// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Cognito Identity Provider
///
/// Client for invoking operations on Amazon Cognito Identity Provider. Each operation on Amazon Cognito Identity Provider is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cognitoidentityprovider::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cognitoidentityprovider::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cognitoidentityprovider::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AddCustomAttributes`](crate::client::fluent_builders::AddCustomAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AddCustomAttributes::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AddCustomAttributes::set_user_pool_id): <p>The user pool ID for the user pool where you want to add custom attributes.</p>
    ///   - [`custom_attributes(Vec<SchemaAttributeType>)`](crate::client::fluent_builders::AddCustomAttributes::custom_attributes) / [`set_custom_attributes(Option<Vec<SchemaAttributeType>>)`](crate::client::fluent_builders::AddCustomAttributes::set_custom_attributes): <p>An array of custom attributes, such as Mutable and Name.</p>
    /// - On success, responds with [`AddCustomAttributesOutput`](crate::output::AddCustomAttributesOutput)

    /// - On failure, responds with [`SdkError<AddCustomAttributesError>`](crate::error::AddCustomAttributesError)
    pub fn add_custom_attributes(&self) -> fluent_builders::AddCustomAttributes<C, M, R> {
        fluent_builders::AddCustomAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminAddUserToGroup`](crate::client::fluent_builders::AdminAddUserToGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminAddUserToGroup::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminAddUserToGroup::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminAddUserToGroup::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminAddUserToGroup::set_username): <p>The username for the user.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::AdminAddUserToGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::AdminAddUserToGroup::set_group_name): <p>The group name.</p>
    /// - On success, responds with [`AdminAddUserToGroupOutput`](crate::output::AdminAddUserToGroupOutput)

    /// - On failure, responds with [`SdkError<AdminAddUserToGroupError>`](crate::error::AdminAddUserToGroupError)
    pub fn admin_add_user_to_group(&self) -> fluent_builders::AdminAddUserToGroup<C, M, R> {
        fluent_builders::AdminAddUserToGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminConfirmSignUp`](crate::client::fluent_builders::AdminConfirmSignUp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminConfirmSignUp::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminConfirmSignUp::set_user_pool_id): <p>The user pool ID for which you want to confirm user registration.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminConfirmSignUp::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminConfirmSignUp::set_username): <p>The user name for which you want to confirm user registration.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::AdminConfirmSignUp::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminConfirmSignUp::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the <code>clientMetadata</code> attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`AdminConfirmSignUpOutput`](crate::output::AdminConfirmSignUpOutput)

    /// - On failure, responds with [`SdkError<AdminConfirmSignUpError>`](crate::error::AdminConfirmSignUpError)
    pub fn admin_confirm_sign_up(&self) -> fluent_builders::AdminConfirmSignUp<C, M, R> {
        fluent_builders::AdminConfirmSignUp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminCreateUser`](crate::client::fluent_builders::AdminCreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminCreateUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminCreateUser::set_user_pool_id): <p>The user pool ID for the user pool where the user will be created.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminCreateUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminCreateUser::set_username): <p>The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.</p>
    ///   - [`user_attributes(Vec<AttributeType>)`](crate::client::fluent_builders::AdminCreateUser::user_attributes) / [`set_user_attributes(Option<Vec<AttributeType>>)`](crate::client::fluent_builders::AdminCreateUser::set_user_attributes): <p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (when creating a user pool or in the <b>Attributes</b> tab of the console) must be supplied either by you (in your call to <code>AdminCreateUser</code>) or by the user (when he or she signs up in response to your welcome message).</p>  <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>  <p>To send a message inviting the user to sign up, you must specify the user's email address or phone number. This can be done in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p>  <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. (You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.)</p>  <ul>   <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>   <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>  </ul>
    ///   - [`validation_data(Vec<AttributeType>)`](crate::client::fluent_builders::AdminCreateUser::validation_data) / [`set_validation_data(Option<Vec<AttributeType>>)`](crate::client::fluent_builders::AdminCreateUser::set_validation_data): <p>The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.</p>  <p>To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.</p>  <p>The user's validation data is not persisted.</p>
    ///   - [`temporary_password(impl Into<String>)`](crate::client::fluent_builders::AdminCreateUser::temporary_password) / [`set_temporary_password(Option<String>)`](crate::client::fluent_builders::AdminCreateUser::set_temporary_password): <p>The user's temporary password. This password must conform to the password policy that you specified when you created the user pool.</p>  <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page along with a new password to be used in all future sign-ins.</p>  <p>This parameter is not required. If you do not specify a value, Amazon Cognito generates one for you.</p>  <p>The temporary password can only be used until the user account expiration limit that you specified when you created the user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter.</p>
    ///   - [`force_alias_creation(bool)`](crate::client::fluent_builders::AdminCreateUser::force_alias_creation) / [`set_force_alias_creation(bool)`](crate::client::fluent_builders::AdminCreateUser::set_force_alias_creation): <p>This parameter is only used if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p>  <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p>  <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>
    ///   - [`message_action(MessageActionType)`](crate::client::fluent_builders::AdminCreateUser::message_action) / [`set_message_action(Option<MessageActionType>)`](crate::client::fluent_builders::AdminCreateUser::set_message_action): <p>Set to <code>"RESEND"</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to <code>"SUPPRESS"</code> to suppress sending the message. Only one value can be specified.</p>
    ///   - [`desired_delivery_mediums(Vec<DeliveryMediumType>)`](crate::client::fluent_builders::AdminCreateUser::desired_delivery_mediums) / [`set_desired_delivery_mediums(Option<Vec<DeliveryMediumType>>)`](crate::client::fluent_builders::AdminCreateUser::set_desired_delivery_mediums): <p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. More than one value can be specified.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::AdminCreateUser::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminCreateUser::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the <i>pre sign-up</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`AdminCreateUserOutput`](crate::output::AdminCreateUserOutput) with field(s):
    ///   - [`user(Option<UserType>)`](crate::output::AdminCreateUserOutput::user): <p>The newly created user.</p>
    /// - On failure, responds with [`SdkError<AdminCreateUserError>`](crate::error::AdminCreateUserError)
    pub fn admin_create_user(&self) -> fluent_builders::AdminCreateUser<C, M, R> {
        fluent_builders::AdminCreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminDeleteUser`](crate::client::fluent_builders::AdminDeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminDeleteUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminDeleteUser::set_user_pool_id): <p>The user pool ID for the user pool where you want to delete the user.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminDeleteUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminDeleteUser::set_username): <p>The user name of the user you wish to delete.</p>
    /// - On success, responds with [`AdminDeleteUserOutput`](crate::output::AdminDeleteUserOutput)

    /// - On failure, responds with [`SdkError<AdminDeleteUserError>`](crate::error::AdminDeleteUserError)
    pub fn admin_delete_user(&self) -> fluent_builders::AdminDeleteUser<C, M, R> {
        fluent_builders::AdminDeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminDeleteUserAttributes`](crate::client::fluent_builders::AdminDeleteUserAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminDeleteUserAttributes::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminDeleteUserAttributes::set_user_pool_id): <p>The user pool ID for the user pool where you want to delete user attributes.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminDeleteUserAttributes::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminDeleteUserAttributes::set_username): <p>The user name of the user from which you would like to delete attributes.</p>
    ///   - [`user_attribute_names(Vec<String>)`](crate::client::fluent_builders::AdminDeleteUserAttributes::user_attribute_names) / [`set_user_attribute_names(Option<Vec<String>>)`](crate::client::fluent_builders::AdminDeleteUserAttributes::set_user_attribute_names): <p>An array of strings representing the user attribute names you wish to delete.</p>  <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    /// - On success, responds with [`AdminDeleteUserAttributesOutput`](crate::output::AdminDeleteUserAttributesOutput)

    /// - On failure, responds with [`SdkError<AdminDeleteUserAttributesError>`](crate::error::AdminDeleteUserAttributesError)
    pub fn admin_delete_user_attributes(
        &self,
    ) -> fluent_builders::AdminDeleteUserAttributes<C, M, R> {
        fluent_builders::AdminDeleteUserAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminDisableProviderForUser`](crate::client::fluent_builders::AdminDisableProviderForUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminDisableProviderForUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminDisableProviderForUser::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`user(ProviderUserIdentifierType)`](crate::client::fluent_builders::AdminDisableProviderForUser::user) / [`set_user(Option<ProviderUserIdentifierType>)`](crate::client::fluent_builders::AdminDisableProviderForUser::set_user): <p>The user to be disabled.</p>
    /// - On success, responds with [`AdminDisableProviderForUserOutput`](crate::output::AdminDisableProviderForUserOutput)

    /// - On failure, responds with [`SdkError<AdminDisableProviderForUserError>`](crate::error::AdminDisableProviderForUserError)
    pub fn admin_disable_provider_for_user(
        &self,
    ) -> fluent_builders::AdminDisableProviderForUser<C, M, R> {
        fluent_builders::AdminDisableProviderForUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminDisableUser`](crate::client::fluent_builders::AdminDisableUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminDisableUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminDisableUser::set_user_pool_id): <p>The user pool ID for the user pool where you want to disable the user.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminDisableUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminDisableUser::set_username): <p>The user name of the user you wish to disable.</p>
    /// - On success, responds with [`AdminDisableUserOutput`](crate::output::AdminDisableUserOutput)

    /// - On failure, responds with [`SdkError<AdminDisableUserError>`](crate::error::AdminDisableUserError)
    pub fn admin_disable_user(&self) -> fluent_builders::AdminDisableUser<C, M, R> {
        fluent_builders::AdminDisableUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminEnableUser`](crate::client::fluent_builders::AdminEnableUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminEnableUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminEnableUser::set_user_pool_id): <p>The user pool ID for the user pool where you want to enable the user.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminEnableUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminEnableUser::set_username): <p>The user name of the user you wish to enable.</p>
    /// - On success, responds with [`AdminEnableUserOutput`](crate::output::AdminEnableUserOutput)

    /// - On failure, responds with [`SdkError<AdminEnableUserError>`](crate::error::AdminEnableUserError)
    pub fn admin_enable_user(&self) -> fluent_builders::AdminEnableUser<C, M, R> {
        fluent_builders::AdminEnableUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminForgetDevice`](crate::client::fluent_builders::AdminForgetDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminForgetDevice::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminForgetDevice::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminForgetDevice::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminForgetDevice::set_username): <p>The user name.</p>
    ///   - [`device_key(impl Into<String>)`](crate::client::fluent_builders::AdminForgetDevice::device_key) / [`set_device_key(Option<String>)`](crate::client::fluent_builders::AdminForgetDevice::set_device_key): <p>The device key.</p>
    /// - On success, responds with [`AdminForgetDeviceOutput`](crate::output::AdminForgetDeviceOutput)

    /// - On failure, responds with [`SdkError<AdminForgetDeviceError>`](crate::error::AdminForgetDeviceError)
    pub fn admin_forget_device(&self) -> fluent_builders::AdminForgetDevice<C, M, R> {
        fluent_builders::AdminForgetDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminGetDevice`](crate::client::fluent_builders::AdminGetDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`device_key(impl Into<String>)`](crate::client::fluent_builders::AdminGetDevice::device_key) / [`set_device_key(Option<String>)`](crate::client::fluent_builders::AdminGetDevice::set_device_key): <p>The device key.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminGetDevice::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminGetDevice::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminGetDevice::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminGetDevice::set_username): <p>The user name.</p>
    /// - On success, responds with [`AdminGetDeviceOutput`](crate::output::AdminGetDeviceOutput) with field(s):
    ///   - [`device(Option<DeviceType>)`](crate::output::AdminGetDeviceOutput::device): <p>The device.</p>
    /// - On failure, responds with [`SdkError<AdminGetDeviceError>`](crate::error::AdminGetDeviceError)
    pub fn admin_get_device(&self) -> fluent_builders::AdminGetDevice<C, M, R> {
        fluent_builders::AdminGetDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminGetUser`](crate::client::fluent_builders::AdminGetUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminGetUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminGetUser::set_user_pool_id): <p>The user pool ID for the user pool where you want to get information about the user.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminGetUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminGetUser::set_username): <p>The user name of the user you wish to retrieve.</p>
    /// - On success, responds with [`AdminGetUserOutput`](crate::output::AdminGetUserOutput) with field(s):
    ///   - [`username(Option<String>)`](crate::output::AdminGetUserOutput::username): <p>The user name of the user about whom you are receiving information.</p>
    ///   - [`user_attributes(Option<Vec<AttributeType>>)`](crate::output::AdminGetUserOutput::user_attributes): <p>An array of name-value pairs representing user attributes.</p>
    ///   - [`user_create_date(Option<DateTime>)`](crate::output::AdminGetUserOutput::user_create_date): <p>The date the user was created.</p>
    ///   - [`user_last_modified_date(Option<DateTime>)`](crate::output::AdminGetUserOutput::user_last_modified_date): <p>The date the user was last modified.</p>
    ///   - [`enabled(bool)`](crate::output::AdminGetUserOutput::enabled): <p>Indicates that the status is enabled.</p>
    ///   - [`user_status(Option<UserStatusType>)`](crate::output::AdminGetUserOutput::user_status): <p>The user status. Can be one of the following:</p>  <ul>   <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>   <li> <p>CONFIRMED - User has been confirmed.</p> </li>   <li> <p>ARCHIVED - User is no longer active.</p> </li>   <li> <p>COMPROMISED - User is disabled due to a potential security threat.</p> </li>   <li> <p>UNKNOWN - User status is not known.</p> </li>   <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password before he or she can sign in.</p> </li>   <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change his or her password to a new value before doing anything else. </p> </li>  </ul>
    ///   - [`mfa_options(Option<Vec<MfaOptionType>>)`](crate::output::AdminGetUserOutput::mfa_options): <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about TOTP software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
    ///   - [`preferred_mfa_setting(Option<String>)`](crate::output::AdminGetUserOutput::preferred_mfa_setting): <p>The user's preferred MFA setting.</p>
    ///   - [`user_mfa_setting_list(Option<Vec<String>>)`](crate::output::AdminGetUserOutput::user_mfa_setting_list): <p>The MFA options that are enabled for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
    /// - On failure, responds with [`SdkError<AdminGetUserError>`](crate::error::AdminGetUserError)
    pub fn admin_get_user(&self) -> fluent_builders::AdminGetUser<C, M, R> {
        fluent_builders::AdminGetUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminInitiateAuth`](crate::client::fluent_builders::AdminInitiateAuth) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminInitiateAuth::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminInitiateAuth::set_user_pool_id): <p>The ID of the Amazon Cognito user pool.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::AdminInitiateAuth::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::AdminInitiateAuth::set_client_id): <p>The app client ID.</p>
    ///   - [`auth_flow(AuthFlowType)`](crate::client::fluent_builders::AdminInitiateAuth::auth_flow) / [`set_auth_flow(Option<AuthFlowType>)`](crate::client::fluent_builders::AdminInitiateAuth::set_auth_flow): <p>The authentication flow for this call to execute. The API action will depend on this value. For example:</p>  <ul>   <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>   <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li>   <li> <p> <code>USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>  </ul>  <p>Valid values include:</p>  <ul>   <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>   <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>   <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>   <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li>   <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if the USERNAME is not found in the user pool. </p> </li>   <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>  </ul>
    ///   - [`auth_parameters(HashMap<String, String>)`](crate::client::fluent_builders::AdminInitiateAuth::auth_parameters) / [`set_auth_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminInitiateAuth::set_auth_parameters): <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p>  <ul>   <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>   <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>   <li> <p>For <code>ADMIN_NO_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>PASSWORD</code> (required), <code>DEVICE_KEY</code>.</p> </li>   <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>  </ul>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::AdminInitiateAuth::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminInitiateAuth::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>  <ul>   <li> <p>Pre signup</p> </li>   <li> <p>Pre authentication</p> </li>   <li> <p>User migration</p> </li>  </ul>  <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminInitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>  <p>When you use the AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it does not provide the ClientMetadata value as input:</p>  <ul>   <li> <p>Post authentication</p> </li>   <li> <p>Custom message</p> </li>   <li> <p>Pre token generation</p> </li>   <li> <p>Create auth challenge</p> </li>   <li> <p>Define auth challenge</p> </li>   <li> <p>Verify auth challenge</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::AdminInitiateAuth::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::AdminInitiateAuth::set_analytics_metadata): <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminInitiateAuth</code> calls.</p>
    ///   - [`context_data(ContextDataType)`](crate::client::fluent_builders::AdminInitiateAuth::context_data) / [`set_context_data(Option<ContextDataType>)`](crate::client::fluent_builders::AdminInitiateAuth::set_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    /// - On success, responds with [`AdminInitiateAuthOutput`](crate::output::AdminInitiateAuthOutput) with field(s):
    ///   - [`challenge_name(Option<ChallengeNameType>)`](crate::output::AdminInitiateAuthOutput::challenge_name): <p>The name of the challenge which you are responding to with this call. This is returned to you in the <code>AdminInitiateAuth</code> response if you need to pass another challenge.</p>  <ul>   <li> <p> <code>MFA_SETUP</code>: If MFA is required, users who do not have at least one of the MFA methods set up are presented with an <code>MFA_SETUP</code> challenge. The user must set up at least one MFA type to continue to authenticate.</p> </li>   <li> <p> <code>SELECT_MFA_TYPE</code>: Selects the MFA type. Valid MFA options are <code>SMS_MFA</code> for text SMS MFA, and <code>SOFTWARE_TOKEN_MFA</code> for TOTP software token MFA.</p> </li>   <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>   <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>   <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>   <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was enabled on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>   <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>   <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you need to authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li>   <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>   <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign-in. The MFA types enabled for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To setup software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To setup SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li>  </ul>
    ///   - [`session(Option<String>)`](crate::output::AdminInitiateAuthOutput::session): <p>The session which should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>
    ///   - [`challenge_parameters(Option<HashMap<String, String>>)`](crate::output::AdminInitiateAuthOutput::challenge_parameters): <p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you need to pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p>  <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>  <p>The value of the <code>USER_ID_FOR_SRP</code> attribute will be the user's actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This is because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute cannot be an alias.</p>
    ///   - [`authentication_result(Option<AuthenticationResultType>)`](crate::output::AdminInitiateAuthOutput::authentication_result): <p>The result of the authentication response. This is only returned if the caller does not need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
    /// - On failure, responds with [`SdkError<AdminInitiateAuthError>`](crate::error::AdminInitiateAuthError)
    pub fn admin_initiate_auth(&self) -> fluent_builders::AdminInitiateAuth<C, M, R> {
        fluent_builders::AdminInitiateAuth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminLinkProviderForUser`](crate::client::fluent_builders::AdminLinkProviderForUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminLinkProviderForUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminLinkProviderForUser::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`destination_user(ProviderUserIdentifierType)`](crate::client::fluent_builders::AdminLinkProviderForUser::destination_user) / [`set_destination_user(Option<ProviderUserIdentifierType>)`](crate::client::fluent_builders::AdminLinkProviderForUser::set_destination_user): <p>The existing user in the user pool to be linked to the external identity provider user account. Can be a native (Username + Password) Cognito User Pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, an exception is thrown. This is the user that is returned when the new user (with the linked identity provider attribute) signs in.</p>  <p>For a native username + password user, the <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the provider-specific <code>user_id</code>.</p>  <p>The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.</p>  <p>The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.</p>
    ///   - [`source_user(ProviderUserIdentifierType)`](crate::client::fluent_builders::AdminLinkProviderForUser::source_user) / [`set_source_user(Option<ProviderUserIdentifierType>)`](crate::client::fluent_builders::AdminLinkProviderForUser::set_source_user): <p>An external identity provider account for a user who does not currently exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p>  <p>If the <code>SourceUser</code> is a federated social identity provider user (Facebook, Google, or Login with Amazon), you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social identity providers, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social identity provider token.</p>  <p></p>  <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. If you wish to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the <code>ProviderAttributeName</code>. If you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Cognito will automatically parse the default unique identifier found in the subject from the SAML token.</p>
    /// - On success, responds with [`AdminLinkProviderForUserOutput`](crate::output::AdminLinkProviderForUserOutput)

    /// - On failure, responds with [`SdkError<AdminLinkProviderForUserError>`](crate::error::AdminLinkProviderForUserError)
    pub fn admin_link_provider_for_user(
        &self,
    ) -> fluent_builders::AdminLinkProviderForUser<C, M, R> {
        fluent_builders::AdminLinkProviderForUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminListDevices`](crate::client::fluent_builders::AdminListDevices) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminListDevices::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminListDevices::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminListDevices::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminListDevices::set_username): <p>The user name.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::AdminListDevices::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::AdminListDevices::set_limit): <p>The limit of the devices request.</p>
    ///   - [`pagination_token(impl Into<String>)`](crate::client::fluent_builders::AdminListDevices::pagination_token) / [`set_pagination_token(Option<String>)`](crate::client::fluent_builders::AdminListDevices::set_pagination_token): <p>The pagination token.</p>
    /// - On success, responds with [`AdminListDevicesOutput`](crate::output::AdminListDevicesOutput) with field(s):
    ///   - [`devices(Option<Vec<DeviceType>>)`](crate::output::AdminListDevicesOutput::devices): <p>The devices in the list of devices response.</p>
    ///   - [`pagination_token(Option<String>)`](crate::output::AdminListDevicesOutput::pagination_token): <p>The pagination token.</p>
    /// - On failure, responds with [`SdkError<AdminListDevicesError>`](crate::error::AdminListDevicesError)
    pub fn admin_list_devices(&self) -> fluent_builders::AdminListDevices<C, M, R> {
        fluent_builders::AdminListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminListGroupsForUser`](crate::client::fluent_builders::AdminListGroupsForUser) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::AdminListGroupsForUser::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminListGroupsForUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminListGroupsForUser::set_username): <p>The username for the user.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminListGroupsForUser::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminListGroupsForUser::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::AdminListGroupsForUser::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::AdminListGroupsForUser::set_limit): <p>The limit of the request to list groups.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::AdminListGroupsForUser::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::AdminListGroupsForUser::set_next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On success, responds with [`AdminListGroupsForUserOutput`](crate::output::AdminListGroupsForUserOutput) with field(s):
    ///   - [`groups(Option<Vec<GroupType>>)`](crate::output::AdminListGroupsForUserOutput::groups): <p>The groups that the user belongs to.</p>
    ///   - [`next_token(Option<String>)`](crate::output::AdminListGroupsForUserOutput::next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<AdminListGroupsForUserError>`](crate::error::AdminListGroupsForUserError)
    pub fn admin_list_groups_for_user(&self) -> fluent_builders::AdminListGroupsForUser<C, M, R> {
        fluent_builders::AdminListGroupsForUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminListUserAuthEvents`](crate::client::fluent_builders::AdminListUserAuthEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::AdminListUserAuthEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminListUserAuthEvents::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminListUserAuthEvents::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminListUserAuthEvents::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminListUserAuthEvents::set_username): <p>The user pool username or an alias.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::AdminListUserAuthEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::AdminListUserAuthEvents::set_max_results): <p>The maximum number of authentication events to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::AdminListUserAuthEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::AdminListUserAuthEvents::set_next_token): <p>A pagination token.</p>
    /// - On success, responds with [`AdminListUserAuthEventsOutput`](crate::output::AdminListUserAuthEventsOutput) with field(s):
    ///   - [`auth_events(Option<Vec<AuthEventType>>)`](crate::output::AdminListUserAuthEventsOutput::auth_events): <p>The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::AdminListUserAuthEventsOutput::next_token): <p>A pagination token.</p>
    /// - On failure, responds with [`SdkError<AdminListUserAuthEventsError>`](crate::error::AdminListUserAuthEventsError)
    pub fn admin_list_user_auth_events(&self) -> fluent_builders::AdminListUserAuthEvents<C, M, R> {
        fluent_builders::AdminListUserAuthEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminRemoveUserFromGroup`](crate::client::fluent_builders::AdminRemoveUserFromGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminRemoveUserFromGroup::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminRemoveUserFromGroup::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminRemoveUserFromGroup::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminRemoveUserFromGroup::set_username): <p>The username for the user.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::AdminRemoveUserFromGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::AdminRemoveUserFromGroup::set_group_name): <p>The group name.</p>
    /// - On success, responds with [`AdminRemoveUserFromGroupOutput`](crate::output::AdminRemoveUserFromGroupOutput)

    /// - On failure, responds with [`SdkError<AdminRemoveUserFromGroupError>`](crate::error::AdminRemoveUserFromGroupError)
    pub fn admin_remove_user_from_group(
        &self,
    ) -> fluent_builders::AdminRemoveUserFromGroup<C, M, R> {
        fluent_builders::AdminRemoveUserFromGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminResetUserPassword`](crate::client::fluent_builders::AdminResetUserPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminResetUserPassword::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminResetUserPassword::set_user_pool_id): <p>The user pool ID for the user pool where you want to reset the user's password.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminResetUserPassword::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminResetUserPassword::set_username): <p>The user name of the user whose password you wish to reset.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::AdminResetUserPassword::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminResetUserPassword::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`AdminResetUserPasswordOutput`](crate::output::AdminResetUserPasswordOutput)

    /// - On failure, responds with [`SdkError<AdminResetUserPasswordError>`](crate::error::AdminResetUserPasswordError)
    pub fn admin_reset_user_password(&self) -> fluent_builders::AdminResetUserPassword<C, M, R> {
        fluent_builders::AdminResetUserPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminRespondToAuthChallenge`](crate::client::fluent_builders::AdminRespondToAuthChallenge) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_user_pool_id): <p>The ID of the Amazon Cognito user pool.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_client_id): <p>The app client ID.</p>
    ///   - [`challenge_name(ChallengeNameType)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::challenge_name) / [`set_challenge_name(Option<ChallengeNameType>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_challenge_name): <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
    ///   - [`challenge_responses(HashMap<String, String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::challenge_responses) / [`set_challenge_responses(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_challenge_responses): <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p>  <ul>   <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>   <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>   <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: <code>PASSWORD</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>   <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>   <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you need to use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>  </ul>  <p>The value of the <code>USERNAME</code> attribute must be the user's actual username, not an alias (such as email address or phone number). To make this easier, the <code>AdminInitiateAuth</code> response includes the actual username value in the <code>USERNAMEUSER_ID_FOR_SRP</code> attribute, even if you specified an alias in your call to <code>AdminInitiateAuth</code>.</p>
    ///   - [`session(impl Into<String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::session) / [`set_session(Option<String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_session): <p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_analytics_metadata): <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminRespondToAuthChallenge</code> calls.</p>
    ///   - [`context_data(ContextDataType)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::context_data) / [`set_context_data(Option<ContextDataType>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminRespondToAuthChallenge::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, <i>post authentication</i>, <i>user migration</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge response</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`AdminRespondToAuthChallengeOutput`](crate::output::AdminRespondToAuthChallengeOutput) with field(s):
    ///   - [`challenge_name(Option<ChallengeNameType>)`](crate::output::AdminRespondToAuthChallengeOutput::challenge_name): <p>The name of the challenge. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
    ///   - [`session(Option<String>)`](crate::output::AdminRespondToAuthChallengeOutput::session): <p>The session which should be passed both ways in challenge-response calls to the service. If the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    ///   - [`challenge_parameters(Option<HashMap<String, String>>)`](crate::output::AdminRespondToAuthChallengeOutput::challenge_parameters): <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
    ///   - [`authentication_result(Option<AuthenticationResultType>)`](crate::output::AdminRespondToAuthChallengeOutput::authentication_result): <p>The result returned by the server in response to the authentication request.</p>
    /// - On failure, responds with [`SdkError<AdminRespondToAuthChallengeError>`](crate::error::AdminRespondToAuthChallengeError)
    pub fn admin_respond_to_auth_challenge(
        &self,
    ) -> fluent_builders::AdminRespondToAuthChallenge<C, M, R> {
        fluent_builders::AdminRespondToAuthChallenge::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminSetUserMFAPreference`](crate::client::fluent_builders::AdminSetUserMFAPreference) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sms_mfa_settings(SmsMfaSettingsType)`](crate::client::fluent_builders::AdminSetUserMFAPreference::sms_mfa_settings) / [`set_sms_mfa_settings(Option<SmsMfaSettingsType>)`](crate::client::fluent_builders::AdminSetUserMFAPreference::set_sms_mfa_settings): <p>The SMS text message MFA settings.</p>
    ///   - [`software_token_mfa_settings(SoftwareTokenMfaSettingsType)`](crate::client::fluent_builders::AdminSetUserMFAPreference::software_token_mfa_settings) / [`set_software_token_mfa_settings(Option<SoftwareTokenMfaSettingsType>)`](crate::client::fluent_builders::AdminSetUserMFAPreference::set_software_token_mfa_settings): <p>The time-based one-time password software token MFA settings.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminSetUserMFAPreference::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminSetUserMFAPreference::set_username): <p>The user pool username or alias.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminSetUserMFAPreference::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminSetUserMFAPreference::set_user_pool_id): <p>The user pool ID.</p>
    /// - On success, responds with [`AdminSetUserMfaPreferenceOutput`](crate::output::AdminSetUserMfaPreferenceOutput)

    /// - On failure, responds with [`SdkError<AdminSetUserMFAPreferenceError>`](crate::error::AdminSetUserMFAPreferenceError)
    pub fn admin_set_user_mfa_preference(
        &self,
    ) -> fluent_builders::AdminSetUserMFAPreference<C, M, R> {
        fluent_builders::AdminSetUserMFAPreference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminSetUserPassword`](crate::client::fluent_builders::AdminSetUserPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminSetUserPassword::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminSetUserPassword::set_user_pool_id): <p>The user pool ID for the user pool where you want to set the user's password.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminSetUserPassword::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminSetUserPassword::set_username): <p>The user name of the user whose password you wish to set.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::AdminSetUserPassword::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::AdminSetUserPassword::set_password): <p>The password for the user.</p>
    ///   - [`permanent(bool)`](crate::client::fluent_builders::AdminSetUserPassword::permanent) / [`set_permanent(bool)`](crate::client::fluent_builders::AdminSetUserPassword::set_permanent): <p> <code>True</code> if the password is permanent, <code>False</code> if it is temporary.</p>
    /// - On success, responds with [`AdminSetUserPasswordOutput`](crate::output::AdminSetUserPasswordOutput)

    /// - On failure, responds with [`SdkError<AdminSetUserPasswordError>`](crate::error::AdminSetUserPasswordError)
    pub fn admin_set_user_password(&self) -> fluent_builders::AdminSetUserPassword<C, M, R> {
        fluent_builders::AdminSetUserPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminSetUserSettings`](crate::client::fluent_builders::AdminSetUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminSetUserSettings::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminSetUserSettings::set_user_pool_id): <p>The ID of the user pool that contains the user that you are setting options for.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminSetUserSettings::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminSetUserSettings::set_username): <p>The user name of the user that you are setting options for.</p>
    ///   - [`mfa_options(Vec<MfaOptionType>)`](crate::client::fluent_builders::AdminSetUserSettings::mfa_options) / [`set_mfa_options(Option<Vec<MfaOptionType>>)`](crate::client::fluent_builders::AdminSetUserSettings::set_mfa_options): <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
    /// - On success, responds with [`AdminSetUserSettingsOutput`](crate::output::AdminSetUserSettingsOutput)

    /// - On failure, responds with [`SdkError<AdminSetUserSettingsError>`](crate::error::AdminSetUserSettingsError)
    pub fn admin_set_user_settings(&self) -> fluent_builders::AdminSetUserSettings<C, M, R> {
        fluent_builders::AdminSetUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminUpdateAuthEventFeedback`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::set_username): <p>The user pool username.</p>
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::set_event_id): <p>The authentication event ID.</p>
    ///   - [`feedback_value(FeedbackValueType)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::feedback_value) / [`set_feedback_value(Option<FeedbackValueType>)`](crate::client::fluent_builders::AdminUpdateAuthEventFeedback::set_feedback_value): <p>The authentication event feedback value.</p>
    /// - On success, responds with [`AdminUpdateAuthEventFeedbackOutput`](crate::output::AdminUpdateAuthEventFeedbackOutput)

    /// - On failure, responds with [`SdkError<AdminUpdateAuthEventFeedbackError>`](crate::error::AdminUpdateAuthEventFeedbackError)
    pub fn admin_update_auth_event_feedback(
        &self,
    ) -> fluent_builders::AdminUpdateAuthEventFeedback<C, M, R> {
        fluent_builders::AdminUpdateAuthEventFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminUpdateDeviceStatus`](crate::client::fluent_builders::AdminUpdateDeviceStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::set_username): <p>The user name.</p>
    ///   - [`device_key(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::device_key) / [`set_device_key(Option<String>)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::set_device_key): <p>The device key.</p>
    ///   - [`device_remembered_status(DeviceRememberedStatusType)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::device_remembered_status) / [`set_device_remembered_status(Option<DeviceRememberedStatusType>)`](crate::client::fluent_builders::AdminUpdateDeviceStatus::set_device_remembered_status): <p>The status indicating whether a device has been remembered or not.</p>
    /// - On success, responds with [`AdminUpdateDeviceStatusOutput`](crate::output::AdminUpdateDeviceStatusOutput)

    /// - On failure, responds with [`SdkError<AdminUpdateDeviceStatusError>`](crate::error::AdminUpdateDeviceStatusError)
    pub fn admin_update_device_status(&self) -> fluent_builders::AdminUpdateDeviceStatus<C, M, R> {
        fluent_builders::AdminUpdateDeviceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminUpdateUserAttributes`](crate::client::fluent_builders::AdminUpdateUserAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::set_user_pool_id): <p>The user pool ID for the user pool where you want to update user attributes.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::set_username): <p>The user name of the user for whom you want to update user attributes.</p>
    ///   - [`user_attributes(Vec<AttributeType>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::user_attributes) / [`set_user_attributes(Option<Vec<AttributeType>>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::set_user_attributes): <p>An array of name-value pairs representing user attributes.</p>  <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AdminUpdateUserAttributes::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`AdminUpdateUserAttributesOutput`](crate::output::AdminUpdateUserAttributesOutput)

    /// - On failure, responds with [`SdkError<AdminUpdateUserAttributesError>`](crate::error::AdminUpdateUserAttributesError)
    pub fn admin_update_user_attributes(
        &self,
    ) -> fluent_builders::AdminUpdateUserAttributes<C, M, R> {
        fluent_builders::AdminUpdateUserAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdminUserGlobalSignOut`](crate::client::fluent_builders::AdminUserGlobalSignOut) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::AdminUserGlobalSignOut::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::AdminUserGlobalSignOut::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::AdminUserGlobalSignOut::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::AdminUserGlobalSignOut::set_username): <p>The user name.</p>
    /// - On success, responds with [`AdminUserGlobalSignOutOutput`](crate::output::AdminUserGlobalSignOutOutput)

    /// - On failure, responds with [`SdkError<AdminUserGlobalSignOutError>`](crate::error::AdminUserGlobalSignOutError)
    pub fn admin_user_global_sign_out(&self) -> fluent_builders::AdminUserGlobalSignOut<C, M, R> {
        fluent_builders::AdminUserGlobalSignOut::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateSoftwareToken`](crate::client::fluent_builders::AssociateSoftwareToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::AssociateSoftwareToken::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::AssociateSoftwareToken::set_access_token): <p>The access token.</p>
    ///   - [`session(impl Into<String>)`](crate::client::fluent_builders::AssociateSoftwareToken::session) / [`set_session(Option<String>)`](crate::client::fluent_builders::AssociateSoftwareToken::set_session): <p>The session which should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
    /// - On success, responds with [`AssociateSoftwareTokenOutput`](crate::output::AssociateSoftwareTokenOutput) with field(s):
    ///   - [`secret_code(Option<String>)`](crate::output::AssociateSoftwareTokenOutput::secret_code): <p>A unique generated shared secret code that is used in the TOTP algorithm to generate a one time code.</p>
    ///   - [`session(Option<String>)`](crate::output::AssociateSoftwareTokenOutput::session): <p>The session which should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
    /// - On failure, responds with [`SdkError<AssociateSoftwareTokenError>`](crate::error::AssociateSoftwareTokenError)
    pub fn associate_software_token(&self) -> fluent_builders::AssociateSoftwareToken<C, M, R> {
        fluent_builders::AssociateSoftwareToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ChangePassword`](crate::client::fluent_builders::ChangePassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`previous_password(impl Into<String>)`](crate::client::fluent_builders::ChangePassword::previous_password) / [`set_previous_password(Option<String>)`](crate::client::fluent_builders::ChangePassword::set_previous_password): <p>The old password.</p>
    ///   - [`proposed_password(impl Into<String>)`](crate::client::fluent_builders::ChangePassword::proposed_password) / [`set_proposed_password(Option<String>)`](crate::client::fluent_builders::ChangePassword::set_proposed_password): <p>The new password.</p>
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::ChangePassword::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::ChangePassword::set_access_token): <p>The access token.</p>
    /// - On success, responds with [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)

    /// - On failure, responds with [`SdkError<ChangePasswordError>`](crate::error::ChangePasswordError)
    pub fn change_password(&self) -> fluent_builders::ChangePassword<C, M, R> {
        fluent_builders::ChangePassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmDevice`](crate::client::fluent_builders::ConfirmDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::ConfirmDevice::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::ConfirmDevice::set_access_token): <p>The access token.</p>
    ///   - [`device_key(impl Into<String>)`](crate::client::fluent_builders::ConfirmDevice::device_key) / [`set_device_key(Option<String>)`](crate::client::fluent_builders::ConfirmDevice::set_device_key): <p>The device key.</p>
    ///   - [`device_secret_verifier_config(DeviceSecretVerifierConfigType)`](crate::client::fluent_builders::ConfirmDevice::device_secret_verifier_config) / [`set_device_secret_verifier_config(Option<DeviceSecretVerifierConfigType>)`](crate::client::fluent_builders::ConfirmDevice::set_device_secret_verifier_config): <p>The configuration of the device secret verifier.</p>
    ///   - [`device_name(impl Into<String>)`](crate::client::fluent_builders::ConfirmDevice::device_name) / [`set_device_name(Option<String>)`](crate::client::fluent_builders::ConfirmDevice::set_device_name): <p>The device name.</p>
    /// - On success, responds with [`ConfirmDeviceOutput`](crate::output::ConfirmDeviceOutput) with field(s):
    ///   - [`user_confirmation_necessary(bool)`](crate::output::ConfirmDeviceOutput::user_confirmation_necessary): <p>Indicates whether the user confirmation is necessary to confirm the device response.</p>
    /// - On failure, responds with [`SdkError<ConfirmDeviceError>`](crate::error::ConfirmDeviceError)
    pub fn confirm_device(&self) -> fluent_builders::ConfirmDevice<C, M, R> {
        fluent_builders::ConfirmDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmForgotPassword`](crate::client::fluent_builders::ConfirmForgotPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_client_id): <p>The app client ID of the app associated with the user pool.</p>
    ///   - [`secret_hash(impl Into<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::secret_hash) / [`set_secret_hash(Option<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_secret_hash): <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_username): <p>The user name of the user for whom you want to enter a code to retrieve a forgotten password.</p>
    ///   - [`confirmation_code(impl Into<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::confirmation_code) / [`set_confirmation_code(Option<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_confirmation_code): <p>The confirmation code sent by a user's request to retrieve a forgotten password. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html">ForgotPassword</a>.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_password): <p>The password sent by a user's request to retrieve a forgotten password.</p>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::ConfirmForgotPassword::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_analytics_metadata): <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmForgotPassword</code> calls.</p>
    ///   - [`user_context_data(UserContextDataType)`](crate::client::fluent_builders::ConfirmForgotPassword::user_context_data) / [`set_user_context_data(Option<UserContextDataType>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_user_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::ConfirmForgotPassword::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ConfirmForgotPassword::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`ConfirmForgotPasswordOutput`](crate::output::ConfirmForgotPasswordOutput)

    /// - On failure, responds with [`SdkError<ConfirmForgotPasswordError>`](crate::error::ConfirmForgotPasswordError)
    pub fn confirm_forgot_password(&self) -> fluent_builders::ConfirmForgotPassword<C, M, R> {
        fluent_builders::ConfirmForgotPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmSignUp`](crate::client::fluent_builders::ConfirmSignUp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmSignUp::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::ConfirmSignUp::set_client_id): <p>The ID of the app client associated with the user pool.</p>
    ///   - [`secret_hash(impl Into<String>)`](crate::client::fluent_builders::ConfirmSignUp::secret_hash) / [`set_secret_hash(Option<String>)`](crate::client::fluent_builders::ConfirmSignUp::set_secret_hash): <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::ConfirmSignUp::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::ConfirmSignUp::set_username): <p>The user name of the user whose registration you wish to confirm.</p>
    ///   - [`confirmation_code(impl Into<String>)`](crate::client::fluent_builders::ConfirmSignUp::confirmation_code) / [`set_confirmation_code(Option<String>)`](crate::client::fluent_builders::ConfirmSignUp::set_confirmation_code): <p>The confirmation code sent by a user's request to confirm registration.</p>
    ///   - [`force_alias_creation(bool)`](crate::client::fluent_builders::ConfirmSignUp::force_alias_creation) / [`set_force_alias_creation(bool)`](crate::client::fluent_builders::ConfirmSignUp::set_force_alias_creation): <p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::ConfirmSignUp::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::ConfirmSignUp::set_analytics_metadata): <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmSignUp</code> calls.</p>
    ///   - [`user_context_data(UserContextDataType)`](crate::client::fluent_builders::ConfirmSignUp::user_context_data) / [`set_user_context_data(Option<UserContextDataType>)`](crate::client::fluent_builders::ConfirmSignUp::set_user_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::ConfirmSignUp::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ConfirmSignUp::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`ConfirmSignUpOutput`](crate::output::ConfirmSignUpOutput)

    /// - On failure, responds with [`SdkError<ConfirmSignUpError>`](crate::error::ConfirmSignUpError)
    pub fn confirm_sign_up(&self) -> fluent_builders::ConfirmSignUp<C, M, R> {
        fluent_builders::ConfirmSignUp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGroup`](crate::client::fluent_builders::CreateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_group_name): <p>The name of the group. Must be unique.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_description): <p>A string containing the description of the group.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_role_arn): <p>The role ARN for the group.</p>
    ///   - [`precedence(i32)`](crate::client::fluent_builders::CreateGroup::precedence) / [`set_precedence(Option<i32>)`](crate::client::fluent_builders::CreateGroup::set_precedence): <p>A nonnegative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN will be used in the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the user's tokens.</p>  <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim is not set in users' tokens.</p>  <p>The default <code>Precedence</code> value is null.</p>
    /// - On success, responds with [`CreateGroupOutput`](crate::output::CreateGroupOutput) with field(s):
    ///   - [`group(Option<GroupType>)`](crate::output::CreateGroupOutput::group): <p>The group object for the group.</p>
    /// - On failure, responds with [`SdkError<CreateGroupError>`](crate::error::CreateGroupError)
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIdentityProvider`](crate::client::fluent_builders::CreateIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateIdentityProvider::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::CreateIdentityProvider::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::CreateIdentityProvider::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::CreateIdentityProvider::set_provider_name): <p>The identity provider name.</p>
    ///   - [`provider_type(IdentityProviderTypeType)`](crate::client::fluent_builders::CreateIdentityProvider::provider_type) / [`set_provider_type(Option<IdentityProviderTypeType>)`](crate::client::fluent_builders::CreateIdentityProvider::set_provider_type): <p>The identity provider type.</p>
    ///   - [`provider_details(HashMap<String, String>)`](crate::client::fluent_builders::CreateIdentityProvider::provider_details) / [`set_provider_details(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIdentityProvider::set_provider_details): <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>  <ul>   <li> <p>For Google and Login with Amazon:</p>    <ul>     <li> <p>client_id</p> </li>     <li> <p>client_secret</p> </li>     <li> <p>authorize_scopes</p> </li>    </ul> </li>   <li> <p>For Facebook:</p>    <ul>     <li> <p>client_id</p> </li>     <li> <p>client_secret</p> </li>     <li> <p>authorize_scopes</p> </li>     <li> <p>api_version</p> </li>    </ul> </li>   <li> <p>For Sign in with Apple:</p>    <ul>     <li> <p>client_id</p> </li>     <li> <p>team_id</p> </li>     <li> <p>key_id</p> </li>     <li> <p>private_key</p> </li>     <li> <p>authorize_scopes</p> </li>    </ul> </li>   <li> <p>For OIDC providers:</p>    <ul>     <li> <p>client_id</p> </li>     <li> <p>client_secret</p> </li>     <li> <p>attributes_request_method</p> </li>     <li> <p>oidc_issuer</p> </li>     <li> <p>authorize_scopes</p> </li>     <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>     <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>     <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>     <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>    </ul> </li>   <li> <p>For SAML providers:</p>    <ul>     <li> <p>MetadataFile OR MetadataURL</p> </li>     <li> <p>IDPSignout <i>optional</i> </p> </li>    </ul> </li>  </ul>
    ///   - [`attribute_mapping(HashMap<String, String>)`](crate::client::fluent_builders::CreateIdentityProvider::attribute_mapping) / [`set_attribute_mapping(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIdentityProvider::set_attribute_mapping): <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
    ///   - [`idp_identifiers(Vec<String>)`](crate::client::fluent_builders::CreateIdentityProvider::idp_identifiers) / [`set_idp_identifiers(Option<Vec<String>>)`](crate::client::fluent_builders::CreateIdentityProvider::set_idp_identifiers): <p>A list of identity provider identifiers.</p>
    /// - On success, responds with [`CreateIdentityProviderOutput`](crate::output::CreateIdentityProviderOutput) with field(s):
    ///   - [`identity_provider(Option<IdentityProviderType>)`](crate::output::CreateIdentityProviderOutput::identity_provider): <p>The newly created identity provider object.</p>
    /// - On failure, responds with [`SdkError<CreateIdentityProviderError>`](crate::error::CreateIdentityProviderError)
    pub fn create_identity_provider(&self) -> fluent_builders::CreateIdentityProvider<C, M, R> {
        fluent_builders::CreateIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourceServer`](crate::client::fluent_builders::CreateResourceServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateResourceServer::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::CreateResourceServer::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::CreateResourceServer::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::CreateResourceServer::set_identifier): <p>A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource server is located. For example, <code>https://my-weather-api.example.com</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateResourceServer::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateResourceServer::set_name): <p>A friendly name for the resource server.</p>
    ///   - [`scopes(Vec<ResourceServerScopeType>)`](crate::client::fluent_builders::CreateResourceServer::scopes) / [`set_scopes(Option<Vec<ResourceServerScopeType>>)`](crate::client::fluent_builders::CreateResourceServer::set_scopes): <p>A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.</p>
    /// - On success, responds with [`CreateResourceServerOutput`](crate::output::CreateResourceServerOutput) with field(s):
    ///   - [`resource_server(Option<ResourceServerType>)`](crate::output::CreateResourceServerOutput::resource_server): <p>The newly created resource server.</p>
    /// - On failure, responds with [`SdkError<CreateResourceServerError>`](crate::error::CreateResourceServerError)
    pub fn create_resource_server(&self) -> fluent_builders::CreateResourceServer<C, M, R> {
        fluent_builders::CreateResourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserImportJob`](crate::client::fluent_builders::CreateUserImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::CreateUserImportJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::CreateUserImportJob::set_job_name): <p>The job name for the user import job.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateUserImportJob::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::CreateUserImportJob::set_user_pool_id): <p>The user pool ID for the user pool that the users are being imported into.</p>
    ///   - [`cloud_watch_logs_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateUserImportJob::cloud_watch_logs_role_arn) / [`set_cloud_watch_logs_role_arn(Option<String>)`](crate::client::fluent_builders::CreateUserImportJob::set_cloud_watch_logs_role_arn): <p>The role ARN for the Amazon CloudWatch Logging role for the user import job.</p>
    /// - On success, responds with [`CreateUserImportJobOutput`](crate::output::CreateUserImportJobOutput) with field(s):
    ///   - [`user_import_job(Option<UserImportJobType>)`](crate::output::CreateUserImportJobOutput::user_import_job): <p>The job object that represents the user import job.</p>
    /// - On failure, responds with [`SdkError<CreateUserImportJobError>`](crate::error::CreateUserImportJobError)
    pub fn create_user_import_job(&self) -> fluent_builders::CreateUserImportJob<C, M, R> {
        fluent_builders::CreateUserImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserPool`](crate::client::fluent_builders::CreateUserPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::CreateUserPool::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::CreateUserPool::set_pool_name): <p>A string used to name the user pool.</p>
    ///   - [`policies(UserPoolPolicyType)`](crate::client::fluent_builders::CreateUserPool::policies) / [`set_policies(Option<UserPoolPolicyType>)`](crate::client::fluent_builders::CreateUserPool::set_policies): <p>The policies associated with the new user pool.</p>
    ///   - [`lambda_config(LambdaConfigType)`](crate::client::fluent_builders::CreateUserPool::lambda_config) / [`set_lambda_config(Option<LambdaConfigType>)`](crate::client::fluent_builders::CreateUserPool::set_lambda_config): <p>The Lambda trigger configuration information for the new user pool.</p> <note>   <p>In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you will need to make an extra call to add permission for these event sources to invoke your Lambda function.</p>   <p></p>   <p>For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>. </p>   <p>For adding permission using the CLI, see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.</p>  </note>
    ///   - [`auto_verified_attributes(Vec<VerifiedAttributeType>)`](crate::client::fluent_builders::CreateUserPool::auto_verified_attributes) / [`set_auto_verified_attributes(Option<Vec<VerifiedAttributeType>>)`](crate::client::fluent_builders::CreateUserPool::set_auto_verified_attributes): <p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>
    ///   - [`alias_attributes(Vec<AliasAttributeType>)`](crate::client::fluent_builders::CreateUserPool::alias_attributes) / [`set_alias_attributes(Option<Vec<AliasAttributeType>>)`](crate::client::fluent_builders::CreateUserPool::set_alias_attributes): <p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>
    ///   - [`username_attributes(Vec<UsernameAttributeType>)`](crate::client::fluent_builders::CreateUserPool::username_attributes) / [`set_username_attributes(Option<Vec<UsernameAttributeType>>)`](crate::client::fluent_builders::CreateUserPool::set_username_attributes): <p>Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.</p>
    ///   - [`sms_verification_message(impl Into<String>)`](crate::client::fluent_builders::CreateUserPool::sms_verification_message) / [`set_sms_verification_message(Option<String>)`](crate::client::fluent_builders::CreateUserPool::set_sms_verification_message): <p>A string representing the SMS verification message.</p>
    ///   - [`email_verification_message(impl Into<String>)`](crate::client::fluent_builders::CreateUserPool::email_verification_message) / [`set_email_verification_message(Option<String>)`](crate::client::fluent_builders::CreateUserPool::set_email_verification_message): <p>A string representing the email verification message. EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    ///   - [`email_verification_subject(impl Into<String>)`](crate::client::fluent_builders::CreateUserPool::email_verification_subject) / [`set_email_verification_subject(Option<String>)`](crate::client::fluent_builders::CreateUserPool::set_email_verification_subject): <p>A string representing the email verification subject. EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    ///   - [`verification_message_template(VerificationMessageTemplateType)`](crate::client::fluent_builders::CreateUserPool::verification_message_template) / [`set_verification_message_template(Option<VerificationMessageTemplateType>)`](crate::client::fluent_builders::CreateUserPool::set_verification_message_template): <p>The template for the verification message that the user sees when the app requests permission to access the user's information.</p>
    ///   - [`sms_authentication_message(impl Into<String>)`](crate::client::fluent_builders::CreateUserPool::sms_authentication_message) / [`set_sms_authentication_message(Option<String>)`](crate::client::fluent_builders::CreateUserPool::set_sms_authentication_message): <p>A string representing the SMS authentication message.</p>
    ///   - [`mfa_configuration(UserPoolMfaType)`](crate::client::fluent_builders::CreateUserPool::mfa_configuration) / [`set_mfa_configuration(Option<UserPoolMfaType>)`](crate::client::fluent_builders::CreateUserPool::set_mfa_configuration): <p>Specifies MFA configuration details.</p>
    ///   - [`device_configuration(DeviceConfigurationType)`](crate::client::fluent_builders::CreateUserPool::device_configuration) / [`set_device_configuration(Option<DeviceConfigurationType>)`](crate::client::fluent_builders::CreateUserPool::set_device_configuration): <p>The device configuration.</p>
    ///   - [`email_configuration(EmailConfigurationType)`](crate::client::fluent_builders::CreateUserPool::email_configuration) / [`set_email_configuration(Option<EmailConfigurationType>)`](crate::client::fluent_builders::CreateUserPool::set_email_configuration): <p>The email configuration.</p>
    ///   - [`sms_configuration(SmsConfigurationType)`](crate::client::fluent_builders::CreateUserPool::sms_configuration) / [`set_sms_configuration(Option<SmsConfigurationType>)`](crate::client::fluent_builders::CreateUserPool::set_sms_configuration): <p>The SMS configuration.</p>
    ///   - [`user_pool_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateUserPool::user_pool_tags) / [`set_user_pool_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateUserPool::set_user_pool_tags): <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
    ///   - [`admin_create_user_config(AdminCreateUserConfigType)`](crate::client::fluent_builders::CreateUserPool::admin_create_user_config) / [`set_admin_create_user_config(Option<AdminCreateUserConfigType>)`](crate::client::fluent_builders::CreateUserPool::set_admin_create_user_config): <p>The configuration for <code>AdminCreateUser</code> requests.</p>
    ///   - [`schema(Vec<SchemaAttributeType>)`](crate::client::fluent_builders::CreateUserPool::schema) / [`set_schema(Option<Vec<SchemaAttributeType>>)`](crate::client::fluent_builders::CreateUserPool::set_schema): <p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>
    ///   - [`user_pool_add_ons(UserPoolAddOnsType)`](crate::client::fluent_builders::CreateUserPool::user_pool_add_ons) / [`set_user_pool_add_ons(Option<UserPoolAddOnsType>)`](crate::client::fluent_builders::CreateUserPool::set_user_pool_add_ons): <p>Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
    ///   - [`username_configuration(UsernameConfigurationType)`](crate::client::fluent_builders::CreateUserPool::username_configuration) / [`set_username_configuration(Option<UsernameConfigurationType>)`](crate::client::fluent_builders::CreateUserPool::set_username_configuration): <p>You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to <code>False</code>, users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
    ///   - [`account_recovery_setting(AccountRecoverySettingType)`](crate::client::fluent_builders::CreateUserPool::account_recovery_setting) / [`set_account_recovery_setting(Option<AccountRecoverySettingType>)`](crate::client::fluent_builders::CreateUserPool::set_account_recovery_setting): <p>Use this setting to define which verified available method a user can use to recover their password when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.</p>
    /// - On success, responds with [`CreateUserPoolOutput`](crate::output::CreateUserPoolOutput) with field(s):
    ///   - [`user_pool(Option<UserPoolType>)`](crate::output::CreateUserPoolOutput::user_pool): <p>A container for the user pool details.</p>
    /// - On failure, responds with [`SdkError<CreateUserPoolError>`](crate::error::CreateUserPoolError)
    pub fn create_user_pool(&self) -> fluent_builders::CreateUserPool<C, M, R> {
        fluent_builders::CreateUserPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserPoolClient`](crate::client::fluent_builders::CreateUserPoolClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateUserPoolClient::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::CreateUserPoolClient::set_user_pool_id): <p>The user pool ID for the user pool where you want to create a user pool client.</p>
    ///   - [`client_name(impl Into<String>)`](crate::client::fluent_builders::CreateUserPoolClient::client_name) / [`set_client_name(Option<String>)`](crate::client::fluent_builders::CreateUserPoolClient::set_client_name): <p>The client name for the user pool client you would like to create.</p>
    ///   - [`generate_secret(bool)`](crate::client::fluent_builders::CreateUserPoolClient::generate_secret) / [`set_generate_secret(bool)`](crate::client::fluent_builders::CreateUserPoolClient::set_generate_secret): <p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>
    ///   - [`refresh_token_validity(i32)`](crate::client::fluent_builders::CreateUserPoolClient::refresh_token_validity) / [`set_refresh_token_validity(i32)`](crate::client::fluent_builders::CreateUserPoolClient::set_refresh_token_validity): <p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>
    ///   - [`access_token_validity(i32)`](crate::client::fluent_builders::CreateUserPoolClient::access_token_validity) / [`set_access_token_validity(Option<i32>)`](crate::client::fluent_builders::CreateUserPoolClient::set_access_token_validity): <p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. This value will be overridden if you have entered a value in TokenValidityUnits.</p>
    ///   - [`id_token_validity(i32)`](crate::client::fluent_builders::CreateUserPoolClient::id_token_validity) / [`set_id_token_validity(Option<i32>)`](crate::client::fluent_builders::CreateUserPoolClient::set_id_token_validity): <p>The time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. This value will be overridden if you have entered a value in TokenValidityUnits.</p>
    ///   - [`token_validity_units(TokenValidityUnitsType)`](crate::client::fluent_builders::CreateUserPoolClient::token_validity_units) / [`set_token_validity_units(Option<TokenValidityUnitsType>)`](crate::client::fluent_builders::CreateUserPoolClient::set_token_validity_units): <p>The units in which the validity times are represented in. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
    ///   - [`read_attributes(Vec<String>)`](crate::client::fluent_builders::CreateUserPoolClient::read_attributes) / [`set_read_attributes(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_read_attributes): <p>The read attributes.</p>
    ///   - [`write_attributes(Vec<String>)`](crate::client::fluent_builders::CreateUserPoolClient::write_attributes) / [`set_write_attributes(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_write_attributes): <p>The user pool attributes that the app client can write to.</p>  <p>If your app client allows users to sign in through an identity provider, this array must include all attributes that are mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client lacks write access to a mapped attribute, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
    ///   - [`explicit_auth_flows(Vec<ExplicitAuthFlowsType>)`](crate::client::fluent_builders::CreateUserPoolClient::explicit_auth_flows) / [`set_explicit_auth_flows(Option<Vec<ExplicitAuthFlowsType>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_explicit_auth_flows): <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.</p>  <p>Valid values include:</p>  <ul>   <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote Password protocol) protocol to verify passwords.</p> </li>   <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>   <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>   <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.</p> </li>   <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>  </ul>
    ///   - [`supported_identity_providers(Vec<String>)`](crate::client::fluent_builders::CreateUserPoolClient::supported_identity_providers) / [`set_supported_identity_providers(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_supported_identity_providers): <p>A list of provider names for the identity providers that are supported on this client. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code> and <code>LoginWithAmazon</code>.</p>
    ///   - [`callback_ur_ls(Vec<String>)`](crate::client::fluent_builders::CreateUserPoolClient::callback_ur_ls) / [`set_callback_ur_ls(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_callback_ur_ls): <p>A list of allowed redirect (callback) URLs for the identity providers.</p>  <p>A redirect URI must:</p>  <ul>   <li> <p>Be an absolute URI.</p> </li>   <li> <p>Be registered with the authorization server.</p> </li>   <li> <p>Not include a fragment component.</p> </li>  </ul>  <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>  <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>  <p>App callback URLs such as myapp://example are also supported.</p>
    ///   - [`logout_ur_ls(Vec<String>)`](crate::client::fluent_builders::CreateUserPoolClient::logout_ur_ls) / [`set_logout_ur_ls(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_logout_ur_ls): <p>A list of allowed logout URLs for the identity providers.</p>
    ///   - [`default_redirect_uri(impl Into<String>)`](crate::client::fluent_builders::CreateUserPoolClient::default_redirect_uri) / [`set_default_redirect_uri(Option<String>)`](crate::client::fluent_builders::CreateUserPoolClient::set_default_redirect_uri): <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>  <p>A redirect URI must:</p>  <ul>   <li> <p>Be an absolute URI.</p> </li>   <li> <p>Be registered with the authorization server.</p> </li>   <li> <p>Not include a fragment component.</p> </li>  </ul>  <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>  <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>  <p>App callback URLs such as myapp://example are also supported.</p>
    ///   - [`allowed_o_auth_flows(Vec<OAuthFlowType>)`](crate::client::fluent_builders::CreateUserPoolClient::allowed_o_auth_flows) / [`set_allowed_o_auth_flows(Option<Vec<OAuthFlowType>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_allowed_o_auth_flows): <p>The allowed OAuth flows.</p>  <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>  <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>  <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
    ///   - [`allowed_o_auth_scopes(Vec<String>)`](crate::client::fluent_builders::CreateUserPoolClient::allowed_o_auth_scopes) / [`set_allowed_o_auth_scopes(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUserPoolClient::set_allowed_o_auth_scopes): <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
    ///   - [`allowed_o_auth_flows_user_pool_client(bool)`](crate::client::fluent_builders::CreateUserPoolClient::allowed_o_auth_flows_user_pool_client) / [`set_allowed_o_auth_flows_user_pool_client(bool)`](crate::client::fluent_builders::CreateUserPoolClient::set_allowed_o_auth_flows_user_pool_client): <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>
    ///   - [`analytics_configuration(AnalyticsConfigurationType)`](crate::client::fluent_builders::CreateUserPoolClient::analytics_configuration) / [`set_analytics_configuration(Option<AnalyticsConfigurationType>)`](crate::client::fluent_builders::CreateUserPoolClient::set_analytics_configuration): <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>   <p>In regions where Pinpoint is not available, Cognito User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In regions where Pinpoint is available, Cognito User Pools will support sending events to Amazon Pinpoint projects within that same region. </p>  </note>
    ///   - [`prevent_user_existence_errors(PreventUserExistenceErrorTypes)`](crate::client::fluent_builders::CreateUserPoolClient::prevent_user_existence_errors) / [`set_prevent_user_existence_errors(Option<PreventUserExistenceErrorTypes>)`](crate::client::fluent_builders::CreateUserPoolClient::set_prevent_user_existence_errors): <p>Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>  <p>Valid values include:</p>  <ul>   <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>   <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not prevented.</p> </li>  </ul> <note>   <p>After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code> for newly created user pool clients if no value is provided.</p>  </note>
    ///   - [`enable_token_revocation(bool)`](crate::client::fluent_builders::CreateUserPoolClient::enable_token_revocation) / [`set_enable_token_revocation(Option<bool>)`](crate::client::fluent_builders::CreateUserPoolClient::set_enable_token_revocation): <p>Enables or disables token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>  <p>If you don't include this parameter, token revocation is automatically enabled for the new user pool client.</p>
    /// - On success, responds with [`CreateUserPoolClientOutput`](crate::output::CreateUserPoolClientOutput) with field(s):
    ///   - [`user_pool_client(Option<UserPoolClientType>)`](crate::output::CreateUserPoolClientOutput::user_pool_client): <p>The user pool client that was just created.</p>
    /// - On failure, responds with [`SdkError<CreateUserPoolClientError>`](crate::error::CreateUserPoolClientError)
    pub fn create_user_pool_client(&self) -> fluent_builders::CreateUserPoolClient<C, M, R> {
        fluent_builders::CreateUserPoolClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserPoolDomain`](crate::client::fluent_builders::CreateUserPoolDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateUserPoolDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateUserPoolDomain::set_domain): <p>The domain string.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateUserPoolDomain::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::CreateUserPoolDomain::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`custom_domain_config(CustomDomainConfigType)`](crate::client::fluent_builders::CreateUserPoolDomain::custom_domain_config) / [`set_custom_domain_config(Option<CustomDomainConfigType>)`](crate::client::fluent_builders::CreateUserPoolDomain::set_custom_domain_config): <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>  <p>Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.</p>  <p>For more information about the hosted domain and custom domains, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html">Configuring a User Pool Domain</a>.</p>
    /// - On success, responds with [`CreateUserPoolDomainOutput`](crate::output::CreateUserPoolDomainOutput) with field(s):
    ///   - [`cloud_front_domain(Option<String>)`](crate::output::CreateUserPoolDomainOutput::cloud_front_domain): <p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.</p>
    /// - On failure, responds with [`SdkError<CreateUserPoolDomainError>`](crate::error::CreateUserPoolDomainError)
    pub fn create_user_pool_domain(&self) -> fluent_builders::CreateUserPoolDomain<C, M, R> {
        fluent_builders::CreateUserPoolDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_group_name): <p>The name of the group.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    /// - On success, responds with [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteGroupError>`](crate::error::DeleteGroupError)
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIdentityProvider`](crate::client::fluent_builders::DeleteIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIdentityProvider::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteIdentityProvider::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::DeleteIdentityProvider::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::DeleteIdentityProvider::set_provider_name): <p>The identity provider name.</p>
    /// - On success, responds with [`DeleteIdentityProviderOutput`](crate::output::DeleteIdentityProviderOutput)

    /// - On failure, responds with [`SdkError<DeleteIdentityProviderError>`](crate::error::DeleteIdentityProviderError)
    pub fn delete_identity_provider(&self) -> fluent_builders::DeleteIdentityProvider<C, M, R> {
        fluent_builders::DeleteIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourceServer`](crate::client::fluent_builders::DeleteResourceServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceServer::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteResourceServer::set_user_pool_id): <p>The user pool ID for the user pool that hosts the resource server.</p>
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceServer::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::DeleteResourceServer::set_identifier): <p>The identifier for the resource server.</p>
    /// - On success, responds with [`DeleteResourceServerOutput`](crate::output::DeleteResourceServerOutput)

    /// - On failure, responds with [`SdkError<DeleteResourceServerError>`](crate::error::DeleteResourceServerError)
    pub fn delete_resource_server(&self) -> fluent_builders::DeleteResourceServer<C, M, R> {
        fluent_builders::DeleteResourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_access_token): <p>The access token from a request to delete a user.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput)

    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserAttributes`](crate::client::fluent_builders::DeleteUserAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_attribute_names(Vec<String>)`](crate::client::fluent_builders::DeleteUserAttributes::user_attribute_names) / [`set_user_attribute_names(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteUserAttributes::set_user_attribute_names): <p>An array of strings representing the user attribute names you wish to delete.</p>  <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::DeleteUserAttributes::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::DeleteUserAttributes::set_access_token): <p>The access token used in the request to delete user attributes.</p>
    /// - On success, responds with [`DeleteUserAttributesOutput`](crate::output::DeleteUserAttributesOutput)

    /// - On failure, responds with [`SdkError<DeleteUserAttributesError>`](crate::error::DeleteUserAttributesError)
    pub fn delete_user_attributes(&self) -> fluent_builders::DeleteUserAttributes<C, M, R> {
        fluent_builders::DeleteUserAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserPool`](crate::client::fluent_builders::DeleteUserPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserPool::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteUserPool::set_user_pool_id): <p>The user pool ID for the user pool you want to delete.</p>
    /// - On success, responds with [`DeleteUserPoolOutput`](crate::output::DeleteUserPoolOutput)

    /// - On failure, responds with [`SdkError<DeleteUserPoolError>`](crate::error::DeleteUserPoolError)
    pub fn delete_user_pool(&self) -> fluent_builders::DeleteUserPool<C, M, R> {
        fluent_builders::DeleteUserPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserPoolClient`](crate::client::fluent_builders::DeleteUserPoolClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserPoolClient::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteUserPoolClient::set_user_pool_id): <p>The user pool ID for the user pool where you want to delete the client.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserPoolClient::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::DeleteUserPoolClient::set_client_id): <p>The app client ID of the app associated with the user pool.</p>
    /// - On success, responds with [`DeleteUserPoolClientOutput`](crate::output::DeleteUserPoolClientOutput)

    /// - On failure, responds with [`SdkError<DeleteUserPoolClientError>`](crate::error::DeleteUserPoolClientError)
    pub fn delete_user_pool_client(&self) -> fluent_builders::DeleteUserPoolClient<C, M, R> {
        fluent_builders::DeleteUserPoolClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserPoolDomain`](crate::client::fluent_builders::DeleteUserPoolDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeleteUserPoolDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeleteUserPoolDomain::set_domain): <p>The domain string.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserPoolDomain::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteUserPoolDomain::set_user_pool_id): <p>The user pool ID.</p>
    /// - On success, responds with [`DeleteUserPoolDomainOutput`](crate::output::DeleteUserPoolDomainOutput)

    /// - On failure, responds with [`SdkError<DeleteUserPoolDomainError>`](crate::error::DeleteUserPoolDomainError)
    pub fn delete_user_pool_domain(&self) -> fluent_builders::DeleteUserPoolDomain<C, M, R> {
        fluent_builders::DeleteUserPoolDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentityProvider`](crate::client::fluent_builders::DescribeIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityProvider::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeIdentityProvider::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityProvider::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::DescribeIdentityProvider::set_provider_name): <p>The identity provider name.</p>
    /// - On success, responds with [`DescribeIdentityProviderOutput`](crate::output::DescribeIdentityProviderOutput) with field(s):
    ///   - [`identity_provider(Option<IdentityProviderType>)`](crate::output::DescribeIdentityProviderOutput::identity_provider): <p>The identity provider that was deleted.</p>
    /// - On failure, responds with [`SdkError<DescribeIdentityProviderError>`](crate::error::DescribeIdentityProviderError)
    pub fn describe_identity_provider(&self) -> fluent_builders::DescribeIdentityProvider<C, M, R> {
        fluent_builders::DescribeIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourceServer`](crate::client::fluent_builders::DescribeResourceServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeResourceServer::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeResourceServer::set_user_pool_id): <p>The user pool ID for the user pool that hosts the resource server.</p>
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeResourceServer::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::DescribeResourceServer::set_identifier): <p>The identifier for the resource server</p>
    /// - On success, responds with [`DescribeResourceServerOutput`](crate::output::DescribeResourceServerOutput) with field(s):
    ///   - [`resource_server(Option<ResourceServerType>)`](crate::output::DescribeResourceServerOutput::resource_server): <p>The resource server.</p>
    /// - On failure, responds with [`SdkError<DescribeResourceServerError>`](crate::error::DescribeResourceServerError)
    pub fn describe_resource_server(&self) -> fluent_builders::DescribeResourceServer<C, M, R> {
        fluent_builders::DescribeResourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRiskConfiguration`](crate::client::fluent_builders::DescribeRiskConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRiskConfiguration::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeRiskConfiguration::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRiskConfiguration::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::DescribeRiskConfiguration::set_client_id): <p>The app client ID.</p>
    /// - On success, responds with [`DescribeRiskConfigurationOutput`](crate::output::DescribeRiskConfigurationOutput) with field(s):
    ///   - [`risk_configuration(Option<RiskConfigurationType>)`](crate::output::DescribeRiskConfigurationOutput::risk_configuration): <p>The risk configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeRiskConfigurationError>`](crate::error::DescribeRiskConfigurationError)
    pub fn describe_risk_configuration(
        &self,
    ) -> fluent_builders::DescribeRiskConfiguration<C, M, R> {
        fluent_builders::DescribeRiskConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserImportJob`](crate::client::fluent_builders::DescribeUserImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserImportJob::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeUserImportJob::set_user_pool_id): <p>The user pool ID for the user pool that the users are being imported into.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeUserImportJob::set_job_id): <p>The job ID for the user import job.</p>
    /// - On success, responds with [`DescribeUserImportJobOutput`](crate::output::DescribeUserImportJobOutput) with field(s):
    ///   - [`user_import_job(Option<UserImportJobType>)`](crate::output::DescribeUserImportJobOutput::user_import_job): <p>The job object that represents the user import job.</p>
    /// - On failure, responds with [`SdkError<DescribeUserImportJobError>`](crate::error::DescribeUserImportJobError)
    pub fn describe_user_import_job(&self) -> fluent_builders::DescribeUserImportJob<C, M, R> {
        fluent_builders::DescribeUserImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserPool`](crate::client::fluent_builders::DescribeUserPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserPool::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeUserPool::set_user_pool_id): <p>The user pool ID for the user pool you want to describe.</p>
    /// - On success, responds with [`DescribeUserPoolOutput`](crate::output::DescribeUserPoolOutput) with field(s):
    ///   - [`user_pool(Option<UserPoolType>)`](crate::output::DescribeUserPoolOutput::user_pool): <p>The container of metadata returned by the server to describe the pool.</p>
    /// - On failure, responds with [`SdkError<DescribeUserPoolError>`](crate::error::DescribeUserPoolError)
    pub fn describe_user_pool(&self) -> fluent_builders::DescribeUserPool<C, M, R> {
        fluent_builders::DescribeUserPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserPoolClient`](crate::client::fluent_builders::DescribeUserPoolClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserPoolClient::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeUserPoolClient::set_user_pool_id): <p>The user pool ID for the user pool you want to describe.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserPoolClient::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::DescribeUserPoolClient::set_client_id): <p>The app client ID of the app associated with the user pool.</p>
    /// - On success, responds with [`DescribeUserPoolClientOutput`](crate::output::DescribeUserPoolClientOutput) with field(s):
    ///   - [`user_pool_client(Option<UserPoolClientType>)`](crate::output::DescribeUserPoolClientOutput::user_pool_client): <p>The user pool client from a server response to describe the user pool client.</p>
    /// - On failure, responds with [`SdkError<DescribeUserPoolClientError>`](crate::error::DescribeUserPoolClientError)
    pub fn describe_user_pool_client(&self) -> fluent_builders::DescribeUserPoolClient<C, M, R> {
        fluent_builders::DescribeUserPoolClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserPoolDomain`](crate::client::fluent_builders::DescribeUserPoolDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DescribeUserPoolDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DescribeUserPoolDomain::set_domain): <p>The domain string.</p>
    /// - On success, responds with [`DescribeUserPoolDomainOutput`](crate::output::DescribeUserPoolDomainOutput) with field(s):
    ///   - [`domain_description(Option<DomainDescriptionType>)`](crate::output::DescribeUserPoolDomainOutput::domain_description): <p>A domain description object containing information about the domain.</p>
    /// - On failure, responds with [`SdkError<DescribeUserPoolDomainError>`](crate::error::DescribeUserPoolDomainError)
    pub fn describe_user_pool_domain(&self) -> fluent_builders::DescribeUserPoolDomain<C, M, R> {
        fluent_builders::DescribeUserPoolDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ForgetDevice`](crate::client::fluent_builders::ForgetDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::ForgetDevice::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::ForgetDevice::set_access_token): <p>The access token for the forgotten device request.</p>
    ///   - [`device_key(impl Into<String>)`](crate::client::fluent_builders::ForgetDevice::device_key) / [`set_device_key(Option<String>)`](crate::client::fluent_builders::ForgetDevice::set_device_key): <p>The device key.</p>
    /// - On success, responds with [`ForgetDeviceOutput`](crate::output::ForgetDeviceOutput)

    /// - On failure, responds with [`SdkError<ForgetDeviceError>`](crate::error::ForgetDeviceError)
    pub fn forget_device(&self) -> fluent_builders::ForgetDevice<C, M, R> {
        fluent_builders::ForgetDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ForgotPassword`](crate::client::fluent_builders::ForgotPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::ForgotPassword::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::ForgotPassword::set_client_id): <p>The ID of the client associated with the user pool.</p>
    ///   - [`secret_hash(impl Into<String>)`](crate::client::fluent_builders::ForgotPassword::secret_hash) / [`set_secret_hash(Option<String>)`](crate::client::fluent_builders::ForgotPassword::set_secret_hash): <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
    ///   - [`user_context_data(UserContextDataType)`](crate::client::fluent_builders::ForgotPassword::user_context_data) / [`set_user_context_data(Option<UserContextDataType>)`](crate::client::fluent_builders::ForgotPassword::set_user_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::ForgotPassword::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::ForgotPassword::set_username): <p>The user name of the user for whom you want to enter a code to reset a forgotten password.</p>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::ForgotPassword::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::ForgotPassword::set_analytics_metadata): <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ForgotPassword</code> calls.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::ForgotPassword::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ForgotPassword::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>user migration</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`ForgotPasswordOutput`](crate::output::ForgotPasswordOutput) with field(s):
    ///   - [`code_delivery_details(Option<CodeDeliveryDetailsType>)`](crate::output::ForgotPasswordOutput::code_delivery_details): <p>The code delivery details returned by the server in response to the request to reset a password.</p>
    /// - On failure, responds with [`SdkError<ForgotPasswordError>`](crate::error::ForgotPasswordError)
    pub fn forgot_password(&self) -> fluent_builders::ForgotPassword<C, M, R> {
        fluent_builders::ForgotPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCSVHeader`](crate::client::fluent_builders::GetCSVHeader) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetCSVHeader::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::GetCSVHeader::set_user_pool_id): <p>The user pool ID for the user pool that the users are to be imported into.</p>
    /// - On success, responds with [`GetCsvHeaderOutput`](crate::output::GetCsvHeaderOutput) with field(s):
    ///   - [`user_pool_id(Option<String>)`](crate::output::GetCsvHeaderOutput::user_pool_id): <p>The user pool ID for the user pool that the users are to be imported into.</p>
    ///   - [`csv_header(Option<Vec<String>>)`](crate::output::GetCsvHeaderOutput::csv_header): <p>The header information for the .csv file for the user import job.</p>
    /// - On failure, responds with [`SdkError<GetCSVHeaderError>`](crate::error::GetCSVHeaderError)
    pub fn get_csv_header(&self) -> fluent_builders::GetCSVHeader<C, M, R> {
        fluent_builders::GetCSVHeader::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDevice`](crate::client::fluent_builders::GetDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`device_key(impl Into<String>)`](crate::client::fluent_builders::GetDevice::device_key) / [`set_device_key(Option<String>)`](crate::client::fluent_builders::GetDevice::set_device_key): <p>The device key.</p>
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::GetDevice::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::GetDevice::set_access_token): <p>The access token.</p>
    /// - On success, responds with [`GetDeviceOutput`](crate::output::GetDeviceOutput) with field(s):
    ///   - [`device(Option<DeviceType>)`](crate::output::GetDeviceOutput::device): <p>The device.</p>
    /// - On failure, responds with [`SdkError<GetDeviceError>`](crate::error::GetDeviceError)
    pub fn get_device(&self) -> fluent_builders::GetDevice<C, M, R> {
        fluent_builders::GetDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGroup`](crate::client::fluent_builders::GetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::GetGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::GetGroup::set_group_name): <p>The name of the group.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetGroup::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::GetGroup::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    /// - On success, responds with [`GetGroupOutput`](crate::output::GetGroupOutput) with field(s):
    ///   - [`group(Option<GroupType>)`](crate::output::GetGroupOutput::group): <p>The group object for the group.</p>
    /// - On failure, responds with [`SdkError<GetGroupError>`](crate::error::GetGroupError)
    pub fn get_group(&self) -> fluent_builders::GetGroup<C, M, R> {
        fluent_builders::GetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityProviderByIdentifier`](crate::client::fluent_builders::GetIdentityProviderByIdentifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetIdentityProviderByIdentifier::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::GetIdentityProviderByIdentifier::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`idp_identifier(impl Into<String>)`](crate::client::fluent_builders::GetIdentityProviderByIdentifier::idp_identifier) / [`set_idp_identifier(Option<String>)`](crate::client::fluent_builders::GetIdentityProviderByIdentifier::set_idp_identifier): <p>The identity provider ID.</p>
    /// - On success, responds with [`GetIdentityProviderByIdentifierOutput`](crate::output::GetIdentityProviderByIdentifierOutput) with field(s):
    ///   - [`identity_provider(Option<IdentityProviderType>)`](crate::output::GetIdentityProviderByIdentifierOutput::identity_provider): <p>The identity provider object.</p>
    /// - On failure, responds with [`SdkError<GetIdentityProviderByIdentifierError>`](crate::error::GetIdentityProviderByIdentifierError)
    pub fn get_identity_provider_by_identifier(
        &self,
    ) -> fluent_builders::GetIdentityProviderByIdentifier<C, M, R> {
        fluent_builders::GetIdentityProviderByIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSigningCertificate`](crate::client::fluent_builders::GetSigningCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetSigningCertificate::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::GetSigningCertificate::set_user_pool_id): <p>The user pool ID.</p>
    /// - On success, responds with [`GetSigningCertificateOutput`](crate::output::GetSigningCertificateOutput) with field(s):
    ///   - [`certificate(Option<String>)`](crate::output::GetSigningCertificateOutput::certificate): <p>The signing certificate.</p>
    /// - On failure, responds with [`SdkError<GetSigningCertificateError>`](crate::error::GetSigningCertificateError)
    pub fn get_signing_certificate(&self) -> fluent_builders::GetSigningCertificate<C, M, R> {
        fluent_builders::GetSigningCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUICustomization`](crate::client::fluent_builders::GetUICustomization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetUICustomization::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::GetUICustomization::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::GetUICustomization::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::GetUICustomization::set_client_id): <p>The client ID for the client app.</p>
    /// - On success, responds with [`GetUiCustomizationOutput`](crate::output::GetUiCustomizationOutput) with field(s):
    ///   - [`ui_customization(Option<UiCustomizationType>)`](crate::output::GetUiCustomizationOutput::ui_customization): <p>The UI customization information.</p>
    /// - On failure, responds with [`SdkError<GetUICustomizationError>`](crate::error::GetUICustomizationError)
    pub fn get_ui_customization(&self) -> fluent_builders::GetUICustomization<C, M, R> {
        fluent_builders::GetUICustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUser`](crate::client::fluent_builders::GetUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::GetUser::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::GetUser::set_access_token): <p>The access token returned by the server response to get information about the user.</p>
    /// - On success, responds with [`GetUserOutput`](crate::output::GetUserOutput) with field(s):
    ///   - [`username(Option<String>)`](crate::output::GetUserOutput::username): <p>The user name of the user you wish to retrieve from the get user request.</p>
    ///   - [`user_attributes(Option<Vec<AttributeType>>)`](crate::output::GetUserOutput::user_attributes): <p>An array of name-value pairs representing user attributes.</p>  <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    ///   - [`mfa_options(Option<Vec<MfaOptionType>>)`](crate::output::GetUserOutput::mfa_options): <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about TOTP software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
    ///   - [`preferred_mfa_setting(Option<String>)`](crate::output::GetUserOutput::preferred_mfa_setting): <p>The user's preferred MFA setting.</p>
    ///   - [`user_mfa_setting_list(Option<Vec<String>>)`](crate::output::GetUserOutput::user_mfa_setting_list): <p>The MFA options that are enabled for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
    /// - On failure, responds with [`SdkError<GetUserError>`](crate::error::GetUserError)
    pub fn get_user(&self) -> fluent_builders::GetUser<C, M, R> {
        fluent_builders::GetUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUserAttributeVerificationCode`](crate::client::fluent_builders::GetUserAttributeVerificationCode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::GetUserAttributeVerificationCode::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::GetUserAttributeVerificationCode::set_access_token): <p>The access token returned by the server response to get the user attribute verification code.</p>
    ///   - [`attribute_name(impl Into<String>)`](crate::client::fluent_builders::GetUserAttributeVerificationCode::attribute_name) / [`set_attribute_name(Option<String>)`](crate::client::fluent_builders::GetUserAttributeVerificationCode::set_attribute_name): <p>The attribute name returned by the server response to get the user attribute verification code.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::GetUserAttributeVerificationCode::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetUserAttributeVerificationCode::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`GetUserAttributeVerificationCodeOutput`](crate::output::GetUserAttributeVerificationCodeOutput) with field(s):
    ///   - [`code_delivery_details(Option<CodeDeliveryDetailsType>)`](crate::output::GetUserAttributeVerificationCodeOutput::code_delivery_details): <p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>
    /// - On failure, responds with [`SdkError<GetUserAttributeVerificationCodeError>`](crate::error::GetUserAttributeVerificationCodeError)
    pub fn get_user_attribute_verification_code(
        &self,
    ) -> fluent_builders::GetUserAttributeVerificationCode<C, M, R> {
        fluent_builders::GetUserAttributeVerificationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUserPoolMfaConfig`](crate::client::fluent_builders::GetUserPoolMfaConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetUserPoolMfaConfig::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::GetUserPoolMfaConfig::set_user_pool_id): <p>The user pool ID.</p>
    /// - On success, responds with [`GetUserPoolMfaConfigOutput`](crate::output::GetUserPoolMfaConfigOutput) with field(s):
    ///   - [`sms_mfa_configuration(Option<SmsMfaConfigType>)`](crate::output::GetUserPoolMfaConfigOutput::sms_mfa_configuration): <p>The SMS text message multi-factor (MFA) configuration.</p>
    ///   - [`software_token_mfa_configuration(Option<SoftwareTokenMfaConfigType>)`](crate::output::GetUserPoolMfaConfigOutput::software_token_mfa_configuration): <p>The software token multi-factor (MFA) configuration.</p>
    ///   - [`mfa_configuration(Option<UserPoolMfaType>)`](crate::output::GetUserPoolMfaConfigOutput::mfa_configuration): <p>The multi-factor (MFA) configuration. Valid values include:</p>  <ul>   <li> <p> <code>OFF</code> MFA will not be used for any users.</p> </li>   <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>   <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetUserPoolMfaConfigError>`](crate::error::GetUserPoolMfaConfigError)
    pub fn get_user_pool_mfa_config(&self) -> fluent_builders::GetUserPoolMfaConfig<C, M, R> {
        fluent_builders::GetUserPoolMfaConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GlobalSignOut`](crate::client::fluent_builders::GlobalSignOut) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::GlobalSignOut::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::GlobalSignOut::set_access_token): <p>The access token.</p>
    /// - On success, responds with [`GlobalSignOutOutput`](crate::output::GlobalSignOutOutput)

    /// - On failure, responds with [`SdkError<GlobalSignOutError>`](crate::error::GlobalSignOutError)
    pub fn global_sign_out(&self) -> fluent_builders::GlobalSignOut<C, M, R> {
        fluent_builders::GlobalSignOut::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InitiateAuth`](crate::client::fluent_builders::InitiateAuth) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auth_flow(AuthFlowType)`](crate::client::fluent_builders::InitiateAuth::auth_flow) / [`set_auth_flow(Option<AuthFlowType>)`](crate::client::fluent_builders::InitiateAuth::set_auth_flow): <p>The authentication flow for this call to execute. The API action will depend on this value. For example: </p>  <ul>   <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>   <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li>   <li> <p> <code>USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>  </ul>  <p>Valid values include:</p>  <ul>   <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>   <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>   <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>   <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if the USERNAME is not found in the user pool. </p> </li>   <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>  </ul>  <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>
    ///   - [`auth_parameters(HashMap<String, String>)`](crate::client::fluent_builders::InitiateAuth::auth_parameters) / [`set_auth_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::InitiateAuth::set_auth_parameters): <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p>  <ul>   <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>   <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>   <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>  </ul>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::InitiateAuth::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::InitiateAuth::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>  <ul>   <li> <p>Pre signup</p> </li>   <li> <p>Pre authentication</p> </li>   <li> <p>User migration</p> </li>  </ul>  <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>  <p>When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it does not provide the ClientMetadata value as input:</p>  <ul>   <li> <p>Post authentication</p> </li>   <li> <p>Custom message</p> </li>   <li> <p>Pre token generation</p> </li>   <li> <p>Create auth challenge</p> </li>   <li> <p>Define auth challenge</p> </li>   <li> <p>Verify auth challenge</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::InitiateAuth::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::InitiateAuth::set_client_id): <p>The app client ID.</p>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::InitiateAuth::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::InitiateAuth::set_analytics_metadata): <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>InitiateAuth</code> calls.</p>
    ///   - [`user_context_data(UserContextDataType)`](crate::client::fluent_builders::InitiateAuth::user_context_data) / [`set_user_context_data(Option<UserContextDataType>)`](crate::client::fluent_builders::InitiateAuth::set_user_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    /// - On success, responds with [`InitiateAuthOutput`](crate::output::InitiateAuthOutput) with field(s):
    ///   - [`challenge_name(Option<ChallengeNameType>)`](crate::output::InitiateAuthOutput::challenge_name): <p>The name of the challenge which you are responding to with this call. This is returned to you in the <code>AdminInitiateAuth</code> response if you need to pass another challenge.</p>  <p>Valid values include the following. Note that all of these challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p>  <ul>   <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>   <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>   <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>   <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was enabled on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>   <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>   <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>   <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign-in. The MFA types enabled for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To setup software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To setup SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li>  </ul>
    ///   - [`session(Option<String>)`](crate::output::InitiateAuthOutput::session): <p>The session which should be passed both ways in challenge-response calls to the service. If the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    ///   - [`challenge_parameters(Option<HashMap<String, String>>)`](crate::output::InitiateAuthOutput::challenge_parameters): <p>The challenge parameters. These are returned to you in the <code>InitiateAuth</code> response if you need to pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p>  <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
    ///   - [`authentication_result(Option<AuthenticationResultType>)`](crate::output::InitiateAuthOutput::authentication_result): <p>The result of the authentication response. This is only returned if the caller does not need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
    /// - On failure, responds with [`SdkError<InitiateAuthError>`](crate::error::InitiateAuthError)
    pub fn initiate_auth(&self) -> fluent_builders::InitiateAuth<C, M, R> {
        fluent_builders::InitiateAuth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDevices`](crate::client::fluent_builders::ListDevices) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::ListDevices::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::ListDevices::set_access_token): <p>The access tokens for the request to list devices.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListDevices::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListDevices::set_limit): <p>The limit of the device request.</p>
    ///   - [`pagination_token(impl Into<String>)`](crate::client::fluent_builders::ListDevices::pagination_token) / [`set_pagination_token(Option<String>)`](crate::client::fluent_builders::ListDevices::set_pagination_token): <p>The pagination token for the list request.</p>
    /// - On success, responds with [`ListDevicesOutput`](crate::output::ListDevicesOutput) with field(s):
    ///   - [`devices(Option<Vec<DeviceType>>)`](crate::output::ListDevicesOutput::devices): <p>The devices returned in the list devices response.</p>
    ///   - [`pagination_token(Option<String>)`](crate::output::ListDevicesOutput::pagination_token): <p>The pagination token for the list device response.</p>
    /// - On failure, responds with [`SdkError<ListDevicesError>`](crate::error::ListDevicesError)
    pub fn list_devices(&self) -> fluent_builders::ListDevices<C, M, R> {
        fluent_builders::ListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroups`](crate::client::fluent_builders::ListGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListGroups::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::ListGroups::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListGroups::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListGroups::set_limit): <p>The limit of the request to list groups.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroups::set_next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On success, responds with [`ListGroupsOutput`](crate::output::ListGroupsOutput) with field(s):
    ///   - [`groups(Option<Vec<GroupType>>)`](crate::output::ListGroupsOutput::groups): <p>The group objects for the groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGroupsOutput::next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListGroupsError>`](crate::error::ListGroupsError)
    pub fn list_groups(&self) -> fluent_builders::ListGroups<C, M, R> {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentityProviders`](crate::client::fluent_builders::ListIdentityProviders) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIdentityProviders::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListIdentityProviders::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::ListIdentityProviders::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIdentityProviders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIdentityProviders::set_max_results): <p>The maximum number of identity providers to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentityProviders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentityProviders::set_next_token): <p>A pagination token.</p>
    /// - On success, responds with [`ListIdentityProvidersOutput`](crate::output::ListIdentityProvidersOutput) with field(s):
    ///   - [`providers(Option<Vec<ProviderDescription>>)`](crate::output::ListIdentityProvidersOutput::providers): <p>A list of identity provider objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentityProvidersOutput::next_token): <p>A pagination token.</p>
    /// - On failure, responds with [`SdkError<ListIdentityProvidersError>`](crate::error::ListIdentityProvidersError)
    pub fn list_identity_providers(&self) -> fluent_builders::ListIdentityProviders<C, M, R> {
        fluent_builders::ListIdentityProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceServers`](crate::client::fluent_builders::ListResourceServers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceServers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListResourceServers::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::ListResourceServers::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceServers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListResourceServers::set_max_results): <p>The maximum number of resource servers to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceServers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceServers::set_next_token): <p>A pagination token.</p>
    /// - On success, responds with [`ListResourceServersOutput`](crate::output::ListResourceServersOutput) with field(s):
    ///   - [`resource_servers(Option<Vec<ResourceServerType>>)`](crate::output::ListResourceServersOutput::resource_servers): <p>The resource servers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceServersOutput::next_token): <p>A pagination token.</p>
    /// - On failure, responds with [`SdkError<ListResourceServersError>`](crate::error::ListResourceServersError)
    pub fn list_resource_servers(&self) -> fluent_builders::ListResourceServers<C, M, R> {
        fluent_builders::ListResourceServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are assigned to the user pool.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUserImportJobs`](crate::client::fluent_builders::ListUserImportJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListUserImportJobs::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::ListUserImportJobs::set_user_pool_id): <p>The user pool ID for the user pool that the users are being imported into.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUserImportJobs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListUserImportJobs::set_max_results): <p>The maximum number of import jobs you want the request to return.</p>
    ///   - [`pagination_token(impl Into<String>)`](crate::client::fluent_builders::ListUserImportJobs::pagination_token) / [`set_pagination_token(Option<String>)`](crate::client::fluent_builders::ListUserImportJobs::set_pagination_token): <p>An identifier that was returned from the previous call to <code>ListUserImportJobs</code>, which can be used to return the next set of import jobs in the list.</p>
    /// - On success, responds with [`ListUserImportJobsOutput`](crate::output::ListUserImportJobsOutput) with field(s):
    ///   - [`user_import_jobs(Option<Vec<UserImportJobType>>)`](crate::output::ListUserImportJobsOutput::user_import_jobs): <p>The user import jobs.</p>
    ///   - [`pagination_token(Option<String>)`](crate::output::ListUserImportJobsOutput::pagination_token): <p>An identifier that can be used to return the next set of user import jobs in the list.</p>
    /// - On failure, responds with [`SdkError<ListUserImportJobsError>`](crate::error::ListUserImportJobsError)
    pub fn list_user_import_jobs(&self) -> fluent_builders::ListUserImportJobs<C, M, R> {
        fluent_builders::ListUserImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUserPoolClients`](crate::client::fluent_builders::ListUserPoolClients) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUserPoolClients::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListUserPoolClients::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::ListUserPoolClients::set_user_pool_id): <p>The user pool ID for the user pool where you want to list user pool clients.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUserPoolClients::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListUserPoolClients::set_max_results): <p>The maximum number of results you want the request to return when listing the user pool clients.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUserPoolClients::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUserPoolClients::set_next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On success, responds with [`ListUserPoolClientsOutput`](crate::output::ListUserPoolClientsOutput) with field(s):
    ///   - [`user_pool_clients(Option<Vec<UserPoolClientDescription>>)`](crate::output::ListUserPoolClientsOutput::user_pool_clients): <p>The user pool clients in the response that lists user pool clients.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUserPoolClientsOutput::next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListUserPoolClientsError>`](crate::error::ListUserPoolClientsError)
    pub fn list_user_pool_clients(&self) -> fluent_builders::ListUserPoolClients<C, M, R> {
        fluent_builders::ListUserPoolClients::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUserPools`](crate::client::fluent_builders::ListUserPools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUserPools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUserPools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUserPools::set_next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUserPools::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListUserPools::set_max_results): <p>The maximum number of results you want the request to return when listing the user pools.</p>
    /// - On success, responds with [`ListUserPoolsOutput`](crate::output::ListUserPoolsOutput) with field(s):
    ///   - [`user_pools(Option<Vec<UserPoolDescriptionType>>)`](crate::output::ListUserPoolsOutput::user_pools): <p>The user pools from the response to list users.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUserPoolsOutput::next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListUserPoolsError>`](crate::error::ListUserPoolsError)
    pub fn list_user_pools(&self) -> fluent_builders::ListUserPools<C, M, R> {
        fluent_builders::ListUserPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsers`](crate::client::fluent_builders::ListUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListUsers::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::ListUsers::set_user_pool_id): <p>The user pool ID for the user pool on which the search should be performed.</p>
    ///   - [`attributes_to_get(Vec<String>)`](crate::client::fluent_builders::ListUsers::attributes_to_get) / [`set_attributes_to_get(Option<Vec<String>>)`](crate::client::fluent_builders::ListUsers::set_attributes_to_get): <p>An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is null, all attributes are returned.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListUsers::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListUsers::set_limit): <p>Maximum number of users to be returned.</p>
    ///   - [`pagination_token(impl Into<String>)`](crate::client::fluent_builders::ListUsers::pagination_token) / [`set_pagination_token(Option<String>)`](crate::client::fluent_builders::ListUsers::set_pagination_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    ///   - [`filter(impl Into<String>)`](crate::client::fluent_builders::ListUsers::filter) / [`set_filter(Option<String>)`](crate::client::fluent_builders::ListUsers::set_filter): <p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "<code>family_name</code> = \"Reddy\"".</p>  <ul>   <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li>   <li> <p> <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"". </p> </li>   <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li>  </ul>  <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p>  <p>You can only search for the following standard attributes:</p>  <ul>   <li> <p> <code>username</code> (case-sensitive)</p> </li>   <li> <p> <code>email</code> </p> </li>   <li> <p> <code>phone_number</code> </p> </li>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>given_name</code> </p> </li>   <li> <p> <code>family_name</code> </p> </li>   <li> <p> <code>preferred_username</code> </p> </li>   <li> <p> <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)</p> </li>   <li> <p> <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code> </p> </li>   <li> <p> <code>sub</code> </p> </li>  </ul>  <p>Custom attributes are not searchable.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    /// - On success, responds with [`ListUsersOutput`](crate::output::ListUsersOutput) with field(s):
    ///   - [`users(Option<Vec<UserType>>)`](crate::output::ListUsersOutput::users): <p>The users returned in the request to list users.</p>
    ///   - [`pagination_token(Option<String>)`](crate::output::ListUsersOutput::pagination_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListUsersError>`](crate::error::ListUsersError)
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsersInGroup`](crate::client::fluent_builders::ListUsersInGroup) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUsersInGroup::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListUsersInGroup::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::ListUsersInGroup::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::ListUsersInGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::ListUsersInGroup::set_group_name): <p>The name of the group.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListUsersInGroup::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListUsersInGroup::set_limit): <p>The limit of the request to list users.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsersInGroup::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsersInGroup::set_next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On success, responds with [`ListUsersInGroupOutput`](crate::output::ListUsersInGroupOutput) with field(s):
    ///   - [`users(Option<Vec<UserType>>)`](crate::output::ListUsersInGroupOutput::users): <p>The users returned in the request to list users.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUsersInGroupOutput::next_token): <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListUsersInGroupError>`](crate::error::ListUsersInGroupError)
    pub fn list_users_in_group(&self) -> fluent_builders::ListUsersInGroup<C, M, R> {
        fluent_builders::ListUsersInGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResendConfirmationCode`](crate::client::fluent_builders::ResendConfirmationCode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::ResendConfirmationCode::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::ResendConfirmationCode::set_client_id): <p>The ID of the client associated with the user pool.</p>
    ///   - [`secret_hash(impl Into<String>)`](crate::client::fluent_builders::ResendConfirmationCode::secret_hash) / [`set_secret_hash(Option<String>)`](crate::client::fluent_builders::ResendConfirmationCode::set_secret_hash): <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
    ///   - [`user_context_data(UserContextDataType)`](crate::client::fluent_builders::ResendConfirmationCode::user_context_data) / [`set_user_context_data(Option<UserContextDataType>)`](crate::client::fluent_builders::ResendConfirmationCode::set_user_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::ResendConfirmationCode::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::ResendConfirmationCode::set_username): <p>The user name of the user to whom you wish to resend a confirmation code.</p>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::ResendConfirmationCode::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::ResendConfirmationCode::set_analytics_metadata): <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ResendConfirmationCode</code> calls.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::ResendConfirmationCode::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ResendConfirmationCode::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`ResendConfirmationCodeOutput`](crate::output::ResendConfirmationCodeOutput) with field(s):
    ///   - [`code_delivery_details(Option<CodeDeliveryDetailsType>)`](crate::output::ResendConfirmationCodeOutput::code_delivery_details): <p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>
    /// - On failure, responds with [`SdkError<ResendConfirmationCodeError>`](crate::error::ResendConfirmationCodeError)
    pub fn resend_confirmation_code(&self) -> fluent_builders::ResendConfirmationCode<C, M, R> {
        fluent_builders::ResendConfirmationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RespondToAuthChallenge`](crate::client::fluent_builders::RespondToAuthChallenge) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::RespondToAuthChallenge::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::RespondToAuthChallenge::set_client_id): <p>The app client ID.</p>
    ///   - [`challenge_name(ChallengeNameType)`](crate::client::fluent_builders::RespondToAuthChallenge::challenge_name) / [`set_challenge_name(Option<ChallengeNameType>)`](crate::client::fluent_builders::RespondToAuthChallenge::set_challenge_name): <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>  <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>
    ///   - [`session(impl Into<String>)`](crate::client::fluent_builders::RespondToAuthChallenge::session) / [`set_session(Option<String>)`](crate::client::fluent_builders::RespondToAuthChallenge::set_session): <p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    ///   - [`challenge_responses(HashMap<String, String>)`](crate::client::fluent_builders::RespondToAuthChallenge::challenge_responses) / [`set_challenge_responses(Option<HashMap<String, String>>)`](crate::client::fluent_builders::RespondToAuthChallenge::set_challenge_responses): <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <note>   <p> <code>SECRET_HASH</code> (if app client is configured with client secret) applies to all inputs below (including <code>SOFTWARE_TOKEN_MFA</code>).</p>  </note>  <ul>   <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>.</p> </li>   <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>.</p> </li>   <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>. </p> </li>   <li> <p> <code>SOFTWARE_TOKEN_MFA</code>: <code>USERNAME</code> and <code>SOFTWARE_TOKEN_MFA_CODE</code> are required attributes.</p> </li>   <li> <p> <code>DEVICE_SRP_AUTH</code> requires <code>USERNAME</code>, <code>DEVICE_KEY</code>, <code>SRP_A</code> (and <code>SECRET_HASH</code>).</p> </li>   <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code> requires everything that <code>PASSWORD_VERIFIER</code> requires plus <code>DEVICE_KEY</code>.</p> </li>   <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you need to use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>  </ul>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::RespondToAuthChallenge::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::RespondToAuthChallenge::set_analytics_metadata): <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>RespondToAuthChallenge</code> calls.</p>
    ///   - [`user_context_data(UserContextDataType)`](crate::client::fluent_builders::RespondToAuthChallenge::user_context_data) / [`set_user_context_data(Option<UserContextDataType>)`](crate::client::fluent_builders::RespondToAuthChallenge::set_user_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::RespondToAuthChallenge::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::RespondToAuthChallenge::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>post authentication</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`RespondToAuthChallengeOutput`](crate::output::RespondToAuthChallengeOutput) with field(s):
    ///   - [`challenge_name(Option<ChallengeNameType>)`](crate::output::RespondToAuthChallengeOutput::challenge_name): <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
    ///   - [`session(Option<String>)`](crate::output::RespondToAuthChallengeOutput::session): <p>The session which should be passed both ways in challenge-response calls to the service. If the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    ///   - [`challenge_parameters(Option<HashMap<String, String>>)`](crate::output::RespondToAuthChallengeOutput::challenge_parameters): <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
    ///   - [`authentication_result(Option<AuthenticationResultType>)`](crate::output::RespondToAuthChallengeOutput::authentication_result): <p>The result returned by the server in response to the request to respond to the authentication challenge.</p>
    /// - On failure, responds with [`SdkError<RespondToAuthChallengeError>`](crate::error::RespondToAuthChallengeError)
    pub fn respond_to_auth_challenge(&self) -> fluent_builders::RespondToAuthChallenge<C, M, R> {
        fluent_builders::RespondToAuthChallenge::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeToken`](crate::client::fluent_builders::RevokeToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::RevokeToken::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::RevokeToken::set_token): <p>The token that you want to revoke.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::RevokeToken::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::RevokeToken::set_client_id): <p>The client ID for the token that you want to revoke.</p>
    ///   - [`client_secret(impl Into<String>)`](crate::client::fluent_builders::RevokeToken::client_secret) / [`set_client_secret(Option<String>)`](crate::client::fluent_builders::RevokeToken::set_client_secret): <p>The secret for the client ID. This is required only if the client ID has a secret.</p>
    /// - On success, responds with [`RevokeTokenOutput`](crate::output::RevokeTokenOutput)

    /// - On failure, responds with [`SdkError<RevokeTokenError>`](crate::error::RevokeTokenError)
    pub fn revoke_token(&self) -> fluent_builders::RevokeToken<C, M, R> {
        fluent_builders::RevokeToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetRiskConfiguration`](crate::client::fluent_builders::SetRiskConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::SetRiskConfiguration::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::SetRiskConfiguration::set_user_pool_id): <p>The user pool ID. </p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::SetRiskConfiguration::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::SetRiskConfiguration::set_client_id): <p>The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in the userPool.</p>  <p>Otherwise, <code>ClientId</code> is mapped to the client. When the client ID is not null, the user pool configuration is overridden and the risk configuration for the client is used instead.</p>
    ///   - [`compromised_credentials_risk_configuration(CompromisedCredentialsRiskConfigurationType)`](crate::client::fluent_builders::SetRiskConfiguration::compromised_credentials_risk_configuration) / [`set_compromised_credentials_risk_configuration(Option<CompromisedCredentialsRiskConfigurationType>)`](crate::client::fluent_builders::SetRiskConfiguration::set_compromised_credentials_risk_configuration): <p>The compromised credentials risk configuration.</p>
    ///   - [`account_takeover_risk_configuration(AccountTakeoverRiskConfigurationType)`](crate::client::fluent_builders::SetRiskConfiguration::account_takeover_risk_configuration) / [`set_account_takeover_risk_configuration(Option<AccountTakeoverRiskConfigurationType>)`](crate::client::fluent_builders::SetRiskConfiguration::set_account_takeover_risk_configuration): <p>The account takeover risk configuration.</p>
    ///   - [`risk_exception_configuration(RiskExceptionConfigurationType)`](crate::client::fluent_builders::SetRiskConfiguration::risk_exception_configuration) / [`set_risk_exception_configuration(Option<RiskExceptionConfigurationType>)`](crate::client::fluent_builders::SetRiskConfiguration::set_risk_exception_configuration): <p>The configuration to override the risk decision.</p>
    /// - On success, responds with [`SetRiskConfigurationOutput`](crate::output::SetRiskConfigurationOutput) with field(s):
    ///   - [`risk_configuration(Option<RiskConfigurationType>)`](crate::output::SetRiskConfigurationOutput::risk_configuration): <p>The risk configuration.</p>
    /// - On failure, responds with [`SdkError<SetRiskConfigurationError>`](crate::error::SetRiskConfigurationError)
    pub fn set_risk_configuration(&self) -> fluent_builders::SetRiskConfiguration<C, M, R> {
        fluent_builders::SetRiskConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetUICustomization`](crate::client::fluent_builders::SetUICustomization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::SetUICustomization::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::SetUICustomization::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::SetUICustomization::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::SetUICustomization::set_client_id): <p>The client ID for the client app.</p>
    ///   - [`css(impl Into<String>)`](crate::client::fluent_builders::SetUICustomization::css) / [`set_css(Option<String>)`](crate::client::fluent_builders::SetUICustomization::set_css): <p>The CSS values in the UI customization.</p>
    ///   - [`image_file(Blob)`](crate::client::fluent_builders::SetUICustomization::image_file) / [`set_image_file(Option<Blob>)`](crate::client::fluent_builders::SetUICustomization::set_image_file): <p>The uploaded logo image for the UI customization.</p>
    /// - On success, responds with [`SetUiCustomizationOutput`](crate::output::SetUiCustomizationOutput) with field(s):
    ///   - [`ui_customization(Option<UiCustomizationType>)`](crate::output::SetUiCustomizationOutput::ui_customization): <p>The UI customization information.</p>
    /// - On failure, responds with [`SdkError<SetUICustomizationError>`](crate::error::SetUICustomizationError)
    pub fn set_ui_customization(&self) -> fluent_builders::SetUICustomization<C, M, R> {
        fluent_builders::SetUICustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetUserMFAPreference`](crate::client::fluent_builders::SetUserMFAPreference) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sms_mfa_settings(SmsMfaSettingsType)`](crate::client::fluent_builders::SetUserMFAPreference::sms_mfa_settings) / [`set_sms_mfa_settings(Option<SmsMfaSettingsType>)`](crate::client::fluent_builders::SetUserMFAPreference::set_sms_mfa_settings): <p>The SMS text message multi-factor authentication (MFA) settings.</p>
    ///   - [`software_token_mfa_settings(SoftwareTokenMfaSettingsType)`](crate::client::fluent_builders::SetUserMFAPreference::software_token_mfa_settings) / [`set_software_token_mfa_settings(Option<SoftwareTokenMfaSettingsType>)`](crate::client::fluent_builders::SetUserMFAPreference::set_software_token_mfa_settings): <p>The time-based one-time password software token MFA settings.</p>
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::SetUserMFAPreference::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::SetUserMFAPreference::set_access_token): <p>The access token for the user.</p>
    /// - On success, responds with [`SetUserMfaPreferenceOutput`](crate::output::SetUserMfaPreferenceOutput)

    /// - On failure, responds with [`SdkError<SetUserMFAPreferenceError>`](crate::error::SetUserMFAPreferenceError)
    pub fn set_user_mfa_preference(&self) -> fluent_builders::SetUserMFAPreference<C, M, R> {
        fluent_builders::SetUserMFAPreference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetUserPoolMfaConfig`](crate::client::fluent_builders::SetUserPoolMfaConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::SetUserPoolMfaConfig::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::SetUserPoolMfaConfig::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`sms_mfa_configuration(SmsMfaConfigType)`](crate::client::fluent_builders::SetUserPoolMfaConfig::sms_mfa_configuration) / [`set_sms_mfa_configuration(Option<SmsMfaConfigType>)`](crate::client::fluent_builders::SetUserPoolMfaConfig::set_sms_mfa_configuration): <p>The SMS text message MFA configuration.</p>
    ///   - [`software_token_mfa_configuration(SoftwareTokenMfaConfigType)`](crate::client::fluent_builders::SetUserPoolMfaConfig::software_token_mfa_configuration) / [`set_software_token_mfa_configuration(Option<SoftwareTokenMfaConfigType>)`](crate::client::fluent_builders::SetUserPoolMfaConfig::set_software_token_mfa_configuration): <p>The software token MFA configuration.</p>
    ///   - [`mfa_configuration(UserPoolMfaType)`](crate::client::fluent_builders::SetUserPoolMfaConfig::mfa_configuration) / [`set_mfa_configuration(Option<UserPoolMfaType>)`](crate::client::fluent_builders::SetUserPoolMfaConfig::set_mfa_configuration): <p>The MFA configuration. Users who don't have an MFA factor set up won't be able to sign-in if you set the MfaConfiguration value to ‘ON’. See <a href="cognito/latest/developerguide/user-pool-settings-mfa.html">Adding Multi-Factor Authentication (MFA) to a User Pool</a> to learn more. Valid values include:</p>  <ul>   <li> <p> <code>OFF</code> MFA will not be used for any users.</p> </li>   <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>   <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>  </ul>
    /// - On success, responds with [`SetUserPoolMfaConfigOutput`](crate::output::SetUserPoolMfaConfigOutput) with field(s):
    ///   - [`sms_mfa_configuration(Option<SmsMfaConfigType>)`](crate::output::SetUserPoolMfaConfigOutput::sms_mfa_configuration): <p>The SMS text message MFA configuration.</p>
    ///   - [`software_token_mfa_configuration(Option<SoftwareTokenMfaConfigType>)`](crate::output::SetUserPoolMfaConfigOutput::software_token_mfa_configuration): <p>The software token MFA configuration.</p>
    ///   - [`mfa_configuration(Option<UserPoolMfaType>)`](crate::output::SetUserPoolMfaConfigOutput::mfa_configuration): <p>The MFA configuration. Valid values include:</p>  <ul>   <li> <p> <code>OFF</code> MFA will not be used for any users.</p> </li>   <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>   <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<SetUserPoolMfaConfigError>`](crate::error::SetUserPoolMfaConfigError)
    pub fn set_user_pool_mfa_config(&self) -> fluent_builders::SetUserPoolMfaConfig<C, M, R> {
        fluent_builders::SetUserPoolMfaConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetUserSettings`](crate::client::fluent_builders::SetUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::SetUserSettings::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::SetUserSettings::set_access_token): <p>The access token for the set user settings request.</p>
    ///   - [`mfa_options(Vec<MfaOptionType>)`](crate::client::fluent_builders::SetUserSettings::mfa_options) / [`set_mfa_options(Option<Vec<MfaOptionType>>)`](crate::client::fluent_builders::SetUserSettings::set_mfa_options): <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
    /// - On success, responds with [`SetUserSettingsOutput`](crate::output::SetUserSettingsOutput)

    /// - On failure, responds with [`SdkError<SetUserSettingsError>`](crate::error::SetUserSettingsError)
    pub fn set_user_settings(&self) -> fluent_builders::SetUserSettings<C, M, R> {
        fluent_builders::SetUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SignUp`](crate::client::fluent_builders::SignUp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::SignUp::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::SignUp::set_client_id): <p>The ID of the client associated with the user pool.</p>
    ///   - [`secret_hash(impl Into<String>)`](crate::client::fluent_builders::SignUp::secret_hash) / [`set_secret_hash(Option<String>)`](crate::client::fluent_builders::SignUp::set_secret_hash): <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::SignUp::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::SignUp::set_username): <p>The user name of the user you wish to register.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::SignUp::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::SignUp::set_password): <p>The password of the user you wish to register.</p>
    ///   - [`user_attributes(Vec<AttributeType>)`](crate::client::fluent_builders::SignUp::user_attributes) / [`set_user_attributes(Option<Vec<AttributeType>>)`](crate::client::fluent_builders::SignUp::set_user_attributes): <p>An array of name-value pairs representing user attributes.</p>  <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    ///   - [`validation_data(Vec<AttributeType>)`](crate::client::fluent_builders::SignUp::validation_data) / [`set_validation_data(Option<Vec<AttributeType>>)`](crate::client::fluent_builders::SignUp::set_validation_data): <p>The validation data in the request to register a user.</p>
    ///   - [`analytics_metadata(AnalyticsMetadataType)`](crate::client::fluent_builders::SignUp::analytics_metadata) / [`set_analytics_metadata(Option<AnalyticsMetadataType>)`](crate::client::fluent_builders::SignUp::set_analytics_metadata): <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>SignUp</code> calls.</p>
    ///   - [`user_context_data(UserContextDataType)`](crate::client::fluent_builders::SignUp::user_context_data) / [`set_user_context_data(Option<UserContextDataType>)`](crate::client::fluent_builders::SignUp::set_user_context_data): <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::SignUp::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SignUp::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>post confirmation</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`SignUpOutput`](crate::output::SignUpOutput) with field(s):
    ///   - [`user_confirmed(bool)`](crate::output::SignUpOutput::user_confirmed): <p>A response from the server indicating that a user registration has been confirmed.</p>
    ///   - [`code_delivery_details(Option<CodeDeliveryDetailsType>)`](crate::output::SignUpOutput::code_delivery_details): <p>The code delivery details returned by the server response to the user registration request.</p>
    ///   - [`user_sub(Option<String>)`](crate::output::SignUpOutput::user_sub): <p>The UUID of the authenticated user. This is not the same as <code>username</code>.</p>
    /// - On failure, responds with [`SdkError<SignUpError>`](crate::error::SignUpError)
    pub fn sign_up(&self) -> fluent_builders::SignUp<C, M, R> {
        fluent_builders::SignUp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartUserImportJob`](crate::client::fluent_builders::StartUserImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::StartUserImportJob::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::StartUserImportJob::set_user_pool_id): <p>The user pool ID for the user pool that the users are being imported into.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StartUserImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StartUserImportJob::set_job_id): <p>The job ID for the user import job.</p>
    /// - On success, responds with [`StartUserImportJobOutput`](crate::output::StartUserImportJobOutput) with field(s):
    ///   - [`user_import_job(Option<UserImportJobType>)`](crate::output::StartUserImportJobOutput::user_import_job): <p>The job object that represents the user import job.</p>
    /// - On failure, responds with [`SdkError<StartUserImportJobError>`](crate::error::StartUserImportJobError)
    pub fn start_user_import_job(&self) -> fluent_builders::StartUserImportJob<C, M, R> {
        fluent_builders::StartUserImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopUserImportJob`](crate::client::fluent_builders::StopUserImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::StopUserImportJob::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::StopUserImportJob::set_user_pool_id): <p>The user pool ID for the user pool that the users are being imported into.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopUserImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopUserImportJob::set_job_id): <p>The job ID for the user import job.</p>
    /// - On success, responds with [`StopUserImportJobOutput`](crate::output::StopUserImportJobOutput) with field(s):
    ///   - [`user_import_job(Option<UserImportJobType>)`](crate::output::StopUserImportJobOutput::user_import_job): <p>The job object that represents the user import job.</p>
    /// - On failure, responds with [`SdkError<StopUserImportJobError>`](crate::error::StopUserImportJobError)
    pub fn stop_user_import_job(&self) -> fluent_builders::StopUserImportJob<C, M, R> {
        fluent_builders::StopUserImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the user pool to assign the tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to assign to the user pool.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to remove from the user pool.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAuthEventFeedback`](crate::client::fluent_builders::UpdateAuthEventFeedback) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::set_username): <p>The user pool username.</p>
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::set_event_id): <p>The event ID.</p>
    ///   - [`feedback_token(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::feedback_token) / [`set_feedback_token(Option<String>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::set_feedback_token): <p>The feedback token.</p>
    ///   - [`feedback_value(FeedbackValueType)`](crate::client::fluent_builders::UpdateAuthEventFeedback::feedback_value) / [`set_feedback_value(Option<FeedbackValueType>)`](crate::client::fluent_builders::UpdateAuthEventFeedback::set_feedback_value): <p>The authentication event feedback value.</p>
    /// - On success, responds with [`UpdateAuthEventFeedbackOutput`](crate::output::UpdateAuthEventFeedbackOutput)

    /// - On failure, responds with [`SdkError<UpdateAuthEventFeedbackError>`](crate::error::UpdateAuthEventFeedbackError)
    pub fn update_auth_event_feedback(&self) -> fluent_builders::UpdateAuthEventFeedback<C, M, R> {
        fluent_builders::UpdateAuthEventFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDeviceStatus`](crate::client::fluent_builders::UpdateDeviceStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::UpdateDeviceStatus::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::UpdateDeviceStatus::set_access_token): <p>The access token.</p>
    ///   - [`device_key(impl Into<String>)`](crate::client::fluent_builders::UpdateDeviceStatus::device_key) / [`set_device_key(Option<String>)`](crate::client::fluent_builders::UpdateDeviceStatus::set_device_key): <p>The device key.</p>
    ///   - [`device_remembered_status(DeviceRememberedStatusType)`](crate::client::fluent_builders::UpdateDeviceStatus::device_remembered_status) / [`set_device_remembered_status(Option<DeviceRememberedStatusType>)`](crate::client::fluent_builders::UpdateDeviceStatus::set_device_remembered_status): <p>The status of whether a device is remembered.</p>
    /// - On success, responds with [`UpdateDeviceStatusOutput`](crate::output::UpdateDeviceStatusOutput)

    /// - On failure, responds with [`SdkError<UpdateDeviceStatusError>`](crate::error::UpdateDeviceStatusError)
    pub fn update_device_status(&self) -> fluent_builders::UpdateDeviceStatus<C, M, R> {
        fluent_builders::UpdateDeviceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_group_name): <p>The name of the group.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_description): <p>A string containing the new description of the group.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_role_arn): <p>The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>
    ///   - [`precedence(i32)`](crate::client::fluent_builders::UpdateGroup::precedence) / [`set_precedence(Option<i32>)`](crate::client::fluent_builders::UpdateGroup::set_precedence): <p>The new precedence value for the group. For more information about this parameter, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html">CreateGroup</a>.</p>
    /// - On success, responds with [`UpdateGroupOutput`](crate::output::UpdateGroupOutput) with field(s):
    ///   - [`group(Option<GroupType>)`](crate::output::UpdateGroupOutput::group): <p>The group object for the group.</p>
    /// - On failure, responds with [`SdkError<UpdateGroupError>`](crate::error::UpdateGroupError)
    pub fn update_group(&self) -> fluent_builders::UpdateGroup<C, M, R> {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIdentityProvider`](crate::client::fluent_builders::UpdateIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_user_pool_id): <p>The user pool ID.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_provider_name): <p>The identity provider name.</p>
    ///   - [`provider_details(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIdentityProvider::provider_details) / [`set_provider_details(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_provider_details): <p>The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>
    ///   - [`attribute_mapping(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIdentityProvider::attribute_mapping) / [`set_attribute_mapping(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_attribute_mapping): <p>The identity provider attribute mapping to be changed.</p>
    ///   - [`idp_identifiers(Vec<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::idp_identifiers) / [`set_idp_identifiers(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_idp_identifiers): <p>A list of identity provider identifiers.</p>
    /// - On success, responds with [`UpdateIdentityProviderOutput`](crate::output::UpdateIdentityProviderOutput) with field(s):
    ///   - [`identity_provider(Option<IdentityProviderType>)`](crate::output::UpdateIdentityProviderOutput::identity_provider): <p>The identity provider object.</p>
    /// - On failure, responds with [`SdkError<UpdateIdentityProviderError>`](crate::error::UpdateIdentityProviderError)
    pub fn update_identity_provider(&self) -> fluent_builders::UpdateIdentityProvider<C, M, R> {
        fluent_builders::UpdateIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourceServer`](crate::client::fluent_builders::UpdateResourceServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceServer::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateResourceServer::set_user_pool_id): <p>The user pool ID for the user pool.</p>
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceServer::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::UpdateResourceServer::set_identifier): <p>The identifier for the resource server.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceServer::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateResourceServer::set_name): <p>The name of the resource server.</p>
    ///   - [`scopes(Vec<ResourceServerScopeType>)`](crate::client::fluent_builders::UpdateResourceServer::scopes) / [`set_scopes(Option<Vec<ResourceServerScopeType>>)`](crate::client::fluent_builders::UpdateResourceServer::set_scopes): <p>The scope values to be set for the resource server.</p>
    /// - On success, responds with [`UpdateResourceServerOutput`](crate::output::UpdateResourceServerOutput) with field(s):
    ///   - [`resource_server(Option<ResourceServerType>)`](crate::output::UpdateResourceServerOutput::resource_server): <p>The resource server.</p>
    /// - On failure, responds with [`SdkError<UpdateResourceServerError>`](crate::error::UpdateResourceServerError)
    pub fn update_resource_server(&self) -> fluent_builders::UpdateResourceServer<C, M, R> {
        fluent_builders::UpdateResourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserAttributes`](crate::client::fluent_builders::UpdateUserAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_attributes(Vec<AttributeType>)`](crate::client::fluent_builders::UpdateUserAttributes::user_attributes) / [`set_user_attributes(Option<Vec<AttributeType>>)`](crate::client::fluent_builders::UpdateUserAttributes::set_user_attributes): <p>An array of name-value pairs representing user attributes.</p>  <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::UpdateUserAttributes::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::UpdateUserAttributes::set_access_token): <p>The access token for the request to update user attributes.</p>
    ///   - [`client_metadata(HashMap<String, String>)`](crate::client::fluent_builders::UpdateUserAttributes::client_metadata) / [`set_client_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateUserAttributes::set_client_metadata): <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>  <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>   <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>   <ul>    <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>    <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>    <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>   </ul>  </note>
    /// - On success, responds with [`UpdateUserAttributesOutput`](crate::output::UpdateUserAttributesOutput) with field(s):
    ///   - [`code_delivery_details_list(Option<Vec<CodeDeliveryDetailsType>>)`](crate::output::UpdateUserAttributesOutput::code_delivery_details_list): <p>The code delivery details list from the server for the request to update user attributes.</p>
    /// - On failure, responds with [`SdkError<UpdateUserAttributesError>`](crate::error::UpdateUserAttributesError)
    pub fn update_user_attributes(&self) -> fluent_builders::UpdateUserAttributes<C, M, R> {
        fluent_builders::UpdateUserAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserPool`](crate::client::fluent_builders::UpdateUserPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPool::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateUserPool::set_user_pool_id): <p>The user pool ID for the user pool you want to update.</p>
    ///   - [`policies(UserPoolPolicyType)`](crate::client::fluent_builders::UpdateUserPool::policies) / [`set_policies(Option<UserPoolPolicyType>)`](crate::client::fluent_builders::UpdateUserPool::set_policies): <p>A container with the policies you wish to update in a user pool.</p>
    ///   - [`lambda_config(LambdaConfigType)`](crate::client::fluent_builders::UpdateUserPool::lambda_config) / [`set_lambda_config(Option<LambdaConfigType>)`](crate::client::fluent_builders::UpdateUserPool::set_lambda_config): <p>The Lambda configuration information from the request to update the user pool.</p>
    ///   - [`auto_verified_attributes(Vec<VerifiedAttributeType>)`](crate::client::fluent_builders::UpdateUserPool::auto_verified_attributes) / [`set_auto_verified_attributes(Option<Vec<VerifiedAttributeType>>)`](crate::client::fluent_builders::UpdateUserPool::set_auto_verified_attributes): <p>The attributes that are automatically verified when the Amazon Cognito service makes a request to update user pools.</p>
    ///   - [`sms_verification_message(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPool::sms_verification_message) / [`set_sms_verification_message(Option<String>)`](crate::client::fluent_builders::UpdateUserPool::set_sms_verification_message): <p>A container with information about the SMS verification message.</p>
    ///   - [`email_verification_message(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPool::email_verification_message) / [`set_email_verification_message(Option<String>)`](crate::client::fluent_builders::UpdateUserPool::set_email_verification_message): <p>The contents of the email verification message.</p>
    ///   - [`email_verification_subject(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPool::email_verification_subject) / [`set_email_verification_subject(Option<String>)`](crate::client::fluent_builders::UpdateUserPool::set_email_verification_subject): <p>The subject of the email verification message.</p>
    ///   - [`verification_message_template(VerificationMessageTemplateType)`](crate::client::fluent_builders::UpdateUserPool::verification_message_template) / [`set_verification_message_template(Option<VerificationMessageTemplateType>)`](crate::client::fluent_builders::UpdateUserPool::set_verification_message_template): <p>The template for verification messages.</p>
    ///   - [`sms_authentication_message(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPool::sms_authentication_message) / [`set_sms_authentication_message(Option<String>)`](crate::client::fluent_builders::UpdateUserPool::set_sms_authentication_message): <p>The contents of the SMS authentication message.</p>
    ///   - [`mfa_configuration(UserPoolMfaType)`](crate::client::fluent_builders::UpdateUserPool::mfa_configuration) / [`set_mfa_configuration(Option<UserPoolMfaType>)`](crate::client::fluent_builders::UpdateUserPool::set_mfa_configuration): <p>Can be one of the following values:</p>  <ul>   <li> <p> <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.</p> </li>   <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify ON when you are initially creating a user pool. You can use the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html">SetUserPoolMfaConfig</a> API operation to turn MFA "ON" for existing user pools. </p> </li>   <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>  </ul>
    ///   - [`device_configuration(DeviceConfigurationType)`](crate::client::fluent_builders::UpdateUserPool::device_configuration) / [`set_device_configuration(Option<DeviceConfigurationType>)`](crate::client::fluent_builders::UpdateUserPool::set_device_configuration): <p>Device configuration.</p>
    ///   - [`email_configuration(EmailConfigurationType)`](crate::client::fluent_builders::UpdateUserPool::email_configuration) / [`set_email_configuration(Option<EmailConfigurationType>)`](crate::client::fluent_builders::UpdateUserPool::set_email_configuration): <p>Email configuration.</p>
    ///   - [`sms_configuration(SmsConfigurationType)`](crate::client::fluent_builders::UpdateUserPool::sms_configuration) / [`set_sms_configuration(Option<SmsConfigurationType>)`](crate::client::fluent_builders::UpdateUserPool::set_sms_configuration): <p>SMS configuration.</p>
    ///   - [`user_pool_tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateUserPool::user_pool_tags) / [`set_user_pool_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateUserPool::set_user_pool_tags): <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
    ///   - [`admin_create_user_config(AdminCreateUserConfigType)`](crate::client::fluent_builders::UpdateUserPool::admin_create_user_config) / [`set_admin_create_user_config(Option<AdminCreateUserConfigType>)`](crate::client::fluent_builders::UpdateUserPool::set_admin_create_user_config): <p>The configuration for <code>AdminCreateUser</code> requests.</p>
    ///   - [`user_pool_add_ons(UserPoolAddOnsType)`](crate::client::fluent_builders::UpdateUserPool::user_pool_add_ons) / [`set_user_pool_add_ons(Option<UserPoolAddOnsType>)`](crate::client::fluent_builders::UpdateUserPool::set_user_pool_add_ons): <p>Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
    ///   - [`account_recovery_setting(AccountRecoverySettingType)`](crate::client::fluent_builders::UpdateUserPool::account_recovery_setting) / [`set_account_recovery_setting(Option<AccountRecoverySettingType>)`](crate::client::fluent_builders::UpdateUserPool::set_account_recovery_setting): <p>Use this setting to define which verified available method a user can use to recover their password when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.</p>
    /// - On success, responds with [`UpdateUserPoolOutput`](crate::output::UpdateUserPoolOutput)

    /// - On failure, responds with [`SdkError<UpdateUserPoolError>`](crate::error::UpdateUserPoolError)
    pub fn update_user_pool(&self) -> fluent_builders::UpdateUserPool<C, M, R> {
        fluent_builders::UpdateUserPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserPoolClient`](crate::client::fluent_builders::UpdateUserPoolClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_user_pool_id): <p>The user pool ID for the user pool where you want to update the user pool client.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_client_id): <p>The ID of the client associated with the user pool.</p>
    ///   - [`client_name(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::client_name) / [`set_client_name(Option<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_client_name): <p>The client name from the update user pool client request.</p>
    ///   - [`refresh_token_validity(i32)`](crate::client::fluent_builders::UpdateUserPoolClient::refresh_token_validity) / [`set_refresh_token_validity(i32)`](crate::client::fluent_builders::UpdateUserPoolClient::set_refresh_token_validity): <p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>
    ///   - [`access_token_validity(i32)`](crate::client::fluent_builders::UpdateUserPoolClient::access_token_validity) / [`set_access_token_validity(Option<i32>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_access_token_validity): <p>The time limit, after which the access token is no longer valid and cannot be used.</p>
    ///   - [`id_token_validity(i32)`](crate::client::fluent_builders::UpdateUserPoolClient::id_token_validity) / [`set_id_token_validity(Option<i32>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_id_token_validity): <p>The time limit, after which the ID token is no longer valid and cannot be used.</p>
    ///   - [`token_validity_units(TokenValidityUnitsType)`](crate::client::fluent_builders::UpdateUserPoolClient::token_validity_units) / [`set_token_validity_units(Option<TokenValidityUnitsType>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_token_validity_units): <p>The units in which the validity times are represented in. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
    ///   - [`read_attributes(Vec<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::read_attributes) / [`set_read_attributes(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_read_attributes): <p>The read-only attributes of the user pool.</p>
    ///   - [`write_attributes(Vec<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::write_attributes) / [`set_write_attributes(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_write_attributes): <p>The writeable attributes of the user pool.</p>
    ///   - [`explicit_auth_flows(Vec<ExplicitAuthFlowsType>)`](crate::client::fluent_builders::UpdateUserPoolClient::explicit_auth_flows) / [`set_explicit_auth_flows(Option<Vec<ExplicitAuthFlowsType>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_explicit_auth_flows): <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.</p>  <p>Valid values include:</p>  <ul>   <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote Password protocol) protocol to verify passwords.</p> </li>   <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>   <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>   <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.</p> </li>   <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>  </ul>
    ///   - [`supported_identity_providers(Vec<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::supported_identity_providers) / [`set_supported_identity_providers(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_supported_identity_providers): <p>A list of provider names for the identity providers that are supported on this client.</p>
    ///   - [`callback_ur_ls(Vec<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::callback_ur_ls) / [`set_callback_ur_ls(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_callback_ur_ls): <p>A list of allowed redirect (callback) URLs for the identity providers.</p>  <p>A redirect URI must:</p>  <ul>   <li> <p>Be an absolute URI.</p> </li>   <li> <p>Be registered with the authorization server.</p> </li>   <li> <p>Not include a fragment component.</p> </li>  </ul>  <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>  <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>  <p>App callback URLs such as myapp://example are also supported.</p>
    ///   - [`logout_ur_ls(Vec<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::logout_ur_ls) / [`set_logout_ur_ls(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_logout_ur_ls): <p>A list of allowed logout URLs for the identity providers.</p>
    ///   - [`default_redirect_uri(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::default_redirect_uri) / [`set_default_redirect_uri(Option<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_default_redirect_uri): <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>  <p>A redirect URI must:</p>  <ul>   <li> <p>Be an absolute URI.</p> </li>   <li> <p>Be registered with the authorization server.</p> </li>   <li> <p>Not include a fragment component.</p> </li>  </ul>  <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>  <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>  <p>App callback URLs such as myapp://example are also supported.</p>
    ///   - [`allowed_o_auth_flows(Vec<OAuthFlowType>)`](crate::client::fluent_builders::UpdateUserPoolClient::allowed_o_auth_flows) / [`set_allowed_o_auth_flows(Option<Vec<OAuthFlowType>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_allowed_o_auth_flows): <p>The allowed OAuth flows.</p>  <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>  <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>  <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
    ///   - [`allowed_o_auth_scopes(Vec<String>)`](crate::client::fluent_builders::UpdateUserPoolClient::allowed_o_auth_scopes) / [`set_allowed_o_auth_scopes(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_allowed_o_auth_scopes): <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
    ///   - [`allowed_o_auth_flows_user_pool_client(bool)`](crate::client::fluent_builders::UpdateUserPoolClient::allowed_o_auth_flows_user_pool_client) / [`set_allowed_o_auth_flows_user_pool_client(bool)`](crate::client::fluent_builders::UpdateUserPoolClient::set_allowed_o_auth_flows_user_pool_client): <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>
    ///   - [`analytics_configuration(AnalyticsConfigurationType)`](crate::client::fluent_builders::UpdateUserPoolClient::analytics_configuration) / [`set_analytics_configuration(Option<AnalyticsConfigurationType>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_analytics_configuration): <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>   <p>In regions where Pinpoint is not available, Cognito User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In regions where Pinpoint is available, Cognito User Pools will support sending events to Amazon Pinpoint projects within that same region. </p>  </note>
    ///   - [`prevent_user_existence_errors(PreventUserExistenceErrorTypes)`](crate::client::fluent_builders::UpdateUserPoolClient::prevent_user_existence_errors) / [`set_prevent_user_existence_errors(Option<PreventUserExistenceErrorTypes>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_prevent_user_existence_errors): <p>Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>  <p>Valid values include:</p>  <ul>   <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>   <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not prevented.</p> </li>  </ul> <note>   <p>After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code> for newly created user pool clients if no value is provided.</p>  </note>
    ///   - [`enable_token_revocation(bool)`](crate::client::fluent_builders::UpdateUserPoolClient::enable_token_revocation) / [`set_enable_token_revocation(Option<bool>)`](crate::client::fluent_builders::UpdateUserPoolClient::set_enable_token_revocation): <p>Enables or disables token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
    /// - On success, responds with [`UpdateUserPoolClientOutput`](crate::output::UpdateUserPoolClientOutput) with field(s):
    ///   - [`user_pool_client(Option<UserPoolClientType>)`](crate::output::UpdateUserPoolClientOutput::user_pool_client): <p>The user pool client value from the response from the server when an update user pool client request is made.</p>
    /// - On failure, responds with [`SdkError<UpdateUserPoolClientError>`](crate::error::UpdateUserPoolClientError)
    pub fn update_user_pool_client(&self) -> fluent_builders::UpdateUserPoolClient<C, M, R> {
        fluent_builders::UpdateUserPoolClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserPoolDomain`](crate::client::fluent_builders::UpdateUserPoolDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPoolDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::UpdateUserPoolDomain::set_domain): <p>The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. For example: <code>auth.example.com</code>. </p>  <p>This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the first or last character. Use periods to separate subdomain names.</p>
    ///   - [`user_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPoolDomain::user_pool_id) / [`set_user_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateUserPoolDomain::set_user_pool_id): <p>The ID of the user pool that is associated with the custom domain that you are updating the certificate for.</p>
    ///   - [`custom_domain_config(CustomDomainConfigType)`](crate::client::fluent_builders::UpdateUserPoolDomain::custom_domain_config) / [`set_custom_domain_config(Option<CustomDomainConfigType>)`](crate::client::fluent_builders::UpdateUserPoolDomain::set_custom_domain_config): <p>The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this object to specify an SSL certificate that is managed by ACM.</p>
    /// - On success, responds with [`UpdateUserPoolDomainOutput`](crate::output::UpdateUserPoolDomainOutput) with field(s):
    ///   - [`cloud_front_domain(Option<String>)`](crate::output::UpdateUserPoolDomainOutput::cloud_front_domain): <p>The Amazon CloudFront endpoint that Amazon Cognito set up when you added the custom domain to your user pool.</p>
    /// - On failure, responds with [`SdkError<UpdateUserPoolDomainError>`](crate::error::UpdateUserPoolDomainError)
    pub fn update_user_pool_domain(&self) -> fluent_builders::UpdateUserPoolDomain<C, M, R> {
        fluent_builders::UpdateUserPoolDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifySoftwareToken`](crate::client::fluent_builders::VerifySoftwareToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::VerifySoftwareToken::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::VerifySoftwareToken::set_access_token): <p>The access token.</p>
    ///   - [`session(impl Into<String>)`](crate::client::fluent_builders::VerifySoftwareToken::session) / [`set_session(Option<String>)`](crate::client::fluent_builders::VerifySoftwareToken::set_session): <p>The session which should be passed both ways in challenge-response calls to the service.</p>
    ///   - [`user_code(impl Into<String>)`](crate::client::fluent_builders::VerifySoftwareToken::user_code) / [`set_user_code(Option<String>)`](crate::client::fluent_builders::VerifySoftwareToken::set_user_code): <p>The one time password computed using the secret code returned by <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html">AssociateSoftwareToken"</a>.</p>
    ///   - [`friendly_device_name(impl Into<String>)`](crate::client::fluent_builders::VerifySoftwareToken::friendly_device_name) / [`set_friendly_device_name(Option<String>)`](crate::client::fluent_builders::VerifySoftwareToken::set_friendly_device_name): <p>The friendly device name.</p>
    /// - On success, responds with [`VerifySoftwareTokenOutput`](crate::output::VerifySoftwareTokenOutput) with field(s):
    ///   - [`status(Option<VerifySoftwareTokenResponseType>)`](crate::output::VerifySoftwareTokenOutput::status): <p>The status of the verify software token.</p>
    ///   - [`session(Option<String>)`](crate::output::VerifySoftwareTokenOutput::session): <p>The session which should be passed both ways in challenge-response calls to the service.</p>
    /// - On failure, responds with [`SdkError<VerifySoftwareTokenError>`](crate::error::VerifySoftwareTokenError)
    pub fn verify_software_token(&self) -> fluent_builders::VerifySoftwareToken<C, M, R> {
        fluent_builders::VerifySoftwareToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifyUserAttribute`](crate::client::fluent_builders::VerifyUserAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_token(impl Into<String>)`](crate::client::fluent_builders::VerifyUserAttribute::access_token) / [`set_access_token(Option<String>)`](crate::client::fluent_builders::VerifyUserAttribute::set_access_token): <p>Represents the access token of the request to verify user attributes.</p>
    ///   - [`attribute_name(impl Into<String>)`](crate::client::fluent_builders::VerifyUserAttribute::attribute_name) / [`set_attribute_name(Option<String>)`](crate::client::fluent_builders::VerifyUserAttribute::set_attribute_name): <p>The attribute name in the request to verify user attributes.</p>
    ///   - [`code(impl Into<String>)`](crate::client::fluent_builders::VerifyUserAttribute::code) / [`set_code(Option<String>)`](crate::client::fluent_builders::VerifyUserAttribute::set_code): <p>The verification code in the request to verify user attributes.</p>
    /// - On success, responds with [`VerifyUserAttributeOutput`](crate::output::VerifyUserAttributeOutput)

    /// - On failure, responds with [`SdkError<VerifyUserAttributeError>`](crate::error::VerifyUserAttributeError)
    pub fn verify_user_attribute(&self) -> fluent_builders::VerifyUserAttribute<C, M, R> {
        fluent_builders::VerifyUserAttribute::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddCustomAttributes`.
    ///
    /// <p>Adds additional user attributes to the user pool schema.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddCustomAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_custom_attributes_input::Builder,
    }
    impl<C, M, R> AddCustomAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddCustomAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddCustomAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddCustomAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddCustomAttributesInputOperationOutputAlias,
                crate::output::AddCustomAttributesOutput,
                crate::error::AddCustomAttributesError,
                crate::input::AddCustomAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to add custom attributes.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to add custom attributes.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// Appends an item to `CustomAttributes`.
        ///
        /// To override the contents of this collection use [`set_custom_attributes`](Self::set_custom_attributes).
        ///
        /// <p>An array of custom attributes, such as Mutable and Name.</p>
        pub fn custom_attributes(mut self, input: crate::model::SchemaAttributeType) -> Self {
            self.inner = self.inner.custom_attributes(input);
            self
        }
        /// <p>An array of custom attributes, such as Mutable and Name.</p>
        pub fn set_custom_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_custom_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminAddUserToGroup`.
    ///
    /// <p>Adds the specified user to the specified group.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminAddUserToGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_add_user_to_group_input::Builder,
    }
    impl<C, M, R> AdminAddUserToGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminAddUserToGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminAddUserToGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminAddUserToGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminAddUserToGroupInputOperationOutputAlias,
                crate::output::AdminAddUserToGroupOutput,
                crate::error::AdminAddUserToGroupError,
                crate::input::AdminAddUserToGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The username for the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username for the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The group name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The group name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminConfirmSignUp`.
    ///
    /// <p>Confirms user registration as an admin without using a confirmation code. Works on any user.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminConfirmSignUp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_confirm_sign_up_input::Builder,
    }
    impl<C, M, R> AdminConfirmSignUp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminConfirmSignUp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminConfirmSignUpOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminConfirmSignUpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminConfirmSignUpInputOperationOutputAlias,
                crate::output::AdminConfirmSignUpOutput,
                crate::error::AdminConfirmSignUpError,
                crate::input::AdminConfirmSignUpInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for which you want to confirm user registration.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for which you want to confirm user registration.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name for which you want to confirm user registration.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name for which you want to confirm user registration.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the <code>clientMetadata</code> attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the <code>clientMetadata</code> attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminCreateUser`.
    ///
    /// <p>Creates a new user in the specified user pool.</p>
    /// <p>If <code>MessageAction</code> is not set, the default is to send a welcome message via email or phone (SMS).</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    /// <p>This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.</p>
    /// <p>Alternatively, you can call <code>AdminCreateUser</code> with “SUPPRESS” for the <code>MessageAction</code> parameter, and Amazon Cognito will not send any email. </p>
    /// <p>In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change their password.</p>
    /// <p> <code>AdminCreateUser</code> requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminCreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_create_user_input::Builder,
    }
    impl<C, M, R> AdminCreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminCreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminCreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminCreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminCreateUserInputOperationOutputAlias,
                crate::output::AdminCreateUserOutput,
                crate::error::AdminCreateUserError,
                crate::input::AdminCreateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where the user will be created.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where the user will be created.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// Appends an item to `UserAttributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (when creating a user pool or in the <b>Attributes</b> tab of the console) must be supplied either by you (in your call to <code>AdminCreateUser</code>) or by the user (when he or she signs up in response to your welcome message).</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        /// <p>To send a message inviting the user to sign up, you must specify the user's email address or phone number. This can be done in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p>
        /// <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. (You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.)</p>
        /// <ul>
        /// <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// </ul>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            self.inner = self.inner.user_attributes(input);
            self
        }
        /// <p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (when creating a user pool or in the <b>Attributes</b> tab of the console) must be supplied either by you (in your call to <code>AdminCreateUser</code>) or by the user (when he or she signs up in response to your welcome message).</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        /// <p>To send a message inviting the user to sign up, you must specify the user's email address or phone number. This can be done in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p>
        /// <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. (You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.)</p>
        /// <ul>
        /// <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// </ul>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_user_attributes(input);
            self
        }
        /// Appends an item to `ValidationData`.
        ///
        /// To override the contents of this collection use [`set_validation_data`](Self::set_validation_data).
        ///
        /// <p>The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.</p>
        /// <p>To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.</p>
        /// <p>The user's validation data is not persisted.</p>
        pub fn validation_data(mut self, input: crate::model::AttributeType) -> Self {
            self.inner = self.inner.validation_data(input);
            self
        }
        /// <p>The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.</p>
        /// <p>To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.</p>
        /// <p>The user's validation data is not persisted.</p>
        pub fn set_validation_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_validation_data(input);
            self
        }
        /// <p>The user's temporary password. This password must conform to the password policy that you specified when you created the user pool.</p>
        /// <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page along with a new password to be used in all future sign-ins.</p>
        /// <p>This parameter is not required. If you do not specify a value, Amazon Cognito generates one for you.</p>
        /// <p>The temporary password can only be used until the user account expiration limit that you specified when you created the user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter.</p>
        pub fn temporary_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.temporary_password(input.into());
            self
        }
        /// <p>The user's temporary password. This password must conform to the password policy that you specified when you created the user pool.</p>
        /// <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page along with a new password to be used in all future sign-ins.</p>
        /// <p>This parameter is not required. If you do not specify a value, Amazon Cognito generates one for you.</p>
        /// <p>The temporary password can only be used until the user account expiration limit that you specified when you created the user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter.</p>
        pub fn set_temporary_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_temporary_password(input);
            self
        }
        /// <p>This parameter is only used if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p>
        /// <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p>
        /// <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>
        pub fn force_alias_creation(mut self, input: bool) -> Self {
            self.inner = self.inner.force_alias_creation(input);
            self
        }
        /// <p>This parameter is only used if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p>
        /// <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p>
        /// <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>
        pub fn set_force_alias_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_alias_creation(input);
            self
        }
        /// <p>Set to <code>"RESEND"</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to <code>"SUPPRESS"</code> to suppress sending the message. Only one value can be specified.</p>
        pub fn message_action(mut self, input: crate::model::MessageActionType) -> Self {
            self.inner = self.inner.message_action(input);
            self
        }
        /// <p>Set to <code>"RESEND"</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to <code>"SUPPRESS"</code> to suppress sending the message. Only one value can be specified.</p>
        pub fn set_message_action(
            mut self,
            input: std::option::Option<crate::model::MessageActionType>,
        ) -> Self {
            self.inner = self.inner.set_message_action(input);
            self
        }
        /// Appends an item to `DesiredDeliveryMediums`.
        ///
        /// To override the contents of this collection use [`set_desired_delivery_mediums`](Self::set_desired_delivery_mediums).
        ///
        /// <p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. More than one value can be specified.</p>
        pub fn desired_delivery_mediums(mut self, input: crate::model::DeliveryMediumType) -> Self {
            self.inner = self.inner.desired_delivery_mediums(input);
            self
        }
        /// <p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. More than one value can be specified.</p>
        pub fn set_desired_delivery_mediums(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeliveryMediumType>>,
        ) -> Self {
            self.inner = self.inner.set_desired_delivery_mediums(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the <i>pre sign-up</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the <i>pre sign-up</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminDeleteUser`.
    ///
    /// <p>Deletes a user as an administrator. Works on any user.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminDeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_delete_user_input::Builder,
    }
    impl<C, M, R> AdminDeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminDeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminDeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminDeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminDeleteUserInputOperationOutputAlias,
                crate::output::AdminDeleteUserOutput,
                crate::error::AdminDeleteUserError,
                crate::input::AdminDeleteUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to delete the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to delete the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user you wish to delete.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user you wish to delete.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminDeleteUserAttributes`.
    ///
    /// <p>Deletes the user attributes in a user pool as an administrator. Works on any user.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminDeleteUserAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_delete_user_attributes_input::Builder,
    }
    impl<C, M, R> AdminDeleteUserAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminDeleteUserAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminDeleteUserAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminDeleteUserAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminDeleteUserAttributesInputOperationOutputAlias,
                crate::output::AdminDeleteUserAttributesOutput,
                crate::error::AdminDeleteUserAttributesError,
                crate::input::AdminDeleteUserAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to delete user attributes.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to delete user attributes.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user from which you would like to delete attributes.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user from which you would like to delete attributes.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// Appends an item to `UserAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_user_attribute_names`](Self::set_user_attribute_names).
        ///
        /// <p>An array of strings representing the user attribute names you wish to delete.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_attribute_names(input.into());
            self
        }
        /// <p>An array of strings representing the user attribute names you wish to delete.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminDisableProviderForUser`.
    ///
    /// <p>Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to disable is a Cognito User Pools native username + password user, they are not permitted to use their password to sign-in. If the user to disable is a linked external IdP user, any link between that user and an existing user is removed. The next time the external user (no longer attached to the previously linked <code>DestinationUser</code>) signs in, they must create a new user account. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a>.</p>
    /// <p>This action is enabled only for admin access and requires developer credentials.</p>
    /// <p>The <code>ProviderName</code> must match the value specified when creating an IdP for the pool. </p>
    /// <p>To disable a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code> and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>, with the <code>ProviderAttributeValue</code> being the name that is used in the user pool for the user.</p>
    /// <p>The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers. The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally linked as a source user.</p>
    /// <p>For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign-in, the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were used for the <code>SourceUser</code> when the identities were originally linked using <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code> must be the subject of the SAML assertion.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminDisableProviderForUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_disable_provider_for_user_input::Builder,
    }
    impl<C, M, R> AdminDisableProviderForUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminDisableProviderForUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminDisableProviderForUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminDisableProviderForUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminDisableProviderForUserInputOperationOutputAlias,
                crate::output::AdminDisableProviderForUserOutput,
                crate::error::AdminDisableProviderForUserError,
                crate::input::AdminDisableProviderForUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user to be disabled.</p>
        pub fn user(mut self, input: crate::model::ProviderUserIdentifierType) -> Self {
            self.inner = self.inner.user(input);
            self
        }
        /// <p>The user to be disabled.</p>
        pub fn set_user(
            mut self,
            input: std::option::Option<crate::model::ProviderUserIdentifierType>,
        ) -> Self {
            self.inner = self.inner.set_user(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminDisableUser`.
    ///
    /// <p>Disables the specified user.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminDisableUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_disable_user_input::Builder,
    }
    impl<C, M, R> AdminDisableUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminDisableUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminDisableUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminDisableUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminDisableUserInputOperationOutputAlias,
                crate::output::AdminDisableUserOutput,
                crate::error::AdminDisableUserError,
                crate::input::AdminDisableUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to disable the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to disable the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user you wish to disable.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user you wish to disable.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminEnableUser`.
    ///
    /// <p>Enables the specified user as an administrator. Works on any user.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminEnableUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_enable_user_input::Builder,
    }
    impl<C, M, R> AdminEnableUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminEnableUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminEnableUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminEnableUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminEnableUserInputOperationOutputAlias,
                crate::output::AdminEnableUserOutput,
                crate::error::AdminEnableUserError,
                crate::input::AdminEnableUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to enable the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to enable the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user you wish to enable.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user you wish to enable.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminForgetDevice`.
    ///
    /// <p>Forgets the device, as an administrator.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminForgetDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_forget_device_input::Builder,
    }
    impl<C, M, R> AdminForgetDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminForgetDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminForgetDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminForgetDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminForgetDeviceInputOperationOutputAlias,
                crate::output::AdminForgetDeviceOutput,
                crate::error::AdminForgetDeviceError,
                crate::input::AdminForgetDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_key(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminGetDevice`.
    ///
    /// <p>Gets the device, as an administrator.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminGetDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_get_device_input::Builder,
    }
    impl<C, M, R> AdminGetDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminGetDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminGetDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminGetDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminGetDeviceInputOperationOutputAlias,
                crate::output::AdminGetDeviceOutput,
                crate::error::AdminGetDeviceError,
                crate::input::AdminGetDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_key(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_key(input);
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminGetUser`.
    ///
    /// <p>Gets the specified user by user name in a user pool as an administrator. Works on any user.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminGetUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_get_user_input::Builder,
    }
    impl<C, M, R> AdminGetUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminGetUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminGetUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminGetUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminGetUserInputOperationOutputAlias,
                crate::output::AdminGetUserOutput,
                crate::error::AdminGetUserError,
                crate::input::AdminGetUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to get information about the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to get information about the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user you wish to retrieve.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user you wish to retrieve.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminInitiateAuth`.
    ///
    /// <p>Initiates the authentication flow, as an administrator.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminInitiateAuth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_initiate_auth_input::Builder,
    }
    impl<C, M, R> AdminInitiateAuth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminInitiateAuth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminInitiateAuthOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminInitiateAuthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminInitiateAuthInputOperationOutputAlias,
                crate::output::AdminInitiateAuthOutput,
                crate::error::AdminInitiateAuthError,
                crate::input::AdminInitiateAuthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The authentication flow for this call to execute. The API action will depend on this value. For example:</p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if the USERNAME is not found in the user pool. </p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>
        /// </ul>
        pub fn auth_flow(mut self, input: crate::model::AuthFlowType) -> Self {
            self.inner = self.inner.auth_flow(input);
            self
        }
        /// <p>The authentication flow for this call to execute. The API action will depend on this value. For example:</p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if the USERNAME is not found in the user pool. </p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>
        /// </ul>
        pub fn set_auth_flow(
            mut self,
            input: std::option::Option<crate::model::AuthFlowType>,
        ) -> Self {
            self.inner = self.inner.set_auth_flow(input);
            self
        }
        /// Adds a key-value pair to `AuthParameters`.
        ///
        /// To override the contents of this collection use [`set_auth_parameters`](Self::set_auth_parameters).
        ///
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>ADMIN_NO_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>PASSWORD</code> (required), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn auth_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auth_parameters(k.into(), v.into());
            self
        }
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>ADMIN_NO_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>PASSWORD</code> (required), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_auth_parameters(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminInitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it does not provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminInitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it does not provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminInitiateAuth</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminInitiateAuth</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn context_data(mut self, input: crate::model::ContextDataType) -> Self {
            self.inner = self.inner.context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_context_data(
            mut self,
            input: std::option::Option<crate::model::ContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_context_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminLinkProviderForUser`.
    ///
    /// <p>Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external identity provider. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in, so that the federated user identity can be used to sign in as the existing user account. </p>
    /// <p> For example, if there is an existing user with a username and password, this API links that user to a federated user identity, so that when the federated user identity is used, the user signs in as the existing user account. </p> <note>
    /// <p>The maximum number of federated identities linked to a user is 5.</p>
    /// </note> <important>
    /// <p>Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external identity providers and provider attributes that have been trusted by the application owner.</p>
    /// </important>
    /// <p>This action is enabled only for admin access and requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminLinkProviderForUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_link_provider_for_user_input::Builder,
    }
    impl<C, M, R> AdminLinkProviderForUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminLinkProviderForUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminLinkProviderForUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminLinkProviderForUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminLinkProviderForUserInputOperationOutputAlias,
                crate::output::AdminLinkProviderForUserOutput,
                crate::error::AdminLinkProviderForUserError,
                crate::input::AdminLinkProviderForUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The existing user in the user pool to be linked to the external identity provider user account. Can be a native (Username + Password) Cognito User Pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, an exception is thrown. This is the user that is returned when the new user (with the linked identity provider attribute) signs in.</p>
        /// <p>For a native username + password user, the <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the provider-specific <code>user_id</code>.</p>
        /// <p>The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.</p>
        /// <p>The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.</p>
        pub fn destination_user(mut self, input: crate::model::ProviderUserIdentifierType) -> Self {
            self.inner = self.inner.destination_user(input);
            self
        }
        /// <p>The existing user in the user pool to be linked to the external identity provider user account. Can be a native (Username + Password) Cognito User Pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, an exception is thrown. This is the user that is returned when the new user (with the linked identity provider attribute) signs in.</p>
        /// <p>For a native username + password user, the <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the provider-specific <code>user_id</code>.</p>
        /// <p>The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.</p>
        /// <p>The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.</p>
        pub fn set_destination_user(
            mut self,
            input: std::option::Option<crate::model::ProviderUserIdentifierType>,
        ) -> Self {
            self.inner = self.inner.set_destination_user(input);
            self
        }
        /// <p>An external identity provider account for a user who does not currently exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p>
        /// <p>If the <code>SourceUser</code> is a federated social identity provider user (Facebook, Google, or Login with Amazon), you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social identity providers, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social identity provider token.</p>
        /// <p></p>
        /// <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. If you wish to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the <code>ProviderAttributeName</code>. If you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Cognito will automatically parse the default unique identifier found in the subject from the SAML token.</p>
        pub fn source_user(mut self, input: crate::model::ProviderUserIdentifierType) -> Self {
            self.inner = self.inner.source_user(input);
            self
        }
        /// <p>An external identity provider account for a user who does not currently exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p>
        /// <p>If the <code>SourceUser</code> is a federated social identity provider user (Facebook, Google, or Login with Amazon), you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social identity providers, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social identity provider token.</p>
        /// <p></p>
        /// <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. If you wish to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the <code>ProviderAttributeName</code>. If you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Cognito will automatically parse the default unique identifier found in the subject from the SAML token.</p>
        pub fn set_source_user(
            mut self,
            input: std::option::Option<crate::model::ProviderUserIdentifierType>,
        ) -> Self {
            self.inner = self.inner.set_source_user(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminListDevices`.
    ///
    /// <p>Lists devices, as an administrator.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminListDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_list_devices_input::Builder,
    }
    impl<C, M, R> AdminListDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminListDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminListDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminListDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminListDevicesInputOperationOutputAlias,
                crate::output::AdminListDevicesOutput,
                crate::error::AdminListDevicesError,
                crate::input::AdminListDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The limit of the devices request.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The limit of the devices request.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The pagination token.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pagination_token(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pagination_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminListGroupsForUser`.
    ///
    /// <p>Lists the groups that the user belongs to.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminListGroupsForUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_list_groups_for_user_input::Builder,
    }
    impl<C, M, R> AdminListGroupsForUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminListGroupsForUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminListGroupsForUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminListGroupsForUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminListGroupsForUserInputOperationOutputAlias,
                crate::output::AdminListGroupsForUserOutput,
                crate::error::AdminListGroupsForUserError,
                crate::input::AdminListGroupsForUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::AdminListGroupsForUserPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::AdminListGroupsForUserPaginator<C, M, R> {
            crate::paginator::AdminListGroupsForUserPaginator::new(self.handle, self.inner)
        }
        /// <p>The username for the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username for the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminListUserAuthEvents`.
    ///
    /// <p>Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminListUserAuthEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_list_user_auth_events_input::Builder,
    }
    impl<C, M, R> AdminListUserAuthEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminListUserAuthEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminListUserAuthEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminListUserAuthEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminListUserAuthEventsInputOperationOutputAlias,
                crate::output::AdminListUserAuthEventsOutput,
                crate::error::AdminListUserAuthEventsError,
                crate::input::AdminListUserAuthEventsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::AdminListUserAuthEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::AdminListUserAuthEventsPaginator<C, M, R> {
            crate::paginator::AdminListUserAuthEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user pool username or an alias.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user pool username or an alias.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The maximum number of authentication events to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of authentication events to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminRemoveUserFromGroup`.
    ///
    /// <p>Removes the specified user from the specified group.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminRemoveUserFromGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_remove_user_from_group_input::Builder,
    }
    impl<C, M, R> AdminRemoveUserFromGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminRemoveUserFromGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminRemoveUserFromGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminRemoveUserFromGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminRemoveUserFromGroupInputOperationOutputAlias,
                crate::output::AdminRemoveUserFromGroupOutput,
                crate::error::AdminRemoveUserFromGroupError,
                crate::input::AdminRemoveUserFromGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The username for the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username for the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The group name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The group name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminResetUserPassword`.
    ///
    /// <p>Resets the specified user's password in a user pool as an administrator. Works on any user.</p>
    /// <p>When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminResetUserPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_reset_user_password_input::Builder,
    }
    impl<C, M, R> AdminResetUserPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminResetUserPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminResetUserPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminResetUserPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminResetUserPasswordInputOperationOutputAlias,
                crate::output::AdminResetUserPasswordOutput,
                crate::error::AdminResetUserPasswordError,
                crate::input::AdminResetUserPasswordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to reset the user's password.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to reset the user's password.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user whose password you wish to reset.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user whose password you wish to reset.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminRespondToAuthChallenge`.
    ///
    /// <p>Responds to an authentication challenge, as an administrator.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminRespondToAuthChallenge<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_respond_to_auth_challenge_input::Builder,
    }
    impl<C, M, R> AdminRespondToAuthChallenge<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminRespondToAuthChallenge`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminRespondToAuthChallengeOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminRespondToAuthChallengeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminRespondToAuthChallengeInputOperationOutputAlias,
                crate::output::AdminRespondToAuthChallengeOutput,
                crate::error::AdminRespondToAuthChallengeError,
                crate::input::AdminRespondToAuthChallengeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.inner = self.inner.challenge_name(input);
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.inner = self.inner.set_challenge_name(input);
            self
        }
        /// Adds a key-value pair to `ChallengeResponses`.
        ///
        /// To override the contents of this collection use [`set_challenge_responses`](Self::set_challenge_responses).
        ///
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: <code>PASSWORD</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you need to use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        /// <p>The value of the <code>USERNAME</code> attribute must be the user's actual username, not an alias (such as email address or phone number). To make this easier, the <code>AdminInitiateAuth</code> response includes the actual username value in the <code>USERNAMEUSER_ID_FOR_SRP</code> attribute, even if you specified an alias in your call to <code>AdminInitiateAuth</code>.</p>
        pub fn challenge_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.challenge_responses(k.into(), v.into());
            self
        }
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: <code>PASSWORD</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you need to use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        /// <p>The value of the <code>USERNAME</code> attribute must be the user's actual username, not an alias (such as email address or phone number). To make this easier, the <code>AdminInitiateAuth</code> response includes the actual username value in the <code>USERNAMEUSER_ID_FOR_SRP</code> attribute, even if you specified an alias in your call to <code>AdminInitiateAuth</code>.</p>
        pub fn set_challenge_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_challenge_responses(input);
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session(input.into());
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session(input);
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminRespondToAuthChallenge</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminRespondToAuthChallenge</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn context_data(mut self, input: crate::model::ContextDataType) -> Self {
            self.inner = self.inner.context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_context_data(
            mut self,
            input: std::option::Option<crate::model::ContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_context_data(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, <i>post authentication</i>, <i>user migration</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge response</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, <i>post authentication</i>, <i>user migration</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge response</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminSetUserMFAPreference`.
    ///
    /// <p>Sets the user's multi-factor authentication (MFA) preference, including which MFA options are enabled and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are enabled. If multiple options are enabled and no preference is set, a challenge to choose an MFA option will be returned during sign in.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminSetUserMFAPreference<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_set_user_mfa_preference_input::Builder,
    }
    impl<C, M, R> AdminSetUserMFAPreference<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminSetUserMFAPreference`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminSetUserMfaPreferenceOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminSetUserMFAPreferenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminSetUserMfaPreferenceInputOperationOutputAlias,
                crate::output::AdminSetUserMfaPreferenceOutput,
                crate::error::AdminSetUserMFAPreferenceError,
                crate::input::AdminSetUserMfaPreferenceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SMS text message MFA settings.</p>
        pub fn sms_mfa_settings(mut self, input: crate::model::SmsMfaSettingsType) -> Self {
            self.inner = self.inner.sms_mfa_settings(input);
            self
        }
        /// <p>The SMS text message MFA settings.</p>
        pub fn set_sms_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SmsMfaSettingsType>,
        ) -> Self {
            self.inner = self.inner.set_sms_mfa_settings(input);
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn software_token_mfa_settings(
            mut self,
            input: crate::model::SoftwareTokenMfaSettingsType,
        ) -> Self {
            self.inner = self.inner.software_token_mfa_settings(input);
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn set_software_token_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaSettingsType>,
        ) -> Self {
            self.inner = self.inner.set_software_token_mfa_settings(input);
            self
        }
        /// <p>The user pool username or alias.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user pool username or alias.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminSetUserPassword`.
    ///
    /// <p>Sets the specified user's password in a user pool as an administrator. Works on any user. </p>
    /// <p>The password can be temporary or permanent. If it is temporary, the user status will be placed into the <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user does not sign in before it expires, the user will not be able to sign in and their password will need to be reset by an administrator. </p>
    /// <p>Once the user has set a new password, or the password is permanent, the user status will be set to <code>Confirmed</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminSetUserPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_set_user_password_input::Builder,
    }
    impl<C, M, R> AdminSetUserPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminSetUserPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminSetUserPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminSetUserPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminSetUserPasswordInputOperationOutputAlias,
                crate::output::AdminSetUserPasswordOutput,
                crate::error::AdminSetUserPasswordError,
                crate::input::AdminSetUserPasswordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to set the user's password.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to set the user's password.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user whose password you wish to set.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user whose password you wish to set.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password for the user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p> <code>True</code> if the password is permanent, <code>False</code> if it is temporary.</p>
        pub fn permanent(mut self, input: bool) -> Self {
            self.inner = self.inner.permanent(input);
            self
        }
        /// <p> <code>True</code> if the password is permanent, <code>False</code> if it is temporary.</p>
        pub fn set_permanent(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_permanent(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminSetUserSettings`.
    ///
    /// <p> <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to configure TOTP software token MFA. To configure either type of MFA, use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html">AdminSetUserMFAPreference</a> instead.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminSetUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_set_user_settings_input::Builder,
    }
    impl<C, M, R> AdminSetUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminSetUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminSetUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminSetUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminSetUserSettingsInputOperationOutputAlias,
                crate::output::AdminSetUserSettingsOutput,
                crate::error::AdminSetUserSettingsError,
                crate::input::AdminSetUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user pool that contains the user that you are setting options for.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The ID of the user pool that contains the user that you are setting options for.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user that you are setting options for.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user that you are setting options for.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// Appends an item to `MFAOptions`.
        ///
        /// To override the contents of this collection use [`set_mfa_options`](Self::set_mfa_options).
        ///
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn mfa_options(mut self, input: crate::model::MfaOptionType) -> Self {
            self.inner = self.inner.mfa_options(input);
            self
        }
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn set_mfa_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        ) -> Self {
            self.inner = self.inner.set_mfa_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminUpdateAuthEventFeedback`.
    ///
    /// <p>Provides feedback for an authentication event as to whether it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminUpdateAuthEventFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_update_auth_event_feedback_input::Builder,
    }
    impl<C, M, R> AdminUpdateAuthEventFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminUpdateAuthEventFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminUpdateAuthEventFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminUpdateAuthEventFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminUpdateAuthEventFeedbackInputOperationOutputAlias,
                crate::output::AdminUpdateAuthEventFeedbackOutput,
                crate::error::AdminUpdateAuthEventFeedbackError,
                crate::input::AdminUpdateAuthEventFeedbackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user pool username.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user pool username.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The authentication event ID.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p>The authentication event ID.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn feedback_value(mut self, input: crate::model::FeedbackValueType) -> Self {
            self.inner = self.inner.feedback_value(input);
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn set_feedback_value(
            mut self,
            input: std::option::Option<crate::model::FeedbackValueType>,
        ) -> Self {
            self.inner = self.inner.set_feedback_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminUpdateDeviceStatus`.
    ///
    /// <p>Updates the device status as an administrator.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminUpdateDeviceStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_update_device_status_input::Builder,
    }
    impl<C, M, R> AdminUpdateDeviceStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminUpdateDeviceStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminUpdateDeviceStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminUpdateDeviceStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminUpdateDeviceStatusInputOperationOutputAlias,
                crate::output::AdminUpdateDeviceStatusOutput,
                crate::error::AdminUpdateDeviceStatusError,
                crate::input::AdminUpdateDeviceStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_key(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_key(input);
            self
        }
        /// <p>The status indicating whether a device has been remembered or not.</p>
        pub fn device_remembered_status(
            mut self,
            input: crate::model::DeviceRememberedStatusType,
        ) -> Self {
            self.inner = self.inner.device_remembered_status(input);
            self
        }
        /// <p>The status indicating whether a device has been remembered or not.</p>
        pub fn set_device_remembered_status(
            mut self,
            input: std::option::Option<crate::model::DeviceRememberedStatusType>,
        ) -> Self {
            self.inner = self.inner.set_device_remembered_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminUpdateUserAttributes`.
    ///
    /// <p>Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.</p>
    /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    /// <p>In addition to updating user attributes, this API can also be used to mark phone and email as verified.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminUpdateUserAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_update_user_attributes_input::Builder,
    }
    impl<C, M, R> AdminUpdateUserAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminUpdateUserAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminUpdateUserAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminUpdateUserAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminUpdateUserAttributesInputOperationOutputAlias,
                crate::output::AdminUpdateUserAttributesOutput,
                crate::error::AdminUpdateUserAttributesError,
                crate::input::AdminUpdateUserAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to update user attributes.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to update user attributes.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name of the user for whom you want to update user attributes.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user for whom you want to update user attributes.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// Appends an item to `UserAttributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            self.inner = self.inner.user_attributes(input);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_user_attributes(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdminUserGlobalSignOut`.
    ///
    /// <p>Signs out users from all devices, as an administrator. It also invalidates all refresh tokens issued to a user. The user's current access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour after they are issued.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdminUserGlobalSignOut<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::admin_user_global_sign_out_input::Builder,
    }
    impl<C, M, R> AdminUserGlobalSignOut<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdminUserGlobalSignOut`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdminUserGlobalSignOutOutput,
            aws_smithy_http::result::SdkError<crate::error::AdminUserGlobalSignOutError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdminUserGlobalSignOutInputOperationOutputAlias,
                crate::output::AdminUserGlobalSignOutOutput,
                crate::error::AdminUserGlobalSignOutError,
                crate::input::AdminUserGlobalSignOutInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSoftwareToken`.
    ///
    /// <p>Returns a unique generated shared secret key code for the user account. The request takes an access token or a session string, but not both.</p> <note>
    /// <p>Calling AssociateSoftwareToken immediately disassociates the existing software token from the user account. If the user doesn't subsequently verify the software token, their account is essentially set up to authenticate without MFA. If MFA config is set to Optional at the user pool level, the user can then login without MFA. However, if MFA is set to Required for the user pool, the user will be asked to setup a new software token MFA during sign in.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateSoftwareToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_software_token_input::Builder,
    }
    impl<C, M, R> AssociateSoftwareToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSoftwareToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSoftwareTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSoftwareTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSoftwareTokenInputOperationOutputAlias,
                crate::output::AssociateSoftwareTokenOutput,
                crate::error::AssociateSoftwareTokenError,
                crate::input::AssociateSoftwareTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session(input.into());
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangePassword`.
    ///
    /// <p>Changes the password for a specified user in a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ChangePassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::change_password_input::Builder,
    }
    impl<C, M, R> ChangePassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChangePassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangePasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangePasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChangePasswordInputOperationOutputAlias,
                crate::output::ChangePasswordOutput,
                crate::error::ChangePasswordError,
                crate::input::ChangePasswordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The old password.</p>
        pub fn previous_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.previous_password(input.into());
            self
        }
        /// <p>The old password.</p>
        pub fn set_previous_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_previous_password(input);
            self
        }
        /// <p>The new password.</p>
        pub fn proposed_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposed_password(input.into());
            self
        }
        /// <p>The new password.</p>
        pub fn set_proposed_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proposed_password(input);
            self
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmDevice`.
    ///
    /// <p>Confirms tracking of the device. This API call is the call that begins device tracking.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_device_input::Builder,
    }
    impl<C, M, R> ConfirmDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmDeviceInputOperationOutputAlias,
                crate::output::ConfirmDeviceOutput,
                crate::error::ConfirmDeviceError,
                crate::input::ConfirmDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_key(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_key(input);
            self
        }
        /// <p>The configuration of the device secret verifier.</p>
        pub fn device_secret_verifier_config(
            mut self,
            input: crate::model::DeviceSecretVerifierConfigType,
        ) -> Self {
            self.inner = self.inner.device_secret_verifier_config(input);
            self
        }
        /// <p>The configuration of the device secret verifier.</p>
        pub fn set_device_secret_verifier_config(
            mut self,
            input: std::option::Option<crate::model::DeviceSecretVerifierConfigType>,
        ) -> Self {
            self.inner = self.inner.set_device_secret_verifier_config(input);
            self
        }
        /// <p>The device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(input.into());
            self
        }
        /// <p>The device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmForgotPassword`.
    ///
    /// <p>Allows a user to enter a confirmation code to reset a forgotten password.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmForgotPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_forgot_password_input::Builder,
    }
    impl<C, M, R> ConfirmForgotPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmForgotPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmForgotPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmForgotPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmForgotPasswordInputOperationOutputAlias,
                crate::output::ConfirmForgotPasswordOutput,
                crate::error::ConfirmForgotPasswordError,
                crate::input::ConfirmForgotPasswordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_hash(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_hash(input);
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to retrieve a forgotten password.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to retrieve a forgotten password.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The confirmation code sent by a user's request to retrieve a forgotten password. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html">ForgotPassword</a>.</p>
        pub fn confirmation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.confirmation_code(input.into());
            self
        }
        /// <p>The confirmation code sent by a user's request to retrieve a forgotten password. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html">ForgotPassword</a>.</p>
        pub fn set_confirmation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_confirmation_code(input);
            self
        }
        /// <p>The password sent by a user's request to retrieve a forgotten password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password sent by a user's request to retrieve a forgotten password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmForgotPassword</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmForgotPassword</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.inner = self.inner.user_context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_user_context_data(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmSignUp`.
    ///
    /// <p>Confirms registration of a user and handles the existing alias from a previous user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmSignUp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_sign_up_input::Builder,
    }
    impl<C, M, R> ConfirmSignUp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmSignUp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmSignUpOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmSignUpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmSignUpInputOperationOutputAlias,
                crate::output::ConfirmSignUpOutput,
                crate::error::ConfirmSignUpError,
                crate::input::ConfirmSignUpInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the app client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The ID of the app client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_hash(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_hash(input);
            self
        }
        /// <p>The user name of the user whose registration you wish to confirm.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user whose registration you wish to confirm.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The confirmation code sent by a user's request to confirm registration.</p>
        pub fn confirmation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.confirmation_code(input.into());
            self
        }
        /// <p>The confirmation code sent by a user's request to confirm registration.</p>
        pub fn set_confirmation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_confirmation_code(input);
            self
        }
        /// <p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>
        pub fn force_alias_creation(mut self, input: bool) -> Self {
            self.inner = self.inner.force_alias_creation(input);
            self
        }
        /// <p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>
        pub fn set_force_alias_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_alias_creation(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmSignUp</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmSignUp</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.inner = self.inner.user_context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_user_context_data(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a new group in the specified user pool.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group. Must be unique.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group. Must be unique.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>A string containing the description of the group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A string containing the description of the group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The role ARN for the group.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The role ARN for the group.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A nonnegative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN will be used in the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the user's tokens.</p>
        /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim is not set in users' tokens.</p>
        /// <p>The default <code>Precedence</code> value is null.</p>
        pub fn precedence(mut self, input: i32) -> Self {
            self.inner = self.inner.precedence(input);
            self
        }
        /// <p>A nonnegative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN will be used in the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the user's tokens.</p>
        /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim is not set in users' tokens.</p>
        /// <p>The default <code>Precedence</code> value is null.</p>
        pub fn set_precedence(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_precedence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIdentityProvider`.
    ///
    /// <p>Creates an identity provider for a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_identity_provider_input::Builder,
    }
    impl<C, M, R> CreateIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIdentityProviderInputOperationOutputAlias,
                crate::output::CreateIdentityProviderOutput,
                crate::error::CreateIdentityProviderError,
                crate::input::CreateIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn provider_type(mut self, input: crate::model::IdentityProviderTypeType) -> Self {
            self.inner = self.inner.provider_type(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderTypeType>,
        ) -> Self {
            self.inner = self.inner.set_provider_type(input);
            self
        }
        /// Adds a key-value pair to `ProviderDetails`.
        ///
        /// To override the contents of this collection use [`set_provider_details`](Self::set_provider_details).
        ///
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>api_version</p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>team_id</p> </li>
        /// <li> <p>key_id</p> </li>
        /// <li> <p>private_key</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>attributes_request_method</p> </li>
        /// <li> <p>oidc_issuer</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p>MetadataFile OR MetadataURL</p> </li>
        /// <li> <p>IDPSignout <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.provider_details(k.into(), v.into());
            self
        }
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>api_version</p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>team_id</p> </li>
        /// <li> <p>key_id</p> </li>
        /// <li> <p>private_key</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>attributes_request_method</p> </li>
        /// <li> <p>oidc_issuer</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p>MetadataFile OR MetadataURL</p> </li>
        /// <li> <p>IDPSignout <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_provider_details(input);
            self
        }
        /// Adds a key-value pair to `AttributeMapping`.
        ///
        /// To override the contents of this collection use [`set_attribute_mapping`](Self::set_attribute_mapping).
        ///
        /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
        pub fn attribute_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attribute_mapping(k.into(), v.into());
            self
        }
        /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
        pub fn set_attribute_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attribute_mapping(input);
            self
        }
        /// Appends an item to `IdpIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_idp_identifiers`](Self::set_idp_identifiers).
        ///
        /// <p>A list of identity provider identifiers.</p>
        pub fn idp_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idp_identifiers(input.into());
            self
        }
        /// <p>A list of identity provider identifiers.</p>
        pub fn set_idp_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_idp_identifiers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceServer`.
    ///
    /// <p>Creates a new OAuth2.0 resource server and defines custom scopes in it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourceServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_server_input::Builder,
    }
    impl<C, M, R> CreateResourceServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceServerInputOperationOutputAlias,
                crate::output::CreateResourceServerOutput,
                crate::error::CreateResourceServerError,
                crate::input::CreateResourceServerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource server is located. For example, <code>https://my-weather-api.example.com</code>.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource server is located. For example, <code>https://my-weather-api.example.com</code>.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>A friendly name for the resource server.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name for the resource server.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Scopes`.
        ///
        /// To override the contents of this collection use [`set_scopes`](Self::set_scopes).
        ///
        /// <p>A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.</p>
        pub fn scopes(mut self, input: crate::model::ResourceServerScopeType) -> Self {
            self.inner = self.inner.scopes(input);
            self
        }
        /// <p>A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.</p>
        pub fn set_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
        ) -> Self {
            self.inner = self.inner.set_scopes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserImportJob`.
    ///
    /// <p>Creates the user import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_import_job_input::Builder,
    }
    impl<C, M, R> CreateUserImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserImportJobInputOperationOutputAlias,
                crate::output::CreateUserImportJobOutput,
                crate::error::CreateUserImportJobError,
                crate::input::CreateUserImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job name for the user import job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The job name for the user import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The role ARN for the Amazon CloudWatch Logging role for the user import job.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_logs_role_arn(input.into());
            self
        }
        /// <p>The role ARN for the Amazon CloudWatch Logging role for the user import job.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserPool`.
    ///
    /// <p>Creates a new Amazon Cognito user pool and sets the password policy for the pool.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserPool<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_pool_input::Builder,
    }
    impl<C, M, R> CreateUserPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserPoolInputOperationOutputAlias,
                crate::output::CreateUserPoolOutput,
                crate::error::CreateUserPoolError,
                crate::input::CreateUserPoolInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string used to name the user pool.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>A string used to name the user pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// <p>The policies associated with the new user pool.</p>
        pub fn policies(mut self, input: crate::model::UserPoolPolicyType) -> Self {
            self.inner = self.inner.policies(input);
            self
        }
        /// <p>The policies associated with the new user pool.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<crate::model::UserPoolPolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policies(input);
            self
        }
        /// <p>The Lambda trigger configuration information for the new user pool.</p> <note>
        /// <p>In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you will need to make an extra call to add permission for these event sources to invoke your Lambda function.</p>
        /// <p></p>
        /// <p>For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>. </p>
        /// <p>For adding permission using the CLI, see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.</p>
        /// </note>
        pub fn lambda_config(mut self, input: crate::model::LambdaConfigType) -> Self {
            self.inner = self.inner.lambda_config(input);
            self
        }
        /// <p>The Lambda trigger configuration information for the new user pool.</p> <note>
        /// <p>In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you will need to make an extra call to add permission for these event sources to invoke your Lambda function.</p>
        /// <p></p>
        /// <p>For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>. </p>
        /// <p>For adding permission using the CLI, see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.</p>
        /// </note>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaConfigType>,
        ) -> Self {
            self.inner = self.inner.set_lambda_config(input);
            self
        }
        /// Appends an item to `AutoVerifiedAttributes`.
        ///
        /// To override the contents of this collection use [`set_auto_verified_attributes`](Self::set_auto_verified_attributes).
        ///
        /// <p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>
        pub fn auto_verified_attributes(
            mut self,
            input: crate::model::VerifiedAttributeType,
        ) -> Self {
            self.inner = self.inner.auto_verified_attributes(input);
            self
        }
        /// <p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>
        pub fn set_auto_verified_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_auto_verified_attributes(input);
            self
        }
        /// Appends an item to `AliasAttributes`.
        ///
        /// To override the contents of this collection use [`set_alias_attributes`](Self::set_alias_attributes).
        ///
        /// <p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>
        pub fn alias_attributes(mut self, input: crate::model::AliasAttributeType) -> Self {
            self.inner = self.inner.alias_attributes(input);
            self
        }
        /// <p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>
        pub fn set_alias_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AliasAttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_alias_attributes(input);
            self
        }
        /// Appends an item to `UsernameAttributes`.
        ///
        /// To override the contents of this collection use [`set_username_attributes`](Self::set_username_attributes).
        ///
        /// <p>Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.</p>
        pub fn username_attributes(mut self, input: crate::model::UsernameAttributeType) -> Self {
            self.inner = self.inner.username_attributes(input);
            self
        }
        /// <p>Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.</p>
        pub fn set_username_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsernameAttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_username_attributes(input);
            self
        }
        /// <p>A string representing the SMS verification message.</p>
        pub fn sms_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sms_verification_message(input.into());
            self
        }
        /// <p>A string representing the SMS verification message.</p>
        pub fn set_sms_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sms_verification_message(input);
            self
        }
        /// <p>A string representing the email verification message. EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_verification_message(input.into());
            self
        }
        /// <p>A string representing the email verification message. EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_verification_message(input);
            self
        }
        /// <p>A string representing the email verification subject. EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_verification_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_verification_subject(input.into());
            self
        }
        /// <p>A string representing the email verification subject. EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_verification_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_verification_subject(input);
            self
        }
        /// <p>The template for the verification message that the user sees when the app requests permission to access the user's information.</p>
        pub fn verification_message_template(
            mut self,
            input: crate::model::VerificationMessageTemplateType,
        ) -> Self {
            self.inner = self.inner.verification_message_template(input);
            self
        }
        /// <p>The template for the verification message that the user sees when the app requests permission to access the user's information.</p>
        pub fn set_verification_message_template(
            mut self,
            input: std::option::Option<crate::model::VerificationMessageTemplateType>,
        ) -> Self {
            self.inner = self.inner.set_verification_message_template(input);
            self
        }
        /// <p>A string representing the SMS authentication message.</p>
        pub fn sms_authentication_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sms_authentication_message(input.into());
            self
        }
        /// <p>A string representing the SMS authentication message.</p>
        pub fn set_sms_authentication_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sms_authentication_message(input);
            self
        }
        /// <p>Specifies MFA configuration details.</p>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.inner = self.inner.mfa_configuration(input);
            self
        }
        /// <p>Specifies MFA configuration details.</p>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.inner = self.inner.set_mfa_configuration(input);
            self
        }
        /// <p>The device configuration.</p>
        pub fn device_configuration(
            mut self,
            input: crate::model::DeviceConfigurationType,
        ) -> Self {
            self.inner = self.inner.device_configuration(input);
            self
        }
        /// <p>The device configuration.</p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_device_configuration(input);
            self
        }
        /// <p>The email configuration.</p>
        pub fn email_configuration(mut self, input: crate::model::EmailConfigurationType) -> Self {
            self.inner = self.inner.email_configuration(input);
            self
        }
        /// <p>The email configuration.</p>
        pub fn set_email_configuration(
            mut self,
            input: std::option::Option<crate::model::EmailConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_email_configuration(input);
            self
        }
        /// <p>The SMS configuration.</p>
        pub fn sms_configuration(mut self, input: crate::model::SmsConfigurationType) -> Self {
            self.inner = self.inner.sms_configuration(input);
            self
        }
        /// <p>The SMS configuration.</p>
        pub fn set_sms_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_sms_configuration(input);
            self
        }
        /// Adds a key-value pair to `UserPoolTags`.
        ///
        /// To override the contents of this collection use [`set_user_pool_tags`](Self::set_user_pool_tags).
        ///
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn user_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.user_pool_tags(k.into(), v.into());
            self
        }
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn set_user_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_user_pool_tags(input);
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn admin_create_user_config(
            mut self,
            input: crate::model::AdminCreateUserConfigType,
        ) -> Self {
            self.inner = self.inner.admin_create_user_config(input);
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn set_admin_create_user_config(
            mut self,
            input: std::option::Option<crate::model::AdminCreateUserConfigType>,
        ) -> Self {
            self.inner = self.inner.set_admin_create_user_config(input);
            self
        }
        /// Appends an item to `Schema`.
        ///
        /// To override the contents of this collection use [`set_schema`](Self::set_schema).
        ///
        /// <p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>
        pub fn schema(mut self, input: crate::model::SchemaAttributeType) -> Self {
            self.inner = self.inner.schema(input);
            self
        }
        /// <p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>
        pub fn set_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// <p>Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn user_pool_add_ons(mut self, input: crate::model::UserPoolAddOnsType) -> Self {
            self.inner = self.inner.user_pool_add_ons(input);
            self
        }
        /// <p>Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn set_user_pool_add_ons(
            mut self,
            input: std::option::Option<crate::model::UserPoolAddOnsType>,
        ) -> Self {
            self.inner = self.inner.set_user_pool_add_ons(input);
            self
        }
        /// <p>You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to <code>False</code>, users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
        pub fn username_configuration(
            mut self,
            input: crate::model::UsernameConfigurationType,
        ) -> Self {
            self.inner = self.inner.username_configuration(input);
            self
        }
        /// <p>You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to <code>False</code>, users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
        pub fn set_username_configuration(
            mut self,
            input: std::option::Option<crate::model::UsernameConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_username_configuration(input);
            self
        }
        /// <p>Use this setting to define which verified available method a user can use to recover their password when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.</p>
        pub fn account_recovery_setting(
            mut self,
            input: crate::model::AccountRecoverySettingType,
        ) -> Self {
            self.inner = self.inner.account_recovery_setting(input);
            self
        }
        /// <p>Use this setting to define which verified available method a user can use to recover their password when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.</p>
        pub fn set_account_recovery_setting(
            mut self,
            input: std::option::Option<crate::model::AccountRecoverySettingType>,
        ) -> Self {
            self.inner = self.inner.set_account_recovery_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserPoolClient`.
    ///
    /// <p>Creates the user pool client.</p>
    /// <p>When you create a new user pool client, token revocation is automatically enabled. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserPoolClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_pool_client_input::Builder,
    }
    impl<C, M, R> CreateUserPoolClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserPoolClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserPoolClientOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserPoolClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserPoolClientInputOperationOutputAlias,
                crate::output::CreateUserPoolClientOutput,
                crate::error::CreateUserPoolClientError,
                crate::input::CreateUserPoolClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to create a user pool client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to create a user pool client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The client name for the user pool client you would like to create.</p>
        pub fn client_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_name(input.into());
            self
        }
        /// <p>The client name for the user pool client you would like to create.</p>
        pub fn set_client_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_name(input);
            self
        }
        /// <p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>
        pub fn generate_secret(mut self, input: bool) -> Self {
            self.inner = self.inner.generate_secret(input);
            self
        }
        /// <p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>
        pub fn set_generate_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_generate_secret(input);
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>
        pub fn refresh_token_validity(mut self, input: i32) -> Self {
            self.inner = self.inner.refresh_token_validity(input);
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>
        pub fn set_refresh_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_refresh_token_validity(input);
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. This value will be overridden if you have entered a value in TokenValidityUnits.</p>
        pub fn access_token_validity(mut self, input: i32) -> Self {
            self.inner = self.inner.access_token_validity(input);
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. This value will be overridden if you have entered a value in TokenValidityUnits.</p>
        pub fn set_access_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_access_token_validity(input);
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. This value will be overridden if you have entered a value in TokenValidityUnits.</p>
        pub fn id_token_validity(mut self, input: i32) -> Self {
            self.inner = self.inner.id_token_validity(input);
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. This value will be overridden if you have entered a value in TokenValidityUnits.</p>
        pub fn set_id_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_id_token_validity(input);
            self
        }
        /// <p>The units in which the validity times are represented in. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
        pub fn token_validity_units(mut self, input: crate::model::TokenValidityUnitsType) -> Self {
            self.inner = self.inner.token_validity_units(input);
            self
        }
        /// <p>The units in which the validity times are represented in. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
        pub fn set_token_validity_units(
            mut self,
            input: std::option::Option<crate::model::TokenValidityUnitsType>,
        ) -> Self {
            self.inner = self.inner.set_token_validity_units(input);
            self
        }
        /// Appends an item to `ReadAttributes`.
        ///
        /// To override the contents of this collection use [`set_read_attributes`](Self::set_read_attributes).
        ///
        /// <p>The read attributes.</p>
        pub fn read_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.read_attributes(input.into());
            self
        }
        /// <p>The read attributes.</p>
        pub fn set_read_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_read_attributes(input);
            self
        }
        /// Appends an item to `WriteAttributes`.
        ///
        /// To override the contents of this collection use [`set_write_attributes`](Self::set_write_attributes).
        ///
        /// <p>The user pool attributes that the app client can write to.</p>
        /// <p>If your app client allows users to sign in through an identity provider, this array must include all attributes that are mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client lacks write access to a mapped attribute, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
        pub fn write_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.write_attributes(input.into());
            self
        }
        /// <p>The user pool attributes that the app client can write to.</p>
        /// <p>If your app client allows users to sign in through an identity provider, this array must include all attributes that are mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client lacks write access to a mapped attribute, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
        pub fn set_write_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_write_attributes(input);
            self
        }
        /// Appends an item to `ExplicitAuthFlows`.
        ///
        /// To override the contents of this collection use [`set_explicit_auth_flows`](Self::set_explicit_auth_flows).
        ///
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote Password protocol) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn explicit_auth_flows(mut self, input: crate::model::ExplicitAuthFlowsType) -> Self {
            self.inner = self.inner.explicit_auth_flows(input);
            self
        }
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote Password protocol) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn set_explicit_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        ) -> Self {
            self.inner = self.inner.set_explicit_auth_flows(input);
            self
        }
        /// Appends an item to `SupportedIdentityProviders`.
        ///
        /// To override the contents of this collection use [`set_supported_identity_providers`](Self::set_supported_identity_providers).
        ///
        /// <p>A list of provider names for the identity providers that are supported on this client. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code> and <code>LoginWithAmazon</code>.</p>
        pub fn supported_identity_providers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.supported_identity_providers(input.into());
            self
        }
        /// <p>A list of provider names for the identity providers that are supported on this client. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code> and <code>LoginWithAmazon</code>.</p>
        pub fn set_supported_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_supported_identity_providers(input);
            self
        }
        /// Appends an item to `CallbackURLs`.
        ///
        /// To override the contents of this collection use [`set_callback_ur_ls`](Self::set_callback_ur_ls).
        ///
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn callback_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.callback_ur_ls(input.into());
            self
        }
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_callback_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_callback_ur_ls(input);
            self
        }
        /// Appends an item to `LogoutURLs`.
        ///
        /// To override the contents of this collection use [`set_logout_ur_ls`](Self::set_logout_ur_ls).
        ///
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn logout_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logout_ur_ls(input.into());
            self
        }
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn set_logout_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_logout_ur_ls(input);
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn default_redirect_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_redirect_uri(input.into());
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_default_redirect_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_redirect_uri(input);
            self
        }
        /// Appends an item to `AllowedOAuthFlows`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_flows`](Self::set_allowed_o_auth_flows).
        ///
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn allowed_o_auth_flows(mut self, input: crate::model::OAuthFlowType) -> Self {
            self.inner = self.inner.allowed_o_auth_flows(input);
            self
        }
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn set_allowed_o_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_o_auth_flows(input);
            self
        }
        /// Appends an item to `AllowedOAuthScopes`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_scopes`](Self::set_allowed_o_auth_scopes).
        ///
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn allowed_o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.allowed_o_auth_scopes(input.into());
            self
        }
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn set_allowed_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_o_auth_scopes(input);
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>
        pub fn allowed_o_auth_flows_user_pool_client(mut self, input: bool) -> Self {
            self.inner = self.inner.allowed_o_auth_flows_user_pool_client(input);
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>
        pub fn set_allowed_o_auth_flows_user_pool_client(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allowed_o_auth_flows_user_pool_client(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In regions where Pinpoint is not available, Cognito User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In regions where Pinpoint is available, Cognito User Pools will support sending events to Amazon Pinpoint projects within that same region. </p>
        /// </note>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfigurationType,
        ) -> Self {
            self.inner = self.inner.analytics_configuration(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In regions where Pinpoint is not available, Cognito User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In regions where Pinpoint is available, Cognito User Pools will support sending events to Amazon Pinpoint projects within that same region. </p>
        /// </note>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_configuration(input);
            self
        }
        /// <p>Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not prevented.</p> </li>
        /// </ul> <note>
        /// <p>After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code> for newly created user pool clients if no value is provided.</p>
        /// </note>
        pub fn prevent_user_existence_errors(
            mut self,
            input: crate::model::PreventUserExistenceErrorTypes,
        ) -> Self {
            self.inner = self.inner.prevent_user_existence_errors(input);
            self
        }
        /// <p>Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not prevented.</p> </li>
        /// </ul> <note>
        /// <p>After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code> for newly created user pool clients if no value is provided.</p>
        /// </note>
        pub fn set_prevent_user_existence_errors(
            mut self,
            input: std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        ) -> Self {
            self.inner = self.inner.set_prevent_user_existence_errors(input);
            self
        }
        /// <p>Enables or disables token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        /// <p>If you don't include this parameter, token revocation is automatically enabled for the new user pool client.</p>
        pub fn enable_token_revocation(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_token_revocation(input);
            self
        }
        /// <p>Enables or disables token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        /// <p>If you don't include this parameter, token revocation is automatically enabled for the new user pool client.</p>
        pub fn set_enable_token_revocation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_token_revocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserPoolDomain`.
    ///
    /// <p>Creates a new domain for a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserPoolDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_pool_domain_input::Builder,
    }
    impl<C, M, R> CreateUserPoolDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserPoolDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserPoolDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserPoolDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserPoolDomainInputOperationOutputAlias,
                crate::output::CreateUserPoolDomainOutput,
                crate::error::CreateUserPoolDomainError,
                crate::input::CreateUserPoolDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain string.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain string.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
        /// <p>Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.</p>
        /// <p>For more information about the hosted domain and custom domains, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html">Configuring a User Pool Domain</a>.</p>
        pub fn custom_domain_config(mut self, input: crate::model::CustomDomainConfigType) -> Self {
            self.inner = self.inner.custom_domain_config(input);
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
        /// <p>Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.</p>
        /// <p>For more information about the hosted domain and custom domains, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html">Configuring a User Pool Domain</a>.</p>
        pub fn set_custom_domain_config(
            mut self,
            input: std::option::Option<crate::model::CustomDomainConfigType>,
        ) -> Self {
            self.inner = self.inner.set_custom_domain_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes a group.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentityProvider`.
    ///
    /// <p>Deletes an identity provider for a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_identity_provider_input::Builder,
    }
    impl<C, M, R> DeleteIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIdentityProviderInputOperationOutputAlias,
                crate::output::DeleteIdentityProviderOutput,
                crate::error::DeleteIdentityProviderError,
                crate::input::DeleteIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceServer`.
    ///
    /// <p>Deletes a resource server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourceServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_server_input::Builder,
    }
    impl<C, M, R> DeleteResourceServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceServerInputOperationOutputAlias,
                crate::output::DeleteResourceServerOutput,
                crate::error::DeleteResourceServerError,
                crate::input::DeleteResourceServerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Allows a user to delete himself or herself.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token from a request to delete a user.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token from a request to delete a user.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserAttributes`.
    ///
    /// <p>Deletes the attributes for a user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_attributes_input::Builder,
    }
    impl<C, M, R> DeleteUserAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserAttributesInputOperationOutputAlias,
                crate::output::DeleteUserAttributesOutput,
                crate::error::DeleteUserAttributesError,
                crate::input::DeleteUserAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UserAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_user_attribute_names`](Self::set_user_attribute_names).
        ///
        /// <p>An array of strings representing the user attribute names you wish to delete.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_attribute_names(input.into());
            self
        }
        /// <p>An array of strings representing the user attribute names you wish to delete.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_attribute_names(input);
            self
        }
        /// <p>The access token used in the request to delete user attributes.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token used in the request to delete user attributes.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserPool`.
    ///
    /// <p>Deletes the specified Amazon Cognito user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserPool<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_pool_input::Builder,
    }
    impl<C, M, R> DeleteUserPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserPoolInputOperationOutputAlias,
                crate::output::DeleteUserPoolOutput,
                crate::error::DeleteUserPoolError,
                crate::input::DeleteUserPoolInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool you want to delete.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to delete.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserPoolClient`.
    ///
    /// <p>Allows the developer to delete the user pool client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserPoolClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_pool_client_input::Builder,
    }
    impl<C, M, R> DeleteUserPoolClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserPoolClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserPoolClientOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserPoolClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserPoolClientInputOperationOutputAlias,
                crate::output::DeleteUserPoolClientOutput,
                crate::error::DeleteUserPoolClientError,
                crate::input::DeleteUserPoolClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to delete the client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to delete the client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserPoolDomain`.
    ///
    /// <p>Deletes a domain for a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserPoolDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_pool_domain_input::Builder,
    }
    impl<C, M, R> DeleteUserPoolDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserPoolDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserPoolDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserPoolDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserPoolDomainInputOperationOutputAlias,
                crate::output::DeleteUserPoolDomainOutput,
                crate::error::DeleteUserPoolDomainError,
                crate::input::DeleteUserPoolDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain string.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain string.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityProvider`.
    ///
    /// <p>Gets information about a specific identity provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_identity_provider_input::Builder,
    }
    impl<C, M, R> DescribeIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIdentityProviderInputOperationOutputAlias,
                crate::output::DescribeIdentityProviderOutput,
                crate::error::DescribeIdentityProviderError,
                crate::input::DescribeIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourceServer`.
    ///
    /// <p>Describes a resource server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourceServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_server_input::Builder,
    }
    impl<C, M, R> DescribeResourceServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourceServerInputOperationOutputAlias,
                crate::output::DescribeResourceServerOutput,
                crate::error::DescribeResourceServerError,
                crate::input::DescribeResourceServerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identifier for the resource server</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>The identifier for the resource server</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRiskConfiguration`.
    ///
    /// <p>Describes the risk configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRiskConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_risk_configuration_input::Builder,
    }
    impl<C, M, R> DescribeRiskConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRiskConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRiskConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRiskConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRiskConfigurationInputOperationOutputAlias,
                crate::output::DescribeRiskConfigurationOutput,
                crate::error::DescribeRiskConfigurationError,
                crate::input::DescribeRiskConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserImportJob`.
    ///
    /// <p>Describes the user import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_import_job_input::Builder,
    }
    impl<C, M, R> DescribeUserImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserImportJobInputOperationOutputAlias,
                crate::output::DescribeUserImportJobOutput,
                crate::error::DescribeUserImportJobError,
                crate::input::DescribeUserImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserPool`.
    ///
    /// <p>Returns the configuration information and metadata of the specified user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserPool<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_pool_input::Builder,
    }
    impl<C, M, R> DescribeUserPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserPoolInputOperationOutputAlias,
                crate::output::DescribeUserPoolOutput,
                crate::error::DescribeUserPoolError,
                crate::input::DescribeUserPoolInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserPoolClient`.
    ///
    /// <p>Client method for returning the configuration information and metadata of the specified user pool app client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserPoolClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_pool_client_input::Builder,
    }
    impl<C, M, R> DescribeUserPoolClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserPoolClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserPoolClientOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserPoolClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserPoolClientInputOperationOutputAlias,
                crate::output::DescribeUserPoolClientOutput,
                crate::error::DescribeUserPoolClientError,
                crate::input::DescribeUserPoolClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserPoolDomain`.
    ///
    /// <p>Gets information about a domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserPoolDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_pool_domain_input::Builder,
    }
    impl<C, M, R> DescribeUserPoolDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserPoolDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserPoolDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserPoolDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserPoolDomainInputOperationOutputAlias,
                crate::output::DescribeUserPoolDomainOutput,
                crate::error::DescribeUserPoolDomainError,
                crate::input::DescribeUserPoolDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain string.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain string.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ForgetDevice`.
    ///
    /// <p>Forgets the specified device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ForgetDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::forget_device_input::Builder,
    }
    impl<C, M, R> ForgetDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ForgetDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ForgetDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::ForgetDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ForgetDeviceInputOperationOutputAlias,
                crate::output::ForgetDeviceOutput,
                crate::error::ForgetDeviceError,
                crate::input::ForgetDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token for the forgotten device request.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token for the forgotten device request.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_key(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ForgotPassword`.
    ///
    /// <p>Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the <code>Username</code> parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. If neither a verified phone number nor a verified email exists, an <code>InvalidParameterException</code> is thrown. To use the confirmation code for resetting the password, call <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html">ConfirmForgotPassword</a>.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ForgotPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::forgot_password_input::Builder,
    }
    impl<C, M, R> ForgotPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ForgotPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ForgotPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ForgotPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ForgotPasswordInputOperationOutputAlias,
                crate::output::ForgotPasswordOutput,
                crate::error::ForgotPasswordError,
                crate::input::ForgotPasswordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_hash(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_hash(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.inner = self.inner.user_context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_user_context_data(input);
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to reset a forgotten password.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to reset a forgotten password.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ForgotPassword</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ForgotPassword</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>user migration</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>user migration</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCSVHeader`.
    ///
    /// <p>Gets the header information for the .csv file to be used as input for the user import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCSVHeader<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_csv_header_input::Builder,
    }
    impl<C, M, R> GetCSVHeader<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCSVHeader`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCsvHeaderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCSVHeaderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCsvHeaderInputOperationOutputAlias,
                crate::output::GetCsvHeaderOutput,
                crate::error::GetCSVHeaderError,
                crate::input::GetCsvHeaderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevice`.
    ///
    /// <p>Gets the device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_input::Builder,
    }
    impl<C, M, R> GetDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceInputOperationOutputAlias,
                crate::output::GetDeviceOutput,
                crate::error::GetDeviceError,
                crate::input::GetDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_key(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_key(input);
            self
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroup`.
    ///
    /// <p>Gets a group.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_input::Builder,
    }
    impl<C, M, R> GetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupInputOperationOutputAlias,
                crate::output::GetGroupOutput,
                crate::error::GetGroupError,
                crate::input::GetGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityProviderByIdentifier`.
    ///
    /// <p>Gets the specified identity provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityProviderByIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_provider_by_identifier_input::Builder,
    }
    impl<C, M, R> GetIdentityProviderByIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityProviderByIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityProviderByIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityProviderByIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityProviderByIdentifierInputOperationOutputAlias,
                crate::output::GetIdentityProviderByIdentifierOutput,
                crate::error::GetIdentityProviderByIdentifierError,
                crate::input::GetIdentityProviderByIdentifierInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identity provider ID.</p>
        pub fn idp_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idp_identifier(input.into());
            self
        }
        /// <p>The identity provider ID.</p>
        pub fn set_idp_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idp_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSigningCertificate`.
    ///
    /// <p>This method takes a user pool ID, and returns the signing certificate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSigningCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_signing_certificate_input::Builder,
    }
    impl<C, M, R> GetSigningCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSigningCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSigningCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSigningCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSigningCertificateInputOperationOutputAlias,
                crate::output::GetSigningCertificateOutput,
                crate::error::GetSigningCertificateError,
                crate::input::GetSigningCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUICustomization`.
    ///
    /// <p>Gets the UI Customization information for a particular app client's app UI, if there is something set. If nothing is set for the particular client, but there is an existing pool level customization (app <code>clientId</code> will be <code>ALL</code>), then that is returned. If nothing is present, then an empty shape is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUICustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ui_customization_input::Builder,
    }
    impl<C, M, R> GetUICustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUICustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUiCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUICustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUiCustomizationInputOperationOutputAlias,
                crate::output::GetUiCustomizationOutput,
                crate::error::GetUICustomizationError,
                crate::input::GetUiCustomizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUser`.
    ///
    /// <p>Gets the user attributes and metadata for a user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_input::Builder,
    }
    impl<C, M, R> GetUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserInputOperationOutputAlias,
                crate::output::GetUserOutput,
                crate::error::GetUserError,
                crate::input::GetUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token returned by the server response to get information about the user.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token returned by the server response to get information about the user.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserAttributeVerificationCode`.
    ///
    /// <p>Gets the user attribute verification code for the specified attribute name.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUserAttributeVerificationCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_attribute_verification_code_input::Builder,
    }
    impl<C, M, R> GetUserAttributeVerificationCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserAttributeVerificationCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserAttributeVerificationCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserAttributeVerificationCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserAttributeVerificationCodeInputOperationOutputAlias,
                crate::output::GetUserAttributeVerificationCodeOutput,
                crate::error::GetUserAttributeVerificationCodeError,
                crate::input::GetUserAttributeVerificationCodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token returned by the server response to get the user attribute verification code.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token returned by the server response to get the user attribute verification code.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The attribute name returned by the server response to get the user attribute verification code.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(input.into());
            self
        }
        /// <p>The attribute name returned by the server response to get the user attribute verification code.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserPoolMfaConfig`.
    ///
    /// <p>Gets the user pool multi-factor authentication (MFA) configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUserPoolMfaConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_pool_mfa_config_input::Builder,
    }
    impl<C, M, R> GetUserPoolMfaConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserPoolMfaConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserPoolMfaConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserPoolMfaConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserPoolMfaConfigInputOperationOutputAlias,
                crate::output::GetUserPoolMfaConfigOutput,
                crate::error::GetUserPoolMfaConfigError,
                crate::input::GetUserPoolMfaConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GlobalSignOut`.
    ///
    /// <p>Signs out users from all devices. It also invalidates all refresh tokens issued to a user. The user's current access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour after they are issued.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GlobalSignOut<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::global_sign_out_input::Builder,
    }
    impl<C, M, R> GlobalSignOut<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GlobalSignOut`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GlobalSignOutOutput,
            aws_smithy_http::result::SdkError<crate::error::GlobalSignOutError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GlobalSignOutInputOperationOutputAlias,
                crate::output::GlobalSignOutOutput,
                crate::error::GlobalSignOutError,
                crate::input::GlobalSignOutInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitiateAuth`.
    ///
    /// <p>Initiates the authentication flow.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InitiateAuth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::initiate_auth_input::Builder,
    }
    impl<C, M, R> InitiateAuth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InitiateAuth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitiateAuthOutput,
            aws_smithy_http::result::SdkError<crate::error::InitiateAuthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InitiateAuthInputOperationOutputAlias,
                crate::output::InitiateAuthOutput,
                crate::error::InitiateAuthError,
                crate::input::InitiateAuthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The authentication flow for this call to execute. The API action will depend on this value. For example: </p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if the USERNAME is not found in the user pool. </p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>
        /// </ul>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>
        pub fn auth_flow(mut self, input: crate::model::AuthFlowType) -> Self {
            self.inner = self.inner.auth_flow(input);
            self
        }
        /// <p>The authentication flow for this call to execute. The API action will depend on this value. For example: </p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if the USERNAME is not found in the user pool. </p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>
        /// </ul>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>
        pub fn set_auth_flow(
            mut self,
            input: std::option::Option<crate::model::AuthFlowType>,
        ) -> Self {
            self.inner = self.inner.set_auth_flow(input);
            self
        }
        /// Adds a key-value pair to `AuthParameters`.
        ///
        /// To override the contents of this collection use [`set_auth_parameters`](Self::set_auth_parameters).
        ///
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn auth_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auth_parameters(k.into(), v.into());
            self
        }
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_auth_parameters(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it does not provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it does not provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>InitiateAuth</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>InitiateAuth</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.inner = self.inner.user_context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_user_context_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevices`.
    ///
    /// <p>Lists the devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_devices_input::Builder,
    }
    impl<C, M, R> ListDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicesInputOperationOutputAlias,
                crate::output::ListDevicesOutput,
                crate::error::ListDevicesError,
                crate::input::ListDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access tokens for the request to list devices.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access tokens for the request to list devices.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The limit of the device request.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The limit of the device request.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The pagination token for the list request.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pagination_token(input.into());
            self
        }
        /// <p>The pagination token for the list request.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pagination_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Lists the groups associated with a user pool.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl<C, M, R> ListGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsInputOperationOutputAlias,
                crate::output::ListGroupsOutput,
                crate::error::ListGroupsError,
                crate::input::ListGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGroupsPaginator<C, M, R> {
            crate::paginator::ListGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityProviders`.
    ///
    /// <p>Lists information about all identity providers for a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentityProviders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identity_providers_input::Builder,
    }
    impl<C, M, R> ListIdentityProviders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentityProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityProvidersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentityProvidersInputOperationOutputAlias,
                crate::output::ListIdentityProvidersOutput,
                crate::error::ListIdentityProvidersError,
                crate::input::ListIdentityProvidersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIdentityProvidersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIdentityProvidersPaginator<C, M, R> {
            crate::paginator::ListIdentityProvidersPaginator::new(self.handle, self.inner)
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The maximum number of identity providers to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of identity providers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceServers`.
    ///
    /// <p>Lists the resource servers for a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceServers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_servers_input::Builder,
    }
    impl<C, M, R> ListResourceServers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceServersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceServersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceServersInputOperationOutputAlias,
                crate::output::ListResourceServersOutput,
                crate::error::ListResourceServersError,
                crate::input::ListResourceServersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceServersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceServersPaginator<C, M, R> {
            crate::paginator::ListResourceServersPaginator::new(self.handle, self.inner)
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The maximum number of resource servers to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resource servers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that are assigned to an Amazon Cognito user pool.</p>
    /// <p>A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// <p>You can use this action up to 10 times per second, per account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserImportJobs`.
    ///
    /// <p>Lists the user import jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUserImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_import_jobs_input::Builder,
    }
    impl<C, M, R> ListUserImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserImportJobsInputOperationOutputAlias,
                crate::output::ListUserImportJobsOutput,
                crate::error::ListUserImportJobsError,
                crate::input::ListUserImportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The maximum number of import jobs you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of import jobs you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to <code>ListUserImportJobs</code>, which can be used to return the next set of import jobs in the list.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pagination_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to <code>ListUserImportJobs</code>, which can be used to return the next set of import jobs in the list.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pagination_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserPoolClients`.
    ///
    /// <p>Lists the clients that have been created for the specified user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUserPoolClients<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_pool_clients_input::Builder,
    }
    impl<C, M, R> ListUserPoolClients<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserPoolClients`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserPoolClientsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserPoolClientsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserPoolClientsInputOperationOutputAlias,
                crate::output::ListUserPoolClientsOutput,
                crate::error::ListUserPoolClientsError,
                crate::input::ListUserPoolClientsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUserPoolClientsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUserPoolClientsPaginator<C, M, R> {
            crate::paginator::ListUserPoolClientsPaginator::new(self.handle, self.inner)
        }
        /// <p>The user pool ID for the user pool where you want to list user pool clients.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to list user pool clients.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pool clients.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pool clients.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserPools`.
    ///
    /// <p>Lists the user pools associated with an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUserPools<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_pools_input::Builder,
    }
    impl<C, M, R> ListUserPools<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserPools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserPoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserPoolsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserPoolsInputOperationOutputAlias,
                crate::output::ListUserPoolsOutput,
                crate::error::ListUserPoolsError,
                crate::input::ListUserPoolsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUserPoolsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUserPoolsPaginator<C, M, R> {
            crate::paginator::ListUserPoolsPaginator::new(self.handle, self.inner)
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pools.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pools.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Lists the users in the Amazon Cognito user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsersPaginator<C, M, R> {
            crate::paginator::ListUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>The user pool ID for the user pool on which the search should be performed.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool on which the search should be performed.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// Appends an item to `AttributesToGet`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is null, all attributes are returned.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_to_get(input.into());
            self
        }
        /// <p>An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is null, all attributes are returned.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_get(input);
            self
        }
        /// <p>Maximum number of users to be returned.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Maximum number of users to be returned.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pagination_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pagination_token(input);
            self
        }
        /// <p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "<code>family_name</code> = \"Reddy\"".</p>
        /// <ul>
        /// <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li>
        /// <li> <p> <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"". </p> </li>
        /// <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li>
        /// </ul>
        /// <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p>
        /// <p>You can only search for the following standard attributes:</p>
        /// <ul>
        /// <li> <p> <code>username</code> (case-sensitive)</p> </li>
        /// <li> <p> <code>email</code> </p> </li>
        /// <li> <p> <code>phone_number</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>given_name</code> </p> </li>
        /// <li> <p> <code>family_name</code> </p> </li>
        /// <li> <p> <code>preferred_username</code> </p> </li>
        /// <li> <p> <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)</p> </li>
        /// <li> <p> <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code> </p> </li>
        /// <li> <p> <code>sub</code> </p> </li>
        /// </ul>
        /// <p>Custom attributes are not searchable.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter(input.into());
            self
        }
        /// <p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "<code>family_name</code> = \"Reddy\"".</p>
        /// <ul>
        /// <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li>
        /// <li> <p> <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"". </p> </li>
        /// <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li>
        /// </ul>
        /// <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p>
        /// <p>You can only search for the following standard attributes:</p>
        /// <ul>
        /// <li> <p> <code>username</code> (case-sensitive)</p> </li>
        /// <li> <p> <code>email</code> </p> </li>
        /// <li> <p> <code>phone_number</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>given_name</code> </p> </li>
        /// <li> <p> <code>family_name</code> </p> </li>
        /// <li> <p> <code>preferred_username</code> </p> </li>
        /// <li> <p> <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)</p> </li>
        /// <li> <p> <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code> </p> </li>
        /// <li> <p> <code>sub</code> </p> </li>
        /// </ul>
        /// <p>Custom attributes are not searchable.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_filter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsersInGroup`.
    ///
    /// <p>Lists the users in the specified group.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsersInGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_in_group_input::Builder,
    }
    impl<C, M, R> ListUsersInGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsersInGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersInGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersInGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInGroupInputOperationOutputAlias,
                crate::output::ListUsersInGroupOutput,
                crate::error::ListUsersInGroupError,
                crate::input::ListUsersInGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsersInGroupPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsersInGroupPaginator<C, M, R> {
            crate::paginator::ListUsersInGroupPaginator::new(self.handle, self.inner)
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The limit of the request to list users.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The limit of the request to list users.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResendConfirmationCode`.
    ///
    /// <p>Resends the confirmation (for confirmation of registration) to a specific user in the user pool.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResendConfirmationCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resend_confirmation_code_input::Builder,
    }
    impl<C, M, R> ResendConfirmationCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResendConfirmationCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResendConfirmationCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::ResendConfirmationCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResendConfirmationCodeInputOperationOutputAlias,
                crate::output::ResendConfirmationCodeOutput,
                crate::error::ResendConfirmationCodeError,
                crate::input::ResendConfirmationCodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_hash(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_hash(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.inner = self.inner.user_context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_user_context_data(input);
            self
        }
        /// <p>The user name of the user to whom you wish to resend a confirmation code.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user to whom you wish to resend a confirmation code.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ResendConfirmationCode</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ResendConfirmationCode</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RespondToAuthChallenge`.
    ///
    /// <p>Responds to the authentication challenge.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RespondToAuthChallenge<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::respond_to_auth_challenge_input::Builder,
    }
    impl<C, M, R> RespondToAuthChallenge<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RespondToAuthChallenge`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RespondToAuthChallengeOutput,
            aws_smithy_http::result::SdkError<crate::error::RespondToAuthChallengeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RespondToAuthChallengeInputOperationOutputAlias,
                crate::output::RespondToAuthChallengeOutput,
                crate::error::RespondToAuthChallengeError,
                crate::input::RespondToAuthChallengeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.inner = self.inner.challenge_name(input);
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.inner = self.inner.set_challenge_name(input);
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session(input.into());
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session(input);
            self
        }
        /// Adds a key-value pair to `ChallengeResponses`.
        ///
        /// To override the contents of this collection use [`set_challenge_responses`](Self::set_challenge_responses).
        ///
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <note>
        /// <p> <code>SECRET_HASH</code> (if app client is configured with client secret) applies to all inputs below (including <code>SOFTWARE_TOKEN_MFA</code>).</p>
        /// </note>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>.</p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>. </p> </li>
        /// <li> <p> <code>SOFTWARE_TOKEN_MFA</code>: <code>USERNAME</code> and <code>SOFTWARE_TOKEN_MFA_CODE</code> are required attributes.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code> requires <code>USERNAME</code>, <code>DEVICE_KEY</code>, <code>SRP_A</code> (and <code>SECRET_HASH</code>).</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code> requires everything that <code>PASSWORD_VERIFIER</code> requires plus <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you need to use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        pub fn challenge_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.challenge_responses(k.into(), v.into());
            self
        }
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <note>
        /// <p> <code>SECRET_HASH</code> (if app client is configured with client secret) applies to all inputs below (including <code>SOFTWARE_TOKEN_MFA</code>).</p>
        /// </note>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>.</p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>. </p> </li>
        /// <li> <p> <code>SOFTWARE_TOKEN_MFA</code>: <code>USERNAME</code> and <code>SOFTWARE_TOKEN_MFA_CODE</code> are required attributes.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code> requires <code>USERNAME</code>, <code>DEVICE_KEY</code>, <code>SRP_A</code> (and <code>SECRET_HASH</code>).</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code> requires everything that <code>PASSWORD_VERIFIER</code> requires plus <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you need to use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        pub fn set_challenge_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_challenge_responses(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>RespondToAuthChallenge</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>RespondToAuthChallenge</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.inner = self.inner.user_context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_user_context_data(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>post authentication</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>post authentication</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeToken`.
    ///
    /// <p>Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can not use the revoked token to access Cognito authenticated APIs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_token_input::Builder,
    }
    impl<C, M, R> RevokeToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeTokenInputOperationOutputAlias,
                crate::output::RevokeTokenOutput,
                crate::error::RevokeTokenError,
                crate::input::RevokeTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that you want to revoke.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The token that you want to revoke.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
        /// <p>The client ID for the token that you want to revoke.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The client ID for the token that you want to revoke.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The secret for the client ID. This is required only if the client ID has a secret.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_secret(input.into());
            self
        }
        /// <p>The secret for the client ID. This is required only if the client ID has a secret.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_secret(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetRiskConfiguration`.
    ///
    /// <p>Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or <code>ClientId</code>, pass null values for all four configuration types.</p>
    /// <p>To enable Amazon Cognito advanced security features, update the user pool to include the <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetRiskConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_risk_configuration_input::Builder,
    }
    impl<C, M, R> SetRiskConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetRiskConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetRiskConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::SetRiskConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetRiskConfigurationInputOperationOutputAlias,
                crate::output::SetRiskConfigurationOutput,
                crate::error::SetRiskConfigurationError,
                crate::input::SetRiskConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID. </p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID. </p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in the userPool.</p>
        /// <p>Otherwise, <code>ClientId</code> is mapped to the client. When the client ID is not null, the user pool configuration is overridden and the risk configuration for the client is used instead.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in the userPool.</p>
        /// <p>Otherwise, <code>ClientId</code> is mapped to the client. When the client ID is not null, the user pool configuration is overridden and the risk configuration for the client is used instead.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The compromised credentials risk configuration.</p>
        pub fn compromised_credentials_risk_configuration(
            mut self,
            input: crate::model::CompromisedCredentialsRiskConfigurationType,
        ) -> Self {
            self.inner = self.inner.compromised_credentials_risk_configuration(input);
            self
        }
        /// <p>The compromised credentials risk configuration.</p>
        pub fn set_compromised_credentials_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::CompromisedCredentialsRiskConfigurationType>,
        ) -> Self {
            self.inner = self
                .inner
                .set_compromised_credentials_risk_configuration(input);
            self
        }
        /// <p>The account takeover risk configuration.</p>
        pub fn account_takeover_risk_configuration(
            mut self,
            input: crate::model::AccountTakeoverRiskConfigurationType,
        ) -> Self {
            self.inner = self.inner.account_takeover_risk_configuration(input);
            self
        }
        /// <p>The account takeover risk configuration.</p>
        pub fn set_account_takeover_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverRiskConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_account_takeover_risk_configuration(input);
            self
        }
        /// <p>The configuration to override the risk decision.</p>
        pub fn risk_exception_configuration(
            mut self,
            input: crate::model::RiskExceptionConfigurationType,
        ) -> Self {
            self.inner = self.inner.risk_exception_configuration(input);
            self
        }
        /// <p>The configuration to override the risk decision.</p>
        pub fn set_risk_exception_configuration(
            mut self,
            input: std::option::Option<crate::model::RiskExceptionConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_risk_exception_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetUICustomization`.
    ///
    /// <p>Sets the UI customization information for a user pool's built-in app UI.</p>
    /// <p>You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the default configuration will be used for every client that has no UI customization set previously. If you specify UI customization settings for a particular client, it will no longer fall back to the <code>ALL</code> configuration. </p> <note>
    /// <p>To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app's pages, and the service will throw an error.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetUICustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_ui_customization_input::Builder,
    }
    impl<C, M, R> SetUICustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetUICustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetUiCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::SetUICustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetUiCustomizationInputOperationOutputAlias,
                crate::output::SetUiCustomizationOutput,
                crate::error::SetUICustomizationError,
                crate::input::SetUiCustomizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The CSS values in the UI customization.</p>
        pub fn css(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.css(input.into());
            self
        }
        /// <p>The CSS values in the UI customization.</p>
        pub fn set_css(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_css(input);
            self
        }
        /// <p>The uploaded logo image for the UI customization.</p>
        pub fn image_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.image_file(input);
            self
        }
        /// <p>The uploaded logo image for the UI customization.</p>
        pub fn set_image_file(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_image_file(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetUserMFAPreference`.
    ///
    /// <p>Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are enabled and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are enabled. If multiple options are enabled and no preference is set, a challenge to choose an MFA option will be returned during sign in. If an MFA type is enabled for a user, the user will be prompted for MFA during all sign in attempts, unless device tracking is turned on and the device has been trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign in attempts, disable MFA for users and turn on Adaptive Authentication for the user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetUserMFAPreference<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_user_mfa_preference_input::Builder,
    }
    impl<C, M, R> SetUserMFAPreference<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetUserMFAPreference`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetUserMfaPreferenceOutput,
            aws_smithy_http::result::SdkError<crate::error::SetUserMFAPreferenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetUserMfaPreferenceInputOperationOutputAlias,
                crate::output::SetUserMfaPreferenceOutput,
                crate::error::SetUserMFAPreferenceError,
                crate::input::SetUserMfaPreferenceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SMS text message multi-factor authentication (MFA) settings.</p>
        pub fn sms_mfa_settings(mut self, input: crate::model::SmsMfaSettingsType) -> Self {
            self.inner = self.inner.sms_mfa_settings(input);
            self
        }
        /// <p>The SMS text message multi-factor authentication (MFA) settings.</p>
        pub fn set_sms_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SmsMfaSettingsType>,
        ) -> Self {
            self.inner = self.inner.set_sms_mfa_settings(input);
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn software_token_mfa_settings(
            mut self,
            input: crate::model::SoftwareTokenMfaSettingsType,
        ) -> Self {
            self.inner = self.inner.software_token_mfa_settings(input);
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn set_software_token_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaSettingsType>,
        ) -> Self {
            self.inner = self.inner.set_software_token_mfa_settings(input);
            self
        }
        /// <p>The access token for the user.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token for the user.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetUserPoolMfaConfig`.
    ///
    /// <p>Set the user pool multi-factor authentication (MFA) configuration.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetUserPoolMfaConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_user_pool_mfa_config_input::Builder,
    }
    impl<C, M, R> SetUserPoolMfaConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetUserPoolMfaConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetUserPoolMfaConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::SetUserPoolMfaConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetUserPoolMfaConfigInputOperationOutputAlias,
                crate::output::SetUserPoolMfaConfigOutput,
                crate::error::SetUserPoolMfaConfigError,
                crate::input::SetUserPoolMfaConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The SMS text message MFA configuration.</p>
        pub fn sms_mfa_configuration(mut self, input: crate::model::SmsMfaConfigType) -> Self {
            self.inner = self.inner.sms_mfa_configuration(input);
            self
        }
        /// <p>The SMS text message MFA configuration.</p>
        pub fn set_sms_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsMfaConfigType>,
        ) -> Self {
            self.inner = self.inner.set_sms_mfa_configuration(input);
            self
        }
        /// <p>The software token MFA configuration.</p>
        pub fn software_token_mfa_configuration(
            mut self,
            input: crate::model::SoftwareTokenMfaConfigType,
        ) -> Self {
            self.inner = self.inner.software_token_mfa_configuration(input);
            self
        }
        /// <p>The software token MFA configuration.</p>
        pub fn set_software_token_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
        ) -> Self {
            self.inner = self.inner.set_software_token_mfa_configuration(input);
            self
        }
        /// <p>The MFA configuration. Users who don't have an MFA factor set up won't be able to sign-in if you set the MfaConfiguration value to ‘ON’. See <a href="cognito/latest/developerguide/user-pool-settings-mfa.html">Adding Multi-Factor Authentication (MFA) to a User Pool</a> to learn more. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA will not be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>
        /// </ul>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.inner = self.inner.mfa_configuration(input);
            self
        }
        /// <p>The MFA configuration. Users who don't have an MFA factor set up won't be able to sign-in if you set the MfaConfiguration value to ‘ON’. See <a href="cognito/latest/developerguide/user-pool-settings-mfa.html">Adding Multi-Factor Authentication (MFA) to a User Pool</a> to learn more. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA will not be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>
        /// </ul>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.inner = self.inner.set_mfa_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetUserSettings`.
    ///
    /// <p> <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to configure TOTP software token MFA. To configure either type of MFA, use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html">SetUserMFAPreference</a> instead.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_user_settings_input::Builder,
    }
    impl<C, M, R> SetUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::SetUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetUserSettingsInputOperationOutputAlias,
                crate::output::SetUserSettingsOutput,
                crate::error::SetUserSettingsError,
                crate::input::SetUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token for the set user settings request.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token for the set user settings request.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// Appends an item to `MFAOptions`.
        ///
        /// To override the contents of this collection use [`set_mfa_options`](Self::set_mfa_options).
        ///
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn mfa_options(mut self, input: crate::model::MfaOptionType) -> Self {
            self.inner = self.inner.mfa_options(input);
            self
        }
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn set_mfa_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        ) -> Self {
            self.inner = self.inner.set_mfa_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SignUp`.
    ///
    /// <p>Registers the user in the specified user pool and creates a user name, password, and user attributes.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SignUp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::sign_up_input::Builder,
    }
    impl<C, M, R> SignUp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SignUp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SignUpOutput,
            aws_smithy_http::result::SdkError<crate::error::SignUpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SignUpInputOperationOutputAlias,
                crate::output::SignUpOutput,
                crate::error::SignUpError,
                crate::input::SignUpInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_hash(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_hash(input);
            self
        }
        /// <p>The user name of the user you wish to register.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name of the user you wish to register.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password of the user you wish to register.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user you wish to register.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// Appends an item to `UserAttributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            self.inner = self.inner.user_attributes(input);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_user_attributes(input);
            self
        }
        /// Appends an item to `ValidationData`.
        ///
        /// To override the contents of this collection use [`set_validation_data`](Self::set_validation_data).
        ///
        /// <p>The validation data in the request to register a user.</p>
        pub fn validation_data(mut self, input: crate::model::AttributeType) -> Self {
            self.inner = self.inner.validation_data(input);
            self
        }
        /// <p>The validation data in the request to register a user.</p>
        pub fn set_validation_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_validation_data(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>SignUp</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.inner = self.inner.analytics_metadata(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>SignUp</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_metadata(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.inner = self.inner.user_context_data(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.inner = self.inner.set_user_context_data(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>post confirmation</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>post confirmation</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartUserImportJob`.
    ///
    /// <p>Starts the user import.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartUserImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_user_import_job_input::Builder,
    }
    impl<C, M, R> StartUserImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartUserImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartUserImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartUserImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartUserImportJobInputOperationOutputAlias,
                crate::output::StartUserImportJobOutput,
                crate::error::StartUserImportJobError,
                crate::input::StartUserImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopUserImportJob`.
    ///
    /// <p>Stops the user import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopUserImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_user_import_job_input::Builder,
    }
    impl<C, M, R> StopUserImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopUserImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopUserImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopUserImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopUserImportJobInputOperationOutputAlias,
                crate::output::StopUserImportJobOutput,
                crate::error::StopUserImportJobError,
                crate::input::StopUserImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// <p>Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an <code>Environment</code> tag key to both user pools. The value of this key might be <code>Test</code> for one user pool and <code>Production</code> for the other.</p>
    /// <p>Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an IAM policy, you can constrain permissions for user pools based on specific tags or tag values.</p>
    /// <p>You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool to assign the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool to assign the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the user pool.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the user pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAuthEventFeedback`.
    ///
    /// <p>Provides the feedback for an authentication event whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAuthEventFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_auth_event_feedback_input::Builder,
    }
    impl<C, M, R> UpdateAuthEventFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAuthEventFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAuthEventFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAuthEventFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAuthEventFeedbackInputOperationOutputAlias,
                crate::output::UpdateAuthEventFeedbackOutput,
                crate::error::UpdateAuthEventFeedbackError,
                crate::input::UpdateAuthEventFeedbackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The user pool username.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user pool username.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The event ID.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p>The event ID.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The feedback token.</p>
        pub fn feedback_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feedback_token(input.into());
            self
        }
        /// <p>The feedback token.</p>
        pub fn set_feedback_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feedback_token(input);
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn feedback_value(mut self, input: crate::model::FeedbackValueType) -> Self {
            self.inner = self.inner.feedback_value(input);
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn set_feedback_value(
            mut self,
            input: std::option::Option<crate::model::FeedbackValueType>,
        ) -> Self {
            self.inner = self.inner.set_feedback_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeviceStatus`.
    ///
    /// <p>Updates the device status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDeviceStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_status_input::Builder,
    }
    impl<C, M, R> UpdateDeviceStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeviceStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeviceStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeviceStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeviceStatusInputOperationOutputAlias,
                crate::output::UpdateDeviceStatusOutput,
                crate::error::UpdateDeviceStatusError,
                crate::input::UpdateDeviceStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_key(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_key(input);
            self
        }
        /// <p>The status of whether a device is remembered.</p>
        pub fn device_remembered_status(
            mut self,
            input: crate::model::DeviceRememberedStatusType,
        ) -> Self {
            self.inner = self.inner.device_remembered_status(input);
            self
        }
        /// <p>The status of whether a device is remembered.</p>
        pub fn set_device_remembered_status(
            mut self,
            input: std::option::Option<crate::model::DeviceRememberedStatusType>,
        ) -> Self {
            self.inner = self.inner.set_device_remembered_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// <p>Updates the specified group with the specified attributes.</p>
    /// <p>Calling this action requires developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_input::Builder,
    }
    impl<C, M, R> UpdateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupInputOperationOutputAlias,
                crate::output::UpdateGroupOutput,
                crate::error::UpdateGroupError,
                crate::input::UpdateGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>A string containing the new description of the group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A string containing the new description of the group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The new precedence value for the group. For more information about this parameter, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html">CreateGroup</a>.</p>
        pub fn precedence(mut self, input: i32) -> Self {
            self.inner = self.inner.precedence(input);
            self
        }
        /// <p>The new precedence value for the group. For more information about this parameter, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html">CreateGroup</a>.</p>
        pub fn set_precedence(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_precedence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIdentityProvider`.
    ///
    /// <p>Updates identity provider information for a user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_identity_provider_input::Builder,
    }
    impl<C, M, R> UpdateIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIdentityProviderInputOperationOutputAlias,
                crate::output::UpdateIdentityProviderOutput,
                crate::error::UpdateIdentityProviderError,
                crate::input::UpdateIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// Adds a key-value pair to `ProviderDetails`.
        ///
        /// To override the contents of this collection use [`set_provider_details`](Self::set_provider_details).
        ///
        /// <p>The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>
        pub fn provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.provider_details(k.into(), v.into());
            self
        }
        /// <p>The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>
        pub fn set_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_provider_details(input);
            self
        }
        /// Adds a key-value pair to `AttributeMapping`.
        ///
        /// To override the contents of this collection use [`set_attribute_mapping`](Self::set_attribute_mapping).
        ///
        /// <p>The identity provider attribute mapping to be changed.</p>
        pub fn attribute_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attribute_mapping(k.into(), v.into());
            self
        }
        /// <p>The identity provider attribute mapping to be changed.</p>
        pub fn set_attribute_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attribute_mapping(input);
            self
        }
        /// Appends an item to `IdpIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_idp_identifiers`](Self::set_idp_identifiers).
        ///
        /// <p>A list of identity provider identifiers.</p>
        pub fn idp_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idp_identifiers(input.into());
            self
        }
        /// <p>A list of identity provider identifiers.</p>
        pub fn set_idp_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_idp_identifiers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceServer`.
    ///
    /// <p>Updates the name and scopes of resource server. All other fields are read-only.</p> <important>
    /// <p>If you don't provide a value for an attribute, it will be set to the default value.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResourceServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_server_input::Builder,
    }
    impl<C, M, R> UpdateResourceServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceServerInputOperationOutputAlias,
                crate::output::UpdateResourceServerOutput,
                crate::error::UpdateResourceServerError,
                crate::input::UpdateResourceServerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The name of the resource server.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the resource server.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Scopes`.
        ///
        /// To override the contents of this collection use [`set_scopes`](Self::set_scopes).
        ///
        /// <p>The scope values to be set for the resource server.</p>
        pub fn scopes(mut self, input: crate::model::ResourceServerScopeType) -> Self {
            self.inner = self.inner.scopes(input);
            self
        }
        /// <p>The scope values to be set for the resource server.</p>
        pub fn set_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
        ) -> Self {
            self.inner = self.inner.set_scopes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserAttributes`.
    ///
    /// <p>Allows a user to update a specific attribute (one at a time).</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_attributes_input::Builder,
    }
    impl<C, M, R> UpdateUserAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserAttributesInputOperationOutputAlias,
                crate::output::UpdateUserAttributesOutput,
                crate::error::UpdateUserAttributesError,
                crate::input::UpdateUserAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UserAttributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            self.inner = self.inner.user_attributes(input);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_user_attributes(input);
            self
        }
        /// <p>The access token for the request to update user attributes.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token for the request to update user attributes.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// Adds a key-value pair to `ClientMetadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.client_metadata(k.into(), v.into());
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>Take the following limitations into consideration when you use the ClientMetadata parameter:</p>
        /// <ul>
        /// <li> <p>Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Amazon Cognito does not validate the ClientMetadata value.</p> </li>
        /// <li> <p>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_client_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserPool`.
    ///
    /// <p>Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html">DescribeUserPool</a>. If you don't provide a value for an attribute, it will be set to the default value.</p> <note>
    /// <p>This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p>
    /// <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserPool<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_pool_input::Builder,
    }
    impl<C, M, R> UpdateUserPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserPoolInputOperationOutputAlias,
                crate::output::UpdateUserPoolOutput,
                crate::error::UpdateUserPoolError,
                crate::input::UpdateUserPoolInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool you want to update.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to update.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>A container with the policies you wish to update in a user pool.</p>
        pub fn policies(mut self, input: crate::model::UserPoolPolicyType) -> Self {
            self.inner = self.inner.policies(input);
            self
        }
        /// <p>A container with the policies you wish to update in a user pool.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<crate::model::UserPoolPolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policies(input);
            self
        }
        /// <p>The Lambda configuration information from the request to update the user pool.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaConfigType) -> Self {
            self.inner = self.inner.lambda_config(input);
            self
        }
        /// <p>The Lambda configuration information from the request to update the user pool.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaConfigType>,
        ) -> Self {
            self.inner = self.inner.set_lambda_config(input);
            self
        }
        /// Appends an item to `AutoVerifiedAttributes`.
        ///
        /// To override the contents of this collection use [`set_auto_verified_attributes`](Self::set_auto_verified_attributes).
        ///
        /// <p>The attributes that are automatically verified when the Amazon Cognito service makes a request to update user pools.</p>
        pub fn auto_verified_attributes(
            mut self,
            input: crate::model::VerifiedAttributeType,
        ) -> Self {
            self.inner = self.inner.auto_verified_attributes(input);
            self
        }
        /// <p>The attributes that are automatically verified when the Amazon Cognito service makes a request to update user pools.</p>
        pub fn set_auto_verified_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        ) -> Self {
            self.inner = self.inner.set_auto_verified_attributes(input);
            self
        }
        /// <p>A container with information about the SMS verification message.</p>
        pub fn sms_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sms_verification_message(input.into());
            self
        }
        /// <p>A container with information about the SMS verification message.</p>
        pub fn set_sms_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sms_verification_message(input);
            self
        }
        /// <p>The contents of the email verification message.</p>
        pub fn email_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_verification_message(input.into());
            self
        }
        /// <p>The contents of the email verification message.</p>
        pub fn set_email_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_verification_message(input);
            self
        }
        /// <p>The subject of the email verification message.</p>
        pub fn email_verification_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_verification_subject(input.into());
            self
        }
        /// <p>The subject of the email verification message.</p>
        pub fn set_email_verification_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_verification_subject(input);
            self
        }
        /// <p>The template for verification messages.</p>
        pub fn verification_message_template(
            mut self,
            input: crate::model::VerificationMessageTemplateType,
        ) -> Self {
            self.inner = self.inner.verification_message_template(input);
            self
        }
        /// <p>The template for verification messages.</p>
        pub fn set_verification_message_template(
            mut self,
            input: std::option::Option<crate::model::VerificationMessageTemplateType>,
        ) -> Self {
            self.inner = self.inner.set_verification_message_template(input);
            self
        }
        /// <p>The contents of the SMS authentication message.</p>
        pub fn sms_authentication_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sms_authentication_message(input.into());
            self
        }
        /// <p>The contents of the SMS authentication message.</p>
        pub fn set_sms_authentication_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sms_authentication_message(input);
            self
        }
        /// <p>Can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.</p> </li>
        /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify ON when you are initially creating a user pool. You can use the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html">SetUserPoolMfaConfig</a> API operation to turn MFA "ON" for existing user pools. </p> </li>
        /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
        /// </ul>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.inner = self.inner.mfa_configuration(input);
            self
        }
        /// <p>Can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.</p> </li>
        /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify ON when you are initially creating a user pool. You can use the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html">SetUserPoolMfaConfig</a> API operation to turn MFA "ON" for existing user pools. </p> </li>
        /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
        /// </ul>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.inner = self.inner.set_mfa_configuration(input);
            self
        }
        /// <p>Device configuration.</p>
        pub fn device_configuration(
            mut self,
            input: crate::model::DeviceConfigurationType,
        ) -> Self {
            self.inner = self.inner.device_configuration(input);
            self
        }
        /// <p>Device configuration.</p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_device_configuration(input);
            self
        }
        /// <p>Email configuration.</p>
        pub fn email_configuration(mut self, input: crate::model::EmailConfigurationType) -> Self {
            self.inner = self.inner.email_configuration(input);
            self
        }
        /// <p>Email configuration.</p>
        pub fn set_email_configuration(
            mut self,
            input: std::option::Option<crate::model::EmailConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_email_configuration(input);
            self
        }
        /// <p>SMS configuration.</p>
        pub fn sms_configuration(mut self, input: crate::model::SmsConfigurationType) -> Self {
            self.inner = self.inner.sms_configuration(input);
            self
        }
        /// <p>SMS configuration.</p>
        pub fn set_sms_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_sms_configuration(input);
            self
        }
        /// Adds a key-value pair to `UserPoolTags`.
        ///
        /// To override the contents of this collection use [`set_user_pool_tags`](Self::set_user_pool_tags).
        ///
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn user_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.user_pool_tags(k.into(), v.into());
            self
        }
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn set_user_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_user_pool_tags(input);
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn admin_create_user_config(
            mut self,
            input: crate::model::AdminCreateUserConfigType,
        ) -> Self {
            self.inner = self.inner.admin_create_user_config(input);
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn set_admin_create_user_config(
            mut self,
            input: std::option::Option<crate::model::AdminCreateUserConfigType>,
        ) -> Self {
            self.inner = self.inner.set_admin_create_user_config(input);
            self
        }
        /// <p>Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn user_pool_add_ons(mut self, input: crate::model::UserPoolAddOnsType) -> Self {
            self.inner = self.inner.user_pool_add_ons(input);
            self
        }
        /// <p>Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn set_user_pool_add_ons(
            mut self,
            input: std::option::Option<crate::model::UserPoolAddOnsType>,
        ) -> Self {
            self.inner = self.inner.set_user_pool_add_ons(input);
            self
        }
        /// <p>Use this setting to define which verified available method a user can use to recover their password when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.</p>
        pub fn account_recovery_setting(
            mut self,
            input: crate::model::AccountRecoverySettingType,
        ) -> Self {
            self.inner = self.inner.account_recovery_setting(input);
            self
        }
        /// <p>Use this setting to define which verified available method a user can use to recover their password when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.</p>
        pub fn set_account_recovery_setting(
            mut self,
            input: std::option::Option<crate::model::AccountRecoverySettingType>,
        ) -> Self {
            self.inner = self.inner.set_account_recovery_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserPoolClient`.
    ///
    /// <p>Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html">DescribeUserPoolClient</a>.</p> <important>
    /// <p>If you don't provide a value for an attribute, it will be set to the default value.</p>
    /// </important>
    /// <p>You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserPoolClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_pool_client_input::Builder,
    }
    impl<C, M, R> UpdateUserPoolClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserPoolClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserPoolClientOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserPoolClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserPoolClientInputOperationOutputAlias,
                crate::output::UpdateUserPoolClientOutput,
                crate::error::UpdateUserPoolClientError,
                crate::input::UpdateUserPoolClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user pool ID for the user pool where you want to update the user pool client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to update the user pool client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The client name from the update user pool client request.</p>
        pub fn client_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_name(input.into());
            self
        }
        /// <p>The client name from the update user pool client request.</p>
        pub fn set_client_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_name(input);
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>
        pub fn refresh_token_validity(mut self, input: i32) -> Self {
            self.inner = self.inner.refresh_token_validity(input);
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>
        pub fn set_refresh_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_refresh_token_validity(input);
            self
        }
        /// <p>The time limit, after which the access token is no longer valid and cannot be used.</p>
        pub fn access_token_validity(mut self, input: i32) -> Self {
            self.inner = self.inner.access_token_validity(input);
            self
        }
        /// <p>The time limit, after which the access token is no longer valid and cannot be used.</p>
        pub fn set_access_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_access_token_validity(input);
            self
        }
        /// <p>The time limit, after which the ID token is no longer valid and cannot be used.</p>
        pub fn id_token_validity(mut self, input: i32) -> Self {
            self.inner = self.inner.id_token_validity(input);
            self
        }
        /// <p>The time limit, after which the ID token is no longer valid and cannot be used.</p>
        pub fn set_id_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_id_token_validity(input);
            self
        }
        /// <p>The units in which the validity times are represented in. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
        pub fn token_validity_units(mut self, input: crate::model::TokenValidityUnitsType) -> Self {
            self.inner = self.inner.token_validity_units(input);
            self
        }
        /// <p>The units in which the validity times are represented in. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
        pub fn set_token_validity_units(
            mut self,
            input: std::option::Option<crate::model::TokenValidityUnitsType>,
        ) -> Self {
            self.inner = self.inner.set_token_validity_units(input);
            self
        }
        /// Appends an item to `ReadAttributes`.
        ///
        /// To override the contents of this collection use [`set_read_attributes`](Self::set_read_attributes).
        ///
        /// <p>The read-only attributes of the user pool.</p>
        pub fn read_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.read_attributes(input.into());
            self
        }
        /// <p>The read-only attributes of the user pool.</p>
        pub fn set_read_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_read_attributes(input);
            self
        }
        /// Appends an item to `WriteAttributes`.
        ///
        /// To override the contents of this collection use [`set_write_attributes`](Self::set_write_attributes).
        ///
        /// <p>The writeable attributes of the user pool.</p>
        pub fn write_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.write_attributes(input.into());
            self
        }
        /// <p>The writeable attributes of the user pool.</p>
        pub fn set_write_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_write_attributes(input);
            self
        }
        /// Appends an item to `ExplicitAuthFlows`.
        ///
        /// To override the contents of this collection use [`set_explicit_auth_flows`](Self::set_explicit_auth_flows).
        ///
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote Password protocol) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn explicit_auth_flows(mut self, input: crate::model::ExplicitAuthFlowsType) -> Self {
            self.inner = self.inner.explicit_auth_flows(input);
            self
        }
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote Password protocol) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn set_explicit_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        ) -> Self {
            self.inner = self.inner.set_explicit_auth_flows(input);
            self
        }
        /// Appends an item to `SupportedIdentityProviders`.
        ///
        /// To override the contents of this collection use [`set_supported_identity_providers`](Self::set_supported_identity_providers).
        ///
        /// <p>A list of provider names for the identity providers that are supported on this client.</p>
        pub fn supported_identity_providers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.supported_identity_providers(input.into());
            self
        }
        /// <p>A list of provider names for the identity providers that are supported on this client.</p>
        pub fn set_supported_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_supported_identity_providers(input);
            self
        }
        /// Appends an item to `CallbackURLs`.
        ///
        /// To override the contents of this collection use [`set_callback_ur_ls`](Self::set_callback_ur_ls).
        ///
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn callback_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.callback_ur_ls(input.into());
            self
        }
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_callback_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_callback_ur_ls(input);
            self
        }
        /// Appends an item to `LogoutURLs`.
        ///
        /// To override the contents of this collection use [`set_logout_ur_ls`](Self::set_logout_ur_ls).
        ///
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn logout_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logout_ur_ls(input.into());
            self
        }
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn set_logout_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_logout_ur_ls(input);
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn default_redirect_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_redirect_uri(input.into());
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_default_redirect_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_redirect_uri(input);
            self
        }
        /// Appends an item to `AllowedOAuthFlows`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_flows`](Self::set_allowed_o_auth_flows).
        ///
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn allowed_o_auth_flows(mut self, input: crate::model::OAuthFlowType) -> Self {
            self.inner = self.inner.allowed_o_auth_flows(input);
            self
        }
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn set_allowed_o_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_o_auth_flows(input);
            self
        }
        /// Appends an item to `AllowedOAuthScopes`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_scopes`](Self::set_allowed_o_auth_scopes).
        ///
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn allowed_o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.allowed_o_auth_scopes(input.into());
            self
        }
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn set_allowed_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_o_auth_scopes(input);
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>
        pub fn allowed_o_auth_flows_user_pool_client(mut self, input: bool) -> Self {
            self.inner = self.inner.allowed_o_auth_flows_user_pool_client(input);
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>
        pub fn set_allowed_o_auth_flows_user_pool_client(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allowed_o_auth_flows_user_pool_client(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In regions where Pinpoint is not available, Cognito User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In regions where Pinpoint is available, Cognito User Pools will support sending events to Amazon Pinpoint projects within that same region. </p>
        /// </note>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfigurationType,
        ) -> Self {
            self.inner = self.inner.analytics_configuration(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In regions where Pinpoint is not available, Cognito User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In regions where Pinpoint is available, Cognito User Pools will support sending events to Amazon Pinpoint projects within that same region. </p>
        /// </note>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfigurationType>,
        ) -> Self {
            self.inner = self.inner.set_analytics_configuration(input);
            self
        }
        /// <p>Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not prevented.</p> </li>
        /// </ul> <note>
        /// <p>After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code> for newly created user pool clients if no value is provided.</p>
        /// </note>
        pub fn prevent_user_existence_errors(
            mut self,
            input: crate::model::PreventUserExistenceErrorTypes,
        ) -> Self {
            self.inner = self.inner.prevent_user_existence_errors(input);
            self
        }
        /// <p>Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not prevented.</p> </li>
        /// </ul> <note>
        /// <p>After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to <code>ENABLED</code> for newly created user pool clients if no value is provided.</p>
        /// </note>
        pub fn set_prevent_user_existence_errors(
            mut self,
            input: std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        ) -> Self {
            self.inner = self.inner.set_prevent_user_existence_errors(input);
            self
        }
        /// <p>Enables or disables token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        pub fn enable_token_revocation(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_token_revocation(input);
            self
        }
        /// <p>Enables or disables token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        pub fn set_enable_token_revocation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_token_revocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserPoolDomain`.
    ///
    /// <p>Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.</p>
    /// <p>You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You cannot use it to change the domain for a user pool.</p>
    /// <p>A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.</p>
    /// <p>Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.</p>
    /// <p>However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.</p>
    /// <p>When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Region.</p>
    /// <p>After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.</p>
    /// <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserPoolDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_pool_domain_input::Builder,
    }
    impl<C, M, R> UpdateUserPoolDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserPoolDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserPoolDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserPoolDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserPoolDomainInputOperationOutputAlias,
                crate::output::UpdateUserPoolDomainOutput,
                crate::error::UpdateUserPoolDomainError,
                crate::input::UpdateUserPoolDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. For example: <code>auth.example.com</code>. </p>
        /// <p>This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the first or last character. Use periods to separate subdomain names.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. For example: <code>auth.example.com</code>. </p>
        /// <p>This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the first or last character. Use periods to separate subdomain names.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The ID of the user pool that is associated with the custom domain that you are updating the certificate for.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_pool_id(input.into());
            self
        }
        /// <p>The ID of the user pool that is associated with the custom domain that you are updating the certificate for.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_pool_id(input);
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this object to specify an SSL certificate that is managed by ACM.</p>
        pub fn custom_domain_config(mut self, input: crate::model::CustomDomainConfigType) -> Self {
            self.inner = self.inner.custom_domain_config(input);
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this object to specify an SSL certificate that is managed by ACM.</p>
        pub fn set_custom_domain_config(
            mut self,
            input: std::option::Option<crate::model::CustomDomainConfigType>,
        ) -> Self {
            self.inner = self.inner.set_custom_domain_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifySoftwareToken`.
    ///
    /// <p>Use this API to register a user's entered TOTP code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifySoftwareToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_software_token_input::Builder,
    }
    impl<C, M, R> VerifySoftwareToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifySoftwareToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifySoftwareTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifySoftwareTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifySoftwareTokenInputOperationOutputAlias,
                crate::output::VerifySoftwareTokenOutput,
                crate::error::VerifySoftwareTokenError,
                crate::input::VerifySoftwareTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session(input.into());
            self
        }
        /// <p>The session which should be passed both ways in challenge-response calls to the service.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session(input);
            self
        }
        /// <p>The one time password computed using the secret code returned by <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html">AssociateSoftwareToken"</a>.</p>
        pub fn user_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_code(input.into());
            self
        }
        /// <p>The one time password computed using the secret code returned by <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html">AssociateSoftwareToken"</a>.</p>
        pub fn set_user_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_code(input);
            self
        }
        /// <p>The friendly device name.</p>
        pub fn friendly_device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.friendly_device_name(input.into());
            self
        }
        /// <p>The friendly device name.</p>
        pub fn set_friendly_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_friendly_device_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyUserAttribute`.
    ///
    /// <p>Verifies the specified user attributes in the user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifyUserAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_user_attribute_input::Builder,
    }
    impl<C, M, R> VerifyUserAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyUserAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyUserAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyUserAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyUserAttributeInputOperationOutputAlias,
                crate::output::VerifyUserAttributeOutput,
                crate::error::VerifyUserAttributeError,
                crate::input::VerifyUserAttributeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the access token of the request to verify user attributes.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_token(input.into());
            self
        }
        /// <p>Represents the access token of the request to verify user attributes.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_token(input);
            self
        }
        /// <p>The attribute name in the request to verify user attributes.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(input.into());
            self
        }
        /// <p>The attribute name in the request to verify user attributes.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// <p>The verification code in the request to verify user attributes.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code(input.into());
            self
        }
        /// <p>The verification code in the request to verify user attributes.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_code(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
