// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddCustomAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_custom_attributes`](crate::client::Client::add_custom_attributes).
///
/// See [`crate::client::fluent_builders::AddCustomAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddCustomAttributes {
    _private: (),
}
impl AddCustomAttributes {
    /// Creates a new builder-style object to manufacture [`AddCustomAttributesInput`](crate::input::AddCustomAttributesInput)
    pub fn builder() -> crate::input::add_custom_attributes_input::Builder {
        crate::input::add_custom_attributes_input::Builder::default()
    }
    /// Creates a new `AddCustomAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddCustomAttributes {
    type Output = std::result::Result<
        crate::output::AddCustomAttributesOutput,
        crate::error::AddCustomAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_custom_attributes_error(response)
        } else {
            crate::operation_deser::parse_add_custom_attributes_response(response)
        }
    }
}

/// Operation shape for `AdminAddUserToGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_add_user_to_group`](crate::client::Client::admin_add_user_to_group).
///
/// See [`crate::client::fluent_builders::AdminAddUserToGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminAddUserToGroup {
    _private: (),
}
impl AdminAddUserToGroup {
    /// Creates a new builder-style object to manufacture [`AdminAddUserToGroupInput`](crate::input::AdminAddUserToGroupInput)
    pub fn builder() -> crate::input::admin_add_user_to_group_input::Builder {
        crate::input::admin_add_user_to_group_input::Builder::default()
    }
    /// Creates a new `AdminAddUserToGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminAddUserToGroup {
    type Output = std::result::Result<
        crate::output::AdminAddUserToGroupOutput,
        crate::error::AdminAddUserToGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_add_user_to_group_error(response)
        } else {
            crate::operation_deser::parse_admin_add_user_to_group_response(response)
        }
    }
}

/// Operation shape for `AdminConfirmSignUp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_confirm_sign_up`](crate::client::Client::admin_confirm_sign_up).
///
/// See [`crate::client::fluent_builders::AdminConfirmSignUp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminConfirmSignUp {
    _private: (),
}
impl AdminConfirmSignUp {
    /// Creates a new builder-style object to manufacture [`AdminConfirmSignUpInput`](crate::input::AdminConfirmSignUpInput)
    pub fn builder() -> crate::input::admin_confirm_sign_up_input::Builder {
        crate::input::admin_confirm_sign_up_input::Builder::default()
    }
    /// Creates a new `AdminConfirmSignUp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminConfirmSignUp {
    type Output = std::result::Result<
        crate::output::AdminConfirmSignUpOutput,
        crate::error::AdminConfirmSignUpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_confirm_sign_up_error(response)
        } else {
            crate::operation_deser::parse_admin_confirm_sign_up_response(response)
        }
    }
}

/// Operation shape for `AdminCreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_create_user`](crate::client::Client::admin_create_user).
///
/// See [`crate::client::fluent_builders::AdminCreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminCreateUser {
    _private: (),
}
impl AdminCreateUser {
    /// Creates a new builder-style object to manufacture [`AdminCreateUserInput`](crate::input::AdminCreateUserInput)
    pub fn builder() -> crate::input::admin_create_user_input::Builder {
        crate::input::admin_create_user_input::Builder::default()
    }
    /// Creates a new `AdminCreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminCreateUser {
    type Output = std::result::Result<
        crate::output::AdminCreateUserOutput,
        crate::error::AdminCreateUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_create_user_error(response)
        } else {
            crate::operation_deser::parse_admin_create_user_response(response)
        }
    }
}

/// Operation shape for `AdminDeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_delete_user`](crate::client::Client::admin_delete_user).
///
/// See [`crate::client::fluent_builders::AdminDeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminDeleteUser {
    _private: (),
}
impl AdminDeleteUser {
    /// Creates a new builder-style object to manufacture [`AdminDeleteUserInput`](crate::input::AdminDeleteUserInput)
    pub fn builder() -> crate::input::admin_delete_user_input::Builder {
        crate::input::admin_delete_user_input::Builder::default()
    }
    /// Creates a new `AdminDeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminDeleteUser {
    type Output = std::result::Result<
        crate::output::AdminDeleteUserOutput,
        crate::error::AdminDeleteUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_delete_user_error(response)
        } else {
            crate::operation_deser::parse_admin_delete_user_response(response)
        }
    }
}

/// Operation shape for `AdminDeleteUserAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_delete_user_attributes`](crate::client::Client::admin_delete_user_attributes).
///
/// See [`crate::client::fluent_builders::AdminDeleteUserAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminDeleteUserAttributes {
    _private: (),
}
impl AdminDeleteUserAttributes {
    /// Creates a new builder-style object to manufacture [`AdminDeleteUserAttributesInput`](crate::input::AdminDeleteUserAttributesInput)
    pub fn builder() -> crate::input::admin_delete_user_attributes_input::Builder {
        crate::input::admin_delete_user_attributes_input::Builder::default()
    }
    /// Creates a new `AdminDeleteUserAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminDeleteUserAttributes {
    type Output = std::result::Result<
        crate::output::AdminDeleteUserAttributesOutput,
        crate::error::AdminDeleteUserAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_delete_user_attributes_error(response)
        } else {
            crate::operation_deser::parse_admin_delete_user_attributes_response(response)
        }
    }
}

/// Operation shape for `AdminDisableProviderForUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_disable_provider_for_user`](crate::client::Client::admin_disable_provider_for_user).
///
/// See [`crate::client::fluent_builders::AdminDisableProviderForUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminDisableProviderForUser {
    _private: (),
}
impl AdminDisableProviderForUser {
    /// Creates a new builder-style object to manufacture [`AdminDisableProviderForUserInput`](crate::input::AdminDisableProviderForUserInput)
    pub fn builder() -> crate::input::admin_disable_provider_for_user_input::Builder {
        crate::input::admin_disable_provider_for_user_input::Builder::default()
    }
    /// Creates a new `AdminDisableProviderForUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminDisableProviderForUser {
    type Output = std::result::Result<
        crate::output::AdminDisableProviderForUserOutput,
        crate::error::AdminDisableProviderForUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_disable_provider_for_user_error(response)
        } else {
            crate::operation_deser::parse_admin_disable_provider_for_user_response(response)
        }
    }
}

/// Operation shape for `AdminDisableUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_disable_user`](crate::client::Client::admin_disable_user).
///
/// See [`crate::client::fluent_builders::AdminDisableUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminDisableUser {
    _private: (),
}
impl AdminDisableUser {
    /// Creates a new builder-style object to manufacture [`AdminDisableUserInput`](crate::input::AdminDisableUserInput)
    pub fn builder() -> crate::input::admin_disable_user_input::Builder {
        crate::input::admin_disable_user_input::Builder::default()
    }
    /// Creates a new `AdminDisableUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminDisableUser {
    type Output = std::result::Result<
        crate::output::AdminDisableUserOutput,
        crate::error::AdminDisableUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_disable_user_error(response)
        } else {
            crate::operation_deser::parse_admin_disable_user_response(response)
        }
    }
}

/// Operation shape for `AdminEnableUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_enable_user`](crate::client::Client::admin_enable_user).
///
/// See [`crate::client::fluent_builders::AdminEnableUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminEnableUser {
    _private: (),
}
impl AdminEnableUser {
    /// Creates a new builder-style object to manufacture [`AdminEnableUserInput`](crate::input::AdminEnableUserInput)
    pub fn builder() -> crate::input::admin_enable_user_input::Builder {
        crate::input::admin_enable_user_input::Builder::default()
    }
    /// Creates a new `AdminEnableUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminEnableUser {
    type Output = std::result::Result<
        crate::output::AdminEnableUserOutput,
        crate::error::AdminEnableUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_enable_user_error(response)
        } else {
            crate::operation_deser::parse_admin_enable_user_response(response)
        }
    }
}

/// Operation shape for `AdminForgetDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_forget_device`](crate::client::Client::admin_forget_device).
///
/// See [`crate::client::fluent_builders::AdminForgetDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminForgetDevice {
    _private: (),
}
impl AdminForgetDevice {
    /// Creates a new builder-style object to manufacture [`AdminForgetDeviceInput`](crate::input::AdminForgetDeviceInput)
    pub fn builder() -> crate::input::admin_forget_device_input::Builder {
        crate::input::admin_forget_device_input::Builder::default()
    }
    /// Creates a new `AdminForgetDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminForgetDevice {
    type Output = std::result::Result<
        crate::output::AdminForgetDeviceOutput,
        crate::error::AdminForgetDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_forget_device_error(response)
        } else {
            crate::operation_deser::parse_admin_forget_device_response(response)
        }
    }
}

/// Operation shape for `AdminGetDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_get_device`](crate::client::Client::admin_get_device).
///
/// See [`crate::client::fluent_builders::AdminGetDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminGetDevice {
    _private: (),
}
impl AdminGetDevice {
    /// Creates a new builder-style object to manufacture [`AdminGetDeviceInput`](crate::input::AdminGetDeviceInput)
    pub fn builder() -> crate::input::admin_get_device_input::Builder {
        crate::input::admin_get_device_input::Builder::default()
    }
    /// Creates a new `AdminGetDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminGetDevice {
    type Output =
        std::result::Result<crate::output::AdminGetDeviceOutput, crate::error::AdminGetDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_get_device_error(response)
        } else {
            crate::operation_deser::parse_admin_get_device_response(response)
        }
    }
}

/// Operation shape for `AdminGetUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_get_user`](crate::client::Client::admin_get_user).
///
/// See [`crate::client::fluent_builders::AdminGetUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminGetUser {
    _private: (),
}
impl AdminGetUser {
    /// Creates a new builder-style object to manufacture [`AdminGetUserInput`](crate::input::AdminGetUserInput)
    pub fn builder() -> crate::input::admin_get_user_input::Builder {
        crate::input::admin_get_user_input::Builder::default()
    }
    /// Creates a new `AdminGetUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminGetUser {
    type Output =
        std::result::Result<crate::output::AdminGetUserOutput, crate::error::AdminGetUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_get_user_error(response)
        } else {
            crate::operation_deser::parse_admin_get_user_response(response)
        }
    }
}

/// Operation shape for `AdminInitiateAuth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_initiate_auth`](crate::client::Client::admin_initiate_auth).
///
/// See [`crate::client::fluent_builders::AdminInitiateAuth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminInitiateAuth {
    _private: (),
}
impl AdminInitiateAuth {
    /// Creates a new builder-style object to manufacture [`AdminInitiateAuthInput`](crate::input::AdminInitiateAuthInput)
    pub fn builder() -> crate::input::admin_initiate_auth_input::Builder {
        crate::input::admin_initiate_auth_input::Builder::default()
    }
    /// Creates a new `AdminInitiateAuth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminInitiateAuth {
    type Output = std::result::Result<
        crate::output::AdminInitiateAuthOutput,
        crate::error::AdminInitiateAuthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_initiate_auth_error(response)
        } else {
            crate::operation_deser::parse_admin_initiate_auth_response(response)
        }
    }
}

/// Operation shape for `AdminLinkProviderForUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_link_provider_for_user`](crate::client::Client::admin_link_provider_for_user).
///
/// See [`crate::client::fluent_builders::AdminLinkProviderForUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminLinkProviderForUser {
    _private: (),
}
impl AdminLinkProviderForUser {
    /// Creates a new builder-style object to manufacture [`AdminLinkProviderForUserInput`](crate::input::AdminLinkProviderForUserInput)
    pub fn builder() -> crate::input::admin_link_provider_for_user_input::Builder {
        crate::input::admin_link_provider_for_user_input::Builder::default()
    }
    /// Creates a new `AdminLinkProviderForUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminLinkProviderForUser {
    type Output = std::result::Result<
        crate::output::AdminLinkProviderForUserOutput,
        crate::error::AdminLinkProviderForUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_link_provider_for_user_error(response)
        } else {
            crate::operation_deser::parse_admin_link_provider_for_user_response(response)
        }
    }
}

/// Operation shape for `AdminListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_list_devices`](crate::client::Client::admin_list_devices).
///
/// See [`crate::client::fluent_builders::AdminListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminListDevices {
    _private: (),
}
impl AdminListDevices {
    /// Creates a new builder-style object to manufacture [`AdminListDevicesInput`](crate::input::AdminListDevicesInput)
    pub fn builder() -> crate::input::admin_list_devices_input::Builder {
        crate::input::admin_list_devices_input::Builder::default()
    }
    /// Creates a new `AdminListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminListDevices {
    type Output = std::result::Result<
        crate::output::AdminListDevicesOutput,
        crate::error::AdminListDevicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_list_devices_error(response)
        } else {
            crate::operation_deser::parse_admin_list_devices_response(response)
        }
    }
}

/// Operation shape for `AdminListGroupsForUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_list_groups_for_user`](crate::client::Client::admin_list_groups_for_user).
///
/// See [`crate::client::fluent_builders::AdminListGroupsForUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminListGroupsForUser {
    _private: (),
}
impl AdminListGroupsForUser {
    /// Creates a new builder-style object to manufacture [`AdminListGroupsForUserInput`](crate::input::AdminListGroupsForUserInput)
    pub fn builder() -> crate::input::admin_list_groups_for_user_input::Builder {
        crate::input::admin_list_groups_for_user_input::Builder::default()
    }
    /// Creates a new `AdminListGroupsForUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminListGroupsForUser {
    type Output = std::result::Result<
        crate::output::AdminListGroupsForUserOutput,
        crate::error::AdminListGroupsForUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_list_groups_for_user_error(response)
        } else {
            crate::operation_deser::parse_admin_list_groups_for_user_response(response)
        }
    }
}

/// Operation shape for `AdminListUserAuthEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_list_user_auth_events`](crate::client::Client::admin_list_user_auth_events).
///
/// See [`crate::client::fluent_builders::AdminListUserAuthEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminListUserAuthEvents {
    _private: (),
}
impl AdminListUserAuthEvents {
    /// Creates a new builder-style object to manufacture [`AdminListUserAuthEventsInput`](crate::input::AdminListUserAuthEventsInput)
    pub fn builder() -> crate::input::admin_list_user_auth_events_input::Builder {
        crate::input::admin_list_user_auth_events_input::Builder::default()
    }
    /// Creates a new `AdminListUserAuthEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminListUserAuthEvents {
    type Output = std::result::Result<
        crate::output::AdminListUserAuthEventsOutput,
        crate::error::AdminListUserAuthEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_list_user_auth_events_error(response)
        } else {
            crate::operation_deser::parse_admin_list_user_auth_events_response(response)
        }
    }
}

/// Operation shape for `AdminRemoveUserFromGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_remove_user_from_group`](crate::client::Client::admin_remove_user_from_group).
///
/// See [`crate::client::fluent_builders::AdminRemoveUserFromGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminRemoveUserFromGroup {
    _private: (),
}
impl AdminRemoveUserFromGroup {
    /// Creates a new builder-style object to manufacture [`AdminRemoveUserFromGroupInput`](crate::input::AdminRemoveUserFromGroupInput)
    pub fn builder() -> crate::input::admin_remove_user_from_group_input::Builder {
        crate::input::admin_remove_user_from_group_input::Builder::default()
    }
    /// Creates a new `AdminRemoveUserFromGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminRemoveUserFromGroup {
    type Output = std::result::Result<
        crate::output::AdminRemoveUserFromGroupOutput,
        crate::error::AdminRemoveUserFromGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_remove_user_from_group_error(response)
        } else {
            crate::operation_deser::parse_admin_remove_user_from_group_response(response)
        }
    }
}

/// Operation shape for `AdminResetUserPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_reset_user_password`](crate::client::Client::admin_reset_user_password).
///
/// See [`crate::client::fluent_builders::AdminResetUserPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminResetUserPassword {
    _private: (),
}
impl AdminResetUserPassword {
    /// Creates a new builder-style object to manufacture [`AdminResetUserPasswordInput`](crate::input::AdminResetUserPasswordInput)
    pub fn builder() -> crate::input::admin_reset_user_password_input::Builder {
        crate::input::admin_reset_user_password_input::Builder::default()
    }
    /// Creates a new `AdminResetUserPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminResetUserPassword {
    type Output = std::result::Result<
        crate::output::AdminResetUserPasswordOutput,
        crate::error::AdminResetUserPasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_reset_user_password_error(response)
        } else {
            crate::operation_deser::parse_admin_reset_user_password_response(response)
        }
    }
}

/// Operation shape for `AdminRespondToAuthChallenge`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_respond_to_auth_challenge`](crate::client::Client::admin_respond_to_auth_challenge).
///
/// See [`crate::client::fluent_builders::AdminRespondToAuthChallenge`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminRespondToAuthChallenge {
    _private: (),
}
impl AdminRespondToAuthChallenge {
    /// Creates a new builder-style object to manufacture [`AdminRespondToAuthChallengeInput`](crate::input::AdminRespondToAuthChallengeInput)
    pub fn builder() -> crate::input::admin_respond_to_auth_challenge_input::Builder {
        crate::input::admin_respond_to_auth_challenge_input::Builder::default()
    }
    /// Creates a new `AdminRespondToAuthChallenge` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminRespondToAuthChallenge {
    type Output = std::result::Result<
        crate::output::AdminRespondToAuthChallengeOutput,
        crate::error::AdminRespondToAuthChallengeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_respond_to_auth_challenge_error(response)
        } else {
            crate::operation_deser::parse_admin_respond_to_auth_challenge_response(response)
        }
    }
}

/// Operation shape for `AdminSetUserMFAPreference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_set_user_mfa_preference`](crate::client::Client::admin_set_user_mfa_preference).
///
/// See [`crate::client::fluent_builders::AdminSetUserMFAPreference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminSetUserMFAPreference {
    _private: (),
}
impl AdminSetUserMFAPreference {
    /// Creates a new builder-style object to manufacture [`AdminSetUserMfaPreferenceInput`](crate::input::AdminSetUserMfaPreferenceInput)
    pub fn builder() -> crate::input::admin_set_user_mfa_preference_input::Builder {
        crate::input::admin_set_user_mfa_preference_input::Builder::default()
    }
    /// Creates a new `AdminSetUserMFAPreference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminSetUserMFAPreference {
    type Output = std::result::Result<
        crate::output::AdminSetUserMfaPreferenceOutput,
        crate::error::AdminSetUserMFAPreferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_set_user_mfa_preference_error(response)
        } else {
            crate::operation_deser::parse_admin_set_user_mfa_preference_response(response)
        }
    }
}

/// Operation shape for `AdminSetUserPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_set_user_password`](crate::client::Client::admin_set_user_password).
///
/// See [`crate::client::fluent_builders::AdminSetUserPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminSetUserPassword {
    _private: (),
}
impl AdminSetUserPassword {
    /// Creates a new builder-style object to manufacture [`AdminSetUserPasswordInput`](crate::input::AdminSetUserPasswordInput)
    pub fn builder() -> crate::input::admin_set_user_password_input::Builder {
        crate::input::admin_set_user_password_input::Builder::default()
    }
    /// Creates a new `AdminSetUserPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminSetUserPassword {
    type Output = std::result::Result<
        crate::output::AdminSetUserPasswordOutput,
        crate::error::AdminSetUserPasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_set_user_password_error(response)
        } else {
            crate::operation_deser::parse_admin_set_user_password_response(response)
        }
    }
}

/// Operation shape for `AdminSetUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_set_user_settings`](crate::client::Client::admin_set_user_settings).
///
/// See [`crate::client::fluent_builders::AdminSetUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminSetUserSettings {
    _private: (),
}
impl AdminSetUserSettings {
    /// Creates a new builder-style object to manufacture [`AdminSetUserSettingsInput`](crate::input::AdminSetUserSettingsInput)
    pub fn builder() -> crate::input::admin_set_user_settings_input::Builder {
        crate::input::admin_set_user_settings_input::Builder::default()
    }
    /// Creates a new `AdminSetUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminSetUserSettings {
    type Output = std::result::Result<
        crate::output::AdminSetUserSettingsOutput,
        crate::error::AdminSetUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_set_user_settings_error(response)
        } else {
            crate::operation_deser::parse_admin_set_user_settings_response(response)
        }
    }
}

/// Operation shape for `AdminUpdateAuthEventFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_update_auth_event_feedback`](crate::client::Client::admin_update_auth_event_feedback).
///
/// See [`crate::client::fluent_builders::AdminUpdateAuthEventFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminUpdateAuthEventFeedback {
    _private: (),
}
impl AdminUpdateAuthEventFeedback {
    /// Creates a new builder-style object to manufacture [`AdminUpdateAuthEventFeedbackInput`](crate::input::AdminUpdateAuthEventFeedbackInput)
    pub fn builder() -> crate::input::admin_update_auth_event_feedback_input::Builder {
        crate::input::admin_update_auth_event_feedback_input::Builder::default()
    }
    /// Creates a new `AdminUpdateAuthEventFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminUpdateAuthEventFeedback {
    type Output = std::result::Result<
        crate::output::AdminUpdateAuthEventFeedbackOutput,
        crate::error::AdminUpdateAuthEventFeedbackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_update_auth_event_feedback_error(response)
        } else {
            crate::operation_deser::parse_admin_update_auth_event_feedback_response(response)
        }
    }
}

/// Operation shape for `AdminUpdateDeviceStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_update_device_status`](crate::client::Client::admin_update_device_status).
///
/// See [`crate::client::fluent_builders::AdminUpdateDeviceStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminUpdateDeviceStatus {
    _private: (),
}
impl AdminUpdateDeviceStatus {
    /// Creates a new builder-style object to manufacture [`AdminUpdateDeviceStatusInput`](crate::input::AdminUpdateDeviceStatusInput)
    pub fn builder() -> crate::input::admin_update_device_status_input::Builder {
        crate::input::admin_update_device_status_input::Builder::default()
    }
    /// Creates a new `AdminUpdateDeviceStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminUpdateDeviceStatus {
    type Output = std::result::Result<
        crate::output::AdminUpdateDeviceStatusOutput,
        crate::error::AdminUpdateDeviceStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_update_device_status_error(response)
        } else {
            crate::operation_deser::parse_admin_update_device_status_response(response)
        }
    }
}

/// Operation shape for `AdminUpdateUserAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_update_user_attributes`](crate::client::Client::admin_update_user_attributes).
///
/// See [`crate::client::fluent_builders::AdminUpdateUserAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminUpdateUserAttributes {
    _private: (),
}
impl AdminUpdateUserAttributes {
    /// Creates a new builder-style object to manufacture [`AdminUpdateUserAttributesInput`](crate::input::AdminUpdateUserAttributesInput)
    pub fn builder() -> crate::input::admin_update_user_attributes_input::Builder {
        crate::input::admin_update_user_attributes_input::Builder::default()
    }
    /// Creates a new `AdminUpdateUserAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminUpdateUserAttributes {
    type Output = std::result::Result<
        crate::output::AdminUpdateUserAttributesOutput,
        crate::error::AdminUpdateUserAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_update_user_attributes_error(response)
        } else {
            crate::operation_deser::parse_admin_update_user_attributes_response(response)
        }
    }
}

/// Operation shape for `AdminUserGlobalSignOut`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`admin_user_global_sign_out`](crate::client::Client::admin_user_global_sign_out).
///
/// See [`crate::client::fluent_builders::AdminUserGlobalSignOut`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdminUserGlobalSignOut {
    _private: (),
}
impl AdminUserGlobalSignOut {
    /// Creates a new builder-style object to manufacture [`AdminUserGlobalSignOutInput`](crate::input::AdminUserGlobalSignOutInput)
    pub fn builder() -> crate::input::admin_user_global_sign_out_input::Builder {
        crate::input::admin_user_global_sign_out_input::Builder::default()
    }
    /// Creates a new `AdminUserGlobalSignOut` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdminUserGlobalSignOut {
    type Output = std::result::Result<
        crate::output::AdminUserGlobalSignOutOutput,
        crate::error::AdminUserGlobalSignOutError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_admin_user_global_sign_out_error(response)
        } else {
            crate::operation_deser::parse_admin_user_global_sign_out_response(response)
        }
    }
}

/// Operation shape for `AssociateSoftwareToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_software_token`](crate::client::Client::associate_software_token).
///
/// See [`crate::client::fluent_builders::AssociateSoftwareToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSoftwareToken {
    _private: (),
}
impl AssociateSoftwareToken {
    /// Creates a new builder-style object to manufacture [`AssociateSoftwareTokenInput`](crate::input::AssociateSoftwareTokenInput)
    pub fn builder() -> crate::input::associate_software_token_input::Builder {
        crate::input::associate_software_token_input::Builder::default()
    }
    /// Creates a new `AssociateSoftwareToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSoftwareToken {
    type Output = std::result::Result<
        crate::output::AssociateSoftwareTokenOutput,
        crate::error::AssociateSoftwareTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_software_token_error(response)
        } else {
            crate::operation_deser::parse_associate_software_token_response(response)
        }
    }
}

/// Operation shape for `ChangePassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`change_password`](crate::client::Client::change_password).
///
/// See [`crate::client::fluent_builders::ChangePassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ChangePassword {
    _private: (),
}
impl ChangePassword {
    /// Creates a new builder-style object to manufacture [`ChangePasswordInput`](crate::input::ChangePasswordInput)
    pub fn builder() -> crate::input::change_password_input::Builder {
        crate::input::change_password_input::Builder::default()
    }
    /// Creates a new `ChangePassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ChangePassword {
    type Output =
        std::result::Result<crate::output::ChangePasswordOutput, crate::error::ChangePasswordError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_change_password_error(response)
        } else {
            crate::operation_deser::parse_change_password_response(response)
        }
    }
}

/// Operation shape for `ConfirmDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`confirm_device`](crate::client::Client::confirm_device).
///
/// See [`crate::client::fluent_builders::ConfirmDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfirmDevice {
    _private: (),
}
impl ConfirmDevice {
    /// Creates a new builder-style object to manufacture [`ConfirmDeviceInput`](crate::input::ConfirmDeviceInput)
    pub fn builder() -> crate::input::confirm_device_input::Builder {
        crate::input::confirm_device_input::Builder::default()
    }
    /// Creates a new `ConfirmDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfirmDevice {
    type Output =
        std::result::Result<crate::output::ConfirmDeviceOutput, crate::error::ConfirmDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_confirm_device_error(response)
        } else {
            crate::operation_deser::parse_confirm_device_response(response)
        }
    }
}

/// Operation shape for `ConfirmForgotPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`confirm_forgot_password`](crate::client::Client::confirm_forgot_password).
///
/// See [`crate::client::fluent_builders::ConfirmForgotPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfirmForgotPassword {
    _private: (),
}
impl ConfirmForgotPassword {
    /// Creates a new builder-style object to manufacture [`ConfirmForgotPasswordInput`](crate::input::ConfirmForgotPasswordInput)
    pub fn builder() -> crate::input::confirm_forgot_password_input::Builder {
        crate::input::confirm_forgot_password_input::Builder::default()
    }
    /// Creates a new `ConfirmForgotPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfirmForgotPassword {
    type Output = std::result::Result<
        crate::output::ConfirmForgotPasswordOutput,
        crate::error::ConfirmForgotPasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_confirm_forgot_password_error(response)
        } else {
            crate::operation_deser::parse_confirm_forgot_password_response(response)
        }
    }
}

/// Operation shape for `ConfirmSignUp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`confirm_sign_up`](crate::client::Client::confirm_sign_up).
///
/// See [`crate::client::fluent_builders::ConfirmSignUp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfirmSignUp {
    _private: (),
}
impl ConfirmSignUp {
    /// Creates a new builder-style object to manufacture [`ConfirmSignUpInput`](crate::input::ConfirmSignUpInput)
    pub fn builder() -> crate::input::confirm_sign_up_input::Builder {
        crate::input::confirm_sign_up_input::Builder::default()
    }
    /// Creates a new `ConfirmSignUp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfirmSignUp {
    type Output =
        std::result::Result<crate::output::ConfirmSignUpOutput, crate::error::ConfirmSignUpError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_confirm_sign_up_error(response)
        } else {
            crate::operation_deser::parse_confirm_sign_up_response(response)
        }
    }
}

/// Operation shape for `CreateGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_group`](crate::client::Client::create_group).
///
/// See [`crate::client::fluent_builders::CreateGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGroup {
    _private: (),
}
impl CreateGroup {
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
    /// Creates a new `CreateGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGroup {
    type Output =
        std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_group_error(response)
        } else {
            crate::operation_deser::parse_create_group_response(response)
        }
    }
}

/// Operation shape for `CreateIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_identity_provider`](crate::client::Client::create_identity_provider).
///
/// See [`crate::client::fluent_builders::CreateIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIdentityProvider {
    _private: (),
}
impl CreateIdentityProvider {
    /// Creates a new builder-style object to manufacture [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
    pub fn builder() -> crate::input::create_identity_provider_input::Builder {
        crate::input::create_identity_provider_input::Builder::default()
    }
    /// Creates a new `CreateIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIdentityProvider {
    type Output = std::result::Result<
        crate::output::CreateIdentityProviderOutput,
        crate::error::CreateIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_create_identity_provider_response(response)
        }
    }
}

/// Operation shape for `CreateResourceServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_server`](crate::client::Client::create_resource_server).
///
/// See [`crate::client::fluent_builders::CreateResourceServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourceServer {
    _private: (),
}
impl CreateResourceServer {
    /// Creates a new builder-style object to manufacture [`CreateResourceServerInput`](crate::input::CreateResourceServerInput)
    pub fn builder() -> crate::input::create_resource_server_input::Builder {
        crate::input::create_resource_server_input::Builder::default()
    }
    /// Creates a new `CreateResourceServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourceServer {
    type Output = std::result::Result<
        crate::output::CreateResourceServerOutput,
        crate::error::CreateResourceServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_server_error(response)
        } else {
            crate::operation_deser::parse_create_resource_server_response(response)
        }
    }
}

/// Operation shape for `CreateUserImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_import_job`](crate::client::Client::create_user_import_job).
///
/// See [`crate::client::fluent_builders::CreateUserImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserImportJob {
    _private: (),
}
impl CreateUserImportJob {
    /// Creates a new builder-style object to manufacture [`CreateUserImportJobInput`](crate::input::CreateUserImportJobInput)
    pub fn builder() -> crate::input::create_user_import_job_input::Builder {
        crate::input::create_user_import_job_input::Builder::default()
    }
    /// Creates a new `CreateUserImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserImportJob {
    type Output = std::result::Result<
        crate::output::CreateUserImportJobOutput,
        crate::error::CreateUserImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_import_job_error(response)
        } else {
            crate::operation_deser::parse_create_user_import_job_response(response)
        }
    }
}

/// Operation shape for `CreateUserPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_pool`](crate::client::Client::create_user_pool).
///
/// See [`crate::client::fluent_builders::CreateUserPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserPool {
    _private: (),
}
impl CreateUserPool {
    /// Creates a new builder-style object to manufacture [`CreateUserPoolInput`](crate::input::CreateUserPoolInput)
    pub fn builder() -> crate::input::create_user_pool_input::Builder {
        crate::input::create_user_pool_input::Builder::default()
    }
    /// Creates a new `CreateUserPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserPool {
    type Output =
        std::result::Result<crate::output::CreateUserPoolOutput, crate::error::CreateUserPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_pool_error(response)
        } else {
            crate::operation_deser::parse_create_user_pool_response(response)
        }
    }
}

/// Operation shape for `CreateUserPoolClient`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_pool_client`](crate::client::Client::create_user_pool_client).
///
/// See [`crate::client::fluent_builders::CreateUserPoolClient`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserPoolClient {
    _private: (),
}
impl CreateUserPoolClient {
    /// Creates a new builder-style object to manufacture [`CreateUserPoolClientInput`](crate::input::CreateUserPoolClientInput)
    pub fn builder() -> crate::input::create_user_pool_client_input::Builder {
        crate::input::create_user_pool_client_input::Builder::default()
    }
    /// Creates a new `CreateUserPoolClient` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserPoolClient {
    type Output = std::result::Result<
        crate::output::CreateUserPoolClientOutput,
        crate::error::CreateUserPoolClientError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_pool_client_error(response)
        } else {
            crate::operation_deser::parse_create_user_pool_client_response(response)
        }
    }
}

/// Operation shape for `CreateUserPoolDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_pool_domain`](crate::client::Client::create_user_pool_domain).
///
/// See [`crate::client::fluent_builders::CreateUserPoolDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserPoolDomain {
    _private: (),
}
impl CreateUserPoolDomain {
    /// Creates a new builder-style object to manufacture [`CreateUserPoolDomainInput`](crate::input::CreateUserPoolDomainInput)
    pub fn builder() -> crate::input::create_user_pool_domain_input::Builder {
        crate::input::create_user_pool_domain_input::Builder::default()
    }
    /// Creates a new `CreateUserPoolDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserPoolDomain {
    type Output = std::result::Result<
        crate::output::CreateUserPoolDomainOutput,
        crate::error::CreateUserPoolDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_pool_domain_error(response)
        } else {
            crate::operation_deser::parse_create_user_pool_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_group`](crate::client::Client::delete_group).
///
/// See [`crate::client::fluent_builders::DeleteGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGroup {
    _private: (),
}
impl DeleteGroup {
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
    /// Creates a new `DeleteGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGroup {
    type Output =
        std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_group_error(response)
        } else {
            crate::operation_deser::parse_delete_group_response(response)
        }
    }
}

/// Operation shape for `DeleteIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_identity_provider`](crate::client::Client::delete_identity_provider).
///
/// See [`crate::client::fluent_builders::DeleteIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIdentityProvider {
    _private: (),
}
impl DeleteIdentityProvider {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
    pub fn builder() -> crate::input::delete_identity_provider_input::Builder {
        crate::input::delete_identity_provider_input::Builder::default()
    }
    /// Creates a new `DeleteIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIdentityProvider {
    type Output = std::result::Result<
        crate::output::DeleteIdentityProviderOutput,
        crate::error::DeleteIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_delete_identity_provider_response(response)
        }
    }
}

/// Operation shape for `DeleteResourceServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_server`](crate::client::Client::delete_resource_server).
///
/// See [`crate::client::fluent_builders::DeleteResourceServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourceServer {
    _private: (),
}
impl DeleteResourceServer {
    /// Creates a new builder-style object to manufacture [`DeleteResourceServerInput`](crate::input::DeleteResourceServerInput)
    pub fn builder() -> crate::input::delete_resource_server_input::Builder {
        crate::input::delete_resource_server_input::Builder::default()
    }
    /// Creates a new `DeleteResourceServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourceServer {
    type Output = std::result::Result<
        crate::output::DeleteResourceServerOutput,
        crate::error::DeleteResourceServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_server_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_server_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DeleteUserAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_attributes`](crate::client::Client::delete_user_attributes).
///
/// See [`crate::client::fluent_builders::DeleteUserAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserAttributes {
    _private: (),
}
impl DeleteUserAttributes {
    /// Creates a new builder-style object to manufacture [`DeleteUserAttributesInput`](crate::input::DeleteUserAttributesInput)
    pub fn builder() -> crate::input::delete_user_attributes_input::Builder {
        crate::input::delete_user_attributes_input::Builder::default()
    }
    /// Creates a new `DeleteUserAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserAttributes {
    type Output = std::result::Result<
        crate::output::DeleteUserAttributesOutput,
        crate::error::DeleteUserAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_attributes_error(response)
        } else {
            crate::operation_deser::parse_delete_user_attributes_response(response)
        }
    }
}

/// Operation shape for `DeleteUserPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_pool`](crate::client::Client::delete_user_pool).
///
/// See [`crate::client::fluent_builders::DeleteUserPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserPool {
    _private: (),
}
impl DeleteUserPool {
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolInput`](crate::input::DeleteUserPoolInput)
    pub fn builder() -> crate::input::delete_user_pool_input::Builder {
        crate::input::delete_user_pool_input::Builder::default()
    }
    /// Creates a new `DeleteUserPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserPool {
    type Output =
        std::result::Result<crate::output::DeleteUserPoolOutput, crate::error::DeleteUserPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_user_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteUserPoolClient`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_pool_client`](crate::client::Client::delete_user_pool_client).
///
/// See [`crate::client::fluent_builders::DeleteUserPoolClient`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserPoolClient {
    _private: (),
}
impl DeleteUserPoolClient {
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolClientInput`](crate::input::DeleteUserPoolClientInput)
    pub fn builder() -> crate::input::delete_user_pool_client_input::Builder {
        crate::input::delete_user_pool_client_input::Builder::default()
    }
    /// Creates a new `DeleteUserPoolClient` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserPoolClient {
    type Output = std::result::Result<
        crate::output::DeleteUserPoolClientOutput,
        crate::error::DeleteUserPoolClientError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_pool_client_error(response)
        } else {
            crate::operation_deser::parse_delete_user_pool_client_response(response)
        }
    }
}

/// Operation shape for `DeleteUserPoolDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_pool_domain`](crate::client::Client::delete_user_pool_domain).
///
/// See [`crate::client::fluent_builders::DeleteUserPoolDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserPoolDomain {
    _private: (),
}
impl DeleteUserPoolDomain {
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolDomainInput`](crate::input::DeleteUserPoolDomainInput)
    pub fn builder() -> crate::input::delete_user_pool_domain_input::Builder {
        crate::input::delete_user_pool_domain_input::Builder::default()
    }
    /// Creates a new `DeleteUserPoolDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserPoolDomain {
    type Output = std::result::Result<
        crate::output::DeleteUserPoolDomainOutput,
        crate::error::DeleteUserPoolDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_pool_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_user_pool_domain_response(response)
        }
    }
}

/// Operation shape for `DescribeIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_identity_provider`](crate::client::Client::describe_identity_provider).
///
/// See [`crate::client::fluent_builders::DescribeIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIdentityProvider {
    _private: (),
}
impl DescribeIdentityProvider {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityProviderInput`](crate::input::DescribeIdentityProviderInput)
    pub fn builder() -> crate::input::describe_identity_provider_input::Builder {
        crate::input::describe_identity_provider_input::Builder::default()
    }
    /// Creates a new `DescribeIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIdentityProvider {
    type Output = std::result::Result<
        crate::output::DescribeIdentityProviderOutput,
        crate::error::DescribeIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_describe_identity_provider_response(response)
        }
    }
}

/// Operation shape for `DescribeResourceServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource_server`](crate::client::Client::describe_resource_server).
///
/// See [`crate::client::fluent_builders::DescribeResourceServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResourceServer {
    _private: (),
}
impl DescribeResourceServer {
    /// Creates a new builder-style object to manufacture [`DescribeResourceServerInput`](crate::input::DescribeResourceServerInput)
    pub fn builder() -> crate::input::describe_resource_server_input::Builder {
        crate::input::describe_resource_server_input::Builder::default()
    }
    /// Creates a new `DescribeResourceServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResourceServer {
    type Output = std::result::Result<
        crate::output::DescribeResourceServerOutput,
        crate::error::DescribeResourceServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_server_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_server_response(response)
        }
    }
}

/// Operation shape for `DescribeRiskConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_risk_configuration`](crate::client::Client::describe_risk_configuration).
///
/// See [`crate::client::fluent_builders::DescribeRiskConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRiskConfiguration {
    _private: (),
}
impl DescribeRiskConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeRiskConfigurationInput`](crate::input::DescribeRiskConfigurationInput)
    pub fn builder() -> crate::input::describe_risk_configuration_input::Builder {
        crate::input::describe_risk_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeRiskConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRiskConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeRiskConfigurationOutput,
        crate::error::DescribeRiskConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_risk_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_risk_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeUserImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_import_job`](crate::client::Client::describe_user_import_job).
///
/// See [`crate::client::fluent_builders::DescribeUserImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserImportJob {
    _private: (),
}
impl DescribeUserImportJob {
    /// Creates a new builder-style object to manufacture [`DescribeUserImportJobInput`](crate::input::DescribeUserImportJobInput)
    pub fn builder() -> crate::input::describe_user_import_job_input::Builder {
        crate::input::describe_user_import_job_input::Builder::default()
    }
    /// Creates a new `DescribeUserImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserImportJob {
    type Output = std::result::Result<
        crate::output::DescribeUserImportJobOutput,
        crate::error::DescribeUserImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_import_job_error(response)
        } else {
            crate::operation_deser::parse_describe_user_import_job_response(response)
        }
    }
}

/// Operation shape for `DescribeUserPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_pool`](crate::client::Client::describe_user_pool).
///
/// See [`crate::client::fluent_builders::DescribeUserPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserPool {
    _private: (),
}
impl DescribeUserPool {
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolInput`](crate::input::DescribeUserPoolInput)
    pub fn builder() -> crate::input::describe_user_pool_input::Builder {
        crate::input::describe_user_pool_input::Builder::default()
    }
    /// Creates a new `DescribeUserPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserPool {
    type Output = std::result::Result<
        crate::output::DescribeUserPoolOutput,
        crate::error::DescribeUserPoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_pool_error(response)
        } else {
            crate::operation_deser::parse_describe_user_pool_response(response)
        }
    }
}

/// Operation shape for `DescribeUserPoolClient`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_pool_client`](crate::client::Client::describe_user_pool_client).
///
/// See [`crate::client::fluent_builders::DescribeUserPoolClient`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserPoolClient {
    _private: (),
}
impl DescribeUserPoolClient {
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolClientInput`](crate::input::DescribeUserPoolClientInput)
    pub fn builder() -> crate::input::describe_user_pool_client_input::Builder {
        crate::input::describe_user_pool_client_input::Builder::default()
    }
    /// Creates a new `DescribeUserPoolClient` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserPoolClient {
    type Output = std::result::Result<
        crate::output::DescribeUserPoolClientOutput,
        crate::error::DescribeUserPoolClientError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_pool_client_error(response)
        } else {
            crate::operation_deser::parse_describe_user_pool_client_response(response)
        }
    }
}

/// Operation shape for `DescribeUserPoolDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_pool_domain`](crate::client::Client::describe_user_pool_domain).
///
/// See [`crate::client::fluent_builders::DescribeUserPoolDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserPoolDomain {
    _private: (),
}
impl DescribeUserPoolDomain {
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolDomainInput`](crate::input::DescribeUserPoolDomainInput)
    pub fn builder() -> crate::input::describe_user_pool_domain_input::Builder {
        crate::input::describe_user_pool_domain_input::Builder::default()
    }
    /// Creates a new `DescribeUserPoolDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserPoolDomain {
    type Output = std::result::Result<
        crate::output::DescribeUserPoolDomainOutput,
        crate::error::DescribeUserPoolDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_pool_domain_error(response)
        } else {
            crate::operation_deser::parse_describe_user_pool_domain_response(response)
        }
    }
}

/// Operation shape for `ForgetDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`forget_device`](crate::client::Client::forget_device).
///
/// See [`crate::client::fluent_builders::ForgetDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ForgetDevice {
    _private: (),
}
impl ForgetDevice {
    /// Creates a new builder-style object to manufacture [`ForgetDeviceInput`](crate::input::ForgetDeviceInput)
    pub fn builder() -> crate::input::forget_device_input::Builder {
        crate::input::forget_device_input::Builder::default()
    }
    /// Creates a new `ForgetDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ForgetDevice {
    type Output =
        std::result::Result<crate::output::ForgetDeviceOutput, crate::error::ForgetDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_forget_device_error(response)
        } else {
            crate::operation_deser::parse_forget_device_response(response)
        }
    }
}

/// Operation shape for `ForgotPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`forgot_password`](crate::client::Client::forgot_password).
///
/// See [`crate::client::fluent_builders::ForgotPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ForgotPassword {
    _private: (),
}
impl ForgotPassword {
    /// Creates a new builder-style object to manufacture [`ForgotPasswordInput`](crate::input::ForgotPasswordInput)
    pub fn builder() -> crate::input::forgot_password_input::Builder {
        crate::input::forgot_password_input::Builder::default()
    }
    /// Creates a new `ForgotPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ForgotPassword {
    type Output =
        std::result::Result<crate::output::ForgotPasswordOutput, crate::error::ForgotPasswordError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_forgot_password_error(response)
        } else {
            crate::operation_deser::parse_forgot_password_response(response)
        }
    }
}

/// Operation shape for `GetCSVHeader`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_csv_header`](crate::client::Client::get_csv_header).
///
/// See [`crate::client::fluent_builders::GetCSVHeader`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCSVHeader {
    _private: (),
}
impl GetCSVHeader {
    /// Creates a new builder-style object to manufacture [`GetCsvHeaderInput`](crate::input::GetCsvHeaderInput)
    pub fn builder() -> crate::input::get_csv_header_input::Builder {
        crate::input::get_csv_header_input::Builder::default()
    }
    /// Creates a new `GetCSVHeader` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCSVHeader {
    type Output =
        std::result::Result<crate::output::GetCsvHeaderOutput, crate::error::GetCSVHeaderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_csv_header_error(response)
        } else {
            crate::operation_deser::parse_get_csv_header_response(response)
        }
    }
}

/// Operation shape for `GetDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device`](crate::client::Client::get_device).
///
/// See [`crate::client::fluent_builders::GetDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevice {
    _private: (),
}
impl GetDevice {
    /// Creates a new builder-style object to manufacture [`GetDeviceInput`](crate::input::GetDeviceInput)
    pub fn builder() -> crate::input::get_device_input::Builder {
        crate::input::get_device_input::Builder::default()
    }
    /// Creates a new `GetDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevice {
    type Output = std::result::Result<crate::output::GetDeviceOutput, crate::error::GetDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_error(response)
        } else {
            crate::operation_deser::parse_get_device_response(response)
        }
    }
}

/// Operation shape for `GetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_group`](crate::client::Client::get_group).
///
/// See [`crate::client::fluent_builders::GetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGroup {
    _private: (),
}
impl GetGroup {
    /// Creates a new builder-style object to manufacture [`GetGroupInput`](crate::input::GetGroupInput)
    pub fn builder() -> crate::input::get_group_input::Builder {
        crate::input::get_group_input::Builder::default()
    }
    /// Creates a new `GetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGroup {
    type Output = std::result::Result<crate::output::GetGroupOutput, crate::error::GetGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_group_error(response)
        } else {
            crate::operation_deser::parse_get_group_response(response)
        }
    }
}

/// Operation shape for `GetIdentityProviderByIdentifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_identity_provider_by_identifier`](crate::client::Client::get_identity_provider_by_identifier).
///
/// See [`crate::client::fluent_builders::GetIdentityProviderByIdentifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIdentityProviderByIdentifier {
    _private: (),
}
impl GetIdentityProviderByIdentifier {
    /// Creates a new builder-style object to manufacture [`GetIdentityProviderByIdentifierInput`](crate::input::GetIdentityProviderByIdentifierInput)
    pub fn builder() -> crate::input::get_identity_provider_by_identifier_input::Builder {
        crate::input::get_identity_provider_by_identifier_input::Builder::default()
    }
    /// Creates a new `GetIdentityProviderByIdentifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIdentityProviderByIdentifier {
    type Output = std::result::Result<
        crate::output::GetIdentityProviderByIdentifierOutput,
        crate::error::GetIdentityProviderByIdentifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_identity_provider_by_identifier_error(response)
        } else {
            crate::operation_deser::parse_get_identity_provider_by_identifier_response(response)
        }
    }
}

/// Operation shape for `GetSigningCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_signing_certificate`](crate::client::Client::get_signing_certificate).
///
/// See [`crate::client::fluent_builders::GetSigningCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSigningCertificate {
    _private: (),
}
impl GetSigningCertificate {
    /// Creates a new builder-style object to manufacture [`GetSigningCertificateInput`](crate::input::GetSigningCertificateInput)
    pub fn builder() -> crate::input::get_signing_certificate_input::Builder {
        crate::input::get_signing_certificate_input::Builder::default()
    }
    /// Creates a new `GetSigningCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSigningCertificate {
    type Output = std::result::Result<
        crate::output::GetSigningCertificateOutput,
        crate::error::GetSigningCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_signing_certificate_error(response)
        } else {
            crate::operation_deser::parse_get_signing_certificate_response(response)
        }
    }
}

/// Operation shape for `GetUICustomization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ui_customization`](crate::client::Client::get_ui_customization).
///
/// See [`crate::client::fluent_builders::GetUICustomization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUICustomization {
    _private: (),
}
impl GetUICustomization {
    /// Creates a new builder-style object to manufacture [`GetUiCustomizationInput`](crate::input::GetUiCustomizationInput)
    pub fn builder() -> crate::input::get_ui_customization_input::Builder {
        crate::input::get_ui_customization_input::Builder::default()
    }
    /// Creates a new `GetUICustomization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUICustomization {
    type Output = std::result::Result<
        crate::output::GetUiCustomizationOutput,
        crate::error::GetUICustomizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ui_customization_error(response)
        } else {
            crate::operation_deser::parse_get_ui_customization_response(response)
        }
    }
}

/// Operation shape for `GetUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user`](crate::client::Client::get_user).
///
/// See [`crate::client::fluent_builders::GetUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUser {
    _private: (),
}
impl GetUser {
    /// Creates a new builder-style object to manufacture [`GetUserInput`](crate::input::GetUserInput)
    pub fn builder() -> crate::input::get_user_input::Builder {
        crate::input::get_user_input::Builder::default()
    }
    /// Creates a new `GetUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUser {
    type Output = std::result::Result<crate::output::GetUserOutput, crate::error::GetUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_error(response)
        } else {
            crate::operation_deser::parse_get_user_response(response)
        }
    }
}

/// Operation shape for `GetUserAttributeVerificationCode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user_attribute_verification_code`](crate::client::Client::get_user_attribute_verification_code).
///
/// See [`crate::client::fluent_builders::GetUserAttributeVerificationCode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUserAttributeVerificationCode {
    _private: (),
}
impl GetUserAttributeVerificationCode {
    /// Creates a new builder-style object to manufacture [`GetUserAttributeVerificationCodeInput`](crate::input::GetUserAttributeVerificationCodeInput)
    pub fn builder() -> crate::input::get_user_attribute_verification_code_input::Builder {
        crate::input::get_user_attribute_verification_code_input::Builder::default()
    }
    /// Creates a new `GetUserAttributeVerificationCode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUserAttributeVerificationCode {
    type Output = std::result::Result<
        crate::output::GetUserAttributeVerificationCodeOutput,
        crate::error::GetUserAttributeVerificationCodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_attribute_verification_code_error(response)
        } else {
            crate::operation_deser::parse_get_user_attribute_verification_code_response(response)
        }
    }
}

/// Operation shape for `GetUserPoolMfaConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user_pool_mfa_config`](crate::client::Client::get_user_pool_mfa_config).
///
/// See [`crate::client::fluent_builders::GetUserPoolMfaConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUserPoolMfaConfig {
    _private: (),
}
impl GetUserPoolMfaConfig {
    /// Creates a new builder-style object to manufacture [`GetUserPoolMfaConfigInput`](crate::input::GetUserPoolMfaConfigInput)
    pub fn builder() -> crate::input::get_user_pool_mfa_config_input::Builder {
        crate::input::get_user_pool_mfa_config_input::Builder::default()
    }
    /// Creates a new `GetUserPoolMfaConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUserPoolMfaConfig {
    type Output = std::result::Result<
        crate::output::GetUserPoolMfaConfigOutput,
        crate::error::GetUserPoolMfaConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_pool_mfa_config_error(response)
        } else {
            crate::operation_deser::parse_get_user_pool_mfa_config_response(response)
        }
    }
}

/// Operation shape for `GlobalSignOut`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`global_sign_out`](crate::client::Client::global_sign_out).
///
/// See [`crate::client::fluent_builders::GlobalSignOut`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GlobalSignOut {
    _private: (),
}
impl GlobalSignOut {
    /// Creates a new builder-style object to manufacture [`GlobalSignOutInput`](crate::input::GlobalSignOutInput)
    pub fn builder() -> crate::input::global_sign_out_input::Builder {
        crate::input::global_sign_out_input::Builder::default()
    }
    /// Creates a new `GlobalSignOut` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GlobalSignOut {
    type Output =
        std::result::Result<crate::output::GlobalSignOutOutput, crate::error::GlobalSignOutError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_global_sign_out_error(response)
        } else {
            crate::operation_deser::parse_global_sign_out_response(response)
        }
    }
}

/// Operation shape for `InitiateAuth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_auth`](crate::client::Client::initiate_auth).
///
/// See [`crate::client::fluent_builders::InitiateAuth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateAuth {
    _private: (),
}
impl InitiateAuth {
    /// Creates a new builder-style object to manufacture [`InitiateAuthInput`](crate::input::InitiateAuthInput)
    pub fn builder() -> crate::input::initiate_auth_input::Builder {
        crate::input::initiate_auth_input::Builder::default()
    }
    /// Creates a new `InitiateAuth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateAuth {
    type Output =
        std::result::Result<crate::output::InitiateAuthOutput, crate::error::InitiateAuthError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_initiate_auth_error(response)
        } else {
            crate::operation_deser::parse_initiate_auth_response(response)
        }
    }
}

/// Operation shape for `ListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices`](crate::client::Client::list_devices).
///
/// See [`crate::client::fluent_builders::ListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevices {
    _private: (),
}
impl ListDevices {
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
    /// Creates a new `ListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevices {
    type Output =
        std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_error(response)
        } else {
            crate::operation_deser::parse_list_devices_response(response)
        }
    }
}

/// Operation shape for `ListGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_groups`](crate::client::Client::list_groups).
///
/// See [`crate::client::fluent_builders::ListGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroups {
    _private: (),
}
impl ListGroups {
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
    /// Creates a new `ListGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroups {
    type Output =
        std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_groups_error(response)
        } else {
            crate::operation_deser::parse_list_groups_response(response)
        }
    }
}

/// Operation shape for `ListIdentityProviders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_identity_providers`](crate::client::Client::list_identity_providers).
///
/// See [`crate::client::fluent_builders::ListIdentityProviders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIdentityProviders {
    _private: (),
}
impl ListIdentityProviders {
    /// Creates a new builder-style object to manufacture [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
    pub fn builder() -> crate::input::list_identity_providers_input::Builder {
        crate::input::list_identity_providers_input::Builder::default()
    }
    /// Creates a new `ListIdentityProviders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIdentityProviders {
    type Output = std::result::Result<
        crate::output::ListIdentityProvidersOutput,
        crate::error::ListIdentityProvidersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_identity_providers_error(response)
        } else {
            crate::operation_deser::parse_list_identity_providers_response(response)
        }
    }
}

/// Operation shape for `ListResourceServers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_servers`](crate::client::Client::list_resource_servers).
///
/// See [`crate::client::fluent_builders::ListResourceServers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceServers {
    _private: (),
}
impl ListResourceServers {
    /// Creates a new builder-style object to manufacture [`ListResourceServersInput`](crate::input::ListResourceServersInput)
    pub fn builder() -> crate::input::list_resource_servers_input::Builder {
        crate::input::list_resource_servers_input::Builder::default()
    }
    /// Creates a new `ListResourceServers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceServers {
    type Output = std::result::Result<
        crate::output::ListResourceServersOutput,
        crate::error::ListResourceServersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_servers_error(response)
        } else {
            crate::operation_deser::parse_list_resource_servers_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListUserImportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_user_import_jobs`](crate::client::Client::list_user_import_jobs).
///
/// See [`crate::client::fluent_builders::ListUserImportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUserImportJobs {
    _private: (),
}
impl ListUserImportJobs {
    /// Creates a new builder-style object to manufacture [`ListUserImportJobsInput`](crate::input::ListUserImportJobsInput)
    pub fn builder() -> crate::input::list_user_import_jobs_input::Builder {
        crate::input::list_user_import_jobs_input::Builder::default()
    }
    /// Creates a new `ListUserImportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUserImportJobs {
    type Output = std::result::Result<
        crate::output::ListUserImportJobsOutput,
        crate::error::ListUserImportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_user_import_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_user_import_jobs_response(response)
        }
    }
}

/// Operation shape for `ListUserPoolClients`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_user_pool_clients`](crate::client::Client::list_user_pool_clients).
///
/// See [`crate::client::fluent_builders::ListUserPoolClients`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUserPoolClients {
    _private: (),
}
impl ListUserPoolClients {
    /// Creates a new builder-style object to manufacture [`ListUserPoolClientsInput`](crate::input::ListUserPoolClientsInput)
    pub fn builder() -> crate::input::list_user_pool_clients_input::Builder {
        crate::input::list_user_pool_clients_input::Builder::default()
    }
    /// Creates a new `ListUserPoolClients` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUserPoolClients {
    type Output = std::result::Result<
        crate::output::ListUserPoolClientsOutput,
        crate::error::ListUserPoolClientsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_user_pool_clients_error(response)
        } else {
            crate::operation_deser::parse_list_user_pool_clients_response(response)
        }
    }
}

/// Operation shape for `ListUserPools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_user_pools`](crate::client::Client::list_user_pools).
///
/// See [`crate::client::fluent_builders::ListUserPools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUserPools {
    _private: (),
}
impl ListUserPools {
    /// Creates a new builder-style object to manufacture [`ListUserPoolsInput`](crate::input::ListUserPoolsInput)
    pub fn builder() -> crate::input::list_user_pools_input::Builder {
        crate::input::list_user_pools_input::Builder::default()
    }
    /// Creates a new `ListUserPools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUserPools {
    type Output =
        std::result::Result<crate::output::ListUserPoolsOutput, crate::error::ListUserPoolsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_user_pools_error(response)
        } else {
            crate::operation_deser::parse_list_user_pools_response(response)
        }
    }
}

/// Operation shape for `ListUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users`](crate::client::Client::list_users).
///
/// See [`crate::client::fluent_builders::ListUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsers {
    _private: (),
}
impl ListUsers {
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
    /// Creates a new `ListUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsers {
    type Output = std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_error(response)
        } else {
            crate::operation_deser::parse_list_users_response(response)
        }
    }
}

/// Operation shape for `ListUsersInGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users_in_group`](crate::client::Client::list_users_in_group).
///
/// See [`crate::client::fluent_builders::ListUsersInGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsersInGroup {
    _private: (),
}
impl ListUsersInGroup {
    /// Creates a new builder-style object to manufacture [`ListUsersInGroupInput`](crate::input::ListUsersInGroupInput)
    pub fn builder() -> crate::input::list_users_in_group_input::Builder {
        crate::input::list_users_in_group_input::Builder::default()
    }
    /// Creates a new `ListUsersInGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsersInGroup {
    type Output = std::result::Result<
        crate::output::ListUsersInGroupOutput,
        crate::error::ListUsersInGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_in_group_error(response)
        } else {
            crate::operation_deser::parse_list_users_in_group_response(response)
        }
    }
}

/// Operation shape for `ResendConfirmationCode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resend_confirmation_code`](crate::client::Client::resend_confirmation_code).
///
/// See [`crate::client::fluent_builders::ResendConfirmationCode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResendConfirmationCode {
    _private: (),
}
impl ResendConfirmationCode {
    /// Creates a new builder-style object to manufacture [`ResendConfirmationCodeInput`](crate::input::ResendConfirmationCodeInput)
    pub fn builder() -> crate::input::resend_confirmation_code_input::Builder {
        crate::input::resend_confirmation_code_input::Builder::default()
    }
    /// Creates a new `ResendConfirmationCode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResendConfirmationCode {
    type Output = std::result::Result<
        crate::output::ResendConfirmationCodeOutput,
        crate::error::ResendConfirmationCodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resend_confirmation_code_error(response)
        } else {
            crate::operation_deser::parse_resend_confirmation_code_response(response)
        }
    }
}

/// Operation shape for `RespondToAuthChallenge`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`respond_to_auth_challenge`](crate::client::Client::respond_to_auth_challenge).
///
/// See [`crate::client::fluent_builders::RespondToAuthChallenge`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RespondToAuthChallenge {
    _private: (),
}
impl RespondToAuthChallenge {
    /// Creates a new builder-style object to manufacture [`RespondToAuthChallengeInput`](crate::input::RespondToAuthChallengeInput)
    pub fn builder() -> crate::input::respond_to_auth_challenge_input::Builder {
        crate::input::respond_to_auth_challenge_input::Builder::default()
    }
    /// Creates a new `RespondToAuthChallenge` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RespondToAuthChallenge {
    type Output = std::result::Result<
        crate::output::RespondToAuthChallengeOutput,
        crate::error::RespondToAuthChallengeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_respond_to_auth_challenge_error(response)
        } else {
            crate::operation_deser::parse_respond_to_auth_challenge_response(response)
        }
    }
}

/// Operation shape for `RevokeToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_token`](crate::client::Client::revoke_token).
///
/// See [`crate::client::fluent_builders::RevokeToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeToken {
    _private: (),
}
impl RevokeToken {
    /// Creates a new builder-style object to manufacture [`RevokeTokenInput`](crate::input::RevokeTokenInput)
    pub fn builder() -> crate::input::revoke_token_input::Builder {
        crate::input::revoke_token_input::Builder::default()
    }
    /// Creates a new `RevokeToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeToken {
    type Output =
        std::result::Result<crate::output::RevokeTokenOutput, crate::error::RevokeTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_token_error(response)
        } else {
            crate::operation_deser::parse_revoke_token_response(response)
        }
    }
}

/// Operation shape for `SetRiskConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_risk_configuration`](crate::client::Client::set_risk_configuration).
///
/// See [`crate::client::fluent_builders::SetRiskConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetRiskConfiguration {
    _private: (),
}
impl SetRiskConfiguration {
    /// Creates a new builder-style object to manufacture [`SetRiskConfigurationInput`](crate::input::SetRiskConfigurationInput)
    pub fn builder() -> crate::input::set_risk_configuration_input::Builder {
        crate::input::set_risk_configuration_input::Builder::default()
    }
    /// Creates a new `SetRiskConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetRiskConfiguration {
    type Output = std::result::Result<
        crate::output::SetRiskConfigurationOutput,
        crate::error::SetRiskConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_risk_configuration_error(response)
        } else {
            crate::operation_deser::parse_set_risk_configuration_response(response)
        }
    }
}

/// Operation shape for `SetUICustomization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_ui_customization`](crate::client::Client::set_ui_customization).
///
/// See [`crate::client::fluent_builders::SetUICustomization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetUICustomization {
    _private: (),
}
impl SetUICustomization {
    /// Creates a new builder-style object to manufacture [`SetUiCustomizationInput`](crate::input::SetUiCustomizationInput)
    pub fn builder() -> crate::input::set_ui_customization_input::Builder {
        crate::input::set_ui_customization_input::Builder::default()
    }
    /// Creates a new `SetUICustomization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetUICustomization {
    type Output = std::result::Result<
        crate::output::SetUiCustomizationOutput,
        crate::error::SetUICustomizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_ui_customization_error(response)
        } else {
            crate::operation_deser::parse_set_ui_customization_response(response)
        }
    }
}

/// Operation shape for `SetUserMFAPreference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_user_mfa_preference`](crate::client::Client::set_user_mfa_preference).
///
/// See [`crate::client::fluent_builders::SetUserMFAPreference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetUserMFAPreference {
    _private: (),
}
impl SetUserMFAPreference {
    /// Creates a new builder-style object to manufacture [`SetUserMfaPreferenceInput`](crate::input::SetUserMfaPreferenceInput)
    pub fn builder() -> crate::input::set_user_mfa_preference_input::Builder {
        crate::input::set_user_mfa_preference_input::Builder::default()
    }
    /// Creates a new `SetUserMFAPreference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetUserMFAPreference {
    type Output = std::result::Result<
        crate::output::SetUserMfaPreferenceOutput,
        crate::error::SetUserMFAPreferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_user_mfa_preference_error(response)
        } else {
            crate::operation_deser::parse_set_user_mfa_preference_response(response)
        }
    }
}

/// Operation shape for `SetUserPoolMfaConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_user_pool_mfa_config`](crate::client::Client::set_user_pool_mfa_config).
///
/// See [`crate::client::fluent_builders::SetUserPoolMfaConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetUserPoolMfaConfig {
    _private: (),
}
impl SetUserPoolMfaConfig {
    /// Creates a new builder-style object to manufacture [`SetUserPoolMfaConfigInput`](crate::input::SetUserPoolMfaConfigInput)
    pub fn builder() -> crate::input::set_user_pool_mfa_config_input::Builder {
        crate::input::set_user_pool_mfa_config_input::Builder::default()
    }
    /// Creates a new `SetUserPoolMfaConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetUserPoolMfaConfig {
    type Output = std::result::Result<
        crate::output::SetUserPoolMfaConfigOutput,
        crate::error::SetUserPoolMfaConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_user_pool_mfa_config_error(response)
        } else {
            crate::operation_deser::parse_set_user_pool_mfa_config_response(response)
        }
    }
}

/// Operation shape for `SetUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_user_settings`](crate::client::Client::set_user_settings).
///
/// See [`crate::client::fluent_builders::SetUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetUserSettings {
    _private: (),
}
impl SetUserSettings {
    /// Creates a new builder-style object to manufacture [`SetUserSettingsInput`](crate::input::SetUserSettingsInput)
    pub fn builder() -> crate::input::set_user_settings_input::Builder {
        crate::input::set_user_settings_input::Builder::default()
    }
    /// Creates a new `SetUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetUserSettings {
    type Output = std::result::Result<
        crate::output::SetUserSettingsOutput,
        crate::error::SetUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_user_settings_error(response)
        } else {
            crate::operation_deser::parse_set_user_settings_response(response)
        }
    }
}

/// Operation shape for `SignUp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`sign_up`](crate::client::Client::sign_up).
///
/// See [`crate::client::fluent_builders::SignUp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SignUp {
    _private: (),
}
impl SignUp {
    /// Creates a new builder-style object to manufacture [`SignUpInput`](crate::input::SignUpInput)
    pub fn builder() -> crate::input::sign_up_input::Builder {
        crate::input::sign_up_input::Builder::default()
    }
    /// Creates a new `SignUp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SignUp {
    type Output = std::result::Result<crate::output::SignUpOutput, crate::error::SignUpError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_sign_up_error(response)
        } else {
            crate::operation_deser::parse_sign_up_response(response)
        }
    }
}

/// Operation shape for `StartUserImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_user_import_job`](crate::client::Client::start_user_import_job).
///
/// See [`crate::client::fluent_builders::StartUserImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartUserImportJob {
    _private: (),
}
impl StartUserImportJob {
    /// Creates a new builder-style object to manufacture [`StartUserImportJobInput`](crate::input::StartUserImportJobInput)
    pub fn builder() -> crate::input::start_user_import_job_input::Builder {
        crate::input::start_user_import_job_input::Builder::default()
    }
    /// Creates a new `StartUserImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartUserImportJob {
    type Output = std::result::Result<
        crate::output::StartUserImportJobOutput,
        crate::error::StartUserImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_user_import_job_error(response)
        } else {
            crate::operation_deser::parse_start_user_import_job_response(response)
        }
    }
}

/// Operation shape for `StopUserImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_user_import_job`](crate::client::Client::stop_user_import_job).
///
/// See [`crate::client::fluent_builders::StopUserImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopUserImportJob {
    _private: (),
}
impl StopUserImportJob {
    /// Creates a new builder-style object to manufacture [`StopUserImportJobInput`](crate::input::StopUserImportJobInput)
    pub fn builder() -> crate::input::stop_user_import_job_input::Builder {
        crate::input::stop_user_import_job_input::Builder::default()
    }
    /// Creates a new `StopUserImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopUserImportJob {
    type Output = std::result::Result<
        crate::output::StopUserImportJobOutput,
        crate::error::StopUserImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_user_import_job_error(response)
        } else {
            crate::operation_deser::parse_stop_user_import_job_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAuthEventFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_auth_event_feedback`](crate::client::Client::update_auth_event_feedback).
///
/// See [`crate::client::fluent_builders::UpdateAuthEventFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAuthEventFeedback {
    _private: (),
}
impl UpdateAuthEventFeedback {
    /// Creates a new builder-style object to manufacture [`UpdateAuthEventFeedbackInput`](crate::input::UpdateAuthEventFeedbackInput)
    pub fn builder() -> crate::input::update_auth_event_feedback_input::Builder {
        crate::input::update_auth_event_feedback_input::Builder::default()
    }
    /// Creates a new `UpdateAuthEventFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAuthEventFeedback {
    type Output = std::result::Result<
        crate::output::UpdateAuthEventFeedbackOutput,
        crate::error::UpdateAuthEventFeedbackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_auth_event_feedback_error(response)
        } else {
            crate::operation_deser::parse_update_auth_event_feedback_response(response)
        }
    }
}

/// Operation shape for `UpdateDeviceStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_status`](crate::client::Client::update_device_status).
///
/// See [`crate::client::fluent_builders::UpdateDeviceStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeviceStatus {
    _private: (),
}
impl UpdateDeviceStatus {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceStatusInput`](crate::input::UpdateDeviceStatusInput)
    pub fn builder() -> crate::input::update_device_status_input::Builder {
        crate::input::update_device_status_input::Builder::default()
    }
    /// Creates a new `UpdateDeviceStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeviceStatus {
    type Output = std::result::Result<
        crate::output::UpdateDeviceStatusOutput,
        crate::error::UpdateDeviceStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_status_error(response)
        } else {
            crate::operation_deser::parse_update_device_status_response(response)
        }
    }
}

/// Operation shape for `UpdateGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_group`](crate::client::Client::update_group).
///
/// See [`crate::client::fluent_builders::UpdateGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGroup {
    _private: (),
}
impl UpdateGroup {
    /// Creates a new builder-style object to manufacture [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    pub fn builder() -> crate::input::update_group_input::Builder {
        crate::input::update_group_input::Builder::default()
    }
    /// Creates a new `UpdateGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGroup {
    type Output =
        std::result::Result<crate::output::UpdateGroupOutput, crate::error::UpdateGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_group_error(response)
        } else {
            crate::operation_deser::parse_update_group_response(response)
        }
    }
}

/// Operation shape for `UpdateIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_identity_provider`](crate::client::Client::update_identity_provider).
///
/// See [`crate::client::fluent_builders::UpdateIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIdentityProvider {
    _private: (),
}
impl UpdateIdentityProvider {
    /// Creates a new builder-style object to manufacture [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
    pub fn builder() -> crate::input::update_identity_provider_input::Builder {
        crate::input::update_identity_provider_input::Builder::default()
    }
    /// Creates a new `UpdateIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIdentityProvider {
    type Output = std::result::Result<
        crate::output::UpdateIdentityProviderOutput,
        crate::error::UpdateIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_update_identity_provider_response(response)
        }
    }
}

/// Operation shape for `UpdateResourceServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource_server`](crate::client::Client::update_resource_server).
///
/// See [`crate::client::fluent_builders::UpdateResourceServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResourceServer {
    _private: (),
}
impl UpdateResourceServer {
    /// Creates a new builder-style object to manufacture [`UpdateResourceServerInput`](crate::input::UpdateResourceServerInput)
    pub fn builder() -> crate::input::update_resource_server_input::Builder {
        crate::input::update_resource_server_input::Builder::default()
    }
    /// Creates a new `UpdateResourceServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResourceServer {
    type Output = std::result::Result<
        crate::output::UpdateResourceServerOutput,
        crate::error::UpdateResourceServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_server_error(response)
        } else {
            crate::operation_deser::parse_update_resource_server_response(response)
        }
    }
}

/// Operation shape for `UpdateUserAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_attributes`](crate::client::Client::update_user_attributes).
///
/// See [`crate::client::fluent_builders::UpdateUserAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserAttributes {
    _private: (),
}
impl UpdateUserAttributes {
    /// Creates a new builder-style object to manufacture [`UpdateUserAttributesInput`](crate::input::UpdateUserAttributesInput)
    pub fn builder() -> crate::input::update_user_attributes_input::Builder {
        crate::input::update_user_attributes_input::Builder::default()
    }
    /// Creates a new `UpdateUserAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserAttributes {
    type Output = std::result::Result<
        crate::output::UpdateUserAttributesOutput,
        crate::error::UpdateUserAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_attributes_error(response)
        } else {
            crate::operation_deser::parse_update_user_attributes_response(response)
        }
    }
}

/// Operation shape for `UpdateUserPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_pool`](crate::client::Client::update_user_pool).
///
/// See [`crate::client::fluent_builders::UpdateUserPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserPool {
    _private: (),
}
impl UpdateUserPool {
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolInput`](crate::input::UpdateUserPoolInput)
    pub fn builder() -> crate::input::update_user_pool_input::Builder {
        crate::input::update_user_pool_input::Builder::default()
    }
    /// Creates a new `UpdateUserPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserPool {
    type Output =
        std::result::Result<crate::output::UpdateUserPoolOutput, crate::error::UpdateUserPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_pool_error(response)
        } else {
            crate::operation_deser::parse_update_user_pool_response(response)
        }
    }
}

/// Operation shape for `UpdateUserPoolClient`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_pool_client`](crate::client::Client::update_user_pool_client).
///
/// See [`crate::client::fluent_builders::UpdateUserPoolClient`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserPoolClient {
    _private: (),
}
impl UpdateUserPoolClient {
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolClientInput`](crate::input::UpdateUserPoolClientInput)
    pub fn builder() -> crate::input::update_user_pool_client_input::Builder {
        crate::input::update_user_pool_client_input::Builder::default()
    }
    /// Creates a new `UpdateUserPoolClient` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserPoolClient {
    type Output = std::result::Result<
        crate::output::UpdateUserPoolClientOutput,
        crate::error::UpdateUserPoolClientError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_pool_client_error(response)
        } else {
            crate::operation_deser::parse_update_user_pool_client_response(response)
        }
    }
}

/// Operation shape for `UpdateUserPoolDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_pool_domain`](crate::client::Client::update_user_pool_domain).
///
/// See [`crate::client::fluent_builders::UpdateUserPoolDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserPoolDomain {
    _private: (),
}
impl UpdateUserPoolDomain {
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolDomainInput`](crate::input::UpdateUserPoolDomainInput)
    pub fn builder() -> crate::input::update_user_pool_domain_input::Builder {
        crate::input::update_user_pool_domain_input::Builder::default()
    }
    /// Creates a new `UpdateUserPoolDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserPoolDomain {
    type Output = std::result::Result<
        crate::output::UpdateUserPoolDomainOutput,
        crate::error::UpdateUserPoolDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_pool_domain_error(response)
        } else {
            crate::operation_deser::parse_update_user_pool_domain_response(response)
        }
    }
}

/// Operation shape for `VerifySoftwareToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_software_token`](crate::client::Client::verify_software_token).
///
/// See [`crate::client::fluent_builders::VerifySoftwareToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifySoftwareToken {
    _private: (),
}
impl VerifySoftwareToken {
    /// Creates a new builder-style object to manufacture [`VerifySoftwareTokenInput`](crate::input::VerifySoftwareTokenInput)
    pub fn builder() -> crate::input::verify_software_token_input::Builder {
        crate::input::verify_software_token_input::Builder::default()
    }
    /// Creates a new `VerifySoftwareToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifySoftwareToken {
    type Output = std::result::Result<
        crate::output::VerifySoftwareTokenOutput,
        crate::error::VerifySoftwareTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_software_token_error(response)
        } else {
            crate::operation_deser::parse_verify_software_token_response(response)
        }
    }
}

/// Operation shape for `VerifyUserAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_user_attribute`](crate::client::Client::verify_user_attribute).
///
/// See [`crate::client::fluent_builders::VerifyUserAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifyUserAttribute {
    _private: (),
}
impl VerifyUserAttribute {
    /// Creates a new builder-style object to manufacture [`VerifyUserAttributeInput`](crate::input::VerifyUserAttributeInput)
    pub fn builder() -> crate::input::verify_user_attribute_input::Builder {
        crate::input::verify_user_attribute_input::Builder::default()
    }
    /// Creates a new `VerifyUserAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifyUserAttribute {
    type Output = std::result::Result<
        crate::output::VerifyUserAttributeOutput,
        crate::error::VerifyUserAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_user_attribute_error(response)
        } else {
            crate::operation_deser::parse_verify_user_attribute_response(response)
        }
    }
}
