// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A container representing the response from the server from the request to verify user attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyUserAttributeOutput {}
impl std::fmt::Debug for VerifyUserAttributeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyUserAttributeOutput");
        formatter.finish()
    }
}
/// See [`VerifyUserAttributeOutput`](crate::output::VerifyUserAttributeOutput)
pub mod verify_user_attribute_output {
    /// A builder for [`VerifyUserAttributeOutput`](crate::output::VerifyUserAttributeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`VerifyUserAttributeOutput`](crate::output::VerifyUserAttributeOutput)
        pub fn build(self) -> crate::output::VerifyUserAttributeOutput {
            crate::output::VerifyUserAttributeOutput {}
        }
    }
}
impl VerifyUserAttributeOutput {
    /// Creates a new builder-style object to manufacture [`VerifyUserAttributeOutput`](crate::output::VerifyUserAttributeOutput)
    pub fn builder() -> crate::output::verify_user_attribute_output::Builder {
        crate::output::verify_user_attribute_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifySoftwareTokenOutput {
    /// <p>The status of the verify software token.</p>
    pub status: std::option::Option<crate::model::VerifySoftwareTokenResponseType>,
    /// <p>The session that should be passed both ways in challenge-response calls to the service.</p>
    pub session: std::option::Option<std::string::String>,
}
impl VerifySoftwareTokenOutput {
    /// <p>The status of the verify software token.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VerifySoftwareTokenResponseType> {
        self.status.as_ref()
    }
    /// <p>The session that should be passed both ways in challenge-response calls to the service.</p>
    pub fn session(&self) -> std::option::Option<&str> {
        self.session.as_deref()
    }
}
impl std::fmt::Debug for VerifySoftwareTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifySoftwareTokenOutput");
        formatter.field("status", &self.status);
        formatter.field("session", &self.session);
        formatter.finish()
    }
}
/// See [`VerifySoftwareTokenOutput`](crate::output::VerifySoftwareTokenOutput)
pub mod verify_software_token_output {
    /// A builder for [`VerifySoftwareTokenOutput`](crate::output::VerifySoftwareTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::VerifySoftwareTokenResponseType>,
        pub(crate) session: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the verify software token.</p>
        pub fn status(mut self, input: crate::model::VerifySoftwareTokenResponseType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the verify software token.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VerifySoftwareTokenResponseType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifySoftwareTokenOutput`](crate::output::VerifySoftwareTokenOutput)
        pub fn build(self) -> crate::output::VerifySoftwareTokenOutput {
            crate::output::VerifySoftwareTokenOutput {
                status: self.status,
                session: self.session,
            }
        }
    }
}
impl VerifySoftwareTokenOutput {
    /// Creates a new builder-style object to manufacture [`VerifySoftwareTokenOutput`](crate::output::VerifySoftwareTokenOutput)
    pub fn builder() -> crate::output::verify_software_token_output::Builder {
        crate::output::verify_software_token_output::Builder::default()
    }
}

/// <p>The UpdateUserPoolDomain response output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserPoolDomainOutput {
    /// <p>The Amazon CloudFront endpoint that Amazon Cognito set up when you added the custom domain to your user pool.</p>
    pub cloud_front_domain: std::option::Option<std::string::String>,
}
impl UpdateUserPoolDomainOutput {
    /// <p>The Amazon CloudFront endpoint that Amazon Cognito set up when you added the custom domain to your user pool.</p>
    pub fn cloud_front_domain(&self) -> std::option::Option<&str> {
        self.cloud_front_domain.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserPoolDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserPoolDomainOutput");
        formatter.field("cloud_front_domain", &self.cloud_front_domain);
        formatter.finish()
    }
}
/// See [`UpdateUserPoolDomainOutput`](crate::output::UpdateUserPoolDomainOutput)
pub mod update_user_pool_domain_output {
    /// A builder for [`UpdateUserPoolDomainOutput`](crate::output::UpdateUserPoolDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon CloudFront endpoint that Amazon Cognito set up when you added the custom domain to your user pool.</p>
        pub fn cloud_front_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_front_domain = Some(input.into());
            self
        }
        /// <p>The Amazon CloudFront endpoint that Amazon Cognito set up when you added the custom domain to your user pool.</p>
        pub fn set_cloud_front_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_front_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserPoolDomainOutput`](crate::output::UpdateUserPoolDomainOutput)
        pub fn build(self) -> crate::output::UpdateUserPoolDomainOutput {
            crate::output::UpdateUserPoolDomainOutput {
                cloud_front_domain: self.cloud_front_domain,
            }
        }
    }
}
impl UpdateUserPoolDomainOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolDomainOutput`](crate::output::UpdateUserPoolDomainOutput)
    pub fn builder() -> crate::output::update_user_pool_domain_output::Builder {
        crate::output::update_user_pool_domain_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to update the user pool client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserPoolClientOutput {
    /// <p>The user pool client value from the response from the server when you request to update the user pool client.</p>
    pub user_pool_client: std::option::Option<crate::model::UserPoolClientType>,
}
impl UpdateUserPoolClientOutput {
    /// <p>The user pool client value from the response from the server when you request to update the user pool client.</p>
    pub fn user_pool_client(&self) -> std::option::Option<&crate::model::UserPoolClientType> {
        self.user_pool_client.as_ref()
    }
}
impl std::fmt::Debug for UpdateUserPoolClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserPoolClientOutput");
        formatter.field("user_pool_client", &self.user_pool_client);
        formatter.finish()
    }
}
/// See [`UpdateUserPoolClientOutput`](crate::output::UpdateUserPoolClientOutput)
pub mod update_user_pool_client_output {
    /// A builder for [`UpdateUserPoolClientOutput`](crate::output::UpdateUserPoolClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_client: std::option::Option<crate::model::UserPoolClientType>,
    }
    impl Builder {
        /// <p>The user pool client value from the response from the server when you request to update the user pool client.</p>
        pub fn user_pool_client(mut self, input: crate::model::UserPoolClientType) -> Self {
            self.user_pool_client = Some(input);
            self
        }
        /// <p>The user pool client value from the response from the server when you request to update the user pool client.</p>
        pub fn set_user_pool_client(
            mut self,
            input: std::option::Option<crate::model::UserPoolClientType>,
        ) -> Self {
            self.user_pool_client = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserPoolClientOutput`](crate::output::UpdateUserPoolClientOutput)
        pub fn build(self) -> crate::output::UpdateUserPoolClientOutput {
            crate::output::UpdateUserPoolClientOutput {
                user_pool_client: self.user_pool_client,
            }
        }
    }
}
impl UpdateUserPoolClientOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolClientOutput`](crate::output::UpdateUserPoolClientOutput)
    pub fn builder() -> crate::output::update_user_pool_client_output::Builder {
        crate::output::update_user_pool_client_output::Builder::default()
    }
}

/// <p>Represents the response from the server when you make a request to update the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserPoolOutput {}
impl std::fmt::Debug for UpdateUserPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserPoolOutput");
        formatter.finish()
    }
}
/// See [`UpdateUserPoolOutput`](crate::output::UpdateUserPoolOutput)
pub mod update_user_pool_output {
    /// A builder for [`UpdateUserPoolOutput`](crate::output::UpdateUserPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateUserPoolOutput`](crate::output::UpdateUserPoolOutput)
        pub fn build(self) -> crate::output::UpdateUserPoolOutput {
            crate::output::UpdateUserPoolOutput {}
        }
    }
}
impl UpdateUserPoolOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolOutput`](crate::output::UpdateUserPoolOutput)
    pub fn builder() -> crate::output::update_user_pool_output::Builder {
        crate::output::update_user_pool_output::Builder::default()
    }
}

/// <p>Represents the response from the server for the request to update user attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserAttributesOutput {
    /// <p>The code delivery details list from the server for the request to update user attributes.</p>
    pub code_delivery_details_list:
        std::option::Option<std::vec::Vec<crate::model::CodeDeliveryDetailsType>>,
}
impl UpdateUserAttributesOutput {
    /// <p>The code delivery details list from the server for the request to update user attributes.</p>
    pub fn code_delivery_details_list(
        &self,
    ) -> std::option::Option<&[crate::model::CodeDeliveryDetailsType]> {
        self.code_delivery_details_list.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserAttributesOutput");
        formatter.field(
            "code_delivery_details_list",
            &self.code_delivery_details_list,
        );
        formatter.finish()
    }
}
/// See [`UpdateUserAttributesOutput`](crate::output::UpdateUserAttributesOutput)
pub mod update_user_attributes_output {
    /// A builder for [`UpdateUserAttributesOutput`](crate::output::UpdateUserAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_delivery_details_list:
            std::option::Option<std::vec::Vec<crate::model::CodeDeliveryDetailsType>>,
    }
    impl Builder {
        /// Appends an item to `code_delivery_details_list`.
        ///
        /// To override the contents of this collection use [`set_code_delivery_details_list`](Self::set_code_delivery_details_list).
        ///
        /// <p>The code delivery details list from the server for the request to update user attributes.</p>
        pub fn code_delivery_details_list(
            mut self,
            input: crate::model::CodeDeliveryDetailsType,
        ) -> Self {
            let mut v = self.code_delivery_details_list.unwrap_or_default();
            v.push(input);
            self.code_delivery_details_list = Some(v);
            self
        }
        /// <p>The code delivery details list from the server for the request to update user attributes.</p>
        pub fn set_code_delivery_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeDeliveryDetailsType>>,
        ) -> Self {
            self.code_delivery_details_list = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserAttributesOutput`](crate::output::UpdateUserAttributesOutput)
        pub fn build(self) -> crate::output::UpdateUserAttributesOutput {
            crate::output::UpdateUserAttributesOutput {
                code_delivery_details_list: self.code_delivery_details_list,
            }
        }
    }
}
impl UpdateUserAttributesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserAttributesOutput`](crate::output::UpdateUserAttributesOutput)
    pub fn builder() -> crate::output::update_user_attributes_output::Builder {
        crate::output::update_user_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceServerOutput {
    /// <p>The resource server.</p>
    pub resource_server: std::option::Option<crate::model::ResourceServerType>,
}
impl UpdateResourceServerOutput {
    /// <p>The resource server.</p>
    pub fn resource_server(&self) -> std::option::Option<&crate::model::ResourceServerType> {
        self.resource_server.as_ref()
    }
}
impl std::fmt::Debug for UpdateResourceServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceServerOutput");
        formatter.field("resource_server", &self.resource_server);
        formatter.finish()
    }
}
/// See [`UpdateResourceServerOutput`](crate::output::UpdateResourceServerOutput)
pub mod update_resource_server_output {
    /// A builder for [`UpdateResourceServerOutput`](crate::output::UpdateResourceServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_server: std::option::Option<crate::model::ResourceServerType>,
    }
    impl Builder {
        /// <p>The resource server.</p>
        pub fn resource_server(mut self, input: crate::model::ResourceServerType) -> Self {
            self.resource_server = Some(input);
            self
        }
        /// <p>The resource server.</p>
        pub fn set_resource_server(
            mut self,
            input: std::option::Option<crate::model::ResourceServerType>,
        ) -> Self {
            self.resource_server = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceServerOutput`](crate::output::UpdateResourceServerOutput)
        pub fn build(self) -> crate::output::UpdateResourceServerOutput {
            crate::output::UpdateResourceServerOutput {
                resource_server: self.resource_server,
            }
        }
    }
}
impl UpdateResourceServerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResourceServerOutput`](crate::output::UpdateResourceServerOutput)
    pub fn builder() -> crate::output::update_resource_server_output::Builder {
        crate::output::update_resource_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIdentityProviderOutput {
    /// <p>The identity provider object.</p>
    pub identity_provider: std::option::Option<crate::model::IdentityProviderType>,
}
impl UpdateIdentityProviderOutput {
    /// <p>The identity provider object.</p>
    pub fn identity_provider(&self) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider.as_ref()
    }
}
impl std::fmt::Debug for UpdateIdentityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIdentityProviderOutput");
        formatter.field("identity_provider", &self.identity_provider);
        formatter.finish()
    }
}
/// See [`UpdateIdentityProviderOutput`](crate::output::UpdateIdentityProviderOutput)
pub mod update_identity_provider_output {
    /// A builder for [`UpdateIdentityProviderOutput`](crate::output::UpdateIdentityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider: std::option::Option<crate::model::IdentityProviderType>,
    }
    impl Builder {
        /// <p>The identity provider object.</p>
        pub fn identity_provider(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider = Some(input);
            self
        }
        /// <p>The identity provider object.</p>
        pub fn set_identity_provider(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIdentityProviderOutput`](crate::output::UpdateIdentityProviderOutput)
        pub fn build(self) -> crate::output::UpdateIdentityProviderOutput {
            crate::output::UpdateIdentityProviderOutput {
                identity_provider: self.identity_provider,
            }
        }
    }
}
impl UpdateIdentityProviderOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIdentityProviderOutput`](crate::output::UpdateIdentityProviderOutput)
    pub fn builder() -> crate::output::update_identity_provider_output::Builder {
        crate::output::update_identity_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupOutput {
    /// <p>The group object for the group.</p>
    pub group: std::option::Option<crate::model::GroupType>,
}
impl UpdateGroupOutput {
    /// <p>The group object for the group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::GroupType> {
        self.group.as_ref()
    }
}
impl std::fmt::Debug for UpdateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
pub mod update_group_output {
    /// A builder for [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::GroupType>,
    }
    impl Builder {
        /// <p>The group object for the group.</p>
        pub fn group(mut self, input: crate::model::GroupType) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The group object for the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::GroupType>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
        pub fn build(self) -> crate::output::UpdateGroupOutput {
            crate::output::UpdateGroupOutput { group: self.group }
        }
    }
}
impl UpdateGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    pub fn builder() -> crate::output::update_group_output::Builder {
        crate::output::update_group_output::Builder::default()
    }
}

/// <p>The response to the request to update the device status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceStatusOutput {}
impl std::fmt::Debug for UpdateDeviceStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceStatusOutput");
        formatter.finish()
    }
}
/// See [`UpdateDeviceStatusOutput`](crate::output::UpdateDeviceStatusOutput)
pub mod update_device_status_output {
    /// A builder for [`UpdateDeviceStatusOutput`](crate::output::UpdateDeviceStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDeviceStatusOutput`](crate::output::UpdateDeviceStatusOutput)
        pub fn build(self) -> crate::output::UpdateDeviceStatusOutput {
            crate::output::UpdateDeviceStatusOutput {}
        }
    }
}
impl UpdateDeviceStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceStatusOutput`](crate::output::UpdateDeviceStatusOutput)
    pub fn builder() -> crate::output::update_device_status_output::Builder {
        crate::output::update_device_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAuthEventFeedbackOutput {}
impl std::fmt::Debug for UpdateAuthEventFeedbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAuthEventFeedbackOutput");
        formatter.finish()
    }
}
/// See [`UpdateAuthEventFeedbackOutput`](crate::output::UpdateAuthEventFeedbackOutput)
pub mod update_auth_event_feedback_output {
    /// A builder for [`UpdateAuthEventFeedbackOutput`](crate::output::UpdateAuthEventFeedbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAuthEventFeedbackOutput`](crate::output::UpdateAuthEventFeedbackOutput)
        pub fn build(self) -> crate::output::UpdateAuthEventFeedbackOutput {
            crate::output::UpdateAuthEventFeedbackOutput {}
        }
    }
}
impl UpdateAuthEventFeedbackOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAuthEventFeedbackOutput`](crate::output::UpdateAuthEventFeedbackOutput)
    pub fn builder() -> crate::output::update_auth_event_feedback_output::Builder {
        crate::output::update_auth_event_feedback_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to stop the user import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub user_import_job: std::option::Option<crate::model::UserImportJobType>,
}
impl StopUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub fn user_import_job(&self) -> std::option::Option<&crate::model::UserImportJobType> {
        self.user_import_job.as_ref()
    }
}
impl std::fmt::Debug for StopUserImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopUserImportJobOutput");
        formatter.field("user_import_job", &self.user_import_job);
        formatter.finish()
    }
}
/// See [`StopUserImportJobOutput`](crate::output::StopUserImportJobOutput)
pub mod stop_user_import_job_output {
    /// A builder for [`StopUserImportJobOutput`](crate::output::StopUserImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_import_job: std::option::Option<crate::model::UserImportJobType>,
    }
    impl Builder {
        /// <p>The job object that represents the user import job.</p>
        pub fn user_import_job(mut self, input: crate::model::UserImportJobType) -> Self {
            self.user_import_job = Some(input);
            self
        }
        /// <p>The job object that represents the user import job.</p>
        pub fn set_user_import_job(
            mut self,
            input: std::option::Option<crate::model::UserImportJobType>,
        ) -> Self {
            self.user_import_job = input;
            self
        }
        /// Consumes the builder and constructs a [`StopUserImportJobOutput`](crate::output::StopUserImportJobOutput)
        pub fn build(self) -> crate::output::StopUserImportJobOutput {
            crate::output::StopUserImportJobOutput {
                user_import_job: self.user_import_job,
            }
        }
    }
}
impl StopUserImportJobOutput {
    /// Creates a new builder-style object to manufacture [`StopUserImportJobOutput`](crate::output::StopUserImportJobOutput)
    pub fn builder() -> crate::output::stop_user_import_job_output::Builder {
        crate::output::stop_user_import_job_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to start the user import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub user_import_job: std::option::Option<crate::model::UserImportJobType>,
}
impl StartUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub fn user_import_job(&self) -> std::option::Option<&crate::model::UserImportJobType> {
        self.user_import_job.as_ref()
    }
}
impl std::fmt::Debug for StartUserImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartUserImportJobOutput");
        formatter.field("user_import_job", &self.user_import_job);
        formatter.finish()
    }
}
/// See [`StartUserImportJobOutput`](crate::output::StartUserImportJobOutput)
pub mod start_user_import_job_output {
    /// A builder for [`StartUserImportJobOutput`](crate::output::StartUserImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_import_job: std::option::Option<crate::model::UserImportJobType>,
    }
    impl Builder {
        /// <p>The job object that represents the user import job.</p>
        pub fn user_import_job(mut self, input: crate::model::UserImportJobType) -> Self {
            self.user_import_job = Some(input);
            self
        }
        /// <p>The job object that represents the user import job.</p>
        pub fn set_user_import_job(
            mut self,
            input: std::option::Option<crate::model::UserImportJobType>,
        ) -> Self {
            self.user_import_job = input;
            self
        }
        /// Consumes the builder and constructs a [`StartUserImportJobOutput`](crate::output::StartUserImportJobOutput)
        pub fn build(self) -> crate::output::StartUserImportJobOutput {
            crate::output::StartUserImportJobOutput {
                user_import_job: self.user_import_job,
            }
        }
    }
}
impl StartUserImportJobOutput {
    /// Creates a new builder-style object to manufacture [`StartUserImportJobOutput`](crate::output::StartUserImportJobOutput)
    pub fn builder() -> crate::output::start_user_import_job_output::Builder {
        crate::output::start_user_import_job_output::Builder::default()
    }
}

/// <p>The response from the server for a registration request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignUpOutput {
    /// <p>A response from the server indicating that a user registration has been confirmed.</p>
    pub user_confirmed: bool,
    /// <p>The code delivery details returned by the server response to the user registration request.</p>
    pub code_delivery_details: std::option::Option<crate::model::CodeDeliveryDetailsType>,
    /// <p>The UUID of the authenticated user. This isn't the same as <code>username</code>.</p>
    pub user_sub: std::option::Option<std::string::String>,
}
impl SignUpOutput {
    /// <p>A response from the server indicating that a user registration has been confirmed.</p>
    pub fn user_confirmed(&self) -> bool {
        self.user_confirmed
    }
    /// <p>The code delivery details returned by the server response to the user registration request.</p>
    pub fn code_delivery_details(
        &self,
    ) -> std::option::Option<&crate::model::CodeDeliveryDetailsType> {
        self.code_delivery_details.as_ref()
    }
    /// <p>The UUID of the authenticated user. This isn't the same as <code>username</code>.</p>
    pub fn user_sub(&self) -> std::option::Option<&str> {
        self.user_sub.as_deref()
    }
}
impl std::fmt::Debug for SignUpOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignUpOutput");
        formatter.field("user_confirmed", &self.user_confirmed);
        formatter.field("code_delivery_details", &self.code_delivery_details);
        formatter.field("user_sub", &self.user_sub);
        formatter.finish()
    }
}
/// See [`SignUpOutput`](crate::output::SignUpOutput)
pub mod sign_up_output {
    /// A builder for [`SignUpOutput`](crate::output::SignUpOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_confirmed: std::option::Option<bool>,
        pub(crate) code_delivery_details:
            std::option::Option<crate::model::CodeDeliveryDetailsType>,
        pub(crate) user_sub: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A response from the server indicating that a user registration has been confirmed.</p>
        pub fn user_confirmed(mut self, input: bool) -> Self {
            self.user_confirmed = Some(input);
            self
        }
        /// <p>A response from the server indicating that a user registration has been confirmed.</p>
        pub fn set_user_confirmed(mut self, input: std::option::Option<bool>) -> Self {
            self.user_confirmed = input;
            self
        }
        /// <p>The code delivery details returned by the server response to the user registration request.</p>
        pub fn code_delivery_details(
            mut self,
            input: crate::model::CodeDeliveryDetailsType,
        ) -> Self {
            self.code_delivery_details = Some(input);
            self
        }
        /// <p>The code delivery details returned by the server response to the user registration request.</p>
        pub fn set_code_delivery_details(
            mut self,
            input: std::option::Option<crate::model::CodeDeliveryDetailsType>,
        ) -> Self {
            self.code_delivery_details = input;
            self
        }
        /// <p>The UUID of the authenticated user. This isn't the same as <code>username</code>.</p>
        pub fn user_sub(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_sub = Some(input.into());
            self
        }
        /// <p>The UUID of the authenticated user. This isn't the same as <code>username</code>.</p>
        pub fn set_user_sub(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_sub = input;
            self
        }
        /// Consumes the builder and constructs a [`SignUpOutput`](crate::output::SignUpOutput)
        pub fn build(self) -> crate::output::SignUpOutput {
            crate::output::SignUpOutput {
                user_confirmed: self.user_confirmed.unwrap_or_default(),
                code_delivery_details: self.code_delivery_details,
                user_sub: self.user_sub,
            }
        }
    }
}
impl SignUpOutput {
    /// Creates a new builder-style object to manufacture [`SignUpOutput`](crate::output::SignUpOutput)
    pub fn builder() -> crate::output::sign_up_output::Builder {
        crate::output::sign_up_output::Builder::default()
    }
}

/// <p>The response from the server for a set user settings request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetUserSettingsOutput {}
impl std::fmt::Debug for SetUserSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetUserSettingsOutput");
        formatter.finish()
    }
}
/// See [`SetUserSettingsOutput`](crate::output::SetUserSettingsOutput)
pub mod set_user_settings_output {
    /// A builder for [`SetUserSettingsOutput`](crate::output::SetUserSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetUserSettingsOutput`](crate::output::SetUserSettingsOutput)
        pub fn build(self) -> crate::output::SetUserSettingsOutput {
            crate::output::SetUserSettingsOutput {}
        }
    }
}
impl SetUserSettingsOutput {
    /// Creates a new builder-style object to manufacture [`SetUserSettingsOutput`](crate::output::SetUserSettingsOutput)
    pub fn builder() -> crate::output::set_user_settings_output::Builder {
        crate::output::set_user_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetUserPoolMfaConfigOutput {
    /// <p>The SMS text message MFA configuration.</p>
    pub sms_mfa_configuration: std::option::Option<crate::model::SmsMfaConfigType>,
    /// <p>The software token MFA configuration.</p>
    pub software_token_mfa_configuration:
        std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
    /// <p>The MFA configuration. Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
    /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
    /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>
    /// </ul>
    pub mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
}
impl SetUserPoolMfaConfigOutput {
    /// <p>The SMS text message MFA configuration.</p>
    pub fn sms_mfa_configuration(&self) -> std::option::Option<&crate::model::SmsMfaConfigType> {
        self.sms_mfa_configuration.as_ref()
    }
    /// <p>The software token MFA configuration.</p>
    pub fn software_token_mfa_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SoftwareTokenMfaConfigType> {
        self.software_token_mfa_configuration.as_ref()
    }
    /// <p>The MFA configuration. Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
    /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
    /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>
    /// </ul>
    pub fn mfa_configuration(&self) -> std::option::Option<&crate::model::UserPoolMfaType> {
        self.mfa_configuration.as_ref()
    }
}
impl std::fmt::Debug for SetUserPoolMfaConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetUserPoolMfaConfigOutput");
        formatter.field("sms_mfa_configuration", &self.sms_mfa_configuration);
        formatter.field(
            "software_token_mfa_configuration",
            &self.software_token_mfa_configuration,
        );
        formatter.field("mfa_configuration", &self.mfa_configuration);
        formatter.finish()
    }
}
/// See [`SetUserPoolMfaConfigOutput`](crate::output::SetUserPoolMfaConfigOutput)
pub mod set_user_pool_mfa_config_output {
    /// A builder for [`SetUserPoolMfaConfigOutput`](crate::output::SetUserPoolMfaConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_mfa_configuration: std::option::Option<crate::model::SmsMfaConfigType>,
        pub(crate) software_token_mfa_configuration:
            std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
        pub(crate) mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
    }
    impl Builder {
        /// <p>The SMS text message MFA configuration.</p>
        pub fn sms_mfa_configuration(mut self, input: crate::model::SmsMfaConfigType) -> Self {
            self.sms_mfa_configuration = Some(input);
            self
        }
        /// <p>The SMS text message MFA configuration.</p>
        pub fn set_sms_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsMfaConfigType>,
        ) -> Self {
            self.sms_mfa_configuration = input;
            self
        }
        /// <p>The software token MFA configuration.</p>
        pub fn software_token_mfa_configuration(
            mut self,
            input: crate::model::SoftwareTokenMfaConfigType,
        ) -> Self {
            self.software_token_mfa_configuration = Some(input);
            self
        }
        /// <p>The software token MFA configuration.</p>
        pub fn set_software_token_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
        ) -> Self {
            self.software_token_mfa_configuration = input;
            self
        }
        /// <p>The MFA configuration. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>
        /// </ul>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.mfa_configuration = Some(input);
            self
        }
        /// <p>The MFA configuration. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li>
        /// </ul>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.mfa_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SetUserPoolMfaConfigOutput`](crate::output::SetUserPoolMfaConfigOutput)
        pub fn build(self) -> crate::output::SetUserPoolMfaConfigOutput {
            crate::output::SetUserPoolMfaConfigOutput {
                sms_mfa_configuration: self.sms_mfa_configuration,
                software_token_mfa_configuration: self.software_token_mfa_configuration,
                mfa_configuration: self.mfa_configuration,
            }
        }
    }
}
impl SetUserPoolMfaConfigOutput {
    /// Creates a new builder-style object to manufacture [`SetUserPoolMfaConfigOutput`](crate::output::SetUserPoolMfaConfigOutput)
    pub fn builder() -> crate::output::set_user_pool_mfa_config_output::Builder {
        crate::output::set_user_pool_mfa_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetUserMfaPreferenceOutput {}
impl std::fmt::Debug for SetUserMfaPreferenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetUserMfaPreferenceOutput");
        formatter.finish()
    }
}
/// See [`SetUserMfaPreferenceOutput`](crate::output::SetUserMfaPreferenceOutput)
pub mod set_user_mfa_preference_output {
    /// A builder for [`SetUserMfaPreferenceOutput`](crate::output::SetUserMfaPreferenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetUserMfaPreferenceOutput`](crate::output::SetUserMfaPreferenceOutput)
        pub fn build(self) -> crate::output::SetUserMfaPreferenceOutput {
            crate::output::SetUserMfaPreferenceOutput {}
        }
    }
}
impl SetUserMfaPreferenceOutput {
    /// Creates a new builder-style object to manufacture [`SetUserMfaPreferenceOutput`](crate::output::SetUserMfaPreferenceOutput)
    pub fn builder() -> crate::output::set_user_mfa_preference_output::Builder {
        crate::output::set_user_mfa_preference_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetUiCustomizationOutput {
    /// <p>The UI customization information.</p>
    pub ui_customization: std::option::Option<crate::model::UiCustomizationType>,
}
impl SetUiCustomizationOutput {
    /// <p>The UI customization information.</p>
    pub fn ui_customization(&self) -> std::option::Option<&crate::model::UiCustomizationType> {
        self.ui_customization.as_ref()
    }
}
impl std::fmt::Debug for SetUiCustomizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetUiCustomizationOutput");
        formatter.field("ui_customization", &self.ui_customization);
        formatter.finish()
    }
}
/// See [`SetUiCustomizationOutput`](crate::output::SetUiCustomizationOutput)
pub mod set_ui_customization_output {
    /// A builder for [`SetUiCustomizationOutput`](crate::output::SetUiCustomizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ui_customization: std::option::Option<crate::model::UiCustomizationType>,
    }
    impl Builder {
        /// <p>The UI customization information.</p>
        pub fn ui_customization(mut self, input: crate::model::UiCustomizationType) -> Self {
            self.ui_customization = Some(input);
            self
        }
        /// <p>The UI customization information.</p>
        pub fn set_ui_customization(
            mut self,
            input: std::option::Option<crate::model::UiCustomizationType>,
        ) -> Self {
            self.ui_customization = input;
            self
        }
        /// Consumes the builder and constructs a [`SetUiCustomizationOutput`](crate::output::SetUiCustomizationOutput)
        pub fn build(self) -> crate::output::SetUiCustomizationOutput {
            crate::output::SetUiCustomizationOutput {
                ui_customization: self.ui_customization,
            }
        }
    }
}
impl SetUiCustomizationOutput {
    /// Creates a new builder-style object to manufacture [`SetUiCustomizationOutput`](crate::output::SetUiCustomizationOutput)
    pub fn builder() -> crate::output::set_ui_customization_output::Builder {
        crate::output::set_ui_customization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetRiskConfigurationOutput {
    /// <p>The risk configuration.</p>
    pub risk_configuration: std::option::Option<crate::model::RiskConfigurationType>,
}
impl SetRiskConfigurationOutput {
    /// <p>The risk configuration.</p>
    pub fn risk_configuration(&self) -> std::option::Option<&crate::model::RiskConfigurationType> {
        self.risk_configuration.as_ref()
    }
}
impl std::fmt::Debug for SetRiskConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetRiskConfigurationOutput");
        formatter.field("risk_configuration", &self.risk_configuration);
        formatter.finish()
    }
}
/// See [`SetRiskConfigurationOutput`](crate::output::SetRiskConfigurationOutput)
pub mod set_risk_configuration_output {
    /// A builder for [`SetRiskConfigurationOutput`](crate::output::SetRiskConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) risk_configuration: std::option::Option<crate::model::RiskConfigurationType>,
    }
    impl Builder {
        /// <p>The risk configuration.</p>
        pub fn risk_configuration(mut self, input: crate::model::RiskConfigurationType) -> Self {
            self.risk_configuration = Some(input);
            self
        }
        /// <p>The risk configuration.</p>
        pub fn set_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::RiskConfigurationType>,
        ) -> Self {
            self.risk_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRiskConfigurationOutput`](crate::output::SetRiskConfigurationOutput)
        pub fn build(self) -> crate::output::SetRiskConfigurationOutput {
            crate::output::SetRiskConfigurationOutput {
                risk_configuration: self.risk_configuration,
            }
        }
    }
}
impl SetRiskConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`SetRiskConfigurationOutput`](crate::output::SetRiskConfigurationOutput)
    pub fn builder() -> crate::output::set_risk_configuration_output::Builder {
        crate::output::set_risk_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeTokenOutput {}
impl std::fmt::Debug for RevokeTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeTokenOutput");
        formatter.finish()
    }
}
/// See [`RevokeTokenOutput`](crate::output::RevokeTokenOutput)
pub mod revoke_token_output {
    /// A builder for [`RevokeTokenOutput`](crate::output::RevokeTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RevokeTokenOutput`](crate::output::RevokeTokenOutput)
        pub fn build(self) -> crate::output::RevokeTokenOutput {
            crate::output::RevokeTokenOutput {}
        }
    }
}
impl RevokeTokenOutput {
    /// Creates a new builder-style object to manufacture [`RevokeTokenOutput`](crate::output::RevokeTokenOutput)
    pub fn builder() -> crate::output::revoke_token_output::Builder {
        crate::output::revoke_token_output::Builder::default()
    }
}

/// <p>The response to respond to the authentication challenge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RespondToAuthChallengeOutput {
    /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
    pub challenge_name: std::option::Option<crate::model::ChallengeNameType>,
    /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    pub session: std::option::Option<std::string::String>,
    /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
    pub challenge_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The result returned by the server in response to the request to respond to the authentication challenge.</p>
    pub authentication_result: std::option::Option<crate::model::AuthenticationResultType>,
}
impl RespondToAuthChallengeOutput {
    /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
    pub fn challenge_name(&self) -> std::option::Option<&crate::model::ChallengeNameType> {
        self.challenge_name.as_ref()
    }
    /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    pub fn session(&self) -> std::option::Option<&str> {
        self.session.as_deref()
    }
    /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
    pub fn challenge_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.challenge_parameters.as_ref()
    }
    /// <p>The result returned by the server in response to the request to respond to the authentication challenge.</p>
    pub fn authentication_result(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationResultType> {
        self.authentication_result.as_ref()
    }
}
impl std::fmt::Debug for RespondToAuthChallengeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RespondToAuthChallengeOutput");
        formatter.field("challenge_name", &self.challenge_name);
        formatter.field("session", &self.session);
        formatter.field("challenge_parameters", &self.challenge_parameters);
        formatter.field("authentication_result", &self.authentication_result);
        formatter.finish()
    }
}
/// See [`RespondToAuthChallengeOutput`](crate::output::RespondToAuthChallengeOutput)
pub mod respond_to_auth_challenge_output {
    /// A builder for [`RespondToAuthChallengeOutput`](crate::output::RespondToAuthChallengeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) challenge_name: std::option::Option<crate::model::ChallengeNameType>,
        pub(crate) session: std::option::Option<std::string::String>,
        pub(crate) challenge_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) authentication_result:
            std::option::Option<crate::model::AuthenticationResultType>,
    }
    impl Builder {
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.challenge_name = Some(input);
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.challenge_name = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Adds a key-value pair to `challenge_parameters`.
        ///
        /// To override the contents of this collection use [`set_challenge_parameters`](Self::set_challenge_parameters).
        ///
        /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        pub fn challenge_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.challenge_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.challenge_parameters = Some(hash_map);
            self
        }
        /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        pub fn set_challenge_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.challenge_parameters = input;
            self
        }
        /// <p>The result returned by the server in response to the request to respond to the authentication challenge.</p>
        pub fn authentication_result(
            mut self,
            input: crate::model::AuthenticationResultType,
        ) -> Self {
            self.authentication_result = Some(input);
            self
        }
        /// <p>The result returned by the server in response to the request to respond to the authentication challenge.</p>
        pub fn set_authentication_result(
            mut self,
            input: std::option::Option<crate::model::AuthenticationResultType>,
        ) -> Self {
            self.authentication_result = input;
            self
        }
        /// Consumes the builder and constructs a [`RespondToAuthChallengeOutput`](crate::output::RespondToAuthChallengeOutput)
        pub fn build(self) -> crate::output::RespondToAuthChallengeOutput {
            crate::output::RespondToAuthChallengeOutput {
                challenge_name: self.challenge_name,
                session: self.session,
                challenge_parameters: self.challenge_parameters,
                authentication_result: self.authentication_result,
            }
        }
    }
}
impl RespondToAuthChallengeOutput {
    /// Creates a new builder-style object to manufacture [`RespondToAuthChallengeOutput`](crate::output::RespondToAuthChallengeOutput)
    pub fn builder() -> crate::output::respond_to_auth_challenge_output::Builder {
        crate::output::respond_to_auth_challenge_output::Builder::default()
    }
}

/// <p>The response from the server when Amazon Cognito makes the request to resend a confirmation code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResendConfirmationCodeOutput {
    /// <p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>
    pub code_delivery_details: std::option::Option<crate::model::CodeDeliveryDetailsType>,
}
impl ResendConfirmationCodeOutput {
    /// <p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>
    pub fn code_delivery_details(
        &self,
    ) -> std::option::Option<&crate::model::CodeDeliveryDetailsType> {
        self.code_delivery_details.as_ref()
    }
}
impl std::fmt::Debug for ResendConfirmationCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResendConfirmationCodeOutput");
        formatter.field("code_delivery_details", &self.code_delivery_details);
        formatter.finish()
    }
}
/// See [`ResendConfirmationCodeOutput`](crate::output::ResendConfirmationCodeOutput)
pub mod resend_confirmation_code_output {
    /// A builder for [`ResendConfirmationCodeOutput`](crate::output::ResendConfirmationCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_delivery_details:
            std::option::Option<crate::model::CodeDeliveryDetailsType>,
    }
    impl Builder {
        /// <p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>
        pub fn code_delivery_details(
            mut self,
            input: crate::model::CodeDeliveryDetailsType,
        ) -> Self {
            self.code_delivery_details = Some(input);
            self
        }
        /// <p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>
        pub fn set_code_delivery_details(
            mut self,
            input: std::option::Option<crate::model::CodeDeliveryDetailsType>,
        ) -> Self {
            self.code_delivery_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ResendConfirmationCodeOutput`](crate::output::ResendConfirmationCodeOutput)
        pub fn build(self) -> crate::output::ResendConfirmationCodeOutput {
            crate::output::ResendConfirmationCodeOutput {
                code_delivery_details: self.code_delivery_details,
            }
        }
    }
}
impl ResendConfirmationCodeOutput {
    /// Creates a new builder-style object to manufacture [`ResendConfirmationCodeOutput`](crate::output::ResendConfirmationCodeOutput)
    pub fn builder() -> crate::output::resend_confirmation_code_output::Builder {
        crate::output::resend_confirmation_code_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersInGroupOutput {
    /// <p>The users returned in the request to list users.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::UserType>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUsersInGroupOutput {
    /// <p>The users returned in the request to list users.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::UserType]> {
        self.users.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUsersInGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersInGroupOutput");
        formatter.field("users", &self.users);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUsersInGroupOutput`](crate::output::ListUsersInGroupOutput)
pub mod list_users_in_group_output {
    /// A builder for [`ListUsersInGroupOutput`](crate::output::ListUsersInGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::UserType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>The users returned in the request to list users.</p>
        pub fn users(mut self, input: crate::model::UserType) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input);
            self.users = Some(v);
            self
        }
        /// <p>The users returned in the request to list users.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserType>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInGroupOutput`](crate::output::ListUsersInGroupOutput)
        pub fn build(self) -> crate::output::ListUsersInGroupOutput {
            crate::output::ListUsersInGroupOutput {
                users: self.users,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUsersInGroupOutput {
    /// Creates a new builder-style object to manufacture [`ListUsersInGroupOutput`](crate::output::ListUsersInGroupOutput)
    pub fn builder() -> crate::output::list_users_in_group_output::Builder {
        crate::output::list_users_in_group_output::Builder::default()
    }
}

/// <p>The response from the request to list users.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersOutput {
    /// <p>The users returned in the request to list users.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::UserType>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub pagination_token: std::option::Option<std::string::String>,
}
impl ListUsersOutput {
    /// <p>The users returned in the request to list users.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::UserType]> {
        self.users.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn pagination_token(&self) -> std::option::Option<&str> {
        self.pagination_token.as_deref()
    }
}
impl std::fmt::Debug for ListUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersOutput");
        formatter.field("users", &self.users);
        formatter.field("pagination_token", &self.pagination_token);
        formatter.finish()
    }
}
/// See [`ListUsersOutput`](crate::output::ListUsersOutput)
pub mod list_users_output {
    /// A builder for [`ListUsersOutput`](crate::output::ListUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::UserType>>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>The users returned in the request to list users.</p>
        pub fn users(mut self, input: crate::model::UserType) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input);
            self.users = Some(v);
            self
        }
        /// <p>The users returned in the request to list users.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserType>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersOutput`](crate::output::ListUsersOutput)
        pub fn build(self) -> crate::output::ListUsersOutput {
            crate::output::ListUsersOutput {
                users: self.users,
                pagination_token: self.pagination_token,
            }
        }
    }
}
impl ListUsersOutput {
    /// Creates a new builder-style object to manufacture [`ListUsersOutput`](crate::output::ListUsersOutput)
    pub fn builder() -> crate::output::list_users_output::Builder {
        crate::output::list_users_output::Builder::default()
    }
}

/// <p>Represents the response to list user pools.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserPoolsOutput {
    /// <p>The user pools from the response to list users.</p>
    pub user_pools: std::option::Option<std::vec::Vec<crate::model::UserPoolDescriptionType>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUserPoolsOutput {
    /// <p>The user pools from the response to list users.</p>
    pub fn user_pools(&self) -> std::option::Option<&[crate::model::UserPoolDescriptionType]> {
        self.user_pools.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUserPoolsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserPoolsOutput");
        formatter.field("user_pools", &self.user_pools);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUserPoolsOutput`](crate::output::ListUserPoolsOutput)
pub mod list_user_pools_output {
    /// A builder for [`ListUserPoolsOutput`](crate::output::ListUserPoolsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pools:
            std::option::Option<std::vec::Vec<crate::model::UserPoolDescriptionType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_pools`.
        ///
        /// To override the contents of this collection use [`set_user_pools`](Self::set_user_pools).
        ///
        /// <p>The user pools from the response to list users.</p>
        pub fn user_pools(mut self, input: crate::model::UserPoolDescriptionType) -> Self {
            let mut v = self.user_pools.unwrap_or_default();
            v.push(input);
            self.user_pools = Some(v);
            self
        }
        /// <p>The user pools from the response to list users.</p>
        pub fn set_user_pools(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserPoolDescriptionType>>,
        ) -> Self {
            self.user_pools = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserPoolsOutput`](crate::output::ListUserPoolsOutput)
        pub fn build(self) -> crate::output::ListUserPoolsOutput {
            crate::output::ListUserPoolsOutput {
                user_pools: self.user_pools,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUserPoolsOutput {
    /// Creates a new builder-style object to manufacture [`ListUserPoolsOutput`](crate::output::ListUserPoolsOutput)
    pub fn builder() -> crate::output::list_user_pools_output::Builder {
        crate::output::list_user_pools_output::Builder::default()
    }
}

/// <p>Represents the response from the server that lists user pool clients.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserPoolClientsOutput {
    /// <p>The user pool clients in the response that lists user pool clients.</p>
    pub user_pool_clients:
        std::option::Option<std::vec::Vec<crate::model::UserPoolClientDescription>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUserPoolClientsOutput {
    /// <p>The user pool clients in the response that lists user pool clients.</p>
    pub fn user_pool_clients(
        &self,
    ) -> std::option::Option<&[crate::model::UserPoolClientDescription]> {
        self.user_pool_clients.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUserPoolClientsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserPoolClientsOutput");
        formatter.field("user_pool_clients", &self.user_pool_clients);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUserPoolClientsOutput`](crate::output::ListUserPoolClientsOutput)
pub mod list_user_pool_clients_output {
    /// A builder for [`ListUserPoolClientsOutput`](crate::output::ListUserPoolClientsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_clients:
            std::option::Option<std::vec::Vec<crate::model::UserPoolClientDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_pool_clients`.
        ///
        /// To override the contents of this collection use [`set_user_pool_clients`](Self::set_user_pool_clients).
        ///
        /// <p>The user pool clients in the response that lists user pool clients.</p>
        pub fn user_pool_clients(mut self, input: crate::model::UserPoolClientDescription) -> Self {
            let mut v = self.user_pool_clients.unwrap_or_default();
            v.push(input);
            self.user_pool_clients = Some(v);
            self
        }
        /// <p>The user pool clients in the response that lists user pool clients.</p>
        pub fn set_user_pool_clients(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserPoolClientDescription>>,
        ) -> Self {
            self.user_pool_clients = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserPoolClientsOutput`](crate::output::ListUserPoolClientsOutput)
        pub fn build(self) -> crate::output::ListUserPoolClientsOutput {
            crate::output::ListUserPoolClientsOutput {
                user_pool_clients: self.user_pool_clients,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUserPoolClientsOutput {
    /// Creates a new builder-style object to manufacture [`ListUserPoolClientsOutput`](crate::output::ListUserPoolClientsOutput)
    pub fn builder() -> crate::output::list_user_pool_clients_output::Builder {
        crate::output::list_user_pool_clients_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to list the user import jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserImportJobsOutput {
    /// <p>The user import jobs.</p>
    pub user_import_jobs: std::option::Option<std::vec::Vec<crate::model::UserImportJobType>>,
    /// <p>An identifier that can be used to return the next set of user import jobs in the list.</p>
    pub pagination_token: std::option::Option<std::string::String>,
}
impl ListUserImportJobsOutput {
    /// <p>The user import jobs.</p>
    pub fn user_import_jobs(&self) -> std::option::Option<&[crate::model::UserImportJobType]> {
        self.user_import_jobs.as_deref()
    }
    /// <p>An identifier that can be used to return the next set of user import jobs in the list.</p>
    pub fn pagination_token(&self) -> std::option::Option<&str> {
        self.pagination_token.as_deref()
    }
}
impl std::fmt::Debug for ListUserImportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserImportJobsOutput");
        formatter.field("user_import_jobs", &self.user_import_jobs);
        formatter.field("pagination_token", &self.pagination_token);
        formatter.finish()
    }
}
/// See [`ListUserImportJobsOutput`](crate::output::ListUserImportJobsOutput)
pub mod list_user_import_jobs_output {
    /// A builder for [`ListUserImportJobsOutput`](crate::output::ListUserImportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_import_jobs:
            std::option::Option<std::vec::Vec<crate::model::UserImportJobType>>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_import_jobs`.
        ///
        /// To override the contents of this collection use [`set_user_import_jobs`](Self::set_user_import_jobs).
        ///
        /// <p>The user import jobs.</p>
        pub fn user_import_jobs(mut self, input: crate::model::UserImportJobType) -> Self {
            let mut v = self.user_import_jobs.unwrap_or_default();
            v.push(input);
            self.user_import_jobs = Some(v);
            self
        }
        /// <p>The user import jobs.</p>
        pub fn set_user_import_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserImportJobType>>,
        ) -> Self {
            self.user_import_jobs = input;
            self
        }
        /// <p>An identifier that can be used to return the next set of user import jobs in the list.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>An identifier that can be used to return the next set of user import jobs in the list.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserImportJobsOutput`](crate::output::ListUserImportJobsOutput)
        pub fn build(self) -> crate::output::ListUserImportJobsOutput {
            crate::output::ListUserImportJobsOutput {
                user_import_jobs: self.user_import_jobs,
                pagination_token: self.pagination_token,
            }
        }
    }
}
impl ListUserImportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListUserImportJobsOutput`](crate::output::ListUserImportJobsOutput)
    pub fn builder() -> crate::output::list_user_import_jobs_output::Builder {
        crate::output::list_user_import_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the user pool.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the user pool.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are assigned to the user pool.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags that are assigned to the user pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceServersOutput {
    /// <p>The resource servers.</p>
    pub resource_servers: std::option::Option<std::vec::Vec<crate::model::ResourceServerType>>,
    /// <p>A pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourceServersOutput {
    /// <p>The resource servers.</p>
    pub fn resource_servers(&self) -> std::option::Option<&[crate::model::ResourceServerType]> {
        self.resource_servers.as_deref()
    }
    /// <p>A pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourceServersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceServersOutput");
        formatter.field("resource_servers", &self.resource_servers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourceServersOutput`](crate::output::ListResourceServersOutput)
pub mod list_resource_servers_output {
    /// A builder for [`ListResourceServersOutput`](crate::output::ListResourceServersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_servers:
            std::option::Option<std::vec::Vec<crate::model::ResourceServerType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_servers`.
        ///
        /// To override the contents of this collection use [`set_resource_servers`](Self::set_resource_servers).
        ///
        /// <p>The resource servers.</p>
        pub fn resource_servers(mut self, input: crate::model::ResourceServerType) -> Self {
            let mut v = self.resource_servers.unwrap_or_default();
            v.push(input);
            self.resource_servers = Some(v);
            self
        }
        /// <p>The resource servers.</p>
        pub fn set_resource_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceServerType>>,
        ) -> Self {
            self.resource_servers = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceServersOutput`](crate::output::ListResourceServersOutput)
        pub fn build(self) -> crate::output::ListResourceServersOutput {
            crate::output::ListResourceServersOutput {
                resource_servers: self.resource_servers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourceServersOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceServersOutput`](crate::output::ListResourceServersOutput)
    pub fn builder() -> crate::output::list_resource_servers_output::Builder {
        crate::output::list_resource_servers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityProvidersOutput {
    /// <p>A list of identity provider objects.</p>
    pub providers: std::option::Option<std::vec::Vec<crate::model::ProviderDescription>>,
    /// <p>A pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIdentityProvidersOutput {
    /// <p>A list of identity provider objects.</p>
    pub fn providers(&self) -> std::option::Option<&[crate::model::ProviderDescription]> {
        self.providers.as_deref()
    }
    /// <p>A pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIdentityProvidersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityProvidersOutput");
        formatter.field("providers", &self.providers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIdentityProvidersOutput`](crate::output::ListIdentityProvidersOutput)
pub mod list_identity_providers_output {
    /// A builder for [`ListIdentityProvidersOutput`](crate::output::ListIdentityProvidersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) providers: std::option::Option<std::vec::Vec<crate::model::ProviderDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `providers`.
        ///
        /// To override the contents of this collection use [`set_providers`](Self::set_providers).
        ///
        /// <p>A list of identity provider objects.</p>
        pub fn providers(mut self, input: crate::model::ProviderDescription) -> Self {
            let mut v = self.providers.unwrap_or_default();
            v.push(input);
            self.providers = Some(v);
            self
        }
        /// <p>A list of identity provider objects.</p>
        pub fn set_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProviderDescription>>,
        ) -> Self {
            self.providers = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityProvidersOutput`](crate::output::ListIdentityProvidersOutput)
        pub fn build(self) -> crate::output::ListIdentityProvidersOutput {
            crate::output::ListIdentityProvidersOutput {
                providers: self.providers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIdentityProvidersOutput {
    /// Creates a new builder-style object to manufacture [`ListIdentityProvidersOutput`](crate::output::ListIdentityProvidersOutput)
    pub fn builder() -> crate::output::list_identity_providers_output::Builder {
        crate::output::list_identity_providers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsOutput {
    /// <p>The group objects for the groups.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::GroupType>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGroupsOutput {
    /// <p>The group objects for the groups.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::GroupType]> {
        self.groups.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsOutput");
        formatter.field("groups", &self.groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGroupsOutput`](crate::output::ListGroupsOutput)
pub mod list_groups_output {
    /// A builder for [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::GroupType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The group objects for the groups.</p>
        pub fn groups(mut self, input: crate::model::GroupType) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>The group objects for the groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupType>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsOutput`](crate::output::ListGroupsOutput)
        pub fn build(self) -> crate::output::ListGroupsOutput {
            crate::output::ListGroupsOutput {
                groups: self.groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    pub fn builder() -> crate::output::list_groups_output::Builder {
        crate::output::list_groups_output::Builder::default()
    }
}

/// <p>Represents the response to list devices.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesOutput {
    /// <p>The devices returned in the list devices response.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::DeviceType>>,
    /// <p>The pagination token for the list device response.</p>
    pub pagination_token: std::option::Option<std::string::String>,
}
impl ListDevicesOutput {
    /// <p>The devices returned in the list devices response.</p>
    pub fn devices(&self) -> std::option::Option<&[crate::model::DeviceType]> {
        self.devices.as_deref()
    }
    /// <p>The pagination token for the list device response.</p>
    pub fn pagination_token(&self) -> std::option::Option<&str> {
        self.pagination_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("pagination_token", &self.pagination_token);
        formatter.finish()
    }
}
/// See [`ListDevicesOutput`](crate::output::ListDevicesOutput)
pub mod list_devices_output {
    /// A builder for [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::DeviceType>>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>The devices returned in the list devices response.</p>
        pub fn devices(mut self, input: crate::model::DeviceType) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input);
            self.devices = Some(v);
            self
        }
        /// <p>The devices returned in the list devices response.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceType>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>The pagination token for the list device response.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list device response.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesOutput`](crate::output::ListDevicesOutput)
        pub fn build(self) -> crate::output::ListDevicesOutput {
            crate::output::ListDevicesOutput {
                devices: self.devices,
                pagination_token: self.pagination_token,
            }
        }
    }
}
impl ListDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    pub fn builder() -> crate::output::list_devices_output::Builder {
        crate::output::list_devices_output::Builder::default()
    }
}

/// <p>Initiates the authentication response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateAuthOutput {
    /// <p>The name of the challenge that you're responding to with this call. This name is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
    /// <p>Valid values include the following:</p> <note>
    /// <p>All of the following challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p>
    /// </note>
    /// <ul>
    /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
    /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
    /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
    /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
    /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
    /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
    /// <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>. Use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
    /// </ul>
    pub challenge_name: std::option::Option<crate::model::ChallengeNameType>,
    /// <p>The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    pub session: std::option::Option<std::string::String>,
    /// <p>The challenge parameters. These are returned in the <code>InitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p>
    /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
    pub challenge_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The result of the authentication response. This result is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
    pub authentication_result: std::option::Option<crate::model::AuthenticationResultType>,
}
impl InitiateAuthOutput {
    /// <p>The name of the challenge that you're responding to with this call. This name is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
    /// <p>Valid values include the following:</p> <note>
    /// <p>All of the following challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p>
    /// </note>
    /// <ul>
    /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
    /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
    /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
    /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
    /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
    /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
    /// <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>. Use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
    /// </ul>
    pub fn challenge_name(&self) -> std::option::Option<&crate::model::ChallengeNameType> {
        self.challenge_name.as_ref()
    }
    /// <p>The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    pub fn session(&self) -> std::option::Option<&str> {
        self.session.as_deref()
    }
    /// <p>The challenge parameters. These are returned in the <code>InitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p>
    /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
    pub fn challenge_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.challenge_parameters.as_ref()
    }
    /// <p>The result of the authentication response. This result is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
    pub fn authentication_result(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationResultType> {
        self.authentication_result.as_ref()
    }
}
impl std::fmt::Debug for InitiateAuthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateAuthOutput");
        formatter.field("challenge_name", &self.challenge_name);
        formatter.field("session", &self.session);
        formatter.field("challenge_parameters", &self.challenge_parameters);
        formatter.field("authentication_result", &self.authentication_result);
        formatter.finish()
    }
}
/// See [`InitiateAuthOutput`](crate::output::InitiateAuthOutput)
pub mod initiate_auth_output {
    /// A builder for [`InitiateAuthOutput`](crate::output::InitiateAuthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) challenge_name: std::option::Option<crate::model::ChallengeNameType>,
        pub(crate) session: std::option::Option<std::string::String>,
        pub(crate) challenge_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) authentication_result:
            std::option::Option<crate::model::AuthenticationResultType>,
    }
    impl Builder {
        /// <p>The name of the challenge that you're responding to with this call. This name is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
        /// <p>Valid values include the following:</p> <note>
        /// <p>All of the following challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p>
        /// </note>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
        /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>. Use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
        /// </ul>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.challenge_name = Some(input);
            self
        }
        /// <p>The name of the challenge that you're responding to with this call. This name is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
        /// <p>Valid values include the following:</p> <note>
        /// <p>All of the following challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p>
        /// </note>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
        /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>. Use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
        /// </ul>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.challenge_name = input;
            self
        }
        /// <p>The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Adds a key-value pair to `challenge_parameters`.
        ///
        /// To override the contents of this collection use [`set_challenge_parameters`](Self::set_challenge_parameters).
        ///
        /// <p>The challenge parameters. These are returned in the <code>InitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p>
        /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
        pub fn challenge_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.challenge_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.challenge_parameters = Some(hash_map);
            self
        }
        /// <p>The challenge parameters. These are returned in the <code>InitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p>
        /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
        pub fn set_challenge_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.challenge_parameters = input;
            self
        }
        /// <p>The result of the authentication response. This result is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
        pub fn authentication_result(
            mut self,
            input: crate::model::AuthenticationResultType,
        ) -> Self {
            self.authentication_result = Some(input);
            self
        }
        /// <p>The result of the authentication response. This result is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
        pub fn set_authentication_result(
            mut self,
            input: std::option::Option<crate::model::AuthenticationResultType>,
        ) -> Self {
            self.authentication_result = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateAuthOutput`](crate::output::InitiateAuthOutput)
        pub fn build(self) -> crate::output::InitiateAuthOutput {
            crate::output::InitiateAuthOutput {
                challenge_name: self.challenge_name,
                session: self.session,
                challenge_parameters: self.challenge_parameters,
                authentication_result: self.authentication_result,
            }
        }
    }
}
impl InitiateAuthOutput {
    /// Creates a new builder-style object to manufacture [`InitiateAuthOutput`](crate::output::InitiateAuthOutput)
    pub fn builder() -> crate::output::initiate_auth_output::Builder {
        crate::output::initiate_auth_output::Builder::default()
    }
}

/// <p>The response to the request to sign out all devices.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalSignOutOutput {}
impl std::fmt::Debug for GlobalSignOutOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalSignOutOutput");
        formatter.finish()
    }
}
/// See [`GlobalSignOutOutput`](crate::output::GlobalSignOutOutput)
pub mod global_sign_out_output {
    /// A builder for [`GlobalSignOutOutput`](crate::output::GlobalSignOutOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GlobalSignOutOutput`](crate::output::GlobalSignOutOutput)
        pub fn build(self) -> crate::output::GlobalSignOutOutput {
            crate::output::GlobalSignOutOutput {}
        }
    }
}
impl GlobalSignOutOutput {
    /// Creates a new builder-style object to manufacture [`GlobalSignOutOutput`](crate::output::GlobalSignOutOutput)
    pub fn builder() -> crate::output::global_sign_out_output::Builder {
        crate::output::global_sign_out_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserPoolMfaConfigOutput {
    /// <p>The SMS text message multi-factor (MFA) configuration.</p>
    pub sms_mfa_configuration: std::option::Option<crate::model::SmsMfaConfigType>,
    /// <p>The software token multi-factor (MFA) configuration.</p>
    pub software_token_mfa_configuration:
        std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
    /// <p>The multi-factor (MFA) configuration. Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
    /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
    /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li>
    /// </ul>
    pub mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
}
impl GetUserPoolMfaConfigOutput {
    /// <p>The SMS text message multi-factor (MFA) configuration.</p>
    pub fn sms_mfa_configuration(&self) -> std::option::Option<&crate::model::SmsMfaConfigType> {
        self.sms_mfa_configuration.as_ref()
    }
    /// <p>The software token multi-factor (MFA) configuration.</p>
    pub fn software_token_mfa_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SoftwareTokenMfaConfigType> {
        self.software_token_mfa_configuration.as_ref()
    }
    /// <p>The multi-factor (MFA) configuration. Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
    /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
    /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li>
    /// </ul>
    pub fn mfa_configuration(&self) -> std::option::Option<&crate::model::UserPoolMfaType> {
        self.mfa_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetUserPoolMfaConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserPoolMfaConfigOutput");
        formatter.field("sms_mfa_configuration", &self.sms_mfa_configuration);
        formatter.field(
            "software_token_mfa_configuration",
            &self.software_token_mfa_configuration,
        );
        formatter.field("mfa_configuration", &self.mfa_configuration);
        formatter.finish()
    }
}
/// See [`GetUserPoolMfaConfigOutput`](crate::output::GetUserPoolMfaConfigOutput)
pub mod get_user_pool_mfa_config_output {
    /// A builder for [`GetUserPoolMfaConfigOutput`](crate::output::GetUserPoolMfaConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_mfa_configuration: std::option::Option<crate::model::SmsMfaConfigType>,
        pub(crate) software_token_mfa_configuration:
            std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
        pub(crate) mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
    }
    impl Builder {
        /// <p>The SMS text message multi-factor (MFA) configuration.</p>
        pub fn sms_mfa_configuration(mut self, input: crate::model::SmsMfaConfigType) -> Self {
            self.sms_mfa_configuration = Some(input);
            self
        }
        /// <p>The SMS text message multi-factor (MFA) configuration.</p>
        pub fn set_sms_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsMfaConfigType>,
        ) -> Self {
            self.sms_mfa_configuration = input;
            self
        }
        /// <p>The software token multi-factor (MFA) configuration.</p>
        pub fn software_token_mfa_configuration(
            mut self,
            input: crate::model::SoftwareTokenMfaConfigType,
        ) -> Self {
            self.software_token_mfa_configuration = Some(input);
            self
        }
        /// <p>The software token multi-factor (MFA) configuration.</p>
        pub fn set_software_token_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
        ) -> Self {
            self.software_token_mfa_configuration = input;
            self
        }
        /// <p>The multi-factor (MFA) configuration. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li>
        /// </ul>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.mfa_configuration = Some(input);
            self
        }
        /// <p>The multi-factor (MFA) configuration. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li>
        /// </ul>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.mfa_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserPoolMfaConfigOutput`](crate::output::GetUserPoolMfaConfigOutput)
        pub fn build(self) -> crate::output::GetUserPoolMfaConfigOutput {
            crate::output::GetUserPoolMfaConfigOutput {
                sms_mfa_configuration: self.sms_mfa_configuration,
                software_token_mfa_configuration: self.software_token_mfa_configuration,
                mfa_configuration: self.mfa_configuration,
            }
        }
    }
}
impl GetUserPoolMfaConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetUserPoolMfaConfigOutput`](crate::output::GetUserPoolMfaConfigOutput)
    pub fn builder() -> crate::output::get_user_pool_mfa_config_output::Builder {
        crate::output::get_user_pool_mfa_config_output::Builder::default()
    }
}

/// <p>The verification code response returned by the server response to get the user attribute verification code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserAttributeVerificationCodeOutput {
    /// <p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>
    pub code_delivery_details: std::option::Option<crate::model::CodeDeliveryDetailsType>,
}
impl GetUserAttributeVerificationCodeOutput {
    /// <p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>
    pub fn code_delivery_details(
        &self,
    ) -> std::option::Option<&crate::model::CodeDeliveryDetailsType> {
        self.code_delivery_details.as_ref()
    }
}
impl std::fmt::Debug for GetUserAttributeVerificationCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserAttributeVerificationCodeOutput");
        formatter.field("code_delivery_details", &self.code_delivery_details);
        formatter.finish()
    }
}
/// See [`GetUserAttributeVerificationCodeOutput`](crate::output::GetUserAttributeVerificationCodeOutput)
pub mod get_user_attribute_verification_code_output {
    /// A builder for [`GetUserAttributeVerificationCodeOutput`](crate::output::GetUserAttributeVerificationCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_delivery_details:
            std::option::Option<crate::model::CodeDeliveryDetailsType>,
    }
    impl Builder {
        /// <p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>
        pub fn code_delivery_details(
            mut self,
            input: crate::model::CodeDeliveryDetailsType,
        ) -> Self {
            self.code_delivery_details = Some(input);
            self
        }
        /// <p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>
        pub fn set_code_delivery_details(
            mut self,
            input: std::option::Option<crate::model::CodeDeliveryDetailsType>,
        ) -> Self {
            self.code_delivery_details = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserAttributeVerificationCodeOutput`](crate::output::GetUserAttributeVerificationCodeOutput)
        pub fn build(self) -> crate::output::GetUserAttributeVerificationCodeOutput {
            crate::output::GetUserAttributeVerificationCodeOutput {
                code_delivery_details: self.code_delivery_details,
            }
        }
    }
}
impl GetUserAttributeVerificationCodeOutput {
    /// Creates a new builder-style object to manufacture [`GetUserAttributeVerificationCodeOutput`](crate::output::GetUserAttributeVerificationCodeOutput)
    pub fn builder() -> crate::output::get_user_attribute_verification_code_output::Builder {
        crate::output::get_user_attribute_verification_code_output::Builder::default()
    }
}

/// <p>Represents the response from the server from the request to get information about the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserOutput {
    /// <p>The user name of the user you want to retrieve from the get user request.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>An array of name-value pairs representing user attributes.</p>
    /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    pub user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
    /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
    pub mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
    /// <p>The user's preferred MFA setting.</p>
    pub preferred_mfa_setting: std::option::Option<std::string::String>,
    /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
    pub user_mfa_setting_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetUserOutput {
    /// <p>The user name of the user you want to retrieve from the get user request.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>An array of name-value pairs representing user attributes.</p>
    /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
    pub fn user_attributes(&self) -> std::option::Option<&[crate::model::AttributeType]> {
        self.user_attributes.as_deref()
    }
    /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
    pub fn mfa_options(&self) -> std::option::Option<&[crate::model::MfaOptionType]> {
        self.mfa_options.as_deref()
    }
    /// <p>The user's preferred MFA setting.</p>
    pub fn preferred_mfa_setting(&self) -> std::option::Option<&str> {
        self.preferred_mfa_setting.as_deref()
    }
    /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
    pub fn user_mfa_setting_list(&self) -> std::option::Option<&[std::string::String]> {
        self.user_mfa_setting_list.as_deref()
    }
}
impl std::fmt::Debug for GetUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserOutput");
        formatter.field("username", &"*** Sensitive Data Redacted ***");
        formatter.field("user_attributes", &self.user_attributes);
        formatter.field("mfa_options", &self.mfa_options);
        formatter.field("preferred_mfa_setting", &self.preferred_mfa_setting);
        formatter.field("user_mfa_setting_list", &self.user_mfa_setting_list);
        formatter.finish()
    }
}
/// See [`GetUserOutput`](crate::output::GetUserOutput)
pub mod get_user_output {
    /// A builder for [`GetUserOutput`](crate::output::GetUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        pub(crate) preferred_mfa_setting: std::option::Option<std::string::String>,
        pub(crate) user_mfa_setting_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The user name of the user you want to retrieve from the get user request.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user you want to retrieve from the get user request.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input);
            self.user_attributes = Some(v);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// Appends an item to `mfa_options`.
        ///
        /// To override the contents of this collection use [`set_mfa_options`](Self::set_mfa_options).
        ///
        /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
        pub fn mfa_options(mut self, input: crate::model::MfaOptionType) -> Self {
            let mut v = self.mfa_options.unwrap_or_default();
            v.push(input);
            self.mfa_options = Some(v);
            self
        }
        /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
        pub fn set_mfa_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        ) -> Self {
            self.mfa_options = input;
            self
        }
        /// <p>The user's preferred MFA setting.</p>
        pub fn preferred_mfa_setting(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_mfa_setting = Some(input.into());
            self
        }
        /// <p>The user's preferred MFA setting.</p>
        pub fn set_preferred_mfa_setting(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_mfa_setting = input;
            self
        }
        /// Appends an item to `user_mfa_setting_list`.
        ///
        /// To override the contents of this collection use [`set_user_mfa_setting_list`](Self::set_user_mfa_setting_list).
        ///
        /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
        pub fn user_mfa_setting_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_mfa_setting_list.unwrap_or_default();
            v.push(input.into());
            self.user_mfa_setting_list = Some(v);
            self
        }
        /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
        pub fn set_user_mfa_setting_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_mfa_setting_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserOutput`](crate::output::GetUserOutput)
        pub fn build(self) -> crate::output::GetUserOutput {
            crate::output::GetUserOutput {
                username: self.username,
                user_attributes: self.user_attributes,
                mfa_options: self.mfa_options,
                preferred_mfa_setting: self.preferred_mfa_setting,
                user_mfa_setting_list: self.user_mfa_setting_list,
            }
        }
    }
}
impl GetUserOutput {
    /// Creates a new builder-style object to manufacture [`GetUserOutput`](crate::output::GetUserOutput)
    pub fn builder() -> crate::output::get_user_output::Builder {
        crate::output::get_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUiCustomizationOutput {
    /// <p>The UI customization information.</p>
    pub ui_customization: std::option::Option<crate::model::UiCustomizationType>,
}
impl GetUiCustomizationOutput {
    /// <p>The UI customization information.</p>
    pub fn ui_customization(&self) -> std::option::Option<&crate::model::UiCustomizationType> {
        self.ui_customization.as_ref()
    }
}
impl std::fmt::Debug for GetUiCustomizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUiCustomizationOutput");
        formatter.field("ui_customization", &self.ui_customization);
        formatter.finish()
    }
}
/// See [`GetUiCustomizationOutput`](crate::output::GetUiCustomizationOutput)
pub mod get_ui_customization_output {
    /// A builder for [`GetUiCustomizationOutput`](crate::output::GetUiCustomizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ui_customization: std::option::Option<crate::model::UiCustomizationType>,
    }
    impl Builder {
        /// <p>The UI customization information.</p>
        pub fn ui_customization(mut self, input: crate::model::UiCustomizationType) -> Self {
            self.ui_customization = Some(input);
            self
        }
        /// <p>The UI customization information.</p>
        pub fn set_ui_customization(
            mut self,
            input: std::option::Option<crate::model::UiCustomizationType>,
        ) -> Self {
            self.ui_customization = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUiCustomizationOutput`](crate::output::GetUiCustomizationOutput)
        pub fn build(self) -> crate::output::GetUiCustomizationOutput {
            crate::output::GetUiCustomizationOutput {
                ui_customization: self.ui_customization,
            }
        }
    }
}
impl GetUiCustomizationOutput {
    /// Creates a new builder-style object to manufacture [`GetUiCustomizationOutput`](crate::output::GetUiCustomizationOutput)
    pub fn builder() -> crate::output::get_ui_customization_output::Builder {
        crate::output::get_ui_customization_output::Builder::default()
    }
}

/// <p>Response from Amazon Cognito for a signing certificate request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSigningCertificateOutput {
    /// <p>The signing certificate.</p>
    pub certificate: std::option::Option<std::string::String>,
}
impl GetSigningCertificateOutput {
    /// <p>The signing certificate.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
}
impl std::fmt::Debug for GetSigningCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSigningCertificateOutput");
        formatter.field("certificate", &self.certificate);
        formatter.finish()
    }
}
/// See [`GetSigningCertificateOutput`](crate::output::GetSigningCertificateOutput)
pub mod get_signing_certificate_output {
    /// A builder for [`GetSigningCertificateOutput`](crate::output::GetSigningCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The signing certificate.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The signing certificate.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSigningCertificateOutput`](crate::output::GetSigningCertificateOutput)
        pub fn build(self) -> crate::output::GetSigningCertificateOutput {
            crate::output::GetSigningCertificateOutput {
                certificate: self.certificate,
            }
        }
    }
}
impl GetSigningCertificateOutput {
    /// Creates a new builder-style object to manufacture [`GetSigningCertificateOutput`](crate::output::GetSigningCertificateOutput)
    pub fn builder() -> crate::output::get_signing_certificate_output::Builder {
        crate::output::get_signing_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityProviderByIdentifierOutput {
    /// <p>The identity provider object.</p>
    pub identity_provider: std::option::Option<crate::model::IdentityProviderType>,
}
impl GetIdentityProviderByIdentifierOutput {
    /// <p>The identity provider object.</p>
    pub fn identity_provider(&self) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityProviderByIdentifierOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityProviderByIdentifierOutput");
        formatter.field("identity_provider", &self.identity_provider);
        formatter.finish()
    }
}
/// See [`GetIdentityProviderByIdentifierOutput`](crate::output::GetIdentityProviderByIdentifierOutput)
pub mod get_identity_provider_by_identifier_output {
    /// A builder for [`GetIdentityProviderByIdentifierOutput`](crate::output::GetIdentityProviderByIdentifierOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider: std::option::Option<crate::model::IdentityProviderType>,
    }
    impl Builder {
        /// <p>The identity provider object.</p>
        pub fn identity_provider(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider = Some(input);
            self
        }
        /// <p>The identity provider object.</p>
        pub fn set_identity_provider(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityProviderByIdentifierOutput`](crate::output::GetIdentityProviderByIdentifierOutput)
        pub fn build(self) -> crate::output::GetIdentityProviderByIdentifierOutput {
            crate::output::GetIdentityProviderByIdentifierOutput {
                identity_provider: self.identity_provider,
            }
        }
    }
}
impl GetIdentityProviderByIdentifierOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityProviderByIdentifierOutput`](crate::output::GetIdentityProviderByIdentifierOutput)
    pub fn builder() -> crate::output::get_identity_provider_by_identifier_output::Builder {
        crate::output::get_identity_provider_by_identifier_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupOutput {
    /// <p>The group object for the group.</p>
    pub group: std::option::Option<crate::model::GroupType>,
}
impl GetGroupOutput {
    /// <p>The group object for the group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::GroupType> {
        self.group.as_ref()
    }
}
impl std::fmt::Debug for GetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`GetGroupOutput`](crate::output::GetGroupOutput)
pub mod get_group_output {
    /// A builder for [`GetGroupOutput`](crate::output::GetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::GroupType>,
    }
    impl Builder {
        /// <p>The group object for the group.</p>
        pub fn group(mut self, input: crate::model::GroupType) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The group object for the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::GroupType>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupOutput`](crate::output::GetGroupOutput)
        pub fn build(self) -> crate::output::GetGroupOutput {
            crate::output::GetGroupOutput { group: self.group }
        }
    }
}
impl GetGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupOutput`](crate::output::GetGroupOutput)
    pub fn builder() -> crate::output::get_group_output::Builder {
        crate::output::get_group_output::Builder::default()
    }
}

/// <p>Gets the device response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceOutput {
    /// <p>The device.</p>
    pub device: std::option::Option<crate::model::DeviceType>,
}
impl GetDeviceOutput {
    /// <p>The device.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::DeviceType> {
        self.device.as_ref()
    }
}
impl std::fmt::Debug for GetDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`GetDeviceOutput`](crate::output::GetDeviceOutput)
pub mod get_device_output {
    /// A builder for [`GetDeviceOutput`](crate::output::GetDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::DeviceType>,
    }
    impl Builder {
        /// <p>The device.</p>
        pub fn device(mut self, input: crate::model::DeviceType) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>The device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::DeviceType>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceOutput`](crate::output::GetDeviceOutput)
        pub fn build(self) -> crate::output::GetDeviceOutput {
            crate::output::GetDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl GetDeviceOutput {
    /// Creates a new builder-style object to manufacture [`GetDeviceOutput`](crate::output::GetDeviceOutput)
    pub fn builder() -> crate::output::get_device_output::Builder {
        crate::output::get_device_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to get the header information of the CSV file for the user import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCsvHeaderOutput {
    /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The header information of the CSV file for the user import job.</p>
    pub csv_header: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetCsvHeaderOutput {
    /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The header information of the CSV file for the user import job.</p>
    pub fn csv_header(&self) -> std::option::Option<&[std::string::String]> {
        self.csv_header.as_deref()
    }
}
impl std::fmt::Debug for GetCsvHeaderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCsvHeaderOutput");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("csv_header", &self.csv_header);
        formatter.finish()
    }
}
/// See [`GetCsvHeaderOutput`](crate::output::GetCsvHeaderOutput)
pub mod get_csv_header_output {
    /// A builder for [`GetCsvHeaderOutput`](crate::output::GetCsvHeaderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) csv_header: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Appends an item to `csv_header`.
        ///
        /// To override the contents of this collection use [`set_csv_header`](Self::set_csv_header).
        ///
        /// <p>The header information of the CSV file for the user import job.</p>
        pub fn csv_header(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.csv_header.unwrap_or_default();
            v.push(input.into());
            self.csv_header = Some(v);
            self
        }
        /// <p>The header information of the CSV file for the user import job.</p>
        pub fn set_csv_header(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.csv_header = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCsvHeaderOutput`](crate::output::GetCsvHeaderOutput)
        pub fn build(self) -> crate::output::GetCsvHeaderOutput {
            crate::output::GetCsvHeaderOutput {
                user_pool_id: self.user_pool_id,
                csv_header: self.csv_header,
            }
        }
    }
}
impl GetCsvHeaderOutput {
    /// Creates a new builder-style object to manufacture [`GetCsvHeaderOutput`](crate::output::GetCsvHeaderOutput)
    pub fn builder() -> crate::output::get_csv_header_output::Builder {
        crate::output::get_csv_header_output::Builder::default()
    }
}

/// <p>Respresents the response from the server regarding the request to reset a password.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForgotPasswordOutput {
    /// <p>The code delivery details returned by the server in response to the request to reset a password.</p>
    pub code_delivery_details: std::option::Option<crate::model::CodeDeliveryDetailsType>,
}
impl ForgotPasswordOutput {
    /// <p>The code delivery details returned by the server in response to the request to reset a password.</p>
    pub fn code_delivery_details(
        &self,
    ) -> std::option::Option<&crate::model::CodeDeliveryDetailsType> {
        self.code_delivery_details.as_ref()
    }
}
impl std::fmt::Debug for ForgotPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForgotPasswordOutput");
        formatter.field("code_delivery_details", &self.code_delivery_details);
        formatter.finish()
    }
}
/// See [`ForgotPasswordOutput`](crate::output::ForgotPasswordOutput)
pub mod forgot_password_output {
    /// A builder for [`ForgotPasswordOutput`](crate::output::ForgotPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_delivery_details:
            std::option::Option<crate::model::CodeDeliveryDetailsType>,
    }
    impl Builder {
        /// <p>The code delivery details returned by the server in response to the request to reset a password.</p>
        pub fn code_delivery_details(
            mut self,
            input: crate::model::CodeDeliveryDetailsType,
        ) -> Self {
            self.code_delivery_details = Some(input);
            self
        }
        /// <p>The code delivery details returned by the server in response to the request to reset a password.</p>
        pub fn set_code_delivery_details(
            mut self,
            input: std::option::Option<crate::model::CodeDeliveryDetailsType>,
        ) -> Self {
            self.code_delivery_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ForgotPasswordOutput`](crate::output::ForgotPasswordOutput)
        pub fn build(self) -> crate::output::ForgotPasswordOutput {
            crate::output::ForgotPasswordOutput {
                code_delivery_details: self.code_delivery_details,
            }
        }
    }
}
impl ForgotPasswordOutput {
    /// Creates a new builder-style object to manufacture [`ForgotPasswordOutput`](crate::output::ForgotPasswordOutput)
    pub fn builder() -> crate::output::forgot_password_output::Builder {
        crate::output::forgot_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForgetDeviceOutput {}
impl std::fmt::Debug for ForgetDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForgetDeviceOutput");
        formatter.finish()
    }
}
/// See [`ForgetDeviceOutput`](crate::output::ForgetDeviceOutput)
pub mod forget_device_output {
    /// A builder for [`ForgetDeviceOutput`](crate::output::ForgetDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ForgetDeviceOutput`](crate::output::ForgetDeviceOutput)
        pub fn build(self) -> crate::output::ForgetDeviceOutput {
            crate::output::ForgetDeviceOutput {}
        }
    }
}
impl ForgetDeviceOutput {
    /// Creates a new builder-style object to manufacture [`ForgetDeviceOutput`](crate::output::ForgetDeviceOutput)
    pub fn builder() -> crate::output::forget_device_output::Builder {
        crate::output::forget_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserPoolDomainOutput {
    /// <p>A domain description object containing information about the domain.</p>
    pub domain_description: std::option::Option<crate::model::DomainDescriptionType>,
}
impl DescribeUserPoolDomainOutput {
    /// <p>A domain description object containing information about the domain.</p>
    pub fn domain_description(&self) -> std::option::Option<&crate::model::DomainDescriptionType> {
        self.domain_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeUserPoolDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserPoolDomainOutput");
        formatter.field("domain_description", &self.domain_description);
        formatter.finish()
    }
}
/// See [`DescribeUserPoolDomainOutput`](crate::output::DescribeUserPoolDomainOutput)
pub mod describe_user_pool_domain_output {
    /// A builder for [`DescribeUserPoolDomainOutput`](crate::output::DescribeUserPoolDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_description: std::option::Option<crate::model::DomainDescriptionType>,
    }
    impl Builder {
        /// <p>A domain description object containing information about the domain.</p>
        pub fn domain_description(mut self, input: crate::model::DomainDescriptionType) -> Self {
            self.domain_description = Some(input);
            self
        }
        /// <p>A domain description object containing information about the domain.</p>
        pub fn set_domain_description(
            mut self,
            input: std::option::Option<crate::model::DomainDescriptionType>,
        ) -> Self {
            self.domain_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserPoolDomainOutput`](crate::output::DescribeUserPoolDomainOutput)
        pub fn build(self) -> crate::output::DescribeUserPoolDomainOutput {
            crate::output::DescribeUserPoolDomainOutput {
                domain_description: self.domain_description,
            }
        }
    }
}
impl DescribeUserPoolDomainOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolDomainOutput`](crate::output::DescribeUserPoolDomainOutput)
    pub fn builder() -> crate::output::describe_user_pool_domain_output::Builder {
        crate::output::describe_user_pool_domain_output::Builder::default()
    }
}

/// <p>Represents the response from the server from a request to describe the user pool client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserPoolClientOutput {
    /// <p>The user pool client from a server response to describe the user pool client.</p>
    pub user_pool_client: std::option::Option<crate::model::UserPoolClientType>,
}
impl DescribeUserPoolClientOutput {
    /// <p>The user pool client from a server response to describe the user pool client.</p>
    pub fn user_pool_client(&self) -> std::option::Option<&crate::model::UserPoolClientType> {
        self.user_pool_client.as_ref()
    }
}
impl std::fmt::Debug for DescribeUserPoolClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserPoolClientOutput");
        formatter.field("user_pool_client", &self.user_pool_client);
        formatter.finish()
    }
}
/// See [`DescribeUserPoolClientOutput`](crate::output::DescribeUserPoolClientOutput)
pub mod describe_user_pool_client_output {
    /// A builder for [`DescribeUserPoolClientOutput`](crate::output::DescribeUserPoolClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_client: std::option::Option<crate::model::UserPoolClientType>,
    }
    impl Builder {
        /// <p>The user pool client from a server response to describe the user pool client.</p>
        pub fn user_pool_client(mut self, input: crate::model::UserPoolClientType) -> Self {
            self.user_pool_client = Some(input);
            self
        }
        /// <p>The user pool client from a server response to describe the user pool client.</p>
        pub fn set_user_pool_client(
            mut self,
            input: std::option::Option<crate::model::UserPoolClientType>,
        ) -> Self {
            self.user_pool_client = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserPoolClientOutput`](crate::output::DescribeUserPoolClientOutput)
        pub fn build(self) -> crate::output::DescribeUserPoolClientOutput {
            crate::output::DescribeUserPoolClientOutput {
                user_pool_client: self.user_pool_client,
            }
        }
    }
}
impl DescribeUserPoolClientOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolClientOutput`](crate::output::DescribeUserPoolClientOutput)
    pub fn builder() -> crate::output::describe_user_pool_client_output::Builder {
        crate::output::describe_user_pool_client_output::Builder::default()
    }
}

/// <p>Represents the response to describe the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserPoolOutput {
    /// <p>The container of metadata returned by the server to describe the pool.</p>
    pub user_pool: std::option::Option<crate::model::UserPoolType>,
}
impl DescribeUserPoolOutput {
    /// <p>The container of metadata returned by the server to describe the pool.</p>
    pub fn user_pool(&self) -> std::option::Option<&crate::model::UserPoolType> {
        self.user_pool.as_ref()
    }
}
impl std::fmt::Debug for DescribeUserPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserPoolOutput");
        formatter.field("user_pool", &self.user_pool);
        formatter.finish()
    }
}
/// See [`DescribeUserPoolOutput`](crate::output::DescribeUserPoolOutput)
pub mod describe_user_pool_output {
    /// A builder for [`DescribeUserPoolOutput`](crate::output::DescribeUserPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool: std::option::Option<crate::model::UserPoolType>,
    }
    impl Builder {
        /// <p>The container of metadata returned by the server to describe the pool.</p>
        pub fn user_pool(mut self, input: crate::model::UserPoolType) -> Self {
            self.user_pool = Some(input);
            self
        }
        /// <p>The container of metadata returned by the server to describe the pool.</p>
        pub fn set_user_pool(
            mut self,
            input: std::option::Option<crate::model::UserPoolType>,
        ) -> Self {
            self.user_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserPoolOutput`](crate::output::DescribeUserPoolOutput)
        pub fn build(self) -> crate::output::DescribeUserPoolOutput {
            crate::output::DescribeUserPoolOutput {
                user_pool: self.user_pool,
            }
        }
    }
}
impl DescribeUserPoolOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolOutput`](crate::output::DescribeUserPoolOutput)
    pub fn builder() -> crate::output::describe_user_pool_output::Builder {
        crate::output::describe_user_pool_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to describe the user import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub user_import_job: std::option::Option<crate::model::UserImportJobType>,
}
impl DescribeUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub fn user_import_job(&self) -> std::option::Option<&crate::model::UserImportJobType> {
        self.user_import_job.as_ref()
    }
}
impl std::fmt::Debug for DescribeUserImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserImportJobOutput");
        formatter.field("user_import_job", &self.user_import_job);
        formatter.finish()
    }
}
/// See [`DescribeUserImportJobOutput`](crate::output::DescribeUserImportJobOutput)
pub mod describe_user_import_job_output {
    /// A builder for [`DescribeUserImportJobOutput`](crate::output::DescribeUserImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_import_job: std::option::Option<crate::model::UserImportJobType>,
    }
    impl Builder {
        /// <p>The job object that represents the user import job.</p>
        pub fn user_import_job(mut self, input: crate::model::UserImportJobType) -> Self {
            self.user_import_job = Some(input);
            self
        }
        /// <p>The job object that represents the user import job.</p>
        pub fn set_user_import_job(
            mut self,
            input: std::option::Option<crate::model::UserImportJobType>,
        ) -> Self {
            self.user_import_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserImportJobOutput`](crate::output::DescribeUserImportJobOutput)
        pub fn build(self) -> crate::output::DescribeUserImportJobOutput {
            crate::output::DescribeUserImportJobOutput {
                user_import_job: self.user_import_job,
            }
        }
    }
}
impl DescribeUserImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserImportJobOutput`](crate::output::DescribeUserImportJobOutput)
    pub fn builder() -> crate::output::describe_user_import_job_output::Builder {
        crate::output::describe_user_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRiskConfigurationOutput {
    /// <p>The risk configuration.</p>
    pub risk_configuration: std::option::Option<crate::model::RiskConfigurationType>,
}
impl DescribeRiskConfigurationOutput {
    /// <p>The risk configuration.</p>
    pub fn risk_configuration(&self) -> std::option::Option<&crate::model::RiskConfigurationType> {
        self.risk_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribeRiskConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRiskConfigurationOutput");
        formatter.field("risk_configuration", &self.risk_configuration);
        formatter.finish()
    }
}
/// See [`DescribeRiskConfigurationOutput`](crate::output::DescribeRiskConfigurationOutput)
pub mod describe_risk_configuration_output {
    /// A builder for [`DescribeRiskConfigurationOutput`](crate::output::DescribeRiskConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) risk_configuration: std::option::Option<crate::model::RiskConfigurationType>,
    }
    impl Builder {
        /// <p>The risk configuration.</p>
        pub fn risk_configuration(mut self, input: crate::model::RiskConfigurationType) -> Self {
            self.risk_configuration = Some(input);
            self
        }
        /// <p>The risk configuration.</p>
        pub fn set_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::RiskConfigurationType>,
        ) -> Self {
            self.risk_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRiskConfigurationOutput`](crate::output::DescribeRiskConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeRiskConfigurationOutput {
            crate::output::DescribeRiskConfigurationOutput {
                risk_configuration: self.risk_configuration,
            }
        }
    }
}
impl DescribeRiskConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRiskConfigurationOutput`](crate::output::DescribeRiskConfigurationOutput)
    pub fn builder() -> crate::output::describe_risk_configuration_output::Builder {
        crate::output::describe_risk_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourceServerOutput {
    /// <p>The resource server.</p>
    pub resource_server: std::option::Option<crate::model::ResourceServerType>,
}
impl DescribeResourceServerOutput {
    /// <p>The resource server.</p>
    pub fn resource_server(&self) -> std::option::Option<&crate::model::ResourceServerType> {
        self.resource_server.as_ref()
    }
}
impl std::fmt::Debug for DescribeResourceServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourceServerOutput");
        formatter.field("resource_server", &self.resource_server);
        formatter.finish()
    }
}
/// See [`DescribeResourceServerOutput`](crate::output::DescribeResourceServerOutput)
pub mod describe_resource_server_output {
    /// A builder for [`DescribeResourceServerOutput`](crate::output::DescribeResourceServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_server: std::option::Option<crate::model::ResourceServerType>,
    }
    impl Builder {
        /// <p>The resource server.</p>
        pub fn resource_server(mut self, input: crate::model::ResourceServerType) -> Self {
            self.resource_server = Some(input);
            self
        }
        /// <p>The resource server.</p>
        pub fn set_resource_server(
            mut self,
            input: std::option::Option<crate::model::ResourceServerType>,
        ) -> Self {
            self.resource_server = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourceServerOutput`](crate::output::DescribeResourceServerOutput)
        pub fn build(self) -> crate::output::DescribeResourceServerOutput {
            crate::output::DescribeResourceServerOutput {
                resource_server: self.resource_server,
            }
        }
    }
}
impl DescribeResourceServerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeResourceServerOutput`](crate::output::DescribeResourceServerOutput)
    pub fn builder() -> crate::output::describe_resource_server_output::Builder {
        crate::output::describe_resource_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityProviderOutput {
    /// <p>The identity provider that was deleted.</p>
    pub identity_provider: std::option::Option<crate::model::IdentityProviderType>,
}
impl DescribeIdentityProviderOutput {
    /// <p>The identity provider that was deleted.</p>
    pub fn identity_provider(&self) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider.as_ref()
    }
}
impl std::fmt::Debug for DescribeIdentityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityProviderOutput");
        formatter.field("identity_provider", &self.identity_provider);
        formatter.finish()
    }
}
/// See [`DescribeIdentityProviderOutput`](crate::output::DescribeIdentityProviderOutput)
pub mod describe_identity_provider_output {
    /// A builder for [`DescribeIdentityProviderOutput`](crate::output::DescribeIdentityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider: std::option::Option<crate::model::IdentityProviderType>,
    }
    impl Builder {
        /// <p>The identity provider that was deleted.</p>
        pub fn identity_provider(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider = Some(input);
            self
        }
        /// <p>The identity provider that was deleted.</p>
        pub fn set_identity_provider(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityProviderOutput`](crate::output::DescribeIdentityProviderOutput)
        pub fn build(self) -> crate::output::DescribeIdentityProviderOutput {
            crate::output::DescribeIdentityProviderOutput {
                identity_provider: self.identity_provider,
            }
        }
    }
}
impl DescribeIdentityProviderOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityProviderOutput`](crate::output::DescribeIdentityProviderOutput)
    pub fn builder() -> crate::output::describe_identity_provider_output::Builder {
        crate::output::describe_identity_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserPoolDomainOutput {}
impl std::fmt::Debug for DeleteUserPoolDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserPoolDomainOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserPoolDomainOutput`](crate::output::DeleteUserPoolDomainOutput)
pub mod delete_user_pool_domain_output {
    /// A builder for [`DeleteUserPoolDomainOutput`](crate::output::DeleteUserPoolDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserPoolDomainOutput`](crate::output::DeleteUserPoolDomainOutput)
        pub fn build(self) -> crate::output::DeleteUserPoolDomainOutput {
            crate::output::DeleteUserPoolDomainOutput {}
        }
    }
}
impl DeleteUserPoolDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolDomainOutput`](crate::output::DeleteUserPoolDomainOutput)
    pub fn builder() -> crate::output::delete_user_pool_domain_output::Builder {
        crate::output::delete_user_pool_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserPoolClientOutput {}
impl std::fmt::Debug for DeleteUserPoolClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserPoolClientOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserPoolClientOutput`](crate::output::DeleteUserPoolClientOutput)
pub mod delete_user_pool_client_output {
    /// A builder for [`DeleteUserPoolClientOutput`](crate::output::DeleteUserPoolClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserPoolClientOutput`](crate::output::DeleteUserPoolClientOutput)
        pub fn build(self) -> crate::output::DeleteUserPoolClientOutput {
            crate::output::DeleteUserPoolClientOutput {}
        }
    }
}
impl DeleteUserPoolClientOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolClientOutput`](crate::output::DeleteUserPoolClientOutput)
    pub fn builder() -> crate::output::delete_user_pool_client_output::Builder {
        crate::output::delete_user_pool_client_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserPoolOutput {}
impl std::fmt::Debug for DeleteUserPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserPoolOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserPoolOutput`](crate::output::DeleteUserPoolOutput)
pub mod delete_user_pool_output {
    /// A builder for [`DeleteUserPoolOutput`](crate::output::DeleteUserPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserPoolOutput`](crate::output::DeleteUserPoolOutput)
        pub fn build(self) -> crate::output::DeleteUserPoolOutput {
            crate::output::DeleteUserPoolOutput {}
        }
    }
}
impl DeleteUserPoolOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolOutput`](crate::output::DeleteUserPoolOutput)
    pub fn builder() -> crate::output::delete_user_pool_output::Builder {
        crate::output::delete_user_pool_output::Builder::default()
    }
}

/// <p>Represents the response from the server to delete user attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserAttributesOutput {}
impl std::fmt::Debug for DeleteUserAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserAttributesOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserAttributesOutput`](crate::output::DeleteUserAttributesOutput)
pub mod delete_user_attributes_output {
    /// A builder for [`DeleteUserAttributesOutput`](crate::output::DeleteUserAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserAttributesOutput`](crate::output::DeleteUserAttributesOutput)
        pub fn build(self) -> crate::output::DeleteUserAttributesOutput {
            crate::output::DeleteUserAttributesOutput {}
        }
    }
}
impl DeleteUserAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserAttributesOutput`](crate::output::DeleteUserAttributesOutput)
    pub fn builder() -> crate::output::delete_user_attributes_output::Builder {
        crate::output::delete_user_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {}
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceServerOutput {}
impl std::fmt::Debug for DeleteResourceServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceServerOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourceServerOutput`](crate::output::DeleteResourceServerOutput)
pub mod delete_resource_server_output {
    /// A builder for [`DeleteResourceServerOutput`](crate::output::DeleteResourceServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourceServerOutput`](crate::output::DeleteResourceServerOutput)
        pub fn build(self) -> crate::output::DeleteResourceServerOutput {
            crate::output::DeleteResourceServerOutput {}
        }
    }
}
impl DeleteResourceServerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourceServerOutput`](crate::output::DeleteResourceServerOutput)
    pub fn builder() -> crate::output::delete_resource_server_output::Builder {
        crate::output::delete_resource_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityProviderOutput {}
impl std::fmt::Debug for DeleteIdentityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityProviderOutput");
        formatter.finish()
    }
}
/// See [`DeleteIdentityProviderOutput`](crate::output::DeleteIdentityProviderOutput)
pub mod delete_identity_provider_output {
    /// A builder for [`DeleteIdentityProviderOutput`](crate::output::DeleteIdentityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIdentityProviderOutput`](crate::output::DeleteIdentityProviderOutput)
        pub fn build(self) -> crate::output::DeleteIdentityProviderOutput {
            crate::output::DeleteIdentityProviderOutput {}
        }
    }
}
impl DeleteIdentityProviderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityProviderOutput`](crate::output::DeleteIdentityProviderOutput)
    pub fn builder() -> crate::output::delete_identity_provider_output::Builder {
        crate::output::delete_identity_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupOutput {}
impl std::fmt::Debug for DeleteGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
pub mod delete_group_output {
    /// A builder for [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
        pub fn build(self) -> crate::output::DeleteGroupOutput {
            crate::output::DeleteGroupOutput {}
        }
    }
}
impl DeleteGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    pub fn builder() -> crate::output::delete_group_output::Builder {
        crate::output::delete_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserPoolDomainOutput {
    /// <p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.</p>
    pub cloud_front_domain: std::option::Option<std::string::String>,
}
impl CreateUserPoolDomainOutput {
    /// <p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.</p>
    pub fn cloud_front_domain(&self) -> std::option::Option<&str> {
        self.cloud_front_domain.as_deref()
    }
}
impl std::fmt::Debug for CreateUserPoolDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserPoolDomainOutput");
        formatter.field("cloud_front_domain", &self.cloud_front_domain);
        formatter.finish()
    }
}
/// See [`CreateUserPoolDomainOutput`](crate::output::CreateUserPoolDomainOutput)
pub mod create_user_pool_domain_output {
    /// A builder for [`CreateUserPoolDomainOutput`](crate::output::CreateUserPoolDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.</p>
        pub fn cloud_front_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_front_domain = Some(input.into());
            self
        }
        /// <p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.</p>
        pub fn set_cloud_front_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_front_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserPoolDomainOutput`](crate::output::CreateUserPoolDomainOutput)
        pub fn build(self) -> crate::output::CreateUserPoolDomainOutput {
            crate::output::CreateUserPoolDomainOutput {
                cloud_front_domain: self.cloud_front_domain,
            }
        }
    }
}
impl CreateUserPoolDomainOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserPoolDomainOutput`](crate::output::CreateUserPoolDomainOutput)
    pub fn builder() -> crate::output::create_user_pool_domain_output::Builder {
        crate::output::create_user_pool_domain_output::Builder::default()
    }
}

/// <p>Represents the response from the server to create a user pool client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserPoolClientOutput {
    /// <p>The user pool client that was just created.</p>
    pub user_pool_client: std::option::Option<crate::model::UserPoolClientType>,
}
impl CreateUserPoolClientOutput {
    /// <p>The user pool client that was just created.</p>
    pub fn user_pool_client(&self) -> std::option::Option<&crate::model::UserPoolClientType> {
        self.user_pool_client.as_ref()
    }
}
impl std::fmt::Debug for CreateUserPoolClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserPoolClientOutput");
        formatter.field("user_pool_client", &self.user_pool_client);
        formatter.finish()
    }
}
/// See [`CreateUserPoolClientOutput`](crate::output::CreateUserPoolClientOutput)
pub mod create_user_pool_client_output {
    /// A builder for [`CreateUserPoolClientOutput`](crate::output::CreateUserPoolClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_client: std::option::Option<crate::model::UserPoolClientType>,
    }
    impl Builder {
        /// <p>The user pool client that was just created.</p>
        pub fn user_pool_client(mut self, input: crate::model::UserPoolClientType) -> Self {
            self.user_pool_client = Some(input);
            self
        }
        /// <p>The user pool client that was just created.</p>
        pub fn set_user_pool_client(
            mut self,
            input: std::option::Option<crate::model::UserPoolClientType>,
        ) -> Self {
            self.user_pool_client = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserPoolClientOutput`](crate::output::CreateUserPoolClientOutput)
        pub fn build(self) -> crate::output::CreateUserPoolClientOutput {
            crate::output::CreateUserPoolClientOutput {
                user_pool_client: self.user_pool_client,
            }
        }
    }
}
impl CreateUserPoolClientOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserPoolClientOutput`](crate::output::CreateUserPoolClientOutput)
    pub fn builder() -> crate::output::create_user_pool_client_output::Builder {
        crate::output::create_user_pool_client_output::Builder::default()
    }
}

/// <p>Represents the response from the server for the request to create a user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserPoolOutput {
    /// <p>A container for the user pool details.</p>
    pub user_pool: std::option::Option<crate::model::UserPoolType>,
}
impl CreateUserPoolOutput {
    /// <p>A container for the user pool details.</p>
    pub fn user_pool(&self) -> std::option::Option<&crate::model::UserPoolType> {
        self.user_pool.as_ref()
    }
}
impl std::fmt::Debug for CreateUserPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserPoolOutput");
        formatter.field("user_pool", &self.user_pool);
        formatter.finish()
    }
}
/// See [`CreateUserPoolOutput`](crate::output::CreateUserPoolOutput)
pub mod create_user_pool_output {
    /// A builder for [`CreateUserPoolOutput`](crate::output::CreateUserPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool: std::option::Option<crate::model::UserPoolType>,
    }
    impl Builder {
        /// <p>A container for the user pool details.</p>
        pub fn user_pool(mut self, input: crate::model::UserPoolType) -> Self {
            self.user_pool = Some(input);
            self
        }
        /// <p>A container for the user pool details.</p>
        pub fn set_user_pool(
            mut self,
            input: std::option::Option<crate::model::UserPoolType>,
        ) -> Self {
            self.user_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserPoolOutput`](crate::output::CreateUserPoolOutput)
        pub fn build(self) -> crate::output::CreateUserPoolOutput {
            crate::output::CreateUserPoolOutput {
                user_pool: self.user_pool,
            }
        }
    }
}
impl CreateUserPoolOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserPoolOutput`](crate::output::CreateUserPoolOutput)
    pub fn builder() -> crate::output::create_user_pool_output::Builder {
        crate::output::create_user_pool_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to create the user import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub user_import_job: std::option::Option<crate::model::UserImportJobType>,
}
impl CreateUserImportJobOutput {
    /// <p>The job object that represents the user import job.</p>
    pub fn user_import_job(&self) -> std::option::Option<&crate::model::UserImportJobType> {
        self.user_import_job.as_ref()
    }
}
impl std::fmt::Debug for CreateUserImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserImportJobOutput");
        formatter.field("user_import_job", &self.user_import_job);
        formatter.finish()
    }
}
/// See [`CreateUserImportJobOutput`](crate::output::CreateUserImportJobOutput)
pub mod create_user_import_job_output {
    /// A builder for [`CreateUserImportJobOutput`](crate::output::CreateUserImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_import_job: std::option::Option<crate::model::UserImportJobType>,
    }
    impl Builder {
        /// <p>The job object that represents the user import job.</p>
        pub fn user_import_job(mut self, input: crate::model::UserImportJobType) -> Self {
            self.user_import_job = Some(input);
            self
        }
        /// <p>The job object that represents the user import job.</p>
        pub fn set_user_import_job(
            mut self,
            input: std::option::Option<crate::model::UserImportJobType>,
        ) -> Self {
            self.user_import_job = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserImportJobOutput`](crate::output::CreateUserImportJobOutput)
        pub fn build(self) -> crate::output::CreateUserImportJobOutput {
            crate::output::CreateUserImportJobOutput {
                user_import_job: self.user_import_job,
            }
        }
    }
}
impl CreateUserImportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserImportJobOutput`](crate::output::CreateUserImportJobOutput)
    pub fn builder() -> crate::output::create_user_import_job_output::Builder {
        crate::output::create_user_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceServerOutput {
    /// <p>The newly created resource server.</p>
    pub resource_server: std::option::Option<crate::model::ResourceServerType>,
}
impl CreateResourceServerOutput {
    /// <p>The newly created resource server.</p>
    pub fn resource_server(&self) -> std::option::Option<&crate::model::ResourceServerType> {
        self.resource_server.as_ref()
    }
}
impl std::fmt::Debug for CreateResourceServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceServerOutput");
        formatter.field("resource_server", &self.resource_server);
        formatter.finish()
    }
}
/// See [`CreateResourceServerOutput`](crate::output::CreateResourceServerOutput)
pub mod create_resource_server_output {
    /// A builder for [`CreateResourceServerOutput`](crate::output::CreateResourceServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_server: std::option::Option<crate::model::ResourceServerType>,
    }
    impl Builder {
        /// <p>The newly created resource server.</p>
        pub fn resource_server(mut self, input: crate::model::ResourceServerType) -> Self {
            self.resource_server = Some(input);
            self
        }
        /// <p>The newly created resource server.</p>
        pub fn set_resource_server(
            mut self,
            input: std::option::Option<crate::model::ResourceServerType>,
        ) -> Self {
            self.resource_server = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceServerOutput`](crate::output::CreateResourceServerOutput)
        pub fn build(self) -> crate::output::CreateResourceServerOutput {
            crate::output::CreateResourceServerOutput {
                resource_server: self.resource_server,
            }
        }
    }
}
impl CreateResourceServerOutput {
    /// Creates a new builder-style object to manufacture [`CreateResourceServerOutput`](crate::output::CreateResourceServerOutput)
    pub fn builder() -> crate::output::create_resource_server_output::Builder {
        crate::output::create_resource_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIdentityProviderOutput {
    /// <p>The newly created identity provider object.</p>
    pub identity_provider: std::option::Option<crate::model::IdentityProviderType>,
}
impl CreateIdentityProviderOutput {
    /// <p>The newly created identity provider object.</p>
    pub fn identity_provider(&self) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider.as_ref()
    }
}
impl std::fmt::Debug for CreateIdentityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIdentityProviderOutput");
        formatter.field("identity_provider", &self.identity_provider);
        formatter.finish()
    }
}
/// See [`CreateIdentityProviderOutput`](crate::output::CreateIdentityProviderOutput)
pub mod create_identity_provider_output {
    /// A builder for [`CreateIdentityProviderOutput`](crate::output::CreateIdentityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider: std::option::Option<crate::model::IdentityProviderType>,
    }
    impl Builder {
        /// <p>The newly created identity provider object.</p>
        pub fn identity_provider(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider = Some(input);
            self
        }
        /// <p>The newly created identity provider object.</p>
        pub fn set_identity_provider(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIdentityProviderOutput`](crate::output::CreateIdentityProviderOutput)
        pub fn build(self) -> crate::output::CreateIdentityProviderOutput {
            crate::output::CreateIdentityProviderOutput {
                identity_provider: self.identity_provider,
            }
        }
    }
}
impl CreateIdentityProviderOutput {
    /// Creates a new builder-style object to manufacture [`CreateIdentityProviderOutput`](crate::output::CreateIdentityProviderOutput)
    pub fn builder() -> crate::output::create_identity_provider_output::Builder {
        crate::output::create_identity_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupOutput {
    /// <p>The group object for the group.</p>
    pub group: std::option::Option<crate::model::GroupType>,
}
impl CreateGroupOutput {
    /// <p>The group object for the group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::GroupType> {
        self.group.as_ref()
    }
}
impl std::fmt::Debug for CreateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`CreateGroupOutput`](crate::output::CreateGroupOutput)
pub mod create_group_output {
    /// A builder for [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::GroupType>,
    }
    impl Builder {
        /// <p>The group object for the group.</p>
        pub fn group(mut self, input: crate::model::GroupType) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The group object for the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::GroupType>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupOutput`](crate::output::CreateGroupOutput)
        pub fn build(self) -> crate::output::CreateGroupOutput {
            crate::output::CreateGroupOutput { group: self.group }
        }
    }
}
impl CreateGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    pub fn builder() -> crate::output::create_group_output::Builder {
        crate::output::create_group_output::Builder::default()
    }
}

/// <p>Represents the response from the server for the registration confirmation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmSignUpOutput {}
impl std::fmt::Debug for ConfirmSignUpOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmSignUpOutput");
        formatter.finish()
    }
}
/// See [`ConfirmSignUpOutput`](crate::output::ConfirmSignUpOutput)
pub mod confirm_sign_up_output {
    /// A builder for [`ConfirmSignUpOutput`](crate::output::ConfirmSignUpOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ConfirmSignUpOutput`](crate::output::ConfirmSignUpOutput)
        pub fn build(self) -> crate::output::ConfirmSignUpOutput {
            crate::output::ConfirmSignUpOutput {}
        }
    }
}
impl ConfirmSignUpOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmSignUpOutput`](crate::output::ConfirmSignUpOutput)
    pub fn builder() -> crate::output::confirm_sign_up_output::Builder {
        crate::output::confirm_sign_up_output::Builder::default()
    }
}

/// <p>The response from the server that results from a user's request to retrieve a forgotten password.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmForgotPasswordOutput {}
impl std::fmt::Debug for ConfirmForgotPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmForgotPasswordOutput");
        formatter.finish()
    }
}
/// See [`ConfirmForgotPasswordOutput`](crate::output::ConfirmForgotPasswordOutput)
pub mod confirm_forgot_password_output {
    /// A builder for [`ConfirmForgotPasswordOutput`](crate::output::ConfirmForgotPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ConfirmForgotPasswordOutput`](crate::output::ConfirmForgotPasswordOutput)
        pub fn build(self) -> crate::output::ConfirmForgotPasswordOutput {
            crate::output::ConfirmForgotPasswordOutput {}
        }
    }
}
impl ConfirmForgotPasswordOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmForgotPasswordOutput`](crate::output::ConfirmForgotPasswordOutput)
    pub fn builder() -> crate::output::confirm_forgot_password_output::Builder {
        crate::output::confirm_forgot_password_output::Builder::default()
    }
}

/// <p>Confirms the device response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmDeviceOutput {
    /// <p>Indicates whether the user confirmation must confirm the device response.</p>
    pub user_confirmation_necessary: bool,
}
impl ConfirmDeviceOutput {
    /// <p>Indicates whether the user confirmation must confirm the device response.</p>
    pub fn user_confirmation_necessary(&self) -> bool {
        self.user_confirmation_necessary
    }
}
impl std::fmt::Debug for ConfirmDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmDeviceOutput");
        formatter.field(
            "user_confirmation_necessary",
            &self.user_confirmation_necessary,
        );
        formatter.finish()
    }
}
/// See [`ConfirmDeviceOutput`](crate::output::ConfirmDeviceOutput)
pub mod confirm_device_output {
    /// A builder for [`ConfirmDeviceOutput`](crate::output::ConfirmDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_confirmation_necessary: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the user confirmation must confirm the device response.</p>
        pub fn user_confirmation_necessary(mut self, input: bool) -> Self {
            self.user_confirmation_necessary = Some(input);
            self
        }
        /// <p>Indicates whether the user confirmation must confirm the device response.</p>
        pub fn set_user_confirmation_necessary(mut self, input: std::option::Option<bool>) -> Self {
            self.user_confirmation_necessary = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmDeviceOutput`](crate::output::ConfirmDeviceOutput)
        pub fn build(self) -> crate::output::ConfirmDeviceOutput {
            crate::output::ConfirmDeviceOutput {
                user_confirmation_necessary: self.user_confirmation_necessary.unwrap_or_default(),
            }
        }
    }
}
impl ConfirmDeviceOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmDeviceOutput`](crate::output::ConfirmDeviceOutput)
    pub fn builder() -> crate::output::confirm_device_output::Builder {
        crate::output::confirm_device_output::Builder::default()
    }
}

/// <p>The response from the server to the change password request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangePasswordOutput {}
impl std::fmt::Debug for ChangePasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangePasswordOutput");
        formatter.finish()
    }
}
/// See [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
pub mod change_password_output {
    /// A builder for [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
        pub fn build(self) -> crate::output::ChangePasswordOutput {
            crate::output::ChangePasswordOutput {}
        }
    }
}
impl ChangePasswordOutput {
    /// Creates a new builder-style object to manufacture [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
    pub fn builder() -> crate::output::change_password_output::Builder {
        crate::output::change_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateSoftwareTokenOutput {
    /// <p>A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm to generate a one-time code.</p>
    pub secret_code: std::option::Option<std::string::String>,
    /// <p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
    pub session: std::option::Option<std::string::String>,
}
impl AssociateSoftwareTokenOutput {
    /// <p>A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm to generate a one-time code.</p>
    pub fn secret_code(&self) -> std::option::Option<&str> {
        self.secret_code.as_deref()
    }
    /// <p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
    pub fn session(&self) -> std::option::Option<&str> {
        self.session.as_deref()
    }
}
impl std::fmt::Debug for AssociateSoftwareTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateSoftwareTokenOutput");
        formatter.field("secret_code", &"*** Sensitive Data Redacted ***");
        formatter.field("session", &self.session);
        formatter.finish()
    }
}
/// See [`AssociateSoftwareTokenOutput`](crate::output::AssociateSoftwareTokenOutput)
pub mod associate_software_token_output {
    /// A builder for [`AssociateSoftwareTokenOutput`](crate::output::AssociateSoftwareTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_code: std::option::Option<std::string::String>,
        pub(crate) session: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm to generate a one-time code.</p>
        pub fn secret_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_code = Some(input.into());
            self
        }
        /// <p>A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm to generate a one-time code.</p>
        pub fn set_secret_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_code = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSoftwareTokenOutput`](crate::output::AssociateSoftwareTokenOutput)
        pub fn build(self) -> crate::output::AssociateSoftwareTokenOutput {
            crate::output::AssociateSoftwareTokenOutput {
                secret_code: self.secret_code,
                session: self.session,
            }
        }
    }
}
impl AssociateSoftwareTokenOutput {
    /// Creates a new builder-style object to manufacture [`AssociateSoftwareTokenOutput`](crate::output::AssociateSoftwareTokenOutput)
    pub fn builder() -> crate::output::associate_software_token_output::Builder {
        crate::output::associate_software_token_output::Builder::default()
    }
}

/// <p>The global sign-out response, as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminUserGlobalSignOutOutput {}
impl std::fmt::Debug for AdminUserGlobalSignOutOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminUserGlobalSignOutOutput");
        formatter.finish()
    }
}
/// See [`AdminUserGlobalSignOutOutput`](crate::output::AdminUserGlobalSignOutOutput)
pub mod admin_user_global_sign_out_output {
    /// A builder for [`AdminUserGlobalSignOutOutput`](crate::output::AdminUserGlobalSignOutOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminUserGlobalSignOutOutput`](crate::output::AdminUserGlobalSignOutOutput)
        pub fn build(self) -> crate::output::AdminUserGlobalSignOutOutput {
            crate::output::AdminUserGlobalSignOutOutput {}
        }
    }
}
impl AdminUserGlobalSignOutOutput {
    /// Creates a new builder-style object to manufacture [`AdminUserGlobalSignOutOutput`](crate::output::AdminUserGlobalSignOutOutput)
    pub fn builder() -> crate::output::admin_user_global_sign_out_output::Builder {
        crate::output::admin_user_global_sign_out_output::Builder::default()
    }
}

/// <p>Represents the response from the server for the request to update user attributes as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminUpdateUserAttributesOutput {}
impl std::fmt::Debug for AdminUpdateUserAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminUpdateUserAttributesOutput");
        formatter.finish()
    }
}
/// See [`AdminUpdateUserAttributesOutput`](crate::output::AdminUpdateUserAttributesOutput)
pub mod admin_update_user_attributes_output {
    /// A builder for [`AdminUpdateUserAttributesOutput`](crate::output::AdminUpdateUserAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminUpdateUserAttributesOutput`](crate::output::AdminUpdateUserAttributesOutput)
        pub fn build(self) -> crate::output::AdminUpdateUserAttributesOutput {
            crate::output::AdminUpdateUserAttributesOutput {}
        }
    }
}
impl AdminUpdateUserAttributesOutput {
    /// Creates a new builder-style object to manufacture [`AdminUpdateUserAttributesOutput`](crate::output::AdminUpdateUserAttributesOutput)
    pub fn builder() -> crate::output::admin_update_user_attributes_output::Builder {
        crate::output::admin_update_user_attributes_output::Builder::default()
    }
}

/// <p>The status response to the request to update the device, as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminUpdateDeviceStatusOutput {}
impl std::fmt::Debug for AdminUpdateDeviceStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminUpdateDeviceStatusOutput");
        formatter.finish()
    }
}
/// See [`AdminUpdateDeviceStatusOutput`](crate::output::AdminUpdateDeviceStatusOutput)
pub mod admin_update_device_status_output {
    /// A builder for [`AdminUpdateDeviceStatusOutput`](crate::output::AdminUpdateDeviceStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminUpdateDeviceStatusOutput`](crate::output::AdminUpdateDeviceStatusOutput)
        pub fn build(self) -> crate::output::AdminUpdateDeviceStatusOutput {
            crate::output::AdminUpdateDeviceStatusOutput {}
        }
    }
}
impl AdminUpdateDeviceStatusOutput {
    /// Creates a new builder-style object to manufacture [`AdminUpdateDeviceStatusOutput`](crate::output::AdminUpdateDeviceStatusOutput)
    pub fn builder() -> crate::output::admin_update_device_status_output::Builder {
        crate::output::admin_update_device_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminUpdateAuthEventFeedbackOutput {}
impl std::fmt::Debug for AdminUpdateAuthEventFeedbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminUpdateAuthEventFeedbackOutput");
        formatter.finish()
    }
}
/// See [`AdminUpdateAuthEventFeedbackOutput`](crate::output::AdminUpdateAuthEventFeedbackOutput)
pub mod admin_update_auth_event_feedback_output {
    /// A builder for [`AdminUpdateAuthEventFeedbackOutput`](crate::output::AdminUpdateAuthEventFeedbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminUpdateAuthEventFeedbackOutput`](crate::output::AdminUpdateAuthEventFeedbackOutput)
        pub fn build(self) -> crate::output::AdminUpdateAuthEventFeedbackOutput {
            crate::output::AdminUpdateAuthEventFeedbackOutput {}
        }
    }
}
impl AdminUpdateAuthEventFeedbackOutput {
    /// Creates a new builder-style object to manufacture [`AdminUpdateAuthEventFeedbackOutput`](crate::output::AdminUpdateAuthEventFeedbackOutput)
    pub fn builder() -> crate::output::admin_update_auth_event_feedback_output::Builder {
        crate::output::admin_update_auth_event_feedback_output::Builder::default()
    }
}

/// <p>Represents the response from the server to set user settings as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminSetUserSettingsOutput {}
impl std::fmt::Debug for AdminSetUserSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminSetUserSettingsOutput");
        formatter.finish()
    }
}
/// See [`AdminSetUserSettingsOutput`](crate::output::AdminSetUserSettingsOutput)
pub mod admin_set_user_settings_output {
    /// A builder for [`AdminSetUserSettingsOutput`](crate::output::AdminSetUserSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminSetUserSettingsOutput`](crate::output::AdminSetUserSettingsOutput)
        pub fn build(self) -> crate::output::AdminSetUserSettingsOutput {
            crate::output::AdminSetUserSettingsOutput {}
        }
    }
}
impl AdminSetUserSettingsOutput {
    /// Creates a new builder-style object to manufacture [`AdminSetUserSettingsOutput`](crate::output::AdminSetUserSettingsOutput)
    pub fn builder() -> crate::output::admin_set_user_settings_output::Builder {
        crate::output::admin_set_user_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminSetUserPasswordOutput {}
impl std::fmt::Debug for AdminSetUserPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminSetUserPasswordOutput");
        formatter.finish()
    }
}
/// See [`AdminSetUserPasswordOutput`](crate::output::AdminSetUserPasswordOutput)
pub mod admin_set_user_password_output {
    /// A builder for [`AdminSetUserPasswordOutput`](crate::output::AdminSetUserPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminSetUserPasswordOutput`](crate::output::AdminSetUserPasswordOutput)
        pub fn build(self) -> crate::output::AdminSetUserPasswordOutput {
            crate::output::AdminSetUserPasswordOutput {}
        }
    }
}
impl AdminSetUserPasswordOutput {
    /// Creates a new builder-style object to manufacture [`AdminSetUserPasswordOutput`](crate::output::AdminSetUserPasswordOutput)
    pub fn builder() -> crate::output::admin_set_user_password_output::Builder {
        crate::output::admin_set_user_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminSetUserMfaPreferenceOutput {}
impl std::fmt::Debug for AdminSetUserMfaPreferenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminSetUserMfaPreferenceOutput");
        formatter.finish()
    }
}
/// See [`AdminSetUserMfaPreferenceOutput`](crate::output::AdminSetUserMfaPreferenceOutput)
pub mod admin_set_user_mfa_preference_output {
    /// A builder for [`AdminSetUserMfaPreferenceOutput`](crate::output::AdminSetUserMfaPreferenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminSetUserMfaPreferenceOutput`](crate::output::AdminSetUserMfaPreferenceOutput)
        pub fn build(self) -> crate::output::AdminSetUserMfaPreferenceOutput {
            crate::output::AdminSetUserMfaPreferenceOutput {}
        }
    }
}
impl AdminSetUserMfaPreferenceOutput {
    /// Creates a new builder-style object to manufacture [`AdminSetUserMfaPreferenceOutput`](crate::output::AdminSetUserMfaPreferenceOutput)
    pub fn builder() -> crate::output::admin_set_user_mfa_preference_output::Builder {
        crate::output::admin_set_user_mfa_preference_output::Builder::default()
    }
}

/// <p>Responds to the authentication challenge, as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminRespondToAuthChallengeOutput {
    /// <p>The name of the challenge. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
    pub challenge_name: std::option::Option<crate::model::ChallengeNameType>,
    /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    pub session: std::option::Option<std::string::String>,
    /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
    pub challenge_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The result returned by the server in response to the authentication request.</p>
    pub authentication_result: std::option::Option<crate::model::AuthenticationResultType>,
}
impl AdminRespondToAuthChallengeOutput {
    /// <p>The name of the challenge. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
    pub fn challenge_name(&self) -> std::option::Option<&crate::model::ChallengeNameType> {
        self.challenge_name.as_ref()
    }
    /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
    pub fn session(&self) -> std::option::Option<&str> {
        self.session.as_deref()
    }
    /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
    pub fn challenge_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.challenge_parameters.as_ref()
    }
    /// <p>The result returned by the server in response to the authentication request.</p>
    pub fn authentication_result(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationResultType> {
        self.authentication_result.as_ref()
    }
}
impl std::fmt::Debug for AdminRespondToAuthChallengeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminRespondToAuthChallengeOutput");
        formatter.field("challenge_name", &self.challenge_name);
        formatter.field("session", &self.session);
        formatter.field("challenge_parameters", &self.challenge_parameters);
        formatter.field("authentication_result", &self.authentication_result);
        formatter.finish()
    }
}
/// See [`AdminRespondToAuthChallengeOutput`](crate::output::AdminRespondToAuthChallengeOutput)
pub mod admin_respond_to_auth_challenge_output {
    /// A builder for [`AdminRespondToAuthChallengeOutput`](crate::output::AdminRespondToAuthChallengeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) challenge_name: std::option::Option<crate::model::ChallengeNameType>,
        pub(crate) session: std::option::Option<std::string::String>,
        pub(crate) challenge_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) authentication_result:
            std::option::Option<crate::model::AuthenticationResultType>,
    }
    impl Builder {
        /// <p>The name of the challenge. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.challenge_name = Some(input);
            self
        }
        /// <p>The name of the challenge. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.challenge_name = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Adds a key-value pair to `challenge_parameters`.
        ///
        /// To override the contents of this collection use [`set_challenge_parameters`](Self::set_challenge_parameters).
        ///
        /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn challenge_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.challenge_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.challenge_parameters = Some(hash_map);
            self
        }
        /// <p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn set_challenge_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.challenge_parameters = input;
            self
        }
        /// <p>The result returned by the server in response to the authentication request.</p>
        pub fn authentication_result(
            mut self,
            input: crate::model::AuthenticationResultType,
        ) -> Self {
            self.authentication_result = Some(input);
            self
        }
        /// <p>The result returned by the server in response to the authentication request.</p>
        pub fn set_authentication_result(
            mut self,
            input: std::option::Option<crate::model::AuthenticationResultType>,
        ) -> Self {
            self.authentication_result = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminRespondToAuthChallengeOutput`](crate::output::AdminRespondToAuthChallengeOutput)
        pub fn build(self) -> crate::output::AdminRespondToAuthChallengeOutput {
            crate::output::AdminRespondToAuthChallengeOutput {
                challenge_name: self.challenge_name,
                session: self.session,
                challenge_parameters: self.challenge_parameters,
                authentication_result: self.authentication_result,
            }
        }
    }
}
impl AdminRespondToAuthChallengeOutput {
    /// Creates a new builder-style object to manufacture [`AdminRespondToAuthChallengeOutput`](crate::output::AdminRespondToAuthChallengeOutput)
    pub fn builder() -> crate::output::admin_respond_to_auth_challenge_output::Builder {
        crate::output::admin_respond_to_auth_challenge_output::Builder::default()
    }
}

/// <p>Represents the response from the server to reset a user password as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminResetUserPasswordOutput {}
impl std::fmt::Debug for AdminResetUserPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminResetUserPasswordOutput");
        formatter.finish()
    }
}
/// See [`AdminResetUserPasswordOutput`](crate::output::AdminResetUserPasswordOutput)
pub mod admin_reset_user_password_output {
    /// A builder for [`AdminResetUserPasswordOutput`](crate::output::AdminResetUserPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminResetUserPasswordOutput`](crate::output::AdminResetUserPasswordOutput)
        pub fn build(self) -> crate::output::AdminResetUserPasswordOutput {
            crate::output::AdminResetUserPasswordOutput {}
        }
    }
}
impl AdminResetUserPasswordOutput {
    /// Creates a new builder-style object to manufacture [`AdminResetUserPasswordOutput`](crate::output::AdminResetUserPasswordOutput)
    pub fn builder() -> crate::output::admin_reset_user_password_output::Builder {
        crate::output::admin_reset_user_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminRemoveUserFromGroupOutput {}
impl std::fmt::Debug for AdminRemoveUserFromGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminRemoveUserFromGroupOutput");
        formatter.finish()
    }
}
/// See [`AdminRemoveUserFromGroupOutput`](crate::output::AdminRemoveUserFromGroupOutput)
pub mod admin_remove_user_from_group_output {
    /// A builder for [`AdminRemoveUserFromGroupOutput`](crate::output::AdminRemoveUserFromGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminRemoveUserFromGroupOutput`](crate::output::AdminRemoveUserFromGroupOutput)
        pub fn build(self) -> crate::output::AdminRemoveUserFromGroupOutput {
            crate::output::AdminRemoveUserFromGroupOutput {}
        }
    }
}
impl AdminRemoveUserFromGroupOutput {
    /// Creates a new builder-style object to manufacture [`AdminRemoveUserFromGroupOutput`](crate::output::AdminRemoveUserFromGroupOutput)
    pub fn builder() -> crate::output::admin_remove_user_from_group_output::Builder {
        crate::output::admin_remove_user_from_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminListUserAuthEventsOutput {
    /// <p>The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.</p>
    pub auth_events: std::option::Option<std::vec::Vec<crate::model::AuthEventType>>,
    /// <p>A pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl AdminListUserAuthEventsOutput {
    /// <p>The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.</p>
    pub fn auth_events(&self) -> std::option::Option<&[crate::model::AuthEventType]> {
        self.auth_events.as_deref()
    }
    /// <p>A pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for AdminListUserAuthEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminListUserAuthEventsOutput");
        formatter.field("auth_events", &self.auth_events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`AdminListUserAuthEventsOutput`](crate::output::AdminListUserAuthEventsOutput)
pub mod admin_list_user_auth_events_output {
    /// A builder for [`AdminListUserAuthEventsOutput`](crate::output::AdminListUserAuthEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_events: std::option::Option<std::vec::Vec<crate::model::AuthEventType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `auth_events`.
        ///
        /// To override the contents of this collection use [`set_auth_events`](Self::set_auth_events).
        ///
        /// <p>The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.</p>
        pub fn auth_events(mut self, input: crate::model::AuthEventType) -> Self {
            let mut v = self.auth_events.unwrap_or_default();
            v.push(input);
            self.auth_events = Some(v);
            self
        }
        /// <p>The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.</p>
        pub fn set_auth_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthEventType>>,
        ) -> Self {
            self.auth_events = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminListUserAuthEventsOutput`](crate::output::AdminListUserAuthEventsOutput)
        pub fn build(self) -> crate::output::AdminListUserAuthEventsOutput {
            crate::output::AdminListUserAuthEventsOutput {
                auth_events: self.auth_events,
                next_token: self.next_token,
            }
        }
    }
}
impl AdminListUserAuthEventsOutput {
    /// Creates a new builder-style object to manufacture [`AdminListUserAuthEventsOutput`](crate::output::AdminListUserAuthEventsOutput)
    pub fn builder() -> crate::output::admin_list_user_auth_events_output::Builder {
        crate::output::admin_list_user_auth_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminListGroupsForUserOutput {
    /// <p>The groups that the user belongs to.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::GroupType>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl AdminListGroupsForUserOutput {
    /// <p>The groups that the user belongs to.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::GroupType]> {
        self.groups.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for AdminListGroupsForUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminListGroupsForUserOutput");
        formatter.field("groups", &self.groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`AdminListGroupsForUserOutput`](crate::output::AdminListGroupsForUserOutput)
pub mod admin_list_groups_for_user_output {
    /// A builder for [`AdminListGroupsForUserOutput`](crate::output::AdminListGroupsForUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::GroupType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The groups that the user belongs to.</p>
        pub fn groups(mut self, input: crate::model::GroupType) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>The groups that the user belongs to.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupType>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminListGroupsForUserOutput`](crate::output::AdminListGroupsForUserOutput)
        pub fn build(self) -> crate::output::AdminListGroupsForUserOutput {
            crate::output::AdminListGroupsForUserOutput {
                groups: self.groups,
                next_token: self.next_token,
            }
        }
    }
}
impl AdminListGroupsForUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminListGroupsForUserOutput`](crate::output::AdminListGroupsForUserOutput)
    pub fn builder() -> crate::output::admin_list_groups_for_user_output::Builder {
        crate::output::admin_list_groups_for_user_output::Builder::default()
    }
}

/// <p>Lists the device's response, as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminListDevicesOutput {
    /// <p>The devices in the list of devices response.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::DeviceType>>,
    /// <p>The pagination token.</p>
    pub pagination_token: std::option::Option<std::string::String>,
}
impl AdminListDevicesOutput {
    /// <p>The devices in the list of devices response.</p>
    pub fn devices(&self) -> std::option::Option<&[crate::model::DeviceType]> {
        self.devices.as_deref()
    }
    /// <p>The pagination token.</p>
    pub fn pagination_token(&self) -> std::option::Option<&str> {
        self.pagination_token.as_deref()
    }
}
impl std::fmt::Debug for AdminListDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminListDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("pagination_token", &self.pagination_token);
        formatter.finish()
    }
}
/// See [`AdminListDevicesOutput`](crate::output::AdminListDevicesOutput)
pub mod admin_list_devices_output {
    /// A builder for [`AdminListDevicesOutput`](crate::output::AdminListDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::DeviceType>>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>The devices in the list of devices response.</p>
        pub fn devices(mut self, input: crate::model::DeviceType) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input);
            self.devices = Some(v);
            self
        }
        /// <p>The devices in the list of devices response.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceType>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminListDevicesOutput`](crate::output::AdminListDevicesOutput)
        pub fn build(self) -> crate::output::AdminListDevicesOutput {
            crate::output::AdminListDevicesOutput {
                devices: self.devices,
                pagination_token: self.pagination_token,
            }
        }
    }
}
impl AdminListDevicesOutput {
    /// Creates a new builder-style object to manufacture [`AdminListDevicesOutput`](crate::output::AdminListDevicesOutput)
    pub fn builder() -> crate::output::admin_list_devices_output::Builder {
        crate::output::admin_list_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminLinkProviderForUserOutput {}
impl std::fmt::Debug for AdminLinkProviderForUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminLinkProviderForUserOutput");
        formatter.finish()
    }
}
/// See [`AdminLinkProviderForUserOutput`](crate::output::AdminLinkProviderForUserOutput)
pub mod admin_link_provider_for_user_output {
    /// A builder for [`AdminLinkProviderForUserOutput`](crate::output::AdminLinkProviderForUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminLinkProviderForUserOutput`](crate::output::AdminLinkProviderForUserOutput)
        pub fn build(self) -> crate::output::AdminLinkProviderForUserOutput {
            crate::output::AdminLinkProviderForUserOutput {}
        }
    }
}
impl AdminLinkProviderForUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminLinkProviderForUserOutput`](crate::output::AdminLinkProviderForUserOutput)
    pub fn builder() -> crate::output::admin_link_provider_for_user_output::Builder {
        crate::output::admin_link_provider_for_user_output::Builder::default()
    }
}

/// <p>Initiates the authentication response, as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminInitiateAuthOutput {
    /// <p>The name of the challenge that you're responding to with this call. This is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
    /// <ul>
    /// <li> <p> <code>MFA_SETUP</code>: If MFA is required, users who don't have at least one of the MFA methods set up are presented with an <code>MFA_SETUP</code> challenge. The user must set up at least one MFA type to continue to authenticate.</p> </li>
    /// <li> <p> <code>SELECT_MFA_TYPE</code>: Selects the MFA type. Valid MFA options are <code>SMS_MFA</code> for text SMS MFA, and <code>SOFTWARE_TOKEN_MFA</code> for time-based one-time password (TOTP) software token MFA.</p> </li>
    /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
    /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
    /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
    /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated in your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
    /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
    /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you must authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li>
    /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
    /// <li> <p> <code>MFA_SETUP</code>: For users who are required to set up an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
    /// </ul>
    pub challenge_name: std::option::Option<crate::model::ChallengeNameType>,
    /// <p>The session that should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>
    pub session: std::option::Option<std::string::String>,
    /// <p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p>
    /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
    /// <p>The value of the <code>USER_ID_FOR_SRP</code> attribute is the user's actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This happens because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute can't be an alias.</p>
    pub challenge_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The result of the authentication response. This is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
    pub authentication_result: std::option::Option<crate::model::AuthenticationResultType>,
}
impl AdminInitiateAuthOutput {
    /// <p>The name of the challenge that you're responding to with this call. This is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
    /// <ul>
    /// <li> <p> <code>MFA_SETUP</code>: If MFA is required, users who don't have at least one of the MFA methods set up are presented with an <code>MFA_SETUP</code> challenge. The user must set up at least one MFA type to continue to authenticate.</p> </li>
    /// <li> <p> <code>SELECT_MFA_TYPE</code>: Selects the MFA type. Valid MFA options are <code>SMS_MFA</code> for text SMS MFA, and <code>SOFTWARE_TOKEN_MFA</code> for time-based one-time password (TOTP) software token MFA.</p> </li>
    /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
    /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
    /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
    /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated in your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
    /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
    /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you must authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li>
    /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
    /// <li> <p> <code>MFA_SETUP</code>: For users who are required to set up an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
    /// </ul>
    pub fn challenge_name(&self) -> std::option::Option<&crate::model::ChallengeNameType> {
        self.challenge_name.as_ref()
    }
    /// <p>The session that should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>
    pub fn session(&self) -> std::option::Option<&str> {
        self.session.as_deref()
    }
    /// <p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p>
    /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
    /// <p>The value of the <code>USER_ID_FOR_SRP</code> attribute is the user's actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This happens because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute can't be an alias.</p>
    pub fn challenge_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.challenge_parameters.as_ref()
    }
    /// <p>The result of the authentication response. This is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
    pub fn authentication_result(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationResultType> {
        self.authentication_result.as_ref()
    }
}
impl std::fmt::Debug for AdminInitiateAuthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminInitiateAuthOutput");
        formatter.field("challenge_name", &self.challenge_name);
        formatter.field("session", &self.session);
        formatter.field("challenge_parameters", &self.challenge_parameters);
        formatter.field("authentication_result", &self.authentication_result);
        formatter.finish()
    }
}
/// See [`AdminInitiateAuthOutput`](crate::output::AdminInitiateAuthOutput)
pub mod admin_initiate_auth_output {
    /// A builder for [`AdminInitiateAuthOutput`](crate::output::AdminInitiateAuthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) challenge_name: std::option::Option<crate::model::ChallengeNameType>,
        pub(crate) session: std::option::Option<std::string::String>,
        pub(crate) challenge_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) authentication_result:
            std::option::Option<crate::model::AuthenticationResultType>,
    }
    impl Builder {
        /// <p>The name of the challenge that you're responding to with this call. This is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
        /// <ul>
        /// <li> <p> <code>MFA_SETUP</code>: If MFA is required, users who don't have at least one of the MFA methods set up are presented with an <code>MFA_SETUP</code> challenge. The user must set up at least one MFA type to continue to authenticate.</p> </li>
        /// <li> <p> <code>SELECT_MFA_TYPE</code>: Selects the MFA type. Valid MFA options are <code>SMS_MFA</code> for text SMS MFA, and <code>SOFTWARE_TOKEN_MFA</code> for time-based one-time password (TOTP) software token MFA.</p> </li>
        /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
        /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated in your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you must authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code>: For users who are required to set up an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
        /// </ul>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.challenge_name = Some(input);
            self
        }
        /// <p>The name of the challenge that you're responding to with this call. This is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p>
        /// <ul>
        /// <li> <p> <code>MFA_SETUP</code>: If MFA is required, users who don't have at least one of the MFA methods set up are presented with an <code>MFA_SETUP</code> challenge. The user must set up at least one MFA type to continue to authenticate.</p> </li>
        /// <li> <p> <code>SELECT_MFA_TYPE</code>: Selects the MFA type. Valid MFA options are <code>SMS_MFA</code> for text SMS MFA, and <code>SOFTWARE_TOKEN_MFA</code> for time-based one-time password (TOTP) software token MFA.</p> </li>
        /// <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li>
        /// <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated in your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you must authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code>: For users who are required to set up an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li>
        /// </ul>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.challenge_name = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Adds a key-value pair to `challenge_parameters`.
        ///
        /// To override the contents of this collection use [`set_challenge_parameters`](Self::set_challenge_parameters).
        ///
        /// <p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p>
        /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
        /// <p>The value of the <code>USER_ID_FOR_SRP</code> attribute is the user's actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This happens because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute can't be an alias.</p>
        pub fn challenge_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.challenge_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.challenge_parameters = Some(hash_map);
            self
        }
        /// <p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p>
        /// <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>
        /// <p>The value of the <code>USER_ID_FOR_SRP</code> attribute is the user's actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This happens because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute can't be an alias.</p>
        pub fn set_challenge_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.challenge_parameters = input;
            self
        }
        /// <p>The result of the authentication response. This is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
        pub fn authentication_result(
            mut self,
            input: crate::model::AuthenticationResultType,
        ) -> Self {
            self.authentication_result = Some(input);
            self
        }
        /// <p>The result of the authentication response. This is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>
        pub fn set_authentication_result(
            mut self,
            input: std::option::Option<crate::model::AuthenticationResultType>,
        ) -> Self {
            self.authentication_result = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminInitiateAuthOutput`](crate::output::AdminInitiateAuthOutput)
        pub fn build(self) -> crate::output::AdminInitiateAuthOutput {
            crate::output::AdminInitiateAuthOutput {
                challenge_name: self.challenge_name,
                session: self.session,
                challenge_parameters: self.challenge_parameters,
                authentication_result: self.authentication_result,
            }
        }
    }
}
impl AdminInitiateAuthOutput {
    /// Creates a new builder-style object to manufacture [`AdminInitiateAuthOutput`](crate::output::AdminInitiateAuthOutput)
    pub fn builder() -> crate::output::admin_initiate_auth_output::Builder {
        crate::output::admin_initiate_auth_output::Builder::default()
    }
}

/// <p>Represents the response from the server from the request to get the specified user as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminGetUserOutput {
    /// <p>The user name of the user about whom you're receiving information.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>An array of name-value pairs representing user attributes.</p>
    pub user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
    /// <p>The date the user was created.</p>
    pub user_create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the user was last modified.</p>
    pub user_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates that the status is <code>enabled</code>.</p>
    pub enabled: bool,
    /// <p>The user status. Can be one of the following:</p>
    /// <ul>
    /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
    /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
    /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
    /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
    /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
    /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
    /// </ul>
    pub user_status: std::option::Option<crate::model::UserStatusType>,
    /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
    pub mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
    /// <p>The user's preferred MFA setting.</p>
    pub preferred_mfa_setting: std::option::Option<std::string::String>,
    /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
    pub user_mfa_setting_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AdminGetUserOutput {
    /// <p>The user name of the user about whom you're receiving information.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>An array of name-value pairs representing user attributes.</p>
    pub fn user_attributes(&self) -> std::option::Option<&[crate::model::AttributeType]> {
        self.user_attributes.as_deref()
    }
    /// <p>The date the user was created.</p>
    pub fn user_create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.user_create_date.as_ref()
    }
    /// <p>The date the user was last modified.</p>
    pub fn user_last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.user_last_modified_date.as_ref()
    }
    /// <p>Indicates that the status is <code>enabled</code>.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The user status. Can be one of the following:</p>
    /// <ul>
    /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
    /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
    /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
    /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
    /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
    /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
    /// </ul>
    pub fn user_status(&self) -> std::option::Option<&crate::model::UserStatusType> {
        self.user_status.as_ref()
    }
    /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
    pub fn mfa_options(&self) -> std::option::Option<&[crate::model::MfaOptionType]> {
        self.mfa_options.as_deref()
    }
    /// <p>The user's preferred MFA setting.</p>
    pub fn preferred_mfa_setting(&self) -> std::option::Option<&str> {
        self.preferred_mfa_setting.as_deref()
    }
    /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
    pub fn user_mfa_setting_list(&self) -> std::option::Option<&[std::string::String]> {
        self.user_mfa_setting_list.as_deref()
    }
}
impl std::fmt::Debug for AdminGetUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminGetUserOutput");
        formatter.field("username", &"*** Sensitive Data Redacted ***");
        formatter.field("user_attributes", &self.user_attributes);
        formatter.field("user_create_date", &self.user_create_date);
        formatter.field("user_last_modified_date", &self.user_last_modified_date);
        formatter.field("enabled", &self.enabled);
        formatter.field("user_status", &self.user_status);
        formatter.field("mfa_options", &self.mfa_options);
        formatter.field("preferred_mfa_setting", &self.preferred_mfa_setting);
        formatter.field("user_mfa_setting_list", &self.user_mfa_setting_list);
        formatter.finish()
    }
}
/// See [`AdminGetUserOutput`](crate::output::AdminGetUserOutput)
pub mod admin_get_user_output {
    /// A builder for [`AdminGetUserOutput`](crate::output::AdminGetUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) user_create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) user_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) user_status: std::option::Option<crate::model::UserStatusType>,
        pub(crate) mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        pub(crate) preferred_mfa_setting: std::option::Option<std::string::String>,
        pub(crate) user_mfa_setting_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The user name of the user about whom you're receiving information.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user about whom you're receiving information.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input);
            self.user_attributes = Some(v);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// <p>The date the user was created.</p>
        pub fn user_create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.user_create_date = Some(input);
            self
        }
        /// <p>The date the user was created.</p>
        pub fn set_user_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.user_create_date = input;
            self
        }
        /// <p>The date the user was last modified.</p>
        pub fn user_last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.user_last_modified_date = Some(input);
            self
        }
        /// <p>The date the user was last modified.</p>
        pub fn set_user_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.user_last_modified_date = input;
            self
        }
        /// <p>Indicates that the status is <code>enabled</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates that the status is <code>enabled</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The user status. Can be one of the following:</p>
        /// <ul>
        /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
        /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
        /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
        /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
        /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
        /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
        /// </ul>
        pub fn user_status(mut self, input: crate::model::UserStatusType) -> Self {
            self.user_status = Some(input);
            self
        }
        /// <p>The user status. Can be one of the following:</p>
        /// <ul>
        /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
        /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
        /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
        /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
        /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
        /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
        /// </ul>
        pub fn set_user_status(
            mut self,
            input: std::option::Option<crate::model::UserStatusType>,
        ) -> Self {
            self.user_status = input;
            self
        }
        /// Appends an item to `mfa_options`.
        ///
        /// To override the contents of this collection use [`set_mfa_options`](Self::set_mfa_options).
        ///
        /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
        pub fn mfa_options(mut self, input: crate::model::MfaOptionType) -> Self {
            let mut v = self.mfa_options.unwrap_or_default();
            v.push(input);
            self.mfa_options = Some(v);
            self
        }
        /// <p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>
        pub fn set_mfa_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        ) -> Self {
            self.mfa_options = input;
            self
        }
        /// <p>The user's preferred MFA setting.</p>
        pub fn preferred_mfa_setting(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_mfa_setting = Some(input.into());
            self
        }
        /// <p>The user's preferred MFA setting.</p>
        pub fn set_preferred_mfa_setting(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_mfa_setting = input;
            self
        }
        /// Appends an item to `user_mfa_setting_list`.
        ///
        /// To override the contents of this collection use [`set_user_mfa_setting_list`](Self::set_user_mfa_setting_list).
        ///
        /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
        pub fn user_mfa_setting_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_mfa_setting_list.unwrap_or_default();
            v.push(input.into());
            self.user_mfa_setting_list = Some(v);
            self
        }
        /// <p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>
        pub fn set_user_mfa_setting_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_mfa_setting_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminGetUserOutput`](crate::output::AdminGetUserOutput)
        pub fn build(self) -> crate::output::AdminGetUserOutput {
            crate::output::AdminGetUserOutput {
                username: self.username,
                user_attributes: self.user_attributes,
                user_create_date: self.user_create_date,
                user_last_modified_date: self.user_last_modified_date,
                enabled: self.enabled.unwrap_or_default(),
                user_status: self.user_status,
                mfa_options: self.mfa_options,
                preferred_mfa_setting: self.preferred_mfa_setting,
                user_mfa_setting_list: self.user_mfa_setting_list,
            }
        }
    }
}
impl AdminGetUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminGetUserOutput`](crate::output::AdminGetUserOutput)
    pub fn builder() -> crate::output::admin_get_user_output::Builder {
        crate::output::admin_get_user_output::Builder::default()
    }
}

/// <p>Gets the device response, as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminGetDeviceOutput {
    /// <p>The device.</p>
    pub device: std::option::Option<crate::model::DeviceType>,
}
impl AdminGetDeviceOutput {
    /// <p>The device.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::DeviceType> {
        self.device.as_ref()
    }
}
impl std::fmt::Debug for AdminGetDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminGetDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`AdminGetDeviceOutput`](crate::output::AdminGetDeviceOutput)
pub mod admin_get_device_output {
    /// A builder for [`AdminGetDeviceOutput`](crate::output::AdminGetDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::DeviceType>,
    }
    impl Builder {
        /// <p>The device.</p>
        pub fn device(mut self, input: crate::model::DeviceType) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>The device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::DeviceType>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminGetDeviceOutput`](crate::output::AdminGetDeviceOutput)
        pub fn build(self) -> crate::output::AdminGetDeviceOutput {
            crate::output::AdminGetDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl AdminGetDeviceOutput {
    /// Creates a new builder-style object to manufacture [`AdminGetDeviceOutput`](crate::output::AdminGetDeviceOutput)
    pub fn builder() -> crate::output::admin_get_device_output::Builder {
        crate::output::admin_get_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminForgetDeviceOutput {}
impl std::fmt::Debug for AdminForgetDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminForgetDeviceOutput");
        formatter.finish()
    }
}
/// See [`AdminForgetDeviceOutput`](crate::output::AdminForgetDeviceOutput)
pub mod admin_forget_device_output {
    /// A builder for [`AdminForgetDeviceOutput`](crate::output::AdminForgetDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminForgetDeviceOutput`](crate::output::AdminForgetDeviceOutput)
        pub fn build(self) -> crate::output::AdminForgetDeviceOutput {
            crate::output::AdminForgetDeviceOutput {}
        }
    }
}
impl AdminForgetDeviceOutput {
    /// Creates a new builder-style object to manufacture [`AdminForgetDeviceOutput`](crate::output::AdminForgetDeviceOutput)
    pub fn builder() -> crate::output::admin_forget_device_output::Builder {
        crate::output::admin_forget_device_output::Builder::default()
    }
}

/// <p>Represents the response from the server for the request to enable a user as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminEnableUserOutput {}
impl std::fmt::Debug for AdminEnableUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminEnableUserOutput");
        formatter.finish()
    }
}
/// See [`AdminEnableUserOutput`](crate::output::AdminEnableUserOutput)
pub mod admin_enable_user_output {
    /// A builder for [`AdminEnableUserOutput`](crate::output::AdminEnableUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminEnableUserOutput`](crate::output::AdminEnableUserOutput)
        pub fn build(self) -> crate::output::AdminEnableUserOutput {
            crate::output::AdminEnableUserOutput {}
        }
    }
}
impl AdminEnableUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminEnableUserOutput`](crate::output::AdminEnableUserOutput)
    pub fn builder() -> crate::output::admin_enable_user_output::Builder {
        crate::output::admin_enable_user_output::Builder::default()
    }
}

/// <p>Represents the response received from the server to disable the user as an administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminDisableUserOutput {}
impl std::fmt::Debug for AdminDisableUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminDisableUserOutput");
        formatter.finish()
    }
}
/// See [`AdminDisableUserOutput`](crate::output::AdminDisableUserOutput)
pub mod admin_disable_user_output {
    /// A builder for [`AdminDisableUserOutput`](crate::output::AdminDisableUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminDisableUserOutput`](crate::output::AdminDisableUserOutput)
        pub fn build(self) -> crate::output::AdminDisableUserOutput {
            crate::output::AdminDisableUserOutput {}
        }
    }
}
impl AdminDisableUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminDisableUserOutput`](crate::output::AdminDisableUserOutput)
    pub fn builder() -> crate::output::admin_disable_user_output::Builder {
        crate::output::admin_disable_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminDisableProviderForUserOutput {}
impl std::fmt::Debug for AdminDisableProviderForUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminDisableProviderForUserOutput");
        formatter.finish()
    }
}
/// See [`AdminDisableProviderForUserOutput`](crate::output::AdminDisableProviderForUserOutput)
pub mod admin_disable_provider_for_user_output {
    /// A builder for [`AdminDisableProviderForUserOutput`](crate::output::AdminDisableProviderForUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminDisableProviderForUserOutput`](crate::output::AdminDisableProviderForUserOutput)
        pub fn build(self) -> crate::output::AdminDisableProviderForUserOutput {
            crate::output::AdminDisableProviderForUserOutput {}
        }
    }
}
impl AdminDisableProviderForUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminDisableProviderForUserOutput`](crate::output::AdminDisableProviderForUserOutput)
    pub fn builder() -> crate::output::admin_disable_provider_for_user_output::Builder {
        crate::output::admin_disable_provider_for_user_output::Builder::default()
    }
}

/// <p>Represents the response received from the server for a request to delete user attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminDeleteUserAttributesOutput {}
impl std::fmt::Debug for AdminDeleteUserAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminDeleteUserAttributesOutput");
        formatter.finish()
    }
}
/// See [`AdminDeleteUserAttributesOutput`](crate::output::AdminDeleteUserAttributesOutput)
pub mod admin_delete_user_attributes_output {
    /// A builder for [`AdminDeleteUserAttributesOutput`](crate::output::AdminDeleteUserAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminDeleteUserAttributesOutput`](crate::output::AdminDeleteUserAttributesOutput)
        pub fn build(self) -> crate::output::AdminDeleteUserAttributesOutput {
            crate::output::AdminDeleteUserAttributesOutput {}
        }
    }
}
impl AdminDeleteUserAttributesOutput {
    /// Creates a new builder-style object to manufacture [`AdminDeleteUserAttributesOutput`](crate::output::AdminDeleteUserAttributesOutput)
    pub fn builder() -> crate::output::admin_delete_user_attributes_output::Builder {
        crate::output::admin_delete_user_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminDeleteUserOutput {}
impl std::fmt::Debug for AdminDeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminDeleteUserOutput");
        formatter.finish()
    }
}
/// See [`AdminDeleteUserOutput`](crate::output::AdminDeleteUserOutput)
pub mod admin_delete_user_output {
    /// A builder for [`AdminDeleteUserOutput`](crate::output::AdminDeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminDeleteUserOutput`](crate::output::AdminDeleteUserOutput)
        pub fn build(self) -> crate::output::AdminDeleteUserOutput {
            crate::output::AdminDeleteUserOutput {}
        }
    }
}
impl AdminDeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminDeleteUserOutput`](crate::output::AdminDeleteUserOutput)
    pub fn builder() -> crate::output::admin_delete_user_output::Builder {
        crate::output::admin_delete_user_output::Builder::default()
    }
}

/// <p>Represents the response from the server to the request to create the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminCreateUserOutput {
    /// <p>The newly created user.</p>
    pub user: std::option::Option<crate::model::UserType>,
}
impl AdminCreateUserOutput {
    /// <p>The newly created user.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::UserType> {
        self.user.as_ref()
    }
}
impl std::fmt::Debug for AdminCreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminCreateUserOutput");
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`AdminCreateUserOutput`](crate::output::AdminCreateUserOutput)
pub mod admin_create_user_output {
    /// A builder for [`AdminCreateUserOutput`](crate::output::AdminCreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::UserType>,
    }
    impl Builder {
        /// <p>The newly created user.</p>
        pub fn user(mut self, input: crate::model::UserType) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The newly created user.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminCreateUserOutput`](crate::output::AdminCreateUserOutput)
        pub fn build(self) -> crate::output::AdminCreateUserOutput {
            crate::output::AdminCreateUserOutput { user: self.user }
        }
    }
}
impl AdminCreateUserOutput {
    /// Creates a new builder-style object to manufacture [`AdminCreateUserOutput`](crate::output::AdminCreateUserOutput)
    pub fn builder() -> crate::output::admin_create_user_output::Builder {
        crate::output::admin_create_user_output::Builder::default()
    }
}

/// <p>Represents the response from the server for the request to confirm registration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminConfirmSignUpOutput {}
impl std::fmt::Debug for AdminConfirmSignUpOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminConfirmSignUpOutput");
        formatter.finish()
    }
}
/// See [`AdminConfirmSignUpOutput`](crate::output::AdminConfirmSignUpOutput)
pub mod admin_confirm_sign_up_output {
    /// A builder for [`AdminConfirmSignUpOutput`](crate::output::AdminConfirmSignUpOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminConfirmSignUpOutput`](crate::output::AdminConfirmSignUpOutput)
        pub fn build(self) -> crate::output::AdminConfirmSignUpOutput {
            crate::output::AdminConfirmSignUpOutput {}
        }
    }
}
impl AdminConfirmSignUpOutput {
    /// Creates a new builder-style object to manufacture [`AdminConfirmSignUpOutput`](crate::output::AdminConfirmSignUpOutput)
    pub fn builder() -> crate::output::admin_confirm_sign_up_output::Builder {
        crate::output::admin_confirm_sign_up_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminAddUserToGroupOutput {}
impl std::fmt::Debug for AdminAddUserToGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminAddUserToGroupOutput");
        formatter.finish()
    }
}
/// See [`AdminAddUserToGroupOutput`](crate::output::AdminAddUserToGroupOutput)
pub mod admin_add_user_to_group_output {
    /// A builder for [`AdminAddUserToGroupOutput`](crate::output::AdminAddUserToGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AdminAddUserToGroupOutput`](crate::output::AdminAddUserToGroupOutput)
        pub fn build(self) -> crate::output::AdminAddUserToGroupOutput {
            crate::output::AdminAddUserToGroupOutput {}
        }
    }
}
impl AdminAddUserToGroupOutput {
    /// Creates a new builder-style object to manufacture [`AdminAddUserToGroupOutput`](crate::output::AdminAddUserToGroupOutput)
    pub fn builder() -> crate::output::admin_add_user_to_group_output::Builder {
        crate::output::admin_add_user_to_group_output::Builder::default()
    }
}

/// <p>Represents the response from the server for the request to add custom attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddCustomAttributesOutput {}
impl std::fmt::Debug for AddCustomAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddCustomAttributesOutput");
        formatter.finish()
    }
}
/// See [`AddCustomAttributesOutput`](crate::output::AddCustomAttributesOutput)
pub mod add_custom_attributes_output {
    /// A builder for [`AddCustomAttributesOutput`](crate::output::AddCustomAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddCustomAttributesOutput`](crate::output::AddCustomAttributesOutput)
        pub fn build(self) -> crate::output::AddCustomAttributesOutput {
            crate::output::AddCustomAttributesOutput {}
        }
    }
}
impl AddCustomAttributesOutput {
    /// Creates a new builder-style object to manufacture [`AddCustomAttributesOutput`](crate::output::AddCustomAttributesOutput)
    pub fn builder() -> crate::output::add_custom_attributes_output::Builder {
        crate::output::add_custom_attributes_output::Builder::default()
    }
}
