// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VerifySoftwareTokenResponseType {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VerifySoftwareTokenResponseType {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => VerifySoftwareTokenResponseType::Error,
            "SUCCESS" => VerifySoftwareTokenResponseType::Success,
            other => VerifySoftwareTokenResponseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VerifySoftwareTokenResponseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VerifySoftwareTokenResponseType::from(s))
    }
}
impl VerifySoftwareTokenResponseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VerifySoftwareTokenResponseType::Error => "ERROR",
            VerifySoftwareTokenResponseType::Success => "SUCCESS",
            VerifySoftwareTokenResponseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "SUCCESS"]
    }
}
impl AsRef<str> for VerifySoftwareTokenResponseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomDomainConfigType {
    /// <p>The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl CustomDomainConfigType {
    /// <p>The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomDomainConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomDomainConfigType");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}
/// See [`CustomDomainConfigType`](crate::model::CustomDomainConfigType)
pub mod custom_domain_config_type {
    /// A builder for [`CustomDomainConfigType`](crate::model::CustomDomainConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomDomainConfigType`](crate::model::CustomDomainConfigType)
        pub fn build(self) -> crate::model::CustomDomainConfigType {
            crate::model::CustomDomainConfigType {
                certificate_arn: self.certificate_arn,
            }
        }
    }
}
impl CustomDomainConfigType {
    /// Creates a new builder-style object to manufacture [`CustomDomainConfigType`](crate::model::CustomDomainConfigType)
    pub fn builder() -> crate::model::custom_domain_config_type::Builder {
        crate::model::custom_domain_config_type::Builder::default()
    }
}

/// <p>Contains information about a user pool client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolClientType {
    /// <p>The user pool ID for the user pool client.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The client name from the user pool request of the client type.</p>
    pub client_name: std::option::Option<std::string::String>,
    /// <p>The ID of the client associated with the user pool.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The client secret from the user pool request of the client type.</p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p>The date the user pool client was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the user pool client was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
    pub refresh_token_validity: i32,
    /// <p>The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no longer valid and can't be used.</p>
    pub access_token_validity: std::option::Option<i32>,
    /// <p>The time limit specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no longer valid and can't be used.</p>
    pub id_token_validity: std::option::Option<i32>,
    /// <p>The time units used to specify the token validity times of their respective token.</p>
    pub token_validity_units: std::option::Option<crate::model::TokenValidityUnitsType>,
    /// <p>The Read-only attributes.</p>
    pub read_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The writeable attributes.</p>
    pub write_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values including the <code>ALLOW_</code> prefix.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
    /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
    /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
    /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
    /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
    /// </ul>
    pub explicit_auth_flows:
        std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
    /// <p>A list of provider names for the identity providers that are supported on this client.</p>
    pub supported_identity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
    /// <p>A redirect URI must:</p>
    /// <ul>
    /// <li> <p>Be an absolute URI.</p> </li>
    /// <li> <p>Be registered with the authorization server.</p> </li>
    /// <li> <p>Not include a fragment component.</p> </li>
    /// </ul>
    /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
    /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
    /// <p>App callback URLs such as myapp://example are also supported.</p>
    pub callback_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of allowed logout URLs for the identity providers.</p>
    pub logout_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
    /// <p>A redirect URI must:</p>
    /// <ul>
    /// <li> <p>Be an absolute URI.</p> </li>
    /// <li> <p>Be registered with the authorization server.</p> </li>
    /// <li> <p>Not include a fragment component.</p> </li>
    /// </ul>
    /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
    /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
    /// <p>App callback URLs such as myapp://example are also supported.</p>
    pub default_redirect_uri: std::option::Option<std::string::String>,
    /// <p>The allowed OAuth flows.</p>
    /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
    /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
    /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
    pub allowed_o_auth_flows: std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
    /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
    pub allowed_o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
    pub allowed_o_auth_flows_user_pool_client: std::option::Option<bool>,
    /// <p>The Amazon Pinpoint analytics configuration for the user pool client.</p> <note>
    /// <p>Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.</p>
    /// </note>
    pub analytics_configuration: std::option::Option<crate::model::AnalyticsConfigurationType>,
    /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
    /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors aren't prevented.</p> </li>
    /// </ul>
    pub prevent_user_existence_errors:
        std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
    /// <p>Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
    pub enable_token_revocation: std::option::Option<bool>,
}
impl UserPoolClientType {
    /// <p>The user pool ID for the user pool client.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The client name from the user pool request of the client type.</p>
    pub fn client_name(&self) -> std::option::Option<&str> {
        self.client_name.as_deref()
    }
    /// <p>The ID of the client associated with the user pool.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The client secret from the user pool request of the client type.</p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p>The date the user pool client was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the user pool client was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
    pub fn refresh_token_validity(&self) -> i32 {
        self.refresh_token_validity
    }
    /// <p>The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no longer valid and can't be used.</p>
    pub fn access_token_validity(&self) -> std::option::Option<i32> {
        self.access_token_validity
    }
    /// <p>The time limit specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no longer valid and can't be used.</p>
    pub fn id_token_validity(&self) -> std::option::Option<i32> {
        self.id_token_validity
    }
    /// <p>The time units used to specify the token validity times of their respective token.</p>
    pub fn token_validity_units(
        &self,
    ) -> std::option::Option<&crate::model::TokenValidityUnitsType> {
        self.token_validity_units.as_ref()
    }
    /// <p>The Read-only attributes.</p>
    pub fn read_attributes(&self) -> std::option::Option<&[std::string::String]> {
        self.read_attributes.as_deref()
    }
    /// <p>The writeable attributes.</p>
    pub fn write_attributes(&self) -> std::option::Option<&[std::string::String]> {
        self.write_attributes.as_deref()
    }
    /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values including the <code>ALLOW_</code> prefix.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
    /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
    /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
    /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
    /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
    /// </ul>
    pub fn explicit_auth_flows(
        &self,
    ) -> std::option::Option<&[crate::model::ExplicitAuthFlowsType]> {
        self.explicit_auth_flows.as_deref()
    }
    /// <p>A list of provider names for the identity providers that are supported on this client.</p>
    pub fn supported_identity_providers(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_identity_providers.as_deref()
    }
    /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
    /// <p>A redirect URI must:</p>
    /// <ul>
    /// <li> <p>Be an absolute URI.</p> </li>
    /// <li> <p>Be registered with the authorization server.</p> </li>
    /// <li> <p>Not include a fragment component.</p> </li>
    /// </ul>
    /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
    /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
    /// <p>App callback URLs such as myapp://example are also supported.</p>
    pub fn callback_ur_ls(&self) -> std::option::Option<&[std::string::String]> {
        self.callback_ur_ls.as_deref()
    }
    /// <p>A list of allowed logout URLs for the identity providers.</p>
    pub fn logout_ur_ls(&self) -> std::option::Option<&[std::string::String]> {
        self.logout_ur_ls.as_deref()
    }
    /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
    /// <p>A redirect URI must:</p>
    /// <ul>
    /// <li> <p>Be an absolute URI.</p> </li>
    /// <li> <p>Be registered with the authorization server.</p> </li>
    /// <li> <p>Not include a fragment component.</p> </li>
    /// </ul>
    /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
    /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
    /// <p>App callback URLs such as myapp://example are also supported.</p>
    pub fn default_redirect_uri(&self) -> std::option::Option<&str> {
        self.default_redirect_uri.as_deref()
    }
    /// <p>The allowed OAuth flows.</p>
    /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
    /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
    /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
    pub fn allowed_o_auth_flows(&self) -> std::option::Option<&[crate::model::OAuthFlowType]> {
        self.allowed_o_auth_flows.as_deref()
    }
    /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
    pub fn allowed_o_auth_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_o_auth_scopes.as_deref()
    }
    /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
    pub fn allowed_o_auth_flows_user_pool_client(&self) -> std::option::Option<bool> {
        self.allowed_o_auth_flows_user_pool_client
    }
    /// <p>The Amazon Pinpoint analytics configuration for the user pool client.</p> <note>
    /// <p>Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.</p>
    /// </note>
    pub fn analytics_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AnalyticsConfigurationType> {
        self.analytics_configuration.as_ref()
    }
    /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
    /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors aren't prevented.</p> </li>
    /// </ul>
    pub fn prevent_user_existence_errors(
        &self,
    ) -> std::option::Option<&crate::model::PreventUserExistenceErrorTypes> {
        self.prevent_user_existence_errors.as_ref()
    }
    /// <p>Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
    pub fn enable_token_revocation(&self) -> std::option::Option<bool> {
        self.enable_token_revocation
    }
}
impl std::fmt::Debug for UserPoolClientType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolClientType");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("client_name", &self.client_name);
        formatter.field("client_id", &"*** Sensitive Data Redacted ***");
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("refresh_token_validity", &self.refresh_token_validity);
        formatter.field("access_token_validity", &self.access_token_validity);
        formatter.field("id_token_validity", &self.id_token_validity);
        formatter.field("token_validity_units", &self.token_validity_units);
        formatter.field("read_attributes", &self.read_attributes);
        formatter.field("write_attributes", &self.write_attributes);
        formatter.field("explicit_auth_flows", &self.explicit_auth_flows);
        formatter.field(
            "supported_identity_providers",
            &self.supported_identity_providers,
        );
        formatter.field("callback_ur_ls", &self.callback_ur_ls);
        formatter.field("logout_ur_ls", &self.logout_ur_ls);
        formatter.field("default_redirect_uri", &self.default_redirect_uri);
        formatter.field("allowed_o_auth_flows", &self.allowed_o_auth_flows);
        formatter.field("allowed_o_auth_scopes", &self.allowed_o_auth_scopes);
        formatter.field(
            "allowed_o_auth_flows_user_pool_client",
            &self.allowed_o_auth_flows_user_pool_client,
        );
        formatter.field("analytics_configuration", &self.analytics_configuration);
        formatter.field(
            "prevent_user_existence_errors",
            &self.prevent_user_existence_errors,
        );
        formatter.field("enable_token_revocation", &self.enable_token_revocation);
        formatter.finish()
    }
}
/// See [`UserPoolClientType`](crate::model::UserPoolClientType)
pub mod user_pool_client_type {
    /// A builder for [`UserPoolClientType`](crate::model::UserPoolClientType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_name: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) refresh_token_validity: std::option::Option<i32>,
        pub(crate) access_token_validity: std::option::Option<i32>,
        pub(crate) id_token_validity: std::option::Option<i32>,
        pub(crate) token_validity_units: std::option::Option<crate::model::TokenValidityUnitsType>,
        pub(crate) read_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) write_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) explicit_auth_flows:
            std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        pub(crate) supported_identity_providers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) callback_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) logout_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_redirect_uri: std::option::Option<std::string::String>,
        pub(crate) allowed_o_auth_flows:
            std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        pub(crate) allowed_o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_o_auth_flows_user_pool_client: std::option::Option<bool>,
        pub(crate) analytics_configuration:
            std::option::Option<crate::model::AnalyticsConfigurationType>,
        pub(crate) prevent_user_existence_errors:
            std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        pub(crate) enable_token_revocation: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The client name from the user pool request of the client type.</p>
        pub fn client_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_name = Some(input.into());
            self
        }
        /// <p>The client name from the user pool request of the client type.</p>
        pub fn set_client_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_name = input;
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The client secret from the user pool request of the client type.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p>The client secret from the user pool request of the client type.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p>The date the user pool client was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the user pool client was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the user pool client was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the user pool client was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
        pub fn refresh_token_validity(mut self, input: i32) -> Self {
            self.refresh_token_validity = Some(input);
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
        pub fn set_refresh_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.refresh_token_validity = input;
            self
        }
        /// <p>The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no longer valid and can't be used.</p>
        pub fn access_token_validity(mut self, input: i32) -> Self {
            self.access_token_validity = Some(input);
            self
        }
        /// <p>The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no longer valid and can't be used.</p>
        pub fn set_access_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.access_token_validity = input;
            self
        }
        /// <p>The time limit specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no longer valid and can't be used.</p>
        pub fn id_token_validity(mut self, input: i32) -> Self {
            self.id_token_validity = Some(input);
            self
        }
        /// <p>The time limit specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no longer valid and can't be used.</p>
        pub fn set_id_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.id_token_validity = input;
            self
        }
        /// <p>The time units used to specify the token validity times of their respective token.</p>
        pub fn token_validity_units(mut self, input: crate::model::TokenValidityUnitsType) -> Self {
            self.token_validity_units = Some(input);
            self
        }
        /// <p>The time units used to specify the token validity times of their respective token.</p>
        pub fn set_token_validity_units(
            mut self,
            input: std::option::Option<crate::model::TokenValidityUnitsType>,
        ) -> Self {
            self.token_validity_units = input;
            self
        }
        /// Appends an item to `read_attributes`.
        ///
        /// To override the contents of this collection use [`set_read_attributes`](Self::set_read_attributes).
        ///
        /// <p>The Read-only attributes.</p>
        pub fn read_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.read_attributes.unwrap_or_default();
            v.push(input.into());
            self.read_attributes = Some(v);
            self
        }
        /// <p>The Read-only attributes.</p>
        pub fn set_read_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_attributes = input;
            self
        }
        /// Appends an item to `write_attributes`.
        ///
        /// To override the contents of this collection use [`set_write_attributes`](Self::set_write_attributes).
        ///
        /// <p>The writeable attributes.</p>
        pub fn write_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.write_attributes.unwrap_or_default();
            v.push(input.into());
            self.write_attributes = Some(v);
            self
        }
        /// <p>The writeable attributes.</p>
        pub fn set_write_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.write_attributes = input;
            self
        }
        /// Appends an item to `explicit_auth_flows`.
        ///
        /// To override the contents of this collection use [`set_explicit_auth_flows`](Self::set_explicit_auth_flows).
        ///
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values including the <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn explicit_auth_flows(mut self, input: crate::model::ExplicitAuthFlowsType) -> Self {
            let mut v = self.explicit_auth_flows.unwrap_or_default();
            v.push(input);
            self.explicit_auth_flows = Some(v);
            self
        }
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values including the <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn set_explicit_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        ) -> Self {
            self.explicit_auth_flows = input;
            self
        }
        /// Appends an item to `supported_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_identity_providers`](Self::set_supported_identity_providers).
        ///
        /// <p>A list of provider names for the identity providers that are supported on this client.</p>
        pub fn supported_identity_providers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.supported_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.supported_identity_providers = Some(v);
            self
        }
        /// <p>A list of provider names for the identity providers that are supported on this client.</p>
        pub fn set_supported_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_identity_providers = input;
            self
        }
        /// Appends an item to `callback_ur_ls`.
        ///
        /// To override the contents of this collection use [`set_callback_ur_ls`](Self::set_callback_ur_ls).
        ///
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn callback_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.callback_ur_ls.unwrap_or_default();
            v.push(input.into());
            self.callback_ur_ls = Some(v);
            self
        }
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_callback_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.callback_ur_ls = input;
            self
        }
        /// Appends an item to `logout_ur_ls`.
        ///
        /// To override the contents of this collection use [`set_logout_ur_ls`](Self::set_logout_ur_ls).
        ///
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn logout_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logout_ur_ls.unwrap_or_default();
            v.push(input.into());
            self.logout_ur_ls = Some(v);
            self
        }
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn set_logout_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logout_ur_ls = input;
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn default_redirect_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_redirect_uri = Some(input.into());
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_default_redirect_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_redirect_uri = input;
            self
        }
        /// Appends an item to `allowed_o_auth_flows`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_flows`](Self::set_allowed_o_auth_flows).
        ///
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn allowed_o_auth_flows(mut self, input: crate::model::OAuthFlowType) -> Self {
            let mut v = self.allowed_o_auth_flows.unwrap_or_default();
            v.push(input);
            self.allowed_o_auth_flows = Some(v);
            self
        }
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn set_allowed_o_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        ) -> Self {
            self.allowed_o_auth_flows = input;
            self
        }
        /// Appends an item to `allowed_o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_scopes`](Self::set_allowed_o_auth_scopes).
        ///
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn allowed_o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.allowed_o_auth_scopes = Some(v);
            self
        }
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn set_allowed_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_o_auth_scopes = input;
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
        pub fn allowed_o_auth_flows_user_pool_client(mut self, input: bool) -> Self {
            self.allowed_o_auth_flows_user_pool_client = Some(input);
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
        pub fn set_allowed_o_auth_flows_user_pool_client(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allowed_o_auth_flows_user_pool_client = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for the user pool client.</p> <note>
        /// <p>Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.</p>
        /// </note>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfigurationType,
        ) -> Self {
            self.analytics_configuration = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for the user pool client.</p> <note>
        /// <p>Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.</p>
        /// </note>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfigurationType>,
        ) -> Self {
            self.analytics_configuration = input;
            self
        }
        /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors aren't prevented.</p> </li>
        /// </ul>
        pub fn prevent_user_existence_errors(
            mut self,
            input: crate::model::PreventUserExistenceErrorTypes,
        ) -> Self {
            self.prevent_user_existence_errors = Some(input);
            self
        }
        /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors aren't prevented.</p> </li>
        /// </ul>
        pub fn set_prevent_user_existence_errors(
            mut self,
            input: std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        ) -> Self {
            self.prevent_user_existence_errors = input;
            self
        }
        /// <p>Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        pub fn enable_token_revocation(mut self, input: bool) -> Self {
            self.enable_token_revocation = Some(input);
            self
        }
        /// <p>Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        pub fn set_enable_token_revocation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_token_revocation = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolClientType`](crate::model::UserPoolClientType)
        pub fn build(self) -> crate::model::UserPoolClientType {
            crate::model::UserPoolClientType {
                user_pool_id: self.user_pool_id,
                client_name: self.client_name,
                client_id: self.client_id,
                client_secret: self.client_secret,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
                refresh_token_validity: self.refresh_token_validity.unwrap_or_default(),
                access_token_validity: self.access_token_validity,
                id_token_validity: self.id_token_validity,
                token_validity_units: self.token_validity_units,
                read_attributes: self.read_attributes,
                write_attributes: self.write_attributes,
                explicit_auth_flows: self.explicit_auth_flows,
                supported_identity_providers: self.supported_identity_providers,
                callback_ur_ls: self.callback_ur_ls,
                logout_ur_ls: self.logout_ur_ls,
                default_redirect_uri: self.default_redirect_uri,
                allowed_o_auth_flows: self.allowed_o_auth_flows,
                allowed_o_auth_scopes: self.allowed_o_auth_scopes,
                allowed_o_auth_flows_user_pool_client: self.allowed_o_auth_flows_user_pool_client,
                analytics_configuration: self.analytics_configuration,
                prevent_user_existence_errors: self.prevent_user_existence_errors,
                enable_token_revocation: self.enable_token_revocation,
            }
        }
    }
}
impl UserPoolClientType {
    /// Creates a new builder-style object to manufacture [`UserPoolClientType`](crate::model::UserPoolClientType)
    pub fn builder() -> crate::model::user_pool_client_type::Builder {
        crate::model::user_pool_client_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PreventUserExistenceErrorTypes {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Legacy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PreventUserExistenceErrorTypes {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => PreventUserExistenceErrorTypes::Enabled,
            "LEGACY" => PreventUserExistenceErrorTypes::Legacy,
            other => PreventUserExistenceErrorTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PreventUserExistenceErrorTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PreventUserExistenceErrorTypes::from(s))
    }
}
impl PreventUserExistenceErrorTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PreventUserExistenceErrorTypes::Enabled => "ENABLED",
            PreventUserExistenceErrorTypes::Legacy => "LEGACY",
            PreventUserExistenceErrorTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED", "LEGACY"]
    }
}
impl AsRef<str> for PreventUserExistenceErrorTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Amazon Pinpoint analytics configuration for collecting metrics for a user pool.</p> <note>
/// <p>In Regions where Amazon Pinpointisn't available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyticsConfigurationType {
    /// <p>The application ID for an Amazon Pinpoint application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The external ID.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.</p>
    pub user_data_shared: bool,
}
impl AnalyticsConfigurationType {
    /// <p>The application ID for an Amazon Pinpoint application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
    /// <p>The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The external ID.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.</p>
    pub fn user_data_shared(&self) -> bool {
        self.user_data_shared
    }
}
impl std::fmt::Debug for AnalyticsConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyticsConfigurationType");
        formatter.field("application_id", &self.application_id);
        formatter.field("application_arn", &self.application_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("external_id", &self.external_id);
        formatter.field("user_data_shared", &self.user_data_shared);
        formatter.finish()
    }
}
/// See [`AnalyticsConfigurationType`](crate::model::AnalyticsConfigurationType)
pub mod analytics_configuration_type {
    /// A builder for [`AnalyticsConfigurationType`](crate::model::AnalyticsConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) user_data_shared: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The application ID for an Amazon Pinpoint application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID for an Amazon Pinpoint application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The external ID.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.</p>
        pub fn user_data_shared(mut self, input: bool) -> Self {
            self.user_data_shared = Some(input);
            self
        }
        /// <p>If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.</p>
        pub fn set_user_data_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.user_data_shared = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyticsConfigurationType`](crate::model::AnalyticsConfigurationType)
        pub fn build(self) -> crate::model::AnalyticsConfigurationType {
            crate::model::AnalyticsConfigurationType {
                application_id: self.application_id,
                application_arn: self.application_arn,
                role_arn: self.role_arn,
                external_id: self.external_id,
                user_data_shared: self.user_data_shared.unwrap_or_default(),
            }
        }
    }
}
impl AnalyticsConfigurationType {
    /// Creates a new builder-style object to manufacture [`AnalyticsConfigurationType`](crate::model::AnalyticsConfigurationType)
    pub fn builder() -> crate::model::analytics_configuration_type::Builder {
        crate::model::analytics_configuration_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OAuthFlowType {
    #[allow(missing_docs)] // documentation missing in model
    ClientCredentials,
    #[allow(missing_docs)] // documentation missing in model
    Code,
    #[allow(missing_docs)] // documentation missing in model
    Implicit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OAuthFlowType {
    fn from(s: &str) -> Self {
        match s {
            "client_credentials" => OAuthFlowType::ClientCredentials,
            "code" => OAuthFlowType::Code,
            "implicit" => OAuthFlowType::Implicit,
            other => OAuthFlowType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OAuthFlowType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OAuthFlowType::from(s))
    }
}
impl OAuthFlowType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OAuthFlowType::ClientCredentials => "client_credentials",
            OAuthFlowType::Code => "code",
            OAuthFlowType::Implicit => "implicit",
            OAuthFlowType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["client_credentials", "code", "implicit"]
    }
}
impl AsRef<str> for OAuthFlowType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExplicitAuthFlowsType {
    #[allow(missing_docs)] // documentation missing in model
    AdminNoSrpAuth,
    #[allow(missing_docs)] // documentation missing in model
    AllowAdminUserPasswordAuth,
    #[allow(missing_docs)] // documentation missing in model
    AllowCustomAuth,
    #[allow(missing_docs)] // documentation missing in model
    AllowRefreshTokenAuth,
    #[allow(missing_docs)] // documentation missing in model
    AllowUserPasswordAuth,
    #[allow(missing_docs)] // documentation missing in model
    AllowUserSrpAuth,
    #[allow(missing_docs)] // documentation missing in model
    CustomAuthFlowOnly,
    #[allow(missing_docs)] // documentation missing in model
    UserPasswordAuth,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExplicitAuthFlowsType {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN_NO_SRP_AUTH" => ExplicitAuthFlowsType::AdminNoSrpAuth,
            "ALLOW_ADMIN_USER_PASSWORD_AUTH" => ExplicitAuthFlowsType::AllowAdminUserPasswordAuth,
            "ALLOW_CUSTOM_AUTH" => ExplicitAuthFlowsType::AllowCustomAuth,
            "ALLOW_REFRESH_TOKEN_AUTH" => ExplicitAuthFlowsType::AllowRefreshTokenAuth,
            "ALLOW_USER_PASSWORD_AUTH" => ExplicitAuthFlowsType::AllowUserPasswordAuth,
            "ALLOW_USER_SRP_AUTH" => ExplicitAuthFlowsType::AllowUserSrpAuth,
            "CUSTOM_AUTH_FLOW_ONLY" => ExplicitAuthFlowsType::CustomAuthFlowOnly,
            "USER_PASSWORD_AUTH" => ExplicitAuthFlowsType::UserPasswordAuth,
            other => ExplicitAuthFlowsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExplicitAuthFlowsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExplicitAuthFlowsType::from(s))
    }
}
impl ExplicitAuthFlowsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExplicitAuthFlowsType::AdminNoSrpAuth => "ADMIN_NO_SRP_AUTH",
            ExplicitAuthFlowsType::AllowAdminUserPasswordAuth => "ALLOW_ADMIN_USER_PASSWORD_AUTH",
            ExplicitAuthFlowsType::AllowCustomAuth => "ALLOW_CUSTOM_AUTH",
            ExplicitAuthFlowsType::AllowRefreshTokenAuth => "ALLOW_REFRESH_TOKEN_AUTH",
            ExplicitAuthFlowsType::AllowUserPasswordAuth => "ALLOW_USER_PASSWORD_AUTH",
            ExplicitAuthFlowsType::AllowUserSrpAuth => "ALLOW_USER_SRP_AUTH",
            ExplicitAuthFlowsType::CustomAuthFlowOnly => "CUSTOM_AUTH_FLOW_ONLY",
            ExplicitAuthFlowsType::UserPasswordAuth => "USER_PASSWORD_AUTH",
            ExplicitAuthFlowsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADMIN_NO_SRP_AUTH",
            "ALLOW_ADMIN_USER_PASSWORD_AUTH",
            "ALLOW_CUSTOM_AUTH",
            "ALLOW_REFRESH_TOKEN_AUTH",
            "ALLOW_USER_PASSWORD_AUTH",
            "ALLOW_USER_SRP_AUTH",
            "CUSTOM_AUTH_FLOW_ONLY",
            "USER_PASSWORD_AUTH",
        ]
    }
}
impl AsRef<str> for ExplicitAuthFlowsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The data type for TokenValidityUnits that specifics the time measurements for token validity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TokenValidityUnitsType {
    /// <p> A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in AccessTokenValidity, defaulting to hours.</p>
    pub access_token: std::option::Option<crate::model::TimeUnitsType>,
    /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in IdTokenValidity, defaulting to hours.</p>
    pub id_token: std::option::Option<crate::model::TimeUnitsType>,
    /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in RefreshTokenValidity, defaulting to days.</p>
    pub refresh_token: std::option::Option<crate::model::TimeUnitsType>,
}
impl TokenValidityUnitsType {
    /// <p> A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in AccessTokenValidity, defaulting to hours.</p>
    pub fn access_token(&self) -> std::option::Option<&crate::model::TimeUnitsType> {
        self.access_token.as_ref()
    }
    /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in IdTokenValidity, defaulting to hours.</p>
    pub fn id_token(&self) -> std::option::Option<&crate::model::TimeUnitsType> {
        self.id_token.as_ref()
    }
    /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in RefreshTokenValidity, defaulting to days.</p>
    pub fn refresh_token(&self) -> std::option::Option<&crate::model::TimeUnitsType> {
        self.refresh_token.as_ref()
    }
}
impl std::fmt::Debug for TokenValidityUnitsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TokenValidityUnitsType");
        formatter.field("access_token", &self.access_token);
        formatter.field("id_token", &self.id_token);
        formatter.field("refresh_token", &self.refresh_token);
        formatter.finish()
    }
}
/// See [`TokenValidityUnitsType`](crate::model::TokenValidityUnitsType)
pub mod token_validity_units_type {
    /// A builder for [`TokenValidityUnitsType`](crate::model::TokenValidityUnitsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<crate::model::TimeUnitsType>,
        pub(crate) id_token: std::option::Option<crate::model::TimeUnitsType>,
        pub(crate) refresh_token: std::option::Option<crate::model::TimeUnitsType>,
    }
    impl Builder {
        /// <p> A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in AccessTokenValidity, defaulting to hours.</p>
        pub fn access_token(mut self, input: crate::model::TimeUnitsType) -> Self {
            self.access_token = Some(input);
            self
        }
        /// <p> A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in AccessTokenValidity, defaulting to hours.</p>
        pub fn set_access_token(
            mut self,
            input: std::option::Option<crate::model::TimeUnitsType>,
        ) -> Self {
            self.access_token = input;
            self
        }
        /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in IdTokenValidity, defaulting to hours.</p>
        pub fn id_token(mut self, input: crate::model::TimeUnitsType) -> Self {
            self.id_token = Some(input);
            self
        }
        /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in IdTokenValidity, defaulting to hours.</p>
        pub fn set_id_token(
            mut self,
            input: std::option::Option<crate::model::TimeUnitsType>,
        ) -> Self {
            self.id_token = input;
            self
        }
        /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in RefreshTokenValidity, defaulting to days.</p>
        pub fn refresh_token(mut self, input: crate::model::TimeUnitsType) -> Self {
            self.refresh_token = Some(input);
            self
        }
        /// <p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in RefreshTokenValidity, defaulting to days.</p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<crate::model::TimeUnitsType>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// Consumes the builder and constructs a [`TokenValidityUnitsType`](crate::model::TokenValidityUnitsType)
        pub fn build(self) -> crate::model::TokenValidityUnitsType {
            crate::model::TokenValidityUnitsType {
                access_token: self.access_token,
                id_token: self.id_token,
                refresh_token: self.refresh_token,
            }
        }
    }
}
impl TokenValidityUnitsType {
    /// Creates a new builder-style object to manufacture [`TokenValidityUnitsType`](crate::model::TokenValidityUnitsType)
    pub fn builder() -> crate::model::token_validity_units_type::Builder {
        crate::model::token_validity_units_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeUnitsType {
    #[allow(missing_docs)] // documentation missing in model
    Days,
    #[allow(missing_docs)] // documentation missing in model
    Hours,
    #[allow(missing_docs)] // documentation missing in model
    Minutes,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeUnitsType {
    fn from(s: &str) -> Self {
        match s {
            "days" => TimeUnitsType::Days,
            "hours" => TimeUnitsType::Hours,
            "minutes" => TimeUnitsType::Minutes,
            "seconds" => TimeUnitsType::Seconds,
            other => TimeUnitsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeUnitsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeUnitsType::from(s))
    }
}
impl TimeUnitsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeUnitsType::Days => "days",
            TimeUnitsType::Hours => "hours",
            TimeUnitsType::Minutes => "minutes",
            TimeUnitsType::Seconds => "seconds",
            TimeUnitsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["days", "hours", "minutes", "seconds"]
    }
}
impl AsRef<str> for TimeUnitsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The data type for <code>AccountRecoverySetting</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountRecoverySettingType {
    /// <p>The list of <code>RecoveryOptionTypes</code>.</p>
    pub recovery_mechanisms: std::option::Option<std::vec::Vec<crate::model::RecoveryOptionType>>,
}
impl AccountRecoverySettingType {
    /// <p>The list of <code>RecoveryOptionTypes</code>.</p>
    pub fn recovery_mechanisms(&self) -> std::option::Option<&[crate::model::RecoveryOptionType]> {
        self.recovery_mechanisms.as_deref()
    }
}
impl std::fmt::Debug for AccountRecoverySettingType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountRecoverySettingType");
        formatter.field("recovery_mechanisms", &self.recovery_mechanisms);
        formatter.finish()
    }
}
/// See [`AccountRecoverySettingType`](crate::model::AccountRecoverySettingType)
pub mod account_recovery_setting_type {
    /// A builder for [`AccountRecoverySettingType`](crate::model::AccountRecoverySettingType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_mechanisms:
            std::option::Option<std::vec::Vec<crate::model::RecoveryOptionType>>,
    }
    impl Builder {
        /// Appends an item to `recovery_mechanisms`.
        ///
        /// To override the contents of this collection use [`set_recovery_mechanisms`](Self::set_recovery_mechanisms).
        ///
        /// <p>The list of <code>RecoveryOptionTypes</code>.</p>
        pub fn recovery_mechanisms(mut self, input: crate::model::RecoveryOptionType) -> Self {
            let mut v = self.recovery_mechanisms.unwrap_or_default();
            v.push(input);
            self.recovery_mechanisms = Some(v);
            self
        }
        /// <p>The list of <code>RecoveryOptionTypes</code>.</p>
        pub fn set_recovery_mechanisms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecoveryOptionType>>,
        ) -> Self {
            self.recovery_mechanisms = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountRecoverySettingType`](crate::model::AccountRecoverySettingType)
        pub fn build(self) -> crate::model::AccountRecoverySettingType {
            crate::model::AccountRecoverySettingType {
                recovery_mechanisms: self.recovery_mechanisms,
            }
        }
    }
}
impl AccountRecoverySettingType {
    /// Creates a new builder-style object to manufacture [`AccountRecoverySettingType`](crate::model::AccountRecoverySettingType)
    pub fn builder() -> crate::model::account_recovery_setting_type::Builder {
        crate::model::account_recovery_setting_type::Builder::default()
    }
}

/// <p>A map containing a priority as a key, and recovery method name as a value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryOptionType {
    /// <p>A positive integer specifying priority of a method with 1 being the highest priority.</p>
    pub priority: i32,
    /// <p>The recovery method for a user.</p>
    pub name: std::option::Option<crate::model::RecoveryOptionNameType>,
}
impl RecoveryOptionType {
    /// <p>A positive integer specifying priority of a method with 1 being the highest priority.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>The recovery method for a user.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::RecoveryOptionNameType> {
        self.name.as_ref()
    }
}
impl std::fmt::Debug for RecoveryOptionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryOptionType");
        formatter.field("priority", &self.priority);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RecoveryOptionType`](crate::model::RecoveryOptionType)
pub mod recovery_option_type {
    /// A builder for [`RecoveryOptionType`](crate::model::RecoveryOptionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) name: std::option::Option<crate::model::RecoveryOptionNameType>,
    }
    impl Builder {
        /// <p>A positive integer specifying priority of a method with 1 being the highest priority.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>A positive integer specifying priority of a method with 1 being the highest priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The recovery method for a user.</p>
        pub fn name(mut self, input: crate::model::RecoveryOptionNameType) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The recovery method for a user.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::RecoveryOptionNameType>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryOptionType`](crate::model::RecoveryOptionType)
        pub fn build(self) -> crate::model::RecoveryOptionType {
            crate::model::RecoveryOptionType {
                priority: self.priority.unwrap_or_default(),
                name: self.name,
            }
        }
    }
}
impl RecoveryOptionType {
    /// Creates a new builder-style object to manufacture [`RecoveryOptionType`](crate::model::RecoveryOptionType)
    pub fn builder() -> crate::model::recovery_option_type::Builder {
        crate::model::recovery_option_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecoveryOptionNameType {
    #[allow(missing_docs)] // documentation missing in model
    AdminOnly,
    #[allow(missing_docs)] // documentation missing in model
    VerifiedEmail,
    #[allow(missing_docs)] // documentation missing in model
    VerifiedPhoneNumber,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecoveryOptionNameType {
    fn from(s: &str) -> Self {
        match s {
            "admin_only" => RecoveryOptionNameType::AdminOnly,
            "verified_email" => RecoveryOptionNameType::VerifiedEmail,
            "verified_phone_number" => RecoveryOptionNameType::VerifiedPhoneNumber,
            other => RecoveryOptionNameType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecoveryOptionNameType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecoveryOptionNameType::from(s))
    }
}
impl RecoveryOptionNameType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecoveryOptionNameType::AdminOnly => "admin_only",
            RecoveryOptionNameType::VerifiedEmail => "verified_email",
            RecoveryOptionNameType::VerifiedPhoneNumber => "verified_phone_number",
            RecoveryOptionNameType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["admin_only", "verified_email", "verified_phone_number"]
    }
}
impl AsRef<str> for RecoveryOptionNameType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The user pool add-ons type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolAddOnsType {
    /// <p>The advanced security mode.</p>
    pub advanced_security_mode: std::option::Option<crate::model::AdvancedSecurityModeType>,
}
impl UserPoolAddOnsType {
    /// <p>The advanced security mode.</p>
    pub fn advanced_security_mode(
        &self,
    ) -> std::option::Option<&crate::model::AdvancedSecurityModeType> {
        self.advanced_security_mode.as_ref()
    }
}
impl std::fmt::Debug for UserPoolAddOnsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolAddOnsType");
        formatter.field("advanced_security_mode", &self.advanced_security_mode);
        formatter.finish()
    }
}
/// See [`UserPoolAddOnsType`](crate::model::UserPoolAddOnsType)
pub mod user_pool_add_ons_type {
    /// A builder for [`UserPoolAddOnsType`](crate::model::UserPoolAddOnsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) advanced_security_mode:
            std::option::Option<crate::model::AdvancedSecurityModeType>,
    }
    impl Builder {
        /// <p>The advanced security mode.</p>
        pub fn advanced_security_mode(
            mut self,
            input: crate::model::AdvancedSecurityModeType,
        ) -> Self {
            self.advanced_security_mode = Some(input);
            self
        }
        /// <p>The advanced security mode.</p>
        pub fn set_advanced_security_mode(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityModeType>,
        ) -> Self {
            self.advanced_security_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolAddOnsType`](crate::model::UserPoolAddOnsType)
        pub fn build(self) -> crate::model::UserPoolAddOnsType {
            crate::model::UserPoolAddOnsType {
                advanced_security_mode: self.advanced_security_mode,
            }
        }
    }
}
impl UserPoolAddOnsType {
    /// Creates a new builder-style object to manufacture [`UserPoolAddOnsType`](crate::model::UserPoolAddOnsType)
    pub fn builder() -> crate::model::user_pool_add_ons_type::Builder {
        crate::model::user_pool_add_ons_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdvancedSecurityModeType {
    #[allow(missing_docs)] // documentation missing in model
    Audit,
    #[allow(missing_docs)] // documentation missing in model
    Enforced,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdvancedSecurityModeType {
    fn from(s: &str) -> Self {
        match s {
            "AUDIT" => AdvancedSecurityModeType::Audit,
            "ENFORCED" => AdvancedSecurityModeType::Enforced,
            "OFF" => AdvancedSecurityModeType::Off,
            other => AdvancedSecurityModeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdvancedSecurityModeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdvancedSecurityModeType::from(s))
    }
}
impl AdvancedSecurityModeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdvancedSecurityModeType::Audit => "AUDIT",
            AdvancedSecurityModeType::Enforced => "ENFORCED",
            AdvancedSecurityModeType::Off => "OFF",
            AdvancedSecurityModeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUDIT", "ENFORCED", "OFF"]
    }
}
impl AsRef<str> for AdvancedSecurityModeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for creating a new user profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminCreateUserConfigType {
    /// <p>Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code> if users can sign themselves up via an app.</p>
    pub allow_admin_create_user_only: bool,
    /// <p>The user account expiration limit, in days, after which the account is no longer usable. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7. </p> <note>
    /// <p>If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.</p>
    /// </note>
    pub unused_account_validity_days: i32,
    /// <p>The message template to be used for the welcome message to new users.</p>
    /// <p>See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a>.</p>
    pub invite_message_template: std::option::Option<crate::model::MessageTemplateType>,
}
impl AdminCreateUserConfigType {
    /// <p>Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code> if users can sign themselves up via an app.</p>
    pub fn allow_admin_create_user_only(&self) -> bool {
        self.allow_admin_create_user_only
    }
    /// <p>The user account expiration limit, in days, after which the account is no longer usable. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7. </p> <note>
    /// <p>If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.</p>
    /// </note>
    pub fn unused_account_validity_days(&self) -> i32 {
        self.unused_account_validity_days
    }
    /// <p>The message template to be used for the welcome message to new users.</p>
    /// <p>See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a>.</p>
    pub fn invite_message_template(
        &self,
    ) -> std::option::Option<&crate::model::MessageTemplateType> {
        self.invite_message_template.as_ref()
    }
}
impl std::fmt::Debug for AdminCreateUserConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminCreateUserConfigType");
        formatter.field(
            "allow_admin_create_user_only",
            &self.allow_admin_create_user_only,
        );
        formatter.field(
            "unused_account_validity_days",
            &self.unused_account_validity_days,
        );
        formatter.field("invite_message_template", &self.invite_message_template);
        formatter.finish()
    }
}
/// See [`AdminCreateUserConfigType`](crate::model::AdminCreateUserConfigType)
pub mod admin_create_user_config_type {
    /// A builder for [`AdminCreateUserConfigType`](crate::model::AdminCreateUserConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allow_admin_create_user_only: std::option::Option<bool>,
        pub(crate) unused_account_validity_days: std::option::Option<i32>,
        pub(crate) invite_message_template: std::option::Option<crate::model::MessageTemplateType>,
    }
    impl Builder {
        /// <p>Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code> if users can sign themselves up via an app.</p>
        pub fn allow_admin_create_user_only(mut self, input: bool) -> Self {
            self.allow_admin_create_user_only = Some(input);
            self
        }
        /// <p>Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code> if users can sign themselves up via an app.</p>
        pub fn set_allow_admin_create_user_only(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_admin_create_user_only = input;
            self
        }
        /// <p>The user account expiration limit, in days, after which the account is no longer usable. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7. </p> <note>
        /// <p>If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.</p>
        /// </note>
        pub fn unused_account_validity_days(mut self, input: i32) -> Self {
            self.unused_account_validity_days = Some(input);
            self
        }
        /// <p>The user account expiration limit, in days, after which the account is no longer usable. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7. </p> <note>
        /// <p>If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.</p>
        /// </note>
        pub fn set_unused_account_validity_days(mut self, input: std::option::Option<i32>) -> Self {
            self.unused_account_validity_days = input;
            self
        }
        /// <p>The message template to be used for the welcome message to new users.</p>
        /// <p>See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a>.</p>
        pub fn invite_message_template(mut self, input: crate::model::MessageTemplateType) -> Self {
            self.invite_message_template = Some(input);
            self
        }
        /// <p>The message template to be used for the welcome message to new users.</p>
        /// <p>See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a>.</p>
        pub fn set_invite_message_template(
            mut self,
            input: std::option::Option<crate::model::MessageTemplateType>,
        ) -> Self {
            self.invite_message_template = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminCreateUserConfigType`](crate::model::AdminCreateUserConfigType)
        pub fn build(self) -> crate::model::AdminCreateUserConfigType {
            crate::model::AdminCreateUserConfigType {
                allow_admin_create_user_only: self.allow_admin_create_user_only.unwrap_or_default(),
                unused_account_validity_days: self.unused_account_validity_days.unwrap_or_default(),
                invite_message_template: self.invite_message_template,
            }
        }
    }
}
impl AdminCreateUserConfigType {
    /// Creates a new builder-style object to manufacture [`AdminCreateUserConfigType`](crate::model::AdminCreateUserConfigType)
    pub fn builder() -> crate::model::admin_create_user_config_type::Builder {
        crate::model::admin_create_user_config_type::Builder::default()
    }
}

/// <p>The message template structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageTemplateType {
    /// <p>The message template for SMS messages.</p>
    pub sms_message: std::option::Option<std::string::String>,
    /// <p>The message template for email messages. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    pub email_message: std::option::Option<std::string::String>,
    /// <p>The subject line for email messages. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    pub email_subject: std::option::Option<std::string::String>,
}
impl MessageTemplateType {
    /// <p>The message template for SMS messages.</p>
    pub fn sms_message(&self) -> std::option::Option<&str> {
        self.sms_message.as_deref()
    }
    /// <p>The message template for email messages. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    pub fn email_message(&self) -> std::option::Option<&str> {
        self.email_message.as_deref()
    }
    /// <p>The subject line for email messages. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    pub fn email_subject(&self) -> std::option::Option<&str> {
        self.email_subject.as_deref()
    }
}
impl std::fmt::Debug for MessageTemplateType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageTemplateType");
        formatter.field("sms_message", &self.sms_message);
        formatter.field("email_message", &self.email_message);
        formatter.field("email_subject", &self.email_subject);
        formatter.finish()
    }
}
/// See [`MessageTemplateType`](crate::model::MessageTemplateType)
pub mod message_template_type {
    /// A builder for [`MessageTemplateType`](crate::model::MessageTemplateType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_message: std::option::Option<std::string::String>,
        pub(crate) email_message: std::option::Option<std::string::String>,
        pub(crate) email_subject: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message template for SMS messages.</p>
        pub fn sms_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_message = Some(input.into());
            self
        }
        /// <p>The message template for SMS messages.</p>
        pub fn set_sms_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sms_message = input;
            self
        }
        /// <p>The message template for email messages. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_message = Some(input.into());
            self
        }
        /// <p>The message template for email messages. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_message = input;
            self
        }
        /// <p>The subject line for email messages. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_subject = Some(input.into());
            self
        }
        /// <p>The subject line for email messages. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_subject = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageTemplateType`](crate::model::MessageTemplateType)
        pub fn build(self) -> crate::model::MessageTemplateType {
            crate::model::MessageTemplateType {
                sms_message: self.sms_message,
                email_message: self.email_message,
                email_subject: self.email_subject,
            }
        }
    }
}
impl MessageTemplateType {
    /// Creates a new builder-style object to manufacture [`MessageTemplateType`](crate::model::MessageTemplateType)
    pub fn builder() -> crate::model::message_template_type::Builder {
        crate::model::message_template_type::Builder::default()
    }
}

/// <p>The SMS configuration type is the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsConfigurationType {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a>. </p>
    pub sns_caller_arn: std::option::Option<std::string::String>,
    /// <p>The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code> with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the <code>ExternalId</code>.</p>
    /// <p>For more information about the <code>ExternalId</code> of a role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use an external ID when granting access to your Amazon Web Services resources to a third party</a> </p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>. </p>
    /// <p> Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings for Amazon Cognito user pools</a>.</p>
    pub sns_region: std::option::Option<std::string::String>,
}
impl SmsConfigurationType {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a>. </p>
    pub fn sns_caller_arn(&self) -> std::option::Option<&str> {
        self.sns_caller_arn.as_deref()
    }
    /// <p>The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code> with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the <code>ExternalId</code>.</p>
    /// <p>For more information about the <code>ExternalId</code> of a role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use an external ID when granting access to your Amazon Web Services resources to a third party</a> </p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>. </p>
    /// <p> Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings for Amazon Cognito user pools</a>.</p>
    pub fn sns_region(&self) -> std::option::Option<&str> {
        self.sns_region.as_deref()
    }
}
impl std::fmt::Debug for SmsConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsConfigurationType");
        formatter.field("sns_caller_arn", &self.sns_caller_arn);
        formatter.field("external_id", &self.external_id);
        formatter.field("sns_region", &self.sns_region);
        formatter.finish()
    }
}
/// See [`SmsConfigurationType`](crate::model::SmsConfigurationType)
pub mod sms_configuration_type {
    /// A builder for [`SmsConfigurationType`](crate::model::SmsConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_caller_arn: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) sns_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a>. </p>
        pub fn sns_caller_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_caller_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a>. </p>
        pub fn set_sns_caller_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_caller_arn = input;
            self
        }
        /// <p>The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code> with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the <code>ExternalId</code>.</p>
        /// <p>For more information about the <code>ExternalId</code> of a role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use an external ID when granting access to your Amazon Web Services resources to a third party</a> </p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code> with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the <code>ExternalId</code>.</p>
        /// <p>For more information about the <code>ExternalId</code> of a role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use an external ID when granting access to your Amazon Web Services resources to a third party</a> </p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>. </p>
        /// <p> Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings for Amazon Cognito user pools</a>.</p>
        pub fn sns_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>. </p>
        /// <p> Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings for Amazon Cognito user pools</a>.</p>
        pub fn set_sns_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_region = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsConfigurationType`](crate::model::SmsConfigurationType)
        pub fn build(self) -> crate::model::SmsConfigurationType {
            crate::model::SmsConfigurationType {
                sns_caller_arn: self.sns_caller_arn,
                external_id: self.external_id,
                sns_region: self.sns_region,
            }
        }
    }
}
impl SmsConfigurationType {
    /// Creates a new builder-style object to manufacture [`SmsConfigurationType`](crate::model::SmsConfigurationType)
    pub fn builder() -> crate::model::sms_configuration_type::Builder {
        crate::model::sms_configuration_type::Builder::default()
    }
}

/// <p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.</p> <note>
/// <p>Amazon Cognito can send email messages with Amazon Simple Email Service resources in the Amazon Web Services Region where you created your user pool, and in alternate Regions in some cases. For more information on the supported Regions, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html">Email settings for Amazon Cognito user pools</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailConfigurationType {
    /// <p>The ARN of a verified email address in Amazon SES. Amazon Cognito uses this email address in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:</p>
    /// <ul>
    /// <li> <p>If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</p> </li>
    /// <li> <p>If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</p> </li>
    /// </ul>
    /// <p>The Region value of the <code>SourceArn</code> parameter must indicate a supported Amazon Web Services Region of your user pool. Typically, the Region in the <code>SourceArn</code> and the user pool Region are the same. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping">Amazon SES email configuration regions</a> in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito Developer Guide</a>.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The destination to which the receiver of the email should reply.</p>
    pub reply_to_email_address: std::option::Option<std::string::String>,
    /// <p>Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration. Specify one of the following values:</p>
    /// <dl>
    /// <dt>
    /// COGNITO_DEFAULT
    /// </dt>
    /// <dd>
    /// <p>When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</p>
    /// <p>To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in </a> in the <i> Developer Guide</i>.</p>
    /// <p>The default FROM address is <code>no-reply@verificationemail.com</code>. To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
    /// <p> If EmailSendingAccount is COGNITO_DEFAULT, you can't use the following parameters:</p>
    /// <ul>
    /// <li> <p>EmailVerificationMessage</p> </li>
    /// <li> <p>EmailVerificationSubject</p> </li>
    /// <li> <p>InviteMessageTemplate.EmailMessage</p> </li>
    /// <li> <p>InviteMessageTemplate.EmailSubject</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailMessage</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailMessageByLink</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailSubject,</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailSubjectByLink</p> </li>
    /// </ul> <note>
    /// <p>DEVELOPER EmailSendingAccount is required.</p>
    /// </note>
    /// </dd>
    /// <dt>
    /// DEVELOPER
    /// </dt>
    /// <dd>
    /// <p>When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your Amazon Web Services account.</p>
    /// <p>If you use this option, you must provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
    /// <p>Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a type of role, in your Amazon Web Services account. This role contains the permissions that allow to access Amazon SES and send email messages with your address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub email_sending_account: std::option::Option<crate::model::EmailSendingAccountType>,
    /// <p>Either the sender’s email address or the sender’s name with their email address. For example, <code>testuser@example.com</code> or <code>Test User
    /// <testuser@example.com></testuser@example.com></code>. This address appears before the body of the email.</p>
    pub from: std::option::Option<std::string::String>,
    /// <p>The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails: </p>
    /// <dl>
    /// <dt>
    /// Event publishing
    /// </dt>
    /// <dd>
    /// <p>Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other Amazon Web Services services such as and Amazon CloudWatch</p>
    /// </dd>
    /// <dt>
    /// IP pool management
    /// </dt>
    /// <dd>
    /// <p>When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</p>
    /// </dd>
    /// </dl>
    pub configuration_set: std::option::Option<std::string::String>,
}
impl EmailConfigurationType {
    /// <p>The ARN of a verified email address in Amazon SES. Amazon Cognito uses this email address in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:</p>
    /// <ul>
    /// <li> <p>If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</p> </li>
    /// <li> <p>If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</p> </li>
    /// </ul>
    /// <p>The Region value of the <code>SourceArn</code> parameter must indicate a supported Amazon Web Services Region of your user pool. Typically, the Region in the <code>SourceArn</code> and the user pool Region are the same. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping">Amazon SES email configuration regions</a> in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito Developer Guide</a>.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The destination to which the receiver of the email should reply.</p>
    pub fn reply_to_email_address(&self) -> std::option::Option<&str> {
        self.reply_to_email_address.as_deref()
    }
    /// <p>Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration. Specify one of the following values:</p>
    /// <dl>
    /// <dt>
    /// COGNITO_DEFAULT
    /// </dt>
    /// <dd>
    /// <p>When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</p>
    /// <p>To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in </a> in the <i> Developer Guide</i>.</p>
    /// <p>The default FROM address is <code>no-reply@verificationemail.com</code>. To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
    /// <p> If EmailSendingAccount is COGNITO_DEFAULT, you can't use the following parameters:</p>
    /// <ul>
    /// <li> <p>EmailVerificationMessage</p> </li>
    /// <li> <p>EmailVerificationSubject</p> </li>
    /// <li> <p>InviteMessageTemplate.EmailMessage</p> </li>
    /// <li> <p>InviteMessageTemplate.EmailSubject</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailMessage</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailMessageByLink</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailSubject,</p> </li>
    /// <li> <p>VerificationMessageTemplate.EmailSubjectByLink</p> </li>
    /// </ul> <note>
    /// <p>DEVELOPER EmailSendingAccount is required.</p>
    /// </note>
    /// </dd>
    /// <dt>
    /// DEVELOPER
    /// </dt>
    /// <dd>
    /// <p>When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your Amazon Web Services account.</p>
    /// <p>If you use this option, you must provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
    /// <p>Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a type of role, in your Amazon Web Services account. This role contains the permissions that allow to access Amazon SES and send email messages with your address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub fn email_sending_account(
        &self,
    ) -> std::option::Option<&crate::model::EmailSendingAccountType> {
        self.email_sending_account.as_ref()
    }
    /// <p>Either the sender’s email address or the sender’s name with their email address. For example, <code>testuser@example.com</code> or <code>Test User
    /// <testuser@example.com></testuser@example.com></code>. This address appears before the body of the email.</p>
    pub fn from(&self) -> std::option::Option<&str> {
        self.from.as_deref()
    }
    /// <p>The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails: </p>
    /// <dl>
    /// <dt>
    /// Event publishing
    /// </dt>
    /// <dd>
    /// <p>Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other Amazon Web Services services such as and Amazon CloudWatch</p>
    /// </dd>
    /// <dt>
    /// IP pool management
    /// </dt>
    /// <dd>
    /// <p>When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</p>
    /// </dd>
    /// </dl>
    pub fn configuration_set(&self) -> std::option::Option<&str> {
        self.configuration_set.as_deref()
    }
}
impl std::fmt::Debug for EmailConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailConfigurationType");
        formatter.field("source_arn", &self.source_arn);
        formatter.field("reply_to_email_address", &self.reply_to_email_address);
        formatter.field("email_sending_account", &self.email_sending_account);
        formatter.field("from", &self.from);
        formatter.field("configuration_set", &self.configuration_set);
        formatter.finish()
    }
}
/// See [`EmailConfigurationType`](crate::model::EmailConfigurationType)
pub mod email_configuration_type {
    /// A builder for [`EmailConfigurationType`](crate::model::EmailConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) reply_to_email_address: std::option::Option<std::string::String>,
        pub(crate) email_sending_account:
            std::option::Option<crate::model::EmailSendingAccountType>,
        pub(crate) from: std::option::Option<std::string::String>,
        pub(crate) configuration_set: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a verified email address in Amazon SES. Amazon Cognito uses this email address in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:</p>
        /// <ul>
        /// <li> <p>If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</p> </li>
        /// <li> <p>If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</p> </li>
        /// </ul>
        /// <p>The Region value of the <code>SourceArn</code> parameter must indicate a supported Amazon Web Services Region of your user pool. Typically, the Region in the <code>SourceArn</code> and the user pool Region are the same. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping">Amazon SES email configuration regions</a> in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito Developer Guide</a>.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a verified email address in Amazon SES. Amazon Cognito uses this email address in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:</p>
        /// <ul>
        /// <li> <p>If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</p> </li>
        /// <li> <p>If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</p> </li>
        /// </ul>
        /// <p>The Region value of the <code>SourceArn</code> parameter must indicate a supported Amazon Web Services Region of your user pool. Typically, the Region in the <code>SourceArn</code> and the user pool Region are the same. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping">Amazon SES email configuration regions</a> in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito Developer Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The destination to which the receiver of the email should reply.</p>
        pub fn reply_to_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.reply_to_email_address = Some(input.into());
            self
        }
        /// <p>The destination to which the receiver of the email should reply.</p>
        pub fn set_reply_to_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reply_to_email_address = input;
            self
        }
        /// <p>Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration. Specify one of the following values:</p>
        /// <dl>
        /// <dt>
        /// COGNITO_DEFAULT
        /// </dt>
        /// <dd>
        /// <p>When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</p>
        /// <p>To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in </a> in the <i> Developer Guide</i>.</p>
        /// <p>The default FROM address is <code>no-reply@verificationemail.com</code>. To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
        /// <p> If EmailSendingAccount is COGNITO_DEFAULT, you can't use the following parameters:</p>
        /// <ul>
        /// <li> <p>EmailVerificationMessage</p> </li>
        /// <li> <p>EmailVerificationSubject</p> </li>
        /// <li> <p>InviteMessageTemplate.EmailMessage</p> </li>
        /// <li> <p>InviteMessageTemplate.EmailSubject</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailMessage</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailMessageByLink</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailSubject,</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailSubjectByLink</p> </li>
        /// </ul> <note>
        /// <p>DEVELOPER EmailSendingAccount is required.</p>
        /// </note>
        /// </dd>
        /// <dt>
        /// DEVELOPER
        /// </dt>
        /// <dd>
        /// <p>When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your Amazon Web Services account.</p>
        /// <p>If you use this option, you must provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
        /// <p>Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a type of role, in your Amazon Web Services account. This role contains the permissions that allow to access Amazon SES and send email messages with your address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn email_sending_account(
            mut self,
            input: crate::model::EmailSendingAccountType,
        ) -> Self {
            self.email_sending_account = Some(input);
            self
        }
        /// <p>Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration. Specify one of the following values:</p>
        /// <dl>
        /// <dt>
        /// COGNITO_DEFAULT
        /// </dt>
        /// <dd>
        /// <p>When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</p>
        /// <p>To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in </a> in the <i> Developer Guide</i>.</p>
        /// <p>The default FROM address is <code>no-reply@verificationemail.com</code>. To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
        /// <p> If EmailSendingAccount is COGNITO_DEFAULT, you can't use the following parameters:</p>
        /// <ul>
        /// <li> <p>EmailVerificationMessage</p> </li>
        /// <li> <p>EmailVerificationSubject</p> </li>
        /// <li> <p>InviteMessageTemplate.EmailMessage</p> </li>
        /// <li> <p>InviteMessageTemplate.EmailSubject</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailMessage</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailMessageByLink</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailSubject,</p> </li>
        /// <li> <p>VerificationMessageTemplate.EmailSubjectByLink</p> </li>
        /// </ul> <note>
        /// <p>DEVELOPER EmailSendingAccount is required.</p>
        /// </note>
        /// </dd>
        /// <dt>
        /// DEVELOPER
        /// </dt>
        /// <dd>
        /// <p>When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your Amazon Web Services account.</p>
        /// <p>If you use this option, you must provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p>
        /// <p>Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a type of role, in your Amazon Web Services account. This role contains the permissions that allow to access Amazon SES and send email messages with your address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn set_email_sending_account(
            mut self,
            input: std::option::Option<crate::model::EmailSendingAccountType>,
        ) -> Self {
            self.email_sending_account = input;
            self
        }
        /// <p>Either the sender’s email address or the sender’s name with their email address. For example, <code>testuser@example.com</code> or <code>Test User
        /// <testuser@example.com></testuser@example.com></code>. This address appears before the body of the email.</p>
        pub fn from(mut self, input: impl Into<std::string::String>) -> Self {
            self.from = Some(input.into());
            self
        }
        /// <p>Either the sender’s email address or the sender’s name with their email address. For example, <code>testuser@example.com</code> or <code>Test User
        /// <testuser@example.com></testuser@example.com></code>. This address appears before the body of the email.</p>
        pub fn set_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from = input;
            self
        }
        /// <p>The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails: </p>
        /// <dl>
        /// <dt>
        /// Event publishing
        /// </dt>
        /// <dd>
        /// <p>Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other Amazon Web Services services such as and Amazon CloudWatch</p>
        /// </dd>
        /// <dt>
        /// IP pool management
        /// </dt>
        /// <dd>
        /// <p>When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</p>
        /// </dd>
        /// </dl>
        pub fn configuration_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set = Some(input.into());
            self
        }
        /// <p>The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails: </p>
        /// <dl>
        /// <dt>
        /// Event publishing
        /// </dt>
        /// <dd>
        /// <p>Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other Amazon Web Services services such as and Amazon CloudWatch</p>
        /// </dd>
        /// <dt>
        /// IP pool management
        /// </dt>
        /// <dd>
        /// <p>When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</p>
        /// </dd>
        /// </dl>
        pub fn set_configuration_set(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailConfigurationType`](crate::model::EmailConfigurationType)
        pub fn build(self) -> crate::model::EmailConfigurationType {
            crate::model::EmailConfigurationType {
                source_arn: self.source_arn,
                reply_to_email_address: self.reply_to_email_address,
                email_sending_account: self.email_sending_account,
                from: self.from,
                configuration_set: self.configuration_set,
            }
        }
    }
}
impl EmailConfigurationType {
    /// Creates a new builder-style object to manufacture [`EmailConfigurationType`](crate::model::EmailConfigurationType)
    pub fn builder() -> crate::model::email_configuration_type::Builder {
        crate::model::email_configuration_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EmailSendingAccountType {
    #[allow(missing_docs)] // documentation missing in model
    CognitoDefault,
    #[allow(missing_docs)] // documentation missing in model
    Developer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EmailSendingAccountType {
    fn from(s: &str) -> Self {
        match s {
            "COGNITO_DEFAULT" => EmailSendingAccountType::CognitoDefault,
            "DEVELOPER" => EmailSendingAccountType::Developer,
            other => EmailSendingAccountType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EmailSendingAccountType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EmailSendingAccountType::from(s))
    }
}
impl EmailSendingAccountType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EmailSendingAccountType::CognitoDefault => "COGNITO_DEFAULT",
            EmailSendingAccountType::Developer => "DEVELOPER",
            EmailSendingAccountType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COGNITO_DEFAULT", "DEVELOPER"]
    }
}
impl AsRef<str> for EmailSendingAccountType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The device tracking configuration for a user pool. A user pool with device tracking deactivated returns a null value.</p> <note>
/// <p>When you provide values for any DeviceConfiguration field, you activate device tracking.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceConfigurationType {
    /// <p>When true, device authentication can replace SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note>
    /// <p>Users that sign in with devices that have not been confirmed or remembered will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice is true, when your user pool requires MFA.</p>
    /// </note>
    pub challenge_required_on_new_device: bool,
    /// <p>When true, users can opt in to remembering their device. Your app code must use callback functions to return the user's choice.</p>
    pub device_only_remembered_on_user_prompt: bool,
}
impl DeviceConfigurationType {
    /// <p>When true, device authentication can replace SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note>
    /// <p>Users that sign in with devices that have not been confirmed or remembered will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice is true, when your user pool requires MFA.</p>
    /// </note>
    pub fn challenge_required_on_new_device(&self) -> bool {
        self.challenge_required_on_new_device
    }
    /// <p>When true, users can opt in to remembering their device. Your app code must use callback functions to return the user's choice.</p>
    pub fn device_only_remembered_on_user_prompt(&self) -> bool {
        self.device_only_remembered_on_user_prompt
    }
}
impl std::fmt::Debug for DeviceConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceConfigurationType");
        formatter.field(
            "challenge_required_on_new_device",
            &self.challenge_required_on_new_device,
        );
        formatter.field(
            "device_only_remembered_on_user_prompt",
            &self.device_only_remembered_on_user_prompt,
        );
        formatter.finish()
    }
}
/// See [`DeviceConfigurationType`](crate::model::DeviceConfigurationType)
pub mod device_configuration_type {
    /// A builder for [`DeviceConfigurationType`](crate::model::DeviceConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) challenge_required_on_new_device: std::option::Option<bool>,
        pub(crate) device_only_remembered_on_user_prompt: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>When true, device authentication can replace SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note>
        /// <p>Users that sign in with devices that have not been confirmed or remembered will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice is true, when your user pool requires MFA.</p>
        /// </note>
        pub fn challenge_required_on_new_device(mut self, input: bool) -> Self {
            self.challenge_required_on_new_device = Some(input);
            self
        }
        /// <p>When true, device authentication can replace SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note>
        /// <p>Users that sign in with devices that have not been confirmed or remembered will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice is true, when your user pool requires MFA.</p>
        /// </note>
        pub fn set_challenge_required_on_new_device(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.challenge_required_on_new_device = input;
            self
        }
        /// <p>When true, users can opt in to remembering their device. Your app code must use callback functions to return the user's choice.</p>
        pub fn device_only_remembered_on_user_prompt(mut self, input: bool) -> Self {
            self.device_only_remembered_on_user_prompt = Some(input);
            self
        }
        /// <p>When true, users can opt in to remembering their device. Your app code must use callback functions to return the user's choice.</p>
        pub fn set_device_only_remembered_on_user_prompt(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.device_only_remembered_on_user_prompt = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceConfigurationType`](crate::model::DeviceConfigurationType)
        pub fn build(self) -> crate::model::DeviceConfigurationType {
            crate::model::DeviceConfigurationType {
                challenge_required_on_new_device: self
                    .challenge_required_on_new_device
                    .unwrap_or_default(),
                device_only_remembered_on_user_prompt: self
                    .device_only_remembered_on_user_prompt
                    .unwrap_or_default(),
            }
        }
    }
}
impl DeviceConfigurationType {
    /// Creates a new builder-style object to manufacture [`DeviceConfigurationType`](crate::model::DeviceConfigurationType)
    pub fn builder() -> crate::model::device_configuration_type::Builder {
        crate::model::device_configuration_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserPoolMfaType {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    On,
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserPoolMfaType {
    fn from(s: &str) -> Self {
        match s {
            "OFF" => UserPoolMfaType::Off,
            "ON" => UserPoolMfaType::On,
            "OPTIONAL" => UserPoolMfaType::Optional,
            other => UserPoolMfaType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserPoolMfaType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserPoolMfaType::from(s))
    }
}
impl UserPoolMfaType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserPoolMfaType::Off => "OFF",
            UserPoolMfaType::On => "ON",
            UserPoolMfaType::Optional => "OPTIONAL",
            UserPoolMfaType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFF", "ON", "OPTIONAL"]
    }
}
impl AsRef<str> for UserPoolMfaType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The template for verification messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerificationMessageTemplateType {
    /// <p>The SMS message template.</p>
    pub sms_message: std::option::Option<std::string::String>,
    /// <p>The email message template. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER. </p>
    pub email_message: std::option::Option<std::string::String>,
    /// <p>The subject line for the email message template. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    pub email_subject: std::option::Option<std::string::String>,
    /// <p>The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
    pub email_message_by_link: std::option::Option<std::string::String>,
    /// <p>The subject line for the email message template for sending a confirmation link to the user. EmailSubjectByLink is allowed only <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
    pub email_subject_by_link: std::option::Option<std::string::String>,
    /// <p>The default email option.</p>
    pub default_email_option: std::option::Option<crate::model::DefaultEmailOptionType>,
}
impl VerificationMessageTemplateType {
    /// <p>The SMS message template.</p>
    pub fn sms_message(&self) -> std::option::Option<&str> {
        self.sms_message.as_deref()
    }
    /// <p>The email message template. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER. </p>
    pub fn email_message(&self) -> std::option::Option<&str> {
        self.email_message.as_deref()
    }
    /// <p>The subject line for the email message template. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
    pub fn email_subject(&self) -> std::option::Option<&str> {
        self.email_subject.as_deref()
    }
    /// <p>The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
    pub fn email_message_by_link(&self) -> std::option::Option<&str> {
        self.email_message_by_link.as_deref()
    }
    /// <p>The subject line for the email message template for sending a confirmation link to the user. EmailSubjectByLink is allowed only <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
    pub fn email_subject_by_link(&self) -> std::option::Option<&str> {
        self.email_subject_by_link.as_deref()
    }
    /// <p>The default email option.</p>
    pub fn default_email_option(
        &self,
    ) -> std::option::Option<&crate::model::DefaultEmailOptionType> {
        self.default_email_option.as_ref()
    }
}
impl std::fmt::Debug for VerificationMessageTemplateType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerificationMessageTemplateType");
        formatter.field("sms_message", &self.sms_message);
        formatter.field("email_message", &self.email_message);
        formatter.field("email_subject", &self.email_subject);
        formatter.field("email_message_by_link", &self.email_message_by_link);
        formatter.field("email_subject_by_link", &self.email_subject_by_link);
        formatter.field("default_email_option", &self.default_email_option);
        formatter.finish()
    }
}
/// See [`VerificationMessageTemplateType`](crate::model::VerificationMessageTemplateType)
pub mod verification_message_template_type {
    /// A builder for [`VerificationMessageTemplateType`](crate::model::VerificationMessageTemplateType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_message: std::option::Option<std::string::String>,
        pub(crate) email_message: std::option::Option<std::string::String>,
        pub(crate) email_subject: std::option::Option<std::string::String>,
        pub(crate) email_message_by_link: std::option::Option<std::string::String>,
        pub(crate) email_subject_by_link: std::option::Option<std::string::String>,
        pub(crate) default_email_option: std::option::Option<crate::model::DefaultEmailOptionType>,
    }
    impl Builder {
        /// <p>The SMS message template.</p>
        pub fn sms_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_message = Some(input.into());
            self
        }
        /// <p>The SMS message template.</p>
        pub fn set_sms_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sms_message = input;
            self
        }
        /// <p>The email message template. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_message = Some(input.into());
            self
        }
        /// <p>The email message template. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_message = input;
            self
        }
        /// <p>The subject line for the email message template. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_subject = Some(input.into());
            self
        }
        /// <p>The subject line for the email message template. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_subject = input;
            self
        }
        /// <p>The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
        pub fn email_message_by_link(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_message_by_link = Some(input.into());
            self
        }
        /// <p>The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
        pub fn set_email_message_by_link(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_message_by_link = input;
            self
        }
        /// <p>The subject line for the email message template for sending a confirmation link to the user. EmailSubjectByLink is allowed only <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
        pub fn email_subject_by_link(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_subject_by_link = Some(input.into());
            self
        }
        /// <p>The subject line for the email message template for sending a confirmation link to the user. EmailSubjectByLink is allowed only <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>
        pub fn set_email_subject_by_link(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_subject_by_link = input;
            self
        }
        /// <p>The default email option.</p>
        pub fn default_email_option(mut self, input: crate::model::DefaultEmailOptionType) -> Self {
            self.default_email_option = Some(input);
            self
        }
        /// <p>The default email option.</p>
        pub fn set_default_email_option(
            mut self,
            input: std::option::Option<crate::model::DefaultEmailOptionType>,
        ) -> Self {
            self.default_email_option = input;
            self
        }
        /// Consumes the builder and constructs a [`VerificationMessageTemplateType`](crate::model::VerificationMessageTemplateType)
        pub fn build(self) -> crate::model::VerificationMessageTemplateType {
            crate::model::VerificationMessageTemplateType {
                sms_message: self.sms_message,
                email_message: self.email_message,
                email_subject: self.email_subject,
                email_message_by_link: self.email_message_by_link,
                email_subject_by_link: self.email_subject_by_link,
                default_email_option: self.default_email_option,
            }
        }
    }
}
impl VerificationMessageTemplateType {
    /// Creates a new builder-style object to manufacture [`VerificationMessageTemplateType`](crate::model::VerificationMessageTemplateType)
    pub fn builder() -> crate::model::verification_message_template_type::Builder {
        crate::model::verification_message_template_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DefaultEmailOptionType {
    #[allow(missing_docs)] // documentation missing in model
    ConfirmWithCode,
    #[allow(missing_docs)] // documentation missing in model
    ConfirmWithLink,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DefaultEmailOptionType {
    fn from(s: &str) -> Self {
        match s {
            "CONFIRM_WITH_CODE" => DefaultEmailOptionType::ConfirmWithCode,
            "CONFIRM_WITH_LINK" => DefaultEmailOptionType::ConfirmWithLink,
            other => DefaultEmailOptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DefaultEmailOptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DefaultEmailOptionType::from(s))
    }
}
impl DefaultEmailOptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DefaultEmailOptionType::ConfirmWithCode => "CONFIRM_WITH_CODE",
            DefaultEmailOptionType::ConfirmWithLink => "CONFIRM_WITH_LINK",
            DefaultEmailOptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONFIRM_WITH_CODE", "CONFIRM_WITH_LINK"]
    }
}
impl AsRef<str> for DefaultEmailOptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VerifiedAttributeType {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VerifiedAttributeType {
    fn from(s: &str) -> Self {
        match s {
            "email" => VerifiedAttributeType::Email,
            "phone_number" => VerifiedAttributeType::PhoneNumber,
            other => VerifiedAttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VerifiedAttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VerifiedAttributeType::from(s))
    }
}
impl VerifiedAttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VerifiedAttributeType::Email => "email",
            VerifiedAttributeType::PhoneNumber => "phone_number",
            VerifiedAttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["email", "phone_number"]
    }
}
impl AsRef<str> for VerifiedAttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the configuration for Lambda triggers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaConfigType {
    /// <p>A pre-registration Lambda trigger.</p>
    pub pre_sign_up: std::option::Option<std::string::String>,
    /// <p>A custom Message Lambda trigger.</p>
    pub custom_message: std::option::Option<std::string::String>,
    /// <p>A post-confirmation Lambda trigger.</p>
    pub post_confirmation: std::option::Option<std::string::String>,
    /// <p>A pre-authentication Lambda trigger.</p>
    pub pre_authentication: std::option::Option<std::string::String>,
    /// <p>A post-authentication Lambda trigger.</p>
    pub post_authentication: std::option::Option<std::string::String>,
    /// <p>Defines the authentication challenge.</p>
    pub define_auth_challenge: std::option::Option<std::string::String>,
    /// <p>Creates an authentication challenge.</p>
    pub create_auth_challenge: std::option::Option<std::string::String>,
    /// <p>Verifies the authentication challenge response.</p>
    pub verify_auth_challenge_response: std::option::Option<std::string::String>,
    /// <p>A Lambda trigger that is invoked before token generation.</p>
    pub pre_token_generation: std::option::Option<std::string::String>,
    /// <p>The user migration Lambda config type.</p>
    pub user_migration: std::option::Option<std::string::String>,
    /// <p>A custom SMS sender Lambda trigger.</p>
    pub custom_sms_sender: std::option::Option<crate::model::CustomSmsLambdaVersionConfigType>,
    /// <p>A custom email sender Lambda trigger.</p>
    pub custom_email_sender: std::option::Option<crate::model::CustomEmailLambdaVersionConfigType>,
    /// <p>The Amazon Resource Name (ARN) of an <a href="/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl LambdaConfigType {
    /// <p>A pre-registration Lambda trigger.</p>
    pub fn pre_sign_up(&self) -> std::option::Option<&str> {
        self.pre_sign_up.as_deref()
    }
    /// <p>A custom Message Lambda trigger.</p>
    pub fn custom_message(&self) -> std::option::Option<&str> {
        self.custom_message.as_deref()
    }
    /// <p>A post-confirmation Lambda trigger.</p>
    pub fn post_confirmation(&self) -> std::option::Option<&str> {
        self.post_confirmation.as_deref()
    }
    /// <p>A pre-authentication Lambda trigger.</p>
    pub fn pre_authentication(&self) -> std::option::Option<&str> {
        self.pre_authentication.as_deref()
    }
    /// <p>A post-authentication Lambda trigger.</p>
    pub fn post_authentication(&self) -> std::option::Option<&str> {
        self.post_authentication.as_deref()
    }
    /// <p>Defines the authentication challenge.</p>
    pub fn define_auth_challenge(&self) -> std::option::Option<&str> {
        self.define_auth_challenge.as_deref()
    }
    /// <p>Creates an authentication challenge.</p>
    pub fn create_auth_challenge(&self) -> std::option::Option<&str> {
        self.create_auth_challenge.as_deref()
    }
    /// <p>Verifies the authentication challenge response.</p>
    pub fn verify_auth_challenge_response(&self) -> std::option::Option<&str> {
        self.verify_auth_challenge_response.as_deref()
    }
    /// <p>A Lambda trigger that is invoked before token generation.</p>
    pub fn pre_token_generation(&self) -> std::option::Option<&str> {
        self.pre_token_generation.as_deref()
    }
    /// <p>The user migration Lambda config type.</p>
    pub fn user_migration(&self) -> std::option::Option<&str> {
        self.user_migration.as_deref()
    }
    /// <p>A custom SMS sender Lambda trigger.</p>
    pub fn custom_sms_sender(
        &self,
    ) -> std::option::Option<&crate::model::CustomSmsLambdaVersionConfigType> {
        self.custom_sms_sender.as_ref()
    }
    /// <p>A custom email sender Lambda trigger.</p>
    pub fn custom_email_sender(
        &self,
    ) -> std::option::Option<&crate::model::CustomEmailLambdaVersionConfigType> {
        self.custom_email_sender.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an <a href="/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for LambdaConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaConfigType");
        formatter.field("pre_sign_up", &self.pre_sign_up);
        formatter.field("custom_message", &self.custom_message);
        formatter.field("post_confirmation", &self.post_confirmation);
        formatter.field("pre_authentication", &self.pre_authentication);
        formatter.field("post_authentication", &self.post_authentication);
        formatter.field("define_auth_challenge", &self.define_auth_challenge);
        formatter.field("create_auth_challenge", &self.create_auth_challenge);
        formatter.field(
            "verify_auth_challenge_response",
            &self.verify_auth_challenge_response,
        );
        formatter.field("pre_token_generation", &self.pre_token_generation);
        formatter.field("user_migration", &self.user_migration);
        formatter.field("custom_sms_sender", &self.custom_sms_sender);
        formatter.field("custom_email_sender", &self.custom_email_sender);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`LambdaConfigType`](crate::model::LambdaConfigType)
pub mod lambda_config_type {
    /// A builder for [`LambdaConfigType`](crate::model::LambdaConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pre_sign_up: std::option::Option<std::string::String>,
        pub(crate) custom_message: std::option::Option<std::string::String>,
        pub(crate) post_confirmation: std::option::Option<std::string::String>,
        pub(crate) pre_authentication: std::option::Option<std::string::String>,
        pub(crate) post_authentication: std::option::Option<std::string::String>,
        pub(crate) define_auth_challenge: std::option::Option<std::string::String>,
        pub(crate) create_auth_challenge: std::option::Option<std::string::String>,
        pub(crate) verify_auth_challenge_response: std::option::Option<std::string::String>,
        pub(crate) pre_token_generation: std::option::Option<std::string::String>,
        pub(crate) user_migration: std::option::Option<std::string::String>,
        pub(crate) custom_sms_sender:
            std::option::Option<crate::model::CustomSmsLambdaVersionConfigType>,
        pub(crate) custom_email_sender:
            std::option::Option<crate::model::CustomEmailLambdaVersionConfigType>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A pre-registration Lambda trigger.</p>
        pub fn pre_sign_up(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_sign_up = Some(input.into());
            self
        }
        /// <p>A pre-registration Lambda trigger.</p>
        pub fn set_pre_sign_up(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pre_sign_up = input;
            self
        }
        /// <p>A custom Message Lambda trigger.</p>
        pub fn custom_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_message = Some(input.into());
            self
        }
        /// <p>A custom Message Lambda trigger.</p>
        pub fn set_custom_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_message = input;
            self
        }
        /// <p>A post-confirmation Lambda trigger.</p>
        pub fn post_confirmation(mut self, input: impl Into<std::string::String>) -> Self {
            self.post_confirmation = Some(input.into());
            self
        }
        /// <p>A post-confirmation Lambda trigger.</p>
        pub fn set_post_confirmation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.post_confirmation = input;
            self
        }
        /// <p>A pre-authentication Lambda trigger.</p>
        pub fn pre_authentication(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_authentication = Some(input.into());
            self
        }
        /// <p>A pre-authentication Lambda trigger.</p>
        pub fn set_pre_authentication(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_authentication = input;
            self
        }
        /// <p>A post-authentication Lambda trigger.</p>
        pub fn post_authentication(mut self, input: impl Into<std::string::String>) -> Self {
            self.post_authentication = Some(input.into());
            self
        }
        /// <p>A post-authentication Lambda trigger.</p>
        pub fn set_post_authentication(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.post_authentication = input;
            self
        }
        /// <p>Defines the authentication challenge.</p>
        pub fn define_auth_challenge(mut self, input: impl Into<std::string::String>) -> Self {
            self.define_auth_challenge = Some(input.into());
            self
        }
        /// <p>Defines the authentication challenge.</p>
        pub fn set_define_auth_challenge(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.define_auth_challenge = input;
            self
        }
        /// <p>Creates an authentication challenge.</p>
        pub fn create_auth_challenge(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_auth_challenge = Some(input.into());
            self
        }
        /// <p>Creates an authentication challenge.</p>
        pub fn set_create_auth_challenge(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.create_auth_challenge = input;
            self
        }
        /// <p>Verifies the authentication challenge response.</p>
        pub fn verify_auth_challenge_response(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.verify_auth_challenge_response = Some(input.into());
            self
        }
        /// <p>Verifies the authentication challenge response.</p>
        pub fn set_verify_auth_challenge_response(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verify_auth_challenge_response = input;
            self
        }
        /// <p>A Lambda trigger that is invoked before token generation.</p>
        pub fn pre_token_generation(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_token_generation = Some(input.into());
            self
        }
        /// <p>A Lambda trigger that is invoked before token generation.</p>
        pub fn set_pre_token_generation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_token_generation = input;
            self
        }
        /// <p>The user migration Lambda config type.</p>
        pub fn user_migration(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_migration = Some(input.into());
            self
        }
        /// <p>The user migration Lambda config type.</p>
        pub fn set_user_migration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_migration = input;
            self
        }
        /// <p>A custom SMS sender Lambda trigger.</p>
        pub fn custom_sms_sender(
            mut self,
            input: crate::model::CustomSmsLambdaVersionConfigType,
        ) -> Self {
            self.custom_sms_sender = Some(input);
            self
        }
        /// <p>A custom SMS sender Lambda trigger.</p>
        pub fn set_custom_sms_sender(
            mut self,
            input: std::option::Option<crate::model::CustomSmsLambdaVersionConfigType>,
        ) -> Self {
            self.custom_sms_sender = input;
            self
        }
        /// <p>A custom email sender Lambda trigger.</p>
        pub fn custom_email_sender(
            mut self,
            input: crate::model::CustomEmailLambdaVersionConfigType,
        ) -> Self {
            self.custom_email_sender = Some(input);
            self
        }
        /// <p>A custom email sender Lambda trigger.</p>
        pub fn set_custom_email_sender(
            mut self,
            input: std::option::Option<crate::model::CustomEmailLambdaVersionConfigType>,
        ) -> Self {
            self.custom_email_sender = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an <a href="/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an <a href="/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaConfigType`](crate::model::LambdaConfigType)
        pub fn build(self) -> crate::model::LambdaConfigType {
            crate::model::LambdaConfigType {
                pre_sign_up: self.pre_sign_up,
                custom_message: self.custom_message,
                post_confirmation: self.post_confirmation,
                pre_authentication: self.pre_authentication,
                post_authentication: self.post_authentication,
                define_auth_challenge: self.define_auth_challenge,
                create_auth_challenge: self.create_auth_challenge,
                verify_auth_challenge_response: self.verify_auth_challenge_response,
                pre_token_generation: self.pre_token_generation,
                user_migration: self.user_migration,
                custom_sms_sender: self.custom_sms_sender,
                custom_email_sender: self.custom_email_sender,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl LambdaConfigType {
    /// Creates a new builder-style object to manufacture [`LambdaConfigType`](crate::model::LambdaConfigType)
    pub fn builder() -> crate::model::lambda_config_type::Builder {
        crate::model::lambda_config_type::Builder::default()
    }
}

/// <p>A custom email sender Lambda configuration type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomEmailLambdaVersionConfigType {
    /// <p>Signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is <code>V1_0</code>.</p>
    pub lambda_version: std::option::Option<crate::model::CustomEmailSenderLambdaVersionType>,
    /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send email notifications to users.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
}
impl CustomEmailLambdaVersionConfigType {
    /// <p>Signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is <code>V1_0</code>.</p>
    pub fn lambda_version(
        &self,
    ) -> std::option::Option<&crate::model::CustomEmailSenderLambdaVersionType> {
        self.lambda_version.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send email notifications to users.</p>
    pub fn lambda_arn(&self) -> std::option::Option<&str> {
        self.lambda_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomEmailLambdaVersionConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomEmailLambdaVersionConfigType");
        formatter.field("lambda_version", &self.lambda_version);
        formatter.field("lambda_arn", &self.lambda_arn);
        formatter.finish()
    }
}
/// See [`CustomEmailLambdaVersionConfigType`](crate::model::CustomEmailLambdaVersionConfigType)
pub mod custom_email_lambda_version_config_type {
    /// A builder for [`CustomEmailLambdaVersionConfigType`](crate::model::CustomEmailLambdaVersionConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_version:
            std::option::Option<crate::model::CustomEmailSenderLambdaVersionType>,
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is <code>V1_0</code>.</p>
        pub fn lambda_version(
            mut self,
            input: crate::model::CustomEmailSenderLambdaVersionType,
        ) -> Self {
            self.lambda_version = Some(input);
            self
        }
        /// <p>Signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is <code>V1_0</code>.</p>
        pub fn set_lambda_version(
            mut self,
            input: std::option::Option<crate::model::CustomEmailSenderLambdaVersionType>,
        ) -> Self {
            self.lambda_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send email notifications to users.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send email notifications to users.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomEmailLambdaVersionConfigType`](crate::model::CustomEmailLambdaVersionConfigType)
        pub fn build(self) -> crate::model::CustomEmailLambdaVersionConfigType {
            crate::model::CustomEmailLambdaVersionConfigType {
                lambda_version: self.lambda_version,
                lambda_arn: self.lambda_arn,
            }
        }
    }
}
impl CustomEmailLambdaVersionConfigType {
    /// Creates a new builder-style object to manufacture [`CustomEmailLambdaVersionConfigType`](crate::model::CustomEmailLambdaVersionConfigType)
    pub fn builder() -> crate::model::custom_email_lambda_version_config_type::Builder {
        crate::model::custom_email_lambda_version_config_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomEmailSenderLambdaVersionType {
    #[allow(missing_docs)] // documentation missing in model
    V10,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomEmailSenderLambdaVersionType {
    fn from(s: &str) -> Self {
        match s {
            "V1_0" => CustomEmailSenderLambdaVersionType::V10,
            other => CustomEmailSenderLambdaVersionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomEmailSenderLambdaVersionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomEmailSenderLambdaVersionType::from(s))
    }
}
impl CustomEmailSenderLambdaVersionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomEmailSenderLambdaVersionType::V10 => "V1_0",
            CustomEmailSenderLambdaVersionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V1_0"]
    }
}
impl AsRef<str> for CustomEmailSenderLambdaVersionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A custom SMS sender Lambda configuration type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomSmsLambdaVersionConfigType {
    /// <p>Signature of the "request" attribute in the "event" information that Amazon Cognito passes to your custom SMS Lambda function. The only supported value is <code>V1_0</code>.</p>
    pub lambda_version: std::option::Option<crate::model::CustomSmsSenderLambdaVersionType>,
    /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send SMS notifications to users.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
}
impl CustomSmsLambdaVersionConfigType {
    /// <p>Signature of the "request" attribute in the "event" information that Amazon Cognito passes to your custom SMS Lambda function. The only supported value is <code>V1_0</code>.</p>
    pub fn lambda_version(
        &self,
    ) -> std::option::Option<&crate::model::CustomSmsSenderLambdaVersionType> {
        self.lambda_version.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send SMS notifications to users.</p>
    pub fn lambda_arn(&self) -> std::option::Option<&str> {
        self.lambda_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomSmsLambdaVersionConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomSmsLambdaVersionConfigType");
        formatter.field("lambda_version", &self.lambda_version);
        formatter.field("lambda_arn", &self.lambda_arn);
        formatter.finish()
    }
}
/// See [`CustomSmsLambdaVersionConfigType`](crate::model::CustomSmsLambdaVersionConfigType)
pub mod custom_sms_lambda_version_config_type {
    /// A builder for [`CustomSmsLambdaVersionConfigType`](crate::model::CustomSmsLambdaVersionConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_version:
            std::option::Option<crate::model::CustomSmsSenderLambdaVersionType>,
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Signature of the "request" attribute in the "event" information that Amazon Cognito passes to your custom SMS Lambda function. The only supported value is <code>V1_0</code>.</p>
        pub fn lambda_version(
            mut self,
            input: crate::model::CustomSmsSenderLambdaVersionType,
        ) -> Self {
            self.lambda_version = Some(input);
            self
        }
        /// <p>Signature of the "request" attribute in the "event" information that Amazon Cognito passes to your custom SMS Lambda function. The only supported value is <code>V1_0</code>.</p>
        pub fn set_lambda_version(
            mut self,
            input: std::option::Option<crate::model::CustomSmsSenderLambdaVersionType>,
        ) -> Self {
            self.lambda_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send SMS notifications to users.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send SMS notifications to users.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomSmsLambdaVersionConfigType`](crate::model::CustomSmsLambdaVersionConfigType)
        pub fn build(self) -> crate::model::CustomSmsLambdaVersionConfigType {
            crate::model::CustomSmsLambdaVersionConfigType {
                lambda_version: self.lambda_version,
                lambda_arn: self.lambda_arn,
            }
        }
    }
}
impl CustomSmsLambdaVersionConfigType {
    /// Creates a new builder-style object to manufacture [`CustomSmsLambdaVersionConfigType`](crate::model::CustomSmsLambdaVersionConfigType)
    pub fn builder() -> crate::model::custom_sms_lambda_version_config_type::Builder {
        crate::model::custom_sms_lambda_version_config_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomSmsSenderLambdaVersionType {
    #[allow(missing_docs)] // documentation missing in model
    V10,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomSmsSenderLambdaVersionType {
    fn from(s: &str) -> Self {
        match s {
            "V1_0" => CustomSmsSenderLambdaVersionType::V10,
            other => CustomSmsSenderLambdaVersionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomSmsSenderLambdaVersionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomSmsSenderLambdaVersionType::from(s))
    }
}
impl CustomSmsSenderLambdaVersionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomSmsSenderLambdaVersionType::V10 => "V1_0",
            CustomSmsSenderLambdaVersionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V1_0"]
    }
}
impl AsRef<str> for CustomSmsSenderLambdaVersionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The policy associated with a user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolPolicyType {
    /// <p>The password policy.</p>
    pub password_policy: std::option::Option<crate::model::PasswordPolicyType>,
}
impl UserPoolPolicyType {
    /// <p>The password policy.</p>
    pub fn password_policy(&self) -> std::option::Option<&crate::model::PasswordPolicyType> {
        self.password_policy.as_ref()
    }
}
impl std::fmt::Debug for UserPoolPolicyType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolPolicyType");
        formatter.field("password_policy", &self.password_policy);
        formatter.finish()
    }
}
/// See [`UserPoolPolicyType`](crate::model::UserPoolPolicyType)
pub mod user_pool_policy_type {
    /// A builder for [`UserPoolPolicyType`](crate::model::UserPoolPolicyType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) password_policy: std::option::Option<crate::model::PasswordPolicyType>,
    }
    impl Builder {
        /// <p>The password policy.</p>
        pub fn password_policy(mut self, input: crate::model::PasswordPolicyType) -> Self {
            self.password_policy = Some(input);
            self
        }
        /// <p>The password policy.</p>
        pub fn set_password_policy(
            mut self,
            input: std::option::Option<crate::model::PasswordPolicyType>,
        ) -> Self {
            self.password_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolPolicyType`](crate::model::UserPoolPolicyType)
        pub fn build(self) -> crate::model::UserPoolPolicyType {
            crate::model::UserPoolPolicyType {
                password_policy: self.password_policy,
            }
        }
    }
}
impl UserPoolPolicyType {
    /// Creates a new builder-style object to manufacture [`UserPoolPolicyType`](crate::model::UserPoolPolicyType)
    pub fn builder() -> crate::model::user_pool_policy_type::Builder {
        crate::model::user_pool_policy_type::Builder::default()
    }
}

/// <p>The password policy type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PasswordPolicyType {
    /// <p>The minimum length of the password in the policy that you have set. This value can't be less than 6.</p>
    pub minimum_length: i32,
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.</p>
    pub require_uppercase: bool,
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.</p>
    pub require_lowercase: bool,
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one number in their password.</p>
    pub require_numbers: bool,
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.</p>
    pub require_symbols: bool,
    /// <p>The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password.</p> <note>
    /// <p>When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set the deprecated <code>UnusedAccountValidityDays</code> value for that user pool.</p>
    /// </note>
    pub temporary_password_validity_days: i32,
}
impl PasswordPolicyType {
    /// <p>The minimum length of the password in the policy that you have set. This value can't be less than 6.</p>
    pub fn minimum_length(&self) -> i32 {
        self.minimum_length
    }
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.</p>
    pub fn require_uppercase(&self) -> bool {
        self.require_uppercase
    }
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.</p>
    pub fn require_lowercase(&self) -> bool {
        self.require_lowercase
    }
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one number in their password.</p>
    pub fn require_numbers(&self) -> bool {
        self.require_numbers
    }
    /// <p>In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.</p>
    pub fn require_symbols(&self) -> bool {
        self.require_symbols
    }
    /// <p>The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password.</p> <note>
    /// <p>When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set the deprecated <code>UnusedAccountValidityDays</code> value for that user pool.</p>
    /// </note>
    pub fn temporary_password_validity_days(&self) -> i32 {
        self.temporary_password_validity_days
    }
}
impl std::fmt::Debug for PasswordPolicyType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PasswordPolicyType");
        formatter.field("minimum_length", &self.minimum_length);
        formatter.field("require_uppercase", &self.require_uppercase);
        formatter.field("require_lowercase", &self.require_lowercase);
        formatter.field("require_numbers", &self.require_numbers);
        formatter.field("require_symbols", &self.require_symbols);
        formatter.field(
            "temporary_password_validity_days",
            &self.temporary_password_validity_days,
        );
        formatter.finish()
    }
}
/// See [`PasswordPolicyType`](crate::model::PasswordPolicyType)
pub mod password_policy_type {
    /// A builder for [`PasswordPolicyType`](crate::model::PasswordPolicyType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_length: std::option::Option<i32>,
        pub(crate) require_uppercase: std::option::Option<bool>,
        pub(crate) require_lowercase: std::option::Option<bool>,
        pub(crate) require_numbers: std::option::Option<bool>,
        pub(crate) require_symbols: std::option::Option<bool>,
        pub(crate) temporary_password_validity_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum length of the password in the policy that you have set. This value can't be less than 6.</p>
        pub fn minimum_length(mut self, input: i32) -> Self {
            self.minimum_length = Some(input);
            self
        }
        /// <p>The minimum length of the password in the policy that you have set. This value can't be less than 6.</p>
        pub fn set_minimum_length(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_length = input;
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.</p>
        pub fn require_uppercase(mut self, input: bool) -> Self {
            self.require_uppercase = Some(input);
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.</p>
        pub fn set_require_uppercase(mut self, input: std::option::Option<bool>) -> Self {
            self.require_uppercase = input;
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.</p>
        pub fn require_lowercase(mut self, input: bool) -> Self {
            self.require_lowercase = Some(input);
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.</p>
        pub fn set_require_lowercase(mut self, input: std::option::Option<bool>) -> Self {
            self.require_lowercase = input;
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one number in their password.</p>
        pub fn require_numbers(mut self, input: bool) -> Self {
            self.require_numbers = Some(input);
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one number in their password.</p>
        pub fn set_require_numbers(mut self, input: std::option::Option<bool>) -> Self {
            self.require_numbers = input;
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.</p>
        pub fn require_symbols(mut self, input: bool) -> Self {
            self.require_symbols = Some(input);
            self
        }
        /// <p>In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.</p>
        pub fn set_require_symbols(mut self, input: std::option::Option<bool>) -> Self {
            self.require_symbols = input;
            self
        }
        /// <p>The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password.</p> <note>
        /// <p>When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set the deprecated <code>UnusedAccountValidityDays</code> value for that user pool.</p>
        /// </note>
        pub fn temporary_password_validity_days(mut self, input: i32) -> Self {
            self.temporary_password_validity_days = Some(input);
            self
        }
        /// <p>The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password.</p> <note>
        /// <p>When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set the deprecated <code>UnusedAccountValidityDays</code> value for that user pool.</p>
        /// </note>
        pub fn set_temporary_password_validity_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.temporary_password_validity_days = input;
            self
        }
        /// Consumes the builder and constructs a [`PasswordPolicyType`](crate::model::PasswordPolicyType)
        pub fn build(self) -> crate::model::PasswordPolicyType {
            crate::model::PasswordPolicyType {
                minimum_length: self.minimum_length.unwrap_or_default(),
                require_uppercase: self.require_uppercase.unwrap_or_default(),
                require_lowercase: self.require_lowercase.unwrap_or_default(),
                require_numbers: self.require_numbers.unwrap_or_default(),
                require_symbols: self.require_symbols.unwrap_or_default(),
                temporary_password_validity_days: self
                    .temporary_password_validity_days
                    .unwrap_or_default(),
            }
        }
    }
}
impl PasswordPolicyType {
    /// Creates a new builder-style object to manufacture [`PasswordPolicyType`](crate::model::PasswordPolicyType)
    pub fn builder() -> crate::model::password_policy_type::Builder {
        crate::model::password_policy_type::Builder::default()
    }
}

/// <p>The code delivery details being returned from the server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeDeliveryDetailsType {
    /// <p>The destination for the code delivery details.</p>
    pub destination: std::option::Option<std::string::String>,
    /// <p>The delivery medium (email message or phone number).</p>
    pub delivery_medium: std::option::Option<crate::model::DeliveryMediumType>,
    /// <p>The attribute name.</p>
    pub attribute_name: std::option::Option<std::string::String>,
}
impl CodeDeliveryDetailsType {
    /// <p>The destination for the code delivery details.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
    /// <p>The delivery medium (email message or phone number).</p>
    pub fn delivery_medium(&self) -> std::option::Option<&crate::model::DeliveryMediumType> {
        self.delivery_medium.as_ref()
    }
    /// <p>The attribute name.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
}
impl std::fmt::Debug for CodeDeliveryDetailsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeDeliveryDetailsType");
        formatter.field("destination", &self.destination);
        formatter.field("delivery_medium", &self.delivery_medium);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.finish()
    }
}
/// See [`CodeDeliveryDetailsType`](crate::model::CodeDeliveryDetailsType)
pub mod code_delivery_details_type {
    /// A builder for [`CodeDeliveryDetailsType`](crate::model::CodeDeliveryDetailsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) delivery_medium: std::option::Option<crate::model::DeliveryMediumType>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The destination for the code delivery details.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The destination for the code delivery details.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The delivery medium (email message or phone number).</p>
        pub fn delivery_medium(mut self, input: crate::model::DeliveryMediumType) -> Self {
            self.delivery_medium = Some(input);
            self
        }
        /// <p>The delivery medium (email message or phone number).</p>
        pub fn set_delivery_medium(
            mut self,
            input: std::option::Option<crate::model::DeliveryMediumType>,
        ) -> Self {
            self.delivery_medium = input;
            self
        }
        /// <p>The attribute name.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The attribute name.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeDeliveryDetailsType`](crate::model::CodeDeliveryDetailsType)
        pub fn build(self) -> crate::model::CodeDeliveryDetailsType {
            crate::model::CodeDeliveryDetailsType {
                destination: self.destination,
                delivery_medium: self.delivery_medium,
                attribute_name: self.attribute_name,
            }
        }
    }
}
impl CodeDeliveryDetailsType {
    /// Creates a new builder-style object to manufacture [`CodeDeliveryDetailsType`](crate::model::CodeDeliveryDetailsType)
    pub fn builder() -> crate::model::code_delivery_details_type::Builder {
        crate::model::code_delivery_details_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliveryMediumType {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliveryMediumType {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL" => DeliveryMediumType::Email,
            "SMS" => DeliveryMediumType::Sms,
            other => DeliveryMediumType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliveryMediumType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliveryMediumType::from(s))
    }
}
impl DeliveryMediumType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliveryMediumType::Email => "EMAIL",
            DeliveryMediumType::Sms => "SMS",
            DeliveryMediumType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMAIL", "SMS"]
    }
}
impl AsRef<str> for DeliveryMediumType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies whether the attribute is standard or custom.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeType {
    /// <p>The name of the attribute.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the attribute.</p>
    pub value: std::option::Option<std::string::String>,
}
impl AttributeType {
    /// <p>The name of the attribute.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the attribute.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for AttributeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeType");
        formatter.field("name", &self.name);
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AttributeType`](crate::model::AttributeType)
pub mod attribute_type {
    /// A builder for [`AttributeType`](crate::model::AttributeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeType`](crate::model::AttributeType)
        pub fn build(self) -> crate::model::AttributeType {
            crate::model::AttributeType {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl AttributeType {
    /// Creates a new builder-style object to manufacture [`AttributeType`](crate::model::AttributeType)
    pub fn builder() -> crate::model::attribute_type::Builder {
        crate::model::attribute_type::Builder::default()
    }
}

/// <p>A container for information about a resource server for a user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceServerType {
    /// <p>The user pool ID for the user pool that hosts the resource server.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the resource server.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The name of the resource server.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of scopes that are defined for the resource server.</p>
    pub scopes: std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
}
impl ResourceServerType {
    /// <p>The user pool ID for the user pool that hosts the resource server.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The identifier for the resource server.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The name of the resource server.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of scopes that are defined for the resource server.</p>
    pub fn scopes(&self) -> std::option::Option<&[crate::model::ResourceServerScopeType]> {
        self.scopes.as_deref()
    }
}
impl std::fmt::Debug for ResourceServerType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceServerType");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("identifier", &self.identifier);
        formatter.field("name", &self.name);
        formatter.field("scopes", &self.scopes);
        formatter.finish()
    }
}
/// See [`ResourceServerType`](crate::model::ResourceServerType)
pub mod resource_server_type {
    /// A builder for [`ResourceServerType`](crate::model::ResourceServerType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) scopes:
            std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The name of the resource server.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource server.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `scopes`.
        ///
        /// To override the contents of this collection use [`set_scopes`](Self::set_scopes).
        ///
        /// <p>A list of scopes that are defined for the resource server.</p>
        pub fn scopes(mut self, input: crate::model::ResourceServerScopeType) -> Self {
            let mut v = self.scopes.unwrap_or_default();
            v.push(input);
            self.scopes = Some(v);
            self
        }
        /// <p>A list of scopes that are defined for the resource server.</p>
        pub fn set_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
        ) -> Self {
            self.scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceServerType`](crate::model::ResourceServerType)
        pub fn build(self) -> crate::model::ResourceServerType {
            crate::model::ResourceServerType {
                user_pool_id: self.user_pool_id,
                identifier: self.identifier,
                name: self.name,
                scopes: self.scopes,
            }
        }
    }
}
impl ResourceServerType {
    /// Creates a new builder-style object to manufacture [`ResourceServerType`](crate::model::ResourceServerType)
    pub fn builder() -> crate::model::resource_server_type::Builder {
        crate::model::resource_server_type::Builder::default()
    }
}

/// <p>A resource server scope.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceServerScopeType {
    /// <p>The name of the scope.</p>
    pub scope_name: std::option::Option<std::string::String>,
    /// <p>A description of the scope.</p>
    pub scope_description: std::option::Option<std::string::String>,
}
impl ResourceServerScopeType {
    /// <p>The name of the scope.</p>
    pub fn scope_name(&self) -> std::option::Option<&str> {
        self.scope_name.as_deref()
    }
    /// <p>A description of the scope.</p>
    pub fn scope_description(&self) -> std::option::Option<&str> {
        self.scope_description.as_deref()
    }
}
impl std::fmt::Debug for ResourceServerScopeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceServerScopeType");
        formatter.field("scope_name", &self.scope_name);
        formatter.field("scope_description", &self.scope_description);
        formatter.finish()
    }
}
/// See [`ResourceServerScopeType`](crate::model::ResourceServerScopeType)
pub mod resource_server_scope_type {
    /// A builder for [`ResourceServerScopeType`](crate::model::ResourceServerScopeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scope_name: std::option::Option<std::string::String>,
        pub(crate) scope_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scope.</p>
        pub fn scope_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scope_name = Some(input.into());
            self
        }
        /// <p>The name of the scope.</p>
        pub fn set_scope_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scope_name = input;
            self
        }
        /// <p>A description of the scope.</p>
        pub fn scope_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.scope_description = Some(input.into());
            self
        }
        /// <p>A description of the scope.</p>
        pub fn set_scope_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scope_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceServerScopeType`](crate::model::ResourceServerScopeType)
        pub fn build(self) -> crate::model::ResourceServerScopeType {
            crate::model::ResourceServerScopeType {
                scope_name: self.scope_name,
                scope_description: self.scope_description,
            }
        }
    }
}
impl ResourceServerScopeType {
    /// Creates a new builder-style object to manufacture [`ResourceServerScopeType`](crate::model::ResourceServerScopeType)
    pub fn builder() -> crate::model::resource_server_scope_type::Builder {
        crate::model::resource_server_scope_type::Builder::default()
    }
}

/// <p>A container for information about an identity provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityProviderType {
    /// <p>The user pool ID.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The identity provider name.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The identity provider type.</p>
    pub provider_type: std::option::Option<crate::model::IdentityProviderTypeType>,
    /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
    /// <ul>
    /// <li> <p>For Google and Login with Amazon:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>client_secret</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// </ul> </li>
    /// <li> <p>For Facebook:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>client_secret</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// <li> <p>api_version</p> </li>
    /// </ul> </li>
    /// <li> <p>For Sign in with Apple:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>team_id</p> </li>
    /// <li> <p>key_id</p> </li>
    /// <li> <p>private_key</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// </ul> </li>
    /// <li> <p>For OIDC providers:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>client_secret</p> </li>
    /// <li> <p>attributes_request_method</p> </li>
    /// <li> <p>oidc_issuer</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li>
    /// </ul> </li>
    /// <li> <p>For SAML providers:</p>
    /// <ul>
    /// <li> <p>MetadataFile or MetadataURL</p> </li>
    /// <li> <p>IDPSignOut <i>optional</i> </p> </li>
    /// </ul> </li>
    /// </ul>
    pub provider_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
    pub attribute_mapping:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of identity provider identifiers.</p>
    pub idp_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date the identity provider was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the identity provider was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl IdentityProviderType {
    /// <p>The user pool ID.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The identity provider name.</p>
    pub fn provider_name(&self) -> std::option::Option<&str> {
        self.provider_name.as_deref()
    }
    /// <p>The identity provider type.</p>
    pub fn provider_type(&self) -> std::option::Option<&crate::model::IdentityProviderTypeType> {
        self.provider_type.as_ref()
    }
    /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
    /// <ul>
    /// <li> <p>For Google and Login with Amazon:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>client_secret</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// </ul> </li>
    /// <li> <p>For Facebook:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>client_secret</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// <li> <p>api_version</p> </li>
    /// </ul> </li>
    /// <li> <p>For Sign in with Apple:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>team_id</p> </li>
    /// <li> <p>key_id</p> </li>
    /// <li> <p>private_key</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// </ul> </li>
    /// <li> <p>For OIDC providers:</p>
    /// <ul>
    /// <li> <p>client_id</p> </li>
    /// <li> <p>client_secret</p> </li>
    /// <li> <p>attributes_request_method</p> </li>
    /// <li> <p>oidc_issuer</p> </li>
    /// <li> <p>authorize_scopes</p> </li>
    /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
    /// <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li>
    /// </ul> </li>
    /// <li> <p>For SAML providers:</p>
    /// <ul>
    /// <li> <p>MetadataFile or MetadataURL</p> </li>
    /// <li> <p>IDPSignOut <i>optional</i> </p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn provider_details(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.provider_details.as_ref()
    }
    /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
    pub fn attribute_mapping(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attribute_mapping.as_ref()
    }
    /// <p>A list of identity provider identifiers.</p>
    pub fn idp_identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.idp_identifiers.as_deref()
    }
    /// <p>The date the identity provider was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the identity provider was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for IdentityProviderType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityProviderType");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("provider_details", &self.provider_details);
        formatter.field("attribute_mapping", &self.attribute_mapping);
        formatter.field("idp_identifiers", &self.idp_identifiers);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`IdentityProviderType`](crate::model::IdentityProviderType)
pub mod identity_provider_type {
    /// A builder for [`IdentityProviderType`](crate::model::IdentityProviderType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::IdentityProviderTypeType>,
        pub(crate) provider_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) attribute_mapping: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) idp_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The identity provider type.</p>
        pub fn provider_type(mut self, input: crate::model::IdentityProviderTypeType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderTypeType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// Adds a key-value pair to `provider_details`.
        ///
        /// To override the contents of this collection use [`set_provider_details`](Self::set_provider_details).
        ///
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>api_version</p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>team_id</p> </li>
        /// <li> <p>key_id</p> </li>
        /// <li> <p>private_key</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>attributes_request_method</p> </li>
        /// <li> <p>oidc_issuer</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p>MetadataFile or MetadataURL</p> </li>
        /// <li> <p>IDPSignOut <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.provider_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.provider_details = Some(hash_map);
            self
        }
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>api_version</p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>team_id</p> </li>
        /// <li> <p>key_id</p> </li>
        /// <li> <p>private_key</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>attributes_request_method</p> </li>
        /// <li> <p>oidc_issuer</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p>MetadataFile or MetadataURL</p> </li>
        /// <li> <p>IDPSignOut <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.provider_details = input;
            self
        }
        /// Adds a key-value pair to `attribute_mapping`.
        ///
        /// To override the contents of this collection use [`set_attribute_mapping`](Self::set_attribute_mapping).
        ///
        /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
        pub fn attribute_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attribute_mapping.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attribute_mapping = Some(hash_map);
            self
        }
        /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
        pub fn set_attribute_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attribute_mapping = input;
            self
        }
        /// Appends an item to `idp_identifiers`.
        ///
        /// To override the contents of this collection use [`set_idp_identifiers`](Self::set_idp_identifiers).
        ///
        /// <p>A list of identity provider identifiers.</p>
        pub fn idp_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.idp_identifiers.unwrap_or_default();
            v.push(input.into());
            self.idp_identifiers = Some(v);
            self
        }
        /// <p>A list of identity provider identifiers.</p>
        pub fn set_idp_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.idp_identifiers = input;
            self
        }
        /// <p>The date the identity provider was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the identity provider was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the identity provider was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the identity provider was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityProviderType`](crate::model::IdentityProviderType)
        pub fn build(self) -> crate::model::IdentityProviderType {
            crate::model::IdentityProviderType {
                user_pool_id: self.user_pool_id,
                provider_name: self.provider_name,
                provider_type: self.provider_type,
                provider_details: self.provider_details,
                attribute_mapping: self.attribute_mapping,
                idp_identifiers: self.idp_identifiers,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
            }
        }
    }
}
impl IdentityProviderType {
    /// Creates a new builder-style object to manufacture [`IdentityProviderType`](crate::model::IdentityProviderType)
    pub fn builder() -> crate::model::identity_provider_type::Builder {
        crate::model::identity_provider_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityProviderTypeType {
    #[allow(missing_docs)] // documentation missing in model
    Facebook,
    #[allow(missing_docs)] // documentation missing in model
    Google,
    #[allow(missing_docs)] // documentation missing in model
    LoginWithAmazon,
    #[allow(missing_docs)] // documentation missing in model
    Oidc,
    #[allow(missing_docs)] // documentation missing in model
    Saml,
    #[allow(missing_docs)] // documentation missing in model
    SignInWithApple,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityProviderTypeType {
    fn from(s: &str) -> Self {
        match s {
            "Facebook" => IdentityProviderTypeType::Facebook,
            "Google" => IdentityProviderTypeType::Google,
            "LoginWithAmazon" => IdentityProviderTypeType::LoginWithAmazon,
            "OIDC" => IdentityProviderTypeType::Oidc,
            "SAML" => IdentityProviderTypeType::Saml,
            "SignInWithApple" => IdentityProviderTypeType::SignInWithApple,
            other => IdentityProviderTypeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityProviderTypeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityProviderTypeType::from(s))
    }
}
impl IdentityProviderTypeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityProviderTypeType::Facebook => "Facebook",
            IdentityProviderTypeType::Google => "Google",
            IdentityProviderTypeType::LoginWithAmazon => "LoginWithAmazon",
            IdentityProviderTypeType::Oidc => "OIDC",
            IdentityProviderTypeType::Saml => "SAML",
            IdentityProviderTypeType::SignInWithApple => "SignInWithApple",
            IdentityProviderTypeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Facebook",
            "Google",
            "LoginWithAmazon",
            "OIDC",
            "SAML",
            "SignInWithApple",
        ]
    }
}
impl AsRef<str> for IdentityProviderTypeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The group type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupType {
    /// <p>The name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The user pool ID for the user pool.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>A string containing the description of the group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The role Amazon Resource Name (ARN) for the group.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p>
    /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.</p>
    /// <p>The default <code>Precedence</code> value is null.</p>
    pub precedence: std::option::Option<i32>,
    /// <p>The date the group was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the group was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl GroupType {
    /// <p>The name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The user pool ID for the user pool.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>A string containing the description of the group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The role Amazon Resource Name (ARN) for the group.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p>
    /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.</p>
    /// <p>The default <code>Precedence</code> value is null.</p>
    pub fn precedence(&self) -> std::option::Option<i32> {
        self.precedence
    }
    /// <p>The date the group was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the group was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for GroupType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupType");
        formatter.field("group_name", &self.group_name);
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("precedence", &self.precedence);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`GroupType`](crate::model::GroupType)
pub mod group_type {
    /// A builder for [`GroupType`](crate::model::GroupType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) precedence: std::option::Option<i32>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>A string containing the description of the group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A string containing the description of the group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The role Amazon Resource Name (ARN) for the group.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role Amazon Resource Name (ARN) for the group.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p>
        /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.</p>
        /// <p>The default <code>Precedence</code> value is null.</p>
        pub fn precedence(mut self, input: i32) -> Self {
            self.precedence = Some(input);
            self
        }
        /// <p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p>
        /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.</p>
        /// <p>The default <code>Precedence</code> value is null.</p>
        pub fn set_precedence(mut self, input: std::option::Option<i32>) -> Self {
            self.precedence = input;
            self
        }
        /// <p>The date the group was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the group was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the group was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the group was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupType`](crate::model::GroupType)
        pub fn build(self) -> crate::model::GroupType {
            crate::model::GroupType {
                group_name: self.group_name,
                user_pool_id: self.user_pool_id,
                description: self.description,
                role_arn: self.role_arn,
                precedence: self.precedence,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
            }
        }
    }
}
impl GroupType {
    /// Creates a new builder-style object to manufacture [`GroupType`](crate::model::GroupType)
    pub fn builder() -> crate::model::group_type::Builder {
        crate::model::group_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceRememberedStatusType {
    #[allow(missing_docs)] // documentation missing in model
    NotRemembered,
    #[allow(missing_docs)] // documentation missing in model
    Remembered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceRememberedStatusType {
    fn from(s: &str) -> Self {
        match s {
            "not_remembered" => DeviceRememberedStatusType::NotRemembered,
            "remembered" => DeviceRememberedStatusType::Remembered,
            other => DeviceRememberedStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceRememberedStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceRememberedStatusType::from(s))
    }
}
impl DeviceRememberedStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceRememberedStatusType::NotRemembered => "not_remembered",
            DeviceRememberedStatusType::Remembered => "remembered",
            DeviceRememberedStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["not_remembered", "remembered"]
    }
}
impl AsRef<str> for DeviceRememberedStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeedbackValueType {
    #[allow(missing_docs)] // documentation missing in model
    Invalid,
    #[allow(missing_docs)] // documentation missing in model
    Valid,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeedbackValueType {
    fn from(s: &str) -> Self {
        match s {
            "Invalid" => FeedbackValueType::Invalid,
            "Valid" => FeedbackValueType::Valid,
            other => FeedbackValueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeedbackValueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeedbackValueType::from(s))
    }
}
impl FeedbackValueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeedbackValueType::Invalid => "Invalid",
            FeedbackValueType::Valid => "Valid",
            FeedbackValueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Invalid", "Valid"]
    }
}
impl AsRef<str> for FeedbackValueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The user import job type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserImportJobType {
    /// <p>The job name for the user import job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The job ID for the user import job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The user pool ID for the user pool that the users are being imported into.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The pre-signed URL to be used to upload the <code>.csv</code> file.</p>
    pub pre_signed_url: std::option::Option<std::string::String>,
    /// <p>The date the user import job was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the user import job was started.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the user import job was completed.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the user import job. One of the following:</p>
    /// <ul>
    /// <li> <p> <code>Created</code> - The job was created but not started.</p> </li>
    /// <li> <p> <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.</p> </li>
    /// <li> <p> <code>InProgress</code> - The job has started, and users are being imported.</p> </li>
    /// <li> <p> <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.</p> </li>
    /// <li> <p> <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.</p> </li>
    /// <li> <p> <code>Succeeded</code> - The job has completed successfully.</p> </li>
    /// <li> <p> <code>Failed</code> - The job has stopped due to an error.</p> </li>
    /// <li> <p> <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can't be started.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::UserImportJobStatusType>,
    /// <p>The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>The number of users that were successfully imported.</p>
    pub imported_users: i64,
    /// <p>The number of users that were skipped.</p>
    pub skipped_users: i64,
    /// <p>The number of users that couldn't be imported.</p>
    pub failed_users: i64,
    /// <p>The message returned when the user import job is completed.</p>
    pub completion_message: std::option::Option<std::string::String>,
}
impl UserImportJobType {
    /// <p>The job name for the user import job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The job ID for the user import job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The user pool ID for the user pool that the users are being imported into.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The pre-signed URL to be used to upload the <code>.csv</code> file.</p>
    pub fn pre_signed_url(&self) -> std::option::Option<&str> {
        self.pre_signed_url.as_deref()
    }
    /// <p>The date the user import job was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date when the user import job was started.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The date when the user import job was completed.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>The status of the user import job. One of the following:</p>
    /// <ul>
    /// <li> <p> <code>Created</code> - The job was created but not started.</p> </li>
    /// <li> <p> <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.</p> </li>
    /// <li> <p> <code>InProgress</code> - The job has started, and users are being imported.</p> </li>
    /// <li> <p> <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.</p> </li>
    /// <li> <p> <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.</p> </li>
    /// <li> <p> <code>Succeeded</code> - The job has completed successfully.</p> </li>
    /// <li> <p> <code>Failed</code> - The job has stopped due to an error.</p> </li>
    /// <li> <p> <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can't be started.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::UserImportJobStatusType> {
        self.status.as_ref()
    }
    /// <p>The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>The number of users that were successfully imported.</p>
    pub fn imported_users(&self) -> i64 {
        self.imported_users
    }
    /// <p>The number of users that were skipped.</p>
    pub fn skipped_users(&self) -> i64 {
        self.skipped_users
    }
    /// <p>The number of users that couldn't be imported.</p>
    pub fn failed_users(&self) -> i64 {
        self.failed_users
    }
    /// <p>The message returned when the user import job is completed.</p>
    pub fn completion_message(&self) -> std::option::Option<&str> {
        self.completion_message.as_deref()
    }
}
impl std::fmt::Debug for UserImportJobType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserImportJobType");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("start_date", &self.start_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("status", &self.status);
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("imported_users", &self.imported_users);
        formatter.field("skipped_users", &self.skipped_users);
        formatter.field("failed_users", &self.failed_users);
        formatter.field("completion_message", &self.completion_message);
        formatter.finish()
    }
}
/// See [`UserImportJobType`](crate::model::UserImportJobType)
pub mod user_import_job_type {
    /// A builder for [`UserImportJobType`](crate::model::UserImportJobType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::UserImportJobStatusType>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) imported_users: std::option::Option<i64>,
        pub(crate) skipped_users: std::option::Option<i64>,
        pub(crate) failed_users: std::option::Option<i64>,
        pub(crate) completion_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job name for the user import job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The job name for the user import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The pre-signed URL to be used to upload the <code>.csv</code> file.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>The pre-signed URL to be used to upload the <code>.csv</code> file.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>The date the user import job was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the user import job was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date when the user import job was started.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date when the user import job was started.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date when the user import job was completed.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date when the user import job was completed.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>The status of the user import job. One of the following:</p>
        /// <ul>
        /// <li> <p> <code>Created</code> - The job was created but not started.</p> </li>
        /// <li> <p> <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.</p> </li>
        /// <li> <p> <code>InProgress</code> - The job has started, and users are being imported.</p> </li>
        /// <li> <p> <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.</p> </li>
        /// <li> <p> <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.</p> </li>
        /// <li> <p> <code>Succeeded</code> - The job has completed successfully.</p> </li>
        /// <li> <p> <code>Failed</code> - The job has stopped due to an error.</p> </li>
        /// <li> <p> <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can't be started.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::UserImportJobStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the user import job. One of the following:</p>
        /// <ul>
        /// <li> <p> <code>Created</code> - The job was created but not started.</p> </li>
        /// <li> <p> <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.</p> </li>
        /// <li> <p> <code>InProgress</code> - The job has started, and users are being imported.</p> </li>
        /// <li> <p> <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.</p> </li>
        /// <li> <p> <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.</p> </li>
        /// <li> <p> <code>Succeeded</code> - The job has completed successfully.</p> </li>
        /// <li> <p> <code>Failed</code> - The job has stopped due to an error.</p> </li>
        /// <li> <p> <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can't be started.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::UserImportJobStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>The number of users that were successfully imported.</p>
        pub fn imported_users(mut self, input: i64) -> Self {
            self.imported_users = Some(input);
            self
        }
        /// <p>The number of users that were successfully imported.</p>
        pub fn set_imported_users(mut self, input: std::option::Option<i64>) -> Self {
            self.imported_users = input;
            self
        }
        /// <p>The number of users that were skipped.</p>
        pub fn skipped_users(mut self, input: i64) -> Self {
            self.skipped_users = Some(input);
            self
        }
        /// <p>The number of users that were skipped.</p>
        pub fn set_skipped_users(mut self, input: std::option::Option<i64>) -> Self {
            self.skipped_users = input;
            self
        }
        /// <p>The number of users that couldn't be imported.</p>
        pub fn failed_users(mut self, input: i64) -> Self {
            self.failed_users = Some(input);
            self
        }
        /// <p>The number of users that couldn't be imported.</p>
        pub fn set_failed_users(mut self, input: std::option::Option<i64>) -> Self {
            self.failed_users = input;
            self
        }
        /// <p>The message returned when the user import job is completed.</p>
        pub fn completion_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.completion_message = Some(input.into());
            self
        }
        /// <p>The message returned when the user import job is completed.</p>
        pub fn set_completion_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.completion_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserImportJobType`](crate::model::UserImportJobType)
        pub fn build(self) -> crate::model::UserImportJobType {
            crate::model::UserImportJobType {
                job_name: self.job_name,
                job_id: self.job_id,
                user_pool_id: self.user_pool_id,
                pre_signed_url: self.pre_signed_url,
                creation_date: self.creation_date,
                start_date: self.start_date,
                completion_date: self.completion_date,
                status: self.status,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                imported_users: self.imported_users.unwrap_or_default(),
                skipped_users: self.skipped_users.unwrap_or_default(),
                failed_users: self.failed_users.unwrap_or_default(),
                completion_message: self.completion_message,
            }
        }
    }
}
impl UserImportJobType {
    /// Creates a new builder-style object to manufacture [`UserImportJobType`](crate::model::UserImportJobType)
    pub fn builder() -> crate::model::user_import_job_type::Builder {
        crate::model::user_import_job_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserImportJobStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserImportJobStatusType {
    fn from(s: &str) -> Self {
        match s {
            "Created" => UserImportJobStatusType::Created,
            "Expired" => UserImportJobStatusType::Expired,
            "Failed" => UserImportJobStatusType::Failed,
            "InProgress" => UserImportJobStatusType::InProgress,
            "Pending" => UserImportJobStatusType::Pending,
            "Stopped" => UserImportJobStatusType::Stopped,
            "Stopping" => UserImportJobStatusType::Stopping,
            "Succeeded" => UserImportJobStatusType::Succeeded,
            other => UserImportJobStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserImportJobStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserImportJobStatusType::from(s))
    }
}
impl UserImportJobStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserImportJobStatusType::Created => "Created",
            UserImportJobStatusType::Expired => "Expired",
            UserImportJobStatusType::Failed => "Failed",
            UserImportJobStatusType::InProgress => "InProgress",
            UserImportJobStatusType::Pending => "Pending",
            UserImportJobStatusType::Stopped => "Stopped",
            UserImportJobStatusType::Stopping => "Stopping",
            UserImportJobStatusType::Succeeded => "Succeeded",
            UserImportJobStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Created",
            "Expired",
            "Failed",
            "InProgress",
            "Pending",
            "Stopped",
            "Stopping",
            "Succeeded",
        ]
    }
}
impl AsRef<str> for UserImportJobStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserContextDataType {
    /// <p>Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    pub encoded_data: std::option::Option<std::string::String>,
}
impl UserContextDataType {
    /// <p>Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
    pub fn encoded_data(&self) -> std::option::Option<&str> {
        self.encoded_data.as_deref()
    }
}
impl std::fmt::Debug for UserContextDataType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserContextDataType");
        formatter.field("encoded_data", &self.encoded_data);
        formatter.finish()
    }
}
/// See [`UserContextDataType`](crate::model::UserContextDataType)
pub mod user_context_data_type {
    /// A builder for [`UserContextDataType`](crate::model::UserContextDataType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encoded_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn encoded_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.encoded_data = Some(input.into());
            self
        }
        /// <p>Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_encoded_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.encoded_data = input;
            self
        }
        /// Consumes the builder and constructs a [`UserContextDataType`](crate::model::UserContextDataType)
        pub fn build(self) -> crate::model::UserContextDataType {
            crate::model::UserContextDataType {
                encoded_data: self.encoded_data,
            }
        }
    }
}
impl UserContextDataType {
    /// Creates a new builder-style object to manufacture [`UserContextDataType`](crate::model::UserContextDataType)
    pub fn builder() -> crate::model::user_context_data_type::Builder {
        crate::model::user_context_data_type::Builder::default()
    }
}

/// <p>An Amazon Pinpoint analytics endpoint.</p>
/// <p>An endpoint uniquely identifies a mobile device, email address, or phone number that can receive messages from Amazon Pinpoint analytics.</p> <note>
/// <p>Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyticsMetadataType {
    /// <p>The endpoint ID.</p>
    pub analytics_endpoint_id: std::option::Option<std::string::String>,
}
impl AnalyticsMetadataType {
    /// <p>The endpoint ID.</p>
    pub fn analytics_endpoint_id(&self) -> std::option::Option<&str> {
        self.analytics_endpoint_id.as_deref()
    }
}
impl std::fmt::Debug for AnalyticsMetadataType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyticsMetadataType");
        formatter.field("analytics_endpoint_id", &self.analytics_endpoint_id);
        formatter.finish()
    }
}
/// See [`AnalyticsMetadataType`](crate::model::AnalyticsMetadataType)
pub mod analytics_metadata_type {
    /// A builder for [`AnalyticsMetadataType`](crate::model::AnalyticsMetadataType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analytics_endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint ID.</p>
        pub fn analytics_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analytics_endpoint_id = Some(input.into());
            self
        }
        /// <p>The endpoint ID.</p>
        pub fn set_analytics_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analytics_endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyticsMetadataType`](crate::model::AnalyticsMetadataType)
        pub fn build(self) -> crate::model::AnalyticsMetadataType {
            crate::model::AnalyticsMetadataType {
                analytics_endpoint_id: self.analytics_endpoint_id,
            }
        }
    }
}
impl AnalyticsMetadataType {
    /// Creates a new builder-style object to manufacture [`AnalyticsMetadataType`](crate::model::AnalyticsMetadataType)
    pub fn builder() -> crate::model::analytics_metadata_type::Builder {
        crate::model::analytics_metadata_type::Builder::default()
    }
}

/// <p> <i>This data type is no longer supported.</i> Applies only to SMS multi-factor authentication (MFA) configurations. Does not apply to time-based one-time password (TOTP) software token MFA configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MfaOptionType {
    /// <p>The delivery medium to send the MFA code. You can use this parameter to set only the <code>SMS</code> delivery medium value.</p>
    pub delivery_medium: std::option::Option<crate::model::DeliveryMediumType>,
    /// <p>The attribute name of the MFA option type. The only valid value is <code>phone_number</code>.</p>
    pub attribute_name: std::option::Option<std::string::String>,
}
impl MfaOptionType {
    /// <p>The delivery medium to send the MFA code. You can use this parameter to set only the <code>SMS</code> delivery medium value.</p>
    pub fn delivery_medium(&self) -> std::option::Option<&crate::model::DeliveryMediumType> {
        self.delivery_medium.as_ref()
    }
    /// <p>The attribute name of the MFA option type. The only valid value is <code>phone_number</code>.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
}
impl std::fmt::Debug for MfaOptionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MfaOptionType");
        formatter.field("delivery_medium", &self.delivery_medium);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.finish()
    }
}
/// See [`MfaOptionType`](crate::model::MfaOptionType)
pub mod mfa_option_type {
    /// A builder for [`MfaOptionType`](crate::model::MfaOptionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_medium: std::option::Option<crate::model::DeliveryMediumType>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The delivery medium to send the MFA code. You can use this parameter to set only the <code>SMS</code> delivery medium value.</p>
        pub fn delivery_medium(mut self, input: crate::model::DeliveryMediumType) -> Self {
            self.delivery_medium = Some(input);
            self
        }
        /// <p>The delivery medium to send the MFA code. You can use this parameter to set only the <code>SMS</code> delivery medium value.</p>
        pub fn set_delivery_medium(
            mut self,
            input: std::option::Option<crate::model::DeliveryMediumType>,
        ) -> Self {
            self.delivery_medium = input;
            self
        }
        /// <p>The attribute name of the MFA option type. The only valid value is <code>phone_number</code>.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The attribute name of the MFA option type. The only valid value is <code>phone_number</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MfaOptionType`](crate::model::MfaOptionType)
        pub fn build(self) -> crate::model::MfaOptionType {
            crate::model::MfaOptionType {
                delivery_medium: self.delivery_medium,
                attribute_name: self.attribute_name,
            }
        }
    }
}
impl MfaOptionType {
    /// Creates a new builder-style object to manufacture [`MfaOptionType`](crate::model::MfaOptionType)
    pub fn builder() -> crate::model::mfa_option_type::Builder {
        crate::model::mfa_option_type::Builder::default()
    }
}

/// <p>The type used for enabling software token MFA at the user pool level.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SoftwareTokenMfaConfigType {
    /// <p>Specifies whether software token MFA is activated.</p>
    pub enabled: bool,
}
impl SoftwareTokenMfaConfigType {
    /// <p>Specifies whether software token MFA is activated.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for SoftwareTokenMfaConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SoftwareTokenMfaConfigType");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`SoftwareTokenMfaConfigType`](crate::model::SoftwareTokenMfaConfigType)
pub mod software_token_mfa_config_type {
    /// A builder for [`SoftwareTokenMfaConfigType`](crate::model::SoftwareTokenMfaConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether software token MFA is activated.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether software token MFA is activated.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`SoftwareTokenMfaConfigType`](crate::model::SoftwareTokenMfaConfigType)
        pub fn build(self) -> crate::model::SoftwareTokenMfaConfigType {
            crate::model::SoftwareTokenMfaConfigType {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl SoftwareTokenMfaConfigType {
    /// Creates a new builder-style object to manufacture [`SoftwareTokenMfaConfigType`](crate::model::SoftwareTokenMfaConfigType)
    pub fn builder() -> crate::model::software_token_mfa_config_type::Builder {
        crate::model::software_token_mfa_config_type::Builder::default()
    }
}

/// <p>The SMS text message multi-factor authentication (MFA) configuration type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsMfaConfigType {
    /// <p>The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default message will be used.</p>
    pub sms_authentication_message: std::option::Option<std::string::String>,
    /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.</p>
    pub sms_configuration: std::option::Option<crate::model::SmsConfigurationType>,
}
impl SmsMfaConfigType {
    /// <p>The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default message will be used.</p>
    pub fn sms_authentication_message(&self) -> std::option::Option<&str> {
        self.sms_authentication_message.as_deref()
    }
    /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.</p>
    pub fn sms_configuration(&self) -> std::option::Option<&crate::model::SmsConfigurationType> {
        self.sms_configuration.as_ref()
    }
}
impl std::fmt::Debug for SmsMfaConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsMfaConfigType");
        formatter.field(
            "sms_authentication_message",
            &self.sms_authentication_message,
        );
        formatter.field("sms_configuration", &self.sms_configuration);
        formatter.finish()
    }
}
/// See [`SmsMfaConfigType`](crate::model::SmsMfaConfigType)
pub mod sms_mfa_config_type {
    /// A builder for [`SmsMfaConfigType`](crate::model::SmsMfaConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_authentication_message: std::option::Option<std::string::String>,
        pub(crate) sms_configuration: std::option::Option<crate::model::SmsConfigurationType>,
    }
    impl Builder {
        /// <p>The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default message will be used.</p>
        pub fn sms_authentication_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_authentication_message = Some(input.into());
            self
        }
        /// <p>The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default message will be used.</p>
        pub fn set_sms_authentication_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_authentication_message = input;
            self
        }
        /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.</p>
        pub fn sms_configuration(mut self, input: crate::model::SmsConfigurationType) -> Self {
            self.sms_configuration = Some(input);
            self
        }
        /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.</p>
        pub fn set_sms_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsConfigurationType>,
        ) -> Self {
            self.sms_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsMfaConfigType`](crate::model::SmsMfaConfigType)
        pub fn build(self) -> crate::model::SmsMfaConfigType {
            crate::model::SmsMfaConfigType {
                sms_authentication_message: self.sms_authentication_message,
                sms_configuration: self.sms_configuration,
            }
        }
    }
}
impl SmsMfaConfigType {
    /// Creates a new builder-style object to manufacture [`SmsMfaConfigType`](crate::model::SmsMfaConfigType)
    pub fn builder() -> crate::model::sms_mfa_config_type::Builder {
        crate::model::sms_mfa_config_type::Builder::default()
    }
}

/// <p>The type used for enabling software token MFA at the user level. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SoftwareTokenMfaSettingsType {
    /// <p>Specifies whether software token MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
    pub enabled: bool,
    /// <p>Specifies whether software token MFA is the preferred MFA method.</p>
    pub preferred_mfa: bool,
}
impl SoftwareTokenMfaSettingsType {
    /// <p>Specifies whether software token MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>Specifies whether software token MFA is the preferred MFA method.</p>
    pub fn preferred_mfa(&self) -> bool {
        self.preferred_mfa
    }
}
impl std::fmt::Debug for SoftwareTokenMfaSettingsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SoftwareTokenMfaSettingsType");
        formatter.field("enabled", &self.enabled);
        formatter.field("preferred_mfa", &self.preferred_mfa);
        formatter.finish()
    }
}
/// See [`SoftwareTokenMfaSettingsType`](crate::model::SoftwareTokenMfaSettingsType)
pub mod software_token_mfa_settings_type {
    /// A builder for [`SoftwareTokenMfaSettingsType`](crate::model::SoftwareTokenMfaSettingsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) preferred_mfa: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether software token MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether software token MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies whether software token MFA is the preferred MFA method.</p>
        pub fn preferred_mfa(mut self, input: bool) -> Self {
            self.preferred_mfa = Some(input);
            self
        }
        /// <p>Specifies whether software token MFA is the preferred MFA method.</p>
        pub fn set_preferred_mfa(mut self, input: std::option::Option<bool>) -> Self {
            self.preferred_mfa = input;
            self
        }
        /// Consumes the builder and constructs a [`SoftwareTokenMfaSettingsType`](crate::model::SoftwareTokenMfaSettingsType)
        pub fn build(self) -> crate::model::SoftwareTokenMfaSettingsType {
            crate::model::SoftwareTokenMfaSettingsType {
                enabled: self.enabled.unwrap_or_default(),
                preferred_mfa: self.preferred_mfa.unwrap_or_default(),
            }
        }
    }
}
impl SoftwareTokenMfaSettingsType {
    /// Creates a new builder-style object to manufacture [`SoftwareTokenMfaSettingsType`](crate::model::SoftwareTokenMfaSettingsType)
    pub fn builder() -> crate::model::software_token_mfa_settings_type::Builder {
        crate::model::software_token_mfa_settings_type::Builder::default()
    }
}

/// <p>The type used for enabling SMS multi-factor authentication (MFA) at the user level. Phone numbers don't need to be verified to be used for SMS MFA. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsMfaSettingsType {
    /// <p>Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
    pub enabled: bool,
    /// <p>Specifies whether SMS is the preferred MFA method.</p>
    pub preferred_mfa: bool,
}
impl SmsMfaSettingsType {
    /// <p>Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>Specifies whether SMS is the preferred MFA method.</p>
    pub fn preferred_mfa(&self) -> bool {
        self.preferred_mfa
    }
}
impl std::fmt::Debug for SmsMfaSettingsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsMfaSettingsType");
        formatter.field("enabled", &self.enabled);
        formatter.field("preferred_mfa", &self.preferred_mfa);
        formatter.finish()
    }
}
/// See [`SmsMfaSettingsType`](crate::model::SmsMfaSettingsType)
pub mod sms_mfa_settings_type {
    /// A builder for [`SmsMfaSettingsType`](crate::model::SmsMfaSettingsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) preferred_mfa: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies whether SMS is the preferred MFA method.</p>
        pub fn preferred_mfa(mut self, input: bool) -> Self {
            self.preferred_mfa = Some(input);
            self
        }
        /// <p>Specifies whether SMS is the preferred MFA method.</p>
        pub fn set_preferred_mfa(mut self, input: std::option::Option<bool>) -> Self {
            self.preferred_mfa = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsMfaSettingsType`](crate::model::SmsMfaSettingsType)
        pub fn build(self) -> crate::model::SmsMfaSettingsType {
            crate::model::SmsMfaSettingsType {
                enabled: self.enabled.unwrap_or_default(),
                preferred_mfa: self.preferred_mfa.unwrap_or_default(),
            }
        }
    }
}
impl SmsMfaSettingsType {
    /// Creates a new builder-style object to manufacture [`SmsMfaSettingsType`](crate::model::SmsMfaSettingsType)
    pub fn builder() -> crate::model::sms_mfa_settings_type::Builder {
        crate::model::sms_mfa_settings_type::Builder::default()
    }
}

/// <p>A container for the UI customization information for a user pool's built-in app UI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UiCustomizationType {
    /// <p>The user pool ID for the user pool.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The client ID for the client app.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The logo image for the UI customization.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>The CSS values in the UI customization.</p>
    pub css: std::option::Option<std::string::String>,
    /// <p>The CSS version number.</p>
    pub css_version: std::option::Option<std::string::String>,
    /// <p>The last-modified date for the UI customization.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The creation date for the UI customization.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl UiCustomizationType {
    /// <p>The user pool ID for the user pool.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The client ID for the client app.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The logo image for the UI customization.</p>
    pub fn image_url(&self) -> std::option::Option<&str> {
        self.image_url.as_deref()
    }
    /// <p>The CSS values in the UI customization.</p>
    pub fn css(&self) -> std::option::Option<&str> {
        self.css.as_deref()
    }
    /// <p>The CSS version number.</p>
    pub fn css_version(&self) -> std::option::Option<&str> {
        self.css_version.as_deref()
    }
    /// <p>The last-modified date for the UI customization.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The creation date for the UI customization.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for UiCustomizationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UiCustomizationType");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("client_id", &"*** Sensitive Data Redacted ***");
        formatter.field("image_url", &self.image_url);
        formatter.field("css", &self.css);
        formatter.field("css_version", &self.css_version);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`UiCustomizationType`](crate::model::UiCustomizationType)
pub mod ui_customization_type {
    /// A builder for [`UiCustomizationType`](crate::model::UiCustomizationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) css: std::option::Option<std::string::String>,
        pub(crate) css_version: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The logo image for the UI customization.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The logo image for the UI customization.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// <p>The CSS values in the UI customization.</p>
        pub fn css(mut self, input: impl Into<std::string::String>) -> Self {
            self.css = Some(input.into());
            self
        }
        /// <p>The CSS values in the UI customization.</p>
        pub fn set_css(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.css = input;
            self
        }
        /// <p>The CSS version number.</p>
        pub fn css_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.css_version = Some(input.into());
            self
        }
        /// <p>The CSS version number.</p>
        pub fn set_css_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.css_version = input;
            self
        }
        /// <p>The last-modified date for the UI customization.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The last-modified date for the UI customization.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The creation date for the UI customization.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date for the UI customization.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UiCustomizationType`](crate::model::UiCustomizationType)
        pub fn build(self) -> crate::model::UiCustomizationType {
            crate::model::UiCustomizationType {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
                image_url: self.image_url,
                css: self.css,
                css_version: self.css_version,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
            }
        }
    }
}
impl UiCustomizationType {
    /// Creates a new builder-style object to manufacture [`UiCustomizationType`](crate::model::UiCustomizationType)
    pub fn builder() -> crate::model::ui_customization_type::Builder {
        crate::model::ui_customization_type::Builder::default()
    }
}

/// <p>The risk configuration type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RiskConfigurationType {
    /// <p>The user pool ID.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The app client ID.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code>.</p>
    pub compromised_credentials_risk_configuration:
        std::option::Option<crate::model::CompromisedCredentialsRiskConfigurationType>,
    /// <p>The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.</p>
    pub account_takeover_risk_configuration:
        std::option::Option<crate::model::AccountTakeoverRiskConfigurationType>,
    /// <p>The configuration to override the risk decision.</p>
    pub risk_exception_configuration:
        std::option::Option<crate::model::RiskExceptionConfigurationType>,
    /// <p>The last modified date.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl RiskConfigurationType {
    /// <p>The user pool ID.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The app client ID.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code>.</p>
    pub fn compromised_credentials_risk_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CompromisedCredentialsRiskConfigurationType> {
        self.compromised_credentials_risk_configuration.as_ref()
    }
    /// <p>The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.</p>
    pub fn account_takeover_risk_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AccountTakeoverRiskConfigurationType> {
        self.account_takeover_risk_configuration.as_ref()
    }
    /// <p>The configuration to override the risk decision.</p>
    pub fn risk_exception_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RiskExceptionConfigurationType> {
        self.risk_exception_configuration.as_ref()
    }
    /// <p>The last modified date.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for RiskConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RiskConfigurationType");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("client_id", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "compromised_credentials_risk_configuration",
            &self.compromised_credentials_risk_configuration,
        );
        formatter.field(
            "account_takeover_risk_configuration",
            &self.account_takeover_risk_configuration,
        );
        formatter.field(
            "risk_exception_configuration",
            &self.risk_exception_configuration,
        );
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`RiskConfigurationType`](crate::model::RiskConfigurationType)
pub mod risk_configuration_type {
    /// A builder for [`RiskConfigurationType`](crate::model::RiskConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) compromised_credentials_risk_configuration:
            std::option::Option<crate::model::CompromisedCredentialsRiskConfigurationType>,
        pub(crate) account_takeover_risk_configuration:
            std::option::Option<crate::model::AccountTakeoverRiskConfigurationType>,
        pub(crate) risk_exception_configuration:
            std::option::Option<crate::model::RiskExceptionConfigurationType>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code>.</p>
        pub fn compromised_credentials_risk_configuration(
            mut self,
            input: crate::model::CompromisedCredentialsRiskConfigurationType,
        ) -> Self {
            self.compromised_credentials_risk_configuration = Some(input);
            self
        }
        /// <p>The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code>.</p>
        pub fn set_compromised_credentials_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::CompromisedCredentialsRiskConfigurationType>,
        ) -> Self {
            self.compromised_credentials_risk_configuration = input;
            self
        }
        /// <p>The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.</p>
        pub fn account_takeover_risk_configuration(
            mut self,
            input: crate::model::AccountTakeoverRiskConfigurationType,
        ) -> Self {
            self.account_takeover_risk_configuration = Some(input);
            self
        }
        /// <p>The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.</p>
        pub fn set_account_takeover_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverRiskConfigurationType>,
        ) -> Self {
            self.account_takeover_risk_configuration = input;
            self
        }
        /// <p>The configuration to override the risk decision.</p>
        pub fn risk_exception_configuration(
            mut self,
            input: crate::model::RiskExceptionConfigurationType,
        ) -> Self {
            self.risk_exception_configuration = Some(input);
            self
        }
        /// <p>The configuration to override the risk decision.</p>
        pub fn set_risk_exception_configuration(
            mut self,
            input: std::option::Option<crate::model::RiskExceptionConfigurationType>,
        ) -> Self {
            self.risk_exception_configuration = input;
            self
        }
        /// <p>The last modified date.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The last modified date.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`RiskConfigurationType`](crate::model::RiskConfigurationType)
        pub fn build(self) -> crate::model::RiskConfigurationType {
            crate::model::RiskConfigurationType {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
                compromised_credentials_risk_configuration: self
                    .compromised_credentials_risk_configuration,
                account_takeover_risk_configuration: self.account_takeover_risk_configuration,
                risk_exception_configuration: self.risk_exception_configuration,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl RiskConfigurationType {
    /// Creates a new builder-style object to manufacture [`RiskConfigurationType`](crate::model::RiskConfigurationType)
    pub fn builder() -> crate::model::risk_configuration_type::Builder {
        crate::model::risk_configuration_type::Builder::default()
    }
}

/// <p>The type of the configuration to override the risk decision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RiskExceptionConfigurationType {
    /// <p>Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.</p>
    pub blocked_ip_range_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Risk detection isn't performed on the IP addresses in this range list. The IP range is in CIDR notation.</p>
    pub skipped_ip_range_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RiskExceptionConfigurationType {
    /// <p>Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.</p>
    pub fn blocked_ip_range_list(&self) -> std::option::Option<&[std::string::String]> {
        self.blocked_ip_range_list.as_deref()
    }
    /// <p>Risk detection isn't performed on the IP addresses in this range list. The IP range is in CIDR notation.</p>
    pub fn skipped_ip_range_list(&self) -> std::option::Option<&[std::string::String]> {
        self.skipped_ip_range_list.as_deref()
    }
}
impl std::fmt::Debug for RiskExceptionConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RiskExceptionConfigurationType");
        formatter.field("blocked_ip_range_list", &self.blocked_ip_range_list);
        formatter.field("skipped_ip_range_list", &self.skipped_ip_range_list);
        formatter.finish()
    }
}
/// See [`RiskExceptionConfigurationType`](crate::model::RiskExceptionConfigurationType)
pub mod risk_exception_configuration_type {
    /// A builder for [`RiskExceptionConfigurationType`](crate::model::RiskExceptionConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blocked_ip_range_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) skipped_ip_range_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `blocked_ip_range_list`.
        ///
        /// To override the contents of this collection use [`set_blocked_ip_range_list`](Self::set_blocked_ip_range_list).
        ///
        /// <p>Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.</p>
        pub fn blocked_ip_range_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.blocked_ip_range_list.unwrap_or_default();
            v.push(input.into());
            self.blocked_ip_range_list = Some(v);
            self
        }
        /// <p>Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.</p>
        pub fn set_blocked_ip_range_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.blocked_ip_range_list = input;
            self
        }
        /// Appends an item to `skipped_ip_range_list`.
        ///
        /// To override the contents of this collection use [`set_skipped_ip_range_list`](Self::set_skipped_ip_range_list).
        ///
        /// <p>Risk detection isn't performed on the IP addresses in this range list. The IP range is in CIDR notation.</p>
        pub fn skipped_ip_range_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.skipped_ip_range_list.unwrap_or_default();
            v.push(input.into());
            self.skipped_ip_range_list = Some(v);
            self
        }
        /// <p>Risk detection isn't performed on the IP addresses in this range list. The IP range is in CIDR notation.</p>
        pub fn set_skipped_ip_range_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.skipped_ip_range_list = input;
            self
        }
        /// Consumes the builder and constructs a [`RiskExceptionConfigurationType`](crate::model::RiskExceptionConfigurationType)
        pub fn build(self) -> crate::model::RiskExceptionConfigurationType {
            crate::model::RiskExceptionConfigurationType {
                blocked_ip_range_list: self.blocked_ip_range_list,
                skipped_ip_range_list: self.skipped_ip_range_list,
            }
        }
    }
}
impl RiskExceptionConfigurationType {
    /// Creates a new builder-style object to manufacture [`RiskExceptionConfigurationType`](crate::model::RiskExceptionConfigurationType)
    pub fn builder() -> crate::model::risk_exception_configuration_type::Builder {
        crate::model::risk_exception_configuration_type::Builder::default()
    }
}

/// <p>Configuration for mitigation actions and notification for different levels of risk detected for a potential account takeover.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountTakeoverRiskConfigurationType {
    /// <p>The notify configuration used to construct email notifications.</p>
    pub notify_configuration: std::option::Option<crate::model::NotifyConfigurationType>,
    /// <p>Account takeover risk configuration actions.</p>
    pub actions: std::option::Option<crate::model::AccountTakeoverActionsType>,
}
impl AccountTakeoverRiskConfigurationType {
    /// <p>The notify configuration used to construct email notifications.</p>
    pub fn notify_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotifyConfigurationType> {
        self.notify_configuration.as_ref()
    }
    /// <p>Account takeover risk configuration actions.</p>
    pub fn actions(&self) -> std::option::Option<&crate::model::AccountTakeoverActionsType> {
        self.actions.as_ref()
    }
}
impl std::fmt::Debug for AccountTakeoverRiskConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountTakeoverRiskConfigurationType");
        formatter.field("notify_configuration", &self.notify_configuration);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`AccountTakeoverRiskConfigurationType`](crate::model::AccountTakeoverRiskConfigurationType)
pub mod account_takeover_risk_configuration_type {
    /// A builder for [`AccountTakeoverRiskConfigurationType`](crate::model::AccountTakeoverRiskConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notify_configuration: std::option::Option<crate::model::NotifyConfigurationType>,
        pub(crate) actions: std::option::Option<crate::model::AccountTakeoverActionsType>,
    }
    impl Builder {
        /// <p>The notify configuration used to construct email notifications.</p>
        pub fn notify_configuration(
            mut self,
            input: crate::model::NotifyConfigurationType,
        ) -> Self {
            self.notify_configuration = Some(input);
            self
        }
        /// <p>The notify configuration used to construct email notifications.</p>
        pub fn set_notify_configuration(
            mut self,
            input: std::option::Option<crate::model::NotifyConfigurationType>,
        ) -> Self {
            self.notify_configuration = input;
            self
        }
        /// <p>Account takeover risk configuration actions.</p>
        pub fn actions(mut self, input: crate::model::AccountTakeoverActionsType) -> Self {
            self.actions = Some(input);
            self
        }
        /// <p>Account takeover risk configuration actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverActionsType>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountTakeoverRiskConfigurationType`](crate::model::AccountTakeoverRiskConfigurationType)
        pub fn build(self) -> crate::model::AccountTakeoverRiskConfigurationType {
            crate::model::AccountTakeoverRiskConfigurationType {
                notify_configuration: self.notify_configuration,
                actions: self.actions,
            }
        }
    }
}
impl AccountTakeoverRiskConfigurationType {
    /// Creates a new builder-style object to manufacture [`AccountTakeoverRiskConfigurationType`](crate::model::AccountTakeoverRiskConfigurationType)
    pub fn builder() -> crate::model::account_takeover_risk_configuration_type::Builder {
        crate::model::account_takeover_risk_configuration_type::Builder::default()
    }
}

/// <p>Account takeover actions type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountTakeoverActionsType {
    /// <p>Action to take for a low risk.</p>
    pub low_action: std::option::Option<crate::model::AccountTakeoverActionType>,
    /// <p>Action to take for a medium risk.</p>
    pub medium_action: std::option::Option<crate::model::AccountTakeoverActionType>,
    /// <p>Action to take for a high risk.</p>
    pub high_action: std::option::Option<crate::model::AccountTakeoverActionType>,
}
impl AccountTakeoverActionsType {
    /// <p>Action to take for a low risk.</p>
    pub fn low_action(&self) -> std::option::Option<&crate::model::AccountTakeoverActionType> {
        self.low_action.as_ref()
    }
    /// <p>Action to take for a medium risk.</p>
    pub fn medium_action(&self) -> std::option::Option<&crate::model::AccountTakeoverActionType> {
        self.medium_action.as_ref()
    }
    /// <p>Action to take for a high risk.</p>
    pub fn high_action(&self) -> std::option::Option<&crate::model::AccountTakeoverActionType> {
        self.high_action.as_ref()
    }
}
impl std::fmt::Debug for AccountTakeoverActionsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountTakeoverActionsType");
        formatter.field("low_action", &self.low_action);
        formatter.field("medium_action", &self.medium_action);
        formatter.field("high_action", &self.high_action);
        formatter.finish()
    }
}
/// See [`AccountTakeoverActionsType`](crate::model::AccountTakeoverActionsType)
pub mod account_takeover_actions_type {
    /// A builder for [`AccountTakeoverActionsType`](crate::model::AccountTakeoverActionsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) low_action: std::option::Option<crate::model::AccountTakeoverActionType>,
        pub(crate) medium_action: std::option::Option<crate::model::AccountTakeoverActionType>,
        pub(crate) high_action: std::option::Option<crate::model::AccountTakeoverActionType>,
    }
    impl Builder {
        /// <p>Action to take for a low risk.</p>
        pub fn low_action(mut self, input: crate::model::AccountTakeoverActionType) -> Self {
            self.low_action = Some(input);
            self
        }
        /// <p>Action to take for a low risk.</p>
        pub fn set_low_action(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverActionType>,
        ) -> Self {
            self.low_action = input;
            self
        }
        /// <p>Action to take for a medium risk.</p>
        pub fn medium_action(mut self, input: crate::model::AccountTakeoverActionType) -> Self {
            self.medium_action = Some(input);
            self
        }
        /// <p>Action to take for a medium risk.</p>
        pub fn set_medium_action(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverActionType>,
        ) -> Self {
            self.medium_action = input;
            self
        }
        /// <p>Action to take for a high risk.</p>
        pub fn high_action(mut self, input: crate::model::AccountTakeoverActionType) -> Self {
            self.high_action = Some(input);
            self
        }
        /// <p>Action to take for a high risk.</p>
        pub fn set_high_action(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverActionType>,
        ) -> Self {
            self.high_action = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountTakeoverActionsType`](crate::model::AccountTakeoverActionsType)
        pub fn build(self) -> crate::model::AccountTakeoverActionsType {
            crate::model::AccountTakeoverActionsType {
                low_action: self.low_action,
                medium_action: self.medium_action,
                high_action: self.high_action,
            }
        }
    }
}
impl AccountTakeoverActionsType {
    /// Creates a new builder-style object to manufacture [`AccountTakeoverActionsType`](crate::model::AccountTakeoverActionsType)
    pub fn builder() -> crate::model::account_takeover_actions_type::Builder {
        crate::model::account_takeover_actions_type::Builder::default()
    }
}

/// <p>Account takeover action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountTakeoverActionType {
    /// <p>Flag specifying whether to send a notification.</p>
    pub notify: bool,
    /// <p>The action to take in response to the account takeover action. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>BLOCK</code> Choosing this action will block the request.</p> </li>
    /// <li> <p> <code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</p> </li>
    /// <li> <p> <code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</p> </li>
    /// <li> <p> <code>NO_ACTION</code> Allow the user to sign in.</p> </li>
    /// </ul>
    pub event_action: std::option::Option<crate::model::AccountTakeoverEventActionType>,
}
impl AccountTakeoverActionType {
    /// <p>Flag specifying whether to send a notification.</p>
    pub fn notify(&self) -> bool {
        self.notify
    }
    /// <p>The action to take in response to the account takeover action. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>BLOCK</code> Choosing this action will block the request.</p> </li>
    /// <li> <p> <code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</p> </li>
    /// <li> <p> <code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</p> </li>
    /// <li> <p> <code>NO_ACTION</code> Allow the user to sign in.</p> </li>
    /// </ul>
    pub fn event_action(
        &self,
    ) -> std::option::Option<&crate::model::AccountTakeoverEventActionType> {
        self.event_action.as_ref()
    }
}
impl std::fmt::Debug for AccountTakeoverActionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountTakeoverActionType");
        formatter.field("notify", &self.notify);
        formatter.field("event_action", &self.event_action);
        formatter.finish()
    }
}
/// See [`AccountTakeoverActionType`](crate::model::AccountTakeoverActionType)
pub mod account_takeover_action_type {
    /// A builder for [`AccountTakeoverActionType`](crate::model::AccountTakeoverActionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notify: std::option::Option<bool>,
        pub(crate) event_action: std::option::Option<crate::model::AccountTakeoverEventActionType>,
    }
    impl Builder {
        /// <p>Flag specifying whether to send a notification.</p>
        pub fn notify(mut self, input: bool) -> Self {
            self.notify = Some(input);
            self
        }
        /// <p>Flag specifying whether to send a notification.</p>
        pub fn set_notify(mut self, input: std::option::Option<bool>) -> Self {
            self.notify = input;
            self
        }
        /// <p>The action to take in response to the account takeover action. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>BLOCK</code> Choosing this action will block the request.</p> </li>
        /// <li> <p> <code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</p> </li>
        /// <li> <p> <code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</p> </li>
        /// <li> <p> <code>NO_ACTION</code> Allow the user to sign in.</p> </li>
        /// </ul>
        pub fn event_action(mut self, input: crate::model::AccountTakeoverEventActionType) -> Self {
            self.event_action = Some(input);
            self
        }
        /// <p>The action to take in response to the account takeover action. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>BLOCK</code> Choosing this action will block the request.</p> </li>
        /// <li> <p> <code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</p> </li>
        /// <li> <p> <code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</p> </li>
        /// <li> <p> <code>NO_ACTION</code> Allow the user to sign in.</p> </li>
        /// </ul>
        pub fn set_event_action(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverEventActionType>,
        ) -> Self {
            self.event_action = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountTakeoverActionType`](crate::model::AccountTakeoverActionType)
        pub fn build(self) -> crate::model::AccountTakeoverActionType {
            crate::model::AccountTakeoverActionType {
                notify: self.notify.unwrap_or_default(),
                event_action: self.event_action,
            }
        }
    }
}
impl AccountTakeoverActionType {
    /// Creates a new builder-style object to manufacture [`AccountTakeoverActionType`](crate::model::AccountTakeoverActionType)
    pub fn builder() -> crate::model::account_takeover_action_type::Builder {
        crate::model::account_takeover_action_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountTakeoverEventActionType {
    #[allow(missing_docs)] // documentation missing in model
    Block,
    #[allow(missing_docs)] // documentation missing in model
    MfaIfConfigured,
    #[allow(missing_docs)] // documentation missing in model
    MfaRequired,
    #[allow(missing_docs)] // documentation missing in model
    NoAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountTakeoverEventActionType {
    fn from(s: &str) -> Self {
        match s {
            "BLOCK" => AccountTakeoverEventActionType::Block,
            "MFA_IF_CONFIGURED" => AccountTakeoverEventActionType::MfaIfConfigured,
            "MFA_REQUIRED" => AccountTakeoverEventActionType::MfaRequired,
            "NO_ACTION" => AccountTakeoverEventActionType::NoAction,
            other => AccountTakeoverEventActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountTakeoverEventActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountTakeoverEventActionType::from(s))
    }
}
impl AccountTakeoverEventActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountTakeoverEventActionType::Block => "BLOCK",
            AccountTakeoverEventActionType::MfaIfConfigured => "MFA_IF_CONFIGURED",
            AccountTakeoverEventActionType::MfaRequired => "MFA_REQUIRED",
            AccountTakeoverEventActionType::NoAction => "NO_ACTION",
            AccountTakeoverEventActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BLOCK", "MFA_IF_CONFIGURED", "MFA_REQUIRED", "NO_ACTION"]
    }
}
impl AsRef<str> for AccountTakeoverEventActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The notify configuration type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyConfigurationType {
    /// <p>The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.</p>
    pub from: std::option::Option<std::string::String>,
    /// <p>The destination to which the receiver of an email should reply to.</p>
    pub reply_to: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>Email template used when a detected risk event is blocked.</p>
    pub block_email: std::option::Option<crate::model::NotifyEmailType>,
    /// <p>The email template used when a detected risk event is allowed.</p>
    pub no_action_email: std::option::Option<crate::model::NotifyEmailType>,
    /// <p>The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.</p>
    pub mfa_email: std::option::Option<crate::model::NotifyEmailType>,
}
impl NotifyConfigurationType {
    /// <p>The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.</p>
    pub fn from(&self) -> std::option::Option<&str> {
        self.from.as_deref()
    }
    /// <p>The destination to which the receiver of an email should reply to.</p>
    pub fn reply_to(&self) -> std::option::Option<&str> {
        self.reply_to.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>Email template used when a detected risk event is blocked.</p>
    pub fn block_email(&self) -> std::option::Option<&crate::model::NotifyEmailType> {
        self.block_email.as_ref()
    }
    /// <p>The email template used when a detected risk event is allowed.</p>
    pub fn no_action_email(&self) -> std::option::Option<&crate::model::NotifyEmailType> {
        self.no_action_email.as_ref()
    }
    /// <p>The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.</p>
    pub fn mfa_email(&self) -> std::option::Option<&crate::model::NotifyEmailType> {
        self.mfa_email.as_ref()
    }
}
impl std::fmt::Debug for NotifyConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyConfigurationType");
        formatter.field("from", &self.from);
        formatter.field("reply_to", &self.reply_to);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("block_email", &self.block_email);
        formatter.field("no_action_email", &self.no_action_email);
        formatter.field("mfa_email", &self.mfa_email);
        formatter.finish()
    }
}
/// See [`NotifyConfigurationType`](crate::model::NotifyConfigurationType)
pub mod notify_configuration_type {
    /// A builder for [`NotifyConfigurationType`](crate::model::NotifyConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<std::string::String>,
        pub(crate) reply_to: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) block_email: std::option::Option<crate::model::NotifyEmailType>,
        pub(crate) no_action_email: std::option::Option<crate::model::NotifyEmailType>,
        pub(crate) mfa_email: std::option::Option<crate::model::NotifyEmailType>,
    }
    impl Builder {
        /// <p>The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.</p>
        pub fn from(mut self, input: impl Into<std::string::String>) -> Self {
            self.from = Some(input.into());
            self
        }
        /// <p>The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.</p>
        pub fn set_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from = input;
            self
        }
        /// <p>The destination to which the receiver of an email should reply to.</p>
        pub fn reply_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.reply_to = Some(input.into());
            self
        }
        /// <p>The destination to which the receiver of an email should reply to.</p>
        pub fn set_reply_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reply_to = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>Email template used when a detected risk event is blocked.</p>
        pub fn block_email(mut self, input: crate::model::NotifyEmailType) -> Self {
            self.block_email = Some(input);
            self
        }
        /// <p>Email template used when a detected risk event is blocked.</p>
        pub fn set_block_email(
            mut self,
            input: std::option::Option<crate::model::NotifyEmailType>,
        ) -> Self {
            self.block_email = input;
            self
        }
        /// <p>The email template used when a detected risk event is allowed.</p>
        pub fn no_action_email(mut self, input: crate::model::NotifyEmailType) -> Self {
            self.no_action_email = Some(input);
            self
        }
        /// <p>The email template used when a detected risk event is allowed.</p>
        pub fn set_no_action_email(
            mut self,
            input: std::option::Option<crate::model::NotifyEmailType>,
        ) -> Self {
            self.no_action_email = input;
            self
        }
        /// <p>The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.</p>
        pub fn mfa_email(mut self, input: crate::model::NotifyEmailType) -> Self {
            self.mfa_email = Some(input);
            self
        }
        /// <p>The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.</p>
        pub fn set_mfa_email(
            mut self,
            input: std::option::Option<crate::model::NotifyEmailType>,
        ) -> Self {
            self.mfa_email = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyConfigurationType`](crate::model::NotifyConfigurationType)
        pub fn build(self) -> crate::model::NotifyConfigurationType {
            crate::model::NotifyConfigurationType {
                from: self.from,
                reply_to: self.reply_to,
                source_arn: self.source_arn,
                block_email: self.block_email,
                no_action_email: self.no_action_email,
                mfa_email: self.mfa_email,
            }
        }
    }
}
impl NotifyConfigurationType {
    /// Creates a new builder-style object to manufacture [`NotifyConfigurationType`](crate::model::NotifyConfigurationType)
    pub fn builder() -> crate::model::notify_configuration_type::Builder {
        crate::model::notify_configuration_type::Builder::default()
    }
}

/// <p>The notify email type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyEmailType {
    /// <p>The email subject.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The email HTML body.</p>
    pub html_body: std::option::Option<std::string::String>,
    /// <p>The email text body.</p>
    pub text_body: std::option::Option<std::string::String>,
}
impl NotifyEmailType {
    /// <p>The email subject.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The email HTML body.</p>
    pub fn html_body(&self) -> std::option::Option<&str> {
        self.html_body.as_deref()
    }
    /// <p>The email text body.</p>
    pub fn text_body(&self) -> std::option::Option<&str> {
        self.text_body.as_deref()
    }
}
impl std::fmt::Debug for NotifyEmailType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyEmailType");
        formatter.field("subject", &self.subject);
        formatter.field("html_body", &self.html_body);
        formatter.field("text_body", &self.text_body);
        formatter.finish()
    }
}
/// See [`NotifyEmailType`](crate::model::NotifyEmailType)
pub mod notify_email_type {
    /// A builder for [`NotifyEmailType`](crate::model::NotifyEmailType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) html_body: std::option::Option<std::string::String>,
        pub(crate) text_body: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email subject.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The email subject.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The email HTML body.</p>
        pub fn html_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.html_body = Some(input.into());
            self
        }
        /// <p>The email HTML body.</p>
        pub fn set_html_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.html_body = input;
            self
        }
        /// <p>The email text body.</p>
        pub fn text_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.text_body = Some(input.into());
            self
        }
        /// <p>The email text body.</p>
        pub fn set_text_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text_body = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyEmailType`](crate::model::NotifyEmailType)
        pub fn build(self) -> crate::model::NotifyEmailType {
            crate::model::NotifyEmailType {
                subject: self.subject,
                html_body: self.html_body,
                text_body: self.text_body,
            }
        }
    }
}
impl NotifyEmailType {
    /// Creates a new builder-style object to manufacture [`NotifyEmailType`](crate::model::NotifyEmailType)
    pub fn builder() -> crate::model::notify_email_type::Builder {
        crate::model::notify_email_type::Builder::default()
    }
}

/// <p>The compromised credentials risk configuration type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompromisedCredentialsRiskConfigurationType {
    /// <p>Perform the action for these events. The default is to perform all events if no event filter is specified.</p>
    pub event_filter: std::option::Option<std::vec::Vec<crate::model::EventFilterType>>,
    /// <p>The compromised credentials risk configuration actions.</p>
    pub actions: std::option::Option<crate::model::CompromisedCredentialsActionsType>,
}
impl CompromisedCredentialsRiskConfigurationType {
    /// <p>Perform the action for these events. The default is to perform all events if no event filter is specified.</p>
    pub fn event_filter(&self) -> std::option::Option<&[crate::model::EventFilterType]> {
        self.event_filter.as_deref()
    }
    /// <p>The compromised credentials risk configuration actions.</p>
    pub fn actions(&self) -> std::option::Option<&crate::model::CompromisedCredentialsActionsType> {
        self.actions.as_ref()
    }
}
impl std::fmt::Debug for CompromisedCredentialsRiskConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompromisedCredentialsRiskConfigurationType");
        formatter.field("event_filter", &self.event_filter);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`CompromisedCredentialsRiskConfigurationType`](crate::model::CompromisedCredentialsRiskConfigurationType)
pub mod compromised_credentials_risk_configuration_type {
    /// A builder for [`CompromisedCredentialsRiskConfigurationType`](crate::model::CompromisedCredentialsRiskConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_filter: std::option::Option<std::vec::Vec<crate::model::EventFilterType>>,
        pub(crate) actions: std::option::Option<crate::model::CompromisedCredentialsActionsType>,
    }
    impl Builder {
        /// Appends an item to `event_filter`.
        ///
        /// To override the contents of this collection use [`set_event_filter`](Self::set_event_filter).
        ///
        /// <p>Perform the action for these events. The default is to perform all events if no event filter is specified.</p>
        pub fn event_filter(mut self, input: crate::model::EventFilterType) -> Self {
            let mut v = self.event_filter.unwrap_or_default();
            v.push(input);
            self.event_filter = Some(v);
            self
        }
        /// <p>Perform the action for these events. The default is to perform all events if no event filter is specified.</p>
        pub fn set_event_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventFilterType>>,
        ) -> Self {
            self.event_filter = input;
            self
        }
        /// <p>The compromised credentials risk configuration actions.</p>
        pub fn actions(mut self, input: crate::model::CompromisedCredentialsActionsType) -> Self {
            self.actions = Some(input);
            self
        }
        /// <p>The compromised credentials risk configuration actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<crate::model::CompromisedCredentialsActionsType>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`CompromisedCredentialsRiskConfigurationType`](crate::model::CompromisedCredentialsRiskConfigurationType)
        pub fn build(self) -> crate::model::CompromisedCredentialsRiskConfigurationType {
            crate::model::CompromisedCredentialsRiskConfigurationType {
                event_filter: self.event_filter,
                actions: self.actions,
            }
        }
    }
}
impl CompromisedCredentialsRiskConfigurationType {
    /// Creates a new builder-style object to manufacture [`CompromisedCredentialsRiskConfigurationType`](crate::model::CompromisedCredentialsRiskConfigurationType)
    pub fn builder() -> crate::model::compromised_credentials_risk_configuration_type::Builder {
        crate::model::compromised_credentials_risk_configuration_type::Builder::default()
    }
}

/// <p>The compromised credentials actions type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompromisedCredentialsActionsType {
    /// <p>The event action.</p>
    pub event_action: std::option::Option<crate::model::CompromisedCredentialsEventActionType>,
}
impl CompromisedCredentialsActionsType {
    /// <p>The event action.</p>
    pub fn event_action(
        &self,
    ) -> std::option::Option<&crate::model::CompromisedCredentialsEventActionType> {
        self.event_action.as_ref()
    }
}
impl std::fmt::Debug for CompromisedCredentialsActionsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompromisedCredentialsActionsType");
        formatter.field("event_action", &self.event_action);
        formatter.finish()
    }
}
/// See [`CompromisedCredentialsActionsType`](crate::model::CompromisedCredentialsActionsType)
pub mod compromised_credentials_actions_type {
    /// A builder for [`CompromisedCredentialsActionsType`](crate::model::CompromisedCredentialsActionsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_action:
            std::option::Option<crate::model::CompromisedCredentialsEventActionType>,
    }
    impl Builder {
        /// <p>The event action.</p>
        pub fn event_action(
            mut self,
            input: crate::model::CompromisedCredentialsEventActionType,
        ) -> Self {
            self.event_action = Some(input);
            self
        }
        /// <p>The event action.</p>
        pub fn set_event_action(
            mut self,
            input: std::option::Option<crate::model::CompromisedCredentialsEventActionType>,
        ) -> Self {
            self.event_action = input;
            self
        }
        /// Consumes the builder and constructs a [`CompromisedCredentialsActionsType`](crate::model::CompromisedCredentialsActionsType)
        pub fn build(self) -> crate::model::CompromisedCredentialsActionsType {
            crate::model::CompromisedCredentialsActionsType {
                event_action: self.event_action,
            }
        }
    }
}
impl CompromisedCredentialsActionsType {
    /// Creates a new builder-style object to manufacture [`CompromisedCredentialsActionsType`](crate::model::CompromisedCredentialsActionsType)
    pub fn builder() -> crate::model::compromised_credentials_actions_type::Builder {
        crate::model::compromised_credentials_actions_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CompromisedCredentialsEventActionType {
    #[allow(missing_docs)] // documentation missing in model
    Block,
    #[allow(missing_docs)] // documentation missing in model
    NoAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CompromisedCredentialsEventActionType {
    fn from(s: &str) -> Self {
        match s {
            "BLOCK" => CompromisedCredentialsEventActionType::Block,
            "NO_ACTION" => CompromisedCredentialsEventActionType::NoAction,
            other => CompromisedCredentialsEventActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CompromisedCredentialsEventActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CompromisedCredentialsEventActionType::from(s))
    }
}
impl CompromisedCredentialsEventActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CompromisedCredentialsEventActionType::Block => "BLOCK",
            CompromisedCredentialsEventActionType::NoAction => "NO_ACTION",
            CompromisedCredentialsEventActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BLOCK", "NO_ACTION"]
    }
}
impl AsRef<str> for CompromisedCredentialsEventActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventFilterType {
    #[allow(missing_docs)] // documentation missing in model
    PasswordChange,
    #[allow(missing_docs)] // documentation missing in model
    SignIn,
    #[allow(missing_docs)] // documentation missing in model
    SignUp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventFilterType {
    fn from(s: &str) -> Self {
        match s {
            "PASSWORD_CHANGE" => EventFilterType::PasswordChange,
            "SIGN_IN" => EventFilterType::SignIn,
            "SIGN_UP" => EventFilterType::SignUp,
            other => EventFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventFilterType::from(s))
    }
}
impl EventFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventFilterType::PasswordChange => "PASSWORD_CHANGE",
            EventFilterType::SignIn => "SIGN_IN",
            EventFilterType::SignUp => "SIGN_UP",
            EventFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PASSWORD_CHANGE", "SIGN_IN", "SIGN_UP"]
    }
}
impl AsRef<str> for EventFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The authentication result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationResultType {
    /// <p>The access token.</p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p>The expiration period of the authentication result in seconds.</p>
    pub expires_in: i32,
    /// <p>The token type.</p>
    pub token_type: std::option::Option<std::string::String>,
    /// <p>The refresh token.</p>
    pub refresh_token: std::option::Option<std::string::String>,
    /// <p>The ID token.</p>
    pub id_token: std::option::Option<std::string::String>,
    /// <p>The new device metadata from an authentication result.</p>
    pub new_device_metadata: std::option::Option<crate::model::NewDeviceMetadataType>,
}
impl AuthenticationResultType {
    /// <p>The access token.</p>
    pub fn access_token(&self) -> std::option::Option<&str> {
        self.access_token.as_deref()
    }
    /// <p>The expiration period of the authentication result in seconds.</p>
    pub fn expires_in(&self) -> i32 {
        self.expires_in
    }
    /// <p>The token type.</p>
    pub fn token_type(&self) -> std::option::Option<&str> {
        self.token_type.as_deref()
    }
    /// <p>The refresh token.</p>
    pub fn refresh_token(&self) -> std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
    /// <p>The ID token.</p>
    pub fn id_token(&self) -> std::option::Option<&str> {
        self.id_token.as_deref()
    }
    /// <p>The new device metadata from an authentication result.</p>
    pub fn new_device_metadata(&self) -> std::option::Option<&crate::model::NewDeviceMetadataType> {
        self.new_device_metadata.as_ref()
    }
}
impl std::fmt::Debug for AuthenticationResultType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationResultType");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expires_in", &self.expires_in);
        formatter.field("token_type", &self.token_type);
        formatter.field("refresh_token", &"*** Sensitive Data Redacted ***");
        formatter.field("id_token", &"*** Sensitive Data Redacted ***");
        formatter.field("new_device_metadata", &self.new_device_metadata);
        formatter.finish()
    }
}
/// See [`AuthenticationResultType`](crate::model::AuthenticationResultType)
pub mod authentication_result_type {
    /// A builder for [`AuthenticationResultType`](crate::model::AuthenticationResultType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) expires_in: std::option::Option<i32>,
        pub(crate) token_type: std::option::Option<std::string::String>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
        pub(crate) id_token: std::option::Option<std::string::String>,
        pub(crate) new_device_metadata: std::option::Option<crate::model::NewDeviceMetadataType>,
    }
    impl Builder {
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The expiration period of the authentication result in seconds.</p>
        pub fn expires_in(mut self, input: i32) -> Self {
            self.expires_in = Some(input);
            self
        }
        /// <p>The expiration period of the authentication result in seconds.</p>
        pub fn set_expires_in(mut self, input: std::option::Option<i32>) -> Self {
            self.expires_in = input;
            self
        }
        /// <p>The token type.</p>
        pub fn token_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_type = Some(input.into());
            self
        }
        /// <p>The token type.</p>
        pub fn set_token_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_type = input;
            self
        }
        /// <p>The refresh token.</p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p>The refresh token.</p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// <p>The ID token.</p>
        pub fn id_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.id_token = Some(input.into());
            self
        }
        /// <p>The ID token.</p>
        pub fn set_id_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id_token = input;
            self
        }
        /// <p>The new device metadata from an authentication result.</p>
        pub fn new_device_metadata(mut self, input: crate::model::NewDeviceMetadataType) -> Self {
            self.new_device_metadata = Some(input);
            self
        }
        /// <p>The new device metadata from an authentication result.</p>
        pub fn set_new_device_metadata(
            mut self,
            input: std::option::Option<crate::model::NewDeviceMetadataType>,
        ) -> Self {
            self.new_device_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationResultType`](crate::model::AuthenticationResultType)
        pub fn build(self) -> crate::model::AuthenticationResultType {
            crate::model::AuthenticationResultType {
                access_token: self.access_token,
                expires_in: self.expires_in.unwrap_or_default(),
                token_type: self.token_type,
                refresh_token: self.refresh_token,
                id_token: self.id_token,
                new_device_metadata: self.new_device_metadata,
            }
        }
    }
}
impl AuthenticationResultType {
    /// Creates a new builder-style object to manufacture [`AuthenticationResultType`](crate::model::AuthenticationResultType)
    pub fn builder() -> crate::model::authentication_result_type::Builder {
        crate::model::authentication_result_type::Builder::default()
    }
}

/// <p>The new device metadata type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewDeviceMetadataType {
    /// <p>The device key.</p>
    pub device_key: std::option::Option<std::string::String>,
    /// <p>The device group key.</p>
    pub device_group_key: std::option::Option<std::string::String>,
}
impl NewDeviceMetadataType {
    /// <p>The device key.</p>
    pub fn device_key(&self) -> std::option::Option<&str> {
        self.device_key.as_deref()
    }
    /// <p>The device group key.</p>
    pub fn device_group_key(&self) -> std::option::Option<&str> {
        self.device_group_key.as_deref()
    }
}
impl std::fmt::Debug for NewDeviceMetadataType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewDeviceMetadataType");
        formatter.field("device_key", &self.device_key);
        formatter.field("device_group_key", &self.device_group_key);
        formatter.finish()
    }
}
/// See [`NewDeviceMetadataType`](crate::model::NewDeviceMetadataType)
pub mod new_device_metadata_type {
    /// A builder for [`NewDeviceMetadataType`](crate::model::NewDeviceMetadataType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_key: std::option::Option<std::string::String>,
        pub(crate) device_group_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// <p>The device group key.</p>
        pub fn device_group_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_group_key = Some(input.into());
            self
        }
        /// <p>The device group key.</p>
        pub fn set_device_group_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_group_key = input;
            self
        }
        /// Consumes the builder and constructs a [`NewDeviceMetadataType`](crate::model::NewDeviceMetadataType)
        pub fn build(self) -> crate::model::NewDeviceMetadataType {
            crate::model::NewDeviceMetadataType {
                device_key: self.device_key,
                device_group_key: self.device_group_key,
            }
        }
    }
}
impl NewDeviceMetadataType {
    /// Creates a new builder-style object to manufacture [`NewDeviceMetadataType`](crate::model::NewDeviceMetadataType)
    pub fn builder() -> crate::model::new_device_metadata_type::Builder {
        crate::model::new_device_metadata_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChallengeNameType {
    #[allow(missing_docs)] // documentation missing in model
    AdminNoSrpAuth,
    #[allow(missing_docs)] // documentation missing in model
    CustomChallenge,
    #[allow(missing_docs)] // documentation missing in model
    DevicePasswordVerifier,
    #[allow(missing_docs)] // documentation missing in model
    DeviceSrpAuth,
    #[allow(missing_docs)] // documentation missing in model
    MfaSetup,
    #[allow(missing_docs)] // documentation missing in model
    NewPasswordRequired,
    #[allow(missing_docs)] // documentation missing in model
    PasswordVerifier,
    #[allow(missing_docs)] // documentation missing in model
    SelectMfaType,
    #[allow(missing_docs)] // documentation missing in model
    SmsMfa,
    #[allow(missing_docs)] // documentation missing in model
    SoftwareTokenMfa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChallengeNameType {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN_NO_SRP_AUTH" => ChallengeNameType::AdminNoSrpAuth,
            "CUSTOM_CHALLENGE" => ChallengeNameType::CustomChallenge,
            "DEVICE_PASSWORD_VERIFIER" => ChallengeNameType::DevicePasswordVerifier,
            "DEVICE_SRP_AUTH" => ChallengeNameType::DeviceSrpAuth,
            "MFA_SETUP" => ChallengeNameType::MfaSetup,
            "NEW_PASSWORD_REQUIRED" => ChallengeNameType::NewPasswordRequired,
            "PASSWORD_VERIFIER" => ChallengeNameType::PasswordVerifier,
            "SELECT_MFA_TYPE" => ChallengeNameType::SelectMfaType,
            "SMS_MFA" => ChallengeNameType::SmsMfa,
            "SOFTWARE_TOKEN_MFA" => ChallengeNameType::SoftwareTokenMfa,
            other => ChallengeNameType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChallengeNameType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChallengeNameType::from(s))
    }
}
impl ChallengeNameType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChallengeNameType::AdminNoSrpAuth => "ADMIN_NO_SRP_AUTH",
            ChallengeNameType::CustomChallenge => "CUSTOM_CHALLENGE",
            ChallengeNameType::DevicePasswordVerifier => "DEVICE_PASSWORD_VERIFIER",
            ChallengeNameType::DeviceSrpAuth => "DEVICE_SRP_AUTH",
            ChallengeNameType::MfaSetup => "MFA_SETUP",
            ChallengeNameType::NewPasswordRequired => "NEW_PASSWORD_REQUIRED",
            ChallengeNameType::PasswordVerifier => "PASSWORD_VERIFIER",
            ChallengeNameType::SelectMfaType => "SELECT_MFA_TYPE",
            ChallengeNameType::SmsMfa => "SMS_MFA",
            ChallengeNameType::SoftwareTokenMfa => "SOFTWARE_TOKEN_MFA",
            ChallengeNameType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADMIN_NO_SRP_AUTH",
            "CUSTOM_CHALLENGE",
            "DEVICE_PASSWORD_VERIFIER",
            "DEVICE_SRP_AUTH",
            "MFA_SETUP",
            "NEW_PASSWORD_REQUIRED",
            "PASSWORD_VERIFIER",
            "SELECT_MFA_TYPE",
            "SMS_MFA",
            "SOFTWARE_TOKEN_MFA",
        ]
    }
}
impl AsRef<str> for ChallengeNameType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The user type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserType {
    /// <p>The user name of the user you want to describe.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>A container with information about the user type attributes.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
    /// <p>The creation date of the user.</p>
    pub user_create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last modified date of the user.</p>
    pub user_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the user is enabled.</p>
    pub enabled: bool,
    /// <p>The user status. This can be one of the following:</p>
    /// <ul>
    /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
    /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
    /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
    /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
    /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
    /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
    /// </ul>
    pub user_status: std::option::Option<crate::model::UserStatusType>,
    /// <p>The MFA options for the user.</p>
    pub mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
}
impl UserType {
    /// <p>The user name of the user you want to describe.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>A container with information about the user type attributes.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::AttributeType]> {
        self.attributes.as_deref()
    }
    /// <p>The creation date of the user.</p>
    pub fn user_create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.user_create_date.as_ref()
    }
    /// <p>The last modified date of the user.</p>
    pub fn user_last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.user_last_modified_date.as_ref()
    }
    /// <p>Specifies whether the user is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The user status. This can be one of the following:</p>
    /// <ul>
    /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
    /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
    /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
    /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
    /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
    /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
    /// </ul>
    pub fn user_status(&self) -> std::option::Option<&crate::model::UserStatusType> {
        self.user_status.as_ref()
    }
    /// <p>The MFA options for the user.</p>
    pub fn mfa_options(&self) -> std::option::Option<&[crate::model::MfaOptionType]> {
        self.mfa_options.as_deref()
    }
}
impl std::fmt::Debug for UserType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserType");
        formatter.field("username", &"*** Sensitive Data Redacted ***");
        formatter.field("attributes", &self.attributes);
        formatter.field("user_create_date", &self.user_create_date);
        formatter.field("user_last_modified_date", &self.user_last_modified_date);
        formatter.field("enabled", &self.enabled);
        formatter.field("user_status", &self.user_status);
        formatter.field("mfa_options", &self.mfa_options);
        formatter.finish()
    }
}
/// See [`UserType`](crate::model::UserType)
pub mod user_type {
    /// A builder for [`UserType`](crate::model::UserType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) user_create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) user_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) user_status: std::option::Option<crate::model::UserStatusType>,
        pub(crate) mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
    }
    impl Builder {
        /// <p>The user name of the user you want to describe.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user you want to describe.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A container with information about the user type attributes.</p>
        pub fn attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>A container with information about the user type attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The creation date of the user.</p>
        pub fn user_create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.user_create_date = Some(input);
            self
        }
        /// <p>The creation date of the user.</p>
        pub fn set_user_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.user_create_date = input;
            self
        }
        /// <p>The last modified date of the user.</p>
        pub fn user_last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.user_last_modified_date = Some(input);
            self
        }
        /// <p>The last modified date of the user.</p>
        pub fn set_user_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.user_last_modified_date = input;
            self
        }
        /// <p>Specifies whether the user is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the user is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The user status. This can be one of the following:</p>
        /// <ul>
        /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
        /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
        /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
        /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
        /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
        /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
        /// </ul>
        pub fn user_status(mut self, input: crate::model::UserStatusType) -> Self {
            self.user_status = Some(input);
            self
        }
        /// <p>The user status. This can be one of the following:</p>
        /// <ul>
        /// <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li>
        /// <li> <p>CONFIRMED - User has been confirmed.</p> </li>
        /// <li> <p>ARCHIVED - User is no longer active.</p> </li>
        /// <li> <p>UNKNOWN - User status isn't known.</p> </li>
        /// <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li>
        /// <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li>
        /// </ul>
        pub fn set_user_status(
            mut self,
            input: std::option::Option<crate::model::UserStatusType>,
        ) -> Self {
            self.user_status = input;
            self
        }
        /// Appends an item to `mfa_options`.
        ///
        /// To override the contents of this collection use [`set_mfa_options`](Self::set_mfa_options).
        ///
        /// <p>The MFA options for the user.</p>
        pub fn mfa_options(mut self, input: crate::model::MfaOptionType) -> Self {
            let mut v = self.mfa_options.unwrap_or_default();
            v.push(input);
            self.mfa_options = Some(v);
            self
        }
        /// <p>The MFA options for the user.</p>
        pub fn set_mfa_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        ) -> Self {
            self.mfa_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UserType`](crate::model::UserType)
        pub fn build(self) -> crate::model::UserType {
            crate::model::UserType {
                username: self.username,
                attributes: self.attributes,
                user_create_date: self.user_create_date,
                user_last_modified_date: self.user_last_modified_date,
                enabled: self.enabled.unwrap_or_default(),
                user_status: self.user_status,
                mfa_options: self.mfa_options,
            }
        }
    }
}
impl UserType {
    /// Creates a new builder-style object to manufacture [`UserType`](crate::model::UserType)
    pub fn builder() -> crate::model::user_type::Builder {
        crate::model::user_type::Builder::default()
    }
}

/// _Note: `UserStatusType::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Archived,
    #[allow(missing_docs)] // documentation missing in model
    Compromised,
    #[allow(missing_docs)] // documentation missing in model
    Confirmed,
    #[allow(missing_docs)] // documentation missing in model
    ForceChangePassword,
    #[allow(missing_docs)] // documentation missing in model
    ResetRequired,
    #[allow(missing_docs)] // documentation missing in model
    Unconfirmed,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ARCHIVED" => UserStatusType::Archived,
            "COMPROMISED" => UserStatusType::Compromised,
            "CONFIRMED" => UserStatusType::Confirmed,
            "FORCE_CHANGE_PASSWORD" => UserStatusType::ForceChangePassword,
            "RESET_REQUIRED" => UserStatusType::ResetRequired,
            "UNCONFIRMED" => UserStatusType::Unconfirmed,
            "UNKNOWN" => UserStatusType::UnknownValue,
            other => UserStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserStatusType::from(s))
    }
}
impl UserStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserStatusType::Archived => "ARCHIVED",
            UserStatusType::Compromised => "COMPROMISED",
            UserStatusType::Confirmed => "CONFIRMED",
            UserStatusType::ForceChangePassword => "FORCE_CHANGE_PASSWORD",
            UserStatusType::ResetRequired => "RESET_REQUIRED",
            UserStatusType::Unconfirmed => "UNCONFIRMED",
            UserStatusType::UnknownValue => "UNKNOWN",
            UserStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ARCHIVED",
            "COMPROMISED",
            "CONFIRMED",
            "FORCE_CHANGE_PASSWORD",
            "RESET_REQUIRED",
            "UNCONFIRMED",
            "UNKNOWN",
        ]
    }
}
impl AsRef<str> for UserStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A user pool description.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolDescriptionType {
    /// <p>The ID in a user pool description.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name in a user pool description.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Lambda configuration information in a user pool description.</p>
    pub lambda_config: std::option::Option<crate::model::LambdaConfigType>,
    /// <p>The user pool status in a user pool description.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The date the user pool description was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the user pool description was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl UserPoolDescriptionType {
    /// <p>The ID in a user pool description.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name in a user pool description.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Lambda configuration information in a user pool description.</p>
    pub fn lambda_config(&self) -> std::option::Option<&crate::model::LambdaConfigType> {
        self.lambda_config.as_ref()
    }
    /// <p>The user pool status in a user pool description.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The date the user pool description was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the user pool description was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for UserPoolDescriptionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolDescriptionType");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("lambda_config", &self.lambda_config);
        formatter.field("status", &self.status);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`UserPoolDescriptionType`](crate::model::UserPoolDescriptionType)
pub mod user_pool_description_type {
    /// A builder for [`UserPoolDescriptionType`](crate::model::UserPoolDescriptionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) lambda_config: std::option::Option<crate::model::LambdaConfigType>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID in a user pool description.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID in a user pool description.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name in a user pool description.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name in a user pool description.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Lambda configuration information in a user pool description.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaConfigType) -> Self {
            self.lambda_config = Some(input);
            self
        }
        /// <p>The Lambda configuration information in a user pool description.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaConfigType>,
        ) -> Self {
            self.lambda_config = input;
            self
        }
        /// <p>The user pool status in a user pool description.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The user pool status in a user pool description.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date the user pool description was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the user pool description was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the user pool description was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the user pool description was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolDescriptionType`](crate::model::UserPoolDescriptionType)
        pub fn build(self) -> crate::model::UserPoolDescriptionType {
            crate::model::UserPoolDescriptionType {
                id: self.id,
                name: self.name,
                lambda_config: self.lambda_config,
                status: self.status,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
            }
        }
    }
}
impl UserPoolDescriptionType {
    /// Creates a new builder-style object to manufacture [`UserPoolDescriptionType`](crate::model::UserPoolDescriptionType)
    pub fn builder() -> crate::model::user_pool_description_type::Builder {
        crate::model::user_pool_description_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusType {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusType {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => StatusType::Disabled,
            "Enabled" => StatusType::Enabled,
            other => StatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusType::from(s))
    }
}
impl StatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusType::Disabled => "Disabled",
            StatusType::Enabled => "Enabled",
            StatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for StatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The description of the user pool client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolClientDescription {
    /// <p>The ID of the client associated with the user pool.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The user pool ID for the user pool where you want to describe the user pool client.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The client name from the user pool client description.</p>
    pub client_name: std::option::Option<std::string::String>,
}
impl UserPoolClientDescription {
    /// <p>The ID of the client associated with the user pool.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The user pool ID for the user pool where you want to describe the user pool client.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The client name from the user pool client description.</p>
    pub fn client_name(&self) -> std::option::Option<&str> {
        self.client_name.as_deref()
    }
}
impl std::fmt::Debug for UserPoolClientDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolClientDescription");
        formatter.field("client_id", &"*** Sensitive Data Redacted ***");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("client_name", &self.client_name);
        formatter.finish()
    }
}
/// See [`UserPoolClientDescription`](crate::model::UserPoolClientDescription)
pub mod user_pool_client_description {
    /// A builder for [`UserPoolClientDescription`](crate::model::UserPoolClientDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The user pool ID for the user pool where you want to describe the user pool client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to describe the user pool client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The client name from the user pool client description.</p>
        pub fn client_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_name = Some(input.into());
            self
        }
        /// <p>The client name from the user pool client description.</p>
        pub fn set_client_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolClientDescription`](crate::model::UserPoolClientDescription)
        pub fn build(self) -> crate::model::UserPoolClientDescription {
            crate::model::UserPoolClientDescription {
                client_id: self.client_id,
                user_pool_id: self.user_pool_id,
                client_name: self.client_name,
            }
        }
    }
}
impl UserPoolClientDescription {
    /// Creates a new builder-style object to manufacture [`UserPoolClientDescription`](crate::model::UserPoolClientDescription)
    pub fn builder() -> crate::model::user_pool_client_description::Builder {
        crate::model::user_pool_client_description::Builder::default()
    }
}

/// <p>A container for identity provider details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProviderDescription {
    /// <p>The identity provider name.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The identity provider type.</p>
    pub provider_type: std::option::Option<crate::model::IdentityProviderTypeType>,
    /// <p>The date the provider was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the provider was added to the user pool.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl ProviderDescription {
    /// <p>The identity provider name.</p>
    pub fn provider_name(&self) -> std::option::Option<&str> {
        self.provider_name.as_deref()
    }
    /// <p>The identity provider type.</p>
    pub fn provider_type(&self) -> std::option::Option<&crate::model::IdentityProviderTypeType> {
        self.provider_type.as_ref()
    }
    /// <p>The date the provider was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the provider was added to the user pool.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for ProviderDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProviderDescription");
        formatter.field("provider_name", &self.provider_name);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`ProviderDescription`](crate::model::ProviderDescription)
pub mod provider_description {
    /// A builder for [`ProviderDescription`](crate::model::ProviderDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::IdentityProviderTypeType>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The identity provider type.</p>
        pub fn provider_type(mut self, input: crate::model::IdentityProviderTypeType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderTypeType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// <p>The date the provider was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the provider was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the provider was added to the user pool.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the provider was added to the user pool.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ProviderDescription`](crate::model::ProviderDescription)
        pub fn build(self) -> crate::model::ProviderDescription {
            crate::model::ProviderDescription {
                provider_name: self.provider_name,
                provider_type: self.provider_type,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
            }
        }
    }
}
impl ProviderDescription {
    /// Creates a new builder-style object to manufacture [`ProviderDescription`](crate::model::ProviderDescription)
    pub fn builder() -> crate::model::provider_description::Builder {
        crate::model::provider_description::Builder::default()
    }
}

/// <p>The device type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceType {
    /// <p>The device key.</p>
    pub device_key: std::option::Option<std::string::String>,
    /// <p>The device attributes.</p>
    pub device_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
    /// <p>The creation date of the device.</p>
    pub device_create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last modified date of the device.</p>
    pub device_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the device was last authenticated.</p>
    pub device_last_authenticated_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeviceType {
    /// <p>The device key.</p>
    pub fn device_key(&self) -> std::option::Option<&str> {
        self.device_key.as_deref()
    }
    /// <p>The device attributes.</p>
    pub fn device_attributes(&self) -> std::option::Option<&[crate::model::AttributeType]> {
        self.device_attributes.as_deref()
    }
    /// <p>The creation date of the device.</p>
    pub fn device_create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.device_create_date.as_ref()
    }
    /// <p>The last modified date of the device.</p>
    pub fn device_last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.device_last_modified_date.as_ref()
    }
    /// <p>The date when the device was last authenticated.</p>
    pub fn device_last_authenticated_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.device_last_authenticated_date.as_ref()
    }
}
impl std::fmt::Debug for DeviceType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceType");
        formatter.field("device_key", &self.device_key);
        formatter.field("device_attributes", &self.device_attributes);
        formatter.field("device_create_date", &self.device_create_date);
        formatter.field("device_last_modified_date", &self.device_last_modified_date);
        formatter.field(
            "device_last_authenticated_date",
            &self.device_last_authenticated_date,
        );
        formatter.finish()
    }
}
/// See [`DeviceType`](crate::model::DeviceType)
pub mod device_type {
    /// A builder for [`DeviceType`](crate::model::DeviceType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_key: std::option::Option<std::string::String>,
        pub(crate) device_attributes:
            std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) device_create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) device_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) device_last_authenticated_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// Appends an item to `device_attributes`.
        ///
        /// To override the contents of this collection use [`set_device_attributes`](Self::set_device_attributes).
        ///
        /// <p>The device attributes.</p>
        pub fn device_attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.device_attributes.unwrap_or_default();
            v.push(input);
            self.device_attributes = Some(v);
            self
        }
        /// <p>The device attributes.</p>
        pub fn set_device_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.device_attributes = input;
            self
        }
        /// <p>The creation date of the device.</p>
        pub fn device_create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.device_create_date = Some(input);
            self
        }
        /// <p>The creation date of the device.</p>
        pub fn set_device_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.device_create_date = input;
            self
        }
        /// <p>The last modified date of the device.</p>
        pub fn device_last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.device_last_modified_date = Some(input);
            self
        }
        /// <p>The last modified date of the device.</p>
        pub fn set_device_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.device_last_modified_date = input;
            self
        }
        /// <p>The date when the device was last authenticated.</p>
        pub fn device_last_authenticated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.device_last_authenticated_date = Some(input);
            self
        }
        /// <p>The date when the device was last authenticated.</p>
        pub fn set_device_last_authenticated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.device_last_authenticated_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceType`](crate::model::DeviceType)
        pub fn build(self) -> crate::model::DeviceType {
            crate::model::DeviceType {
                device_key: self.device_key,
                device_attributes: self.device_attributes,
                device_create_date: self.device_create_date,
                device_last_modified_date: self.device_last_modified_date,
                device_last_authenticated_date: self.device_last_authenticated_date,
            }
        }
    }
}
impl DeviceType {
    /// Creates a new builder-style object to manufacture [`DeviceType`](crate::model::DeviceType)
    pub fn builder() -> crate::model::device_type::Builder {
        crate::model::device_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthFlowType {
    #[allow(missing_docs)] // documentation missing in model
    AdminNoSrpAuth,
    #[allow(missing_docs)] // documentation missing in model
    AdminUserPasswordAuth,
    #[allow(missing_docs)] // documentation missing in model
    CustomAuth,
    #[allow(missing_docs)] // documentation missing in model
    RefreshToken,
    #[allow(missing_docs)] // documentation missing in model
    RefreshTokenAuth,
    #[allow(missing_docs)] // documentation missing in model
    UserPasswordAuth,
    #[allow(missing_docs)] // documentation missing in model
    UserSrpAuth,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthFlowType {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN_NO_SRP_AUTH" => AuthFlowType::AdminNoSrpAuth,
            "ADMIN_USER_PASSWORD_AUTH" => AuthFlowType::AdminUserPasswordAuth,
            "CUSTOM_AUTH" => AuthFlowType::CustomAuth,
            "REFRESH_TOKEN" => AuthFlowType::RefreshToken,
            "REFRESH_TOKEN_AUTH" => AuthFlowType::RefreshTokenAuth,
            "USER_PASSWORD_AUTH" => AuthFlowType::UserPasswordAuth,
            "USER_SRP_AUTH" => AuthFlowType::UserSrpAuth,
            other => AuthFlowType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthFlowType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthFlowType::from(s))
    }
}
impl AuthFlowType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthFlowType::AdminNoSrpAuth => "ADMIN_NO_SRP_AUTH",
            AuthFlowType::AdminUserPasswordAuth => "ADMIN_USER_PASSWORD_AUTH",
            AuthFlowType::CustomAuth => "CUSTOM_AUTH",
            AuthFlowType::RefreshToken => "REFRESH_TOKEN",
            AuthFlowType::RefreshTokenAuth => "REFRESH_TOKEN_AUTH",
            AuthFlowType::UserPasswordAuth => "USER_PASSWORD_AUTH",
            AuthFlowType::UserSrpAuth => "USER_SRP_AUTH",
            AuthFlowType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADMIN_NO_SRP_AUTH",
            "ADMIN_USER_PASSWORD_AUTH",
            "CUSTOM_AUTH",
            "REFRESH_TOKEN",
            "REFRESH_TOKEN_AUTH",
            "USER_PASSWORD_AUTH",
            "USER_SRP_AUTH",
        ]
    }
}
impl AsRef<str> for AuthFlowType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for information about a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainDescriptionType {
    /// <p>The user pool ID.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services ID for the user pool owner.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket where the static files for this domain are stored.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.</p>
    pub cloud_front_distribution: std::option::Option<std::string::String>,
    /// <p>The app version.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The domain status.</p>
    pub status: std::option::Option<crate::model::DomainStatusType>,
    /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
    pub custom_domain_config: std::option::Option<crate::model::CustomDomainConfigType>,
}
impl DomainDescriptionType {
    /// <p>The user pool ID.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The Amazon Web Services ID for the user pool owner.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The Amazon S3 bucket where the static files for this domain are stored.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.</p>
    pub fn cloud_front_distribution(&self) -> std::option::Option<&str> {
        self.cloud_front_distribution.as_deref()
    }
    /// <p>The app version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The domain status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DomainStatusType> {
        self.status.as_ref()
    }
    /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
    pub fn custom_domain_config(
        &self,
    ) -> std::option::Option<&crate::model::CustomDomainConfigType> {
        self.custom_domain_config.as_ref()
    }
}
impl std::fmt::Debug for DomainDescriptionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainDescriptionType");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("domain", &self.domain);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("cloud_front_distribution", &self.cloud_front_distribution);
        formatter.field("version", &self.version);
        formatter.field("status", &self.status);
        formatter.field("custom_domain_config", &self.custom_domain_config);
        formatter.finish()
    }
}
/// See [`DomainDescriptionType`](crate::model::DomainDescriptionType)
pub mod domain_description_type {
    /// A builder for [`DomainDescriptionType`](crate::model::DomainDescriptionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) cloud_front_distribution: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DomainStatusType>,
        pub(crate) custom_domain_config: std::option::Option<crate::model::CustomDomainConfigType>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The Amazon Web Services ID for the user pool owner.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services ID for the user pool owner.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The Amazon S3 bucket where the static files for this domain are stored.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket where the static files for this domain are stored.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.</p>
        pub fn cloud_front_distribution(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_front_distribution = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.</p>
        pub fn set_cloud_front_distribution(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_front_distribution = input;
            self
        }
        /// <p>The app version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The app version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The domain status.</p>
        pub fn status(mut self, input: crate::model::DomainStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The domain status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
        pub fn custom_domain_config(mut self, input: crate::model::CustomDomainConfigType) -> Self {
            self.custom_domain_config = Some(input);
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
        pub fn set_custom_domain_config(
            mut self,
            input: std::option::Option<crate::model::CustomDomainConfigType>,
        ) -> Self {
            self.custom_domain_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainDescriptionType`](crate::model::DomainDescriptionType)
        pub fn build(self) -> crate::model::DomainDescriptionType {
            crate::model::DomainDescriptionType {
                user_pool_id: self.user_pool_id,
                aws_account_id: self.aws_account_id,
                domain: self.domain,
                s3_bucket: self.s3_bucket,
                cloud_front_distribution: self.cloud_front_distribution,
                version: self.version,
                status: self.status,
                custom_domain_config: self.custom_domain_config,
            }
        }
    }
}
impl DomainDescriptionType {
    /// Creates a new builder-style object to manufacture [`DomainDescriptionType`](crate::model::DomainDescriptionType)
    pub fn builder() -> crate::model::domain_description_type::Builder {
        crate::model::domain_description_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DomainStatusType::Active,
            "CREATING" => DomainStatusType::Creating,
            "DELETING" => DomainStatusType::Deleting,
            "FAILED" => DomainStatusType::Failed,
            "UPDATING" => DomainStatusType::Updating,
            other => DomainStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainStatusType::from(s))
    }
}
impl DomainStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainStatusType::Active => "ACTIVE",
            DomainStatusType::Creating => "CREATING",
            DomainStatusType::Deleting => "DELETING",
            DomainStatusType::Failed => "FAILED",
            DomainStatusType::Updating => "UPDATING",
            DomainStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for DomainStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for information about the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolType {
    /// <p>The ID of the user pool.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the user pool.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The policies associated with the user pool.</p>
    pub policies: std::option::Option<crate::model::UserPoolPolicyType>,
    /// <p>The Lambda triggers associated with the user pool.</p>
    pub lambda_config: std::option::Option<crate::model::LambdaConfigType>,
    /// <p>The status of a user pool.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The date the user pool was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the user pool was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A container with the schema attributes of a user pool.</p>
    pub schema_attributes: std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
    /// <p>The attributes that are auto-verified in a user pool.</p>
    pub auto_verified_attributes:
        std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
    /// <p>The attributes that are aliased in a user pool.</p>
    pub alias_attributes: std::option::Option<std::vec::Vec<crate::model::AliasAttributeType>>,
    /// <p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>
    pub username_attributes:
        std::option::Option<std::vec::Vec<crate::model::UsernameAttributeType>>,
    /// <p>The contents of the SMS verification message.</p>
    pub sms_verification_message: std::option::Option<std::string::String>,
    /// <p>The contents of the email verification message.</p>
    pub email_verification_message: std::option::Option<std::string::String>,
    /// <p>The subject of the email verification message.</p>
    pub email_verification_subject: std::option::Option<std::string::String>,
    /// <p>The template for verification messages.</p>
    pub verification_message_template:
        std::option::Option<crate::model::VerificationMessageTemplateType>,
    /// <p>The contents of the SMS authentication message.</p>
    pub sms_authentication_message: std::option::Option<std::string::String>,
    /// <p>Can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>OFF</code> - MFA tokens aren't required and can't be specified during user registration.</p> </li>
    /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you're initially creating a user pool.</p> </li>
    /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
    /// </ul>
    pub mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
    /// <p>The device configuration.</p>
    pub device_configuration: std::option::Option<crate::model::DeviceConfigurationType>,
    /// <p>A number estimating the size of the user pool.</p>
    pub estimated_number_of_users: i32,
    /// <p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages tfrom your user pool.</p>
    pub email_configuration: std::option::Option<crate::model::EmailConfigurationType>,
    /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>
    pub sms_configuration: std::option::Option<crate::model::SmsConfigurationType>,
    /// <p>The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    pub user_pool_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The reason why the SMS configuration can't send the messages to your users.</p>
    /// <p>This message might include comma-separated values to describe why your SMS configuration can't send messages to user pool end users.</p>
    /// <dl>
    /// <dt>
    /// InvalidSmsRoleAccessPolicyException
    /// </dt>
    /// <dd>
    /// <p>The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn't properly configured. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html">SmsConfigurationType</a>.</p>
    /// </dd>
    /// <dt>
    /// SNSSandbox
    /// </dt>
    /// <dd>
    /// <p>The Amazon Web Services account is in the SNS SMS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the IAM user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html">Moving out of the SMS sandbox</a>.</p>
    /// </dd>
    /// </dl>
    pub sms_configuration_failure: std::option::Option<std::string::String>,
    /// <p>Deprecated. Review error codes from API requests with <code>EventSource:cognito-idp.amazonaws.com</code> in CloudTrail for information about problems with user pool email configuration.</p>
    pub email_configuration_failure: std::option::Option<std::string::String>,
    /// <p>The domain prefix, if the user pool has a domain associated with it.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be <code>auth.example.com</code>.</p>
    /// <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>
    pub custom_domain: std::option::Option<std::string::String>,
    /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
    pub admin_create_user_config: std::option::Option<crate::model::AdminCreateUserConfigType>,
    /// <p>The user pool add-ons.</p>
    pub user_pool_add_ons: std::option::Option<crate::model::UserPoolAddOnsType>,
    /// <p>Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
    pub username_configuration: std::option::Option<crate::model::UsernameConfigurationType>,
    /// <p>The Amazon Resource Name (ARN) for the user pool.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
    pub account_recovery_setting: std::option::Option<crate::model::AccountRecoverySettingType>,
}
impl UserPoolType {
    /// <p>The ID of the user pool.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the user pool.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The policies associated with the user pool.</p>
    pub fn policies(&self) -> std::option::Option<&crate::model::UserPoolPolicyType> {
        self.policies.as_ref()
    }
    /// <p>The Lambda triggers associated with the user pool.</p>
    pub fn lambda_config(&self) -> std::option::Option<&crate::model::LambdaConfigType> {
        self.lambda_config.as_ref()
    }
    /// <p>The status of a user pool.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The date the user pool was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the user pool was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>A container with the schema attributes of a user pool.</p>
    pub fn schema_attributes(&self) -> std::option::Option<&[crate::model::SchemaAttributeType]> {
        self.schema_attributes.as_deref()
    }
    /// <p>The attributes that are auto-verified in a user pool.</p>
    pub fn auto_verified_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::VerifiedAttributeType]> {
        self.auto_verified_attributes.as_deref()
    }
    /// <p>The attributes that are aliased in a user pool.</p>
    pub fn alias_attributes(&self) -> std::option::Option<&[crate::model::AliasAttributeType]> {
        self.alias_attributes.as_deref()
    }
    /// <p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>
    pub fn username_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::UsernameAttributeType]> {
        self.username_attributes.as_deref()
    }
    /// <p>The contents of the SMS verification message.</p>
    pub fn sms_verification_message(&self) -> std::option::Option<&str> {
        self.sms_verification_message.as_deref()
    }
    /// <p>The contents of the email verification message.</p>
    pub fn email_verification_message(&self) -> std::option::Option<&str> {
        self.email_verification_message.as_deref()
    }
    /// <p>The subject of the email verification message.</p>
    pub fn email_verification_subject(&self) -> std::option::Option<&str> {
        self.email_verification_subject.as_deref()
    }
    /// <p>The template for verification messages.</p>
    pub fn verification_message_template(
        &self,
    ) -> std::option::Option<&crate::model::VerificationMessageTemplateType> {
        self.verification_message_template.as_ref()
    }
    /// <p>The contents of the SMS authentication message.</p>
    pub fn sms_authentication_message(&self) -> std::option::Option<&str> {
        self.sms_authentication_message.as_deref()
    }
    /// <p>Can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>OFF</code> - MFA tokens aren't required and can't be specified during user registration.</p> </li>
    /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you're initially creating a user pool.</p> </li>
    /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
    /// </ul>
    pub fn mfa_configuration(&self) -> std::option::Option<&crate::model::UserPoolMfaType> {
        self.mfa_configuration.as_ref()
    }
    /// <p>The device configuration.</p>
    pub fn device_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeviceConfigurationType> {
        self.device_configuration.as_ref()
    }
    /// <p>A number estimating the size of the user pool.</p>
    pub fn estimated_number_of_users(&self) -> i32 {
        self.estimated_number_of_users
    }
    /// <p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages tfrom your user pool.</p>
    pub fn email_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EmailConfigurationType> {
        self.email_configuration.as_ref()
    }
    /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>
    pub fn sms_configuration(&self) -> std::option::Option<&crate::model::SmsConfigurationType> {
        self.sms_configuration.as_ref()
    }
    /// <p>The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    pub fn user_pool_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.user_pool_tags.as_ref()
    }
    /// <p>The reason why the SMS configuration can't send the messages to your users.</p>
    /// <p>This message might include comma-separated values to describe why your SMS configuration can't send messages to user pool end users.</p>
    /// <dl>
    /// <dt>
    /// InvalidSmsRoleAccessPolicyException
    /// </dt>
    /// <dd>
    /// <p>The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn't properly configured. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html">SmsConfigurationType</a>.</p>
    /// </dd>
    /// <dt>
    /// SNSSandbox
    /// </dt>
    /// <dd>
    /// <p>The Amazon Web Services account is in the SNS SMS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the IAM user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html">Moving out of the SMS sandbox</a>.</p>
    /// </dd>
    /// </dl>
    pub fn sms_configuration_failure(&self) -> std::option::Option<&str> {
        self.sms_configuration_failure.as_deref()
    }
    /// <p>Deprecated. Review error codes from API requests with <code>EventSource:cognito-idp.amazonaws.com</code> in CloudTrail for information about problems with user pool email configuration.</p>
    pub fn email_configuration_failure(&self) -> std::option::Option<&str> {
        self.email_configuration_failure.as_deref()
    }
    /// <p>The domain prefix, if the user pool has a domain associated with it.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be <code>auth.example.com</code>.</p>
    /// <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>
    pub fn custom_domain(&self) -> std::option::Option<&str> {
        self.custom_domain.as_deref()
    }
    /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
    pub fn admin_create_user_config(
        &self,
    ) -> std::option::Option<&crate::model::AdminCreateUserConfigType> {
        self.admin_create_user_config.as_ref()
    }
    /// <p>The user pool add-ons.</p>
    pub fn user_pool_add_ons(&self) -> std::option::Option<&crate::model::UserPoolAddOnsType> {
        self.user_pool_add_ons.as_ref()
    }
    /// <p>Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
    pub fn username_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UsernameConfigurationType> {
        self.username_configuration.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the user pool.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
    pub fn account_recovery_setting(
        &self,
    ) -> std::option::Option<&crate::model::AccountRecoverySettingType> {
        self.account_recovery_setting.as_ref()
    }
}
impl std::fmt::Debug for UserPoolType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolType");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("policies", &self.policies);
        formatter.field("lambda_config", &self.lambda_config);
        formatter.field("status", &self.status);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("schema_attributes", &self.schema_attributes);
        formatter.field("auto_verified_attributes", &self.auto_verified_attributes);
        formatter.field("alias_attributes", &self.alias_attributes);
        formatter.field("username_attributes", &self.username_attributes);
        formatter.field("sms_verification_message", &self.sms_verification_message);
        formatter.field(
            "email_verification_message",
            &self.email_verification_message,
        );
        formatter.field(
            "email_verification_subject",
            &self.email_verification_subject,
        );
        formatter.field(
            "verification_message_template",
            &self.verification_message_template,
        );
        formatter.field(
            "sms_authentication_message",
            &self.sms_authentication_message,
        );
        formatter.field("mfa_configuration", &self.mfa_configuration);
        formatter.field("device_configuration", &self.device_configuration);
        formatter.field("estimated_number_of_users", &self.estimated_number_of_users);
        formatter.field("email_configuration", &self.email_configuration);
        formatter.field("sms_configuration", &self.sms_configuration);
        formatter.field("user_pool_tags", &self.user_pool_tags);
        formatter.field("sms_configuration_failure", &self.sms_configuration_failure);
        formatter.field(
            "email_configuration_failure",
            &self.email_configuration_failure,
        );
        formatter.field("domain", &self.domain);
        formatter.field("custom_domain", &self.custom_domain);
        formatter.field("admin_create_user_config", &self.admin_create_user_config);
        formatter.field("user_pool_add_ons", &self.user_pool_add_ons);
        formatter.field("username_configuration", &self.username_configuration);
        formatter.field("arn", &self.arn);
        formatter.field("account_recovery_setting", &self.account_recovery_setting);
        formatter.finish()
    }
}
/// See [`UserPoolType`](crate::model::UserPoolType)
pub mod user_pool_type {
    /// A builder for [`UserPoolType`](crate::model::UserPoolType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) policies: std::option::Option<crate::model::UserPoolPolicyType>,
        pub(crate) lambda_config: std::option::Option<crate::model::LambdaConfigType>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) schema_attributes:
            std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
        pub(crate) auto_verified_attributes:
            std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        pub(crate) alias_attributes:
            std::option::Option<std::vec::Vec<crate::model::AliasAttributeType>>,
        pub(crate) username_attributes:
            std::option::Option<std::vec::Vec<crate::model::UsernameAttributeType>>,
        pub(crate) sms_verification_message: std::option::Option<std::string::String>,
        pub(crate) email_verification_message: std::option::Option<std::string::String>,
        pub(crate) email_verification_subject: std::option::Option<std::string::String>,
        pub(crate) verification_message_template:
            std::option::Option<crate::model::VerificationMessageTemplateType>,
        pub(crate) sms_authentication_message: std::option::Option<std::string::String>,
        pub(crate) mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
        pub(crate) device_configuration: std::option::Option<crate::model::DeviceConfigurationType>,
        pub(crate) estimated_number_of_users: std::option::Option<i32>,
        pub(crate) email_configuration: std::option::Option<crate::model::EmailConfigurationType>,
        pub(crate) sms_configuration: std::option::Option<crate::model::SmsConfigurationType>,
        pub(crate) user_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) sms_configuration_failure: std::option::Option<std::string::String>,
        pub(crate) email_configuration_failure: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) custom_domain: std::option::Option<std::string::String>,
        pub(crate) admin_create_user_config:
            std::option::Option<crate::model::AdminCreateUserConfigType>,
        pub(crate) user_pool_add_ons: std::option::Option<crate::model::UserPoolAddOnsType>,
        pub(crate) username_configuration:
            std::option::Option<crate::model::UsernameConfigurationType>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) account_recovery_setting:
            std::option::Option<crate::model::AccountRecoverySettingType>,
    }
    impl Builder {
        /// <p>The ID of the user pool.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the user pool.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the user pool.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the user pool.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The policies associated with the user pool.</p>
        pub fn policies(mut self, input: crate::model::UserPoolPolicyType) -> Self {
            self.policies = Some(input);
            self
        }
        /// <p>The policies associated with the user pool.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<crate::model::UserPoolPolicyType>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The Lambda triggers associated with the user pool.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaConfigType) -> Self {
            self.lambda_config = Some(input);
            self
        }
        /// <p>The Lambda triggers associated with the user pool.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaConfigType>,
        ) -> Self {
            self.lambda_config = input;
            self
        }
        /// <p>The status of a user pool.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a user pool.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date the user pool was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the user pool was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the user pool was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the user pool was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Appends an item to `schema_attributes`.
        ///
        /// To override the contents of this collection use [`set_schema_attributes`](Self::set_schema_attributes).
        ///
        /// <p>A container with the schema attributes of a user pool.</p>
        pub fn schema_attributes(mut self, input: crate::model::SchemaAttributeType) -> Self {
            let mut v = self.schema_attributes.unwrap_or_default();
            v.push(input);
            self.schema_attributes = Some(v);
            self
        }
        /// <p>A container with the schema attributes of a user pool.</p>
        pub fn set_schema_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
        ) -> Self {
            self.schema_attributes = input;
            self
        }
        /// Appends an item to `auto_verified_attributes`.
        ///
        /// To override the contents of this collection use [`set_auto_verified_attributes`](Self::set_auto_verified_attributes).
        ///
        /// <p>The attributes that are auto-verified in a user pool.</p>
        pub fn auto_verified_attributes(
            mut self,
            input: crate::model::VerifiedAttributeType,
        ) -> Self {
            let mut v = self.auto_verified_attributes.unwrap_or_default();
            v.push(input);
            self.auto_verified_attributes = Some(v);
            self
        }
        /// <p>The attributes that are auto-verified in a user pool.</p>
        pub fn set_auto_verified_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        ) -> Self {
            self.auto_verified_attributes = input;
            self
        }
        /// Appends an item to `alias_attributes`.
        ///
        /// To override the contents of this collection use [`set_alias_attributes`](Self::set_alias_attributes).
        ///
        /// <p>The attributes that are aliased in a user pool.</p>
        pub fn alias_attributes(mut self, input: crate::model::AliasAttributeType) -> Self {
            let mut v = self.alias_attributes.unwrap_or_default();
            v.push(input);
            self.alias_attributes = Some(v);
            self
        }
        /// <p>The attributes that are aliased in a user pool.</p>
        pub fn set_alias_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AliasAttributeType>>,
        ) -> Self {
            self.alias_attributes = input;
            self
        }
        /// Appends an item to `username_attributes`.
        ///
        /// To override the contents of this collection use [`set_username_attributes`](Self::set_username_attributes).
        ///
        /// <p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>
        pub fn username_attributes(mut self, input: crate::model::UsernameAttributeType) -> Self {
            let mut v = self.username_attributes.unwrap_or_default();
            v.push(input);
            self.username_attributes = Some(v);
            self
        }
        /// <p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>
        pub fn set_username_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsernameAttributeType>>,
        ) -> Self {
            self.username_attributes = input;
            self
        }
        /// <p>The contents of the SMS verification message.</p>
        pub fn sms_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_verification_message = Some(input.into());
            self
        }
        /// <p>The contents of the SMS verification message.</p>
        pub fn set_sms_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_verification_message = input;
            self
        }
        /// <p>The contents of the email verification message.</p>
        pub fn email_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_verification_message = Some(input.into());
            self
        }
        /// <p>The contents of the email verification message.</p>
        pub fn set_email_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_verification_message = input;
            self
        }
        /// <p>The subject of the email verification message.</p>
        pub fn email_verification_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_verification_subject = Some(input.into());
            self
        }
        /// <p>The subject of the email verification message.</p>
        pub fn set_email_verification_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_verification_subject = input;
            self
        }
        /// <p>The template for verification messages.</p>
        pub fn verification_message_template(
            mut self,
            input: crate::model::VerificationMessageTemplateType,
        ) -> Self {
            self.verification_message_template = Some(input);
            self
        }
        /// <p>The template for verification messages.</p>
        pub fn set_verification_message_template(
            mut self,
            input: std::option::Option<crate::model::VerificationMessageTemplateType>,
        ) -> Self {
            self.verification_message_template = input;
            self
        }
        /// <p>The contents of the SMS authentication message.</p>
        pub fn sms_authentication_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_authentication_message = Some(input.into());
            self
        }
        /// <p>The contents of the SMS authentication message.</p>
        pub fn set_sms_authentication_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_authentication_message = input;
            self
        }
        /// <p>Can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> - MFA tokens aren't required and can't be specified during user registration.</p> </li>
        /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you're initially creating a user pool.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
        /// </ul>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.mfa_configuration = Some(input);
            self
        }
        /// <p>Can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> - MFA tokens aren't required and can't be specified during user registration.</p> </li>
        /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you're initially creating a user pool.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
        /// </ul>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.mfa_configuration = input;
            self
        }
        /// <p>The device configuration.</p>
        pub fn device_configuration(
            mut self,
            input: crate::model::DeviceConfigurationType,
        ) -> Self {
            self.device_configuration = Some(input);
            self
        }
        /// <p>The device configuration.</p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfigurationType>,
        ) -> Self {
            self.device_configuration = input;
            self
        }
        /// <p>A number estimating the size of the user pool.</p>
        pub fn estimated_number_of_users(mut self, input: i32) -> Self {
            self.estimated_number_of_users = Some(input);
            self
        }
        /// <p>A number estimating the size of the user pool.</p>
        pub fn set_estimated_number_of_users(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_number_of_users = input;
            self
        }
        /// <p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages tfrom your user pool.</p>
        pub fn email_configuration(mut self, input: crate::model::EmailConfigurationType) -> Self {
            self.email_configuration = Some(input);
            self
        }
        /// <p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages tfrom your user pool.</p>
        pub fn set_email_configuration(
            mut self,
            input: std::option::Option<crate::model::EmailConfigurationType>,
        ) -> Self {
            self.email_configuration = input;
            self
        }
        /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>
        pub fn sms_configuration(mut self, input: crate::model::SmsConfigurationType) -> Self {
            self.sms_configuration = Some(input);
            self
        }
        /// <p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>
        pub fn set_sms_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsConfigurationType>,
        ) -> Self {
            self.sms_configuration = input;
            self
        }
        /// Adds a key-value pair to `user_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_user_pool_tags`](Self::set_user_pool_tags).
        ///
        /// <p>The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn user_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_pool_tags = Some(hash_map);
            self
        }
        /// <p>The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn set_user_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_pool_tags = input;
            self
        }
        /// <p>The reason why the SMS configuration can't send the messages to your users.</p>
        /// <p>This message might include comma-separated values to describe why your SMS configuration can't send messages to user pool end users.</p>
        /// <dl>
        /// <dt>
        /// InvalidSmsRoleAccessPolicyException
        /// </dt>
        /// <dd>
        /// <p>The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn't properly configured. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html">SmsConfigurationType</a>.</p>
        /// </dd>
        /// <dt>
        /// SNSSandbox
        /// </dt>
        /// <dd>
        /// <p>The Amazon Web Services account is in the SNS SMS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the IAM user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html">Moving out of the SMS sandbox</a>.</p>
        /// </dd>
        /// </dl>
        pub fn sms_configuration_failure(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_configuration_failure = Some(input.into());
            self
        }
        /// <p>The reason why the SMS configuration can't send the messages to your users.</p>
        /// <p>This message might include comma-separated values to describe why your SMS configuration can't send messages to user pool end users.</p>
        /// <dl>
        /// <dt>
        /// InvalidSmsRoleAccessPolicyException
        /// </dt>
        /// <dd>
        /// <p>The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn't properly configured. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html">SmsConfigurationType</a>.</p>
        /// </dd>
        /// <dt>
        /// SNSSandbox
        /// </dt>
        /// <dd>
        /// <p>The Amazon Web Services account is in the SNS SMS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the IAM user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html">Moving out of the SMS sandbox</a>.</p>
        /// </dd>
        /// </dl>
        pub fn set_sms_configuration_failure(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_configuration_failure = input;
            self
        }
        /// <p>Deprecated. Review error codes from API requests with <code>EventSource:cognito-idp.amazonaws.com</code> in CloudTrail for information about problems with user pool email configuration.</p>
        pub fn email_configuration_failure(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.email_configuration_failure = Some(input.into());
            self
        }
        /// <p>Deprecated. Review error codes from API requests with <code>EventSource:cognito-idp.amazonaws.com</code> in CloudTrail for information about problems with user pool email configuration.</p>
        pub fn set_email_configuration_failure(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_configuration_failure = input;
            self
        }
        /// <p>The domain prefix, if the user pool has a domain associated with it.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain prefix, if the user pool has a domain associated with it.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be <code>auth.example.com</code>.</p>
        /// <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>
        pub fn custom_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_domain = Some(input.into());
            self
        }
        /// <p>A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be <code>auth.example.com</code>.</p>
        /// <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>
        pub fn set_custom_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_domain = input;
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn admin_create_user_config(
            mut self,
            input: crate::model::AdminCreateUserConfigType,
        ) -> Self {
            self.admin_create_user_config = Some(input);
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn set_admin_create_user_config(
            mut self,
            input: std::option::Option<crate::model::AdminCreateUserConfigType>,
        ) -> Self {
            self.admin_create_user_config = input;
            self
        }
        /// <p>The user pool add-ons.</p>
        pub fn user_pool_add_ons(mut self, input: crate::model::UserPoolAddOnsType) -> Self {
            self.user_pool_add_ons = Some(input);
            self
        }
        /// <p>The user pool add-ons.</p>
        pub fn set_user_pool_add_ons(
            mut self,
            input: std::option::Option<crate::model::UserPoolAddOnsType>,
        ) -> Self {
            self.user_pool_add_ons = input;
            self
        }
        /// <p>Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
        pub fn username_configuration(
            mut self,
            input: crate::model::UsernameConfigurationType,
        ) -> Self {
            self.username_configuration = Some(input);
            self
        }
        /// <p>Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
        pub fn set_username_configuration(
            mut self,
            input: std::option::Option<crate::model::UsernameConfigurationType>,
        ) -> Self {
            self.username_configuration = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the user pool.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the user pool.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
        pub fn account_recovery_setting(
            mut self,
            input: crate::model::AccountRecoverySettingType,
        ) -> Self {
            self.account_recovery_setting = Some(input);
            self
        }
        /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
        pub fn set_account_recovery_setting(
            mut self,
            input: std::option::Option<crate::model::AccountRecoverySettingType>,
        ) -> Self {
            self.account_recovery_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolType`](crate::model::UserPoolType)
        pub fn build(self) -> crate::model::UserPoolType {
            crate::model::UserPoolType {
                id: self.id,
                name: self.name,
                policies: self.policies,
                lambda_config: self.lambda_config,
                status: self.status,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
                schema_attributes: self.schema_attributes,
                auto_verified_attributes: self.auto_verified_attributes,
                alias_attributes: self.alias_attributes,
                username_attributes: self.username_attributes,
                sms_verification_message: self.sms_verification_message,
                email_verification_message: self.email_verification_message,
                email_verification_subject: self.email_verification_subject,
                verification_message_template: self.verification_message_template,
                sms_authentication_message: self.sms_authentication_message,
                mfa_configuration: self.mfa_configuration,
                device_configuration: self.device_configuration,
                estimated_number_of_users: self.estimated_number_of_users.unwrap_or_default(),
                email_configuration: self.email_configuration,
                sms_configuration: self.sms_configuration,
                user_pool_tags: self.user_pool_tags,
                sms_configuration_failure: self.sms_configuration_failure,
                email_configuration_failure: self.email_configuration_failure,
                domain: self.domain,
                custom_domain: self.custom_domain,
                admin_create_user_config: self.admin_create_user_config,
                user_pool_add_ons: self.user_pool_add_ons,
                username_configuration: self.username_configuration,
                arn: self.arn,
                account_recovery_setting: self.account_recovery_setting,
            }
        }
    }
}
impl UserPoolType {
    /// Creates a new builder-style object to manufacture [`UserPoolType`](crate::model::UserPoolType)
    pub fn builder() -> crate::model::user_pool_type::Builder {
        crate::model::user_pool_type::Builder::default()
    }
}

/// <p>The username configuration type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsernameConfigurationType {
    /// <p>Specifies whether username case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.</p>
    /// <p>Valid values include:</p>
    /// <dl>
    /// <dt>
    /// True
    /// </dt>
    /// <dd>
    /// <p>Enables case sensitivity for all username input. When this option is set to <code>True</code>, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</p>
    /// </dd>
    /// <dt>
    /// False
    /// </dt>
    /// <dd>
    /// <p>Enables case insensitivity for all username input. For example, when this option is set to <code>False</code>, users can sign in using either "username" or "Username". This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</p>
    /// </dd>
    /// </dl>
    pub case_sensitive: std::option::Option<bool>,
}
impl UsernameConfigurationType {
    /// <p>Specifies whether username case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.</p>
    /// <p>Valid values include:</p>
    /// <dl>
    /// <dt>
    /// True
    /// </dt>
    /// <dd>
    /// <p>Enables case sensitivity for all username input. When this option is set to <code>True</code>, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</p>
    /// </dd>
    /// <dt>
    /// False
    /// </dt>
    /// <dd>
    /// <p>Enables case insensitivity for all username input. For example, when this option is set to <code>False</code>, users can sign in using either "username" or "Username". This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</p>
    /// </dd>
    /// </dl>
    pub fn case_sensitive(&self) -> std::option::Option<bool> {
        self.case_sensitive
    }
}
impl std::fmt::Debug for UsernameConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsernameConfigurationType");
        formatter.field("case_sensitive", &self.case_sensitive);
        formatter.finish()
    }
}
/// See [`UsernameConfigurationType`](crate::model::UsernameConfigurationType)
pub mod username_configuration_type {
    /// A builder for [`UsernameConfigurationType`](crate::model::UsernameConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) case_sensitive: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether username case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.</p>
        /// <p>Valid values include:</p>
        /// <dl>
        /// <dt>
        /// True
        /// </dt>
        /// <dd>
        /// <p>Enables case sensitivity for all username input. When this option is set to <code>True</code>, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</p>
        /// </dd>
        /// <dt>
        /// False
        /// </dt>
        /// <dd>
        /// <p>Enables case insensitivity for all username input. For example, when this option is set to <code>False</code>, users can sign in using either "username" or "Username". This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</p>
        /// </dd>
        /// </dl>
        pub fn case_sensitive(mut self, input: bool) -> Self {
            self.case_sensitive = Some(input);
            self
        }
        /// <p>Specifies whether username case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.</p>
        /// <p>Valid values include:</p>
        /// <dl>
        /// <dt>
        /// True
        /// </dt>
        /// <dd>
        /// <p>Enables case sensitivity for all username input. When this option is set to <code>True</code>, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</p>
        /// </dd>
        /// <dt>
        /// False
        /// </dt>
        /// <dd>
        /// <p>Enables case insensitivity for all username input. For example, when this option is set to <code>False</code>, users can sign in using either "username" or "Username". This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</p>
        /// </dd>
        /// </dl>
        pub fn set_case_sensitive(mut self, input: std::option::Option<bool>) -> Self {
            self.case_sensitive = input;
            self
        }
        /// Consumes the builder and constructs a [`UsernameConfigurationType`](crate::model::UsernameConfigurationType)
        pub fn build(self) -> crate::model::UsernameConfigurationType {
            crate::model::UsernameConfigurationType {
                case_sensitive: self.case_sensitive,
            }
        }
    }
}
impl UsernameConfigurationType {
    /// Creates a new builder-style object to manufacture [`UsernameConfigurationType`](crate::model::UsernameConfigurationType)
    pub fn builder() -> crate::model::username_configuration_type::Builder {
        crate::model::username_configuration_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsernameAttributeType {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsernameAttributeType {
    fn from(s: &str) -> Self {
        match s {
            "email" => UsernameAttributeType::Email,
            "phone_number" => UsernameAttributeType::PhoneNumber,
            other => UsernameAttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsernameAttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsernameAttributeType::from(s))
    }
}
impl UsernameAttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsernameAttributeType::Email => "email",
            UsernameAttributeType::PhoneNumber => "phone_number",
            UsernameAttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["email", "phone_number"]
    }
}
impl AsRef<str> for UsernameAttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AliasAttributeType {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    PreferredUsername,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AliasAttributeType {
    fn from(s: &str) -> Self {
        match s {
            "email" => AliasAttributeType::Email,
            "phone_number" => AliasAttributeType::PhoneNumber,
            "preferred_username" => AliasAttributeType::PreferredUsername,
            other => AliasAttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AliasAttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AliasAttributeType::from(s))
    }
}
impl AliasAttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AliasAttributeType::Email => "email",
            AliasAttributeType::PhoneNumber => "phone_number",
            AliasAttributeType::PreferredUsername => "preferred_username",
            AliasAttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["email", "phone_number", "preferred_username"]
    }
}
impl AsRef<str> for AliasAttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the schema attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaAttributeType {
    /// <p>A schema attribute of the name type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The attribute data type.</p>
    pub attribute_data_type: std::option::Option<crate::model::AttributeDataType>,
    /// <note>
    /// <p>You should use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes">WriteAttributes</a> in the user pool client to control how attributes can be mutated for new use cases instead of using <code>DeveloperOnlyAttribute</code>.</p>
    /// </note>
    /// <p>Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, <code>DeveloperOnlyAttribute</code> can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.</p>
    pub developer_only_attribute: std::option::Option<bool>,
    /// <p>Specifies whether the value of the attribute can be changed.</p>
    /// <p>For any user pool attribute that is mapped to an identity provider attribute, you must set this parameter to <code>true</code>. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
    pub mutable: std::option::Option<bool>,
    /// <p>Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.</p>
    pub required: std::option::Option<bool>,
    /// <p>Specifies the constraints for an attribute of the number type.</p>
    pub number_attribute_constraints:
        std::option::Option<crate::model::NumberAttributeConstraintsType>,
    /// <p>Specifies the constraints for an attribute of the string type.</p>
    pub string_attribute_constraints:
        std::option::Option<crate::model::StringAttributeConstraintsType>,
}
impl SchemaAttributeType {
    /// <p>A schema attribute of the name type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The attribute data type.</p>
    pub fn attribute_data_type(&self) -> std::option::Option<&crate::model::AttributeDataType> {
        self.attribute_data_type.as_ref()
    }
    /// <note>
    /// <p>You should use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes">WriteAttributes</a> in the user pool client to control how attributes can be mutated for new use cases instead of using <code>DeveloperOnlyAttribute</code>.</p>
    /// </note>
    /// <p>Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, <code>DeveloperOnlyAttribute</code> can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.</p>
    pub fn developer_only_attribute(&self) -> std::option::Option<bool> {
        self.developer_only_attribute
    }
    /// <p>Specifies whether the value of the attribute can be changed.</p>
    /// <p>For any user pool attribute that is mapped to an identity provider attribute, you must set this parameter to <code>true</code>. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
    pub fn mutable(&self) -> std::option::Option<bool> {
        self.mutable
    }
    /// <p>Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.</p>
    pub fn required(&self) -> std::option::Option<bool> {
        self.required
    }
    /// <p>Specifies the constraints for an attribute of the number type.</p>
    pub fn number_attribute_constraints(
        &self,
    ) -> std::option::Option<&crate::model::NumberAttributeConstraintsType> {
        self.number_attribute_constraints.as_ref()
    }
    /// <p>Specifies the constraints for an attribute of the string type.</p>
    pub fn string_attribute_constraints(
        &self,
    ) -> std::option::Option<&crate::model::StringAttributeConstraintsType> {
        self.string_attribute_constraints.as_ref()
    }
}
impl std::fmt::Debug for SchemaAttributeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaAttributeType");
        formatter.field("name", &self.name);
        formatter.field("attribute_data_type", &self.attribute_data_type);
        formatter.field("developer_only_attribute", &self.developer_only_attribute);
        formatter.field("mutable", &self.mutable);
        formatter.field("required", &self.required);
        formatter.field(
            "number_attribute_constraints",
            &self.number_attribute_constraints,
        );
        formatter.field(
            "string_attribute_constraints",
            &self.string_attribute_constraints,
        );
        formatter.finish()
    }
}
/// See [`SchemaAttributeType`](crate::model::SchemaAttributeType)
pub mod schema_attribute_type {
    /// A builder for [`SchemaAttributeType`](crate::model::SchemaAttributeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attribute_data_type: std::option::Option<crate::model::AttributeDataType>,
        pub(crate) developer_only_attribute: std::option::Option<bool>,
        pub(crate) mutable: std::option::Option<bool>,
        pub(crate) required: std::option::Option<bool>,
        pub(crate) number_attribute_constraints:
            std::option::Option<crate::model::NumberAttributeConstraintsType>,
        pub(crate) string_attribute_constraints:
            std::option::Option<crate::model::StringAttributeConstraintsType>,
    }
    impl Builder {
        /// <p>A schema attribute of the name type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A schema attribute of the name type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The attribute data type.</p>
        pub fn attribute_data_type(mut self, input: crate::model::AttributeDataType) -> Self {
            self.attribute_data_type = Some(input);
            self
        }
        /// <p>The attribute data type.</p>
        pub fn set_attribute_data_type(
            mut self,
            input: std::option::Option<crate::model::AttributeDataType>,
        ) -> Self {
            self.attribute_data_type = input;
            self
        }
        /// <note>
        /// <p>You should use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes">WriteAttributes</a> in the user pool client to control how attributes can be mutated for new use cases instead of using <code>DeveloperOnlyAttribute</code>.</p>
        /// </note>
        /// <p>Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, <code>DeveloperOnlyAttribute</code> can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.</p>
        pub fn developer_only_attribute(mut self, input: bool) -> Self {
            self.developer_only_attribute = Some(input);
            self
        }
        /// <note>
        /// <p>You should use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes">WriteAttributes</a> in the user pool client to control how attributes can be mutated for new use cases instead of using <code>DeveloperOnlyAttribute</code>.</p>
        /// </note>
        /// <p>Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, <code>DeveloperOnlyAttribute</code> can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.</p>
        pub fn set_developer_only_attribute(mut self, input: std::option::Option<bool>) -> Self {
            self.developer_only_attribute = input;
            self
        }
        /// <p>Specifies whether the value of the attribute can be changed.</p>
        /// <p>For any user pool attribute that is mapped to an identity provider attribute, you must set this parameter to <code>true</code>. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
        pub fn mutable(mut self, input: bool) -> Self {
            self.mutable = Some(input);
            self
        }
        /// <p>Specifies whether the value of the attribute can be changed.</p>
        /// <p>For any user pool attribute that is mapped to an identity provider attribute, you must set this parameter to <code>true</code>. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
        pub fn set_mutable(mut self, input: std::option::Option<bool>) -> Self {
            self.mutable = input;
            self
        }
        /// <p>Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.</p>
        pub fn required(mut self, input: bool) -> Self {
            self.required = Some(input);
            self
        }
        /// <p>Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.</p>
        pub fn set_required(mut self, input: std::option::Option<bool>) -> Self {
            self.required = input;
            self
        }
        /// <p>Specifies the constraints for an attribute of the number type.</p>
        pub fn number_attribute_constraints(
            mut self,
            input: crate::model::NumberAttributeConstraintsType,
        ) -> Self {
            self.number_attribute_constraints = Some(input);
            self
        }
        /// <p>Specifies the constraints for an attribute of the number type.</p>
        pub fn set_number_attribute_constraints(
            mut self,
            input: std::option::Option<crate::model::NumberAttributeConstraintsType>,
        ) -> Self {
            self.number_attribute_constraints = input;
            self
        }
        /// <p>Specifies the constraints for an attribute of the string type.</p>
        pub fn string_attribute_constraints(
            mut self,
            input: crate::model::StringAttributeConstraintsType,
        ) -> Self {
            self.string_attribute_constraints = Some(input);
            self
        }
        /// <p>Specifies the constraints for an attribute of the string type.</p>
        pub fn set_string_attribute_constraints(
            mut self,
            input: std::option::Option<crate::model::StringAttributeConstraintsType>,
        ) -> Self {
            self.string_attribute_constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaAttributeType`](crate::model::SchemaAttributeType)
        pub fn build(self) -> crate::model::SchemaAttributeType {
            crate::model::SchemaAttributeType {
                name: self.name,
                attribute_data_type: self.attribute_data_type,
                developer_only_attribute: self.developer_only_attribute,
                mutable: self.mutable,
                required: self.required,
                number_attribute_constraints: self.number_attribute_constraints,
                string_attribute_constraints: self.string_attribute_constraints,
            }
        }
    }
}
impl SchemaAttributeType {
    /// Creates a new builder-style object to manufacture [`SchemaAttributeType`](crate::model::SchemaAttributeType)
    pub fn builder() -> crate::model::schema_attribute_type::Builder {
        crate::model::schema_attribute_type::Builder::default()
    }
}

/// <p>The constraints associated with a string attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StringAttributeConstraintsType {
    /// <p>The minimum length.</p>
    pub min_length: std::option::Option<std::string::String>,
    /// <p>The maximum length.</p>
    pub max_length: std::option::Option<std::string::String>,
}
impl StringAttributeConstraintsType {
    /// <p>The minimum length.</p>
    pub fn min_length(&self) -> std::option::Option<&str> {
        self.min_length.as_deref()
    }
    /// <p>The maximum length.</p>
    pub fn max_length(&self) -> std::option::Option<&str> {
        self.max_length.as_deref()
    }
}
impl std::fmt::Debug for StringAttributeConstraintsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StringAttributeConstraintsType");
        formatter.field("min_length", &self.min_length);
        formatter.field("max_length", &self.max_length);
        formatter.finish()
    }
}
/// See [`StringAttributeConstraintsType`](crate::model::StringAttributeConstraintsType)
pub mod string_attribute_constraints_type {
    /// A builder for [`StringAttributeConstraintsType`](crate::model::StringAttributeConstraintsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_length: std::option::Option<std::string::String>,
        pub(crate) max_length: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The minimum length.</p>
        pub fn min_length(mut self, input: impl Into<std::string::String>) -> Self {
            self.min_length = Some(input.into());
            self
        }
        /// <p>The minimum length.</p>
        pub fn set_min_length(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.min_length = input;
            self
        }
        /// <p>The maximum length.</p>
        pub fn max_length(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_length = Some(input.into());
            self
        }
        /// <p>The maximum length.</p>
        pub fn set_max_length(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_length = input;
            self
        }
        /// Consumes the builder and constructs a [`StringAttributeConstraintsType`](crate::model::StringAttributeConstraintsType)
        pub fn build(self) -> crate::model::StringAttributeConstraintsType {
            crate::model::StringAttributeConstraintsType {
                min_length: self.min_length,
                max_length: self.max_length,
            }
        }
    }
}
impl StringAttributeConstraintsType {
    /// Creates a new builder-style object to manufacture [`StringAttributeConstraintsType`](crate::model::StringAttributeConstraintsType)
    pub fn builder() -> crate::model::string_attribute_constraints_type::Builder {
        crate::model::string_attribute_constraints_type::Builder::default()
    }
}

/// <p>The minimum and maximum values of an attribute that is of the number data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NumberAttributeConstraintsType {
    /// <p>The minimum value of an attribute that is of the number data type.</p>
    pub min_value: std::option::Option<std::string::String>,
    /// <p>The maximum value of an attribute that is of the number data type.</p>
    pub max_value: std::option::Option<std::string::String>,
}
impl NumberAttributeConstraintsType {
    /// <p>The minimum value of an attribute that is of the number data type.</p>
    pub fn min_value(&self) -> std::option::Option<&str> {
        self.min_value.as_deref()
    }
    /// <p>The maximum value of an attribute that is of the number data type.</p>
    pub fn max_value(&self) -> std::option::Option<&str> {
        self.max_value.as_deref()
    }
}
impl std::fmt::Debug for NumberAttributeConstraintsType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NumberAttributeConstraintsType");
        formatter.field("min_value", &self.min_value);
        formatter.field("max_value", &self.max_value);
        formatter.finish()
    }
}
/// See [`NumberAttributeConstraintsType`](crate::model::NumberAttributeConstraintsType)
pub mod number_attribute_constraints_type {
    /// A builder for [`NumberAttributeConstraintsType`](crate::model::NumberAttributeConstraintsType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_value: std::option::Option<std::string::String>,
        pub(crate) max_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The minimum value of an attribute that is of the number data type.</p>
        pub fn min_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.min_value = Some(input.into());
            self
        }
        /// <p>The minimum value of an attribute that is of the number data type.</p>
        pub fn set_min_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The maximum value of an attribute that is of the number data type.</p>
        pub fn max_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_value = Some(input.into());
            self
        }
        /// <p>The maximum value of an attribute that is of the number data type.</p>
        pub fn set_max_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_value = input;
            self
        }
        /// Consumes the builder and constructs a [`NumberAttributeConstraintsType`](crate::model::NumberAttributeConstraintsType)
        pub fn build(self) -> crate::model::NumberAttributeConstraintsType {
            crate::model::NumberAttributeConstraintsType {
                min_value: self.min_value,
                max_value: self.max_value,
            }
        }
    }
}
impl NumberAttributeConstraintsType {
    /// Creates a new builder-style object to manufacture [`NumberAttributeConstraintsType`](crate::model::NumberAttributeConstraintsType)
    pub fn builder() -> crate::model::number_attribute_constraints_type::Builder {
        crate::model::number_attribute_constraints_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttributeDataType {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Datetime,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttributeDataType {
    fn from(s: &str) -> Self {
        match s {
            "Boolean" => AttributeDataType::Boolean,
            "DateTime" => AttributeDataType::Datetime,
            "Number" => AttributeDataType::Number,
            "String" => AttributeDataType::String,
            other => AttributeDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttributeDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttributeDataType::from(s))
    }
}
impl AttributeDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttributeDataType::Boolean => "Boolean",
            AttributeDataType::Datetime => "DateTime",
            AttributeDataType::Number => "Number",
            AttributeDataType::String => "String",
            AttributeDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Boolean", "DateTime", "Number", "String"]
    }
}
impl AsRef<str> for AttributeDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The device verifier against which it is authenticated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceSecretVerifierConfigType {
    /// <p>The password verifier.</p>
    pub password_verifier: std::option::Option<std::string::String>,
    /// <p>The salt.</p>
    pub salt: std::option::Option<std::string::String>,
}
impl DeviceSecretVerifierConfigType {
    /// <p>The password verifier.</p>
    pub fn password_verifier(&self) -> std::option::Option<&str> {
        self.password_verifier.as_deref()
    }
    /// <p>The salt.</p>
    pub fn salt(&self) -> std::option::Option<&str> {
        self.salt.as_deref()
    }
}
impl std::fmt::Debug for DeviceSecretVerifierConfigType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceSecretVerifierConfigType");
        formatter.field("password_verifier", &self.password_verifier);
        formatter.field("salt", &self.salt);
        formatter.finish()
    }
}
/// See [`DeviceSecretVerifierConfigType`](crate::model::DeviceSecretVerifierConfigType)
pub mod device_secret_verifier_config_type {
    /// A builder for [`DeviceSecretVerifierConfigType`](crate::model::DeviceSecretVerifierConfigType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) password_verifier: std::option::Option<std::string::String>,
        pub(crate) salt: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The password verifier.</p>
        pub fn password_verifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.password_verifier = Some(input.into());
            self
        }
        /// <p>The password verifier.</p>
        pub fn set_password_verifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.password_verifier = input;
            self
        }
        /// <p>The salt.</p>
        pub fn salt(mut self, input: impl Into<std::string::String>) -> Self {
            self.salt = Some(input.into());
            self
        }
        /// <p>The salt.</p>
        pub fn set_salt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.salt = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceSecretVerifierConfigType`](crate::model::DeviceSecretVerifierConfigType)
        pub fn build(self) -> crate::model::DeviceSecretVerifierConfigType {
            crate::model::DeviceSecretVerifierConfigType {
                password_verifier: self.password_verifier,
                salt: self.salt,
            }
        }
    }
}
impl DeviceSecretVerifierConfigType {
    /// Creates a new builder-style object to manufacture [`DeviceSecretVerifierConfigType`](crate::model::DeviceSecretVerifierConfigType)
    pub fn builder() -> crate::model::device_secret_verifier_config_type::Builder {
        crate::model::device_secret_verifier_config_type::Builder::default()
    }
}

/// <p>Contextual user data type used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContextDataType {
    /// <p>Source IP address of your user.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>Your server endpoint where this API is invoked.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Your server path where this API is invoked.</p>
    pub server_path: std::option::Option<std::string::String>,
    /// <p>HttpHeaders received on your server in same order.</p>
    pub http_headers: std::option::Option<std::vec::Vec<crate::model::HttpHeader>>,
    /// <p>Encoded data containing device fingerprinting details collected using the Amazon Cognito context data collection library.</p>
    pub encoded_data: std::option::Option<std::string::String>,
}
impl ContextDataType {
    /// <p>Source IP address of your user.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>Your server endpoint where this API is invoked.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Your server path where this API is invoked.</p>
    pub fn server_path(&self) -> std::option::Option<&str> {
        self.server_path.as_deref()
    }
    /// <p>HttpHeaders received on your server in same order.</p>
    pub fn http_headers(&self) -> std::option::Option<&[crate::model::HttpHeader]> {
        self.http_headers.as_deref()
    }
    /// <p>Encoded data containing device fingerprinting details collected using the Amazon Cognito context data collection library.</p>
    pub fn encoded_data(&self) -> std::option::Option<&str> {
        self.encoded_data.as_deref()
    }
}
impl std::fmt::Debug for ContextDataType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContextDataType");
        formatter.field("ip_address", &self.ip_address);
        formatter.field("server_name", &self.server_name);
        formatter.field("server_path", &self.server_path);
        formatter.field("http_headers", &self.http_headers);
        formatter.field("encoded_data", &self.encoded_data);
        formatter.finish()
    }
}
/// See [`ContextDataType`](crate::model::ContextDataType)
pub mod context_data_type {
    /// A builder for [`ContextDataType`](crate::model::ContextDataType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) server_path: std::option::Option<std::string::String>,
        pub(crate) http_headers: std::option::Option<std::vec::Vec<crate::model::HttpHeader>>,
        pub(crate) encoded_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source IP address of your user.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>Source IP address of your user.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>Your server endpoint where this API is invoked.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Your server endpoint where this API is invoked.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Your server path where this API is invoked.</p>
        pub fn server_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_path = Some(input.into());
            self
        }
        /// <p>Your server path where this API is invoked.</p>
        pub fn set_server_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_path = input;
            self
        }
        /// Appends an item to `http_headers`.
        ///
        /// To override the contents of this collection use [`set_http_headers`](Self::set_http_headers).
        ///
        /// <p>HttpHeaders received on your server in same order.</p>
        pub fn http_headers(mut self, input: crate::model::HttpHeader) -> Self {
            let mut v = self.http_headers.unwrap_or_default();
            v.push(input);
            self.http_headers = Some(v);
            self
        }
        /// <p>HttpHeaders received on your server in same order.</p>
        pub fn set_http_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpHeader>>,
        ) -> Self {
            self.http_headers = input;
            self
        }
        /// <p>Encoded data containing device fingerprinting details collected using the Amazon Cognito context data collection library.</p>
        pub fn encoded_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.encoded_data = Some(input.into());
            self
        }
        /// <p>Encoded data containing device fingerprinting details collected using the Amazon Cognito context data collection library.</p>
        pub fn set_encoded_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.encoded_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ContextDataType`](crate::model::ContextDataType)
        pub fn build(self) -> crate::model::ContextDataType {
            crate::model::ContextDataType {
                ip_address: self.ip_address,
                server_name: self.server_name,
                server_path: self.server_path,
                http_headers: self.http_headers,
                encoded_data: self.encoded_data,
            }
        }
    }
}
impl ContextDataType {
    /// Creates a new builder-style object to manufacture [`ContextDataType`](crate::model::ContextDataType)
    pub fn builder() -> crate::model::context_data_type::Builder {
        crate::model::context_data_type::Builder::default()
    }
}

/// <p>The HTTP header.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpHeader {
    /// <p>The header name.</p>
    pub header_name: std::option::Option<std::string::String>,
    /// <p>The header value.</p>
    pub header_value: std::option::Option<std::string::String>,
}
impl HttpHeader {
    /// <p>The header name.</p>
    pub fn header_name(&self) -> std::option::Option<&str> {
        self.header_name.as_deref()
    }
    /// <p>The header value.</p>
    pub fn header_value(&self) -> std::option::Option<&str> {
        self.header_value.as_deref()
    }
}
impl std::fmt::Debug for HttpHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpHeader");
        formatter.field("header_name", &self.header_name);
        formatter.field("header_value", &self.header_value);
        formatter.finish()
    }
}
/// See [`HttpHeader`](crate::model::HttpHeader)
pub mod http_header {
    /// A builder for [`HttpHeader`](crate::model::HttpHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header_name: std::option::Option<std::string::String>,
        pub(crate) header_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The header name.</p>
        pub fn header_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.header_name = Some(input.into());
            self
        }
        /// <p>The header name.</p>
        pub fn set_header_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header_name = input;
            self
        }
        /// <p>The header value.</p>
        pub fn header_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.header_value = Some(input.into());
            self
        }
        /// <p>The header value.</p>
        pub fn set_header_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header_value = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpHeader`](crate::model::HttpHeader)
        pub fn build(self) -> crate::model::HttpHeader {
            crate::model::HttpHeader {
                header_name: self.header_name,
                header_value: self.header_value,
            }
        }
    }
}
impl HttpHeader {
    /// Creates a new builder-style object to manufacture [`HttpHeader`](crate::model::HttpHeader)
    pub fn builder() -> crate::model::http_header::Builder {
        crate::model::http_header::Builder::default()
    }
}

/// <p>The authentication event type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthEventType {
    /// <p>The event ID.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The event type.</p>
    pub event_type: std::option::Option<crate::model::EventType>,
    /// <p>The creation date</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The event response.</p>
    pub event_response: std::option::Option<crate::model::EventResponseType>,
    /// <p>The event risk.</p>
    pub event_risk: std::option::Option<crate::model::EventRiskType>,
    /// <p>The challenge responses.</p>
    pub challenge_responses:
        std::option::Option<std::vec::Vec<crate::model::ChallengeResponseType>>,
    /// <p>The user context data captured at the time of an event request. This value provides additional information about the client from which event the request is received.</p>
    pub event_context_data: std::option::Option<crate::model::EventContextDataType>,
    /// <p>A flag specifying the user feedback captured at the time of an event request is good or bad. </p>
    pub event_feedback: std::option::Option<crate::model::EventFeedbackType>,
}
impl AuthEventType {
    /// <p>The event ID.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>The event type.</p>
    pub fn event_type(&self) -> std::option::Option<&crate::model::EventType> {
        self.event_type.as_ref()
    }
    /// <p>The creation date</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The event response.</p>
    pub fn event_response(&self) -> std::option::Option<&crate::model::EventResponseType> {
        self.event_response.as_ref()
    }
    /// <p>The event risk.</p>
    pub fn event_risk(&self) -> std::option::Option<&crate::model::EventRiskType> {
        self.event_risk.as_ref()
    }
    /// <p>The challenge responses.</p>
    pub fn challenge_responses(
        &self,
    ) -> std::option::Option<&[crate::model::ChallengeResponseType]> {
        self.challenge_responses.as_deref()
    }
    /// <p>The user context data captured at the time of an event request. This value provides additional information about the client from which event the request is received.</p>
    pub fn event_context_data(&self) -> std::option::Option<&crate::model::EventContextDataType> {
        self.event_context_data.as_ref()
    }
    /// <p>A flag specifying the user feedback captured at the time of an event request is good or bad. </p>
    pub fn event_feedback(&self) -> std::option::Option<&crate::model::EventFeedbackType> {
        self.event_feedback.as_ref()
    }
}
impl std::fmt::Debug for AuthEventType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthEventType");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type", &self.event_type);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("event_response", &self.event_response);
        formatter.field("event_risk", &self.event_risk);
        formatter.field("challenge_responses", &self.challenge_responses);
        formatter.field("event_context_data", &self.event_context_data);
        formatter.field("event_feedback", &self.event_feedback);
        formatter.finish()
    }
}
/// See [`AuthEventType`](crate::model::AuthEventType)
pub mod auth_event_type {
    /// A builder for [`AuthEventType`](crate::model::AuthEventType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<crate::model::EventType>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_response: std::option::Option<crate::model::EventResponseType>,
        pub(crate) event_risk: std::option::Option<crate::model::EventRiskType>,
        pub(crate) challenge_responses:
            std::option::Option<std::vec::Vec<crate::model::ChallengeResponseType>>,
        pub(crate) event_context_data: std::option::Option<crate::model::EventContextDataType>,
        pub(crate) event_feedback: std::option::Option<crate::model::EventFeedbackType>,
    }
    impl Builder {
        /// <p>The event ID.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The event ID.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The event type.</p>
        pub fn event_type(mut self, input: crate::model::EventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The event type.</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>The creation date</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The event response.</p>
        pub fn event_response(mut self, input: crate::model::EventResponseType) -> Self {
            self.event_response = Some(input);
            self
        }
        /// <p>The event response.</p>
        pub fn set_event_response(
            mut self,
            input: std::option::Option<crate::model::EventResponseType>,
        ) -> Self {
            self.event_response = input;
            self
        }
        /// <p>The event risk.</p>
        pub fn event_risk(mut self, input: crate::model::EventRiskType) -> Self {
            self.event_risk = Some(input);
            self
        }
        /// <p>The event risk.</p>
        pub fn set_event_risk(
            mut self,
            input: std::option::Option<crate::model::EventRiskType>,
        ) -> Self {
            self.event_risk = input;
            self
        }
        /// Appends an item to `challenge_responses`.
        ///
        /// To override the contents of this collection use [`set_challenge_responses`](Self::set_challenge_responses).
        ///
        /// <p>The challenge responses.</p>
        pub fn challenge_responses(mut self, input: crate::model::ChallengeResponseType) -> Self {
            let mut v = self.challenge_responses.unwrap_or_default();
            v.push(input);
            self.challenge_responses = Some(v);
            self
        }
        /// <p>The challenge responses.</p>
        pub fn set_challenge_responses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChallengeResponseType>>,
        ) -> Self {
            self.challenge_responses = input;
            self
        }
        /// <p>The user context data captured at the time of an event request. This value provides additional information about the client from which event the request is received.</p>
        pub fn event_context_data(mut self, input: crate::model::EventContextDataType) -> Self {
            self.event_context_data = Some(input);
            self
        }
        /// <p>The user context data captured at the time of an event request. This value provides additional information about the client from which event the request is received.</p>
        pub fn set_event_context_data(
            mut self,
            input: std::option::Option<crate::model::EventContextDataType>,
        ) -> Self {
            self.event_context_data = input;
            self
        }
        /// <p>A flag specifying the user feedback captured at the time of an event request is good or bad. </p>
        pub fn event_feedback(mut self, input: crate::model::EventFeedbackType) -> Self {
            self.event_feedback = Some(input);
            self
        }
        /// <p>A flag specifying the user feedback captured at the time of an event request is good or bad. </p>
        pub fn set_event_feedback(
            mut self,
            input: std::option::Option<crate::model::EventFeedbackType>,
        ) -> Self {
            self.event_feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthEventType`](crate::model::AuthEventType)
        pub fn build(self) -> crate::model::AuthEventType {
            crate::model::AuthEventType {
                event_id: self.event_id,
                event_type: self.event_type,
                creation_date: self.creation_date,
                event_response: self.event_response,
                event_risk: self.event_risk,
                challenge_responses: self.challenge_responses,
                event_context_data: self.event_context_data,
                event_feedback: self.event_feedback,
            }
        }
    }
}
impl AuthEventType {
    /// Creates a new builder-style object to manufacture [`AuthEventType`](crate::model::AuthEventType)
    pub fn builder() -> crate::model::auth_event_type::Builder {
        crate::model::auth_event_type::Builder::default()
    }
}

/// <p>Specifies the event feedback type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventFeedbackType {
    /// <p>The event feedback value.</p>
    pub feedback_value: std::option::Option<crate::model::FeedbackValueType>,
    /// <p>The provider.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The event feedback date.</p>
    pub feedback_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl EventFeedbackType {
    /// <p>The event feedback value.</p>
    pub fn feedback_value(&self) -> std::option::Option<&crate::model::FeedbackValueType> {
        self.feedback_value.as_ref()
    }
    /// <p>The provider.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>The event feedback date.</p>
    pub fn feedback_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.feedback_date.as_ref()
    }
}
impl std::fmt::Debug for EventFeedbackType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventFeedbackType");
        formatter.field("feedback_value", &self.feedback_value);
        formatter.field("provider", &self.provider);
        formatter.field("feedback_date", &self.feedback_date);
        formatter.finish()
    }
}
/// See [`EventFeedbackType`](crate::model::EventFeedbackType)
pub mod event_feedback_type {
    /// A builder for [`EventFeedbackType`](crate::model::EventFeedbackType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feedback_value: std::option::Option<crate::model::FeedbackValueType>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) feedback_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The event feedback value.</p>
        pub fn feedback_value(mut self, input: crate::model::FeedbackValueType) -> Self {
            self.feedback_value = Some(input);
            self
        }
        /// <p>The event feedback value.</p>
        pub fn set_feedback_value(
            mut self,
            input: std::option::Option<crate::model::FeedbackValueType>,
        ) -> Self {
            self.feedback_value = input;
            self
        }
        /// <p>The provider.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The event feedback date.</p>
        pub fn feedback_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.feedback_date = Some(input);
            self
        }
        /// <p>The event feedback date.</p>
        pub fn set_feedback_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.feedback_date = input;
            self
        }
        /// Consumes the builder and constructs a [`EventFeedbackType`](crate::model::EventFeedbackType)
        pub fn build(self) -> crate::model::EventFeedbackType {
            crate::model::EventFeedbackType {
                feedback_value: self.feedback_value,
                provider: self.provider,
                feedback_date: self.feedback_date,
            }
        }
    }
}
impl EventFeedbackType {
    /// Creates a new builder-style object to manufacture [`EventFeedbackType`](crate::model::EventFeedbackType)
    pub fn builder() -> crate::model::event_feedback_type::Builder {
        crate::model::event_feedback_type::Builder::default()
    }
}

/// <p>Specifies the user context data captured at the time of an event request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventContextDataType {
    /// <p>The user's IP address.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The user's device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The user's time zone.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>The user's city.</p>
    pub city: std::option::Option<std::string::String>,
    /// <p>The user's country.</p>
    pub country: std::option::Option<std::string::String>,
}
impl EventContextDataType {
    /// <p>The user's IP address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The user's device name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The user's time zone.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>The user's city.</p>
    pub fn city(&self) -> std::option::Option<&str> {
        self.city.as_deref()
    }
    /// <p>The user's country.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
}
impl std::fmt::Debug for EventContextDataType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventContextDataType");
        formatter.field("ip_address", &self.ip_address);
        formatter.field("device_name", &self.device_name);
        formatter.field("timezone", &self.timezone);
        formatter.field("city", &self.city);
        formatter.field("country", &self.country);
        formatter.finish()
    }
}
/// See [`EventContextDataType`](crate::model::EventContextDataType)
pub mod event_context_data_type {
    /// A builder for [`EventContextDataType`](crate::model::EventContextDataType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) city: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user's IP address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The user's IP address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The user's device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The user's device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The user's time zone.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The user's time zone.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>The user's city.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.city = Some(input.into());
            self
        }
        /// <p>The user's city.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city = input;
            self
        }
        /// <p>The user's country.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The user's country.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// Consumes the builder and constructs a [`EventContextDataType`](crate::model::EventContextDataType)
        pub fn build(self) -> crate::model::EventContextDataType {
            crate::model::EventContextDataType {
                ip_address: self.ip_address,
                device_name: self.device_name,
                timezone: self.timezone,
                city: self.city,
                country: self.country,
            }
        }
    }
}
impl EventContextDataType {
    /// Creates a new builder-style object to manufacture [`EventContextDataType`](crate::model::EventContextDataType)
    pub fn builder() -> crate::model::event_context_data_type::Builder {
        crate::model::event_context_data_type::Builder::default()
    }
}

/// <p>The challenge response type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChallengeResponseType {
    /// <p>The challenge name.</p>
    pub challenge_name: std::option::Option<crate::model::ChallengeName>,
    /// <p>The challenge response.</p>
    pub challenge_response: std::option::Option<crate::model::ChallengeResponse>,
}
impl ChallengeResponseType {
    /// <p>The challenge name.</p>
    pub fn challenge_name(&self) -> std::option::Option<&crate::model::ChallengeName> {
        self.challenge_name.as_ref()
    }
    /// <p>The challenge response.</p>
    pub fn challenge_response(&self) -> std::option::Option<&crate::model::ChallengeResponse> {
        self.challenge_response.as_ref()
    }
}
impl std::fmt::Debug for ChallengeResponseType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChallengeResponseType");
        formatter.field("challenge_name", &self.challenge_name);
        formatter.field("challenge_response", &self.challenge_response);
        formatter.finish()
    }
}
/// See [`ChallengeResponseType`](crate::model::ChallengeResponseType)
pub mod challenge_response_type {
    /// A builder for [`ChallengeResponseType`](crate::model::ChallengeResponseType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) challenge_name: std::option::Option<crate::model::ChallengeName>,
        pub(crate) challenge_response: std::option::Option<crate::model::ChallengeResponse>,
    }
    impl Builder {
        /// <p>The challenge name.</p>
        pub fn challenge_name(mut self, input: crate::model::ChallengeName) -> Self {
            self.challenge_name = Some(input);
            self
        }
        /// <p>The challenge name.</p>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeName>,
        ) -> Self {
            self.challenge_name = input;
            self
        }
        /// <p>The challenge response.</p>
        pub fn challenge_response(mut self, input: crate::model::ChallengeResponse) -> Self {
            self.challenge_response = Some(input);
            self
        }
        /// <p>The challenge response.</p>
        pub fn set_challenge_response(
            mut self,
            input: std::option::Option<crate::model::ChallengeResponse>,
        ) -> Self {
            self.challenge_response = input;
            self
        }
        /// Consumes the builder and constructs a [`ChallengeResponseType`](crate::model::ChallengeResponseType)
        pub fn build(self) -> crate::model::ChallengeResponseType {
            crate::model::ChallengeResponseType {
                challenge_name: self.challenge_name,
                challenge_response: self.challenge_response,
            }
        }
    }
}
impl ChallengeResponseType {
    /// Creates a new builder-style object to manufacture [`ChallengeResponseType`](crate::model::ChallengeResponseType)
    pub fn builder() -> crate::model::challenge_response_type::Builder {
        crate::model::challenge_response_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChallengeResponse {
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChallengeResponse {
    fn from(s: &str) -> Self {
        match s {
            "Failure" => ChallengeResponse::Failure,
            "Success" => ChallengeResponse::Success,
            other => ChallengeResponse::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChallengeResponse {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChallengeResponse::from(s))
    }
}
impl ChallengeResponse {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChallengeResponse::Failure => "Failure",
            ChallengeResponse::Success => "Success",
            ChallengeResponse::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failure", "Success"]
    }
}
impl AsRef<str> for ChallengeResponse {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChallengeName {
    #[allow(missing_docs)] // documentation missing in model
    Mfa,
    #[allow(missing_docs)] // documentation missing in model
    Password,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChallengeName {
    fn from(s: &str) -> Self {
        match s {
            "Mfa" => ChallengeName::Mfa,
            "Password" => ChallengeName::Password,
            other => ChallengeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChallengeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChallengeName::from(s))
    }
}
impl ChallengeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChallengeName::Mfa => "Mfa",
            ChallengeName::Password => "Password",
            ChallengeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Mfa", "Password"]
    }
}
impl AsRef<str> for ChallengeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The event risk type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventRiskType {
    /// <p>The risk decision.</p>
    pub risk_decision: std::option::Option<crate::model::RiskDecisionType>,
    /// <p>The risk level.</p>
    pub risk_level: std::option::Option<crate::model::RiskLevelType>,
    /// <p>Indicates whether compromised credentials were detected during an authentication event.</p>
    pub compromised_credentials_detected: std::option::Option<bool>,
}
impl EventRiskType {
    /// <p>The risk decision.</p>
    pub fn risk_decision(&self) -> std::option::Option<&crate::model::RiskDecisionType> {
        self.risk_decision.as_ref()
    }
    /// <p>The risk level.</p>
    pub fn risk_level(&self) -> std::option::Option<&crate::model::RiskLevelType> {
        self.risk_level.as_ref()
    }
    /// <p>Indicates whether compromised credentials were detected during an authentication event.</p>
    pub fn compromised_credentials_detected(&self) -> std::option::Option<bool> {
        self.compromised_credentials_detected
    }
}
impl std::fmt::Debug for EventRiskType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventRiskType");
        formatter.field("risk_decision", &self.risk_decision);
        formatter.field("risk_level", &self.risk_level);
        formatter.field(
            "compromised_credentials_detected",
            &self.compromised_credentials_detected,
        );
        formatter.finish()
    }
}
/// See [`EventRiskType`](crate::model::EventRiskType)
pub mod event_risk_type {
    /// A builder for [`EventRiskType`](crate::model::EventRiskType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) risk_decision: std::option::Option<crate::model::RiskDecisionType>,
        pub(crate) risk_level: std::option::Option<crate::model::RiskLevelType>,
        pub(crate) compromised_credentials_detected: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The risk decision.</p>
        pub fn risk_decision(mut self, input: crate::model::RiskDecisionType) -> Self {
            self.risk_decision = Some(input);
            self
        }
        /// <p>The risk decision.</p>
        pub fn set_risk_decision(
            mut self,
            input: std::option::Option<crate::model::RiskDecisionType>,
        ) -> Self {
            self.risk_decision = input;
            self
        }
        /// <p>The risk level.</p>
        pub fn risk_level(mut self, input: crate::model::RiskLevelType) -> Self {
            self.risk_level = Some(input);
            self
        }
        /// <p>The risk level.</p>
        pub fn set_risk_level(
            mut self,
            input: std::option::Option<crate::model::RiskLevelType>,
        ) -> Self {
            self.risk_level = input;
            self
        }
        /// <p>Indicates whether compromised credentials were detected during an authentication event.</p>
        pub fn compromised_credentials_detected(mut self, input: bool) -> Self {
            self.compromised_credentials_detected = Some(input);
            self
        }
        /// <p>Indicates whether compromised credentials were detected during an authentication event.</p>
        pub fn set_compromised_credentials_detected(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.compromised_credentials_detected = input;
            self
        }
        /// Consumes the builder and constructs a [`EventRiskType`](crate::model::EventRiskType)
        pub fn build(self) -> crate::model::EventRiskType {
            crate::model::EventRiskType {
                risk_decision: self.risk_decision,
                risk_level: self.risk_level,
                compromised_credentials_detected: self.compromised_credentials_detected,
            }
        }
    }
}
impl EventRiskType {
    /// Creates a new builder-style object to manufacture [`EventRiskType`](crate::model::EventRiskType)
    pub fn builder() -> crate::model::event_risk_type::Builder {
        crate::model::event_risk_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RiskLevelType {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RiskLevelType {
    fn from(s: &str) -> Self {
        match s {
            "High" => RiskLevelType::High,
            "Low" => RiskLevelType::Low,
            "Medium" => RiskLevelType::Medium,
            other => RiskLevelType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RiskLevelType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RiskLevelType::from(s))
    }
}
impl RiskLevelType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RiskLevelType::High => "High",
            RiskLevelType::Low => "Low",
            RiskLevelType::Medium => "Medium",
            RiskLevelType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["High", "Low", "Medium"]
    }
}
impl AsRef<str> for RiskLevelType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RiskDecisionType {
    #[allow(missing_docs)] // documentation missing in model
    AccountTakeover,
    #[allow(missing_docs)] // documentation missing in model
    Block,
    #[allow(missing_docs)] // documentation missing in model
    NoRisk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RiskDecisionType {
    fn from(s: &str) -> Self {
        match s {
            "AccountTakeover" => RiskDecisionType::AccountTakeover,
            "Block" => RiskDecisionType::Block,
            "NoRisk" => RiskDecisionType::NoRisk,
            other => RiskDecisionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RiskDecisionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RiskDecisionType::from(s))
    }
}
impl RiskDecisionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RiskDecisionType::AccountTakeover => "AccountTakeover",
            RiskDecisionType::Block => "Block",
            RiskDecisionType::NoRisk => "NoRisk",
            RiskDecisionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AccountTakeover", "Block", "NoRisk"]
    }
}
impl AsRef<str> for RiskDecisionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventResponseType {
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventResponseType {
    fn from(s: &str) -> Self {
        match s {
            "Failure" => EventResponseType::Failure,
            "Success" => EventResponseType::Success,
            other => EventResponseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventResponseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventResponseType::from(s))
    }
}
impl EventResponseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventResponseType::Failure => "Failure",
            EventResponseType::Success => "Success",
            EventResponseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failure", "Success"]
    }
}
impl AsRef<str> for EventResponseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    ForgotPassword,
    #[allow(missing_docs)] // documentation missing in model
    SignIn,
    #[allow(missing_docs)] // documentation missing in model
    SignUp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "ForgotPassword" => EventType::ForgotPassword,
            "SignIn" => EventType::SignIn,
            "SignUp" => EventType::SignUp,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::ForgotPassword => "ForgotPassword",
            EventType::SignIn => "SignIn",
            EventType::SignUp => "SignUp",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ForgotPassword", "SignIn", "SignUp"]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for information about an identity provider for a user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProviderUserIdentifierType {
    /// <p>The name of the provider, such as Facebook, Google, or Login with Amazon.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The name of the provider attribute to link to, such as <code>NameID</code>.</p>
    pub provider_attribute_name: std::option::Option<std::string::String>,
    /// <p>The value of the provider attribute to link to, such as <code>xxxxx_account</code>.</p>
    pub provider_attribute_value: std::option::Option<std::string::String>,
}
impl ProviderUserIdentifierType {
    /// <p>The name of the provider, such as Facebook, Google, or Login with Amazon.</p>
    pub fn provider_name(&self) -> std::option::Option<&str> {
        self.provider_name.as_deref()
    }
    /// <p>The name of the provider attribute to link to, such as <code>NameID</code>.</p>
    pub fn provider_attribute_name(&self) -> std::option::Option<&str> {
        self.provider_attribute_name.as_deref()
    }
    /// <p>The value of the provider attribute to link to, such as <code>xxxxx_account</code>.</p>
    pub fn provider_attribute_value(&self) -> std::option::Option<&str> {
        self.provider_attribute_value.as_deref()
    }
}
impl std::fmt::Debug for ProviderUserIdentifierType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProviderUserIdentifierType");
        formatter.field("provider_name", &self.provider_name);
        formatter.field("provider_attribute_name", &self.provider_attribute_name);
        formatter.field("provider_attribute_value", &self.provider_attribute_value);
        formatter.finish()
    }
}
/// See [`ProviderUserIdentifierType`](crate::model::ProviderUserIdentifierType)
pub mod provider_user_identifier_type {
    /// A builder for [`ProviderUserIdentifierType`](crate::model::ProviderUserIdentifierType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) provider_attribute_name: std::option::Option<std::string::String>,
        pub(crate) provider_attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the provider, such as Facebook, Google, or Login with Amazon.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the provider, such as Facebook, Google, or Login with Amazon.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The name of the provider attribute to link to, such as <code>NameID</code>.</p>
        pub fn provider_attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the provider attribute to link to, such as <code>NameID</code>.</p>
        pub fn set_provider_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_attribute_name = input;
            self
        }
        /// <p>The value of the provider attribute to link to, such as <code>xxxxx_account</code>.</p>
        pub fn provider_attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_attribute_value = Some(input.into());
            self
        }
        /// <p>The value of the provider attribute to link to, such as <code>xxxxx_account</code>.</p>
        pub fn set_provider_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ProviderUserIdentifierType`](crate::model::ProviderUserIdentifierType)
        pub fn build(self) -> crate::model::ProviderUserIdentifierType {
            crate::model::ProviderUserIdentifierType {
                provider_name: self.provider_name,
                provider_attribute_name: self.provider_attribute_name,
                provider_attribute_value: self.provider_attribute_value,
            }
        }
    }
}
impl ProviderUserIdentifierType {
    /// Creates a new builder-style object to manufacture [`ProviderUserIdentifierType`](crate::model::ProviderUserIdentifierType)
    pub fn builder() -> crate::model::provider_user_identifier_type::Builder {
        crate::model::provider_user_identifier_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageActionType {
    #[allow(missing_docs)] // documentation missing in model
    Resend,
    #[allow(missing_docs)] // documentation missing in model
    Suppress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageActionType {
    fn from(s: &str) -> Self {
        match s {
            "RESEND" => MessageActionType::Resend,
            "SUPPRESS" => MessageActionType::Suppress,
            other => MessageActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageActionType::from(s))
    }
}
impl MessageActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageActionType::Resend => "RESEND",
            MessageActionType::Suppress => "SUPPRESS",
            MessageActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RESEND", "SUPPRESS"]
    }
}
impl AsRef<str> for MessageActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
