// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddCustomAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddCustomAttributesError {
    /// Kind of error that occurred.
    pub kind: AddCustomAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddCustomAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddCustomAttributesErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when you're trying to modify a user pool while a user import job is in progress for that pool.</p>
    UserImportInProgressException(crate::error::UserImportInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddCustomAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddCustomAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AddCustomAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AddCustomAttributesErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AddCustomAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddCustomAttributesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AddCustomAttributesErrorKind::UserImportInProgressException(_inner) => _inner.fmt(f),
            AddCustomAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddCustomAttributesError {
    fn code(&self) -> Option<&str> {
        AddCustomAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddCustomAttributesError {
    /// Creates a new `AddCustomAttributesError`.
    pub fn new(kind: AddCustomAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddCustomAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddCustomAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddCustomAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddCustomAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddCustomAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AddCustomAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AddCustomAttributesErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomAttributesErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AddCustomAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddCustomAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomAttributesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AddCustomAttributesErrorKind::UserImportInProgressException`.
    pub fn is_user_import_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomAttributesErrorKind::UserImportInProgressException(_)
        )
    }
}
impl std::error::Error for AddCustomAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddCustomAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            AddCustomAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AddCustomAttributesErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AddCustomAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddCustomAttributesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AddCustomAttributesErrorKind::UserImportInProgressException(_inner) => Some(_inner),
            AddCustomAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminAddUserToGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminAddUserToGroupError {
    /// Kind of error that occurred.
    pub kind: AdminAddUserToGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminAddUserToGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminAddUserToGroupErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminAddUserToGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminAddUserToGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminAddUserToGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminAddUserToGroupErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminAddUserToGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminAddUserToGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminAddUserToGroupErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminAddUserToGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminAddUserToGroupError {
    fn code(&self) -> Option<&str> {
        AdminAddUserToGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminAddUserToGroupError {
    /// Creates a new `AdminAddUserToGroupError`.
    pub fn new(kind: AdminAddUserToGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminAddUserToGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminAddUserToGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminAddUserToGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminAddUserToGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminAddUserToGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminAddUserToGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminAddUserToGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminAddUserToGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminAddUserToGroupErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminAddUserToGroupErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminAddUserToGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminAddUserToGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminAddUserToGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminAddUserToGroupErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminAddUserToGroupErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminAddUserToGroupErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminAddUserToGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminAddUserToGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminAddUserToGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminAddUserToGroupErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminAddUserToGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminAddUserToGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminAddUserToGroupErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminAddUserToGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminConfirmSignUp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminConfirmSignUpError {
    /// Kind of error that occurred.
    pub kind: AdminConfirmSignUpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminConfirmSignUp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminConfirmSignUpErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many failed attempts for a given action, such as sign-in.</p>
    TooManyFailedAttemptsException(crate::error::TooManyFailedAttemptsException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminConfirmSignUpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminConfirmSignUpErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::TooManyFailedAttemptsException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminConfirmSignUpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminConfirmSignUpError {
    fn code(&self) -> Option<&str> {
        AdminConfirmSignUpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminConfirmSignUpError {
    /// Creates a new `AdminConfirmSignUpError`.
    pub fn new(kind: AdminConfirmSignUpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminConfirmSignUpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminConfirmSignUpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminConfirmSignUpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminConfirmSignUpErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::TooManyFailedAttemptsException`.
    pub fn is_too_many_failed_attempts_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::TooManyFailedAttemptsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminConfirmSignUpErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminConfirmSignUpErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminConfirmSignUpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminConfirmSignUpErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::LimitExceededException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::TooManyFailedAttemptsException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminConfirmSignUpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminCreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminCreateUserError {
    /// Kind of error that occurred.
    pub kind: AdminCreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminCreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminCreateUserErrorKind {
    /// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
    CodeDeliveryFailureException(crate::error::CodeDeliveryFailureException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a precondition is not met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>The request failed because the user is in an unsupported state.</p>
    UnsupportedUserStateException(crate::error::UnsupportedUserStateException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.</p>
    UsernameExistsException(crate::error::UsernameExistsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminCreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminCreateUserErrorKind::CodeDeliveryFailureException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            AdminCreateUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::UnsupportedUserStateException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::UsernameExistsException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminCreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminCreateUserError {
    fn code(&self) -> Option<&str> {
        AdminCreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminCreateUserError {
    /// Creates a new `AdminCreateUserError`.
    pub fn new(kind: AdminCreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminCreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminCreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminCreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminCreateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::CodeDeliveryFailureException`.
    pub fn is_code_delivery_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::CodeDeliveryFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::UnsupportedUserStateException`.
    pub fn is_unsupported_user_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::UnsupportedUserStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::UsernameExistsException`.
    pub fn is_username_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::UsernameExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminCreateUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminCreateUserErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminCreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminCreateUserErrorKind::CodeDeliveryFailureException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            AdminCreateUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::UnsupportedUserStateException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::UsernameExistsException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminCreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminDeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminDeleteUserError {
    /// Kind of error that occurred.
    pub kind: AdminDeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminDeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminDeleteUserErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminDeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminDeleteUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminDeleteUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminDeleteUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminDeleteUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminDeleteUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminDeleteUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminDeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminDeleteUserError {
    fn code(&self) -> Option<&str> {
        AdminDeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminDeleteUserError {
    /// Creates a new `AdminDeleteUserError`.
    pub fn new(kind: AdminDeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminDeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminDeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminDeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminDeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminDeleteUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminDeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminDeleteUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminDeleteUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminDeleteUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminDeleteUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminDeleteUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminDeleteUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminDeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminDeleteUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminDeleteUserAttributesError {
    /// Kind of error that occurred.
    pub kind: AdminDeleteUserAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminDeleteUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminDeleteUserAttributesErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminDeleteUserAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminDeleteUserAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminDeleteUserAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminDeleteUserAttributesErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminDeleteUserAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminDeleteUserAttributesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminDeleteUserAttributesErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminDeleteUserAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminDeleteUserAttributesError {
    fn code(&self) -> Option<&str> {
        AdminDeleteUserAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminDeleteUserAttributesError {
    /// Creates a new `AdminDeleteUserAttributesError`.
    pub fn new(kind: AdminDeleteUserAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminDeleteUserAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminDeleteUserAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminDeleteUserAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminDeleteUserAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminDeleteUserAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserAttributesErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserAttributesErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserAttributesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDeleteUserAttributesErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDeleteUserAttributesErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminDeleteUserAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminDeleteUserAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminDeleteUserAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminDeleteUserAttributesErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminDeleteUserAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminDeleteUserAttributesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminDeleteUserAttributesErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminDeleteUserAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminDisableProviderForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminDisableProviderForUserError {
    /// Kind of error that occurred.
    pub kind: AdminDisableProviderForUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminDisableProviderForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminDisableProviderForUserErrorKind {
    /// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
    AliasExistsException(crate::error::AliasExistsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminDisableProviderForUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminDisableProviderForUserErrorKind::AliasExistsException(_inner) => _inner.fmt(f),
            AdminDisableProviderForUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminDisableProviderForUserErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AdminDisableProviderForUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminDisableProviderForUserErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AdminDisableProviderForUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminDisableProviderForUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminDisableProviderForUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminDisableProviderForUserError {
    fn code(&self) -> Option<&str> {
        AdminDisableProviderForUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminDisableProviderForUserError {
    /// Creates a new `AdminDisableProviderForUserError`.
    pub fn new(kind: AdminDisableProviderForUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminDisableProviderForUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminDisableProviderForUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminDisableProviderForUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminDisableProviderForUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminDisableProviderForUserErrorKind::AliasExistsException`.
    pub fn is_alias_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableProviderForUserErrorKind::AliasExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableProviderForUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableProviderForUserErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableProviderForUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableProviderForUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableProviderForUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableProviderForUserErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableProviderForUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableProviderForUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableProviderForUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableProviderForUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableProviderForUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableProviderForUserErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminDisableProviderForUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminDisableProviderForUserErrorKind::AliasExistsException(_inner) => Some(_inner),
            AdminDisableProviderForUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminDisableProviderForUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminDisableProviderForUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminDisableProviderForUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminDisableProviderForUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminDisableProviderForUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminDisableProviderForUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminDisableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminDisableUserError {
    /// Kind of error that occurred.
    pub kind: AdminDisableUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminDisableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminDisableUserErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminDisableUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminDisableUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminDisableUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminDisableUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminDisableUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminDisableUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminDisableUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminDisableUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminDisableUserError {
    fn code(&self) -> Option<&str> {
        AdminDisableUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminDisableUserError {
    /// Creates a new `AdminDisableUserError`.
    pub fn new(kind: AdminDisableUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminDisableUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminDisableUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminDisableUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminDisableUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminDisableUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableUserErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableUserErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminDisableUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminDisableUserErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminDisableUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminDisableUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminDisableUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminDisableUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminDisableUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminDisableUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminDisableUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminDisableUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminEnableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminEnableUserError {
    /// Kind of error that occurred.
    pub kind: AdminEnableUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminEnableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminEnableUserErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminEnableUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminEnableUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminEnableUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminEnableUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminEnableUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminEnableUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminEnableUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminEnableUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminEnableUserError {
    fn code(&self) -> Option<&str> {
        AdminEnableUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminEnableUserError {
    /// Creates a new `AdminEnableUserError`.
    pub fn new(kind: AdminEnableUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminEnableUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminEnableUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminEnableUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminEnableUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminEnableUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminEnableUserErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminEnableUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminEnableUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminEnableUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminEnableUserErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminEnableUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminEnableUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminEnableUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminEnableUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminEnableUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminEnableUserErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminEnableUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminEnableUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminEnableUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminEnableUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminEnableUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminEnableUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminEnableUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminEnableUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminForgetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminForgetDeviceError {
    /// Kind of error that occurred.
    pub kind: AdminForgetDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminForgetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminForgetDeviceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminForgetDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminForgetDeviceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminForgetDeviceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminForgetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            AdminForgetDeviceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminForgetDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminForgetDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminForgetDeviceErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminForgetDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminForgetDeviceError {
    fn code(&self) -> Option<&str> {
        AdminForgetDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminForgetDeviceError {
    /// Creates a new `AdminForgetDeviceError`.
    pub fn new(kind: AdminForgetDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminForgetDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminForgetDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminForgetDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminForgetDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminForgetDeviceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminForgetDeviceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminForgetDeviceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminForgetDeviceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminForgetDeviceErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminForgetDeviceErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminForgetDeviceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminForgetDeviceErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminForgetDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminForgetDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminForgetDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminForgetDeviceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminForgetDeviceErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminForgetDeviceErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminForgetDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminForgetDeviceErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminForgetDeviceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminForgetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            AdminForgetDeviceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminForgetDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminForgetDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminForgetDeviceErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminForgetDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminGetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminGetDeviceError {
    /// Kind of error that occurred.
    pub kind: AdminGetDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminGetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminGetDeviceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminGetDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminGetDeviceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminGetDeviceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminGetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => _inner.fmt(f),
            AdminGetDeviceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminGetDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminGetDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminGetDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminGetDeviceError {
    fn code(&self) -> Option<&str> {
        AdminGetDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminGetDeviceError {
    /// Creates a new `AdminGetDeviceError`.
    pub fn new(kind: AdminGetDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminGetDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminGetDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminGetDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminGetDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminGetDeviceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetDeviceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetDeviceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetDeviceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetDeviceErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetDeviceErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetDeviceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetDeviceErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetDeviceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AdminGetDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminGetDeviceErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminGetDeviceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminGetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => Some(_inner),
            AdminGetDeviceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminGetDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminGetDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminGetDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminGetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminGetUserError {
    /// Kind of error that occurred.
    pub kind: AdminGetUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminGetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminGetUserErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminGetUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminGetUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminGetUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminGetUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminGetUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminGetUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminGetUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminGetUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminGetUserError {
    fn code(&self) -> Option<&str> {
        AdminGetUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminGetUserError {
    /// Creates a new `AdminGetUserError`.
    pub fn new(kind: AdminGetUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminGetUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminGetUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminGetUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminGetUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminGetUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, AdminGetUserErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `AdminGetUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, AdminGetUserErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `AdminGetUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminGetUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminGetUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, AdminGetUserErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for AdminGetUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminGetUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminGetUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminGetUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminGetUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminGetUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminGetUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminGetUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminInitiateAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminInitiateAuthError {
    /// Kind of error that occurred.
    pub kind: AdminInitiateAuthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminInitiateAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminInitiateAuthErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when Amazon Cognito can't find a multi-factor authentication (MFA) method.</p>
    MfaMethodNotFoundException(crate::error::MfaMethodNotFoundException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminInitiateAuthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminInitiateAuthErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            AdminInitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            AdminInitiateAuthErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            AdminInitiateAuthErrorKind::MfaMethodNotFoundException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminInitiateAuthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminInitiateAuthError {
    fn code(&self) -> Option<&str> {
        AdminInitiateAuthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminInitiateAuthError {
    /// Creates a new `AdminInitiateAuthError`.
    pub fn new(kind: AdminInitiateAuthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminInitiateAuthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminInitiateAuthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminInitiateAuthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminInitiateAuthErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::MfaMethodNotFoundException`.
    pub fn is_mfa_method_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::MfaMethodNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminInitiateAuthErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminInitiateAuthErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminInitiateAuthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminInitiateAuthErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            AdminInitiateAuthErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            AdminInitiateAuthErrorKind::MfaMethodNotFoundException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminInitiateAuthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminLinkProviderForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminLinkProviderForUserError {
    /// Kind of error that occurred.
    pub kind: AdminLinkProviderForUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminLinkProviderForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminLinkProviderForUserErrorKind {
    /// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
    AliasExistsException(crate::error::AliasExistsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminLinkProviderForUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminLinkProviderForUserErrorKind::AliasExistsException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminLinkProviderForUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminLinkProviderForUserError {
    fn code(&self) -> Option<&str> {
        AdminLinkProviderForUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminLinkProviderForUserError {
    /// Creates a new `AdminLinkProviderForUserError`.
    pub fn new(kind: AdminLinkProviderForUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminLinkProviderForUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminLinkProviderForUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminLinkProviderForUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminLinkProviderForUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::AliasExistsException`.
    pub fn is_alias_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::AliasExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminLinkProviderForUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminLinkProviderForUserErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminLinkProviderForUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminLinkProviderForUserErrorKind::AliasExistsException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminLinkProviderForUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminListDevicesError {
    /// Kind of error that occurred.
    pub kind: AdminListDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminListDevicesErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminListDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminListDevicesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminListDevicesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminListDevicesErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            AdminListDevicesErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminListDevicesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminListDevicesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminListDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminListDevicesError {
    fn code(&self) -> Option<&str> {
        AdminListDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminListDevicesError {
    /// Creates a new `AdminListDevicesError`.
    pub fn new(kind: AdminListDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminListDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminListDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminListDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminListDevicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminListDevicesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListDevicesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListDevicesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListDevicesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListDevicesErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListDevicesErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListDevicesErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListDevicesErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListDevicesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListDevicesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListDevicesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListDevicesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AdminListDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminListDevicesErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminListDevicesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminListDevicesErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            AdminListDevicesErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminListDevicesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminListDevicesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminListDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminListGroupsForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminListGroupsForUserError {
    /// Kind of error that occurred.
    pub kind: AdminListGroupsForUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminListGroupsForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminListGroupsForUserErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminListGroupsForUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminListGroupsForUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminListGroupsForUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminListGroupsForUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminListGroupsForUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminListGroupsForUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminListGroupsForUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminListGroupsForUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminListGroupsForUserError {
    fn code(&self) -> Option<&str> {
        AdminListGroupsForUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminListGroupsForUserError {
    /// Creates a new `AdminListGroupsForUserError`.
    pub fn new(kind: AdminListGroupsForUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminListGroupsForUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminListGroupsForUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminListGroupsForUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminListGroupsForUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminListGroupsForUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListGroupsForUserErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListGroupsForUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListGroupsForUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListGroupsForUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListGroupsForUserErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListGroupsForUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListGroupsForUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListGroupsForUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListGroupsForUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListGroupsForUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListGroupsForUserErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminListGroupsForUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminListGroupsForUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminListGroupsForUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminListGroupsForUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminListGroupsForUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminListGroupsForUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminListGroupsForUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminListGroupsForUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminListUserAuthEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminListUserAuthEventsError {
    /// Kind of error that occurred.
    pub kind: AdminListUserAuthEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminListUserAuthEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminListUserAuthEventsErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// <p>This exception is thrown when user pool add-ons aren't enabled.</p>
    UserPoolAddOnNotEnabledException(crate::error::UserPoolAddOnNotEnabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminListUserAuthEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminListUserAuthEventsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminListUserAuthEventsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminListUserAuthEventsErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminListUserAuthEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminListUserAuthEventsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminListUserAuthEventsErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminListUserAuthEventsErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                _inner.fmt(f)
            }
            AdminListUserAuthEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminListUserAuthEventsError {
    fn code(&self) -> Option<&str> {
        AdminListUserAuthEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminListUserAuthEventsError {
    /// Creates a new `AdminListUserAuthEventsError`.
    pub fn new(kind: AdminListUserAuthEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminListUserAuthEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminListUserAuthEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminListUserAuthEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminListUserAuthEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminListUserAuthEventsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListUserAuthEventsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListUserAuthEventsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListUserAuthEventsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListUserAuthEventsErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListUserAuthEventsErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListUserAuthEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListUserAuthEventsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListUserAuthEventsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListUserAuthEventsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListUserAuthEventsErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListUserAuthEventsErrorKind::UserNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminListUserAuthEventsErrorKind::UserPoolAddOnNotEnabledException`.
    pub fn is_user_pool_add_on_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminListUserAuthEventsErrorKind::UserPoolAddOnNotEnabledException(_)
        )
    }
}
impl std::error::Error for AdminListUserAuthEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminListUserAuthEventsErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminListUserAuthEventsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminListUserAuthEventsErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminListUserAuthEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminListUserAuthEventsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminListUserAuthEventsErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminListUserAuthEventsErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                Some(_inner)
            }
            AdminListUserAuthEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminRemoveUserFromGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminRemoveUserFromGroupError {
    /// Kind of error that occurred.
    pub kind: AdminRemoveUserFromGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminRemoveUserFromGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminRemoveUserFromGroupErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminRemoveUserFromGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminRemoveUserFromGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminRemoveUserFromGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminRemoveUserFromGroupErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminRemoveUserFromGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminRemoveUserFromGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminRemoveUserFromGroupErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminRemoveUserFromGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminRemoveUserFromGroupError {
    fn code(&self) -> Option<&str> {
        AdminRemoveUserFromGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminRemoveUserFromGroupError {
    /// Creates a new `AdminRemoveUserFromGroupError`.
    pub fn new(kind: AdminRemoveUserFromGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminRemoveUserFromGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminRemoveUserFromGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminRemoveUserFromGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminRemoveUserFromGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminRemoveUserFromGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRemoveUserFromGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRemoveUserFromGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRemoveUserFromGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRemoveUserFromGroupErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRemoveUserFromGroupErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRemoveUserFromGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRemoveUserFromGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRemoveUserFromGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRemoveUserFromGroupErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRemoveUserFromGroupErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRemoveUserFromGroupErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminRemoveUserFromGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminRemoveUserFromGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminRemoveUserFromGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminRemoveUserFromGroupErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminRemoveUserFromGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminRemoveUserFromGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminRemoveUserFromGroupErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminRemoveUserFromGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminResetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminResetUserPasswordError {
    /// Kind of error that occurred.
    pub kind: AdminResetUserPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminResetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminResetUserPasswordErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminResetUserPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminResetUserPasswordErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            AdminResetUserPasswordErrorKind::InvalidLambdaResponseException(_inner) => {
                _inner.fmt(f)
            }
            AdminResetUserPasswordErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            AdminResetUserPasswordErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            AdminResetUserPasswordErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminResetUserPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminResetUserPasswordError {
    fn code(&self) -> Option<&str> {
        AdminResetUserPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminResetUserPasswordError {
    /// Creates a new `AdminResetUserPasswordError`.
    pub fn new(kind: AdminResetUserPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminResetUserPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminResetUserPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminResetUserPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminResetUserPasswordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminResetUserPasswordErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminResetUserPasswordErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminResetUserPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminResetUserPasswordErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            AdminResetUserPasswordErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            AdminResetUserPasswordErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            AdminResetUserPasswordErrorKind::LimitExceededException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminResetUserPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminRespondToAuthChallenge` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminRespondToAuthChallengeError {
    /// Kind of error that occurred.
    pub kind: AdminRespondToAuthChallengeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminRespondToAuthChallenge` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminRespondToAuthChallengeErrorKind {
    /// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
    AliasExistsException(crate::error::AliasExistsException),
    /// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
    CodeMismatchException(crate::error::CodeMismatchException),
    /// <p>This exception is thrown if a code has expired.</p>
    ExpiredCodeException(crate::error::ExpiredCodeException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when Amazon Cognito can't find a multi-factor authentication (MFA) method.</p>
    MfaMethodNotFoundException(crate::error::MfaMethodNotFoundException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the software token time-based one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</p>
    SoftwareTokenMfaNotFoundException(crate::error::SoftwareTokenMfaNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminRespondToAuthChallengeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminRespondToAuthChallengeErrorKind::AliasExistsException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::CodeMismatchException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::ExpiredCodeException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::InvalidLambdaResponseException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException(
                _inner,
            ) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::MfaMethodNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::PasswordResetRequiredException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::UnexpectedLambdaException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::UserLambdaValidationException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::UserNotConfirmedException(_inner) => {
                _inner.fmt(f)
            }
            AdminRespondToAuthChallengeErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminRespondToAuthChallengeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminRespondToAuthChallengeError {
    fn code(&self) -> Option<&str> {
        AdminRespondToAuthChallengeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminRespondToAuthChallengeError {
    /// Creates a new `AdminRespondToAuthChallengeError`.
    pub fn new(kind: AdminRespondToAuthChallengeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminRespondToAuthChallengeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminRespondToAuthChallengeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminRespondToAuthChallengeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminRespondToAuthChallengeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::AliasExistsException`.
    pub fn is_alias_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::AliasExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::CodeMismatchException`.
    pub fn is_code_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::CodeMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::ExpiredCodeException`.
    pub fn is_expired_code_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::ExpiredCodeException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::MfaMethodNotFoundException`.
    pub fn is_mfa_method_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::MfaMethodNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException`.
    pub fn is_software_token_mfa_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminRespondToAuthChallengeErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminRespondToAuthChallengeErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminRespondToAuthChallengeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminRespondToAuthChallengeErrorKind::AliasExistsException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::CodeMismatchException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::ExpiredCodeException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::InvalidLambdaResponseException(_inner) => {
                Some(_inner)
            }
            AdminRespondToAuthChallengeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException(
                _inner,
            ) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            AdminRespondToAuthChallengeErrorKind::MfaMethodNotFoundException(_inner) => {
                Some(_inner)
            }
            AdminRespondToAuthChallengeErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::PasswordResetRequiredException(_inner) => {
                Some(_inner)
            }
            AdminRespondToAuthChallengeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException(_inner) => {
                Some(_inner)
            }
            AdminRespondToAuthChallengeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::UserLambdaValidationException(_inner) => {
                Some(_inner)
            }
            AdminRespondToAuthChallengeErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminRespondToAuthChallengeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminSetUserMFAPreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminSetUserMFAPreferenceError {
    /// Kind of error that occurred.
    pub kind: AdminSetUserMFAPreferenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminSetUserMFAPreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminSetUserMFAPreferenceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminSetUserMFAPreferenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminSetUserMFAPreferenceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminSetUserMFAPreferenceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminSetUserMFAPreferenceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminSetUserMFAPreferenceErrorKind::PasswordResetRequiredException(_inner) => {
                _inner.fmt(f)
            }
            AdminSetUserMFAPreferenceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminSetUserMFAPreferenceErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            AdminSetUserMFAPreferenceErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminSetUserMFAPreferenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminSetUserMFAPreferenceError {
    fn code(&self) -> Option<&str> {
        AdminSetUserMFAPreferenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminSetUserMFAPreferenceError {
    /// Creates a new `AdminSetUserMFAPreferenceError`.
    pub fn new(kind: AdminSetUserMFAPreferenceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminSetUserMFAPreferenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminSetUserMFAPreferenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminSetUserMFAPreferenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminSetUserMFAPreferenceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminSetUserMFAPreferenceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserMFAPreferenceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserMFAPreferenceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserMFAPreferenceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserMFAPreferenceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserMFAPreferenceErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserMFAPreferenceErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserMFAPreferenceErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserMFAPreferenceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserMFAPreferenceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserMFAPreferenceErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserMFAPreferenceErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserMFAPreferenceErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserMFAPreferenceErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminSetUserMFAPreferenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminSetUserMFAPreferenceErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminSetUserMFAPreferenceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminSetUserMFAPreferenceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminSetUserMFAPreferenceErrorKind::PasswordResetRequiredException(_inner) => {
                Some(_inner)
            }
            AdminSetUserMFAPreferenceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminSetUserMFAPreferenceErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            AdminSetUserMFAPreferenceErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminSetUserMFAPreferenceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminSetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminSetUserPasswordError {
    /// Kind of error that occurred.
    pub kind: AdminSetUserPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminSetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminSetUserPasswordErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminSetUserPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminSetUserPasswordErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminSetUserPasswordErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminSetUserPasswordErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            AdminSetUserPasswordErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminSetUserPasswordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminSetUserPasswordErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminSetUserPasswordErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminSetUserPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminSetUserPasswordError {
    fn code(&self) -> Option<&str> {
        AdminSetUserPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminSetUserPasswordError {
    /// Creates a new `AdminSetUserPasswordError`.
    pub fn new(kind: AdminSetUserPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminSetUserPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminSetUserPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminSetUserPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminSetUserPasswordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminSetUserPasswordErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserPasswordErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserPasswordErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserPasswordErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserPasswordErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserPasswordErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserPasswordErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserPasswordErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserPasswordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserPasswordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserPasswordErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserPasswordErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserPasswordErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserPasswordErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminSetUserPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminSetUserPasswordErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminSetUserPasswordErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminSetUserPasswordErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            AdminSetUserPasswordErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminSetUserPasswordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminSetUserPasswordErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminSetUserPasswordErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminSetUserPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminSetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminSetUserSettingsError {
    /// Kind of error that occurred.
    pub kind: AdminSetUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminSetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminSetUserSettingsErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminSetUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminSetUserSettingsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminSetUserSettingsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminSetUserSettingsErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminSetUserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminSetUserSettingsErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminSetUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminSetUserSettingsError {
    fn code(&self) -> Option<&str> {
        AdminSetUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminSetUserSettingsError {
    /// Creates a new `AdminSetUserSettingsError`.
    pub fn new(kind: AdminSetUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminSetUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminSetUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminSetUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminSetUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminSetUserSettingsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserSettingsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserSettingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserSettingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserSettingsErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserSettingsErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminSetUserSettingsErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminSetUserSettingsErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminSetUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminSetUserSettingsErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminSetUserSettingsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminSetUserSettingsErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminSetUserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminSetUserSettingsErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminSetUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminUpdateAuthEventFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminUpdateAuthEventFeedbackError {
    /// Kind of error that occurred.
    pub kind: AdminUpdateAuthEventFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminUpdateAuthEventFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminUpdateAuthEventFeedbackErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// <p>This exception is thrown when user pool add-ons aren't enabled.</p>
    UserPoolAddOnNotEnabledException(crate::error::UserPoolAddOnNotEnabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminUpdateAuthEventFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminUpdateAuthEventFeedbackErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminUpdateAuthEventFeedbackErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateAuthEventFeedbackErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminUpdateAuthEventFeedbackErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateAuthEventFeedbackErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateAuthEventFeedbackErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminUpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateAuthEventFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminUpdateAuthEventFeedbackError {
    fn code(&self) -> Option<&str> {
        AdminUpdateAuthEventFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminUpdateAuthEventFeedbackError {
    /// Creates a new `AdminUpdateAuthEventFeedbackError`.
    pub fn new(kind: AdminUpdateAuthEventFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminUpdateAuthEventFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminUpdateAuthEventFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminUpdateAuthEventFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminUpdateAuthEventFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminUpdateAuthEventFeedbackErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateAuthEventFeedbackErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateAuthEventFeedbackErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateAuthEventFeedbackErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateAuthEventFeedbackErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateAuthEventFeedbackErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateAuthEventFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateAuthEventFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateAuthEventFeedbackErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateAuthEventFeedbackErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateAuthEventFeedbackErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateAuthEventFeedbackErrorKind::UserNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException`.
    pub fn is_user_pool_add_on_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException(_)
        )
    }
}
impl std::error::Error for AdminUpdateAuthEventFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminUpdateAuthEventFeedbackErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminUpdateAuthEventFeedbackErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            AdminUpdateAuthEventFeedbackErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminUpdateAuthEventFeedbackErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AdminUpdateAuthEventFeedbackErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminUpdateAuthEventFeedbackErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminUpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                Some(_inner)
            }
            AdminUpdateAuthEventFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminUpdateDeviceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminUpdateDeviceStatusError {
    /// Kind of error that occurred.
    pub kind: AdminUpdateDeviceStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminUpdateDeviceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminUpdateDeviceStatusErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminUpdateDeviceStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminUpdateDeviceStatusErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminUpdateDeviceStatusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminUpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateDeviceStatusErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminUpdateDeviceStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminUpdateDeviceStatusErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminUpdateDeviceStatusErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminUpdateDeviceStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminUpdateDeviceStatusError {
    fn code(&self) -> Option<&str> {
        AdminUpdateDeviceStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminUpdateDeviceStatusError {
    /// Creates a new `AdminUpdateDeviceStatusError`.
    pub fn new(kind: AdminUpdateDeviceStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminUpdateDeviceStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminUpdateDeviceStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminUpdateDeviceStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminUpdateDeviceStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminUpdateDeviceStatusErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateDeviceStatusErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateDeviceStatusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateDeviceStatusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateDeviceStatusErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateDeviceStatusErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateDeviceStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateDeviceStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateDeviceStatusErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateDeviceStatusErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateDeviceStatusErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateDeviceStatusErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminUpdateDeviceStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminUpdateDeviceStatusErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminUpdateDeviceStatusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminUpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            AdminUpdateDeviceStatusErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminUpdateDeviceStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminUpdateDeviceStatusErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminUpdateDeviceStatusErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminUpdateDeviceStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminUpdateUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminUpdateUserAttributesError {
    /// Kind of error that occurred.
    pub kind: AdminUpdateUserAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminUpdateUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminUpdateUserAttributesErrorKind {
    /// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
    AliasExistsException(crate::error::AliasExistsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminUpdateUserAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminUpdateUserAttributesErrorKind::AliasExistsException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateUserAttributesErrorKind::InvalidLambdaResponseException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateUserAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException(
                _inner,
            ) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::UserLambdaValidationException(_inner) => {
                _inner.fmt(f)
            }
            AdminUpdateUserAttributesErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminUpdateUserAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminUpdateUserAttributesError {
    fn code(&self) -> Option<&str> {
        AdminUpdateUserAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminUpdateUserAttributesError {
    /// Creates a new `AdminUpdateUserAttributesError`.
    pub fn new(kind: AdminUpdateUserAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminUpdateUserAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminUpdateUserAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminUpdateUserAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminUpdateUserAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::AliasExistsException`.
    pub fn is_alias_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::AliasExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUpdateUserAttributesErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUpdateUserAttributesErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminUpdateUserAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminUpdateUserAttributesErrorKind::AliasExistsException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            AdminUpdateUserAttributesErrorKind::InvalidLambdaResponseException(_inner) => {
                Some(_inner)
            }
            AdminUpdateUserAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            AdminUpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException(
                _inner,
            ) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::UserLambdaValidationException(_inner) => {
                Some(_inner)
            }
            AdminUpdateUserAttributesErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminUpdateUserAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdminUserGlobalSignOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdminUserGlobalSignOutError {
    /// Kind of error that occurred.
    pub kind: AdminUserGlobalSignOutErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdminUserGlobalSignOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdminUserGlobalSignOutErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdminUserGlobalSignOutError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdminUserGlobalSignOutErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AdminUserGlobalSignOutErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AdminUserGlobalSignOutErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AdminUserGlobalSignOutErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AdminUserGlobalSignOutErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AdminUserGlobalSignOutErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            AdminUserGlobalSignOutErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdminUserGlobalSignOutError {
    fn code(&self) -> Option<&str> {
        AdminUserGlobalSignOutError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdminUserGlobalSignOutError {
    /// Creates a new `AdminUserGlobalSignOutError`.
    pub fn new(kind: AdminUserGlobalSignOutErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdminUserGlobalSignOutError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdminUserGlobalSignOutErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdminUserGlobalSignOutError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdminUserGlobalSignOutErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AdminUserGlobalSignOutErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUserGlobalSignOutErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUserGlobalSignOutErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUserGlobalSignOutErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUserGlobalSignOutErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUserGlobalSignOutErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUserGlobalSignOutErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUserGlobalSignOutErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUserGlobalSignOutErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUserGlobalSignOutErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AdminUserGlobalSignOutErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdminUserGlobalSignOutErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for AdminUserGlobalSignOutError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdminUserGlobalSignOutErrorKind::InternalErrorException(_inner) => Some(_inner),
            AdminUserGlobalSignOutErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AdminUserGlobalSignOutErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AdminUserGlobalSignOutErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AdminUserGlobalSignOutErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AdminUserGlobalSignOutErrorKind::UserNotFoundException(_inner) => Some(_inner),
            AdminUserGlobalSignOutErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateSoftwareToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateSoftwareTokenError {
    /// Kind of error that occurred.
    pub kind: AssociateSoftwareTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateSoftwareToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateSoftwareTokenErrorKind {
    /// <p>This exception is thrown if two or more modifications are happening concurrently.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the software token time-based one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</p>
    SoftwareTokenMfaNotFoundException(crate::error::SoftwareTokenMfaNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateSoftwareTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateSoftwareTokenErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSoftwareTokenErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AssociateSoftwareTokenErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateSoftwareTokenErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AssociateSoftwareTokenErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateSoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSoftwareTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateSoftwareTokenError {
    fn code(&self) -> Option<&str> {
        AssociateSoftwareTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateSoftwareTokenError {
    /// Creates a new `AssociateSoftwareTokenError`.
    pub fn new(kind: AssociateSoftwareTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateSoftwareTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateSoftwareTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateSoftwareTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateSoftwareTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateSoftwareTokenErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSoftwareTokenErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSoftwareTokenErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSoftwareTokenErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSoftwareTokenErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSoftwareTokenErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSoftwareTokenErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSoftwareTokenErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSoftwareTokenErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSoftwareTokenErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException`.
    pub fn is_software_token_mfa_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateSoftwareTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateSoftwareTokenErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            AssociateSoftwareTokenErrorKind::InternalErrorException(_inner) => Some(_inner),
            AssociateSoftwareTokenErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateSoftwareTokenErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AssociateSoftwareTokenErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateSoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateSoftwareTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ChangePassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChangePasswordError {
    /// Kind of error that occurred.
    pub kind: ChangePasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChangePassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChangePasswordErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChangePasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChangePasswordErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChangePasswordError {
    fn code(&self) -> Option<&str> {
        ChangePasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChangePasswordError {
    /// Creates a new `ChangePasswordError`.
    pub fn new(kind: ChangePasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChangePasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChangePasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChangePasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChangePasswordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for ChangePasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChangePasswordErrorKind::InternalErrorException(_inner) => Some(_inner),
            ChangePasswordErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ChangePasswordErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            ChangePasswordErrorKind::LimitExceededException(_inner) => Some(_inner),
            ChangePasswordErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ChangePasswordErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            ChangePasswordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ChangePasswordErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ChangePasswordErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            ChangePasswordErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ChangePasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmDeviceError {
    /// Kind of error that occurred.
    pub kind: ConfirmDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmDeviceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.</p>
    UsernameExistsException(crate::error::UsernameExistsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmDeviceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::UsernameExistsException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ConfirmDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmDeviceError {
    fn code(&self) -> Option<&str> {
        ConfirmDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmDeviceError {
    /// Creates a new `ConfirmDeviceError`.
    pub fn new(kind: ConfirmDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::UsernameExistsException`.
    pub fn is_username_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::UsernameExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmDeviceErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmDeviceErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, ConfirmDeviceErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for ConfirmDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmDeviceErrorKind::InternalErrorException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::UsernameExistsException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ConfirmDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmForgotPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmForgotPasswordError {
    /// Kind of error that occurred.
    pub kind: ConfirmForgotPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmForgotPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmForgotPasswordErrorKind {
    /// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
    CodeMismatchException(crate::error::CodeMismatchException),
    /// <p>This exception is thrown if a code has expired.</p>
    ExpiredCodeException(crate::error::ExpiredCodeException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many failed attempts for a given action, such as sign-in.</p>
    TooManyFailedAttemptsException(crate::error::TooManyFailedAttemptsException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmForgotPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmForgotPasswordErrorKind::CodeMismatchException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::ExpiredCodeException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::TooManyFailedAttemptsException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ConfirmForgotPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmForgotPasswordError {
    fn code(&self) -> Option<&str> {
        ConfirmForgotPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmForgotPasswordError {
    /// Creates a new `ConfirmForgotPasswordError`.
    pub fn new(kind: ConfirmForgotPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmForgotPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmForgotPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmForgotPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmForgotPasswordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::CodeMismatchException`.
    pub fn is_code_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::CodeMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::ExpiredCodeException`.
    pub fn is_expired_code_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::ExpiredCodeException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::TooManyFailedAttemptsException`.
    pub fn is_too_many_failed_attempts_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::TooManyFailedAttemptsException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmForgotPasswordErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmForgotPasswordErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for ConfirmForgotPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmForgotPasswordErrorKind::CodeMismatchException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::ExpiredCodeException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::InternalErrorException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::LimitExceededException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::TooManyFailedAttemptsException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ConfirmForgotPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmSignUp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmSignUpError {
    /// Kind of error that occurred.
    pub kind: ConfirmSignUpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmSignUp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmSignUpErrorKind {
    /// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
    AliasExistsException(crate::error::AliasExistsException),
    /// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
    CodeMismatchException(crate::error::CodeMismatchException),
    /// <p>This exception is thrown if a code has expired.</p>
    ExpiredCodeException(crate::error::ExpiredCodeException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many failed attempts for a given action, such as sign-in.</p>
    TooManyFailedAttemptsException(crate::error::TooManyFailedAttemptsException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmSignUpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmSignUpErrorKind::AliasExistsException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::CodeMismatchException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::ExpiredCodeException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::TooManyFailedAttemptsException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ConfirmSignUpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmSignUpError {
    fn code(&self) -> Option<&str> {
        ConfirmSignUpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmSignUpError {
    /// Creates a new `ConfirmSignUpError`.
    pub fn new(kind: ConfirmSignUpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmSignUpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmSignUpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmSignUpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmSignUpErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::AliasExistsException`.
    pub fn is_alias_exists_exception(&self) -> bool {
        matches!(&self.kind, ConfirmSignUpErrorKind::AliasExistsException(_))
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::CodeMismatchException`.
    pub fn is_code_mismatch_exception(&self) -> bool {
        matches!(&self.kind, ConfirmSignUpErrorKind::CodeMismatchException(_))
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::ExpiredCodeException`.
    pub fn is_expired_code_exception(&self) -> bool {
        matches!(&self.kind, ConfirmSignUpErrorKind::ExpiredCodeException(_))
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::TooManyFailedAttemptsException`.
    pub fn is_too_many_failed_attempts_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::TooManyFailedAttemptsException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSignUpErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmSignUpErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, ConfirmSignUpErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for ConfirmSignUpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmSignUpErrorKind::AliasExistsException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::CodeMismatchException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::ExpiredCodeException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::InternalErrorException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::LimitExceededException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::TooManyFailedAttemptsException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ConfirmSignUpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGroupErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.</p>
    GroupExistsException(crate::error::GroupExistsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGroupErrorKind::GroupExistsException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGroupError {
    fn code(&self) -> Option<&str> {
        CreateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGroupError {
    /// Creates a new `CreateGroupError`.
    pub fn new(kind: CreateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::GroupExistsException`.
    pub fn is_group_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::GroupExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGroupErrorKind::GroupExistsException(_inner) => Some(_inner),
            CreateGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGroupErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            CreateGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: CreateIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIdentityProviderErrorKind {
    /// <p>This exception is thrown when the provider is already supported by the user pool.</p>
    DuplicateProviderException(crate::error::DuplicateProviderException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIdentityProviderErrorKind::DuplicateProviderException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIdentityProviderError {
    fn code(&self) -> Option<&str> {
        CreateIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIdentityProviderError {
    /// Creates a new `CreateIdentityProviderError`.
    pub fn new(kind: CreateIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::DuplicateProviderException`.
    pub fn is_duplicate_provider_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::DuplicateProviderException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIdentityProviderErrorKind::DuplicateProviderException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceServerError {
    /// Kind of error that occurred.
    pub kind: CreateResourceServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceServerErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceServerErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateResourceServerErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateResourceServerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateResourceServerErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            CreateResourceServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateResourceServerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateResourceServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceServerError {
    fn code(&self) -> Option<&str> {
        CreateResourceServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceServerError {
    /// Creates a new `CreateResourceServerError`.
    pub fn new(kind: CreateResourceServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourceServerErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceServerErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceServerErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceServerErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceServerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceServerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceServerErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceServerErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceServerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceServerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateResourceServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceServerErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateResourceServerErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateResourceServerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateResourceServerErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            CreateResourceServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateResourceServerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateResourceServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserImportJobError {
    /// Kind of error that occurred.
    pub kind: CreateUserImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserImportJobErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a precondition is not met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserImportJobErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateUserImportJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateUserImportJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserImportJobErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            CreateUserImportJobErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            CreateUserImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUserImportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateUserImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserImportJobError {
    fn code(&self) -> Option<&str> {
        CreateUserImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserImportJobError {
    /// Creates a new `CreateUserImportJobError`.
    pub fn new(kind: CreateUserImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserImportJobErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserImportJobErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserImportJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserImportJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserImportJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserImportJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserImportJobErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserImportJobErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserImportJobErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserImportJobErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserImportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserImportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateUserImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserImportJobErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateUserImportJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateUserImportJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserImportJobErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            CreateUserImportJobErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            CreateUserImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUserImportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateUserImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserPoolError {
    /// Kind of error that occurred.
    pub kind: CreateUserPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserPoolErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user pool tag can't be set or updated.</p>
    UserPoolTaggingException(crate::error::UserPoolTaggingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserPoolErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            CreateUserPoolErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::UserPoolTaggingException(_inner) => _inner.fmt(f),
            CreateUserPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserPoolError {
    fn code(&self) -> Option<&str> {
        CreateUserPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserPoolError {
    /// Creates a new `CreateUserPoolError`.
    pub fn new(kind: CreateUserPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserPoolErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolErrorKind::UserPoolTaggingException`.
    pub fn is_user_pool_tagging_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolErrorKind::UserPoolTaggingException(_)
        )
    }
}
impl std::error::Error for CreateUserPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserPoolErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            CreateUserPoolErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::UserPoolTaggingException(_inner) => Some(_inner),
            CreateUserPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserPoolClientError {
    /// Kind of error that occurred.
    pub kind: CreateUserPoolClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserPoolClientErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the specified OAuth flow is not valid.</p>
    InvalidOAuthFlowException(crate::error::InvalidOAuthFlowException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the specified scope doesn't exist.</p>
    ScopeDoesNotExistException(crate::error::ScopeDoesNotExistException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserPoolClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserPoolClientErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::InvalidOAuthFlowException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::ScopeDoesNotExistException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateUserPoolClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserPoolClientError {
    fn code(&self) -> Option<&str> {
        CreateUserPoolClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserPoolClientError {
    /// Creates a new `CreateUserPoolClientError`.
    pub fn new(kind: CreateUserPoolClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserPoolClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserPoolClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserPoolClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserPoolClientErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::InvalidOAuthFlowException`.
    pub fn is_invalid_o_auth_flow_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::InvalidOAuthFlowException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::ScopeDoesNotExistException`.
    pub fn is_scope_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::ScopeDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolClientErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolClientErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateUserPoolClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserPoolClientErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::InvalidOAuthFlowException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::ScopeDoesNotExistException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateUserPoolClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserPoolDomainError {
    /// Kind of error that occurred.
    pub kind: CreateUserPoolDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserPoolDomainErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserPoolDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserPoolDomainErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateUserPoolDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateUserPoolDomainErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserPoolDomainErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            CreateUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUserPoolDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserPoolDomainError {
    fn code(&self) -> Option<&str> {
        CreateUserPoolDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserPoolDomainError {
    /// Creates a new `CreateUserPoolDomainError`.
    pub fn new(kind: CreateUserPoolDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserPoolDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserPoolDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserPoolDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserPoolDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserPoolDomainErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolDomainErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolDomainErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolDomainErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolDomainErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolDomainErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserPoolDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserPoolDomainErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateUserPoolDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserPoolDomainErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateUserPoolDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateUserPoolDomainErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserPoolDomainErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            CreateUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUserPoolDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupError {
    /// Creates a new `DeleteGroupError`.
    pub fn new(kind: DeleteGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteGroupErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: DeleteIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIdentityProviderErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when the specified identifier isn't supported.</p>
    UnsupportedIdentityProviderException(crate::error::UnsupportedIdentityProviderException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIdentityProviderErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::UnsupportedIdentityProviderException(_inner) => {
                _inner.fmt(f)
            }
            DeleteIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIdentityProviderError {
    fn code(&self) -> Option<&str> {
        DeleteIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIdentityProviderError {
    /// Creates a new `DeleteIdentityProviderError`.
    pub fn new(kind: DeleteIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::UnsupportedIdentityProviderException`.
    pub fn is_unsupported_identity_provider_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::UnsupportedIdentityProviderException(_)
        )
    }
}
impl std::error::Error for DeleteIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIdentityProviderErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::UnsupportedIdentityProviderException(_inner) => {
                Some(_inner)
            }
            DeleteIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceServerError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceServerErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceServerErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteResourceServerErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteResourceServerErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteResourceServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourceServerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteResourceServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceServerError {
    fn code(&self) -> Option<&str> {
        DeleteResourceServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceServerError {
    /// Creates a new `DeleteResourceServerError`.
    pub fn new(kind: DeleteResourceServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceServerErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceServerErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceServerErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceServerErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceServerErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceServerErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceServerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceServerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteResourceServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceServerErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteResourceServerErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteResourceServerErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteResourceServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourceServerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteResourceServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteUserErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteUserErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            DeleteUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserAttributesError {
    /// Kind of error that occurred.
    pub kind: DeleteUserAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserAttributesErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserAttributesError {
    fn code(&self) -> Option<&str> {
        DeleteUserAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserAttributesError {
    /// Creates a new `DeleteUserAttributesError`.
    pub fn new(kind: DeleteUserAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserAttributesErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserAttributesErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteUserAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::UserNotFoundException(_inner) => Some(_inner),
            DeleteUserAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserPoolError {
    /// Kind of error that occurred.
    pub kind: DeleteUserPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserPoolErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when you're trying to modify a user pool while a user import job is in progress for that pool.</p>
    UserImportInProgressException(crate::error::UserImportInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserPoolErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteUserPoolErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserPoolErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteUserPoolErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserPoolErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteUserPoolErrorKind::UserImportInProgressException(_inner) => _inner.fmt(f),
            DeleteUserPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserPoolError {
    fn code(&self) -> Option<&str> {
        DeleteUserPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserPoolError {
    /// Creates a new `DeleteUserPoolError`.
    pub fn new(kind: DeleteUserPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserPoolErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserPoolErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolErrorKind::UserImportInProgressException`.
    pub fn is_user_import_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolErrorKind::UserImportInProgressException(_)
        )
    }
}
impl std::error::Error for DeleteUserPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserPoolErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteUserPoolErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserPoolErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteUserPoolErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserPoolErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteUserPoolErrorKind::UserImportInProgressException(_inner) => Some(_inner),
            DeleteUserPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserPoolClientError {
    /// Kind of error that occurred.
    pub kind: DeleteUserPoolClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserPoolClientErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserPoolClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserPoolClientErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteUserPoolClientErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserPoolClientErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteUserPoolClientErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserPoolClientErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteUserPoolClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserPoolClientError {
    fn code(&self) -> Option<&str> {
        DeleteUserPoolClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserPoolClientError {
    /// Creates a new `DeleteUserPoolClientError`.
    pub fn new(kind: DeleteUserPoolClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserPoolClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserPoolClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserPoolClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserPoolClientErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserPoolClientErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolClientErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolClientErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolClientErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolClientErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolClientErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolClientErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolClientErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolClientErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolClientErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteUserPoolClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserPoolClientErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteUserPoolClientErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserPoolClientErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteUserPoolClientErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserPoolClientErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteUserPoolClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserPoolDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteUserPoolDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserPoolDomainErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserPoolDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserPoolDomainErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteUserPoolDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserPoolDomainErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserPoolDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserPoolDomainError {
    fn code(&self) -> Option<&str> {
        DeleteUserPoolDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserPoolDomainError {
    /// Creates a new `DeleteUserPoolDomainError`.
    pub fn new(kind: DeleteUserPoolDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserPoolDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserPoolDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserPoolDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserPoolDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserPoolDomainErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolDomainErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolDomainErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolDomainErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPoolDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPoolDomainErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteUserPoolDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserPoolDomainErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteUserPoolDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserPoolDomainErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserPoolDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: DescribeIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIdentityProviderErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIdentityProviderErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeIdentityProviderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeIdentityProviderErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeIdentityProviderErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIdentityProviderError {
    fn code(&self) -> Option<&str> {
        DescribeIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIdentityProviderError {
    /// Creates a new `DescribeIdentityProviderError`.
    pub fn new(kind: DescribeIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIdentityProviderErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeIdentityProviderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeIdentityProviderErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIdentityProviderErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourceServerError {
    /// Kind of error that occurred.
    pub kind: DescribeResourceServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourceServerErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourceServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourceServerErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeResourceServerErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeResourceServerErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeResourceServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeResourceServerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeResourceServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourceServerError {
    fn code(&self) -> Option<&str> {
        DescribeResourceServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourceServerError {
    /// Creates a new `DescribeResourceServerError`.
    pub fn new(kind: DescribeResourceServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourceServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourceServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourceServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourceServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResourceServerErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceServerErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceServerErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceServerErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceServerErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceServerErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceServerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceServerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeResourceServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourceServerErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeResourceServerErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeResourceServerErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeResourceServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeResourceServerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeResourceServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRiskConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRiskConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeRiskConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRiskConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRiskConfigurationErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when user pool add-ons aren't enabled.</p>
    UserPoolAddOnNotEnabledException(crate::error::UserPoolAddOnNotEnabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRiskConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRiskConfigurationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeRiskConfigurationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeRiskConfigurationErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeRiskConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRiskConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRiskConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRiskConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeRiskConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRiskConfigurationError {
    /// Creates a new `DescribeRiskConfigurationError`.
    pub fn new(kind: DescribeRiskConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRiskConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRiskConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRiskConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRiskConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRiskConfigurationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRiskConfigurationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRiskConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRiskConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRiskConfigurationErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRiskConfigurationErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRiskConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRiskConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRiskConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRiskConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException`.
    pub fn is_user_pool_add_on_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException(_)
        )
    }
}
impl std::error::Error for DescribeRiskConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRiskConfigurationErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeRiskConfigurationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeRiskConfigurationErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeRiskConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRiskConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                Some(_inner)
            }
            DescribeRiskConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserImportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeUserImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserImportJobErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserImportJobErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeUserImportJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUserImportJobErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeUserImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserImportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeUserImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserImportJobError {
    fn code(&self) -> Option<&str> {
        DescribeUserImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserImportJobError {
    /// Creates a new `DescribeUserImportJobError`.
    pub fn new(kind: DescribeUserImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserImportJobErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserImportJobErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserImportJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserImportJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserImportJobErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserImportJobErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserImportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserImportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeUserImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserImportJobErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeUserImportJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUserImportJobErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeUserImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserImportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeUserImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserPoolError {
    /// Kind of error that occurred.
    pub kind: DescribeUserPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserPoolErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user pool tag can't be set or updated.</p>
    UserPoolTaggingException(crate::error::UserPoolTaggingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserPoolErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeUserPoolErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUserPoolErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeUserPoolErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserPoolErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeUserPoolErrorKind::UserPoolTaggingException(_inner) => _inner.fmt(f),
            DescribeUserPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserPoolError {
    fn code(&self) -> Option<&str> {
        DescribeUserPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserPoolError {
    /// Creates a new `DescribeUserPoolError`.
    pub fn new(kind: DescribeUserPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserPoolErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserPoolErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolErrorKind::UserPoolTaggingException`.
    pub fn is_user_pool_tagging_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolErrorKind::UserPoolTaggingException(_)
        )
    }
}
impl std::error::Error for DescribeUserPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserPoolErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeUserPoolErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUserPoolErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeUserPoolErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserPoolErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeUserPoolErrorKind::UserPoolTaggingException(_inner) => Some(_inner),
            DescribeUserPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserPoolClientError {
    /// Kind of error that occurred.
    pub kind: DescribeUserPoolClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserPoolClientErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserPoolClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserPoolClientErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeUserPoolClientErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUserPoolClientErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeUserPoolClientErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserPoolClientErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeUserPoolClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserPoolClientError {
    fn code(&self) -> Option<&str> {
        DescribeUserPoolClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserPoolClientError {
    /// Creates a new `DescribeUserPoolClientError`.
    pub fn new(kind: DescribeUserPoolClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserPoolClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserPoolClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserPoolClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserPoolClientErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserPoolClientErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolClientErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolClientErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolClientErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolClientErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolClientErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolClientErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolClientErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolClientErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolClientErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeUserPoolClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserPoolClientErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeUserPoolClientErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUserPoolClientErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeUserPoolClientErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserPoolClientErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeUserPoolClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserPoolDomainError {
    /// Kind of error that occurred.
    pub kind: DescribeUserPoolDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserPoolDomainErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserPoolDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserPoolDomainErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeUserPoolDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUserPoolDomainErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserPoolDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserPoolDomainError {
    fn code(&self) -> Option<&str> {
        DescribeUserPoolDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserPoolDomainError {
    /// Creates a new `DescribeUserPoolDomainError`.
    pub fn new(kind: DescribeUserPoolDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserPoolDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserPoolDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserPoolDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserPoolDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserPoolDomainErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolDomainErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolDomainErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolDomainErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserPoolDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserPoolDomainErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeUserPoolDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserPoolDomainErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeUserPoolDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUserPoolDomainErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserPoolDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ForgetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ForgetDeviceError {
    /// Kind of error that occurred.
    pub kind: ForgetDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ForgetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ForgetDeviceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ForgetDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ForgetDeviceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ForgetDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ForgetDeviceError {
    fn code(&self) -> Option<&str> {
        ForgetDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ForgetDeviceError {
    /// Creates a new `ForgetDeviceError`.
    pub fn new(kind: ForgetDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ForgetDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ForgetDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ForgetDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ForgetDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ForgetDeviceErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgetDeviceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgetDeviceErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, ForgetDeviceErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgetDeviceErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgetDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgetDeviceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgetDeviceErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgetDeviceErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, ForgetDeviceErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for ForgetDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ForgetDeviceErrorKind::InternalErrorException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ForgetDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ForgotPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ForgotPasswordError {
    /// Kind of error that occurred.
    pub kind: ForgotPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ForgotPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ForgotPasswordErrorKind {
    /// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
    CodeDeliveryFailureException(crate::error::CodeDeliveryFailureException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ForgotPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ForgotPasswordErrorKind::CodeDeliveryFailureException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            ForgotPasswordErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ForgotPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ForgotPasswordError {
    fn code(&self) -> Option<&str> {
        ForgotPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ForgotPasswordError {
    /// Creates a new `ForgotPasswordError`.
    pub fn new(kind: ForgotPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ForgotPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ForgotPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ForgotPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ForgotPasswordErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::CodeDeliveryFailureException`.
    pub fn is_code_delivery_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::CodeDeliveryFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `ForgotPasswordErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgotPasswordErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for ForgotPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ForgotPasswordErrorKind::CodeDeliveryFailureException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::InternalErrorException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            ForgotPasswordErrorKind::LimitExceededException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ForgotPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCSVHeader` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCSVHeaderError {
    /// Kind of error that occurred.
    pub kind: GetCSVHeaderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCSVHeader` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCSVHeaderErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCSVHeaderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCSVHeaderErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetCSVHeaderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetCSVHeaderErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GetCSVHeaderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCSVHeaderErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCSVHeaderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCSVHeaderError {
    fn code(&self) -> Option<&str> {
        GetCSVHeaderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCSVHeaderError {
    /// Creates a new `GetCSVHeaderError`.
    pub fn new(kind: GetCSVHeaderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCSVHeaderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCSVHeaderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCSVHeaderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCSVHeaderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCSVHeaderErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetCSVHeaderErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetCSVHeaderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCSVHeaderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCSVHeaderErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, GetCSVHeaderErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `GetCSVHeaderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCSVHeaderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCSVHeaderErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCSVHeaderErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCSVHeaderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCSVHeaderErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetCSVHeaderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetCSVHeaderErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GetCSVHeaderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCSVHeaderErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCSVHeaderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeviceError {
    /// Kind of error that occurred.
    pub kind: GetDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeviceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeviceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeviceError {
    fn code(&self) -> Option<&str> {
        GetDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeviceError {
    /// Creates a new `GetDeviceError`.
    pub fn new(kind: GetDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::UserNotConfirmedException(_))
    }
    /// Returns `true` if the error kind is `GetDeviceErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for GetDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeviceErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetDeviceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetDeviceErrorKind::InvalidUserPoolConfigurationException(_inner) => Some(_inner),
            GetDeviceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GetDeviceErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            GetDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetDeviceErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            GetDeviceErrorKind::UserNotFoundException(_inner) => Some(_inner),
            GetDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupError {
    /// Kind of error that occurred.
    pub kind: GetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupError {
    fn code(&self) -> Option<&str> {
        GetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupError {
    /// Creates a new `GetGroupError`.
    pub fn new(kind: GetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetGroupErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GetGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIdentityProviderByIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIdentityProviderByIdentifierError {
    /// Kind of error that occurred.
    pub kind: GetIdentityProviderByIdentifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIdentityProviderByIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIdentityProviderByIdentifierErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIdentityProviderByIdentifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIdentityProviderByIdentifierErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetIdentityProviderByIdentifierErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetIdentityProviderByIdentifierErrorKind::NotAuthorizedException(_inner) => {
                _inner.fmt(f)
            }
            GetIdentityProviderByIdentifierErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetIdentityProviderByIdentifierErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetIdentityProviderByIdentifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIdentityProviderByIdentifierError {
    fn code(&self) -> Option<&str> {
        GetIdentityProviderByIdentifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIdentityProviderByIdentifierError {
    /// Creates a new `GetIdentityProviderByIdentifierError`.
    pub fn new(
        kind: GetIdentityProviderByIdentifierErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIdentityProviderByIdentifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIdentityProviderByIdentifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIdentityProviderByIdentifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIdentityProviderByIdentifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIdentityProviderByIdentifierErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderByIdentifierErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderByIdentifierErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderByIdentifierErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderByIdentifierErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderByIdentifierErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderByIdentifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderByIdentifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderByIdentifierErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderByIdentifierErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetIdentityProviderByIdentifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIdentityProviderByIdentifierErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            GetIdentityProviderByIdentifierErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetIdentityProviderByIdentifierErrorKind::NotAuthorizedException(_inner) => {
                Some(_inner)
            }
            GetIdentityProviderByIdentifierErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetIdentityProviderByIdentifierErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetIdentityProviderByIdentifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSigningCertificateError {
    /// Kind of error that occurred.
    pub kind: GetSigningCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSigningCertificateErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSigningCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSigningCertificateErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetSigningCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetSigningCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSigningCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSigningCertificateError {
    fn code(&self) -> Option<&str> {
        GetSigningCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSigningCertificateError {
    /// Creates a new `GetSigningCertificateError`.
    pub fn new(kind: GetSigningCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSigningCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSigningCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSigningCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSigningCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSigningCertificateErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSigningCertificateErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSigningCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSigningCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSigningCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSigningCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetSigningCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSigningCertificateErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetSigningCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetSigningCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSigningCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUICustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUICustomizationError {
    /// Kind of error that occurred.
    pub kind: GetUICustomizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUICustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUICustomizationErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUICustomizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUICustomizationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetUICustomizationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetUICustomizationErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GetUICustomizationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUICustomizationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUICustomizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUICustomizationError {
    fn code(&self) -> Option<&str> {
        GetUICustomizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUICustomizationError {
    /// Creates a new `GetUICustomizationError`.
    pub fn new(kind: GetUICustomizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUICustomizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUICustomizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUICustomizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUICustomizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUICustomizationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUICustomizationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUICustomizationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUICustomizationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUICustomizationErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUICustomizationErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUICustomizationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUICustomizationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUICustomizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUICustomizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetUICustomizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUICustomizationErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetUICustomizationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetUICustomizationErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GetUICustomizationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUICustomizationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUICustomizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserError {
    /// Kind of error that occurred.
    pub kind: GetUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetUserErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GetUserErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUserErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            GetUserErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            GetUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserError {
    fn code(&self) -> Option<&str> {
        GetUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserError {
    /// Creates a new `GetUserError`.
    pub fn new(kind: GetUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::UserNotConfirmedException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for GetUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetUserErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GetUserErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            GetUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUserErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            GetUserErrorKind::UserNotFoundException(_inner) => Some(_inner),
            GetUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserAttributeVerificationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserAttributeVerificationCodeError {
    /// Kind of error that occurred.
    pub kind: GetUserAttributeVerificationCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserAttributeVerificationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserAttributeVerificationCodeErrorKind {
    /// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
    CodeDeliveryFailureException(crate::error::CodeDeliveryFailureException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserAttributeVerificationCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserAttributeVerificationCodeErrorKind::CodeDeliveryFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::InvalidEmailRoleAccessPolicyException(
                _inner,
            ) => _inner.fmt(f),
            GetUserAttributeVerificationCodeErrorKind::InvalidLambdaResponseException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleAccessPolicyException(
                _inner,
            ) => _inner.fmt(f),
            GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleTrustRelationshipException(
                _inner,
            ) => _inner.fmt(f),
            GetUserAttributeVerificationCodeErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::NotAuthorizedException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::PasswordResetRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::UnexpectedLambdaException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::UserLambdaValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::UserNotConfirmedException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::UserNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetUserAttributeVerificationCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserAttributeVerificationCodeError {
    fn code(&self) -> Option<&str> {
        GetUserAttributeVerificationCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserAttributeVerificationCodeError {
    /// Creates a new `GetUserAttributeVerificationCodeError`.
    pub fn new(
        kind: GetUserAttributeVerificationCodeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserAttributeVerificationCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserAttributeVerificationCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserAttributeVerificationCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserAttributeVerificationCodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::CodeDeliveryFailureException`.
    pub fn is_code_delivery_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::CodeDeliveryFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserAttributeVerificationCodeErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserAttributeVerificationCodeErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for GetUserAttributeVerificationCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserAttributeVerificationCodeErrorKind::CodeDeliveryFailureException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::InvalidEmailRoleAccessPolicyException(
                _inner,
            ) => Some(_inner),
            GetUserAttributeVerificationCodeErrorKind::InvalidLambdaResponseException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleAccessPolicyException(
                _inner,
            ) => Some(_inner),
            GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleTrustRelationshipException(
                _inner,
            ) => Some(_inner),
            GetUserAttributeVerificationCodeErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::NotAuthorizedException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::PasswordResetRequiredException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::UnexpectedLambdaException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::UserLambdaValidationException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::UserNotConfirmedException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::UserNotFoundException(_inner) => {
                Some(_inner)
            }
            GetUserAttributeVerificationCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserPoolMfaConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserPoolMfaConfigError {
    /// Kind of error that occurred.
    pub kind: GetUserPoolMfaConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserPoolMfaConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserPoolMfaConfigErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserPoolMfaConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserPoolMfaConfigErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetUserPoolMfaConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetUserPoolMfaConfigErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GetUserPoolMfaConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUserPoolMfaConfigErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetUserPoolMfaConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserPoolMfaConfigError {
    fn code(&self) -> Option<&str> {
        GetUserPoolMfaConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserPoolMfaConfigError {
    /// Creates a new `GetUserPoolMfaConfigError`.
    pub fn new(kind: GetUserPoolMfaConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserPoolMfaConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserPoolMfaConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserPoolMfaConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserPoolMfaConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserPoolMfaConfigErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserPoolMfaConfigErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserPoolMfaConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserPoolMfaConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserPoolMfaConfigErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserPoolMfaConfigErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserPoolMfaConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserPoolMfaConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserPoolMfaConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserPoolMfaConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetUserPoolMfaConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserPoolMfaConfigErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetUserPoolMfaConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetUserPoolMfaConfigErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GetUserPoolMfaConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUserPoolMfaConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetUserPoolMfaConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GlobalSignOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GlobalSignOutError {
    /// Kind of error that occurred.
    pub kind: GlobalSignOutErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GlobalSignOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GlobalSignOutErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GlobalSignOutError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GlobalSignOutErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GlobalSignOutErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GlobalSignOutErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GlobalSignOutErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            GlobalSignOutErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GlobalSignOutErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GlobalSignOutErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            GlobalSignOutErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GlobalSignOutError {
    fn code(&self) -> Option<&str> {
        GlobalSignOutError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GlobalSignOutError {
    /// Creates a new `GlobalSignOutError`.
    pub fn new(kind: GlobalSignOutErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GlobalSignOutError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GlobalSignOutErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GlobalSignOutError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GlobalSignOutErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GlobalSignOutErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GlobalSignOutErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GlobalSignOutErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GlobalSignOutErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GlobalSignOutErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GlobalSignOutErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `GlobalSignOutErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GlobalSignOutErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GlobalSignOutErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GlobalSignOutErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GlobalSignOutErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GlobalSignOutErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `GlobalSignOutErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GlobalSignOutErrorKind::UserNotConfirmedException(_)
        )
    }
}
impl std::error::Error for GlobalSignOutError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GlobalSignOutErrorKind::InternalErrorException(_inner) => Some(_inner),
            GlobalSignOutErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GlobalSignOutErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GlobalSignOutErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            GlobalSignOutErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GlobalSignOutErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GlobalSignOutErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            GlobalSignOutErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitiateAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitiateAuthError {
    /// Kind of error that occurred.
    pub kind: InitiateAuthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitiateAuth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitiateAuthErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitiateAuthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitiateAuthErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            InitiateAuthErrorKind::InvalidUserPoolConfigurationException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            InitiateAuthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitiateAuthError {
    fn code(&self) -> Option<&str> {
        InitiateAuthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitiateAuthError {
    /// Creates a new `InitiateAuthError`.
    pub fn new(kind: InitiateAuthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitiateAuthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitiateAuthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitiateAuthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitiateAuthErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, InitiateAuthErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, InitiateAuthErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateAuthErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateAuthErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, InitiateAuthErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for InitiateAuthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitiateAuthErrorKind::InternalErrorException(_inner) => Some(_inner),
            InitiateAuthErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            InitiateAuthErrorKind::InvalidParameterException(_inner) => Some(_inner),
            InitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => Some(_inner),
            InitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => Some(_inner),
            InitiateAuthErrorKind::InvalidUserPoolConfigurationException(_inner) => Some(_inner),
            InitiateAuthErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            InitiateAuthErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            InitiateAuthErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InitiateAuthErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            InitiateAuthErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            InitiateAuthErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            InitiateAuthErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            InitiateAuthErrorKind::UserNotFoundException(_inner) => Some(_inner),
            InitiateAuthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevicesError {
    /// Kind of error that occurred.
    pub kind: ListDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevicesErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevicesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::InvalidUserPoolConfigurationException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevicesError {
    fn code(&self) -> Option<&str> {
        ListDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevicesError {
    /// Creates a new `ListDevicesError`.
    pub fn new(kind: ListDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::UserNotFoundException(_))
    }
}
impl std::error::Error for ListDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevicesErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListDevicesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListDevicesErrorKind::InvalidUserPoolConfigurationException(_inner) => Some(_inner),
            ListDevicesErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListDevicesErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            ListDevicesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDevicesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListDevicesErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            ListDevicesErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ListDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupsError {
    /// Kind of error that occurred.
    pub kind: ListGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupsErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupsError {
    fn code(&self) -> Option<&str> {
        ListGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupsError {
    /// Creates a new `ListGroupsError`.
    pub fn new(kind: ListGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListGroupsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListGroupsErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListGroupsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIdentityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIdentityProvidersError {
    /// Kind of error that occurred.
    pub kind: ListIdentityProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIdentityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIdentityProvidersErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIdentityProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIdentityProvidersErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIdentityProvidersError {
    fn code(&self) -> Option<&str> {
        ListIdentityProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIdentityProvidersError {
    /// Creates a new `ListIdentityProvidersError`.
    pub fn new(kind: ListIdentityProvidersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIdentityProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIdentityProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIdentityProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIdentityProvidersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListIdentityProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIdentityProvidersErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceServersError {
    /// Kind of error that occurred.
    pub kind: ListResourceServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceServersErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceServersErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListResourceServersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListResourceServersErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListResourceServersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListResourceServersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListResourceServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceServersError {
    fn code(&self) -> Option<&str> {
        ListResourceServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceServersError {
    /// Creates a new `ListResourceServersError`.
    pub fn new(kind: ListResourceServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceServersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceServersErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceServersErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceServersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceServersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceServersErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceServersErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceServersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceServersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceServersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceServersErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListResourceServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceServersErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListResourceServersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListResourceServersErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListResourceServersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListResourceServersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListResourceServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserImportJobsError {
    /// Kind of error that occurred.
    pub kind: ListUserImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserImportJobsErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserImportJobsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListUserImportJobsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUserImportJobsErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListUserImportJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUserImportJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListUserImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserImportJobsError {
    fn code(&self) -> Option<&str> {
        ListUserImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserImportJobsError {
    /// Creates a new `ListUserImportJobsError`.
    pub fn new(kind: ListUserImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserImportJobsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserImportJobsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserImportJobsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserImportJobsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserImportJobsErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserImportJobsErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserImportJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserImportJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserImportJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserImportJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListUserImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserImportJobsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListUserImportJobsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUserImportJobsErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListUserImportJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUserImportJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListUserImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserPoolClients` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserPoolClientsError {
    /// Kind of error that occurred.
    pub kind: ListUserPoolClientsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserPoolClients` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserPoolClientsErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserPoolClientsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserPoolClientsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListUserPoolClientsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUserPoolClientsErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListUserPoolClientsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUserPoolClientsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListUserPoolClientsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserPoolClientsError {
    fn code(&self) -> Option<&str> {
        ListUserPoolClientsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserPoolClientsError {
    /// Creates a new `ListUserPoolClientsError`.
    pub fn new(kind: ListUserPoolClientsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserPoolClientsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserPoolClientsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserPoolClientsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserPoolClientsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserPoolClientsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolClientsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoolClientsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolClientsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoolClientsErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolClientsErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoolClientsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolClientsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoolClientsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolClientsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListUserPoolClientsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserPoolClientsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListUserPoolClientsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUserPoolClientsErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListUserPoolClientsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUserPoolClientsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListUserPoolClientsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserPools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserPoolsError {
    /// Kind of error that occurred.
    pub kind: ListUserPoolsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserPools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserPoolsErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserPoolsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserPoolsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListUserPoolsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUserPoolsErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListUserPoolsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListUserPoolsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserPoolsError {
    fn code(&self) -> Option<&str> {
        ListUserPoolsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserPoolsError {
    /// Creates a new `ListUserPoolsError`.
    pub fn new(kind: ListUserPoolsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserPoolsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserPoolsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserPoolsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserPoolsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserPoolsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoolsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoolsErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolsErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoolsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoolsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListUserPoolsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserPoolsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListUserPoolsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUserPoolsErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListUserPoolsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListUserPoolsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListUsersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUsersErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUsersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsersInGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersInGroupError {
    /// Kind of error that occurred.
    pub kind: ListUsersInGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsersInGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersInGroupErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersInGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersInGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListUsersInGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUsersInGroupErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListUsersInGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUsersInGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListUsersInGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersInGroupError {
    fn code(&self) -> Option<&str> {
        ListUsersInGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersInGroupError {
    /// Creates a new `ListUsersInGroupError`.
    pub fn new(kind: ListUsersInGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersInGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersInGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersInGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersInGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersInGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersInGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersInGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersInGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersInGroupErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersInGroupErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersInGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersInGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersInGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersInGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListUsersInGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersInGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListUsersInGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUsersInGroupErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListUsersInGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUsersInGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListUsersInGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResendConfirmationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResendConfirmationCodeError {
    /// Kind of error that occurred.
    pub kind: ResendConfirmationCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResendConfirmationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResendConfirmationCodeErrorKind {
    /// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
    CodeDeliveryFailureException(crate::error::CodeDeliveryFailureException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResendConfirmationCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResendConfirmationCodeErrorKind::CodeDeliveryFailureException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            ResendConfirmationCodeErrorKind::InvalidLambdaResponseException(_inner) => {
                _inner.fmt(f)
            }
            ResendConfirmationCodeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            ResendConfirmationCodeErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            ResendConfirmationCodeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            ResendConfirmationCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResendConfirmationCodeError {
    fn code(&self) -> Option<&str> {
        ResendConfirmationCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResendConfirmationCodeError {
    /// Creates a new `ResendConfirmationCodeError`.
    pub fn new(kind: ResendConfirmationCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResendConfirmationCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResendConfirmationCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResendConfirmationCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResendConfirmationCodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::CodeDeliveryFailureException`.
    pub fn is_code_delivery_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::CodeDeliveryFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `ResendConfirmationCodeErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendConfirmationCodeErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for ResendConfirmationCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResendConfirmationCodeErrorKind::CodeDeliveryFailureException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::InternalErrorException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            ResendConfirmationCodeErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            ResendConfirmationCodeErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            ResendConfirmationCodeErrorKind::LimitExceededException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::UserNotFoundException(_inner) => Some(_inner),
            ResendConfirmationCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RespondToAuthChallenge` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RespondToAuthChallengeError {
    /// Kind of error that occurred.
    pub kind: RespondToAuthChallengeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RespondToAuthChallenge` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RespondToAuthChallengeErrorKind {
    /// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
    AliasExistsException(crate::error::AliasExistsException),
    /// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
    CodeMismatchException(crate::error::CodeMismatchException),
    /// <p>This exception is thrown if a code has expired.</p>
    ExpiredCodeException(crate::error::ExpiredCodeException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when Amazon Cognito can't find a multi-factor authentication (MFA) method.</p>
    MfaMethodNotFoundException(crate::error::MfaMethodNotFoundException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the software token time-based one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</p>
    SoftwareTokenMfaNotFoundException(crate::error::SoftwareTokenMfaNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RespondToAuthChallengeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RespondToAuthChallengeErrorKind::AliasExistsException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::CodeMismatchException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::ExpiredCodeException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::InvalidLambdaResponseException(_inner) => {
                _inner.fmt(f)
            }
            RespondToAuthChallengeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            RespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            RespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            RespondToAuthChallengeErrorKind::MfaMethodNotFoundException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::PasswordResetRequiredException(_inner) => {
                _inner.fmt(f)
            }
            RespondToAuthChallengeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RespondToAuthChallengeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            RespondToAuthChallengeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RespondToAuthChallengeError {
    fn code(&self) -> Option<&str> {
        RespondToAuthChallengeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RespondToAuthChallengeError {
    /// Creates a new `RespondToAuthChallengeError`.
    pub fn new(kind: RespondToAuthChallengeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RespondToAuthChallengeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RespondToAuthChallengeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RespondToAuthChallengeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RespondToAuthChallengeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::AliasExistsException`.
    pub fn is_alias_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::AliasExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::CodeMismatchException`.
    pub fn is_code_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::CodeMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::ExpiredCodeException`.
    pub fn is_expired_code_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::ExpiredCodeException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::MfaMethodNotFoundException`.
    pub fn is_mfa_method_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::MfaMethodNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException`.
    pub fn is_software_token_mfa_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `RespondToAuthChallengeErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RespondToAuthChallengeErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for RespondToAuthChallengeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RespondToAuthChallengeErrorKind::AliasExistsException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::CodeMismatchException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::ExpiredCodeException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::InternalErrorException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            RespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            RespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            RespondToAuthChallengeErrorKind::MfaMethodNotFoundException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException(_inner) => {
                Some(_inner)
            }
            RespondToAuthChallengeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::UserNotFoundException(_inner) => Some(_inner),
            RespondToAuthChallengeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeTokenError {
    /// Kind of error that occurred.
    pub kind: RevokeTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeTokenErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>Exception that is thrown when the request isn't authorized. This can happen due to an invalid access token in the request.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>Exception that is thrown when you attempt to perform an operation that isn't enabled for the user pool client.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// <p>Exception that is thrown when an unsupported token is passed to an operation.</p>
    UnsupportedTokenTypeException(crate::error::UnsupportedTokenTypeException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeTokenErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            RevokeTokenErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RevokeTokenErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RevokeTokenErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            RevokeTokenErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            RevokeTokenErrorKind::UnsupportedTokenTypeException(_inner) => _inner.fmt(f),
            RevokeTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeTokenError {
    fn code(&self) -> Option<&str> {
        RevokeTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeTokenError {
    /// Creates a new `RevokeTokenError`.
    pub fn new(kind: RevokeTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeTokenErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, RevokeTokenErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `RevokeTokenErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeTokenErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeTokenErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeTokenErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeTokenErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, RevokeTokenErrorKind::UnauthorizedException(_))
    }
    /// Returns `true` if the error kind is `RevokeTokenErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeTokenErrorKind::UnsupportedOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeTokenErrorKind::UnsupportedTokenTypeException`.
    pub fn is_unsupported_token_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeTokenErrorKind::UnsupportedTokenTypeException(_)
        )
    }
}
impl std::error::Error for RevokeTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeTokenErrorKind::InternalErrorException(_inner) => Some(_inner),
            RevokeTokenErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RevokeTokenErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RevokeTokenErrorKind::UnauthorizedException(_inner) => Some(_inner),
            RevokeTokenErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            RevokeTokenErrorKind::UnsupportedTokenTypeException(_inner) => Some(_inner),
            RevokeTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetRiskConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetRiskConfigurationError {
    /// Kind of error that occurred.
    pub kind: SetRiskConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetRiskConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetRiskConfigurationErrorKind {
    /// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
    CodeDeliveryFailureException(crate::error::CodeDeliveryFailureException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when user pool add-ons aren't enabled.</p>
    UserPoolAddOnNotEnabledException(crate::error::UserPoolAddOnNotEnabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetRiskConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetRiskConfigurationErrorKind::CodeDeliveryFailureException(_inner) => _inner.fmt(f),
            SetRiskConfigurationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetRiskConfigurationErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            SetRiskConfigurationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetRiskConfigurationErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            SetRiskConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetRiskConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SetRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                _inner.fmt(f)
            }
            SetRiskConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetRiskConfigurationError {
    fn code(&self) -> Option<&str> {
        SetRiskConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetRiskConfigurationError {
    /// Creates a new `SetRiskConfigurationError`.
    pub fn new(kind: SetRiskConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetRiskConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetRiskConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetRiskConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetRiskConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::CodeDeliveryFailureException`.
    pub fn is_code_delivery_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::CodeDeliveryFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException`.
    pub fn is_user_pool_add_on_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException(_)
        )
    }
}
impl std::error::Error for SetRiskConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetRiskConfigurationErrorKind::CodeDeliveryFailureException(_inner) => Some(_inner),
            SetRiskConfigurationErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetRiskConfigurationErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            SetRiskConfigurationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetRiskConfigurationErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            SetRiskConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetRiskConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SetRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException(_inner) => Some(_inner),
            SetRiskConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetUICustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetUICustomizationError {
    /// Kind of error that occurred.
    pub kind: SetUICustomizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetUICustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetUICustomizationErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetUICustomizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetUICustomizationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetUICustomizationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetUICustomizationErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            SetUICustomizationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetUICustomizationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SetUICustomizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetUICustomizationError {
    fn code(&self) -> Option<&str> {
        SetUICustomizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetUICustomizationError {
    /// Creates a new `SetUICustomizationError`.
    pub fn new(kind: SetUICustomizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetUICustomizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetUICustomizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetUICustomizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetUICustomizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetUICustomizationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUICustomizationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUICustomizationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUICustomizationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUICustomizationErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUICustomizationErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUICustomizationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUICustomizationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUICustomizationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUICustomizationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for SetUICustomizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetUICustomizationErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetUICustomizationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetUICustomizationErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            SetUICustomizationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetUICustomizationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SetUICustomizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetUserMFAPreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetUserMFAPreferenceError {
    /// Kind of error that occurred.
    pub kind: SetUserMFAPreferenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetUserMFAPreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetUserMFAPreferenceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetUserMFAPreferenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetUserMFAPreferenceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetUserMFAPreferenceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetUserMFAPreferenceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            SetUserMFAPreferenceErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            SetUserMFAPreferenceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetUserMFAPreferenceErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            SetUserMFAPreferenceErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            SetUserMFAPreferenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetUserMFAPreferenceError {
    fn code(&self) -> Option<&str> {
        SetUserMFAPreferenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetUserMFAPreferenceError {
    /// Creates a new `SetUserMFAPreferenceError`.
    pub fn new(kind: SetUserMFAPreferenceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetUserMFAPreferenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetUserMFAPreferenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetUserMFAPreferenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetUserMFAPreferenceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetUserMFAPreferenceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserMFAPreferenceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserMFAPreferenceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserMFAPreferenceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserMFAPreferenceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserMFAPreferenceErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserMFAPreferenceErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserMFAPreferenceErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserMFAPreferenceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserMFAPreferenceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserMFAPreferenceErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserMFAPreferenceErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserMFAPreferenceErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserMFAPreferenceErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for SetUserMFAPreferenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetUserMFAPreferenceErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetUserMFAPreferenceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetUserMFAPreferenceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            SetUserMFAPreferenceErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            SetUserMFAPreferenceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetUserMFAPreferenceErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            SetUserMFAPreferenceErrorKind::UserNotFoundException(_inner) => Some(_inner),
            SetUserMFAPreferenceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetUserPoolMfaConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetUserPoolMfaConfigError {
    /// Kind of error that occurred.
    pub kind: SetUserPoolMfaConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetUserPoolMfaConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetUserPoolMfaConfigErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetUserPoolMfaConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetUserPoolMfaConfigErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetUserPoolMfaConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetUserPoolMfaConfigErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            SetUserPoolMfaConfigErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            SetUserPoolMfaConfigErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            SetUserPoolMfaConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetUserPoolMfaConfigErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SetUserPoolMfaConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetUserPoolMfaConfigError {
    fn code(&self) -> Option<&str> {
        SetUserPoolMfaConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetUserPoolMfaConfigError {
    /// Creates a new `SetUserPoolMfaConfigError`.
    pub fn new(kind: SetUserPoolMfaConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetUserPoolMfaConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetUserPoolMfaConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetUserPoolMfaConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetUserPoolMfaConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetUserPoolMfaConfigErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserPoolMfaConfigErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserPoolMfaConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserPoolMfaConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserPoolMfaConfigErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserPoolMfaConfigErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserPoolMfaConfigErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserPoolMfaConfigErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserPoolMfaConfigErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserPoolMfaConfigErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserPoolMfaConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserPoolMfaConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserPoolMfaConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserPoolMfaConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for SetUserPoolMfaConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetUserPoolMfaConfigErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetUserPoolMfaConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetUserPoolMfaConfigErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            SetUserPoolMfaConfigErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            SetUserPoolMfaConfigErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            SetUserPoolMfaConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetUserPoolMfaConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SetUserPoolMfaConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetUserSettingsError {
    /// Kind of error that occurred.
    pub kind: SetUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetUserSettingsErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetUserSettingsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetUserSettingsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetUserSettingsErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            SetUserSettingsErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            SetUserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetUserSettingsErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            SetUserSettingsErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            SetUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetUserSettingsError {
    fn code(&self) -> Option<&str> {
        SetUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetUserSettingsError {
    /// Creates a new `SetUserSettingsError`.
    pub fn new(kind: SetUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetUserSettingsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserSettingsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserSettingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserSettingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserSettingsErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserSettingsErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserSettingsErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserSettingsErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserSettingsErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserSettingsErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetUserSettingsErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetUserSettingsErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for SetUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetUserSettingsErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetUserSettingsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetUserSettingsErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            SetUserSettingsErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            SetUserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetUserSettingsErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            SetUserSettingsErrorKind::UserNotFoundException(_inner) => Some(_inner),
            SetUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SignUp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SignUpError {
    /// Kind of error that occurred.
    pub kind: SignUpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SignUp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SignUpErrorKind {
    /// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
    CodeDeliveryFailureException(crate::error::CodeDeliveryFailureException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.</p>
    UsernameExistsException(crate::error::UsernameExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SignUpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SignUpErrorKind::CodeDeliveryFailureException(_inner) => _inner.fmt(f),
            SignUpErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SignUpErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => _inner.fmt(f),
            SignUpErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            SignUpErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SignUpErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            SignUpErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => _inner.fmt(f),
            SignUpErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => _inner.fmt(f),
            SignUpErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            SignUpErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SignUpErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SignUpErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            SignUpErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            SignUpErrorKind::UsernameExistsException(_inner) => _inner.fmt(f),
            SignUpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SignUpError {
    fn code(&self) -> Option<&str> {
        SignUpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SignUpError {
    /// Creates a new `SignUpError`.
    pub fn new(kind: SignUpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SignUpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SignUpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SignUpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SignUpErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::CodeDeliveryFailureException`.
    pub fn is_code_delivery_failure_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::CodeDeliveryFailureException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignUpErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignUpErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::InvalidPasswordException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignUpErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignUpErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::UnexpectedLambdaException(_))
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignUpErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `SignUpErrorKind::UsernameExistsException`.
    pub fn is_username_exists_exception(&self) -> bool {
        matches!(&self.kind, SignUpErrorKind::UsernameExistsException(_))
    }
}
impl std::error::Error for SignUpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SignUpErrorKind::CodeDeliveryFailureException(_inner) => Some(_inner),
            SignUpErrorKind::InternalErrorException(_inner) => Some(_inner),
            SignUpErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => Some(_inner),
            SignUpErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            SignUpErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SignUpErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            SignUpErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => Some(_inner),
            SignUpErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => Some(_inner),
            SignUpErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            SignUpErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SignUpErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SignUpErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            SignUpErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            SignUpErrorKind::UsernameExistsException(_inner) => Some(_inner),
            SignUpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartUserImportJobError {
    /// Kind of error that occurred.
    pub kind: StartUserImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartUserImportJobErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a precondition is not met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartUserImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartUserImportJobErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            StartUserImportJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartUserImportJobErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            StartUserImportJobErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            StartUserImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartUserImportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartUserImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartUserImportJobError {
    fn code(&self) -> Option<&str> {
        StartUserImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartUserImportJobError {
    /// Creates a new `StartUserImportJobError`.
    pub fn new(kind: StartUserImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartUserImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartUserImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartUserImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartUserImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartUserImportJobErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartUserImportJobErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StartUserImportJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartUserImportJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartUserImportJobErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartUserImportJobErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartUserImportJobErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartUserImportJobErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `StartUserImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartUserImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartUserImportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartUserImportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StartUserImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartUserImportJobErrorKind::InternalErrorException(_inner) => Some(_inner),
            StartUserImportJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartUserImportJobErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            StartUserImportJobErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            StartUserImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartUserImportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartUserImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopUserImportJobError {
    /// Kind of error that occurred.
    pub kind: StopUserImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopUserImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopUserImportJobErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a precondition is not met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopUserImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopUserImportJobErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            StopUserImportJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StopUserImportJobErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            StopUserImportJobErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            StopUserImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopUserImportJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StopUserImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopUserImportJobError {
    fn code(&self) -> Option<&str> {
        StopUserImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopUserImportJobError {
    /// Creates a new `StopUserImportJobError`.
    pub fn new(kind: StopUserImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopUserImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopUserImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopUserImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopUserImportJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopUserImportJobErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopUserImportJobErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StopUserImportJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopUserImportJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StopUserImportJobErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopUserImportJobErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopUserImportJobErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopUserImportJobErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `StopUserImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopUserImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopUserImportJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopUserImportJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StopUserImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopUserImportJobErrorKind::InternalErrorException(_inner) => Some(_inner),
            StopUserImportJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StopUserImportJobErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            StopUserImportJobErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            StopUserImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopUserImportJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StopUserImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAuthEventFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAuthEventFeedbackError {
    /// Kind of error that occurred.
    pub kind: UpdateAuthEventFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAuthEventFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAuthEventFeedbackErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// <p>This exception is thrown when user pool add-ons aren't enabled.</p>
    UserPoolAddOnNotEnabledException(crate::error::UserPoolAddOnNotEnabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAuthEventFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAuthEventFeedbackErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateAuthEventFeedbackErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateAuthEventFeedbackErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateAuthEventFeedbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAuthEventFeedbackErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateAuthEventFeedbackErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            UpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAuthEventFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAuthEventFeedbackError {
    fn code(&self) -> Option<&str> {
        UpdateAuthEventFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAuthEventFeedbackError {
    /// Creates a new `UpdateAuthEventFeedbackError`.
    pub fn new(kind: UpdateAuthEventFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAuthEventFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAuthEventFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAuthEventFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAuthEventFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAuthEventFeedbackErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthEventFeedbackErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuthEventFeedbackErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthEventFeedbackErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuthEventFeedbackErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthEventFeedbackErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuthEventFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthEventFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuthEventFeedbackErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthEventFeedbackErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuthEventFeedbackErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthEventFeedbackErrorKind::UserNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException`.
    pub fn is_user_pool_add_on_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException(_)
        )
    }
}
impl std::error::Error for UpdateAuthEventFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAuthEventFeedbackErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateAuthEventFeedbackErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateAuthEventFeedbackErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateAuthEventFeedbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAuthEventFeedbackErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateAuthEventFeedbackErrorKind::UserNotFoundException(_inner) => Some(_inner),
            UpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException(_inner) => {
                Some(_inner)
            }
            UpdateAuthEventFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeviceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeviceStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateDeviceStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeviceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeviceStatusErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeviceStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeviceStatusErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDeviceStatusErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            UpdateDeviceStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeviceStatusError {
    fn code(&self) -> Option<&str> {
        UpdateDeviceStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeviceStatusError {
    /// Creates a new `UpdateDeviceStatusError`.
    pub fn new(kind: UpdateDeviceStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeviceStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeviceStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeviceStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeviceStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStatusErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStatusErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateDeviceStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeviceStatusErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            UpdateDeviceStatusErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::UserNotFoundException(_inner) => Some(_inner),
            UpdateDeviceStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGroupErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGroupError {
    fn code(&self) -> Option<&str> {
        UpdateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGroupError {
    /// Creates a new `UpdateGroupError`.
    pub fn new(kind: UpdateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateGroupErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: UpdateIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIdentityProviderErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when the specified identifier isn't supported.</p>
    UnsupportedIdentityProviderException(crate::error::UnsupportedIdentityProviderException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIdentityProviderErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::UnsupportedIdentityProviderException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIdentityProviderError {
    fn code(&self) -> Option<&str> {
        UpdateIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIdentityProviderError {
    /// Creates a new `UpdateIdentityProviderError`.
    pub fn new(kind: UpdateIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::UnsupportedIdentityProviderException`.
    pub fn is_unsupported_identity_provider_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::UnsupportedIdentityProviderException(_)
        )
    }
}
impl std::error::Error for UpdateIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIdentityProviderErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::UnsupportedIdentityProviderException(_inner) => {
                Some(_inner)
            }
            UpdateIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceServerError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceServerErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceServerErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateResourceServerErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateResourceServerErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateResourceServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceServerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateResourceServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceServerError {
    fn code(&self) -> Option<&str> {
        UpdateResourceServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceServerError {
    /// Creates a new `UpdateResourceServerError`.
    pub fn new(kind: UpdateResourceServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceServerErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceServerErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceServerErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceServerErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceServerErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceServerErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceServerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceServerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateResourceServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceServerErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateResourceServerErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateResourceServerErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateResourceServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateResourceServerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateResourceServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateUserAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserAttributesErrorKind {
    /// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
    AliasExistsException(crate::error::AliasExistsException),
    /// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
    CodeDeliveryFailureException(crate::error::CodeDeliveryFailureException),
    /// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
    CodeMismatchException(crate::error::CodeMismatchException),
    /// <p>This exception is thrown if a code has expired.</p>
    ExpiredCodeException(crate::error::ExpiredCodeException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
    InvalidLambdaResponseException(crate::error::InvalidLambdaResponseException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
    UnexpectedLambdaException(crate::error::UnexpectedLambdaException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
    UserLambdaValidationException(crate::error::UserLambdaValidationException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserAttributesErrorKind::AliasExistsException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::CodeDeliveryFailureException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::CodeMismatchException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::ExpiredCodeException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserAttributesErrorKind::InvalidLambdaResponseException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserAttributesErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::UnexpectedLambdaException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::UserLambdaValidationException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateUserAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserAttributesError {
    /// Creates a new `UpdateUserAttributesError`.
    pub fn new(kind: UpdateUserAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::AliasExistsException`.
    pub fn is_alias_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::AliasExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::CodeDeliveryFailureException`.
    pub fn is_code_delivery_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::CodeDeliveryFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::CodeMismatchException`.
    pub fn is_code_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::CodeMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::ExpiredCodeException`.
    pub fn is_expired_code_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::ExpiredCodeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::InvalidLambdaResponseException`.
    pub fn is_invalid_lambda_response_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::InvalidLambdaResponseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::UnexpectedLambdaException`.
    pub fn is_unexpected_lambda_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::UnexpectedLambdaException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::UserLambdaValidationException`.
    pub fn is_user_lambda_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::UserLambdaValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserAttributesErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserAttributesErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateUserAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserAttributesErrorKind::AliasExistsException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::CodeDeliveryFailureException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::CodeMismatchException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::ExpiredCodeException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            UpdateUserAttributesErrorKind::InvalidLambdaResponseException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => {
                Some(_inner)
            }
            UpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            UpdateUserAttributesErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::UnexpectedLambdaException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::UserLambdaValidationException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::UserNotFoundException(_inner) => Some(_inner),
            UpdateUserAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserPoolError {
    /// Kind of error that occurred.
    pub kind: UpdateUserPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserPoolErrorKind {
    /// <p>This exception is thrown if two or more modifications are happening concurrently.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
    InvalidEmailRoleAccessPolicyException(crate::error::InvalidEmailRoleAccessPolicyException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
    InvalidSmsRoleAccessPolicyException(crate::error::InvalidSmsRoleAccessPolicyException),
    /// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
    InvalidSmsRoleTrustRelationshipException(
        crate::error::InvalidSmsRoleTrustRelationshipException,
    ),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when you're trying to modify a user pool while a user import job is in progress for that pool.</p>
    UserImportInProgressException(crate::error::UserImportInProgressException),
    /// <p>This exception is thrown when a user pool tag can't be set or updated.</p>
    UserPoolTaggingException(crate::error::UserPoolTaggingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserPoolErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserPoolErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::UserImportInProgressException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::UserPoolTaggingException(_inner) => _inner.fmt(f),
            UpdateUserPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserPoolError {
    fn code(&self) -> Option<&str> {
        UpdateUserPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserPoolError {
    /// Creates a new `UpdateUserPoolError`.
    pub fn new(kind: UpdateUserPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserPoolErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException`.
    pub fn is_invalid_email_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException`.
    pub fn is_invalid_sms_role_access_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException`.
    pub fn is_invalid_sms_role_trust_relationship_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::UserImportInProgressException`.
    pub fn is_user_import_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::UserImportInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolErrorKind::UserPoolTaggingException`.
    pub fn is_user_pool_tagging_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolErrorKind::UserPoolTaggingException(_)
        )
    }
}
impl std::error::Error for UpdateUserPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserPoolErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(_inner) => {
                Some(_inner)
            }
            UpdateUserPoolErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::UserImportInProgressException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::UserPoolTaggingException(_inner) => Some(_inner),
            UpdateUserPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserPoolClientError {
    /// Kind of error that occurred.
    pub kind: UpdateUserPoolClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserPoolClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserPoolClientErrorKind {
    /// <p>This exception is thrown if two or more modifications are happening concurrently.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the specified OAuth flow is not valid.</p>
    InvalidOAuthFlowException(crate::error::InvalidOAuthFlowException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the specified scope doesn't exist.</p>
    ScopeDoesNotExistException(crate::error::ScopeDoesNotExistException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserPoolClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserPoolClientErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::InvalidOAuthFlowException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::ScopeDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateUserPoolClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserPoolClientError {
    fn code(&self) -> Option<&str> {
        UpdateUserPoolClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserPoolClientError {
    /// Creates a new `UpdateUserPoolClientError`.
    pub fn new(kind: UpdateUserPoolClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserPoolClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserPoolClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserPoolClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserPoolClientErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::InvalidOAuthFlowException`.
    pub fn is_invalid_o_auth_flow_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::InvalidOAuthFlowException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::ScopeDoesNotExistException`.
    pub fn is_scope_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::ScopeDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolClientErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolClientErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateUserPoolClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserPoolClientErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::InvalidOAuthFlowException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::ScopeDoesNotExistException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateUserPoolClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserPoolDomainError {
    /// Kind of error that occurred.
    pub kind: UpdateUserPoolDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserPoolDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserPoolDomainErrorKind {
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserPoolDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserPoolDomainErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateUserPoolDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserPoolDomainErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserPoolDomainErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateUserPoolDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserPoolDomainError {
    fn code(&self) -> Option<&str> {
        UpdateUserPoolDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserPoolDomainError {
    /// Creates a new `UpdateUserPoolDomainError`.
    pub fn new(kind: UpdateUserPoolDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserPoolDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserPoolDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserPoolDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserPoolDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserPoolDomainErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolDomainErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolDomainErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolDomainErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPoolDomainErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPoolDomainErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateUserPoolDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserPoolDomainErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateUserPoolDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserPoolDomainErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateUserPoolDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserPoolDomainErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateUserPoolDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifySoftwareToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifySoftwareTokenError {
    /// Kind of error that occurred.
    pub kind: VerifySoftwareTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifySoftwareToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifySoftwareTokenErrorKind {
    /// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
    CodeMismatchException(crate::error::CodeMismatchException),
    /// <p>This exception is thrown when there is a code mismatch and the service fails to configure the software token TOTP multi-factor authentication (MFA).</p>
    EnableSoftwareTokenMfaException(crate::error::EnableSoftwareTokenMfaException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the user pool configuration is not valid.</p>
    InvalidUserPoolConfigurationException(crate::error::InvalidUserPoolConfigurationException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the software token time-based one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</p>
    SoftwareTokenMfaNotFoundException(crate::error::SoftwareTokenMfaNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifySoftwareTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifySoftwareTokenErrorKind::CodeMismatchException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::EnableSoftwareTokenMfaException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            VerifySoftwareTokenErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            VerifySoftwareTokenErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            VerifySoftwareTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifySoftwareTokenError {
    fn code(&self) -> Option<&str> {
        VerifySoftwareTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifySoftwareTokenError {
    /// Creates a new `VerifySoftwareTokenError`.
    pub fn new(kind: VerifySoftwareTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifySoftwareTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifySoftwareTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifySoftwareTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifySoftwareTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::CodeMismatchException`.
    pub fn is_code_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::CodeMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::EnableSoftwareTokenMfaException`.
    pub fn is_enable_software_token_mfa_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::EnableSoftwareTokenMfaException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::InvalidUserPoolConfigurationException`.
    pub fn is_invalid_user_pool_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::InvalidUserPoolConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException`.
    pub fn is_software_token_mfa_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifySoftwareTokenErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySoftwareTokenErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for VerifySoftwareTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifySoftwareTokenErrorKind::CodeMismatchException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::EnableSoftwareTokenMfaException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::InternalErrorException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::InvalidParameterException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::InvalidUserPoolConfigurationException(_inner) => {
                Some(_inner)
            }
            VerifySoftwareTokenErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::UserNotFoundException(_inner) => Some(_inner),
            VerifySoftwareTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifyUserAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifyUserAttributeError {
    /// Kind of error that occurred.
    pub kind: VerifyUserAttributeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifyUserAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifyUserAttributeErrorKind {
    /// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
    CodeMismatchException(crate::error::CodeMismatchException),
    /// <p>This exception is thrown if a code has expired.</p>
    ExpiredCodeException(crate::error::ExpiredCodeException),
    /// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is thrown when a user isn't authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>This exception is thrown when a password reset is required.</p>
    PasswordResetRequiredException(crate::error::PasswordResetRequiredException),
    /// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>This exception is thrown when a user isn't confirmed successfully.</p>
    UserNotConfirmedException(crate::error::UserNotConfirmedException),
    /// <p>This exception is thrown when a user isn't found.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifyUserAttributeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifyUserAttributeErrorKind::CodeMismatchException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::ExpiredCodeException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::PasswordResetRequiredException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::UserNotConfirmedException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            VerifyUserAttributeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifyUserAttributeError {
    fn code(&self) -> Option<&str> {
        VerifyUserAttributeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifyUserAttributeError {
    /// Creates a new `VerifyUserAttributeError`.
    pub fn new(kind: VerifyUserAttributeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifyUserAttributeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifyUserAttributeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifyUserAttributeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifyUserAttributeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::CodeMismatchException`.
    pub fn is_code_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::CodeMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::ExpiredCodeException`.
    pub fn is_expired_code_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::ExpiredCodeException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::PasswordResetRequiredException`.
    pub fn is_password_reset_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::PasswordResetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::UserNotConfirmedException`.
    pub fn is_user_not_confirmed_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::UserNotConfirmedException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyUserAttributeErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyUserAttributeErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for VerifyUserAttributeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifyUserAttributeErrorKind::CodeMismatchException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::ExpiredCodeException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::InternalErrorException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::LimitExceededException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::PasswordResetRequiredException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::UserNotConfirmedException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::UserNotFoundException(_inner) => Some(_inner),
            VerifyUserAttributeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>This exception is thrown when a user isn't found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserNotFoundException {
    /// <p>The message returned when a user isn't found.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserNotFoundException {}
/// See [`UserNotFoundException`](crate::error::UserNotFoundException)
pub mod user_not_found_exception {
    /// A builder for [`UserNotFoundException`](crate::error::UserNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when a user isn't found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when a user isn't found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserNotFoundException`](crate::error::UserNotFoundException)
        pub fn build(self) -> crate::error::UserNotFoundException {
            crate::error::UserNotFoundException {
                message: self.message,
            }
        }
    }
}
impl UserNotFoundException {
    /// Creates a new builder-style object to manufacture [`UserNotFoundException`](crate::error::UserNotFoundException)
    pub fn builder() -> crate::error::user_not_found_exception::Builder {
        crate::error::user_not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a user isn't confirmed successfully.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserNotConfirmedException {
    /// <p>The message returned when a user isn't confirmed successfully.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserNotConfirmedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserNotConfirmedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserNotConfirmedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserNotConfirmedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserNotConfirmedException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserNotConfirmedException {}
/// See [`UserNotConfirmedException`](crate::error::UserNotConfirmedException)
pub mod user_not_confirmed_exception {
    /// A builder for [`UserNotConfirmedException`](crate::error::UserNotConfirmedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when a user isn't confirmed successfully.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when a user isn't confirmed successfully.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserNotConfirmedException`](crate::error::UserNotConfirmedException)
        pub fn build(self) -> crate::error::UserNotConfirmedException {
            crate::error::UserNotConfirmedException {
                message: self.message,
            }
        }
    }
}
impl UserNotConfirmedException {
    /// Creates a new builder-style object to manufacture [`UserNotConfirmedException`](crate::error::UserNotConfirmedException)
    pub fn builder() -> crate::error::user_not_confirmed_exception::Builder {
        crate::error::user_not_confirmed_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the user has made too many requests for a given operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>The message returned when the Amazon Cognito service returns a too many requests exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the Amazon Cognito service returns a too many requests exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the Amazon Cognito service returns a too many requests exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the Amazon Cognito service can't find the requested resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The message returned when the Amazon Cognito service returns a resource not found exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the Amazon Cognito service returns a resource not found exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the Amazon Cognito service returns a resource not found exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a password reset is required.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PasswordResetRequiredException {
    /// <p>The message returned when a password reset is required.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PasswordResetRequiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PasswordResetRequiredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PasswordResetRequiredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PasswordResetRequiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PasswordResetRequiredException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for PasswordResetRequiredException {}
/// See [`PasswordResetRequiredException`](crate::error::PasswordResetRequiredException)
pub mod password_reset_required_exception {
    /// A builder for [`PasswordResetRequiredException`](crate::error::PasswordResetRequiredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when a password reset is required.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when a password reset is required.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PasswordResetRequiredException`](crate::error::PasswordResetRequiredException)
        pub fn build(self) -> crate::error::PasswordResetRequiredException {
            crate::error::PasswordResetRequiredException {
                message: self.message,
            }
        }
    }
}
impl PasswordResetRequiredException {
    /// Creates a new builder-style object to manufacture [`PasswordResetRequiredException`](crate::error::PasswordResetRequiredException)
    pub fn builder() -> crate::error::password_reset_required_exception::Builder {
        crate::error::password_reset_required_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a user isn't authorized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotAuthorizedException {
    /// <p>The message returned when the Amazon Cognito service returns a not authorized exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotAuthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotAuthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotAuthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotAuthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotAuthorizedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotAuthorizedException {}
/// See [`NotAuthorizedException`](crate::error::NotAuthorizedException)
pub mod not_authorized_exception {
    /// A builder for [`NotAuthorizedException`](crate::error::NotAuthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the Amazon Cognito service returns a not authorized exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the Amazon Cognito service returns a not authorized exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotAuthorizedException`](crate::error::NotAuthorizedException)
        pub fn build(self) -> crate::error::NotAuthorizedException {
            crate::error::NotAuthorizedException {
                message: self.message,
            }
        }
    }
}
impl NotAuthorizedException {
    /// Creates a new builder-style object to manufacture [`NotAuthorizedException`](crate::error::NotAuthorizedException)
    pub fn builder() -> crate::error::not_authorized_exception::Builder {
        crate::error::not_authorized_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>The message returned when Amazon Cognito throws a limit exceeded exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito throws a limit exceeded exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito throws a limit exceeded exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    /// <p>The message returned when the Amazon Cognito service throws an invalid parameter exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the Amazon Cognito service throws an invalid parameter exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the Amazon Cognito service throws an invalid parameter exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito encounters an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalErrorException {
    /// <p>The message returned when Amazon Cognito throws an internal error exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalErrorException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalErrorException {}
/// See [`InternalErrorException`](crate::error::InternalErrorException)
pub mod internal_error_exception {
    /// A builder for [`InternalErrorException`](crate::error::InternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito throws an internal error exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito throws an internal error exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalErrorException`](crate::error::InternalErrorException)
        pub fn build(self) -> crate::error::InternalErrorException {
            crate::error::InternalErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalErrorException {
    /// Creates a new builder-style object to manufacture [`InternalErrorException`](crate::error::InternalErrorException)
    pub fn builder() -> crate::error::internal_error_exception::Builder {
        crate::error::internal_error_exception::Builder::default()
    }
}

/// <p>This exception is thrown if a code has expired.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiredCodeException {
    /// <p>The message returned when the expired code exception is thrown.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExpiredCodeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiredCodeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExpiredCodeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExpiredCodeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExpiredCodeException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExpiredCodeException {}
/// See [`ExpiredCodeException`](crate::error::ExpiredCodeException)
pub mod expired_code_exception {
    /// A builder for [`ExpiredCodeException`](crate::error::ExpiredCodeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the expired code exception is thrown.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the expired code exception is thrown.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiredCodeException`](crate::error::ExpiredCodeException)
        pub fn build(self) -> crate::error::ExpiredCodeException {
            crate::error::ExpiredCodeException {
                message: self.message,
            }
        }
    }
}
impl ExpiredCodeException {
    /// Creates a new builder-style object to manufacture [`ExpiredCodeException`](crate::error::ExpiredCodeException)
    pub fn builder() -> crate::error::expired_code_exception::Builder {
        crate::error::expired_code_exception::Builder::default()
    }
}

/// <p>This exception is thrown if the provided code doesn't match what the server was expecting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeMismatchException {
    /// <p>The message provided when the code mismatch exception is thrown.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CodeMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CodeMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CodeMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CodeMismatchException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for CodeMismatchException {}
/// See [`CodeMismatchException`](crate::error::CodeMismatchException)
pub mod code_mismatch_exception {
    /// A builder for [`CodeMismatchException`](crate::error::CodeMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided when the code mismatch exception is thrown.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided when the code mismatch exception is thrown.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeMismatchException`](crate::error::CodeMismatchException)
        pub fn build(self) -> crate::error::CodeMismatchException {
            crate::error::CodeMismatchException {
                message: self.message,
            }
        }
    }
}
impl CodeMismatchException {
    /// Creates a new builder-style object to manufacture [`CodeMismatchException`](crate::error::CodeMismatchException)
    pub fn builder() -> crate::error::code_mismatch_exception::Builder {
        crate::error::code_mismatch_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the software token time-based one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SoftwareTokenMfaNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SoftwareTokenMfaNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SoftwareTokenMfaNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SoftwareTokenMfaNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SoftwareTokenMfaNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "SoftwareTokenMfaNotFoundException [SoftwareTokenMFANotFoundException]"
        )?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for SoftwareTokenMfaNotFoundException {}
/// See [`SoftwareTokenMfaNotFoundException`](crate::error::SoftwareTokenMfaNotFoundException)
pub mod software_token_mfa_not_found_exception {
    /// A builder for [`SoftwareTokenMfaNotFoundException`](crate::error::SoftwareTokenMfaNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SoftwareTokenMfaNotFoundException`](crate::error::SoftwareTokenMfaNotFoundException)
        pub fn build(self) -> crate::error::SoftwareTokenMfaNotFoundException {
            crate::error::SoftwareTokenMfaNotFoundException {
                message: self.message,
            }
        }
    }
}
impl SoftwareTokenMfaNotFoundException {
    /// Creates a new builder-style object to manufacture [`SoftwareTokenMfaNotFoundException`](crate::error::SoftwareTokenMfaNotFoundException)
    pub fn builder() -> crate::error::software_token_mfa_not_found_exception::Builder {
        crate::error::software_token_mfa_not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the user pool configuration is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidUserPoolConfigurationException {
    /// <p>The message returned when the user pool configuration is not valid.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidUserPoolConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidUserPoolConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidUserPoolConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidUserPoolConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidUserPoolConfigurationException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidUserPoolConfigurationException {}
/// See [`InvalidUserPoolConfigurationException`](crate::error::InvalidUserPoolConfigurationException)
pub mod invalid_user_pool_configuration_exception {
    /// A builder for [`InvalidUserPoolConfigurationException`](crate::error::InvalidUserPoolConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the user pool configuration is not valid.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the user pool configuration is not valid.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidUserPoolConfigurationException`](crate::error::InvalidUserPoolConfigurationException)
        pub fn build(self) -> crate::error::InvalidUserPoolConfigurationException {
            crate::error::InvalidUserPoolConfigurationException {
                message: self.message,
            }
        }
    }
}
impl InvalidUserPoolConfigurationException {
    /// Creates a new builder-style object to manufacture [`InvalidUserPoolConfigurationException`](crate::error::InvalidUserPoolConfigurationException)
    pub fn builder() -> crate::error::invalid_user_pool_configuration_exception::Builder {
        crate::error::invalid_user_pool_configuration_exception::Builder::default()
    }
}

/// <p>This exception is thrown when there is a code mismatch and the service fails to configure the software token TOTP multi-factor authentication (MFA).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSoftwareTokenMfaException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EnableSoftwareTokenMfaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSoftwareTokenMfaException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EnableSoftwareTokenMfaException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EnableSoftwareTokenMfaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "EnableSoftwareTokenMfaException [EnableSoftwareTokenMFAException]"
        )?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for EnableSoftwareTokenMfaException {}
/// See [`EnableSoftwareTokenMfaException`](crate::error::EnableSoftwareTokenMfaException)
pub mod enable_software_token_mfa_exception {
    /// A builder for [`EnableSoftwareTokenMfaException`](crate::error::EnableSoftwareTokenMfaException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableSoftwareTokenMfaException`](crate::error::EnableSoftwareTokenMfaException)
        pub fn build(self) -> crate::error::EnableSoftwareTokenMfaException {
            crate::error::EnableSoftwareTokenMfaException {
                message: self.message,
            }
        }
    }
}
impl EnableSoftwareTokenMfaException {
    /// Creates a new builder-style object to manufacture [`EnableSoftwareTokenMfaException`](crate::error::EnableSoftwareTokenMfaException)
    pub fn builder() -> crate::error::enable_software_token_mfa_exception::Builder {
        crate::error::enable_software_token_mfa_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified scope doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScopeDoesNotExistException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScopeDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScopeDoesNotExistException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScopeDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScopeDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScopeDoesNotExistException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScopeDoesNotExistException {}
/// See [`ScopeDoesNotExistException`](crate::error::ScopeDoesNotExistException)
pub mod scope_does_not_exist_exception {
    /// A builder for [`ScopeDoesNotExistException`](crate::error::ScopeDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScopeDoesNotExistException`](crate::error::ScopeDoesNotExistException)
        pub fn build(self) -> crate::error::ScopeDoesNotExistException {
            crate::error::ScopeDoesNotExistException {
                message: self.message,
            }
        }
    }
}
impl ScopeDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`ScopeDoesNotExistException`](crate::error::ScopeDoesNotExistException)
    pub fn builder() -> crate::error::scope_does_not_exist_exception::Builder {
        crate::error::scope_does_not_exist_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified OAuth flow is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOAuthFlowException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOAuthFlowException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOAuthFlowException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOAuthFlowException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOAuthFlowException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOAuthFlowException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOAuthFlowException {}
/// See [`InvalidOAuthFlowException`](crate::error::InvalidOAuthFlowException)
pub mod invalid_o_auth_flow_exception {
    /// A builder for [`InvalidOAuthFlowException`](crate::error::InvalidOAuthFlowException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOAuthFlowException`](crate::error::InvalidOAuthFlowException)
        pub fn build(self) -> crate::error::InvalidOAuthFlowException {
            crate::error::InvalidOAuthFlowException {
                message: self.message,
            }
        }
    }
}
impl InvalidOAuthFlowException {
    /// Creates a new builder-style object to manufacture [`InvalidOAuthFlowException`](crate::error::InvalidOAuthFlowException)
    pub fn builder() -> crate::error::invalid_o_auth_flow_exception::Builder {
        crate::error::invalid_o_auth_flow_exception::Builder::default()
    }
}

/// <p>This exception is thrown if two or more modifications are happening concurrently.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    /// <p>The message provided when the concurrent exception is thrown.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided when the concurrent exception is thrown.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided when the concurrent exception is thrown.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a user pool tag can't be set or updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolTaggingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserPoolTaggingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolTaggingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserPoolTaggingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserPoolTaggingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserPoolTaggingException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserPoolTaggingException {}
/// See [`UserPoolTaggingException`](crate::error::UserPoolTaggingException)
pub mod user_pool_tagging_exception {
    /// A builder for [`UserPoolTaggingException`](crate::error::UserPoolTaggingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolTaggingException`](crate::error::UserPoolTaggingException)
        pub fn build(self) -> crate::error::UserPoolTaggingException {
            crate::error::UserPoolTaggingException {
                message: self.message,
            }
        }
    }
}
impl UserPoolTaggingException {
    /// Creates a new builder-style object to manufacture [`UserPoolTaggingException`](crate::error::UserPoolTaggingException)
    pub fn builder() -> crate::error::user_pool_tagging_exception::Builder {
        crate::error::user_pool_tagging_exception::Builder::default()
    }
}

/// <p>This exception is thrown when you're trying to modify a user pool while a user import job is in progress for that pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserImportInProgressException {
    /// <p>The message returned when the user pool has an import job running.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserImportInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserImportInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserImportInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserImportInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserImportInProgressException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserImportInProgressException {}
/// See [`UserImportInProgressException`](crate::error::UserImportInProgressException)
pub mod user_import_in_progress_exception {
    /// A builder for [`UserImportInProgressException`](crate::error::UserImportInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the user pool has an import job running.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the user pool has an import job running.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserImportInProgressException`](crate::error::UserImportInProgressException)
        pub fn build(self) -> crate::error::UserImportInProgressException {
            crate::error::UserImportInProgressException {
                message: self.message,
            }
        }
    }
}
impl UserImportInProgressException {
    /// Creates a new builder-style object to manufacture [`UserImportInProgressException`](crate::error::UserImportInProgressException)
    pub fn builder() -> crate::error::user_import_in_progress_exception::Builder {
        crate::error::user_import_in_progress_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSmsRoleTrustRelationshipException {
    /// <p>The message returned when the role trust relationship for the SMS message is not valid.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSmsRoleTrustRelationshipException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSmsRoleTrustRelationshipException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSmsRoleTrustRelationshipException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSmsRoleTrustRelationshipException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSmsRoleTrustRelationshipException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSmsRoleTrustRelationshipException {}
/// See [`InvalidSmsRoleTrustRelationshipException`](crate::error::InvalidSmsRoleTrustRelationshipException)
pub mod invalid_sms_role_trust_relationship_exception {
    /// A builder for [`InvalidSmsRoleTrustRelationshipException`](crate::error::InvalidSmsRoleTrustRelationshipException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the role trust relationship for the SMS message is not valid.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the role trust relationship for the SMS message is not valid.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSmsRoleTrustRelationshipException`](crate::error::InvalidSmsRoleTrustRelationshipException)
        pub fn build(self) -> crate::error::InvalidSmsRoleTrustRelationshipException {
            crate::error::InvalidSmsRoleTrustRelationshipException {
                message: self.message,
            }
        }
    }
}
impl InvalidSmsRoleTrustRelationshipException {
    /// Creates a new builder-style object to manufacture [`InvalidSmsRoleTrustRelationshipException`](crate::error::InvalidSmsRoleTrustRelationshipException)
    pub fn builder() -> crate::error::invalid_sms_role_trust_relationship_exception::Builder {
        crate::error::invalid_sms_role_trust_relationship_exception::Builder::default()
    }
}

/// <p>This exception is returned when the role provided for SMS configuration doesn't have permission to publish using Amazon SNS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSmsRoleAccessPolicyException {
    /// <p>The message returned when the invalid SMS role access policy exception is thrown.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSmsRoleAccessPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSmsRoleAccessPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSmsRoleAccessPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSmsRoleAccessPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSmsRoleAccessPolicyException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSmsRoleAccessPolicyException {}
/// See [`InvalidSmsRoleAccessPolicyException`](crate::error::InvalidSmsRoleAccessPolicyException)
pub mod invalid_sms_role_access_policy_exception {
    /// A builder for [`InvalidSmsRoleAccessPolicyException`](crate::error::InvalidSmsRoleAccessPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the invalid SMS role access policy exception is thrown.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the invalid SMS role access policy exception is thrown.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSmsRoleAccessPolicyException`](crate::error::InvalidSmsRoleAccessPolicyException)
        pub fn build(self) -> crate::error::InvalidSmsRoleAccessPolicyException {
            crate::error::InvalidSmsRoleAccessPolicyException {
                message: self.message,
            }
        }
    }
}
impl InvalidSmsRoleAccessPolicyException {
    /// Creates a new builder-style object to manufacture [`InvalidSmsRoleAccessPolicyException`](crate::error::InvalidSmsRoleAccessPolicyException)
    pub fn builder() -> crate::error::invalid_sms_role_access_policy_exception::Builder {
        crate::error::invalid_sms_role_access_policy_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code: 400.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEmailRoleAccessPolicyException {
    /// <p>The message returned when you have an unverified email address or the identity policy isn't set on an email address that Amazon Cognito can access.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEmailRoleAccessPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEmailRoleAccessPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEmailRoleAccessPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEmailRoleAccessPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEmailRoleAccessPolicyException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEmailRoleAccessPolicyException {}
/// See [`InvalidEmailRoleAccessPolicyException`](crate::error::InvalidEmailRoleAccessPolicyException)
pub mod invalid_email_role_access_policy_exception {
    /// A builder for [`InvalidEmailRoleAccessPolicyException`](crate::error::InvalidEmailRoleAccessPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when you have an unverified email address or the identity policy isn't set on an email address that Amazon Cognito can access.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when you have an unverified email address or the identity policy isn't set on an email address that Amazon Cognito can access.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEmailRoleAccessPolicyException`](crate::error::InvalidEmailRoleAccessPolicyException)
        pub fn build(self) -> crate::error::InvalidEmailRoleAccessPolicyException {
            crate::error::InvalidEmailRoleAccessPolicyException {
                message: self.message,
            }
        }
    }
}
impl InvalidEmailRoleAccessPolicyException {
    /// Creates a new builder-style object to manufacture [`InvalidEmailRoleAccessPolicyException`](crate::error::InvalidEmailRoleAccessPolicyException)
    pub fn builder() -> crate::error::invalid_email_role_access_policy_exception::Builder {
        crate::error::invalid_email_role_access_policy_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserLambdaValidationException {
    /// <p>The message returned when the Amazon Cognito service returns a user validation exception with the Lambda service.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserLambdaValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserLambdaValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserLambdaValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserLambdaValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserLambdaValidationException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserLambdaValidationException {}
/// See [`UserLambdaValidationException`](crate::error::UserLambdaValidationException)
pub mod user_lambda_validation_exception {
    /// A builder for [`UserLambdaValidationException`](crate::error::UserLambdaValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the Amazon Cognito service returns a user validation exception with the Lambda service.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the Amazon Cognito service returns a user validation exception with the Lambda service.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserLambdaValidationException`](crate::error::UserLambdaValidationException)
        pub fn build(self) -> crate::error::UserLambdaValidationException {
            crate::error::UserLambdaValidationException {
                message: self.message,
            }
        }
    }
}
impl UserLambdaValidationException {
    /// Creates a new builder-style object to manufacture [`UserLambdaValidationException`](crate::error::UserLambdaValidationException)
    pub fn builder() -> crate::error::user_lambda_validation_exception::Builder {
        crate::error::user_lambda_validation_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnexpectedLambdaException {
    /// <p>The message returned when Amazon Cognito returns an unexpected Lambda exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnexpectedLambdaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnexpectedLambdaException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnexpectedLambdaException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnexpectedLambdaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnexpectedLambdaException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnexpectedLambdaException {}
/// See [`UnexpectedLambdaException`](crate::error::UnexpectedLambdaException)
pub mod unexpected_lambda_exception {
    /// A builder for [`UnexpectedLambdaException`](crate::error::UnexpectedLambdaException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito returns an unexpected Lambda exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito returns an unexpected Lambda exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnexpectedLambdaException`](crate::error::UnexpectedLambdaException)
        pub fn build(self) -> crate::error::UnexpectedLambdaException {
            crate::error::UnexpectedLambdaException {
                message: self.message,
            }
        }
    }
}
impl UnexpectedLambdaException {
    /// Creates a new builder-style object to manufacture [`UnexpectedLambdaException`](crate::error::UnexpectedLambdaException)
    pub fn builder() -> crate::error::unexpected_lambda_exception::Builder {
        crate::error::unexpected_lambda_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLambdaResponseException {
    /// <p>The message returned when Amazon Cognito hrows an invalid Lambda response exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLambdaResponseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLambdaResponseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLambdaResponseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLambdaResponseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLambdaResponseException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLambdaResponseException {}
/// See [`InvalidLambdaResponseException`](crate::error::InvalidLambdaResponseException)
pub mod invalid_lambda_response_exception {
    /// A builder for [`InvalidLambdaResponseException`](crate::error::InvalidLambdaResponseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito hrows an invalid Lambda response exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito hrows an invalid Lambda response exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLambdaResponseException`](crate::error::InvalidLambdaResponseException)
        pub fn build(self) -> crate::error::InvalidLambdaResponseException {
            crate::error::InvalidLambdaResponseException {
                message: self.message,
            }
        }
    }
}
impl InvalidLambdaResponseException {
    /// Creates a new builder-style object to manufacture [`InvalidLambdaResponseException`](crate::error::InvalidLambdaResponseException)
    pub fn builder() -> crate::error::invalid_lambda_response_exception::Builder {
        crate::error::invalid_lambda_response_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a verification code fails to deliver successfully.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeDeliveryFailureException {
    /// <p>The message sent when a verification code fails to deliver successfully.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CodeDeliveryFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeDeliveryFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CodeDeliveryFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CodeDeliveryFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CodeDeliveryFailureException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for CodeDeliveryFailureException {}
/// See [`CodeDeliveryFailureException`](crate::error::CodeDeliveryFailureException)
pub mod code_delivery_failure_exception {
    /// A builder for [`CodeDeliveryFailureException`](crate::error::CodeDeliveryFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message sent when a verification code fails to deliver successfully.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message sent when a verification code fails to deliver successfully.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeDeliveryFailureException`](crate::error::CodeDeliveryFailureException)
        pub fn build(self) -> crate::error::CodeDeliveryFailureException {
            crate::error::CodeDeliveryFailureException {
                message: self.message,
            }
        }
    }
}
impl CodeDeliveryFailureException {
    /// Creates a new builder-style object to manufacture [`CodeDeliveryFailureException`](crate::error::CodeDeliveryFailureException)
    pub fn builder() -> crate::error::code_delivery_failure_exception::Builder {
        crate::error::code_delivery_failure_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AliasExistsException {
    /// <p>The message sent to the user when an alias exists.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AliasExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AliasExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AliasExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AliasExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AliasExistsException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for AliasExistsException {}
/// See [`AliasExistsException`](crate::error::AliasExistsException)
pub mod alias_exists_exception {
    /// A builder for [`AliasExistsException`](crate::error::AliasExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message sent to the user when an alias exists.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message sent to the user when an alias exists.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AliasExistsException`](crate::error::AliasExistsException)
        pub fn build(self) -> crate::error::AliasExistsException {
            crate::error::AliasExistsException {
                message: self.message,
            }
        }
    }
}
impl AliasExistsException {
    /// Creates a new builder-style object to manufacture [`AliasExistsException`](crate::error::AliasExistsException)
    pub fn builder() -> crate::error::alias_exists_exception::Builder {
        crate::error::alias_exists_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified identifier isn't supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedIdentityProviderException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedIdentityProviderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedIdentityProviderException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedIdentityProviderException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedIdentityProviderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedIdentityProviderException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedIdentityProviderException {}
/// See [`UnsupportedIdentityProviderException`](crate::error::UnsupportedIdentityProviderException)
pub mod unsupported_identity_provider_exception {
    /// A builder for [`UnsupportedIdentityProviderException`](crate::error::UnsupportedIdentityProviderException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedIdentityProviderException`](crate::error::UnsupportedIdentityProviderException)
        pub fn build(self) -> crate::error::UnsupportedIdentityProviderException {
            crate::error::UnsupportedIdentityProviderException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedIdentityProviderException {
    /// Creates a new builder-style object to manufacture [`UnsupportedIdentityProviderException`](crate::error::UnsupportedIdentityProviderException)
    pub fn builder() -> crate::error::unsupported_identity_provider_exception::Builder {
        crate::error::unsupported_identity_provider_exception::Builder::default()
    }
}

/// <p>This exception is thrown when user pool add-ons aren't enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolAddOnNotEnabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserPoolAddOnNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolAddOnNotEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserPoolAddOnNotEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserPoolAddOnNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserPoolAddOnNotEnabledException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserPoolAddOnNotEnabledException {}
/// See [`UserPoolAddOnNotEnabledException`](crate::error::UserPoolAddOnNotEnabledException)
pub mod user_pool_add_on_not_enabled_exception {
    /// A builder for [`UserPoolAddOnNotEnabledException`](crate::error::UserPoolAddOnNotEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolAddOnNotEnabledException`](crate::error::UserPoolAddOnNotEnabledException)
        pub fn build(self) -> crate::error::UserPoolAddOnNotEnabledException {
            crate::error::UserPoolAddOnNotEnabledException {
                message: self.message,
            }
        }
    }
}
impl UserPoolAddOnNotEnabledException {
    /// Creates a new builder-style object to manufacture [`UserPoolAddOnNotEnabledException`](crate::error::UserPoolAddOnNotEnabledException)
    pub fn builder() -> crate::error::user_pool_add_on_not_enabled_exception::Builder {
        crate::error::user_pool_add_on_not_enabled_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a precondition is not met.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionNotMetException {
    /// <p>The message returned when a precondition is not met.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PreconditionNotMetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionNotMetException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreconditionNotMetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionNotMetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionNotMetException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionNotMetException {}
/// See [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
pub mod precondition_not_met_exception {
    /// A builder for [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when a precondition is not met.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when a precondition is not met.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
        pub fn build(self) -> crate::error::PreconditionNotMetException {
            crate::error::PreconditionNotMetException {
                message: self.message,
            }
        }
    }
}
impl PreconditionNotMetException {
    /// Creates a new builder-style object to manufacture [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
    pub fn builder() -> crate::error::precondition_not_met_exception::Builder {
        crate::error::precondition_not_met_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsernameExistsException {
    /// <p>The message returned when Amazon Cognito throws a user name exists exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UsernameExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsernameExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UsernameExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UsernameExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UsernameExistsException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for UsernameExistsException {}
/// See [`UsernameExistsException`](crate::error::UsernameExistsException)
pub mod username_exists_exception {
    /// A builder for [`UsernameExistsException`](crate::error::UsernameExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito throws a user name exists exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito throws a user name exists exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UsernameExistsException`](crate::error::UsernameExistsException)
        pub fn build(self) -> crate::error::UsernameExistsException {
            crate::error::UsernameExistsException {
                message: self.message,
            }
        }
    }
}
impl UsernameExistsException {
    /// Creates a new builder-style object to manufacture [`UsernameExistsException`](crate::error::UsernameExistsException)
    pub fn builder() -> crate::error::username_exists_exception::Builder {
        crate::error::username_exists_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPasswordException {
    /// <p>The message returned when Amazon Cognito throws an invalid user password exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPasswordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPasswordException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPasswordException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPasswordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPasswordException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPasswordException {}
/// See [`InvalidPasswordException`](crate::error::InvalidPasswordException)
pub mod invalid_password_exception {
    /// A builder for [`InvalidPasswordException`](crate::error::InvalidPasswordException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito throws an invalid user password exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito throws an invalid user password exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPasswordException`](crate::error::InvalidPasswordException)
        pub fn build(self) -> crate::error::InvalidPasswordException {
            crate::error::InvalidPasswordException {
                message: self.message,
            }
        }
    }
}
impl InvalidPasswordException {
    /// Creates a new builder-style object to manufacture [`InvalidPasswordException`](crate::error::InvalidPasswordException)
    pub fn builder() -> crate::error::invalid_password_exception::Builder {
        crate::error::invalid_password_exception::Builder::default()
    }
}

/// <p>Exception that is thrown when an unsupported token is passed to an operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedTokenTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedTokenTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedTokenTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedTokenTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedTokenTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedTokenTypeException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedTokenTypeException {}
/// See [`UnsupportedTokenTypeException`](crate::error::UnsupportedTokenTypeException)
pub mod unsupported_token_type_exception {
    /// A builder for [`UnsupportedTokenTypeException`](crate::error::UnsupportedTokenTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedTokenTypeException`](crate::error::UnsupportedTokenTypeException)
        pub fn build(self) -> crate::error::UnsupportedTokenTypeException {
            crate::error::UnsupportedTokenTypeException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedTokenTypeException {
    /// Creates a new builder-style object to manufacture [`UnsupportedTokenTypeException`](crate::error::UnsupportedTokenTypeException)
    pub fn builder() -> crate::error::unsupported_token_type_exception::Builder {
        crate::error::unsupported_token_type_exception::Builder::default()
    }
}

/// <p>Exception that is thrown when you attempt to perform an operation that isn't enabled for the user pool client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationException {}
/// See [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
pub mod unsupported_operation_exception {
    /// A builder for [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
        pub fn build(self) -> crate::error::UnsupportedOperationException {
            crate::error::UnsupportedOperationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    pub fn builder() -> crate::error::unsupported_operation_exception::Builder {
        crate::error::unsupported_operation_exception::Builder::default()
    }
}

/// <p>Exception that is thrown when the request isn't authorized. This can happen due to an invalid access token in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito can't find a multi-factor authentication (MFA) method.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MfaMethodNotFoundException {
    /// <p>The message returned when Amazon Cognito throws an MFA method not found exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MfaMethodNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MfaMethodNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MfaMethodNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MfaMethodNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MfaMethodNotFoundException [MFAMethodNotFoundException]")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for MfaMethodNotFoundException {}
/// See [`MfaMethodNotFoundException`](crate::error::MfaMethodNotFoundException)
pub mod mfa_method_not_found_exception {
    /// A builder for [`MfaMethodNotFoundException`](crate::error::MfaMethodNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito throws an MFA method not found exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito throws an MFA method not found exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MfaMethodNotFoundException`](crate::error::MfaMethodNotFoundException)
        pub fn build(self) -> crate::error::MfaMethodNotFoundException {
            crate::error::MfaMethodNotFoundException {
                message: self.message,
            }
        }
    }
}
impl MfaMethodNotFoundException {
    /// Creates a new builder-style object to manufacture [`MfaMethodNotFoundException`](crate::error::MfaMethodNotFoundException)
    pub fn builder() -> crate::error::mfa_method_not_found_exception::Builder {
        crate::error::mfa_method_not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the provider is already supported by the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateProviderException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateProviderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateProviderException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateProviderException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateProviderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateProviderException")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateProviderException {}
/// See [`DuplicateProviderException`](crate::error::DuplicateProviderException)
pub mod duplicate_provider_exception {
    /// A builder for [`DuplicateProviderException`](crate::error::DuplicateProviderException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateProviderException`](crate::error::DuplicateProviderException)
        pub fn build(self) -> crate::error::DuplicateProviderException {
            crate::error::DuplicateProviderException {
                message: self.message,
            }
        }
    }
}
impl DuplicateProviderException {
    /// Creates a new builder-style object to manufacture [`DuplicateProviderException`](crate::error::DuplicateProviderException)
    pub fn builder() -> crate::error::duplicate_provider_exception::Builder {
        crate::error::duplicate_provider_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GroupExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GroupExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GroupExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GroupExistsException")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for GroupExistsException {}
/// See [`GroupExistsException`](crate::error::GroupExistsException)
pub mod group_exists_exception {
    /// A builder for [`GroupExistsException`](crate::error::GroupExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupExistsException`](crate::error::GroupExistsException)
        pub fn build(self) -> crate::error::GroupExistsException {
            crate::error::GroupExistsException {
                message: self.message,
            }
        }
    }
}
impl GroupExistsException {
    /// Creates a new builder-style object to manufacture [`GroupExistsException`](crate::error::GroupExistsException)
    pub fn builder() -> crate::error::group_exists_exception::Builder {
        crate::error::group_exists_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the user has made too many failed attempts for a given action, such as sign-in.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFailedAttemptsException {
    /// <p>The message returned when Amazon Cognito returns a <code>TooManyFailedAttempts</code> exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFailedAttemptsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFailedAttemptsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFailedAttemptsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFailedAttemptsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFailedAttemptsException")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFailedAttemptsException {}
/// See [`TooManyFailedAttemptsException`](crate::error::TooManyFailedAttemptsException)
pub mod too_many_failed_attempts_exception {
    /// A builder for [`TooManyFailedAttemptsException`](crate::error::TooManyFailedAttemptsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when Amazon Cognito returns a <code>TooManyFailedAttempts</code> exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when Amazon Cognito returns a <code>TooManyFailedAttempts</code> exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFailedAttemptsException`](crate::error::TooManyFailedAttemptsException)
        pub fn build(self) -> crate::error::TooManyFailedAttemptsException {
            crate::error::TooManyFailedAttemptsException {
                message: self.message,
            }
        }
    }
}
impl TooManyFailedAttemptsException {
    /// Creates a new builder-style object to manufacture [`TooManyFailedAttemptsException`](crate::error::TooManyFailedAttemptsException)
    pub fn builder() -> crate::error::too_many_failed_attempts_exception::Builder {
        crate::error::too_many_failed_attempts_exception::Builder::default()
    }
}

/// <p>The request failed because the user is in an unsupported state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedUserStateException {
    /// <p>The message returned when the user is in an unsupported state.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedUserStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedUserStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedUserStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedUserStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedUserStateException")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedUserStateException {}
/// See [`UnsupportedUserStateException`](crate::error::UnsupportedUserStateException)
pub mod unsupported_user_state_exception {
    /// A builder for [`UnsupportedUserStateException`](crate::error::UnsupportedUserStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message returned when the user is in an unsupported state.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message returned when the user is in an unsupported state.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedUserStateException`](crate::error::UnsupportedUserStateException)
        pub fn build(self) -> crate::error::UnsupportedUserStateException {
            crate::error::UnsupportedUserStateException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedUserStateException {
    /// Creates a new builder-style object to manufacture [`UnsupportedUserStateException`](crate::error::UnsupportedUserStateException)
    pub fn builder() -> crate::error::unsupported_user_state_exception::Builder {
        crate::error::unsupported_user_state_exception::Builder::default()
    }
}
