// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Cognito Identity
///
/// Client for invoking operations on Amazon Cognito Identity. Each operation on Amazon Cognito Identity is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cognitoidentity::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_cognitoidentity::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_cognitoidentity::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateIdentityPool`](crate::client::fluent_builders::CreateIdentityPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_name(impl Into<String>)`](crate::client::fluent_builders::CreateIdentityPool::identity_pool_name) / [`set_identity_pool_name(Option<String>)`](crate::client::fluent_builders::CreateIdentityPool::set_identity_pool_name): <p>A string that you provide.</p>
    ///   - [`allow_unauthenticated_identities(bool)`](crate::client::fluent_builders::CreateIdentityPool::allow_unauthenticated_identities) / [`set_allow_unauthenticated_identities(bool)`](crate::client::fluent_builders::CreateIdentityPool::set_allow_unauthenticated_identities): <p>TRUE if the identity pool supports unauthenticated logins.</p>
    ///   - [`allow_classic_flow(bool)`](crate::client::fluent_builders::CreateIdentityPool::allow_classic_flow) / [`set_allow_classic_flow(Option<bool>)`](crate::client::fluent_builders::CreateIdentityPool::set_allow_classic_flow): <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    ///   - [`supported_login_providers(HashMap<String, String>)`](crate::client::fluent_builders::CreateIdentityPool::supported_login_providers) / [`set_supported_login_providers(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIdentityPool::set_supported_login_providers): <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    ///   - [`developer_provider_name(impl Into<String>)`](crate::client::fluent_builders::CreateIdentityPool::developer_provider_name) / [`set_developer_provider_name(Option<String>)`](crate::client::fluent_builders::CreateIdentityPool::set_developer_provider_name): <p>The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (<code>.</code>), underscore (<code>_</code>), and dash (<code>-</code>).</p>  <p>Once you have set a developer provider name, you cannot change it. Please take care in setting this parameter.</p>
    ///   - [`open_id_connect_provider_ar_ns(Vec<String>)`](crate::client::fluent_builders::CreateIdentityPool::open_id_connect_provider_ar_ns) / [`set_open_id_connect_provider_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateIdentityPool::set_open_id_connect_provider_ar_ns): <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
    ///   - [`cognito_identity_providers(Vec<CognitoIdentityProvider>)`](crate::client::fluent_builders::CreateIdentityPool::cognito_identity_providers) / [`set_cognito_identity_providers(Option<Vec<CognitoIdentityProvider>>)`](crate::client::fluent_builders::CreateIdentityPool::set_cognito_identity_providers): <p>An array of Amazon Cognito user pools and their client IDs.</p>
    ///   - [`saml_provider_ar_ns(Vec<String>)`](crate::client::fluent_builders::CreateIdentityPool::saml_provider_ar_ns) / [`set_saml_provider_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateIdentityPool::set_saml_provider_ar_ns): <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
    ///   - [`identity_pool_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateIdentityPool::identity_pool_tags) / [`set_identity_pool_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIdentityPool::set_identity_pool_tags): <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// - On success, responds with [`CreateIdentityPoolOutput`](crate::output::CreateIdentityPoolOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::CreateIdentityPoolOutput::identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`identity_pool_name(Option<String>)`](crate::output::CreateIdentityPoolOutput::identity_pool_name): <p>A string that you provide.</p>
    ///   - [`allow_unauthenticated_identities(bool)`](crate::output::CreateIdentityPoolOutput::allow_unauthenticated_identities): <p>TRUE if the identity pool supports unauthenticated logins.</p>
    ///   - [`allow_classic_flow(Option<bool>)`](crate::output::CreateIdentityPoolOutput::allow_classic_flow): <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    ///   - [`supported_login_providers(Option<HashMap<String, String>>)`](crate::output::CreateIdentityPoolOutput::supported_login_providers): <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    ///   - [`developer_provider_name(Option<String>)`](crate::output::CreateIdentityPoolOutput::developer_provider_name): <p>The "domain" by which Cognito will refer to your users.</p>
    ///   - [`open_id_connect_provider_ar_ns(Option<Vec<String>>)`](crate::output::CreateIdentityPoolOutput::open_id_connect_provider_ar_ns): <p>The ARNs of the OpenID Connect providers.</p>
    ///   - [`cognito_identity_providers(Option<Vec<CognitoIdentityProvider>>)`](crate::output::CreateIdentityPoolOutput::cognito_identity_providers): <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    ///   - [`saml_provider_ar_ns(Option<Vec<String>>)`](crate::output::CreateIdentityPoolOutput::saml_provider_ar_ns): <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
    ///   - [`identity_pool_tags(Option<HashMap<String, String>>)`](crate::output::CreateIdentityPoolOutput::identity_pool_tags): <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// - On failure, responds with [`SdkError<CreateIdentityPoolError>`](crate::error::CreateIdentityPoolError)
    pub fn create_identity_pool(&self) -> fluent_builders::CreateIdentityPool {
        fluent_builders::CreateIdentityPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIdentities`](crate::client::fluent_builders::DeleteIdentities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_ids_to_delete(Vec<String>)`](crate::client::fluent_builders::DeleteIdentities::identity_ids_to_delete) / [`set_identity_ids_to_delete(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteIdentities::set_identity_ids_to_delete): <p>A list of 1-60 identities that you want to delete.</p>
    /// - On success, responds with [`DeleteIdentitiesOutput`](crate::output::DeleteIdentitiesOutput) with field(s):
    ///   - [`unprocessed_identity_ids(Option<Vec<UnprocessedIdentityId>>)`](crate::output::DeleteIdentitiesOutput::unprocessed_identity_ids): <p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.</p>
    /// - On failure, responds with [`SdkError<DeleteIdentitiesError>`](crate::error::DeleteIdentitiesError)
    pub fn delete_identities(&self) -> fluent_builders::DeleteIdentities {
        fluent_builders::DeleteIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIdentityPool`](crate::client::fluent_builders::DeleteIdentityPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIdentityPool::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteIdentityPool::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    /// - On success, responds with [`DeleteIdentityPoolOutput`](crate::output::DeleteIdentityPoolOutput)

    /// - On failure, responds with [`SdkError<DeleteIdentityPoolError>`](crate::error::DeleteIdentityPoolError)
    pub fn delete_identity_pool(&self) -> fluent_builders::DeleteIdentityPool {
        fluent_builders::DeleteIdentityPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentity`](crate::client::fluent_builders::DescribeIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentity::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::DescribeIdentity::set_identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    /// - On success, responds with [`DescribeIdentityOutput`](crate::output::DescribeIdentityOutput) with field(s):
    ///   - [`identity_id(Option<String>)`](crate::output::DescribeIdentityOutput::identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`logins(Option<Vec<String>>)`](crate::output::DescribeIdentityOutput::logins): <p>The provider names.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeIdentityOutput::creation_date): <p>Date on which the identity was created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeIdentityOutput::last_modified_date): <p>Date on which the identity was last modified.</p>
    /// - On failure, responds with [`SdkError<DescribeIdentityError>`](crate::error::DescribeIdentityError)
    pub fn describe_identity(&self) -> fluent_builders::DescribeIdentity {
        fluent_builders::DescribeIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentityPool`](crate::client::fluent_builders::DescribeIdentityPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityPool::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeIdentityPool::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    /// - On success, responds with [`DescribeIdentityPoolOutput`](crate::output::DescribeIdentityPoolOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::DescribeIdentityPoolOutput::identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`identity_pool_name(Option<String>)`](crate::output::DescribeIdentityPoolOutput::identity_pool_name): <p>A string that you provide.</p>
    ///   - [`allow_unauthenticated_identities(bool)`](crate::output::DescribeIdentityPoolOutput::allow_unauthenticated_identities): <p>TRUE if the identity pool supports unauthenticated logins.</p>
    ///   - [`allow_classic_flow(Option<bool>)`](crate::output::DescribeIdentityPoolOutput::allow_classic_flow): <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    ///   - [`supported_login_providers(Option<HashMap<String, String>>)`](crate::output::DescribeIdentityPoolOutput::supported_login_providers): <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    ///   - [`developer_provider_name(Option<String>)`](crate::output::DescribeIdentityPoolOutput::developer_provider_name): <p>The "domain" by which Cognito will refer to your users.</p>
    ///   - [`open_id_connect_provider_ar_ns(Option<Vec<String>>)`](crate::output::DescribeIdentityPoolOutput::open_id_connect_provider_ar_ns): <p>The ARNs of the OpenID Connect providers.</p>
    ///   - [`cognito_identity_providers(Option<Vec<CognitoIdentityProvider>>)`](crate::output::DescribeIdentityPoolOutput::cognito_identity_providers): <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    ///   - [`saml_provider_ar_ns(Option<Vec<String>>)`](crate::output::DescribeIdentityPoolOutput::saml_provider_ar_ns): <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
    ///   - [`identity_pool_tags(Option<HashMap<String, String>>)`](crate::output::DescribeIdentityPoolOutput::identity_pool_tags): <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// - On failure, responds with [`SdkError<DescribeIdentityPoolError>`](crate::error::DescribeIdentityPoolError)
    pub fn describe_identity_pool(&self) -> fluent_builders::DescribeIdentityPool {
        fluent_builders::DescribeIdentityPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCredentialsForIdentity`](crate::client::fluent_builders::GetCredentialsForIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::GetCredentialsForIdentity::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::GetCredentialsForIdentity::set_identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`logins(HashMap<String, String>)`](crate::client::fluent_builders::GetCredentialsForIdentity::logins) / [`set_logins(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetCredentialsForIdentity::set_logins): <p>A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will follow the syntax "provider_name": "provider_user_identifier".</p>  <p>Logins should not be specified when trying to get credentials for an unauthenticated identity.</p>  <p>The Logins parameter is required when using identities associated with external identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer Guide.</p>
    ///   - [`custom_role_arn(impl Into<String>)`](crate::client::fluent_builders::GetCredentialsForIdentity::custom_role_arn) / [`set_custom_role_arn(Option<String>)`](crate::client::fluent_builders::GetCredentialsForIdentity::set_custom_role_arn): <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers that do not support role customization.</p>
    /// - On success, responds with [`GetCredentialsForIdentityOutput`](crate::output::GetCredentialsForIdentityOutput) with field(s):
    ///   - [`identity_id(Option<String>)`](crate::output::GetCredentialsForIdentityOutput::identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`credentials(Option<Credentials>)`](crate::output::GetCredentialsForIdentityOutput::credentials): <p>Credentials for the provided identity ID.</p>
    /// - On failure, responds with [`SdkError<GetCredentialsForIdentityError>`](crate::error::GetCredentialsForIdentityError)
    pub fn get_credentials_for_identity(&self) -> fluent_builders::GetCredentialsForIdentity {
        fluent_builders::GetCredentialsForIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetId`](crate::client::fluent_builders::GetId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetId::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetId::set_account_id): <p>A standard AWS account ID (9+ digits).</p>
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetId::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetId::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`logins(HashMap<String, String>)`](crate::client::fluent_builders::GetId::logins) / [`set_logins(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetId::set_logins): <p>A set of optional name-value pairs that map provider names to provider tokens. The available provider names for <code>Logins</code> are as follows:</p>  <ul>   <li> <p>Facebook: <code>graph.facebook.com</code> </p> </li>   <li> <p>Amazon Cognito user pool: <code>cognito-idp.     <region>      .amazonaws.com/      <your_user_pool_id></your_user_pool_id>     </region></code>, for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>. </p> </li>   <li> <p>Google: <code>accounts.google.com</code> </p> </li>   <li> <p>Amazon: <code>www.amazon.com</code> </p> </li>   <li> <p>Twitter: <code>api.twitter.com</code> </p> </li>   <li> <p>Digits: <code>www.digits.com</code> </p> </li>  </ul>
    /// - On success, responds with [`GetIdOutput`](crate::output::GetIdOutput) with field(s):
    ///   - [`identity_id(Option<String>)`](crate::output::GetIdOutput::identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    /// - On failure, responds with [`SdkError<GetIdError>`](crate::error::GetIdError)
    pub fn get_id(&self) -> fluent_builders::GetId {
        fluent_builders::GetId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityPoolRoles`](crate::client::fluent_builders::GetIdentityPoolRoles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetIdentityPoolRoles::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetIdentityPoolRoles::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    /// - On success, responds with [`GetIdentityPoolRolesOutput`](crate::output::GetIdentityPoolRolesOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::GetIdentityPoolRolesOutput::identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`roles(Option<HashMap<String, String>>)`](crate::output::GetIdentityPoolRolesOutput::roles): <p>The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are supported.</p>
    ///   - [`role_mappings(Option<HashMap<String, RoleMapping>>)`](crate::output::GetIdentityPoolRolesOutput::role_mappings): <p>How users for a specific identity provider are to mapped to roles. This is a String-to-<code>RoleMapping</code> object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
    /// - On failure, responds with [`SdkError<GetIdentityPoolRolesError>`](crate::error::GetIdentityPoolRolesError)
    pub fn get_identity_pool_roles(&self) -> fluent_builders::GetIdentityPoolRoles {
        fluent_builders::GetIdentityPoolRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOpenIdToken`](crate::client::fluent_builders::GetOpenIdToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::GetOpenIdToken::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::GetOpenIdToken::set_identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`logins(HashMap<String, String>)`](crate::client::fluent_builders::GetOpenIdToken::logins) / [`set_logins(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetOpenIdToken::set_logins): <p>A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any other OpenID Connect provider, always include the <code>id_token</code>.</p>
    /// - On success, responds with [`GetOpenIdTokenOutput`](crate::output::GetOpenIdTokenOutput) with field(s):
    ///   - [`identity_id(Option<String>)`](crate::output::GetOpenIdTokenOutput::identity_id): <p>A unique identifier in the format REGION:GUID. Note that the IdentityId returned may not match the one passed on input.</p>
    ///   - [`token(Option<String>)`](crate::output::GetOpenIdTokenOutput::token): <p>An OpenID token, valid for 10 minutes.</p>
    /// - On failure, responds with [`SdkError<GetOpenIdTokenError>`](crate::error::GetOpenIdTokenError)
    pub fn get_open_id_token(&self) -> fluent_builders::GetOpenIdToken {
        fluent_builders::GetOpenIdToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOpenIdTokenForDeveloperIdentity`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::set_identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`logins(HashMap<String, String>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::logins) / [`set_logins(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::set_logins): <p>A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a user from a public provider or developer provider. If the user is from a developer provider, the name-value pair will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the identity pool. The developer user identifier is an identifier from your backend that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.</p>
    ///   - [`principal_tags(HashMap<String, String>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::principal_tags) / [`set_principal_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::set_principal_tags): <p>Use this operation to configure attribute mappings for custom providers. </p>
    ///   - [`token_duration(i64)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::token_duration) / [`set_token_duration(Option<i64>)`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity::set_token_duration): <p>The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are significant security implications: an attacker could use a leaked token to access your AWS resources for the token's duration.</p> <note>   <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>  </note>
    /// - On success, responds with [`GetOpenIdTokenForDeveloperIdentityOutput`](crate::output::GetOpenIdTokenForDeveloperIdentityOutput) with field(s):
    ///   - [`identity_id(Option<String>)`](crate::output::GetOpenIdTokenForDeveloperIdentityOutput::identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`token(Option<String>)`](crate::output::GetOpenIdTokenForDeveloperIdentityOutput::token): <p>An OpenID token.</p>
    /// - On failure, responds with [`SdkError<GetOpenIdTokenForDeveloperIdentityError>`](crate::error::GetOpenIdTokenForDeveloperIdentityError)
    pub fn get_open_id_token_for_developer_identity(
        &self,
    ) -> fluent_builders::GetOpenIdTokenForDeveloperIdentity {
        fluent_builders::GetOpenIdTokenForDeveloperIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPrincipalTagAttributeMap`](crate::client::fluent_builders::GetPrincipalTagAttributeMap) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetPrincipalTagAttributeMap::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetPrincipalTagAttributeMap::set_identity_pool_id): <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
    ///   - [`identity_provider_name(impl Into<String>)`](crate::client::fluent_builders::GetPrincipalTagAttributeMap::identity_provider_name) / [`set_identity_provider_name(Option<String>)`](crate::client::fluent_builders::GetPrincipalTagAttributeMap::set_identity_provider_name): <p>You can use this operation to get the provider name.</p>
    /// - On success, responds with [`GetPrincipalTagAttributeMapOutput`](crate::output::GetPrincipalTagAttributeMapOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::GetPrincipalTagAttributeMapOutput::identity_pool_id): <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
    ///   - [`identity_provider_name(Option<String>)`](crate::output::GetPrincipalTagAttributeMapOutput::identity_provider_name): <p>You can use this operation to get the provider name.</p>
    ///   - [`use_defaults(Option<bool>)`](crate::output::GetPrincipalTagAttributeMapOutput::use_defaults): <p>You can use this operation to list </p>
    ///   - [`principal_tags(Option<HashMap<String, String>>)`](crate::output::GetPrincipalTagAttributeMapOutput::principal_tags): <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
    /// - On failure, responds with [`SdkError<GetPrincipalTagAttributeMapError>`](crate::error::GetPrincipalTagAttributeMapError)
    pub fn get_principal_tag_attribute_map(&self) -> fluent_builders::GetPrincipalTagAttributeMap {
        fluent_builders::GetPrincipalTagAttributeMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentities`](crate::client::fluent_builders::ListIdentities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListIdentities::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::ListIdentities::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIdentities::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListIdentities::set_max_results): <p>The maximum number of identities to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentities::set_next_token): <p>A pagination token.</p>
    ///   - [`hide_disabled(bool)`](crate::client::fluent_builders::ListIdentities::hide_disabled) / [`set_hide_disabled(bool)`](crate::client::fluent_builders::ListIdentities::set_hide_disabled): <p>An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API will include disabled identities in the response.</p>
    /// - On success, responds with [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::ListIdentitiesOutput::identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`identities(Option<Vec<IdentityDescription>>)`](crate::output::ListIdentitiesOutput::identities): <p>An object containing a set of identities and associated mappings.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentitiesOutput::next_token): <p>A pagination token.</p>
    /// - On failure, responds with [`SdkError<ListIdentitiesError>`](crate::error::ListIdentitiesError)
    pub fn list_identities(&self) -> fluent_builders::ListIdentities {
        fluent_builders::ListIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentityPools`](crate::client::fluent_builders::ListIdentityPools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIdentityPools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIdentityPools::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListIdentityPools::set_max_results): <p>The maximum number of identities to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentityPools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentityPools::set_next_token): <p>A pagination token.</p>
    /// - On success, responds with [`ListIdentityPoolsOutput`](crate::output::ListIdentityPoolsOutput) with field(s):
    ///   - [`identity_pools(Option<Vec<IdentityPoolShortDescription>>)`](crate::output::ListIdentityPoolsOutput::identity_pools): <p>The identity pools returned by the ListIdentityPools action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentityPoolsOutput::next_token): <p>A pagination token.</p>
    /// - On failure, responds with [`SdkError<ListIdentityPoolsError>`](crate::error::ListIdentityPoolsError)
    pub fn list_identity_pools(&self) -> fluent_builders::ListIdentityPools {
        fluent_builders::ListIdentityPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned to.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are assigned to the identity pool.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`LookupDeveloperIdentity`](crate::client::fluent_builders::LookupDeveloperIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::set_identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`developer_user_identifier(impl Into<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::developer_user_identifier) / [`set_developer_user_identifier(Option<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::set_developer_user_identifier): <p>A unique ID used by your backend authentication process to identify a user. Typically, a developer identity provider would issue many developer user identifiers, in keeping with the number of users.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::LookupDeveloperIdentity::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::LookupDeveloperIdentity::set_max_results): <p>The maximum number of identities to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::LookupDeveloperIdentity::set_next_token): <p>A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service will return <code>NextToken</code> values as needed. For example, let's say you make a request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.</p>
    /// - On success, responds with [`LookupDeveloperIdentityOutput`](crate::output::LookupDeveloperIdentityOutput) with field(s):
    ///   - [`identity_id(Option<String>)`](crate::output::LookupDeveloperIdentityOutput::identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`developer_user_identifier_list(Option<Vec<String>>)`](crate::output::LookupDeveloperIdentityOutput::developer_user_identifier_list): <p>This is the list of developer user identifiers associated with an identity ID. Cognito supports the association of multiple developer user identifiers with an identity ID.</p>
    ///   - [`next_token(Option<String>)`](crate::output::LookupDeveloperIdentityOutput::next_token): <p>A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service will return <code>NextToken</code> values as needed. For example, let's say you make a request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.</p>
    /// - On failure, responds with [`SdkError<LookupDeveloperIdentityError>`](crate::error::LookupDeveloperIdentityError)
    pub fn lookup_developer_identity(&self) -> fluent_builders::LookupDeveloperIdentity {
        fluent_builders::LookupDeveloperIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergeDeveloperIdentities`](crate::client::fluent_builders::MergeDeveloperIdentities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_user_identifier(impl Into<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::source_user_identifier) / [`set_source_user_identifier(Option<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::set_source_user_identifier): <p>User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.</p>
    ///   - [`destination_user_identifier(impl Into<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::destination_user_identifier) / [`set_destination_user_identifier(Option<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::set_destination_user_identifier): <p>User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.</p>
    ///   - [`developer_provider_name(impl Into<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::developer_provider_name) / [`set_developer_provider_name(Option<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::set_developer_provider_name): <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (.), underscore (_), and dash (-).</p>
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::MergeDeveloperIdentities::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    /// - On success, responds with [`MergeDeveloperIdentitiesOutput`](crate::output::MergeDeveloperIdentitiesOutput) with field(s):
    ///   - [`identity_id(Option<String>)`](crate::output::MergeDeveloperIdentitiesOutput::identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    /// - On failure, responds with [`SdkError<MergeDeveloperIdentitiesError>`](crate::error::MergeDeveloperIdentitiesError)
    pub fn merge_developer_identities(&self) -> fluent_builders::MergeDeveloperIdentities {
        fluent_builders::MergeDeveloperIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIdentityPoolRoles`](crate::client::fluent_builders::SetIdentityPoolRoles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::SetIdentityPoolRoles::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::SetIdentityPoolRoles::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`roles(HashMap<String, String>)`](crate::client::fluent_builders::SetIdentityPoolRoles::roles) / [`set_roles(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SetIdentityPoolRoles::set_roles): <p>The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
    ///   - [`role_mappings(HashMap<String, RoleMapping>)`](crate::client::fluent_builders::SetIdentityPoolRoles::role_mappings) / [`set_role_mappings(Option<HashMap<String, RoleMapping>>)`](crate::client::fluent_builders::SetIdentityPoolRoles::set_role_mappings): <p>How users for a specific identity provider are to mapped to roles. This is a string to <code>RoleMapping</code> object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>  <p>Up to 25 rules can be specified per identity provider.</p>
    /// - On success, responds with [`SetIdentityPoolRolesOutput`](crate::output::SetIdentityPoolRolesOutput)

    /// - On failure, responds with [`SdkError<SetIdentityPoolRolesError>`](crate::error::SetIdentityPoolRolesError)
    pub fn set_identity_pool_roles(&self) -> fluent_builders::SetIdentityPoolRoles {
        fluent_builders::SetIdentityPoolRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetPrincipalTagAttributeMap`](crate::client::fluent_builders::SetPrincipalTagAttributeMap) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::set_identity_pool_id): <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
    ///   - [`identity_provider_name(impl Into<String>)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::identity_provider_name) / [`set_identity_provider_name(Option<String>)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::set_identity_provider_name): <p>The provider name you want to use for attribute mappings.</p>
    ///   - [`use_defaults(bool)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::use_defaults) / [`set_use_defaults(Option<bool>)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::set_use_defaults): <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
    ///   - [`principal_tags(HashMap<String, String>)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::principal_tags) / [`set_principal_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SetPrincipalTagAttributeMap::set_principal_tags): <p>You can use this operation to add principal tags.</p>
    /// - On success, responds with [`SetPrincipalTagAttributeMapOutput`](crate::output::SetPrincipalTagAttributeMapOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::SetPrincipalTagAttributeMapOutput::identity_pool_id): <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
    ///   - [`identity_provider_name(Option<String>)`](crate::output::SetPrincipalTagAttributeMapOutput::identity_provider_name): <p>The provider name you want to use for attribute mappings.</p>
    ///   - [`use_defaults(Option<bool>)`](crate::output::SetPrincipalTagAttributeMapOutput::use_defaults): <p>You can use this operation to select default (username and clientID) attribute mappings.</p>
    ///   - [`principal_tags(Option<HashMap<String, String>>)`](crate::output::SetPrincipalTagAttributeMapOutput::principal_tags): <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
    /// - On failure, responds with [`SdkError<SetPrincipalTagAttributeMapError>`](crate::error::SetPrincipalTagAttributeMapError)
    pub fn set_principal_tag_attribute_map(&self) -> fluent_builders::SetPrincipalTagAttributeMap {
        fluent_builders::SetPrincipalTagAttributeMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the identity pool.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to assign to the identity pool.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnlinkDeveloperIdentity`](crate::client::fluent_builders::UnlinkDeveloperIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::set_identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`developer_provider_name(impl Into<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::developer_provider_name) / [`set_developer_provider_name(Option<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::set_developer_provider_name): <p>The "domain" by which Cognito will refer to your users.</p>
    ///   - [`developer_user_identifier(impl Into<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::developer_user_identifier) / [`set_developer_user_identifier(Option<String>)`](crate::client::fluent_builders::UnlinkDeveloperIdentity::set_developer_user_identifier): <p>A unique ID used by your backend authentication process to identify a user.</p>
    /// - On success, responds with [`UnlinkDeveloperIdentityOutput`](crate::output::UnlinkDeveloperIdentityOutput)

    /// - On failure, responds with [`SdkError<UnlinkDeveloperIdentityError>`](crate::error::UnlinkDeveloperIdentityError)
    pub fn unlink_developer_identity(&self) -> fluent_builders::UnlinkDeveloperIdentity {
        fluent_builders::UnlinkDeveloperIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnlinkIdentity`](crate::client::fluent_builders::UnlinkIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::UnlinkIdentity::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::UnlinkIdentity::set_identity_id): <p>A unique identifier in the format REGION:GUID.</p>
    ///   - [`logins(HashMap<String, String>)`](crate::client::fluent_builders::UnlinkIdentity::logins) / [`set_logins(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UnlinkIdentity::set_logins): <p>A set of optional name-value pairs that map provider names to provider tokens.</p>
    ///   - [`logins_to_remove(Vec<String>)`](crate::client::fluent_builders::UnlinkIdentity::logins_to_remove) / [`set_logins_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::UnlinkIdentity::set_logins_to_remove): <p>Provider names to unlink from this identity.</p>
    /// - On success, responds with [`UnlinkIdentityOutput`](crate::output::UnlinkIdentityOutput)

    /// - On failure, responds with [`SdkError<UnlinkIdentityError>`](crate::error::UnlinkIdentityError)
    pub fn unlink_identity(&self) -> fluent_builders::UnlinkIdentity {
        fluent_builders::UnlinkIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the identity pool.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to remove from the user pool.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIdentityPool`](crate::client::fluent_builders::UpdateIdentityPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityPool::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateIdentityPool::set_identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`identity_pool_name(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityPool::identity_pool_name) / [`set_identity_pool_name(Option<String>)`](crate::client::fluent_builders::UpdateIdentityPool::set_identity_pool_name): <p>A string that you provide.</p>
    ///   - [`allow_unauthenticated_identities(bool)`](crate::client::fluent_builders::UpdateIdentityPool::allow_unauthenticated_identities) / [`set_allow_unauthenticated_identities(bool)`](crate::client::fluent_builders::UpdateIdentityPool::set_allow_unauthenticated_identities): <p>TRUE if the identity pool supports unauthenticated logins.</p>
    ///   - [`allow_classic_flow(bool)`](crate::client::fluent_builders::UpdateIdentityPool::allow_classic_flow) / [`set_allow_classic_flow(Option<bool>)`](crate::client::fluent_builders::UpdateIdentityPool::set_allow_classic_flow): <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    ///   - [`supported_login_providers(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIdentityPool::supported_login_providers) / [`set_supported_login_providers(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIdentityPool::set_supported_login_providers): <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    ///   - [`developer_provider_name(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityPool::developer_provider_name) / [`set_developer_provider_name(Option<String>)`](crate::client::fluent_builders::UpdateIdentityPool::set_developer_provider_name): <p>The "domain" by which Cognito will refer to your users.</p>
    ///   - [`open_id_connect_provider_ar_ns(Vec<String>)`](crate::client::fluent_builders::UpdateIdentityPool::open_id_connect_provider_ar_ns) / [`set_open_id_connect_provider_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateIdentityPool::set_open_id_connect_provider_ar_ns): <p>The ARNs of the OpenID Connect providers.</p>
    ///   - [`cognito_identity_providers(Vec<CognitoIdentityProvider>)`](crate::client::fluent_builders::UpdateIdentityPool::cognito_identity_providers) / [`set_cognito_identity_providers(Option<Vec<CognitoIdentityProvider>>)`](crate::client::fluent_builders::UpdateIdentityPool::set_cognito_identity_providers): <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    ///   - [`saml_provider_ar_ns(Vec<String>)`](crate::client::fluent_builders::UpdateIdentityPool::saml_provider_ar_ns) / [`set_saml_provider_ar_ns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateIdentityPool::set_saml_provider_ar_ns): <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
    ///   - [`identity_pool_tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIdentityPool::identity_pool_tags) / [`set_identity_pool_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIdentityPool::set_identity_pool_tags): <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// - On success, responds with [`UpdateIdentityPoolOutput`](crate::output::UpdateIdentityPoolOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::UpdateIdentityPoolOutput::identity_pool_id): <p>An identity pool ID in the format REGION:GUID.</p>
    ///   - [`identity_pool_name(Option<String>)`](crate::output::UpdateIdentityPoolOutput::identity_pool_name): <p>A string that you provide.</p>
    ///   - [`allow_unauthenticated_identities(bool)`](crate::output::UpdateIdentityPoolOutput::allow_unauthenticated_identities): <p>TRUE if the identity pool supports unauthenticated logins.</p>
    ///   - [`allow_classic_flow(Option<bool>)`](crate::output::UpdateIdentityPoolOutput::allow_classic_flow): <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    ///   - [`supported_login_providers(Option<HashMap<String, String>>)`](crate::output::UpdateIdentityPoolOutput::supported_login_providers): <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    ///   - [`developer_provider_name(Option<String>)`](crate::output::UpdateIdentityPoolOutput::developer_provider_name): <p>The "domain" by which Cognito will refer to your users.</p>
    ///   - [`open_id_connect_provider_ar_ns(Option<Vec<String>>)`](crate::output::UpdateIdentityPoolOutput::open_id_connect_provider_ar_ns): <p>The ARNs of the OpenID Connect providers.</p>
    ///   - [`cognito_identity_providers(Option<Vec<CognitoIdentityProvider>>)`](crate::output::UpdateIdentityPoolOutput::cognito_identity_providers): <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    ///   - [`saml_provider_ar_ns(Option<Vec<String>>)`](crate::output::UpdateIdentityPoolOutput::saml_provider_ar_ns): <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
    ///   - [`identity_pool_tags(Option<HashMap<String, String>>)`](crate::output::UpdateIdentityPoolOutput::identity_pool_tags): <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// - On failure, responds with [`SdkError<UpdateIdentityPoolError>`](crate::error::UpdateIdentityPoolError)
    pub fn update_identity_pool(&self) -> fluent_builders::UpdateIdentityPool {
        fluent_builders::UpdateIdentityPool::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateIdentityPool`.
    ///
    /// <p>Creates a new identity pool. The identity pool is a store of user identity information that is specific to your AWS account. The keys for <code>SupportedLoginProviders</code> are as follows:</p>
    /// <ul>
    /// <li> <p>Facebook: <code>graph.facebook.com</code> </p> </li>
    /// <li> <p>Google: <code>accounts.google.com</code> </p> </li>
    /// <li> <p>Amazon: <code>www.amazon.com</code> </p> </li>
    /// <li> <p>Twitter: <code>api.twitter.com</code> </p> </li>
    /// <li> <p>Digits: <code>www.digits.com</code> </p> </li>
    /// </ul>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIdentityPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_identity_pool_input::Builder,
    }
    impl CreateIdentityPool {
        /// Creates a new `CreateIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIdentityPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_name(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_name(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_unauthenticated_identities(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allow_unauthenticated_identities(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_classic_flow(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_classic_flow(input);
            self
        }
        /// Adds a key-value pair to `SupportedLoginProviders`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.supported_login_providers(k.into(), v.into());
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_supported_login_providers(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (<code>.</code>), underscore (<code>_</code>), and dash (<code>-</code>).</p>
        /// <p>Once you have set a developer provider name, you cannot change it. Please take care in setting this parameter.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (<code>.</code>), underscore (<code>_</code>), and dash (<code>-</code>).</p>
        /// <p>Once you have set a developer provider name, you cannot change it. Please take care in setting this parameter.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// Appends an item to `OpenIdConnectProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.open_id_connect_provider_ar_ns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_ar_ns(input);
            self
        }
        /// Appends an item to `CognitoIdentityProviders`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>An array of Amazon Cognito user pools and their client IDs.</p>
        pub fn cognito_identity_providers(
            mut self,
            input: crate::model::CognitoIdentityProvider,
        ) -> Self {
            self.inner = self.inner.cognito_identity_providers(input);
            self
        }
        /// <p>An array of Amazon Cognito user pools and their client IDs.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.inner = self.inner.set_cognito_identity_providers(input);
            self
        }
        /// Appends an item to `SamlProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
        pub fn saml_provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_ar_ns(input.into());
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_ar_ns(input);
            self
        }
        /// Adds a key-value pair to `IdentityPoolTags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_pool_tags(k.into(), v.into());
            self
        }
        /// <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentities`.
    ///
    /// <p>Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_identities_input::Builder,
    }
    impl DeleteIdentities {
        /// Creates a new `DeleteIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `IdentityIdsToDelete`.
        ///
        /// To override the contents of this collection use [`set_identity_ids_to_delete`](Self::set_identity_ids_to_delete).
        ///
        /// <p>A list of 1-60 identities that you want to delete.</p>
        pub fn identity_ids_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_ids_to_delete(input.into());
            self
        }
        /// <p>A list of 1-60 identities that you want to delete.</p>
        pub fn set_identity_ids_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_ids_to_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentityPool`.
    ///
    /// <p>Deletes an identity pool. Once a pool is deleted, users will not be able to authenticate with the pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIdentityPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_identity_pool_input::Builder,
    }
    impl DeleteIdentityPool {
        /// Creates a new `DeleteIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentity`.
    ///
    /// <p>Returns metadata related to the given identity, including when the identity was created and any associated linked logins.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_identity_input::Builder,
    }
    impl DescribeIdentity {
        /// Creates a new `DescribeIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityPool`.
    ///
    /// <p>Gets details about a particular identity pool, including the pool name, ID description, creation date, and current number of users.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentityPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_identity_pool_input::Builder,
    }
    impl DescribeIdentityPool {
        /// Creates a new `DescribeIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCredentialsForIdentity`.
    ///
    /// <p>Returns credentials for the provided identity ID. Any provided logins will be validated against supported login providers. If the token is for cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service with the appropriate role for the token.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCredentialsForIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_credentials_for_identity_input::Builder,
    }
    impl GetCredentialsForIdentity {
        /// Creates a new `GetCredentialsForIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCredentialsForIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCredentialsForIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will follow the syntax "provider_name": "provider_user_identifier".</p>
        /// <p>Logins should not be specified when trying to get credentials for an unauthenticated identity.</p>
        /// <p>The Logins parameter is required when using identities associated with external identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer Guide.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k.into(), v.into());
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will follow the syntax "provider_name": "provider_user_identifier".</p>
        /// <p>Logins should not be specified when trying to get credentials for an unauthenticated identity.</p>
        /// <p>The Logins parameter is required when using identities associated with external identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer Guide.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers that do not support role customization.</p>
        pub fn custom_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers that do not support role customization.</p>
        pub fn set_custom_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetId`.
    ///
    /// <p>Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_id_input::Builder,
    }
    impl GetId {
        /// Creates a new `GetId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A standard AWS account ID (9+ digits).</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>A standard AWS account ID (9+ digits).</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The available provider names for <code>Logins</code> are as follows:</p>
        /// <ul>
        /// <li> <p>Facebook: <code>graph.facebook.com</code> </p> </li>
        /// <li> <p>Amazon Cognito user pool: <code>cognito-idp.
        /// <region>
        /// .amazonaws.com/
        /// <your_user_pool_id></your_user_pool_id>
        /// </region></code>, for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>. </p> </li>
        /// <li> <p>Google: <code>accounts.google.com</code> </p> </li>
        /// <li> <p>Amazon: <code>www.amazon.com</code> </p> </li>
        /// <li> <p>Twitter: <code>api.twitter.com</code> </p> </li>
        /// <li> <p>Digits: <code>www.digits.com</code> </p> </li>
        /// </ul>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k.into(), v.into());
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The available provider names for <code>Logins</code> are as follows:</p>
        /// <ul>
        /// <li> <p>Facebook: <code>graph.facebook.com</code> </p> </li>
        /// <li> <p>Amazon Cognito user pool: <code>cognito-idp.
        /// <region>
        /// .amazonaws.com/
        /// <your_user_pool_id></your_user_pool_id>
        /// </region></code>, for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>. </p> </li>
        /// <li> <p>Google: <code>accounts.google.com</code> </p> </li>
        /// <li> <p>Amazon: <code>www.amazon.com</code> </p> </li>
        /// <li> <p>Twitter: <code>api.twitter.com</code> </p> </li>
        /// <li> <p>Digits: <code>www.digits.com</code> </p> </li>
        /// </ul>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityPoolRoles`.
    ///
    /// <p>Gets the roles for an identity pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityPoolRoles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_pool_roles_input::Builder,
    }
    impl GetIdentityPoolRoles {
        /// Creates a new `GetIdentityPoolRoles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityPoolRolesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityPoolRolesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpenIdToken`.
    ///
    /// <p>Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by <code>GetId</code>. You can optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.</p>
    /// <p>The OpenID token is valid for 10 minutes.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOpenIdToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_open_id_token_input::Builder,
    }
    impl GetOpenIdToken {
        /// Creates a new `GetOpenIdToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpenIdTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpenIdTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any other OpenID Connect provider, always include the <code>id_token</code>.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k.into(), v.into());
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any other OpenID Connect provider, always include the <code>id_token</code>.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpenIdTokenForDeveloperIdentity`.
    ///
    /// <p>Registers (or retrieves) a Cognito <code>IdentityId</code> and an OpenID Connect token for a user authenticated by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can only specify one developer provider as part of the <code>Logins</code> map, which is linked to the identity pool. The developer provider is the "domain" by which Cognito will refer to your users.</p>
    /// <p>You can use <code>GetOpenIdTokenForDeveloperIdentity</code> to create a new identity and to link new logins (that is, user credentials issued by a public provider or developer provider) to an existing identity. When you want to create a new identity, the <code>IdentityId</code> should be null. When you want to associate a new login with an existing authenticated/unauthenticated identity, you can do so by providing the existing <code>IdentityId</code>. This API will create the identity in the specified <code>IdentityPoolId</code>.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOpenIdTokenForDeveloperIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_open_id_token_for_developer_identity_input::Builder,
    }
    impl GetOpenIdTokenForDeveloperIdentity {
        /// Creates a new `GetOpenIdTokenForDeveloperIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpenIdTokenForDeveloperIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetOpenIdTokenForDeveloperIdentityError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a user from a public provider or developer provider. If the user is from a developer provider, the name-value pair will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the identity pool. The developer user identifier is an identifier from your backend that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k.into(), v.into());
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a user from a public provider or developer provider. If the user is from a developer provider, the name-value pair will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the identity pool. The developer user identifier is an identifier from your backend that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
        /// Adds a key-value pair to `PrincipalTags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>Use this operation to configure attribute mappings for custom providers. </p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.principal_tags(k.into(), v.into());
            self
        }
        /// <p>Use this operation to configure attribute mappings for custom providers. </p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_principal_tags(input);
            self
        }
        /// <p>The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are significant security implications: an attacker could use a leaked token to access your AWS resources for the token's duration.</p> <note>
        /// <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>
        /// </note>
        pub fn token_duration(mut self, input: i64) -> Self {
            self.inner = self.inner.token_duration(input);
            self
        }
        /// <p>The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are significant security implications: an attacker could use a leaked token to access your AWS resources for the token's duration.</p> <note>
        /// <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>
        /// </note>
        pub fn set_token_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_token_duration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPrincipalTagAttributeMap`.
    ///
    /// <p>Use <code>GetPrincipalTagAttributeMap</code> to list all mappings between <code>PrincipalTags</code> and user attributes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPrincipalTagAttributeMap {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_principal_tag_attribute_map_input::Builder,
    }
    impl GetPrincipalTagAttributeMap {
        /// Creates a new `GetPrincipalTagAttributeMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPrincipalTagAttributeMapOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPrincipalTagAttributeMapError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(input.into());
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentities`.
    ///
    /// <p>Lists the identities in an identity pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_identities_input::Builder,
    }
    impl ListIdentities {
        /// Creates a new `ListIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API will include disabled identities in the response.</p>
        pub fn hide_disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.hide_disabled(input);
            self
        }
        /// <p>An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API will include disabled identities in the response.</p>
        pub fn set_hide_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_hide_disabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityPools`.
    ///
    /// <p>Lists all of the Cognito identity pools registered for your account.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentityPools {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_identity_pools_input::Builder,
    }
    impl ListIdentityPools {
        /// Creates a new `ListIdentityPools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityPoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityPoolsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIdentityPoolsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIdentityPoolsPaginator {
            crate::paginator::ListIdentityPoolsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that are assigned to an Amazon Cognito identity pool.</p>
    /// <p>A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// <p>You can use this action up to 10 times per second, per account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LookupDeveloperIdentity`.
    ///
    /// <p>Retrieves the <code>IdentityID</code> associated with a <code>DeveloperUserIdentifier</code> or the list of <code>DeveloperUserIdentifier</code> values associated with an <code>IdentityId</code> for an existing identity. Either <code>IdentityID</code> or <code>DeveloperUserIdentifier</code> must not be null. If you supply only one of these values, the other value will be searched in the database and returned as a part of the response. If you supply both, <code>DeveloperUserIdentifier</code> will be matched against <code>IdentityID</code>. If the values are verified against the database, the response returns both values and is the same as the request. Otherwise a <code>ResourceConflictException</code> is thrown.</p>
    /// <p> <code>LookupDeveloperIdentity</code> is intended for low-throughput control plane operations: for example, to enable customer service to locate an identity ID by username. If you are using it for higher-volume operations such as user authentication, your requests are likely to be throttled. <code>GetOpenIdTokenForDeveloperIdentity</code> is a better option for higher-volume operations for user authentication.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct LookupDeveloperIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::lookup_developer_identity_input::Builder,
    }
    impl LookupDeveloperIdentity {
        /// Creates a new `LookupDeveloperIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LookupDeveloperIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::LookupDeveloperIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user. Typically, a developer identity provider would issue many developer user identifiers, in keeping with the number of users.</p>
        pub fn developer_user_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_user_identifier(input.into());
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user. Typically, a developer identity provider would issue many developer user identifiers, in keeping with the number of users.</p>
        pub fn set_developer_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_user_identifier(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service will return <code>NextToken</code> values as needed. For example, let's say you make a request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service will return <code>NextToken</code> values as needed. For example, let's say you make a request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeDeveloperIdentities`.
    ///
    /// <p>Merges two users having different <code>IdentityId</code>s, existing in the same identity pool, and identified by the same developer provider. You can use this action to request that discrete users be merged and identified as a single user in the Cognito environment. Cognito associates the given source user (<code>SourceUserIdentifier</code>) with the <code>IdentityId</code> of the <code>DestinationUserIdentifier</code>. Only developer-authenticated users can be merged. If the users to be merged are associated with the same public provider, but as two different users, an exception will be thrown.</p>
    /// <p>The number of linked logins is limited to 20. So, the number of linked logins for the source user, <code>SourceUserIdentifier</code>, and the destination user, <code>DestinationUserIdentifier</code>, together should not be larger than 20. Otherwise, an exception will be thrown.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergeDeveloperIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_developer_identities_input::Builder,
    }
    impl MergeDeveloperIdentities {
        /// Creates a new `MergeDeveloperIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeDeveloperIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeDeveloperIdentitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.</p>
        pub fn source_user_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_user_identifier(input.into());
            self
        }
        /// <p>User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.</p>
        pub fn set_source_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_user_identifier(input);
            self
        }
        /// <p>User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.</p>
        pub fn destination_user_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_user_identifier(input.into());
            self
        }
        /// <p>User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.</p>
        pub fn set_destination_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_user_identifier(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (.), underscore (_), and dash (-).</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (.), underscore (_), and dash (-).</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityPoolRoles`.
    ///
    /// <p>Sets the roles for an identity pool. These roles are used when making calls to <code>GetCredentialsForIdentity</code> action.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIdentityPoolRoles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_identity_pool_roles_input::Builder,
    }
    impl SetIdentityPoolRoles {
        /// Creates a new `SetIdentityPoolRoles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityPoolRolesOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityPoolRolesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// Adds a key-value pair to `Roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
        pub fn roles(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.roles(k.into(), v.into());
            self
        }
        /// <p>The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_roles(input);
            self
        }
        /// Adds a key-value pair to `RoleMappings`.
        ///
        /// To override the contents of this collection use [`set_role_mappings`](Self::set_role_mappings).
        ///
        /// <p>How users for a specific identity provider are to mapped to roles. This is a string to <code>RoleMapping</code> object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        /// <p>Up to 25 rules can be specified per identity provider.</p>
        pub fn role_mappings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::RoleMapping,
        ) -> Self {
            self.inner = self.inner.role_mappings(k.into(), v);
            self
        }
        /// <p>How users for a specific identity provider are to mapped to roles. This is a string to <code>RoleMapping</code> object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        /// <p>Up to 25 rules can be specified per identity provider.</p>
        pub fn set_role_mappings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
            >,
        ) -> Self {
            self.inner = self.inner.set_role_mappings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetPrincipalTagAttributeMap`.
    ///
    /// <p>You can use this operation to use default (username and clientID) attribute or custom attribute mappings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetPrincipalTagAttributeMap {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_principal_tag_attribute_map_input::Builder,
    }
    impl SetPrincipalTagAttributeMap {
        /// Creates a new `SetPrincipalTagAttributeMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetPrincipalTagAttributeMapOutput,
            aws_smithy_http::result::SdkError<crate::error::SetPrincipalTagAttributeMapError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(input.into());
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
        /// <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
        pub fn use_defaults(mut self, input: bool) -> Self {
            self.inner = self.inner.use_defaults(input);
            self
        }
        /// <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
        pub fn set_use_defaults(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_defaults(input);
            self
        }
        /// Adds a key-value pair to `PrincipalTags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>You can use this operation to add principal tags.</p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.principal_tags(k.into(), v.into());
            self
        }
        /// <p>You can use this operation to add principal tags.</p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_principal_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label that you can use to categorize and manage identity pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// <p>Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of an identity pool, one for testing and another for production, you might assign an <code>Environment</code> tag key to both identity pools. The value of this key might be <code>Test</code> for one identity pool and <code>Production</code> for the other.</p>
    /// <p>Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your identity pools. In an IAM policy, you can constrain permissions for identity pools based on specific tags or tag values.</p>
    /// <p>You can use this action up to 5 times per second, per account. An identity pool can have as many as 50 tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the identity pool.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the identity pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnlinkDeveloperIdentity`.
    ///
    /// <p>Unlinks a <code>DeveloperUserIdentifier</code> from an existing identity. Unlinked developer users will be considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated identities as well as the developer user identifier, the Cognito identity becomes inaccessible.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UnlinkDeveloperIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::unlink_developer_identity_input::Builder,
    }
    impl UnlinkDeveloperIdentity {
        /// Creates a new `UnlinkDeveloperIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnlinkDeveloperIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::UnlinkDeveloperIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.</p>
        pub fn developer_user_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_user_identifier(input.into());
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.</p>
        pub fn set_developer_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_user_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnlinkIdentity`.
    ///
    /// <p>Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next time they are seen. Removing the last linked login will make this identity inaccessible.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UnlinkIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::unlink_identity_input::Builder,
    }
    impl UnlinkIdentity {
        /// Creates a new `UnlinkIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnlinkIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::UnlinkIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k.into(), v.into());
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
        /// Appends an item to `LoginsToRemove`.
        ///
        /// To override the contents of this collection use [`set_logins_to_remove`](Self::set_logins_to_remove).
        ///
        /// <p>Provider names to unlink from this identity.</p>
        pub fn logins_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logins_to_remove(input.into());
            self
        }
        /// <p>Provider names to unlink from this identity.</p>
        pub fn set_logins_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_logins_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified Amazon Cognito identity pool. You can use this action up to 5 times per second, per account</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIdentityPool`.
    ///
    /// <p>Updates an identity pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIdentityPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_identity_pool_input::Builder,
    }
    impl UpdateIdentityPool {
        /// Creates a new `UpdateIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIdentityPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_name(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_name(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_unauthenticated_identities(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allow_unauthenticated_identities(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_classic_flow(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_classic_flow(input);
            self
        }
        /// Adds a key-value pair to `SupportedLoginProviders`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.supported_login_providers(k.into(), v.into());
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_supported_login_providers(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// Appends an item to `OpenIdConnectProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.open_id_connect_provider_ar_ns(input.into());
            self
        }
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_ar_ns(input);
            self
        }
        /// Appends an item to `CognitoIdentityProviders`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn cognito_identity_providers(
            mut self,
            input: crate::model::CognitoIdentityProvider,
        ) -> Self {
            self.inner = self.inner.cognito_identity_providers(input);
            self
        }
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.inner = self.inner.set_cognito_identity_providers(input);
            self
        }
        /// Appends an item to `SamlProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
        pub fn saml_provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_ar_ns(input.into());
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_ar_ns(input);
            self
        }
        /// Adds a key-value pair to `IdentityPoolTags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_pool_tags(k.into(), v.into());
            self
        }
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_tags(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
