// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object representing an Amazon Cognito identity pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIdentityPoolOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A string that you provide.</p>
    pub identity_pool_name: std::option::Option<std::string::String>,
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub allow_unauthenticated_identities: bool,
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub allow_classic_flow: std::option::Option<bool>,
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub supported_login_providers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub developer_provider_name: std::option::Option<std::string::String>,
    /// <p>The ARNs of the OpenID Connect providers.</p>
    pub open_id_connect_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    pub cognito_identity_providers:
        std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
    /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub identity_pool_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateIdentityPoolOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>A string that you provide.</p>
    pub fn identity_pool_name(&self) -> std::option::Option<&str> {
        self.identity_pool_name.as_deref()
    }
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub fn allow_unauthenticated_identities(&self) -> bool {
        self.allow_unauthenticated_identities
    }
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub fn allow_classic_flow(&self) -> std::option::Option<bool> {
        self.allow_classic_flow
    }
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub fn supported_login_providers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.supported_login_providers.as_ref()
    }
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub fn developer_provider_name(&self) -> std::option::Option<&str> {
        self.developer_provider_name.as_deref()
    }
    /// <p>The ARNs of the OpenID Connect providers.</p>
    pub fn open_id_connect_provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.open_id_connect_provider_ar_ns.as_deref()
    }
    /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    pub fn cognito_identity_providers(
        &self,
    ) -> std::option::Option<&[crate::model::CognitoIdentityProvider]> {
        self.cognito_identity_providers.as_deref()
    }
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub fn saml_provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.saml_provider_ar_ns.as_deref()
    }
    /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
    /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub fn identity_pool_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.identity_pool_tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateIdentityPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIdentityPoolOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_pool_name", &self.identity_pool_name);
        formatter.field(
            "allow_unauthenticated_identities",
            &self.allow_unauthenticated_identities,
        );
        formatter.field("allow_classic_flow", &self.allow_classic_flow);
        formatter.field("supported_login_providers", &self.supported_login_providers);
        formatter.field("developer_provider_name", &self.developer_provider_name);
        formatter.field(
            "open_id_connect_provider_ar_ns",
            &self.open_id_connect_provider_ar_ns,
        );
        formatter.field(
            "cognito_identity_providers",
            &self.cognito_identity_providers,
        );
        formatter.field("saml_provider_ar_ns", &self.saml_provider_ar_ns);
        formatter.field("identity_pool_tags", &self.identity_pool_tags);
        formatter.finish()
    }
}
/// See [`UpdateIdentityPoolOutput`](crate::output::UpdateIdentityPoolOutput)
pub mod update_identity_pool_output {
    /// A builder for [`UpdateIdentityPoolOutput`](crate::output::UpdateIdentityPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_name: std::option::Option<std::string::String>,
        pub(crate) allow_unauthenticated_identities: std::option::Option<bool>,
        pub(crate) allow_classic_flow: std::option::Option<bool>,
        pub(crate) supported_login_providers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) developer_provider_name: std::option::Option<std::string::String>,
        pub(crate) open_id_connect_provider_ar_ns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cognito_identity_providers:
            std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        pub(crate) saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_name = Some(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_name = input;
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, input: bool) -> Self {
            self.allow_unauthenticated_identities = Some(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_unauthenticated_identities = input;
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, input: bool) -> Self {
            self.allow_classic_flow = Some(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_classic_flow = input;
            self
        }
        /// Adds a key-value pair to `supported_login_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.supported_login_providers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.supported_login_providers = Some(hash_map);
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.supported_login_providers = input;
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_provider_name = Some(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_provider_name = input;
            self
        }
        /// Appends an item to `open_id_connect_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.open_id_connect_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.open_id_connect_provider_ar_ns = Some(v);
            self
        }
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.open_id_connect_provider_ar_ns = input;
            self
        }
        /// Appends an item to `cognito_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn cognito_identity_providers(
            mut self,
            input: impl Into<crate::model::CognitoIdentityProvider>,
        ) -> Self {
            let mut v = self.cognito_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.cognito_identity_providers = Some(v);
            self
        }
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.cognito_identity_providers = input;
            self
        }
        /// Appends an item to `saml_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn saml_provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.saml_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.saml_provider_ar_ns = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.saml_provider_ar_ns = input;
            self
        }
        /// Adds a key-value pair to `identity_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_pool_tags = Some(hash_map);
            self
        }
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_pool_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIdentityPoolOutput`](crate::output::UpdateIdentityPoolOutput)
        pub fn build(self) -> crate::output::UpdateIdentityPoolOutput {
            crate::output::UpdateIdentityPoolOutput {
                identity_pool_id: self.identity_pool_id,
                identity_pool_name: self.identity_pool_name,
                allow_unauthenticated_identities: self
                    .allow_unauthenticated_identities
                    .unwrap_or_default(),
                allow_classic_flow: self.allow_classic_flow,
                supported_login_providers: self.supported_login_providers,
                developer_provider_name: self.developer_provider_name,
                open_id_connect_provider_ar_ns: self.open_id_connect_provider_ar_ns,
                cognito_identity_providers: self.cognito_identity_providers,
                saml_provider_ar_ns: self.saml_provider_ar_ns,
                identity_pool_tags: self.identity_pool_tags,
            }
        }
    }
}
impl UpdateIdentityPoolOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIdentityPoolOutput`](crate::output::UpdateIdentityPoolOutput)
    pub fn builder() -> crate::output::update_identity_pool_output::Builder {
        crate::output::update_identity_pool_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnlinkIdentityOutput {}
impl std::fmt::Debug for UnlinkIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnlinkIdentityOutput");
        formatter.finish()
    }
}
/// See [`UnlinkIdentityOutput`](crate::output::UnlinkIdentityOutput)
pub mod unlink_identity_output {
    /// A builder for [`UnlinkIdentityOutput`](crate::output::UnlinkIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UnlinkIdentityOutput`](crate::output::UnlinkIdentityOutput)
        pub fn build(self) -> crate::output::UnlinkIdentityOutput {
            crate::output::UnlinkIdentityOutput {}
        }
    }
}
impl UnlinkIdentityOutput {
    /// Creates a new builder-style object to manufacture [`UnlinkIdentityOutput`](crate::output::UnlinkIdentityOutput)
    pub fn builder() -> crate::output::unlink_identity_output::Builder {
        crate::output::unlink_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnlinkDeveloperIdentityOutput {}
impl std::fmt::Debug for UnlinkDeveloperIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnlinkDeveloperIdentityOutput");
        formatter.finish()
    }
}
/// See [`UnlinkDeveloperIdentityOutput`](crate::output::UnlinkDeveloperIdentityOutput)
pub mod unlink_developer_identity_output {
    /// A builder for [`UnlinkDeveloperIdentityOutput`](crate::output::UnlinkDeveloperIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UnlinkDeveloperIdentityOutput`](crate::output::UnlinkDeveloperIdentityOutput)
        pub fn build(self) -> crate::output::UnlinkDeveloperIdentityOutput {
            crate::output::UnlinkDeveloperIdentityOutput {}
        }
    }
}
impl UnlinkDeveloperIdentityOutput {
    /// Creates a new builder-style object to manufacture [`UnlinkDeveloperIdentityOutput`](crate::output::UnlinkDeveloperIdentityOutput)
    pub fn builder() -> crate::output::unlink_developer_identity_output::Builder {
        crate::output::unlink_developer_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetPrincipalTagAttributeMapOutput {
    /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The provider name you want to use for attribute mappings.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
    /// <p>You can use this operation to select default (username and clientID) attribute mappings.</p>
    pub use_defaults: std::option::Option<bool>,
    /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
    pub principal_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SetPrincipalTagAttributeMapOutput {
    /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>The provider name you want to use for attribute mappings.</p>
    pub fn identity_provider_name(&self) -> std::option::Option<&str> {
        self.identity_provider_name.as_deref()
    }
    /// <p>You can use this operation to select default (username and clientID) attribute mappings.</p>
    pub fn use_defaults(&self) -> std::option::Option<bool> {
        self.use_defaults
    }
    /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
    pub fn principal_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.principal_tags.as_ref()
    }
}
impl std::fmt::Debug for SetPrincipalTagAttributeMapOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetPrincipalTagAttributeMapOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.field("use_defaults", &self.use_defaults);
        formatter.field("principal_tags", &self.principal_tags);
        formatter.finish()
    }
}
/// See [`SetPrincipalTagAttributeMapOutput`](crate::output::SetPrincipalTagAttributeMapOutput)
pub mod set_principal_tag_attribute_map_output {
    /// A builder for [`SetPrincipalTagAttributeMapOutput`](crate::output::SetPrincipalTagAttributeMapOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
        pub(crate) use_defaults: std::option::Option<bool>,
        pub(crate) principal_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// <p>You can use this operation to select default (username and clientID) attribute mappings.</p>
        pub fn use_defaults(mut self, input: bool) -> Self {
            self.use_defaults = Some(input);
            self
        }
        /// <p>You can use this operation to select default (username and clientID) attribute mappings.</p>
        pub fn set_use_defaults(mut self, input: std::option::Option<bool>) -> Self {
            self.use_defaults = input;
            self
        }
        /// Adds a key-value pair to `principal_tags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.principal_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.principal_tags = Some(hash_map);
            self
        }
        /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.principal_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SetPrincipalTagAttributeMapOutput`](crate::output::SetPrincipalTagAttributeMapOutput)
        pub fn build(self) -> crate::output::SetPrincipalTagAttributeMapOutput {
            crate::output::SetPrincipalTagAttributeMapOutput {
                identity_pool_id: self.identity_pool_id,
                identity_provider_name: self.identity_provider_name,
                use_defaults: self.use_defaults,
                principal_tags: self.principal_tags,
            }
        }
    }
}
impl SetPrincipalTagAttributeMapOutput {
    /// Creates a new builder-style object to manufacture [`SetPrincipalTagAttributeMapOutput`](crate::output::SetPrincipalTagAttributeMapOutput)
    pub fn builder() -> crate::output::set_principal_tag_attribute_map_output::Builder {
        crate::output::set_principal_tag_attribute_map_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityPoolRolesOutput {}
impl std::fmt::Debug for SetIdentityPoolRolesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityPoolRolesOutput");
        formatter.finish()
    }
}
/// See [`SetIdentityPoolRolesOutput`](crate::output::SetIdentityPoolRolesOutput)
pub mod set_identity_pool_roles_output {
    /// A builder for [`SetIdentityPoolRolesOutput`](crate::output::SetIdentityPoolRolesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetIdentityPoolRolesOutput`](crate::output::SetIdentityPoolRolesOutput)
        pub fn build(self) -> crate::output::SetIdentityPoolRolesOutput {
            crate::output::SetIdentityPoolRolesOutput {}
        }
    }
}
impl SetIdentityPoolRolesOutput {
    /// Creates a new builder-style object to manufacture [`SetIdentityPoolRolesOutput`](crate::output::SetIdentityPoolRolesOutput)
    pub fn builder() -> crate::output::set_identity_pool_roles_output::Builder {
        crate::output::set_identity_pool_roles_output::Builder::default()
    }
}

/// <p>Returned in response to a successful <code>MergeDeveloperIdentities</code>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeDeveloperIdentitiesOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
}
impl MergeDeveloperIdentitiesOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
}
impl std::fmt::Debug for MergeDeveloperIdentitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeDeveloperIdentitiesOutput");
        formatter.field("identity_id", &self.identity_id);
        formatter.finish()
    }
}
/// See [`MergeDeveloperIdentitiesOutput`](crate::output::MergeDeveloperIdentitiesOutput)
pub mod merge_developer_identities_output {
    /// A builder for [`MergeDeveloperIdentitiesOutput`](crate::output::MergeDeveloperIdentitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeDeveloperIdentitiesOutput`](crate::output::MergeDeveloperIdentitiesOutput)
        pub fn build(self) -> crate::output::MergeDeveloperIdentitiesOutput {
            crate::output::MergeDeveloperIdentitiesOutput {
                identity_id: self.identity_id,
            }
        }
    }
}
impl MergeDeveloperIdentitiesOutput {
    /// Creates a new builder-style object to manufacture [`MergeDeveloperIdentitiesOutput`](crate::output::MergeDeveloperIdentitiesOutput)
    pub fn builder() -> crate::output::merge_developer_identities_output::Builder {
        crate::output::merge_developer_identities_output::Builder::default()
    }
}

/// <p>Returned in response to a successful <code>LookupDeveloperIdentity</code>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupDeveloperIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>This is the list of developer user identifiers associated with an identity ID.
    /// Cognito supports the association of multiple developer user identifiers with an identity
    /// ID.</p>
    pub developer_user_identifier_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
    /// null. After that the service will return <code>NextToken</code> values as needed. For
    /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
    /// 20 matches in the database. The service will return a pagination token as a part of the
    /// response. This token can be used to call the API again and get results starting from the
    /// 11th match.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl LookupDeveloperIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>This is the list of developer user identifiers associated with an identity ID.
    /// Cognito supports the association of multiple developer user identifiers with an identity
    /// ID.</p>
    pub fn developer_user_identifier_list(&self) -> std::option::Option<&[std::string::String]> {
        self.developer_user_identifier_list.as_deref()
    }
    /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
    /// null. After that the service will return <code>NextToken</code> values as needed. For
    /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
    /// 20 matches in the database. The service will return a pagination token as a part of the
    /// response. This token can be used to call the API again and get results starting from the
    /// 11th match.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for LookupDeveloperIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupDeveloperIdentityOutput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field(
            "developer_user_identifier_list",
            &self.developer_user_identifier_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`LookupDeveloperIdentityOutput`](crate::output::LookupDeveloperIdentityOutput)
pub mod lookup_developer_identity_output {
    /// A builder for [`LookupDeveloperIdentityOutput`](crate::output::LookupDeveloperIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) developer_user_identifier_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Appends an item to `developer_user_identifier_list`.
        ///
        /// To override the contents of this collection use [`set_developer_user_identifier_list`](Self::set_developer_user_identifier_list).
        ///
        /// <p>This is the list of developer user identifiers associated with an identity ID.
        /// Cognito supports the association of multiple developer user identifiers with an identity
        /// ID.</p>
        pub fn developer_user_identifier_list(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.developer_user_identifier_list.unwrap_or_default();
            v.push(input.into());
            self.developer_user_identifier_list = Some(v);
            self
        }
        /// <p>This is the list of developer user identifiers associated with an identity ID.
        /// Cognito supports the association of multiple developer user identifiers with an identity
        /// ID.</p>
        pub fn set_developer_user_identifier_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.developer_user_identifier_list = input;
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
        /// null. After that the service will return <code>NextToken</code> values as needed. For
        /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
        /// 20 matches in the database. The service will return a pagination token as a part of the
        /// response. This token can be used to call the API again and get results starting from the
        /// 11th match.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
        /// null. After that the service will return <code>NextToken</code> values as needed. For
        /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
        /// 20 matches in the database. The service will return a pagination token as a part of the
        /// response. This token can be used to call the API again and get results starting from the
        /// 11th match.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupDeveloperIdentityOutput`](crate::output::LookupDeveloperIdentityOutput)
        pub fn build(self) -> crate::output::LookupDeveloperIdentityOutput {
            crate::output::LookupDeveloperIdentityOutput {
                identity_id: self.identity_id,
                developer_user_identifier_list: self.developer_user_identifier_list,
                next_token: self.next_token,
            }
        }
    }
}
impl LookupDeveloperIdentityOutput {
    /// Creates a new builder-style object to manufacture [`LookupDeveloperIdentityOutput`](crate::output::LookupDeveloperIdentityOutput)
    pub fn builder() -> crate::output::lookup_developer_identity_output::Builder {
        crate::output::lookup_developer_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the identity pool.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the identity pool.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are assigned to the identity pool.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags that are assigned to the identity pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>The result of a successful ListIdentityPools action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityPoolsOutput {
    /// <p>The identity pools returned by the ListIdentityPools action.</p>
    pub identity_pools:
        std::option::Option<std::vec::Vec<crate::model::IdentityPoolShortDescription>>,
    /// <p>A pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIdentityPoolsOutput {
    /// <p>The identity pools returned by the ListIdentityPools action.</p>
    pub fn identity_pools(
        &self,
    ) -> std::option::Option<&[crate::model::IdentityPoolShortDescription]> {
        self.identity_pools.as_deref()
    }
    /// <p>A pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIdentityPoolsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityPoolsOutput");
        formatter.field("identity_pools", &self.identity_pools);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIdentityPoolsOutput`](crate::output::ListIdentityPoolsOutput)
pub mod list_identity_pools_output {
    /// A builder for [`ListIdentityPoolsOutput`](crate::output::ListIdentityPoolsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pools:
            std::option::Option<std::vec::Vec<crate::model::IdentityPoolShortDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `identity_pools`.
        ///
        /// To override the contents of this collection use [`set_identity_pools`](Self::set_identity_pools).
        ///
        /// <p>The identity pools returned by the ListIdentityPools action.</p>
        pub fn identity_pools(
            mut self,
            input: impl Into<crate::model::IdentityPoolShortDescription>,
        ) -> Self {
            let mut v = self.identity_pools.unwrap_or_default();
            v.push(input.into());
            self.identity_pools = Some(v);
            self
        }
        /// <p>The identity pools returned by the ListIdentityPools action.</p>
        pub fn set_identity_pools(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IdentityPoolShortDescription>>,
        ) -> Self {
            self.identity_pools = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityPoolsOutput`](crate::output::ListIdentityPoolsOutput)
        pub fn build(self) -> crate::output::ListIdentityPoolsOutput {
            crate::output::ListIdentityPoolsOutput {
                identity_pools: self.identity_pools,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIdentityPoolsOutput {
    /// Creates a new builder-style object to manufacture [`ListIdentityPoolsOutput`](crate::output::ListIdentityPoolsOutput)
    pub fn builder() -> crate::output::list_identity_pools_output::Builder {
        crate::output::list_identity_pools_output::Builder::default()
    }
}

/// <p>The response to a ListIdentities request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentitiesOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>An object containing a set of identities and associated mappings.</p>
    pub identities: std::option::Option<std::vec::Vec<crate::model::IdentityDescription>>,
    /// <p>A pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIdentitiesOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>An object containing a set of identities and associated mappings.</p>
    pub fn identities(&self) -> std::option::Option<&[crate::model::IdentityDescription]> {
        self.identities.as_deref()
    }
    /// <p>A pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIdentitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentitiesOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identities", &self.identities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
pub mod list_identities_output {
    /// A builder for [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identities:
            std::option::Option<std::vec::Vec<crate::model::IdentityDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Appends an item to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>An object containing a set of identities and associated mappings.</p>
        pub fn identities(mut self, input: impl Into<crate::model::IdentityDescription>) -> Self {
            let mut v = self.identities.unwrap_or_default();
            v.push(input.into());
            self.identities = Some(v);
            self
        }
        /// <p>An object containing a set of identities and associated mappings.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IdentityDescription>>,
        ) -> Self {
            self.identities = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
        pub fn build(self) -> crate::output::ListIdentitiesOutput {
            crate::output::ListIdentitiesOutput {
                identity_pool_id: self.identity_pool_id,
                identities: self.identities,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIdentitiesOutput {
    /// Creates a new builder-style object to manufacture [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
    pub fn builder() -> crate::output::list_identities_output::Builder {
        crate::output::list_identities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPrincipalTagAttributeMapOutput {
    /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>You can use this operation to get the provider name.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
    /// <p>You can use this operation to list </p>
    pub use_defaults: std::option::Option<bool>,
    /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
    pub principal_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetPrincipalTagAttributeMapOutput {
    /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>You can use this operation to get the provider name.</p>
    pub fn identity_provider_name(&self) -> std::option::Option<&str> {
        self.identity_provider_name.as_deref()
    }
    /// <p>You can use this operation to list </p>
    pub fn use_defaults(&self) -> std::option::Option<bool> {
        self.use_defaults
    }
    /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
    pub fn principal_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.principal_tags.as_ref()
    }
}
impl std::fmt::Debug for GetPrincipalTagAttributeMapOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPrincipalTagAttributeMapOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.field("use_defaults", &self.use_defaults);
        formatter.field("principal_tags", &self.principal_tags);
        formatter.finish()
    }
}
/// See [`GetPrincipalTagAttributeMapOutput`](crate::output::GetPrincipalTagAttributeMapOutput)
pub mod get_principal_tag_attribute_map_output {
    /// A builder for [`GetPrincipalTagAttributeMapOutput`](crate::output::GetPrincipalTagAttributeMapOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
        pub(crate) use_defaults: std::option::Option<bool>,
        pub(crate) principal_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// <p>You can use this operation to list </p>
        pub fn use_defaults(mut self, input: bool) -> Self {
            self.use_defaults = Some(input);
            self
        }
        /// <p>You can use this operation to list </p>
        pub fn set_use_defaults(mut self, input: std::option::Option<bool>) -> Self {
            self.use_defaults = input;
            self
        }
        /// Adds a key-value pair to `principal_tags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.principal_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.principal_tags = Some(hash_map);
            self
        }
        /// <p>You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to reference user attributes in your IAM permissions policy.</p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.principal_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPrincipalTagAttributeMapOutput`](crate::output::GetPrincipalTagAttributeMapOutput)
        pub fn build(self) -> crate::output::GetPrincipalTagAttributeMapOutput {
            crate::output::GetPrincipalTagAttributeMapOutput {
                identity_pool_id: self.identity_pool_id,
                identity_provider_name: self.identity_provider_name,
                use_defaults: self.use_defaults,
                principal_tags: self.principal_tags,
            }
        }
    }
}
impl GetPrincipalTagAttributeMapOutput {
    /// Creates a new builder-style object to manufacture [`GetPrincipalTagAttributeMapOutput`](crate::output::GetPrincipalTagAttributeMapOutput)
    pub fn builder() -> crate::output::get_principal_tag_attribute_map_output::Builder {
        crate::output::get_principal_tag_attribute_map_output::Builder::default()
    }
}

/// <p>Returned in response to a successful <code>GetOpenIdTokenForDeveloperIdentity</code>
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpenIdTokenForDeveloperIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>An OpenID token.</p>
    pub token: std::option::Option<std::string::String>,
}
impl GetOpenIdTokenForDeveloperIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>An OpenID token.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
}
impl std::fmt::Debug for GetOpenIdTokenForDeveloperIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpenIdTokenForDeveloperIdentityOutput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("token", &self.token);
        formatter.finish()
    }
}
/// See [`GetOpenIdTokenForDeveloperIdentityOutput`](crate::output::GetOpenIdTokenForDeveloperIdentityOutput)
pub mod get_open_id_token_for_developer_identity_output {
    /// A builder for [`GetOpenIdTokenForDeveloperIdentityOutput`](crate::output::GetOpenIdTokenForDeveloperIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>An OpenID token.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>An OpenID token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpenIdTokenForDeveloperIdentityOutput`](crate::output::GetOpenIdTokenForDeveloperIdentityOutput)
        pub fn build(self) -> crate::output::GetOpenIdTokenForDeveloperIdentityOutput {
            crate::output::GetOpenIdTokenForDeveloperIdentityOutput {
                identity_id: self.identity_id,
                token: self.token,
            }
        }
    }
}
impl GetOpenIdTokenForDeveloperIdentityOutput {
    /// Creates a new builder-style object to manufacture [`GetOpenIdTokenForDeveloperIdentityOutput`](crate::output::GetOpenIdTokenForDeveloperIdentityOutput)
    pub fn builder() -> crate::output::get_open_id_token_for_developer_identity_output::Builder {
        crate::output::get_open_id_token_for_developer_identity_output::Builder::default()
    }
}

/// <p>Returned in response to a successful GetOpenIdToken request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpenIdTokenOutput {
    /// <p>A unique identifier in the format REGION:GUID. Note that the IdentityId returned may
    /// not match the one passed on input.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>An OpenID token, valid for 10 minutes.</p>
    pub token: std::option::Option<std::string::String>,
}
impl GetOpenIdTokenOutput {
    /// <p>A unique identifier in the format REGION:GUID. Note that the IdentityId returned may
    /// not match the one passed on input.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>An OpenID token, valid for 10 minutes.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
}
impl std::fmt::Debug for GetOpenIdTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpenIdTokenOutput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("token", &self.token);
        formatter.finish()
    }
}
/// See [`GetOpenIdTokenOutput`](crate::output::GetOpenIdTokenOutput)
pub mod get_open_id_token_output {
    /// A builder for [`GetOpenIdTokenOutput`](crate::output::GetOpenIdTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID. Note that the IdentityId returned may
        /// not match the one passed on input.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID. Note that the IdentityId returned may
        /// not match the one passed on input.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>An OpenID token, valid for 10 minutes.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>An OpenID token, valid for 10 minutes.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpenIdTokenOutput`](crate::output::GetOpenIdTokenOutput)
        pub fn build(self) -> crate::output::GetOpenIdTokenOutput {
            crate::output::GetOpenIdTokenOutput {
                identity_id: self.identity_id,
                token: self.token,
            }
        }
    }
}
impl GetOpenIdTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetOpenIdTokenOutput`](crate::output::GetOpenIdTokenOutput)
    pub fn builder() -> crate::output::get_open_id_token_output::Builder {
        crate::output::get_open_id_token_output::Builder::default()
    }
}

/// <p>Returned in response to a successful <code>GetIdentityPoolRoles</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityPoolRolesOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The map of roles associated with this pool. Currently only authenticated and
    /// unauthenticated roles are supported.</p>
    pub roles:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>How users for a specific identity provider are to mapped to roles. This is a
    /// String-to-<a>RoleMapping</a> object map. The string identifies the identity
    /// provider, for example, "graph.facebook.com" or
    /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
    pub role_mappings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
    >,
}
impl GetIdentityPoolRolesOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>The map of roles associated with this pool. Currently only authenticated and
    /// unauthenticated roles are supported.</p>
    pub fn roles(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.roles.as_ref()
    }
    /// <p>How users for a specific identity provider are to mapped to roles. This is a
    /// String-to-<a>RoleMapping</a> object map. The string identifies the identity
    /// provider, for example, "graph.facebook.com" or
    /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
    pub fn role_mappings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
    > {
        self.role_mappings.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityPoolRolesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityPoolRolesOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("roles", &self.roles);
        formatter.field("role_mappings", &self.role_mappings);
        formatter.finish()
    }
}
/// See [`GetIdentityPoolRolesOutput`](crate::output::GetIdentityPoolRolesOutput)
pub mod get_identity_pool_roles_output {
    /// A builder for [`GetIdentityPoolRolesOutput`](crate::output::GetIdentityPoolRolesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) roles: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) role_mappings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
        >,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Adds a key-value pair to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>The map of roles associated with this pool. Currently only authenticated and
        /// unauthenticated roles are supported.</p>
        pub fn roles(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.roles.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.roles = Some(hash_map);
            self
        }
        /// <p>The map of roles associated with this pool. Currently only authenticated and
        /// unauthenticated roles are supported.</p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Adds a key-value pair to `role_mappings`.
        ///
        /// To override the contents of this collection use [`set_role_mappings`](Self::set_role_mappings).
        ///
        /// <p>How users for a specific identity provider are to mapped to roles. This is a
        /// String-to-<a>RoleMapping</a> object map. The string identifies the identity
        /// provider, for example, "graph.facebook.com" or
        /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        pub fn role_mappings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RoleMapping>,
        ) -> Self {
            let mut hash_map = self.role_mappings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.role_mappings = Some(hash_map);
            self
        }
        /// <p>How users for a specific identity provider are to mapped to roles. This is a
        /// String-to-<a>RoleMapping</a> object map. The string identifies the identity
        /// provider, for example, "graph.facebook.com" or
        /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        pub fn set_role_mappings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
            >,
        ) -> Self {
            self.role_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityPoolRolesOutput`](crate::output::GetIdentityPoolRolesOutput)
        pub fn build(self) -> crate::output::GetIdentityPoolRolesOutput {
            crate::output::GetIdentityPoolRolesOutput {
                identity_pool_id: self.identity_pool_id,
                roles: self.roles,
                role_mappings: self.role_mappings,
            }
        }
    }
}
impl GetIdentityPoolRolesOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityPoolRolesOutput`](crate::output::GetIdentityPoolRolesOutput)
    pub fn builder() -> crate::output::get_identity_pool_roles_output::Builder {
        crate::output::get_identity_pool_roles_output::Builder::default()
    }
}

/// <p>Returned in response to a GetId request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
}
impl GetIdOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
}
impl std::fmt::Debug for GetIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdOutput");
        formatter.field("identity_id", &self.identity_id);
        formatter.finish()
    }
}
/// See [`GetIdOutput`](crate::output::GetIdOutput)
pub mod get_id_output {
    /// A builder for [`GetIdOutput`](crate::output::GetIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdOutput`](crate::output::GetIdOutput)
        pub fn build(self) -> crate::output::GetIdOutput {
            crate::output::GetIdOutput {
                identity_id: self.identity_id,
            }
        }
    }
}
impl GetIdOutput {
    /// Creates a new builder-style object to manufacture [`GetIdOutput`](crate::output::GetIdOutput)
    pub fn builder() -> crate::output::get_id_output::Builder {
        crate::output::get_id_output::Builder::default()
    }
}

/// <p>Returned in response to a successful <code>GetCredentialsForIdentity</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCredentialsForIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>Credentials for the provided identity ID.</p>
    pub credentials: std::option::Option<crate::model::Credentials>,
}
impl GetCredentialsForIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>Credentials for the provided identity ID.</p>
    pub fn credentials(&self) -> std::option::Option<&crate::model::Credentials> {
        self.credentials.as_ref()
    }
}
impl std::fmt::Debug for GetCredentialsForIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCredentialsForIdentityOutput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("credentials", &self.credentials);
        formatter.finish()
    }
}
/// See [`GetCredentialsForIdentityOutput`](crate::output::GetCredentialsForIdentityOutput)
pub mod get_credentials_for_identity_output {
    /// A builder for [`GetCredentialsForIdentityOutput`](crate::output::GetCredentialsForIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) credentials: std::option::Option<crate::model::Credentials>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>Credentials for the provided identity ID.</p>
        pub fn credentials(mut self, input: crate::model::Credentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>Credentials for the provided identity ID.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::Credentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCredentialsForIdentityOutput`](crate::output::GetCredentialsForIdentityOutput)
        pub fn build(self) -> crate::output::GetCredentialsForIdentityOutput {
            crate::output::GetCredentialsForIdentityOutput {
                identity_id: self.identity_id,
                credentials: self.credentials,
            }
        }
    }
}
impl GetCredentialsForIdentityOutput {
    /// Creates a new builder-style object to manufacture [`GetCredentialsForIdentityOutput`](crate::output::GetCredentialsForIdentityOutput)
    pub fn builder() -> crate::output::get_credentials_for_identity_output::Builder {
        crate::output::get_credentials_for_identity_output::Builder::default()
    }
}

/// <p>An object representing an Amazon Cognito identity pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityPoolOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A string that you provide.</p>
    pub identity_pool_name: std::option::Option<std::string::String>,
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub allow_unauthenticated_identities: bool,
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub allow_classic_flow: std::option::Option<bool>,
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub supported_login_providers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub developer_provider_name: std::option::Option<std::string::String>,
    /// <p>The ARNs of the OpenID Connect providers.</p>
    pub open_id_connect_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    pub cognito_identity_providers:
        std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
    /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub identity_pool_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeIdentityPoolOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>A string that you provide.</p>
    pub fn identity_pool_name(&self) -> std::option::Option<&str> {
        self.identity_pool_name.as_deref()
    }
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub fn allow_unauthenticated_identities(&self) -> bool {
        self.allow_unauthenticated_identities
    }
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub fn allow_classic_flow(&self) -> std::option::Option<bool> {
        self.allow_classic_flow
    }
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub fn supported_login_providers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.supported_login_providers.as_ref()
    }
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub fn developer_provider_name(&self) -> std::option::Option<&str> {
        self.developer_provider_name.as_deref()
    }
    /// <p>The ARNs of the OpenID Connect providers.</p>
    pub fn open_id_connect_provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.open_id_connect_provider_ar_ns.as_deref()
    }
    /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    pub fn cognito_identity_providers(
        &self,
    ) -> std::option::Option<&[crate::model::CognitoIdentityProvider]> {
        self.cognito_identity_providers.as_deref()
    }
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub fn saml_provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.saml_provider_ar_ns.as_deref()
    }
    /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
    /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub fn identity_pool_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.identity_pool_tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeIdentityPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityPoolOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_pool_name", &self.identity_pool_name);
        formatter.field(
            "allow_unauthenticated_identities",
            &self.allow_unauthenticated_identities,
        );
        formatter.field("allow_classic_flow", &self.allow_classic_flow);
        formatter.field("supported_login_providers", &self.supported_login_providers);
        formatter.field("developer_provider_name", &self.developer_provider_name);
        formatter.field(
            "open_id_connect_provider_ar_ns",
            &self.open_id_connect_provider_ar_ns,
        );
        formatter.field(
            "cognito_identity_providers",
            &self.cognito_identity_providers,
        );
        formatter.field("saml_provider_ar_ns", &self.saml_provider_ar_ns);
        formatter.field("identity_pool_tags", &self.identity_pool_tags);
        formatter.finish()
    }
}
/// See [`DescribeIdentityPoolOutput`](crate::output::DescribeIdentityPoolOutput)
pub mod describe_identity_pool_output {
    /// A builder for [`DescribeIdentityPoolOutput`](crate::output::DescribeIdentityPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_name: std::option::Option<std::string::String>,
        pub(crate) allow_unauthenticated_identities: std::option::Option<bool>,
        pub(crate) allow_classic_flow: std::option::Option<bool>,
        pub(crate) supported_login_providers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) developer_provider_name: std::option::Option<std::string::String>,
        pub(crate) open_id_connect_provider_ar_ns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cognito_identity_providers:
            std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        pub(crate) saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_name = Some(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_name = input;
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, input: bool) -> Self {
            self.allow_unauthenticated_identities = Some(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_unauthenticated_identities = input;
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, input: bool) -> Self {
            self.allow_classic_flow = Some(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_classic_flow = input;
            self
        }
        /// Adds a key-value pair to `supported_login_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.supported_login_providers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.supported_login_providers = Some(hash_map);
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.supported_login_providers = input;
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_provider_name = Some(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_provider_name = input;
            self
        }
        /// Appends an item to `open_id_connect_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.open_id_connect_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.open_id_connect_provider_ar_ns = Some(v);
            self
        }
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.open_id_connect_provider_ar_ns = input;
            self
        }
        /// Appends an item to `cognito_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn cognito_identity_providers(
            mut self,
            input: impl Into<crate::model::CognitoIdentityProvider>,
        ) -> Self {
            let mut v = self.cognito_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.cognito_identity_providers = Some(v);
            self
        }
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.cognito_identity_providers = input;
            self
        }
        /// Appends an item to `saml_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn saml_provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.saml_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.saml_provider_ar_ns = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.saml_provider_ar_ns = input;
            self
        }
        /// Adds a key-value pair to `identity_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_pool_tags = Some(hash_map);
            self
        }
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_pool_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityPoolOutput`](crate::output::DescribeIdentityPoolOutput)
        pub fn build(self) -> crate::output::DescribeIdentityPoolOutput {
            crate::output::DescribeIdentityPoolOutput {
                identity_pool_id: self.identity_pool_id,
                identity_pool_name: self.identity_pool_name,
                allow_unauthenticated_identities: self
                    .allow_unauthenticated_identities
                    .unwrap_or_default(),
                allow_classic_flow: self.allow_classic_flow,
                supported_login_providers: self.supported_login_providers,
                developer_provider_name: self.developer_provider_name,
                open_id_connect_provider_ar_ns: self.open_id_connect_provider_ar_ns,
                cognito_identity_providers: self.cognito_identity_providers,
                saml_provider_ar_ns: self.saml_provider_ar_ns,
                identity_pool_tags: self.identity_pool_tags,
            }
        }
    }
}
impl DescribeIdentityPoolOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityPoolOutput`](crate::output::DescribeIdentityPoolOutput)
    pub fn builder() -> crate::output::describe_identity_pool_output::Builder {
        crate::output::describe_identity_pool_output::Builder::default()
    }
}

/// <p>A description of the identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The provider names.</p>
    pub logins: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Date on which the identity was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Date on which the identity was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeIdentityOutput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>The provider names.</p>
    pub fn logins(&self) -> std::option::Option<&[std::string::String]> {
        self.logins.as_deref()
    }
    /// <p>Date on which the identity was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>Date on which the identity was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityOutput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("logins", &self.logins);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`DescribeIdentityOutput`](crate::output::DescribeIdentityOutput)
pub mod describe_identity_output {
    /// A builder for [`DescribeIdentityOutput`](crate::output::DescribeIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) logins: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Appends an item to `logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>The provider names.</p>
        pub fn logins(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logins.unwrap_or_default();
            v.push(input.into());
            self.logins = Some(v);
            self
        }
        /// <p>The provider names.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logins = input;
            self
        }
        /// <p>Date on which the identity was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>Date on which the identity was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Date on which the identity was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>Date on which the identity was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityOutput`](crate::output::DescribeIdentityOutput)
        pub fn build(self) -> crate::output::DescribeIdentityOutput {
            crate::output::DescribeIdentityOutput {
                identity_id: self.identity_id,
                logins: self.logins,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl DescribeIdentityOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityOutput`](crate::output::DescribeIdentityOutput)
    pub fn builder() -> crate::output::describe_identity_output::Builder {
        crate::output::describe_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityPoolOutput {}
impl std::fmt::Debug for DeleteIdentityPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityPoolOutput");
        formatter.finish()
    }
}
/// See [`DeleteIdentityPoolOutput`](crate::output::DeleteIdentityPoolOutput)
pub mod delete_identity_pool_output {
    /// A builder for [`DeleteIdentityPoolOutput`](crate::output::DeleteIdentityPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIdentityPoolOutput`](crate::output::DeleteIdentityPoolOutput)
        pub fn build(self) -> crate::output::DeleteIdentityPoolOutput {
            crate::output::DeleteIdentityPoolOutput {}
        }
    }
}
impl DeleteIdentityPoolOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityPoolOutput`](crate::output::DeleteIdentityPoolOutput)
    pub fn builder() -> crate::output::delete_identity_pool_output::Builder {
        crate::output::delete_identity_pool_output::Builder::default()
    }
}

/// <p>Returned in response to a successful <code>DeleteIdentities</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentitiesOutput {
    /// <p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and
    /// IdentityId.</p>
    pub unprocessed_identity_ids:
        std::option::Option<std::vec::Vec<crate::model::UnprocessedIdentityId>>,
}
impl DeleteIdentitiesOutput {
    /// <p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and
    /// IdentityId.</p>
    pub fn unprocessed_identity_ids(
        &self,
    ) -> std::option::Option<&[crate::model::UnprocessedIdentityId]> {
        self.unprocessed_identity_ids.as_deref()
    }
}
impl std::fmt::Debug for DeleteIdentitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentitiesOutput");
        formatter.field("unprocessed_identity_ids", &self.unprocessed_identity_ids);
        formatter.finish()
    }
}
/// See [`DeleteIdentitiesOutput`](crate::output::DeleteIdentitiesOutput)
pub mod delete_identities_output {
    /// A builder for [`DeleteIdentitiesOutput`](crate::output::DeleteIdentitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unprocessed_identity_ids:
            std::option::Option<std::vec::Vec<crate::model::UnprocessedIdentityId>>,
    }
    impl Builder {
        /// Appends an item to `unprocessed_identity_ids`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_identity_ids`](Self::set_unprocessed_identity_ids).
        ///
        /// <p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and
        /// IdentityId.</p>
        pub fn unprocessed_identity_ids(
            mut self,
            input: impl Into<crate::model::UnprocessedIdentityId>,
        ) -> Self {
            let mut v = self.unprocessed_identity_ids.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_identity_ids = Some(v);
            self
        }
        /// <p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and
        /// IdentityId.</p>
        pub fn set_unprocessed_identity_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UnprocessedIdentityId>>,
        ) -> Self {
            self.unprocessed_identity_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIdentitiesOutput`](crate::output::DeleteIdentitiesOutput)
        pub fn build(self) -> crate::output::DeleteIdentitiesOutput {
            crate::output::DeleteIdentitiesOutput {
                unprocessed_identity_ids: self.unprocessed_identity_ids,
            }
        }
    }
}
impl DeleteIdentitiesOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIdentitiesOutput`](crate::output::DeleteIdentitiesOutput)
    pub fn builder() -> crate::output::delete_identities_output::Builder {
        crate::output::delete_identities_output::Builder::default()
    }
}

/// <p>An object representing an Amazon Cognito identity pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIdentityPoolOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A string that you provide.</p>
    pub identity_pool_name: std::option::Option<std::string::String>,
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub allow_unauthenticated_identities: bool,
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub allow_classic_flow: std::option::Option<bool>,
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub supported_login_providers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub developer_provider_name: std::option::Option<std::string::String>,
    /// <p>The ARNs of the OpenID Connect providers.</p>
    pub open_id_connect_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    pub cognito_identity_providers:
        std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
    /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub identity_pool_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateIdentityPoolOutput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>A string that you provide.</p>
    pub fn identity_pool_name(&self) -> std::option::Option<&str> {
        self.identity_pool_name.as_deref()
    }
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub fn allow_unauthenticated_identities(&self) -> bool {
        self.allow_unauthenticated_identities
    }
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub fn allow_classic_flow(&self) -> std::option::Option<bool> {
        self.allow_classic_flow
    }
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub fn supported_login_providers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.supported_login_providers.as_ref()
    }
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub fn developer_provider_name(&self) -> std::option::Option<&str> {
        self.developer_provider_name.as_deref()
    }
    /// <p>The ARNs of the OpenID Connect providers.</p>
    pub fn open_id_connect_provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.open_id_connect_provider_ar_ns.as_deref()
    }
    /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    pub fn cognito_identity_providers(
        &self,
    ) -> std::option::Option<&[crate::model::CognitoIdentityProvider]> {
        self.cognito_identity_providers.as_deref()
    }
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub fn saml_provider_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.saml_provider_ar_ns.as_deref()
    }
    /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
    /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub fn identity_pool_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.identity_pool_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateIdentityPoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIdentityPoolOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_pool_name", &self.identity_pool_name);
        formatter.field(
            "allow_unauthenticated_identities",
            &self.allow_unauthenticated_identities,
        );
        formatter.field("allow_classic_flow", &self.allow_classic_flow);
        formatter.field("supported_login_providers", &self.supported_login_providers);
        formatter.field("developer_provider_name", &self.developer_provider_name);
        formatter.field(
            "open_id_connect_provider_ar_ns",
            &self.open_id_connect_provider_ar_ns,
        );
        formatter.field(
            "cognito_identity_providers",
            &self.cognito_identity_providers,
        );
        formatter.field("saml_provider_ar_ns", &self.saml_provider_ar_ns);
        formatter.field("identity_pool_tags", &self.identity_pool_tags);
        formatter.finish()
    }
}
/// See [`CreateIdentityPoolOutput`](crate::output::CreateIdentityPoolOutput)
pub mod create_identity_pool_output {
    /// A builder for [`CreateIdentityPoolOutput`](crate::output::CreateIdentityPoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_name: std::option::Option<std::string::String>,
        pub(crate) allow_unauthenticated_identities: std::option::Option<bool>,
        pub(crate) allow_classic_flow: std::option::Option<bool>,
        pub(crate) supported_login_providers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) developer_provider_name: std::option::Option<std::string::String>,
        pub(crate) open_id_connect_provider_ar_ns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cognito_identity_providers:
            std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        pub(crate) saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_name = Some(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_name = input;
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, input: bool) -> Self {
            self.allow_unauthenticated_identities = Some(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_unauthenticated_identities = input;
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, input: bool) -> Self {
            self.allow_classic_flow = Some(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_classic_flow = input;
            self
        }
        /// Adds a key-value pair to `supported_login_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.supported_login_providers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.supported_login_providers = Some(hash_map);
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.supported_login_providers = input;
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_provider_name = Some(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_provider_name = input;
            self
        }
        /// Appends an item to `open_id_connect_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.open_id_connect_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.open_id_connect_provider_ar_ns = Some(v);
            self
        }
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.open_id_connect_provider_ar_ns = input;
            self
        }
        /// Appends an item to `cognito_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn cognito_identity_providers(
            mut self,
            input: impl Into<crate::model::CognitoIdentityProvider>,
        ) -> Self {
            let mut v = self.cognito_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.cognito_identity_providers = Some(v);
            self
        }
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.cognito_identity_providers = input;
            self
        }
        /// Appends an item to `saml_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn saml_provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.saml_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.saml_provider_ar_ns = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.saml_provider_ar_ns = input;
            self
        }
        /// Adds a key-value pair to `identity_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_pool_tags = Some(hash_map);
            self
        }
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_pool_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIdentityPoolOutput`](crate::output::CreateIdentityPoolOutput)
        pub fn build(self) -> crate::output::CreateIdentityPoolOutput {
            crate::output::CreateIdentityPoolOutput {
                identity_pool_id: self.identity_pool_id,
                identity_pool_name: self.identity_pool_name,
                allow_unauthenticated_identities: self
                    .allow_unauthenticated_identities
                    .unwrap_or_default(),
                allow_classic_flow: self.allow_classic_flow,
                supported_login_providers: self.supported_login_providers,
                developer_provider_name: self.developer_provider_name,
                open_id_connect_provider_ar_ns: self.open_id_connect_provider_ar_ns,
                cognito_identity_providers: self.cognito_identity_providers,
                saml_provider_ar_ns: self.saml_provider_ar_ns,
                identity_pool_tags: self.identity_pool_tags,
            }
        }
    }
}
impl CreateIdentityPoolOutput {
    /// Creates a new builder-style object to manufacture [`CreateIdentityPoolOutput`](crate::output::CreateIdentityPoolOutput)
    pub fn builder() -> crate::output::create_identity_pool_output::Builder {
        crate::output::create_identity_pool_output::Builder::default()
    }
}
