// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A provider representing an Amazon Cognito user pool and its client ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CognitoIdentityProvider {
    /// <p>The provider name for an Amazon Cognito user pool. For example,
    /// <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The client ID for the Amazon Cognito user pool.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>TRUE if server-side token validation is enabled for the identity provider’s
    /// token.</p>
    /// <p>Once you set <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that
    /// identity pool will check with the integrated user pools to make sure that the user has not
    /// been globally signed out or deleted before the identity pool provides an OIDC token or AWS
    /// credentials for the user.</p>
    /// <p>If the user is signed out or deleted, the identity pool will return a 400 Not
    /// Authorized error.</p>
    pub server_side_token_check: std::option::Option<bool>,
}
impl std::fmt::Debug for CognitoIdentityProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CognitoIdentityProvider");
        formatter.field("provider_name", &self.provider_name);
        formatter.field("client_id", &self.client_id);
        formatter.field("server_side_token_check", &self.server_side_token_check);
        formatter.finish()
    }
}
/// See [`CognitoIdentityProvider`](crate::model::CognitoIdentityProvider)
pub mod cognito_identity_provider {
    /// A builder for [`CognitoIdentityProvider`](crate::model::CognitoIdentityProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) server_side_token_check: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The provider name for an Amazon Cognito user pool. For example,
        /// <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The provider name for an Amazon Cognito user pool. For example,
        /// <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The client ID for the Amazon Cognito user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID for the Amazon Cognito user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>TRUE if server-side token validation is enabled for the identity provider’s
        /// token.</p>
        /// <p>Once you set <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that
        /// identity pool will check with the integrated user pools to make sure that the user has not
        /// been globally signed out or deleted before the identity pool provides an OIDC token or AWS
        /// credentials for the user.</p>
        /// <p>If the user is signed out or deleted, the identity pool will return a 400 Not
        /// Authorized error.</p>
        pub fn server_side_token_check(mut self, input: bool) -> Self {
            self.server_side_token_check = Some(input);
            self
        }
        /// <p>TRUE if server-side token validation is enabled for the identity provider’s
        /// token.</p>
        /// <p>Once you set <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that
        /// identity pool will check with the integrated user pools to make sure that the user has not
        /// been globally signed out or deleted before the identity pool provides an OIDC token or AWS
        /// credentials for the user.</p>
        /// <p>If the user is signed out or deleted, the identity pool will return a 400 Not
        /// Authorized error.</p>
        pub fn set_server_side_token_check(mut self, input: std::option::Option<bool>) -> Self {
            self.server_side_token_check = input;
            self
        }
        /// Consumes the builder and constructs a [`CognitoIdentityProvider`](crate::model::CognitoIdentityProvider)
        pub fn build(self) -> crate::model::CognitoIdentityProvider {
            crate::model::CognitoIdentityProvider {
                provider_name: self.provider_name,
                client_id: self.client_id,
                server_side_token_check: self.server_side_token_check,
            }
        }
    }
}
impl CognitoIdentityProvider {
    /// Creates a new builder-style object to manufacture [`CognitoIdentityProvider`](crate::model::CognitoIdentityProvider)
    pub fn builder() -> crate::model::cognito_identity_provider::Builder {
        crate::model::cognito_identity_provider::Builder::default()
    }
}

/// <p>A role mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoleMapping {
    /// <p>The role mapping type. Token will use <code>cognito:roles</code> and
    /// <code>cognito:preferred_role</code> claims from the Cognito identity provider token to
    /// map groups to roles. Rules will attempt to match claims from the token to map to a
    /// role.</p>
    pub r#type: std::option::Option<crate::model::RoleMappingType>,
    /// <p>If you specify Token or Rules as the <code>Type</code>,
    /// <code>AmbiguousRoleResolution</code> is required.</p>
    /// <p>Specifies the action to be taken if either no rules match the claim value for the
    /// <code>Rules</code> type, or there is no <code>cognito:preferred_role</code> claim and
    /// there are multiple <code>cognito:roles</code> matches for the <code>Token</code>
    /// type.</p>
    pub ambiguous_role_resolution: std::option::Option<crate::model::AmbiguousRoleResolutionType>,
    /// <p>The rules to be used for mapping users to roles.</p>
    /// <p>If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is
    /// required.</p>
    pub rules_configuration: std::option::Option<crate::model::RulesConfigurationType>,
}
impl std::fmt::Debug for RoleMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoleMapping");
        formatter.field("r#type", &self.r#type);
        formatter.field("ambiguous_role_resolution", &self.ambiguous_role_resolution);
        formatter.field("rules_configuration", &self.rules_configuration);
        formatter.finish()
    }
}
/// See [`RoleMapping`](crate::model::RoleMapping)
pub mod role_mapping {
    /// A builder for [`RoleMapping`](crate::model::RoleMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RoleMappingType>,
        pub(crate) ambiguous_role_resolution:
            std::option::Option<crate::model::AmbiguousRoleResolutionType>,
        pub(crate) rules_configuration: std::option::Option<crate::model::RulesConfigurationType>,
    }
    impl Builder {
        /// <p>The role mapping type. Token will use <code>cognito:roles</code> and
        /// <code>cognito:preferred_role</code> claims from the Cognito identity provider token to
        /// map groups to roles. Rules will attempt to match claims from the token to map to a
        /// role.</p>
        pub fn r#type(mut self, input: crate::model::RoleMappingType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The role mapping type. Token will use <code>cognito:roles</code> and
        /// <code>cognito:preferred_role</code> claims from the Cognito identity provider token to
        /// map groups to roles. Rules will attempt to match claims from the token to map to a
        /// role.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::RoleMappingType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>If you specify Token or Rules as the <code>Type</code>,
        /// <code>AmbiguousRoleResolution</code> is required.</p>
        /// <p>Specifies the action to be taken if either no rules match the claim value for the
        /// <code>Rules</code> type, or there is no <code>cognito:preferred_role</code> claim and
        /// there are multiple <code>cognito:roles</code> matches for the <code>Token</code>
        /// type.</p>
        pub fn ambiguous_role_resolution(
            mut self,
            input: crate::model::AmbiguousRoleResolutionType,
        ) -> Self {
            self.ambiguous_role_resolution = Some(input);
            self
        }
        /// <p>If you specify Token or Rules as the <code>Type</code>,
        /// <code>AmbiguousRoleResolution</code> is required.</p>
        /// <p>Specifies the action to be taken if either no rules match the claim value for the
        /// <code>Rules</code> type, or there is no <code>cognito:preferred_role</code> claim and
        /// there are multiple <code>cognito:roles</code> matches for the <code>Token</code>
        /// type.</p>
        pub fn set_ambiguous_role_resolution(
            mut self,
            input: std::option::Option<crate::model::AmbiguousRoleResolutionType>,
        ) -> Self {
            self.ambiguous_role_resolution = input;
            self
        }
        /// <p>The rules to be used for mapping users to roles.</p>
        /// <p>If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is
        /// required.</p>
        pub fn rules_configuration(mut self, input: crate::model::RulesConfigurationType) -> Self {
            self.rules_configuration = Some(input);
            self
        }
        /// <p>The rules to be used for mapping users to roles.</p>
        /// <p>If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is
        /// required.</p>
        pub fn set_rules_configuration(
            mut self,
            input: std::option::Option<crate::model::RulesConfigurationType>,
        ) -> Self {
            self.rules_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`RoleMapping`](crate::model::RoleMapping)
        pub fn build(self) -> crate::model::RoleMapping {
            crate::model::RoleMapping {
                r#type: self.r#type,
                ambiguous_role_resolution: self.ambiguous_role_resolution,
                rules_configuration: self.rules_configuration,
            }
        }
    }
}
impl RoleMapping {
    /// Creates a new builder-style object to manufacture [`RoleMapping`](crate::model::RoleMapping)
    pub fn builder() -> crate::model::role_mapping::Builder {
        crate::model::role_mapping::Builder::default()
    }
}

/// <p>A container for rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RulesConfigurationType {
    /// <p>An array of rules. You can specify up to 25 rules per identity provider.</p>
    /// <p>Rules are evaluated in order. The first one to match specifies the role.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::MappingRule>>,
}
impl std::fmt::Debug for RulesConfigurationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RulesConfigurationType");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`RulesConfigurationType`](crate::model::RulesConfigurationType)
pub mod rules_configuration_type {
    /// A builder for [`RulesConfigurationType`](crate::model::RulesConfigurationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::MappingRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array of rules. You can specify up to 25 rules per identity provider.</p>
        /// <p>Rules are evaluated in order. The first one to match specifies the role.</p>
        pub fn rules(mut self, input: impl Into<crate::model::MappingRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>An array of rules. You can specify up to 25 rules per identity provider.</p>
        /// <p>Rules are evaluated in order. The first one to match specifies the role.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MappingRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`RulesConfigurationType`](crate::model::RulesConfigurationType)
        pub fn build(self) -> crate::model::RulesConfigurationType {
            crate::model::RulesConfigurationType { rules: self.rules }
        }
    }
}
impl RulesConfigurationType {
    /// Creates a new builder-style object to manufacture [`RulesConfigurationType`](crate::model::RulesConfigurationType)
    pub fn builder() -> crate::model::rules_configuration_type::Builder {
        crate::model::rules_configuration_type::Builder::default()
    }
}

/// <p>A rule that maps a claim name, a claim value, and a match type to a role
/// ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MappingRule {
    /// <p>The claim name that must be present in the token, for example, "isAdmin" or
    /// "paid".</p>
    pub claim: std::option::Option<std::string::String>,
    /// <p>The match condition that specifies how closely the claim value in the IdP token must
    /// match <code>Value</code>.</p>
    pub match_type: std::option::Option<crate::model::MappingRuleMatchType>,
    /// <p>A brief string that the claim must match, for example, "paid" or "yes".</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The role ARN.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MappingRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MappingRule");
        formatter.field("claim", &self.claim);
        formatter.field("match_type", &self.match_type);
        formatter.field("value", &self.value);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`MappingRule`](crate::model::MappingRule)
pub mod mapping_rule {
    /// A builder for [`MappingRule`](crate::model::MappingRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) claim: std::option::Option<std::string::String>,
        pub(crate) match_type: std::option::Option<crate::model::MappingRuleMatchType>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The claim name that must be present in the token, for example, "isAdmin" or
        /// "paid".</p>
        pub fn claim(mut self, input: impl Into<std::string::String>) -> Self {
            self.claim = Some(input.into());
            self
        }
        /// <p>The claim name that must be present in the token, for example, "isAdmin" or
        /// "paid".</p>
        pub fn set_claim(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.claim = input;
            self
        }
        /// <p>The match condition that specifies how closely the claim value in the IdP token must
        /// match <code>Value</code>.</p>
        pub fn match_type(mut self, input: crate::model::MappingRuleMatchType) -> Self {
            self.match_type = Some(input);
            self
        }
        /// <p>The match condition that specifies how closely the claim value in the IdP token must
        /// match <code>Value</code>.</p>
        pub fn set_match_type(
            mut self,
            input: std::option::Option<crate::model::MappingRuleMatchType>,
        ) -> Self {
            self.match_type = input;
            self
        }
        /// <p>A brief string that the claim must match, for example, "paid" or "yes".</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A brief string that the claim must match, for example, "paid" or "yes".</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The role ARN.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MappingRule`](crate::model::MappingRule)
        pub fn build(self) -> crate::model::MappingRule {
            crate::model::MappingRule {
                claim: self.claim,
                match_type: self.match_type,
                value: self.value,
                role_arn: self.role_arn,
            }
        }
    }
}
impl MappingRule {
    /// Creates a new builder-style object to manufacture [`MappingRule`](crate::model::MappingRule)
    pub fn builder() -> crate::model::mapping_rule::Builder {
        crate::model::mapping_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MappingRuleMatchType {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    NotEqual,
    #[allow(missing_docs)] // documentation missing in model
    StartsWith,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MappingRuleMatchType {
    fn from(s: &str) -> Self {
        match s {
            "Contains" => MappingRuleMatchType::Contains,
            "Equals" => MappingRuleMatchType::Equals,
            "NotEqual" => MappingRuleMatchType::NotEqual,
            "StartsWith" => MappingRuleMatchType::StartsWith,
            other => MappingRuleMatchType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MappingRuleMatchType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MappingRuleMatchType::from(s))
    }
}
impl MappingRuleMatchType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MappingRuleMatchType::Contains => "Contains",
            MappingRuleMatchType::Equals => "Equals",
            MappingRuleMatchType::NotEqual => "NotEqual",
            MappingRuleMatchType::StartsWith => "StartsWith",
            MappingRuleMatchType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Contains", "Equals", "NotEqual", "StartsWith"]
    }
}
impl AsRef<str> for MappingRuleMatchType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AmbiguousRoleResolutionType {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRole,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AmbiguousRoleResolutionType {
    fn from(s: &str) -> Self {
        match s {
            "AuthenticatedRole" => AmbiguousRoleResolutionType::AuthenticatedRole,
            "Deny" => AmbiguousRoleResolutionType::Deny,
            other => AmbiguousRoleResolutionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AmbiguousRoleResolutionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AmbiguousRoleResolutionType::from(s))
    }
}
impl AmbiguousRoleResolutionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AmbiguousRoleResolutionType::AuthenticatedRole => "AuthenticatedRole",
            AmbiguousRoleResolutionType::Deny => "Deny",
            AmbiguousRoleResolutionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AuthenticatedRole", "Deny"]
    }
}
impl AsRef<str> for AmbiguousRoleResolutionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RoleMappingType {
    #[allow(missing_docs)] // documentation missing in model
    Rules,
    #[allow(missing_docs)] // documentation missing in model
    Token,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RoleMappingType {
    fn from(s: &str) -> Self {
        match s {
            "Rules" => RoleMappingType::Rules,
            "Token" => RoleMappingType::Token,
            other => RoleMappingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RoleMappingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RoleMappingType::from(s))
    }
}
impl RoleMappingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RoleMappingType::Rules => "Rules",
            RoleMappingType::Token => "Token",
            RoleMappingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Rules", "Token"]
    }
}
impl AsRef<str> for RoleMappingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A description of the identity pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityPoolShortDescription {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A string that you provide.</p>
    pub identity_pool_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdentityPoolShortDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityPoolShortDescription");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_pool_name", &self.identity_pool_name);
        formatter.finish()
    }
}
/// See [`IdentityPoolShortDescription`](crate::model::IdentityPoolShortDescription)
pub mod identity_pool_short_description {
    /// A builder for [`IdentityPoolShortDescription`](crate::model::IdentityPoolShortDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_name = Some(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_name = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityPoolShortDescription`](crate::model::IdentityPoolShortDescription)
        pub fn build(self) -> crate::model::IdentityPoolShortDescription {
            crate::model::IdentityPoolShortDescription {
                identity_pool_id: self.identity_pool_id,
                identity_pool_name: self.identity_pool_name,
            }
        }
    }
}
impl IdentityPoolShortDescription {
    /// Creates a new builder-style object to manufacture [`IdentityPoolShortDescription`](crate::model::IdentityPoolShortDescription)
    pub fn builder() -> crate::model::identity_pool_short_description::Builder {
        crate::model::identity_pool_short_description::Builder::default()
    }
}

/// <p>A description of the identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityDescription {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The provider names.</p>
    pub logins: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Date on which the identity was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Date on which the identity was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for IdentityDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityDescription");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("logins", &self.logins);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`IdentityDescription`](crate::model::IdentityDescription)
pub mod identity_description {
    /// A builder for [`IdentityDescription`](crate::model::IdentityDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) logins: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Appends an item to `logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>The provider names.</p>
        pub fn logins(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logins.unwrap_or_default();
            v.push(input.into());
            self.logins = Some(v);
            self
        }
        /// <p>The provider names.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logins = input;
            self
        }
        /// <p>Date on which the identity was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>Date on which the identity was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Date on which the identity was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>Date on which the identity was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityDescription`](crate::model::IdentityDescription)
        pub fn build(self) -> crate::model::IdentityDescription {
            crate::model::IdentityDescription {
                identity_id: self.identity_id,
                logins: self.logins,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl IdentityDescription {
    /// Creates a new builder-style object to manufacture [`IdentityDescription`](crate::model::IdentityDescription)
    pub fn builder() -> crate::model::identity_description::Builder {
        crate::model::identity_description::Builder::default()
    }
}

/// <p>Credentials for the provided identity ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Credentials {
    /// <p>The Access Key portion of the credentials.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The Secret Access Key portion of the credentials</p>
    pub secret_key: std::option::Option<std::string::String>,
    /// <p>The Session Token portion of the credentials</p>
    pub session_token: std::option::Option<std::string::String>,
    /// <p>The date at which these credentials will expire.</p>
    pub expiration: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Credentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Credentials");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("secret_key", &self.secret_key);
        formatter.field("session_token", &self.session_token);
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
/// See [`Credentials`](crate::model::Credentials)
pub mod credentials {
    /// A builder for [`Credentials`](crate::model::Credentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_key: std::option::Option<std::string::String>,
        pub(crate) session_token: std::option::Option<std::string::String>,
        pub(crate) expiration: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Access Key portion of the credentials.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The Access Key portion of the credentials.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The Secret Access Key portion of the credentials</p>
        pub fn secret_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_key = Some(input.into());
            self
        }
        /// <p>The Secret Access Key portion of the credentials</p>
        pub fn set_secret_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_key = input;
            self
        }
        /// <p>The Session Token portion of the credentials</p>
        pub fn session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_token = Some(input.into());
            self
        }
        /// <p>The Session Token portion of the credentials</p>
        pub fn set_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_token = input;
            self
        }
        /// <p>The date at which these credentials will expire.</p>
        pub fn expiration(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>The date at which these credentials will expire.</p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// Consumes the builder and constructs a [`Credentials`](crate::model::Credentials)
        pub fn build(self) -> crate::model::Credentials {
            crate::model::Credentials {
                access_key_id: self.access_key_id,
                secret_key: self.secret_key,
                session_token: self.session_token,
                expiration: self.expiration,
            }
        }
    }
}
impl Credentials {
    /// Creates a new builder-style object to manufacture [`Credentials`](crate::model::Credentials)
    pub fn builder() -> crate::model::credentials::Builder {
        crate::model::credentials::Builder::default()
    }
}

/// <p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and
/// IdentityId.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedIdentityId {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The error code indicating the type of error that occurred.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
}
impl std::fmt::Debug for UnprocessedIdentityId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedIdentityId");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("error_code", &self.error_code);
        formatter.finish()
    }
}
/// See [`UnprocessedIdentityId`](crate::model::UnprocessedIdentityId)
pub mod unprocessed_identity_id {
    /// A builder for [`UnprocessedIdentityId`](crate::model::UnprocessedIdentityId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The error code indicating the type of error that occurred.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code indicating the type of error that occurred.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedIdentityId`](crate::model::UnprocessedIdentityId)
        pub fn build(self) -> crate::model::UnprocessedIdentityId {
            crate::model::UnprocessedIdentityId {
                identity_id: self.identity_id,
                error_code: self.error_code,
            }
        }
    }
}
impl UnprocessedIdentityId {
    /// Creates a new builder-style object to manufacture [`UnprocessedIdentityId`](crate::model::UnprocessedIdentityId)
    pub fn builder() -> crate::model::unprocessed_identity_id::Builder {
        crate::model::unprocessed_identity_id::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    InternalServerError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => ErrorCode::AccessDenied,
            "InternalServerError" => ErrorCode::InternalServerError,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::AccessDenied => "AccessDenied",
            ErrorCode::InternalServerError => "InternalServerError",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AccessDenied", "InternalServerError"]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
