// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateIdentityPoolInput`](crate::input::CreateIdentityPoolInput)
pub mod create_identity_pool_input {
    /// A builder for [`CreateIdentityPoolInput`](crate::input::CreateIdentityPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_name: std::option::Option<std::string::String>,
        pub(crate) allow_unauthenticated_identities: std::option::Option<bool>,
        pub(crate) allow_classic_flow: std::option::Option<bool>,
        pub(crate) supported_login_providers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) developer_provider_name: std::option::Option<std::string::String>,
        pub(crate) open_id_connect_provider_ar_ns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cognito_identity_providers:
            std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        pub(crate) saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_name = Some(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_name = input;
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, input: bool) -> Self {
            self.allow_unauthenticated_identities = Some(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_unauthenticated_identities = input;
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, input: bool) -> Self {
            self.allow_classic_flow = Some(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_classic_flow = input;
            self
        }
        /// Adds a key-value pair to `supported_login_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.supported_login_providers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.supported_login_providers = Some(hash_map);
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.supported_login_providers = input;
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This name acts as a
        /// placeholder that allows your backend and the Cognito service to communicate about the
        /// developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well
        /// as period (<code>.</code>), underscore (<code>_</code>), and dash
        /// (<code>-</code>).</p>
        /// <p>Once you have set a developer provider name, you cannot change it. Please take care
        /// in setting this parameter.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_provider_name = Some(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This name acts as a
        /// placeholder that allows your backend and the Cognito service to communicate about the
        /// developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well
        /// as period (<code>.</code>), underscore (<code>_</code>), and dash
        /// (<code>-</code>).</p>
        /// <p>Once you have set a developer provider name, you cannot change it. Please take care
        /// in setting this parameter.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_provider_name = input;
            self
        }
        /// Appends an item to `open_id_connect_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.open_id_connect_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.open_id_connect_provider_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.open_id_connect_provider_ar_ns = input;
            self
        }
        /// Appends an item to `cognito_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>An array of Amazon Cognito user pools and their client IDs.</p>
        pub fn cognito_identity_providers(
            mut self,
            input: impl Into<crate::model::CognitoIdentityProvider>,
        ) -> Self {
            let mut v = self.cognito_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.cognito_identity_providers = Some(v);
            self
        }
        /// <p>An array of Amazon Cognito user pools and their client IDs.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.cognito_identity_providers = input;
            self
        }
        /// Appends an item to `saml_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn saml_provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.saml_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.saml_provider_ar_ns = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.saml_provider_ar_ns = input;
            self
        }
        /// Adds a key-value pair to `identity_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity
        /// pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_pool_tags = Some(hash_map);
            self
        }
        /// <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity
        /// pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_pool_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIdentityPoolInput`](crate::input::CreateIdentityPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIdentityPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIdentityPoolInput {
                identity_pool_name: self.identity_pool_name,
                allow_unauthenticated_identities: self
                    .allow_unauthenticated_identities
                    .unwrap_or_default(),
                allow_classic_flow: self.allow_classic_flow,
                supported_login_providers: self.supported_login_providers,
                developer_provider_name: self.developer_provider_name,
                open_id_connect_provider_ar_ns: self.open_id_connect_provider_ar_ns,
                cognito_identity_providers: self.cognito_identity_providers,
                saml_provider_ar_ns: self.saml_provider_ar_ns,
                identity_pool_tags: self.identity_pool_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIdentityPoolInputOperationOutputAlias = crate::operation::CreateIdentityPool;
#[doc(hidden)]
pub type CreateIdentityPoolInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateIdentityPoolInput {
    /// Consumes the builder and constructs an Operation<[`CreateIdentityPool`](crate::operation::CreateIdentityPool)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIdentityPool,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIdentityPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIdentityPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIdentityPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.CreateIdentityPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_identity_pool(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIdentityPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIdentityPool",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIdentityPoolInput`](crate::input::CreateIdentityPoolInput)
    pub fn builder() -> crate::input::create_identity_pool_input::Builder {
        crate::input::create_identity_pool_input::Builder::default()
    }
}

/// See [`DeleteIdentitiesInput`](crate::input::DeleteIdentitiesInput)
pub mod delete_identities_input {
    /// A builder for [`DeleteIdentitiesInput`](crate::input::DeleteIdentitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_ids_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `identity_ids_to_delete`.
        ///
        /// To override the contents of this collection use [`set_identity_ids_to_delete`](Self::set_identity_ids_to_delete).
        ///
        /// <p>A list of 1-60 identities that you want to delete.</p>
        pub fn identity_ids_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identity_ids_to_delete.unwrap_or_default();
            v.push(input.into());
            self.identity_ids_to_delete = Some(v);
            self
        }
        /// <p>A list of 1-60 identities that you want to delete.</p>
        pub fn set_identity_ids_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identity_ids_to_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIdentitiesInput`](crate::input::DeleteIdentitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIdentitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIdentitiesInput {
                identity_ids_to_delete: self.identity_ids_to_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIdentitiesInputOperationOutputAlias = crate::operation::DeleteIdentities;
#[doc(hidden)]
pub type DeleteIdentitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIdentitiesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIdentities`](crate::operation::DeleteIdentities)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIdentities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIdentitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIdentitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIdentitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.DeleteIdentities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_identities(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIdentities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIdentities",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIdentitiesInput`](crate::input::DeleteIdentitiesInput)
    pub fn builder() -> crate::input::delete_identities_input::Builder {
        crate::input::delete_identities_input::Builder::default()
    }
}

/// See [`DeleteIdentityPoolInput`](crate::input::DeleteIdentityPoolInput)
pub mod delete_identity_pool_input {
    /// A builder for [`DeleteIdentityPoolInput`](crate::input::DeleteIdentityPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIdentityPoolInput`](crate::input::DeleteIdentityPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIdentityPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIdentityPoolInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIdentityPoolInputOperationOutputAlias = crate::operation::DeleteIdentityPool;
#[doc(hidden)]
pub type DeleteIdentityPoolInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIdentityPoolInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIdentityPool`](crate::operation::DeleteIdentityPool)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIdentityPool,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIdentityPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIdentityPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIdentityPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.DeleteIdentityPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_identity_pool(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIdentityPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIdentityPool",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIdentityPoolInput`](crate::input::DeleteIdentityPoolInput)
    pub fn builder() -> crate::input::delete_identity_pool_input::Builder {
        crate::input::delete_identity_pool_input::Builder::default()
    }
}

/// See [`DescribeIdentityInput`](crate::input::DescribeIdentityInput)
pub mod describe_identity_input {
    /// A builder for [`DescribeIdentityInput`](crate::input::DescribeIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityInput`](crate::input::DescribeIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIdentityInput {
                identity_id: self.identity_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIdentityInputOperationOutputAlias = crate::operation::DescribeIdentity;
#[doc(hidden)]
pub type DescribeIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeIdentityInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIdentity`](crate::operation::DescribeIdentity)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.DescribeIdentity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_identity(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIdentity",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIdentityInput`](crate::input::DescribeIdentityInput)
    pub fn builder() -> crate::input::describe_identity_input::Builder {
        crate::input::describe_identity_input::Builder::default()
    }
}

/// See [`DescribeIdentityPoolInput`](crate::input::DescribeIdentityPoolInput)
pub mod describe_identity_pool_input {
    /// A builder for [`DescribeIdentityPoolInput`](crate::input::DescribeIdentityPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityPoolInput`](crate::input::DescribeIdentityPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIdentityPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIdentityPoolInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIdentityPoolInputOperationOutputAlias = crate::operation::DescribeIdentityPool;
#[doc(hidden)]
pub type DescribeIdentityPoolInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeIdentityPoolInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIdentityPool`](crate::operation::DescribeIdentityPool)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIdentityPool,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIdentityPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIdentityPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIdentityPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.DescribeIdentityPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_identity_pool(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIdentityPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIdentityPool",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIdentityPoolInput`](crate::input::DescribeIdentityPoolInput)
    pub fn builder() -> crate::input::describe_identity_pool_input::Builder {
        crate::input::describe_identity_pool_input::Builder::default()
    }
}

/// See [`GetCredentialsForIdentityInput`](crate::input::GetCredentialsForIdentityInput)
pub mod get_credentials_for_identity_input {
    /// A builder for [`GetCredentialsForIdentityInput`](crate::input::GetCredentialsForIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) logins: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) custom_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Adds a key-value pair to `logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// name-value pair will follow the syntax "provider_name":
        /// "provider_user_identifier".</p>
        /// <p>Logins should not be specified when trying to get credentials for an unauthenticated
        /// identity.</p>
        /// <p>The Logins parameter is required when using identities associated with external
        /// identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code
        /// examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer
        /// Guide.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.logins.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.logins = Some(hash_map);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// name-value pair will follow the syntax "provider_name":
        /// "provider_user_identifier".</p>
        /// <p>Logins should not be specified when trying to get credentials for an unauthenticated
        /// identity.</p>
        /// <p>The Logins parameter is required when using identities associated with external
        /// identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code
        /// examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer
        /// Guide.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.logins = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
        /// received in the token from the identity provider. For example, a SAML-based identity
        /// provider. This parameter is optional for identity providers that do not support role
        /// customization.</p>
        pub fn custom_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
        /// received in the token from the identity provider. For example, a SAML-based identity
        /// provider. This parameter is optional for identity providers that do not support role
        /// customization.</p>
        pub fn set_custom_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCredentialsForIdentityInput`](crate::input::GetCredentialsForIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCredentialsForIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCredentialsForIdentityInput {
                identity_id: self.identity_id,
                logins: self.logins,
                custom_role_arn: self.custom_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCredentialsForIdentityInputOperationOutputAlias =
    crate::operation::GetCredentialsForIdentity;
#[doc(hidden)]
pub type GetCredentialsForIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCredentialsForIdentityInput {
    /// Consumes the builder and constructs an Operation<[`GetCredentialsForIdentity`](crate::operation::GetCredentialsForIdentity)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCredentialsForIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCredentialsForIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCredentialsForIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCredentialsForIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.GetCredentialsForIdentity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_credentials_for_identity(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCredentialsForIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCredentialsForIdentity",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCredentialsForIdentityInput`](crate::input::GetCredentialsForIdentityInput)
    pub fn builder() -> crate::input::get_credentials_for_identity_input::Builder {
        crate::input::get_credentials_for_identity_input::Builder::default()
    }
}

/// See [`GetIdInput`](crate::input::GetIdInput)
pub mod get_id_input {
    /// A builder for [`GetIdInput`](crate::input::GetIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) logins: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A standard AWS account ID (9+ digits).</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>A standard AWS account ID (9+ digits).</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Adds a key-value pair to `logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// available provider names for <code>Logins</code> are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>Facebook: <code>graph.facebook.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Cognito user pool:
        /// <code>cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID></code>,
        /// for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Google: <code>accounts.google.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon: <code>www.amazon.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Twitter: <code>api.twitter.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Digits: <code>www.digits.com</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.logins.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.logins = Some(hash_map);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// available provider names for <code>Logins</code> are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>Facebook: <code>graph.facebook.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Cognito user pool:
        /// <code>cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID></code>,
        /// for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Google: <code>accounts.google.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon: <code>www.amazon.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Twitter: <code>api.twitter.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Digits: <code>www.digits.com</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.logins = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdInput`](crate::input::GetIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetIdInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetIdInput {
                account_id: self.account_id,
                identity_pool_id: self.identity_pool_id,
                logins: self.logins,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdInputOperationOutputAlias = crate::operation::GetId;
#[doc(hidden)]
pub type GetIdInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIdInput {
    /// Consumes the builder and constructs an Operation<[`GetId`](crate::operation::GetId)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetId,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.GetId",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_id(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetId::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetId",
                    "cognitoidentity",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdInput`](crate::input::GetIdInput)
    pub fn builder() -> crate::input::get_id_input::Builder {
        crate::input::get_id_input::Builder::default()
    }
}

/// See [`GetIdentityPoolRolesInput`](crate::input::GetIdentityPoolRolesInput)
pub mod get_identity_pool_roles_input {
    /// A builder for [`GetIdentityPoolRolesInput`](crate::input::GetIdentityPoolRolesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityPoolRolesInput`](crate::input::GetIdentityPoolRolesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityPoolRolesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityPoolRolesInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityPoolRolesInputOperationOutputAlias = crate::operation::GetIdentityPoolRoles;
#[doc(hidden)]
pub type GetIdentityPoolRolesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIdentityPoolRolesInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityPoolRoles`](crate::operation::GetIdentityPoolRoles)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityPoolRoles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityPoolRolesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityPoolRolesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityPoolRolesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.GetIdentityPoolRoles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_identity_pool_roles(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityPoolRoles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityPoolRoles",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityPoolRolesInput`](crate::input::GetIdentityPoolRolesInput)
    pub fn builder() -> crate::input::get_identity_pool_roles_input::Builder {
        crate::input::get_identity_pool_roles_input::Builder::default()
    }
}

/// See [`GetOpenIdTokenInput`](crate::input::GetOpenIdTokenInput)
pub mod get_open_id_token_input {
    /// A builder for [`GetOpenIdTokenInput`](crate::input::GetOpenIdTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) logins: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Adds a key-value pair to `logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. When
        /// using graph.facebook.com and www.amazon.com, supply the access_token returned from the
        /// provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any
        /// other OpenID Connect provider, always include the <code>id_token</code>.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.logins.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.logins = Some(hash_map);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. When
        /// using graph.facebook.com and www.amazon.com, supply the access_token returned from the
        /// provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any
        /// other OpenID Connect provider, always include the <code>id_token</code>.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.logins = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpenIdTokenInput`](crate::input::GetOpenIdTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOpenIdTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOpenIdTokenInput {
                identity_id: self.identity_id,
                logins: self.logins,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOpenIdTokenInputOperationOutputAlias = crate::operation::GetOpenIdToken;
#[doc(hidden)]
pub type GetOpenIdTokenInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOpenIdTokenInput {
    /// Consumes the builder and constructs an Operation<[`GetOpenIdToken`](crate::operation::GetOpenIdToken)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOpenIdToken,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOpenIdTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOpenIdTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOpenIdTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.GetOpenIdToken",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_open_id_token(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOpenIdToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOpenIdToken",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOpenIdTokenInput`](crate::input::GetOpenIdTokenInput)
    pub fn builder() -> crate::input::get_open_id_token_input::Builder {
        crate::input::get_open_id_token_input::Builder::default()
    }
}

/// See [`GetOpenIdTokenForDeveloperIdentityInput`](crate::input::GetOpenIdTokenForDeveloperIdentityInput)
pub mod get_open_id_token_for_developer_identity_input {
    /// A builder for [`GetOpenIdTokenForDeveloperIdentityInput`](crate::input::GetOpenIdTokenForDeveloperIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) logins: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) principal_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) token_duration: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Adds a key-value pair to `logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. Each
        /// name-value pair represents a user from a public provider or developer provider. If the user
        /// is from a developer provider, the name-value pair will follow the syntax
        /// <code>"developer_provider_name": "developer_user_identifier"</code>. The developer
        /// provider is the "domain" by which Cognito will refer to your users; you provided this
        /// domain while creating/updating the identity pool. The developer user identifier is an
        /// identifier from your backend that uniquely identifies a user. When you create an identity
        /// pool, you can specify the supported logins.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.logins.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.logins = Some(hash_map);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. Each
        /// name-value pair represents a user from a public provider or developer provider. If the user
        /// is from a developer provider, the name-value pair will follow the syntax
        /// <code>"developer_provider_name": "developer_user_identifier"</code>. The developer
        /// provider is the "domain" by which Cognito will refer to your users; you provided this
        /// domain while creating/updating the identity pool. The developer user identifier is an
        /// identifier from your backend that uniquely identifies a user. When you create an identity
        /// pool, you can specify the supported logins.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.logins = input;
            self
        }
        /// Adds a key-value pair to `principal_tags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>Use this operation to configure attribute mappings for custom providers. </p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.principal_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.principal_tags = Some(hash_map);
            self
        }
        /// <p>Use this operation to configure attribute mappings for custom providers. </p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.principal_tags = input;
            self
        }
        /// <p>The expiration time of the token, in seconds. You can specify a custom expiration
        /// time for the token so that you can cache it. If you don't provide an expiration time, the
        /// token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
        /// credentials, which are valid for a maximum of one hour. The maximum token duration you can
        /// set is 24 hours. You should take care in setting the expiration time for a token, as there
        /// are significant security implications: an attacker could use a leaked token to access your
        /// AWS resources for the token's duration.</p>
        /// <note>
        /// <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>
        /// </note>
        pub fn token_duration(mut self, input: i64) -> Self {
            self.token_duration = Some(input);
            self
        }
        /// <p>The expiration time of the token, in seconds. You can specify a custom expiration
        /// time for the token so that you can cache it. If you don't provide an expiration time, the
        /// token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
        /// credentials, which are valid for a maximum of one hour. The maximum token duration you can
        /// set is 24 hours. You should take care in setting the expiration time for a token, as there
        /// are significant security implications: an attacker could use a leaked token to access your
        /// AWS resources for the token's duration.</p>
        /// <note>
        /// <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>
        /// </note>
        pub fn set_token_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.token_duration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpenIdTokenForDeveloperIdentityInput`](crate::input::GetOpenIdTokenForDeveloperIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOpenIdTokenForDeveloperIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOpenIdTokenForDeveloperIdentityInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                logins: self.logins,
                principal_tags: self.principal_tags,
                token_duration: self.token_duration,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOpenIdTokenForDeveloperIdentityInputOperationOutputAlias =
    crate::operation::GetOpenIdTokenForDeveloperIdentity;
#[doc(hidden)]
pub type GetOpenIdTokenForDeveloperIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOpenIdTokenForDeveloperIdentityInput {
    /// Consumes the builder and constructs an Operation<[`GetOpenIdTokenForDeveloperIdentity`](crate::operation::GetOpenIdTokenForDeveloperIdentity)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOpenIdTokenForDeveloperIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOpenIdTokenForDeveloperIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOpenIdTokenForDeveloperIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOpenIdTokenForDeveloperIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.GetOpenIdTokenForDeveloperIdentity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_open_id_token_for_developer_identity(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOpenIdTokenForDeveloperIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOpenIdTokenForDeveloperIdentity",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOpenIdTokenForDeveloperIdentityInput`](crate::input::GetOpenIdTokenForDeveloperIdentityInput)
    pub fn builder() -> crate::input::get_open_id_token_for_developer_identity_input::Builder {
        crate::input::get_open_id_token_for_developer_identity_input::Builder::default()
    }
}

/// See [`GetPrincipalTagAttributeMapInput`](crate::input::GetPrincipalTagAttributeMapInput)
pub mod get_principal_tag_attribute_map_input {
    /// A builder for [`GetPrincipalTagAttributeMapInput`](crate::input::GetPrincipalTagAttributeMapInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPrincipalTagAttributeMapInput`](crate::input::GetPrincipalTagAttributeMapInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPrincipalTagAttributeMapInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPrincipalTagAttributeMapInput {
                identity_pool_id: self.identity_pool_id,
                identity_provider_name: self.identity_provider_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPrincipalTagAttributeMapInputOperationOutputAlias =
    crate::operation::GetPrincipalTagAttributeMap;
#[doc(hidden)]
pub type GetPrincipalTagAttributeMapInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPrincipalTagAttributeMapInput {
    /// Consumes the builder and constructs an Operation<[`GetPrincipalTagAttributeMap`](crate::operation::GetPrincipalTagAttributeMap)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPrincipalTagAttributeMap,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPrincipalTagAttributeMapInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPrincipalTagAttributeMapInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPrincipalTagAttributeMapInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.GetPrincipalTagAttributeMap",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_principal_tag_attribute_map(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPrincipalTagAttributeMap::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPrincipalTagAttributeMap",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPrincipalTagAttributeMapInput`](crate::input::GetPrincipalTagAttributeMapInput)
    pub fn builder() -> crate::input::get_principal_tag_attribute_map_input::Builder {
        crate::input::get_principal_tag_attribute_map_input::Builder::default()
    }
}

/// See [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
pub mod list_identities_input {
    /// A builder for [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) hide_disabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>An optional boolean parameter that allows you to hide disabled identities. If
        /// omitted, the ListIdentities API will include disabled identities in the response.</p>
        pub fn hide_disabled(mut self, input: bool) -> Self {
            self.hide_disabled = Some(input);
            self
        }
        /// <p>An optional boolean parameter that allows you to hide disabled identities. If
        /// omitted, the ListIdentities API will include disabled identities in the response.</p>
        pub fn set_hide_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.hide_disabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentitiesInput {
                identity_pool_id: self.identity_pool_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                hide_disabled: self.hide_disabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentitiesInputOperationOutputAlias = crate::operation::ListIdentities;
#[doc(hidden)]
pub type ListIdentitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListIdentitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentities`](crate::operation::ListIdentities)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIdentitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIdentitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIdentitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.ListIdentities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_identities(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentities",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
    pub fn builder() -> crate::input::list_identities_input::Builder {
        crate::input::list_identities_input::Builder::default()
    }
}

/// See [`ListIdentityPoolsInput`](crate::input::ListIdentityPoolsInput)
pub mod list_identity_pools_input {
    /// A builder for [`ListIdentityPoolsInput`](crate::input::ListIdentityPoolsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityPoolsInput`](crate::input::ListIdentityPoolsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentityPoolsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentityPoolsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentityPoolsInputOperationOutputAlias = crate::operation::ListIdentityPools;
#[doc(hidden)]
pub type ListIdentityPoolsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListIdentityPoolsInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentityPools`](crate::operation::ListIdentityPools)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentityPools,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIdentityPoolsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIdentityPoolsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIdentityPoolsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.ListIdentityPools",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_identity_pools(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentityPools::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentityPools",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIdentityPoolsInput`](crate::input::ListIdentityPoolsInput)
    pub fn builder() -> crate::input::list_identity_pools_input::Builder {
        crate::input::list_identity_pools_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned
        /// to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned
        /// to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`LookupDeveloperIdentityInput`](crate::input::LookupDeveloperIdentityInput)
pub mod lookup_developer_identity_input {
    /// A builder for [`LookupDeveloperIdentityInput`](crate::input::LookupDeveloperIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) developer_user_identifier: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.
        /// Typically, a developer identity provider would issue many developer user identifiers, in
        /// keeping with the number of users.</p>
        pub fn developer_user_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_user_identifier = Some(input.into());
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.
        /// Typically, a developer identity provider would issue many developer user identifiers, in
        /// keeping with the number of users.</p>
        pub fn set_developer_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_user_identifier = input;
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
        /// null. After that the service will return <code>NextToken</code> values as needed. For
        /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
        /// 20 matches in the database. The service will return a pagination token as a part of the
        /// response. This token can be used to call the API again and get results starting from the
        /// 11th match.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
        /// null. After that the service will return <code>NextToken</code> values as needed. For
        /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
        /// 20 matches in the database. The service will return a pagination token as a part of the
        /// response. This token can be used to call the API again and get results starting from the
        /// 11th match.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupDeveloperIdentityInput`](crate::input::LookupDeveloperIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::LookupDeveloperIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::LookupDeveloperIdentityInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                developer_user_identifier: self.developer_user_identifier,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type LookupDeveloperIdentityInputOperationOutputAlias =
    crate::operation::LookupDeveloperIdentity;
#[doc(hidden)]
pub type LookupDeveloperIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl LookupDeveloperIdentityInput {
    /// Consumes the builder and constructs an Operation<[`LookupDeveloperIdentity`](crate::operation::LookupDeveloperIdentity)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::LookupDeveloperIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::LookupDeveloperIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::LookupDeveloperIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::LookupDeveloperIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.LookupDeveloperIdentity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_lookup_developer_identity(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::LookupDeveloperIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "LookupDeveloperIdentity",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`LookupDeveloperIdentityInput`](crate::input::LookupDeveloperIdentityInput)
    pub fn builder() -> crate::input::lookup_developer_identity_input::Builder {
        crate::input::lookup_developer_identity_input::Builder::default()
    }
}

/// See [`MergeDeveloperIdentitiesInput`](crate::input::MergeDeveloperIdentitiesInput)
pub mod merge_developer_identities_input {
    /// A builder for [`MergeDeveloperIdentitiesInput`](crate::input::MergeDeveloperIdentitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_user_identifier: std::option::Option<std::string::String>,
        pub(crate) destination_user_identifier: std::option::Option<std::string::String>,
        pub(crate) developer_provider_name: std::option::Option<std::string::String>,
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>User identifier for the source user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn source_user_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_user_identifier = Some(input.into());
            self
        }
        /// <p>User identifier for the source user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn set_source_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_user_identifier = input;
            self
        }
        /// <p>User identifier for the destination user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn destination_user_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_user_identifier = Some(input.into());
            self
        }
        /// <p>User identifier for the destination user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn set_destination_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_user_identifier = input;
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
        /// name that you provide while creating an identity pool. This name acts as a placeholder that
        /// allows your backend and the Cognito service to communicate about the developer provider.
        /// For the <code>DeveloperProviderName</code>, you can use letters as well as period (.),
        /// underscore (_), and dash (-).</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_provider_name = Some(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
        /// name that you provide while creating an identity pool. This name acts as a placeholder that
        /// allows your backend and the Cognito service to communicate about the developer provider.
        /// For the <code>DeveloperProviderName</code>, you can use letters as well as period (.),
        /// underscore (_), and dash (-).</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_provider_name = input;
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeDeveloperIdentitiesInput`](crate::input::MergeDeveloperIdentitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergeDeveloperIdentitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergeDeveloperIdentitiesInput {
                source_user_identifier: self.source_user_identifier,
                destination_user_identifier: self.destination_user_identifier,
                developer_provider_name: self.developer_provider_name,
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type MergeDeveloperIdentitiesInputOperationOutputAlias =
    crate::operation::MergeDeveloperIdentities;
#[doc(hidden)]
pub type MergeDeveloperIdentitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl MergeDeveloperIdentitiesInput {
    /// Consumes the builder and constructs an Operation<[`MergeDeveloperIdentities`](crate::operation::MergeDeveloperIdentities)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergeDeveloperIdentities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MergeDeveloperIdentitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MergeDeveloperIdentitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MergeDeveloperIdentitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.MergeDeveloperIdentities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_merge_developer_identities(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergeDeveloperIdentities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergeDeveloperIdentities",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MergeDeveloperIdentitiesInput`](crate::input::MergeDeveloperIdentitiesInput)
    pub fn builder() -> crate::input::merge_developer_identities_input::Builder {
        crate::input::merge_developer_identities_input::Builder::default()
    }
}

/// See [`SetIdentityPoolRolesInput`](crate::input::SetIdentityPoolRolesInput)
pub mod set_identity_pool_roles_input {
    /// A builder for [`SetIdentityPoolRolesInput`](crate::input::SetIdentityPoolRolesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) roles: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) role_mappings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
        >,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Adds a key-value pair to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>The map of roles associated with this pool. For a given role, the key will be either
        /// "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
        pub fn roles(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.roles.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.roles = Some(hash_map);
            self
        }
        /// <p>The map of roles associated with this pool. For a given role, the key will be either
        /// "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Adds a key-value pair to `role_mappings`.
        ///
        /// To override the contents of this collection use [`set_role_mappings`](Self::set_role_mappings).
        ///
        /// <p>How users for a specific identity provider are to mapped to roles. This is a string
        /// to <a>RoleMapping</a> object map. The string identifies the identity provider,
        /// for example, "graph.facebook.com" or
        /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        /// <p>Up to 25 rules can be specified per identity provider.</p>
        pub fn role_mappings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RoleMapping>,
        ) -> Self {
            let mut hash_map = self.role_mappings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.role_mappings = Some(hash_map);
            self
        }
        /// <p>How users for a specific identity provider are to mapped to roles. This is a string
        /// to <a>RoleMapping</a> object map. The string identifies the identity provider,
        /// for example, "graph.facebook.com" or
        /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        /// <p>Up to 25 rules can be specified per identity provider.</p>
        pub fn set_role_mappings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
            >,
        ) -> Self {
            self.role_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityPoolRolesInput`](crate::input::SetIdentityPoolRolesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIdentityPoolRolesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetIdentityPoolRolesInput {
                identity_pool_id: self.identity_pool_id,
                roles: self.roles,
                role_mappings: self.role_mappings,
            })
        }
    }
}
#[doc(hidden)]
pub type SetIdentityPoolRolesInputOperationOutputAlias = crate::operation::SetIdentityPoolRoles;
#[doc(hidden)]
pub type SetIdentityPoolRolesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetIdentityPoolRolesInput {
    /// Consumes the builder and constructs an Operation<[`SetIdentityPoolRoles`](crate::operation::SetIdentityPoolRoles)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIdentityPoolRoles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIdentityPoolRolesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIdentityPoolRolesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIdentityPoolRolesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.SetIdentityPoolRoles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_identity_pool_roles(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIdentityPoolRoles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIdentityPoolRoles",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIdentityPoolRolesInput`](crate::input::SetIdentityPoolRolesInput)
    pub fn builder() -> crate::input::set_identity_pool_roles_input::Builder {
        crate::input::set_identity_pool_roles_input::Builder::default()
    }
}

/// See [`SetPrincipalTagAttributeMapInput`](crate::input::SetPrincipalTagAttributeMapInput)
pub mod set_principal_tag_attribute_map_input {
    /// A builder for [`SetPrincipalTagAttributeMapInput`](crate::input::SetPrincipalTagAttributeMapInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
        pub(crate) use_defaults: std::option::Option<bool>,
        pub(crate) principal_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
        pub fn use_defaults(mut self, input: bool) -> Self {
            self.use_defaults = Some(input);
            self
        }
        /// <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
        pub fn set_use_defaults(mut self, input: std::option::Option<bool>) -> Self {
            self.use_defaults = input;
            self
        }
        /// Adds a key-value pair to `principal_tags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>You can use this operation to add principal tags.</p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.principal_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.principal_tags = Some(hash_map);
            self
        }
        /// <p>You can use this operation to add principal tags.</p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.principal_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SetPrincipalTagAttributeMapInput`](crate::input::SetPrincipalTagAttributeMapInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetPrincipalTagAttributeMapInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetPrincipalTagAttributeMapInput {
                identity_pool_id: self.identity_pool_id,
                identity_provider_name: self.identity_provider_name,
                use_defaults: self.use_defaults,
                principal_tags: self.principal_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type SetPrincipalTagAttributeMapInputOperationOutputAlias =
    crate::operation::SetPrincipalTagAttributeMap;
#[doc(hidden)]
pub type SetPrincipalTagAttributeMapInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetPrincipalTagAttributeMapInput {
    /// Consumes the builder and constructs an Operation<[`SetPrincipalTagAttributeMap`](crate::operation::SetPrincipalTagAttributeMap)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetPrincipalTagAttributeMap,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetPrincipalTagAttributeMapInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetPrincipalTagAttributeMapInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetPrincipalTagAttributeMapInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.SetPrincipalTagAttributeMap",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_principal_tag_attribute_map(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetPrincipalTagAttributeMap::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetPrincipalTagAttributeMap",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetPrincipalTagAttributeMapInput`](crate::input::SetPrincipalTagAttributeMapInput)
    pub fn builder() -> crate::input::set_principal_tag_attribute_map_input::Builder {
        crate::input::set_principal_tag_attribute_map_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the identity pool.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the identity pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UnlinkDeveloperIdentityInput`](crate::input::UnlinkDeveloperIdentityInput)
pub mod unlink_developer_identity_input {
    /// A builder for [`UnlinkDeveloperIdentityInput`](crate::input::UnlinkDeveloperIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) developer_provider_name: std::option::Option<std::string::String>,
        pub(crate) developer_user_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_provider_name = Some(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_provider_name = input;
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.</p>
        pub fn developer_user_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_user_identifier = Some(input.into());
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.</p>
        pub fn set_developer_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_user_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`UnlinkDeveloperIdentityInput`](crate::input::UnlinkDeveloperIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnlinkDeveloperIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnlinkDeveloperIdentityInput {
                identity_id: self.identity_id,
                identity_pool_id: self.identity_pool_id,
                developer_provider_name: self.developer_provider_name,
                developer_user_identifier: self.developer_user_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type UnlinkDeveloperIdentityInputOperationOutputAlias =
    crate::operation::UnlinkDeveloperIdentity;
#[doc(hidden)]
pub type UnlinkDeveloperIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnlinkDeveloperIdentityInput {
    /// Consumes the builder and constructs an Operation<[`UnlinkDeveloperIdentity`](crate::operation::UnlinkDeveloperIdentity)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnlinkDeveloperIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnlinkDeveloperIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnlinkDeveloperIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnlinkDeveloperIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.UnlinkDeveloperIdentity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_unlink_developer_identity(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnlinkDeveloperIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnlinkDeveloperIdentity",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnlinkDeveloperIdentityInput`](crate::input::UnlinkDeveloperIdentityInput)
    pub fn builder() -> crate::input::unlink_developer_identity_input::Builder {
        crate::input::unlink_developer_identity_input::Builder::default()
    }
}

/// See [`UnlinkIdentityInput`](crate::input::UnlinkIdentityInput)
pub mod unlink_identity_input {
    /// A builder for [`UnlinkIdentityInput`](crate::input::UnlinkIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) logins: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) logins_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Adds a key-value pair to `logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider
        /// tokens.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.logins.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.logins = Some(hash_map);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider
        /// tokens.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.logins = input;
            self
        }
        /// Appends an item to `logins_to_remove`.
        ///
        /// To override the contents of this collection use [`set_logins_to_remove`](Self::set_logins_to_remove).
        ///
        /// <p>Provider names to unlink from this identity.</p>
        pub fn logins_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logins_to_remove.unwrap_or_default();
            v.push(input.into());
            self.logins_to_remove = Some(v);
            self
        }
        /// <p>Provider names to unlink from this identity.</p>
        pub fn set_logins_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logins_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`UnlinkIdentityInput`](crate::input::UnlinkIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnlinkIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnlinkIdentityInput {
                identity_id: self.identity_id,
                logins: self.logins,
                logins_to_remove: self.logins_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type UnlinkIdentityInputOperationOutputAlias = crate::operation::UnlinkIdentity;
#[doc(hidden)]
pub type UnlinkIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnlinkIdentityInput {
    /// Consumes the builder and constructs an Operation<[`UnlinkIdentity`](crate::operation::UnlinkIdentity)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnlinkIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnlinkIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnlinkIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnlinkIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.UnlinkIdentity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_unlink_identity(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnlinkIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnlinkIdentity",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnlinkIdentityInput`](crate::input::UnlinkIdentityInput)
    pub fn builder() -> crate::input::unlink_identity_input::Builder {
        crate::input::unlink_identity_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateIdentityPoolInput`](crate::input::UpdateIdentityPoolInput)
pub mod update_identity_pool_input {
    /// A builder for [`UpdateIdentityPoolInput`](crate::input::UpdateIdentityPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_name: std::option::Option<std::string::String>,
        pub(crate) allow_unauthenticated_identities: std::option::Option<bool>,
        pub(crate) allow_classic_flow: std::option::Option<bool>,
        pub(crate) supported_login_providers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) developer_provider_name: std::option::Option<std::string::String>,
        pub(crate) open_id_connect_provider_ar_ns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cognito_identity_providers:
            std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        pub(crate) saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) identity_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_name = Some(input.into());
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_name = input;
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, input: bool) -> Self {
            self.allow_unauthenticated_identities = Some(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_unauthenticated_identities = input;
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, input: bool) -> Self {
            self.allow_classic_flow = Some(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_classic_flow = input;
            self
        }
        /// Adds a key-value pair to `supported_login_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.supported_login_providers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.supported_login_providers = Some(hash_map);
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.supported_login_providers = input;
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.developer_provider_name = Some(input.into());
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.developer_provider_name = input;
            self
        }
        /// Appends an item to `open_id_connect_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.open_id_connect_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.open_id_connect_provider_ar_ns = Some(v);
            self
        }
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.open_id_connect_provider_ar_ns = input;
            self
        }
        /// Appends an item to `cognito_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn cognito_identity_providers(
            mut self,
            input: impl Into<crate::model::CognitoIdentityProvider>,
        ) -> Self {
            let mut v = self.cognito_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.cognito_identity_providers = Some(v);
            self
        }
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.cognito_identity_providers = input;
            self
        }
        /// Appends an item to `saml_provider_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn saml_provider_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.saml_provider_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.saml_provider_ar_ns = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.saml_provider_ar_ns = input;
            self
        }
        /// Adds a key-value pair to `identity_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_pool_tags = Some(hash_map);
            self
        }
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_pool_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIdentityPoolInput`](crate::input::UpdateIdentityPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIdentityPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIdentityPoolInput {
                identity_pool_id: self.identity_pool_id,
                identity_pool_name: self.identity_pool_name,
                allow_unauthenticated_identities: self
                    .allow_unauthenticated_identities
                    .unwrap_or_default(),
                allow_classic_flow: self.allow_classic_flow,
                supported_login_providers: self.supported_login_providers,
                developer_provider_name: self.developer_provider_name,
                open_id_connect_provider_ar_ns: self.open_id_connect_provider_ar_ns,
                cognito_identity_providers: self.cognito_identity_providers,
                saml_provider_ar_ns: self.saml_provider_ar_ns,
                identity_pool_tags: self.identity_pool_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIdentityPoolInputOperationOutputAlias = crate::operation::UpdateIdentityPool;
#[doc(hidden)]
pub type UpdateIdentityPoolInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateIdentityPoolInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIdentityPool`](crate::operation::UpdateIdentityPool)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIdentityPool,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateIdentityPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateIdentityPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateIdentityPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityService.UpdateIdentityPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_identity_pool(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIdentityPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIdentityPool",
            "cognitoidentity",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateIdentityPoolInput`](crate::input::UpdateIdentityPoolInput)
    pub fn builder() -> crate::input::update_identity_pool_input::Builder {
        crate::input::update_identity_pool_input::Builder::default()
    }
}

/// <p>An object representing an Amazon Cognito identity pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIdentityPoolInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A string that you provide.</p>
    pub identity_pool_name: std::option::Option<std::string::String>,
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub allow_unauthenticated_identities: bool,
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub allow_classic_flow: std::option::Option<bool>,
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub supported_login_providers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub developer_provider_name: std::option::Option<std::string::String>,
    /// <p>The ARNs of the OpenID Connect providers.</p>
    pub open_id_connect_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
    pub cognito_identity_providers:
        std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
    /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub identity_pool_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for UpdateIdentityPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIdentityPoolInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_pool_name", &self.identity_pool_name);
        formatter.field(
            "allow_unauthenticated_identities",
            &self.allow_unauthenticated_identities,
        );
        formatter.field("allow_classic_flow", &self.allow_classic_flow);
        formatter.field("supported_login_providers", &self.supported_login_providers);
        formatter.field("developer_provider_name", &self.developer_provider_name);
        formatter.field(
            "open_id_connect_provider_ar_ns",
            &self.open_id_connect_provider_ar_ns,
        );
        formatter.field(
            "cognito_identity_providers",
            &self.cognito_identity_providers,
        );
        formatter.field("saml_provider_ar_ns", &self.saml_provider_ar_ns);
        formatter.field("identity_pool_tags", &self.identity_pool_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to remove from the user pool.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Input to the UnlinkIdentity action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnlinkIdentityInput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>A set of optional name-value pairs that map provider names to provider
    /// tokens.</p>
    pub logins:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Provider names to unlink from this identity.</p>
    pub logins_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UnlinkIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnlinkIdentityInput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("logins", &self.logins);
        formatter.field("logins_to_remove", &self.logins_to_remove);
        formatter.finish()
    }
}

/// <p>Input to the <code>UnlinkDeveloperIdentity</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnlinkDeveloperIdentityInput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The "domain" by which Cognito will refer to your users.</p>
    pub developer_provider_name: std::option::Option<std::string::String>,
    /// <p>A unique ID used by your backend authentication process to identify a user.</p>
    pub developer_user_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnlinkDeveloperIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnlinkDeveloperIdentityInput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("developer_provider_name", &self.developer_provider_name);
        formatter.field("developer_user_identifier", &self.developer_user_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to assign to the identity pool.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetPrincipalTagAttributeMapInput {
    /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The provider name you want to use for attribute mappings.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
    /// <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
    pub use_defaults: std::option::Option<bool>,
    /// <p>You can use this operation to add principal tags.</p>
    pub principal_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SetPrincipalTagAttributeMapInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetPrincipalTagAttributeMapInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.field("use_defaults", &self.use_defaults);
        formatter.field("principal_tags", &self.principal_tags);
        formatter.finish()
    }
}

/// <p>Input to the <code>SetIdentityPoolRoles</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityPoolRolesInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The map of roles associated with this pool. For a given role, the key will be either
    /// "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
    pub roles:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>How users for a specific identity provider are to mapped to roles. This is a string
    /// to <a>RoleMapping</a> object map. The string identifies the identity provider,
    /// for example, "graph.facebook.com" or
    /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
    /// <p>Up to 25 rules can be specified per identity provider.</p>
    pub role_mappings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
    >,
}
impl std::fmt::Debug for SetIdentityPoolRolesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityPoolRolesInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("roles", &self.roles);
        formatter.field("role_mappings", &self.role_mappings);
        formatter.finish()
    }
}

/// <p>Input to the <code>MergeDeveloperIdentities</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeDeveloperIdentitiesInput {
    /// <p>User identifier for the source user. The value should be a
    /// <code>DeveloperUserIdentifier</code>.</p>
    pub source_user_identifier: std::option::Option<std::string::String>,
    /// <p>User identifier for the destination user. The value should be a
    /// <code>DeveloperUserIdentifier</code>.</p>
    pub destination_user_identifier: std::option::Option<std::string::String>,
    /// <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
    /// name that you provide while creating an identity pool. This name acts as a placeholder that
    /// allows your backend and the Cognito service to communicate about the developer provider.
    /// For the <code>DeveloperProviderName</code>, you can use letters as well as period (.),
    /// underscore (_), and dash (-).</p>
    pub developer_provider_name: std::option::Option<std::string::String>,
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MergeDeveloperIdentitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeDeveloperIdentitiesInput");
        formatter.field("source_user_identifier", &self.source_user_identifier);
        formatter.field(
            "destination_user_identifier",
            &self.destination_user_identifier,
        );
        formatter.field("developer_provider_name", &self.developer_provider_name);
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// <p>Input to the <code>LookupDeveloperIdentityInput</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupDeveloperIdentityInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>A unique ID used by your backend authentication process to identify a user.
    /// Typically, a developer identity provider would issue many developer user identifiers, in
    /// keeping with the number of users.</p>
    pub developer_user_identifier: std::option::Option<std::string::String>,
    /// <p>The maximum number of identities to return.</p>
    pub max_results: i32,
    /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
    /// null. After that the service will return <code>NextToken</code> values as needed. For
    /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
    /// 20 matches in the database. The service will return a pagination token as a part of the
    /// response. This token can be used to call the API again and get results starting from the
    /// 11th match.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LookupDeveloperIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupDeveloperIdentityInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("developer_user_identifier", &self.developer_user_identifier);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned
    /// to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p>Input to the ListIdentityPools action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityPoolsInput {
    /// <p>The maximum number of identities to return.</p>
    pub max_results: i32,
    /// <p>A pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListIdentityPoolsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityPoolsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Input to the ListIdentities action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentitiesInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of identities to return.</p>
    pub max_results: i32,
    /// <p>A pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional boolean parameter that allows you to hide disabled identities. If
    /// omitted, the ListIdentities API will include disabled identities in the response.</p>
    pub hide_disabled: bool,
}
impl std::fmt::Debug for ListIdentitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentitiesInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("hide_disabled", &self.hide_disabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPrincipalTagAttributeMapInput {
    /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>You can use this operation to get the provider name.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPrincipalTagAttributeMapInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPrincipalTagAttributeMapInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.finish()
    }
}

/// <p>Input to the <code>GetOpenIdTokenForDeveloperIdentity</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpenIdTokenForDeveloperIdentityInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>A set of optional name-value pairs that map provider names to provider tokens. Each
    /// name-value pair represents a user from a public provider or developer provider. If the user
    /// is from a developer provider, the name-value pair will follow the syntax
    /// <code>"developer_provider_name": "developer_user_identifier"</code>. The developer
    /// provider is the "domain" by which Cognito will refer to your users; you provided this
    /// domain while creating/updating the identity pool. The developer user identifier is an
    /// identifier from your backend that uniquely identifies a user. When you create an identity
    /// pool, you can specify the supported logins.</p>
    pub logins:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Use this operation to configure attribute mappings for custom providers. </p>
    pub principal_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The expiration time of the token, in seconds. You can specify a custom expiration
    /// time for the token so that you can cache it. If you don't provide an expiration time, the
    /// token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
    /// credentials, which are valid for a maximum of one hour. The maximum token duration you can
    /// set is 24 hours. You should take care in setting the expiration time for a token, as there
    /// are significant security implications: an attacker could use a leaked token to access your
    /// AWS resources for the token's duration.</p>
    /// <note>
    /// <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>
    /// </note>
    pub token_duration: std::option::Option<i64>,
}
impl std::fmt::Debug for GetOpenIdTokenForDeveloperIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpenIdTokenForDeveloperIdentityInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("logins", &self.logins);
        formatter.field("principal_tags", &self.principal_tags);
        formatter.field("token_duration", &self.token_duration);
        formatter.finish()
    }
}

/// <p>Input to the GetOpenIdToken action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpenIdTokenInput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>A set of optional name-value pairs that map provider names to provider tokens. When
    /// using graph.facebook.com and www.amazon.com, supply the access_token returned from the
    /// provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any
    /// other OpenID Connect provider, always include the <code>id_token</code>.</p>
    pub logins:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetOpenIdTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpenIdTokenInput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("logins", &self.logins);
        formatter.finish()
    }
}

/// <p>Input to the <code>GetIdentityPoolRoles</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityPoolRolesInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetIdentityPoolRolesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityPoolRolesInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// <p>Input to the GetId action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdInput {
    /// <p>A standard AWS account ID (9+ digits).</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
    /// available provider names for <code>Logins</code> are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>Facebook: <code>graph.facebook.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Cognito user pool:
    /// <code>cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID></code>,
    /// for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>Google: <code>accounts.google.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon: <code>www.amazon.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Twitter: <code>api.twitter.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Digits: <code>www.digits.com</code>
    /// </p>
    /// </li>
    /// </ul>
    pub logins:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("logins", &self.logins);
        formatter.finish()
    }
}

/// <p>Input to the <code>GetCredentialsForIdentity</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCredentialsForIdentityInput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
    /// name-value pair will follow the syntax "provider_name":
    /// "provider_user_identifier".</p>
    /// <p>Logins should not be specified when trying to get credentials for an unauthenticated
    /// identity.</p>
    /// <p>The Logins parameter is required when using identities associated with external
    /// identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code
    /// examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer
    /// Guide.</p>
    pub logins:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
    /// received in the token from the identity provider. For example, a SAML-based identity
    /// provider. This parameter is optional for identity providers that do not support role
    /// customization.</p>
    pub custom_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCredentialsForIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCredentialsForIdentityInput");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("logins", &self.logins);
        formatter.field("custom_role_arn", &self.custom_role_arn);
        formatter.finish()
    }
}

/// <p>Input to the DescribeIdentityPool action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityPoolInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeIdentityPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityPoolInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// <p>Input to the <code>DescribeIdentity</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityInput {
    /// <p>A unique identifier in the format REGION:GUID.</p>
    pub identity_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityInput");
        formatter.field("identity_id", &self.identity_id);
        formatter.finish()
    }
}

/// <p>Input to the DeleteIdentityPool action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityPoolInput {
    /// <p>An identity pool ID in the format REGION:GUID.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteIdentityPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityPoolInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// <p>Input to the <code>DeleteIdentities</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentitiesInput {
    /// <p>A list of 1-60 identities that you want to delete.</p>
    pub identity_ids_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DeleteIdentitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentitiesInput");
        formatter.field("identity_ids_to_delete", &self.identity_ids_to_delete);
        formatter.finish()
    }
}

/// <p>Input to the CreateIdentityPool action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIdentityPoolInput {
    /// <p>A string that you provide.</p>
    pub identity_pool_name: std::option::Option<std::string::String>,
    /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
    pub allow_unauthenticated_identities: bool,
    /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
    pub allow_classic_flow: std::option::Option<bool>,
    /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
    pub supported_login_providers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The "domain" by which Cognito will refer to your users. This name acts as a
    /// placeholder that allows your backend and the Cognito service to communicate about the
    /// developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well
    /// as period (<code>.</code>), underscore (<code>_</code>), and dash
    /// (<code>-</code>).</p>
    /// <p>Once you have set a developer provider name, you cannot change it. Please take care
    /// in setting this parameter.</p>
    pub developer_provider_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
    pub open_id_connect_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of Amazon Cognito user pools and their client IDs.</p>
    pub cognito_identity_providers:
        std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
    /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
    /// pool.</p>
    pub saml_provider_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity
    /// pools to categorize and manage them in different ways, such as by purpose, owner,
    /// environment, or other criteria.</p>
    pub identity_pool_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateIdentityPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIdentityPoolInput");
        formatter.field("identity_pool_name", &self.identity_pool_name);
        formatter.field(
            "allow_unauthenticated_identities",
            &self.allow_unauthenticated_identities,
        );
        formatter.field("allow_classic_flow", &self.allow_classic_flow);
        formatter.field("supported_login_providers", &self.supported_login_providers);
        formatter.field("developer_provider_name", &self.developer_provider_name);
        formatter.field(
            "open_id_connect_provider_ar_ns",
            &self.open_id_connect_provider_ar_ns,
        );
        formatter.field(
            "cognito_identity_providers",
            &self.cognito_identity_providers,
        );
        formatter.field("saml_provider_ar_ns", &self.saml_provider_ar_ns);
        formatter.field("identity_pool_tags", &self.identity_pool_tags);
        formatter.finish()
    }
}
