// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSCognitoIdentityService`.
///
/// This client allows ergonomic access to a `AWSCognitoIdentityService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateIdentityPool` operation.
    ///
    /// See [`CreateIdentityPool`](crate::client::fluent_builders::CreateIdentityPool) for more information about the
    /// operation and its arguments.
    pub fn create_identity_pool(&self) -> fluent_builders::CreateIdentityPool<C, M, R> {
        fluent_builders::CreateIdentityPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIdentities` operation.
    ///
    /// See [`DeleteIdentities`](crate::client::fluent_builders::DeleteIdentities) for more information about the
    /// operation and its arguments.
    pub fn delete_identities(&self) -> fluent_builders::DeleteIdentities<C, M, R> {
        fluent_builders::DeleteIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIdentityPool` operation.
    ///
    /// See [`DeleteIdentityPool`](crate::client::fluent_builders::DeleteIdentityPool) for more information about the
    /// operation and its arguments.
    pub fn delete_identity_pool(&self) -> fluent_builders::DeleteIdentityPool<C, M, R> {
        fluent_builders::DeleteIdentityPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIdentity` operation.
    ///
    /// See [`DescribeIdentity`](crate::client::fluent_builders::DescribeIdentity) for more information about the
    /// operation and its arguments.
    pub fn describe_identity(&self) -> fluent_builders::DescribeIdentity<C, M, R> {
        fluent_builders::DescribeIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIdentityPool` operation.
    ///
    /// See [`DescribeIdentityPool`](crate::client::fluent_builders::DescribeIdentityPool) for more information about the
    /// operation and its arguments.
    pub fn describe_identity_pool(&self) -> fluent_builders::DescribeIdentityPool<C, M, R> {
        fluent_builders::DescribeIdentityPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCredentialsForIdentity` operation.
    ///
    /// See [`GetCredentialsForIdentity`](crate::client::fluent_builders::GetCredentialsForIdentity) for more information about the
    /// operation and its arguments.
    pub fn get_credentials_for_identity(
        &self,
    ) -> fluent_builders::GetCredentialsForIdentity<C, M, R> {
        fluent_builders::GetCredentialsForIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetId` operation.
    ///
    /// See [`GetId`](crate::client::fluent_builders::GetId) for more information about the
    /// operation and its arguments.
    pub fn get_id(&self) -> fluent_builders::GetId<C, M, R> {
        fluent_builders::GetId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityPoolRoles` operation.
    ///
    /// See [`GetIdentityPoolRoles`](crate::client::fluent_builders::GetIdentityPoolRoles) for more information about the
    /// operation and its arguments.
    pub fn get_identity_pool_roles(&self) -> fluent_builders::GetIdentityPoolRoles<C, M, R> {
        fluent_builders::GetIdentityPoolRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOpenIdToken` operation.
    ///
    /// See [`GetOpenIdToken`](crate::client::fluent_builders::GetOpenIdToken) for more information about the
    /// operation and its arguments.
    pub fn get_open_id_token(&self) -> fluent_builders::GetOpenIdToken<C, M, R> {
        fluent_builders::GetOpenIdToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOpenIdTokenForDeveloperIdentity` operation.
    ///
    /// See [`GetOpenIdTokenForDeveloperIdentity`](crate::client::fluent_builders::GetOpenIdTokenForDeveloperIdentity) for more information about the
    /// operation and its arguments.
    pub fn get_open_id_token_for_developer_identity(
        &self,
    ) -> fluent_builders::GetOpenIdTokenForDeveloperIdentity<C, M, R> {
        fluent_builders::GetOpenIdTokenForDeveloperIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPrincipalTagAttributeMap` operation.
    ///
    /// See [`GetPrincipalTagAttributeMap`](crate::client::fluent_builders::GetPrincipalTagAttributeMap) for more information about the
    /// operation and its arguments.
    pub fn get_principal_tag_attribute_map(
        &self,
    ) -> fluent_builders::GetPrincipalTagAttributeMap<C, M, R> {
        fluent_builders::GetPrincipalTagAttributeMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIdentities` operation.
    ///
    /// See [`ListIdentities`](crate::client::fluent_builders::ListIdentities) for more information about the
    /// operation and its arguments.
    pub fn list_identities(&self) -> fluent_builders::ListIdentities<C, M, R> {
        fluent_builders::ListIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIdentityPools` operation.
    ///
    /// See [`ListIdentityPools`](crate::client::fluent_builders::ListIdentityPools) for more information about the
    /// operation and its arguments.
    pub fn list_identity_pools(&self) -> fluent_builders::ListIdentityPools<C, M, R> {
        fluent_builders::ListIdentityPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `LookupDeveloperIdentity` operation.
    ///
    /// See [`LookupDeveloperIdentity`](crate::client::fluent_builders::LookupDeveloperIdentity) for more information about the
    /// operation and its arguments.
    pub fn lookup_developer_identity(&self) -> fluent_builders::LookupDeveloperIdentity<C, M, R> {
        fluent_builders::LookupDeveloperIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergeDeveloperIdentities` operation.
    ///
    /// See [`MergeDeveloperIdentities`](crate::client::fluent_builders::MergeDeveloperIdentities) for more information about the
    /// operation and its arguments.
    pub fn merge_developer_identities(&self) -> fluent_builders::MergeDeveloperIdentities<C, M, R> {
        fluent_builders::MergeDeveloperIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIdentityPoolRoles` operation.
    ///
    /// See [`SetIdentityPoolRoles`](crate::client::fluent_builders::SetIdentityPoolRoles) for more information about the
    /// operation and its arguments.
    pub fn set_identity_pool_roles(&self) -> fluent_builders::SetIdentityPoolRoles<C, M, R> {
        fluent_builders::SetIdentityPoolRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetPrincipalTagAttributeMap` operation.
    ///
    /// See [`SetPrincipalTagAttributeMap`](crate::client::fluent_builders::SetPrincipalTagAttributeMap) for more information about the
    /// operation and its arguments.
    pub fn set_principal_tag_attribute_map(
        &self,
    ) -> fluent_builders::SetPrincipalTagAttributeMap<C, M, R> {
        fluent_builders::SetPrincipalTagAttributeMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnlinkDeveloperIdentity` operation.
    ///
    /// See [`UnlinkDeveloperIdentity`](crate::client::fluent_builders::UnlinkDeveloperIdentity) for more information about the
    /// operation and its arguments.
    pub fn unlink_developer_identity(&self) -> fluent_builders::UnlinkDeveloperIdentity<C, M, R> {
        fluent_builders::UnlinkDeveloperIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnlinkIdentity` operation.
    ///
    /// See [`UnlinkIdentity`](crate::client::fluent_builders::UnlinkIdentity) for more information about the
    /// operation and its arguments.
    pub fn unlink_identity(&self) -> fluent_builders::UnlinkIdentity<C, M, R> {
        fluent_builders::UnlinkIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIdentityPool` operation.
    ///
    /// See [`UpdateIdentityPool`](crate::client::fluent_builders::UpdateIdentityPool) for more information about the
    /// operation and its arguments.
    pub fn update_identity_pool(&self) -> fluent_builders::UpdateIdentityPool<C, M, R> {
        fluent_builders::UpdateIdentityPool::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateIdentityPool`.
    ///
    /// <p>Creates a new identity pool. The identity pool is a store of user identity
    /// information that is specific to your AWS account. The keys for <code>SupportedLoginProviders</code> are as follows:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Facebook: <code>graph.facebook.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Google: <code>accounts.google.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon: <code>www.amazon.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Twitter: <code>api.twitter.com</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Digits: <code>www.digits.com</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIdentityPool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_identity_pool_input::Builder,
    }
    impl<C, M, R> CreateIdentityPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIdentityPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIdentityPoolInputOperationOutputAlias,
                crate::output::CreateIdentityPoolOutput,
                crate::error::CreateIdentityPoolError,
                crate::input::CreateIdentityPoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_name(inp);
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_name(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_unauthenticated_identities(inp);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allow_unauthenticated_identities(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_classic_flow(inp);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_classic_flow(input);
            self
        }
        /// Adds a key-value pair to `SupportedLoginProviders`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.supported_login_providers(k, v);
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_supported_login_providers(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This name acts as a
        /// placeholder that allows your backend and the Cognito service to communicate about the
        /// developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well
        /// as period (<code>.</code>), underscore (<code>_</code>), and dash
        /// (<code>-</code>).</p>
        /// <p>Once you have set a developer provider name, you cannot change it. Please take care
        /// in setting this parameter.</p>
        pub fn developer_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(inp);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This name acts as a
        /// placeholder that allows your backend and the Cognito service to communicate about the
        /// developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well
        /// as period (<code>.</code>), underscore (<code>_</code>), and dash
        /// (<code>-</code>).</p>
        /// <p>Once you have set a developer provider name, you cannot change it. Please take care
        /// in setting this parameter.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// Appends an item to `OpenIdConnectProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.open_id_connect_provider_ar_ns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_ar_ns(input);
            self
        }
        /// Appends an item to `CognitoIdentityProviders`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>An array of Amazon Cognito user pools and their client IDs.</p>
        pub fn cognito_identity_providers(
            mut self,
            inp: impl Into<crate::model::CognitoIdentityProvider>,
        ) -> Self {
            self.inner = self.inner.cognito_identity_providers(inp);
            self
        }
        /// <p>An array of Amazon Cognito user pools and their client IDs.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.inner = self.inner.set_cognito_identity_providers(input);
            self
        }
        /// Appends an item to `SamlProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn saml_provider_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_ar_ns(inp);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_ar_ns(input);
            self
        }
        /// Adds a key-value pair to `IdentityPoolTags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity
        /// pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_pool_tags(k, v);
            self
        }
        /// <p>Tags to assign to the identity pool. A tag is a label that you can apply to identity
        /// pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentities`.
    ///
    /// <p>Deletes identities from an identity pool. You can specify a list of 1-60 identities
    /// that you want to delete.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIdentities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_identities_input::Builder,
    }
    impl<C, M, R> DeleteIdentities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIdentitiesInputOperationOutputAlias,
                crate::output::DeleteIdentitiesOutput,
                crate::error::DeleteIdentitiesError,
                crate::input::DeleteIdentitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `IdentityIdsToDelete`.
        ///
        /// To override the contents of this collection use [`set_identity_ids_to_delete`](Self::set_identity_ids_to_delete).
        ///
        /// <p>A list of 1-60 identities that you want to delete.</p>
        pub fn identity_ids_to_delete(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_ids_to_delete(inp);
            self
        }
        /// <p>A list of 1-60 identities that you want to delete.</p>
        pub fn set_identity_ids_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identity_ids_to_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentityPool`.
    ///
    /// <p>Deletes an identity pool. Once a pool is deleted, users will not be able to
    /// authenticate with the pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIdentityPool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_identity_pool_input::Builder,
    }
    impl<C, M, R> DeleteIdentityPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIdentityPoolInputOperationOutputAlias,
                crate::output::DeleteIdentityPoolOutput,
                crate::error::DeleteIdentityPoolError,
                crate::input::DeleteIdentityPoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentity`.
    ///
    /// <p>Returns metadata related to the given identity, including when the identity was
    /// created and any associated linked logins.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_identity_input::Builder,
    }
    impl<C, M, R> DescribeIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIdentityInputOperationOutputAlias,
                crate::output::DescribeIdentityOutput,
                crate::error::DescribeIdentityError,
                crate::input::DescribeIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityPool`.
    ///
    /// <p>Gets details about a particular identity pool, including the pool name, ID
    /// description, creation date, and current number of users.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIdentityPool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_identity_pool_input::Builder,
    }
    impl<C, M, R> DescribeIdentityPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIdentityPoolInputOperationOutputAlias,
                crate::output::DescribeIdentityPoolOutput,
                crate::error::DescribeIdentityPoolError,
                crate::input::DescribeIdentityPoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCredentialsForIdentity`.
    ///
    /// <p>Returns credentials for the provided identity ID. Any provided logins will be
    /// validated against supported login providers. If the token is for
    /// cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service
    /// with the appropriate role for the token.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCredentialsForIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_credentials_for_identity_input::Builder,
    }
    impl<C, M, R> GetCredentialsForIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCredentialsForIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCredentialsForIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCredentialsForIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCredentialsForIdentityInputOperationOutputAlias,
                crate::output::GetCredentialsForIdentityOutput,
                crate::error::GetCredentialsForIdentityError,
                crate::input::GetCredentialsForIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// name-value pair will follow the syntax "provider_name":
        /// "provider_user_identifier".</p>
        /// <p>Logins should not be specified when trying to get credentials for an unauthenticated
        /// identity.</p>
        /// <p>The Logins parameter is required when using identities associated with external
        /// identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code
        /// examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer
        /// Guide.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k, v);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// name-value pair will follow the syntax "provider_name":
        /// "provider_user_identifier".</p>
        /// <p>Logins should not be specified when trying to get credentials for an unauthenticated
        /// identity.</p>
        /// <p>The Logins parameter is required when using identities associated with external
        /// identity providers such as Facebook. For examples of <code>Logins</code> maps, see the code
        /// examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers</a> section of the Amazon Cognito Developer
        /// Guide.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
        /// received in the token from the identity provider. For example, a SAML-based identity
        /// provider. This parameter is optional for identity providers that do not support role
        /// customization.</p>
        pub fn custom_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
        /// received in the token from the identity provider. For example, a SAML-based identity
        /// provider. This parameter is optional for identity providers that do not support role
        /// customization.</p>
        pub fn set_custom_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetId`.
    ///
    /// <p>Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an
    /// implicit linked account.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetId<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_id_input::Builder,
    }
    impl<C, M, R> GetId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdInputOperationOutputAlias,
                crate::output::GetIdOutput,
                crate::error::GetIdError,
                crate::input::GetIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A standard AWS account ID (9+ digits).</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>A standard AWS account ID (9+ digits).</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// available provider names for <code>Logins</code> are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>Facebook: <code>graph.facebook.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Cognito user pool:
        /// <code>cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID></code>,
        /// for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Google: <code>accounts.google.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon: <code>www.amazon.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Twitter: <code>api.twitter.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Digits: <code>www.digits.com</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k, v);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. The
        /// available provider names for <code>Logins</code> are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>Facebook: <code>graph.facebook.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Cognito user pool:
        /// <code>cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID></code>,
        /// for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Google: <code>accounts.google.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon: <code>www.amazon.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Twitter: <code>api.twitter.com</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Digits: <code>www.digits.com</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityPoolRoles`.
    ///
    /// <p>Gets the roles for an identity pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityPoolRoles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_pool_roles_input::Builder,
    }
    impl<C, M, R> GetIdentityPoolRoles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityPoolRoles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityPoolRolesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityPoolRolesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityPoolRolesInputOperationOutputAlias,
                crate::output::GetIdentityPoolRolesOutput,
                crate::error::GetIdentityPoolRolesError,
                crate::input::GetIdentityPoolRolesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpenIdToken`.
    ///
    /// <p>Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by
    /// <a>GetId</a>. You can optionally add additional logins for the identity.
    /// Supplying multiple logins creates an implicit link.</p>
    /// <p>The OpenID token is valid for 10 minutes.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOpenIdToken<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_open_id_token_input::Builder,
    }
    impl<C, M, R> GetOpenIdToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOpenIdToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpenIdTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpenIdTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOpenIdTokenInputOperationOutputAlias,
                crate::output::GetOpenIdTokenOutput,
                crate::error::GetOpenIdTokenError,
                crate::input::GetOpenIdTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. When
        /// using graph.facebook.com and www.amazon.com, supply the access_token returned from the
        /// provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any
        /// other OpenID Connect provider, always include the <code>id_token</code>.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k, v);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. When
        /// using graph.facebook.com and www.amazon.com, supply the access_token returned from the
        /// provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any
        /// other OpenID Connect provider, always include the <code>id_token</code>.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpenIdTokenForDeveloperIdentity`.
    ///
    /// <p>Registers (or retrieves) a Cognito <code>IdentityId</code> and an OpenID Connect
    /// token for a user authenticated by your backend authentication process. Supplying multiple
    /// logins will create an implicit linked account. You can only specify one developer provider
    /// as part of the <code>Logins</code> map, which is linked to the identity pool. The developer
    /// provider is the "domain" by which Cognito will refer to your users.</p>
    /// <p>You can use <code>GetOpenIdTokenForDeveloperIdentity</code> to create a new identity
    /// and to link new logins (that is, user credentials issued by a public provider or developer
    /// provider) to an existing identity. When you want to create a new identity, the
    /// <code>IdentityId</code> should be null. When you want to associate a new login with an
    /// existing authenticated/unauthenticated identity, you can do so by providing the existing
    /// <code>IdentityId</code>. This API will create the identity in the specified
    /// <code>IdentityPoolId</code>.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOpenIdTokenForDeveloperIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_open_id_token_for_developer_identity_input::Builder,
    }
    impl<C, M, R> GetOpenIdTokenForDeveloperIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOpenIdTokenForDeveloperIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpenIdTokenForDeveloperIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetOpenIdTokenForDeveloperIdentityError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOpenIdTokenForDeveloperIdentityInputOperationOutputAlias,
                crate::output::GetOpenIdTokenForDeveloperIdentityOutput,
                crate::error::GetOpenIdTokenForDeveloperIdentityError,
                crate::input::GetOpenIdTokenForDeveloperIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. Each
        /// name-value pair represents a user from a public provider or developer provider. If the user
        /// is from a developer provider, the name-value pair will follow the syntax
        /// <code>"developer_provider_name": "developer_user_identifier"</code>. The developer
        /// provider is the "domain" by which Cognito will refer to your users; you provided this
        /// domain while creating/updating the identity pool. The developer user identifier is an
        /// identifier from your backend that uniquely identifies a user. When you create an identity
        /// pool, you can specify the supported logins.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k, v);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider tokens. Each
        /// name-value pair represents a user from a public provider or developer provider. If the user
        /// is from a developer provider, the name-value pair will follow the syntax
        /// <code>"developer_provider_name": "developer_user_identifier"</code>. The developer
        /// provider is the "domain" by which Cognito will refer to your users; you provided this
        /// domain while creating/updating the identity pool. The developer user identifier is an
        /// identifier from your backend that uniquely identifies a user. When you create an identity
        /// pool, you can specify the supported logins.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
        /// Adds a key-value pair to `PrincipalTags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>Use this operation to configure attribute mappings for custom providers. </p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.principal_tags(k, v);
            self
        }
        /// <p>Use this operation to configure attribute mappings for custom providers. </p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_principal_tags(input);
            self
        }
        /// <p>The expiration time of the token, in seconds. You can specify a custom expiration
        /// time for the token so that you can cache it. If you don't provide an expiration time, the
        /// token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
        /// credentials, which are valid for a maximum of one hour. The maximum token duration you can
        /// set is 24 hours. You should take care in setting the expiration time for a token, as there
        /// are significant security implications: an attacker could use a leaked token to access your
        /// AWS resources for the token's duration.</p>
        /// <note>
        /// <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>
        /// </note>
        pub fn token_duration(mut self, inp: i64) -> Self {
            self.inner = self.inner.token_duration(inp);
            self
        }
        /// <p>The expiration time of the token, in seconds. You can specify a custom expiration
        /// time for the token so that you can cache it. If you don't provide an expiration time, the
        /// token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
        /// credentials, which are valid for a maximum of one hour. The maximum token duration you can
        /// set is 24 hours. You should take care in setting the expiration time for a token, as there
        /// are significant security implications: an attacker could use a leaked token to access your
        /// AWS resources for the token's duration.</p>
        /// <note>
        /// <p>Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.</p>
        /// </note>
        pub fn set_token_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_token_duration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPrincipalTagAttributeMap`.
    ///
    /// <p>Use <code>GetPrincipalTagAttributeMap</code> to list all mappings between <code>PrincipalTags</code> and user attributes.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPrincipalTagAttributeMap<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_principal_tag_attribute_map_input::Builder,
    }
    impl<C, M, R> GetPrincipalTagAttributeMap<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPrincipalTagAttributeMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPrincipalTagAttributeMapOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPrincipalTagAttributeMapError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPrincipalTagAttributeMapInputOperationOutputAlias,
                crate::output::GetPrincipalTagAttributeMapOutput,
                crate::error::GetPrincipalTagAttributeMapError,
                crate::input::GetPrincipalTagAttributeMapInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn identity_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(inp);
            self
        }
        /// <p>You can use this operation to get the provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentities`.
    ///
    /// <p>Lists the identities in an identity pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIdentities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identities_input::Builder,
    }
    impl<C, M, R> ListIdentities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentitiesInputOperationOutputAlias,
                crate::output::ListIdentitiesOutput,
                crate::error::ListIdentitiesError,
                crate::input::ListIdentitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>An optional boolean parameter that allows you to hide disabled identities. If
        /// omitted, the ListIdentities API will include disabled identities in the response.</p>
        pub fn hide_disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.hide_disabled(inp);
            self
        }
        /// <p>An optional boolean parameter that allows you to hide disabled identities. If
        /// omitted, the ListIdentities API will include disabled identities in the response.</p>
        pub fn set_hide_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_hide_disabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityPools`.
    ///
    /// <p>Lists all of the Cognito identity pools registered for your account.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIdentityPools<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identity_pools_input::Builder,
    }
    impl<C, M, R> ListIdentityPools<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentityPools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityPoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityPoolsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentityPoolsInputOperationOutputAlias,
                crate::output::ListIdentityPoolsOutput,
                crate::error::ListIdentityPoolsError,
                crate::input::ListIdentityPoolsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that are assigned to an Amazon Cognito identity pool.</p>
    /// <p>A tag is a label that you can apply to identity pools to categorize and manage them in
    /// different ways, such as by purpose, owner, environment, or other criteria.</p>
    /// <p>You can use this action up to 10 times per second, per account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned
        /// to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool that the tags are assigned
        /// to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LookupDeveloperIdentity`.
    ///
    /// <p>Retrieves the <code>IdentityID</code> associated with a
    /// <code>DeveloperUserIdentifier</code> or the list of <code>DeveloperUserIdentifier</code>
    /// values associated with an <code>IdentityId</code> for an existing identity. Either
    /// <code>IdentityID</code> or <code>DeveloperUserIdentifier</code> must not be null. If you
    /// supply only one of these values, the other value will be searched in the database and
    /// returned as a part of the response. If you supply both,
    /// <code>DeveloperUserIdentifier</code> will be matched against <code>IdentityID</code>. If
    /// the values are verified against the database, the response returns both values and is the
    /// same as the request. Otherwise a <code>ResourceConflictException</code> is
    /// thrown.</p>
    /// <p>
    /// <code>LookupDeveloperIdentity</code> is intended for low-throughput control plane
    /// operations: for example, to enable customer service to locate an identity ID by username.
    /// If you are using it for higher-volume operations such as user authentication, your requests
    /// are likely to be throttled. <a>GetOpenIdTokenForDeveloperIdentity</a> is a
    /// better option for higher-volume operations for user authentication.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct LookupDeveloperIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::lookup_developer_identity_input::Builder,
    }
    impl<C, M, R> LookupDeveloperIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LookupDeveloperIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LookupDeveloperIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::LookupDeveloperIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LookupDeveloperIdentityInputOperationOutputAlias,
                crate::output::LookupDeveloperIdentityOutput,
                crate::error::LookupDeveloperIdentityError,
                crate::input::LookupDeveloperIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.
        /// Typically, a developer identity provider would issue many developer user identifiers, in
        /// keeping with the number of users.</p>
        pub fn developer_user_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_user_identifier(inp);
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.
        /// Typically, a developer identity provider would issue many developer user identifiers, in
        /// keeping with the number of users.</p>
        pub fn set_developer_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_user_identifier(input);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of identities to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
        /// null. After that the service will return <code>NextToken</code> values as needed. For
        /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
        /// 20 matches in the database. The service will return a pagination token as a part of the
        /// response. This token can be used to call the API again and get results starting from the
        /// 11th match.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token. The first call you make will have <code>NextToken</code> set to
        /// null. After that the service will return <code>NextToken</code> values as needed. For
        /// example, let's say you make a request with <code>MaxResults</code> set to 10, and there are
        /// 20 matches in the database. The service will return a pagination token as a part of the
        /// response. This token can be used to call the API again and get results starting from the
        /// 11th match.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeDeveloperIdentities`.
    ///
    /// <p>Merges two users having different <code>IdentityId</code>s, existing in the same
    /// identity pool, and identified by the same developer provider. You can use this action to
    /// request that discrete users be merged and identified as a single user in the Cognito
    /// environment. Cognito associates the given source user (<code>SourceUserIdentifier</code>)
    /// with the <code>IdentityId</code> of the <code>DestinationUserIdentifier</code>. Only
    /// developer-authenticated users can be merged. If the users to be merged are associated with
    /// the same public provider, but as two different users, an exception will be
    /// thrown.</p>
    /// <p>The number of linked logins is limited to 20. So, the number of linked logins for the
    /// source user, <code>SourceUserIdentifier</code>, and the destination user,
    /// <code>DestinationUserIdentifier</code>, together should not be larger than 20.
    /// Otherwise, an exception will be thrown.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct MergeDeveloperIdentities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_developer_identities_input::Builder,
    }
    impl<C, M, R> MergeDeveloperIdentities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergeDeveloperIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeDeveloperIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeDeveloperIdentitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergeDeveloperIdentitiesInputOperationOutputAlias,
                crate::output::MergeDeveloperIdentitiesOutput,
                crate::error::MergeDeveloperIdentitiesError,
                crate::input::MergeDeveloperIdentitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>User identifier for the source user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn source_user_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_user_identifier(inp);
            self
        }
        /// <p>User identifier for the source user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn set_source_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_user_identifier(input);
            self
        }
        /// <p>User identifier for the destination user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn destination_user_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_user_identifier(inp);
            self
        }
        /// <p>User identifier for the destination user. The value should be a
        /// <code>DeveloperUserIdentifier</code>.</p>
        pub fn set_destination_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_user_identifier(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
        /// name that you provide while creating an identity pool. This name acts as a placeholder that
        /// allows your backend and the Cognito service to communicate about the developer provider.
        /// For the <code>DeveloperProviderName</code>, you can use letters as well as period (.),
        /// underscore (_), and dash (-).</p>
        pub fn developer_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(inp);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
        /// name that you provide while creating an identity pool. This name acts as a placeholder that
        /// allows your backend and the Cognito service to communicate about the developer provider.
        /// For the <code>DeveloperProviderName</code>, you can use letters as well as period (.),
        /// underscore (_), and dash (-).</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityPoolRoles`.
    ///
    /// <p>Sets the roles for an identity pool. These roles are used when making calls to <a>GetCredentialsForIdentity</a> action.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetIdentityPoolRoles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_identity_pool_roles_input::Builder,
    }
    impl<C, M, R> SetIdentityPoolRoles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIdentityPoolRoles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityPoolRolesOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityPoolRolesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIdentityPoolRolesInputOperationOutputAlias,
                crate::output::SetIdentityPoolRolesOutput,
                crate::error::SetIdentityPoolRolesError,
                crate::input::SetIdentityPoolRolesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// Adds a key-value pair to `Roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>The map of roles associated with this pool. For a given role, the key will be either
        /// "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
        pub fn roles(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.roles(k, v);
            self
        }
        /// <p>The map of roles associated with this pool. For a given role, the key will be either
        /// "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_roles(input);
            self
        }
        /// Adds a key-value pair to `RoleMappings`.
        ///
        /// To override the contents of this collection use [`set_role_mappings`](Self::set_role_mappings).
        ///
        /// <p>How users for a specific identity provider are to mapped to roles. This is a string
        /// to <a>RoleMapping</a> object map. The string identifies the identity provider,
        /// for example, "graph.facebook.com" or
        /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        /// <p>Up to 25 rules can be specified per identity provider.</p>
        pub fn role_mappings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RoleMapping>,
        ) -> Self {
            self.inner = self.inner.role_mappings(k, v);
            self
        }
        /// <p>How users for a specific identity provider are to mapped to roles. This is a string
        /// to <a>RoleMapping</a> object map. The string identifies the identity provider,
        /// for example, "graph.facebook.com" or
        /// "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>
        /// <p>Up to 25 rules can be specified per identity provider.</p>
        pub fn set_role_mappings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RoleMapping>,
            >,
        ) -> Self {
            self.inner = self.inner.set_role_mappings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetPrincipalTagAttributeMap`.
    ///
    /// <p>You can use this operation to use default (username and clientID) attribute or custom attribute mappings.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetPrincipalTagAttributeMap<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_principal_tag_attribute_map_input::Builder,
    }
    impl<C, M, R> SetPrincipalTagAttributeMap<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetPrincipalTagAttributeMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetPrincipalTagAttributeMapOutput,
            aws_smithy_http::result::SdkError<crate::error::SetPrincipalTagAttributeMapError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetPrincipalTagAttributeMapInputOperationOutputAlias,
                crate::output::SetPrincipalTagAttributeMapOutput,
                crate::error::SetPrincipalTagAttributeMapError,
                crate::input::SetPrincipalTagAttributeMapInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>The ID of the Identity Pool you want to set attribute mappings for.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn identity_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(inp);
            self
        }
        /// <p>The provider name you want to use for attribute mappings.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
        /// <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
        pub fn use_defaults(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_defaults(inp);
            self
        }
        /// <p>You can use this operation to use default (username and clientID) attribute mappings.</p>
        pub fn set_use_defaults(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_defaults(input);
            self
        }
        /// Adds a key-value pair to `PrincipalTags`.
        ///
        /// To override the contents of this collection use [`set_principal_tags`](Self::set_principal_tags).
        ///
        /// <p>You can use this operation to add principal tags.</p>
        pub fn principal_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.principal_tags(k, v);
            self
        }
        /// <p>You can use this operation to add principal tags.</p>
        pub fn set_principal_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_principal_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label
    /// that you can use to categorize and manage identity pools in different ways, such as by
    /// purpose, owner, environment, or other criteria.</p>
    /// <p>Each tag consists of a key and value, both of which you define. A key is a general
    /// category for more specific values. For example, if you have two versions of an identity
    /// pool, one for testing and another for production, you might assign an
    /// <code>Environment</code> tag key to both identity pools. The value of this key might be
    /// <code>Test</code> for one identity pool and <code>Production</code> for the
    /// other.</p>
    /// <p>Tags are useful for cost tracking and access control. You can activate your tags so that
    /// they appear on the Billing and Cost Management console, where you can track the costs
    /// associated with your identity pools. In an IAM policy, you can constrain permissions for
    /// identity pools based on specific tags or tag values.</p>
    /// <p>You can use this action up to 5 times per second, per account. An identity pool can have
    /// as many as 50 tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the identity pool.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to assign to the identity pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnlinkDeveloperIdentity`.
    ///
    /// <p>Unlinks a <code>DeveloperUserIdentifier</code> from an existing identity. Unlinked
    /// developer users will be considered new identities next time they are seen. If, for a given
    /// Cognito identity, you remove all federated identities as well as the developer user
    /// identifier, the Cognito identity becomes inaccessible.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct UnlinkDeveloperIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unlink_developer_identity_input::Builder,
    }
    impl<C, M, R> UnlinkDeveloperIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnlinkDeveloperIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnlinkDeveloperIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::UnlinkDeveloperIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnlinkDeveloperIdentityInputOperationOutputAlias,
                crate::output::UnlinkDeveloperIdentityOutput,
                crate::error::UnlinkDeveloperIdentityError,
                crate::input::UnlinkDeveloperIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(inp);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.</p>
        pub fn developer_user_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_user_identifier(inp);
            self
        }
        /// <p>A unique ID used by your backend authentication process to identify a user.</p>
        pub fn set_developer_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_user_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnlinkIdentity`.
    ///
    /// <p>Unlinks a federated identity from an existing account. Unlinked logins will be
    /// considered new identities next time they are seen. Removing the last linked login will make
    /// this identity inaccessible.</p>
    /// <p>This is a public API. You do not need any credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct UnlinkIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unlink_identity_input::Builder,
    }
    impl<C, M, R> UnlinkIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnlinkIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnlinkIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::UnlinkIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnlinkIdentityInputOperationOutputAlias,
                crate::output::UnlinkIdentityOutput,
                crate::error::UnlinkIdentityError,
                crate::input::UnlinkIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>A unique identifier in the format REGION:GUID.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// Adds a key-value pair to `Logins`.
        ///
        /// To override the contents of this collection use [`set_logins`](Self::set_logins).
        ///
        /// <p>A set of optional name-value pairs that map provider names to provider
        /// tokens.</p>
        pub fn logins(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logins(k, v);
            self
        }
        /// <p>A set of optional name-value pairs that map provider names to provider
        /// tokens.</p>
        pub fn set_logins(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logins(input);
            self
        }
        /// Appends an item to `LoginsToRemove`.
        ///
        /// To override the contents of this collection use [`set_logins_to_remove`](Self::set_logins_to_remove).
        ///
        /// <p>Provider names to unlink from this identity.</p>
        pub fn logins_to_remove(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logins_to_remove(inp);
            self
        }
        /// <p>Provider names to unlink from this identity.</p>
        pub fn set_logins_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_logins_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified Amazon Cognito identity pool. You can use
    /// this action up to 5 times per second, per account</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the identity pool.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIdentityPool`.
    ///
    /// <p>Updates an identity pool.</p>
    /// <p>You must use AWS Developer credentials to call this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIdentityPool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_identity_pool_input::Builder,
    }
    impl<C, M, R> UpdateIdentityPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIdentityPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIdentityPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIdentityPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIdentityPoolInputOperationOutputAlias,
                crate::output::UpdateIdentityPoolOutput,
                crate::error::UpdateIdentityPoolError,
                crate::input::UpdateIdentityPoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>An identity pool ID in the format REGION:GUID.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>A string that you provide.</p>
        pub fn identity_pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_name(inp);
            self
        }
        /// <p>A string that you provide.</p>
        pub fn set_identity_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_name(input);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn allow_unauthenticated_identities(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_unauthenticated_identities(inp);
            self
        }
        /// <p>TRUE if the identity pool supports unauthenticated logins.</p>
        pub fn set_allow_unauthenticated_identities(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allow_unauthenticated_identities(input);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn allow_classic_flow(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_classic_flow(inp);
            self
        }
        /// <p>Enables or disables the Basic (Classic) authentication flow. For more information, see
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_allow_classic_flow(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_classic_flow(input);
            self
        }
        /// Adds a key-value pair to `SupportedLoginProviders`.
        ///
        /// To override the contents of this collection use [`set_supported_login_providers`](Self::set_supported_login_providers).
        ///
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn supported_login_providers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.supported_login_providers(k, v);
            self
        }
        /// <p>Optional key:value pairs mapping provider names to provider app IDs.</p>
        pub fn set_supported_login_providers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_supported_login_providers(input);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn developer_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.developer_provider_name(inp);
            self
        }
        /// <p>The "domain" by which Cognito will refer to your users.</p>
        pub fn set_developer_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_developer_provider_name(input);
            self
        }
        /// Appends an item to `OpenIdConnectProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_ar_ns`](Self::set_open_id_connect_provider_ar_ns).
        ///
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn open_id_connect_provider_ar_ns(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.open_id_connect_provider_ar_ns(inp);
            self
        }
        /// <p>The ARNs of the OpenID Connect providers.</p>
        pub fn set_open_id_connect_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_ar_ns(input);
            self
        }
        /// Appends an item to `CognitoIdentityProviders`.
        ///
        /// To override the contents of this collection use [`set_cognito_identity_providers`](Self::set_cognito_identity_providers).
        ///
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn cognito_identity_providers(
            mut self,
            inp: impl Into<crate::model::CognitoIdentityProvider>,
        ) -> Self {
            self.inner = self.inner.cognito_identity_providers(inp);
            self
        }
        /// <p>A list representing an Amazon Cognito user pool and its client ID.</p>
        pub fn set_cognito_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CognitoIdentityProvider>>,
        ) -> Self {
            self.inner = self.inner.set_cognito_identity_providers(input);
            self
        }
        /// Appends an item to `SamlProviderARNs`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_ar_ns`](Self::set_saml_provider_ar_ns).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn saml_provider_ar_ns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_ar_ns(inp);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
        /// pool.</p>
        pub fn set_saml_provider_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_ar_ns(input);
            self
        }
        /// Adds a key-value pair to `IdentityPoolTags`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_tags`](Self::set_identity_pool_tags).
        ///
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn identity_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_pool_tags(k, v);
            self
        }
        /// <p>The tags that are assigned to the identity pool. A tag is a label that you can apply to
        /// identity pools to categorize and manage them in different ways, such as by purpose, owner,
        /// environment, or other criteria.</p>
        pub fn set_identity_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_tags(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
