// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNotificationRuleOutput {}
impl std::fmt::Debug for UpdateNotificationRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNotificationRuleOutput");
        formatter.finish()
    }
}
/// See [`UpdateNotificationRuleOutput`](crate::output::UpdateNotificationRuleOutput)
pub mod update_notification_rule_output {
    /// A builder for [`UpdateNotificationRuleOutput`](crate::output::UpdateNotificationRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateNotificationRuleOutput`](crate::output::UpdateNotificationRuleOutput)
        pub fn build(self) -> crate::output::UpdateNotificationRuleOutput {
            crate::output::UpdateNotificationRuleOutput {}
        }
    }
}
impl UpdateNotificationRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNotificationRuleOutput`](crate::output::UpdateNotificationRuleOutput)
    pub fn builder() -> crate::output::update_notification_rule_output::Builder {
        crate::output::update_notification_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsubscribeOutput {
    /// <p>The Amazon Resource Name (ARN) of the the notification rule from which you have removed a subscription.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl UnsubscribeOutput {
    /// <p>The Amazon Resource Name (ARN) of the the notification rule from which you have removed a subscription.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for UnsubscribeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsubscribeOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`UnsubscribeOutput`](crate::output::UnsubscribeOutput)
pub mod unsubscribe_output {
    /// A builder for [`UnsubscribeOutput`](crate::output::UnsubscribeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the the notification rule from which you have removed a subscription.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the the notification rule from which you have removed a subscription.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsubscribeOutput`](crate::output::UnsubscribeOutput)
        pub fn build(self) -> crate::output::UnsubscribeOutput {
            crate::output::UnsubscribeOutput { arn: self.arn }
        }
    }
}
impl UnsubscribeOutput {
    /// Creates a new builder-style object to manufacture [`UnsubscribeOutput`](crate::output::UnsubscribeOutput)
    pub fn builder() -> crate::output::unsubscribe_output::Builder {
        crate::output::unsubscribe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {
    /// <p>The list of tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceOutput {
    /// <p>The list of tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput { tags: self.tags }
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscribeOutput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule for which you have created assocations.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl SubscribeOutput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule for which you have created assocations.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for SubscribeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscribeOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`SubscribeOutput`](crate::output::SubscribeOutput)
pub mod subscribe_output {
    /// A builder for [`SubscribeOutput`](crate::output::SubscribeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you have created assocations.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you have created assocations.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscribeOutput`](crate::output::SubscribeOutput)
        pub fn build(self) -> crate::output::SubscribeOutput {
            crate::output::SubscribeOutput { arn: self.arn }
        }
    }
}
impl SubscribeOutput {
    /// Creates a new builder-style object to manufacture [`SubscribeOutput`](crate::output::SubscribeOutput)
    pub fn builder() -> crate::output::subscribe_output::Builder {
        crate::output::subscribe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsOutput {
    /// <p>The list of notification rule targets. </p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::TargetSummary>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTargetsOutput {
    /// <p>The list of notification rule targets. </p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::TargetSummary]> {
        self.targets.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsOutput");
        formatter.field("targets", &self.targets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTargetsOutput`](crate::output::ListTargetsOutput)
pub mod list_targets_output {
    /// A builder for [`ListTargetsOutput`](crate::output::ListTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::TargetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The list of notification rule targets. </p>
        pub fn targets(mut self, input: crate::model::TargetSummary) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// <p>The list of notification rule targets. </p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetSummary>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsOutput`](crate::output::ListTargetsOutput)
        pub fn build(self) -> crate::output::ListTargetsOutput {
            crate::output::ListTargetsOutput {
                targets: self.targets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTargetsOutput {
    /// Creates a new builder-style object to manufacture [`ListTargetsOutput`](crate::output::ListTargetsOutput)
    pub fn builder() -> crate::output::list_targets_output::Builder {
        crate::output::list_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags associated with the notification rule.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags associated with the notification rule.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the notification rule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the notification rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotificationRulesOutput {
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID. </p>
    pub notification_rules:
        std::option::Option<std::vec::Vec<crate::model::NotificationRuleSummary>>,
}
impl ListNotificationRulesOutput {
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID. </p>
    pub fn notification_rules(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationRuleSummary]> {
        self.notification_rules.as_deref()
    }
}
impl std::fmt::Debug for ListNotificationRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotificationRulesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("notification_rules", &self.notification_rules);
        formatter.finish()
    }
}
/// See [`ListNotificationRulesOutput`](crate::output::ListNotificationRulesOutput)
pub mod list_notification_rules_output {
    /// A builder for [`ListNotificationRulesOutput`](crate::output::ListNotificationRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) notification_rules:
            std::option::Option<std::vec::Vec<crate::model::NotificationRuleSummary>>,
    }
    impl Builder {
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `notification_rules`.
        ///
        /// To override the contents of this collection use [`set_notification_rules`](Self::set_notification_rules).
        ///
        /// <p>The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID. </p>
        pub fn notification_rules(mut self, input: crate::model::NotificationRuleSummary) -> Self {
            let mut v = self.notification_rules.unwrap_or_default();
            v.push(input);
            self.notification_rules = Some(v);
            self
        }
        /// <p>The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID. </p>
        pub fn set_notification_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationRuleSummary>>,
        ) -> Self {
            self.notification_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotificationRulesOutput`](crate::output::ListNotificationRulesOutput)
        pub fn build(self) -> crate::output::ListNotificationRulesOutput {
            crate::output::ListNotificationRulesOutput {
                next_token: self.next_token,
                notification_rules: self.notification_rules,
            }
        }
    }
}
impl ListNotificationRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListNotificationRulesOutput`](crate::output::ListNotificationRulesOutput)
    pub fn builder() -> crate::output::list_notification_rules_output::Builder {
        crate::output::list_notification_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventTypesOutput {
    /// <p>Information about each event, including service name, resource type, event ID, and event name.</p>
    pub event_types: std::option::Option<std::vec::Vec<crate::model::EventTypeSummary>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEventTypesOutput {
    /// <p>Information about each event, including service name, resource type, event ID, and event name.</p>
    pub fn event_types(&self) -> std::option::Option<&[crate::model::EventTypeSummary]> {
        self.event_types.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEventTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventTypesOutput");
        formatter.field("event_types", &self.event_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEventTypesOutput`](crate::output::ListEventTypesOutput)
pub mod list_event_types_output {
    /// A builder for [`ListEventTypesOutput`](crate::output::ListEventTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_types: std::option::Option<std::vec::Vec<crate::model::EventTypeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_types`.
        ///
        /// To override the contents of this collection use [`set_event_types`](Self::set_event_types).
        ///
        /// <p>Information about each event, including service name, resource type, event ID, and event name.</p>
        pub fn event_types(mut self, input: crate::model::EventTypeSummary) -> Self {
            let mut v = self.event_types.unwrap_or_default();
            v.push(input);
            self.event_types = Some(v);
            self
        }
        /// <p>Information about each event, including service name, resource type, event ID, and event name.</p>
        pub fn set_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTypeSummary>>,
        ) -> Self {
            self.event_types = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventTypesOutput`](crate::output::ListEventTypesOutput)
        pub fn build(self) -> crate::output::ListEventTypesOutput {
            crate::output::ListEventTypesOutput {
                event_types: self.event_types,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEventTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListEventTypesOutput`](crate::output::ListEventTypesOutput)
    pub fn builder() -> crate::output::list_event_types_output::Builder {
        crate::output::list_event_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the notification rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the event types associated with the notification rule.</p>
    pub event_types: std::option::Option<std::vec::Vec<crate::model::EventTypeSummary>>,
    /// <p>The Amazon Resource Name (ARN) of the resource associated with the notification rule.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>A list of the SNS topics associated with the notification rule.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::TargetSummary>>,
    /// <p>The level of detail included in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    pub detail_type: std::option::Option<crate::model::DetailType>,
    /// <p>The name or email alias of the person who created the notification rule.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending notifications).</p>
    pub status: std::option::Option<crate::model::NotificationRuleStatus>,
    /// <p>The date and time the notification rule was created, in timestamp format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the notification rule was most recently updated, in timestamp format.</p>
    pub last_modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The tags associated with the notification rule.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeNotificationRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the notification rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the event types associated with the notification rule.</p>
    pub fn event_types(&self) -> std::option::Option<&[crate::model::EventTypeSummary]> {
        self.event_types.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource associated with the notification rule.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>A list of the SNS topics associated with the notification rule.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::TargetSummary]> {
        self.targets.as_deref()
    }
    /// <p>The level of detail included in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    pub fn detail_type(&self) -> std::option::Option<&crate::model::DetailType> {
        self.detail_type.as_ref()
    }
    /// <p>The name or email alias of the person who created the notification rule.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending notifications).</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NotificationRuleStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time the notification rule was created, in timestamp format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The date and time the notification rule was most recently updated, in timestamp format.</p>
    pub fn last_modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_timestamp.as_ref()
    }
    /// <p>The tags associated with the notification rule.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeNotificationRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationRuleOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("event_types", &self.event_types);
        formatter.field("resource", &self.resource);
        formatter.field("targets", &self.targets);
        formatter.field("detail_type", &self.detail_type);
        formatter.field("created_by", &self.created_by);
        formatter.field("status", &self.status);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_modified_timestamp", &self.last_modified_timestamp);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeNotificationRuleOutput`](crate::output::DescribeNotificationRuleOutput)
pub mod describe_notification_rule_output {
    /// A builder for [`DescribeNotificationRuleOutput`](crate::output::DescribeNotificationRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_types: std::option::Option<std::vec::Vec<crate::model::EventTypeSummary>>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::TargetSummary>>,
        pub(crate) detail_type: std::option::Option<crate::model::DetailType>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NotificationRuleStatus>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `event_types`.
        ///
        /// To override the contents of this collection use [`set_event_types`](Self::set_event_types).
        ///
        /// <p>A list of the event types associated with the notification rule.</p>
        pub fn event_types(mut self, input: crate::model::EventTypeSummary) -> Self {
            let mut v = self.event_types.unwrap_or_default();
            v.push(input);
            self.event_types = Some(v);
            self
        }
        /// <p>A list of the event types associated with the notification rule.</p>
        pub fn set_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTypeSummary>>,
        ) -> Self {
            self.event_types = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the notification rule.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the notification rule.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of the SNS topics associated with the notification rule.</p>
        pub fn targets(mut self, input: crate::model::TargetSummary) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// <p>A list of the SNS topics associated with the notification rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetSummary>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The level of detail included in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn detail_type(mut self, input: crate::model::DetailType) -> Self {
            self.detail_type = Some(input);
            self
        }
        /// <p>The level of detail included in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn set_detail_type(
            mut self,
            input: std::option::Option<crate::model::DetailType>,
        ) -> Self {
            self.detail_type = input;
            self
        }
        /// <p>The name or email alias of the person who created the notification rule.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The name or email alias of the person who created the notification rule.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending notifications).</p>
        pub fn status(mut self, input: crate::model::NotificationRuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending notifications).</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotificationRuleStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time the notification rule was created, in timestamp format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The date and time the notification rule was created, in timestamp format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The date and time the notification rule was most recently updated, in timestamp format.</p>
        pub fn last_modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_timestamp = Some(input);
            self
        }
        /// <p>The date and time the notification rule was most recently updated, in timestamp format.</p>
        pub fn set_last_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_timestamp = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the notification rule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the notification rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationRuleOutput`](crate::output::DescribeNotificationRuleOutput)
        pub fn build(self) -> crate::output::DescribeNotificationRuleOutput {
            crate::output::DescribeNotificationRuleOutput {
                arn: self.arn,
                name: self.name,
                event_types: self.event_types,
                resource: self.resource,
                targets: self.targets,
                detail_type: self.detail_type,
                created_by: self.created_by,
                status: self.status,
                created_timestamp: self.created_timestamp,
                last_modified_timestamp: self.last_modified_timestamp,
                tags: self.tags,
            }
        }
    }
}
impl DescribeNotificationRuleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNotificationRuleOutput`](crate::output::DescribeNotificationRuleOutput)
    pub fn builder() -> crate::output::describe_notification_rule_output::Builder {
        crate::output::describe_notification_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTargetOutput {}
impl std::fmt::Debug for DeleteTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTargetOutput");
        formatter.finish()
    }
}
/// See [`DeleteTargetOutput`](crate::output::DeleteTargetOutput)
pub mod delete_target_output {
    /// A builder for [`DeleteTargetOutput`](crate::output::DeleteTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTargetOutput`](crate::output::DeleteTargetOutput)
        pub fn build(self) -> crate::output::DeleteTargetOutput {
            crate::output::DeleteTargetOutput {}
        }
    }
}
impl DeleteTargetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTargetOutput`](crate::output::DeleteTargetOutput)
    pub fn builder() -> crate::output::delete_target_output::Builder {
        crate::output::delete_target_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted notification rule.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteNotificationRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted notification rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteNotificationRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationRuleOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeleteNotificationRuleOutput`](crate::output::DeleteNotificationRuleOutput)
pub mod delete_notification_rule_output {
    /// A builder for [`DeleteNotificationRuleOutput`](crate::output::DeleteNotificationRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deleted notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotificationRuleOutput`](crate::output::DeleteNotificationRuleOutput)
        pub fn build(self) -> crate::output::DeleteNotificationRuleOutput {
            crate::output::DeleteNotificationRuleOutput { arn: self.arn }
        }
    }
}
impl DeleteNotificationRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteNotificationRuleOutput`](crate::output::DeleteNotificationRuleOutput)
    pub fn builder() -> crate::output::delete_notification_rule_output::Builder {
        crate::output::delete_notification_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNotificationRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreateNotificationRuleOutput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreateNotificationRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNotificationRuleOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateNotificationRuleOutput`](crate::output::CreateNotificationRuleOutput)
pub mod create_notification_rule_output {
    /// A builder for [`CreateNotificationRuleOutput`](crate::output::CreateNotificationRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotificationRuleOutput`](crate::output::CreateNotificationRuleOutput)
        pub fn build(self) -> crate::output::CreateNotificationRuleOutput {
            crate::output::CreateNotificationRuleOutput { arn: self.arn }
        }
    }
}
impl CreateNotificationRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateNotificationRuleOutput`](crate::output::CreateNotificationRuleOutput)
    pub fn builder() -> crate::output::create_notification_rule_output::Builder {
        crate::output::create_notification_rule_output::Builder::default()
    }
}
