#![allow(clippy::module_inception)]
#![allow(clippy::upper_case_acronyms)]
#![allow(clippy::large_enum_variant)]
#![allow(clippy::wrong_self_convention)]
#![allow(clippy::should_implement_trait)]
#![allow(clippy::blacklisted_name)]
#![allow(clippy::vec_init_then_push)]
#![allow(rustdoc::bare_urls)]
#![warn(missing_docs)]
//! <p>This AWS CodeStar Notifications API Reference provides descriptions and usage examples of the
//! operations and data types for the AWS CodeStar Notifications API. You can use the AWS CodeStar Notifications API
//! to work with the following objects:</p>
//!
//! <p>Notification rules, by calling the following: </p>
//! <ul>
//! <li>
//! <p>
//! <a>CreateNotificationRule</a>, which creates a notification rule for a
//! resource in your account. </p>
//! </li>
//! <li>
//! <p>
//! <a>DeleteNotificationRule</a>, which deletes a notification rule. </p>
//! </li>
//! <li>
//! <p>
//! <a>DescribeNotificationRule</a>, which provides information about a notification rule. </p>
//! </li>
//! <li>
//! <p>
//! <a>ListNotificationRules</a>, which lists the notification rules associated with
//! your account. </p>
//! </li>
//! <li>
//! <p>
//! <a>UpdateNotificationRule</a>, which changes the name, events, or targets associated with a
//! notification rule. </p>
//! </li>
//! <li>
//! <p>
//! <a>Subscribe</a>, which subscribes a target to a notification rule. </p>
//! </li>
//! <li>
//! <p>
//! <a>Unsubscribe</a>, which removes a target from a notification rule. </p>
//! </li>
//! </ul>
//!
//! <p>Targets, by calling the following: </p>
//! <ul>
//! <li>
//! <p>
//! <a>DeleteTarget</a>, which removes a notification rule target (SNS topic) from a
//! notification rule. </p>
//! </li>
//! <li>
//! <p>
//! <a>ListTargets</a>, which lists the targets associated with a
//! notification rule. </p>
//! </li>
//! </ul>
//!
//! <p>Events, by calling the following: </p>
//! <ul>
//! <li>
//! <p>
//! <a>ListEventTypes</a>, which lists the event types you can include in
//! a notification rule. </p>
//! </li>
//! </ul>
//! <p>Tags, by calling the following: </p>
//! <ul>
//! <li>
//! <p>
//! <a>ListTagsForResource</a>, which lists the tags already associated
//! with a notification rule in your account. </p>
//! </li>
//! <li>
//! <p>
//! <a>TagResource</a>, which associates a tag you provide with a
//! notification rule in your account. </p>
//! </li>
//! <li>
//! <p>
//! <a>UntagResource</a>, which removes a tag from a notification rule in
//! your account. </p>
//! </li>
//! </ul>
//!
//!
//!
//! <p> For information about how to use AWS CodeStar Notifications, see link in the CodeStarNotifications User Guide.
//! </p>
//!
//! # Crate Organization
//!
//! The entry point for most customers will be [`Client`]. [`Client`] exposes one method for each API offered
//! by the service.
//!
//! Some APIs require complex or nested arguments. These exist in [`model`](crate::model).
//!
//! Lastly, errors that can be returned by the service are contained within [`error`]. [`Error`] defines a meta
//! error encompassing all possible errors that can be returned by the service.
//!
//! The other modules within this crate are not required for normal usage.

// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use error_meta::Error;

#[doc(inline)]
pub use config::Config;

mod aws_endpoint;
/// Client and fluent builders for calling the service.
pub mod client;
/// Configuration for the service.
pub mod config;
/// Errors that can occur when calling the service.
pub mod error;
mod error_meta;
mod idempotency_token;
/// Input structures for operations.
pub mod input;
mod json_deser;
mod json_errors;
mod json_ser;
/// Generated accessors for nested fields
mod lens;
pub mod middleware;
/// Data structures used by operation inputs/outputs.
pub mod model;
mod no_credentials;
/// All operations that this crate can perform.
pub mod operation;
mod operation_deser;
mod operation_ser;
/// Output structures for operations.
pub mod output;
/// Paginators for the service
pub mod paginator;
/// Crate version number.
pub static PKG_VERSION: &str = env!("CARGO_PKG_VERSION");
/// Re-exported types from supporting crates.
pub mod types {
    pub use aws_smithy_http::result::SdkError;
    pub use aws_smithy_types::DateTime;
}
static API_METADATA: aws_http::user_agent::ApiMetadata =
    aws_http::user_agent::ApiMetadata::new("codestarnotifications", PKG_VERSION);
pub use aws_smithy_http::endpoint::Endpoint;
pub use aws_smithy_types::retry::RetryConfig;
pub use aws_types::app_name::AppName;
pub use aws_types::region::Region;
pub use aws_types::Credentials;
#[doc(inline)]
pub use client::Client;
