// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS CodeStar Notifications
///
/// Client for invoking operations on AWS CodeStar Notifications. Each operation on AWS CodeStar Notifications is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codestarnotifications::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_codestarnotifications::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_codestarnotifications::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateNotificationRule`](crate::client::fluent_builders::CreateNotificationRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateNotificationRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateNotificationRule::set_name): <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS account.</p>
    ///   - [`event_type_ids(Vec<String>)`](crate::client::fluent_builders::CreateNotificationRule::event_type_ids) / [`set_event_type_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateNotificationRule::set_event_type_ids): <p>A list of event types associated with this notification rule. For a list of allowed events, see <code>EventTypeSummary</code>.</p>
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::CreateNotificationRule::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::CreateNotificationRule::set_resource): <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::CreateNotificationRule::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::CreateNotificationRule::set_targets): <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.</p>
    ///   - [`detail_type(DetailType)`](crate::client::fluent_builders::CreateNotificationRule::detail_type) / [`set_detail_type(Option<DetailType>)`](crate::client::fluent_builders::CreateNotificationRule::set_detail_type): <p>The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateNotificationRule::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateNotificationRule::set_client_request_token): <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request with the same parameters is received and a token is included, the request returns information about the initial request that used that token.</p> <note>   <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>  </note>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateNotificationRule::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateNotificationRule::set_tags): <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
    ///   - [`status(NotificationRuleStatus)`](crate::client::fluent_builders::CreateNotificationRule::status) / [`set_status(Option<NotificationRuleStatus>)`](crate::client::fluent_builders::CreateNotificationRule::set_status): <p>The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED, notifications aren't sent for the notification rule.</p>
    /// - On success, responds with [`CreateNotificationRuleOutput`](crate::output::CreateNotificationRuleOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateNotificationRuleOutput::arn): <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    /// - On failure, responds with [`SdkError<CreateNotificationRuleError>`](crate::error::CreateNotificationRuleError)
    pub fn create_notification_rule(&self) -> fluent_builders::CreateNotificationRule {
        fluent_builders::CreateNotificationRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNotificationRule`](crate::client::fluent_builders::DeleteNotificationRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteNotificationRule::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteNotificationRule::set_arn): <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
    /// - On success, responds with [`DeleteNotificationRuleOutput`](crate::output::DeleteNotificationRuleOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteNotificationRuleOutput::arn): <p>The Amazon Resource Name (ARN) of the deleted notification rule.</p>
    /// - On failure, responds with [`SdkError<DeleteNotificationRuleError>`](crate::error::DeleteNotificationRuleError)
    pub fn delete_notification_rule(&self) -> fluent_builders::DeleteNotificationRule {
        fluent_builders::DeleteNotificationRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTarget`](crate::client::fluent_builders::DeleteTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_address(impl Into<String>)`](crate::client::fluent_builders::DeleteTarget::target_address) / [`set_target_address(Option<String>)`](crate::client::fluent_builders::DeleteTarget::set_target_address): <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
    ///   - [`force_unsubscribe_all(bool)`](crate::client::fluent_builders::DeleteTarget::force_unsubscribe_all) / [`set_force_unsubscribe_all(bool)`](crate::client::fluent_builders::DeleteTarget::set_force_unsubscribe_all): <p>A Boolean value that can be used to delete all associations with this SNS topic. The default value is FALSE. If set to TRUE, all associations between that target and every notification rule in your AWS account are deleted.</p>
    /// - On success, responds with [`DeleteTargetOutput`](crate::output::DeleteTargetOutput)

    /// - On failure, responds with [`SdkError<DeleteTargetError>`](crate::error::DeleteTargetError)
    pub fn delete_target(&self) -> fluent_builders::DeleteTarget {
        fluent_builders::DeleteTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNotificationRule`](crate::client::fluent_builders::DescribeNotificationRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DescribeNotificationRule::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DescribeNotificationRule::set_arn): <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    /// - On success, responds with [`DescribeNotificationRuleOutput`](crate::output::DescribeNotificationRuleOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeNotificationRuleOutput::arn): <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeNotificationRuleOutput::name): <p>The name of the notification rule.</p>
    ///   - [`event_types(Option<Vec<EventTypeSummary>>)`](crate::output::DescribeNotificationRuleOutput::event_types): <p>A list of the event types associated with the notification rule.</p>
    ///   - [`resource(Option<String>)`](crate::output::DescribeNotificationRuleOutput::resource): <p>The Amazon Resource Name (ARN) of the resource associated with the notification rule.</p>
    ///   - [`targets(Option<Vec<TargetSummary>>)`](crate::output::DescribeNotificationRuleOutput::targets): <p>A list of the SNS topics associated with the notification rule.</p>
    ///   - [`detail_type(Option<DetailType>)`](crate::output::DescribeNotificationRuleOutput::detail_type): <p>The level of detail included in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeNotificationRuleOutput::created_by): <p>The name or email alias of the person who created the notification rule.</p>
    ///   - [`status(Option<NotificationRuleStatus>)`](crate::output::DescribeNotificationRuleOutput::status): <p>The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending notifications).</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::DescribeNotificationRuleOutput::created_timestamp): <p>The date and time the notification rule was created, in timestamp format.</p>
    ///   - [`last_modified_timestamp(Option<DateTime>)`](crate::output::DescribeNotificationRuleOutput::last_modified_timestamp): <p>The date and time the notification rule was most recently updated, in timestamp format.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeNotificationRuleOutput::tags): <p>The tags associated with the notification rule.</p>
    /// - On failure, responds with [`SdkError<DescribeNotificationRuleError>`](crate::error::DescribeNotificationRuleError)
    pub fn describe_notification_rule(&self) -> fluent_builders::DescribeNotificationRule {
        fluent_builders::DescribeNotificationRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventTypes`](crate::client::fluent_builders::ListEventTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEventTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ListEventTypesFilter>)`](crate::client::fluent_builders::ListEventTypes::filters) / [`set_filters(Option<Vec<ListEventTypesFilter>>)`](crate::client::fluent_builders::ListEventTypes::set_filters): <p>The filters to use to return information by service or resource type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventTypes::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEventTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEventTypes::set_max_results): <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of results that can be returned is 100.</p>
    /// - On success, responds with [`ListEventTypesOutput`](crate::output::ListEventTypesOutput) with field(s):
    ///   - [`event_types(Option<Vec<EventTypeSummary>>)`](crate::output::ListEventTypesOutput::event_types): <p>Information about each event, including service name, resource type, event ID, and event name.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventTypesOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    /// - On failure, responds with [`SdkError<ListEventTypesError>`](crate::error::ListEventTypesError)
    pub fn list_event_types(&self) -> fluent_builders::ListEventTypes {
        fluent_builders::ListEventTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNotificationRules`](crate::client::fluent_builders::ListNotificationRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNotificationRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ListNotificationRulesFilter>)`](crate::client::fluent_builders::ListNotificationRules::filters) / [`set_filters(Option<Vec<ListNotificationRulesFilter>>)`](crate::client::fluent_builders::ListNotificationRules::set_filters): <p>The filters to use to return information by service or resource type. For valid values, see <code>ListNotificationRulesFilter</code>.</p> <note>   <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>  </note>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNotificationRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNotificationRules::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNotificationRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNotificationRules::set_max_results): <p>A non-negative integer used to limit the number of returned results. The maximum number of results that can be returned is 100.</p>
    /// - On success, responds with [`ListNotificationRulesOutput`](crate::output::ListNotificationRulesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListNotificationRulesOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    ///   - [`notification_rules(Option<Vec<NotificationRuleSummary>>)`](crate::output::ListNotificationRulesOutput::notification_rules): <p>The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID. </p>
    /// - On failure, responds with [`SdkError<ListNotificationRulesError>`](crate::error::ListNotificationRulesError)
    pub fn list_notification_rules(&self) -> fluent_builders::ListNotificationRules {
        fluent_builders::ListNotificationRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_arn): <p>The Amazon Resource Name (ARN) for the notification rule.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags associated with the notification rule.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTargets`](crate::client::fluent_builders::ListTargets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTargets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ListTargetsFilter>)`](crate::client::fluent_builders::ListTargets::filters) / [`set_filters(Option<Vec<ListTargetsFilter>>)`](crate::client::fluent_builders::ListTargets::set_filters): <p>The filters to use to return information by service or resource type. Valid filters include target type, target address, and target status.</p> <note>   <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>  </note>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTargets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTargets::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTargets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTargets::set_max_results): <p>A non-negative integer used to limit the number of returned results. The maximum number of results that can be returned is 100.</p>
    /// - On success, responds with [`ListTargetsOutput`](crate::output::ListTargetsOutput) with field(s):
    ///   - [`targets(Option<Vec<TargetSummary>>)`](crate::output::ListTargetsOutput::targets): <p>The list of notification rule targets. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTargetsOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of results.</p>
    /// - On failure, responds with [`SdkError<ListTargetsError>`](crate::error::ListTargetsError)
    pub fn list_targets(&self) -> fluent_builders::ListTargets {
        fluent_builders::ListTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Subscribe`](crate::client::fluent_builders::Subscribe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::Subscribe::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::Subscribe::set_arn): <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
    ///   - [`target(Target)`](crate::client::fluent_builders::Subscribe::target) / [`set_target(Option<Target>)`](crate::client::fluent_builders::Subscribe::set_target): <p>Information about the SNS topics associated with a notification rule.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::Subscribe::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::Subscribe::set_client_request_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    /// - On success, responds with [`SubscribeOutput`](crate::output::SubscribeOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::SubscribeOutput::arn): <p>The Amazon Resource Name (ARN) of the notification rule for which you have created assocations.</p>
    /// - On failure, responds with [`SdkError<SubscribeError>`](crate::error::SubscribeError)
    pub fn subscribe(&self) -> fluent_builders::Subscribe {
        fluent_builders::Subscribe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_arn): <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::TagResourceOutput::tags): <p>The list of tags associated with the resource.</p>
    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Unsubscribe`](crate::client::fluent_builders::Unsubscribe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::Unsubscribe::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::Unsubscribe::set_arn): <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    ///   - [`target_address(impl Into<String>)`](crate::client::fluent_builders::Unsubscribe::target_address) / [`set_target_address(Option<String>)`](crate::client::fluent_builders::Unsubscribe::set_target_address): <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
    /// - On success, responds with [`UnsubscribeOutput`](crate::output::UnsubscribeOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UnsubscribeOutput::arn): <p>The Amazon Resource Name (ARN) of the the notification rule from which you have removed a subscription.</p>
    /// - On failure, responds with [`SdkError<UnsubscribeError>`](crate::error::UnsubscribeError)
    pub fn unsubscribe(&self) -> fluent_builders::Unsubscribe {
        fluent_builders::Unsubscribe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_arn): <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The key names of the tags to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNotificationRule`](crate::client::fluent_builders::UpdateNotificationRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateNotificationRule::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateNotificationRule::set_arn): <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateNotificationRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateNotificationRule::set_name): <p>The name of the notification rule.</p>
    ///   - [`status(NotificationRuleStatus)`](crate::client::fluent_builders::UpdateNotificationRule::status) / [`set_status(Option<NotificationRuleStatus>)`](crate::client::fluent_builders::UpdateNotificationRule::set_status): <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled (not sending notifications).</p>
    ///   - [`event_type_ids(Vec<String>)`](crate::client::fluent_builders::UpdateNotificationRule::event_type_ids) / [`set_event_type_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNotificationRule::set_event_type_ids): <p>A list of event types associated with this notification rule.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::UpdateNotificationRule::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::UpdateNotificationRule::set_targets): <p>The address and type of the targets to receive notifications from this notification rule.</p>
    ///   - [`detail_type(DetailType)`](crate::client::fluent_builders::UpdateNotificationRule::detail_type) / [`set_detail_type(Option<DetailType>)`](crate::client::fluent_builders::UpdateNotificationRule::set_detail_type): <p>The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    /// - On success, responds with [`UpdateNotificationRuleOutput`](crate::output::UpdateNotificationRuleOutput)

    /// - On failure, responds with [`SdkError<UpdateNotificationRuleError>`](crate::error::UpdateNotificationRuleError)
    pub fn update_notification_rule(&self) -> fluent_builders::UpdateNotificationRule {
        fluent_builders::UpdateNotificationRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateNotificationRule`.
    ///
    /// <p>Creates a notification rule for a resource. The rule specifies the events you want notifications about and the targets (such as SNS topics) where you want to receive them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNotificationRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_notification_rule_input::Builder,
    }
    impl CreateNotificationRule {
        /// Creates a new `CreateNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNotificationRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `EventTypeIds`.
        ///
        /// To override the contents of this collection use [`set_event_type_ids`](Self::set_event_type_ids).
        ///
        /// <p>A list of event types associated with this notification rule. For a list of allowed events, see <code>EventTypeSummary</code>.</p>
        pub fn event_type_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_ids(input.into());
            self
        }
        /// <p>A list of event types associated with this notification rule. For a list of allowed events, see <code>EventTypeSummary</code>.</p>
        pub fn set_event_type_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_type_ids(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn detail_type(mut self, input: crate::model::DetailType) -> Self {
            self.inner = self.inner.detail_type(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn set_detail_type(
            mut self,
            input: std::option::Option<crate::model::DetailType>,
        ) -> Self {
            self.inner = self.inner.set_detail_type(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request with the same parameters is received and a token is included, the request returns information about the initial request that used that token.</p> <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
        /// </note>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request with the same parameters is received and a token is included, the request returns information about the initial request that used that token.</p> <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
        /// </note>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED, notifications aren't sent for the notification rule.</p>
        pub fn status(mut self, input: crate::model::NotificationRuleStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED, notifications aren't sent for the notification rule.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotificationRuleStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotificationRule`.
    ///
    /// <p>Deletes a notification rule for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNotificationRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_notification_rule_input::Builder,
    }
    impl DeleteNotificationRule {
        /// Creates a new `DeleteNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNotificationRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTarget`.
    ///
    /// <p>Deletes a specified target for notifications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_target_input::Builder,
    }
    impl DeleteTarget {
        /// Creates a new `DeleteTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
        pub fn target_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_address(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
        pub fn set_target_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_address(input);
            self
        }
        /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The default value is FALSE. If set to TRUE, all associations between that target and every notification rule in your AWS account are deleted.</p>
        pub fn force_unsubscribe_all(mut self, input: bool) -> Self {
            self.inner = self.inner.force_unsubscribe_all(input);
            self
        }
        /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The default value is FALSE. If set to TRUE, all associations between that target and every notification rule in your AWS account are deleted.</p>
        pub fn set_force_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_unsubscribe_all(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotificationRule`.
    ///
    /// <p>Returns information about a specified notification rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNotificationRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_notification_rule_input::Builder,
    }
    impl DescribeNotificationRule {
        /// Creates a new `DescribeNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNotificationRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventTypes`.
    ///
    /// <p>Returns information about the event types available for configuring notifications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_types_input::Builder,
    }
    impl ListEventTypes {
        /// Creates a new `ListEventTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventTypesPaginator {
            crate::paginator::ListEventTypesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type.</p>
        pub fn filters(mut self, input: crate::model::ListEventTypesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters to use to return information by service or resource type.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListEventTypesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of results that can be returned is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotificationRules`.
    ///
    /// <p>Returns a list of the notification rules for an AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNotificationRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_notification_rules_input::Builder,
    }
    impl ListNotificationRules {
        /// Creates a new `ListNotificationRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNotificationRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNotificationRulesPaginator {
            crate::paginator::ListNotificationRulesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type. For valid values, see <code>ListNotificationRulesFilter</code>.</p> <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::ListNotificationRulesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters to use to return information by service or resource type. For valid values, see <code>ListNotificationRulesFilter</code>.</p> <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListNotificationRulesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of results that can be returned is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags associated with a notification rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargets`.
    ///
    /// <p>Returns a list of the notification rule targets for an AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_targets_input::Builder,
    }
    impl ListTargets {
        /// Creates a new `ListTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTargetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTargetsPaginator {
            crate::paginator::ListTargetsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type. Valid filters include target type, target address, and target status.</p> <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::ListTargetsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters to use to return information by service or resource type. Valid filters include target type, target address, and target status.</p> <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListTargetsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of results that can be returned is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Subscribe`.
    ///
    /// <p>Creates an association between a notification rule and an SNS topic so that the associated target can receive notifications when the events described in the rule are triggered.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Subscribe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::subscribe_input::Builder,
    }
    impl Subscribe {
        /// Creates a new `Subscribe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubscribeOutput,
            aws_smithy_http::result::SdkError<crate::error::SubscribeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Information about the SNS topics associated with a notification rule.</p>
        pub fn target(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.target(input);
            self
        }
        /// <p>Information about the SNS topics associated with a notification rule.</p>
        pub fn set_target(mut self, input: std::option::Option<crate::model::Target>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a set of provided tags with a notification rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Unsubscribe`.
    ///
    /// <p>Removes an association between a notification rule and an Amazon SNS topic so that subscribers to that topic stop receiving notifications when the events described in the rule are triggered.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Unsubscribe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::unsubscribe_input::Builder,
    }
    impl Unsubscribe {
        /// Creates a new `Unsubscribe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnsubscribeOutput,
            aws_smithy_http::result::SdkError<crate::error::UnsubscribeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
        pub fn target_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_address(input.into());
            self
        }
        /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
        pub fn set_target_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the association between one or more provided tags and a notification rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key names of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The key names of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNotificationRule`.
    ///
    /// <p>Updates a notification rule for a resource. You can change the events that trigger the notification rule, the status of the rule, and the targets that receive the notifications.</p> <note>
    /// <p>To add or remove tags for a notification rule, you must use <code>TagResource</code> and <code>UntagResource</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNotificationRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_notification_rule_input::Builder,
    }
    impl UpdateNotificationRule {
        /// Creates a new `UpdateNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNotificationRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled (not sending notifications).</p>
        pub fn status(mut self, input: crate::model::NotificationRuleStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled (not sending notifications).</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotificationRuleStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `EventTypeIds`.
        ///
        /// To override the contents of this collection use [`set_event_type_ids`](Self::set_event_type_ids).
        ///
        /// <p>A list of event types associated with this notification rule.</p>
        pub fn event_type_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_ids(input.into());
            self
        }
        /// <p>A list of event types associated with this notification rule.</p>
        pub fn set_event_type_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_type_ids(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The address and type of the targets to receive notifications from this notification rule.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The address and type of the targets to receive notifications from this notification rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn detail_type(mut self, input: crate::model::DetailType) -> Self {
            self.inner = self.inner.detail_type(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn set_detail_type(
            mut self,
            input: std::option::Option<crate::model::DetailType>,
        ) -> Self {
            self.inner = self.inner.set_detail_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
