// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateNotificationRuleInput`](crate::input::CreateNotificationRuleInput)
pub mod create_notification_rule_input {
    /// A builder for [`CreateNotificationRuleInput`](crate::input::CreateNotificationRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) event_type_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) detail_type: std::option::Option<crate::model::DetailType>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::NotificationRuleStatus>,
    }
    impl Builder {
        /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS
        /// account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS
        /// account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `event_type_ids`.
        ///
        /// To override the contents of this collection use [`set_event_type_ids`](Self::set_event_type_ids).
        ///
        /// <p>A list of event types associated with this notification rule. For a list of allowed
        /// events, see <a>EventTypeSummary</a>.</p>
        pub fn event_type_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_type_ids.unwrap_or_default();
            v.push(input.into());
            self.event_type_ids = Some(v);
            self
        }
        /// <p>A list of event types associated with this notification rule. For a list of allowed
        /// events, see <a>EventTypeSummary</a>.</p>
        pub fn set_event_type_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_type_ids = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline,
        /// repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline,
        /// repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the
        /// notification rule.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the
        /// notification rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn detail_type(mut self, input: crate::model::DetailType) -> Self {
            self.detail_type = Some(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn set_detail_type(
            mut self,
            input: std::option::Option<crate::model::DetailType>,
        ) -> Self {
            self.detail_type = input;
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request with the same
        /// parameters is received and a token is included, the request returns information about
        /// the initial request that used that token.</p>
        /// <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
        /// idempotency token is created for you.</p>
        /// </note>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request with the same
        /// parameters is received and a token is included, the request returns information about
        /// the initial request that used that token.</p>
        /// <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
        /// idempotency token is created for you.</p>
        /// </note>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The status of the notification rule. The default value is ENABLED. If the status is
        /// set to DISABLED, notifications aren't sent for the notification rule.</p>
        pub fn status(mut self, input: crate::model::NotificationRuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the notification rule. The default value is ENABLED. If the status is
        /// set to DISABLED, notifications aren't sent for the notification rule.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotificationRuleStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotificationRuleInput`](crate::input::CreateNotificationRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNotificationRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNotificationRuleInput {
                name: self.name,
                event_type_ids: self.event_type_ids,
                resource: self.resource,
                targets: self.targets,
                detail_type: self.detail_type,
                client_request_token: self.client_request_token,
                tags: self.tags,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNotificationRuleInputOperationOutputAlias = crate::operation::CreateNotificationRule;
#[doc(hidden)]
pub type CreateNotificationRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNotificationRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateNotificationRule`](crate::operation::CreateNotificationRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNotificationRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNotificationRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createNotificationRule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNotificationRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNotificationRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_notification_rule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNotificationRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNotificationRule",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNotificationRuleInput`](crate::input::CreateNotificationRuleInput)
    pub fn builder() -> crate::input::create_notification_rule_input::Builder {
        crate::input::create_notification_rule_input::Builder::default()
    }
}

/// See [`DeleteNotificationRuleInput`](crate::input::DeleteNotificationRuleInput)
pub mod delete_notification_rule_input {
    /// A builder for [`DeleteNotificationRuleInput`](crate::input::DeleteNotificationRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotificationRuleInput`](crate::input::DeleteNotificationRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNotificationRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNotificationRuleInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteNotificationRuleInputOperationOutputAlias = crate::operation::DeleteNotificationRule;
#[doc(hidden)]
pub type DeleteNotificationRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteNotificationRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNotificationRule`](crate::operation::DeleteNotificationRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNotificationRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNotificationRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteNotificationRule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNotificationRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNotificationRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_notification_rule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNotificationRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNotificationRule",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNotificationRuleInput`](crate::input::DeleteNotificationRuleInput)
    pub fn builder() -> crate::input::delete_notification_rule_input::Builder {
        crate::input::delete_notification_rule_input::Builder::default()
    }
}

/// See [`DeleteTargetInput`](crate::input::DeleteTargetInput)
pub mod delete_target_input {
    /// A builder for [`DeleteTargetInput`](crate::input::DeleteTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_address: std::option::Option<std::string::String>,
        pub(crate) force_unsubscribe_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
        pub fn target_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_address = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
        pub fn set_target_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_address = input;
            self
        }
        /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The
        /// default value is FALSE. If set to TRUE, all associations between that target and every
        /// notification rule in your AWS account are deleted.</p>
        pub fn force_unsubscribe_all(mut self, input: bool) -> Self {
            self.force_unsubscribe_all = Some(input);
            self
        }
        /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The
        /// default value is FALSE. If set to TRUE, all associations between that target and every
        /// notification rule in your AWS account are deleted.</p>
        pub fn set_force_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.force_unsubscribe_all = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTargetInput`](crate::input::DeleteTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTargetInput {
                target_address: self.target_address,
                force_unsubscribe_all: self.force_unsubscribe_all.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTargetInputOperationOutputAlias = crate::operation::DeleteTarget;
#[doc(hidden)]
pub type DeleteTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTargetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTarget`](crate::operation::DeleteTarget)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteTarget").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_target(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTarget",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTargetInput`](crate::input::DeleteTargetInput)
    pub fn builder() -> crate::input::delete_target_input::Builder {
        crate::input::delete_target_input::Builder::default()
    }
}

/// See [`DescribeNotificationRuleInput`](crate::input::DescribeNotificationRuleInput)
pub mod describe_notification_rule_input {
    /// A builder for [`DescribeNotificationRuleInput`](crate::input::DescribeNotificationRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationRuleInput`](crate::input::DescribeNotificationRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNotificationRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNotificationRuleInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DescribeNotificationRuleInputOperationOutputAlias =
    crate::operation::DescribeNotificationRule;
#[doc(hidden)]
pub type DescribeNotificationRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNotificationRuleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNotificationRule`](crate::operation::DescribeNotificationRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNotificationRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNotificationRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describeNotificationRule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNotificationRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNotificationRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_notification_rule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNotificationRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNotificationRule",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNotificationRuleInput`](crate::input::DescribeNotificationRuleInput)
    pub fn builder() -> crate::input::describe_notification_rule_input::Builder {
        crate::input::describe_notification_rule_input::Builder::default()
    }
}

/// See [`ListEventTypesInput`](crate::input::ListEventTypesInput)
pub mod list_event_types_input {
    /// A builder for [`ListEventTypesInput`](crate::input::ListEventTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ListEventTypesFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ListEventTypesFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to return information by service or resource type.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListEventTypesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventTypesInput`](crate::input::ListEventTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventTypesInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventTypesInputOperationOutputAlias = crate::operation::ListEventTypes;
#[doc(hidden)]
pub type ListEventTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEventTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListEventTypes`](crate::operation::ListEventTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEventTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listEventTypes").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEventTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEventTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_event_types(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventTypes",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEventTypesInput`](crate::input::ListEventTypesInput)
    pub fn builder() -> crate::input::list_event_types_input::Builder {
        crate::input::list_event_types_input::Builder::default()
    }
}

/// See [`ListNotificationRulesInput`](crate::input::ListNotificationRulesInput)
pub mod list_notification_rules_input {
    /// A builder for [`ListNotificationRulesInput`](crate::input::ListNotificationRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ListNotificationRulesFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type. For valid values,
        /// see <a>ListNotificationRulesFilter</a>.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::ListNotificationRulesFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to return information by service or resource type. For valid values,
        /// see <a>ListNotificationRulesFilter</a>.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListNotificationRulesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotificationRulesInput`](crate::input::ListNotificationRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNotificationRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNotificationRulesInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNotificationRulesInputOperationOutputAlias = crate::operation::ListNotificationRules;
#[doc(hidden)]
pub type ListNotificationRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListNotificationRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListNotificationRules`](crate::operation::ListNotificationRules)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNotificationRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNotificationRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listNotificationRules").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNotificationRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNotificationRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_notification_rules(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNotificationRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNotificationRules",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNotificationRulesInput`](crate::input::ListNotificationRulesInput)
    pub fn builder() -> crate::input::list_notification_rules_input::Builder {
        crate::input::list_notification_rules_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listTagsForResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTargetsInput`](crate::input::ListTargetsInput)
pub mod list_targets_input {
    /// A builder for [`ListTargetsInput`](crate::input::ListTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ListTargetsFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type. Valid filters
        /// include target type, target address, and target status.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn filters(mut self, input: impl Into<crate::model::ListTargetsFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters to use to return information by service or resource type. Valid filters
        /// include target type, target address, and target status.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListTargetsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsInput`](crate::input::ListTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTargetsInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTargetsInputOperationOutputAlias = crate::operation::ListTargets;
#[doc(hidden)]
pub type ListTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTargetsInput {
    /// Consumes the builder and constructs an Operation<[`ListTargets`](crate::operation::ListTargets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listTargets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_targets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTargets",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTargetsInput`](crate::input::ListTargetsInput)
    pub fn builder() -> crate::input::list_targets_input::Builder {
        crate::input::list_targets_input::Builder::default()
    }
}

/// See [`SubscribeInput`](crate::input::SubscribeInput)
pub mod subscribe_input {
    /// A builder for [`SubscribeInput`](crate::input::SubscribeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<crate::model::Target>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Information about the SNS topics associated with a  notification rule.</p>
        pub fn target(mut self, input: crate::model::Target) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>Information about the SNS topics associated with a  notification rule.</p>
        pub fn set_target(mut self, input: std::option::Option<crate::model::Target>) -> Self {
            self.target = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscribeInput`](crate::input::SubscribeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SubscribeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SubscribeInput {
                arn: self.arn,
                target: self.target,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SubscribeInputOperationOutputAlias = crate::operation::Subscribe;
#[doc(hidden)]
pub type SubscribeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubscribeInput {
    /// Consumes the builder and constructs an Operation<[`Subscribe`](crate::operation::Subscribe)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Subscribe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubscribeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/subscribe").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubscribeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubscribeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_subscribe(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Subscribe::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "Subscribe",
                    "codestarnotifications",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubscribeInput`](crate::input::SubscribeInput)
    pub fn builder() -> crate::input::subscribe_input::Builder {
        crate::input::subscribe_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                arn: self.arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UnsubscribeInput`](crate::input::UnsubscribeInput)
pub mod unsubscribe_input {
    /// A builder for [`UnsubscribeInput`](crate::input::UnsubscribeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) target_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
        pub fn target_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_address = Some(input.into());
            self
        }
        /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
        pub fn set_target_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_address = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsubscribeInput`](crate::input::UnsubscribeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnsubscribeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnsubscribeInput {
                arn: self.arn,
                target_address: self.target_address,
            })
        }
    }
}
#[doc(hidden)]
pub type UnsubscribeInputOperationOutputAlias = crate::operation::Unsubscribe;
#[doc(hidden)]
pub type UnsubscribeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnsubscribeInput {
    /// Consumes the builder and constructs an Operation<[`Unsubscribe`](crate::operation::Unsubscribe)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Unsubscribe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnsubscribeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/unsubscribe").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnsubscribeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnsubscribeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_unsubscribe(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::Unsubscribe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "Unsubscribe",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnsubscribeInput`](crate::input::UnsubscribeInput)
    pub fn builder() -> crate::input::unsubscribe_input::Builder {
        crate::input::unsubscribe_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the
        /// tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the
        /// tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key names of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The key names of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                arn: self.arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/untagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateNotificationRuleInput`](crate::input::UpdateNotificationRuleInput)
pub mod update_notification_rule_input {
    /// A builder for [`UpdateNotificationRuleInput`](crate::input::UpdateNotificationRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NotificationRuleStatus>,
        pub(crate) event_type_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) detail_type: std::option::Option<crate::model::DetailType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or
        /// disabled (not sending notifications).</p>
        pub fn status(mut self, input: crate::model::NotificationRuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or
        /// disabled (not sending notifications).</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotificationRuleStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `event_type_ids`.
        ///
        /// To override the contents of this collection use [`set_event_type_ids`](Self::set_event_type_ids).
        ///
        /// <p>A list of event types associated with this notification rule.</p>
        pub fn event_type_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_type_ids.unwrap_or_default();
            v.push(input.into());
            self.event_type_ids = Some(v);
            self
        }
        /// <p>A list of event types associated with this notification rule.</p>
        pub fn set_event_type_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_type_ids = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The address and type of the targets to receive notifications from this notification
        /// rule.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The address and type of the targets to receive notifications from this notification
        /// rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn detail_type(mut self, input: crate::model::DetailType) -> Self {
            self.detail_type = Some(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn set_detail_type(
            mut self,
            input: std::option::Option<crate::model::DetailType>,
        ) -> Self {
            self.detail_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNotificationRuleInput`](crate::input::UpdateNotificationRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNotificationRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNotificationRuleInput {
                arn: self.arn,
                name: self.name,
                status: self.status,
                event_type_ids: self.event_type_ids,
                targets: self.targets,
                detail_type: self.detail_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNotificationRuleInputOperationOutputAlias = crate::operation::UpdateNotificationRule;
#[doc(hidden)]
pub type UpdateNotificationRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateNotificationRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNotificationRule`](crate::operation::UpdateNotificationRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNotificationRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNotificationRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateNotificationRule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNotificationRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNotificationRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_notification_rule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNotificationRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNotificationRule",
            "codestarnotifications",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNotificationRuleInput`](crate::input::UpdateNotificationRuleInput)
    pub fn builder() -> crate::input::update_notification_rule_input::Builder {
        crate::input::update_notification_rule_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNotificationRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the notification rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or
    /// disabled (not sending notifications).</p>
    pub status: std::option::Option<crate::model::NotificationRuleStatus>,
    /// <p>A list of event types associated with this notification rule.</p>
    pub event_type_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The address and type of the targets to receive notifications from this notification
    /// rule.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
    /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
    /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    pub detail_type: std::option::Option<crate::model::DetailType>,
}
impl UpdateNotificationRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the notification rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or
    /// disabled (not sending notifications).</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NotificationRuleStatus> {
        self.status.as_ref()
    }
    /// <p>A list of event types associated with this notification rule.</p>
    pub fn event_type_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.event_type_ids.as_deref()
    }
    /// <p>The address and type of the targets to receive notifications from this notification
    /// rule.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
    /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
    /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
    /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    pub fn detail_type(&self) -> std::option::Option<&crate::model::DetailType> {
        self.detail_type.as_ref()
    }
}
impl std::fmt::Debug for UpdateNotificationRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNotificationRuleInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("event_type_ids", &self.event_type_ids);
        formatter.field("targets", &self.targets);
        formatter.field("detail_type", &self.detail_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the
    /// tags.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The key names of the tags to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the
    /// tags.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The key names of the tags to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("arn", &self.arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsubscribeInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
    pub target_address: std::option::Option<std::string::String>,
}
impl UnsubscribeInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
    pub fn target_address(&self) -> std::option::Option<&str> {
        self.target_address.as_deref()
    }
}
impl std::fmt::Debug for UnsubscribeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsubscribeInput");
        formatter.field("arn", &self.arn);
        formatter.field("target_address", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscribeInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Information about the SNS topics associated with a  notification rule.</p>
    pub target: std::option::Option<crate::model::Target>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl SubscribeInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Information about the SNS topics associated with a  notification rule.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::Target> {
        self.target.as_ref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for SubscribeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscribeInput");
        formatter.field("arn", &self.arn);
        formatter.field("target", &self.target);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsInput {
    /// <p>The filters to use to return information by service or resource type. Valid filters
    /// include target type, target address, and target status.</p>
    /// <note>
    /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
    /// </note>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ListTargetsFilter>>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
    /// results that can be returned is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTargetsInput {
    /// <p>The filters to use to return information by service or resource type. Valid filters
    /// include target type, target address, and target status.</p>
    /// <note>
    /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
    /// </note>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ListTargetsFilter]> {
        self.filters.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
    /// results that can be returned is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotificationRulesInput {
    /// <p>The filters to use to return information by service or resource type. For valid values,
    /// see <a>ListNotificationRulesFilter</a>.</p>
    /// <note>
    /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
    /// </note>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ListNotificationRulesFilter>>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
    /// results that can be returned is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListNotificationRulesInput {
    /// <p>The filters to use to return information by service or resource type. For valid values,
    /// see <a>ListNotificationRulesFilter</a>.</p>
    /// <note>
    /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
    /// </note>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ListNotificationRulesFilter]> {
        self.filters.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
    /// results that can be returned is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListNotificationRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotificationRulesInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventTypesInput {
    /// <p>The filters to use to return information by service or resource type.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ListEventTypesFilter>>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of
    /// results that can be returned is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEventTypesInput {
    /// <p>The filters to use to return information by service or resource type.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ListEventTypesFilter]> {
        self.filters.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of
    /// results that can be returned is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEventTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventTypesInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DescribeNotificationRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeNotificationRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationRuleInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTargetInput {
    /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
    pub target_address: std::option::Option<std::string::String>,
    /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The
    /// default value is FALSE. If set to TRUE, all associations between that target and every
    /// notification rule in your AWS account are deleted.</p>
    pub force_unsubscribe_all: bool,
}
impl DeleteTargetInput {
    /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
    pub fn target_address(&self) -> std::option::Option<&str> {
        self.target_address.as_deref()
    }
    /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The
    /// default value is FALSE. If set to TRUE, all associations between that target and every
    /// notification rule in your AWS account are deleted.</p>
    pub fn force_unsubscribe_all(&self) -> bool {
        self.force_unsubscribe_all
    }
}
impl std::fmt::Debug for DeleteTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTargetInput");
        formatter.field("target_address", &"*** Sensitive Data Redacted ***");
        formatter.field("force_unsubscribe_all", &self.force_unsubscribe_all);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteNotificationRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteNotificationRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationRuleInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNotificationRuleInput {
    /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS
    /// account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of event types associated with this notification rule. For a list of allowed
    /// events, see <a>EventTypeSummary</a>.</p>
    pub event_type_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline,
    /// repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the
    /// notification rule.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
    /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
    /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    pub detail_type: std::option::Option<crate::model::DetailType>,
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
    /// the request cannot be repeated with a changed parameter. If a request with the same
    /// parameters is received and a token is included, the request returns information about
    /// the initial request that used that token.</p>
    /// <note>
    /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
    /// idempotency token is created for you.</p>
    /// </note>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the notification rule. The default value is ENABLED. If the status is
    /// set to DISABLED, notifications aren't sent for the notification rule.</p>
    pub status: std::option::Option<crate::model::NotificationRuleStatus>,
}
impl CreateNotificationRuleInput {
    /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS
    /// account.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of event types associated with this notification rule. For a list of allowed
    /// events, see <a>EventTypeSummary</a>.</p>
    pub fn event_type_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.event_type_ids.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline,
    /// repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the
    /// notification rule.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
    /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
    /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
    /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
    pub fn detail_type(&self) -> std::option::Option<&crate::model::DetailType> {
        self.detail_type.as_ref()
    }
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
    /// the request cannot be repeated with a changed parameter. If a request with the same
    /// parameters is received and a token is included, the request returns information about
    /// the initial request that used that token.</p>
    /// <note>
    /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
    /// idempotency token is created for you.</p>
    /// </note>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The status of the notification rule. The default value is ENABLED. If the status is
    /// set to DISABLED, notifications aren't sent for the notification rule.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NotificationRuleStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CreateNotificationRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNotificationRuleInput");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("event_type_ids", &self.event_type_ids);
        formatter.field("resource", &self.resource);
        formatter.field("targets", &self.targets);
        formatter.field("detail_type", &self.detail_type);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
