// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CodeStarNotifications_20191015`.
///
/// This client allows ergonomic access to a `CodeStarNotifications_20191015`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateNotificationRule` operation.
    ///
    /// See [`CreateNotificationRule`](crate::client::fluent_builders::CreateNotificationRule) for more information about the
    /// operation and its arguments.
    pub fn create_notification_rule(&self) -> fluent_builders::CreateNotificationRule<C, M, R> {
        fluent_builders::CreateNotificationRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNotificationRule` operation.
    ///
    /// See [`DeleteNotificationRule`](crate::client::fluent_builders::DeleteNotificationRule) for more information about the
    /// operation and its arguments.
    pub fn delete_notification_rule(&self) -> fluent_builders::DeleteNotificationRule<C, M, R> {
        fluent_builders::DeleteNotificationRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTarget` operation.
    ///
    /// See [`DeleteTarget`](crate::client::fluent_builders::DeleteTarget) for more information about the
    /// operation and its arguments.
    pub fn delete_target(&self) -> fluent_builders::DeleteTarget<C, M, R> {
        fluent_builders::DeleteTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNotificationRule` operation.
    ///
    /// See [`DescribeNotificationRule`](crate::client::fluent_builders::DescribeNotificationRule) for more information about the
    /// operation and its arguments.
    pub fn describe_notification_rule(&self) -> fluent_builders::DescribeNotificationRule<C, M, R> {
        fluent_builders::DescribeNotificationRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventTypes` operation.
    ///
    /// See [`ListEventTypes`](crate::client::fluent_builders::ListEventTypes) for more information about the
    /// operation and its arguments.
    pub fn list_event_types(&self) -> fluent_builders::ListEventTypes<C, M, R> {
        fluent_builders::ListEventTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNotificationRules` operation.
    ///
    /// See [`ListNotificationRules`](crate::client::fluent_builders::ListNotificationRules) for more information about the
    /// operation and its arguments.
    pub fn list_notification_rules(&self) -> fluent_builders::ListNotificationRules<C, M, R> {
        fluent_builders::ListNotificationRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTargets` operation.
    ///
    /// See [`ListTargets`](crate::client::fluent_builders::ListTargets) for more information about the
    /// operation and its arguments.
    pub fn list_targets(&self) -> fluent_builders::ListTargets<C, M, R> {
        fluent_builders::ListTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Subscribe` operation.
    ///
    /// See [`Subscribe`](crate::client::fluent_builders::Subscribe) for more information about the
    /// operation and its arguments.
    pub fn subscribe(&self) -> fluent_builders::Subscribe<C, M, R> {
        fluent_builders::Subscribe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Unsubscribe` operation.
    ///
    /// See [`Unsubscribe`](crate::client::fluent_builders::Unsubscribe) for more information about the
    /// operation and its arguments.
    pub fn unsubscribe(&self) -> fluent_builders::Unsubscribe<C, M, R> {
        fluent_builders::Unsubscribe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNotificationRule` operation.
    ///
    /// See [`UpdateNotificationRule`](crate::client::fluent_builders::UpdateNotificationRule) for more information about the
    /// operation and its arguments.
    pub fn update_notification_rule(&self) -> fluent_builders::UpdateNotificationRule<C, M, R> {
        fluent_builders::UpdateNotificationRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateNotificationRule`.
    ///
    /// <p>Creates a notification rule for a resource. The rule specifies the events you want
    /// notifications about and the targets (such as SNS topics) where you want to receive
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNotificationRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_notification_rule_input::Builder,
    }
    impl<C, M, R> CreateNotificationRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNotificationRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNotificationRuleInputOperationOutputAlias,
                crate::output::CreateNotificationRuleOutput,
                crate::error::CreateNotificationRuleError,
                crate::input::CreateNotificationRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS
        /// account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the notification rule. Notifictaion rule names must be unique in your AWS
        /// account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `EventTypeIds`.
        ///
        /// To override the contents of this collection use [`set_event_type_ids`](Self::set_event_type_ids).
        ///
        /// <p>A list of event types associated with this notification rule. For a list of allowed
        /// events, see <a>EventTypeSummary</a>.</p>
        pub fn event_type_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_ids(inp);
            self
        }
        /// <p>A list of event types associated with this notification rule. For a list of allowed
        /// events, see <a>EventTypeSummary</a>.</p>
        pub fn set_event_type_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_type_ids(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline,
        /// repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
        pub fn resource(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline,
        /// repositories in AWS CodeCommit, and build projects in AWS CodeBuild.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the
        /// notification rule.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of SNS topics to associate with the
        /// notification rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn detail_type(mut self, inp: crate::model::DetailType) -> Self {
            self.inner = self.inner.detail_type(inp);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn set_detail_type(
            mut self,
            input: std::option::Option<crate::model::DetailType>,
        ) -> Self {
            self.inner = self.inner.set_detail_type(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request with the same
        /// parameters is received and a token is included, the request returns information about
        /// the initial request that used that token.</p>
        /// <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
        /// idempotency token is created for you.</p>
        /// </note>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request with the same
        /// parameters is received and a token is included, the request returns information about
        /// the initial request that used that token.</p>
        /// <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
        /// idempotency token is created for you.</p>
        /// </note>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of tags to apply to this notification rule. Key names cannot start with "aws". </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The status of the notification rule. The default value is ENABLED. If the status is
        /// set to DISABLED, notifications aren't sent for the notification rule.</p>
        pub fn status(mut self, inp: crate::model::NotificationRuleStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the notification rule. The default value is ENABLED. If the status is
        /// set to DISABLED, notifications aren't sent for the notification rule.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotificationRuleStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotificationRule`.
    ///
    /// <p>Deletes a notification rule for a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNotificationRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_notification_rule_input::Builder,
    }
    impl<C, M, R> DeleteNotificationRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNotificationRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNotificationRuleInputOperationOutputAlias,
                crate::output::DeleteNotificationRuleOutput,
                crate::error::DeleteNotificationRuleError,
                crate::input::DeleteNotificationRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule you want to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTarget`.
    ///
    /// <p>Deletes a specified target for notifications.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_target_input::Builder,
    }
    impl<C, M, R> DeleteTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTargetInputOperationOutputAlias,
                crate::output::DeleteTargetOutput,
                crate::error::DeleteTargetError,
                crate::input::DeleteTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
        pub fn target_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_address(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to delete.</p>
        pub fn set_target_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_address(input);
            self
        }
        /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The
        /// default value is FALSE. If set to TRUE, all associations between that target and every
        /// notification rule in your AWS account are deleted.</p>
        pub fn force_unsubscribe_all(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_unsubscribe_all(inp);
            self
        }
        /// <p>A Boolean value that can be used to delete all associations with this SNS topic. The
        /// default value is FALSE. If set to TRUE, all associations between that target and every
        /// notification rule in your AWS account are deleted.</p>
        pub fn set_force_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_unsubscribe_all(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotificationRule`.
    ///
    /// <p>Returns information about a specified notification rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeNotificationRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_notification_rule_input::Builder,
    }
    impl<C, M, R> DescribeNotificationRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNotificationRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNotificationRuleInputOperationOutputAlias,
                crate::output::DescribeNotificationRuleOutput,
                crate::error::DescribeNotificationRuleError,
                crate::input::DescribeNotificationRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventTypes`.
    ///
    /// <p>Returns information about the event types available for configuring notifications.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEventTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_event_types_input::Builder,
    }
    impl<C, M, R> ListEventTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventTypesInputOperationOutputAlias,
                crate::output::ListEventTypesOutput,
                crate::error::ListEventTypesError,
                crate::input::ListEventTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ListEventTypesFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to return information by service or resource type.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListEventTypesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotificationRules`.
    ///
    /// <p>Returns a list of the notification rules for an AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNotificationRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_notification_rules_input::Builder,
    }
    impl<C, M, R> ListNotificationRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNotificationRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNotificationRulesInputOperationOutputAlias,
                crate::output::ListNotificationRulesOutput,
                crate::error::ListNotificationRulesError,
                crate::input::ListNotificationRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type. For valid values,
        /// see <a>ListNotificationRulesFilter</a>.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn filters(
            mut self,
            inp: impl Into<crate::model::ListNotificationRulesFilter>,
        ) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to return information by service or resource type. For valid values,
        /// see <a>ListNotificationRulesFilter</a>.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListNotificationRulesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags associated with a notification rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargets`.
    ///
    /// <p>Returns a list of the notification rule targets for an AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_targets_input::Builder,
    }
    impl<C, M, R> ListTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTargetsInputOperationOutputAlias,
                crate::output::ListTargetsOutput,
                crate::error::ListTargetsError,
                crate::input::ListTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to return information by service or resource type. Valid filters
        /// include target type, target address, and target status.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn filters(mut self, inp: impl Into<crate::model::ListTargetsFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to return information by service or resource type. Valid filters
        /// include target type, target address, and target status.</p>
        /// <note>
        /// <p>A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListTargetsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-negative integer used to limit the number of returned results. The maximum number of
        /// results that can be returned is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Subscribe`.
    ///
    /// <p>Creates an association between a notification rule and an SNS topic so that the
    /// associated target can receive notifications when the events described in the rule are
    /// triggered.</p>
    #[derive(std::fmt::Debug)]
    pub struct Subscribe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::subscribe_input::Builder,
    }
    impl<C, M, R> Subscribe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Subscribe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubscribeOutput,
            aws_smithy_http::result::SdkError<crate::error::SubscribeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SubscribeInputOperationOutputAlias,
                crate::output::SubscribeOutput,
                crate::error::SubscribeError,
                crate::input::SubscribeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Information about the SNS topics associated with a  notification rule.</p>
        pub fn target(mut self, inp: crate::model::Target) -> Self {
            self.inner = self.inner.target(inp);
            self
        }
        /// <p>Information about the SNS topics associated with a  notification rule.</p>
        pub fn set_target(mut self, input: std::option::Option<crate::model::Target>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a set of provided tags with a notification rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule to tag.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The list of tags to associate with the resource. Tag key names cannot start with "aws".</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Unsubscribe`.
    ///
    /// <p>Removes an association between a notification rule and an Amazon SNS topic so that
    /// subscribers to that topic stop receiving notifications when the events described in the
    /// rule are triggered.</p>
    #[derive(std::fmt::Debug)]
    pub struct Unsubscribe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unsubscribe_input::Builder,
    }
    impl<C, M, R> Unsubscribe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Unsubscribe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnsubscribeOutput,
            aws_smithy_http::result::SdkError<crate::error::UnsubscribeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnsubscribeInputOperationOutputAlias,
                crate::output::UnsubscribeOutput,
                crate::error::UnsubscribeError,
                crate::input::UnsubscribeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
        pub fn target_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_address(inp);
            self
        }
        /// <p>The ARN of the SNS topic to unsubscribe from the notification rule.</p>
        pub fn set_target_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the association between one or more provided tags and a notification
    /// rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the
        /// tags.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule from which to remove the
        /// tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key names of the tags to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The key names of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNotificationRule`.
    ///
    /// <p>Updates a notification rule for a resource. You can change the events that trigger the
    /// notification rule, the status of the rule, and the targets that receive the
    /// notifications.</p>
    /// <note>
    /// <p>To add or remove tags for a notification rule, you must use <a>TagResource</a> and <a>UntagResource</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNotificationRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_notification_rule_input::Builder,
    }
    impl<C, M, R> UpdateNotificationRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNotificationRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNotificationRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNotificationRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNotificationRuleInputOperationOutputAlias,
                crate::output::UpdateNotificationRuleOutput,
                crate::error::UpdateNotificationRuleError,
                crate::input::UpdateNotificationRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the notification rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or
        /// disabled (not sending notifications).</p>
        pub fn status(mut self, inp: crate::model::NotificationRuleStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the notification rule. Valid statuses include enabled (sending notifications) or
        /// disabled (not sending notifications).</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NotificationRuleStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `EventTypeIds`.
        ///
        /// To override the contents of this collection use [`set_event_type_ids`](Self::set_event_type_ids).
        ///
        /// <p>A list of event types associated with this notification rule.</p>
        pub fn event_type_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_ids(inp);
            self
        }
        /// <p>A list of event types associated with this notification rule.</p>
        pub fn set_event_type_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_type_ids(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The address and type of the targets to receive notifications from this notification
        /// rule.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The address and type of the targets to receive notifications from this notification
        /// rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn detail_type(mut self, inp: crate::model::DetailType) -> Self {
            self.inner = self.inner.detail_type(inp);
            self
        }
        /// <p>The level of detail to include in the notifications for this resource. BASIC will include only the
        /// contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
        /// provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.</p>
        pub fn set_detail_type(
            mut self,
            input: std::option::Option<crate::model::DetailType>,
        ) -> Self {
            self.inner = self.inner.set_detail_type(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
