// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connection`](crate::client::Client::create_connection).
///
/// See [`crate::client::fluent_builders::CreateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnection {
    _private: (),
}
impl CreateConnection {
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
    /// Creates a new `CreateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnection {
    type Output = std::result::Result<
        crate::output::CreateConnectionOutput,
        crate::error::CreateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connection_error(response)
        } else {
            crate::operation_deser::parse_create_connection_response(response)
        }
    }
}

/// Operation shape for `CreateHost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_host`](crate::client::Client::create_host).
///
/// See [`crate::client::fluent_builders::CreateHost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHost {
    _private: (),
}
impl CreateHost {
    /// Creates a new builder-style object to manufacture [`CreateHostInput`](crate::input::CreateHostInput)
    pub fn builder() -> crate::input::create_host_input::Builder {
        crate::input::create_host_input::Builder::default()
    }
    /// Creates a new `CreateHost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHost {
    type Output =
        std::result::Result<crate::output::CreateHostOutput, crate::error::CreateHostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_host_error(response)
        } else {
            crate::operation_deser::parse_create_host_response(response)
        }
    }
}

/// Operation shape for `DeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection`](crate::client::Client::delete_connection).
///
/// See [`crate::client::fluent_builders::DeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnection {
    _private: (),
}
impl DeleteConnection {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
    /// Creates a new `DeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnection {
    type Output = std::result::Result<
        crate::output::DeleteConnectionOutput,
        crate::error::DeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteHost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_host`](crate::client::Client::delete_host).
///
/// See [`crate::client::fluent_builders::DeleteHost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHost {
    _private: (),
}
impl DeleteHost {
    /// Creates a new builder-style object to manufacture [`DeleteHostInput`](crate::input::DeleteHostInput)
    pub fn builder() -> crate::input::delete_host_input::Builder {
        crate::input::delete_host_input::Builder::default()
    }
    /// Creates a new `DeleteHost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHost {
    type Output =
        std::result::Result<crate::output::DeleteHostOutput, crate::error::DeleteHostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_host_error(response)
        } else {
            crate::operation_deser::parse_delete_host_response(response)
        }
    }
}

/// Operation shape for `GetConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connection`](crate::client::Client::get_connection).
///
/// See [`crate::client::fluent_builders::GetConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnection {
    _private: (),
}
impl GetConnection {
    /// Creates a new builder-style object to manufacture [`GetConnectionInput`](crate::input::GetConnectionInput)
    pub fn builder() -> crate::input::get_connection_input::Builder {
        crate::input::get_connection_input::Builder::default()
    }
    /// Creates a new `GetConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnection {
    type Output =
        std::result::Result<crate::output::GetConnectionOutput, crate::error::GetConnectionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connection_error(response)
        } else {
            crate::operation_deser::parse_get_connection_response(response)
        }
    }
}

/// Operation shape for `GetHost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_host`](crate::client::Client::get_host).
///
/// See [`crate::client::fluent_builders::GetHost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHost {
    _private: (),
}
impl GetHost {
    /// Creates a new builder-style object to manufacture [`GetHostInput`](crate::input::GetHostInput)
    pub fn builder() -> crate::input::get_host_input::Builder {
        crate::input::get_host_input::Builder::default()
    }
    /// Creates a new `GetHost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHost {
    type Output = std::result::Result<crate::output::GetHostOutput, crate::error::GetHostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_host_error(response)
        } else {
            crate::operation_deser::parse_get_host_response(response)
        }
    }
}

/// Operation shape for `ListConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_connections`](crate::client::Client::list_connections).
///
/// See [`crate::client::fluent_builders::ListConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConnections {
    _private: (),
}
impl ListConnections {
    /// Creates a new builder-style object to manufacture [`ListConnectionsInput`](crate::input::ListConnectionsInput)
    pub fn builder() -> crate::input::list_connections_input::Builder {
        crate::input::list_connections_input::Builder::default()
    }
    /// Creates a new `ListConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConnections {
    type Output = std::result::Result<
        crate::output::ListConnectionsOutput,
        crate::error::ListConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_connections_error(response)
        } else {
            crate::operation_deser::parse_list_connections_response(response)
        }
    }
}

/// Operation shape for `ListHosts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hosts`](crate::client::Client::list_hosts).
///
/// See [`crate::client::fluent_builders::ListHosts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHosts {
    _private: (),
}
impl ListHosts {
    /// Creates a new builder-style object to manufacture [`ListHostsInput`](crate::input::ListHostsInput)
    pub fn builder() -> crate::input::list_hosts_input::Builder {
        crate::input::list_hosts_input::Builder::default()
    }
    /// Creates a new `ListHosts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHosts {
    type Output = std::result::Result<crate::output::ListHostsOutput, crate::error::ListHostsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hosts_error(response)
        } else {
            crate::operation_deser::parse_list_hosts_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateHost`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_host`](crate::client::Client::update_host).
///
/// See [`crate::client::fluent_builders::UpdateHost`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateHost {
    _private: (),
}
impl UpdateHost {
    /// Creates a new builder-style object to manufacture [`UpdateHostInput`](crate::input::UpdateHostInput)
    pub fn builder() -> crate::input::update_host_input::Builder {
        crate::input::update_host_input::Builder::default()
    }
    /// Creates a new `UpdateHost` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateHost {
    type Output =
        std::result::Result<crate::output::UpdateHostOutput, crate::error::UpdateHostError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_host_error(response)
        } else {
            crate::operation_deser::parse_update_host_response(response)
        }
    }
}
