// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CodeStar_connections_20191201`.
///
/// This client allows ergonomic access to a `CodeStar_connections_20191201`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateConnection` operation.
    ///
    /// See [`CreateConnection`](crate::client::fluent_builders::CreateConnection) for more information about the
    /// operation and its arguments.
    pub fn create_connection(&self) -> fluent_builders::CreateConnection<C, M, R> {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHost` operation.
    ///
    /// See [`CreateHost`](crate::client::fluent_builders::CreateHost) for more information about the
    /// operation and its arguments.
    pub fn create_host(&self) -> fluent_builders::CreateHost<C, M, R> {
        fluent_builders::CreateHost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnection` operation.
    ///
    /// See [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection<C, M, R> {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHost` operation.
    ///
    /// See [`DeleteHost`](crate::client::fluent_builders::DeleteHost) for more information about the
    /// operation and its arguments.
    pub fn delete_host(&self) -> fluent_builders::DeleteHost<C, M, R> {
        fluent_builders::DeleteHost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnection` operation.
    ///
    /// See [`GetConnection`](crate::client::fluent_builders::GetConnection) for more information about the
    /// operation and its arguments.
    pub fn get_connection(&self) -> fluent_builders::GetConnection<C, M, R> {
        fluent_builders::GetConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHost` operation.
    ///
    /// See [`GetHost`](crate::client::fluent_builders::GetHost) for more information about the
    /// operation and its arguments.
    pub fn get_host(&self) -> fluent_builders::GetHost<C, M, R> {
        fluent_builders::GetHost::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnections` operation.
    ///
    /// See [`ListConnections`](crate::client::fluent_builders::ListConnections) for more information about the
    /// operation and its arguments.
    pub fn list_connections(&self) -> fluent_builders::ListConnections<C, M, R> {
        fluent_builders::ListConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHosts` operation.
    ///
    /// See [`ListHosts`](crate::client::fluent_builders::ListHosts) for more information about the
    /// operation and its arguments.
    pub fn list_hosts(&self) -> fluent_builders::ListHosts<C, M, R> {
        fluent_builders::ListHosts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateHost` operation.
    ///
    /// See [`UpdateHost`](crate::client::fluent_builders::UpdateHost) for more information about the
    /// operation and its arguments.
    pub fn update_host(&self) -> fluent_builders::UpdateHost<C, M, R> {
        fluent_builders::UpdateHost::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection that can then be given to other AWS services like CodePipeline so
    /// that it can access third-party code repositories. The connection is in pending status until
    /// the third-party connection handshake is completed from the console.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl<C, M, R> CreateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectionInputOperationOutputAlias,
                crate::output::CreateConnectionOutput,
                crate::error::CreateConnectionError,
                crate::input::CreateConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the external provider where your third-party code repository is
        /// configured.</p>
        pub fn provider_type(mut self, inp: crate::model::ProviderType) -> Self {
            self.inner = self.inner.provider_type(inp);
            self
        }
        /// <p>The name of the external provider where your third-party code repository is
        /// configured.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.inner = self.inner.set_provider_type(input);
            self
        }
        /// <p>The name of the connection to be created. The name must be unique in the calling AWS
        /// account.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>The name of the connection to be created. The name must be unique in the calling AWS
        /// account.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair to use when tagging the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair to use when tagging the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the host associated with the connection to be created.</p>
        pub fn host_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the host associated with the connection to be created.</p>
        pub fn set_host_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHost`.
    ///
    /// <p>Creates a resource that represents the infrastructure where a third-party provider is
    /// installed. The host is used when you create connections to an installed third-party provider
    /// type, such as GitHub Enterprise Server. You create one host for all connections to that
    /// provider.</p>
    /// <note>
    /// <p>A host created through the CLI or the SDK is in `PENDING` status by
    /// default. You can make its status `AVAILABLE` by setting up the host in the console.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateHost<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_host_input::Builder,
    }
    impl<C, M, R> CreateHost<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHostOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHostError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHostInputOperationOutputAlias,
                crate::output::CreateHostOutput,
                crate::error::CreateHostError,
                crate::input::CreateHostInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the host to be created. The name must be unique in the calling AWS
        /// account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the host to be created. The name must be unique in the calling AWS
        /// account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the installed provider to be associated with your connection. The host
        /// resource represents the infrastructure where your provider type is installed. The valid
        /// provider type is GitHub Enterprise Server.</p>
        pub fn provider_type(mut self, inp: crate::model::ProviderType) -> Self {
            self.inner = self.inner.provider_type(inp);
            self
        }
        /// <p>The name of the installed provider to be associated with your connection. The host
        /// resource represents the infrastructure where your provider type is installed. The valid
        /// provider type is GitHub Enterprise Server.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.inner = self.inner.set_provider_type(input);
            self
        }
        /// <p>The endpoint of the infrastructure to be represented by the host after it is
        /// created.</p>
        pub fn provider_endpoint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_endpoint(inp);
            self
        }
        /// <p>The endpoint of the infrastructure to be represented by the host after it is
        /// created.</p>
        pub fn set_provider_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_endpoint(input);
            self
        }
        /// <p>The VPC configuration to be provisioned for the host. A VPC must be configured and the
        /// infrastructure to be represented by the host must already be connected to the VPC.</p>
        pub fn vpc_configuration(mut self, inp: crate::model::VpcConfiguration) -> Self {
            self.inner = self.inner.vpc_configuration(inp);
            self
        }
        /// <p>The VPC configuration to be provisioned for the host. A VPC must be configured and the
        /// infrastructure to be represented by the host must already be connected to the VPC.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_vpc_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        #[allow(missing_docs)] // documentation missing in model
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>The connection to be deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl<C, M, R> DeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionInputOperationOutputAlias,
                crate::output::DeleteConnectionOutput,
                crate::error::DeleteConnectionError,
                crate::input::DeleteConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the connection to be deleted.</p>
        /// <note>
        /// <p>The ARN is never reused if the connection is deleted.</p>
        /// </note>
        pub fn connection_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connection to be deleted.</p>
        /// <note>
        /// <p>The ARN is never reused if the connection is deleted.</p>
        /// </note>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHost`.
    ///
    /// <p>The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.</p>
    /// <note>
    /// <p>A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteHost<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_host_input::Builder,
    }
    impl<C, M, R> DeleteHost<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHostOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHostError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHostInputOperationOutputAlias,
                crate::output::DeleteHostOutput,
                crate::error::DeleteHostError,
                crate::input::DeleteHostInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the host to be deleted.</p>
        pub fn host_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the host to be deleted.</p>
        pub fn set_host_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnection`.
    ///
    /// <p>Returns the connection ARN and details such as status, owner, and provider type.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connection_input::Builder,
    }
    impl<C, M, R> GetConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectionInputOperationOutputAlias,
                crate::output::GetConnectionOutput,
                crate::error::GetConnectionError,
                crate::input::GetConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of a connection.</p>
        pub fn connection_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHost`.
    ///
    /// <p>Returns the host ARN and details such as status, provider type, endpoint, and, if
    /// applicable, the VPC configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetHost<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_host_input::Builder,
    }
    impl<C, M, R> GetHost<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHostInputOperationOutputAlias,
                crate::output::GetHostOutput,
                crate::error::GetHostError,
                crate::input::GetHostInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the requested host.</p>
        pub fn host_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the requested host.</p>
        pub fn set_host_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnections`.
    ///
    /// <p>Lists the connections associated with your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connections_input::Builder,
    }
    impl<C, M, R> ListConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectionsInputOperationOutputAlias,
                crate::output::ListConnectionsOutput,
                crate::error::ListConnectionsError,
                crate::input::ListConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the list of connections to those associated with a specified provider, such as
        /// Bitbucket.</p>
        pub fn provider_type_filter(mut self, inp: crate::model::ProviderType) -> Self {
            self.inner = self.inner.provider_type_filter(inp);
            self
        }
        /// <p>Filters the list of connections to those associated with a specified provider, such as
        /// Bitbucket.</p>
        pub fn set_provider_type_filter(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.inner = self.inner.set_provider_type_filter(input);
            self
        }
        /// <p>Filters the list of connections to those associated with a specified host.</p>
        pub fn host_arn_filter(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_arn_filter(inp);
            self
        }
        /// <p>Filters the list of connections to those associated with a specified host.</p>
        pub fn set_host_arn_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_host_arn_filter(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that was returned from the previous <code>ListConnections</code> call, which
        /// can be used to return the next set of connections in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that was returned from the previous <code>ListConnections</code> call, which
        /// can be used to return the next set of connections in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHosts`.
    ///
    /// <p>Lists the hosts associated with your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListHosts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hosts_input::Builder,
    }
    impl<C, M, R> ListHosts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHosts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHostsInputOperationOutputAlias,
                crate::output::ListHostsOutput,
                crate::error::ListHostsError,
                crate::input::ListHostsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that was returned from the previous <code>ListHosts</code> call, which can be
        /// used to return the next set of hosts in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that was returned from the previous <code>ListHosts</code> call, which can be
        /// used to return the next set of hosts in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets the set of key-value pairs (metadata) that are used to manage the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used
    /// to manage a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an AWS resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys for the tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of keys for the tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHost`.
    ///
    /// <p>Updates a specified host with the provided configurations.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateHost<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_host_input::Builder,
    }
    impl<C, M, R> UpdateHost<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateHost`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHostOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHostError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateHostInputOperationOutputAlias,
                crate::output::UpdateHostOutput,
                crate::error::UpdateHostError,
                crate::input::UpdateHostInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the host to be updated.</p>
        pub fn host_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the host to be updated.</p>
        pub fn set_host_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host_arn(input);
            self
        }
        /// <p>The URL or endpoint of the host to be updated.</p>
        pub fn provider_endpoint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_endpoint(inp);
            self
        }
        /// <p>The URL or endpoint of the host to be updated.</p>
        pub fn set_provider_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_endpoint(input);
            self
        }
        /// <p>The VPC configuration of the host to be updated. A VPC must be configured and the
        /// infrastructure to be represented by the host must already be connected to the VPC.</p>
        pub fn vpc_configuration(mut self, inp: crate::model::VpcConfiguration) -> Self {
            self.inner = self.inner.vpc_configuration(inp);
            self
        }
        /// <p>The VPC configuration of the host to be updated. A VPC must be configured and the
        /// infrastructure to be represented by the host must already be connected to the VPC.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_vpc_configuration(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
