// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS CodeStar
///
/// Client for invoking operations on AWS CodeStar. Each operation on AWS CodeStar is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codestar::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codestar::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codestar::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateTeamMember`](crate::client::fluent_builders::AssociateTeamMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTeamMember::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::AssociateTeamMember::set_project_id): <p>The ID of the project to which you will add the IAM user.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::AssociateTeamMember::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::AssociateTeamMember::set_client_request_token): <p>A user- or system-generated token that identifies the entity that requested the team member association to the project. This token can be used to repeat the request.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateTeamMember::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::AssociateTeamMember::set_user_arn): <p>The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.</p>
    ///   - [`project_role(impl Into<String>)`](crate::client::fluent_builders::AssociateTeamMember::project_role) / [`set_project_role(Option<String>)`](crate::client::fluent_builders::AssociateTeamMember::set_project_role): <p>The AWS CodeStar project role that will apply to this user. This role determines what actions a user can take in an AWS CodeStar project.</p>
    ///   - [`remote_access_allowed(bool)`](crate::client::fluent_builders::AssociateTeamMember::remote_access_allowed) / [`set_remote_access_allowed(Option<bool>)`](crate::client::fluent_builders::AssociateTeamMember::set_remote_access_allowed): <p>Whether the team member is allowed to use an SSH public/private key pair to remotely access project resources, for example Amazon EC2 instances.</p>
    /// - On success, responds with [`AssociateTeamMemberOutput`](crate::output::AssociateTeamMemberOutput) with field(s):
    ///   - [`client_request_token(Option<String>)`](crate::output::AssociateTeamMemberOutput::client_request_token): <p>The user- or system-generated token from the initial request that can be used to repeat the request.</p>
    /// - On failure, responds with [`SdkError<AssociateTeamMemberError>`](crate::error::AssociateTeamMemberError)
    pub fn associate_team_member(&self) -> fluent_builders::AssociateTeamMember<C, M, R> {
        fluent_builders::AssociateTeamMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProject`](crate::client::fluent_builders::CreateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_name): <p>The display name for the project to be created in AWS CodeStar.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateProject::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateProject::set_id): <p>The ID of the project to be created in AWS CodeStar.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateProject::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateProject::set_description): <p>The description of the project, if any.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateProject::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateProject::set_client_request_token): <p>A user- or system-generated token that identifies the entity that requested project creation. This token can be used to repeat the request.</p>
    ///   - [`source_code(Vec<Code>)`](crate::client::fluent_builders::CreateProject::source_code) / [`set_source_code(Option<Vec<Code>>)`](crate::client::fluent_builders::CreateProject::set_source_code): <p>A list of the Code objects submitted with the project request. If this parameter is specified, the request must also include the toolchain parameter.</p>
    ///   - [`toolchain(Toolchain)`](crate::client::fluent_builders::CreateProject::toolchain) / [`set_toolchain(Option<Toolchain>)`](crate::client::fluent_builders::CreateProject::set_toolchain): <p>The name of the toolchain template file submitted with the project request. If this parameter is specified, the request must also include the sourceCode parameter.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateProject::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProject::set_tags): <p>The tags created for the project.</p>
    /// - On success, responds with [`CreateProjectOutput`](crate::output::CreateProjectOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateProjectOutput::id): <p>The ID of the project.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateProjectOutput::arn): <p>The Amazon Resource Name (ARN) of the created project.</p>
    ///   - [`client_request_token(Option<String>)`](crate::output::CreateProjectOutput::client_request_token): <p>A user- or system-generated token that identifies the entity that requested project creation.</p>
    ///   - [`project_template_id(Option<String>)`](crate::output::CreateProjectOutput::project_template_id): <p>Reserved for future use.</p>
    /// - On failure, responds with [`SdkError<CreateProjectError>`](crate::error::CreateProjectError)
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserProfile`](crate::client::fluent_builders::CreateUserProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::CreateUserProfile::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::CreateUserProfile::set_user_arn): <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateUserProfile::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateUserProfile::set_display_name): <p>The name that will be displayed as the friendly name for the user in AWS CodeStar. </p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::CreateUserProfile::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::CreateUserProfile::set_email_address): <p>The email address that will be displayed as part of the user's profile in AWS CodeStar.</p>
    ///   - [`ssh_public_key(impl Into<String>)`](crate::client::fluent_builders::CreateUserProfile::ssh_public_key) / [`set_ssh_public_key(Option<String>)`](crate::client::fluent_builders::CreateUserProfile::set_ssh_public_key): <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
    /// - On success, responds with [`CreateUserProfileOutput`](crate::output::CreateUserProfileOutput) with field(s):
    ///   - [`user_arn(Option<String>)`](crate::output::CreateUserProfileOutput::user_arn): <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    ///   - [`display_name(Option<String>)`](crate::output::CreateUserProfileOutput::display_name): <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
    ///   - [`email_address(Option<String>)`](crate::output::CreateUserProfileOutput::email_address): <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
    ///   - [`ssh_public_key(Option<String>)`](crate::output::CreateUserProfileOutput::ssh_public_key): <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the public/private keypair the user can use to access project resources if a project owner allows the user remote access to those resources.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::CreateUserProfileOutput::created_timestamp): <p>The date the user profile was created, in timestamp format.</p>
    ///   - [`last_modified_timestamp(Option<DateTime>)`](crate::output::CreateUserProfileOutput::last_modified_timestamp): <p>The date the user profile was last modified, in timestamp format.</p>
    /// - On failure, responds with [`SdkError<CreateUserProfileError>`](crate::error::CreateUserProfileError)
    pub fn create_user_profile(&self) -> fluent_builders::CreateUserProfile<C, M, R> {
        fluent_builders::CreateUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProject`](crate::client::fluent_builders::DeleteProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_id): <p>The ID of the project to be deleted in AWS CodeStar.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_client_request_token): <p>A user- or system-generated token that identifies the entity that requested project deletion. This token can be used to repeat the request. </p>
    ///   - [`delete_stack(bool)`](crate::client::fluent_builders::DeleteProject::delete_stack) / [`set_delete_stack(bool)`](crate::client::fluent_builders::DeleteProject::set_delete_stack): <p>Whether to send a delete request for the primary stack in AWS CloudFormation originally used to generate the project and its resources. This option will delete all AWS resources for the project (except for any buckets in Amazon S3) as well as deleting the project itself. Recommended for most use cases.</p>
    /// - On success, responds with [`DeleteProjectOutput`](crate::output::DeleteProjectOutput) with field(s):
    ///   - [`stack_id(Option<String>)`](crate::output::DeleteProjectOutput::stack_id): <p>The ID of the primary stack in AWS CloudFormation that will be deleted as part of deleting the project and its resources.</p>
    ///   - [`project_arn(Option<String>)`](crate::output::DeleteProjectOutput::project_arn): <p>The Amazon Resource Name (ARN) of the deleted project.</p>
    /// - On failure, responds with [`SdkError<DeleteProjectError>`](crate::error::DeleteProjectError)
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserProfile`](crate::client::fluent_builders::DeleteUserProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteUserProfile::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::DeleteUserProfile::set_user_arn): <p>The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.</p>
    /// - On success, responds with [`DeleteUserProfileOutput`](crate::output::DeleteUserProfileOutput) with field(s):
    ///   - [`user_arn(Option<String>)`](crate::output::DeleteUserProfileOutput::user_arn): <p>The Amazon Resource Name (ARN) of the user deleted from AWS CodeStar.</p>
    /// - On failure, responds with [`SdkError<DeleteUserProfileError>`](crate::error::DeleteUserProfileError)
    pub fn delete_user_profile(&self) -> fluent_builders::DeleteUserProfile<C, M, R> {
        fluent_builders::DeleteUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProject`](crate::client::fluent_builders::DescribeProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeProject::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeProject::set_id): <p>The ID of the project.</p>
    /// - On success, responds with [`DescribeProjectOutput`](crate::output::DescribeProjectOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeProjectOutput::name): <p>The display name for the project.</p>
    ///   - [`id(Option<String>)`](crate::output::DescribeProjectOutput::id): <p>The ID of the project.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeProjectOutput::arn): <p>The Amazon Resource Name (ARN) for the project.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeProjectOutput::description): <p>The description of the project, if any.</p>
    ///   - [`client_request_token(Option<String>)`](crate::output::DescribeProjectOutput::client_request_token): <p>A user- or system-generated token that identifies the entity that requested project creation. </p>
    ///   - [`created_time_stamp(Option<DateTime>)`](crate::output::DescribeProjectOutput::created_time_stamp): <p>The date and time the project was created, in timestamp format.</p>
    ///   - [`stack_id(Option<String>)`](crate::output::DescribeProjectOutput::stack_id): <p>The ID of the primary stack in AWS CloudFormation used to generate resources for the project.</p>
    ///   - [`project_template_id(Option<String>)`](crate::output::DescribeProjectOutput::project_template_id): <p>The ID for the AWS CodeStar project template used to create the project.</p>
    ///   - [`status(Option<ProjectStatus>)`](crate::output::DescribeProjectOutput::status): <p>The project creation or deletion status.</p>
    /// - On failure, responds with [`SdkError<DescribeProjectError>`](crate::error::DescribeProjectError)
    pub fn describe_project(&self) -> fluent_builders::DescribeProject<C, M, R> {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserProfile`](crate::client::fluent_builders::DescribeUserProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeUserProfile::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeUserProfile::set_user_arn): <p>The Amazon Resource Name (ARN) of the user.</p>
    /// - On success, responds with [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput) with field(s):
    ///   - [`user_arn(Option<String>)`](crate::output::DescribeUserProfileOutput::user_arn): <p>The Amazon Resource Name (ARN) of the user.</p>
    ///   - [`display_name(Option<String>)`](crate::output::DescribeUserProfileOutput::display_name): <p>The display name shown for the user in AWS CodeStar projects. For example, this could be set to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first character that appears after the space will be used as the second character in the user initial icon. The initial icon displays a maximum of two characters, so a display name with more than one space (for example "Mary Jane Major") would generate an initial icon using the first character and the first character after the space ("MJ", not "MM").</p>
    ///   - [`email_address(Option<String>)`](crate::output::DescribeUserProfileOutput::email_address): <p>The email address for the user. Optional.</p>
    ///   - [`ssh_public_key(Option<String>)`](crate::output::DescribeUserProfileOutput::ssh_public_key): <p>The SSH public key associated with the user. This SSH public key is associated with the user profile, and can be used in conjunction with the associated private key for access to project resources, such as Amazon EC2 instances, if a project owner grants remote access to those resources.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::DescribeUserProfileOutput::created_timestamp): <p>The date and time when the user profile was created in AWS CodeStar, in timestamp format.</p>
    ///   - [`last_modified_timestamp(Option<DateTime>)`](crate::output::DescribeUserProfileOutput::last_modified_timestamp): <p>The date and time when the user profile was last modified, in timestamp format.</p>
    /// - On failure, responds with [`SdkError<DescribeUserProfileError>`](crate::error::DescribeUserProfileError)
    pub fn describe_user_profile(&self) -> fluent_builders::DescribeUserProfile<C, M, R> {
        fluent_builders::DescribeUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateTeamMember`](crate::client::fluent_builders::DisassociateTeamMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateTeamMember::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::DisassociateTeamMember::set_project_id): <p>The ID of the AWS CodeStar project from which you want to remove a team member.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateTeamMember::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::DisassociateTeamMember::set_user_arn): <p>The Amazon Resource Name (ARN) of the IAM user or group whom you want to remove from the project.</p>
    /// - On success, responds with [`DisassociateTeamMemberOutput`](crate::output::DisassociateTeamMemberOutput)

    /// - On failure, responds with [`SdkError<DisassociateTeamMemberError>`](crate::error::DisassociateTeamMemberError)
    pub fn disassociate_team_member(&self) -> fluent_builders::DisassociateTeamMember<C, M, R> {
        fluent_builders::DisassociateTeamMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProjects`](crate::client::fluent_builders::ListProjects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProjects::set_next_token): <p>The continuation token to be used to return the next set of results, if the results cannot be returned in one response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProjects::set_max_results): <p>The maximum amount of data that can be contained in a single set of results.</p>
    /// - On success, responds with [`ListProjectsOutput`](crate::output::ListProjectsOutput) with field(s):
    ///   - [`projects(Option<Vec<ProjectSummary>>)`](crate::output::ListProjectsOutput::projects): <p>A list of projects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProjectsOutput::next_token): <p>The continuation token to use when requesting the next set of results, if there are more results to be returned.</p>
    /// - On failure, responds with [`SdkError<ListProjectsError>`](crate::error::ListProjectsError)
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResources`](crate::client::fluent_builders::ListResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::ListResources::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::ListResources::set_project_id): <p>The ID of the project.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResources::set_next_token): <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResources::set_max_results): <p>The maximum amount of data that can be contained in a single set of results.</p>
    /// - On success, responds with [`ListResourcesOutput`](crate::output::ListResourcesOutput) with field(s):
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::ListResourcesOutput::resources): <p>An array of resources associated with the project. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourcesOutput::next_token): <p>The continuation token to use when requesting the next set of results, if there are more results to be returned.</p>
    /// - On failure, responds with [`SdkError<ListResourcesError>`](crate::error::ListResourcesError)
    pub fn list_resources(&self) -> fluent_builders::ListResources<C, M, R> {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForProject`](crate::client::fluent_builders::ListTagsForProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ListTagsForProject::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ListTagsForProject::set_id): <p>The ID of the project to get tags for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForProject::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForProject::set_next_token): <p>Reserved for future use.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForProject::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForProject::set_max_results): <p>Reserved for future use.</p>
    /// - On success, responds with [`ListTagsForProjectOutput`](crate::output::ListTagsForProjectOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForProjectOutput::tags): <p>The tags for the project.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForProjectOutput::next_token): <p>Reserved for future use.</p>
    /// - On failure, responds with [`SdkError<ListTagsForProjectError>`](crate::error::ListTagsForProjectError)
    pub fn list_tags_for_project(&self) -> fluent_builders::ListTagsForProject<C, M, R> {
        fluent_builders::ListTagsForProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTeamMembers`](crate::client::fluent_builders::ListTeamMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::ListTeamMembers::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::ListTeamMembers::set_project_id): <p>The ID of the project for which you want to list team members.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTeamMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTeamMembers::set_next_token): <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTeamMembers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTeamMembers::set_max_results): <p>The maximum number of team members you want returned in a response.</p>
    /// - On success, responds with [`ListTeamMembersOutput`](crate::output::ListTeamMembersOutput) with field(s):
    ///   - [`team_members(Option<Vec<TeamMember>>)`](crate::output::ListTeamMembersOutput::team_members): <p>A list of team member objects for the project.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTeamMembersOutput::next_token): <p>The continuation token to use when requesting the next set of results, if there are more results to be returned.</p>
    /// - On failure, responds with [`SdkError<ListTeamMembersError>`](crate::error::ListTeamMembersError)
    pub fn list_team_members(&self) -> fluent_builders::ListTeamMembers<C, M, R> {
        fluent_builders::ListTeamMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUserProfiles`](crate::client::fluent_builders::ListUserProfiles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUserProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUserProfiles::set_next_token): <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUserProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUserProfiles::set_max_results): <p>The maximum number of results to return in a response.</p>
    /// - On success, responds with [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput) with field(s):
    ///   - [`user_profiles(Option<Vec<UserProfileSummary>>)`](crate::output::ListUserProfilesOutput::user_profiles): <p>All the user profiles configured in AWS CodeStar for an AWS account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUserProfilesOutput::next_token): <p>The continuation token to use when requesting the next set of results, if there are more results to be returned.</p>
    /// - On failure, responds with [`SdkError<ListUserProfilesError>`](crate::error::ListUserProfilesError)
    pub fn list_user_profiles(&self) -> fluent_builders::ListUserProfiles<C, M, R> {
        fluent_builders::ListUserProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagProject`](crate::client::fluent_builders::TagProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::TagProject::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::TagProject::set_id): <p>The ID of the project you want to add a tag to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagProject::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagProject::set_tags): <p>The tags you want to add to the project.</p>
    /// - On success, responds with [`TagProjectOutput`](crate::output::TagProjectOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::TagProjectOutput::tags): <p>The tags for the project.</p>
    /// - On failure, responds with [`SdkError<TagProjectError>`](crate::error::TagProjectError)
    pub fn tag_project(&self) -> fluent_builders::TagProject<C, M, R> {
        fluent_builders::TagProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagProject`](crate::client::fluent_builders::UntagProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UntagProject::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UntagProject::set_id): <p>The ID of the project to remove tags from.</p>
    ///   - [`tags(Vec<String>)`](crate::client::fluent_builders::UntagProject::tags) / [`set_tags(Option<Vec<String>>)`](crate::client::fluent_builders::UntagProject::set_tags): <p>The tags to remove from the project.</p>
    /// - On success, responds with [`UntagProjectOutput`](crate::output::UntagProjectOutput)

    /// - On failure, responds with [`SdkError<UntagProjectError>`](crate::error::UntagProjectError)
    pub fn untag_project(&self) -> fluent_builders::UntagProject<C, M, R> {
        fluent_builders::UntagProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProject`](crate::client::fluent_builders::UpdateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_id): <p>The ID of the project you want to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_name): <p>The name of the project you want to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_description): <p>The description of the project, if any.</p>
    /// - On success, responds with [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)

    /// - On failure, responds with [`SdkError<UpdateProjectError>`](crate::error::UpdateProjectError)
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTeamMember`](crate::client::fluent_builders::UpdateTeamMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTeamMember::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::UpdateTeamMember::set_project_id): <p>The ID of the project.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTeamMember::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::UpdateTeamMember::set_user_arn): <p>The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.</p>
    ///   - [`project_role(impl Into<String>)`](crate::client::fluent_builders::UpdateTeamMember::project_role) / [`set_project_role(Option<String>)`](crate::client::fluent_builders::UpdateTeamMember::set_project_role): <p>The role assigned to the user in the project. Project roles have different levels of access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in the <i>AWS CodeStar User Guide</i>.</p>
    ///   - [`remote_access_allowed(bool)`](crate::client::fluent_builders::UpdateTeamMember::remote_access_allowed) / [`set_remote_access_allowed(Option<bool>)`](crate::client::fluent_builders::UpdateTeamMember::set_remote_access_allowed): <p>Whether a team member is allowed to remotely access project resources using the SSH public key associated with the user's profile. Even if this is set to True, the user must associate a public key with their profile before the user can access resources.</p>
    /// - On success, responds with [`UpdateTeamMemberOutput`](crate::output::UpdateTeamMemberOutput) with field(s):
    ///   - [`user_arn(Option<String>)`](crate::output::UpdateTeamMemberOutput::user_arn): <p>The Amazon Resource Name (ARN) of the user whose team membership attributes were updated.</p>
    ///   - [`project_role(Option<String>)`](crate::output::UpdateTeamMemberOutput::project_role): <p>The project role granted to the user.</p>
    ///   - [`remote_access_allowed(Option<bool>)`](crate::output::UpdateTeamMemberOutput::remote_access_allowed): <p>Whether a team member is allowed to remotely access project resources using the SSH public key associated with the user's profile.</p>
    /// - On failure, responds with [`SdkError<UpdateTeamMemberError>`](crate::error::UpdateTeamMemberError)
    pub fn update_team_member(&self) -> fluent_builders::UpdateTeamMember<C, M, R> {
        fluent_builders::UpdateTeamMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserProfile`](crate::client::fluent_builders::UpdateUserProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateUserProfile::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::UpdateUserProfile::set_user_arn): <p>The name that will be displayed as the friendly name for the user in AWS CodeStar.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateUserProfile::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateUserProfile::set_display_name): <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::UpdateUserProfile::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::UpdateUserProfile::set_email_address): <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
    ///   - [`ssh_public_key(impl Into<String>)`](crate::client::fluent_builders::UpdateUserProfile::ssh_public_key) / [`set_ssh_public_key(Option<String>)`](crate::client::fluent_builders::UpdateUserProfile::set_ssh_public_key): <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
    /// - On success, responds with [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput) with field(s):
    ///   - [`user_arn(Option<String>)`](crate::output::UpdateUserProfileOutput::user_arn): <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    ///   - [`display_name(Option<String>)`](crate::output::UpdateUserProfileOutput::display_name): <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
    ///   - [`email_address(Option<String>)`](crate::output::UpdateUserProfileOutput::email_address): <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
    ///   - [`ssh_public_key(Option<String>)`](crate::output::UpdateUserProfileOutput::ssh_public_key): <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the public/private keypair the user can use to access project resources if a project owner allows the user remote access to those resources.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::UpdateUserProfileOutput::created_timestamp): <p>The date the user profile was created, in timestamp format.</p>
    ///   - [`last_modified_timestamp(Option<DateTime>)`](crate::output::UpdateUserProfileOutput::last_modified_timestamp): <p>The date the user profile was last modified, in timestamp format.</p>
    /// - On failure, responds with [`SdkError<UpdateUserProfileError>`](crate::error::UpdateUserProfileError)
    pub fn update_user_profile(&self) -> fluent_builders::UpdateUserProfile<C, M, R> {
        fluent_builders::UpdateUserProfile::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateTeamMember`.
    ///
    /// <p>Adds an IAM user to the team for an AWS CodeStar project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTeamMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_team_member_input::Builder,
    }
    impl<C, M, R> AssociateTeamMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTeamMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTeamMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTeamMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTeamMemberInputOperationOutputAlias,
                crate::output::AssociateTeamMemberOutput,
                crate::error::AssociateTeamMemberError,
                crate::input::AssociateTeamMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to which you will add the IAM user.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project to which you will add the IAM user.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested the team member association to the project. This token can be used to repeat the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested the team member association to the project. This token can be used to repeat the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The AWS CodeStar project role that will apply to this user. This role determines what actions a user can take in an AWS CodeStar project.</p>
        pub fn project_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_role(input.into());
            self
        }
        /// <p>The AWS CodeStar project role that will apply to this user. This role determines what actions a user can take in an AWS CodeStar project.</p>
        pub fn set_project_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_role(input);
            self
        }
        /// <p>Whether the team member is allowed to use an SSH public/private key pair to remotely access project resources, for example Amazon EC2 instances.</p>
        pub fn remote_access_allowed(mut self, input: bool) -> Self {
            self.inner = self.inner.remote_access_allowed(input);
            self
        }
        /// <p>Whether the team member is allowed to use an SSH public/private key pair to remotely access project resources, for example Amazon EC2 instances.</p>
        pub fn set_remote_access_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remote_access_allowed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The display name for the project to be created in AWS CodeStar.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The display name for the project to be created in AWS CodeStar.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the project to be created in AWS CodeStar.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the project to be created in AWS CodeStar.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project creation. This token can be used to repeat the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project creation. This token can be used to repeat the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `sourceCode`.
        ///
        /// To override the contents of this collection use [`set_source_code`](Self::set_source_code).
        ///
        /// <p>A list of the Code objects submitted with the project request. If this parameter is specified, the request must also include the toolchain parameter.</p>
        pub fn source_code(mut self, input: crate::model::Code) -> Self {
            self.inner = self.inner.source_code(input);
            self
        }
        /// <p>A list of the Code objects submitted with the project request. If this parameter is specified, the request must also include the toolchain parameter.</p>
        pub fn set_source_code(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Code>>,
        ) -> Self {
            self.inner = self.inner.set_source_code(input);
            self
        }
        /// <p>The name of the toolchain template file submitted with the project request. If this parameter is specified, the request must also include the sourceCode parameter.</p>
        pub fn toolchain(mut self, input: crate::model::Toolchain) -> Self {
            self.inner = self.inner.toolchain(input);
            self
        }
        /// <p>The name of the toolchain template file submitted with the project request. If this parameter is specified, the request must also include the sourceCode parameter.</p>
        pub fn set_toolchain(
            mut self,
            input: std::option::Option<crate::model::Toolchain>,
        ) -> Self {
            self.inner = self.inner.set_toolchain(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags created for the project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags created for the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserProfile`.
    ///
    /// <p>Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_profile_input::Builder,
    }
    impl<C, M, R> CreateUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserProfileInputOperationOutputAlias,
                crate::output::CreateUserProfileOutput,
                crate::error::CreateUserProfileError,
                crate::input::CreateUserProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS CodeStar. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS CodeStar. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The email address that will be displayed as part of the user's profile in AWS CodeStar.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address that will be displayed as part of the user's profile in AWS CodeStar.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key(input.into());
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to be deleted in AWS CodeStar.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the project to be deleted in AWS CodeStar.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project deletion. This token can be used to repeat the request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project deletion. This token can be used to repeat the request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Whether to send a delete request for the primary stack in AWS CloudFormation originally used to generate the project and its resources. This option will delete all AWS resources for the project (except for any buckets in Amazon S3) as well as deleting the project itself. Recommended for most use cases.</p>
        pub fn delete_stack(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_stack(input);
            self
        }
        /// <p>Whether to send a delete request for the primary stack in AWS CloudFormation originally used to generate the project and its resources. This option will delete all AWS resources for the project (except for any buckets in Amazon S3) as well as deleting the project itself. Recommended for most use cases.</p>
        pub fn set_delete_stack(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_stack(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserProfile`.
    ///
    /// <p>Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_profile_input::Builder,
    }
    impl<C, M, R> DeleteUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserProfileInputOperationOutputAlias,
                crate::output::DeleteUserProfileOutput,
                crate::error::DeleteUserProfileError,
                crate::input::DeleteUserProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Describes a project and its resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl<C, M, R> DescribeProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectInputOperationOutputAlias,
                crate::output::DescribeProjectOutput,
                crate::error::DescribeProjectError,
                crate::input::DescribeProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserProfile`.
    ///
    /// <p>Describes a user in AWS CodeStar and the user attributes across all projects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_profile_input::Builder,
    }
    impl<C, M, R> DescribeUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserProfileInputOperationOutputAlias,
                crate::output::DescribeUserProfileOutput,
                crate::error::DescribeUserProfileError,
                crate::input::DescribeUserProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTeamMember`.
    ///
    /// <p>Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTeamMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_team_member_input::Builder,
    }
    impl<C, M, R> DisassociateTeamMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTeamMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTeamMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTeamMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTeamMemberInputOperationOutputAlias,
                crate::output::DisassociateTeamMemberOutput,
                crate::error::DisassociateTeamMemberError,
                crate::input::DisassociateTeamMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the AWS CodeStar project from which you want to remove a team member.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the AWS CodeStar project from which you want to remove a team member.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user or group whom you want to remove from the project.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user or group whom you want to remove from the project.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Lists all projects in AWS CodeStar associated with your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The continuation token to be used to return the next set of results, if the results cannot be returned in one response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The continuation token to be used to return the next set of results, if the results cannot be returned in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Lists resources associated with a project in AWS CodeStar.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl<C, M, R> ListResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesInputOperationOutputAlias,
                crate::output::ListResourcesOutput,
                crate::error::ListResourcesError,
                crate::input::ListResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForProject`.
    ///
    /// <p>Gets the tags for a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_project_input::Builder,
    }
    impl<C, M, R> ListTagsForProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForProjectInputOperationOutputAlias,
                crate::output::ListTagsForProjectOutput,
                crate::error::ListTagsForProjectError,
                crate::input::ListTagsForProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to get tags for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the project to get tags for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTeamMembers`.
    ///
    /// <p>Lists all team members associated with a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTeamMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_team_members_input::Builder,
    }
    impl<C, M, R> ListTeamMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTeamMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTeamMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTeamMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTeamMembersInputOperationOutputAlias,
                crate::output::ListTeamMembersOutput,
                crate::error::ListTeamMembersError,
                crate::input::ListTeamMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project for which you want to list team members.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project for which you want to list team members.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of team members you want returned in a response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of team members you want returned in a response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserProfiles`.
    ///
    /// <p>Lists all the user profiles configured for your AWS account in AWS CodeStar.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUserProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_profiles_input::Builder,
    }
    impl<C, M, R> ListUserProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserProfilesInputOperationOutputAlias,
                crate::output::ListUserProfilesOutput,
                crate::error::ListUserProfilesError,
                crate::input::ListUserProfilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagProject`.
    ///
    /// <p>Adds tags to a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_project_input::Builder,
    }
    impl<C, M, R> TagProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::TagProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagProjectInputOperationOutputAlias,
                crate::output::TagProjectOutput,
                crate::error::TagProjectError,
                crate::input::TagProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project you want to add a tag to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the project you want to add a tag to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to add to the project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags you want to add to the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagProject`.
    ///
    /// <p>Removes tags from a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_project_input::Builder,
    }
    impl<C, M, R> UntagProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagProjectInputOperationOutputAlias,
                crate::output::UntagProjectOutput,
                crate::error::UntagProjectError,
                crate::input::UntagProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to remove tags from.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the project to remove tags from.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to remove from the project.</p>
        pub fn tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags(input.into());
            self
        }
        /// <p>The tags to remove from the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Updates a project in AWS CodeStar.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the project you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the project you want to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the project you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTeamMember`.
    ///
    /// <p>Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTeamMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_team_member_input::Builder,
    }
    impl<C, M, R> UpdateTeamMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTeamMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTeamMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTeamMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTeamMemberInputOperationOutputAlias,
                crate::output::UpdateTeamMemberOutput,
                crate::error::UpdateTeamMemberError,
                crate::input::UpdateTeamMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The role assigned to the user in the project. Project roles have different levels of access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in the <i>AWS CodeStar User Guide</i>.</p>
        pub fn project_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_role(input.into());
            self
        }
        /// <p>The role assigned to the user in the project. Project roles have different levels of access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in the <i>AWS CodeStar User Guide</i>.</p>
        pub fn set_project_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_role(input);
            self
        }
        /// <p>Whether a team member is allowed to remotely access project resources using the SSH public key associated with the user's profile. Even if this is set to True, the user must associate a public key with their profile before the user can access resources.</p>
        pub fn remote_access_allowed(mut self, input: bool) -> Self {
            self.inner = self.inner.remote_access_allowed(input);
            self
        }
        /// <p>Whether a team member is allowed to remotely access project resources using the SSH public key associated with the user's profile. Even if this is set to True, the user must associate a public key with their profile before the user can access resources.</p>
        pub fn set_remote_access_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remote_access_allowed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserProfile`.
    ///
    /// <p>Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_profile_input::Builder,
    }
    impl<C, M, R> UpdateUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserProfileInputOperationOutputAlias,
                crate::output::UpdateUserProfileOutput,
                crate::error::UpdateUserProfileError,
                crate::input::UpdateUserProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key(input.into());
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
