// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateTeamMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateTeamMemberError {
    /// Kind of error that occurred.
    pub kind: AssociateTeamMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateTeamMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateTeamMemberErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The service role is not valid.</p>
    InvalidServiceRoleException(crate::error::InvalidServiceRoleException),
    /// <p>A resource limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Project configuration information is required but not specified.</p>
    ProjectConfigurationException(crate::error::ProjectConfigurationException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The team member is already associated with a role in this project.</p>
    TeamMemberAlreadyAssociatedException(crate::error::TeamMemberAlreadyAssociatedException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateTeamMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateTeamMemberErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            AssociateTeamMemberErrorKind::InvalidServiceRoleException(_inner) => _inner.fmt(f),
            AssociateTeamMemberErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateTeamMemberErrorKind::ProjectConfigurationException(_inner) => _inner.fmt(f),
            AssociateTeamMemberErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            AssociateTeamMemberErrorKind::TeamMemberAlreadyAssociatedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTeamMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateTeamMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateTeamMemberError {
    fn code(&self) -> Option<&str> {
        AssociateTeamMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateTeamMemberError {
    /// Creates a new `AssociateTeamMemberError`.
    pub fn new(kind: AssociateTeamMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateTeamMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateTeamMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateTeamMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateTeamMemberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateTeamMemberErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTeamMemberErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTeamMemberErrorKind::InvalidServiceRoleException`.
    pub fn is_invalid_service_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTeamMemberErrorKind::InvalidServiceRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTeamMemberErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTeamMemberErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTeamMemberErrorKind::ProjectConfigurationException`.
    pub fn is_project_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTeamMemberErrorKind::ProjectConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTeamMemberErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTeamMemberErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTeamMemberErrorKind::TeamMemberAlreadyAssociatedException`.
    pub fn is_team_member_already_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTeamMemberErrorKind::TeamMemberAlreadyAssociatedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTeamMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTeamMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateTeamMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateTeamMemberErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            AssociateTeamMemberErrorKind::InvalidServiceRoleException(_inner) => Some(_inner),
            AssociateTeamMemberErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateTeamMemberErrorKind::ProjectConfigurationException(_inner) => Some(_inner),
            AssociateTeamMemberErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            AssociateTeamMemberErrorKind::TeamMemberAlreadyAssociatedException(_inner) => {
                Some(_inner)
            }
            AssociateTeamMemberErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateTeamMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProjectError {
    /// Kind of error that occurred.
    pub kind: CreateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProjectErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The service role is not valid.</p>
    InvalidServiceRoleException(crate::error::InvalidServiceRoleException),
    /// <p>A resource limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An AWS CodeStar project with the same ID already exists in this region for the AWS account. AWS CodeStar project IDs must be unique within a region for the AWS account.</p>
    ProjectAlreadyExistsException(crate::error::ProjectAlreadyExistsException),
    /// <p>Project configuration information is required but not specified.</p>
    ProjectConfigurationException(crate::error::ProjectConfigurationException),
    /// <p>The project creation request was valid, but a nonspecific exception or error occurred during project creation. The project could not be created in AWS CodeStar.</p>
    ProjectCreationFailedException(crate::error::ProjectCreationFailedException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProjectErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::InvalidServiceRoleException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ProjectAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ProjectConfigurationException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ProjectCreationFailedException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProjectError {
    fn code(&self) -> Option<&str> {
        CreateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProjectError {
    /// Creates a new `CreateProjectError`.
    pub fn new(kind: CreateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::InvalidServiceRoleException`.
    pub fn is_invalid_service_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::InvalidServiceRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ProjectAlreadyExistsException`.
    pub fn is_project_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ProjectAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ProjectConfigurationException`.
    pub fn is_project_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ProjectConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ProjectCreationFailedException`.
    pub fn is_project_creation_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ProjectCreationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProjectErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateProjectErrorKind::InvalidServiceRoleException(_inner) => Some(_inner),
            CreateProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProjectErrorKind::ProjectAlreadyExistsException(_inner) => Some(_inner),
            CreateProjectErrorKind::ProjectConfigurationException(_inner) => Some(_inner),
            CreateProjectErrorKind::ProjectCreationFailedException(_inner) => Some(_inner),
            CreateProjectErrorKind::ValidationException(_inner) => Some(_inner),
            CreateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserProfileError {
    /// Kind of error that occurred.
    pub kind: CreateUserProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserProfileErrorKind {
    /// <p>A user profile with that name already exists in this region for the AWS account. AWS CodeStar user profile names must be unique within a region for the AWS account. </p>
    UserProfileAlreadyExistsException(crate::error::UserProfileAlreadyExistsException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserProfileErrorKind::UserProfileAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateUserProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateUserProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserProfileError {
    fn code(&self) -> Option<&str> {
        CreateUserProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserProfileError {
    /// Creates a new `CreateUserProfileError`.
    pub fn new(kind: CreateUserProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserProfileErrorKind::UserProfileAlreadyExistsException`.
    pub fn is_user_profile_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserProfileErrorKind::UserProfileAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateUserProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserProfileErrorKind::UserProfileAlreadyExistsException(_inner) => Some(_inner),
            CreateUserProfileErrorKind::ValidationException(_inner) => Some(_inner),
            CreateUserProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProjectErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The service role is not valid.</p>
    InvalidServiceRoleException(crate::error::InvalidServiceRoleException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProjectErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::InvalidServiceRoleException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProjectError {
    fn code(&self) -> Option<&str> {
        DeleteProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProjectError {
    /// Creates a new `DeleteProjectError`.
    pub fn new(kind: DeleteProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::InvalidServiceRoleException`.
    pub fn is_invalid_service_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::InvalidServiceRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProjectErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteProjectErrorKind::InvalidServiceRoleException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteUserProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserProfileErrorKind {
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteUserProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserProfileError {
    fn code(&self) -> Option<&str> {
        DeleteUserProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserProfileError {
    /// Creates a new `DeleteUserProfileError`.
    pub fn new(kind: DeleteUserProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteUserProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserProfileErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteUserProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProjectError {
    /// Kind of error that occurred.
    pub kind: DescribeProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProjectErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The service role is not valid.</p>
    InvalidServiceRoleException(crate::error::InvalidServiceRoleException),
    /// <p>Project configuration information is required but not specified.</p>
    ProjectConfigurationException(crate::error::ProjectConfigurationException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProjectErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::InvalidServiceRoleException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ProjectConfigurationException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProjectError {
    fn code(&self) -> Option<&str> {
        DescribeProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProjectError {
    /// Creates a new `DescribeProjectError`.
    pub fn new(kind: DescribeProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProjectErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProjectErrorKind::InvalidServiceRoleException`.
    pub fn is_invalid_service_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::InvalidServiceRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProjectErrorKind::ProjectConfigurationException`.
    pub fn is_project_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::ProjectConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProjectErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProjectErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DescribeProjectErrorKind::InvalidServiceRoleException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ProjectConfigurationException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserProfileError {
    /// Kind of error that occurred.
    pub kind: DescribeUserProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserProfileErrorKind {
    /// <p>The user profile was not found.</p>
    UserProfileNotFoundException(crate::error::UserProfileNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserProfileErrorKind::UserProfileNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeUserProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserProfileError {
    fn code(&self) -> Option<&str> {
        DescribeUserProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserProfileError {
    /// Creates a new `DescribeUserProfileError`.
    pub fn new(kind: DescribeUserProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserProfileErrorKind::UserProfileNotFoundException`.
    pub fn is_user_profile_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserProfileErrorKind::UserProfileNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeUserProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserProfileErrorKind::UserProfileNotFoundException(_inner) => Some(_inner),
            DescribeUserProfileErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeUserProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateTeamMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateTeamMemberError {
    /// Kind of error that occurred.
    pub kind: DisassociateTeamMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateTeamMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateTeamMemberErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The service role is not valid.</p>
    InvalidServiceRoleException(crate::error::InvalidServiceRoleException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateTeamMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateTeamMemberErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTeamMemberErrorKind::InvalidServiceRoleException(_inner) => _inner.fmt(f),
            DisassociateTeamMemberErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            DisassociateTeamMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateTeamMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateTeamMemberError {
    fn code(&self) -> Option<&str> {
        DisassociateTeamMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateTeamMemberError {
    /// Creates a new `DisassociateTeamMemberError`.
    pub fn new(kind: DisassociateTeamMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateTeamMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateTeamMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateTeamMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateTeamMemberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateTeamMemberErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTeamMemberErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTeamMemberErrorKind::InvalidServiceRoleException`.
    pub fn is_invalid_service_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTeamMemberErrorKind::InvalidServiceRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTeamMemberErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTeamMemberErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTeamMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTeamMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateTeamMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateTeamMemberErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DisassociateTeamMemberErrorKind::InvalidServiceRoleException(_inner) => Some(_inner),
            DisassociateTeamMemberErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            DisassociateTeamMemberErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateTeamMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectsError {
    /// Kind of error that occurred.
    pub kind: ListProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectsErrorKind {
    /// <p>The next token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectsError {
    fn code(&self) -> Option<&str> {
        ListProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectsError {
    /// Creates a new `ListProjectsError`.
    pub fn new(kind: ListProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProjectsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProjectsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListProjectsErrorKind::ValidationException(_inner) => Some(_inner),
            ListProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesError {
    /// Kind of error that occurred.
    pub kind: ListResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesErrorKind {
    /// <p>The next token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesError {
    fn code(&self) -> Option<&str> {
        ListResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesError {
    /// Creates a new `ListResourcesError`.
    pub fn new(kind: ListResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListResourcesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListResourcesErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            ListResourcesErrorKind::ValidationException(_inner) => Some(_inner),
            ListResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForProjectError {
    /// Kind of error that occurred.
    pub kind: ListTagsForProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForProjectErrorKind {
    /// <p>The next token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForProjectErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTagsForProjectErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForProjectError {
    fn code(&self) -> Option<&str> {
        ListTagsForProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForProjectError {
    /// Creates a new `ListTagsForProjectError`.
    pub fn new(kind: ListTagsForProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForProjectErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForProjectErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForProjectErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForProjectErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForProjectErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForProjectErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTagsForProjectErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            ListTagsForProjectErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTeamMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTeamMembersError {
    /// Kind of error that occurred.
    pub kind: ListTeamMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTeamMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTeamMembersErrorKind {
    /// <p>The next token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTeamMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTeamMembersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTeamMembersErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            ListTeamMembersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTeamMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTeamMembersError {
    fn code(&self) -> Option<&str> {
        ListTeamMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTeamMembersError {
    /// Creates a new `ListTeamMembersError`.
    pub fn new(kind: ListTeamMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTeamMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTeamMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTeamMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTeamMembersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTeamMembersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTeamMembersErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTeamMembersErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTeamMembersErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTeamMembersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListTeamMembersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListTeamMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTeamMembersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTeamMembersErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            ListTeamMembersErrorKind::ValidationException(_inner) => Some(_inner),
            ListTeamMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserProfilesError {
    /// Kind of error that occurred.
    pub kind: ListUserProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserProfilesErrorKind {
    /// <p>The next token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserProfilesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListUserProfilesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListUserProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserProfilesError {
    fn code(&self) -> Option<&str> {
        ListUserProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserProfilesError {
    /// Creates a new `ListUserProfilesError`.
    pub fn new(kind: ListUserProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserProfilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserProfilesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserProfilesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserProfilesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserProfilesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListUserProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserProfilesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListUserProfilesErrorKind::ValidationException(_inner) => Some(_inner),
            ListUserProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagProjectError {
    /// Kind of error that occurred.
    pub kind: TagProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagProjectErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A resource limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagProjectErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagProjectErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            TagProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagProjectError {
    fn code(&self) -> Option<&str> {
        TagProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagProjectError {
    /// Creates a new `TagProjectError`.
    pub fn new(kind: TagProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagProjectErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagProjectErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagProjectErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagProjectErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagProjectErrorKind::ProjectNotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagProjectErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagProjectErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            TagProjectErrorKind::ValidationException(_inner) => Some(_inner),
            TagProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagProjectError {
    /// Kind of error that occurred.
    pub kind: UntagProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagProjectErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A resource limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagProjectErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagProjectErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            UntagProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagProjectError {
    fn code(&self) -> Option<&str> {
        UntagProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagProjectError {
    /// Creates a new `UntagProjectError`.
    pub fn new(kind: UntagProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagProjectErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagProjectErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UntagProjectErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UntagProjectErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagProjectErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagProjectErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagProjectErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            UntagProjectErrorKind::ValidationException(_inner) => Some(_inner),
            UntagProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectErrorKind {
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectError {
    fn code(&self) -> Option<&str> {
        UpdateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectError {
    /// Creates a new `UpdateProjectError`.
    pub fn new(kind: UpdateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTeamMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTeamMemberError {
    /// Kind of error that occurred.
    pub kind: UpdateTeamMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTeamMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTeamMemberErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The service role is not valid.</p>
    InvalidServiceRoleException(crate::error::InvalidServiceRoleException),
    /// <p>A resource limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Project configuration information is required but not specified.</p>
    ProjectConfigurationException(crate::error::ProjectConfigurationException),
    /// <p>The specified AWS CodeStar project was not found.</p>
    ProjectNotFoundException(crate::error::ProjectNotFoundException),
    /// <p>The specified team member was not found.</p>
    TeamMemberNotFoundException(crate::error::TeamMemberNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTeamMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTeamMemberErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateTeamMemberErrorKind::InvalidServiceRoleException(_inner) => _inner.fmt(f),
            UpdateTeamMemberErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateTeamMemberErrorKind::ProjectConfigurationException(_inner) => _inner.fmt(f),
            UpdateTeamMemberErrorKind::ProjectNotFoundException(_inner) => _inner.fmt(f),
            UpdateTeamMemberErrorKind::TeamMemberNotFoundException(_inner) => _inner.fmt(f),
            UpdateTeamMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateTeamMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTeamMemberError {
    fn code(&self) -> Option<&str> {
        UpdateTeamMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTeamMemberError {
    /// Creates a new `UpdateTeamMemberError`.
    pub fn new(kind: UpdateTeamMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTeamMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTeamMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTeamMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTeamMemberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTeamMemberErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTeamMemberErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTeamMemberErrorKind::InvalidServiceRoleException`.
    pub fn is_invalid_service_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTeamMemberErrorKind::InvalidServiceRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTeamMemberErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTeamMemberErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTeamMemberErrorKind::ProjectConfigurationException`.
    pub fn is_project_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTeamMemberErrorKind::ProjectConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTeamMemberErrorKind::ProjectNotFoundException`.
    pub fn is_project_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTeamMemberErrorKind::ProjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTeamMemberErrorKind::TeamMemberNotFoundException`.
    pub fn is_team_member_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTeamMemberErrorKind::TeamMemberNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTeamMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTeamMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateTeamMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTeamMemberErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateTeamMemberErrorKind::InvalidServiceRoleException(_inner) => Some(_inner),
            UpdateTeamMemberErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateTeamMemberErrorKind::ProjectConfigurationException(_inner) => Some(_inner),
            UpdateTeamMemberErrorKind::ProjectNotFoundException(_inner) => Some(_inner),
            UpdateTeamMemberErrorKind::TeamMemberNotFoundException(_inner) => Some(_inner),
            UpdateTeamMemberErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateTeamMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateUserProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserProfileErrorKind {
    /// <p>The user profile was not found.</p>
    UserProfileNotFoundException(crate::error::UserProfileNotFoundException),
    /// <p>The specified input is either not valid, or it could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserProfileErrorKind::UserProfileNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateUserProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserProfileError {
    fn code(&self) -> Option<&str> {
        UpdateUserProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserProfileError {
    /// Creates a new `UpdateUserProfileError`.
    pub fn new(kind: UpdateUserProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserProfileErrorKind::UserProfileNotFoundException`.
    pub fn is_user_profile_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserProfileErrorKind::UserProfileNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateUserProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserProfileErrorKind::UserProfileNotFoundException(_inner) => Some(_inner),
            UpdateUserProfileErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateUserProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified input is either not valid, or it could not be validated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The user profile was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserProfileNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserProfileNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserProfileNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserProfileNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserProfileNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserProfileNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserProfileNotFoundException {}
/// See [`UserProfileNotFoundException`](crate::error::UserProfileNotFoundException)
pub mod user_profile_not_found_exception {
    /// A builder for [`UserProfileNotFoundException`](crate::error::UserProfileNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserProfileNotFoundException`](crate::error::UserProfileNotFoundException)
        pub fn build(self) -> crate::error::UserProfileNotFoundException {
            crate::error::UserProfileNotFoundException {
                message: self.message,
            }
        }
    }
}
impl UserProfileNotFoundException {
    /// Creates a new builder-style object to manufacture [`UserProfileNotFoundException`](crate::error::UserProfileNotFoundException)
    pub fn builder() -> crate::error::user_profile_not_found_exception::Builder {
        crate::error::user_profile_not_found_exception::Builder::default()
    }
}

/// <p>The specified team member was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TeamMemberNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TeamMemberNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TeamMemberNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TeamMemberNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TeamMemberNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TeamMemberNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TeamMemberNotFoundException {}
/// See [`TeamMemberNotFoundException`](crate::error::TeamMemberNotFoundException)
pub mod team_member_not_found_exception {
    /// A builder for [`TeamMemberNotFoundException`](crate::error::TeamMemberNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TeamMemberNotFoundException`](crate::error::TeamMemberNotFoundException)
        pub fn build(self) -> crate::error::TeamMemberNotFoundException {
            crate::error::TeamMemberNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TeamMemberNotFoundException {
    /// Creates a new builder-style object to manufacture [`TeamMemberNotFoundException`](crate::error::TeamMemberNotFoundException)
    pub fn builder() -> crate::error::team_member_not_found_exception::Builder {
        crate::error::team_member_not_found_exception::Builder::default()
    }
}

/// <p>The specified AWS CodeStar project was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProjectNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProjectNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProjectNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProjectNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProjectNotFoundException {}
/// See [`ProjectNotFoundException`](crate::error::ProjectNotFoundException)
pub mod project_not_found_exception {
    /// A builder for [`ProjectNotFoundException`](crate::error::ProjectNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectNotFoundException`](crate::error::ProjectNotFoundException)
        pub fn build(self) -> crate::error::ProjectNotFoundException {
            crate::error::ProjectNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ProjectNotFoundException {
    /// Creates a new builder-style object to manufacture [`ProjectNotFoundException`](crate::error::ProjectNotFoundException)
    pub fn builder() -> crate::error::project_not_found_exception::Builder {
        crate::error::project_not_found_exception::Builder::default()
    }
}

/// <p>Project configuration information is required but not specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectConfigurationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProjectConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProjectConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProjectConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProjectConfigurationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProjectConfigurationException {}
/// See [`ProjectConfigurationException`](crate::error::ProjectConfigurationException)
pub mod project_configuration_exception {
    /// A builder for [`ProjectConfigurationException`](crate::error::ProjectConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectConfigurationException`](crate::error::ProjectConfigurationException)
        pub fn build(self) -> crate::error::ProjectConfigurationException {
            crate::error::ProjectConfigurationException {
                message: self.message,
            }
        }
    }
}
impl ProjectConfigurationException {
    /// Creates a new builder-style object to manufacture [`ProjectConfigurationException`](crate::error::ProjectConfigurationException)
    pub fn builder() -> crate::error::project_configuration_exception::Builder {
        crate::error::project_configuration_exception::Builder::default()
    }
}

/// <p>A resource limit has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The service role is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidServiceRoleException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidServiceRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidServiceRoleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidServiceRoleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidServiceRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidServiceRoleException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidServiceRoleException {}
/// See [`InvalidServiceRoleException`](crate::error::InvalidServiceRoleException)
pub mod invalid_service_role_exception {
    /// A builder for [`InvalidServiceRoleException`](crate::error::InvalidServiceRoleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidServiceRoleException`](crate::error::InvalidServiceRoleException)
        pub fn build(self) -> crate::error::InvalidServiceRoleException {
            crate::error::InvalidServiceRoleException {
                message: self.message,
            }
        }
    }
}
impl InvalidServiceRoleException {
    /// Creates a new builder-style object to manufacture [`InvalidServiceRoleException`](crate::error::InvalidServiceRoleException)
    pub fn builder() -> crate::error::invalid_service_role_exception::Builder {
        crate::error::invalid_service_role_exception::Builder::default()
    }
}

/// <p>Another modification is being made. That modification must complete before you can make your change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The next token is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>A user profile with that name already exists in this region for the AWS account. AWS CodeStar user profile names must be unique within a region for the AWS account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserProfileAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserProfileAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserProfileAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserProfileAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserProfileAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserProfileAlreadyExistsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserProfileAlreadyExistsException {}
/// See [`UserProfileAlreadyExistsException`](crate::error::UserProfileAlreadyExistsException)
pub mod user_profile_already_exists_exception {
    /// A builder for [`UserProfileAlreadyExistsException`](crate::error::UserProfileAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserProfileAlreadyExistsException`](crate::error::UserProfileAlreadyExistsException)
        pub fn build(self) -> crate::error::UserProfileAlreadyExistsException {
            crate::error::UserProfileAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl UserProfileAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`UserProfileAlreadyExistsException`](crate::error::UserProfileAlreadyExistsException)
    pub fn builder() -> crate::error::user_profile_already_exists_exception::Builder {
        crate::error::user_profile_already_exists_exception::Builder::default()
    }
}

/// <p>The project creation request was valid, but a nonspecific exception or error occurred during project creation. The project could not be created in AWS CodeStar.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectCreationFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProjectCreationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectCreationFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProjectCreationFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProjectCreationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProjectCreationFailedException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProjectCreationFailedException {}
/// See [`ProjectCreationFailedException`](crate::error::ProjectCreationFailedException)
pub mod project_creation_failed_exception {
    /// A builder for [`ProjectCreationFailedException`](crate::error::ProjectCreationFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectCreationFailedException`](crate::error::ProjectCreationFailedException)
        pub fn build(self) -> crate::error::ProjectCreationFailedException {
            crate::error::ProjectCreationFailedException {
                message: self.message,
            }
        }
    }
}
impl ProjectCreationFailedException {
    /// Creates a new builder-style object to manufacture [`ProjectCreationFailedException`](crate::error::ProjectCreationFailedException)
    pub fn builder() -> crate::error::project_creation_failed_exception::Builder {
        crate::error::project_creation_failed_exception::Builder::default()
    }
}

/// <p>An AWS CodeStar project with the same ID already exists in this region for the AWS account. AWS CodeStar project IDs must be unique within a region for the AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProjectAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProjectAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProjectAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProjectAlreadyExistsException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProjectAlreadyExistsException {}
/// See [`ProjectAlreadyExistsException`](crate::error::ProjectAlreadyExistsException)
pub mod project_already_exists_exception {
    /// A builder for [`ProjectAlreadyExistsException`](crate::error::ProjectAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectAlreadyExistsException`](crate::error::ProjectAlreadyExistsException)
        pub fn build(self) -> crate::error::ProjectAlreadyExistsException {
            crate::error::ProjectAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ProjectAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ProjectAlreadyExistsException`](crate::error::ProjectAlreadyExistsException)
    pub fn builder() -> crate::error::project_already_exists_exception::Builder {
        crate::error::project_already_exists_exception::Builder::default()
    }
}

/// <p>The team member is already associated with a role in this project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TeamMemberAlreadyAssociatedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TeamMemberAlreadyAssociatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TeamMemberAlreadyAssociatedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TeamMemberAlreadyAssociatedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TeamMemberAlreadyAssociatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TeamMemberAlreadyAssociatedException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for TeamMemberAlreadyAssociatedException {}
/// See [`TeamMemberAlreadyAssociatedException`](crate::error::TeamMemberAlreadyAssociatedException)
pub mod team_member_already_associated_exception {
    /// A builder for [`TeamMemberAlreadyAssociatedException`](crate::error::TeamMemberAlreadyAssociatedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TeamMemberAlreadyAssociatedException`](crate::error::TeamMemberAlreadyAssociatedException)
        pub fn build(self) -> crate::error::TeamMemberAlreadyAssociatedException {
            crate::error::TeamMemberAlreadyAssociatedException {
                message: self.message,
            }
        }
    }
}
impl TeamMemberAlreadyAssociatedException {
    /// Creates a new builder-style object to manufacture [`TeamMemberAlreadyAssociatedException`](crate::error::TeamMemberAlreadyAssociatedException)
    pub fn builder() -> crate::error::team_member_already_associated_exception::Builder {
        crate::error::team_member_already_associated_exception::Builder::default()
    }
}
