// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a user's profile in AWS CodeStar.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserProfileSummary {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The display name of a user in AWS CodeStar. For example, this could be set to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first character that appears after the space will be used as the second character in the user initial icon. The initial icon displays a maximum of two characters, so a display name with more than one space (for example "Mary Jane Major") would generate an initial icon using the first character and the first character after the space ("MJ", not "MM").</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The email address associated with the user.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
}
impl UserProfileSummary {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
    /// <p>The display name of a user in AWS CodeStar. For example, this could be set to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first character that appears after the space will be used as the second character in the user initial icon. The initial icon displays a maximum of two characters, so a display name with more than one space (for example "Mary Jane Major") would generate an initial icon using the first character and the first character after the space ("MJ", not "MM").</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The email address associated with the user.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
}
impl std::fmt::Debug for UserProfileSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserProfileSummary");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.finish()
    }
}
/// See [`UserProfileSummary`](crate::model::UserProfileSummary)
pub mod user_profile_summary {
    /// A builder for [`UserProfileSummary`](crate::model::UserProfileSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The display name of a user in AWS CodeStar. For example, this could be set to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first character that appears after the space will be used as the second character in the user initial icon. The initial icon displays a maximum of two characters, so a display name with more than one space (for example "Mary Jane Major") would generate an initial icon using the first character and the first character after the space ("MJ", not "MM").</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of a user in AWS CodeStar. For example, this could be set to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first character that appears after the space will be used as the second character in the user initial icon. The initial icon displays a maximum of two characters, so a display name with more than one space (for example "Mary Jane Major") would generate an initial icon using the first character and the first character after the space ("MJ", not "MM").</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The email address associated with the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address associated with the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// Consumes the builder and constructs a [`UserProfileSummary`](crate::model::UserProfileSummary)
        pub fn build(self) -> crate::model::UserProfileSummary {
            crate::model::UserProfileSummary {
                user_arn: self.user_arn,
                display_name: self.display_name,
                email_address: self.email_address,
                ssh_public_key: self.ssh_public_key,
            }
        }
    }
}
impl UserProfileSummary {
    /// Creates a new builder-style object to manufacture [`UserProfileSummary`](crate::model::UserProfileSummary)
    pub fn builder() -> crate::model::user_profile_summary::Builder {
        crate::model::user_profile_summary::Builder::default()
    }
}

/// <p>Information about a team member in a project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TeamMember {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The role assigned to the user in the project. Project roles have different levels of access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in the <i>AWS CodeStar User Guide</i>. </p>
    pub project_role: std::option::Option<std::string::String>,
    /// <p>Whether the user is allowed to remotely access project resources using an SSH public/private key pair.</p>
    pub remote_access_allowed: std::option::Option<bool>,
}
impl TeamMember {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
    /// <p>The role assigned to the user in the project. Project roles have different levels of access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in the <i>AWS CodeStar User Guide</i>. </p>
    pub fn project_role(&self) -> std::option::Option<&str> {
        self.project_role.as_deref()
    }
    /// <p>Whether the user is allowed to remotely access project resources using an SSH public/private key pair.</p>
    pub fn remote_access_allowed(&self) -> std::option::Option<bool> {
        self.remote_access_allowed
    }
}
impl std::fmt::Debug for TeamMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TeamMember");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("project_role", &self.project_role);
        formatter.field("remote_access_allowed", &self.remote_access_allowed);
        formatter.finish()
    }
}
/// See [`TeamMember`](crate::model::TeamMember)
pub mod team_member {
    /// A builder for [`TeamMember`](crate::model::TeamMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) project_role: std::option::Option<std::string::String>,
        pub(crate) remote_access_allowed: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The role assigned to the user in the project. Project roles have different levels of access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in the <i>AWS CodeStar User Guide</i>. </p>
        pub fn project_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_role = Some(input.into());
            self
        }
        /// <p>The role assigned to the user in the project. Project roles have different levels of access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in the <i>AWS CodeStar User Guide</i>. </p>
        pub fn set_project_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_role = input;
            self
        }
        /// <p>Whether the user is allowed to remotely access project resources using an SSH public/private key pair.</p>
        pub fn remote_access_allowed(mut self, input: bool) -> Self {
            self.remote_access_allowed = Some(input);
            self
        }
        /// <p>Whether the user is allowed to remotely access project resources using an SSH public/private key pair.</p>
        pub fn set_remote_access_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_access_allowed = input;
            self
        }
        /// Consumes the builder and constructs a [`TeamMember`](crate::model::TeamMember)
        pub fn build(self) -> crate::model::TeamMember {
            crate::model::TeamMember {
                user_arn: self.user_arn,
                project_role: self.project_role,
                remote_access_allowed: self.remote_access_allowed,
            }
        }
    }
}
impl TeamMember {
    /// Creates a new builder-style object to manufacture [`TeamMember`](crate::model::TeamMember)
    pub fn builder() -> crate::model::team_member::Builder {
        crate::model::team_member::Builder::default()
    }
}

/// <p>Information about a resource for a project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub id: std::option::Option<std::string::String>,
}
impl Resource {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource { id: self.id }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>Information about the metadata for a project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectSummary {
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub project_arn: std::option::Option<std::string::String>,
}
impl ProjectSummary {
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
}
impl std::fmt::Debug for ProjectSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectSummary");
        formatter.field("project_id", &self.project_id);
        formatter.field("project_arn", &self.project_arn);
        formatter.finish()
    }
}
/// See [`ProjectSummary`](crate::model::ProjectSummary)
pub mod project_summary {
    /// A builder for [`ProjectSummary`](crate::model::ProjectSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) project_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectSummary`](crate::model::ProjectSummary)
        pub fn build(self) -> crate::model::ProjectSummary {
            crate::model::ProjectSummary {
                project_id: self.project_id,
                project_arn: self.project_arn,
            }
        }
    }
}
impl ProjectSummary {
    /// Creates a new builder-style object to manufacture [`ProjectSummary`](crate::model::ProjectSummary)
    pub fn builder() -> crate::model::project_summary::Builder {
        crate::model::project_summary::Builder::default()
    }
}

/// <p>An indication of whether a project creation or deletion is failed or successful.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectStatus {
    /// <p>The phase of completion for a project creation or deletion.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>In the case of a project creation or deletion failure, a reason for the failure.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl ProjectStatus {
    /// <p>The phase of completion for a project creation or deletion.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>In the case of a project creation or deletion failure, a reason for the failure.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for ProjectStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectStatus");
        formatter.field("state", &self.state);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ProjectStatus`](crate::model::ProjectStatus)
pub mod project_status {
    /// A builder for [`ProjectStatus`](crate::model::ProjectStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phase of completion for a project creation or deletion.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The phase of completion for a project creation or deletion.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>In the case of a project creation or deletion failure, a reason for the failure.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>In the case of a project creation or deletion failure, a reason for the failure.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectStatus`](crate::model::ProjectStatus)
        pub fn build(self) -> crate::model::ProjectStatus {
            crate::model::ProjectStatus {
                state: self.state,
                reason: self.reason,
            }
        }
    }
}
impl ProjectStatus {
    /// Creates a new builder-style object to manufacture [`ProjectStatus`](crate::model::ProjectStatus)
    pub fn builder() -> crate::model::project_status::Builder {
        crate::model::project_status::Builder::default()
    }
}

/// <p>The toolchain template file provided with the project request. AWS CodeStar uses the template to provision the toolchain stack in AWS CloudFormation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Toolchain {
    /// <p>The Amazon S3 location where the toolchain template file provided with the project request is stored. AWS CodeStar retrieves the file during project creation.</p>
    pub source: std::option::Option<crate::model::ToolchainSource>,
    /// <p>The service role ARN for AWS CodeStar to use for the toolchain template during stack provisioning.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The list of parameter overrides to be passed into the toolchain template during stack provisioning, if any.</p>
    pub stack_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Toolchain {
    /// <p>The Amazon S3 location where the toolchain template file provided with the project request is stored. AWS CodeStar retrieves the file during project creation.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::ToolchainSource> {
        self.source.as_ref()
    }
    /// <p>The service role ARN for AWS CodeStar to use for the toolchain template during stack provisioning.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The list of parameter overrides to be passed into the toolchain template during stack provisioning, if any.</p>
    pub fn stack_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.stack_parameters.as_ref()
    }
}
impl std::fmt::Debug for Toolchain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Toolchain");
        formatter.field("source", &self.source);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("stack_parameters", &self.stack_parameters);
        formatter.finish()
    }
}
/// See [`Toolchain`](crate::model::Toolchain)
pub mod toolchain {
    /// A builder for [`Toolchain`](crate::model::Toolchain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::ToolchainSource>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stack_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon S3 location where the toolchain template file provided with the project request is stored. AWS CodeStar retrieves the file during project creation.</p>
        pub fn source(mut self, input: crate::model::ToolchainSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The Amazon S3 location where the toolchain template file provided with the project request is stored. AWS CodeStar retrieves the file during project creation.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ToolchainSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The service role ARN for AWS CodeStar to use for the toolchain template during stack provisioning.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The service role ARN for AWS CodeStar to use for the toolchain template during stack provisioning.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `stack_parameters`.
        ///
        /// To override the contents of this collection use [`set_stack_parameters`](Self::set_stack_parameters).
        ///
        /// <p>The list of parameter overrides to be passed into the toolchain template during stack provisioning, if any.</p>
        pub fn stack_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.stack_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.stack_parameters = Some(hash_map);
            self
        }
        /// <p>The list of parameter overrides to be passed into the toolchain template during stack provisioning, if any.</p>
        pub fn set_stack_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.stack_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`Toolchain`](crate::model::Toolchain)
        pub fn build(self) -> crate::model::Toolchain {
            crate::model::Toolchain {
                source: self.source,
                role_arn: self.role_arn,
                stack_parameters: self.stack_parameters,
            }
        }
    }
}
impl Toolchain {
    /// Creates a new builder-style object to manufacture [`Toolchain`](crate::model::Toolchain)
    pub fn builder() -> crate::model::toolchain::Builder {
        crate::model::toolchain::Builder::default()
    }
}

/// <p>The Amazon S3 location where the toolchain template file provided with the project request is stored. AWS CodeStar retrieves the file during project creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ToolchainSource {
    /// <p>The Amazon S3 bucket where the toolchain template file provided with the project request is stored.</p>
    pub s3: std::option::Option<crate::model::S3Location>,
}
impl ToolchainSource {
    /// <p>The Amazon S3 bucket where the toolchain template file provided with the project request is stored.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for ToolchainSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ToolchainSource");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`ToolchainSource`](crate::model::ToolchainSource)
pub mod toolchain_source {
    /// A builder for [`ToolchainSource`](crate::model::ToolchainSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket where the toolchain template file provided with the project request is stored.</p>
        pub fn s3(mut self, input: crate::model::S3Location) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket where the toolchain template file provided with the project request is stored.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Location>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`ToolchainSource`](crate::model::ToolchainSource)
        pub fn build(self) -> crate::model::ToolchainSource {
            crate::model::ToolchainSource { s3: self.s3 }
        }
    }
}
impl ToolchainSource {
    /// Creates a new builder-style object to manufacture [`ToolchainSource`](crate::model::ToolchainSource)
    pub fn builder() -> crate::model::toolchain_source::Builder {
        crate::model::toolchain_source::Builder::default()
    }
}

/// <p>The Amazon S3 location where the source code files provided with the project request are stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The Amazon S3 bucket name where the source code files provided with the project request are stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 object key where the source code files provided with the project request are stored.</p>
    pub bucket_key: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The Amazon S3 bucket name where the source code files provided with the project request are stored.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The Amazon S3 object key where the source code files provided with the project request are stored.</p>
    pub fn bucket_key(&self) -> std::option::Option<&str> {
        self.bucket_key.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_key", &self.bucket_key);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name where the source code files provided with the project request are stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket name where the source code files provided with the project request are stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The Amazon S3 object key where the source code files provided with the project request are stored.</p>
        pub fn bucket_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 object key where the source code files provided with the project request are stored.</p>
        pub fn set_bucket_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket_name: self.bucket_name,
                bucket_key: self.bucket_key,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>Location and destination information about the source code files provided with the project request. The source code is uploaded to the new project source repository after project creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Code {
    /// <p>The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the files during project creation.</p>
    pub source: std::option::Option<crate::model::CodeSource>,
    /// <p>The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.</p>
    pub destination: std::option::Option<crate::model::CodeDestination>,
}
impl Code {
    /// <p>The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the files during project creation.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::CodeSource> {
        self.source.as_ref()
    }
    /// <p>The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::CodeDestination> {
        self.destination.as_ref()
    }
}
impl std::fmt::Debug for Code {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Code");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`Code`](crate::model::Code)
pub mod code {
    /// A builder for [`Code`](crate::model::Code)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::CodeSource>,
        pub(crate) destination: std::option::Option<crate::model::CodeDestination>,
    }
    impl Builder {
        /// <p>The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the files during project creation.</p>
        pub fn source(mut self, input: crate::model::CodeSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the files during project creation.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::CodeSource>) -> Self {
            self.source = input;
            self
        }
        /// <p>The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.</p>
        pub fn destination(mut self, input: crate::model::CodeDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::CodeDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`Code`](crate::model::Code)
        pub fn build(self) -> crate::model::Code {
            crate::model::Code {
                source: self.source,
                destination: self.destination,
            }
        }
    }
}
impl Code {
    /// Creates a new builder-style object to manufacture [`Code`](crate::model::Code)
    pub fn builder() -> crate::model::code::Builder {
        crate::model::code::Builder::default()
    }
}

/// <p>The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeDestination {
    /// <p>Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
    pub code_commit: std::option::Option<crate::model::CodeCommitCodeDestination>,
    /// <p>Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
    pub git_hub: std::option::Option<crate::model::GitHubCodeDestination>,
}
impl CodeDestination {
    /// <p>Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
    pub fn code_commit(&self) -> std::option::Option<&crate::model::CodeCommitCodeDestination> {
        self.code_commit.as_ref()
    }
    /// <p>Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
    pub fn git_hub(&self) -> std::option::Option<&crate::model::GitHubCodeDestination> {
        self.git_hub.as_ref()
    }
}
impl std::fmt::Debug for CodeDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeDestination");
        formatter.field("code_commit", &self.code_commit);
        formatter.field("git_hub", &self.git_hub);
        formatter.finish()
    }
}
/// See [`CodeDestination`](crate::model::CodeDestination)
pub mod code_destination {
    /// A builder for [`CodeDestination`](crate::model::CodeDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_commit: std::option::Option<crate::model::CodeCommitCodeDestination>,
        pub(crate) git_hub: std::option::Option<crate::model::GitHubCodeDestination>,
    }
    impl Builder {
        /// <p>Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
        pub fn code_commit(mut self, input: crate::model::CodeCommitCodeDestination) -> Self {
            self.code_commit = Some(input);
            self
        }
        /// <p>Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
        pub fn set_code_commit(
            mut self,
            input: std::option::Option<crate::model::CodeCommitCodeDestination>,
        ) -> Self {
            self.code_commit = input;
            self
        }
        /// <p>Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
        pub fn git_hub(mut self, input: crate::model::GitHubCodeDestination) -> Self {
            self.git_hub = Some(input);
            self
        }
        /// <p>Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
        pub fn set_git_hub(
            mut self,
            input: std::option::Option<crate::model::GitHubCodeDestination>,
        ) -> Self {
            self.git_hub = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeDestination`](crate::model::CodeDestination)
        pub fn build(self) -> crate::model::CodeDestination {
            crate::model::CodeDestination {
                code_commit: self.code_commit,
                git_hub: self.git_hub,
            }
        }
    }
}
impl CodeDestination {
    /// Creates a new builder-style object to manufacture [`CodeDestination`](crate::model::CodeDestination)
    pub fn builder() -> crate::model::code_destination::Builder {
        crate::model::code_destination::Builder::default()
    }
}

/// <p>Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GitHubCodeDestination {
    /// <p>Name of the GitHub repository to be created in AWS CodeStar.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub after the repository is created.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository should be owned by a GitHub organization, provide its name.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>Whether the GitHub repository is to be a private repository.</p>
    pub private_repository: bool,
    /// <p>Whether to enable issues for the GitHub repository.</p>
    pub issues_enabled: bool,
    /// <p>The GitHub user's personal access token for the GitHub repository.</p>
    pub token: std::option::Option<std::string::String>,
}
impl GitHubCodeDestination {
    /// <p>Name of the GitHub repository to be created in AWS CodeStar.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub after the repository is created.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository should be owned by a GitHub organization, provide its name.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>Whether the GitHub repository is to be a private repository.</p>
    pub fn private_repository(&self) -> bool {
        self.private_repository
    }
    /// <p>Whether to enable issues for the GitHub repository.</p>
    pub fn issues_enabled(&self) -> bool {
        self.issues_enabled
    }
    /// <p>The GitHub user's personal access token for the GitHub repository.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
}
impl std::fmt::Debug for GitHubCodeDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GitHubCodeDestination");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("owner", &self.owner);
        formatter.field("private_repository", &self.private_repository);
        formatter.field("issues_enabled", &self.issues_enabled);
        formatter.field("token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GitHubCodeDestination`](crate::model::GitHubCodeDestination)
pub mod git_hub_code_destination {
    /// A builder for [`GitHubCodeDestination`](crate::model::GitHubCodeDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) private_repository: std::option::Option<bool>,
        pub(crate) issues_enabled: std::option::Option<bool>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the GitHub repository to be created in AWS CodeStar.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the GitHub repository to be created in AWS CodeStar.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub after the repository is created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub after the repository is created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository should be owned by a GitHub organization, provide its name.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository should be owned by a GitHub organization, provide its name.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>Whether the GitHub repository is to be a private repository.</p>
        pub fn private_repository(mut self, input: bool) -> Self {
            self.private_repository = Some(input);
            self
        }
        /// <p>Whether the GitHub repository is to be a private repository.</p>
        pub fn set_private_repository(mut self, input: std::option::Option<bool>) -> Self {
            self.private_repository = input;
            self
        }
        /// <p>Whether to enable issues for the GitHub repository.</p>
        pub fn issues_enabled(mut self, input: bool) -> Self {
            self.issues_enabled = Some(input);
            self
        }
        /// <p>Whether to enable issues for the GitHub repository.</p>
        pub fn set_issues_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.issues_enabled = input;
            self
        }
        /// <p>The GitHub user's personal access token for the GitHub repository.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The GitHub user's personal access token for the GitHub repository.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`GitHubCodeDestination`](crate::model::GitHubCodeDestination)
        pub fn build(self) -> crate::model::GitHubCodeDestination {
            crate::model::GitHubCodeDestination {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                owner: self.owner,
                private_repository: self.private_repository.unwrap_or_default(),
                issues_enabled: self.issues_enabled.unwrap_or_default(),
                token: self.token,
            }
        }
    }
}
impl GitHubCodeDestination {
    /// Creates a new builder-style object to manufacture [`GitHubCodeDestination`](crate::model::GitHubCodeDestination)
    pub fn builder() -> crate::model::git_hub_code_destination::Builder {
        crate::model::git_hub_code_destination::Builder::default()
    }
}

/// <p>Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeCommitCodeDestination {
    /// <p>The name of the AWS CodeCommit repository to be created in AWS CodeStar.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CodeCommitCodeDestination {
    /// <p>The name of the AWS CodeCommit repository to be created in AWS CodeStar.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CodeCommitCodeDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeCommitCodeDestination");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CodeCommitCodeDestination`](crate::model::CodeCommitCodeDestination)
pub mod code_commit_code_destination {
    /// A builder for [`CodeCommitCodeDestination`](crate::model::CodeCommitCodeDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the AWS CodeCommit repository to be created in AWS CodeStar.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the AWS CodeCommit repository to be created in AWS CodeStar.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeCommitCodeDestination`](crate::model::CodeCommitCodeDestination)
        pub fn build(self) -> crate::model::CodeCommitCodeDestination {
            crate::model::CodeCommitCodeDestination { name: self.name }
        }
    }
}
impl CodeCommitCodeDestination {
    /// Creates a new builder-style object to manufacture [`CodeCommitCodeDestination`](crate::model::CodeCommitCodeDestination)
    pub fn builder() -> crate::model::code_commit_code_destination::Builder {
        crate::model::code_commit_code_destination::Builder::default()
    }
}

/// <p>The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the files during project creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeSource {
    /// <p>Information about the Amazon S3 location where the source code files provided with the project request are stored. </p>
    pub s3: std::option::Option<crate::model::S3Location>,
}
impl CodeSource {
    /// <p>Information about the Amazon S3 location where the source code files provided with the project request are stored. </p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for CodeSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeSource");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`CodeSource`](crate::model::CodeSource)
pub mod code_source {
    /// A builder for [`CodeSource`](crate::model::CodeSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Information about the Amazon S3 location where the source code files provided with the project request are stored. </p>
        pub fn s3(mut self, input: crate::model::S3Location) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>Information about the Amazon S3 location where the source code files provided with the project request are stored. </p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Location>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeSource`](crate::model::CodeSource)
        pub fn build(self) -> crate::model::CodeSource {
            crate::model::CodeSource { s3: self.s3 }
        }
    }
}
impl CodeSource {
    /// Creates a new builder-style object to manufacture [`CodeSource`](crate::model::CodeSource)
    pub fn builder() -> crate::model::code_source::Builder {
        crate::model::code_source::Builder::default()
    }
}
