// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_team_member_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTeamMemberOutput,
    crate::error::AssociateTeamMemberError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateTeamMemberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateTeamMemberError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::AssociateTeamMemberError {
            meta: generic,
            kind: crate::error::AssociateTeamMemberErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidServiceRoleException" => crate::error::AssociateTeamMemberError {
            meta: generic,
            kind: crate::error::AssociateTeamMemberErrorKind::InvalidServiceRoleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_service_role_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_service_role_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AssociateTeamMemberError {
            meta: generic,
            kind: crate::error::AssociateTeamMemberErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectConfigurationException" => crate::error::AssociateTeamMemberError {
            meta: generic,
            kind: crate::error::AssociateTeamMemberErrorKind::ProjectConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::project_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::AssociateTeamMemberError {
            meta: generic,
            kind: crate::error::AssociateTeamMemberErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TeamMemberAlreadyAssociatedException" => crate::error::AssociateTeamMemberError {
            meta: generic,
            kind: crate::error::AssociateTeamMemberErrorKind::TeamMemberAlreadyAssociatedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::team_member_already_associated_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_team_member_already_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTeamMemberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ValidationException" => crate::error::AssociateTeamMemberError {
            meta: generic,
            kind: crate::error::AssociateTeamMemberErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateTeamMemberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_team_member_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTeamMemberOutput,
    crate::error::AssociateTeamMemberError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_team_member_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_team_member(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateTeamMemberError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidServiceRoleException" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::InvalidServiceRoleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_service_role_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_service_role_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectAlreadyExistsException" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::ProjectAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::project_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectConfigurationException" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::ProjectConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::project_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectCreationFailedException" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::ProjectCreationFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::project_creation_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_creation_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserProfileOutput, crate::error::CreateUserProfileError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "UserProfileAlreadyExistsException" => crate::error::CreateUserProfileError {
            meta: generic,
            kind: crate::error::CreateUserProfileErrorKind::UserProfileAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_profile_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_profile_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateUserProfileError {
            meta: generic,
            kind: crate::error::CreateUserProfileErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserProfileOutput, crate::error::CreateUserProfileError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteProjectError {
            meta: generic,
            kind: crate::error::DeleteProjectErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidServiceRoleException" => crate::error::DeleteProjectError {
            meta: generic,
            kind: crate::error::DeleteProjectErrorKind::InvalidServiceRoleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_service_role_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_service_role_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteProjectError {
            meta: generic,
            kind: crate::error::DeleteProjectErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserProfileOutput, crate::error::DeleteUserProfileError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ValidationException" => crate::error::DeleteUserProfileError {
            meta: generic,
            kind: crate::error::DeleteUserProfileErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserProfileOutput, crate::error::DeleteUserProfileError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_user_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteUserProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeProjectOutput, crate::error::DescribeProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DescribeProjectError {
            meta: generic,
            kind: crate::error::DescribeProjectErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidServiceRoleException" => crate::error::DescribeProjectError {
            meta: generic,
            kind: crate::error::DescribeProjectErrorKind::InvalidServiceRoleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_service_role_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_service_role_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectConfigurationException" => crate::error::DescribeProjectError {
            meta: generic,
            kind: crate::error::DescribeProjectErrorKind::ProjectConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::project_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::DescribeProjectError {
            meta: generic,
            kind: crate::error::DescribeProjectErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeProjectError {
            meta: generic,
            kind: crate::error::DescribeProjectErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeProjectOutput, crate::error::DescribeProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserProfileOutput,
    crate::error::DescribeUserProfileError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "UserProfileNotFoundException" => crate::error::DescribeUserProfileError {
            meta: generic,
            kind: crate::error::DescribeUserProfileErrorKind::UserProfileNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_profile_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_profile_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DescribeUserProfileError {
            meta: generic,
            kind: crate::error::DescribeUserProfileErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserProfileOutput,
    crate::error::DescribeUserProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_user_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_user_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUserProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_team_member_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTeamMemberOutput,
    crate::error::DisassociateTeamMemberError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateTeamMemberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateTeamMemberError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DisassociateTeamMemberError {
            meta: generic,
            kind: crate::error::DisassociateTeamMemberErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidServiceRoleException" => crate::error::DisassociateTeamMemberError {
            meta: generic,
            kind: crate::error::DisassociateTeamMemberErrorKind::InvalidServiceRoleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_service_role_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_service_role_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::DisassociateTeamMemberError {
            meta: generic,
            kind: crate::error::DisassociateTeamMemberErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisassociateTeamMemberError {
            meta: generic,
            kind: crate::error::DisassociateTeamMemberErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateTeamMemberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_team_member_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTeamMemberOutput,
    crate::error::DisassociateTeamMemberError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_team_member_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_projects_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProjectsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListProjectsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListProjectsError {
            meta: generic,
            kind: crate::error::ListProjectsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListProjectsError {
            meta: generic,
            kind: crate::error::ListProjectsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListProjectsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_projects_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_projects_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_projects(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListProjectsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListResourcesOutput, crate::error::ListResourcesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResourcesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListResourcesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListResourcesError {
            meta: generic,
            kind: crate::error::ListResourcesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::ListResourcesError {
            meta: generic,
            kind: crate::error::ListResourcesErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListResourcesError {
            meta: generic,
            kind: crate::error::ListResourcesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListResourcesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListResourcesOutput, crate::error::ListResourcesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_resources_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_resources(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListResourcesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForProjectOutput,
    crate::error::ListTagsForProjectError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListTagsForProjectError {
            meta: generic,
            kind: crate::error::ListTagsForProjectErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::ListTagsForProjectError {
            meta: generic,
            kind: crate::error::ListTagsForProjectErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTagsForProjectError {
            meta: generic,
            kind: crate::error::ListTagsForProjectErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForProjectOutput,
    crate::error::ListTagsForProjectError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_team_members_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTeamMembersOutput, crate::error::ListTeamMembersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTeamMembersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTeamMembersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListTeamMembersError {
            meta: generic,
            kind: crate::error::ListTeamMembersErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTeamMembersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::ListTeamMembersError {
            meta: generic,
            kind: crate::error::ListTeamMembersErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTeamMembersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTeamMembersError {
            meta: generic,
            kind: crate::error::ListTeamMembersErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTeamMembersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTeamMembersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_team_members_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTeamMembersOutput, crate::error::ListTeamMembersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_team_members_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_team_members(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTeamMembersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_profiles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserProfilesOutput, crate::error::ListUserProfilesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserProfilesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUserProfilesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListUserProfilesError {
            meta: generic,
            kind: crate::error::ListUserProfilesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserProfilesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListUserProfilesError {
            meta: generic,
            kind: crate::error::ListUserProfilesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserProfilesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUserProfilesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_profiles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserProfilesOutput, crate::error::ListUserProfilesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_profiles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_user_profiles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserProfilesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagProjectOutput, crate::error::TagProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::TagProjectError {
            meta: generic,
            kind: crate::error::TagProjectErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::TagProjectError {
            meta: generic,
            kind: crate::error::TagProjectErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::TagProjectError {
            meta: generic,
            kind: crate::error::TagProjectErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::TagProjectError {
            meta: generic,
            kind: crate::error::TagProjectErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagProjectOutput, crate::error::TagProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_tag_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TagProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagProjectOutput, crate::error::UntagProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UntagProjectError {
            meta: generic,
            kind: crate::error::UntagProjectErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UntagProjectError {
            meta: generic,
            kind: crate::error::UntagProjectErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::UntagProjectError {
            meta: generic,
            kind: crate::error::UntagProjectErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UntagProjectError {
            meta: generic,
            kind: crate::error::UntagProjectErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagProjectOutput, crate::error::UntagProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_project_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ProjectNotFoundException" => crate::error::UpdateProjectError {
            meta: generic,
            kind: crate::error::UpdateProjectErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateProjectError {
            meta: generic,
            kind: crate::error::UpdateProjectErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_project_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_team_member_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTeamMemberOutput, crate::error::UpdateTeamMemberError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTeamMemberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTeamMemberError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateTeamMemberError {
            meta: generic,
            kind: crate::error::UpdateTeamMemberErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidServiceRoleException" => crate::error::UpdateTeamMemberError {
            meta: generic,
            kind: crate::error::UpdateTeamMemberErrorKind::InvalidServiceRoleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_service_role_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_service_role_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateTeamMemberError {
            meta: generic,
            kind: crate::error::UpdateTeamMemberErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectConfigurationException" => crate::error::UpdateTeamMemberError {
            meta: generic,
            kind: crate::error::UpdateTeamMemberErrorKind::ProjectConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::project_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProjectNotFoundException" => crate::error::UpdateTeamMemberError {
            meta: generic,
            kind: crate::error::UpdateTeamMemberErrorKind::ProjectNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::project_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_project_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TeamMemberNotFoundException" => crate::error::UpdateTeamMemberError {
            meta: generic,
            kind: crate::error::UpdateTeamMemberErrorKind::TeamMemberNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::team_member_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_team_member_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateTeamMemberError {
            meta: generic,
            kind: crate::error::UpdateTeamMemberErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTeamMemberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTeamMemberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_team_member_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTeamMemberOutput, crate::error::UpdateTeamMemberError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_team_member_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_team_member(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTeamMemberError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserProfileOutput, crate::error::UpdateUserProfileError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "UserProfileNotFoundException" => crate::error::UpdateUserProfileError {
            meta: generic,
            kind: crate::error::UpdateUserProfileErrorKind::UserProfileNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_profile_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_profile_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateUserProfileError {
            meta: generic,
            kind: crate::error::UpdateUserProfileErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserProfileOutput, crate::error::UpdateUserProfileError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_user_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateUserProfileError::unhandled)?;
        output.build()
    })
}
