// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CodeStar_20170419`.
///
/// This client allows ergonomic access to a `CodeStar_20170419`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateTeamMember` operation.
    ///
    /// See [`AssociateTeamMember`](crate::client::fluent_builders::AssociateTeamMember) for more information about the
    /// operation and its arguments.
    pub fn associate_team_member(&self) -> fluent_builders::AssociateTeamMember<C, M, R> {
        fluent_builders::AssociateTeamMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUserProfile` operation.
    ///
    /// See [`CreateUserProfile`](crate::client::fluent_builders::CreateUserProfile) for more information about the
    /// operation and its arguments.
    pub fn create_user_profile(&self) -> fluent_builders::CreateUserProfile<C, M, R> {
        fluent_builders::CreateUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserProfile` operation.
    ///
    /// See [`DeleteUserProfile`](crate::client::fluent_builders::DeleteUserProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_user_profile(&self) -> fluent_builders::DeleteUserProfile<C, M, R> {
        fluent_builders::DeleteUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProject` operation.
    ///
    /// See [`DescribeProject`](crate::client::fluent_builders::DescribeProject) for more information about the
    /// operation and its arguments.
    pub fn describe_project(&self) -> fluent_builders::DescribeProject<C, M, R> {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUserProfile` operation.
    ///
    /// See [`DescribeUserProfile`](crate::client::fluent_builders::DescribeUserProfile) for more information about the
    /// operation and its arguments.
    pub fn describe_user_profile(&self) -> fluent_builders::DescribeUserProfile<C, M, R> {
        fluent_builders::DescribeUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTeamMember` operation.
    ///
    /// See [`DisassociateTeamMember`](crate::client::fluent_builders::DisassociateTeamMember) for more information about the
    /// operation and its arguments.
    pub fn disassociate_team_member(&self) -> fluent_builders::DisassociateTeamMember<C, M, R> {
        fluent_builders::DisassociateTeamMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResources` operation.
    ///
    /// See [`ListResources`](crate::client::fluent_builders::ListResources) for more information about the
    /// operation and its arguments.
    pub fn list_resources(&self) -> fluent_builders::ListResources<C, M, R> {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForProject` operation.
    ///
    /// See [`ListTagsForProject`](crate::client::fluent_builders::ListTagsForProject) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_project(&self) -> fluent_builders::ListTagsForProject<C, M, R> {
        fluent_builders::ListTagsForProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTeamMembers` operation.
    ///
    /// See [`ListTeamMembers`](crate::client::fluent_builders::ListTeamMembers) for more information about the
    /// operation and its arguments.
    pub fn list_team_members(&self) -> fluent_builders::ListTeamMembers<C, M, R> {
        fluent_builders::ListTeamMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUserProfiles` operation.
    ///
    /// See [`ListUserProfiles`](crate::client::fluent_builders::ListUserProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_user_profiles(&self) -> fluent_builders::ListUserProfiles<C, M, R> {
        fluent_builders::ListUserProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagProject` operation.
    ///
    /// See [`TagProject`](crate::client::fluent_builders::TagProject) for more information about the
    /// operation and its arguments.
    pub fn tag_project(&self) -> fluent_builders::TagProject<C, M, R> {
        fluent_builders::TagProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagProject` operation.
    ///
    /// See [`UntagProject`](crate::client::fluent_builders::UntagProject) for more information about the
    /// operation and its arguments.
    pub fn untag_project(&self) -> fluent_builders::UntagProject<C, M, R> {
        fluent_builders::UntagProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTeamMember` operation.
    ///
    /// See [`UpdateTeamMember`](crate::client::fluent_builders::UpdateTeamMember) for more information about the
    /// operation and its arguments.
    pub fn update_team_member(&self) -> fluent_builders::UpdateTeamMember<C, M, R> {
        fluent_builders::UpdateTeamMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserProfile` operation.
    ///
    /// See [`UpdateUserProfile`](crate::client::fluent_builders::UpdateUserProfile) for more information about the
    /// operation and its arguments.
    pub fn update_user_profile(&self) -> fluent_builders::UpdateUserProfile<C, M, R> {
        fluent_builders::UpdateUserProfile::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateTeamMember`.
    ///
    /// <p>Adds an IAM user to the team for an AWS CodeStar project.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateTeamMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_team_member_input::Builder,
    }
    impl<C, M, R> AssociateTeamMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTeamMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTeamMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTeamMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTeamMemberInputOperationOutputAlias,
                crate::output::AssociateTeamMemberOutput,
                crate::error::AssociateTeamMemberError,
                crate::input::AssociateTeamMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to which you will add the IAM user.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project to which you will add the IAM user.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested the team
        /// member association to the project. This token can be used to repeat the request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested the team
        /// member association to the project. This token can be used to repeat the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar
        /// project.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar
        /// project.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The AWS CodeStar project role that will apply to this user. This role determines what actions
        /// a user can take in an AWS CodeStar project.</p>
        pub fn project_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_role(inp);
            self
        }
        /// <p>The AWS CodeStar project role that will apply to this user. This role determines what actions
        /// a user can take in an AWS CodeStar project.</p>
        pub fn set_project_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_role(input);
            self
        }
        /// <p>Whether the team member is allowed to use an SSH public/private key pair to remotely
        /// access project resources, for example Amazon EC2 instances.</p>
        pub fn remote_access_allowed(mut self, inp: bool) -> Self {
            self.inner = self.inner.remote_access_allowed(inp);
            self
        }
        /// <p>Whether the team member is allowed to use an SSH public/private key pair to remotely
        /// access project resources, for example Amazon EC2 instances.</p>
        pub fn set_remote_access_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remote_access_allowed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a project, including project resources. This action creates a project based on
    /// a submitted project request. A set of source code files and a toolchain template file
    /// can be included with the project request. If these are not provided, an empty project is created.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The display name for the project to be created in AWS CodeStar.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The display name for the project to be created in AWS CodeStar.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the project to be created in AWS CodeStar.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the project to be created in AWS CodeStar.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// creation. This token can be used to repeat the request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// creation. This token can be used to repeat the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `sourceCode`.
        ///
        /// To override the contents of this collection use [`set_source_code`](Self::set_source_code).
        ///
        /// <p>A list of the Code objects submitted with the project request. If this
        /// parameter is specified, the request must also include the toolchain parameter.</p>
        pub fn source_code(mut self, inp: impl Into<crate::model::Code>) -> Self {
            self.inner = self.inner.source_code(inp);
            self
        }
        /// <p>A list of the Code objects submitted with the project request. If this
        /// parameter is specified, the request must also include the toolchain parameter.</p>
        pub fn set_source_code(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Code>>,
        ) -> Self {
            self.inner = self.inner.set_source_code(input);
            self
        }
        /// <p>The name of the toolchain template file submitted with the project request. If
        /// this parameter is specified, the request must also include the sourceCode parameter.</p>
        pub fn toolchain(mut self, inp: crate::model::Toolchain) -> Self {
            self.inner = self.inner.toolchain(inp);
            self
        }
        /// <p>The name of the toolchain template file submitted with the project request. If
        /// this parameter is specified, the request must also include the sourceCode parameter.</p>
        pub fn set_toolchain(
            mut self,
            input: std::option::Option<crate::model::Toolchain>,
        ) -> Self {
            self.inner = self.inner.set_toolchain(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags created for the project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags created for the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserProfile`.
    ///
    /// <p>Creates a profile for a user that includes user preferences, such as the display name
    /// and email address assocciated with the user, in AWS CodeStar. The user profile is not
    /// project-specific. Information in the user profile is displayed wherever the user's information
    /// appears to other users in AWS CodeStar.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_profile_input::Builder,
    }
    impl<C, M, R> CreateUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserProfileInputOperationOutputAlias,
                crate::output::CreateUserProfileOutput,
                crate::error::CreateUserProfileError,
                crate::input::CreateUserProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS CodeStar. </p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS CodeStar. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The email address that will be displayed as part of the user's profile in
        /// AWS CodeStar.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address that will be displayed as part of the user's profile in
        /// AWS CodeStar.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the
        /// user remote access to project resources, this public key will be used along with the user's
        /// private key for SSH access.</p>
        pub fn ssh_public_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key(inp);
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the
        /// user remote access to project resources, this public key will be used along with the user's
        /// private key for SSH access.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes a project, including project resources. Does not delete users associated with
    /// the project, but does delete the IAM roles that allowed access to the project.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to be deleted in AWS CodeStar.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the project to be deleted in AWS CodeStar.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// deletion. This token can be used to repeat the request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// deletion. This token can be used to repeat the request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Whether to send a delete request for the primary stack in AWS CloudFormation originally
        /// used to generate the project and its resources. This option will delete all AWS resources for
        /// the project (except for any buckets in Amazon S3) as well as deleting the project itself.
        /// Recommended for most use cases.</p>
        pub fn delete_stack(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_stack(inp);
            self
        }
        /// <p>Whether to send a delete request for the primary stack in AWS CloudFormation originally
        /// used to generate the project and its resources. This option will delete all AWS resources for
        /// the project (except for any buckets in Amazon S3) as well as deleting the project itself.
        /// Recommended for most use cases.</p>
        pub fn set_delete_stack(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_stack(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserProfile`.
    ///
    /// <p>Deletes a user profile in AWS CodeStar, including all personal preference data associated with
    /// that profile, such as display name and email address. It does not delete the history of that
    /// user, for example the history of commits made by that user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_profile_input::Builder,
    }
    impl<C, M, R> DeleteUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserProfileInputOperationOutputAlias,
                crate::output::DeleteUserProfileOutput,
                crate::error::DeleteUserProfileError,
                crate::input::DeleteUserProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Describes a project and its resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl<C, M, R> DescribeProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectInputOperationOutputAlias,
                crate::output::DescribeProjectOutput,
                crate::error::DescribeProjectError,
                crate::input::DescribeProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserProfile`.
    ///
    /// <p>Describes a user in AWS CodeStar and the user attributes across all projects.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_profile_input::Builder,
    }
    impl<C, M, R> DescribeUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserProfileInputOperationOutputAlias,
                crate::output::DescribeUserProfileOutput,
                crate::error::DescribeUserProfileError,
                crate::input::DescribeUserProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTeamMember`.
    ///
    /// <p>Removes a user from a project. Removing a user from a project also removes the IAM
    /// policies from that user that allowed access to the project and its resources. Disassociating a
    /// team member does not remove that user's profile from AWS CodeStar. It does not remove the user from
    /// IAM.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateTeamMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_team_member_input::Builder,
    }
    impl<C, M, R> DisassociateTeamMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTeamMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTeamMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTeamMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTeamMemberInputOperationOutputAlias,
                crate::output::DisassociateTeamMemberOutput,
                crate::error::DisassociateTeamMemberError,
                crate::input::DisassociateTeamMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the AWS CodeStar project from which you want to remove a team member.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the AWS CodeStar project from which you want to remove a team member.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user or group whom you want to remove from
        /// the project.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user or group whom you want to remove from
        /// the project.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Lists all projects in AWS CodeStar associated with your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The continuation token to be used to return the next set of results, if the results
        /// cannot be returned in one response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The continuation token to be used to return the next set of results, if the results
        /// cannot be returned in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Lists resources associated with a project in AWS CodeStar.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl<C, M, R> ListResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesInputOperationOutputAlias,
                crate::output::ListResourcesOutput,
                crate::error::ListResourcesError,
                crate::input::ListResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned
        /// in one response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned
        /// in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum amount of data that can be contained in a single set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForProject`.
    ///
    /// <p>Gets the tags for a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_project_input::Builder,
    }
    impl<C, M, R> ListTagsForProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForProjectInputOperationOutputAlias,
                crate::output::ListTagsForProjectOutput,
                crate::error::ListTagsForProjectError,
                crate::input::ListTagsForProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to get tags for.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the project to get tags for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTeamMembers`.
    ///
    /// <p>Lists all team members associated with a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTeamMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_team_members_input::Builder,
    }
    impl<C, M, R> ListTeamMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTeamMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTeamMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTeamMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTeamMembersInputOperationOutputAlias,
                crate::output::ListTeamMembersOutput,
                crate::error::ListTeamMembersError,
                crate::input::ListTeamMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project for which you want to list team members.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project for which you want to list team members.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned
        /// in one response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned
        /// in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of team members you want returned in a response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of team members you want returned in a response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserProfiles`.
    ///
    /// <p>Lists all the user profiles configured for your AWS account in AWS CodeStar.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUserProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_profiles_input::Builder,
    }
    impl<C, M, R> ListUserProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserProfilesInputOperationOutputAlias,
                crate::output::ListUserProfilesOutput,
                crate::error::ListUserProfilesError,
                crate::input::ListUserProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned
        /// in one response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The continuation token for the next set of results, if the results cannot be returned
        /// in one response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagProject`.
    ///
    /// <p>Adds tags to a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_project_input::Builder,
    }
    impl<C, M, R> TagProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::TagProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagProjectInputOperationOutputAlias,
                crate::output::TagProjectOutput,
                crate::error::TagProjectError,
                crate::input::TagProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project you want to add a tag to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the project you want to add a tag to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to add to the project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags you want to add to the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagProject`.
    ///
    /// <p>Removes tags from a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_project_input::Builder,
    }
    impl<C, M, R> UntagProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagProjectInputOperationOutputAlias,
                crate::output::UntagProjectOutput,
                crate::error::UntagProjectError,
                crate::input::UntagProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to remove tags from.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the project to remove tags from.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to remove from the project.</p>
        pub fn tags(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to remove from the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Updates a project in AWS CodeStar.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project you want to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the project you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the project you want to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the project you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTeamMember`.
    ///
    /// <p>Updates a team member's attributes in an AWS CodeStar project. For example, you can change a
    /// team member's role in the project, or change whether they have remote access to project
    /// resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTeamMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_team_member_input::Builder,
    }
    impl<C, M, R> UpdateTeamMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTeamMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTeamMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTeamMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTeamMemberInputOperationOutputAlias,
                crate::output::UpdateTeamMemberOutput,
                crate::error::UpdateTeamMemberError,
                crate::input::UpdateTeamMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user for whom you want to change team membership
        /// attributes.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user for whom you want to change team membership
        /// attributes.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The role assigned to the user in the project. Project roles have different levels of
        /// access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
        /// Teams</a> in the <i>AWS CodeStar User Guide</i>.</p>
        pub fn project_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_role(inp);
            self
        }
        /// <p>The role assigned to the user in the project. Project roles have different levels of
        /// access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
        /// Teams</a> in the <i>AWS CodeStar User Guide</i>.</p>
        pub fn set_project_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_role(input);
            self
        }
        /// <p>Whether a team member is allowed to remotely access project resources using the SSH
        /// public key associated with the user's profile. Even if this is set to True, the user must
        /// associate a public key with their profile before the user can access resources.</p>
        pub fn remote_access_allowed(mut self, inp: bool) -> Self {
            self.inner = self.inner.remote_access_allowed(inp);
            self
        }
        /// <p>Whether a team member is allowed to remotely access project resources using the SSH
        /// public key associated with the user's profile. Even if this is set to True, the user must
        /// associate a public key with their profile before the user can access resources.</p>
        pub fn set_remote_access_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remote_access_allowed(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserProfile`.
    ///
    /// <p>Updates a user's profile in AWS CodeStar. The user profile is not project-specific.
    /// Information in the user profile is displayed wherever the user's information appears to other
    /// users in AWS CodeStar. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_profile_input::Builder,
    }
    impl<C, M, R> UpdateUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserProfileInputOperationOutputAlias,
                crate::output::UpdateUserProfileOutput,
                crate::error::UpdateUserProfileError,
                crate::input::UpdateUserProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS
        /// CodeStar.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The name that will be displayed as the friendly name for the user in AWS
        /// CodeStar.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS
        /// CodeStar.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS
        /// CodeStar.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the
        /// user remote access to project resources, this public key will be used along with the user's
        /// private key for SSH access.</p>
        pub fn ssh_public_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key(inp);
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. If a project owner allows the
        /// user remote access to project resources, this public key will be used along with the user's
        /// private key for SSH access.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
