// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The email address that is displayed as part of the user's profile in AWS
    /// CodeStar.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
    /// public/private keypair the user can use to access project resources if a project owner allows
    /// the user remote access to those resources.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>The date the user profile was created, in timestamp format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date the user profile was last modified, in timestamp format.</p>
    pub last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl UpdateUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
    /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The email address that is displayed as part of the user's profile in AWS
    /// CodeStar.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
    /// public/private keypair the user can use to access project resources if a project owner allows
    /// the user remote access to those resources.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>The date the user profile was created, in timestamp format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The date the user profile was last modified, in timestamp format.</p>
    pub fn last_modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_timestamp.as_ref()
    }
}
impl std::fmt::Debug for UpdateUserProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserProfileOutput");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_modified_timestamp", &self.last_modified_timestamp);
        formatter.finish()
    }
}
/// See [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
pub mod update_user_profile_output {
    /// A builder for [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS
        /// CodeStar.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS
        /// CodeStar.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
        /// public/private keypair the user can use to access project resources if a project owner allows
        /// the user remote access to those resources.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
        /// public/private keypair the user can use to access project resources if a project owner allows
        /// the user remote access to those resources.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>The date the user profile was created, in timestamp format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The date the user profile was created, in timestamp format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The date the user profile was last modified, in timestamp format.</p>
        pub fn last_modified_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_timestamp = Some(input);
            self
        }
        /// <p>The date the user profile was last modified, in timestamp format.</p>
        pub fn set_last_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
        pub fn build(self) -> crate::output::UpdateUserProfileOutput {
            crate::output::UpdateUserProfileOutput {
                user_arn: self.user_arn,
                display_name: self.display_name,
                email_address: self.email_address,
                ssh_public_key: self.ssh_public_key,
                created_timestamp: self.created_timestamp,
                last_modified_timestamp: self.last_modified_timestamp,
            }
        }
    }
}
impl UpdateUserProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
    pub fn builder() -> crate::output::update_user_profile_output::Builder {
        crate::output::update_user_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTeamMemberOutput {
    /// <p>The Amazon Resource Name (ARN) of the user whose team membership attributes were
    /// updated.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The project role granted to the user.</p>
    pub project_role: std::option::Option<std::string::String>,
    /// <p>Whether a team member is allowed to remotely access project resources using the SSH
    /// public key associated with the user's profile.</p>
    pub remote_access_allowed: std::option::Option<bool>,
}
impl UpdateTeamMemberOutput {
    /// <p>The Amazon Resource Name (ARN) of the user whose team membership attributes were
    /// updated.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
    /// <p>The project role granted to the user.</p>
    pub fn project_role(&self) -> std::option::Option<&str> {
        self.project_role.as_deref()
    }
    /// <p>Whether a team member is allowed to remotely access project resources using the SSH
    /// public key associated with the user's profile.</p>
    pub fn remote_access_allowed(&self) -> std::option::Option<bool> {
        self.remote_access_allowed
    }
}
impl std::fmt::Debug for UpdateTeamMemberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTeamMemberOutput");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("project_role", &self.project_role);
        formatter.field("remote_access_allowed", &self.remote_access_allowed);
        formatter.finish()
    }
}
/// See [`UpdateTeamMemberOutput`](crate::output::UpdateTeamMemberOutput)
pub mod update_team_member_output {
    /// A builder for [`UpdateTeamMemberOutput`](crate::output::UpdateTeamMemberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) project_role: std::option::Option<std::string::String>,
        pub(crate) remote_access_allowed: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user whose team membership attributes were
        /// updated.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose team membership attributes were
        /// updated.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The project role granted to the user.</p>
        pub fn project_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_role = Some(input.into());
            self
        }
        /// <p>The project role granted to the user.</p>
        pub fn set_project_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_role = input;
            self
        }
        /// <p>Whether a team member is allowed to remotely access project resources using the SSH
        /// public key associated with the user's profile.</p>
        pub fn remote_access_allowed(mut self, input: bool) -> Self {
            self.remote_access_allowed = Some(input);
            self
        }
        /// <p>Whether a team member is allowed to remotely access project resources using the SSH
        /// public key associated with the user's profile.</p>
        pub fn set_remote_access_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_access_allowed = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTeamMemberOutput`](crate::output::UpdateTeamMemberOutput)
        pub fn build(self) -> crate::output::UpdateTeamMemberOutput {
            crate::output::UpdateTeamMemberOutput {
                user_arn: self.user_arn,
                project_role: self.project_role,
                remote_access_allowed: self.remote_access_allowed,
            }
        }
    }
}
impl UpdateTeamMemberOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTeamMemberOutput`](crate::output::UpdateTeamMemberOutput)
    pub fn builder() -> crate::output::update_team_member_output::Builder {
        crate::output::update_team_member_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectOutput {}
impl std::fmt::Debug for UpdateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectOutput");
        formatter.finish()
    }
}
/// See [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
pub mod update_project_output {
    /// A builder for [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
        pub fn build(self) -> crate::output::UpdateProjectOutput {
            crate::output::UpdateProjectOutput {}
        }
    }
}
impl UpdateProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    pub fn builder() -> crate::output::update_project_output::Builder {
        crate::output::update_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagProjectOutput {}
impl std::fmt::Debug for UntagProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagProjectOutput");
        formatter.finish()
    }
}
/// See [`UntagProjectOutput`](crate::output::UntagProjectOutput)
pub mod untag_project_output {
    /// A builder for [`UntagProjectOutput`](crate::output::UntagProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagProjectOutput`](crate::output::UntagProjectOutput)
        pub fn build(self) -> crate::output::UntagProjectOutput {
            crate::output::UntagProjectOutput {}
        }
    }
}
impl UntagProjectOutput {
    /// Creates a new builder-style object to manufacture [`UntagProjectOutput`](crate::output::UntagProjectOutput)
    pub fn builder() -> crate::output::untag_project_output::Builder {
        crate::output::untag_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagProjectOutput {
    /// <p>The tags for the project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagProjectOutput {
    /// <p>The tags for the project.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagProjectOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TagProjectOutput`](crate::output::TagProjectOutput)
pub mod tag_project_output {
    /// A builder for [`TagProjectOutput`](crate::output::TagProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagProjectOutput`](crate::output::TagProjectOutput)
        pub fn build(self) -> crate::output::TagProjectOutput {
            crate::output::TagProjectOutput { tags: self.tags }
        }
    }
}
impl TagProjectOutput {
    /// Creates a new builder-style object to manufacture [`TagProjectOutput`](crate::output::TagProjectOutput)
    pub fn builder() -> crate::output::tag_project_output::Builder {
        crate::output::tag_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserProfilesOutput {
    /// <p>All the user profiles configured in AWS CodeStar for an AWS account.</p>
    pub user_profiles: std::option::Option<std::vec::Vec<crate::model::UserProfileSummary>>,
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUserProfilesOutput {
    /// <p>All the user profiles configured in AWS CodeStar for an AWS account.</p>
    pub fn user_profiles(&self) -> std::option::Option<&[crate::model::UserProfileSummary]> {
        self.user_profiles.as_deref()
    }
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUserProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserProfilesOutput");
        formatter.field("user_profiles", &self.user_profiles);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
pub mod list_user_profiles_output {
    /// A builder for [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_profiles:
            std::option::Option<std::vec::Vec<crate::model::UserProfileSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_profiles`.
        ///
        /// To override the contents of this collection use [`set_user_profiles`](Self::set_user_profiles).
        ///
        /// <p>All the user profiles configured in AWS CodeStar for an AWS account.</p>
        pub fn user_profiles(mut self, input: impl Into<crate::model::UserProfileSummary>) -> Self {
            let mut v = self.user_profiles.unwrap_or_default();
            v.push(input.into());
            self.user_profiles = Some(v);
            self
        }
        /// <p>All the user profiles configured in AWS CodeStar for an AWS account.</p>
        pub fn set_user_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserProfileSummary>>,
        ) -> Self {
            self.user_profiles = input;
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
        pub fn build(self) -> crate::output::ListUserProfilesOutput {
            crate::output::ListUserProfilesOutput {
                user_profiles: self.user_profiles,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUserProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
    pub fn builder() -> crate::output::list_user_profiles_output::Builder {
        crate::output::list_user_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTeamMembersOutput {
    /// <p>A list of team member objects for the project.</p>
    pub team_members: std::option::Option<std::vec::Vec<crate::model::TeamMember>>,
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTeamMembersOutput {
    /// <p>A list of team member objects for the project.</p>
    pub fn team_members(&self) -> std::option::Option<&[crate::model::TeamMember]> {
        self.team_members.as_deref()
    }
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTeamMembersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTeamMembersOutput");
        formatter.field("team_members", &self.team_members);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTeamMembersOutput`](crate::output::ListTeamMembersOutput)
pub mod list_team_members_output {
    /// A builder for [`ListTeamMembersOutput`](crate::output::ListTeamMembersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) team_members: std::option::Option<std::vec::Vec<crate::model::TeamMember>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `team_members`.
        ///
        /// To override the contents of this collection use [`set_team_members`](Self::set_team_members).
        ///
        /// <p>A list of team member objects for the project.</p>
        pub fn team_members(mut self, input: impl Into<crate::model::TeamMember>) -> Self {
            let mut v = self.team_members.unwrap_or_default();
            v.push(input.into());
            self.team_members = Some(v);
            self
        }
        /// <p>A list of team member objects for the project.</p>
        pub fn set_team_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TeamMember>>,
        ) -> Self {
            self.team_members = input;
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTeamMembersOutput`](crate::output::ListTeamMembersOutput)
        pub fn build(self) -> crate::output::ListTeamMembersOutput {
            crate::output::ListTeamMembersOutput {
                team_members: self.team_members,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTeamMembersOutput {
    /// Creates a new builder-style object to manufacture [`ListTeamMembersOutput`](crate::output::ListTeamMembersOutput)
    pub fn builder() -> crate::output::list_team_members_output::Builder {
        crate::output::list_team_members_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForProjectOutput {
    /// <p>The tags for the project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForProjectOutput {
    /// <p>The tags for the project.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForProjectOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForProjectOutput`](crate::output::ListTagsForProjectOutput)
pub mod list_tags_for_project_output {
    /// A builder for [`ListTagsForProjectOutput`](crate::output::ListTagsForProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForProjectOutput`](crate::output::ListTagsForProjectOutput)
        pub fn build(self) -> crate::output::ListTagsForProjectOutput {
            crate::output::ListTagsForProjectOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForProjectOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForProjectOutput`](crate::output::ListTagsForProjectOutput)
    pub fn builder() -> crate::output::list_tags_for_project_output::Builder {
        crate::output::list_tags_for_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesOutput {
    /// <p>An array of resources associated with the project. </p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourcesOutput {
    /// <p>An array of resources associated with the project. </p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesOutput");
        formatter.field("resources", &self.resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourcesOutput`](crate::output::ListResourcesOutput)
pub mod list_resources_output {
    /// A builder for [`ListResourcesOutput`](crate::output::ListResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>An array of resources associated with the project. </p>
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>An array of resources associated with the project. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesOutput`](crate::output::ListResourcesOutput)
        pub fn build(self) -> crate::output::ListResourcesOutput {
            crate::output::ListResourcesOutput {
                resources: self.resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListResourcesOutput`](crate::output::ListResourcesOutput)
    pub fn builder() -> crate::output::list_resources_output::Builder {
        crate::output::list_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>A list of projects.</p>
    pub projects: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsOutput {
    /// <p>A list of projects.</p>
    pub fn projects(&self) -> std::option::Option<&[crate::model::ProjectSummary]> {
        self.projects.as_deref()
    }
    /// <p>The continuation token to use when requesting the next set of results, if there are
    /// more results to be returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("projects", &self.projects);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projects: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p>A list of projects.</p>
        pub fn projects(mut self, input: impl Into<crate::model::ProjectSummary>) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input.into());
            self.projects = Some(v);
            self
        }
        /// <p>A list of projects.</p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The continuation token to use when requesting the next set of results, if there are
        /// more results to be returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                projects: self.projects,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTeamMemberOutput {}
impl std::fmt::Debug for DisassociateTeamMemberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTeamMemberOutput");
        formatter.finish()
    }
}
/// See [`DisassociateTeamMemberOutput`](crate::output::DisassociateTeamMemberOutput)
pub mod disassociate_team_member_output {
    /// A builder for [`DisassociateTeamMemberOutput`](crate::output::DisassociateTeamMemberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateTeamMemberOutput`](crate::output::DisassociateTeamMemberOutput)
        pub fn build(self) -> crate::output::DisassociateTeamMemberOutput {
            crate::output::DisassociateTeamMemberOutput {}
        }
    }
}
impl DisassociateTeamMemberOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateTeamMemberOutput`](crate::output::DisassociateTeamMemberOutput)
    pub fn builder() -> crate::output::disassociate_team_member_output::Builder {
        crate::output::disassociate_team_member_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The display name shown for the user in AWS CodeStar projects. For example, this could be set
    /// to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also
    /// used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are
    /// included in the display name, the first character that appears after the space will be used as
    /// the second character in the user initial icon. The initial icon displays a maximum of two
    /// characters, so a display name with more than one space (for example "Mary Jane Major") would
    /// generate an initial icon using the first character and the first character after the space
    /// ("MJ", not "MM").</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The email address for the user. Optional.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The SSH public key associated with the user. This SSH public key is associated with the
    /// user profile, and can be used in conjunction with the associated private key for access to
    /// project resources, such as Amazon EC2 instances, if a project owner grants remote access to
    /// those resources.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>The date and time when the user profile was created in AWS CodeStar, in timestamp
    /// format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the user profile was last modified, in timestamp
    /// format.</p>
    pub last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
    /// <p>The display name shown for the user in AWS CodeStar projects. For example, this could be set
    /// to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also
    /// used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are
    /// included in the display name, the first character that appears after the space will be used as
    /// the second character in the user initial icon. The initial icon displays a maximum of two
    /// characters, so a display name with more than one space (for example "Mary Jane Major") would
    /// generate an initial icon using the first character and the first character after the space
    /// ("MJ", not "MM").</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The email address for the user. Optional.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The SSH public key associated with the user. This SSH public key is associated with the
    /// user profile, and can be used in conjunction with the associated private key for access to
    /// project resources, such as Amazon EC2 instances, if a project owner grants remote access to
    /// those resources.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>The date and time when the user profile was created in AWS CodeStar, in timestamp
    /// format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The date and time when the user profile was last modified, in timestamp
    /// format.</p>
    pub fn last_modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_timestamp.as_ref()
    }
}
impl std::fmt::Debug for DescribeUserProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserProfileOutput");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_modified_timestamp", &self.last_modified_timestamp);
        formatter.finish()
    }
}
/// See [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
pub mod describe_user_profile_output {
    /// A builder for [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The display name shown for the user in AWS CodeStar projects. For example, this could be set
        /// to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also
        /// used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are
        /// included in the display name, the first character that appears after the space will be used as
        /// the second character in the user initial icon. The initial icon displays a maximum of two
        /// characters, so a display name with more than one space (for example "Mary Jane Major") would
        /// generate an initial icon using the first character and the first character after the space
        /// ("MJ", not "MM").</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name shown for the user in AWS CodeStar projects. For example, this could be set
        /// to both first and last name ("Mary Major") or a single name ("Mary"). The display name is also
        /// used to generate the initial icon associated with the user in AWS CodeStar projects. If spaces are
        /// included in the display name, the first character that appears after the space will be used as
        /// the second character in the user initial icon. The initial icon displays a maximum of two
        /// characters, so a display name with more than one space (for example "Mary Jane Major") would
        /// generate an initial icon using the first character and the first character after the space
        /// ("MJ", not "MM").</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The email address for the user. Optional.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address for the user. Optional.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The SSH public key associated with the user. This SSH public key is associated with the
        /// user profile, and can be used in conjunction with the associated private key for access to
        /// project resources, such as Amazon EC2 instances, if a project owner grants remote access to
        /// those resources.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The SSH public key associated with the user. This SSH public key is associated with the
        /// user profile, and can be used in conjunction with the associated private key for access to
        /// project resources, such as Amazon EC2 instances, if a project owner grants remote access to
        /// those resources.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>The date and time when the user profile was created in AWS CodeStar, in timestamp
        /// format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the user profile was created in AWS CodeStar, in timestamp
        /// format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The date and time when the user profile was last modified, in timestamp
        /// format.</p>
        pub fn last_modified_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the user profile was last modified, in timestamp
        /// format.</p>
        pub fn set_last_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
        pub fn build(self) -> crate::output::DescribeUserProfileOutput {
            crate::output::DescribeUserProfileOutput {
                user_arn: self.user_arn,
                display_name: self.display_name,
                email_address: self.email_address,
                ssh_public_key: self.ssh_public_key,
                created_timestamp: self.created_timestamp,
                last_modified_timestamp: self.last_modified_timestamp,
            }
        }
    }
}
impl DescribeUserProfileOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
    pub fn builder() -> crate::output::describe_user_profile_output::Builder {
        crate::output::describe_user_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectOutput {
    /// <p>The display name for the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the project.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the project.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description of the project, if any.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A user- or system-generated token that identifies the entity that requested project
    /// creation. </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The date and time the project was created, in timestamp format.</p>
    pub created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the primary stack in AWS CloudFormation used to generate resources for the
    /// project.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The ID for the AWS CodeStar project template used to create the project.</p>
    pub project_template_id: std::option::Option<std::string::String>,
    /// <p>The project creation or deletion status.</p>
    pub status: std::option::Option<crate::model::ProjectStatus>,
}
impl DescribeProjectOutput {
    /// <p>The display name for the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the project.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the project.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description of the project, if any.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A user- or system-generated token that identifies the entity that requested project
    /// creation. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The date and time the project was created, in timestamp format.</p>
    pub fn created_time_stamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time_stamp.as_ref()
    }
    /// <p>The ID of the primary stack in AWS CloudFormation used to generate resources for the
    /// project.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The ID for the AWS CodeStar project template used to create the project.</p>
    pub fn project_template_id(&self) -> std::option::Option<&str> {
        self.project_template_id.as_deref()
    }
    /// <p>The project creation or deletion status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProjectStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DescribeProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectOutput");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("created_time_stamp", &self.created_time_stamp);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("project_template_id", &self.project_template_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
pub mod describe_project_output {
    /// A builder for [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) project_template_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProjectStatus>,
    }
    impl Builder {
        /// <p>The display name for the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The display name for the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the project.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the project.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the project, if any.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// creation. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// creation. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The date and time the project was created, in timestamp format.</p>
        pub fn created_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time_stamp = Some(input);
            self
        }
        /// <p>The date and time the project was created, in timestamp format.</p>
        pub fn set_created_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time_stamp = input;
            self
        }
        /// <p>The ID of the primary stack in AWS CloudFormation used to generate resources for the
        /// project.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the primary stack in AWS CloudFormation used to generate resources for the
        /// project.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The ID for the AWS CodeStar project template used to create the project.</p>
        pub fn project_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_template_id = Some(input.into());
            self
        }
        /// <p>The ID for the AWS CodeStar project template used to create the project.</p>
        pub fn set_project_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_template_id = input;
            self
        }
        /// <p>The project creation or deletion status.</p>
        pub fn status(mut self, input: crate::model::ProjectStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The project creation or deletion status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProjectStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
        pub fn build(self) -> crate::output::DescribeProjectOutput {
            crate::output::DescribeProjectOutput {
                name: self.name,
                id: self.id,
                arn: self.arn,
                description: self.description,
                client_request_token: self.client_request_token,
                created_time_stamp: self.created_time_stamp,
                stack_id: self.stack_id,
                project_template_id: self.project_template_id,
                status: self.status,
            }
        }
    }
}
impl DescribeProjectOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    pub fn builder() -> crate::output::describe_project_output::Builder {
        crate::output::describe_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user deleted from AWS CodeStar.</p>
    pub user_arn: std::option::Option<std::string::String>,
}
impl DeleteUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user deleted from AWS CodeStar.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserProfileOutput");
        formatter.field("user_arn", &self.user_arn);
        formatter.finish()
    }
}
/// See [`DeleteUserProfileOutput`](crate::output::DeleteUserProfileOutput)
pub mod delete_user_profile_output {
    /// A builder for [`DeleteUserProfileOutput`](crate::output::DeleteUserProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user deleted from AWS CodeStar.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user deleted from AWS CodeStar.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserProfileOutput`](crate::output::DeleteUserProfileOutput)
        pub fn build(self) -> crate::output::DeleteUserProfileOutput {
            crate::output::DeleteUserProfileOutput {
                user_arn: self.user_arn,
            }
        }
    }
}
impl DeleteUserProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserProfileOutput`](crate::output::DeleteUserProfileOutput)
    pub fn builder() -> crate::output::delete_user_profile_output::Builder {
        crate::output::delete_user_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectOutput {
    /// <p>The ID of the primary stack in AWS CloudFormation that will be deleted as part of
    /// deleting the project and its resources.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the deleted project.</p>
    pub project_arn: std::option::Option<std::string::String>,
}
impl DeleteProjectOutput {
    /// <p>The ID of the primary stack in AWS CloudFormation that will be deleted as part of
    /// deleting the project and its resources.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the deleted project.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectOutput");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("project_arn", &self.project_arn);
        formatter.finish()
    }
}
/// See [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
pub mod delete_project_output {
    /// A builder for [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) project_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the primary stack in AWS CloudFormation that will be deleted as part of
        /// deleting the project and its resources.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the primary stack in AWS CloudFormation that will be deleted as part of
        /// deleting the project and its resources.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
        pub fn build(self) -> crate::output::DeleteProjectOutput {
            crate::output::DeleteProjectOutput {
                stack_id: self.stack_id,
                project_arn: self.project_arn,
            }
        }
    }
}
impl DeleteProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    pub fn builder() -> crate::output::delete_project_output::Builder {
        crate::output::delete_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
    /// public/private keypair the user can use to access project resources if a project owner allows
    /// the user remote access to those resources.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>The date the user profile was created, in timestamp format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date the user profile was last modified, in timestamp format.</p>
    pub last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateUserProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
    /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
    /// public/private keypair the user can use to access project resources if a project owner allows
    /// the user remote access to those resources.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>The date the user profile was created, in timestamp format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The date the user profile was last modified, in timestamp format.</p>
    pub fn last_modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_timestamp.as_ref()
    }
}
impl std::fmt::Debug for CreateUserProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserProfileOutput");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_modified_timestamp", &self.last_modified_timestamp);
        formatter.finish()
    }
}
/// See [`CreateUserProfileOutput`](crate::output::CreateUserProfileOutput)
pub mod create_user_profile_output {
    /// A builder for [`CreateUserProfileOutput`](crate::output::CreateUserProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user in IAM.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name that is displayed as the friendly name for the user in AWS CodeStar.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address that is displayed as part of the user's profile in AWS CodeStar.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
        /// public/private keypair the user can use to access project resources if a project owner allows
        /// the user remote access to those resources.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
        /// public/private keypair the user can use to access project resources if a project owner allows
        /// the user remote access to those resources.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>The date the user profile was created, in timestamp format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The date the user profile was created, in timestamp format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The date the user profile was last modified, in timestamp format.</p>
        pub fn last_modified_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_timestamp = Some(input);
            self
        }
        /// <p>The date the user profile was last modified, in timestamp format.</p>
        pub fn set_last_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserProfileOutput`](crate::output::CreateUserProfileOutput)
        pub fn build(self) -> crate::output::CreateUserProfileOutput {
            crate::output::CreateUserProfileOutput {
                user_arn: self.user_arn,
                display_name: self.display_name,
                email_address: self.email_address,
                ssh_public_key: self.ssh_public_key,
                created_timestamp: self.created_timestamp,
                last_modified_timestamp: self.last_modified_timestamp,
            }
        }
    }
}
impl CreateUserProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserProfileOutput`](crate::output::CreateUserProfileOutput)
    pub fn builder() -> crate::output::create_user_profile_output::Builder {
        crate::output::create_user_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectOutput {
    /// <p>The ID of the project.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the created project.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A user- or system-generated token that identifies the entity that requested project
    /// creation.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub project_template_id: std::option::Option<std::string::String>,
}
impl CreateProjectOutput {
    /// <p>The ID of the project.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the created project.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A user- or system-generated token that identifies the entity that requested project
    /// creation.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn project_template_id(&self) -> std::option::Option<&str> {
        self.project_template_id.as_deref()
    }
}
impl std::fmt::Debug for CreateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectOutput");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("project_template_id", &self.project_template_id);
        formatter.finish()
    }
}
/// See [`CreateProjectOutput`](crate::output::CreateProjectOutput)
pub mod create_project_output {
    /// A builder for [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) project_template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created project.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// creation.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A user- or system-generated token that identifies the entity that requested project
        /// creation.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn project_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_template_id = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_project_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectOutput`](crate::output::CreateProjectOutput)
        pub fn build(self) -> crate::output::CreateProjectOutput {
            crate::output::CreateProjectOutput {
                id: self.id,
                arn: self.arn,
                client_request_token: self.client_request_token,
                project_template_id: self.project_template_id,
            }
        }
    }
}
impl CreateProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    pub fn builder() -> crate::output::create_project_output::Builder {
        crate::output::create_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTeamMemberOutput {
    /// <p>The user- or system-generated token from the initial request that can be used to repeat
    /// the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl AssociateTeamMemberOutput {
    /// <p>The user- or system-generated token from the initial request that can be used to repeat
    /// the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateTeamMemberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTeamMemberOutput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}
/// See [`AssociateTeamMemberOutput`](crate::output::AssociateTeamMemberOutput)
pub mod associate_team_member_output {
    /// A builder for [`AssociateTeamMemberOutput`](crate::output::AssociateTeamMemberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user- or system-generated token from the initial request that can be used to repeat
        /// the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The user- or system-generated token from the initial request that can be used to repeat
        /// the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTeamMemberOutput`](crate::output::AssociateTeamMemberOutput)
        pub fn build(self) -> crate::output::AssociateTeamMemberOutput {
            crate::output::AssociateTeamMemberOutput {
                client_request_token: self.client_request_token,
            }
        }
    }
}
impl AssociateTeamMemberOutput {
    /// Creates a new builder-style object to manufacture [`AssociateTeamMemberOutput`](crate::output::AssociateTeamMemberOutput)
    pub fn builder() -> crate::output::associate_team_member_output::Builder {
        crate::output::associate_team_member_output::Builder::default()
    }
}
