// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_acknowledge_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AcknowledgeJobOutput, crate::error::AcknowledgeJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcknowledgeJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AcknowledgeJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNonceException" => crate::error::AcknowledgeJobError {
            meta: generic,
            kind: crate::error::AcknowledgeJobErrorKind::InvalidNonceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_nonce_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_nonce_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcknowledgeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::AcknowledgeJobError {
            meta: generic,
            kind: crate::error::AcknowledgeJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcknowledgeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AcknowledgeJobError {
            meta: generic,
            kind: crate::error::AcknowledgeJobErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcknowledgeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AcknowledgeJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_acknowledge_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AcknowledgeJobOutput, crate::error::AcknowledgeJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::acknowledge_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_acknowledge_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AcknowledgeJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_acknowledge_third_party_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcknowledgeThirdPartyJobOutput,
    crate::error::AcknowledgeThirdPartyJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcknowledgeThirdPartyJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AcknowledgeThirdPartyJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidClientTokenException" => crate::error::AcknowledgeThirdPartyJobError {
            meta: generic,
            kind: crate::error::AcknowledgeThirdPartyJobErrorKind::InvalidClientTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_client_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_client_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcknowledgeThirdPartyJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNonceException" => crate::error::AcknowledgeThirdPartyJobError {
            meta: generic,
            kind: crate::error::AcknowledgeThirdPartyJobErrorKind::InvalidNonceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_nonce_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_nonce_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcknowledgeThirdPartyJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::AcknowledgeThirdPartyJobError {
            meta: generic,
            kind: crate::error::AcknowledgeThirdPartyJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcknowledgeThirdPartyJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AcknowledgeThirdPartyJobError {
            meta: generic,
            kind: crate::error::AcknowledgeThirdPartyJobErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcknowledgeThirdPartyJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AcknowledgeThirdPartyJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_acknowledge_third_party_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcknowledgeThirdPartyJobOutput,
    crate::error::AcknowledgeThirdPartyJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::acknowledge_third_party_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_acknowledge_third_party_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AcknowledgeThirdPartyJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_action_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomActionTypeOutput,
    crate::error::CreateCustomActionTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomActionTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCustomActionTypeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::CreateCustomActionTypeError {
            meta: generic,
            kind: crate::error::CreateCustomActionTypeErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagsException" => crate::error::CreateCustomActionTypeError {
            meta: generic,
            kind: crate::error::CreateCustomActionTypeErrorKind::InvalidTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateCustomActionTypeError {
            meta: generic,
            kind: crate::error::CreateCustomActionTypeErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreateCustomActionTypeError {
            meta: generic,
            kind: crate::error::CreateCustomActionTypeErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateCustomActionTypeError {
            meta: generic,
            kind: crate::error::CreateCustomActionTypeErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCustomActionTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_action_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomActionTypeOutput,
    crate::error::CreateCustomActionTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_custom_action_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_custom_action_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCustomActionTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidActionDeclarationException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::InvalidActionDeclarationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_action_declaration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_action_declaration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidBlockerDeclarationException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::InvalidBlockerDeclarationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_blocker_declaration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_blocker_declaration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStageDeclarationException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::InvalidStageDeclarationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_stage_declaration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_stage_declaration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStructureException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::InvalidStructureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_structure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_structure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagsException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::InvalidTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNameInUseException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::PipelineNameInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::pipeline_name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePipelineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_action_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomActionTypeOutput,
    crate::error::DeleteCustomActionTypeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomActionTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCustomActionTypeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteCustomActionTypeError {
            meta: generic,
            kind: crate::error::DeleteCustomActionTypeErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteCustomActionTypeError {
            meta: generic,
            kind: crate::error::DeleteCustomActionTypeErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCustomActionTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_action_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomActionTypeOutput,
    crate::error::DeleteCustomActionTypeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_custom_action_type_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeletePipelineError {
            meta: generic,
            kind: crate::error::DeletePipelineErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeletePipelineError {
            meta: generic,
            kind: crate::error::DeletePipelineErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_pipeline_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_webhook_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWebhookOutput, crate::error::DeleteWebhookError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWebhookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWebhookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::DeleteWebhookError {
            meta: generic,
            kind: crate::error::DeleteWebhookErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteWebhookError {
            meta: generic,
            kind: crate::error::DeleteWebhookErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteWebhookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_webhook_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWebhookOutput, crate::error::DeleteWebhookError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_webhook_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_webhook_with_third_party_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterWebhookWithThirdPartyOutput,
    crate::error::DeregisterWebhookWithThirdPartyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterWebhookWithThirdPartyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeregisterWebhookWithThirdPartyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ValidationException" => crate::error::DeregisterWebhookWithThirdPartyError {
            meta: generic,
            kind: crate::error::DeregisterWebhookWithThirdPartyErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterWebhookWithThirdPartyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WebhookNotFoundException" => crate::error::DeregisterWebhookWithThirdPartyError {
            meta: generic,
            kind: crate::error::DeregisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::webhook_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_webhook_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterWebhookWithThirdPartyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeregisterWebhookWithThirdPartyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_webhook_with_third_party_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterWebhookWithThirdPartyOutput,
    crate::error::DeregisterWebhookWithThirdPartyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::deregister_webhook_with_third_party_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_stage_transition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableStageTransitionOutput,
    crate::error::DisableStageTransitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableStageTransitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisableStageTransitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "PipelineNotFoundException" => crate::error::DisableStageTransitionError {
            meta: generic,
            kind: crate::error::DisableStageTransitionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableStageTransitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StageNotFoundException" => crate::error::DisableStageTransitionError {
            meta: generic,
            kind: crate::error::DisableStageTransitionErrorKind::StageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stage_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_stage_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableStageTransitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisableStageTransitionError {
            meta: generic,
            kind: crate::error::DisableStageTransitionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableStageTransitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableStageTransitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_stage_transition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableStageTransitionOutput,
    crate::error::DisableStageTransitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_stage_transition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_stage_transition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableStageTransitionOutput,
    crate::error::EnableStageTransitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableStageTransitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableStageTransitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "PipelineNotFoundException" => crate::error::EnableStageTransitionError {
            meta: generic,
            kind: crate::error::EnableStageTransitionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableStageTransitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StageNotFoundException" => crate::error::EnableStageTransitionError {
            meta: generic,
            kind: crate::error::EnableStageTransitionErrorKind::StageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stage_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_stage_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableStageTransitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::EnableStageTransitionError {
            meta: generic,
            kind: crate::error::EnableStageTransitionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableStageTransitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableStageTransitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_stage_transition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableStageTransitionOutput,
    crate::error::EnableStageTransitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_stage_transition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_action_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetActionTypeOutput, crate::error::GetActionTypeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetActionTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetActionTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActionTypeNotFoundException" => crate::error::GetActionTypeError {
            meta: generic,
            kind: crate::error::GetActionTypeErrorKind::ActionTypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::action_type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_action_type_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetActionTypeError {
            meta: generic,
            kind: crate::error::GetActionTypeErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetActionTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_action_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetActionTypeOutput, crate::error::GetActionTypeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_action_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_action_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetActionTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobDetailsOutput, crate::error::GetJobDetailsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetJobDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetJobDetailsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "JobNotFoundException" => crate::error::GetJobDetailsError {
            meta: generic,
            kind: crate::error::GetJobDetailsErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetJobDetailsError {
            meta: generic,
            kind: crate::error::GetJobDetailsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetJobDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobDetailsOutput, crate::error::GetJobDetailsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_job_details_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_job_details(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetJobDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPipelineOutput, crate::error::GetPipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "PipelineNotFoundException" => crate::error::GetPipelineError {
            meta: generic,
            kind: crate::error::GetPipelineErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineVersionNotFoundException" => crate::error::GetPipelineError {
            meta: generic,
            kind: crate::error::GetPipelineErrorKind::PipelineVersionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::pipeline_version_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_version_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetPipelineError {
            meta: generic,
            kind: crate::error::GetPipelineErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPipelineOutput, crate::error::GetPipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPipelineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPipelineExecutionOutput,
    crate::error::GetPipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPipelineExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "PipelineExecutionNotFoundException" => {
            crate::error::GetPipelineExecutionError {
                meta: generic,
                kind:
                    crate::error::GetPipelineExecutionErrorKind::PipelineExecutionNotFoundException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::pipeline_execution_not_found_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_pipeline_execution_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineExecutionError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "PipelineNotFoundException" => crate::error::GetPipelineExecutionError {
            meta: generic,
            kind: crate::error::GetPipelineExecutionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetPipelineExecutionError {
            meta: generic,
            kind: crate::error::GetPipelineExecutionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPipelineExecutionOutput,
    crate::error::GetPipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_state_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPipelineStateOutput, crate::error::GetPipelineStateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPipelineStateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPipelineStateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "PipelineNotFoundException" => crate::error::GetPipelineStateError {
            meta: generic,
            kind: crate::error::GetPipelineStateErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetPipelineStateError {
            meta: generic,
            kind: crate::error::GetPipelineStateErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPipelineStateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_state_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPipelineStateOutput, crate::error::GetPipelineStateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_pipeline_state_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_pipeline_state(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPipelineStateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_third_party_job_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetThirdPartyJobDetailsOutput,
    crate::error::GetThirdPartyJobDetailsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetThirdPartyJobDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetThirdPartyJobDetailsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidClientTokenException" => crate::error::GetThirdPartyJobDetailsError {
            meta: generic,
            kind: crate::error::GetThirdPartyJobDetailsErrorKind::InvalidClientTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_client_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_client_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetThirdPartyJobDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidJobException" => crate::error::GetThirdPartyJobDetailsError {
            meta: generic,
            kind: crate::error::GetThirdPartyJobDetailsErrorKind::InvalidJobException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetThirdPartyJobDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::GetThirdPartyJobDetailsError {
            meta: generic,
            kind: crate::error::GetThirdPartyJobDetailsErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetThirdPartyJobDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetThirdPartyJobDetailsError {
            meta: generic,
            kind: crate::error::GetThirdPartyJobDetailsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetThirdPartyJobDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetThirdPartyJobDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_third_party_job_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetThirdPartyJobDetailsOutput,
    crate::error::GetThirdPartyJobDetailsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_third_party_job_details_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_third_party_job_details(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetThirdPartyJobDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_action_executions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListActionExecutionsOutput,
    crate::error::ListActionExecutionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListActionExecutionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListActionExecutionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListActionExecutionsError {
            meta: generic,
            kind: crate::error::ListActionExecutionsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActionExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineExecutionNotFoundException" => {
            crate::error::ListActionExecutionsError {
                meta: generic,
                kind:
                    crate::error::ListActionExecutionsErrorKind::PipelineExecutionNotFoundException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::pipeline_execution_not_found_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_pipeline_execution_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActionExecutionsError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "PipelineNotFoundException" => crate::error::ListActionExecutionsError {
            meta: generic,
            kind: crate::error::ListActionExecutionsErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActionExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListActionExecutionsError {
            meta: generic,
            kind: crate::error::ListActionExecutionsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActionExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListActionExecutionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_action_executions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListActionExecutionsOutput,
    crate::error::ListActionExecutionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_action_executions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_action_executions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListActionExecutionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_action_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListActionTypesOutput, crate::error::ListActionTypesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListActionTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListActionTypesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListActionTypesError {
            meta: generic,
            kind: crate::error::ListActionTypesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActionTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListActionTypesError {
            meta: generic,
            kind: crate::error::ListActionTypesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActionTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListActionTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_action_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListActionTypesOutput, crate::error::ListActionTypesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_action_types_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_action_types(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListActionTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_executions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineExecutionsOutput,
    crate::error::ListPipelineExecutionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPipelineExecutionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListPipelineExecutionsError {
            meta: generic,
            kind: crate::error::ListPipelineExecutionsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::ListPipelineExecutionsError {
            meta: generic,
            kind: crate::error::ListPipelineExecutionsErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListPipelineExecutionsError {
            meta: generic,
            kind: crate::error::ListPipelineExecutionsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPipelineExecutionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_executions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineExecutionsOutput,
    crate::error::ListPipelineExecutionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pipeline_executions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pipeline_executions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipelines_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPipelinesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPipelinesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListPipelinesError {
            meta: generic,
            kind: crate::error::ListPipelinesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListPipelinesError {
            meta: generic,
            kind: crate::error::ListPipelinesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPipelinesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipelines_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pipelines_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pipelines(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPipelinesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArnException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_webhooks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWebhooksOutput, crate::error::ListWebhooksError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListWebhooksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListWebhooksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListWebhooksError {
            meta: generic,
            kind: crate::error::ListWebhooksErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListWebhooksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListWebhooksError {
            meta: generic,
            kind: crate::error::ListWebhooksErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListWebhooksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListWebhooksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_webhooks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWebhooksOutput, crate::error::ListWebhooksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_webhooks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_webhooks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListWebhooksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_poll_for_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PollForJobsOutput, crate::error::PollForJobsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PollForJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PollForJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActionTypeNotFoundException" => crate::error::PollForJobsError {
            meta: generic,
            kind: crate::error::PollForJobsErrorKind::ActionTypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::action_type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_action_type_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PollForJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PollForJobsError {
            meta: generic,
            kind: crate::error::PollForJobsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PollForJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PollForJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_poll_for_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PollForJobsOutput, crate::error::PollForJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::poll_for_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_poll_for_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PollForJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_poll_for_third_party_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PollForThirdPartyJobsOutput,
    crate::error::PollForThirdPartyJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PollForThirdPartyJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PollForThirdPartyJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActionTypeNotFoundException" => crate::error::PollForThirdPartyJobsError {
            meta: generic,
            kind: crate::error::PollForThirdPartyJobsErrorKind::ActionTypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::action_type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_action_type_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PollForThirdPartyJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PollForThirdPartyJobsError {
            meta: generic,
            kind: crate::error::PollForThirdPartyJobsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PollForThirdPartyJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PollForThirdPartyJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_poll_for_third_party_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PollForThirdPartyJobsOutput,
    crate::error::PollForThirdPartyJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::poll_for_third_party_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_poll_for_third_party_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PollForThirdPartyJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_action_revision_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutActionRevisionOutput, crate::error::PutActionRevisionError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutActionRevisionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutActionRevisionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActionNotFoundException" => crate::error::PutActionRevisionError {
            meta: generic,
            kind: crate::error::PutActionRevisionErrorKind::ActionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::action_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_action_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutActionRevisionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::PutActionRevisionError {
            meta: generic,
            kind: crate::error::PutActionRevisionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutActionRevisionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StageNotFoundException" => crate::error::PutActionRevisionError {
            meta: generic,
            kind: crate::error::PutActionRevisionErrorKind::StageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stage_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_stage_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutActionRevisionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutActionRevisionError {
            meta: generic,
            kind: crate::error::PutActionRevisionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutActionRevisionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutActionRevisionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_action_revision_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutActionRevisionOutput, crate::error::PutActionRevisionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_action_revision_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_action_revision(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutActionRevisionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_approval_result_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutApprovalResultOutput, crate::error::PutApprovalResultError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutApprovalResultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutApprovalResultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActionNotFoundException" => crate::error::PutApprovalResultError {
            meta: generic,
            kind: crate::error::PutApprovalResultErrorKind::ActionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::action_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_action_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutApprovalResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ApprovalAlreadyCompletedException" => crate::error::PutApprovalResultError {
            meta: generic,
            kind: crate::error::PutApprovalResultErrorKind::ApprovalAlreadyCompletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::approval_already_completed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_approval_already_completed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutApprovalResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidApprovalTokenException" => crate::error::PutApprovalResultError {
            meta: generic,
            kind: crate::error::PutApprovalResultErrorKind::InvalidApprovalTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_approval_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_approval_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutApprovalResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::PutApprovalResultError {
            meta: generic,
            kind: crate::error::PutApprovalResultErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutApprovalResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StageNotFoundException" => crate::error::PutApprovalResultError {
            meta: generic,
            kind: crate::error::PutApprovalResultErrorKind::StageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stage_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_stage_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutApprovalResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutApprovalResultError {
            meta: generic,
            kind: crate::error::PutApprovalResultErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutApprovalResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutApprovalResultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_approval_result_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutApprovalResultOutput, crate::error::PutApprovalResultError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_approval_result_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_approval_result(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutApprovalResultError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_job_failure_result_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutJobFailureResultOutput,
    crate::error::PutJobFailureResultError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutJobFailureResultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutJobFailureResultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::PutJobFailureResultError {
            meta: generic,
            kind: crate::error::PutJobFailureResultErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutJobFailureResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::PutJobFailureResultError {
            meta: generic,
            kind: crate::error::PutJobFailureResultErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutJobFailureResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutJobFailureResultError {
            meta: generic,
            kind: crate::error::PutJobFailureResultErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutJobFailureResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutJobFailureResultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_job_failure_result_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutJobFailureResultOutput,
    crate::error::PutJobFailureResultError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_job_failure_result_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_job_success_result_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutJobSuccessResultOutput,
    crate::error::PutJobSuccessResultError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutJobSuccessResultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutJobSuccessResultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::PutJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutJobSuccessResultErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutJobSuccessResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::PutJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutJobSuccessResultErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutJobSuccessResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OutputVariablesSizeExceededException" => crate::error::PutJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutJobSuccessResultErrorKind::OutputVariablesSizeExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::output_variables_size_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_output_variables_size_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutJobSuccessResultError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ValidationException" => crate::error::PutJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutJobSuccessResultErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutJobSuccessResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutJobSuccessResultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_job_success_result_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutJobSuccessResultOutput,
    crate::error::PutJobSuccessResultError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_job_success_result_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_third_party_job_failure_result_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutThirdPartyJobFailureResultOutput,
    crate::error::PutThirdPartyJobFailureResultError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutThirdPartyJobFailureResultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutThirdPartyJobFailureResultError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidClientTokenException" => crate::error::PutThirdPartyJobFailureResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobFailureResultErrorKind::InvalidClientTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_client_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_client_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobFailureResultError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidJobStateException" => crate::error::PutThirdPartyJobFailureResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobFailureResultErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobFailureResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::PutThirdPartyJobFailureResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobFailureResultErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobFailureResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutThirdPartyJobFailureResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobFailureResultErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobFailureResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutThirdPartyJobFailureResultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_third_party_job_failure_result_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutThirdPartyJobFailureResultOutput,
    crate::error::PutThirdPartyJobFailureResultError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_third_party_job_failure_result_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_third_party_job_success_result_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutThirdPartyJobSuccessResultOutput,
    crate::error::PutThirdPartyJobSuccessResultError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutThirdPartyJobSuccessResultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutThirdPartyJobSuccessResultError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidClientTokenException" => crate::error::PutThirdPartyJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobSuccessResultErrorKind::InvalidClientTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_client_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_client_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobSuccessResultError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidJobStateException" => crate::error::PutThirdPartyJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobSuccessResultErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobSuccessResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::PutThirdPartyJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobSuccessResultErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobSuccessResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutThirdPartyJobSuccessResultError {
            meta: generic,
            kind: crate::error::PutThirdPartyJobSuccessResultErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutThirdPartyJobSuccessResultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutThirdPartyJobSuccessResultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_third_party_job_success_result_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutThirdPartyJobSuccessResultOutput,
    crate::error::PutThirdPartyJobSuccessResultError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_third_party_job_success_result_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_webhook_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutWebhookOutput, crate::error::PutWebhookError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutWebhookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutWebhookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::PutWebhookError {
            meta: generic,
            kind: crate::error::PutWebhookErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagsException" => crate::error::PutWebhookError {
            meta: generic,
            kind: crate::error::PutWebhookErrorKind::InvalidTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidWebhookAuthenticationParametersException" => crate::error::PutWebhookError {
            meta: generic,
            kind:
                crate::error::PutWebhookErrorKind::InvalidWebhookAuthenticationParametersException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_webhook_authentication_parameters_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_webhook_authentication_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidWebhookFilterPatternException" => {
            crate::error::PutWebhookError {
                meta: generic,
                kind: crate::error::PutWebhookErrorKind::InvalidWebhookFilterPatternException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_webhook_filter_pattern_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_webhook_filter_pattern_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceededException" => crate::error::PutWebhookError {
            meta: generic,
            kind: crate::error::PutWebhookErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::PutWebhookError {
            meta: generic,
            kind: crate::error::PutWebhookErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::PutWebhookError {
            meta: generic,
            kind: crate::error::PutWebhookErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutWebhookError {
            meta: generic,
            kind: crate::error::PutWebhookErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutWebhookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutWebhookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_webhook_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutWebhookOutput, crate::error::PutWebhookError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_webhook_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_webhook(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutWebhookError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_webhook_with_third_party_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterWebhookWithThirdPartyOutput,
    crate::error::RegisterWebhookWithThirdPartyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterWebhookWithThirdPartyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RegisterWebhookWithThirdPartyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ValidationException" => crate::error::RegisterWebhookWithThirdPartyError {
            meta: generic,
            kind: crate::error::RegisterWebhookWithThirdPartyErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWebhookWithThirdPartyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WebhookNotFoundException" => crate::error::RegisterWebhookWithThirdPartyError {
            meta: generic,
            kind: crate::error::RegisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::webhook_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_webhook_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWebhookWithThirdPartyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterWebhookWithThirdPartyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_webhook_with_third_party_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterWebhookWithThirdPartyOutput,
    crate::error::RegisterWebhookWithThirdPartyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::register_webhook_with_third_party_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retry_stage_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetryStageExecutionOutput,
    crate::error::RetryStageExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RetryStageExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RetryStageExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::RetryStageExecutionError {
                meta: generic,
                kind: crate::error::RetryStageExecutionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetryStageExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotLatestPipelineExecutionException" => {
            crate::error::RetryStageExecutionError {
                meta: generic,
                kind:
                    crate::error::RetryStageExecutionErrorKind::NotLatestPipelineExecutionException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::not_latest_pipeline_execution_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_not_latest_pipeline_execution_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetryStageExecutionError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "PipelineNotFoundException" => crate::error::RetryStageExecutionError {
            meta: generic,
            kind: crate::error::RetryStageExecutionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetryStageExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StageNotFoundException" => crate::error::RetryStageExecutionError {
            meta: generic,
            kind: crate::error::RetryStageExecutionErrorKind::StageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::stage_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_stage_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetryStageExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StageNotRetryableException" => crate::error::RetryStageExecutionError {
            meta: generic,
            kind: crate::error::RetryStageExecutionErrorKind::StageNotRetryableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::stage_not_retryable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_stage_not_retryable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetryStageExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::RetryStageExecutionError {
            meta: generic,
            kind: crate::error::RetryStageExecutionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetryStageExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RetryStageExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retry_stage_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetryStageExecutionOutput,
    crate::error::RetryStageExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::retry_stage_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_retry_stage_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RetryStageExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartPipelineExecutionOutput,
    crate::error::StartPipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartPipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartPipelineExecutionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::StartPipelineExecutionError {
                meta: generic,
                kind: crate::error::StartPipelineExecutionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PipelineNotFoundException" => crate::error::StartPipelineExecutionError {
            meta: generic,
            kind: crate::error::StartPipelineExecutionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::StartPipelineExecutionError {
            meta: generic,
            kind: crate::error::StartPipelineExecutionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartPipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartPipelineExecutionOutput,
    crate::error::StartPipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartPipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopPipelineExecutionOutput,
    crate::error::StopPipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopPipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopPipelineExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::StopPipelineExecutionError {
                meta: generic,
                kind: crate::error::StopPipelineExecutionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DuplicatedStopRequestException" => crate::error::StopPipelineExecutionError {
            meta: generic,
            kind: crate::error::StopPipelineExecutionErrorKind::DuplicatedStopRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::duplicated_stop_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicated_stop_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineExecutionNotStoppableException" => crate::error::StopPipelineExecutionError {
            meta: generic,
            kind:
                crate::error::StopPipelineExecutionErrorKind::PipelineExecutionNotStoppableException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::pipeline_execution_not_stoppable_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_pipeline_execution_not_stoppable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPipelineExecutionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "PipelineNotFoundException" => crate::error::StopPipelineExecutionError {
            meta: generic,
            kind: crate::error::StopPipelineExecutionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::StopPipelineExecutionError {
            meta: generic,
            kind: crate::error::StopPipelineExecutionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopPipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopPipelineExecutionOutput,
    crate::error::StopPipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopPipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagsException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_action_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateActionTypeOutput, crate::error::UpdateActionTypeError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateActionTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateActionTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActionTypeNotFoundException" => crate::error::UpdateActionTypeError {
            meta: generic,
            kind: crate::error::UpdateActionTypeErrorKind::ActionTypeNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::action_type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_action_type_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestFailedException" => crate::error::UpdateActionTypeError {
            meta: generic,
            kind: crate::error::UpdateActionTypeErrorKind::RequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateActionTypeError {
            meta: generic,
            kind: crate::error::UpdateActionTypeErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateActionTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateActionTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_action_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateActionTypeOutput, crate::error::UpdateActionTypeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_action_type_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidActionDeclarationException" => crate::error::UpdatePipelineError {
            meta: generic,
            kind: crate::error::UpdatePipelineErrorKind::InvalidActionDeclarationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_action_declaration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_action_declaration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidBlockerDeclarationException" => crate::error::UpdatePipelineError {
            meta: generic,
            kind: crate::error::UpdatePipelineErrorKind::InvalidBlockerDeclarationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_blocker_declaration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_blocker_declaration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStageDeclarationException" => crate::error::UpdatePipelineError {
            meta: generic,
            kind: crate::error::UpdatePipelineErrorKind::InvalidStageDeclarationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_stage_declaration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_stage_declaration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStructureException" => crate::error::UpdatePipelineError {
            meta: generic,
            kind: crate::error::UpdatePipelineErrorKind::InvalidStructureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_structure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_structure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdatePipelineError {
            meta: generic,
            kind: crate::error::UpdatePipelineErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdatePipelineError {
            meta: generic,
            kind: crate::error::UpdatePipelineErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePipelineError::unhandled)?;
        output.build()
    })
}
