// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the structure of actions and stages to be performed in the pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineDeclaration {
    /// <p>The name of the pipeline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
    /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
    /// </note>
    pub artifact_store: std::option::Option<crate::model::ArtifactStore>,
    /// <p>A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.</p> <note>
    /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
    /// </note>
    pub artifact_stores: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ArtifactStore>,
    >,
    /// <p>The stage in which to perform the action.</p>
    pub stages: std::option::Option<std::vec::Vec<crate::model::StageDeclaration>>,
    /// <p>The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented when a pipeline is updated.</p>
    pub version: std::option::Option<i32>,
}
impl PipelineDeclaration {
    /// <p>The name of the pipeline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
    /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
    /// </note>
    pub fn artifact_store(&self) -> std::option::Option<&crate::model::ArtifactStore> {
        self.artifact_store.as_ref()
    }
    /// <p>A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.</p> <note>
    /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
    /// </note>
    pub fn artifact_stores(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ArtifactStore>,
    > {
        self.artifact_stores.as_ref()
    }
    /// <p>The stage in which to perform the action.</p>
    pub fn stages(&self) -> std::option::Option<&[crate::model::StageDeclaration]> {
        self.stages.as_deref()
    }
    /// <p>The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented when a pipeline is updated.</p>
    pub fn version(&self) -> std::option::Option<i32> {
        self.version
    }
}
impl std::fmt::Debug for PipelineDeclaration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineDeclaration");
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("artifact_store", &self.artifact_store);
        formatter.field("artifact_stores", &self.artifact_stores);
        formatter.field("stages", &self.stages);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`PipelineDeclaration`](crate::model::PipelineDeclaration)
pub mod pipeline_declaration {
    /// A builder for [`PipelineDeclaration`](crate::model::PipelineDeclaration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) artifact_store: std::option::Option<crate::model::ArtifactStore>,
        pub(crate) artifact_stores: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ArtifactStore>,
        >,
        pub(crate) stages: std::option::Option<std::vec::Vec<crate::model::StageDeclaration>>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
        /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
        /// </note>
        pub fn artifact_store(mut self, input: crate::model::ArtifactStore) -> Self {
            self.artifact_store = Some(input);
            self
        }
        /// <p>Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
        /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
        /// </note>
        pub fn set_artifact_store(
            mut self,
            input: std::option::Option<crate::model::ArtifactStore>,
        ) -> Self {
            self.artifact_store = input;
            self
        }
        /// Adds a key-value pair to `artifact_stores`.
        ///
        /// To override the contents of this collection use [`set_artifact_stores`](Self::set_artifact_stores).
        ///
        /// <p>A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.</p> <note>
        /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
        /// </note>
        pub fn artifact_stores(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ArtifactStore,
        ) -> Self {
            let mut hash_map = self.artifact_stores.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.artifact_stores = Some(hash_map);
            self
        }
        /// <p>A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.</p> <note>
        /// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
        /// </note>
        pub fn set_artifact_stores(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ArtifactStore>,
            >,
        ) -> Self {
            self.artifact_stores = input;
            self
        }
        /// Appends an item to `stages`.
        ///
        /// To override the contents of this collection use [`set_stages`](Self::set_stages).
        ///
        /// <p>The stage in which to perform the action.</p>
        pub fn stages(mut self, input: crate::model::StageDeclaration) -> Self {
            let mut v = self.stages.unwrap_or_default();
            v.push(input);
            self.stages = Some(v);
            self
        }
        /// <p>The stage in which to perform the action.</p>
        pub fn set_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StageDeclaration>>,
        ) -> Self {
            self.stages = input;
            self
        }
        /// <p>The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented when a pipeline is updated.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented when a pipeline is updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineDeclaration`](crate::model::PipelineDeclaration)
        pub fn build(self) -> crate::model::PipelineDeclaration {
            crate::model::PipelineDeclaration {
                name: self.name,
                role_arn: self.role_arn,
                artifact_store: self.artifact_store,
                artifact_stores: self.artifact_stores,
                stages: self.stages,
                version: self.version,
            }
        }
    }
}
impl PipelineDeclaration {
    /// Creates a new builder-style object to manufacture [`PipelineDeclaration`](crate::model::PipelineDeclaration)
    pub fn builder() -> crate::model::pipeline_declaration::Builder {
        crate::model::pipeline_declaration::Builder::default()
    }
}

/// <p>Represents information about a stage and its definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageDeclaration {
    /// <p>The name of the stage.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub blockers: std::option::Option<std::vec::Vec<crate::model::BlockerDeclaration>>,
    /// <p>The actions included in a stage.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::ActionDeclaration>>,
}
impl StageDeclaration {
    /// <p>The name of the stage.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn blockers(&self) -> std::option::Option<&[crate::model::BlockerDeclaration]> {
        self.blockers.as_deref()
    }
    /// <p>The actions included in a stage.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::ActionDeclaration]> {
        self.actions.as_deref()
    }
}
impl std::fmt::Debug for StageDeclaration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageDeclaration");
        formatter.field("name", &self.name);
        formatter.field("blockers", &self.blockers);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`StageDeclaration`](crate::model::StageDeclaration)
pub mod stage_declaration {
    /// A builder for [`StageDeclaration`](crate::model::StageDeclaration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) blockers: std::option::Option<std::vec::Vec<crate::model::BlockerDeclaration>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::ActionDeclaration>>,
    }
    impl Builder {
        /// <p>The name of the stage.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `blockers`.
        ///
        /// To override the contents of this collection use [`set_blockers`](Self::set_blockers).
        ///
        /// <p>Reserved for future use.</p>
        pub fn blockers(mut self, input: crate::model::BlockerDeclaration) -> Self {
            let mut v = self.blockers.unwrap_or_default();
            v.push(input);
            self.blockers = Some(v);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_blockers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockerDeclaration>>,
        ) -> Self {
            self.blockers = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions included in a stage.</p>
        pub fn actions(mut self, input: crate::model::ActionDeclaration) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>The actions included in a stage.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionDeclaration>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`StageDeclaration`](crate::model::StageDeclaration)
        pub fn build(self) -> crate::model::StageDeclaration {
            crate::model::StageDeclaration {
                name: self.name,
                blockers: self.blockers,
                actions: self.actions,
            }
        }
    }
}
impl StageDeclaration {
    /// Creates a new builder-style object to manufacture [`StageDeclaration`](crate::model::StageDeclaration)
    pub fn builder() -> crate::model::stage_declaration::Builder {
        crate::model::stage_declaration::Builder::default()
    }
}

/// <p>Represents information about an action declaration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionDeclaration {
    /// <p>The action declaration's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the action type and the provider of the action.</p>
    pub action_type_id: std::option::Option<crate::model::ActionTypeId>,
    /// <p>The order in which actions are run.</p>
    pub run_order: std::option::Option<i32>,
    /// <p>The action's configuration. These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a>. For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <i>AWS CloudFormation User Guide</i>. For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <i>AWS CloudFormation User Guide</i>.</p>
    /// <p>The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows: </p>
    /// <p> <i>JSON:</i> </p>
    /// <p> <code>"Configuration" : { Key : Value },</code> </p>
    pub configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name or ID of the result of the action declaration, such as a test or build artifact.</p>
    pub output_artifacts: std::option::Option<std::vec::Vec<crate::model::OutputArtifact>>,
    /// <p>The name or ID of the artifact consumed by the action, such as a test or build artifact.</p>
    pub input_artifacts: std::option::Option<std::vec::Vec<crate::model::InputArtifact>>,
    /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The action declaration's AWS Region, such as us-east-1.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
    pub namespace: std::option::Option<std::string::String>,
}
impl ActionDeclaration {
    /// <p>The action declaration's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the action type and the provider of the action.</p>
    pub fn action_type_id(&self) -> std::option::Option<&crate::model::ActionTypeId> {
        self.action_type_id.as_ref()
    }
    /// <p>The order in which actions are run.</p>
    pub fn run_order(&self) -> std::option::Option<i32> {
        self.run_order
    }
    /// <p>The action's configuration. These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a>. For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <i>AWS CloudFormation User Guide</i>. For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <i>AWS CloudFormation User Guide</i>.</p>
    /// <p>The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows: </p>
    /// <p> <i>JSON:</i> </p>
    /// <p> <code>"Configuration" : { Key : Value },</code> </p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.configuration.as_ref()
    }
    /// <p>The name or ID of the result of the action declaration, such as a test or build artifact.</p>
    pub fn output_artifacts(&self) -> std::option::Option<&[crate::model::OutputArtifact]> {
        self.output_artifacts.as_deref()
    }
    /// <p>The name or ID of the artifact consumed by the action, such as a test or build artifact.</p>
    pub fn input_artifacts(&self) -> std::option::Option<&[crate::model::InputArtifact]> {
        self.input_artifacts.as_deref()
    }
    /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The action declaration's AWS Region, such as us-east-1.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
}
impl std::fmt::Debug for ActionDeclaration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionDeclaration");
        formatter.field("name", &self.name);
        formatter.field("action_type_id", &self.action_type_id);
        formatter.field("run_order", &self.run_order);
        formatter.field("configuration", &self.configuration);
        formatter.field("output_artifacts", &self.output_artifacts);
        formatter.field("input_artifacts", &self.input_artifacts);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("region", &self.region);
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`ActionDeclaration`](crate::model::ActionDeclaration)
pub mod action_declaration {
    /// A builder for [`ActionDeclaration`](crate::model::ActionDeclaration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) action_type_id: std::option::Option<crate::model::ActionTypeId>,
        pub(crate) run_order: std::option::Option<i32>,
        pub(crate) configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) output_artifacts:
            std::option::Option<std::vec::Vec<crate::model::OutputArtifact>>,
        pub(crate) input_artifacts: std::option::Option<std::vec::Vec<crate::model::InputArtifact>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action declaration's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The action declaration's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the action type and the provider of the action.</p>
        pub fn action_type_id(mut self, input: crate::model::ActionTypeId) -> Self {
            self.action_type_id = Some(input);
            self
        }
        /// <p>Specifies the action type and the provider of the action.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.action_type_id = input;
            self
        }
        /// <p>The order in which actions are run.</p>
        pub fn run_order(mut self, input: i32) -> Self {
            self.run_order = Some(input);
            self
        }
        /// <p>The order in which actions are run.</p>
        pub fn set_run_order(mut self, input: std::option::Option<i32>) -> Self {
            self.run_order = input;
            self
        }
        /// Adds a key-value pair to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>The action's configuration. These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a>. For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <i>AWS CloudFormation User Guide</i>. For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <i>AWS CloudFormation User Guide</i>.</p>
        /// <p>The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows: </p>
        /// <p> <i>JSON:</i> </p>
        /// <p> <code>"Configuration" : { Key : Value },</code> </p>
        pub fn configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.configuration = Some(hash_map);
            self
        }
        /// <p>The action's configuration. These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a>. For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <i>AWS CloudFormation User Guide</i>. For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <i>AWS CloudFormation User Guide</i>.</p>
        /// <p>The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows: </p>
        /// <p> <i>JSON:</i> </p>
        /// <p> <code>"Configuration" : { Key : Value },</code> </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Appends an item to `output_artifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>The name or ID of the result of the action declaration, such as a test or build artifact.</p>
        pub fn output_artifacts(mut self, input: crate::model::OutputArtifact) -> Self {
            let mut v = self.output_artifacts.unwrap_or_default();
            v.push(input);
            self.output_artifacts = Some(v);
            self
        }
        /// <p>The name or ID of the result of the action declaration, such as a test or build artifact.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputArtifact>>,
        ) -> Self {
            self.output_artifacts = input;
            self
        }
        /// Appends an item to `input_artifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>The name or ID of the artifact consumed by the action, such as a test or build artifact.</p>
        pub fn input_artifacts(mut self, input: crate::model::InputArtifact) -> Self {
            let mut v = self.input_artifacts.unwrap_or_default();
            v.push(input);
            self.input_artifacts = Some(v);
            self
        }
        /// <p>The name or ID of the artifact consumed by the action, such as a test or build artifact.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputArtifact>>,
        ) -> Self {
            self.input_artifacts = input;
            self
        }
        /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The action declaration's AWS Region, such as us-east-1.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The action declaration's AWS Region, such as us-east-1.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionDeclaration`](crate::model::ActionDeclaration)
        pub fn build(self) -> crate::model::ActionDeclaration {
            crate::model::ActionDeclaration {
                name: self.name,
                action_type_id: self.action_type_id,
                run_order: self.run_order,
                configuration: self.configuration,
                output_artifacts: self.output_artifacts,
                input_artifacts: self.input_artifacts,
                role_arn: self.role_arn,
                region: self.region,
                namespace: self.namespace,
            }
        }
    }
}
impl ActionDeclaration {
    /// Creates a new builder-style object to manufacture [`ActionDeclaration`](crate::model::ActionDeclaration)
    pub fn builder() -> crate::model::action_declaration::Builder {
        crate::model::action_declaration::Builder::default()
    }
}

/// <p>Represents information about an artifact to be worked on, such as a test or build artifact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputArtifact {
    /// <p>The name of the artifact to be worked on (for example, "My App").</p>
    /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
    pub name: std::option::Option<std::string::String>,
}
impl InputArtifact {
    /// <p>The name of the artifact to be worked on (for example, "My App").</p>
    /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for InputArtifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputArtifact");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`InputArtifact`](crate::model::InputArtifact)
pub mod input_artifact {
    /// A builder for [`InputArtifact`](crate::model::InputArtifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the artifact to be worked on (for example, "My App").</p>
        /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the artifact to be worked on (for example, "My App").</p>
        /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`InputArtifact`](crate::model::InputArtifact)
        pub fn build(self) -> crate::model::InputArtifact {
            crate::model::InputArtifact { name: self.name }
        }
    }
}
impl InputArtifact {
    /// Creates a new builder-style object to manufacture [`InputArtifact`](crate::model::InputArtifact)
    pub fn builder() -> crate::model::input_artifact::Builder {
        crate::model::input_artifact::Builder::default()
    }
}

/// <p>Represents information about the output of an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputArtifact {
    /// <p>The name of the output of an artifact, such as "My App".</p>
    /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
    /// <p>Output artifact names must be unique within a pipeline.</p>
    pub name: std::option::Option<std::string::String>,
}
impl OutputArtifact {
    /// <p>The name of the output of an artifact, such as "My App".</p>
    /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
    /// <p>Output artifact names must be unique within a pipeline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for OutputArtifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputArtifact");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`OutputArtifact`](crate::model::OutputArtifact)
pub mod output_artifact {
    /// A builder for [`OutputArtifact`](crate::model::OutputArtifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the output of an artifact, such as "My App".</p>
        /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
        /// <p>Output artifact names must be unique within a pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the output of an artifact, such as "My App".</p>
        /// <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>
        /// <p>Output artifact names must be unique within a pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputArtifact`](crate::model::OutputArtifact)
        pub fn build(self) -> crate::model::OutputArtifact {
            crate::model::OutputArtifact { name: self.name }
        }
    }
}
impl OutputArtifact {
    /// Creates a new builder-style object to manufacture [`OutputArtifact`](crate::model::OutputArtifact)
    pub fn builder() -> crate::model::output_artifact::Builder {
        crate::model::output_artifact::Builder::default()
    }
}

/// <p>Represents information about an action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeId {
    /// <p>A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the following values. </p>
    /// <ul>
    /// <li> <p>Source</p> </li>
    /// <li> <p>Build</p> </li>
    /// <li> <p>Test</p> </li>
    /// <li> <p>Deploy</p> </li>
    /// <li> <p>Invoke</p> </li>
    /// <li> <p>Approval</p> </li>
    /// </ul>
    pub category: std::option::Option<crate::model::ActionCategory>,
    /// <p>The creator of the action being called. There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and <code>Custom</code>. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
    pub owner: std::option::Option<crate::model::ActionOwner>,
    /// <p>The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>A string that describes the action version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl ActionTypeId {
    /// <p>A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the following values. </p>
    /// <ul>
    /// <li> <p>Source</p> </li>
    /// <li> <p>Build</p> </li>
    /// <li> <p>Test</p> </li>
    /// <li> <p>Deploy</p> </li>
    /// <li> <p>Invoke</p> </li>
    /// <li> <p>Approval</p> </li>
    /// </ul>
    pub fn category(&self) -> std::option::Option<&crate::model::ActionCategory> {
        self.category.as_ref()
    }
    /// <p>The creator of the action being called. There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and <code>Custom</code>. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::ActionOwner> {
        self.owner.as_ref()
    }
    /// <p>The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>A string that describes the action version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for ActionTypeId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeId");
        formatter.field("category", &self.category);
        formatter.field("owner", &self.owner);
        formatter.field("provider", &self.provider);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ActionTypeId`](crate::model::ActionTypeId)
pub mod action_type_id {
    /// A builder for [`ActionTypeId`](crate::model::ActionTypeId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::ActionCategory>,
        pub(crate) owner: std::option::Option<crate::model::ActionOwner>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the following values. </p>
        /// <ul>
        /// <li> <p>Source</p> </li>
        /// <li> <p>Build</p> </li>
        /// <li> <p>Test</p> </li>
        /// <li> <p>Deploy</p> </li>
        /// <li> <p>Invoke</p> </li>
        /// <li> <p>Approval</p> </li>
        /// </ul>
        pub fn category(mut self, input: crate::model::ActionCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the following values. </p>
        /// <ul>
        /// <li> <p>Source</p> </li>
        /// <li> <p>Build</p> </li>
        /// <li> <p>Test</p> </li>
        /// <li> <p>Deploy</p> </li>
        /// <li> <p>Invoke</p> </li>
        /// <li> <p>Approval</p> </li>
        /// </ul>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The creator of the action being called. There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and <code>Custom</code>. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
        pub fn owner(mut self, input: crate::model::ActionOwner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The creator of the action being called. There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and <code>Custom</code>. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::ActionOwner>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>A string that describes the action version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A string that describes the action version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeId`](crate::model::ActionTypeId)
        pub fn build(self) -> crate::model::ActionTypeId {
            crate::model::ActionTypeId {
                category: self.category,
                owner: self.owner,
                provider: self.provider,
                version: self.version,
            }
        }
    }
}
impl ActionTypeId {
    /// Creates a new builder-style object to manufacture [`ActionTypeId`](crate::model::ActionTypeId)
    pub fn builder() -> crate::model::action_type_id::Builder {
        crate::model::action_type_id::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionOwner {
    #[allow(missing_docs)] // documentation missing in model
    Aws,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    ThirdParty,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionOwner {
    fn from(s: &str) -> Self {
        match s {
            "AWS" => ActionOwner::Aws,
            "Custom" => ActionOwner::Custom,
            "ThirdParty" => ActionOwner::ThirdParty,
            other => ActionOwner::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionOwner {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionOwner::from(s))
    }
}
impl ActionOwner {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionOwner::Aws => "AWS",
            ActionOwner::Custom => "Custom",
            ActionOwner::ThirdParty => "ThirdParty",
            ActionOwner::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS", "Custom", "ThirdParty"]
    }
}
impl AsRef<str> for ActionOwner {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionCategory {
    #[allow(missing_docs)] // documentation missing in model
    Approval,
    #[allow(missing_docs)] // documentation missing in model
    Build,
    #[allow(missing_docs)] // documentation missing in model
    Deploy,
    #[allow(missing_docs)] // documentation missing in model
    Invoke,
    #[allow(missing_docs)] // documentation missing in model
    Source,
    #[allow(missing_docs)] // documentation missing in model
    Test,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionCategory {
    fn from(s: &str) -> Self {
        match s {
            "Approval" => ActionCategory::Approval,
            "Build" => ActionCategory::Build,
            "Deploy" => ActionCategory::Deploy,
            "Invoke" => ActionCategory::Invoke,
            "Source" => ActionCategory::Source,
            "Test" => ActionCategory::Test,
            other => ActionCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionCategory::from(s))
    }
}
impl ActionCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionCategory::Approval => "Approval",
            ActionCategory::Build => "Build",
            ActionCategory::Deploy => "Deploy",
            ActionCategory::Invoke => "Invoke",
            ActionCategory::Source => "Source",
            ActionCategory::Test => "Test",
            ActionCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Approval", "Build", "Deploy", "Invoke", "Source", "Test"]
    }
}
impl AsRef<str> for ActionCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Reserved for future use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockerDeclaration {
    /// <p>Reserved for future use.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub r#type: std::option::Option<crate::model::BlockerType>,
}
impl BlockerDeclaration {
    /// <p>Reserved for future use.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::BlockerType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for BlockerDeclaration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockerDeclaration");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`BlockerDeclaration`](crate::model::BlockerDeclaration)
pub mod blocker_declaration {
    /// A builder for [`BlockerDeclaration`](crate::model::BlockerDeclaration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::BlockerType>,
    }
    impl Builder {
        /// <p>Reserved for future use.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn r#type(mut self, input: crate::model::BlockerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::BlockerType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockerDeclaration`](crate::model::BlockerDeclaration)
        pub fn build(self) -> crate::model::BlockerDeclaration {
            crate::model::BlockerDeclaration {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl BlockerDeclaration {
    /// Creates a new builder-style object to manufacture [`BlockerDeclaration`](crate::model::BlockerDeclaration)
    pub fn builder() -> crate::model::blocker_declaration::Builder {
        crate::model::blocker_declaration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BlockerType {
    #[allow(missing_docs)] // documentation missing in model
    Schedule,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BlockerType {
    fn from(s: &str) -> Self {
        match s {
            "Schedule" => BlockerType::Schedule,
            other => BlockerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BlockerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BlockerType::from(s))
    }
}
impl BlockerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BlockerType::Schedule => "Schedule",
            BlockerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Schedule"]
    }
}
impl AsRef<str> for BlockerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The S3 bucket where artifacts for the pipeline are stored.</p> <note>
/// <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactStore {
    /// <p>The type of the artifact store, such as S3.</p>
    pub r#type: std::option::Option<crate::model::ArtifactStoreType>,
    /// <p>The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If this is undefined, the default key for Amazon S3 is used.</p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
}
impl ArtifactStore {
    /// <p>The type of the artifact store, such as S3.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ArtifactStoreType> {
        self.r#type.as_ref()
    }
    /// <p>The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If this is undefined, the default key for Amazon S3 is used.</p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
}
impl std::fmt::Debug for ArtifactStore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactStore");
        formatter.field("r#type", &self.r#type);
        formatter.field("location", &self.location);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.finish()
    }
}
/// See [`ArtifactStore`](crate::model::ArtifactStore)
pub mod artifact_store {
    /// A builder for [`ArtifactStore`](crate::model::ArtifactStore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ArtifactStoreType>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
    }
    impl Builder {
        /// <p>The type of the artifact store, such as S3.</p>
        pub fn r#type(mut self, input: crate::model::ArtifactStoreType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the artifact store, such as S3.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ArtifactStoreType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If this is undefined, the default key for Amazon S3 is used.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If this is undefined, the default key for Amazon S3 is used.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactStore`](crate::model::ArtifactStore)
        pub fn build(self) -> crate::model::ArtifactStore {
            crate::model::ArtifactStore {
                r#type: self.r#type,
                location: self.location,
                encryption_key: self.encryption_key,
            }
        }
    }
}
impl ArtifactStore {
    /// Creates a new builder-style object to manufacture [`ArtifactStore`](crate::model::ArtifactStore)
    pub fn builder() -> crate::model::artifact_store::Builder {
        crate::model::artifact_store::Builder::default()
    }
}

/// <p>Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionKey {
    /// <p>The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.</p> <note>
    /// <p>Aliases are recognized only in the account that created the customer master key (CMK). For cross-account actions, you can only use the key ID or key ARN to identify the key.</p>
    /// </note>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a pipeline, the value must be set to 'KMS'.</p>
    pub r#type: std::option::Option<crate::model::EncryptionKeyType>,
}
impl EncryptionKey {
    /// <p>The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.</p> <note>
    /// <p>Aliases are recognized only in the account that created the customer master key (CMK). For cross-account actions, you can only use the key ID or key ARN to identify the key.</p>
    /// </note>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a pipeline, the value must be set to 'KMS'.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EncryptionKeyType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for EncryptionKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionKey");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`EncryptionKey`](crate::model::EncryptionKey)
pub mod encryption_key {
    /// A builder for [`EncryptionKey`](crate::model::EncryptionKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::EncryptionKeyType>,
    }
    impl Builder {
        /// <p>The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.</p> <note>
        /// <p>Aliases are recognized only in the account that created the customer master key (CMK). For cross-account actions, you can only use the key ID or key ARN to identify the key.</p>
        /// </note>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.</p> <note>
        /// <p>Aliases are recognized only in the account that created the customer master key (CMK). For cross-account actions, you can only use the key ID or key ARN to identify the key.</p>
        /// </note>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a pipeline, the value must be set to 'KMS'.</p>
        pub fn r#type(mut self, input: crate::model::EncryptionKeyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a pipeline, the value must be set to 'KMS'.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionKeyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionKey`](crate::model::EncryptionKey)
        pub fn build(self) -> crate::model::EncryptionKey {
            crate::model::EncryptionKey {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl EncryptionKey {
    /// Creates a new builder-style object to manufacture [`EncryptionKey`](crate::model::EncryptionKey)
    pub fn builder() -> crate::model::encryption_key::Builder {
        crate::model::encryption_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionKeyType {
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionKeyType {
    fn from(s: &str) -> Self {
        match s {
            "KMS" => EncryptionKeyType::Kms,
            other => EncryptionKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionKeyType::from(s))
    }
}
impl EncryptionKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionKeyType::Kms => "KMS",
            EncryptionKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KMS"]
    }
}
impl AsRef<str> for EncryptionKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactStoreType {
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactStoreType {
    fn from(s: &str) -> Self {
        match s {
            "S3" => ArtifactStoreType::S3,
            other => ArtifactStoreType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactStoreType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactStoreType::from(s))
    }
}
impl ArtifactStoreType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactStoreType::S3 => "S3",
            ArtifactStoreType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3"]
    }
}
impl AsRef<str> for ArtifactStoreType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The parameters for the action type definition that are provided when the action type is created or updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeDeclaration {
    /// <p>The description for the action type to be updated.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the executor for an action type that was created with any supported integration model.</p>
    pub executor: std::option::Option<crate::model::ActionTypeExecutor>,
    /// <p>The action category, owner, provider, and version of the action type to be updated.</p>
    pub id: std::option::Option<crate::model::ActionTypeIdentifier>,
    /// <p>Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum and maximum number of input artifacts allowed.</p>
    pub input_artifact_details: std::option::Option<crate::model::ActionTypeArtifactDetails>,
    /// <p>Details for the output artifacts, such as a built application, that are the result of the action. For example, the minimum and maximum number of output artifacts allowed.</p>
    pub output_artifact_details: std::option::Option<crate::model::ActionTypeArtifactDetails>,
    /// <p>Details identifying the accounts with permissions to use the action type.</p>
    pub permissions: std::option::Option<crate::model::ActionTypePermissions>,
    /// <p>The properties of the action type to be updated.</p>
    pub properties: std::option::Option<std::vec::Vec<crate::model::ActionTypeProperty>>,
    /// <p>The links associated with the action type to be updated.</p>
    pub urls: std::option::Option<crate::model::ActionTypeUrls>,
}
impl ActionTypeDeclaration {
    /// <p>The description for the action type to be updated.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the executor for an action type that was created with any supported integration model.</p>
    pub fn executor(&self) -> std::option::Option<&crate::model::ActionTypeExecutor> {
        self.executor.as_ref()
    }
    /// <p>The action category, owner, provider, and version of the action type to be updated.</p>
    pub fn id(&self) -> std::option::Option<&crate::model::ActionTypeIdentifier> {
        self.id.as_ref()
    }
    /// <p>Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum and maximum number of input artifacts allowed.</p>
    pub fn input_artifact_details(
        &self,
    ) -> std::option::Option<&crate::model::ActionTypeArtifactDetails> {
        self.input_artifact_details.as_ref()
    }
    /// <p>Details for the output artifacts, such as a built application, that are the result of the action. For example, the minimum and maximum number of output artifacts allowed.</p>
    pub fn output_artifact_details(
        &self,
    ) -> std::option::Option<&crate::model::ActionTypeArtifactDetails> {
        self.output_artifact_details.as_ref()
    }
    /// <p>Details identifying the accounts with permissions to use the action type.</p>
    pub fn permissions(&self) -> std::option::Option<&crate::model::ActionTypePermissions> {
        self.permissions.as_ref()
    }
    /// <p>The properties of the action type to be updated.</p>
    pub fn properties(&self) -> std::option::Option<&[crate::model::ActionTypeProperty]> {
        self.properties.as_deref()
    }
    /// <p>The links associated with the action type to be updated.</p>
    pub fn urls(&self) -> std::option::Option<&crate::model::ActionTypeUrls> {
        self.urls.as_ref()
    }
}
impl std::fmt::Debug for ActionTypeDeclaration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeDeclaration");
        formatter.field("description", &self.description);
        formatter.field("executor", &self.executor);
        formatter.field("id", &self.id);
        formatter.field("input_artifact_details", &self.input_artifact_details);
        formatter.field("output_artifact_details", &self.output_artifact_details);
        formatter.field("permissions", &self.permissions);
        formatter.field("properties", &self.properties);
        formatter.field("urls", &self.urls);
        formatter.finish()
    }
}
/// See [`ActionTypeDeclaration`](crate::model::ActionTypeDeclaration)
pub mod action_type_declaration {
    /// A builder for [`ActionTypeDeclaration`](crate::model::ActionTypeDeclaration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) executor: std::option::Option<crate::model::ActionTypeExecutor>,
        pub(crate) id: std::option::Option<crate::model::ActionTypeIdentifier>,
        pub(crate) input_artifact_details:
            std::option::Option<crate::model::ActionTypeArtifactDetails>,
        pub(crate) output_artifact_details:
            std::option::Option<crate::model::ActionTypeArtifactDetails>,
        pub(crate) permissions: std::option::Option<crate::model::ActionTypePermissions>,
        pub(crate) properties: std::option::Option<std::vec::Vec<crate::model::ActionTypeProperty>>,
        pub(crate) urls: std::option::Option<crate::model::ActionTypeUrls>,
    }
    impl Builder {
        /// <p>The description for the action type to be updated.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the action type to be updated.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the executor for an action type that was created with any supported integration model.</p>
        pub fn executor(mut self, input: crate::model::ActionTypeExecutor) -> Self {
            self.executor = Some(input);
            self
        }
        /// <p>Information about the executor for an action type that was created with any supported integration model.</p>
        pub fn set_executor(
            mut self,
            input: std::option::Option<crate::model::ActionTypeExecutor>,
        ) -> Self {
            self.executor = input;
            self
        }
        /// <p>The action category, owner, provider, and version of the action type to be updated.</p>
        pub fn id(mut self, input: crate::model::ActionTypeIdentifier) -> Self {
            self.id = Some(input);
            self
        }
        /// <p>The action category, owner, provider, and version of the action type to be updated.</p>
        pub fn set_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeIdentifier>,
        ) -> Self {
            self.id = input;
            self
        }
        /// <p>Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum and maximum number of input artifacts allowed.</p>
        pub fn input_artifact_details(
            mut self,
            input: crate::model::ActionTypeArtifactDetails,
        ) -> Self {
            self.input_artifact_details = Some(input);
            self
        }
        /// <p>Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum and maximum number of input artifacts allowed.</p>
        pub fn set_input_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ActionTypeArtifactDetails>,
        ) -> Self {
            self.input_artifact_details = input;
            self
        }
        /// <p>Details for the output artifacts, such as a built application, that are the result of the action. For example, the minimum and maximum number of output artifacts allowed.</p>
        pub fn output_artifact_details(
            mut self,
            input: crate::model::ActionTypeArtifactDetails,
        ) -> Self {
            self.output_artifact_details = Some(input);
            self
        }
        /// <p>Details for the output artifacts, such as a built application, that are the result of the action. For example, the minimum and maximum number of output artifacts allowed.</p>
        pub fn set_output_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ActionTypeArtifactDetails>,
        ) -> Self {
            self.output_artifact_details = input;
            self
        }
        /// <p>Details identifying the accounts with permissions to use the action type.</p>
        pub fn permissions(mut self, input: crate::model::ActionTypePermissions) -> Self {
            self.permissions = Some(input);
            self
        }
        /// <p>Details identifying the accounts with permissions to use the action type.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<crate::model::ActionTypePermissions>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The properties of the action type to be updated.</p>
        pub fn properties(mut self, input: crate::model::ActionTypeProperty) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input);
            self.properties = Some(v);
            self
        }
        /// <p>The properties of the action type to be updated.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionTypeProperty>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>The links associated with the action type to be updated.</p>
        pub fn urls(mut self, input: crate::model::ActionTypeUrls) -> Self {
            self.urls = Some(input);
            self
        }
        /// <p>The links associated with the action type to be updated.</p>
        pub fn set_urls(
            mut self,
            input: std::option::Option<crate::model::ActionTypeUrls>,
        ) -> Self {
            self.urls = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeDeclaration`](crate::model::ActionTypeDeclaration)
        pub fn build(self) -> crate::model::ActionTypeDeclaration {
            crate::model::ActionTypeDeclaration {
                description: self.description,
                executor: self.executor,
                id: self.id,
                input_artifact_details: self.input_artifact_details,
                output_artifact_details: self.output_artifact_details,
                permissions: self.permissions,
                properties: self.properties,
                urls: self.urls,
            }
        }
    }
}
impl ActionTypeDeclaration {
    /// Creates a new builder-style object to manufacture [`ActionTypeDeclaration`](crate::model::ActionTypeDeclaration)
    pub fn builder() -> crate::model::action_type_declaration::Builder {
        crate::model::action_type_declaration::Builder::default()
    }
}

/// <p>Returns information about URLs for web pages that display to customers as links on the pipeline view, such as an external configuration page for the action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeUrls {
    /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can configure the external action.</p>
    pub configuration_url: std::option::Option<std::string::String>,
    /// <p>The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as a status page. This link is provided as part of the action display in the pipeline.</p>
    pub entity_url_template: std::option::Option<std::string::String>,
    /// <p>The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status page.</p>
    pub execution_url_template: std::option::Option<std::string::String>,
    /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
    pub revision_url_template: std::option::Option<std::string::String>,
}
impl ActionTypeUrls {
    /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can configure the external action.</p>
    pub fn configuration_url(&self) -> std::option::Option<&str> {
        self.configuration_url.as_deref()
    }
    /// <p>The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as a status page. This link is provided as part of the action display in the pipeline.</p>
    pub fn entity_url_template(&self) -> std::option::Option<&str> {
        self.entity_url_template.as_deref()
    }
    /// <p>The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status page.</p>
    pub fn execution_url_template(&self) -> std::option::Option<&str> {
        self.execution_url_template.as_deref()
    }
    /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
    pub fn revision_url_template(&self) -> std::option::Option<&str> {
        self.revision_url_template.as_deref()
    }
}
impl std::fmt::Debug for ActionTypeUrls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeUrls");
        formatter.field("configuration_url", &self.configuration_url);
        formatter.field("entity_url_template", &self.entity_url_template);
        formatter.field("execution_url_template", &self.execution_url_template);
        formatter.field("revision_url_template", &self.revision_url_template);
        formatter.finish()
    }
}
/// See [`ActionTypeUrls`](crate::model::ActionTypeUrls)
pub mod action_type_urls {
    /// A builder for [`ActionTypeUrls`](crate::model::ActionTypeUrls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_url: std::option::Option<std::string::String>,
        pub(crate) entity_url_template: std::option::Option<std::string::String>,
        pub(crate) execution_url_template: std::option::Option<std::string::String>,
        pub(crate) revision_url_template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can configure the external action.</p>
        pub fn configuration_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_url = Some(input.into());
            self
        }
        /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can configure the external action.</p>
        pub fn set_configuration_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_url = input;
            self
        }
        /// <p>The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as a status page. This link is provided as part of the action display in the pipeline.</p>
        pub fn entity_url_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_url_template = Some(input.into());
            self
        }
        /// <p>The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as a status page. This link is provided as part of the action display in the pipeline.</p>
        pub fn set_entity_url_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_url_template = input;
            self
        }
        /// <p>The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status page.</p>
        pub fn execution_url_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_url_template = Some(input.into());
            self
        }
        /// <p>The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status page.</p>
        pub fn set_execution_url_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_url_template = input;
            self
        }
        /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
        pub fn revision_url_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_url_template = Some(input.into());
            self
        }
        /// <p>The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
        pub fn set_revision_url_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_url_template = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeUrls`](crate::model::ActionTypeUrls)
        pub fn build(self) -> crate::model::ActionTypeUrls {
            crate::model::ActionTypeUrls {
                configuration_url: self.configuration_url,
                entity_url_template: self.entity_url_template,
                execution_url_template: self.execution_url_template,
                revision_url_template: self.revision_url_template,
            }
        }
    }
}
impl ActionTypeUrls {
    /// Creates a new builder-style object to manufacture [`ActionTypeUrls`](crate::model::ActionTypeUrls)
    pub fn builder() -> crate::model::action_type_urls::Builder {
        crate::model::action_type_urls::Builder::default()
    }
}

/// <p>Represents information about each property specified in the action configuration, such as the description and key name that display for the customer using the action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeProperty {
    /// <p>The property name that is displayed to users.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Whether the configuration property is an optional value.</p>
    pub optional: bool,
    /// <p>Whether the configuration property is a key.</p>
    pub key: bool,
    /// <p>Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is not saved in CloudTrail logs for the action execution.</p>
    pub no_echo: bool,
    /// <p>Indicates that the property is used with polling. An action type can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
    pub queryable: bool,
    /// <p>The description of the property that is displayed to users.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ActionTypeProperty {
    /// <p>The property name that is displayed to users.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Whether the configuration property is an optional value.</p>
    pub fn optional(&self) -> bool {
        self.optional
    }
    /// <p>Whether the configuration property is a key.</p>
    pub fn key(&self) -> bool {
        self.key
    }
    /// <p>Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is not saved in CloudTrail logs for the action execution.</p>
    pub fn no_echo(&self) -> bool {
        self.no_echo
    }
    /// <p>Indicates that the property is used with polling. An action type can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
    pub fn queryable(&self) -> bool {
        self.queryable
    }
    /// <p>The description of the property that is displayed to users.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ActionTypeProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeProperty");
        formatter.field("name", &self.name);
        formatter.field("optional", &self.optional);
        formatter.field("key", &self.key);
        formatter.field("no_echo", &self.no_echo);
        formatter.field("queryable", &self.queryable);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ActionTypeProperty`](crate::model::ActionTypeProperty)
pub mod action_type_property {
    /// A builder for [`ActionTypeProperty`](crate::model::ActionTypeProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) optional: std::option::Option<bool>,
        pub(crate) key: std::option::Option<bool>,
        pub(crate) no_echo: std::option::Option<bool>,
        pub(crate) queryable: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The property name that is displayed to users.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The property name that is displayed to users.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Whether the configuration property is an optional value.</p>
        pub fn optional(mut self, input: bool) -> Self {
            self.optional = Some(input);
            self
        }
        /// <p>Whether the configuration property is an optional value.</p>
        pub fn set_optional(mut self, input: std::option::Option<bool>) -> Self {
            self.optional = input;
            self
        }
        /// <p>Whether the configuration property is a key.</p>
        pub fn key(mut self, input: bool) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>Whether the configuration property is a key.</p>
        pub fn set_key(mut self, input: std::option::Option<bool>) -> Self {
            self.key = input;
            self
        }
        /// <p>Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is not saved in CloudTrail logs for the action execution.</p>
        pub fn no_echo(mut self, input: bool) -> Self {
            self.no_echo = Some(input);
            self
        }
        /// <p>Whether to omit the field value entered by the customer in the log. If <code>true</code>, the value is not saved in CloudTrail logs for the action execution.</p>
        pub fn set_no_echo(mut self, input: std::option::Option<bool>) -> Self {
            self.no_echo = input;
            self
        }
        /// <p>Indicates that the property is used with polling. An action type can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
        pub fn queryable(mut self, input: bool) -> Self {
            self.queryable = Some(input);
            self
        }
        /// <p>Indicates that the property is used with polling. An action type can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
        pub fn set_queryable(mut self, input: std::option::Option<bool>) -> Self {
            self.queryable = input;
            self
        }
        /// <p>The description of the property that is displayed to users.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the property that is displayed to users.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeProperty`](crate::model::ActionTypeProperty)
        pub fn build(self) -> crate::model::ActionTypeProperty {
            crate::model::ActionTypeProperty {
                name: self.name,
                optional: self.optional.unwrap_or_default(),
                key: self.key.unwrap_or_default(),
                no_echo: self.no_echo.unwrap_or_default(),
                queryable: self.queryable.unwrap_or_default(),
                description: self.description,
            }
        }
    }
}
impl ActionTypeProperty {
    /// Creates a new builder-style object to manufacture [`ActionTypeProperty`](crate::model::ActionTypeProperty)
    pub fn builder() -> crate::model::action_type_property::Builder {
        crate::model::action_type_property::Builder::default()
    }
}

/// <p>Details identifying the users with permissions to use the action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypePermissions {
    /// <p>A list of AWS account IDs with access to use the action type in their pipelines.</p>
    pub allowed_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ActionTypePermissions {
    /// <p>A list of AWS account IDs with access to use the action type in their pipelines.</p>
    pub fn allowed_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_accounts.as_deref()
    }
}
impl std::fmt::Debug for ActionTypePermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypePermissions");
        formatter.field("allowed_accounts", &self.allowed_accounts);
        formatter.finish()
    }
}
/// See [`ActionTypePermissions`](crate::model::ActionTypePermissions)
pub mod action_type_permissions {
    /// A builder for [`ActionTypePermissions`](crate::model::ActionTypePermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `allowed_accounts`.
        ///
        /// To override the contents of this collection use [`set_allowed_accounts`](Self::set_allowed_accounts).
        ///
        /// <p>A list of AWS account IDs with access to use the action type in their pipelines.</p>
        pub fn allowed_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_accounts.unwrap_or_default();
            v.push(input.into());
            self.allowed_accounts = Some(v);
            self
        }
        /// <p>A list of AWS account IDs with access to use the action type in their pipelines.</p>
        pub fn set_allowed_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypePermissions`](crate::model::ActionTypePermissions)
        pub fn build(self) -> crate::model::ActionTypePermissions {
            crate::model::ActionTypePermissions {
                allowed_accounts: self.allowed_accounts,
            }
        }
    }
}
impl ActionTypePermissions {
    /// Creates a new builder-style object to manufacture [`ActionTypePermissions`](crate::model::ActionTypePermissions)
    pub fn builder() -> crate::model::action_type_permissions::Builder {
        crate::model::action_type_permissions::Builder::default()
    }
}

/// <p>Information about parameters for artifacts associated with the action type, such as the minimum and maximum artifacts allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeArtifactDetails {
    /// <p>The minimum number of artifacts that can be used with the action type. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
    pub minimum_count: i32,
    /// <p>The maximum number of artifacts that can be used with the actiontype. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
    pub maximum_count: i32,
}
impl ActionTypeArtifactDetails {
    /// <p>The minimum number of artifacts that can be used with the action type. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
    pub fn minimum_count(&self) -> i32 {
        self.minimum_count
    }
    /// <p>The maximum number of artifacts that can be used with the actiontype. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
    pub fn maximum_count(&self) -> i32 {
        self.maximum_count
    }
}
impl std::fmt::Debug for ActionTypeArtifactDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeArtifactDetails");
        formatter.field("minimum_count", &self.minimum_count);
        formatter.field("maximum_count", &self.maximum_count);
        formatter.finish()
    }
}
/// See [`ActionTypeArtifactDetails`](crate::model::ActionTypeArtifactDetails)
pub mod action_type_artifact_details {
    /// A builder for [`ActionTypeArtifactDetails`](crate::model::ActionTypeArtifactDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_count: std::option::Option<i32>,
        pub(crate) maximum_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum number of artifacts that can be used with the action type. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
        pub fn minimum_count(mut self, input: i32) -> Self {
            self.minimum_count = Some(input);
            self
        }
        /// <p>The minimum number of artifacts that can be used with the action type. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
        pub fn set_minimum_count(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_count = input;
            self
        }
        /// <p>The maximum number of artifacts that can be used with the actiontype. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
        pub fn maximum_count(mut self, input: i32) -> Self {
            self.maximum_count = Some(input);
            self
        }
        /// <p>The maximum number of artifacts that can be used with the actiontype. For example, you should specify a minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.</p>
        pub fn set_maximum_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeArtifactDetails`](crate::model::ActionTypeArtifactDetails)
        pub fn build(self) -> crate::model::ActionTypeArtifactDetails {
            crate::model::ActionTypeArtifactDetails {
                minimum_count: self.minimum_count.unwrap_or_default(),
                maximum_count: self.maximum_count.unwrap_or_default(),
            }
        }
    }
}
impl ActionTypeArtifactDetails {
    /// Creates a new builder-style object to manufacture [`ActionTypeArtifactDetails`](crate::model::ActionTypeArtifactDetails)
    pub fn builder() -> crate::model::action_type_artifact_details::Builder {
        crate::model::action_type_artifact_details::Builder::default()
    }
}

/// <p>Specifies the category, owner, provider, and version of the action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeIdentifier {
    /// <p>Defines what kind of action can be taken in the stage, one of the following:</p>
    /// <ul>
    /// <li> <p> <code>Source</code> </p> </li>
    /// <li> <p> <code>Build</code> </p> </li>
    /// <li> <p> <code>Test</code> </p> </li>
    /// <li> <p> <code>Deploy</code> </p> </li>
    /// <li> <p> <code>Approval</code> </p> </li>
    /// <li> <p> <code>Invoke</code> </p> </li>
    /// </ul>
    pub category: std::option::Option<crate::model::ActionCategory>,
    /// <p>The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The provider of the action type being called. The provider name is supplied when the action type is created.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>A string that describes the action type version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl ActionTypeIdentifier {
    /// <p>Defines what kind of action can be taken in the stage, one of the following:</p>
    /// <ul>
    /// <li> <p> <code>Source</code> </p> </li>
    /// <li> <p> <code>Build</code> </p> </li>
    /// <li> <p> <code>Test</code> </p> </li>
    /// <li> <p> <code>Deploy</code> </p> </li>
    /// <li> <p> <code>Approval</code> </p> </li>
    /// <li> <p> <code>Invoke</code> </p> </li>
    /// </ul>
    pub fn category(&self) -> std::option::Option<&crate::model::ActionCategory> {
        self.category.as_ref()
    }
    /// <p>The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The provider of the action type being called. The provider name is supplied when the action type is created.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>A string that describes the action type version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for ActionTypeIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeIdentifier");
        formatter.field("category", &self.category);
        formatter.field("owner", &self.owner);
        formatter.field("provider", &self.provider);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ActionTypeIdentifier`](crate::model::ActionTypeIdentifier)
pub mod action_type_identifier {
    /// A builder for [`ActionTypeIdentifier`](crate::model::ActionTypeIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::ActionCategory>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Defines what kind of action can be taken in the stage, one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Source</code> </p> </li>
        /// <li> <p> <code>Build</code> </p> </li>
        /// <li> <p> <code>Test</code> </p> </li>
        /// <li> <p> <code>Deploy</code> </p> </li>
        /// <li> <p> <code>Approval</code> </p> </li>
        /// <li> <p> <code>Invoke</code> </p> </li>
        /// </ul>
        pub fn category(mut self, input: crate::model::ActionCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>Defines what kind of action can be taken in the stage, one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Source</code> </p> </li>
        /// <li> <p> <code>Build</code> </p> </li>
        /// <li> <p> <code>Test</code> </p> </li>
        /// <li> <p> <code>Deploy</code> </p> </li>
        /// <li> <p> <code>Approval</code> </p> </li>
        /// <li> <p> <code>Invoke</code> </p> </li>
        /// </ul>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The provider of the action type being called. The provider name is supplied when the action type is created.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the action type being called. The provider name is supplied when the action type is created.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>A string that describes the action type version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A string that describes the action type version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeIdentifier`](crate::model::ActionTypeIdentifier)
        pub fn build(self) -> crate::model::ActionTypeIdentifier {
            crate::model::ActionTypeIdentifier {
                category: self.category,
                owner: self.owner,
                provider: self.provider,
                version: self.version,
            }
        }
    }
}
impl ActionTypeIdentifier {
    /// Creates a new builder-style object to manufacture [`ActionTypeIdentifier`](crate::model::ActionTypeIdentifier)
    pub fn builder() -> crate::model::action_type_identifier::Builder {
        crate::model::action_type_identifier::Builder::default()
    }
}

/// <p>The action engine, or executor, for an action type created for a provider, where the action is to be used by customers of the provider. The action engine is associated with the model used to create and update the action, such as the Lambda integration model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeExecutor {
    /// <p>The action configuration properties for the action type. These properties are specified in the action definition when the action type is created.</p>
    pub configuration: std::option::Option<crate::model::ExecutorConfiguration>,
    /// <p>The integration model used to create and update the action type, <code>Lambda</code> or <code>JobWorker</code>. </p>
    pub r#type: std::option::Option<crate::model::ExecutorType>,
    /// <p>The policy statement that specifies the permissions in the CodePipeline customer’s account that are needed to successfully run an action.</p>
    /// <p>To grant permission to another account, specify the account ID as the Principal, a domain-style identifier defined by the service, for example <code>codepipeline.amazonaws.com</code>.</p> <note>
    /// <p>The size of the passed JSON policy document cannot exceed 2048 characters.</p>
    /// </note>
    pub policy_statements_template: std::option::Option<std::string::String>,
    /// <p>The timeout in seconds for the job. An action execution can have multiple jobs. This is the timeout for a single job, not the entire action execution.</p>
    pub job_timeout: std::option::Option<i32>,
}
impl ActionTypeExecutor {
    /// <p>The action configuration properties for the action type. These properties are specified in the action definition when the action type is created.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ExecutorConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The integration model used to create and update the action type, <code>Lambda</code> or <code>JobWorker</code>. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ExecutorType> {
        self.r#type.as_ref()
    }
    /// <p>The policy statement that specifies the permissions in the CodePipeline customer’s account that are needed to successfully run an action.</p>
    /// <p>To grant permission to another account, specify the account ID as the Principal, a domain-style identifier defined by the service, for example <code>codepipeline.amazonaws.com</code>.</p> <note>
    /// <p>The size of the passed JSON policy document cannot exceed 2048 characters.</p>
    /// </note>
    pub fn policy_statements_template(&self) -> std::option::Option<&str> {
        self.policy_statements_template.as_deref()
    }
    /// <p>The timeout in seconds for the job. An action execution can have multiple jobs. This is the timeout for a single job, not the entire action execution.</p>
    pub fn job_timeout(&self) -> std::option::Option<i32> {
        self.job_timeout
    }
}
impl std::fmt::Debug for ActionTypeExecutor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeExecutor");
        formatter.field("configuration", &self.configuration);
        formatter.field("r#type", &self.r#type);
        formatter.field(
            "policy_statements_template",
            &self.policy_statements_template,
        );
        formatter.field("job_timeout", &self.job_timeout);
        formatter.finish()
    }
}
/// See [`ActionTypeExecutor`](crate::model::ActionTypeExecutor)
pub mod action_type_executor {
    /// A builder for [`ActionTypeExecutor`](crate::model::ActionTypeExecutor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::ExecutorConfiguration>,
        pub(crate) r#type: std::option::Option<crate::model::ExecutorType>,
        pub(crate) policy_statements_template: std::option::Option<std::string::String>,
        pub(crate) job_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The action configuration properties for the action type. These properties are specified in the action definition when the action type is created.</p>
        pub fn configuration(mut self, input: crate::model::ExecutorConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The action configuration properties for the action type. These properties are specified in the action definition when the action type is created.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ExecutorConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The integration model used to create and update the action type, <code>Lambda</code> or <code>JobWorker</code>. </p>
        pub fn r#type(mut self, input: crate::model::ExecutorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The integration model used to create and update the action type, <code>Lambda</code> or <code>JobWorker</code>. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ExecutorType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The policy statement that specifies the permissions in the CodePipeline customer’s account that are needed to successfully run an action.</p>
        /// <p>To grant permission to another account, specify the account ID as the Principal, a domain-style identifier defined by the service, for example <code>codepipeline.amazonaws.com</code>.</p> <note>
        /// <p>The size of the passed JSON policy document cannot exceed 2048 characters.</p>
        /// </note>
        pub fn policy_statements_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_statements_template = Some(input.into());
            self
        }
        /// <p>The policy statement that specifies the permissions in the CodePipeline customer’s account that are needed to successfully run an action.</p>
        /// <p>To grant permission to another account, specify the account ID as the Principal, a domain-style identifier defined by the service, for example <code>codepipeline.amazonaws.com</code>.</p> <note>
        /// <p>The size of the passed JSON policy document cannot exceed 2048 characters.</p>
        /// </note>
        pub fn set_policy_statements_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_statements_template = input;
            self
        }
        /// <p>The timeout in seconds for the job. An action execution can have multiple jobs. This is the timeout for a single job, not the entire action execution.</p>
        pub fn job_timeout(mut self, input: i32) -> Self {
            self.job_timeout = Some(input);
            self
        }
        /// <p>The timeout in seconds for the job. An action execution can have multiple jobs. This is the timeout for a single job, not the entire action execution.</p>
        pub fn set_job_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.job_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeExecutor`](crate::model::ActionTypeExecutor)
        pub fn build(self) -> crate::model::ActionTypeExecutor {
            crate::model::ActionTypeExecutor {
                configuration: self.configuration,
                r#type: self.r#type,
                policy_statements_template: self.policy_statements_template,
                job_timeout: self.job_timeout,
            }
        }
    }
}
impl ActionTypeExecutor {
    /// Creates a new builder-style object to manufacture [`ActionTypeExecutor`](crate::model::ActionTypeExecutor)
    pub fn builder() -> crate::model::action_type_executor::Builder {
        crate::model::action_type_executor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutorType {
    #[allow(missing_docs)] // documentation missing in model
    JobWorker,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutorType {
    fn from(s: &str) -> Self {
        match s {
            "JobWorker" => ExecutorType::JobWorker,
            "Lambda" => ExecutorType::Lambda,
            other => ExecutorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutorType::from(s))
    }
}
impl ExecutorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutorType::JobWorker => "JobWorker",
            ExecutorType::Lambda => "Lambda",
            ExecutorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JobWorker", "Lambda"]
    }
}
impl AsRef<str> for ExecutorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The action engine, or executor, related to the supported integration model used to create and update the action type. The available executor types are <code>Lambda</code> and <code>JobWorker</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutorConfiguration {
    /// <p>Details about the <code>Lambda</code> executor of the action type.</p>
    pub lambda_executor_configuration:
        std::option::Option<crate::model::LambdaExecutorConfiguration>,
    /// <p>Details about the <code>JobWorker</code> executor of the action type.</p>
    pub job_worker_executor_configuration:
        std::option::Option<crate::model::JobWorkerExecutorConfiguration>,
}
impl ExecutorConfiguration {
    /// <p>Details about the <code>Lambda</code> executor of the action type.</p>
    pub fn lambda_executor_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LambdaExecutorConfiguration> {
        self.lambda_executor_configuration.as_ref()
    }
    /// <p>Details about the <code>JobWorker</code> executor of the action type.</p>
    pub fn job_worker_executor_configuration(
        &self,
    ) -> std::option::Option<&crate::model::JobWorkerExecutorConfiguration> {
        self.job_worker_executor_configuration.as_ref()
    }
}
impl std::fmt::Debug for ExecutorConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutorConfiguration");
        formatter.field(
            "lambda_executor_configuration",
            &self.lambda_executor_configuration,
        );
        formatter.field(
            "job_worker_executor_configuration",
            &self.job_worker_executor_configuration,
        );
        formatter.finish()
    }
}
/// See [`ExecutorConfiguration`](crate::model::ExecutorConfiguration)
pub mod executor_configuration {
    /// A builder for [`ExecutorConfiguration`](crate::model::ExecutorConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_executor_configuration:
            std::option::Option<crate::model::LambdaExecutorConfiguration>,
        pub(crate) job_worker_executor_configuration:
            std::option::Option<crate::model::JobWorkerExecutorConfiguration>,
    }
    impl Builder {
        /// <p>Details about the <code>Lambda</code> executor of the action type.</p>
        pub fn lambda_executor_configuration(
            mut self,
            input: crate::model::LambdaExecutorConfiguration,
        ) -> Self {
            self.lambda_executor_configuration = Some(input);
            self
        }
        /// <p>Details about the <code>Lambda</code> executor of the action type.</p>
        pub fn set_lambda_executor_configuration(
            mut self,
            input: std::option::Option<crate::model::LambdaExecutorConfiguration>,
        ) -> Self {
            self.lambda_executor_configuration = input;
            self
        }
        /// <p>Details about the <code>JobWorker</code> executor of the action type.</p>
        pub fn job_worker_executor_configuration(
            mut self,
            input: crate::model::JobWorkerExecutorConfiguration,
        ) -> Self {
            self.job_worker_executor_configuration = Some(input);
            self
        }
        /// <p>Details about the <code>JobWorker</code> executor of the action type.</p>
        pub fn set_job_worker_executor_configuration(
            mut self,
            input: std::option::Option<crate::model::JobWorkerExecutorConfiguration>,
        ) -> Self {
            self.job_worker_executor_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutorConfiguration`](crate::model::ExecutorConfiguration)
        pub fn build(self) -> crate::model::ExecutorConfiguration {
            crate::model::ExecutorConfiguration {
                lambda_executor_configuration: self.lambda_executor_configuration,
                job_worker_executor_configuration: self.job_worker_executor_configuration,
            }
        }
    }
}
impl ExecutorConfiguration {
    /// Creates a new builder-style object to manufacture [`ExecutorConfiguration`](crate::model::ExecutorConfiguration)
    pub fn builder() -> crate::model::executor_configuration::Builder {
        crate::model::executor_configuration::Builder::default()
    }
}

/// <p>Details about the polling configuration for the <code>JobWorker</code> action engine, or executor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobWorkerExecutorConfiguration {
    /// <p>The accounts in which the job worker is configured and might poll for jobs as part of the action execution.</p>
    pub polling_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The service Principals in which the job worker is configured and might poll for jobs as part of the action execution.</p>
    pub polling_service_principals: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl JobWorkerExecutorConfiguration {
    /// <p>The accounts in which the job worker is configured and might poll for jobs as part of the action execution.</p>
    pub fn polling_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.polling_accounts.as_deref()
    }
    /// <p>The service Principals in which the job worker is configured and might poll for jobs as part of the action execution.</p>
    pub fn polling_service_principals(&self) -> std::option::Option<&[std::string::String]> {
        self.polling_service_principals.as_deref()
    }
}
impl std::fmt::Debug for JobWorkerExecutorConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobWorkerExecutorConfiguration");
        formatter.field("polling_accounts", &self.polling_accounts);
        formatter.field(
            "polling_service_principals",
            &self.polling_service_principals,
        );
        formatter.finish()
    }
}
/// See [`JobWorkerExecutorConfiguration`](crate::model::JobWorkerExecutorConfiguration)
pub mod job_worker_executor_configuration {
    /// A builder for [`JobWorkerExecutorConfiguration`](crate::model::JobWorkerExecutorConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) polling_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) polling_service_principals:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `polling_accounts`.
        ///
        /// To override the contents of this collection use [`set_polling_accounts`](Self::set_polling_accounts).
        ///
        /// <p>The accounts in which the job worker is configured and might poll for jobs as part of the action execution.</p>
        pub fn polling_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.polling_accounts.unwrap_or_default();
            v.push(input.into());
            self.polling_accounts = Some(v);
            self
        }
        /// <p>The accounts in which the job worker is configured and might poll for jobs as part of the action execution.</p>
        pub fn set_polling_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.polling_accounts = input;
            self
        }
        /// Appends an item to `polling_service_principals`.
        ///
        /// To override the contents of this collection use [`set_polling_service_principals`](Self::set_polling_service_principals).
        ///
        /// <p>The service Principals in which the job worker is configured and might poll for jobs as part of the action execution.</p>
        pub fn polling_service_principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.polling_service_principals.unwrap_or_default();
            v.push(input.into());
            self.polling_service_principals = Some(v);
            self
        }
        /// <p>The service Principals in which the job worker is configured and might poll for jobs as part of the action execution.</p>
        pub fn set_polling_service_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.polling_service_principals = input;
            self
        }
        /// Consumes the builder and constructs a [`JobWorkerExecutorConfiguration`](crate::model::JobWorkerExecutorConfiguration)
        pub fn build(self) -> crate::model::JobWorkerExecutorConfiguration {
            crate::model::JobWorkerExecutorConfiguration {
                polling_accounts: self.polling_accounts,
                polling_service_principals: self.polling_service_principals,
            }
        }
    }
}
impl JobWorkerExecutorConfiguration {
    /// Creates a new builder-style object to manufacture [`JobWorkerExecutorConfiguration`](crate::model::JobWorkerExecutorConfiguration)
    pub fn builder() -> crate::model::job_worker_executor_configuration::Builder {
        crate::model::job_worker_executor_configuration::Builder::default()
    }
}

/// <p>Details about the configuration for the <code>Lambda</code> action engine, or executor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaExecutorConfiguration {
    /// <p>The ARN of the Lambda function used by the action engine.</p>
    pub lambda_function_arn: std::option::Option<std::string::String>,
}
impl LambdaExecutorConfiguration {
    /// <p>The ARN of the Lambda function used by the action engine.</p>
    pub fn lambda_function_arn(&self) -> std::option::Option<&str> {
        self.lambda_function_arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaExecutorConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaExecutorConfiguration");
        formatter.field("lambda_function_arn", &self.lambda_function_arn);
        formatter.finish()
    }
}
/// See [`LambdaExecutorConfiguration`](crate::model::LambdaExecutorConfiguration)
pub mod lambda_executor_configuration {
    /// A builder for [`LambdaExecutorConfiguration`](crate::model::LambdaExecutorConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_function_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Lambda function used by the action engine.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function used by the action engine.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaExecutorConfiguration`](crate::model::LambdaExecutorConfiguration)
        pub fn build(self) -> crate::model::LambdaExecutorConfiguration {
            crate::model::LambdaExecutorConfiguration {
                lambda_function_arn: self.lambda_function_arn,
            }
        }
    }
}
impl LambdaExecutorConfiguration {
    /// Creates a new builder-style object to manufacture [`LambdaExecutorConfiguration`](crate::model::LambdaExecutorConfiguration)
    pub fn builder() -> crate::model::lambda_executor_configuration::Builder {
        crate::model::lambda_executor_configuration::Builder::default()
    }
}

/// <p>A tag is a key-value pair that is used to manage the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag's key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag's key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag's key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag's key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StageRetryMode {
    #[allow(missing_docs)] // documentation missing in model
    FailedActions,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StageRetryMode {
    fn from(s: &str) -> Self {
        match s {
            "FAILED_ACTIONS" => StageRetryMode::FailedActions,
            other => StageRetryMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StageRetryMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StageRetryMode::from(s))
    }
}
impl StageRetryMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StageRetryMode::FailedActions => "FAILED_ACTIONS",
            StageRetryMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED_ACTIONS"]
    }
}
impl AsRef<str> for StageRetryMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The detail returned for each webhook after listing webhooks, such as the webhook URL, the webhook name, and the webhook ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWebhookItem {
    /// <p>The detail returned for each webhook, such as the webhook authentication type and filter rules.</p>
    pub definition: std::option::Option<crate::model::WebhookDefinition>,
    /// <p>A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The text of the error message about the webhook.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The number code of the error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The date and time a webhook was last successfully triggered, in timestamp format.</p>
    pub last_triggered: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the webhook.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the tags applied to the webhook.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListWebhookItem {
    /// <p>The detail returned for each webhook, such as the webhook authentication type and filter rules.</p>
    pub fn definition(&self) -> std::option::Option<&crate::model::WebhookDefinition> {
        self.definition.as_ref()
    }
    /// <p>A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The text of the error message about the webhook.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The number code of the error.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The date and time a webhook was last successfully triggered, in timestamp format.</p>
    pub fn last_triggered(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_triggered.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the webhook.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Specifies the tags applied to the webhook.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListWebhookItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWebhookItem");
        formatter.field("definition", &self.definition);
        formatter.field("url", &self.url);
        formatter.field("error_message", &self.error_message);
        formatter.field("error_code", &self.error_code);
        formatter.field("last_triggered", &self.last_triggered);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListWebhookItem`](crate::model::ListWebhookItem)
pub mod list_webhook_item {
    /// A builder for [`ListWebhookItem`](crate::model::ListWebhookItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) definition: std::option::Option<crate::model::WebhookDefinition>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) last_triggered: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The detail returned for each webhook, such as the webhook authentication type and filter rules.</p>
        pub fn definition(mut self, input: crate::model::WebhookDefinition) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The detail returned for each webhook, such as the webhook authentication type and filter rules.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::WebhookDefinition>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The text of the error message about the webhook.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message about the webhook.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The number code of the error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The number code of the error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The date and time a webhook was last successfully triggered, in timestamp format.</p>
        pub fn last_triggered(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_triggered = Some(input);
            self
        }
        /// <p>The date and time a webhook was last successfully triggered, in timestamp format.</p>
        pub fn set_last_triggered(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_triggered = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the webhook.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the webhook.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the webhook.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to the webhook.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWebhookItem`](crate::model::ListWebhookItem)
        pub fn build(self) -> crate::model::ListWebhookItem {
            crate::model::ListWebhookItem {
                definition: self.definition,
                url: self.url,
                error_message: self.error_message,
                error_code: self.error_code,
                last_triggered: self.last_triggered,
                arn: self.arn,
                tags: self.tags,
            }
        }
    }
}
impl ListWebhookItem {
    /// Creates a new builder-style object to manufacture [`ListWebhookItem`](crate::model::ListWebhookItem)
    pub fn builder() -> crate::model::list_webhook_item::Builder {
        crate::model::list_webhook_item::Builder::default()
    }
}

/// <p>Represents information about a webhook and its definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebhookDefinition {
    /// <p>The name of the webhook.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the pipeline you want to connect to the webhook.</p>
    pub target_pipeline: std::option::Option<std::string::String>,
    /// <p>The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.</p>
    pub target_action: std::option::Option<std::string::String>,
    /// <p>A list of rules applied to the body/payload sent in the POST request to a webhook URL. All defined rules must pass for the request to be accepted and the pipeline started.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::WebhookFilterRule>>,
    /// <p>Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.</p>
    /// <ul>
    /// <li> <p>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</p> </li>
    /// <li> <p> IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</p> </li>
    /// <li> <p> UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</p> </li>
    /// </ul>
    pub authentication: std::option::Option<crate::model::WebhookAuthenticationType>,
    /// <p>Properties that configure the authentication applied to incoming webhook trigger requests. The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken </code>property must be set. For IP, only the <code>AllowedIPRange </code>property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.</p>
    pub authentication_configuration: std::option::Option<crate::model::WebhookAuthConfiguration>,
}
impl WebhookDefinition {
    /// <p>The name of the webhook.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the pipeline you want to connect to the webhook.</p>
    pub fn target_pipeline(&self) -> std::option::Option<&str> {
        self.target_pipeline.as_deref()
    }
    /// <p>The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.</p>
    pub fn target_action(&self) -> std::option::Option<&str> {
        self.target_action.as_deref()
    }
    /// <p>A list of rules applied to the body/payload sent in the POST request to a webhook URL. All defined rules must pass for the request to be accepted and the pipeline started.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::WebhookFilterRule]> {
        self.filters.as_deref()
    }
    /// <p>Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.</p>
    /// <ul>
    /// <li> <p>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</p> </li>
    /// <li> <p> IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</p> </li>
    /// <li> <p> UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</p> </li>
    /// </ul>
    pub fn authentication(&self) -> std::option::Option<&crate::model::WebhookAuthenticationType> {
        self.authentication.as_ref()
    }
    /// <p>Properties that configure the authentication applied to incoming webhook trigger requests. The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken </code>property must be set. For IP, only the <code>AllowedIPRange </code>property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.</p>
    pub fn authentication_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WebhookAuthConfiguration> {
        self.authentication_configuration.as_ref()
    }
}
impl std::fmt::Debug for WebhookDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebhookDefinition");
        formatter.field("name", &self.name);
        formatter.field("target_pipeline", &self.target_pipeline);
        formatter.field("target_action", &self.target_action);
        formatter.field("filters", &self.filters);
        formatter.field("authentication", &self.authentication);
        formatter.field(
            "authentication_configuration",
            &self.authentication_configuration,
        );
        formatter.finish()
    }
}
/// See [`WebhookDefinition`](crate::model::WebhookDefinition)
pub mod webhook_definition {
    /// A builder for [`WebhookDefinition`](crate::model::WebhookDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) target_pipeline: std::option::Option<std::string::String>,
        pub(crate) target_action: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::WebhookFilterRule>>,
        pub(crate) authentication: std::option::Option<crate::model::WebhookAuthenticationType>,
        pub(crate) authentication_configuration:
            std::option::Option<crate::model::WebhookAuthConfiguration>,
    }
    impl Builder {
        /// <p>The name of the webhook.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the webhook.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the pipeline you want to connect to the webhook.</p>
        pub fn target_pipeline(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_pipeline = Some(input.into());
            self
        }
        /// <p>The name of the pipeline you want to connect to the webhook.</p>
        pub fn set_target_pipeline(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_pipeline = input;
            self
        }
        /// <p>The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.</p>
        pub fn target_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_action = Some(input.into());
            self
        }
        /// <p>The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.</p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_action = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of rules applied to the body/payload sent in the POST request to a webhook URL. All defined rules must pass for the request to be accepted and the pipeline started.</p>
        pub fn filters(mut self, input: crate::model::WebhookFilterRule) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A list of rules applied to the body/payload sent in the POST request to a webhook URL. All defined rules must pass for the request to be accepted and the pipeline started.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WebhookFilterRule>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.</p>
        /// <ul>
        /// <li> <p>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</p> </li>
        /// <li> <p> IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</p> </li>
        /// <li> <p> UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</p> </li>
        /// </ul>
        pub fn authentication(mut self, input: crate::model::WebhookAuthenticationType) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.</p>
        /// <ul>
        /// <li> <p>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</p> </li>
        /// <li> <p> IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</p> </li>
        /// <li> <p> UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</p> </li>
        /// </ul>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::WebhookAuthenticationType>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>Properties that configure the authentication applied to incoming webhook trigger requests. The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken </code>property must be set. For IP, only the <code>AllowedIPRange </code>property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.</p>
        pub fn authentication_configuration(
            mut self,
            input: crate::model::WebhookAuthConfiguration,
        ) -> Self {
            self.authentication_configuration = Some(input);
            self
        }
        /// <p>Properties that configure the authentication applied to incoming webhook trigger requests. The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken </code>property must be set. For IP, only the <code>AllowedIPRange </code>property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.</p>
        pub fn set_authentication_configuration(
            mut self,
            input: std::option::Option<crate::model::WebhookAuthConfiguration>,
        ) -> Self {
            self.authentication_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`WebhookDefinition`](crate::model::WebhookDefinition)
        pub fn build(self) -> crate::model::WebhookDefinition {
            crate::model::WebhookDefinition {
                name: self.name,
                target_pipeline: self.target_pipeline,
                target_action: self.target_action,
                filters: self.filters,
                authentication: self.authentication,
                authentication_configuration: self.authentication_configuration,
            }
        }
    }
}
impl WebhookDefinition {
    /// Creates a new builder-style object to manufacture [`WebhookDefinition`](crate::model::WebhookDefinition)
    pub fn builder() -> crate::model::webhook_definition::Builder {
        crate::model::webhook_definition::Builder::default()
    }
}

/// <p>The authentication applied to incoming webhook trigger requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebhookAuthConfiguration {
    /// <p>The property used to configure acceptance of webhooks in an IP address range. For IP, only the <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.</p>
    pub allowed_ip_range: std::option::Option<std::string::String>,
    /// <p>The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set.</p>
    pub secret_token: std::option::Option<std::string::String>,
}
impl WebhookAuthConfiguration {
    /// <p>The property used to configure acceptance of webhooks in an IP address range. For IP, only the <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.</p>
    pub fn allowed_ip_range(&self) -> std::option::Option<&str> {
        self.allowed_ip_range.as_deref()
    }
    /// <p>The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set.</p>
    pub fn secret_token(&self) -> std::option::Option<&str> {
        self.secret_token.as_deref()
    }
}
impl std::fmt::Debug for WebhookAuthConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebhookAuthConfiguration");
        formatter.field("allowed_ip_range", &self.allowed_ip_range);
        formatter.field("secret_token", &self.secret_token);
        formatter.finish()
    }
}
/// See [`WebhookAuthConfiguration`](crate::model::WebhookAuthConfiguration)
pub mod webhook_auth_configuration {
    /// A builder for [`WebhookAuthConfiguration`](crate::model::WebhookAuthConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_ip_range: std::option::Option<std::string::String>,
        pub(crate) secret_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The property used to configure acceptance of webhooks in an IP address range. For IP, only the <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.</p>
        pub fn allowed_ip_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_ip_range = Some(input.into());
            self
        }
        /// <p>The property used to configure acceptance of webhooks in an IP address range. For IP, only the <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.</p>
        pub fn set_allowed_ip_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_ip_range = input;
            self
        }
        /// <p>The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set.</p>
        pub fn secret_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_token = Some(input.into());
            self
        }
        /// <p>The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set.</p>
        pub fn set_secret_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_token = input;
            self
        }
        /// Consumes the builder and constructs a [`WebhookAuthConfiguration`](crate::model::WebhookAuthConfiguration)
        pub fn build(self) -> crate::model::WebhookAuthConfiguration {
            crate::model::WebhookAuthConfiguration {
                allowed_ip_range: self.allowed_ip_range,
                secret_token: self.secret_token,
            }
        }
    }
}
impl WebhookAuthConfiguration {
    /// Creates a new builder-style object to manufacture [`WebhookAuthConfiguration`](crate::model::WebhookAuthConfiguration)
    pub fn builder() -> crate::model::webhook_auth_configuration::Builder {
        crate::model::webhook_auth_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WebhookAuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    GithubHmac,
    #[allow(missing_docs)] // documentation missing in model
    Ip,
    #[allow(missing_docs)] // documentation missing in model
    Unauthenticated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WebhookAuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "GITHUB_HMAC" => WebhookAuthenticationType::GithubHmac,
            "IP" => WebhookAuthenticationType::Ip,
            "UNAUTHENTICATED" => WebhookAuthenticationType::Unauthenticated,
            other => WebhookAuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WebhookAuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WebhookAuthenticationType::from(s))
    }
}
impl WebhookAuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WebhookAuthenticationType::GithubHmac => "GITHUB_HMAC",
            WebhookAuthenticationType::Ip => "IP",
            WebhookAuthenticationType::Unauthenticated => "UNAUTHENTICATED",
            WebhookAuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GITHUB_HMAC", "IP", "UNAUTHENTICATED"]
    }
}
impl AsRef<str> for WebhookAuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The event criteria that specify when a webhook notification is sent to your URL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebhookFilterRule {
    /// <p>A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java JsonPath implementation</a> in GitHub.</p>
    pub json_path: std::option::Option<std::string::String>,
    /// <p>The value selected by the <code>JsonPath</code> expression must match what is supplied in the <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "master", the <code>MatchEquals</code> value is evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Pipeline Structure Reference Action Requirements</a>.</p>
    pub match_equals: std::option::Option<std::string::String>,
}
impl WebhookFilterRule {
    /// <p>A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java JsonPath implementation</a> in GitHub.</p>
    pub fn json_path(&self) -> std::option::Option<&str> {
        self.json_path.as_deref()
    }
    /// <p>The value selected by the <code>JsonPath</code> expression must match what is supplied in the <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "master", the <code>MatchEquals</code> value is evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Pipeline Structure Reference Action Requirements</a>.</p>
    pub fn match_equals(&self) -> std::option::Option<&str> {
        self.match_equals.as_deref()
    }
}
impl std::fmt::Debug for WebhookFilterRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebhookFilterRule");
        formatter.field("json_path", &self.json_path);
        formatter.field("match_equals", &self.match_equals);
        formatter.finish()
    }
}
/// See [`WebhookFilterRule`](crate::model::WebhookFilterRule)
pub mod webhook_filter_rule {
    /// A builder for [`WebhookFilterRule`](crate::model::WebhookFilterRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) json_path: std::option::Option<std::string::String>,
        pub(crate) match_equals: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java JsonPath implementation</a> in GitHub.</p>
        pub fn json_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.json_path = Some(input.into());
            self
        }
        /// <p>A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java JsonPath implementation</a> in GitHub.</p>
        pub fn set_json_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.json_path = input;
            self
        }
        /// <p>The value selected by the <code>JsonPath</code> expression must match what is supplied in the <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "master", the <code>MatchEquals</code> value is evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Pipeline Structure Reference Action Requirements</a>.</p>
        pub fn match_equals(mut self, input: impl Into<std::string::String>) -> Self {
            self.match_equals = Some(input.into());
            self
        }
        /// <p>The value selected by the <code>JsonPath</code> expression must match what is supplied in the <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "master", the <code>MatchEquals</code> value is evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Pipeline Structure Reference Action Requirements</a>.</p>
        pub fn set_match_equals(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.match_equals = input;
            self
        }
        /// Consumes the builder and constructs a [`WebhookFilterRule`](crate::model::WebhookFilterRule)
        pub fn build(self) -> crate::model::WebhookFilterRule {
            crate::model::WebhookFilterRule {
                json_path: self.json_path,
                match_equals: self.match_equals,
            }
        }
    }
}
impl WebhookFilterRule {
    /// Creates a new builder-style object to manufacture [`WebhookFilterRule`](crate::model::WebhookFilterRule)
    pub fn builder() -> crate::model::webhook_filter_rule::Builder {
        crate::model::webhook_filter_rule::Builder::default()
    }
}

/// <p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionDetails {
    /// <p>The summary of the current status of the actions.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>The system-generated unique ID of this action used to identify this job worker in any external systems, such as AWS CodeDeploy.</p>
    pub external_execution_id: std::option::Option<std::string::String>,
    /// <p>The percentage of work completed on the action, represented on a scale of 0 to 100 percent.</p>
    pub percent_complete: std::option::Option<i32>,
}
impl ExecutionDetails {
    /// <p>The summary of the current status of the actions.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>The system-generated unique ID of this action used to identify this job worker in any external systems, such as AWS CodeDeploy.</p>
    pub fn external_execution_id(&self) -> std::option::Option<&str> {
        self.external_execution_id.as_deref()
    }
    /// <p>The percentage of work completed on the action, represented on a scale of 0 to 100 percent.</p>
    pub fn percent_complete(&self) -> std::option::Option<i32> {
        self.percent_complete
    }
}
impl std::fmt::Debug for ExecutionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionDetails");
        formatter.field("summary", &self.summary);
        formatter.field("external_execution_id", &self.external_execution_id);
        formatter.field("percent_complete", &self.percent_complete);
        formatter.finish()
    }
}
/// See [`ExecutionDetails`](crate::model::ExecutionDetails)
pub mod execution_details {
    /// A builder for [`ExecutionDetails`](crate::model::ExecutionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) external_execution_id: std::option::Option<std::string::String>,
        pub(crate) percent_complete: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The summary of the current status of the actions.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>The summary of the current status of the actions.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>The system-generated unique ID of this action used to identify this job worker in any external systems, such as AWS CodeDeploy.</p>
        pub fn external_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_execution_id = Some(input.into());
            self
        }
        /// <p>The system-generated unique ID of this action used to identify this job worker in any external systems, such as AWS CodeDeploy.</p>
        pub fn set_external_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_execution_id = input;
            self
        }
        /// <p>The percentage of work completed on the action, represented on a scale of 0 to 100 percent.</p>
        pub fn percent_complete(mut self, input: i32) -> Self {
            self.percent_complete = Some(input);
            self
        }
        /// <p>The percentage of work completed on the action, represented on a scale of 0 to 100 percent.</p>
        pub fn set_percent_complete(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_complete = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionDetails`](crate::model::ExecutionDetails)
        pub fn build(self) -> crate::model::ExecutionDetails {
            crate::model::ExecutionDetails {
                summary: self.summary,
                external_execution_id: self.external_execution_id,
                percent_complete: self.percent_complete,
            }
        }
    }
}
impl ExecutionDetails {
    /// Creates a new builder-style object to manufacture [`ExecutionDetails`](crate::model::ExecutionDetails)
    pub fn builder() -> crate::model::execution_details::Builder {
        crate::model::execution_details::Builder::default()
    }
}

/// <p>Represents information about a current revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CurrentRevision {
    /// <p>The revision ID of the current version of an artifact.</p>
    pub revision: std::option::Option<std::string::String>,
    /// <p>The change identifier for the current revision.</p>
    pub change_identifier: std::option::Option<std::string::String>,
    /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The summary of the most recent revision of the artifact.</p>
    pub revision_summary: std::option::Option<std::string::String>,
}
impl CurrentRevision {
    /// <p>The revision ID of the current version of an artifact.</p>
    pub fn revision(&self) -> std::option::Option<&str> {
        self.revision.as_deref()
    }
    /// <p>The change identifier for the current revision.</p>
    pub fn change_identifier(&self) -> std::option::Option<&str> {
        self.change_identifier.as_deref()
    }
    /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The summary of the most recent revision of the artifact.</p>
    pub fn revision_summary(&self) -> std::option::Option<&str> {
        self.revision_summary.as_deref()
    }
}
impl std::fmt::Debug for CurrentRevision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CurrentRevision");
        formatter.field("revision", &self.revision);
        formatter.field("change_identifier", &self.change_identifier);
        formatter.field("created", &self.created);
        formatter.field("revision_summary", &self.revision_summary);
        formatter.finish()
    }
}
/// See [`CurrentRevision`](crate::model::CurrentRevision)
pub mod current_revision {
    /// A builder for [`CurrentRevision`](crate::model::CurrentRevision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision: std::option::Option<std::string::String>,
        pub(crate) change_identifier: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_summary: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The revision ID of the current version of an artifact.</p>
        pub fn revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision = Some(input.into());
            self
        }
        /// <p>The revision ID of the current version of an artifact.</p>
        pub fn set_revision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision = input;
            self
        }
        /// <p>The change identifier for the current revision.</p>
        pub fn change_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_identifier = Some(input.into());
            self
        }
        /// <p>The change identifier for the current revision.</p>
        pub fn set_change_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_identifier = input;
            self
        }
        /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The summary of the most recent revision of the artifact.</p>
        pub fn revision_summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_summary = Some(input.into());
            self
        }
        /// <p>The summary of the most recent revision of the artifact.</p>
        pub fn set_revision_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CurrentRevision`](crate::model::CurrentRevision)
        pub fn build(self) -> crate::model::CurrentRevision {
            crate::model::CurrentRevision {
                revision: self.revision,
                change_identifier: self.change_identifier,
                created: self.created,
                revision_summary: self.revision_summary,
            }
        }
    }
}
impl CurrentRevision {
    /// Creates a new builder-style object to manufacture [`CurrentRevision`](crate::model::CurrentRevision)
    pub fn builder() -> crate::model::current_revision::Builder {
        crate::model::current_revision::Builder::default()
    }
}

/// <p>Represents information about failure details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureDetails {
    /// <p>The type of the failure.</p>
    pub r#type: std::option::Option<crate::model::FailureType>,
    /// <p>The message about the failure.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The external ID of the run of the action that failed.</p>
    pub external_execution_id: std::option::Option<std::string::String>,
}
impl FailureDetails {
    /// <p>The type of the failure.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FailureType> {
        self.r#type.as_ref()
    }
    /// <p>The message about the failure.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The external ID of the run of the action that failed.</p>
    pub fn external_execution_id(&self) -> std::option::Option<&str> {
        self.external_execution_id.as_deref()
    }
}
impl std::fmt::Debug for FailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureDetails");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.field("external_execution_id", &self.external_execution_id);
        formatter.finish()
    }
}
/// See [`FailureDetails`](crate::model::FailureDetails)
pub mod failure_details {
    /// A builder for [`FailureDetails`](crate::model::FailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FailureType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) external_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the failure.</p>
        pub fn r#type(mut self, input: crate::model::FailureType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the failure.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FailureType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The message about the failure.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message about the failure.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The external ID of the run of the action that failed.</p>
        pub fn external_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_execution_id = Some(input.into());
            self
        }
        /// <p>The external ID of the run of the action that failed.</p>
        pub fn set_external_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureDetails`](crate::model::FailureDetails)
        pub fn build(self) -> crate::model::FailureDetails {
            crate::model::FailureDetails {
                r#type: self.r#type,
                message: self.message,
                external_execution_id: self.external_execution_id,
            }
        }
    }
}
impl FailureDetails {
    /// Creates a new builder-style object to manufacture [`FailureDetails`](crate::model::FailureDetails)
    pub fn builder() -> crate::model::failure_details::Builder {
        crate::model::failure_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailureType {
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationError,
    #[allow(missing_docs)] // documentation missing in model
    JobFailed,
    #[allow(missing_docs)] // documentation missing in model
    PermissionError,
    #[allow(missing_docs)] // documentation missing in model
    RevisionOutOfSync,
    #[allow(missing_docs)] // documentation missing in model
    RevisionUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    SystemUnavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailureType {
    fn from(s: &str) -> Self {
        match s {
            "ConfigurationError" => FailureType::ConfigurationError,
            "JobFailed" => FailureType::JobFailed,
            "PermissionError" => FailureType::PermissionError,
            "RevisionOutOfSync" => FailureType::RevisionOutOfSync,
            "RevisionUnavailable" => FailureType::RevisionUnavailable,
            "SystemUnavailable" => FailureType::SystemUnavailable,
            other => FailureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailureType::from(s))
    }
}
impl FailureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailureType::ConfigurationError => "ConfigurationError",
            FailureType::JobFailed => "JobFailed",
            FailureType::PermissionError => "PermissionError",
            FailureType::RevisionOutOfSync => "RevisionOutOfSync",
            FailureType::RevisionUnavailable => "RevisionUnavailable",
            FailureType::SystemUnavailable => "SystemUnavailable",
            FailureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ConfigurationError",
            "JobFailed",
            "PermissionError",
            "RevisionOutOfSync",
            "RevisionUnavailable",
            "SystemUnavailable",
        ]
    }
}
impl AsRef<str> for FailureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information about the result of an approval request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalResult {
    /// <p>The summary of the current status of the approval request.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>The response submitted by a reviewer assigned to an approval action request.</p>
    pub status: std::option::Option<crate::model::ApprovalStatus>,
}
impl ApprovalResult {
    /// <p>The summary of the current status of the approval request.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>The response submitted by a reviewer assigned to an approval action request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ApprovalStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ApprovalResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalResult");
        formatter.field("summary", &self.summary);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ApprovalResult`](crate::model::ApprovalResult)
pub mod approval_result {
    /// A builder for [`ApprovalResult`](crate::model::ApprovalResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ApprovalStatus>,
    }
    impl Builder {
        /// <p>The summary of the current status of the approval request.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>The summary of the current status of the approval request.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>The response submitted by a reviewer assigned to an approval action request.</p>
        pub fn status(mut self, input: crate::model::ApprovalStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The response submitted by a reviewer assigned to an approval action request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApprovalStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalResult`](crate::model::ApprovalResult)
        pub fn build(self) -> crate::model::ApprovalResult {
            crate::model::ApprovalResult {
                summary: self.summary,
                status: self.status,
            }
        }
    }
}
impl ApprovalResult {
    /// Creates a new builder-style object to manufacture [`ApprovalResult`](crate::model::ApprovalResult)
    pub fn builder() -> crate::model::approval_result::Builder {
        crate::model::approval_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApprovalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApprovalStatus {
    fn from(s: &str) -> Self {
        match s {
            "Approved" => ApprovalStatus::Approved,
            "Rejected" => ApprovalStatus::Rejected,
            other => ApprovalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApprovalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApprovalStatus::from(s))
    }
}
impl ApprovalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApprovalStatus::Approved => "Approved",
            ApprovalStatus::Rejected => "Rejected",
            ApprovalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Approved", "Rejected"]
    }
}
impl AsRef<str> for ApprovalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information about the version (or revision) of an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionRevision {
    /// <p>The system-generated unique ID that identifies the revision number of the action.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the change that set the state to this revision (for example, a deployment ID or timestamp).</p>
    pub revision_change_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the most recent version of the action was created, in timestamp format.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
}
impl ActionRevision {
    /// <p>The system-generated unique ID that identifies the revision number of the action.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The unique identifier of the change that set the state to this revision (for example, a deployment ID or timestamp).</p>
    pub fn revision_change_id(&self) -> std::option::Option<&str> {
        self.revision_change_id.as_deref()
    }
    /// <p>The date and time when the most recent version of the action was created, in timestamp format.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
}
impl std::fmt::Debug for ActionRevision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionRevision");
        formatter.field("revision_id", &self.revision_id);
        formatter.field("revision_change_id", &self.revision_change_id);
        formatter.field("created", &self.created);
        formatter.finish()
    }
}
/// See [`ActionRevision`](crate::model::ActionRevision)
pub mod action_revision {
    /// A builder for [`ActionRevision`](crate::model::ActionRevision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) revision_change_id: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The system-generated unique ID that identifies the revision number of the action.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated unique ID that identifies the revision number of the action.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The unique identifier of the change that set the state to this revision (for example, a deployment ID or timestamp).</p>
        pub fn revision_change_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_change_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the change that set the state to this revision (for example, a deployment ID or timestamp).</p>
        pub fn set_revision_change_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_change_id = input;
            self
        }
        /// <p>The date and time when the most recent version of the action was created, in timestamp format.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time when the most recent version of the action was created, in timestamp format.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionRevision`](crate::model::ActionRevision)
        pub fn build(self) -> crate::model::ActionRevision {
            crate::model::ActionRevision {
                revision_id: self.revision_id,
                revision_change_id: self.revision_change_id,
                created: self.created,
            }
        }
    }
}
impl ActionRevision {
    /// Creates a new builder-style object to manufacture [`ActionRevision`](crate::model::ActionRevision)
    pub fn builder() -> crate::model::action_revision::Builder {
        crate::model::action_revision::Builder::default()
    }
}

/// <p>A response to a <code>PollForThirdPartyJobs</code> request returned by AWS CodePipeline when there is a job to be worked on by a partner action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThirdPartyJob {
    /// <p>The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The identifier used to identify the job in AWS CodePipeline.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl ThirdPartyJob {
    /// <p>The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The identifier used to identify the job in AWS CodePipeline.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for ThirdPartyJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThirdPartyJob");
        formatter.field("client_id", &self.client_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`ThirdPartyJob`](crate::model::ThirdPartyJob)
pub mod third_party_job {
    /// A builder for [`ThirdPartyJob`](crate::model::ThirdPartyJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The identifier used to identify the job in AWS CodePipeline.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier used to identify the job in AWS CodePipeline.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ThirdPartyJob`](crate::model::ThirdPartyJob)
        pub fn build(self) -> crate::model::ThirdPartyJob {
            crate::model::ThirdPartyJob {
                client_id: self.client_id,
                job_id: self.job_id,
            }
        }
    }
}
impl ThirdPartyJob {
    /// Creates a new builder-style object to manufacture [`ThirdPartyJob`](crate::model::ThirdPartyJob)
    pub fn builder() -> crate::model::third_party_job::Builder {
        crate::model::third_party_job::Builder::default()
    }
}

/// <p>Represents information about a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>The unique system-generated ID of the job.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Other data about a job.</p>
    pub data: std::option::Option<crate::model::JobData>,
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeJob</code> request.</p>
    pub nonce: std::option::Option<std::string::String>,
    /// <p>The ID of the AWS account to use when performing the job.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl Job {
    /// <p>The unique system-generated ID of the job.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Other data about a job.</p>
    pub fn data(&self) -> std::option::Option<&crate::model::JobData> {
        self.data.as_ref()
    }
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeJob</code> request.</p>
    pub fn nonce(&self) -> std::option::Option<&str> {
        self.nonce.as_deref()
    }
    /// <p>The ID of the AWS account to use when performing the job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("id", &self.id);
        formatter.field("data", &self.data);
        formatter.field("nonce", &self.nonce);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<crate::model::JobData>,
        pub(crate) nonce: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the job.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the job.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Other data about a job.</p>
        pub fn data(mut self, input: crate::model::JobData) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>Other data about a job.</p>
        pub fn set_data(mut self, input: std::option::Option<crate::model::JobData>) -> Self {
            self.data = input;
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeJob</code> request.</p>
        pub fn nonce(mut self, input: impl Into<std::string::String>) -> Self {
            self.nonce = Some(input.into());
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeJob</code> request.</p>
        pub fn set_nonce(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nonce = input;
            self
        }
        /// <p>The ID of the AWS account to use when performing the job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS account to use when performing the job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                id: self.id,
                data: self.data,
                nonce: self.nonce,
                account_id: self.account_id,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p>Represents other information about a job required for a job worker to complete the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobData {
    /// <p>Represents information about an action type.</p>
    pub action_type_id: std::option::Option<crate::model::ActionTypeId>,
    /// <p>Represents information about an action configuration.</p>
    pub action_configuration: std::option::Option<crate::model::ActionConfiguration>,
    /// <p>Represents information about a pipeline to a job worker.</p> <note>
    /// <p>Includes <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom jobs.</p>
    /// </note>
    pub pipeline_context: std::option::Option<crate::model::PipelineContext>,
    /// <p>The artifact supplied to the job.</p>
    pub input_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
    /// <p>The output of the job.</p>
    pub output_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
    /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifacts for the pipeline in AWS CodePipeline.</p>
    pub artifact_credentials: std::option::Option<crate::model::AwsSessionCredentials>,
    /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, required by a job to continue the job asynchronously.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. </p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
}
impl JobData {
    /// <p>Represents information about an action type.</p>
    pub fn action_type_id(&self) -> std::option::Option<&crate::model::ActionTypeId> {
        self.action_type_id.as_ref()
    }
    /// <p>Represents information about an action configuration.</p>
    pub fn action_configuration(&self) -> std::option::Option<&crate::model::ActionConfiguration> {
        self.action_configuration.as_ref()
    }
    /// <p>Represents information about a pipeline to a job worker.</p> <note>
    /// <p>Includes <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom jobs.</p>
    /// </note>
    pub fn pipeline_context(&self) -> std::option::Option<&crate::model::PipelineContext> {
        self.pipeline_context.as_ref()
    }
    /// <p>The artifact supplied to the job.</p>
    pub fn input_artifacts(&self) -> std::option::Option<&[crate::model::Artifact]> {
        self.input_artifacts.as_deref()
    }
    /// <p>The output of the job.</p>
    pub fn output_artifacts(&self) -> std::option::Option<&[crate::model::Artifact]> {
        self.output_artifacts.as_deref()
    }
    /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifacts for the pipeline in AWS CodePipeline.</p>
    pub fn artifact_credentials(
        &self,
    ) -> std::option::Option<&crate::model::AwsSessionCredentials> {
        self.artifact_credentials.as_ref()
    }
    /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, required by a job to continue the job asynchronously.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. </p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
}
impl std::fmt::Debug for JobData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobData");
        formatter.field("action_type_id", &self.action_type_id);
        formatter.field("action_configuration", &self.action_configuration);
        formatter.field("pipeline_context", &self.pipeline_context);
        formatter.field("input_artifacts", &self.input_artifacts);
        formatter.field("output_artifacts", &self.output_artifacts);
        formatter.field("artifact_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.finish()
    }
}
/// See [`JobData`](crate::model::JobData)
pub mod job_data {
    /// A builder for [`JobData`](crate::model::JobData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type_id: std::option::Option<crate::model::ActionTypeId>,
        pub(crate) action_configuration: std::option::Option<crate::model::ActionConfiguration>,
        pub(crate) pipeline_context: std::option::Option<crate::model::PipelineContext>,
        pub(crate) input_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        pub(crate) output_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        pub(crate) artifact_credentials: std::option::Option<crate::model::AwsSessionCredentials>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
    }
    impl Builder {
        /// <p>Represents information about an action type.</p>
        pub fn action_type_id(mut self, input: crate::model::ActionTypeId) -> Self {
            self.action_type_id = Some(input);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.action_type_id = input;
            self
        }
        /// <p>Represents information about an action configuration.</p>
        pub fn action_configuration(mut self, input: crate::model::ActionConfiguration) -> Self {
            self.action_configuration = Some(input);
            self
        }
        /// <p>Represents information about an action configuration.</p>
        pub fn set_action_configuration(
            mut self,
            input: std::option::Option<crate::model::ActionConfiguration>,
        ) -> Self {
            self.action_configuration = input;
            self
        }
        /// <p>Represents information about a pipeline to a job worker.</p> <note>
        /// <p>Includes <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom jobs.</p>
        /// </note>
        pub fn pipeline_context(mut self, input: crate::model::PipelineContext) -> Self {
            self.pipeline_context = Some(input);
            self
        }
        /// <p>Represents information about a pipeline to a job worker.</p> <note>
        /// <p>Includes <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom jobs.</p>
        /// </note>
        pub fn set_pipeline_context(
            mut self,
            input: std::option::Option<crate::model::PipelineContext>,
        ) -> Self {
            self.pipeline_context = input;
            self
        }
        /// Appends an item to `input_artifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>The artifact supplied to the job.</p>
        pub fn input_artifacts(mut self, input: crate::model::Artifact) -> Self {
            let mut v = self.input_artifacts.unwrap_or_default();
            v.push(input);
            self.input_artifacts = Some(v);
            self
        }
        /// <p>The artifact supplied to the job.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        ) -> Self {
            self.input_artifacts = input;
            self
        }
        /// Appends an item to `output_artifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>The output of the job.</p>
        pub fn output_artifacts(mut self, input: crate::model::Artifact) -> Self {
            let mut v = self.output_artifacts.unwrap_or_default();
            v.push(input);
            self.output_artifacts = Some(v);
            self
        }
        /// <p>The output of the job.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        ) -> Self {
            self.output_artifacts = input;
            self
        }
        /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifacts for the pipeline in AWS CodePipeline.</p>
        pub fn artifact_credentials(mut self, input: crate::model::AwsSessionCredentials) -> Self {
            self.artifact_credentials = Some(input);
            self
        }
        /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifacts for the pipeline in AWS CodePipeline.</p>
        pub fn set_artifact_credentials(
            mut self,
            input: std::option::Option<crate::model::AwsSessionCredentials>,
        ) -> Self {
            self.artifact_credentials = input;
            self
        }
        /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, required by a job to continue the job asynchronously.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, required by a job to continue the job asynchronously.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. </p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Consumes the builder and constructs a [`JobData`](crate::model::JobData)
        pub fn build(self) -> crate::model::JobData {
            crate::model::JobData {
                action_type_id: self.action_type_id,
                action_configuration: self.action_configuration,
                pipeline_context: self.pipeline_context,
                input_artifacts: self.input_artifacts,
                output_artifacts: self.output_artifacts,
                artifact_credentials: self.artifact_credentials,
                continuation_token: self.continuation_token,
                encryption_key: self.encryption_key,
            }
        }
    }
}
impl JobData {
    /// Creates a new builder-style object to manufacture [`JobData`](crate::model::JobData)
    pub fn builder() -> crate::model::job_data::Builder {
        crate::model::job_data::Builder::default()
    }
}

/// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsSessionCredentials {
    /// <p>The access key for the session.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The secret access key for the session.</p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p>The token for the session.</p>
    pub session_token: std::option::Option<std::string::String>,
}
impl AwsSessionCredentials {
    /// <p>The access key for the session.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The secret access key for the session.</p>
    pub fn secret_access_key(&self) -> std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p>The token for the session.</p>
    pub fn session_token(&self) -> std::option::Option<&str> {
        self.session_token.as_deref()
    }
}
impl std::fmt::Debug for AwsSessionCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsSessionCredentials");
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AwsSessionCredentials`](crate::model::AwsSessionCredentials)
pub mod aws_session_credentials {
    /// A builder for [`AwsSessionCredentials`](crate::model::AwsSessionCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) session_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access key for the session.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The access key for the session.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The secret access key for the session.</p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p>The secret access key for the session.</p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p>The token for the session.</p>
        pub fn session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_token = Some(input.into());
            self
        }
        /// <p>The token for the session.</p>
        pub fn set_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsSessionCredentials`](crate::model::AwsSessionCredentials)
        pub fn build(self) -> crate::model::AwsSessionCredentials {
            crate::model::AwsSessionCredentials {
                access_key_id: self.access_key_id,
                secret_access_key: self.secret_access_key,
                session_token: self.session_token,
            }
        }
    }
}
impl AwsSessionCredentials {
    /// Creates a new builder-style object to manufacture [`AwsSessionCredentials`](crate::model::AwsSessionCredentials)
    pub fn builder() -> crate::model::aws_session_credentials::Builder {
        crate::model::aws_session_credentials::Builder::default()
    }
}

/// <p>Represents information about an artifact that is worked on by actions in the pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Artifact {
    /// <p>The artifact's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a revision ID (Amazon S3).</p>
    pub revision: std::option::Option<std::string::String>,
    /// <p>The location of an artifact.</p>
    pub location: std::option::Option<crate::model::ArtifactLocation>,
}
impl Artifact {
    /// <p>The artifact's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a revision ID (Amazon S3).</p>
    pub fn revision(&self) -> std::option::Option<&str> {
        self.revision.as_deref()
    }
    /// <p>The location of an artifact.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::ArtifactLocation> {
        self.location.as_ref()
    }
}
impl std::fmt::Debug for Artifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Artifact");
        formatter.field("name", &self.name);
        formatter.field("revision", &self.revision);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`Artifact`](crate::model::Artifact)
pub mod artifact {
    /// A builder for [`Artifact`](crate::model::Artifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::ArtifactLocation>,
    }
    impl Builder {
        /// <p>The artifact's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The artifact's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a revision ID (Amazon S3).</p>
        pub fn revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision = Some(input.into());
            self
        }
        /// <p>The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a revision ID (Amazon S3).</p>
        pub fn set_revision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision = input;
            self
        }
        /// <p>The location of an artifact.</p>
        pub fn location(mut self, input: crate::model::ArtifactLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of an artifact.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ArtifactLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`Artifact`](crate::model::Artifact)
        pub fn build(self) -> crate::model::Artifact {
            crate::model::Artifact {
                name: self.name,
                revision: self.revision,
                location: self.location,
            }
        }
    }
}
impl Artifact {
    /// Creates a new builder-style object to manufacture [`Artifact`](crate::model::Artifact)
    pub fn builder() -> crate::model::artifact::Builder {
        crate::model::artifact::Builder::default()
    }
}

/// <p>Represents information about the location of an artifact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactLocation {
    /// <p>The type of artifact in the location.</p>
    pub r#type: std::option::Option<crate::model::ArtifactLocationType>,
    /// <p>The S3 bucket that contains the artifact.</p>
    pub s3_location: std::option::Option<crate::model::S3ArtifactLocation>,
}
impl ArtifactLocation {
    /// <p>The type of artifact in the location.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ArtifactLocationType> {
        self.r#type.as_ref()
    }
    /// <p>The S3 bucket that contains the artifact.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3ArtifactLocation> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for ArtifactLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactLocation");
        formatter.field("r#type", &self.r#type);
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`ArtifactLocation`](crate::model::ArtifactLocation)
pub mod artifact_location {
    /// A builder for [`ArtifactLocation`](crate::model::ArtifactLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ArtifactLocationType>,
        pub(crate) s3_location: std::option::Option<crate::model::S3ArtifactLocation>,
    }
    impl Builder {
        /// <p>The type of artifact in the location.</p>
        pub fn r#type(mut self, input: crate::model::ArtifactLocationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of artifact in the location.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ArtifactLocationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The S3 bucket that contains the artifact.</p>
        pub fn s3_location(mut self, input: crate::model::S3ArtifactLocation) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The S3 bucket that contains the artifact.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3ArtifactLocation>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactLocation`](crate::model::ArtifactLocation)
        pub fn build(self) -> crate::model::ArtifactLocation {
            crate::model::ArtifactLocation {
                r#type: self.r#type,
                s3_location: self.s3_location,
            }
        }
    }
}
impl ArtifactLocation {
    /// Creates a new builder-style object to manufacture [`ArtifactLocation`](crate::model::ArtifactLocation)
    pub fn builder() -> crate::model::artifact_location::Builder {
        crate::model::artifact_location::Builder::default()
    }
}

/// <p>The location of the S3 bucket that contains a revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ArtifactLocation {
    /// <p>The name of the S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.</p>
    pub object_key: std::option::Option<std::string::String>,
}
impl S3ArtifactLocation {
    /// <p>The name of the S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.</p>
    pub fn object_key(&self) -> std::option::Option<&str> {
        self.object_key.as_deref()
    }
}
impl std::fmt::Debug for S3ArtifactLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ArtifactLocation");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("object_key", &self.object_key);
        formatter.finish()
    }
}
/// See [`S3ArtifactLocation`](crate::model::S3ArtifactLocation)
pub mod s3_artifact_location {
    /// A builder for [`S3ArtifactLocation`](crate::model::S3ArtifactLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) object_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.</p>
        pub fn object_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_key = Some(input.into());
            self
        }
        /// <p>The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.</p>
        pub fn set_object_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ArtifactLocation`](crate::model::S3ArtifactLocation)
        pub fn build(self) -> crate::model::S3ArtifactLocation {
            crate::model::S3ArtifactLocation {
                bucket_name: self.bucket_name,
                object_key: self.object_key,
            }
        }
    }
}
impl S3ArtifactLocation {
    /// Creates a new builder-style object to manufacture [`S3ArtifactLocation`](crate::model::S3ArtifactLocation)
    pub fn builder() -> crate::model::s3_artifact_location::Builder {
        crate::model::s3_artifact_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactLocationType {
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactLocationType {
    fn from(s: &str) -> Self {
        match s {
            "S3" => ArtifactLocationType::S3,
            other => ArtifactLocationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactLocationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactLocationType::from(s))
    }
}
impl ArtifactLocationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactLocationType::S3 => "S3",
            ArtifactLocationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3"]
    }
}
impl AsRef<str> for ArtifactLocationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information about a pipeline to a job worker.</p> <note>
/// <p>PipelineContext contains <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom action jobs. The <code>pipelineArn</code> and <code>pipelineExecutionId</code> fields are not populated for ThirdParty action jobs.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineContext {
    /// <p>The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline names under an Amazon Web Services account.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The stage of the pipeline.</p>
    pub stage: std::option::Option<crate::model::StageContext>,
    /// <p>The context of an action to a job worker in the stage of a pipeline.</p>
    pub action: std::option::Option<crate::model::ActionContext>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The execution ID of the pipeline.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
}
impl PipelineContext {
    /// <p>The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline names under an Amazon Web Services account.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The stage of the pipeline.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::StageContext> {
        self.stage.as_ref()
    }
    /// <p>The context of an action to a job worker in the stage of a pipeline.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ActionContext> {
        self.action.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub fn pipeline_arn(&self) -> std::option::Option<&str> {
        self.pipeline_arn.as_deref()
    }
    /// <p>The execution ID of the pipeline.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
}
impl std::fmt::Debug for PipelineContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineContext");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("stage", &self.stage);
        formatter.field("action", &self.action);
        formatter.field("pipeline_arn", &self.pipeline_arn);
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.finish()
    }
}
/// See [`PipelineContext`](crate::model::PipelineContext)
pub mod pipeline_context {
    /// A builder for [`PipelineContext`](crate::model::PipelineContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<crate::model::StageContext>,
        pub(crate) action: std::option::Option<crate::model::ActionContext>,
        pub(crate) pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline names under an Amazon Web Services account.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline names under an Amazon Web Services account.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The stage of the pipeline.</p>
        pub fn stage(mut self, input: crate::model::StageContext) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>The stage of the pipeline.</p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::StageContext>) -> Self {
            self.stage = input;
            self
        }
        /// <p>The context of an action to a job worker in the stage of a pipeline.</p>
        pub fn action(mut self, input: crate::model::ActionContext) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The context of an action to a job worker in the stage of a pipeline.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ActionContext>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn set_pipeline_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_arn = input;
            self
        }
        /// <p>The execution ID of the pipeline.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The execution ID of the pipeline.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineContext`](crate::model::PipelineContext)
        pub fn build(self) -> crate::model::PipelineContext {
            crate::model::PipelineContext {
                pipeline_name: self.pipeline_name,
                stage: self.stage,
                action: self.action,
                pipeline_arn: self.pipeline_arn,
                pipeline_execution_id: self.pipeline_execution_id,
            }
        }
    }
}
impl PipelineContext {
    /// Creates a new builder-style object to manufacture [`PipelineContext`](crate::model::PipelineContext)
    pub fn builder() -> crate::model::pipeline_context::Builder {
        crate::model::pipeline_context::Builder::default()
    }
}

/// <p>Represents the context of an action in the stage of a pipeline to a job worker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionContext {
    /// <p>The name of the action in the context of a job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The system-generated unique ID that corresponds to an action's execution.</p>
    pub action_execution_id: std::option::Option<std::string::String>,
}
impl ActionContext {
    /// <p>The name of the action in the context of a job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The system-generated unique ID that corresponds to an action's execution.</p>
    pub fn action_execution_id(&self) -> std::option::Option<&str> {
        self.action_execution_id.as_deref()
    }
}
impl std::fmt::Debug for ActionContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionContext");
        formatter.field("name", &self.name);
        formatter.field("action_execution_id", &self.action_execution_id);
        formatter.finish()
    }
}
/// See [`ActionContext`](crate::model::ActionContext)
pub mod action_context {
    /// A builder for [`ActionContext`](crate::model::ActionContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) action_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the action in the context of a job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the action in the context of a job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The system-generated unique ID that corresponds to an action's execution.</p>
        pub fn action_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_execution_id = Some(input.into());
            self
        }
        /// <p>The system-generated unique ID that corresponds to an action's execution.</p>
        pub fn set_action_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionContext`](crate::model::ActionContext)
        pub fn build(self) -> crate::model::ActionContext {
            crate::model::ActionContext {
                name: self.name,
                action_execution_id: self.action_execution_id,
            }
        }
    }
}
impl ActionContext {
    /// Creates a new builder-style object to manufacture [`ActionContext`](crate::model::ActionContext)
    pub fn builder() -> crate::model::action_context::Builder {
        crate::model::action_context::Builder::default()
    }
}

/// <p>Represents information about a stage to a job worker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageContext {
    /// <p>The name of the stage.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StageContext {
    /// <p>The name of the stage.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StageContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageContext");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`StageContext`](crate::model::StageContext)
pub mod stage_context {
    /// A builder for [`StageContext`](crate::model::StageContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stage.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StageContext`](crate::model::StageContext)
        pub fn build(self) -> crate::model::StageContext {
            crate::model::StageContext { name: self.name }
        }
    }
}
impl StageContext {
    /// Creates a new builder-style object to manufacture [`StageContext`](crate::model::StageContext)
    pub fn builder() -> crate::model::stage_context::Builder {
        crate::model::stage_context::Builder::default()
    }
}

/// <p>Represents information about an action configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionConfiguration {
    /// <p>The configuration data for the action.</p>
    pub configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ActionConfiguration {
    /// <p>The configuration data for the action.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for ActionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionConfiguration");
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`ActionConfiguration`](crate::model::ActionConfiguration)
pub mod action_configuration {
    /// A builder for [`ActionConfiguration`](crate::model::ActionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>The configuration data for the action.</p>
        pub fn configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.configuration = Some(hash_map);
            self
        }
        /// <p>The configuration data for the action.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionConfiguration`](crate::model::ActionConfiguration)
        pub fn build(self) -> crate::model::ActionConfiguration {
            crate::model::ActionConfiguration {
                configuration: self.configuration,
            }
        }
    }
}
impl ActionConfiguration {
    /// Creates a new builder-style object to manufacture [`ActionConfiguration`](crate::model::ActionConfiguration)
    pub fn builder() -> crate::model::action_configuration::Builder {
        crate::model::action_configuration::Builder::default()
    }
}

/// <p>Returns a summary of a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineSummary {
    /// <p>The name of the pipeline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version number of the pipeline.</p>
    pub version: std::option::Option<i32>,
    /// <p>The date and time the pipeline was created, in timestamp format.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time of the last update to the pipeline, in timestamp format.</p>
    pub updated: std::option::Option<aws_smithy_types::DateTime>,
}
impl PipelineSummary {
    /// <p>The name of the pipeline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version number of the pipeline.</p>
    pub fn version(&self) -> std::option::Option<i32> {
        self.version
    }
    /// <p>The date and time the pipeline was created, in timestamp format.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The date and time of the last update to the pipeline, in timestamp format.</p>
    pub fn updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated.as_ref()
    }
}
impl std::fmt::Debug for PipelineSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineSummary");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("created", &self.created);
        formatter.field("updated", &self.updated);
        formatter.finish()
    }
}
/// See [`PipelineSummary`](crate::model::PipelineSummary)
pub mod pipeline_summary {
    /// A builder for [`PipelineSummary`](crate::model::PipelineSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version number of the pipeline.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the pipeline.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// <p>The date and time the pipeline was created, in timestamp format.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time the pipeline was created, in timestamp format.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time of the last update to the pipeline, in timestamp format.</p>
        pub fn updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated = Some(input);
            self
        }
        /// <p>The date and time of the last update to the pipeline, in timestamp format.</p>
        pub fn set_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineSummary`](crate::model::PipelineSummary)
        pub fn build(self) -> crate::model::PipelineSummary {
            crate::model::PipelineSummary {
                name: self.name,
                version: self.version,
                created: self.created,
                updated: self.updated,
            }
        }
    }
}
impl PipelineSummary {
    /// Creates a new builder-style object to manufacture [`PipelineSummary`](crate::model::PipelineSummary)
    pub fn builder() -> crate::model::pipeline_summary::Builder {
        crate::model::pipeline_summary::Builder::default()
    }
}

/// <p>Summary information about a pipeline execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineExecutionSummary {
    /// <p>The ID of the pipeline execution.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
    /// <p>The status of the pipeline execution.</p>
    /// <ul>
    /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
    /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
    /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
    /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PipelineExecutionStatus>,
    /// <p>The date and time when the pipeline execution began, in timestamp format.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time of the last change to the pipeline execution, in timestamp format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of the source artifact revisions that initiated a pipeline execution.</p>
    pub source_revisions: std::option::Option<std::vec::Vec<crate::model::SourceRevision>>,
    /// <p>The interaction or event that started a pipeline execution, such as automated change detection or a <code>StartPipelineExecution</code> API call.</p>
    pub trigger: std::option::Option<crate::model::ExecutionTrigger>,
    /// <p>The interaction that stopped a pipeline execution.</p>
    pub stop_trigger: std::option::Option<crate::model::StopExecutionTrigger>,
}
impl PipelineExecutionSummary {
    /// <p>The ID of the pipeline execution.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
    /// <p>The status of the pipeline execution.</p>
    /// <ul>
    /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
    /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
    /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
    /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PipelineExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time when the pipeline execution began, in timestamp format.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time of the last change to the pipeline execution, in timestamp format.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>A list of the source artifact revisions that initiated a pipeline execution.</p>
    pub fn source_revisions(&self) -> std::option::Option<&[crate::model::SourceRevision]> {
        self.source_revisions.as_deref()
    }
    /// <p>The interaction or event that started a pipeline execution, such as automated change detection or a <code>StartPipelineExecution</code> API call.</p>
    pub fn trigger(&self) -> std::option::Option<&crate::model::ExecutionTrigger> {
        self.trigger.as_ref()
    }
    /// <p>The interaction that stopped a pipeline execution.</p>
    pub fn stop_trigger(&self) -> std::option::Option<&crate::model::StopExecutionTrigger> {
        self.stop_trigger.as_ref()
    }
}
impl std::fmt::Debug for PipelineExecutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineExecutionSummary");
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("source_revisions", &self.source_revisions);
        formatter.field("trigger", &self.trigger);
        formatter.field("stop_trigger", &self.stop_trigger);
        formatter.finish()
    }
}
/// See [`PipelineExecutionSummary`](crate::model::PipelineExecutionSummary)
pub mod pipeline_execution_summary {
    /// A builder for [`PipelineExecutionSummary`](crate::model::PipelineExecutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PipelineExecutionStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_revisions:
            std::option::Option<std::vec::Vec<crate::model::SourceRevision>>,
        pub(crate) trigger: std::option::Option<crate::model::ExecutionTrigger>,
        pub(crate) stop_trigger: std::option::Option<crate::model::StopExecutionTrigger>,
    }
    impl Builder {
        /// <p>The ID of the pipeline execution.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline execution.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// <p>The status of the pipeline execution.</p>
        /// <ul>
        /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
        /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
        /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
        /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PipelineExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the pipeline execution.</p>
        /// <ul>
        /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
        /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
        /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
        /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the pipeline execution began, in timestamp format.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time when the pipeline execution began, in timestamp format.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time of the last change to the pipeline execution, in timestamp format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The date and time of the last change to the pipeline execution, in timestamp format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Appends an item to `source_revisions`.
        ///
        /// To override the contents of this collection use [`set_source_revisions`](Self::set_source_revisions).
        ///
        /// <p>A list of the source artifact revisions that initiated a pipeline execution.</p>
        pub fn source_revisions(mut self, input: crate::model::SourceRevision) -> Self {
            let mut v = self.source_revisions.unwrap_or_default();
            v.push(input);
            self.source_revisions = Some(v);
            self
        }
        /// <p>A list of the source artifact revisions that initiated a pipeline execution.</p>
        pub fn set_source_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceRevision>>,
        ) -> Self {
            self.source_revisions = input;
            self
        }
        /// <p>The interaction or event that started a pipeline execution, such as automated change detection or a <code>StartPipelineExecution</code> API call.</p>
        pub fn trigger(mut self, input: crate::model::ExecutionTrigger) -> Self {
            self.trigger = Some(input);
            self
        }
        /// <p>The interaction or event that started a pipeline execution, such as automated change detection or a <code>StartPipelineExecution</code> API call.</p>
        pub fn set_trigger(
            mut self,
            input: std::option::Option<crate::model::ExecutionTrigger>,
        ) -> Self {
            self.trigger = input;
            self
        }
        /// <p>The interaction that stopped a pipeline execution.</p>
        pub fn stop_trigger(mut self, input: crate::model::StopExecutionTrigger) -> Self {
            self.stop_trigger = Some(input);
            self
        }
        /// <p>The interaction that stopped a pipeline execution.</p>
        pub fn set_stop_trigger(
            mut self,
            input: std::option::Option<crate::model::StopExecutionTrigger>,
        ) -> Self {
            self.stop_trigger = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineExecutionSummary`](crate::model::PipelineExecutionSummary)
        pub fn build(self) -> crate::model::PipelineExecutionSummary {
            crate::model::PipelineExecutionSummary {
                pipeline_execution_id: self.pipeline_execution_id,
                status: self.status,
                start_time: self.start_time,
                last_update_time: self.last_update_time,
                source_revisions: self.source_revisions,
                trigger: self.trigger,
                stop_trigger: self.stop_trigger,
            }
        }
    }
}
impl PipelineExecutionSummary {
    /// Creates a new builder-style object to manufacture [`PipelineExecutionSummary`](crate::model::PipelineExecutionSummary)
    pub fn builder() -> crate::model::pipeline_execution_summary::Builder {
        crate::model::pipeline_execution_summary::Builder::default()
    }
}

/// <p>The interaction that stopped a pipeline execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopExecutionTrigger {
    /// <p>The user-specified reason the pipeline was stopped.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl StopExecutionTrigger {
    /// <p>The user-specified reason the pipeline was stopped.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for StopExecutionTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopExecutionTrigger");
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`StopExecutionTrigger`](crate::model::StopExecutionTrigger)
pub mod stop_execution_trigger {
    /// A builder for [`StopExecutionTrigger`](crate::model::StopExecutionTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-specified reason the pipeline was stopped.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The user-specified reason the pipeline was stopped.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`StopExecutionTrigger`](crate::model::StopExecutionTrigger)
        pub fn build(self) -> crate::model::StopExecutionTrigger {
            crate::model::StopExecutionTrigger {
                reason: self.reason,
            }
        }
    }
}
impl StopExecutionTrigger {
    /// Creates a new builder-style object to manufacture [`StopExecutionTrigger`](crate::model::StopExecutionTrigger)
    pub fn builder() -> crate::model::stop_execution_trigger::Builder {
        crate::model::stop_execution_trigger::Builder::default()
    }
}

/// <p>The interaction or event that started a pipeline execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionTrigger {
    /// <p>The type of change-detection method, command, or user interaction that started a pipeline execution.</p>
    pub trigger_type: std::option::Option<crate::model::TriggerType>,
    /// <p>Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook that triggered the pipeline execution or the user ARN for a user-initiated <code>start-pipeline-execution</code> CLI command.</p>
    pub trigger_detail: std::option::Option<std::string::String>,
}
impl ExecutionTrigger {
    /// <p>The type of change-detection method, command, or user interaction that started a pipeline execution.</p>
    pub fn trigger_type(&self) -> std::option::Option<&crate::model::TriggerType> {
        self.trigger_type.as_ref()
    }
    /// <p>Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook that triggered the pipeline execution or the user ARN for a user-initiated <code>start-pipeline-execution</code> CLI command.</p>
    pub fn trigger_detail(&self) -> std::option::Option<&str> {
        self.trigger_detail.as_deref()
    }
}
impl std::fmt::Debug for ExecutionTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionTrigger");
        formatter.field("trigger_type", &self.trigger_type);
        formatter.field("trigger_detail", &self.trigger_detail);
        formatter.finish()
    }
}
/// See [`ExecutionTrigger`](crate::model::ExecutionTrigger)
pub mod execution_trigger {
    /// A builder for [`ExecutionTrigger`](crate::model::ExecutionTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger_type: std::option::Option<crate::model::TriggerType>,
        pub(crate) trigger_detail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of change-detection method, command, or user interaction that started a pipeline execution.</p>
        pub fn trigger_type(mut self, input: crate::model::TriggerType) -> Self {
            self.trigger_type = Some(input);
            self
        }
        /// <p>The type of change-detection method, command, or user interaction that started a pipeline execution.</p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::TriggerType>,
        ) -> Self {
            self.trigger_type = input;
            self
        }
        /// <p>Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook that triggered the pipeline execution or the user ARN for a user-initiated <code>start-pipeline-execution</code> CLI command.</p>
        pub fn trigger_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger_detail = Some(input.into());
            self
        }
        /// <p>Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook that triggered the pipeline execution or the user ARN for a user-initiated <code>start-pipeline-execution</code> CLI command.</p>
        pub fn set_trigger_detail(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trigger_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionTrigger`](crate::model::ExecutionTrigger)
        pub fn build(self) -> crate::model::ExecutionTrigger {
            crate::model::ExecutionTrigger {
                trigger_type: self.trigger_type,
                trigger_detail: self.trigger_detail,
            }
        }
    }
}
impl ExecutionTrigger {
    /// Creates a new builder-style object to manufacture [`ExecutionTrigger`](crate::model::ExecutionTrigger)
    pub fn builder() -> crate::model::execution_trigger::Builder {
        crate::model::execution_trigger::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggerType {
    #[allow(missing_docs)] // documentation missing in model
    CloudWatchEvent,
    #[allow(missing_docs)] // documentation missing in model
    CreatePipeline,
    #[allow(missing_docs)] // documentation missing in model
    PollForSourceChanges,
    #[allow(missing_docs)] // documentation missing in model
    PutActionRevision,
    #[allow(missing_docs)] // documentation missing in model
    StartPipelineExecution,
    #[allow(missing_docs)] // documentation missing in model
    Webhook,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggerType {
    fn from(s: &str) -> Self {
        match s {
            "CloudWatchEvent" => TriggerType::CloudWatchEvent,
            "CreatePipeline" => TriggerType::CreatePipeline,
            "PollForSourceChanges" => TriggerType::PollForSourceChanges,
            "PutActionRevision" => TriggerType::PutActionRevision,
            "StartPipelineExecution" => TriggerType::StartPipelineExecution,
            "Webhook" => TriggerType::Webhook,
            other => TriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggerType::from(s))
    }
}
impl TriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggerType::CloudWatchEvent => "CloudWatchEvent",
            TriggerType::CreatePipeline => "CreatePipeline",
            TriggerType::PollForSourceChanges => "PollForSourceChanges",
            TriggerType::PutActionRevision => "PutActionRevision",
            TriggerType::StartPipelineExecution => "StartPipelineExecution",
            TriggerType::Webhook => "Webhook",
            TriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CloudWatchEvent",
            "CreatePipeline",
            "PollForSourceChanges",
            "PutActionRevision",
            "StartPipelineExecution",
            "Webhook",
        ]
    }
}
impl AsRef<str> for TriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the version (or revision) of a source artifact that initiated a pipeline execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceRevision {
    /// <p>The name of the action that processed the revision to the source artifact.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The system-generated unique ID that identifies the revision number of the artifact.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
    pub revision_summary: std::option::Option<std::string::String>,
    /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
    pub revision_url: std::option::Option<std::string::String>,
}
impl SourceRevision {
    /// <p>The name of the action that processed the revision to the source artifact.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The system-generated unique ID that identifies the revision number of the artifact.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
    pub fn revision_summary(&self) -> std::option::Option<&str> {
        self.revision_summary.as_deref()
    }
    /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
    pub fn revision_url(&self) -> std::option::Option<&str> {
        self.revision_url.as_deref()
    }
}
impl std::fmt::Debug for SourceRevision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceRevision");
        formatter.field("action_name", &self.action_name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("revision_summary", &self.revision_summary);
        formatter.field("revision_url", &self.revision_url);
        formatter.finish()
    }
}
/// See [`SourceRevision`](crate::model::SourceRevision)
pub mod source_revision {
    /// A builder for [`SourceRevision`](crate::model::SourceRevision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) revision_summary: std::option::Option<std::string::String>,
        pub(crate) revision_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the action that processed the revision to the source artifact.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action that processed the revision to the source artifact.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The system-generated unique ID that identifies the revision number of the artifact.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated unique ID that identifies the revision number of the artifact.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
        pub fn revision_summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_summary = Some(input.into());
            self
        }
        /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
        pub fn set_revision_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_summary = input;
            self
        }
        /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
        pub fn revision_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_url = Some(input.into());
            self
        }
        /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
        pub fn set_revision_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_url = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceRevision`](crate::model::SourceRevision)
        pub fn build(self) -> crate::model::SourceRevision {
            crate::model::SourceRevision {
                action_name: self.action_name,
                revision_id: self.revision_id,
                revision_summary: self.revision_summary,
                revision_url: self.revision_url,
            }
        }
    }
}
impl SourceRevision {
    /// Creates a new builder-style object to manufacture [`SourceRevision`](crate::model::SourceRevision)
    pub fn builder() -> crate::model::source_revision::Builder {
        crate::model::source_revision::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PipelineExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    Superseded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PipelineExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => PipelineExecutionStatus::Cancelled,
            "Failed" => PipelineExecutionStatus::Failed,
            "InProgress" => PipelineExecutionStatus::InProgress,
            "Stopped" => PipelineExecutionStatus::Stopped,
            "Stopping" => PipelineExecutionStatus::Stopping,
            "Succeeded" => PipelineExecutionStatus::Succeeded,
            "Superseded" => PipelineExecutionStatus::Superseded,
            other => PipelineExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PipelineExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PipelineExecutionStatus::from(s))
    }
}
impl PipelineExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PipelineExecutionStatus::Cancelled => "Cancelled",
            PipelineExecutionStatus::Failed => "Failed",
            PipelineExecutionStatus::InProgress => "InProgress",
            PipelineExecutionStatus::Stopped => "Stopped",
            PipelineExecutionStatus::Stopping => "Stopping",
            PipelineExecutionStatus::Succeeded => "Succeeded",
            PipelineExecutionStatus::Superseded => "Superseded",
            PipelineExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Failed",
            "InProgress",
            "Stopped",
            "Stopping",
            "Succeeded",
            "Superseded",
        ]
    }
}
impl AsRef<str> for PipelineExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about the details of an action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionType {
    /// <p>Represents information about an action type.</p>
    pub id: std::option::Option<crate::model::ActionTypeId>,
    /// <p>The settings for the action type.</p>
    pub settings: std::option::Option<crate::model::ActionTypeSettings>,
    /// <p>The configuration properties for the action type.</p>
    pub action_configuration_properties:
        std::option::Option<std::vec::Vec<crate::model::ActionConfigurationProperty>>,
    /// <p>The details of the input artifact for the action, such as its commit ID.</p>
    pub input_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
    /// <p>The details of the output artifact of the action, such as its commit ID.</p>
    pub output_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
}
impl ActionType {
    /// <p>Represents information about an action type.</p>
    pub fn id(&self) -> std::option::Option<&crate::model::ActionTypeId> {
        self.id.as_ref()
    }
    /// <p>The settings for the action type.</p>
    pub fn settings(&self) -> std::option::Option<&crate::model::ActionTypeSettings> {
        self.settings.as_ref()
    }
    /// <p>The configuration properties for the action type.</p>
    pub fn action_configuration_properties(
        &self,
    ) -> std::option::Option<&[crate::model::ActionConfigurationProperty]> {
        self.action_configuration_properties.as_deref()
    }
    /// <p>The details of the input artifact for the action, such as its commit ID.</p>
    pub fn input_artifact_details(&self) -> std::option::Option<&crate::model::ArtifactDetails> {
        self.input_artifact_details.as_ref()
    }
    /// <p>The details of the output artifact of the action, such as its commit ID.</p>
    pub fn output_artifact_details(&self) -> std::option::Option<&crate::model::ArtifactDetails> {
        self.output_artifact_details.as_ref()
    }
}
impl std::fmt::Debug for ActionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionType");
        formatter.field("id", &self.id);
        formatter.field("settings", &self.settings);
        formatter.field(
            "action_configuration_properties",
            &self.action_configuration_properties,
        );
        formatter.field("input_artifact_details", &self.input_artifact_details);
        formatter.field("output_artifact_details", &self.output_artifact_details);
        formatter.finish()
    }
}
/// See [`ActionType`](crate::model::ActionType)
pub mod action_type {
    /// A builder for [`ActionType`](crate::model::ActionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<crate::model::ActionTypeId>,
        pub(crate) settings: std::option::Option<crate::model::ActionTypeSettings>,
        pub(crate) action_configuration_properties:
            std::option::Option<std::vec::Vec<crate::model::ActionConfigurationProperty>>,
        pub(crate) input_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
        pub(crate) output_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
    }
    impl Builder {
        /// <p>Represents information about an action type.</p>
        pub fn id(mut self, input: crate::model::ActionTypeId) -> Self {
            self.id = Some(input);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_id(mut self, input: std::option::Option<crate::model::ActionTypeId>) -> Self {
            self.id = input;
            self
        }
        /// <p>The settings for the action type.</p>
        pub fn settings(mut self, input: crate::model::ActionTypeSettings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>The settings for the action type.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::ActionTypeSettings>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Appends an item to `action_configuration_properties`.
        ///
        /// To override the contents of this collection use [`set_action_configuration_properties`](Self::set_action_configuration_properties).
        ///
        /// <p>The configuration properties for the action type.</p>
        pub fn action_configuration_properties(
            mut self,
            input: crate::model::ActionConfigurationProperty,
        ) -> Self {
            let mut v = self.action_configuration_properties.unwrap_or_default();
            v.push(input);
            self.action_configuration_properties = Some(v);
            self
        }
        /// <p>The configuration properties for the action type.</p>
        pub fn set_action_configuration_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionConfigurationProperty>>,
        ) -> Self {
            self.action_configuration_properties = input;
            self
        }
        /// <p>The details of the input artifact for the action, such as its commit ID.</p>
        pub fn input_artifact_details(mut self, input: crate::model::ArtifactDetails) -> Self {
            self.input_artifact_details = Some(input);
            self
        }
        /// <p>The details of the input artifact for the action, such as its commit ID.</p>
        pub fn set_input_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ArtifactDetails>,
        ) -> Self {
            self.input_artifact_details = input;
            self
        }
        /// <p>The details of the output artifact of the action, such as its commit ID.</p>
        pub fn output_artifact_details(mut self, input: crate::model::ArtifactDetails) -> Self {
            self.output_artifact_details = Some(input);
            self
        }
        /// <p>The details of the output artifact of the action, such as its commit ID.</p>
        pub fn set_output_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ArtifactDetails>,
        ) -> Self {
            self.output_artifact_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionType`](crate::model::ActionType)
        pub fn build(self) -> crate::model::ActionType {
            crate::model::ActionType {
                id: self.id,
                settings: self.settings,
                action_configuration_properties: self.action_configuration_properties,
                input_artifact_details: self.input_artifact_details,
                output_artifact_details: self.output_artifact_details,
            }
        }
    }
}
impl ActionType {
    /// Creates a new builder-style object to manufacture [`ActionType`](crate::model::ActionType)
    pub fn builder() -> crate::model::action_type::Builder {
        crate::model::action_type::Builder::default()
    }
}

/// <p>Returns information about the details of an artifact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactDetails {
    /// <p>The minimum number of artifacts allowed for the action type.</p>
    pub minimum_count: i32,
    /// <p>The maximum number of artifacts allowed for the action type.</p>
    pub maximum_count: i32,
}
impl ArtifactDetails {
    /// <p>The minimum number of artifacts allowed for the action type.</p>
    pub fn minimum_count(&self) -> i32 {
        self.minimum_count
    }
    /// <p>The maximum number of artifacts allowed for the action type.</p>
    pub fn maximum_count(&self) -> i32 {
        self.maximum_count
    }
}
impl std::fmt::Debug for ArtifactDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactDetails");
        formatter.field("minimum_count", &self.minimum_count);
        formatter.field("maximum_count", &self.maximum_count);
        formatter.finish()
    }
}
/// See [`ArtifactDetails`](crate::model::ArtifactDetails)
pub mod artifact_details {
    /// A builder for [`ArtifactDetails`](crate::model::ArtifactDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_count: std::option::Option<i32>,
        pub(crate) maximum_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum number of artifacts allowed for the action type.</p>
        pub fn minimum_count(mut self, input: i32) -> Self {
            self.minimum_count = Some(input);
            self
        }
        /// <p>The minimum number of artifacts allowed for the action type.</p>
        pub fn set_minimum_count(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_count = input;
            self
        }
        /// <p>The maximum number of artifacts allowed for the action type.</p>
        pub fn maximum_count(mut self, input: i32) -> Self {
            self.maximum_count = Some(input);
            self
        }
        /// <p>The maximum number of artifacts allowed for the action type.</p>
        pub fn set_maximum_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactDetails`](crate::model::ArtifactDetails)
        pub fn build(self) -> crate::model::ArtifactDetails {
            crate::model::ArtifactDetails {
                minimum_count: self.minimum_count.unwrap_or_default(),
                maximum_count: self.maximum_count.unwrap_or_default(),
            }
        }
    }
}
impl ArtifactDetails {
    /// Creates a new builder-style object to manufacture [`ArtifactDetails`](crate::model::ArtifactDetails)
    pub fn builder() -> crate::model::artifact_details::Builder {
        crate::model::artifact_details::Builder::default()
    }
}

/// <p>Represents information about an action configuration property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionConfigurationProperty {
    /// <p>The name of the action configuration property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Whether the configuration property is a required value.</p>
    pub required: bool,
    /// <p>Whether the configuration property is a key.</p>
    pub key: bool,
    /// <p>Whether the configuration property is secret. Secrets are hidden from all calls except for <code>GetJobDetails</code>, <code>GetThirdPartyJobDetails</code>, <code>PollForJobs</code>, and <code>PollForThirdPartyJobs</code>.</p>
    /// <p>When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.</p>
    pub secret: bool,
    /// <p>Indicates that the property is used with <code>PollForJobs</code>. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
    /// <p>If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.</p>
    pub queryable: bool,
    /// <p>The description of the action configuration property that is displayed to users.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the configuration property.</p>
    pub r#type: std::option::Option<crate::model::ActionConfigurationPropertyType>,
}
impl ActionConfigurationProperty {
    /// <p>The name of the action configuration property.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Whether the configuration property is a required value.</p>
    pub fn required(&self) -> bool {
        self.required
    }
    /// <p>Whether the configuration property is a key.</p>
    pub fn key(&self) -> bool {
        self.key
    }
    /// <p>Whether the configuration property is secret. Secrets are hidden from all calls except for <code>GetJobDetails</code>, <code>GetThirdPartyJobDetails</code>, <code>PollForJobs</code>, and <code>PollForThirdPartyJobs</code>.</p>
    /// <p>When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.</p>
    pub fn secret(&self) -> bool {
        self.secret
    }
    /// <p>Indicates that the property is used with <code>PollForJobs</code>. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
    /// <p>If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.</p>
    pub fn queryable(&self) -> bool {
        self.queryable
    }
    /// <p>The description of the action configuration property that is displayed to users.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the configuration property.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ActionConfigurationPropertyType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ActionConfigurationProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionConfigurationProperty");
        formatter.field("name", &self.name);
        formatter.field("required", &self.required);
        formatter.field("key", &self.key);
        formatter.field("secret", &self.secret);
        formatter.field("queryable", &self.queryable);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ActionConfigurationProperty`](crate::model::ActionConfigurationProperty)
pub mod action_configuration_property {
    /// A builder for [`ActionConfigurationProperty`](crate::model::ActionConfigurationProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) required: std::option::Option<bool>,
        pub(crate) key: std::option::Option<bool>,
        pub(crate) secret: std::option::Option<bool>,
        pub(crate) queryable: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ActionConfigurationPropertyType>,
    }
    impl Builder {
        /// <p>The name of the action configuration property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the action configuration property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Whether the configuration property is a required value.</p>
        pub fn required(mut self, input: bool) -> Self {
            self.required = Some(input);
            self
        }
        /// <p>Whether the configuration property is a required value.</p>
        pub fn set_required(mut self, input: std::option::Option<bool>) -> Self {
            self.required = input;
            self
        }
        /// <p>Whether the configuration property is a key.</p>
        pub fn key(mut self, input: bool) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>Whether the configuration property is a key.</p>
        pub fn set_key(mut self, input: std::option::Option<bool>) -> Self {
            self.key = input;
            self
        }
        /// <p>Whether the configuration property is secret. Secrets are hidden from all calls except for <code>GetJobDetails</code>, <code>GetThirdPartyJobDetails</code>, <code>PollForJobs</code>, and <code>PollForThirdPartyJobs</code>.</p>
        /// <p>When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.</p>
        pub fn secret(mut self, input: bool) -> Self {
            self.secret = Some(input);
            self
        }
        /// <p>Whether the configuration property is secret. Secrets are hidden from all calls except for <code>GetJobDetails</code>, <code>GetThirdPartyJobDetails</code>, <code>PollForJobs</code>, and <code>PollForThirdPartyJobs</code>.</p>
        /// <p>When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.</p>
        pub fn set_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.secret = input;
            self
        }
        /// <p>Indicates that the property is used with <code>PollForJobs</code>. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
        /// <p>If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.</p>
        pub fn queryable(mut self, input: bool) -> Self {
            self.queryable = Some(input);
            self
        }
        /// <p>Indicates that the property is used with <code>PollForJobs</code>. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.</p>
        /// <p>If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.</p>
        pub fn set_queryable(mut self, input: std::option::Option<bool>) -> Self {
            self.queryable = input;
            self
        }
        /// <p>The description of the action configuration property that is displayed to users.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the action configuration property that is displayed to users.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the configuration property.</p>
        pub fn r#type(mut self, input: crate::model::ActionConfigurationPropertyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the configuration property.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ActionConfigurationPropertyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionConfigurationProperty`](crate::model::ActionConfigurationProperty)
        pub fn build(self) -> crate::model::ActionConfigurationProperty {
            crate::model::ActionConfigurationProperty {
                name: self.name,
                required: self.required.unwrap_or_default(),
                key: self.key.unwrap_or_default(),
                secret: self.secret.unwrap_or_default(),
                queryable: self.queryable.unwrap_or_default(),
                description: self.description,
                r#type: self.r#type,
            }
        }
    }
}
impl ActionConfigurationProperty {
    /// Creates a new builder-style object to manufacture [`ActionConfigurationProperty`](crate::model::ActionConfigurationProperty)
    pub fn builder() -> crate::model::action_configuration_property::Builder {
        crate::model::action_configuration_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionConfigurationPropertyType {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionConfigurationPropertyType {
    fn from(s: &str) -> Self {
        match s {
            "Boolean" => ActionConfigurationPropertyType::Boolean,
            "Number" => ActionConfigurationPropertyType::Number,
            "String" => ActionConfigurationPropertyType::String,
            other => ActionConfigurationPropertyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionConfigurationPropertyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionConfigurationPropertyType::from(s))
    }
}
impl ActionConfigurationPropertyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionConfigurationPropertyType::Boolean => "Boolean",
            ActionConfigurationPropertyType::Number => "Number",
            ActionConfigurationPropertyType::String => "String",
            ActionConfigurationPropertyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Boolean", "Number", "String"]
    }
}
impl AsRef<str> for ActionConfigurationPropertyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about the settings for an action type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeSettings {
    /// <p>The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.</p>
    pub third_party_configuration_url: std::option::Option<std::string::String>,
    /// <p>The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline.</p>
    pub entity_url_template: std::option::Option<std::string::String>,
    /// <p>The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.</p>
    pub execution_url_template: std::option::Option<std::string::String>,
    /// <p>The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
    pub revision_url_template: std::option::Option<std::string::String>,
}
impl ActionTypeSettings {
    /// <p>The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.</p>
    pub fn third_party_configuration_url(&self) -> std::option::Option<&str> {
        self.third_party_configuration_url.as_deref()
    }
    /// <p>The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline.</p>
    pub fn entity_url_template(&self) -> std::option::Option<&str> {
        self.entity_url_template.as_deref()
    }
    /// <p>The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.</p>
    pub fn execution_url_template(&self) -> std::option::Option<&str> {
        self.execution_url_template.as_deref()
    }
    /// <p>The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
    pub fn revision_url_template(&self) -> std::option::Option<&str> {
        self.revision_url_template.as_deref()
    }
}
impl std::fmt::Debug for ActionTypeSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeSettings");
        formatter.field(
            "third_party_configuration_url",
            &self.third_party_configuration_url,
        );
        formatter.field("entity_url_template", &self.entity_url_template);
        formatter.field("execution_url_template", &self.execution_url_template);
        formatter.field("revision_url_template", &self.revision_url_template);
        formatter.finish()
    }
}
/// See [`ActionTypeSettings`](crate::model::ActionTypeSettings)
pub mod action_type_settings {
    /// A builder for [`ActionTypeSettings`](crate::model::ActionTypeSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) third_party_configuration_url: std::option::Option<std::string::String>,
        pub(crate) entity_url_template: std::option::Option<std::string::String>,
        pub(crate) execution_url_template: std::option::Option<std::string::String>,
        pub(crate) revision_url_template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.</p>
        pub fn third_party_configuration_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.third_party_configuration_url = Some(input.into());
            self
        }
        /// <p>The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.</p>
        pub fn set_third_party_configuration_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.third_party_configuration_url = input;
            self
        }
        /// <p>The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline.</p>
        pub fn entity_url_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_url_template = Some(input.into());
            self
        }
        /// <p>The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline.</p>
        pub fn set_entity_url_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_url_template = input;
            self
        }
        /// <p>The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.</p>
        pub fn execution_url_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_url_template = Some(input.into());
            self
        }
        /// <p>The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.</p>
        pub fn set_execution_url_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_url_template = input;
            self
        }
        /// <p>The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
        pub fn revision_url_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_url_template = Some(input.into());
            self
        }
        /// <p>The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>
        pub fn set_revision_url_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_url_template = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeSettings`](crate::model::ActionTypeSettings)
        pub fn build(self) -> crate::model::ActionTypeSettings {
            crate::model::ActionTypeSettings {
                third_party_configuration_url: self.third_party_configuration_url,
                entity_url_template: self.entity_url_template,
                execution_url_template: self.execution_url_template,
                revision_url_template: self.revision_url_template,
            }
        }
    }
}
impl ActionTypeSettings {
    /// Creates a new builder-style object to manufacture [`ActionTypeSettings`](crate::model::ActionTypeSettings)
    pub fn builder() -> crate::model::action_type_settings::Builder {
        crate::model::action_type_settings::Builder::default()
    }
}

/// <p>Returns information about an execution of an action, including the action execution ID, and the name, version, and timing of the action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionExecutionDetail {
    /// <p>The pipeline execution ID for the action execution.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
    /// <p>The action execution ID.</p>
    pub action_execution_id: std::option::Option<std::string::String>,
    /// <p>The version of the pipeline where the action was run.</p>
    pub pipeline_version: std::option::Option<i32>,
    /// <p>The name of the stage that contains the action.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The name of the action.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The start time of the action execution.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last update time of the action execution.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and <code>Failed</code>.</p>
    pub status: std::option::Option<crate::model::ActionExecutionStatus>,
    /// <p>Input details for the action execution, such as role ARN, Region, and input artifacts.</p>
    pub input: std::option::Option<crate::model::ActionExecutionInput>,
    /// <p>Output details for the action execution, such as the action execution result.</p>
    pub output: std::option::Option<crate::model::ActionExecutionOutput>,
}
impl ActionExecutionDetail {
    /// <p>The pipeline execution ID for the action execution.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
    /// <p>The action execution ID.</p>
    pub fn action_execution_id(&self) -> std::option::Option<&str> {
        self.action_execution_id.as_deref()
    }
    /// <p>The version of the pipeline where the action was run.</p>
    pub fn pipeline_version(&self) -> std::option::Option<i32> {
        self.pipeline_version
    }
    /// <p>The name of the stage that contains the action.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The name of the action.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The start time of the action execution.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The last update time of the action execution.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p> The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and <code>Failed</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ActionExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>Input details for the action execution, such as role ARN, Region, and input artifacts.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::ActionExecutionInput> {
        self.input.as_ref()
    }
    /// <p>Output details for the action execution, such as the action execution result.</p>
    pub fn output(&self) -> std::option::Option<&crate::model::ActionExecutionOutput> {
        self.output.as_ref()
    }
}
impl std::fmt::Debug for ActionExecutionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionExecutionDetail");
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.field("action_execution_id", &self.action_execution_id);
        formatter.field("pipeline_version", &self.pipeline_version);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("action_name", &self.action_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.field("input", &self.input);
        formatter.field("output", &self.output);
        formatter.finish()
    }
}
/// See [`ActionExecutionDetail`](crate::model::ActionExecutionDetail)
pub mod action_execution_detail {
    /// A builder for [`ActionExecutionDetail`](crate::model::ActionExecutionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
        pub(crate) action_execution_id: std::option::Option<std::string::String>,
        pub(crate) pipeline_version: std::option::Option<i32>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ActionExecutionStatus>,
        pub(crate) input: std::option::Option<crate::model::ActionExecutionInput>,
        pub(crate) output: std::option::Option<crate::model::ActionExecutionOutput>,
    }
    impl Builder {
        /// <p>The pipeline execution ID for the action execution.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The pipeline execution ID for the action execution.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// <p>The action execution ID.</p>
        pub fn action_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_execution_id = Some(input.into());
            self
        }
        /// <p>The action execution ID.</p>
        pub fn set_action_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_execution_id = input;
            self
        }
        /// <p>The version of the pipeline where the action was run.</p>
        pub fn pipeline_version(mut self, input: i32) -> Self {
            self.pipeline_version = Some(input);
            self
        }
        /// <p>The version of the pipeline where the action was run.</p>
        pub fn set_pipeline_version(mut self, input: std::option::Option<i32>) -> Self {
            self.pipeline_version = input;
            self
        }
        /// <p>The name of the stage that contains the action.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage that contains the action.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The name of the action.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The start time of the action execution.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the action execution.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The last update time of the action execution.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last update time of the action execution.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p> The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and <code>Failed</code>.</p>
        pub fn status(mut self, input: crate::model::ActionExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and <code>Failed</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Input details for the action execution, such as role ARN, Region, and input artifacts.</p>
        pub fn input(mut self, input: crate::model::ActionExecutionInput) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>Input details for the action execution, such as role ARN, Region, and input artifacts.</p>
        pub fn set_input(
            mut self,
            input: std::option::Option<crate::model::ActionExecutionInput>,
        ) -> Self {
            self.input = input;
            self
        }
        /// <p>Output details for the action execution, such as the action execution result.</p>
        pub fn output(mut self, input: crate::model::ActionExecutionOutput) -> Self {
            self.output = Some(input);
            self
        }
        /// <p>Output details for the action execution, such as the action execution result.</p>
        pub fn set_output(
            mut self,
            input: std::option::Option<crate::model::ActionExecutionOutput>,
        ) -> Self {
            self.output = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionExecutionDetail`](crate::model::ActionExecutionDetail)
        pub fn build(self) -> crate::model::ActionExecutionDetail {
            crate::model::ActionExecutionDetail {
                pipeline_execution_id: self.pipeline_execution_id,
                action_execution_id: self.action_execution_id,
                pipeline_version: self.pipeline_version,
                stage_name: self.stage_name,
                action_name: self.action_name,
                start_time: self.start_time,
                last_update_time: self.last_update_time,
                status: self.status,
                input: self.input,
                output: self.output,
            }
        }
    }
}
impl ActionExecutionDetail {
    /// Creates a new builder-style object to manufacture [`ActionExecutionDetail`](crate::model::ActionExecutionDetail)
    pub fn builder() -> crate::model::action_execution_detail::Builder {
        crate::model::action_execution_detail::Builder::default()
    }
}

/// <p>Output details listed for an action execution, such as the action execution result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionExecutionOutput {
    /// <p>Details of output artifacts of the action that correspond to the action execution.</p>
    pub output_artifacts: std::option::Option<std::vec::Vec<crate::model::ArtifactDetail>>,
    /// <p>Execution result information listed in the output details for an action execution.</p>
    pub execution_result: std::option::Option<crate::model::ActionExecutionResult>,
    /// <p>The outputVariables field shows the key-value pairs that were output as part of that execution.</p>
    pub output_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ActionExecutionOutput {
    /// <p>Details of output artifacts of the action that correspond to the action execution.</p>
    pub fn output_artifacts(&self) -> std::option::Option<&[crate::model::ArtifactDetail]> {
        self.output_artifacts.as_deref()
    }
    /// <p>Execution result information listed in the output details for an action execution.</p>
    pub fn execution_result(&self) -> std::option::Option<&crate::model::ActionExecutionResult> {
        self.execution_result.as_ref()
    }
    /// <p>The outputVariables field shows the key-value pairs that were output as part of that execution.</p>
    pub fn output_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.output_variables.as_ref()
    }
}
impl std::fmt::Debug for ActionExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionExecutionOutput");
        formatter.field("output_artifacts", &self.output_artifacts);
        formatter.field("execution_result", &self.execution_result);
        formatter.field("output_variables", &self.output_variables);
        formatter.finish()
    }
}
/// See [`ActionExecutionOutput`](crate::model::ActionExecutionOutput)
pub mod action_execution_output {
    /// A builder for [`ActionExecutionOutput`](crate::model::ActionExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_artifacts:
            std::option::Option<std::vec::Vec<crate::model::ArtifactDetail>>,
        pub(crate) execution_result: std::option::Option<crate::model::ActionExecutionResult>,
        pub(crate) output_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `output_artifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>Details of output artifacts of the action that correspond to the action execution.</p>
        pub fn output_artifacts(mut self, input: crate::model::ArtifactDetail) -> Self {
            let mut v = self.output_artifacts.unwrap_or_default();
            v.push(input);
            self.output_artifacts = Some(v);
            self
        }
        /// <p>Details of output artifacts of the action that correspond to the action execution.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ArtifactDetail>>,
        ) -> Self {
            self.output_artifacts = input;
            self
        }
        /// <p>Execution result information listed in the output details for an action execution.</p>
        pub fn execution_result(mut self, input: crate::model::ActionExecutionResult) -> Self {
            self.execution_result = Some(input);
            self
        }
        /// <p>Execution result information listed in the output details for an action execution.</p>
        pub fn set_execution_result(
            mut self,
            input: std::option::Option<crate::model::ActionExecutionResult>,
        ) -> Self {
            self.execution_result = input;
            self
        }
        /// Adds a key-value pair to `output_variables`.
        ///
        /// To override the contents of this collection use [`set_output_variables`](Self::set_output_variables).
        ///
        /// <p>The outputVariables field shows the key-value pairs that were output as part of that execution.</p>
        pub fn output_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.output_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.output_variables = Some(hash_map);
            self
        }
        /// <p>The outputVariables field shows the key-value pairs that were output as part of that execution.</p>
        pub fn set_output_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.output_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionExecutionOutput`](crate::model::ActionExecutionOutput)
        pub fn build(self) -> crate::model::ActionExecutionOutput {
            crate::model::ActionExecutionOutput {
                output_artifacts: self.output_artifacts,
                execution_result: self.execution_result,
                output_variables: self.output_variables,
            }
        }
    }
}
impl ActionExecutionOutput {
    /// Creates a new builder-style object to manufacture [`ActionExecutionOutput`](crate::model::ActionExecutionOutput)
    pub fn builder() -> crate::model::action_execution_output::Builder {
        crate::model::action_execution_output::Builder::default()
    }
}

/// <p>Execution result information, such as the external execution ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionExecutionResult {
    /// <p>The action provider's external ID for the action execution.</p>
    pub external_execution_id: std::option::Option<std::string::String>,
    /// <p>The action provider's summary for the action execution.</p>
    pub external_execution_summary: std::option::Option<std::string::String>,
    /// <p>The deepest external link to the external resource (for example, a repository URL or deployment endpoint) that is used when running the action.</p>
    pub external_execution_url: std::option::Option<std::string::String>,
}
impl ActionExecutionResult {
    /// <p>The action provider's external ID for the action execution.</p>
    pub fn external_execution_id(&self) -> std::option::Option<&str> {
        self.external_execution_id.as_deref()
    }
    /// <p>The action provider's summary for the action execution.</p>
    pub fn external_execution_summary(&self) -> std::option::Option<&str> {
        self.external_execution_summary.as_deref()
    }
    /// <p>The deepest external link to the external resource (for example, a repository URL or deployment endpoint) that is used when running the action.</p>
    pub fn external_execution_url(&self) -> std::option::Option<&str> {
        self.external_execution_url.as_deref()
    }
}
impl std::fmt::Debug for ActionExecutionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionExecutionResult");
        formatter.field("external_execution_id", &self.external_execution_id);
        formatter.field(
            "external_execution_summary",
            &self.external_execution_summary,
        );
        formatter.field("external_execution_url", &self.external_execution_url);
        formatter.finish()
    }
}
/// See [`ActionExecutionResult`](crate::model::ActionExecutionResult)
pub mod action_execution_result {
    /// A builder for [`ActionExecutionResult`](crate::model::ActionExecutionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_execution_id: std::option::Option<std::string::String>,
        pub(crate) external_execution_summary: std::option::Option<std::string::String>,
        pub(crate) external_execution_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action provider's external ID for the action execution.</p>
        pub fn external_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_execution_id = Some(input.into());
            self
        }
        /// <p>The action provider's external ID for the action execution.</p>
        pub fn set_external_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_execution_id = input;
            self
        }
        /// <p>The action provider's summary for the action execution.</p>
        pub fn external_execution_summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_execution_summary = Some(input.into());
            self
        }
        /// <p>The action provider's summary for the action execution.</p>
        pub fn set_external_execution_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_execution_summary = input;
            self
        }
        /// <p>The deepest external link to the external resource (for example, a repository URL or deployment endpoint) that is used when running the action.</p>
        pub fn external_execution_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_execution_url = Some(input.into());
            self
        }
        /// <p>The deepest external link to the external resource (for example, a repository URL or deployment endpoint) that is used when running the action.</p>
        pub fn set_external_execution_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_execution_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionExecutionResult`](crate::model::ActionExecutionResult)
        pub fn build(self) -> crate::model::ActionExecutionResult {
            crate::model::ActionExecutionResult {
                external_execution_id: self.external_execution_id,
                external_execution_summary: self.external_execution_summary,
                external_execution_url: self.external_execution_url,
            }
        }
    }
}
impl ActionExecutionResult {
    /// Creates a new builder-style object to manufacture [`ActionExecutionResult`](crate::model::ActionExecutionResult)
    pub fn builder() -> crate::model::action_execution_result::Builder {
        crate::model::action_execution_result::Builder::default()
    }
}

/// <p>Artifact details for the action execution, such as the artifact location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactDetail {
    /// <p>The artifact object name for the action execution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 artifact location for the action execution.</p>
    pub s3location: std::option::Option<crate::model::S3Location>,
}
impl ArtifactDetail {
    /// <p>The artifact object name for the action execution.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon S3 artifact location for the action execution.</p>
    pub fn s3location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3location.as_ref()
    }
}
impl std::fmt::Debug for ArtifactDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactDetail");
        formatter.field("name", &self.name);
        formatter.field("s3location", &self.s3location);
        formatter.finish()
    }
}
/// See [`ArtifactDetail`](crate::model::ArtifactDetail)
pub mod artifact_detail {
    /// A builder for [`ArtifactDetail`](crate::model::ArtifactDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The artifact object name for the action execution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The artifact object name for the action execution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon S3 artifact location for the action execution.</p>
        pub fn s3location(mut self, input: crate::model::S3Location) -> Self {
            self.s3location = Some(input);
            self
        }
        /// <p>The Amazon S3 artifact location for the action execution.</p>
        pub fn set_s3location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3location = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactDetail`](crate::model::ArtifactDetail)
        pub fn build(self) -> crate::model::ArtifactDetail {
            crate::model::ArtifactDetail {
                name: self.name,
                s3location: self.s3location,
            }
        }
    }
}
impl ArtifactDetail {
    /// Creates a new builder-style object to manufacture [`ArtifactDetail`](crate::model::ArtifactDetail)
    pub fn builder() -> crate::model::artifact_detail::Builder {
        crate::model::artifact_detail::Builder::default()
    }
}

/// <p>The Amazon S3 artifact location for an action's artifacts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The Amazon S3 artifact bucket for an action's artifacts.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The artifact name.</p>
    pub key: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The Amazon S3 artifact bucket for an action's artifacts.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The artifact name.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 artifact bucket for an action's artifacts.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 artifact bucket for an action's artifacts.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The artifact name.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The artifact name.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>Input information used for an action execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionExecutionInput {
    /// <p>Represents information about an action type.</p>
    pub action_type_id: std::option::Option<crate::model::ActionTypeId>,
    /// <p>Configuration data for an action execution.</p>
    pub configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Configuration data for an action execution with all variable references replaced with their real values for the execution.</p>
    pub resolved_configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The AWS Region for the action, such as us-east-1.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Details of input artifacts of the action that correspond to the action execution.</p>
    pub input_artifacts: std::option::Option<std::vec::Vec<crate::model::ArtifactDetail>>,
    /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
    pub namespace: std::option::Option<std::string::String>,
}
impl ActionExecutionInput {
    /// <p>Represents information about an action type.</p>
    pub fn action_type_id(&self) -> std::option::Option<&crate::model::ActionTypeId> {
        self.action_type_id.as_ref()
    }
    /// <p>Configuration data for an action execution.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.configuration.as_ref()
    }
    /// <p>Configuration data for an action execution with all variable references replaced with their real values for the execution.</p>
    pub fn resolved_configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resolved_configuration.as_ref()
    }
    /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The AWS Region for the action, such as us-east-1.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>Details of input artifacts of the action that correspond to the action execution.</p>
    pub fn input_artifacts(&self) -> std::option::Option<&[crate::model::ArtifactDetail]> {
        self.input_artifacts.as_deref()
    }
    /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
}
impl std::fmt::Debug for ActionExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionExecutionInput");
        formatter.field("action_type_id", &self.action_type_id);
        formatter.field("configuration", &self.configuration);
        formatter.field("resolved_configuration", &self.resolved_configuration);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("region", &self.region);
        formatter.field("input_artifacts", &self.input_artifacts);
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`ActionExecutionInput`](crate::model::ActionExecutionInput)
pub mod action_execution_input {
    /// A builder for [`ActionExecutionInput`](crate::model::ActionExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type_id: std::option::Option<crate::model::ActionTypeId>,
        pub(crate) configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) resolved_configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) input_artifacts:
            std::option::Option<std::vec::Vec<crate::model::ArtifactDetail>>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents information about an action type.</p>
        pub fn action_type_id(mut self, input: crate::model::ActionTypeId) -> Self {
            self.action_type_id = Some(input);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.action_type_id = input;
            self
        }
        /// Adds a key-value pair to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>Configuration data for an action execution.</p>
        pub fn configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.configuration = Some(hash_map);
            self
        }
        /// <p>Configuration data for an action execution.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Adds a key-value pair to `resolved_configuration`.
        ///
        /// To override the contents of this collection use [`set_resolved_configuration`](Self::set_resolved_configuration).
        ///
        /// <p>Configuration data for an action execution with all variable references replaced with their real values for the execution.</p>
        pub fn resolved_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resolved_configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resolved_configuration = Some(hash_map);
            self
        }
        /// <p>Configuration data for an action execution with all variable references replaced with their real values for the execution.</p>
        pub fn set_resolved_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resolved_configuration = input;
            self
        }
        /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The AWS Region for the action, such as us-east-1.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The AWS Region for the action, such as us-east-1.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Appends an item to `input_artifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>Details of input artifacts of the action that correspond to the action execution.</p>
        pub fn input_artifacts(mut self, input: crate::model::ArtifactDetail) -> Self {
            let mut v = self.input_artifacts.unwrap_or_default();
            v.push(input);
            self.input_artifacts = Some(v);
            self
        }
        /// <p>Details of input artifacts of the action that correspond to the action execution.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ArtifactDetail>>,
        ) -> Self {
            self.input_artifacts = input;
            self
        }
        /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionExecutionInput`](crate::model::ActionExecutionInput)
        pub fn build(self) -> crate::model::ActionExecutionInput {
            crate::model::ActionExecutionInput {
                action_type_id: self.action_type_id,
                configuration: self.configuration,
                resolved_configuration: self.resolved_configuration,
                role_arn: self.role_arn,
                region: self.region,
                input_artifacts: self.input_artifacts,
                namespace: self.namespace,
            }
        }
    }
}
impl ActionExecutionInput {
    /// Creates a new builder-style object to manufacture [`ActionExecutionInput`](crate::model::ActionExecutionInput)
    pub fn builder() -> crate::model::action_execution_input::Builder {
        crate::model::action_execution_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Abandoned,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Abandoned" => ActionExecutionStatus::Abandoned,
            "Failed" => ActionExecutionStatus::Failed,
            "InProgress" => ActionExecutionStatus::InProgress,
            "Succeeded" => ActionExecutionStatus::Succeeded,
            other => ActionExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionExecutionStatus::from(s))
    }
}
impl ActionExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionExecutionStatus::Abandoned => "Abandoned",
            ActionExecutionStatus::Failed => "Failed",
            ActionExecutionStatus::InProgress => "InProgress",
            ActionExecutionStatus::Succeeded => "Succeeded",
            ActionExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Abandoned", "Failed", "InProgress", "Succeeded"]
    }
}
impl AsRef<str> for ActionExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filter values for the action execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionExecutionFilter {
    /// <p>The pipeline execution ID used to filter action execution history.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
}
impl ActionExecutionFilter {
    /// <p>The pipeline execution ID used to filter action execution history.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
}
impl std::fmt::Debug for ActionExecutionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionExecutionFilter");
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.finish()
    }
}
/// See [`ActionExecutionFilter`](crate::model::ActionExecutionFilter)
pub mod action_execution_filter {
    /// A builder for [`ActionExecutionFilter`](crate::model::ActionExecutionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pipeline execution ID used to filter action execution history.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The pipeline execution ID used to filter action execution history.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionExecutionFilter`](crate::model::ActionExecutionFilter)
        pub fn build(self) -> crate::model::ActionExecutionFilter {
            crate::model::ActionExecutionFilter {
                pipeline_execution_id: self.pipeline_execution_id,
            }
        }
    }
}
impl ActionExecutionFilter {
    /// Creates a new builder-style object to manufacture [`ActionExecutionFilter`](crate::model::ActionExecutionFilter)
    pub fn builder() -> crate::model::action_execution_filter::Builder {
        crate::model::action_execution_filter::Builder::default()
    }
}

/// <p>The details of a job sent in response to a <code>GetThirdPartyJobDetails</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThirdPartyJobDetails {
    /// <p>The identifier used to identify the job details in AWS CodePipeline.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The data to be returned by the third party job worker.</p>
    pub data: std::option::Option<crate::model::ThirdPartyJobData>,
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeThirdPartyJob</code> request.</p>
    pub nonce: std::option::Option<std::string::String>,
}
impl ThirdPartyJobDetails {
    /// <p>The identifier used to identify the job details in AWS CodePipeline.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The data to be returned by the third party job worker.</p>
    pub fn data(&self) -> std::option::Option<&crate::model::ThirdPartyJobData> {
        self.data.as_ref()
    }
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeThirdPartyJob</code> request.</p>
    pub fn nonce(&self) -> std::option::Option<&str> {
        self.nonce.as_deref()
    }
}
impl std::fmt::Debug for ThirdPartyJobDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThirdPartyJobDetails");
        formatter.field("id", &self.id);
        formatter.field("data", &self.data);
        formatter.field("nonce", &self.nonce);
        formatter.finish()
    }
}
/// See [`ThirdPartyJobDetails`](crate::model::ThirdPartyJobDetails)
pub mod third_party_job_details {
    /// A builder for [`ThirdPartyJobDetails`](crate::model::ThirdPartyJobDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<crate::model::ThirdPartyJobData>,
        pub(crate) nonce: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier used to identify the job details in AWS CodePipeline.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier used to identify the job details in AWS CodePipeline.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The data to be returned by the third party job worker.</p>
        pub fn data(mut self, input: crate::model::ThirdPartyJobData) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The data to be returned by the third party job worker.</p>
        pub fn set_data(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyJobData>,
        ) -> Self {
            self.data = input;
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeThirdPartyJob</code> request.</p>
        pub fn nonce(mut self, input: impl Into<std::string::String>) -> Self {
            self.nonce = Some(input.into());
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <code>AcknowledgeThirdPartyJob</code> request.</p>
        pub fn set_nonce(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nonce = input;
            self
        }
        /// Consumes the builder and constructs a [`ThirdPartyJobDetails`](crate::model::ThirdPartyJobDetails)
        pub fn build(self) -> crate::model::ThirdPartyJobDetails {
            crate::model::ThirdPartyJobDetails {
                id: self.id,
                data: self.data,
                nonce: self.nonce,
            }
        }
    }
}
impl ThirdPartyJobDetails {
    /// Creates a new builder-style object to manufacture [`ThirdPartyJobDetails`](crate::model::ThirdPartyJobDetails)
    pub fn builder() -> crate::model::third_party_job_details::Builder {
        crate::model::third_party_job_details::Builder::default()
    }
}

/// <p>Represents information about the job data for a partner action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThirdPartyJobData {
    /// <p>Represents information about an action type.</p>
    pub action_type_id: std::option::Option<crate::model::ActionTypeId>,
    /// <p>Represents information about an action configuration.</p>
    pub action_configuration: std::option::Option<crate::model::ActionConfiguration>,
    /// <p>Represents information about a pipeline to a job worker.</p> <note>
    /// <p>Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.</p>
    /// </note>
    pub pipeline_context: std::option::Option<crate::model::PipelineContext>,
    /// <p>The name of the artifact that is worked on by the action, if any. This name might be system-generated, such as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match the name of an output artifact generated by an action in an earlier action or stage of the pipeline.</p>
    pub input_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
    /// <p>The name of the artifact that is the result of the action, if any. This name might be system-generated, such as "MyBuiltApp", or it might be defined by the user when the action is created.</p>
    pub output_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
    /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline. </p>
    pub artifact_credentials: std::option::Option<crate::model::AwsSessionCredentials>,
    /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job requires to continue the job asynchronously.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an AWS Key Management Service (AWS KMS) key. This is optional and might not be present.</p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
}
impl ThirdPartyJobData {
    /// <p>Represents information about an action type.</p>
    pub fn action_type_id(&self) -> std::option::Option<&crate::model::ActionTypeId> {
        self.action_type_id.as_ref()
    }
    /// <p>Represents information about an action configuration.</p>
    pub fn action_configuration(&self) -> std::option::Option<&crate::model::ActionConfiguration> {
        self.action_configuration.as_ref()
    }
    /// <p>Represents information about a pipeline to a job worker.</p> <note>
    /// <p>Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.</p>
    /// </note>
    pub fn pipeline_context(&self) -> std::option::Option<&crate::model::PipelineContext> {
        self.pipeline_context.as_ref()
    }
    /// <p>The name of the artifact that is worked on by the action, if any. This name might be system-generated, such as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match the name of an output artifact generated by an action in an earlier action or stage of the pipeline.</p>
    pub fn input_artifacts(&self) -> std::option::Option<&[crate::model::Artifact]> {
        self.input_artifacts.as_deref()
    }
    /// <p>The name of the artifact that is the result of the action, if any. This name might be system-generated, such as "MyBuiltApp", or it might be defined by the user when the action is created.</p>
    pub fn output_artifacts(&self) -> std::option::Option<&[crate::model::Artifact]> {
        self.output_artifacts.as_deref()
    }
    /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline. </p>
    pub fn artifact_credentials(
        &self,
    ) -> std::option::Option<&crate::model::AwsSessionCredentials> {
        self.artifact_credentials.as_ref()
    }
    /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job requires to continue the job asynchronously.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an AWS Key Management Service (AWS KMS) key. This is optional and might not be present.</p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
}
impl std::fmt::Debug for ThirdPartyJobData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThirdPartyJobData");
        formatter.field("action_type_id", &self.action_type_id);
        formatter.field("action_configuration", &self.action_configuration);
        formatter.field("pipeline_context", &self.pipeline_context);
        formatter.field("input_artifacts", &self.input_artifacts);
        formatter.field("output_artifacts", &self.output_artifacts);
        formatter.field("artifact_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.finish()
    }
}
/// See [`ThirdPartyJobData`](crate::model::ThirdPartyJobData)
pub mod third_party_job_data {
    /// A builder for [`ThirdPartyJobData`](crate::model::ThirdPartyJobData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type_id: std::option::Option<crate::model::ActionTypeId>,
        pub(crate) action_configuration: std::option::Option<crate::model::ActionConfiguration>,
        pub(crate) pipeline_context: std::option::Option<crate::model::PipelineContext>,
        pub(crate) input_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        pub(crate) output_artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        pub(crate) artifact_credentials: std::option::Option<crate::model::AwsSessionCredentials>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
    }
    impl Builder {
        /// <p>Represents information about an action type.</p>
        pub fn action_type_id(mut self, input: crate::model::ActionTypeId) -> Self {
            self.action_type_id = Some(input);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.action_type_id = input;
            self
        }
        /// <p>Represents information about an action configuration.</p>
        pub fn action_configuration(mut self, input: crate::model::ActionConfiguration) -> Self {
            self.action_configuration = Some(input);
            self
        }
        /// <p>Represents information about an action configuration.</p>
        pub fn set_action_configuration(
            mut self,
            input: std::option::Option<crate::model::ActionConfiguration>,
        ) -> Self {
            self.action_configuration = input;
            self
        }
        /// <p>Represents information about a pipeline to a job worker.</p> <note>
        /// <p>Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.</p>
        /// </note>
        pub fn pipeline_context(mut self, input: crate::model::PipelineContext) -> Self {
            self.pipeline_context = Some(input);
            self
        }
        /// <p>Represents information about a pipeline to a job worker.</p> <note>
        /// <p>Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.</p>
        /// </note>
        pub fn set_pipeline_context(
            mut self,
            input: std::option::Option<crate::model::PipelineContext>,
        ) -> Self {
            self.pipeline_context = input;
            self
        }
        /// Appends an item to `input_artifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>The name of the artifact that is worked on by the action, if any. This name might be system-generated, such as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match the name of an output artifact generated by an action in an earlier action or stage of the pipeline.</p>
        pub fn input_artifacts(mut self, input: crate::model::Artifact) -> Self {
            let mut v = self.input_artifacts.unwrap_or_default();
            v.push(input);
            self.input_artifacts = Some(v);
            self
        }
        /// <p>The name of the artifact that is worked on by the action, if any. This name might be system-generated, such as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match the name of an output artifact generated by an action in an earlier action or stage of the pipeline.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        ) -> Self {
            self.input_artifacts = input;
            self
        }
        /// Appends an item to `output_artifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>The name of the artifact that is the result of the action, if any. This name might be system-generated, such as "MyBuiltApp", or it might be defined by the user when the action is created.</p>
        pub fn output_artifacts(mut self, input: crate::model::Artifact) -> Self {
            let mut v = self.output_artifacts.unwrap_or_default();
            v.push(input);
            self.output_artifacts = Some(v);
            self
        }
        /// <p>The name of the artifact that is the result of the action, if any. This name might be system-generated, such as "MyBuiltApp", or it might be defined by the user when the action is created.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        ) -> Self {
            self.output_artifacts = input;
            self
        }
        /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline. </p>
        pub fn artifact_credentials(mut self, input: crate::model::AwsSessionCredentials) -> Self {
            self.artifact_credentials = Some(input);
            self
        }
        /// <p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline. </p>
        pub fn set_artifact_credentials(
            mut self,
            input: std::option::Option<crate::model::AwsSessionCredentials>,
        ) -> Self {
            self.artifact_credentials = input;
            self
        }
        /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job requires to continue the job asynchronously.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job requires to continue the job asynchronously.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an AWS Key Management Service (AWS KMS) key. This is optional and might not be present.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an AWS Key Management Service (AWS KMS) key. This is optional and might not be present.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Consumes the builder and constructs a [`ThirdPartyJobData`](crate::model::ThirdPartyJobData)
        pub fn build(self) -> crate::model::ThirdPartyJobData {
            crate::model::ThirdPartyJobData {
                action_type_id: self.action_type_id,
                action_configuration: self.action_configuration,
                pipeline_context: self.pipeline_context,
                input_artifacts: self.input_artifacts,
                output_artifacts: self.output_artifacts,
                artifact_credentials: self.artifact_credentials,
                continuation_token: self.continuation_token,
                encryption_key: self.encryption_key,
            }
        }
    }
}
impl ThirdPartyJobData {
    /// Creates a new builder-style object to manufacture [`ThirdPartyJobData`](crate::model::ThirdPartyJobData)
    pub fn builder() -> crate::model::third_party_job_data::Builder {
        crate::model::third_party_job_data::Builder::default()
    }
}

/// <p>Represents information about the state of the stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageState {
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>Represents information about the run of a stage.</p>
    pub inbound_execution: std::option::Option<crate::model::StageExecution>,
    /// <p>The state of the inbound transition, which is either enabled or disabled.</p>
    pub inbound_transition_state: std::option::Option<crate::model::TransitionState>,
    /// <p>The state of the stage.</p>
    pub action_states: std::option::Option<std::vec::Vec<crate::model::ActionState>>,
    /// <p>Information about the latest execution in the stage, including its ID and status.</p>
    pub latest_execution: std::option::Option<crate::model::StageExecution>,
}
impl StageState {
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>Represents information about the run of a stage.</p>
    pub fn inbound_execution(&self) -> std::option::Option<&crate::model::StageExecution> {
        self.inbound_execution.as_ref()
    }
    /// <p>The state of the inbound transition, which is either enabled or disabled.</p>
    pub fn inbound_transition_state(&self) -> std::option::Option<&crate::model::TransitionState> {
        self.inbound_transition_state.as_ref()
    }
    /// <p>The state of the stage.</p>
    pub fn action_states(&self) -> std::option::Option<&[crate::model::ActionState]> {
        self.action_states.as_deref()
    }
    /// <p>Information about the latest execution in the stage, including its ID and status.</p>
    pub fn latest_execution(&self) -> std::option::Option<&crate::model::StageExecution> {
        self.latest_execution.as_ref()
    }
}
impl std::fmt::Debug for StageState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageState");
        formatter.field("stage_name", &self.stage_name);
        formatter.field("inbound_execution", &self.inbound_execution);
        formatter.field("inbound_transition_state", &self.inbound_transition_state);
        formatter.field("action_states", &self.action_states);
        formatter.field("latest_execution", &self.latest_execution);
        formatter.finish()
    }
}
/// See [`StageState`](crate::model::StageState)
pub mod stage_state {
    /// A builder for [`StageState`](crate::model::StageState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) inbound_execution: std::option::Option<crate::model::StageExecution>,
        pub(crate) inbound_transition_state: std::option::Option<crate::model::TransitionState>,
        pub(crate) action_states: std::option::Option<std::vec::Vec<crate::model::ActionState>>,
        pub(crate) latest_execution: std::option::Option<crate::model::StageExecution>,
    }
    impl Builder {
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>Represents information about the run of a stage.</p>
        pub fn inbound_execution(mut self, input: crate::model::StageExecution) -> Self {
            self.inbound_execution = Some(input);
            self
        }
        /// <p>Represents information about the run of a stage.</p>
        pub fn set_inbound_execution(
            mut self,
            input: std::option::Option<crate::model::StageExecution>,
        ) -> Self {
            self.inbound_execution = input;
            self
        }
        /// <p>The state of the inbound transition, which is either enabled or disabled.</p>
        pub fn inbound_transition_state(mut self, input: crate::model::TransitionState) -> Self {
            self.inbound_transition_state = Some(input);
            self
        }
        /// <p>The state of the inbound transition, which is either enabled or disabled.</p>
        pub fn set_inbound_transition_state(
            mut self,
            input: std::option::Option<crate::model::TransitionState>,
        ) -> Self {
            self.inbound_transition_state = input;
            self
        }
        /// Appends an item to `action_states`.
        ///
        /// To override the contents of this collection use [`set_action_states`](Self::set_action_states).
        ///
        /// <p>The state of the stage.</p>
        pub fn action_states(mut self, input: crate::model::ActionState) -> Self {
            let mut v = self.action_states.unwrap_or_default();
            v.push(input);
            self.action_states = Some(v);
            self
        }
        /// <p>The state of the stage.</p>
        pub fn set_action_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionState>>,
        ) -> Self {
            self.action_states = input;
            self
        }
        /// <p>Information about the latest execution in the stage, including its ID and status.</p>
        pub fn latest_execution(mut self, input: crate::model::StageExecution) -> Self {
            self.latest_execution = Some(input);
            self
        }
        /// <p>Information about the latest execution in the stage, including its ID and status.</p>
        pub fn set_latest_execution(
            mut self,
            input: std::option::Option<crate::model::StageExecution>,
        ) -> Self {
            self.latest_execution = input;
            self
        }
        /// Consumes the builder and constructs a [`StageState`](crate::model::StageState)
        pub fn build(self) -> crate::model::StageState {
            crate::model::StageState {
                stage_name: self.stage_name,
                inbound_execution: self.inbound_execution,
                inbound_transition_state: self.inbound_transition_state,
                action_states: self.action_states,
                latest_execution: self.latest_execution,
            }
        }
    }
}
impl StageState {
    /// Creates a new builder-style object to manufacture [`StageState`](crate::model::StageState)
    pub fn builder() -> crate::model::stage_state::Builder {
        crate::model::stage_state::Builder::default()
    }
}

/// <p>Represents information about the run of a stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageExecution {
    /// <p>The ID of the pipeline execution associated with the stage.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
    /// <p>The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
    /// <p>A status of cancelled means that the pipeline’s definition was updated before the stage execution could be completed.</p>
    /// </note>
    pub status: std::option::Option<crate::model::StageExecutionStatus>,
}
impl StageExecution {
    /// <p>The ID of the pipeline execution associated with the stage.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
    /// <p>The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
    /// <p>A status of cancelled means that the pipeline’s definition was updated before the stage execution could be completed.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&crate::model::StageExecutionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StageExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageExecution");
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StageExecution`](crate::model::StageExecution)
pub mod stage_execution {
    /// A builder for [`StageExecution`](crate::model::StageExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StageExecutionStatus>,
    }
    impl Builder {
        /// <p>The ID of the pipeline execution associated with the stage.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline execution associated with the stage.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// <p>The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
        /// <p>A status of cancelled means that the pipeline’s definition was updated before the stage execution could be completed.</p>
        /// </note>
        pub fn status(mut self, input: crate::model::StageExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
        /// <p>A status of cancelled means that the pipeline’s definition was updated before the stage execution could be completed.</p>
        /// </note>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StageExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StageExecution`](crate::model::StageExecution)
        pub fn build(self) -> crate::model::StageExecution {
            crate::model::StageExecution {
                pipeline_execution_id: self.pipeline_execution_id,
                status: self.status,
            }
        }
    }
}
impl StageExecution {
    /// Creates a new builder-style object to manufacture [`StageExecution`](crate::model::StageExecution)
    pub fn builder() -> crate::model::stage_execution::Builder {
        crate::model::stage_execution::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StageExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StageExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => StageExecutionStatus::Cancelled,
            "Failed" => StageExecutionStatus::Failed,
            "InProgress" => StageExecutionStatus::InProgress,
            "Stopped" => StageExecutionStatus::Stopped,
            "Stopping" => StageExecutionStatus::Stopping,
            "Succeeded" => StageExecutionStatus::Succeeded,
            other => StageExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StageExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StageExecutionStatus::from(s))
    }
}
impl StageExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StageExecutionStatus::Cancelled => "Cancelled",
            StageExecutionStatus::Failed => "Failed",
            StageExecutionStatus::InProgress => "InProgress",
            StageExecutionStatus::Stopped => "Stopped",
            StageExecutionStatus::Stopping => "Stopping",
            StageExecutionStatus::Succeeded => "Succeeded",
            StageExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Failed",
            "InProgress",
            "Stopped",
            "Stopping",
            "Succeeded",
        ]
    }
}
impl AsRef<str> for StageExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information about the state of an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionState {
    /// <p>The name of the action.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>Represents information about the version (or revision) of an action.</p>
    pub current_revision: std::option::Option<crate::model::ActionRevision>,
    /// <p>Represents information about the run of an action.</p>
    pub latest_execution: std::option::Option<crate::model::ActionExecution>,
    /// <p>A URL link for more information about the state of the action, such as a deployment group details page.</p>
    pub entity_url: std::option::Option<std::string::String>,
    /// <p>A URL link for more information about the revision, such as a commit details page.</p>
    pub revision_url: std::option::Option<std::string::String>,
}
impl ActionState {
    /// <p>The name of the action.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>Represents information about the version (or revision) of an action.</p>
    pub fn current_revision(&self) -> std::option::Option<&crate::model::ActionRevision> {
        self.current_revision.as_ref()
    }
    /// <p>Represents information about the run of an action.</p>
    pub fn latest_execution(&self) -> std::option::Option<&crate::model::ActionExecution> {
        self.latest_execution.as_ref()
    }
    /// <p>A URL link for more information about the state of the action, such as a deployment group details page.</p>
    pub fn entity_url(&self) -> std::option::Option<&str> {
        self.entity_url.as_deref()
    }
    /// <p>A URL link for more information about the revision, such as a commit details page.</p>
    pub fn revision_url(&self) -> std::option::Option<&str> {
        self.revision_url.as_deref()
    }
}
impl std::fmt::Debug for ActionState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionState");
        formatter.field("action_name", &self.action_name);
        formatter.field("current_revision", &self.current_revision);
        formatter.field("latest_execution", &self.latest_execution);
        formatter.field("entity_url", &self.entity_url);
        formatter.field("revision_url", &self.revision_url);
        formatter.finish()
    }
}
/// See [`ActionState`](crate::model::ActionState)
pub mod action_state {
    /// A builder for [`ActionState`](crate::model::ActionState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) current_revision: std::option::Option<crate::model::ActionRevision>,
        pub(crate) latest_execution: std::option::Option<crate::model::ActionExecution>,
        pub(crate) entity_url: std::option::Option<std::string::String>,
        pub(crate) revision_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the action.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>Represents information about the version (or revision) of an action.</p>
        pub fn current_revision(mut self, input: crate::model::ActionRevision) -> Self {
            self.current_revision = Some(input);
            self
        }
        /// <p>Represents information about the version (or revision) of an action.</p>
        pub fn set_current_revision(
            mut self,
            input: std::option::Option<crate::model::ActionRevision>,
        ) -> Self {
            self.current_revision = input;
            self
        }
        /// <p>Represents information about the run of an action.</p>
        pub fn latest_execution(mut self, input: crate::model::ActionExecution) -> Self {
            self.latest_execution = Some(input);
            self
        }
        /// <p>Represents information about the run of an action.</p>
        pub fn set_latest_execution(
            mut self,
            input: std::option::Option<crate::model::ActionExecution>,
        ) -> Self {
            self.latest_execution = input;
            self
        }
        /// <p>A URL link for more information about the state of the action, such as a deployment group details page.</p>
        pub fn entity_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_url = Some(input.into());
            self
        }
        /// <p>A URL link for more information about the state of the action, such as a deployment group details page.</p>
        pub fn set_entity_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_url = input;
            self
        }
        /// <p>A URL link for more information about the revision, such as a commit details page.</p>
        pub fn revision_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_url = Some(input.into());
            self
        }
        /// <p>A URL link for more information about the revision, such as a commit details page.</p>
        pub fn set_revision_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionState`](crate::model::ActionState)
        pub fn build(self) -> crate::model::ActionState {
            crate::model::ActionState {
                action_name: self.action_name,
                current_revision: self.current_revision,
                latest_execution: self.latest_execution,
                entity_url: self.entity_url,
                revision_url: self.revision_url,
            }
        }
    }
}
impl ActionState {
    /// Creates a new builder-style object to manufacture [`ActionState`](crate::model::ActionState)
    pub fn builder() -> crate::model::action_state::Builder {
        crate::model::action_state::Builder::default()
    }
}

/// <p>Represents information about the run of an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionExecution {
    /// <p>ID of the workflow action execution in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current action execution details of the current stage.</p> <note>
    /// <p>For older executions, this field might be empty. The action execution ID is available for executions run on or after March 2020.</p>
    /// </note>
    pub action_execution_id: std::option::Option<std::string::String>,
    /// <p>The status of the action, or for a completed action, the last status of the action.</p>
    pub status: std::option::Option<crate::model::ActionExecutionStatus>,
    /// <p>A summary of the run of the action.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>The last status change of the action.</p>
    pub last_status_change: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the approval request corresponding to this token is still valid.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>The ARN of the user who last changed the pipeline.</p>
    pub last_updated_by: std::option::Option<std::string::String>,
    /// <p>The external ID of the run of the action.</p>
    pub external_execution_id: std::option::Option<std::string::String>,
    /// <p>The URL of a resource external to AWS that is used when running the action (for example, an external repository URL).</p>
    pub external_execution_url: std::option::Option<std::string::String>,
    /// <p>A percentage of completeness of the action as it runs.</p>
    pub percent_complete: std::option::Option<i32>,
    /// <p>The details of an error returned by a URL external to AWS.</p>
    pub error_details: std::option::Option<crate::model::ErrorDetails>,
}
impl ActionExecution {
    /// <p>ID of the workflow action execution in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current action execution details of the current stage.</p> <note>
    /// <p>For older executions, this field might be empty. The action execution ID is available for executions run on or after March 2020.</p>
    /// </note>
    pub fn action_execution_id(&self) -> std::option::Option<&str> {
        self.action_execution_id.as_deref()
    }
    /// <p>The status of the action, or for a completed action, the last status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ActionExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>A summary of the run of the action.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>The last status change of the action.</p>
    pub fn last_status_change(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_status_change.as_ref()
    }
    /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the approval request corresponding to this token is still valid.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
    /// <p>The ARN of the user who last changed the pipeline.</p>
    pub fn last_updated_by(&self) -> std::option::Option<&str> {
        self.last_updated_by.as_deref()
    }
    /// <p>The external ID of the run of the action.</p>
    pub fn external_execution_id(&self) -> std::option::Option<&str> {
        self.external_execution_id.as_deref()
    }
    /// <p>The URL of a resource external to AWS that is used when running the action (for example, an external repository URL).</p>
    pub fn external_execution_url(&self) -> std::option::Option<&str> {
        self.external_execution_url.as_deref()
    }
    /// <p>A percentage of completeness of the action as it runs.</p>
    pub fn percent_complete(&self) -> std::option::Option<i32> {
        self.percent_complete
    }
    /// <p>The details of an error returned by a URL external to AWS.</p>
    pub fn error_details(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error_details.as_ref()
    }
}
impl std::fmt::Debug for ActionExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionExecution");
        formatter.field("action_execution_id", &self.action_execution_id);
        formatter.field("status", &self.status);
        formatter.field("summary", &self.summary);
        formatter.field("last_status_change", &self.last_status_change);
        formatter.field("token", &self.token);
        formatter.field("last_updated_by", &self.last_updated_by);
        formatter.field("external_execution_id", &self.external_execution_id);
        formatter.field("external_execution_url", &self.external_execution_url);
        formatter.field("percent_complete", &self.percent_complete);
        formatter.field("error_details", &self.error_details);
        formatter.finish()
    }
}
/// See [`ActionExecution`](crate::model::ActionExecution)
pub mod action_execution {
    /// A builder for [`ActionExecution`](crate::model::ActionExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_execution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ActionExecutionStatus>,
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) last_status_change: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) last_updated_by: std::option::Option<std::string::String>,
        pub(crate) external_execution_id: std::option::Option<std::string::String>,
        pub(crate) external_execution_url: std::option::Option<std::string::String>,
        pub(crate) percent_complete: std::option::Option<i32>,
        pub(crate) error_details: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>ID of the workflow action execution in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current action execution details of the current stage.</p> <note>
        /// <p>For older executions, this field might be empty. The action execution ID is available for executions run on or after March 2020.</p>
        /// </note>
        pub fn action_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_execution_id = Some(input.into());
            self
        }
        /// <p>ID of the workflow action execution in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current action execution details of the current stage.</p> <note>
        /// <p>For older executions, this field might be empty. The action execution ID is available for executions run on or after March 2020.</p>
        /// </note>
        pub fn set_action_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_execution_id = input;
            self
        }
        /// <p>The status of the action, or for a completed action, the last status of the action.</p>
        pub fn status(mut self, input: crate::model::ActionExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action, or for a completed action, the last status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A summary of the run of the action.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>A summary of the run of the action.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>The last status change of the action.</p>
        pub fn last_status_change(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_status_change = Some(input);
            self
        }
        /// <p>The last status change of the action.</p>
        pub fn set_last_status_change(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_status_change = input;
            self
        }
        /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the approval request corresponding to this token is still valid.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the approval request corresponding to this token is still valid.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>The ARN of the user who last changed the pipeline.</p>
        pub fn last_updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_by = Some(input.into());
            self
        }
        /// <p>The ARN of the user who last changed the pipeline.</p>
        pub fn set_last_updated_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_by = input;
            self
        }
        /// <p>The external ID of the run of the action.</p>
        pub fn external_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_execution_id = Some(input.into());
            self
        }
        /// <p>The external ID of the run of the action.</p>
        pub fn set_external_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_execution_id = input;
            self
        }
        /// <p>The URL of a resource external to AWS that is used when running the action (for example, an external repository URL).</p>
        pub fn external_execution_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_execution_url = Some(input.into());
            self
        }
        /// <p>The URL of a resource external to AWS that is used when running the action (for example, an external repository URL).</p>
        pub fn set_external_execution_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_execution_url = input;
            self
        }
        /// <p>A percentage of completeness of the action as it runs.</p>
        pub fn percent_complete(mut self, input: i32) -> Self {
            self.percent_complete = Some(input);
            self
        }
        /// <p>A percentage of completeness of the action as it runs.</p>
        pub fn set_percent_complete(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_complete = input;
            self
        }
        /// <p>The details of an error returned by a URL external to AWS.</p>
        pub fn error_details(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error_details = Some(input);
            self
        }
        /// <p>The details of an error returned by a URL external to AWS.</p>
        pub fn set_error_details(
            mut self,
            input: std::option::Option<crate::model::ErrorDetails>,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionExecution`](crate::model::ActionExecution)
        pub fn build(self) -> crate::model::ActionExecution {
            crate::model::ActionExecution {
                action_execution_id: self.action_execution_id,
                status: self.status,
                summary: self.summary,
                last_status_change: self.last_status_change,
                token: self.token,
                last_updated_by: self.last_updated_by,
                external_execution_id: self.external_execution_id,
                external_execution_url: self.external_execution_url,
                percent_complete: self.percent_complete,
                error_details: self.error_details,
            }
        }
    }
}
impl ActionExecution {
    /// Creates a new builder-style object to manufacture [`ActionExecution`](crate::model::ActionExecution)
    pub fn builder() -> crate::model::action_execution::Builder {
        crate::model::action_execution::Builder::default()
    }
}

/// <p>Represents information about an error in AWS CodePipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetails {
    /// <p>The system ID or number code of the error.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The text of the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ErrorDetails {
    /// <p>The system ID or number code of the error.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The text of the error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetails");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ErrorDetails`](crate::model::ErrorDetails)
pub mod error_details {
    /// A builder for [`ErrorDetails`](crate::model::ErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system ID or number code of the error.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The system ID or number code of the error.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The text of the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The text of the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetails`](crate::model::ErrorDetails)
        pub fn build(self) -> crate::model::ErrorDetails {
            crate::model::ErrorDetails {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ErrorDetails {
    /// Creates a new builder-style object to manufacture [`ErrorDetails`](crate::model::ErrorDetails)
    pub fn builder() -> crate::model::error_details::Builder {
        crate::model::error_details::Builder::default()
    }
}

/// <p>Represents information about the state of transitions between one stage and another stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitionState {
    /// <p>Whether the transition between stages is enabled (true) or disabled (false).</p>
    pub enabled: bool,
    /// <p>The ID of the user who last changed the transition state.</p>
    pub last_changed_by: std::option::Option<std::string::String>,
    /// <p>The timestamp when the transition state was last changed.</p>
    pub last_changed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The user-specified reason why the transition between two stages of a pipeline was disabled.</p>
    pub disabled_reason: std::option::Option<std::string::String>,
}
impl TransitionState {
    /// <p>Whether the transition between stages is enabled (true) or disabled (false).</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The ID of the user who last changed the transition state.</p>
    pub fn last_changed_by(&self) -> std::option::Option<&str> {
        self.last_changed_by.as_deref()
    }
    /// <p>The timestamp when the transition state was last changed.</p>
    pub fn last_changed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_changed_at.as_ref()
    }
    /// <p>The user-specified reason why the transition between two stages of a pipeline was disabled.</p>
    pub fn disabled_reason(&self) -> std::option::Option<&str> {
        self.disabled_reason.as_deref()
    }
}
impl std::fmt::Debug for TransitionState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitionState");
        formatter.field("enabled", &self.enabled);
        formatter.field("last_changed_by", &self.last_changed_by);
        formatter.field("last_changed_at", &self.last_changed_at);
        formatter.field("disabled_reason", &self.disabled_reason);
        formatter.finish()
    }
}
/// See [`TransitionState`](crate::model::TransitionState)
pub mod transition_state {
    /// A builder for [`TransitionState`](crate::model::TransitionState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) last_changed_by: std::option::Option<std::string::String>,
        pub(crate) last_changed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) disabled_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether the transition between stages is enabled (true) or disabled (false).</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether the transition between stages is enabled (true) or disabled (false).</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The ID of the user who last changed the transition state.</p>
        pub fn last_changed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_changed_by = Some(input.into());
            self
        }
        /// <p>The ID of the user who last changed the transition state.</p>
        pub fn set_last_changed_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_changed_by = input;
            self
        }
        /// <p>The timestamp when the transition state was last changed.</p>
        pub fn last_changed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_changed_at = Some(input);
            self
        }
        /// <p>The timestamp when the transition state was last changed.</p>
        pub fn set_last_changed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_changed_at = input;
            self
        }
        /// <p>The user-specified reason why the transition between two stages of a pipeline was disabled.</p>
        pub fn disabled_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.disabled_reason = Some(input.into());
            self
        }
        /// <p>The user-specified reason why the transition between two stages of a pipeline was disabled.</p>
        pub fn set_disabled_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disabled_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitionState`](crate::model::TransitionState)
        pub fn build(self) -> crate::model::TransitionState {
            crate::model::TransitionState {
                enabled: self.enabled.unwrap_or_default(),
                last_changed_by: self.last_changed_by,
                last_changed_at: self.last_changed_at,
                disabled_reason: self.disabled_reason,
            }
        }
    }
}
impl TransitionState {
    /// Creates a new builder-style object to manufacture [`TransitionState`](crate::model::TransitionState)
    pub fn builder() -> crate::model::transition_state::Builder {
        crate::model::transition_state::Builder::default()
    }
}

/// <p>Represents information about an execution of a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineExecution {
    /// <p>The name of the pipeline with the specified pipeline execution.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The version number of the pipeline with the specified pipeline execution.</p>
    pub pipeline_version: std::option::Option<i32>,
    /// <p>The ID of the pipeline execution.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
    /// <p>The status of the pipeline execution.</p>
    /// <ul>
    /// <li> <p>Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.</p> </li>
    /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
    /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
    /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
    /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PipelineExecutionStatus>,
    /// <p>A summary that contains a description of the pipeline execution status.</p>
    pub status_summary: std::option::Option<std::string::String>,
    /// <p>A list of <code>ArtifactRevision</code> objects included in a pipeline execution.</p>
    pub artifact_revisions: std::option::Option<std::vec::Vec<crate::model::ArtifactRevision>>,
}
impl PipelineExecution {
    /// <p>The name of the pipeline with the specified pipeline execution.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The version number of the pipeline with the specified pipeline execution.</p>
    pub fn pipeline_version(&self) -> std::option::Option<i32> {
        self.pipeline_version
    }
    /// <p>The ID of the pipeline execution.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
    /// <p>The status of the pipeline execution.</p>
    /// <ul>
    /// <li> <p>Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.</p> </li>
    /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
    /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
    /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
    /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
    /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PipelineExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>A summary that contains a description of the pipeline execution status.</p>
    pub fn status_summary(&self) -> std::option::Option<&str> {
        self.status_summary.as_deref()
    }
    /// <p>A list of <code>ArtifactRevision</code> objects included in a pipeline execution.</p>
    pub fn artifact_revisions(&self) -> std::option::Option<&[crate::model::ArtifactRevision]> {
        self.artifact_revisions.as_deref()
    }
}
impl std::fmt::Debug for PipelineExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineExecution");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("pipeline_version", &self.pipeline_version);
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.field("status", &self.status);
        formatter.field("status_summary", &self.status_summary);
        formatter.field("artifact_revisions", &self.artifact_revisions);
        formatter.finish()
    }
}
/// See [`PipelineExecution`](crate::model::PipelineExecution)
pub mod pipeline_execution {
    /// A builder for [`PipelineExecution`](crate::model::PipelineExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_version: std::option::Option<i32>,
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PipelineExecutionStatus>,
        pub(crate) status_summary: std::option::Option<std::string::String>,
        pub(crate) artifact_revisions:
            std::option::Option<std::vec::Vec<crate::model::ArtifactRevision>>,
    }
    impl Builder {
        /// <p>The name of the pipeline with the specified pipeline execution.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline with the specified pipeline execution.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The version number of the pipeline with the specified pipeline execution.</p>
        pub fn pipeline_version(mut self, input: i32) -> Self {
            self.pipeline_version = Some(input);
            self
        }
        /// <p>The version number of the pipeline with the specified pipeline execution.</p>
        pub fn set_pipeline_version(mut self, input: std::option::Option<i32>) -> Self {
            self.pipeline_version = input;
            self
        }
        /// <p>The ID of the pipeline execution.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline execution.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// <p>The status of the pipeline execution.</p>
        /// <ul>
        /// <li> <p>Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.</p> </li>
        /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
        /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
        /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
        /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PipelineExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the pipeline execution.</p>
        /// <ul>
        /// <li> <p>Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.</p> </li>
        /// <li> <p>InProgress: The pipeline execution is currently running.</p> </li>
        /// <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li>
        /// <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li>
        /// <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li>
        /// <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A summary that contains a description of the pipeline execution status.</p>
        pub fn status_summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_summary = Some(input.into());
            self
        }
        /// <p>A summary that contains a description of the pipeline execution status.</p>
        pub fn set_status_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_summary = input;
            self
        }
        /// Appends an item to `artifact_revisions`.
        ///
        /// To override the contents of this collection use [`set_artifact_revisions`](Self::set_artifact_revisions).
        ///
        /// <p>A list of <code>ArtifactRevision</code> objects included in a pipeline execution.</p>
        pub fn artifact_revisions(mut self, input: crate::model::ArtifactRevision) -> Self {
            let mut v = self.artifact_revisions.unwrap_or_default();
            v.push(input);
            self.artifact_revisions = Some(v);
            self
        }
        /// <p>A list of <code>ArtifactRevision</code> objects included in a pipeline execution.</p>
        pub fn set_artifact_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ArtifactRevision>>,
        ) -> Self {
            self.artifact_revisions = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineExecution`](crate::model::PipelineExecution)
        pub fn build(self) -> crate::model::PipelineExecution {
            crate::model::PipelineExecution {
                pipeline_name: self.pipeline_name,
                pipeline_version: self.pipeline_version,
                pipeline_execution_id: self.pipeline_execution_id,
                status: self.status,
                status_summary: self.status_summary,
                artifact_revisions: self.artifact_revisions,
            }
        }
    }
}
impl PipelineExecution {
    /// Creates a new builder-style object to manufacture [`PipelineExecution`](crate::model::PipelineExecution)
    pub fn builder() -> crate::model::pipeline_execution::Builder {
        crate::model::pipeline_execution::Builder::default()
    }
}

/// <p>Represents revision details of an artifact. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactRevision {
    /// <p>The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an action is created.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The revision ID of the artifact.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the ETag value.</p>
    pub revision_change_identifier: std::option::Option<std::string::String>,
    /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
    pub revision_summary: std::option::Option<std::string::String>,
    /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
    pub revision_url: std::option::Option<std::string::String>,
}
impl ArtifactRevision {
    /// <p>The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an action is created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The revision ID of the artifact.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the ETag value.</p>
    pub fn revision_change_identifier(&self) -> std::option::Option<&str> {
        self.revision_change_identifier.as_deref()
    }
    /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
    pub fn revision_summary(&self) -> std::option::Option<&str> {
        self.revision_summary.as_deref()
    }
    /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
    pub fn revision_url(&self) -> std::option::Option<&str> {
        self.revision_url.as_deref()
    }
}
impl std::fmt::Debug for ArtifactRevision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactRevision");
        formatter.field("name", &self.name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field(
            "revision_change_identifier",
            &self.revision_change_identifier,
        );
        formatter.field("revision_summary", &self.revision_summary);
        formatter.field("created", &self.created);
        formatter.field("revision_url", &self.revision_url);
        formatter.finish()
    }
}
/// See [`ArtifactRevision`](crate::model::ArtifactRevision)
pub mod artifact_revision {
    /// A builder for [`ArtifactRevision`](crate::model::ArtifactRevision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) revision_change_identifier: std::option::Option<std::string::String>,
        pub(crate) revision_summary: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an action is created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an action is created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The revision ID of the artifact.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the artifact.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the ETag value.</p>
        pub fn revision_change_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_change_identifier = Some(input.into());
            self
        }
        /// <p>An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the ETag value.</p>
        pub fn set_revision_change_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_change_identifier = input;
            self
        }
        /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
        pub fn revision_summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_summary = Some(input.into());
            self
        }
        /// <p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>
        pub fn set_revision_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_summary = input;
            self
        }
        /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
        pub fn revision_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_url = Some(input.into());
            self
        }
        /// <p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>
        pub fn set_revision_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactRevision`](crate::model::ArtifactRevision)
        pub fn build(self) -> crate::model::ArtifactRevision {
            crate::model::ArtifactRevision {
                name: self.name,
                revision_id: self.revision_id,
                revision_change_identifier: self.revision_change_identifier,
                revision_summary: self.revision_summary,
                created: self.created,
                revision_url: self.revision_url,
            }
        }
    }
}
impl ArtifactRevision {
    /// Creates a new builder-style object to manufacture [`ArtifactRevision`](crate::model::ArtifactRevision)
    pub fn builder() -> crate::model::artifact_revision::Builder {
        crate::model::artifact_revision::Builder::default()
    }
}

/// <p>Information about a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineMetadata {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The date and time the pipeline was created, in timestamp format.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
    pub updated: std::option::Option<aws_smithy_types::DateTime>,
}
impl PipelineMetadata {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub fn pipeline_arn(&self) -> std::option::Option<&str> {
        self.pipeline_arn.as_deref()
    }
    /// <p>The date and time the pipeline was created, in timestamp format.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
    pub fn updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated.as_ref()
    }
}
impl std::fmt::Debug for PipelineMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineMetadata");
        formatter.field("pipeline_arn", &self.pipeline_arn);
        formatter.field("created", &self.created);
        formatter.field("updated", &self.updated);
        formatter.finish()
    }
}
/// See [`PipelineMetadata`](crate::model::PipelineMetadata)
pub mod pipeline_metadata {
    /// A builder for [`PipelineMetadata`](crate::model::PipelineMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn set_pipeline_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_arn = input;
            self
        }
        /// <p>The date and time the pipeline was created, in timestamp format.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time the pipeline was created, in timestamp format.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
        pub fn updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated = Some(input);
            self
        }
        /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
        pub fn set_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineMetadata`](crate::model::PipelineMetadata)
        pub fn build(self) -> crate::model::PipelineMetadata {
            crate::model::PipelineMetadata {
                pipeline_arn: self.pipeline_arn,
                created: self.created,
                updated: self.updated,
            }
        }
    }
}
impl PipelineMetadata {
    /// Creates a new builder-style object to manufacture [`PipelineMetadata`](crate::model::PipelineMetadata)
    pub fn builder() -> crate::model::pipeline_metadata::Builder {
        crate::model::pipeline_metadata::Builder::default()
    }
}

/// <p>Represents information about the details of a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobDetails {
    /// <p>The unique system-generated ID of the job.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Represents other information about a job required for a job worker to complete the job. </p>
    pub data: std::option::Option<crate::model::JobData>,
    /// <p>The AWS account ID associated with the job.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl JobDetails {
    /// <p>The unique system-generated ID of the job.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Represents other information about a job required for a job worker to complete the job. </p>
    pub fn data(&self) -> std::option::Option<&crate::model::JobData> {
        self.data.as_ref()
    }
    /// <p>The AWS account ID associated with the job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for JobDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobDetails");
        formatter.field("id", &self.id);
        formatter.field("data", &self.data);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`JobDetails`](crate::model::JobDetails)
pub mod job_details {
    /// A builder for [`JobDetails`](crate::model::JobDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<crate::model::JobData>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the job.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the job.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Represents other information about a job required for a job worker to complete the job. </p>
        pub fn data(mut self, input: crate::model::JobData) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>Represents other information about a job required for a job worker to complete the job. </p>
        pub fn set_data(mut self, input: std::option::Option<crate::model::JobData>) -> Self {
            self.data = input;
            self
        }
        /// <p>The AWS account ID associated with the job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`JobDetails`](crate::model::JobDetails)
        pub fn build(self) -> crate::model::JobDetails {
            crate::model::JobDetails {
                id: self.id,
                data: self.data,
                account_id: self.account_id,
            }
        }
    }
}
impl JobDetails {
    /// Creates a new builder-style object to manufacture [`JobDetails`](crate::model::JobDetails)
    pub fn builder() -> crate::model::job_details::Builder {
        crate::model::job_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StageTransitionType {
    #[allow(missing_docs)] // documentation missing in model
    Inbound,
    #[allow(missing_docs)] // documentation missing in model
    Outbound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StageTransitionType {
    fn from(s: &str) -> Self {
        match s {
            "Inbound" => StageTransitionType::Inbound,
            "Outbound" => StageTransitionType::Outbound,
            other => StageTransitionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StageTransitionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StageTransitionType::from(s))
    }
}
impl StageTransitionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StageTransitionType::Inbound => "Inbound",
            StageTransitionType::Outbound => "Outbound",
            StageTransitionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Inbound", "Outbound"]
    }
}
impl AsRef<str> for StageTransitionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Dispatched,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "Created" => JobStatus::Created,
            "Dispatched" => JobStatus::Dispatched,
            "Failed" => JobStatus::Failed,
            "InProgress" => JobStatus::InProgress,
            "Queued" => JobStatus::Queued,
            "Succeeded" => JobStatus::Succeeded,
            "TimedOut" => JobStatus::TimedOut,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Created => "Created",
            JobStatus::Dispatched => "Dispatched",
            JobStatus::Failed => "Failed",
            JobStatus::InProgress => "InProgress",
            JobStatus::Queued => "Queued",
            JobStatus::Succeeded => "Succeeded",
            JobStatus::TimedOut => "TimedOut",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Created",
            "Dispatched",
            "Failed",
            "InProgress",
            "Queued",
            "Succeeded",
            "TimedOut",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
