// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcknowledgeJobInput`](crate::input::AcknowledgeJobInput)
pub mod acknowledge_job_input {
    /// A builder for [`AcknowledgeJobInput`](crate::input::AcknowledgeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) nonce: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the job for which you want to confirm receipt.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the job for which you want to confirm receipt.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response of the <code>PollForJobs</code> request that returned this job.</p>
        pub fn nonce(mut self, input: impl Into<std::string::String>) -> Self {
            self.nonce = Some(input.into());
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response of the <code>PollForJobs</code> request that returned this job.</p>
        pub fn set_nonce(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nonce = input;
            self
        }
        /// Consumes the builder and constructs a [`AcknowledgeJobInput`](crate::input::AcknowledgeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcknowledgeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcknowledgeJobInput {
                job_id: self.job_id,
                nonce: self.nonce,
            })
        }
    }
}
#[doc(hidden)]
pub type AcknowledgeJobInputOperationOutputAlias = crate::operation::AcknowledgeJob;
#[doc(hidden)]
pub type AcknowledgeJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcknowledgeJobInput {
    /// Consumes the builder and constructs an Operation<[`AcknowledgeJob`](crate::operation::AcknowledgeJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcknowledgeJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcknowledgeJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcknowledgeJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.AcknowledgeJob",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_acknowledge_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcknowledgeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcknowledgeJob",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcknowledgeJobInput`](crate::input::AcknowledgeJobInput)
    pub fn builder() -> crate::input::acknowledge_job_input::Builder {
        crate::input::acknowledge_job_input::Builder::default()
    }
}

/// See [`AcknowledgeThirdPartyJobInput`](crate::input::AcknowledgeThirdPartyJobInput)
pub mod acknowledge_third_party_job_input {
    /// A builder for [`AcknowledgeThirdPartyJobInput`](crate::input::AcknowledgeThirdPartyJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) nonce: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response to a <code>GetThirdPartyJobDetails</code> request.</p>
        pub fn nonce(mut self, input: impl Into<std::string::String>) -> Self {
            self.nonce = Some(input.into());
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response to a <code>GetThirdPartyJobDetails</code> request.</p>
        pub fn set_nonce(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nonce = input;
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AcknowledgeThirdPartyJobInput`](crate::input::AcknowledgeThirdPartyJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcknowledgeThirdPartyJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcknowledgeThirdPartyJobInput {
                job_id: self.job_id,
                nonce: self.nonce,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AcknowledgeThirdPartyJobInputOperationOutputAlias =
    crate::operation::AcknowledgeThirdPartyJob;
#[doc(hidden)]
pub type AcknowledgeThirdPartyJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcknowledgeThirdPartyJobInput {
    /// Consumes the builder and constructs an Operation<[`AcknowledgeThirdPartyJob`](crate::operation::AcknowledgeThirdPartyJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcknowledgeThirdPartyJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcknowledgeThirdPartyJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcknowledgeThirdPartyJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.AcknowledgeThirdPartyJob",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_acknowledge_third_party_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcknowledgeThirdPartyJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcknowledgeThirdPartyJob",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcknowledgeThirdPartyJobInput`](crate::input::AcknowledgeThirdPartyJobInput)
    pub fn builder() -> crate::input::acknowledge_third_party_job_input::Builder {
        crate::input::acknowledge_third_party_job_input::Builder::default()
    }
}

/// See [`CreateCustomActionTypeInput`](crate::input::CreateCustomActionTypeInput)
pub mod create_custom_action_type_input {
    /// A builder for [`CreateCustomActionTypeInput`](crate::input::CreateCustomActionTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::ActionCategory>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<crate::model::ActionTypeSettings>,
        pub(crate) configuration_properties:
            std::option::Option<std::vec::Vec<crate::model::ActionConfigurationProperty>>,
        pub(crate) input_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
        pub(crate) output_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The category of the custom action, such as a build action or a test action.</p>
        pub fn category(mut self, input: crate::model::ActionCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category of the custom action, such as a build action or a test action.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The version identifier of the custom action.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version identifier of the custom action.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>URLs that provide users information about this custom action.</p>
        pub fn settings(mut self, input: crate::model::ActionTypeSettings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>URLs that provide users information about this custom action.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::ActionTypeSettings>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Appends an item to `configuration_properties`.
        ///
        /// To override the contents of this collection use [`set_configuration_properties`](Self::set_configuration_properties).
        ///
        /// <p>The configuration properties for the custom action.</p> <note>
        /// <p>You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a>.</p>
        /// </note>
        pub fn configuration_properties(
            mut self,
            input: crate::model::ActionConfigurationProperty,
        ) -> Self {
            let mut v = self.configuration_properties.unwrap_or_default();
            v.push(input);
            self.configuration_properties = Some(v);
            self
        }
        /// <p>The configuration properties for the custom action.</p> <note>
        /// <p>You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a>.</p>
        /// </note>
        pub fn set_configuration_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionConfigurationProperty>>,
        ) -> Self {
            self.configuration_properties = input;
            self
        }
        /// <p>The details of the input artifact for the action, such as its commit ID.</p>
        pub fn input_artifact_details(mut self, input: crate::model::ArtifactDetails) -> Self {
            self.input_artifact_details = Some(input);
            self
        }
        /// <p>The details of the input artifact for the action, such as its commit ID.</p>
        pub fn set_input_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ArtifactDetails>,
        ) -> Self {
            self.input_artifact_details = input;
            self
        }
        /// <p>The details of the output artifact of the action, such as its commit ID.</p>
        pub fn output_artifact_details(mut self, input: crate::model::ArtifactDetails) -> Self {
            self.output_artifact_details = Some(input);
            self
        }
        /// <p>The details of the output artifact of the action, such as its commit ID.</p>
        pub fn set_output_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ArtifactDetails>,
        ) -> Self {
            self.output_artifact_details = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the custom action.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the custom action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomActionTypeInput`](crate::input::CreateCustomActionTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomActionTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomActionTypeInput {
                category: self.category,
                provider: self.provider,
                version: self.version,
                settings: self.settings,
                configuration_properties: self.configuration_properties,
                input_artifact_details: self.input_artifact_details,
                output_artifact_details: self.output_artifact_details,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomActionTypeInputOperationOutputAlias = crate::operation::CreateCustomActionType;
#[doc(hidden)]
pub type CreateCustomActionTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCustomActionTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomActionType`](crate::operation::CreateCustomActionType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomActionType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCustomActionTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCustomActionTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.CreateCustomActionType",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_custom_action_type(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomActionType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomActionType",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomActionTypeInput`](crate::input::CreateCustomActionTypeInput)
    pub fn builder() -> crate::input::create_custom_action_type_input::Builder {
        crate::input::create_custom_action_type_input::Builder::default()
    }
}

/// See [`CreatePipelineInput`](crate::input::CreatePipelineInput)
pub mod create_pipeline_input {
    /// A builder for [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::PipelineDeclaration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Represents the structure of actions and stages to be performed in the pipeline. </p>
        pub fn pipeline(mut self, input: crate::model::PipelineDeclaration) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>Represents the structure of actions and stages to be performed in the pipeline. </p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::PipelineDeclaration>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the pipeline.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePipelineInput`](crate::input::CreatePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePipelineInput {
                pipeline: self.pipeline,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePipelineInputOperationOutputAlias = crate::operation::CreatePipeline;
#[doc(hidden)]
pub type CreatePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePipelineInput {
    /// Consumes the builder and constructs an Operation<[`CreatePipeline`](crate::operation::CreatePipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.CreatePipeline",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_pipeline(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePipeline",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    pub fn builder() -> crate::input::create_pipeline_input::Builder {
        crate::input::create_pipeline_input::Builder::default()
    }
}

/// See [`DeleteCustomActionTypeInput`](crate::input::DeleteCustomActionTypeInput)
pub mod delete_custom_action_type_input {
    /// A builder for [`DeleteCustomActionTypeInput`](crate::input::DeleteCustomActionTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::ActionCategory>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The category of the custom action that you want to delete, such as source or deploy.</p>
        pub fn category(mut self, input: crate::model::ActionCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category of the custom action that you want to delete, such as source or deploy.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The version of the custom action to delete.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the custom action to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomActionTypeInput`](crate::input::DeleteCustomActionTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomActionTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomActionTypeInput {
                category: self.category,
                provider: self.provider,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomActionTypeInputOperationOutputAlias = crate::operation::DeleteCustomActionType;
#[doc(hidden)]
pub type DeleteCustomActionTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCustomActionTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomActionType`](crate::operation::DeleteCustomActionType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomActionType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCustomActionTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCustomActionTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.DeleteCustomActionType",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_custom_action_type(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomActionType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomActionType",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomActionTypeInput`](crate::input::DeleteCustomActionTypeInput)
    pub fn builder() -> crate::input::delete_custom_action_type_input::Builder {
        crate::input::delete_custom_action_type_input::Builder::default()
    }
}

/// See [`DeletePipelineInput`](crate::input::DeletePipelineInput)
pub mod delete_pipeline_input {
    /// A builder for [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePipelineInput`](crate::input::DeletePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePipelineInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeletePipelineInputOperationOutputAlias = crate::operation::DeletePipeline;
#[doc(hidden)]
pub type DeletePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePipelineInput {
    /// Consumes the builder and constructs an Operation<[`DeletePipeline`](crate::operation::DeletePipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.DeletePipeline",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_pipeline(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePipeline",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    pub fn builder() -> crate::input::delete_pipeline_input::Builder {
        crate::input::delete_pipeline_input::Builder::default()
    }
}

/// See [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
pub mod delete_webhook_input {
    /// A builder for [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the webhook you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the webhook you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWebhookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWebhookInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteWebhookInputOperationOutputAlias = crate::operation::DeleteWebhook;
#[doc(hidden)]
pub type DeleteWebhookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWebhookInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWebhook`](crate::operation::DeleteWebhook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWebhook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteWebhookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteWebhookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.DeleteWebhook",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_webhook(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWebhook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWebhook",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
    pub fn builder() -> crate::input::delete_webhook_input::Builder {
        crate::input::delete_webhook_input::Builder::default()
    }
}

/// See [`DeregisterWebhookWithThirdPartyInput`](crate::input::DeregisterWebhookWithThirdPartyInput)
pub mod deregister_webhook_with_third_party_input {
    /// A builder for [`DeregisterWebhookWithThirdPartyInput`](crate::input::DeregisterWebhookWithThirdPartyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the webhook you want to deregister.</p>
        pub fn webhook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_name = Some(input.into());
            self
        }
        /// <p>The name of the webhook you want to deregister.</p>
        pub fn set_webhook_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterWebhookWithThirdPartyInput`](crate::input::DeregisterWebhookWithThirdPartyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterWebhookWithThirdPartyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterWebhookWithThirdPartyInput {
                webhook_name: self.webhook_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterWebhookWithThirdPartyInputOperationOutputAlias =
    crate::operation::DeregisterWebhookWithThirdParty;
#[doc(hidden)]
pub type DeregisterWebhookWithThirdPartyInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterWebhookWithThirdPartyInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterWebhookWithThirdParty`](crate::operation::DeregisterWebhookWithThirdParty)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterWebhookWithThirdParty,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeregisterWebhookWithThirdPartyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeregisterWebhookWithThirdPartyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.DeregisterWebhookWithThirdParty",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deregister_webhook_with_third_party(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterWebhookWithThirdParty::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterWebhookWithThirdParty",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeregisterWebhookWithThirdPartyInput`](crate::input::DeregisterWebhookWithThirdPartyInput)
    pub fn builder() -> crate::input::deregister_webhook_with_third_party_input::Builder {
        crate::input::deregister_webhook_with_third_party_input::Builder::default()
    }
}

/// See [`DisableStageTransitionInput`](crate::input::DisableStageTransitionInput)
pub mod disable_stage_transition_input {
    /// A builder for [`DisableStageTransitionInput`](crate::input::DisableStageTransitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) transition_type: std::option::Option<crate::model::StageTransitionType>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The name of the stage where you want to disable the inbound or outbound transition of artifacts.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage where you want to disable the inbound or outbound transition of artifacts.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).</p>
        pub fn transition_type(mut self, input: crate::model::StageTransitionType) -> Self {
            self.transition_type = Some(input);
            self
        }
        /// <p>Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).</p>
        pub fn set_transition_type(
            mut self,
            input: std::option::Option<crate::model::StageTransitionType>,
        ) -> Self {
            self.transition_type = input;
            self
        }
        /// <p>The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableStageTransitionInput`](crate::input::DisableStageTransitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableStageTransitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableStageTransitionInput {
                pipeline_name: self.pipeline_name,
                stage_name: self.stage_name,
                transition_type: self.transition_type,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableStageTransitionInputOperationOutputAlias = crate::operation::DisableStageTransition;
#[doc(hidden)]
pub type DisableStageTransitionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableStageTransitionInput {
    /// Consumes the builder and constructs an Operation<[`DisableStageTransition`](crate::operation::DisableStageTransition)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableStageTransition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisableStageTransitionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisableStageTransitionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.DisableStageTransition",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disable_stage_transition(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableStageTransition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableStageTransition",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisableStageTransitionInput`](crate::input::DisableStageTransitionInput)
    pub fn builder() -> crate::input::disable_stage_transition_input::Builder {
        crate::input::disable_stage_transition_input::Builder::default()
    }
}

/// See [`EnableStageTransitionInput`](crate::input::EnableStageTransitionInput)
pub mod enable_stage_transition_input {
    /// A builder for [`EnableStageTransitionInput`](crate::input::EnableStageTransitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) transition_type: std::option::Option<crate::model::StageTransitionType>,
    }
    impl Builder {
        /// <p>The name of the pipeline in which you want to enable the flow of artifacts from one stage to another.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline in which you want to enable the flow of artifacts from one stage to another.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The name of the stage where you want to enable the transition of artifacts, either into the stage (inbound) or from that stage to the next stage (outbound).</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage where you want to enable the transition of artifacts, either into the stage (inbound) or from that stage to the next stage (outbound).</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>Specifies whether artifacts are allowed to enter the stage and be processed by the actions in that stage (inbound) or whether already processed artifacts are allowed to transition to the next stage (outbound).</p>
        pub fn transition_type(mut self, input: crate::model::StageTransitionType) -> Self {
            self.transition_type = Some(input);
            self
        }
        /// <p>Specifies whether artifacts are allowed to enter the stage and be processed by the actions in that stage (inbound) or whether already processed artifacts are allowed to transition to the next stage (outbound).</p>
        pub fn set_transition_type(
            mut self,
            input: std::option::Option<crate::model::StageTransitionType>,
        ) -> Self {
            self.transition_type = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableStageTransitionInput`](crate::input::EnableStageTransitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableStageTransitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableStageTransitionInput {
                pipeline_name: self.pipeline_name,
                stage_name: self.stage_name,
                transition_type: self.transition_type,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableStageTransitionInputOperationOutputAlias = crate::operation::EnableStageTransition;
#[doc(hidden)]
pub type EnableStageTransitionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableStageTransitionInput {
    /// Consumes the builder and constructs an Operation<[`EnableStageTransition`](crate::operation::EnableStageTransition)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableStageTransition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::EnableStageTransitionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EnableStageTransitionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.EnableStageTransition",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_enable_stage_transition(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableStageTransition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableStageTransition",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EnableStageTransitionInput`](crate::input::EnableStageTransitionInput)
    pub fn builder() -> crate::input::enable_stage_transition_input::Builder {
        crate::input::enable_stage_transition_input::Builder::default()
    }
}

/// See [`GetActionTypeInput`](crate::input::GetActionTypeInput)
pub mod get_action_type_input {
    /// A builder for [`GetActionTypeInput`](crate::input::GetActionTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::ActionCategory>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Defines what kind of action can be taken in the stage. The following are the valid values:</p>
        /// <ul>
        /// <li> <p> <code>Source</code> </p> </li>
        /// <li> <p> <code>Build</code> </p> </li>
        /// <li> <p> <code>Test</code> </p> </li>
        /// <li> <p> <code>Deploy</code> </p> </li>
        /// <li> <p> <code>Approval</code> </p> </li>
        /// <li> <p> <code>Invoke</code> </p> </li>
        /// </ul>
        pub fn category(mut self, input: crate::model::ActionCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>Defines what kind of action can be taken in the stage. The following are the valid values:</p>
        /// <ul>
        /// <li> <p> <code>Source</code> </p> </li>
        /// <li> <p> <code>Build</code> </p> </li>
        /// <li> <p> <code>Test</code> </p> </li>
        /// <li> <p> <code>Deploy</code> </p> </li>
        /// <li> <p> <code>Approval</code> </p> </li>
        /// <li> <p> <code>Invoke</code> </p> </li>
        /// </ul>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The creator of an action type that was created with any supported integration model. There are two valid values: <code>AWS</code> and <code>ThirdParty</code>.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The creator of an action type that was created with any supported integration model. There are two valid values: <code>AWS</code> and <code>ThirdParty</code>.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The provider of the action type being called. The provider name is specified when the action type is created.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the action type being called. The provider name is specified when the action type is created.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>A string that describes the action type version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A string that describes the action type version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetActionTypeInput`](crate::input::GetActionTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetActionTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetActionTypeInput {
                category: self.category,
                owner: self.owner,
                provider: self.provider,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetActionTypeInputOperationOutputAlias = crate::operation::GetActionType;
#[doc(hidden)]
pub type GetActionTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetActionTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetActionType`](crate::operation::GetActionType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetActionType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetActionTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetActionTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.GetActionType",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_action_type(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetActionType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetActionType",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetActionTypeInput`](crate::input::GetActionTypeInput)
    pub fn builder() -> crate::input::get_action_type_input::Builder {
        crate::input::get_action_type_input::Builder::default()
    }
}

/// See [`GetJobDetailsInput`](crate::input::GetJobDetailsInput)
pub mod get_job_details_input {
    /// A builder for [`GetJobDetailsInput`](crate::input::GetJobDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobDetailsInput`](crate::input::GetJobDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJobDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJobDetailsInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobDetailsInputOperationOutputAlias = crate::operation::GetJobDetails;
#[doc(hidden)]
pub type GetJobDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetJobDetails`](crate::operation::GetJobDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJobDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetJobDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetJobDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.GetJobDetails",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_job_details(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJobDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJobDetails",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetJobDetailsInput`](crate::input::GetJobDetailsInput)
    pub fn builder() -> crate::input::get_job_details_input::Builder {
        crate::input::get_job_details_input::Builder::default()
    }
}

/// See [`GetPipelineInput`](crate::input::GetPipelineInput)
pub mod get_pipeline_input {
    /// A builder for [`GetPipelineInput`](crate::input::GetPipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the pipeline for which you want to get information. Pipeline names must be unique under an AWS user account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline for which you want to get information. Pipeline names must be unique under an AWS user account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version number of the pipeline. If you do not specify a version, defaults to the current version.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the pipeline. If you do not specify a version, defaults to the current version.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPipelineInput`](crate::input::GetPipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPipelineInput {
                name: self.name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPipelineInputOperationOutputAlias = crate::operation::GetPipeline;
#[doc(hidden)]
pub type GetPipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPipelineInput {
    /// Consumes the builder and constructs an Operation<[`GetPipeline`](crate::operation::GetPipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.GetPipeline",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_pipeline(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPipeline",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPipelineInput`](crate::input::GetPipelineInput)
    pub fn builder() -> crate::input::get_pipeline_input::Builder {
        crate::input::get_pipeline_input::Builder::default()
    }
}

/// See [`GetPipelineExecutionInput`](crate::input::GetPipelineExecutionInput)
pub mod get_pipeline_execution_input {
    /// A builder for [`GetPipelineExecutionInput`](crate::input::GetPipelineExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline about which you want to get execution details.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline about which you want to get execution details.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The ID of the pipeline execution about which you want to get execution details.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline execution about which you want to get execution details.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPipelineExecutionInput`](crate::input::GetPipelineExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPipelineExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPipelineExecutionInput {
                pipeline_name: self.pipeline_name,
                pipeline_execution_id: self.pipeline_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPipelineExecutionInputOperationOutputAlias = crate::operation::GetPipelineExecution;
#[doc(hidden)]
pub type GetPipelineExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPipelineExecutionInput {
    /// Consumes the builder and constructs an Operation<[`GetPipelineExecution`](crate::operation::GetPipelineExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPipelineExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPipelineExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPipelineExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.GetPipelineExecution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_pipeline_execution(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPipelineExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPipelineExecution",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPipelineExecutionInput`](crate::input::GetPipelineExecutionInput)
    pub fn builder() -> crate::input::get_pipeline_execution_input::Builder {
        crate::input::get_pipeline_execution_input::Builder::default()
    }
}

/// See [`GetPipelineStateInput`](crate::input::GetPipelineStateInput)
pub mod get_pipeline_state_input {
    /// A builder for [`GetPipelineStateInput`](crate::input::GetPipelineStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline about which you want to get information.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline about which you want to get information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPipelineStateInput`](crate::input::GetPipelineStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPipelineStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPipelineStateInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetPipelineStateInputOperationOutputAlias = crate::operation::GetPipelineState;
#[doc(hidden)]
pub type GetPipelineStateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPipelineStateInput {
    /// Consumes the builder and constructs an Operation<[`GetPipelineState`](crate::operation::GetPipelineState)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPipelineState,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPipelineStateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPipelineStateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.GetPipelineState",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_pipeline_state(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPipelineState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPipelineState",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPipelineStateInput`](crate::input::GetPipelineStateInput)
    pub fn builder() -> crate::input::get_pipeline_state_input::Builder {
        crate::input::get_pipeline_state_input::Builder::default()
    }
}

/// See [`GetThirdPartyJobDetailsInput`](crate::input::GetThirdPartyJobDetailsInput)
pub mod get_third_party_job_details_input {
    /// A builder for [`GetThirdPartyJobDetailsInput`](crate::input::GetThirdPartyJobDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID used for identifying the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID used for identifying the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetThirdPartyJobDetailsInput`](crate::input::GetThirdPartyJobDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetThirdPartyJobDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetThirdPartyJobDetailsInput {
                job_id: self.job_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetThirdPartyJobDetailsInputOperationOutputAlias =
    crate::operation::GetThirdPartyJobDetails;
#[doc(hidden)]
pub type GetThirdPartyJobDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetThirdPartyJobDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetThirdPartyJobDetails`](crate::operation::GetThirdPartyJobDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetThirdPartyJobDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetThirdPartyJobDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetThirdPartyJobDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.GetThirdPartyJobDetails",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_third_party_job_details(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetThirdPartyJobDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetThirdPartyJobDetails",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetThirdPartyJobDetailsInput`](crate::input::GetThirdPartyJobDetailsInput)
    pub fn builder() -> crate::input::get_third_party_job_details_input::Builder {
        crate::input::get_third_party_job_details_input::Builder::default()
    }
}

/// See [`ListActionExecutionsInput`](crate::input::ListActionExecutionsInput)
pub mod list_action_executions_input {
    /// A builder for [`ListActionExecutionsInput`](crate::input::ListActionExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::ActionExecutionFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the pipeline for which you want to list action execution history.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p> The name of the pipeline for which you want to list action execution history.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>Input information used to filter action execution history.</p>
        pub fn filter(mut self, input: crate::model::ActionExecutionFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Input information used to filter action execution history.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ActionExecutionFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Action execution history is retained for up to 12 months, based on action execution start times. Default value is 100. </p> <note>
        /// <p>Detailed execution history is available for executions run on or after February 21, 2019.</p>
        /// </note>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Action execution history is retained for up to 12 months, based on action execution start times. Default value is 100. </p> <note>
        /// <p>Detailed execution history is available for executions run on or after February 21, 2019.</p>
        /// </note>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that was returned from the previous <code>ListActionExecutions</code> call, which can be used to return the next set of action executions in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that was returned from the previous <code>ListActionExecutions</code> call, which can be used to return the next set of action executions in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActionExecutionsInput`](crate::input::ListActionExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListActionExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListActionExecutionsInput {
                pipeline_name: self.pipeline_name,
                filter: self.filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListActionExecutionsInputOperationOutputAlias = crate::operation::ListActionExecutions;
#[doc(hidden)]
pub type ListActionExecutionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListActionExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListActionExecutions`](crate::operation::ListActionExecutions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListActionExecutions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListActionExecutionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListActionExecutionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.ListActionExecutions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_action_executions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListActionExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListActionExecutions",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListActionExecutionsInput`](crate::input::ListActionExecutionsInput)
    pub fn builder() -> crate::input::list_action_executions_input::Builder {
        crate::input::list_action_executions_input::Builder::default()
    }
}

/// See [`ListActionTypesInput`](crate::input::ListActionTypesInput)
pub mod list_action_types_input {
    /// A builder for [`ListActionTypesInput`](crate::input::ListActionTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_owner_filter: std::option::Option<crate::model::ActionOwner>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) region_filter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filters the list of action types to those created by a specified entity.</p>
        pub fn action_owner_filter(mut self, input: crate::model::ActionOwner) -> Self {
            self.action_owner_filter = Some(input);
            self
        }
        /// <p>Filters the list of action types to those created by a specified entity.</p>
        pub fn set_action_owner_filter(
            mut self,
            input: std::option::Option<crate::model::ActionOwner>,
        ) -> Self {
            self.action_owner_filter = input;
            self
        }
        /// <p>An identifier that was returned from the previous list action types call, which can be used to return the next set of action types in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous list action types call, which can be used to return the next set of action types in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Region to filter on for the list of action types.</p>
        pub fn region_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_filter = Some(input.into());
            self
        }
        /// <p>The Region to filter on for the list of action types.</p>
        pub fn set_region_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.region_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActionTypesInput`](crate::input::ListActionTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListActionTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListActionTypesInput {
                action_owner_filter: self.action_owner_filter,
                next_token: self.next_token,
                region_filter: self.region_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListActionTypesInputOperationOutputAlias = crate::operation::ListActionTypes;
#[doc(hidden)]
pub type ListActionTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListActionTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListActionTypes`](crate::operation::ListActionTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListActionTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListActionTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListActionTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.ListActionTypes",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_action_types(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListActionTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListActionTypes",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListActionTypesInput`](crate::input::ListActionTypesInput)
    pub fn builder() -> crate::input::list_action_types_input::Builder {
        crate::input::list_action_types_input::Builder::default()
    }
}

/// See [`ListPipelineExecutionsInput`](crate::input::ListPipelineExecutionsInput)
pub mod list_pipeline_executions_input {
    /// A builder for [`ListPipelineExecutionsInput`](crate::input::ListPipelineExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline for which you want to get execution summary information.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline for which you want to get execution summary information.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that was returned from the previous <code>ListPipelineExecutions</code> call, which can be used to return the next set of pipeline executions in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that was returned from the previous <code>ListPipelineExecutions</code> call, which can be used to return the next set of pipeline executions in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelineExecutionsInput`](crate::input::ListPipelineExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPipelineExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPipelineExecutionsInput {
                pipeline_name: self.pipeline_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPipelineExecutionsInputOperationOutputAlias = crate::operation::ListPipelineExecutions;
#[doc(hidden)]
pub type ListPipelineExecutionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPipelineExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPipelineExecutions`](crate::operation::ListPipelineExecutions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPipelineExecutions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPipelineExecutionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPipelineExecutionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.ListPipelineExecutions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pipeline_executions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPipelineExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPipelineExecutions",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPipelineExecutionsInput`](crate::input::ListPipelineExecutionsInput)
    pub fn builder() -> crate::input::list_pipeline_executions_input::Builder {
        crate::input::list_pipeline_executions_input::Builder::default()
    }
}

/// See [`ListPipelinesInput`](crate::input::ListPipelinesInput)
pub mod list_pipelines_input {
    /// A builder for [`ListPipelinesInput`](crate::input::ListPipelinesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An identifier that was returned from the previous list pipelines call. It can be used to return the next set of pipelines in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous list pipelines call. It can be used to return the next set of pipelines in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of pipelines to return in a single call. To retrieve the remaining pipelines, make another call with the returned nextToken value. The minimum value you can specify is 1. The maximum accepted value is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of pipelines to return in a single call. To retrieve the remaining pipelines, make another call with the returned nextToken value. The minimum value you can specify is 1. The maximum accepted value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelinesInput`](crate::input::ListPipelinesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPipelinesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPipelinesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPipelinesInputOperationOutputAlias = crate::operation::ListPipelines;
#[doc(hidden)]
pub type ListPipelinesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPipelinesInput {
    /// Consumes the builder and constructs an Operation<[`ListPipelines`](crate::operation::ListPipelines)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPipelines,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPipelinesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPipelinesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.ListPipelines",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pipelines(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPipelines::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPipelines",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPipelinesInput`](crate::input::ListPipelinesInput)
    pub fn builder() -> crate::input::list_pipelines_input::Builder {
        crate::input::list_pipelines_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The token that was returned from the previous API call, which would be used to return the next page of the list. The ListTagsforResource call lists all available tags in one call and does not use pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that was returned from the previous API call, which would be used to return the next page of the list. The ListTagsforResource call lists all available tags in one call and does not use pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWebhooksInput`](crate::input::ListWebhooksInput)
pub mod list_webhooks_input {
    /// A builder for [`ListWebhooksInput`](crate::input::ListWebhooksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token that was returned from the previous ListWebhooks call, which can be used to return the next set of webhooks in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that was returned from the previous ListWebhooks call, which can be used to return the next set of webhooks in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWebhooksInput`](crate::input::ListWebhooksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWebhooksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWebhooksInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWebhooksInputOperationOutputAlias = crate::operation::ListWebhooks;
#[doc(hidden)]
pub type ListWebhooksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWebhooksInput {
    /// Consumes the builder and constructs an Operation<[`ListWebhooks`](crate::operation::ListWebhooks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWebhooks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListWebhooksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListWebhooksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.ListWebhooks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_webhooks(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWebhooks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWebhooks",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListWebhooksInput`](crate::input::ListWebhooksInput)
    pub fn builder() -> crate::input::list_webhooks_input::Builder {
        crate::input::list_webhooks_input::Builder::default()
    }
}

/// See [`PollForJobsInput`](crate::input::PollForJobsInput)
pub mod poll_for_jobs_input {
    /// A builder for [`PollForJobsInput`](crate::input::PollForJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type_id: std::option::Option<crate::model::ActionTypeId>,
        pub(crate) max_batch_size: std::option::Option<i32>,
        pub(crate) query_param: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Represents information about an action type.</p>
        pub fn action_type_id(mut self, input: crate::model::ActionTypeId) -> Self {
            self.action_type_id = Some(input);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.action_type_id = input;
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.max_batch_size = Some(input);
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_batch_size = input;
            self
        }
        /// Adds a key-value pair to `query_param`.
        ///
        /// To override the contents of this collection use [`set_query_param`](Self::set_query_param).
        ///
        /// <p>A map of property names and values. For an action type with no queryable properties, this value must be null or an empty map. For an action type with a queryable property, you must supply that property as a key in the map. Only jobs whose action configuration matches the mapped value are returned.</p>
        pub fn query_param(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.query_param.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.query_param = Some(hash_map);
            self
        }
        /// <p>A map of property names and values. For an action type with no queryable properties, this value must be null or an empty map. For an action type with a queryable property, you must supply that property as a key in the map. Only jobs whose action configuration matches the mapped value are returned.</p>
        pub fn set_query_param(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.query_param = input;
            self
        }
        /// Consumes the builder and constructs a [`PollForJobsInput`](crate::input::PollForJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PollForJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PollForJobsInput {
                action_type_id: self.action_type_id,
                max_batch_size: self.max_batch_size,
                query_param: self.query_param,
            })
        }
    }
}
#[doc(hidden)]
pub type PollForJobsInputOperationOutputAlias = crate::operation::PollForJobs;
#[doc(hidden)]
pub type PollForJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PollForJobsInput {
    /// Consumes the builder and constructs an Operation<[`PollForJobs`](crate::operation::PollForJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PollForJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PollForJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PollForJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PollForJobs",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_poll_for_jobs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PollForJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PollForJobs",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PollForJobsInput`](crate::input::PollForJobsInput)
    pub fn builder() -> crate::input::poll_for_jobs_input::Builder {
        crate::input::poll_for_jobs_input::Builder::default()
    }
}

/// See [`PollForThirdPartyJobsInput`](crate::input::PollForThirdPartyJobsInput)
pub mod poll_for_third_party_jobs_input {
    /// A builder for [`PollForThirdPartyJobsInput`](crate::input::PollForThirdPartyJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type_id: std::option::Option<crate::model::ActionTypeId>,
        pub(crate) max_batch_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Represents information about an action type.</p>
        pub fn action_type_id(mut self, input: crate::model::ActionTypeId) -> Self {
            self.action_type_id = Some(input);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.action_type_id = input;
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.max_batch_size = Some(input);
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_batch_size = input;
            self
        }
        /// Consumes the builder and constructs a [`PollForThirdPartyJobsInput`](crate::input::PollForThirdPartyJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PollForThirdPartyJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PollForThirdPartyJobsInput {
                action_type_id: self.action_type_id,
                max_batch_size: self.max_batch_size,
            })
        }
    }
}
#[doc(hidden)]
pub type PollForThirdPartyJobsInputOperationOutputAlias = crate::operation::PollForThirdPartyJobs;
#[doc(hidden)]
pub type PollForThirdPartyJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PollForThirdPartyJobsInput {
    /// Consumes the builder and constructs an Operation<[`PollForThirdPartyJobs`](crate::operation::PollForThirdPartyJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PollForThirdPartyJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PollForThirdPartyJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PollForThirdPartyJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PollForThirdPartyJobs",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_poll_for_third_party_jobs(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PollForThirdPartyJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PollForThirdPartyJobs",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PollForThirdPartyJobsInput`](crate::input::PollForThirdPartyJobsInput)
    pub fn builder() -> crate::input::poll_for_third_party_jobs_input::Builder {
        crate::input::poll_for_third_party_jobs_input::Builder::default()
    }
}

/// See [`PutActionRevisionInput`](crate::input::PutActionRevisionInput)
pub mod put_action_revision_input {
    /// A builder for [`PutActionRevisionInput`](crate::input::PutActionRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) action_revision: std::option::Option<crate::model::ActionRevision>,
    }
    impl Builder {
        /// <p>The name of the pipeline that starts processing the revision to the source.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline that starts processing the revision to the source.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The name of the stage that contains the action that acts on the revision.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage that contains the action that acts on the revision.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The name of the action that processes the revision.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action that processes the revision.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>Represents information about the version (or revision) of an action.</p>
        pub fn action_revision(mut self, input: crate::model::ActionRevision) -> Self {
            self.action_revision = Some(input);
            self
        }
        /// <p>Represents information about the version (or revision) of an action.</p>
        pub fn set_action_revision(
            mut self,
            input: std::option::Option<crate::model::ActionRevision>,
        ) -> Self {
            self.action_revision = input;
            self
        }
        /// Consumes the builder and constructs a [`PutActionRevisionInput`](crate::input::PutActionRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutActionRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutActionRevisionInput {
                pipeline_name: self.pipeline_name,
                stage_name: self.stage_name,
                action_name: self.action_name,
                action_revision: self.action_revision,
            })
        }
    }
}
#[doc(hidden)]
pub type PutActionRevisionInputOperationOutputAlias = crate::operation::PutActionRevision;
#[doc(hidden)]
pub type PutActionRevisionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutActionRevisionInput {
    /// Consumes the builder and constructs an Operation<[`PutActionRevision`](crate::operation::PutActionRevision)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutActionRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutActionRevisionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutActionRevisionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PutActionRevision",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_action_revision(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutActionRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutActionRevision",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutActionRevisionInput`](crate::input::PutActionRevisionInput)
    pub fn builder() -> crate::input::put_action_revision_input::Builder {
        crate::input::put_action_revision_input::Builder::default()
    }
}

/// See [`PutApprovalResultInput`](crate::input::PutApprovalResultInput)
pub mod put_approval_result_input {
    /// A builder for [`PutApprovalResultInput`](crate::input::PutApprovalResultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) result: std::option::Option<crate::model::ApprovalResult>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline that contains the action. </p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline that contains the action. </p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The name of the stage that contains the action.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage that contains the action.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The name of the action for which approval is requested.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action for which approval is requested.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>Represents information about the result of the approval request.</p>
        pub fn result(mut self, input: crate::model::ApprovalResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>Represents information about the result of the approval request.</p>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ApprovalResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> action. It is used to validate that the approval request corresponding to this token is still valid.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> action. It is used to validate that the approval request corresponding to this token is still valid.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`PutApprovalResultInput`](crate::input::PutApprovalResultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutApprovalResultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutApprovalResultInput {
                pipeline_name: self.pipeline_name,
                stage_name: self.stage_name,
                action_name: self.action_name,
                result: self.result,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type PutApprovalResultInputOperationOutputAlias = crate::operation::PutApprovalResult;
#[doc(hidden)]
pub type PutApprovalResultInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutApprovalResultInput {
    /// Consumes the builder and constructs an Operation<[`PutApprovalResult`](crate::operation::PutApprovalResult)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutApprovalResult,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutApprovalResultInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutApprovalResultInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PutApprovalResult",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_approval_result(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutApprovalResult::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutApprovalResult",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutApprovalResultInput`](crate::input::PutApprovalResultInput)
    pub fn builder() -> crate::input::put_approval_result_input::Builder {
        crate::input::put_approval_result_input::Builder::default()
    }
}

/// See [`PutJobFailureResultInput`](crate::input::PutJobFailureResultInput)
pub mod put_job_failure_result_input {
    /// A builder for [`PutJobFailureResultInput`](crate::input::PutJobFailureResultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the job that failed. This is the same ID returned from <code>PollForJobs</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the job that failed. This is the same ID returned from <code>PollForJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The details about the failure of a job.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>The details about the failure of a job.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PutJobFailureResultInput`](crate::input::PutJobFailureResultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutJobFailureResultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutJobFailureResultInput {
                job_id: self.job_id,
                failure_details: self.failure_details,
            })
        }
    }
}
#[doc(hidden)]
pub type PutJobFailureResultInputOperationOutputAlias = crate::operation::PutJobFailureResult;
#[doc(hidden)]
pub type PutJobFailureResultInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutJobFailureResultInput {
    /// Consumes the builder and constructs an Operation<[`PutJobFailureResult`](crate::operation::PutJobFailureResult)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutJobFailureResult,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutJobFailureResultInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutJobFailureResultInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PutJobFailureResult",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_job_failure_result(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutJobFailureResult::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutJobFailureResult",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutJobFailureResultInput`](crate::input::PutJobFailureResultInput)
    pub fn builder() -> crate::input::put_job_failure_result_input::Builder {
        crate::input::put_job_failure_result_input::Builder::default()
    }
}

/// See [`PutJobSuccessResultInput`](crate::input::PutJobSuccessResultInput)
pub mod put_job_success_result_input {
    /// A builder for [`PutJobSuccessResultInput`](crate::input::PutJobSuccessResultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) current_revision: std::option::Option<crate::model::CurrentRevision>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) execution_details: std::option::Option<crate::model::ExecutionDetails>,
        pub(crate) output_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the job that succeeded. This is the same ID returned from <code>PollForJobs</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the job that succeeded. This is the same ID returned from <code>PollForJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The ID of the current revision of the artifact successfully worked on by the job.</p>
        pub fn current_revision(mut self, input: crate::model::CurrentRevision) -> Self {
            self.current_revision = Some(input);
            self
        }
        /// <p>The ID of the current revision of the artifact successfully worked on by the job.</p>
        pub fn set_current_revision(
            mut self,
            input: std::option::Option<crate::model::CurrentRevision>,
        ) -> Self {
            self.current_revision = input;
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a custom action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the custom action. When the action is complete, no continuation token should be supplied.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a custom action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the custom action. When the action is complete, no continuation token should be supplied.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The execution details of the successful job, such as the actions taken by the job worker.</p>
        pub fn execution_details(mut self, input: crate::model::ExecutionDetails) -> Self {
            self.execution_details = Some(input);
            self
        }
        /// <p>The execution details of the successful job, such as the actions taken by the job worker.</p>
        pub fn set_execution_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionDetails>,
        ) -> Self {
            self.execution_details = input;
            self
        }
        /// Adds a key-value pair to `output_variables`.
        ///
        /// To override the contents of this collection use [`set_output_variables`](Self::set_output_variables).
        ///
        /// <p>Key-value pairs produced as output by a job worker that can be made available to a downstream action configuration. <code>outputVariables</code> can be included only when there is no continuation token on the request.</p>
        pub fn output_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.output_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.output_variables = Some(hash_map);
            self
        }
        /// <p>Key-value pairs produced as output by a job worker that can be made available to a downstream action configuration. <code>outputVariables</code> can be included only when there is no continuation token on the request.</p>
        pub fn set_output_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.output_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`PutJobSuccessResultInput`](crate::input::PutJobSuccessResultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutJobSuccessResultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutJobSuccessResultInput {
                job_id: self.job_id,
                current_revision: self.current_revision,
                continuation_token: self.continuation_token,
                execution_details: self.execution_details,
                output_variables: self.output_variables,
            })
        }
    }
}
#[doc(hidden)]
pub type PutJobSuccessResultInputOperationOutputAlias = crate::operation::PutJobSuccessResult;
#[doc(hidden)]
pub type PutJobSuccessResultInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutJobSuccessResultInput {
    /// Consumes the builder and constructs an Operation<[`PutJobSuccessResult`](crate::operation::PutJobSuccessResult)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutJobSuccessResult,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutJobSuccessResultInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutJobSuccessResultInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PutJobSuccessResult",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_job_success_result(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutJobSuccessResult::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutJobSuccessResult",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutJobSuccessResultInput`](crate::input::PutJobSuccessResultInput)
    pub fn builder() -> crate::input::put_job_success_result_input::Builder {
        crate::input::put_job_success_result_input::Builder::default()
    }
}

/// See [`PutThirdPartyJobFailureResultInput`](crate::input::PutThirdPartyJobFailureResultInput)
pub mod put_third_party_job_failure_result_input {
    /// A builder for [`PutThirdPartyJobFailureResultInput`](crate::input::PutThirdPartyJobFailureResultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
    }
    impl Builder {
        /// <p>The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Represents information about failure details.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Represents information about failure details.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PutThirdPartyJobFailureResultInput`](crate::input::PutThirdPartyJobFailureResultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutThirdPartyJobFailureResultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutThirdPartyJobFailureResultInput {
                job_id: self.job_id,
                client_token: self.client_token,
                failure_details: self.failure_details,
            })
        }
    }
}
#[doc(hidden)]
pub type PutThirdPartyJobFailureResultInputOperationOutputAlias =
    crate::operation::PutThirdPartyJobFailureResult;
#[doc(hidden)]
pub type PutThirdPartyJobFailureResultInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutThirdPartyJobFailureResultInput {
    /// Consumes the builder and constructs an Operation<[`PutThirdPartyJobFailureResult`](crate::operation::PutThirdPartyJobFailureResult)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutThirdPartyJobFailureResult,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutThirdPartyJobFailureResultInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutThirdPartyJobFailureResultInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PutThirdPartyJobFailureResult",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_third_party_job_failure_result(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutThirdPartyJobFailureResult::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutThirdPartyJobFailureResult",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutThirdPartyJobFailureResultInput`](crate::input::PutThirdPartyJobFailureResultInput)
    pub fn builder() -> crate::input::put_third_party_job_failure_result_input::Builder {
        crate::input::put_third_party_job_failure_result_input::Builder::default()
    }
}

/// See [`PutThirdPartyJobSuccessResultInput`](crate::input::PutThirdPartyJobSuccessResultInput)
pub mod put_third_party_job_success_result_input {
    /// A builder for [`PutThirdPartyJobSuccessResultInput`](crate::input::PutThirdPartyJobSuccessResultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) current_revision: std::option::Option<crate::model::CurrentRevision>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) execution_details: std::option::Option<crate::model::ExecutionDetails>,
    }
    impl Builder {
        /// <p>The ID of the job that successfully completed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job that successfully completed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Represents information about a current revision.</p>
        pub fn current_revision(mut self, input: crate::model::CurrentRevision) -> Self {
            self.current_revision = Some(input);
            self
        }
        /// <p>Represents information about a current revision.</p>
        pub fn set_current_revision(
            mut self,
            input: std::option::Option<crate::model::CurrentRevision>,
        ) -> Self {
            self.current_revision = input;
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a partner action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the partner action. When the action is complete, no continuation token should be supplied.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a partner action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the partner action. When the action is complete, no continuation token should be supplied.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline. </p>
        pub fn execution_details(mut self, input: crate::model::ExecutionDetails) -> Self {
            self.execution_details = Some(input);
            self
        }
        /// <p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline. </p>
        pub fn set_execution_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionDetails>,
        ) -> Self {
            self.execution_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PutThirdPartyJobSuccessResultInput`](crate::input::PutThirdPartyJobSuccessResultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutThirdPartyJobSuccessResultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutThirdPartyJobSuccessResultInput {
                job_id: self.job_id,
                client_token: self.client_token,
                current_revision: self.current_revision,
                continuation_token: self.continuation_token,
                execution_details: self.execution_details,
            })
        }
    }
}
#[doc(hidden)]
pub type PutThirdPartyJobSuccessResultInputOperationOutputAlias =
    crate::operation::PutThirdPartyJobSuccessResult;
#[doc(hidden)]
pub type PutThirdPartyJobSuccessResultInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutThirdPartyJobSuccessResultInput {
    /// Consumes the builder and constructs an Operation<[`PutThirdPartyJobSuccessResult`](crate::operation::PutThirdPartyJobSuccessResult)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutThirdPartyJobSuccessResult,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutThirdPartyJobSuccessResultInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutThirdPartyJobSuccessResultInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PutThirdPartyJobSuccessResult",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_third_party_job_success_result(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutThirdPartyJobSuccessResult::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutThirdPartyJobSuccessResult",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutThirdPartyJobSuccessResultInput`](crate::input::PutThirdPartyJobSuccessResultInput)
    pub fn builder() -> crate::input::put_third_party_job_success_result_input::Builder {
        crate::input::put_third_party_job_success_result_input::Builder::default()
    }
}

/// See [`PutWebhookInput`](crate::input::PutWebhookInput)
pub mod put_webhook_input {
    /// A builder for [`PutWebhookInput`](crate::input::PutWebhookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::WebhookDefinition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The detail provided in an input file to create the webhook, such as the webhook name, the pipeline name, and the action name. Give the webhook a unique name that helps you identify it. You might name the webhook after the pipeline and action it targets so that you can easily recognize what it's used for later.</p>
        pub fn webhook(mut self, input: crate::model::WebhookDefinition) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p>The detail provided in an input file to create the webhook, such as the webhook name, the pipeline name, and the action name. Give the webhook a unique name that helps you identify it. You might name the webhook after the pipeline and action it targets so that you can easily recognize what it's used for later.</p>
        pub fn set_webhook(
            mut self,
            input: std::option::Option<crate::model::WebhookDefinition>,
        ) -> Self {
            self.webhook = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the webhook.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the webhook.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutWebhookInput`](crate::input::PutWebhookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutWebhookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutWebhookInput {
                webhook: self.webhook,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutWebhookInputOperationOutputAlias = crate::operation::PutWebhook;
#[doc(hidden)]
pub type PutWebhookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutWebhookInput {
    /// Consumes the builder and constructs an Operation<[`PutWebhook`](crate::operation::PutWebhook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutWebhook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutWebhookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutWebhookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.PutWebhook",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_webhook(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutWebhook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutWebhook",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutWebhookInput`](crate::input::PutWebhookInput)
    pub fn builder() -> crate::input::put_webhook_input::Builder {
        crate::input::put_webhook_input::Builder::default()
    }
}

/// See [`RegisterWebhookWithThirdPartyInput`](crate::input::RegisterWebhookWithThirdPartyInput)
pub mod register_webhook_with_third_party_input {
    /// A builder for [`RegisterWebhookWithThirdPartyInput`](crate::input::RegisterWebhookWithThirdPartyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an existing webhook created with PutWebhook to register with a supported third party. </p>
        pub fn webhook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.webhook_name = Some(input.into());
            self
        }
        /// <p>The name of an existing webhook created with PutWebhook to register with a supported third party. </p>
        pub fn set_webhook_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.webhook_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterWebhookWithThirdPartyInput`](crate::input::RegisterWebhookWithThirdPartyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterWebhookWithThirdPartyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterWebhookWithThirdPartyInput {
                webhook_name: self.webhook_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterWebhookWithThirdPartyInputOperationOutputAlias =
    crate::operation::RegisterWebhookWithThirdParty;
#[doc(hidden)]
pub type RegisterWebhookWithThirdPartyInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RegisterWebhookWithThirdPartyInput {
    /// Consumes the builder and constructs an Operation<[`RegisterWebhookWithThirdParty`](crate::operation::RegisterWebhookWithThirdParty)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterWebhookWithThirdParty,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RegisterWebhookWithThirdPartyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RegisterWebhookWithThirdPartyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.RegisterWebhookWithThirdParty",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_register_webhook_with_third_party(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterWebhookWithThirdParty::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterWebhookWithThirdParty",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RegisterWebhookWithThirdPartyInput`](crate::input::RegisterWebhookWithThirdPartyInput)
    pub fn builder() -> crate::input::register_webhook_with_third_party_input::Builder {
        crate::input::register_webhook_with_third_party_input::Builder::default()
    }
}

/// See [`RetryStageExecutionInput`](crate::input::RetryStageExecutionInput)
pub mod retry_stage_execution_input {
    /// A builder for [`RetryStageExecutionInput`](crate::input::RetryStageExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
        pub(crate) retry_mode: std::option::Option<crate::model::StageRetryMode>,
    }
    impl Builder {
        /// <p>The name of the pipeline that contains the failed stage.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline that contains the failed stage.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The name of the failed stage to be retried.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the failed stage to be retried.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The ID of the pipeline execution in the failed stage to be retried. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId of the failed stage</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline execution in the failed stage to be retried. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId of the failed stage</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// <p>The scope of the retry attempt. Currently, the only supported value is FAILED_ACTIONS.</p>
        pub fn retry_mode(mut self, input: crate::model::StageRetryMode) -> Self {
            self.retry_mode = Some(input);
            self
        }
        /// <p>The scope of the retry attempt. Currently, the only supported value is FAILED_ACTIONS.</p>
        pub fn set_retry_mode(
            mut self,
            input: std::option::Option<crate::model::StageRetryMode>,
        ) -> Self {
            self.retry_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryStageExecutionInput`](crate::input::RetryStageExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RetryStageExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RetryStageExecutionInput {
                pipeline_name: self.pipeline_name,
                stage_name: self.stage_name,
                pipeline_execution_id: self.pipeline_execution_id,
                retry_mode: self.retry_mode,
            })
        }
    }
}
#[doc(hidden)]
pub type RetryStageExecutionInputOperationOutputAlias = crate::operation::RetryStageExecution;
#[doc(hidden)]
pub type RetryStageExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RetryStageExecutionInput {
    /// Consumes the builder and constructs an Operation<[`RetryStageExecution`](crate::operation::RetryStageExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RetryStageExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RetryStageExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RetryStageExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.RetryStageExecution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_retry_stage_execution(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RetryStageExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RetryStageExecution",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RetryStageExecutionInput`](crate::input::RetryStageExecutionInput)
    pub fn builder() -> crate::input::retry_stage_execution_input::Builder {
        crate::input::retry_stage_execution_input::Builder::default()
    }
}

/// See [`StartPipelineExecutionInput`](crate::input::StartPipelineExecutionInput)
pub mod start_pipeline_execution_input {
    /// A builder for [`StartPipelineExecutionInput`](crate::input::StartPipelineExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline to start.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline to start.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The system-generated unique ID used to identify a unique execution request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The system-generated unique ID used to identify a unique execution request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartPipelineExecutionInput`](crate::input::StartPipelineExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartPipelineExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartPipelineExecutionInput {
                name: self.name,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartPipelineExecutionInputOperationOutputAlias = crate::operation::StartPipelineExecution;
#[doc(hidden)]
pub type StartPipelineExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartPipelineExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartPipelineExecution`](crate::operation::StartPipelineExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartPipelineExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartPipelineExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartPipelineExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.StartPipelineExecution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_pipeline_execution(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartPipelineExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartPipelineExecution",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartPipelineExecutionInput`](crate::input::StartPipelineExecutionInput)
    pub fn builder() -> crate::input::start_pipeline_execution_input::Builder {
        crate::input::start_pipeline_execution_input::Builder::default()
    }
}

/// See [`StopPipelineExecutionInput`](crate::input::StopPipelineExecutionInput)
pub mod stop_pipeline_execution_input {
    /// A builder for [`StopPipelineExecutionInput`](crate::input::StopPipelineExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
        pub(crate) abandon: std::option::Option<bool>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline to stop.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline to stop.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The ID of the pipeline execution to be stopped in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline execution to be stopped in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// <p>Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.</p> <note>
        /// <p>This option can lead to failed or out-of-sequence tasks.</p>
        /// </note>
        pub fn abandon(mut self, input: bool) -> Self {
            self.abandon = Some(input);
            self
        }
        /// <p>Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.</p> <note>
        /// <p>This option can lead to failed or out-of-sequence tasks.</p>
        /// </note>
        pub fn set_abandon(mut self, input: std::option::Option<bool>) -> Self {
            self.abandon = input;
            self
        }
        /// <p>Use this option to enter comments, such as the reason the pipeline was stopped.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Use this option to enter comments, such as the reason the pipeline was stopped.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`StopPipelineExecutionInput`](crate::input::StopPipelineExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopPipelineExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopPipelineExecutionInput {
                pipeline_name: self.pipeline_name,
                pipeline_execution_id: self.pipeline_execution_id,
                abandon: self.abandon.unwrap_or_default(),
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type StopPipelineExecutionInputOperationOutputAlias = crate::operation::StopPipelineExecution;
#[doc(hidden)]
pub type StopPipelineExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopPipelineExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StopPipelineExecution`](crate::operation::StopPipelineExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopPipelineExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopPipelineExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopPipelineExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.StopPipelineExecution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_pipeline_execution(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopPipelineExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopPipelineExecution",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopPipelineExecutionInput`](crate::input::StopPipelineExecutionInput)
    pub fn builder() -> crate::input::stop_pipeline_execution_input::Builder {
        crate::input::stop_pipeline_execution_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys for the tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of keys for the tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateActionTypeInput`](crate::input::UpdateActionTypeInput)
pub mod update_action_type_input {
    /// A builder for [`UpdateActionTypeInput`](crate::input::UpdateActionTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<crate::model::ActionTypeDeclaration>,
    }
    impl Builder {
        /// <p>The action type definition for the action type to be updated.</p>
        pub fn action_type(mut self, input: crate::model::ActionTypeDeclaration) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The action type definition for the action type to be updated.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionTypeDeclaration>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateActionTypeInput`](crate::input::UpdateActionTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateActionTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateActionTypeInput {
                action_type: self.action_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateActionTypeInputOperationOutputAlias = crate::operation::UpdateActionType;
#[doc(hidden)]
pub type UpdateActionTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateActionTypeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateActionType`](crate::operation::UpdateActionType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateActionType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateActionTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateActionTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.UpdateActionType",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_action_type(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateActionType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateActionType",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateActionTypeInput`](crate::input::UpdateActionTypeInput)
    pub fn builder() -> crate::input::update_action_type_input::Builder {
        crate::input::update_action_type_input::Builder::default()
    }
}

/// See [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
pub mod update_pipeline_input {
    /// A builder for [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::PipelineDeclaration>,
    }
    impl Builder {
        /// <p>The name of the pipeline to be updated.</p>
        pub fn pipeline(mut self, input: crate::model::PipelineDeclaration) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>The name of the pipeline to be updated.</p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::PipelineDeclaration>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePipelineInput {
                pipeline: self.pipeline,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePipelineInputOperationOutputAlias = crate::operation::UpdatePipeline;
#[doc(hidden)]
pub type UpdatePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePipelineInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePipeline`](crate::operation::UpdatePipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodePipeline_20150709.UpdatePipeline",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pipeline(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePipeline",
            "codepipeline",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
    pub fn builder() -> crate::input::update_pipeline_input::Builder {
        crate::input::update_pipeline_input::Builder::default()
    }
}

/// <p>Represents the input of an <code>UpdatePipeline</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePipelineInput {
    /// <p>The name of the pipeline to be updated.</p>
    pub pipeline: std::option::Option<crate::model::PipelineDeclaration>,
}
impl UpdatePipelineInput {
    /// <p>The name of the pipeline to be updated.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::PipelineDeclaration> {
        self.pipeline.as_ref()
    }
}
impl std::fmt::Debug for UpdatePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePipelineInput");
        formatter.field("pipeline", &self.pipeline);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateActionTypeInput {
    /// <p>The action type definition for the action type to be updated.</p>
    pub action_type: std::option::Option<crate::model::ActionTypeDeclaration>,
}
impl UpdateActionTypeInput {
    /// <p>The action type definition for the action type to be updated.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ActionTypeDeclaration> {
        self.action_type.as_ref()
    }
}
impl std::fmt::Debug for UpdateActionTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateActionTypeInput");
        formatter.field("action_type", &self.action_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of keys for the tags to be removed from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of keys for the tags to be removed from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags you want to modify or add to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags you want to modify or add to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopPipelineExecutionInput {
    /// <p>The name of the pipeline to stop.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The ID of the pipeline execution to be stopped in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
    /// <p>Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.</p> <note>
    /// <p>This option can lead to failed or out-of-sequence tasks.</p>
    /// </note>
    pub abandon: bool,
    /// <p>Use this option to enter comments, such as the reason the pipeline was stopped.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl StopPipelineExecutionInput {
    /// <p>The name of the pipeline to stop.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The ID of the pipeline execution to be stopped in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
    /// <p>Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.</p> <note>
    /// <p>This option can lead to failed or out-of-sequence tasks.</p>
    /// </note>
    pub fn abandon(&self) -> bool {
        self.abandon
    }
    /// <p>Use this option to enter comments, such as the reason the pipeline was stopped.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for StopPipelineExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopPipelineExecutionInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.field("abandon", &self.abandon);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>StartPipelineExecution</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartPipelineExecutionInput {
    /// <p>The name of the pipeline to start.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The system-generated unique ID used to identify a unique execution request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl StartPipelineExecutionInput {
    /// <p>The name of the pipeline to start.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The system-generated unique ID used to identify a unique execution request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for StartPipelineExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartPipelineExecutionInput");
        formatter.field("name", &self.name);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>RetryStageExecution</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryStageExecutionInput {
    /// <p>The name of the pipeline that contains the failed stage.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The name of the failed stage to be retried.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The ID of the pipeline execution in the failed stage to be retried. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId of the failed stage</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
    /// <p>The scope of the retry attempt. Currently, the only supported value is FAILED_ACTIONS.</p>
    pub retry_mode: std::option::Option<crate::model::StageRetryMode>,
}
impl RetryStageExecutionInput {
    /// <p>The name of the pipeline that contains the failed stage.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The name of the failed stage to be retried.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The ID of the pipeline execution in the failed stage to be retried. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId of the failed stage</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
    /// <p>The scope of the retry attempt. Currently, the only supported value is FAILED_ACTIONS.</p>
    pub fn retry_mode(&self) -> std::option::Option<&crate::model::StageRetryMode> {
        self.retry_mode.as_ref()
    }
}
impl std::fmt::Debug for RetryStageExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryStageExecutionInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.field("retry_mode", &self.retry_mode);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterWebhookWithThirdPartyInput {
    /// <p>The name of an existing webhook created with PutWebhook to register with a supported third party. </p>
    pub webhook_name: std::option::Option<std::string::String>,
}
impl RegisterWebhookWithThirdPartyInput {
    /// <p>The name of an existing webhook created with PutWebhook to register with a supported third party. </p>
    pub fn webhook_name(&self) -> std::option::Option<&str> {
        self.webhook_name.as_deref()
    }
}
impl std::fmt::Debug for RegisterWebhookWithThirdPartyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterWebhookWithThirdPartyInput");
        formatter.field("webhook_name", &self.webhook_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutWebhookInput {
    /// <p>The detail provided in an input file to create the webhook, such as the webhook name, the pipeline name, and the action name. Give the webhook a unique name that helps you identify it. You might name the webhook after the pipeline and action it targets so that you can easily recognize what it's used for later.</p>
    pub webhook: std::option::Option<crate::model::WebhookDefinition>,
    /// <p>The tags for the webhook.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutWebhookInput {
    /// <p>The detail provided in an input file to create the webhook, such as the webhook name, the pipeline name, and the action name. Give the webhook a unique name that helps you identify it. You might name the webhook after the pipeline and action it targets so that you can easily recognize what it's used for later.</p>
    pub fn webhook(&self) -> std::option::Option<&crate::model::WebhookDefinition> {
        self.webhook.as_ref()
    }
    /// <p>The tags for the webhook.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutWebhookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutWebhookInput");
        formatter.field("webhook", &self.webhook);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PutThirdPartyJobSuccessResult</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutThirdPartyJobSuccessResultInput {
    /// <p>The ID of the job that successfully completed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Represents information about a current revision.</p>
    pub current_revision: std::option::Option<crate::model::CurrentRevision>,
    /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a partner action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the partner action. When the action is complete, no continuation token should be supplied.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline. </p>
    pub execution_details: std::option::Option<crate::model::ExecutionDetails>,
}
impl PutThirdPartyJobSuccessResultInput {
    /// <p>The ID of the job that successfully completed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Represents information about a current revision.</p>
    pub fn current_revision(&self) -> std::option::Option<&crate::model::CurrentRevision> {
        self.current_revision.as_ref()
    }
    /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a partner action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the partner action. When the action is complete, no continuation token should be supplied.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline. </p>
    pub fn execution_details(&self) -> std::option::Option<&crate::model::ExecutionDetails> {
        self.execution_details.as_ref()
    }
}
impl std::fmt::Debug for PutThirdPartyJobSuccessResultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutThirdPartyJobSuccessResultInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("current_revision", &self.current_revision);
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("execution_details", &self.execution_details);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PutThirdPartyJobFailureResult</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutThirdPartyJobFailureResultInput {
    /// <p>The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Represents information about failure details.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
}
impl PutThirdPartyJobFailureResultInput {
    /// <p>The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Represents information about failure details.</p>
    pub fn failure_details(&self) -> std::option::Option<&crate::model::FailureDetails> {
        self.failure_details.as_ref()
    }
}
impl std::fmt::Debug for PutThirdPartyJobFailureResultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutThirdPartyJobFailureResultInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("failure_details", &self.failure_details);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PutJobSuccessResult</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutJobSuccessResultInput {
    /// <p>The unique system-generated ID of the job that succeeded. This is the same ID returned from <code>PollForJobs</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The ID of the current revision of the artifact successfully worked on by the job.</p>
    pub current_revision: std::option::Option<crate::model::CurrentRevision>,
    /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a custom action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the custom action. When the action is complete, no continuation token should be supplied.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>The execution details of the successful job, such as the actions taken by the job worker.</p>
    pub execution_details: std::option::Option<crate::model::ExecutionDetails>,
    /// <p>Key-value pairs produced as output by a job worker that can be made available to a downstream action configuration. <code>outputVariables</code> can be included only when there is no continuation token on the request.</p>
    pub output_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutJobSuccessResultInput {
    /// <p>The unique system-generated ID of the job that succeeded. This is the same ID returned from <code>PollForJobs</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The ID of the current revision of the artifact successfully worked on by the job.</p>
    pub fn current_revision(&self) -> std::option::Option<&crate::model::CurrentRevision> {
        self.current_revision.as_ref()
    }
    /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a custom action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the custom action. When the action is complete, no continuation token should be supplied.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>The execution details of the successful job, such as the actions taken by the job worker.</p>
    pub fn execution_details(&self) -> std::option::Option<&crate::model::ExecutionDetails> {
        self.execution_details.as_ref()
    }
    /// <p>Key-value pairs produced as output by a job worker that can be made available to a downstream action configuration. <code>outputVariables</code> can be included only when there is no continuation token on the request.</p>
    pub fn output_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.output_variables.as_ref()
    }
}
impl std::fmt::Debug for PutJobSuccessResultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutJobSuccessResultInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("current_revision", &self.current_revision);
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("execution_details", &self.execution_details);
        formatter.field("output_variables", &self.output_variables);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PutJobFailureResult</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutJobFailureResultInput {
    /// <p>The unique system-generated ID of the job that failed. This is the same ID returned from <code>PollForJobs</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The details about the failure of a job.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
}
impl PutJobFailureResultInput {
    /// <p>The unique system-generated ID of the job that failed. This is the same ID returned from <code>PollForJobs</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The details about the failure of a job.</p>
    pub fn failure_details(&self) -> std::option::Option<&crate::model::FailureDetails> {
        self.failure_details.as_ref()
    }
}
impl std::fmt::Debug for PutJobFailureResultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutJobFailureResultInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("failure_details", &self.failure_details);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PutApprovalResult</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutApprovalResultInput {
    /// <p>The name of the pipeline that contains the action. </p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage that contains the action.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The name of the action for which approval is requested.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>Represents information about the result of the approval request.</p>
    pub result: std::option::Option<crate::model::ApprovalResult>,
    /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> action. It is used to validate that the approval request corresponding to this token is still valid.</p>
    pub token: std::option::Option<std::string::String>,
}
impl PutApprovalResultInput {
    /// <p>The name of the pipeline that contains the action. </p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The name of the stage that contains the action.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The name of the action for which approval is requested.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>Represents information about the result of the approval request.</p>
    pub fn result(&self) -> std::option::Option<&crate::model::ApprovalResult> {
        self.result.as_ref()
    }
    /// <p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> action. It is used to validate that the approval request corresponding to this token is still valid.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
}
impl std::fmt::Debug for PutApprovalResultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutApprovalResultInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("action_name", &self.action_name);
        formatter.field("result", &self.result);
        formatter.field("token", &self.token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PutActionRevision</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutActionRevisionInput {
    /// <p>The name of the pipeline that starts processing the revision to the source.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage that contains the action that acts on the revision.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The name of the action that processes the revision.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>Represents information about the version (or revision) of an action.</p>
    pub action_revision: std::option::Option<crate::model::ActionRevision>,
}
impl PutActionRevisionInput {
    /// <p>The name of the pipeline that starts processing the revision to the source.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The name of the stage that contains the action that acts on the revision.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The name of the action that processes the revision.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>Represents information about the version (or revision) of an action.</p>
    pub fn action_revision(&self) -> std::option::Option<&crate::model::ActionRevision> {
        self.action_revision.as_ref()
    }
}
impl std::fmt::Debug for PutActionRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutActionRevisionInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("action_name", &self.action_name);
        formatter.field("action_revision", &self.action_revision);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PollForThirdPartyJobs</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PollForThirdPartyJobsInput {
    /// <p>Represents information about an action type.</p>
    pub action_type_id: std::option::Option<crate::model::ActionTypeId>,
    /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
    pub max_batch_size: std::option::Option<i32>,
}
impl PollForThirdPartyJobsInput {
    /// <p>Represents information about an action type.</p>
    pub fn action_type_id(&self) -> std::option::Option<&crate::model::ActionTypeId> {
        self.action_type_id.as_ref()
    }
    /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
    pub fn max_batch_size(&self) -> std::option::Option<i32> {
        self.max_batch_size
    }
}
impl std::fmt::Debug for PollForThirdPartyJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PollForThirdPartyJobsInput");
        formatter.field("action_type_id", &self.action_type_id);
        formatter.field("max_batch_size", &self.max_batch_size);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PollForJobs</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PollForJobsInput {
    /// <p>Represents information about an action type.</p>
    pub action_type_id: std::option::Option<crate::model::ActionTypeId>,
    /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
    pub max_batch_size: std::option::Option<i32>,
    /// <p>A map of property names and values. For an action type with no queryable properties, this value must be null or an empty map. For an action type with a queryable property, you must supply that property as a key in the map. Only jobs whose action configuration matches the mapped value are returned.</p>
    pub query_param:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PollForJobsInput {
    /// <p>Represents information about an action type.</p>
    pub fn action_type_id(&self) -> std::option::Option<&crate::model::ActionTypeId> {
        self.action_type_id.as_ref()
    }
    /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
    pub fn max_batch_size(&self) -> std::option::Option<i32> {
        self.max_batch_size
    }
    /// <p>A map of property names and values. For an action type with no queryable properties, this value must be null or an empty map. For an action type with a queryable property, you must supply that property as a key in the map. Only jobs whose action configuration matches the mapped value are returned.</p>
    pub fn query_param(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.query_param.as_ref()
    }
}
impl std::fmt::Debug for PollForJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PollForJobsInput");
        formatter.field("action_type_id", &self.action_type_id);
        formatter.field("max_batch_size", &self.max_batch_size);
        formatter.field("query_param", &self.query_param);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWebhooksInput {
    /// <p>The token that was returned from the previous ListWebhooks call, which can be used to return the next set of webhooks in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListWebhooksInput {
    /// <p>The token that was returned from the previous ListWebhooks call, which can be used to return the next set of webhooks in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListWebhooksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWebhooksInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The token that was returned from the previous API call, which would be used to return the next page of the list. The ListTagsforResource call lists all available tags in one call and does not use pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The token that was returned from the previous API call, which would be used to return the next page of the list. The ListTagsforResource call lists all available tags in one call and does not use pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListPipelines</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelinesInput {
    /// <p>An identifier that was returned from the previous list pipelines call. It can be used to return the next set of pipelines in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of pipelines to return in a single call. To retrieve the remaining pipelines, make another call with the returned nextToken value. The minimum value you can specify is 1. The maximum accepted value is 1000.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPipelinesInput {
    /// <p>An identifier that was returned from the previous list pipelines call. It can be used to return the next set of pipelines in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of pipelines to return in a single call. To retrieve the remaining pipelines, make another call with the returned nextToken value. The minimum value you can specify is 1. The maximum accepted value is 1000.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPipelinesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelinesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListPipelineExecutions</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelineExecutionsInput {
    /// <p>The name of the pipeline for which you want to get execution summary information.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that was returned from the previous <code>ListPipelineExecutions</code> call, which can be used to return the next set of pipeline executions in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPipelineExecutionsInput {
    /// <p>The name of the pipeline for which you want to get execution summary information.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token that was returned from the previous <code>ListPipelineExecutions</code> call, which can be used to return the next set of pipeline executions in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelineExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelineExecutionsInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListActionTypes</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActionTypesInput {
    /// <p>Filters the list of action types to those created by a specified entity.</p>
    pub action_owner_filter: std::option::Option<crate::model::ActionOwner>,
    /// <p>An identifier that was returned from the previous list action types call, which can be used to return the next set of action types in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Region to filter on for the list of action types.</p>
    pub region_filter: std::option::Option<std::string::String>,
}
impl ListActionTypesInput {
    /// <p>Filters the list of action types to those created by a specified entity.</p>
    pub fn action_owner_filter(&self) -> std::option::Option<&crate::model::ActionOwner> {
        self.action_owner_filter.as_ref()
    }
    /// <p>An identifier that was returned from the previous list action types call, which can be used to return the next set of action types in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Region to filter on for the list of action types.</p>
    pub fn region_filter(&self) -> std::option::Option<&str> {
        self.region_filter.as_deref()
    }
}
impl std::fmt::Debug for ListActionTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActionTypesInput");
        formatter.field("action_owner_filter", &self.action_owner_filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("region_filter", &self.region_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActionExecutionsInput {
    /// <p> The name of the pipeline for which you want to list action execution history.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>Input information used to filter action execution history.</p>
    pub filter: std::option::Option<crate::model::ActionExecutionFilter>,
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Action execution history is retained for up to 12 months, based on action execution start times. Default value is 100. </p> <note>
    /// <p>Detailed execution history is available for executions run on or after February 21, 2019.</p>
    /// </note>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that was returned from the previous <code>ListActionExecutions</code> call, which can be used to return the next set of action executions in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListActionExecutionsInput {
    /// <p> The name of the pipeline for which you want to list action execution history.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>Input information used to filter action execution history.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::ActionExecutionFilter> {
        self.filter.as_ref()
    }
    /// <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Action execution history is retained for up to 12 months, based on action execution start times. Default value is 100. </p> <note>
    /// <p>Detailed execution history is available for executions run on or after February 21, 2019.</p>
    /// </note>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token that was returned from the previous <code>ListActionExecutions</code> call, which can be used to return the next set of action executions in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListActionExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActionExecutionsInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("filter", &self.filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetThirdPartyJobDetails</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetThirdPartyJobDetailsInput {
    /// <p>The unique system-generated ID used for identifying the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl GetThirdPartyJobDetailsInput {
    /// <p>The unique system-generated ID used for identifying the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for GetThirdPartyJobDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetThirdPartyJobDetailsInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetPipelineState</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPipelineStateInput {
    /// <p>The name of the pipeline about which you want to get information.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetPipelineStateInput {
    /// <p>The name of the pipeline about which you want to get information.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetPipelineStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPipelineStateInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetPipelineExecution</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPipelineExecutionInput {
    /// <p>The name of the pipeline about which you want to get execution details.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The ID of the pipeline execution about which you want to get execution details.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
}
impl GetPipelineExecutionInput {
    /// <p>The name of the pipeline about which you want to get execution details.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The ID of the pipeline execution about which you want to get execution details.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
}
impl std::fmt::Debug for GetPipelineExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPipelineExecutionInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetPipeline</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPipelineInput {
    /// <p>The name of the pipeline for which you want to get information. Pipeline names must be unique under an AWS user account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version number of the pipeline. If you do not specify a version, defaults to the current version.</p>
    pub version: std::option::Option<i32>,
}
impl GetPipelineInput {
    /// <p>The name of the pipeline for which you want to get information. Pipeline names must be unique under an AWS user account.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version number of the pipeline. If you do not specify a version, defaults to the current version.</p>
    pub fn version(&self) -> std::option::Option<i32> {
        self.version
    }
}
impl std::fmt::Debug for GetPipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPipelineInput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetJobDetails</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobDetailsInput {
    /// <p>The unique system-generated ID for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetJobDetailsInput {
    /// <p>The unique system-generated ID for the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetJobDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobDetailsInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetActionTypeInput {
    /// <p>Defines what kind of action can be taken in the stage. The following are the valid values:</p>
    /// <ul>
    /// <li> <p> <code>Source</code> </p> </li>
    /// <li> <p> <code>Build</code> </p> </li>
    /// <li> <p> <code>Test</code> </p> </li>
    /// <li> <p> <code>Deploy</code> </p> </li>
    /// <li> <p> <code>Approval</code> </p> </li>
    /// <li> <p> <code>Invoke</code> </p> </li>
    /// </ul>
    pub category: std::option::Option<crate::model::ActionCategory>,
    /// <p>The creator of an action type that was created with any supported integration model. There are two valid values: <code>AWS</code> and <code>ThirdParty</code>.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The provider of the action type being called. The provider name is specified when the action type is created.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>A string that describes the action type version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl GetActionTypeInput {
    /// <p>Defines what kind of action can be taken in the stage. The following are the valid values:</p>
    /// <ul>
    /// <li> <p> <code>Source</code> </p> </li>
    /// <li> <p> <code>Build</code> </p> </li>
    /// <li> <p> <code>Test</code> </p> </li>
    /// <li> <p> <code>Deploy</code> </p> </li>
    /// <li> <p> <code>Approval</code> </p> </li>
    /// <li> <p> <code>Invoke</code> </p> </li>
    /// </ul>
    pub fn category(&self) -> std::option::Option<&crate::model::ActionCategory> {
        self.category.as_ref()
    }
    /// <p>The creator of an action type that was created with any supported integration model. There are two valid values: <code>AWS</code> and <code>ThirdParty</code>.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The provider of the action type being called. The provider name is specified when the action type is created.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>A string that describes the action type version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for GetActionTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetActionTypeInput");
        formatter.field("category", &self.category);
        formatter.field("owner", &self.owner);
        formatter.field("provider", &self.provider);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

/// <p>Represents the input of an <code>EnableStageTransition</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableStageTransitionInput {
    /// <p>The name of the pipeline in which you want to enable the flow of artifacts from one stage to another.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage where you want to enable the transition of artifacts, either into the stage (inbound) or from that stage to the next stage (outbound).</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether artifacts are allowed to enter the stage and be processed by the actions in that stage (inbound) or whether already processed artifacts are allowed to transition to the next stage (outbound).</p>
    pub transition_type: std::option::Option<crate::model::StageTransitionType>,
}
impl EnableStageTransitionInput {
    /// <p>The name of the pipeline in which you want to enable the flow of artifacts from one stage to another.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The name of the stage where you want to enable the transition of artifacts, either into the stage (inbound) or from that stage to the next stage (outbound).</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>Specifies whether artifacts are allowed to enter the stage and be processed by the actions in that stage (inbound) or whether already processed artifacts are allowed to transition to the next stage (outbound).</p>
    pub fn transition_type(&self) -> std::option::Option<&crate::model::StageTransitionType> {
        self.transition_type.as_ref()
    }
}
impl std::fmt::Debug for EnableStageTransitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableStageTransitionInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("transition_type", &self.transition_type);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DisableStageTransition</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableStageTransitionInput {
    /// <p>The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage where you want to disable the inbound or outbound transition of artifacts.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).</p>
    pub transition_type: std::option::Option<crate::model::StageTransitionType>,
    /// <p>The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl DisableStageTransitionInput {
    /// <p>The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The name of the stage where you want to disable the inbound or outbound transition of artifacts.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).</p>
    pub fn transition_type(&self) -> std::option::Option<&crate::model::StageTransitionType> {
        self.transition_type.as_ref()
    }
    /// <p>The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for DisableStageTransitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableStageTransitionInput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("transition_type", &self.transition_type);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterWebhookWithThirdPartyInput {
    /// <p>The name of the webhook you want to deregister.</p>
    pub webhook_name: std::option::Option<std::string::String>,
}
impl DeregisterWebhookWithThirdPartyInput {
    /// <p>The name of the webhook you want to deregister.</p>
    pub fn webhook_name(&self) -> std::option::Option<&str> {
        self.webhook_name.as_deref()
    }
}
impl std::fmt::Debug for DeregisterWebhookWithThirdPartyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterWebhookWithThirdPartyInput");
        formatter.field("webhook_name", &self.webhook_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWebhookInput {
    /// <p>The name of the webhook you want to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteWebhookInput {
    /// <p>The name of the webhook you want to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteWebhookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWebhookInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeletePipeline</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePipelineInput {
    /// <p>The name of the pipeline to be deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeletePipelineInput {
    /// <p>The name of the pipeline to be deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeletePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePipelineInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteCustomActionType</code> operation. The custom action will be marked as deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomActionTypeInput {
    /// <p>The category of the custom action that you want to delete, such as source or deploy.</p>
    pub category: std::option::Option<crate::model::ActionCategory>,
    /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The version of the custom action to delete.</p>
    pub version: std::option::Option<std::string::String>,
}
impl DeleteCustomActionTypeInput {
    /// <p>The category of the custom action that you want to delete, such as source or deploy.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::ActionCategory> {
        self.category.as_ref()
    }
    /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>The version of the custom action to delete.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomActionTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomActionTypeInput");
        formatter.field("category", &self.category);
        formatter.field("provider", &self.provider);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreatePipeline</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePipelineInput {
    /// <p>Represents the structure of actions and stages to be performed in the pipeline. </p>
    pub pipeline: std::option::Option<crate::model::PipelineDeclaration>,
    /// <p>The tags for the pipeline.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreatePipelineInput {
    /// <p>Represents the structure of actions and stages to be performed in the pipeline. </p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::PipelineDeclaration> {
        self.pipeline.as_ref()
    }
    /// <p>The tags for the pipeline.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreatePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePipelineInput");
        formatter.field("pipeline", &self.pipeline);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of a CreateCustomActionType operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomActionTypeInput {
    /// <p>The category of the custom action, such as a build action or a test action.</p>
    pub category: std::option::Option<crate::model::ActionCategory>,
    /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The version identifier of the custom action.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>URLs that provide users information about this custom action.</p>
    pub settings: std::option::Option<crate::model::ActionTypeSettings>,
    /// <p>The configuration properties for the custom action.</p> <note>
    /// <p>You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a>.</p>
    /// </note>
    pub configuration_properties:
        std::option::Option<std::vec::Vec<crate::model::ActionConfigurationProperty>>,
    /// <p>The details of the input artifact for the action, such as its commit ID.</p>
    pub input_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
    /// <p>The details of the output artifact of the action, such as its commit ID.</p>
    pub output_artifact_details: std::option::Option<crate::model::ArtifactDetails>,
    /// <p>The tags for the custom action.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateCustomActionTypeInput {
    /// <p>The category of the custom action, such as a build action or a test action.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::ActionCategory> {
        self.category.as_ref()
    }
    /// <p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>The version identifier of the custom action.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>URLs that provide users information about this custom action.</p>
    pub fn settings(&self) -> std::option::Option<&crate::model::ActionTypeSettings> {
        self.settings.as_ref()
    }
    /// <p>The configuration properties for the custom action.</p> <note>
    /// <p>You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a>.</p>
    /// </note>
    pub fn configuration_properties(
        &self,
    ) -> std::option::Option<&[crate::model::ActionConfigurationProperty]> {
        self.configuration_properties.as_deref()
    }
    /// <p>The details of the input artifact for the action, such as its commit ID.</p>
    pub fn input_artifact_details(&self) -> std::option::Option<&crate::model::ArtifactDetails> {
        self.input_artifact_details.as_ref()
    }
    /// <p>The details of the output artifact of the action, such as its commit ID.</p>
    pub fn output_artifact_details(&self) -> std::option::Option<&crate::model::ArtifactDetails> {
        self.output_artifact_details.as_ref()
    }
    /// <p>The tags for the custom action.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomActionTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomActionTypeInput");
        formatter.field("category", &self.category);
        formatter.field("provider", &self.provider);
        formatter.field("version", &self.version);
        formatter.field("settings", &self.settings);
        formatter.field("configuration_properties", &self.configuration_properties);
        formatter.field("input_artifact_details", &self.input_artifact_details);
        formatter.field("output_artifact_details", &self.output_artifact_details);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of an AcknowledgeThirdPartyJob action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcknowledgeThirdPartyJobInput {
    /// <p>The unique system-generated ID of the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response to a <code>GetThirdPartyJobDetails</code> request.</p>
    pub nonce: std::option::Option<std::string::String>,
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AcknowledgeThirdPartyJobInput {
    /// <p>The unique system-generated ID of the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response to a <code>GetThirdPartyJobDetails</code> request.</p>
    pub fn nonce(&self) -> std::option::Option<&str> {
        self.nonce.as_deref()
    }
    /// <p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AcknowledgeThirdPartyJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcknowledgeThirdPartyJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("nonce", &self.nonce);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Represents the input of an AcknowledgeJob action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcknowledgeJobInput {
    /// <p>The unique system-generated ID of the job for which you want to confirm receipt.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response of the <code>PollForJobs</code> request that returned this job.</p>
    pub nonce: std::option::Option<std::string::String>,
}
impl AcknowledgeJobInput {
    /// <p>The unique system-generated ID of the job for which you want to confirm receipt.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response of the <code>PollForJobs</code> request that returned this job.</p>
    pub fn nonce(&self) -> std::option::Option<&str> {
        self.nonce.as_deref()
    }
}
impl std::fmt::Debug for AcknowledgeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcknowledgeJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("nonce", &self.nonce);
        formatter.finish()
    }
}
