// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcknowledgeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcknowledgeJobError {
    /// Kind of error that occurred.
    pub kind: AcknowledgeJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcknowledgeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcknowledgeJobErrorKind {
    /// <p>The nonce was specified in an invalid format.</p>
    InvalidNonceException(crate::error::InvalidNonceException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcknowledgeJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcknowledgeJobErrorKind::InvalidNonceException(_inner) => _inner.fmt(f),
            AcknowledgeJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            AcknowledgeJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AcknowledgeJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcknowledgeJobError {
    fn code(&self) -> Option<&str> {
        AcknowledgeJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcknowledgeJobError {
    /// Creates a new `AcknowledgeJobError`.
    pub fn new(kind: AcknowledgeJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcknowledgeJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcknowledgeJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcknowledgeJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcknowledgeJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcknowledgeJobErrorKind::InvalidNonceException`.
    pub fn is_invalid_nonce_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcknowledgeJobErrorKind::InvalidNonceException(_)
        )
    }
    /// Returns `true` if the error kind is `AcknowledgeJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(&self.kind, AcknowledgeJobErrorKind::JobNotFoundException(_))
    }
    /// Returns `true` if the error kind is `AcknowledgeJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AcknowledgeJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AcknowledgeJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcknowledgeJobErrorKind::InvalidNonceException(_inner) => Some(_inner),
            AcknowledgeJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            AcknowledgeJobErrorKind::ValidationException(_inner) => Some(_inner),
            AcknowledgeJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AcknowledgeThirdPartyJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcknowledgeThirdPartyJobError {
    /// Kind of error that occurred.
    pub kind: AcknowledgeThirdPartyJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcknowledgeThirdPartyJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcknowledgeThirdPartyJobErrorKind {
    /// <p>The client token was specified in an invalid format</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The nonce was specified in an invalid format.</p>
    InvalidNonceException(crate::error::InvalidNonceException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcknowledgeThirdPartyJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcknowledgeThirdPartyJobErrorKind::InvalidClientTokenException(_inner) => _inner.fmt(f),
            AcknowledgeThirdPartyJobErrorKind::InvalidNonceException(_inner) => _inner.fmt(f),
            AcknowledgeThirdPartyJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            AcknowledgeThirdPartyJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AcknowledgeThirdPartyJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcknowledgeThirdPartyJobError {
    fn code(&self) -> Option<&str> {
        AcknowledgeThirdPartyJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcknowledgeThirdPartyJobError {
    /// Creates a new `AcknowledgeThirdPartyJobError`.
    pub fn new(kind: AcknowledgeThirdPartyJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcknowledgeThirdPartyJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcknowledgeThirdPartyJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcknowledgeThirdPartyJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcknowledgeThirdPartyJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcknowledgeThirdPartyJobErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcknowledgeThirdPartyJobErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AcknowledgeThirdPartyJobErrorKind::InvalidNonceException`.
    pub fn is_invalid_nonce_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcknowledgeThirdPartyJobErrorKind::InvalidNonceException(_)
        )
    }
    /// Returns `true` if the error kind is `AcknowledgeThirdPartyJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcknowledgeThirdPartyJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcknowledgeThirdPartyJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcknowledgeThirdPartyJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AcknowledgeThirdPartyJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcknowledgeThirdPartyJobErrorKind::InvalidClientTokenException(_inner) => Some(_inner),
            AcknowledgeThirdPartyJobErrorKind::InvalidNonceException(_inner) => Some(_inner),
            AcknowledgeThirdPartyJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            AcknowledgeThirdPartyJobErrorKind::ValidationException(_inner) => Some(_inner),
            AcknowledgeThirdPartyJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomActionTypeError {
    /// Kind of error that occurred.
    pub kind: CreateCustomActionTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomActionTypeErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource tags are invalid.</p>
    InvalidTagsException(crate::error::InvalidTagsException),
    /// <p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The tags limit for a resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomActionTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomActionTypeErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomActionTypeErrorKind::InvalidTagsException(_inner) => _inner.fmt(f),
            CreateCustomActionTypeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateCustomActionTypeErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateCustomActionTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateCustomActionTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomActionTypeError {
    fn code(&self) -> Option<&str> {
        CreateCustomActionTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomActionTypeError {
    /// Creates a new `CreateCustomActionTypeError`.
    pub fn new(kind: CreateCustomActionTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomActionTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomActionTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomActionTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomActionTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomActionTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomActionTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomActionTypeErrorKind::InvalidTagsException`.
    pub fn is_invalid_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomActionTypeErrorKind::InvalidTagsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomActionTypeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomActionTypeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomActionTypeErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomActionTypeErrorKind::TooManyTagsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomActionTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomActionTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateCustomActionTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomActionTypeErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            CreateCustomActionTypeErrorKind::InvalidTagsException(_inner) => Some(_inner),
            CreateCustomActionTypeErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCustomActionTypeErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateCustomActionTypeErrorKind::ValidationException(_inner) => Some(_inner),
            CreateCustomActionTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePipelineError {
    /// Kind of error that occurred.
    pub kind: CreatePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePipelineErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The action declaration was specified in an invalid format.</p>
    InvalidActionDeclarationException(crate::error::InvalidActionDeclarationException),
    /// <p>Reserved for future use.</p>
    InvalidBlockerDeclarationException(crate::error::InvalidBlockerDeclarationException),
    /// <p>The stage declaration was specified in an invalid format.</p>
    InvalidStageDeclarationException(crate::error::InvalidStageDeclarationException),
    /// <p>The structure was specified in an invalid format.</p>
    InvalidStructureException(crate::error::InvalidStructureException),
    /// <p>The specified resource tags are invalid.</p>
    InvalidTagsException(crate::error::InvalidTagsException),
    /// <p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified pipeline name is already in use.</p>
    PipelineNameInUseException(crate::error::PipelineNameInUseException),
    /// <p>The tags limit for a resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePipelineErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::InvalidActionDeclarationException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::InvalidBlockerDeclarationException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::InvalidStageDeclarationException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::InvalidStructureException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::InvalidTagsException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::PipelineNameInUseException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePipelineError {
    fn code(&self) -> Option<&str> {
        CreatePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePipelineError {
    /// Creates a new `CreatePipelineError`.
    pub fn new(kind: CreatePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InvalidActionDeclarationException`.
    pub fn is_invalid_action_declaration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::InvalidActionDeclarationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InvalidBlockerDeclarationException`.
    pub fn is_invalid_blocker_declaration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::InvalidBlockerDeclarationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InvalidStageDeclarationException`.
    pub fn is_invalid_stage_declaration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::InvalidStageDeclarationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InvalidStructureException`.
    pub fn is_invalid_structure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::InvalidStructureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InvalidTagsException`.
    pub fn is_invalid_tags_exception(&self) -> bool {
        matches!(&self.kind, CreatePipelineErrorKind::InvalidTagsException(_))
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::PipelineNameInUseException`.
    pub fn is_pipeline_name_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::PipelineNameInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreatePipelineErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePipelineErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreatePipelineErrorKind::InvalidActionDeclarationException(_inner) => Some(_inner),
            CreatePipelineErrorKind::InvalidBlockerDeclarationException(_inner) => Some(_inner),
            CreatePipelineErrorKind::InvalidStageDeclarationException(_inner) => Some(_inner),
            CreatePipelineErrorKind::InvalidStructureException(_inner) => Some(_inner),
            CreatePipelineErrorKind::InvalidTagsException(_inner) => Some(_inner),
            CreatePipelineErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePipelineErrorKind::PipelineNameInUseException(_inner) => Some(_inner),
            CreatePipelineErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreatePipelineErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomActionTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomActionTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomActionTypeErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomActionTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomActionTypeErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomActionTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCustomActionTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomActionTypeError {
    fn code(&self) -> Option<&str> {
        DeleteCustomActionTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomActionTypeError {
    /// Creates a new `DeleteCustomActionTypeError`.
    pub fn new(kind: DeleteCustomActionTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomActionTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomActionTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomActionTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomActionTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomActionTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomActionTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomActionTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomActionTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteCustomActionTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomActionTypeErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeleteCustomActionTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCustomActionTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePipelineError {
    /// Kind of error that occurred.
    pub kind: DeletePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePipelineErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePipelineErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePipelineError {
    fn code(&self) -> Option<&str> {
        DeletePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePipelineError {
    /// Creates a new `DeletePipelineError`.
    pub fn new(kind: DeletePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePipelineErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeletePipelineErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWebhookError {
    /// Kind of error that occurred.
    pub kind: DeleteWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWebhookErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWebhookErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWebhookError {
    fn code(&self) -> Option<&str> {
        DeleteWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWebhookError {
    /// Creates a new `DeleteWebhookError`.
    pub fn new(kind: DeleteWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWebhookErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebhookErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteWebhookErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWebhookErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterWebhookWithThirdParty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterWebhookWithThirdPartyError {
    /// Kind of error that occurred.
    pub kind: DeregisterWebhookWithThirdPartyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterWebhookWithThirdParty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterWebhookWithThirdPartyErrorKind {
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// <p>The specified webhook was entered in an invalid format or cannot be found.</p>
    WebhookNotFoundException(crate::error::WebhookNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterWebhookWithThirdPartyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterWebhookWithThirdPartyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeregisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterWebhookWithThirdPartyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterWebhookWithThirdPartyError {
    fn code(&self) -> Option<&str> {
        DeregisterWebhookWithThirdPartyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterWebhookWithThirdPartyError {
    /// Creates a new `DeregisterWebhookWithThirdPartyError`.
    pub fn new(
        kind: DeregisterWebhookWithThirdPartyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterWebhookWithThirdPartyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterWebhookWithThirdPartyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterWebhookWithThirdPartyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterWebhookWithThirdPartyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterWebhookWithThirdPartyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterWebhookWithThirdPartyErrorKind::ValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException`.
    pub fn is_webhook_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(_)
        )
    }
}
impl std::error::Error for DeregisterWebhookWithThirdPartyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterWebhookWithThirdPartyErrorKind::ValidationException(_inner) => Some(_inner),
            DeregisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(_inner) => {
                Some(_inner)
            }
            DeregisterWebhookWithThirdPartyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableStageTransition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableStageTransitionError {
    /// Kind of error that occurred.
    pub kind: DisableStageTransitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableStageTransition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableStageTransitionErrorKind {
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The stage was specified in an invalid format or cannot be found.</p>
    StageNotFoundException(crate::error::StageNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableStageTransitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableStageTransitionErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            DisableStageTransitionErrorKind::StageNotFoundException(_inner) => _inner.fmt(f),
            DisableStageTransitionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisableStageTransitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableStageTransitionError {
    fn code(&self) -> Option<&str> {
        DisableStageTransitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableStageTransitionError {
    /// Creates a new `DisableStageTransitionError`.
    pub fn new(kind: DisableStageTransitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableStageTransitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableStageTransitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableStageTransitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableStageTransitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableStageTransitionErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableStageTransitionErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableStageTransitionErrorKind::StageNotFoundException`.
    pub fn is_stage_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableStageTransitionErrorKind::StageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableStageTransitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableStageTransitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisableStageTransitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableStageTransitionErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            DisableStageTransitionErrorKind::StageNotFoundException(_inner) => Some(_inner),
            DisableStageTransitionErrorKind::ValidationException(_inner) => Some(_inner),
            DisableStageTransitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableStageTransition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableStageTransitionError {
    /// Kind of error that occurred.
    pub kind: EnableStageTransitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableStageTransition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableStageTransitionErrorKind {
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The stage was specified in an invalid format or cannot be found.</p>
    StageNotFoundException(crate::error::StageNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableStageTransitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableStageTransitionErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            EnableStageTransitionErrorKind::StageNotFoundException(_inner) => _inner.fmt(f),
            EnableStageTransitionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EnableStageTransitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableStageTransitionError {
    fn code(&self) -> Option<&str> {
        EnableStageTransitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableStageTransitionError {
    /// Creates a new `EnableStageTransitionError`.
    pub fn new(kind: EnableStageTransitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableStageTransitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableStageTransitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableStageTransitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableStageTransitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableStageTransitionErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableStageTransitionErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableStageTransitionErrorKind::StageNotFoundException`.
    pub fn is_stage_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableStageTransitionErrorKind::StageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableStageTransitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableStageTransitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for EnableStageTransitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableStageTransitionErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            EnableStageTransitionErrorKind::StageNotFoundException(_inner) => Some(_inner),
            EnableStageTransitionErrorKind::ValidationException(_inner) => Some(_inner),
            EnableStageTransitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetActionTypeError {
    /// Kind of error that occurred.
    pub kind: GetActionTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetActionTypeErrorKind {
    /// <p>The specified action type cannot be found.</p>
    ActionTypeNotFoundException(crate::error::ActionTypeNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetActionTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetActionTypeErrorKind::ActionTypeNotFoundException(_inner) => _inner.fmt(f),
            GetActionTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetActionTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetActionTypeError {
    fn code(&self) -> Option<&str> {
        GetActionTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetActionTypeError {
    /// Creates a new `GetActionTypeError`.
    pub fn new(kind: GetActionTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetActionTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetActionTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetActionTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetActionTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetActionTypeErrorKind::ActionTypeNotFoundException`.
    pub fn is_action_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetActionTypeErrorKind::ActionTypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetActionTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetActionTypeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetActionTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetActionTypeErrorKind::ActionTypeNotFoundException(_inner) => Some(_inner),
            GetActionTypeErrorKind::ValidationException(_inner) => Some(_inner),
            GetActionTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobDetailsError {
    /// Kind of error that occurred.
    pub kind: GetJobDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobDetailsErrorKind {
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobDetailsErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            GetJobDetailsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetJobDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobDetailsError {
    fn code(&self) -> Option<&str> {
        GetJobDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobDetailsError {
    /// Creates a new `GetJobDetailsError`.
    pub fn new(kind: GetJobDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobDetailsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobDetailsErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobDetailsErrorKind::JobNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobDetailsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetJobDetailsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetJobDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobDetailsErrorKind::JobNotFoundException(_inner) => Some(_inner),
            GetJobDetailsErrorKind::ValidationException(_inner) => Some(_inner),
            GetJobDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPipelineError {
    /// Kind of error that occurred.
    pub kind: GetPipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPipelineErrorKind {
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The pipeline version was specified in an invalid format or cannot be found.</p>
    PipelineVersionNotFoundException(crate::error::PipelineVersionNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPipelineErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            GetPipelineErrorKind::PipelineVersionNotFoundException(_inner) => _inner.fmt(f),
            GetPipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPipelineError {
    fn code(&self) -> Option<&str> {
        GetPipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPipelineError {
    /// Creates a new `GetPipelineError`.
    pub fn new(kind: GetPipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPipelineErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPipelineErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPipelineErrorKind::PipelineVersionNotFoundException`.
    pub fn is_pipeline_version_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPipelineErrorKind::PipelineVersionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetPipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetPipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPipelineErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            GetPipelineErrorKind::PipelineVersionNotFoundException(_inner) => Some(_inner),
            GetPipelineErrorKind::ValidationException(_inner) => Some(_inner),
            GetPipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPipelineExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPipelineExecutionError {
    /// Kind of error that occurred.
    pub kind: GetPipelineExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPipelineExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPipelineExecutionErrorKind {
    /// <p>The pipeline execution was specified in an invalid format or cannot be found, or an execution ID does not belong to the specified pipeline. </p>
    PipelineExecutionNotFoundException(crate::error::PipelineExecutionNotFoundException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPipelineExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPipelineExecutionErrorKind::PipelineExecutionNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetPipelineExecutionErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            GetPipelineExecutionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPipelineExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPipelineExecutionError {
    fn code(&self) -> Option<&str> {
        GetPipelineExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPipelineExecutionError {
    /// Creates a new `GetPipelineExecutionError`.
    pub fn new(kind: GetPipelineExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPipelineExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPipelineExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPipelineExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPipelineExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPipelineExecutionErrorKind::PipelineExecutionNotFoundException`.
    pub fn is_pipeline_execution_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPipelineExecutionErrorKind::PipelineExecutionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPipelineExecutionErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPipelineExecutionErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPipelineExecutionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPipelineExecutionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPipelineExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPipelineExecutionErrorKind::PipelineExecutionNotFoundException(_inner) => {
                Some(_inner)
            }
            GetPipelineExecutionErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            GetPipelineExecutionErrorKind::ValidationException(_inner) => Some(_inner),
            GetPipelineExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPipelineState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPipelineStateError {
    /// Kind of error that occurred.
    pub kind: GetPipelineStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPipelineState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPipelineStateErrorKind {
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPipelineStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPipelineStateErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            GetPipelineStateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPipelineStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPipelineStateError {
    fn code(&self) -> Option<&str> {
        GetPipelineStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPipelineStateError {
    /// Creates a new `GetPipelineStateError`.
    pub fn new(kind: GetPipelineStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPipelineStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPipelineStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPipelineStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPipelineStateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPipelineStateErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPipelineStateErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPipelineStateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPipelineStateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPipelineStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPipelineStateErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            GetPipelineStateErrorKind::ValidationException(_inner) => Some(_inner),
            GetPipelineStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetThirdPartyJobDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetThirdPartyJobDetailsError {
    /// Kind of error that occurred.
    pub kind: GetThirdPartyJobDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetThirdPartyJobDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetThirdPartyJobDetailsErrorKind {
    /// <p>The client token was specified in an invalid format</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    InvalidJobException(crate::error::InvalidJobException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetThirdPartyJobDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetThirdPartyJobDetailsErrorKind::InvalidClientTokenException(_inner) => _inner.fmt(f),
            GetThirdPartyJobDetailsErrorKind::InvalidJobException(_inner) => _inner.fmt(f),
            GetThirdPartyJobDetailsErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            GetThirdPartyJobDetailsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetThirdPartyJobDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetThirdPartyJobDetailsError {
    fn code(&self) -> Option<&str> {
        GetThirdPartyJobDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetThirdPartyJobDetailsError {
    /// Creates a new `GetThirdPartyJobDetailsError`.
    pub fn new(kind: GetThirdPartyJobDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetThirdPartyJobDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetThirdPartyJobDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetThirdPartyJobDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetThirdPartyJobDetailsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetThirdPartyJobDetailsErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThirdPartyJobDetailsErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThirdPartyJobDetailsErrorKind::InvalidJobException`.
    pub fn is_invalid_job_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThirdPartyJobDetailsErrorKind::InvalidJobException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThirdPartyJobDetailsErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThirdPartyJobDetailsErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThirdPartyJobDetailsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThirdPartyJobDetailsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetThirdPartyJobDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetThirdPartyJobDetailsErrorKind::InvalidClientTokenException(_inner) => Some(_inner),
            GetThirdPartyJobDetailsErrorKind::InvalidJobException(_inner) => Some(_inner),
            GetThirdPartyJobDetailsErrorKind::JobNotFoundException(_inner) => Some(_inner),
            GetThirdPartyJobDetailsErrorKind::ValidationException(_inner) => Some(_inner),
            GetThirdPartyJobDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListActionExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListActionExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListActionExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListActionExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListActionExecutionsErrorKind {
    /// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The pipeline execution was specified in an invalid format or cannot be found, or an execution ID does not belong to the specified pipeline. </p>
    PipelineExecutionNotFoundException(crate::error::PipelineExecutionNotFoundException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListActionExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListActionExecutionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListActionExecutionsErrorKind::PipelineExecutionNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListActionExecutionsErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            ListActionExecutionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListActionExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListActionExecutionsError {
    fn code(&self) -> Option<&str> {
        ListActionExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListActionExecutionsError {
    /// Creates a new `ListActionExecutionsError`.
    pub fn new(kind: ListActionExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListActionExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListActionExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListActionExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListActionExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListActionExecutionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActionExecutionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActionExecutionsErrorKind::PipelineExecutionNotFoundException`.
    pub fn is_pipeline_execution_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActionExecutionsErrorKind::PipelineExecutionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActionExecutionsErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActionExecutionsErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActionExecutionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActionExecutionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListActionExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListActionExecutionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListActionExecutionsErrorKind::PipelineExecutionNotFoundException(_inner) => {
                Some(_inner)
            }
            ListActionExecutionsErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            ListActionExecutionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListActionExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListActionTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListActionTypesError {
    /// Kind of error that occurred.
    pub kind: ListActionTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListActionTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListActionTypesErrorKind {
    /// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListActionTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListActionTypesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListActionTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListActionTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListActionTypesError {
    fn code(&self) -> Option<&str> {
        ListActionTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListActionTypesError {
    /// Creates a new `ListActionTypesError`.
    pub fn new(kind: ListActionTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListActionTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListActionTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListActionTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListActionTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListActionTypesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActionTypesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActionTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListActionTypesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListActionTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListActionTypesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListActionTypesErrorKind::ValidationException(_inner) => Some(_inner),
            ListActionTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPipelineExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPipelineExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListPipelineExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPipelineExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPipelineExecutionsErrorKind {
    /// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPipelineExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPipelineExecutionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPipelineExecutionsErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            ListPipelineExecutionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPipelineExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPipelineExecutionsError {
    fn code(&self) -> Option<&str> {
        ListPipelineExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPipelineExecutionsError {
    /// Creates a new `ListPipelineExecutionsError`.
    pub fn new(kind: ListPipelineExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPipelineExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPipelineExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPipelineExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPipelineExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPipelineExecutionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelineExecutionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelineExecutionsErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelineExecutionsErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelineExecutionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelineExecutionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPipelineExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPipelineExecutionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPipelineExecutionsErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            ListPipelineExecutionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPipelineExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPipelinesError {
    /// Kind of error that occurred.
    pub kind: ListPipelinesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPipelinesErrorKind {
    /// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPipelinesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPipelinesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPipelinesError {
    fn code(&self) -> Option<&str> {
        ListPipelinesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPipelinesError {
    /// Creates a new `ListPipelinesError`.
    pub fn new(kind: ListPipelinesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPipelinesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPipelinesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPipelinesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPipelinesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelinesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListPipelinesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListPipelinesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPipelinesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPipelinesErrorKind::ValidationException(_inner) => Some(_inner),
            ListPipelinesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The specified resource ARN is invalid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The resource was specified in an invalid format.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWebhooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWebhooksError {
    /// Kind of error that occurred.
    pub kind: ListWebhooksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWebhooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWebhooksErrorKind {
    /// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWebhooksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWebhooksErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListWebhooksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListWebhooksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWebhooksError {
    fn code(&self) -> Option<&str> {
        ListWebhooksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWebhooksError {
    /// Creates a new `ListWebhooksError`.
    pub fn new(kind: ListWebhooksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWebhooksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWebhooksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWebhooksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWebhooksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWebhooksErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebhooksErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebhooksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListWebhooksErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListWebhooksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWebhooksErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListWebhooksErrorKind::ValidationException(_inner) => Some(_inner),
            ListWebhooksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PollForJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PollForJobsError {
    /// Kind of error that occurred.
    pub kind: PollForJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PollForJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PollForJobsErrorKind {
    /// <p>The specified action type cannot be found.</p>
    ActionTypeNotFoundException(crate::error::ActionTypeNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PollForJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PollForJobsErrorKind::ActionTypeNotFoundException(_inner) => _inner.fmt(f),
            PollForJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PollForJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PollForJobsError {
    fn code(&self) -> Option<&str> {
        PollForJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PollForJobsError {
    /// Creates a new `PollForJobsError`.
    pub fn new(kind: PollForJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PollForJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PollForJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PollForJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PollForJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PollForJobsErrorKind::ActionTypeNotFoundException`.
    pub fn is_action_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PollForJobsErrorKind::ActionTypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PollForJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PollForJobsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PollForJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PollForJobsErrorKind::ActionTypeNotFoundException(_inner) => Some(_inner),
            PollForJobsErrorKind::ValidationException(_inner) => Some(_inner),
            PollForJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PollForThirdPartyJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PollForThirdPartyJobsError {
    /// Kind of error that occurred.
    pub kind: PollForThirdPartyJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PollForThirdPartyJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PollForThirdPartyJobsErrorKind {
    /// <p>The specified action type cannot be found.</p>
    ActionTypeNotFoundException(crate::error::ActionTypeNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PollForThirdPartyJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PollForThirdPartyJobsErrorKind::ActionTypeNotFoundException(_inner) => _inner.fmt(f),
            PollForThirdPartyJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PollForThirdPartyJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PollForThirdPartyJobsError {
    fn code(&self) -> Option<&str> {
        PollForThirdPartyJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PollForThirdPartyJobsError {
    /// Creates a new `PollForThirdPartyJobsError`.
    pub fn new(kind: PollForThirdPartyJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PollForThirdPartyJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PollForThirdPartyJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PollForThirdPartyJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PollForThirdPartyJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PollForThirdPartyJobsErrorKind::ActionTypeNotFoundException`.
    pub fn is_action_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PollForThirdPartyJobsErrorKind::ActionTypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PollForThirdPartyJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PollForThirdPartyJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PollForThirdPartyJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PollForThirdPartyJobsErrorKind::ActionTypeNotFoundException(_inner) => Some(_inner),
            PollForThirdPartyJobsErrorKind::ValidationException(_inner) => Some(_inner),
            PollForThirdPartyJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutActionRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutActionRevisionError {
    /// Kind of error that occurred.
    pub kind: PutActionRevisionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutActionRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutActionRevisionErrorKind {
    /// <p>The specified action cannot be found.</p>
    ActionNotFoundException(crate::error::ActionNotFoundException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The stage was specified in an invalid format or cannot be found.</p>
    StageNotFoundException(crate::error::StageNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutActionRevisionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutActionRevisionErrorKind::ActionNotFoundException(_inner) => _inner.fmt(f),
            PutActionRevisionErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            PutActionRevisionErrorKind::StageNotFoundException(_inner) => _inner.fmt(f),
            PutActionRevisionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutActionRevisionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutActionRevisionError {
    fn code(&self) -> Option<&str> {
        PutActionRevisionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutActionRevisionError {
    /// Creates a new `PutActionRevisionError`.
    pub fn new(kind: PutActionRevisionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutActionRevisionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutActionRevisionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutActionRevisionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutActionRevisionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutActionRevisionErrorKind::ActionNotFoundException`.
    pub fn is_action_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutActionRevisionErrorKind::ActionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutActionRevisionErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutActionRevisionErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutActionRevisionErrorKind::StageNotFoundException`.
    pub fn is_stage_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutActionRevisionErrorKind::StageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutActionRevisionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutActionRevisionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutActionRevisionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutActionRevisionErrorKind::ActionNotFoundException(_inner) => Some(_inner),
            PutActionRevisionErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            PutActionRevisionErrorKind::StageNotFoundException(_inner) => Some(_inner),
            PutActionRevisionErrorKind::ValidationException(_inner) => Some(_inner),
            PutActionRevisionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutApprovalResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutApprovalResultError {
    /// Kind of error that occurred.
    pub kind: PutApprovalResultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutApprovalResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutApprovalResultErrorKind {
    /// <p>The specified action cannot be found.</p>
    ActionNotFoundException(crate::error::ActionNotFoundException),
    /// <p>The approval action has already been approved or rejected.</p>
    ApprovalAlreadyCompletedException(crate::error::ApprovalAlreadyCompletedException),
    /// <p>The approval request already received a response or has expired.</p>
    InvalidApprovalTokenException(crate::error::InvalidApprovalTokenException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The stage was specified in an invalid format or cannot be found.</p>
    StageNotFoundException(crate::error::StageNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutApprovalResultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutApprovalResultErrorKind::ActionNotFoundException(_inner) => _inner.fmt(f),
            PutApprovalResultErrorKind::ApprovalAlreadyCompletedException(_inner) => _inner.fmt(f),
            PutApprovalResultErrorKind::InvalidApprovalTokenException(_inner) => _inner.fmt(f),
            PutApprovalResultErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            PutApprovalResultErrorKind::StageNotFoundException(_inner) => _inner.fmt(f),
            PutApprovalResultErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutApprovalResultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutApprovalResultError {
    fn code(&self) -> Option<&str> {
        PutApprovalResultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutApprovalResultError {
    /// Creates a new `PutApprovalResultError`.
    pub fn new(kind: PutApprovalResultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutApprovalResultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutApprovalResultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutApprovalResultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutApprovalResultErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutApprovalResultErrorKind::ActionNotFoundException`.
    pub fn is_action_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApprovalResultErrorKind::ActionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApprovalResultErrorKind::ApprovalAlreadyCompletedException`.
    pub fn is_approval_already_completed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApprovalResultErrorKind::ApprovalAlreadyCompletedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApprovalResultErrorKind::InvalidApprovalTokenException`.
    pub fn is_invalid_approval_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApprovalResultErrorKind::InvalidApprovalTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApprovalResultErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApprovalResultErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApprovalResultErrorKind::StageNotFoundException`.
    pub fn is_stage_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApprovalResultErrorKind::StageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApprovalResultErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApprovalResultErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutApprovalResultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutApprovalResultErrorKind::ActionNotFoundException(_inner) => Some(_inner),
            PutApprovalResultErrorKind::ApprovalAlreadyCompletedException(_inner) => Some(_inner),
            PutApprovalResultErrorKind::InvalidApprovalTokenException(_inner) => Some(_inner),
            PutApprovalResultErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            PutApprovalResultErrorKind::StageNotFoundException(_inner) => Some(_inner),
            PutApprovalResultErrorKind::ValidationException(_inner) => Some(_inner),
            PutApprovalResultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutJobFailureResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutJobFailureResultError {
    /// Kind of error that occurred.
    pub kind: PutJobFailureResultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutJobFailureResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutJobFailureResultErrorKind {
    /// <p>The job state was specified in an invalid format.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutJobFailureResultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutJobFailureResultErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            PutJobFailureResultErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            PutJobFailureResultErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutJobFailureResultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutJobFailureResultError {
    fn code(&self) -> Option<&str> {
        PutJobFailureResultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutJobFailureResultError {
    /// Creates a new `PutJobFailureResultError`.
    pub fn new(kind: PutJobFailureResultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutJobFailureResultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutJobFailureResultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutJobFailureResultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutJobFailureResultErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutJobFailureResultErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutJobFailureResultErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutJobFailureResultErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutJobFailureResultErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutJobFailureResultErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutJobFailureResultErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutJobFailureResultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutJobFailureResultErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            PutJobFailureResultErrorKind::JobNotFoundException(_inner) => Some(_inner),
            PutJobFailureResultErrorKind::ValidationException(_inner) => Some(_inner),
            PutJobFailureResultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutJobSuccessResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutJobSuccessResultError {
    /// Kind of error that occurred.
    pub kind: PutJobSuccessResultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutJobSuccessResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutJobSuccessResultErrorKind {
    /// <p>The job state was specified in an invalid format.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>Exceeded the total size limit for all variables in the pipeline.</p>
    OutputVariablesSizeExceededException(crate::error::OutputVariablesSizeExceededException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutJobSuccessResultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutJobSuccessResultErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            PutJobSuccessResultErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            PutJobSuccessResultErrorKind::OutputVariablesSizeExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutJobSuccessResultErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutJobSuccessResultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutJobSuccessResultError {
    fn code(&self) -> Option<&str> {
        PutJobSuccessResultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutJobSuccessResultError {
    /// Creates a new `PutJobSuccessResultError`.
    pub fn new(kind: PutJobSuccessResultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutJobSuccessResultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutJobSuccessResultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutJobSuccessResultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutJobSuccessResultErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutJobSuccessResultErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutJobSuccessResultErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutJobSuccessResultErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutJobSuccessResultErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutJobSuccessResultErrorKind::OutputVariablesSizeExceededException`.
    pub fn is_output_variables_size_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutJobSuccessResultErrorKind::OutputVariablesSizeExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutJobSuccessResultErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutJobSuccessResultErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutJobSuccessResultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutJobSuccessResultErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            PutJobSuccessResultErrorKind::JobNotFoundException(_inner) => Some(_inner),
            PutJobSuccessResultErrorKind::OutputVariablesSizeExceededException(_inner) => {
                Some(_inner)
            }
            PutJobSuccessResultErrorKind::ValidationException(_inner) => Some(_inner),
            PutJobSuccessResultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutThirdPartyJobFailureResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutThirdPartyJobFailureResultError {
    /// Kind of error that occurred.
    pub kind: PutThirdPartyJobFailureResultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutThirdPartyJobFailureResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutThirdPartyJobFailureResultErrorKind {
    /// <p>The client token was specified in an invalid format</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The job state was specified in an invalid format.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutThirdPartyJobFailureResultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutThirdPartyJobFailureResultErrorKind::InvalidClientTokenException(_inner) => {
                _inner.fmt(f)
            }
            PutThirdPartyJobFailureResultErrorKind::InvalidJobStateException(_inner) => {
                _inner.fmt(f)
            }
            PutThirdPartyJobFailureResultErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            PutThirdPartyJobFailureResultErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutThirdPartyJobFailureResultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutThirdPartyJobFailureResultError {
    fn code(&self) -> Option<&str> {
        PutThirdPartyJobFailureResultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutThirdPartyJobFailureResultError {
    /// Creates a new `PutThirdPartyJobFailureResultError`.
    pub fn new(
        kind: PutThirdPartyJobFailureResultErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutThirdPartyJobFailureResultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutThirdPartyJobFailureResultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutThirdPartyJobFailureResultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutThirdPartyJobFailureResultErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobFailureResultErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobFailureResultErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobFailureResultErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobFailureResultErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobFailureResultErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobFailureResultErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobFailureResultErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobFailureResultErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutThirdPartyJobFailureResultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutThirdPartyJobFailureResultErrorKind::InvalidClientTokenException(_inner) => {
                Some(_inner)
            }
            PutThirdPartyJobFailureResultErrorKind::InvalidJobStateException(_inner) => {
                Some(_inner)
            }
            PutThirdPartyJobFailureResultErrorKind::JobNotFoundException(_inner) => Some(_inner),
            PutThirdPartyJobFailureResultErrorKind::ValidationException(_inner) => Some(_inner),
            PutThirdPartyJobFailureResultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutThirdPartyJobSuccessResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutThirdPartyJobSuccessResultError {
    /// Kind of error that occurred.
    pub kind: PutThirdPartyJobSuccessResultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutThirdPartyJobSuccessResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutThirdPartyJobSuccessResultErrorKind {
    /// <p>The client token was specified in an invalid format</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The job state was specified in an invalid format.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutThirdPartyJobSuccessResultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutThirdPartyJobSuccessResultErrorKind::InvalidClientTokenException(_inner) => {
                _inner.fmt(f)
            }
            PutThirdPartyJobSuccessResultErrorKind::InvalidJobStateException(_inner) => {
                _inner.fmt(f)
            }
            PutThirdPartyJobSuccessResultErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            PutThirdPartyJobSuccessResultErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutThirdPartyJobSuccessResultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutThirdPartyJobSuccessResultError {
    fn code(&self) -> Option<&str> {
        PutThirdPartyJobSuccessResultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutThirdPartyJobSuccessResultError {
    /// Creates a new `PutThirdPartyJobSuccessResultError`.
    pub fn new(
        kind: PutThirdPartyJobSuccessResultErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutThirdPartyJobSuccessResultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutThirdPartyJobSuccessResultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutThirdPartyJobSuccessResultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutThirdPartyJobSuccessResultErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobSuccessResultErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobSuccessResultErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobSuccessResultErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobSuccessResultErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobSuccessResultErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobSuccessResultErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutThirdPartyJobSuccessResultErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutThirdPartyJobSuccessResultErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutThirdPartyJobSuccessResultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutThirdPartyJobSuccessResultErrorKind::InvalidClientTokenException(_inner) => {
                Some(_inner)
            }
            PutThirdPartyJobSuccessResultErrorKind::InvalidJobStateException(_inner) => {
                Some(_inner)
            }
            PutThirdPartyJobSuccessResultErrorKind::JobNotFoundException(_inner) => Some(_inner),
            PutThirdPartyJobSuccessResultErrorKind::ValidationException(_inner) => Some(_inner),
            PutThirdPartyJobSuccessResultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutWebhookError {
    /// Kind of error that occurred.
    pub kind: PutWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutWebhookErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource tags are invalid.</p>
    InvalidTagsException(crate::error::InvalidTagsException),
    /// <p>The specified authentication type is in an invalid format.</p>
    InvalidWebhookAuthenticationParametersException(
        crate::error::InvalidWebhookAuthenticationParametersException,
    ),
    /// <p>The specified event filter rule is in an invalid format.</p>
    InvalidWebhookFilterPatternException(crate::error::InvalidWebhookFilterPatternException),
    /// <p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The tags limit for a resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutWebhookErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            PutWebhookErrorKind::InvalidTagsException(_inner) => _inner.fmt(f),
            PutWebhookErrorKind::InvalidWebhookAuthenticationParametersException(_inner) => {
                _inner.fmt(f)
            }
            PutWebhookErrorKind::InvalidWebhookFilterPatternException(_inner) => _inner.fmt(f),
            PutWebhookErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutWebhookErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            PutWebhookErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            PutWebhookErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutWebhookError {
    fn code(&self) -> Option<&str> {
        PutWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutWebhookError {
    /// Creates a new `PutWebhookError`.
    pub fn new(kind: PutWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutWebhookErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWebhookErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::InvalidTagsException`.
    pub fn is_invalid_tags_exception(&self) -> bool {
        matches!(&self.kind, PutWebhookErrorKind::InvalidTagsException(_))
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::InvalidWebhookAuthenticationParametersException`.
    pub fn is_invalid_webhook_authentication_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWebhookErrorKind::InvalidWebhookAuthenticationParametersException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::InvalidWebhookFilterPatternException`.
    pub fn is_invalid_webhook_filter_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWebhookErrorKind::InvalidWebhookFilterPatternException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutWebhookErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWebhookErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, PutWebhookErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `PutWebhookErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutWebhookErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutWebhookErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutWebhookErrorKind::InvalidTagsException(_inner) => Some(_inner),
            PutWebhookErrorKind::InvalidWebhookAuthenticationParametersException(_inner) => {
                Some(_inner)
            }
            PutWebhookErrorKind::InvalidWebhookFilterPatternException(_inner) => Some(_inner),
            PutWebhookErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutWebhookErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            PutWebhookErrorKind::TooManyTagsException(_inner) => Some(_inner),
            PutWebhookErrorKind::ValidationException(_inner) => Some(_inner),
            PutWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterWebhookWithThirdParty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterWebhookWithThirdPartyError {
    /// Kind of error that occurred.
    pub kind: RegisterWebhookWithThirdPartyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterWebhookWithThirdParty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterWebhookWithThirdPartyErrorKind {
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// <p>The specified webhook was entered in an invalid format or cannot be found.</p>
    WebhookNotFoundException(crate::error::WebhookNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterWebhookWithThirdPartyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterWebhookWithThirdPartyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RegisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RegisterWebhookWithThirdPartyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterWebhookWithThirdPartyError {
    fn code(&self) -> Option<&str> {
        RegisterWebhookWithThirdPartyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterWebhookWithThirdPartyError {
    /// Creates a new `RegisterWebhookWithThirdPartyError`.
    pub fn new(
        kind: RegisterWebhookWithThirdPartyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterWebhookWithThirdPartyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterWebhookWithThirdPartyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterWebhookWithThirdPartyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterWebhookWithThirdPartyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterWebhookWithThirdPartyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWebhookWithThirdPartyErrorKind::ValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException`.
    pub fn is_webhook_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(_)
        )
    }
}
impl std::error::Error for RegisterWebhookWithThirdPartyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterWebhookWithThirdPartyErrorKind::ValidationException(_inner) => Some(_inner),
            RegisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(_inner) => {
                Some(_inner)
            }
            RegisterWebhookWithThirdPartyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetryStageExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetryStageExecutionError {
    /// Kind of error that occurred.
    pub kind: RetryStageExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetryStageExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetryStageExecutionErrorKind {
    /// <p>Your request cannot be handled because the pipeline is busy handling ongoing activities. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The stage has failed in a later run of the pipeline and the pipelineExecutionId associated with the request is out of date.</p>
    NotLatestPipelineExecutionException(crate::error::NotLatestPipelineExecutionException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The stage was specified in an invalid format or cannot be found.</p>
    StageNotFoundException(crate::error::StageNotFoundException),
    /// <p>Unable to retry. The pipeline structure or stage state might have changed while actions awaited retry, or the stage contains no failed actions.</p>
    StageNotRetryableException(crate::error::StageNotRetryableException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetryStageExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetryStageExecutionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RetryStageExecutionErrorKind::NotLatestPipelineExecutionException(_inner) => {
                _inner.fmt(f)
            }
            RetryStageExecutionErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            RetryStageExecutionErrorKind::StageNotFoundException(_inner) => _inner.fmt(f),
            RetryStageExecutionErrorKind::StageNotRetryableException(_inner) => _inner.fmt(f),
            RetryStageExecutionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RetryStageExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetryStageExecutionError {
    fn code(&self) -> Option<&str> {
        RetryStageExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetryStageExecutionError {
    /// Creates a new `RetryStageExecutionError`.
    pub fn new(kind: RetryStageExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetryStageExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetryStageExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetryStageExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetryStageExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RetryStageExecutionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryStageExecutionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryStageExecutionErrorKind::NotLatestPipelineExecutionException`.
    pub fn is_not_latest_pipeline_execution_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryStageExecutionErrorKind::NotLatestPipelineExecutionException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryStageExecutionErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryStageExecutionErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryStageExecutionErrorKind::StageNotFoundException`.
    pub fn is_stage_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryStageExecutionErrorKind::StageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryStageExecutionErrorKind::StageNotRetryableException`.
    pub fn is_stage_not_retryable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryStageExecutionErrorKind::StageNotRetryableException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryStageExecutionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryStageExecutionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RetryStageExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetryStageExecutionErrorKind::ConflictException(_inner) => Some(_inner),
            RetryStageExecutionErrorKind::NotLatestPipelineExecutionException(_inner) => {
                Some(_inner)
            }
            RetryStageExecutionErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            RetryStageExecutionErrorKind::StageNotFoundException(_inner) => Some(_inner),
            RetryStageExecutionErrorKind::StageNotRetryableException(_inner) => Some(_inner),
            RetryStageExecutionErrorKind::ValidationException(_inner) => Some(_inner),
            RetryStageExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartPipelineExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartPipelineExecutionError {
    /// Kind of error that occurred.
    pub kind: StartPipelineExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartPipelineExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartPipelineExecutionErrorKind {
    /// <p>Your request cannot be handled because the pipeline is busy handling ongoing activities. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartPipelineExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartPipelineExecutionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartPipelineExecutionErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            StartPipelineExecutionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartPipelineExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartPipelineExecutionError {
    fn code(&self) -> Option<&str> {
        StartPipelineExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartPipelineExecutionError {
    /// Creates a new `StartPipelineExecutionError`.
    pub fn new(kind: StartPipelineExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartPipelineExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartPipelineExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartPipelineExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartPipelineExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartPipelineExecutionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineExecutionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPipelineExecutionErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineExecutionErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPipelineExecutionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineExecutionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartPipelineExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartPipelineExecutionErrorKind::ConflictException(_inner) => Some(_inner),
            StartPipelineExecutionErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            StartPipelineExecutionErrorKind::ValidationException(_inner) => Some(_inner),
            StartPipelineExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopPipelineExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopPipelineExecutionError {
    /// Kind of error that occurred.
    pub kind: StopPipelineExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopPipelineExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopPipelineExecutionErrorKind {
    /// <p>Your request cannot be handled because the pipeline is busy handling ongoing activities. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The pipeline execution is already in a <code>Stopping</code> state. If you already chose to stop and wait, you cannot make that request again. You can choose to stop and abandon now, but be aware that this option can lead to failed tasks or out of sequence tasks. If you already chose to stop and abandon, you cannot make that request again.</p>
    DuplicatedStopRequestException(crate::error::DuplicatedStopRequestException),
    /// <p>Unable to stop the pipeline execution. The execution might already be in a <code>Stopped</code> state, or it might no longer be in progress.</p>
    PipelineExecutionNotStoppableException(crate::error::PipelineExecutionNotStoppableException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopPipelineExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopPipelineExecutionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StopPipelineExecutionErrorKind::DuplicatedStopRequestException(_inner) => _inner.fmt(f),
            StopPipelineExecutionErrorKind::PipelineExecutionNotStoppableException(_inner) => {
                _inner.fmt(f)
            }
            StopPipelineExecutionErrorKind::PipelineNotFoundException(_inner) => _inner.fmt(f),
            StopPipelineExecutionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopPipelineExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopPipelineExecutionError {
    fn code(&self) -> Option<&str> {
        StopPipelineExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopPipelineExecutionError {
    /// Creates a new `StopPipelineExecutionError`.
    pub fn new(kind: StopPipelineExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopPipelineExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopPipelineExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopPipelineExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopPipelineExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopPipelineExecutionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPipelineExecutionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StopPipelineExecutionErrorKind::DuplicatedStopRequestException`.
    pub fn is_duplicated_stop_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPipelineExecutionErrorKind::DuplicatedStopRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopPipelineExecutionErrorKind::PipelineExecutionNotStoppableException`.
    pub fn is_pipeline_execution_not_stoppable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPipelineExecutionErrorKind::PipelineExecutionNotStoppableException(_)
        )
    }
    /// Returns `true` if the error kind is `StopPipelineExecutionErrorKind::PipelineNotFoundException`.
    pub fn is_pipeline_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPipelineExecutionErrorKind::PipelineNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopPipelineExecutionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPipelineExecutionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StopPipelineExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopPipelineExecutionErrorKind::ConflictException(_inner) => Some(_inner),
            StopPipelineExecutionErrorKind::DuplicatedStopRequestException(_inner) => Some(_inner),
            StopPipelineExecutionErrorKind::PipelineExecutionNotStoppableException(_inner) => {
                Some(_inner)
            }
            StopPipelineExecutionErrorKind::PipelineNotFoundException(_inner) => Some(_inner),
            StopPipelineExecutionErrorKind::ValidationException(_inner) => Some(_inner),
            StopPipelineExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource ARN is invalid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The specified resource tags are invalid.</p>
    InvalidTagsException(crate::error::InvalidTagsException),
    /// <p>The resource was specified in an invalid format.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The tags limit for a resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidTagsException`.
    pub fn is_invalid_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidTagsException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource ARN is invalid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The specified resource tags are invalid.</p>
    InvalidTagsException(crate::error::InvalidTagsException),
    /// <p>The resource was specified in an invalid format.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidTagsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidTagsException`.
    pub fn is_invalid_tags_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidTagsException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidTagsException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateActionTypeError {
    /// Kind of error that occurred.
    pub kind: UpdateActionTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateActionType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateActionTypeErrorKind {
    /// <p>The specified action type cannot be found.</p>
    ActionTypeNotFoundException(crate::error::ActionTypeNotFoundException),
    /// <p>The request failed because of an unknown error, exception, or failure.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateActionTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateActionTypeErrorKind::ActionTypeNotFoundException(_inner) => _inner.fmt(f),
            UpdateActionTypeErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            UpdateActionTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateActionTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateActionTypeError {
    fn code(&self) -> Option<&str> {
        UpdateActionTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateActionTypeError {
    /// Creates a new `UpdateActionTypeError`.
    pub fn new(kind: UpdateActionTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateActionTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateActionTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateActionTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateActionTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateActionTypeErrorKind::ActionTypeNotFoundException`.
    pub fn is_action_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateActionTypeErrorKind::ActionTypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateActionTypeErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateActionTypeErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateActionTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateActionTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateActionTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateActionTypeErrorKind::ActionTypeNotFoundException(_inner) => Some(_inner),
            UpdateActionTypeErrorKind::RequestFailedException(_inner) => Some(_inner),
            UpdateActionTypeErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateActionTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePipelineError {
    /// Kind of error that occurred.
    pub kind: UpdatePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePipelineErrorKind {
    /// <p>The action declaration was specified in an invalid format.</p>
    InvalidActionDeclarationException(crate::error::InvalidActionDeclarationException),
    /// <p>Reserved for future use.</p>
    InvalidBlockerDeclarationException(crate::error::InvalidBlockerDeclarationException),
    /// <p>The stage declaration was specified in an invalid format.</p>
    InvalidStageDeclarationException(crate::error::InvalidStageDeclarationException),
    /// <p>The structure was specified in an invalid format.</p>
    InvalidStructureException(crate::error::InvalidStructureException),
    /// <p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePipelineErrorKind::InvalidActionDeclarationException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::InvalidBlockerDeclarationException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::InvalidStageDeclarationException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::InvalidStructureException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePipelineError {
    fn code(&self) -> Option<&str> {
        UpdatePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePipelineError {
    /// Creates a new `UpdatePipelineError`.
    pub fn new(kind: UpdatePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::InvalidActionDeclarationException`.
    pub fn is_invalid_action_declaration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::InvalidActionDeclarationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::InvalidBlockerDeclarationException`.
    pub fn is_invalid_blocker_declaration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::InvalidBlockerDeclarationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::InvalidStageDeclarationException`.
    pub fn is_invalid_stage_declaration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::InvalidStageDeclarationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::InvalidStructureException`.
    pub fn is_invalid_structure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::InvalidStructureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdatePipelineErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdatePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePipelineErrorKind::InvalidActionDeclarationException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::InvalidBlockerDeclarationException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::InvalidStageDeclarationException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::InvalidStructureException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The validation was specified in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The structure was specified in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStructureException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStructureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStructureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStructureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStructureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStructureException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStructureException {}
/// See [`InvalidStructureException`](crate::error::InvalidStructureException)
pub mod invalid_structure_exception {
    /// A builder for [`InvalidStructureException`](crate::error::InvalidStructureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStructureException`](crate::error::InvalidStructureException)
        pub fn build(self) -> crate::error::InvalidStructureException {
            crate::error::InvalidStructureException {
                message: self.message,
            }
        }
    }
}
impl InvalidStructureException {
    /// Creates a new builder-style object to manufacture [`InvalidStructureException`](crate::error::InvalidStructureException)
    pub fn builder() -> crate::error::invalid_structure_exception::Builder {
        crate::error::invalid_structure_exception::Builder::default()
    }
}

/// <p>The stage declaration was specified in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStageDeclarationException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStageDeclarationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStageDeclarationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStageDeclarationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStageDeclarationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStageDeclarationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStageDeclarationException {}
/// See [`InvalidStageDeclarationException`](crate::error::InvalidStageDeclarationException)
pub mod invalid_stage_declaration_exception {
    /// A builder for [`InvalidStageDeclarationException`](crate::error::InvalidStageDeclarationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStageDeclarationException`](crate::error::InvalidStageDeclarationException)
        pub fn build(self) -> crate::error::InvalidStageDeclarationException {
            crate::error::InvalidStageDeclarationException {
                message: self.message,
            }
        }
    }
}
impl InvalidStageDeclarationException {
    /// Creates a new builder-style object to manufacture [`InvalidStageDeclarationException`](crate::error::InvalidStageDeclarationException)
    pub fn builder() -> crate::error::invalid_stage_declaration_exception::Builder {
        crate::error::invalid_stage_declaration_exception::Builder::default()
    }
}

/// <p>Reserved for future use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidBlockerDeclarationException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidBlockerDeclarationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidBlockerDeclarationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidBlockerDeclarationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidBlockerDeclarationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidBlockerDeclarationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidBlockerDeclarationException {}
/// See [`InvalidBlockerDeclarationException`](crate::error::InvalidBlockerDeclarationException)
pub mod invalid_blocker_declaration_exception {
    /// A builder for [`InvalidBlockerDeclarationException`](crate::error::InvalidBlockerDeclarationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidBlockerDeclarationException`](crate::error::InvalidBlockerDeclarationException)
        pub fn build(self) -> crate::error::InvalidBlockerDeclarationException {
            crate::error::InvalidBlockerDeclarationException {
                message: self.message,
            }
        }
    }
}
impl InvalidBlockerDeclarationException {
    /// Creates a new builder-style object to manufacture [`InvalidBlockerDeclarationException`](crate::error::InvalidBlockerDeclarationException)
    pub fn builder() -> crate::error::invalid_blocker_declaration_exception::Builder {
        crate::error::invalid_blocker_declaration_exception::Builder::default()
    }
}

/// <p>The action declaration was specified in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidActionDeclarationException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidActionDeclarationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidActionDeclarationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidActionDeclarationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidActionDeclarationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidActionDeclarationException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidActionDeclarationException {}
/// See [`InvalidActionDeclarationException`](crate::error::InvalidActionDeclarationException)
pub mod invalid_action_declaration_exception {
    /// A builder for [`InvalidActionDeclarationException`](crate::error::InvalidActionDeclarationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidActionDeclarationException`](crate::error::InvalidActionDeclarationException)
        pub fn build(self) -> crate::error::InvalidActionDeclarationException {
            crate::error::InvalidActionDeclarationException {
                message: self.message,
            }
        }
    }
}
impl InvalidActionDeclarationException {
    /// Creates a new builder-style object to manufacture [`InvalidActionDeclarationException`](crate::error::InvalidActionDeclarationException)
    pub fn builder() -> crate::error::invalid_action_declaration_exception::Builder {
        crate::error::invalid_action_declaration_exception::Builder::default()
    }
}

/// <p>The request failed because of an unknown error, exception, or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestFailedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestFailedException {}
/// See [`RequestFailedException`](crate::error::RequestFailedException)
pub mod request_failed_exception {
    /// A builder for [`RequestFailedException`](crate::error::RequestFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestFailedException`](crate::error::RequestFailedException)
        pub fn build(self) -> crate::error::RequestFailedException {
            crate::error::RequestFailedException {
                message: self.message,
            }
        }
    }
}
impl RequestFailedException {
    /// Creates a new builder-style object to manufacture [`RequestFailedException`](crate::error::RequestFailedException)
    pub fn builder() -> crate::error::request_failed_exception::Builder {
        crate::error::request_failed_exception::Builder::default()
    }
}

/// <p>The specified action type cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionTypeNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActionTypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionTypeNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActionTypeNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActionTypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActionTypeNotFoundException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActionTypeNotFoundException {}
/// See [`ActionTypeNotFoundException`](crate::error::ActionTypeNotFoundException)
pub mod action_type_not_found_exception {
    /// A builder for [`ActionTypeNotFoundException`](crate::error::ActionTypeNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionTypeNotFoundException`](crate::error::ActionTypeNotFoundException)
        pub fn build(self) -> crate::error::ActionTypeNotFoundException {
            crate::error::ActionTypeNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ActionTypeNotFoundException {
    /// Creates a new builder-style object to manufacture [`ActionTypeNotFoundException`](crate::error::ActionTypeNotFoundException)
    pub fn builder() -> crate::error::action_type_not_found_exception::Builder {
        crate::error::action_type_not_found_exception::Builder::default()
    }
}

/// <p>The resource was specified in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The specified resource tags are invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagsException {}
/// See [`InvalidTagsException`](crate::error::InvalidTagsException)
pub mod invalid_tags_exception {
    /// A builder for [`InvalidTagsException`](crate::error::InvalidTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagsException`](crate::error::InvalidTagsException)
        pub fn build(self) -> crate::error::InvalidTagsException {
            crate::error::InvalidTagsException {
                message: self.message,
            }
        }
    }
}
impl InvalidTagsException {
    /// Creates a new builder-style object to manufacture [`InvalidTagsException`](crate::error::InvalidTagsException)
    pub fn builder() -> crate::error::invalid_tags_exception::Builder {
        crate::error::invalid_tags_exception::Builder::default()
    }
}

/// <p>The specified resource ARN is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArnException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArnException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArnException {}
/// See [`InvalidArnException`](crate::error::InvalidArnException)
pub mod invalid_arn_exception {
    /// A builder for [`InvalidArnException`](crate::error::InvalidArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArnException`](crate::error::InvalidArnException)
        pub fn build(self) -> crate::error::InvalidArnException {
            crate::error::InvalidArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidArnException {
    /// Creates a new builder-style object to manufacture [`InvalidArnException`](crate::error::InvalidArnException)
    pub fn builder() -> crate::error::invalid_arn_exception::Builder {
        crate::error::invalid_arn_exception::Builder::default()
    }
}

/// <p>Unable to modify the tag due to a simultaneous update request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The tags limit for a resource has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The pipeline was specified in an invalid format or cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PipelineNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PipelineNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PipelineNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PipelineNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for PipelineNotFoundException {}
/// See [`PipelineNotFoundException`](crate::error::PipelineNotFoundException)
pub mod pipeline_not_found_exception {
    /// A builder for [`PipelineNotFoundException`](crate::error::PipelineNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineNotFoundException`](crate::error::PipelineNotFoundException)
        pub fn build(self) -> crate::error::PipelineNotFoundException {
            crate::error::PipelineNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PipelineNotFoundException {
    /// Creates a new builder-style object to manufacture [`PipelineNotFoundException`](crate::error::PipelineNotFoundException)
    pub fn builder() -> crate::error::pipeline_not_found_exception::Builder {
        crate::error::pipeline_not_found_exception::Builder::default()
    }
}

/// <p>Unable to stop the pipeline execution. The execution might already be in a <code>Stopped</code> state, or it might no longer be in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineExecutionNotStoppableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PipelineExecutionNotStoppableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineExecutionNotStoppableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PipelineExecutionNotStoppableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PipelineExecutionNotStoppableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PipelineExecutionNotStoppableException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for PipelineExecutionNotStoppableException {}
/// See [`PipelineExecutionNotStoppableException`](crate::error::PipelineExecutionNotStoppableException)
pub mod pipeline_execution_not_stoppable_exception {
    /// A builder for [`PipelineExecutionNotStoppableException`](crate::error::PipelineExecutionNotStoppableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineExecutionNotStoppableException`](crate::error::PipelineExecutionNotStoppableException)
        pub fn build(self) -> crate::error::PipelineExecutionNotStoppableException {
            crate::error::PipelineExecutionNotStoppableException {
                message: self.message,
            }
        }
    }
}
impl PipelineExecutionNotStoppableException {
    /// Creates a new builder-style object to manufacture [`PipelineExecutionNotStoppableException`](crate::error::PipelineExecutionNotStoppableException)
    pub fn builder() -> crate::error::pipeline_execution_not_stoppable_exception::Builder {
        crate::error::pipeline_execution_not_stoppable_exception::Builder::default()
    }
}

/// <p>The pipeline execution is already in a <code>Stopping</code> state. If you already chose to stop and wait, you cannot make that request again. You can choose to stop and abandon now, but be aware that this option can lead to failed tasks or out of sequence tasks. If you already chose to stop and abandon, you cannot make that request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicatedStopRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicatedStopRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicatedStopRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicatedStopRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicatedStopRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicatedStopRequestException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicatedStopRequestException {}
/// See [`DuplicatedStopRequestException`](crate::error::DuplicatedStopRequestException)
pub mod duplicated_stop_request_exception {
    /// A builder for [`DuplicatedStopRequestException`](crate::error::DuplicatedStopRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicatedStopRequestException`](crate::error::DuplicatedStopRequestException)
        pub fn build(self) -> crate::error::DuplicatedStopRequestException {
            crate::error::DuplicatedStopRequestException {
                message: self.message,
            }
        }
    }
}
impl DuplicatedStopRequestException {
    /// Creates a new builder-style object to manufacture [`DuplicatedStopRequestException`](crate::error::DuplicatedStopRequestException)
    pub fn builder() -> crate::error::duplicated_stop_request_exception::Builder {
        crate::error::duplicated_stop_request_exception::Builder::default()
    }
}

/// <p>Your request cannot be handled because the pipeline is busy handling ongoing activities. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>Unable to retry. The pipeline structure or stage state might have changed while actions awaited retry, or the stage contains no failed actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageNotRetryableException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StageNotRetryableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageNotRetryableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StageNotRetryableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StageNotRetryableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StageNotRetryableException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for StageNotRetryableException {}
/// See [`StageNotRetryableException`](crate::error::StageNotRetryableException)
pub mod stage_not_retryable_exception {
    /// A builder for [`StageNotRetryableException`](crate::error::StageNotRetryableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StageNotRetryableException`](crate::error::StageNotRetryableException)
        pub fn build(self) -> crate::error::StageNotRetryableException {
            crate::error::StageNotRetryableException {
                message: self.message,
            }
        }
    }
}
impl StageNotRetryableException {
    /// Creates a new builder-style object to manufacture [`StageNotRetryableException`](crate::error::StageNotRetryableException)
    pub fn builder() -> crate::error::stage_not_retryable_exception::Builder {
        crate::error::stage_not_retryable_exception::Builder::default()
    }
}

/// <p>The stage was specified in an invalid format or cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StageNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StageNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StageNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StageNotFoundException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for StageNotFoundException {}
/// See [`StageNotFoundException`](crate::error::StageNotFoundException)
pub mod stage_not_found_exception {
    /// A builder for [`StageNotFoundException`](crate::error::StageNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StageNotFoundException`](crate::error::StageNotFoundException)
        pub fn build(self) -> crate::error::StageNotFoundException {
            crate::error::StageNotFoundException {
                message: self.message,
            }
        }
    }
}
impl StageNotFoundException {
    /// Creates a new builder-style object to manufacture [`StageNotFoundException`](crate::error::StageNotFoundException)
    pub fn builder() -> crate::error::stage_not_found_exception::Builder {
        crate::error::stage_not_found_exception::Builder::default()
    }
}

/// <p>The stage has failed in a later run of the pipeline and the pipelineExecutionId associated with the request is out of date.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotLatestPipelineExecutionException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotLatestPipelineExecutionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotLatestPipelineExecutionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotLatestPipelineExecutionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotLatestPipelineExecutionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotLatestPipelineExecutionException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotLatestPipelineExecutionException {}
/// See [`NotLatestPipelineExecutionException`](crate::error::NotLatestPipelineExecutionException)
pub mod not_latest_pipeline_execution_exception {
    /// A builder for [`NotLatestPipelineExecutionException`](crate::error::NotLatestPipelineExecutionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotLatestPipelineExecutionException`](crate::error::NotLatestPipelineExecutionException)
        pub fn build(self) -> crate::error::NotLatestPipelineExecutionException {
            crate::error::NotLatestPipelineExecutionException {
                message: self.message,
            }
        }
    }
}
impl NotLatestPipelineExecutionException {
    /// Creates a new builder-style object to manufacture [`NotLatestPipelineExecutionException`](crate::error::NotLatestPipelineExecutionException)
    pub fn builder() -> crate::error::not_latest_pipeline_execution_exception::Builder {
        crate::error::not_latest_pipeline_execution_exception::Builder::default()
    }
}

/// <p>The specified webhook was entered in an invalid format or cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebhookNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WebhookNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebhookNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WebhookNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WebhookNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WebhookNotFoundException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for WebhookNotFoundException {}
/// See [`WebhookNotFoundException`](crate::error::WebhookNotFoundException)
pub mod webhook_not_found_exception {
    /// A builder for [`WebhookNotFoundException`](crate::error::WebhookNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WebhookNotFoundException`](crate::error::WebhookNotFoundException)
        pub fn build(self) -> crate::error::WebhookNotFoundException {
            crate::error::WebhookNotFoundException {
                message: self.message,
            }
        }
    }
}
impl WebhookNotFoundException {
    /// Creates a new builder-style object to manufacture [`WebhookNotFoundException`](crate::error::WebhookNotFoundException)
    pub fn builder() -> crate::error::webhook_not_found_exception::Builder {
        crate::error::webhook_not_found_exception::Builder::default()
    }
}

/// <p>The specified event filter rule is in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidWebhookFilterPatternException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidWebhookFilterPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidWebhookFilterPatternException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidWebhookFilterPatternException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidWebhookFilterPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidWebhookFilterPatternException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidWebhookFilterPatternException {}
/// See [`InvalidWebhookFilterPatternException`](crate::error::InvalidWebhookFilterPatternException)
pub mod invalid_webhook_filter_pattern_exception {
    /// A builder for [`InvalidWebhookFilterPatternException`](crate::error::InvalidWebhookFilterPatternException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidWebhookFilterPatternException`](crate::error::InvalidWebhookFilterPatternException)
        pub fn build(self) -> crate::error::InvalidWebhookFilterPatternException {
            crate::error::InvalidWebhookFilterPatternException {
                message: self.message,
            }
        }
    }
}
impl InvalidWebhookFilterPatternException {
    /// Creates a new builder-style object to manufacture [`InvalidWebhookFilterPatternException`](crate::error::InvalidWebhookFilterPatternException)
    pub fn builder() -> crate::error::invalid_webhook_filter_pattern_exception::Builder {
        crate::error::invalid_webhook_filter_pattern_exception::Builder::default()
    }
}

/// <p>The specified authentication type is in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidWebhookAuthenticationParametersException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidWebhookAuthenticationParametersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidWebhookAuthenticationParametersException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidWebhookAuthenticationParametersException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidWebhookAuthenticationParametersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidWebhookAuthenticationParametersException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidWebhookAuthenticationParametersException {}
/// See [`InvalidWebhookAuthenticationParametersException`](crate::error::InvalidWebhookAuthenticationParametersException)
pub mod invalid_webhook_authentication_parameters_exception {
    /// A builder for [`InvalidWebhookAuthenticationParametersException`](crate::error::InvalidWebhookAuthenticationParametersException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidWebhookAuthenticationParametersException`](crate::error::InvalidWebhookAuthenticationParametersException)
        pub fn build(self) -> crate::error::InvalidWebhookAuthenticationParametersException {
            crate::error::InvalidWebhookAuthenticationParametersException {
                message: self.message,
            }
        }
    }
}
impl InvalidWebhookAuthenticationParametersException {
    /// Creates a new builder-style object to manufacture [`InvalidWebhookAuthenticationParametersException`](crate::error::InvalidWebhookAuthenticationParametersException)
    pub fn builder() -> crate::error::invalid_webhook_authentication_parameters_exception::Builder {
        crate::error::invalid_webhook_authentication_parameters_exception::Builder::default()
    }
}

/// <p>The job was specified in an invalid format or cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl JobNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for JobNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "JobNotFoundException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for JobNotFoundException {}
/// See [`JobNotFoundException`](crate::error::JobNotFoundException)
pub mod job_not_found_exception {
    /// A builder for [`JobNotFoundException`](crate::error::JobNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`JobNotFoundException`](crate::error::JobNotFoundException)
        pub fn build(self) -> crate::error::JobNotFoundException {
            crate::error::JobNotFoundException {
                message: self.message,
            }
        }
    }
}
impl JobNotFoundException {
    /// Creates a new builder-style object to manufacture [`JobNotFoundException`](crate::error::JobNotFoundException)
    pub fn builder() -> crate::error::job_not_found_exception::Builder {
        crate::error::job_not_found_exception::Builder::default()
    }
}

/// <p>The job state was specified in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidJobStateException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidJobStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidJobStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidJobStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidJobStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidJobStateException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidJobStateException {}
/// See [`InvalidJobStateException`](crate::error::InvalidJobStateException)
pub mod invalid_job_state_exception {
    /// A builder for [`InvalidJobStateException`](crate::error::InvalidJobStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidJobStateException`](crate::error::InvalidJobStateException)
        pub fn build(self) -> crate::error::InvalidJobStateException {
            crate::error::InvalidJobStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidJobStateException {
    /// Creates a new builder-style object to manufacture [`InvalidJobStateException`](crate::error::InvalidJobStateException)
    pub fn builder() -> crate::error::invalid_job_state_exception::Builder {
        crate::error::invalid_job_state_exception::Builder::default()
    }
}

/// <p>The client token was specified in an invalid format</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClientTokenException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClientTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClientTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClientTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClientTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClientTokenException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClientTokenException {}
/// See [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
pub mod invalid_client_token_exception {
    /// A builder for [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
        pub fn build(self) -> crate::error::InvalidClientTokenException {
            crate::error::InvalidClientTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidClientTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
    pub fn builder() -> crate::error::invalid_client_token_exception::Builder {
        crate::error::invalid_client_token_exception::Builder::default()
    }
}

/// <p>Exceeded the total size limit for all variables in the pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputVariablesSizeExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OutputVariablesSizeExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputVariablesSizeExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OutputVariablesSizeExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OutputVariablesSizeExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OutputVariablesSizeExceededException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for OutputVariablesSizeExceededException {}
/// See [`OutputVariablesSizeExceededException`](crate::error::OutputVariablesSizeExceededException)
pub mod output_variables_size_exceeded_exception {
    /// A builder for [`OutputVariablesSizeExceededException`](crate::error::OutputVariablesSizeExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputVariablesSizeExceededException`](crate::error::OutputVariablesSizeExceededException)
        pub fn build(self) -> crate::error::OutputVariablesSizeExceededException {
            crate::error::OutputVariablesSizeExceededException {
                message: self.message,
            }
        }
    }
}
impl OutputVariablesSizeExceededException {
    /// Creates a new builder-style object to manufacture [`OutputVariablesSizeExceededException`](crate::error::OutputVariablesSizeExceededException)
    pub fn builder() -> crate::error::output_variables_size_exceeded_exception::Builder {
        crate::error::output_variables_size_exceeded_exception::Builder::default()
    }
}

/// <p>The approval request already received a response or has expired.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidApprovalTokenException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidApprovalTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidApprovalTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidApprovalTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidApprovalTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidApprovalTokenException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidApprovalTokenException {}
/// See [`InvalidApprovalTokenException`](crate::error::InvalidApprovalTokenException)
pub mod invalid_approval_token_exception {
    /// A builder for [`InvalidApprovalTokenException`](crate::error::InvalidApprovalTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidApprovalTokenException`](crate::error::InvalidApprovalTokenException)
        pub fn build(self) -> crate::error::InvalidApprovalTokenException {
            crate::error::InvalidApprovalTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidApprovalTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidApprovalTokenException`](crate::error::InvalidApprovalTokenException)
    pub fn builder() -> crate::error::invalid_approval_token_exception::Builder {
        crate::error::invalid_approval_token_exception::Builder::default()
    }
}

/// <p>The approval action has already been approved or rejected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalAlreadyCompletedException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApprovalAlreadyCompletedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalAlreadyCompletedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ApprovalAlreadyCompletedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ApprovalAlreadyCompletedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ApprovalAlreadyCompletedException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for ApprovalAlreadyCompletedException {}
/// See [`ApprovalAlreadyCompletedException`](crate::error::ApprovalAlreadyCompletedException)
pub mod approval_already_completed_exception {
    /// A builder for [`ApprovalAlreadyCompletedException`](crate::error::ApprovalAlreadyCompletedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalAlreadyCompletedException`](crate::error::ApprovalAlreadyCompletedException)
        pub fn build(self) -> crate::error::ApprovalAlreadyCompletedException {
            crate::error::ApprovalAlreadyCompletedException {
                message: self.message,
            }
        }
    }
}
impl ApprovalAlreadyCompletedException {
    /// Creates a new builder-style object to manufacture [`ApprovalAlreadyCompletedException`](crate::error::ApprovalAlreadyCompletedException)
    pub fn builder() -> crate::error::approval_already_completed_exception::Builder {
        crate::error::approval_already_completed_exception::Builder::default()
    }
}

/// <p>The specified action cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActionNotFoundException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActionNotFoundException {}
/// See [`ActionNotFoundException`](crate::error::ActionNotFoundException)
pub mod action_not_found_exception {
    /// A builder for [`ActionNotFoundException`](crate::error::ActionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionNotFoundException`](crate::error::ActionNotFoundException)
        pub fn build(self) -> crate::error::ActionNotFoundException {
            crate::error::ActionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ActionNotFoundException {
    /// Creates a new builder-style object to manufacture [`ActionNotFoundException`](crate::error::ActionNotFoundException)
    pub fn builder() -> crate::error::action_not_found_exception::Builder {
        crate::error::action_not_found_exception::Builder::default()
    }
}

/// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The pipeline execution was specified in an invalid format or cannot be found, or an execution ID does not belong to the specified pipeline. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineExecutionNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PipelineExecutionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineExecutionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PipelineExecutionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PipelineExecutionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PipelineExecutionNotFoundException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for PipelineExecutionNotFoundException {}
/// See [`PipelineExecutionNotFoundException`](crate::error::PipelineExecutionNotFoundException)
pub mod pipeline_execution_not_found_exception {
    /// A builder for [`PipelineExecutionNotFoundException`](crate::error::PipelineExecutionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineExecutionNotFoundException`](crate::error::PipelineExecutionNotFoundException)
        pub fn build(self) -> crate::error::PipelineExecutionNotFoundException {
            crate::error::PipelineExecutionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PipelineExecutionNotFoundException {
    /// Creates a new builder-style object to manufacture [`PipelineExecutionNotFoundException`](crate::error::PipelineExecutionNotFoundException)
    pub fn builder() -> crate::error::pipeline_execution_not_found_exception::Builder {
        crate::error::pipeline_execution_not_found_exception::Builder::default()
    }
}

/// <p>The job was specified in an invalid format or cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidJobException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidJobException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidJobException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidJobException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidJobException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidJobException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidJobException {}
/// See [`InvalidJobException`](crate::error::InvalidJobException)
pub mod invalid_job_exception {
    /// A builder for [`InvalidJobException`](crate::error::InvalidJobException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidJobException`](crate::error::InvalidJobException)
        pub fn build(self) -> crate::error::InvalidJobException {
            crate::error::InvalidJobException {
                message: self.message,
            }
        }
    }
}
impl InvalidJobException {
    /// Creates a new builder-style object to manufacture [`InvalidJobException`](crate::error::InvalidJobException)
    pub fn builder() -> crate::error::invalid_job_exception::Builder {
        crate::error::invalid_job_exception::Builder::default()
    }
}

/// <p>The pipeline version was specified in an invalid format or cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineVersionNotFoundException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PipelineVersionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineVersionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PipelineVersionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PipelineVersionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PipelineVersionNotFoundException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for PipelineVersionNotFoundException {}
/// See [`PipelineVersionNotFoundException`](crate::error::PipelineVersionNotFoundException)
pub mod pipeline_version_not_found_exception {
    /// A builder for [`PipelineVersionNotFoundException`](crate::error::PipelineVersionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineVersionNotFoundException`](crate::error::PipelineVersionNotFoundException)
        pub fn build(self) -> crate::error::PipelineVersionNotFoundException {
            crate::error::PipelineVersionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PipelineVersionNotFoundException {
    /// Creates a new builder-style object to manufacture [`PipelineVersionNotFoundException`](crate::error::PipelineVersionNotFoundException)
    pub fn builder() -> crate::error::pipeline_version_not_found_exception::Builder {
        crate::error::pipeline_version_not_found_exception::Builder::default()
    }
}

/// <p>The specified pipeline name is already in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineNameInUseException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PipelineNameInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineNameInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PipelineNameInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PipelineNameInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PipelineNameInUseException")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for PipelineNameInUseException {}
/// See [`PipelineNameInUseException`](crate::error::PipelineNameInUseException)
pub mod pipeline_name_in_use_exception {
    /// A builder for [`PipelineNameInUseException`](crate::error::PipelineNameInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineNameInUseException`](crate::error::PipelineNameInUseException)
        pub fn build(self) -> crate::error::PipelineNameInUseException {
            crate::error::PipelineNameInUseException {
                message: self.message,
            }
        }
    }
}
impl PipelineNameInUseException {
    /// Creates a new builder-style object to manufacture [`PipelineNameInUseException`](crate::error::PipelineNameInUseException)
    pub fn builder() -> crate::error::pipeline_name_in_use_exception::Builder {
        crate::error::pipeline_name_in_use_exception::Builder::default()
    }
}

/// <p>The nonce was specified in an invalid format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNonceException {
    /// <p>The message provided to the user in the event of an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNonceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNonceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNonceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNonceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNonceException")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNonceException {}
/// See [`InvalidNonceException`](crate::error::InvalidNonceException)
pub mod invalid_nonce_exception {
    /// A builder for [`InvalidNonceException`](crate::error::InvalidNonceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided to the user in the event of an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNonceException`](crate::error::InvalidNonceException)
        pub fn build(self) -> crate::error::InvalidNonceException {
            crate::error::InvalidNonceException {
                message: self.message,
            }
        }
    }
}
impl InvalidNonceException {
    /// Creates a new builder-style object to manufacture [`InvalidNonceException`](crate::error::InvalidNonceException)
    pub fn builder() -> crate::error::invalid_nonce_exception::Builder {
        crate::error::invalid_nonce_exception::Builder::default()
    }
}
