// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS CodePipeline
///
/// Client for invoking operations on AWS CodePipeline. Each operation on AWS CodePipeline is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codepipeline::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codepipeline::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codepipeline::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcknowledgeJob` operation.
    ///
    /// See [`AcknowledgeJob`](crate::client::fluent_builders::AcknowledgeJob) for more information about the
    /// operation and its arguments.
    pub fn acknowledge_job(&self) -> fluent_builders::AcknowledgeJob<C, M, R> {
        fluent_builders::AcknowledgeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AcknowledgeThirdPartyJob` operation.
    ///
    /// See [`AcknowledgeThirdPartyJob`](crate::client::fluent_builders::AcknowledgeThirdPartyJob) for more information about the
    /// operation and its arguments.
    pub fn acknowledge_third_party_job(
        &self,
    ) -> fluent_builders::AcknowledgeThirdPartyJob<C, M, R> {
        fluent_builders::AcknowledgeThirdPartyJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomActionType` operation.
    ///
    /// See [`CreateCustomActionType`](crate::client::fluent_builders::CreateCustomActionType) for more information about the
    /// operation and its arguments.
    pub fn create_custom_action_type(&self) -> fluent_builders::CreateCustomActionType<C, M, R> {
        fluent_builders::CreateCustomActionType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePipeline` operation.
    ///
    /// See [`CreatePipeline`](crate::client::fluent_builders::CreatePipeline) for more information about the
    /// operation and its arguments.
    pub fn create_pipeline(&self) -> fluent_builders::CreatePipeline<C, M, R> {
        fluent_builders::CreatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomActionType` operation.
    ///
    /// See [`DeleteCustomActionType`](crate::client::fluent_builders::DeleteCustomActionType) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_action_type(&self) -> fluent_builders::DeleteCustomActionType<C, M, R> {
        fluent_builders::DeleteCustomActionType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePipeline` operation.
    ///
    /// See [`DeletePipeline`](crate::client::fluent_builders::DeletePipeline) for more information about the
    /// operation and its arguments.
    pub fn delete_pipeline(&self) -> fluent_builders::DeletePipeline<C, M, R> {
        fluent_builders::DeletePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWebhook` operation.
    ///
    /// See [`DeleteWebhook`](crate::client::fluent_builders::DeleteWebhook) for more information about the
    /// operation and its arguments.
    pub fn delete_webhook(&self) -> fluent_builders::DeleteWebhook<C, M, R> {
        fluent_builders::DeleteWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterWebhookWithThirdParty` operation.
    ///
    /// See [`DeregisterWebhookWithThirdParty`](crate::client::fluent_builders::DeregisterWebhookWithThirdParty) for more information about the
    /// operation and its arguments.
    pub fn deregister_webhook_with_third_party(
        &self,
    ) -> fluent_builders::DeregisterWebhookWithThirdParty<C, M, R> {
        fluent_builders::DeregisterWebhookWithThirdParty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableStageTransition` operation.
    ///
    /// See [`DisableStageTransition`](crate::client::fluent_builders::DisableStageTransition) for more information about the
    /// operation and its arguments.
    pub fn disable_stage_transition(&self) -> fluent_builders::DisableStageTransition<C, M, R> {
        fluent_builders::DisableStageTransition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableStageTransition` operation.
    ///
    /// See [`EnableStageTransition`](crate::client::fluent_builders::EnableStageTransition) for more information about the
    /// operation and its arguments.
    pub fn enable_stage_transition(&self) -> fluent_builders::EnableStageTransition<C, M, R> {
        fluent_builders::EnableStageTransition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetActionType` operation.
    ///
    /// See [`GetActionType`](crate::client::fluent_builders::GetActionType) for more information about the
    /// operation and its arguments.
    pub fn get_action_type(&self) -> fluent_builders::GetActionType<C, M, R> {
        fluent_builders::GetActionType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobDetails` operation.
    ///
    /// See [`GetJobDetails`](crate::client::fluent_builders::GetJobDetails) for more information about the
    /// operation and its arguments.
    pub fn get_job_details(&self) -> fluent_builders::GetJobDetails<C, M, R> {
        fluent_builders::GetJobDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPipeline` operation.
    ///
    /// See [`GetPipeline`](crate::client::fluent_builders::GetPipeline) for more information about the
    /// operation and its arguments.
    pub fn get_pipeline(&self) -> fluent_builders::GetPipeline<C, M, R> {
        fluent_builders::GetPipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPipelineExecution` operation.
    ///
    /// See [`GetPipelineExecution`](crate::client::fluent_builders::GetPipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn get_pipeline_execution(&self) -> fluent_builders::GetPipelineExecution<C, M, R> {
        fluent_builders::GetPipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPipelineState` operation.
    ///
    /// See [`GetPipelineState`](crate::client::fluent_builders::GetPipelineState) for more information about the
    /// operation and its arguments.
    pub fn get_pipeline_state(&self) -> fluent_builders::GetPipelineState<C, M, R> {
        fluent_builders::GetPipelineState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetThirdPartyJobDetails` operation.
    ///
    /// See [`GetThirdPartyJobDetails`](crate::client::fluent_builders::GetThirdPartyJobDetails) for more information about the
    /// operation and its arguments.
    pub fn get_third_party_job_details(&self) -> fluent_builders::GetThirdPartyJobDetails<C, M, R> {
        fluent_builders::GetThirdPartyJobDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListActionExecutions` operation.
    ///
    /// See [`ListActionExecutions`](crate::client::fluent_builders::ListActionExecutions) for more information about the
    /// operation and its arguments.
    pub fn list_action_executions(&self) -> fluent_builders::ListActionExecutions<C, M, R> {
        fluent_builders::ListActionExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListActionTypes` operation.
    ///
    /// See [`ListActionTypes`](crate::client::fluent_builders::ListActionTypes) for more information about the
    /// operation and its arguments.
    pub fn list_action_types(&self) -> fluent_builders::ListActionTypes<C, M, R> {
        fluent_builders::ListActionTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPipelineExecutions` operation.
    ///
    /// See [`ListPipelineExecutions`](crate::client::fluent_builders::ListPipelineExecutions) for more information about the
    /// operation and its arguments.
    pub fn list_pipeline_executions(&self) -> fluent_builders::ListPipelineExecutions<C, M, R> {
        fluent_builders::ListPipelineExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPipelines` operation.
    ///
    /// See [`ListPipelines`](crate::client::fluent_builders::ListPipelines) for more information about the
    /// operation and its arguments.
    pub fn list_pipelines(&self) -> fluent_builders::ListPipelines<C, M, R> {
        fluent_builders::ListPipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWebhooks` operation.
    ///
    /// See [`ListWebhooks`](crate::client::fluent_builders::ListWebhooks) for more information about the
    /// operation and its arguments.
    pub fn list_webhooks(&self) -> fluent_builders::ListWebhooks<C, M, R> {
        fluent_builders::ListWebhooks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PollForJobs` operation.
    ///
    /// See [`PollForJobs`](crate::client::fluent_builders::PollForJobs) for more information about the
    /// operation and its arguments.
    pub fn poll_for_jobs(&self) -> fluent_builders::PollForJobs<C, M, R> {
        fluent_builders::PollForJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PollForThirdPartyJobs` operation.
    ///
    /// See [`PollForThirdPartyJobs`](crate::client::fluent_builders::PollForThirdPartyJobs) for more information about the
    /// operation and its arguments.
    pub fn poll_for_third_party_jobs(&self) -> fluent_builders::PollForThirdPartyJobs<C, M, R> {
        fluent_builders::PollForThirdPartyJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutActionRevision` operation.
    ///
    /// See [`PutActionRevision`](crate::client::fluent_builders::PutActionRevision) for more information about the
    /// operation and its arguments.
    pub fn put_action_revision(&self) -> fluent_builders::PutActionRevision<C, M, R> {
        fluent_builders::PutActionRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutApprovalResult` operation.
    ///
    /// See [`PutApprovalResult`](crate::client::fluent_builders::PutApprovalResult) for more information about the
    /// operation and its arguments.
    pub fn put_approval_result(&self) -> fluent_builders::PutApprovalResult<C, M, R> {
        fluent_builders::PutApprovalResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutJobFailureResult` operation.
    ///
    /// See [`PutJobFailureResult`](crate::client::fluent_builders::PutJobFailureResult) for more information about the
    /// operation and its arguments.
    pub fn put_job_failure_result(&self) -> fluent_builders::PutJobFailureResult<C, M, R> {
        fluent_builders::PutJobFailureResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutJobSuccessResult` operation.
    ///
    /// See [`PutJobSuccessResult`](crate::client::fluent_builders::PutJobSuccessResult) for more information about the
    /// operation and its arguments.
    pub fn put_job_success_result(&self) -> fluent_builders::PutJobSuccessResult<C, M, R> {
        fluent_builders::PutJobSuccessResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutThirdPartyJobFailureResult` operation.
    ///
    /// See [`PutThirdPartyJobFailureResult`](crate::client::fluent_builders::PutThirdPartyJobFailureResult) for more information about the
    /// operation and its arguments.
    pub fn put_third_party_job_failure_result(
        &self,
    ) -> fluent_builders::PutThirdPartyJobFailureResult<C, M, R> {
        fluent_builders::PutThirdPartyJobFailureResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutThirdPartyJobSuccessResult` operation.
    ///
    /// See [`PutThirdPartyJobSuccessResult`](crate::client::fluent_builders::PutThirdPartyJobSuccessResult) for more information about the
    /// operation and its arguments.
    pub fn put_third_party_job_success_result(
        &self,
    ) -> fluent_builders::PutThirdPartyJobSuccessResult<C, M, R> {
        fluent_builders::PutThirdPartyJobSuccessResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutWebhook` operation.
    ///
    /// See [`PutWebhook`](crate::client::fluent_builders::PutWebhook) for more information about the
    /// operation and its arguments.
    pub fn put_webhook(&self) -> fluent_builders::PutWebhook<C, M, R> {
        fluent_builders::PutWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterWebhookWithThirdParty` operation.
    ///
    /// See [`RegisterWebhookWithThirdParty`](crate::client::fluent_builders::RegisterWebhookWithThirdParty) for more information about the
    /// operation and its arguments.
    pub fn register_webhook_with_third_party(
        &self,
    ) -> fluent_builders::RegisterWebhookWithThirdParty<C, M, R> {
        fluent_builders::RegisterWebhookWithThirdParty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetryStageExecution` operation.
    ///
    /// See [`RetryStageExecution`](crate::client::fluent_builders::RetryStageExecution) for more information about the
    /// operation and its arguments.
    pub fn retry_stage_execution(&self) -> fluent_builders::RetryStageExecution<C, M, R> {
        fluent_builders::RetryStageExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartPipelineExecution` operation.
    ///
    /// See [`StartPipelineExecution`](crate::client::fluent_builders::StartPipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn start_pipeline_execution(&self) -> fluent_builders::StartPipelineExecution<C, M, R> {
        fluent_builders::StartPipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopPipelineExecution` operation.
    ///
    /// See [`StopPipelineExecution`](crate::client::fluent_builders::StopPipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn stop_pipeline_execution(&self) -> fluent_builders::StopPipelineExecution<C, M, R> {
        fluent_builders::StopPipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateActionType` operation.
    ///
    /// See [`UpdateActionType`](crate::client::fluent_builders::UpdateActionType) for more information about the
    /// operation and its arguments.
    pub fn update_action_type(&self) -> fluent_builders::UpdateActionType<C, M, R> {
        fluent_builders::UpdateActionType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePipeline` operation.
    ///
    /// See [`UpdatePipeline`](crate::client::fluent_builders::UpdatePipeline) for more information about the
    /// operation and its arguments.
    pub fn update_pipeline(&self) -> fluent_builders::UpdatePipeline<C, M, R> {
        fluent_builders::UpdatePipeline::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcknowledgeJob`.
    ///
    /// <p>Returns information about a specified job and whether that job has been received by
    /// the job worker. Used for custom actions only.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcknowledgeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::acknowledge_job_input::Builder,
    }
    impl<C, M, R> AcknowledgeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcknowledgeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcknowledgeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::AcknowledgeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcknowledgeJobInputOperationOutputAlias,
                crate::output::AcknowledgeJobOutput,
                crate::error::AcknowledgeJobError,
                crate::input::AcknowledgeJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique system-generated ID of the job for which you want to confirm
        /// receipt.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique system-generated ID of the job for which you want to confirm
        /// receipt.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job
        /// is being worked on by only one job worker. Get this number from the response of the
        /// <a>PollForJobs</a> request that returned this job.</p>
        pub fn nonce(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nonce(inp);
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job
        /// is being worked on by only one job worker. Get this number from the response of the
        /// <a>PollForJobs</a> request that returned this job.</p>
        pub fn set_nonce(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_nonce(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AcknowledgeThirdPartyJob`.
    ///
    /// <p>Confirms a job worker has received the specified job. Used for partner actions
    /// only.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcknowledgeThirdPartyJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::acknowledge_third_party_job_input::Builder,
    }
    impl<C, M, R> AcknowledgeThirdPartyJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcknowledgeThirdPartyJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcknowledgeThirdPartyJobOutput,
            aws_smithy_http::result::SdkError<crate::error::AcknowledgeThirdPartyJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcknowledgeThirdPartyJobInputOperationOutputAlias,
                crate::output::AcknowledgeThirdPartyJobOutput,
                crate::error::AcknowledgeThirdPartyJobError,
                crate::input::AcknowledgeThirdPartyJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique system-generated ID of the job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique system-generated ID of the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job
        /// is being worked on by only one job worker. Get this number from the response to a <a>GetThirdPartyJobDetails</a> request.</p>
        pub fn nonce(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nonce(inp);
            self
        }
        /// <p>A system-generated random number that AWS CodePipeline uses to ensure that the job
        /// is being worked on by only one job worker. Get this number from the response to a <a>GetThirdPartyJobDetails</a> request.</p>
        pub fn set_nonce(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_nonce(input);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomActionType`.
    ///
    /// <p>Creates a new custom action that can be used in all pipelines associated with the
    /// AWS account. Only used for custom actions.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomActionType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_action_type_input::Builder,
    }
    impl<C, M, R> CreateCustomActionType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomActionType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomActionTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomActionTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomActionTypeInputOperationOutputAlias,
                crate::output::CreateCustomActionTypeOutput,
                crate::error::CreateCustomActionTypeError,
                crate::input::CreateCustomActionTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The category of the custom action, such as a build action or a test
        /// action.</p>
        pub fn category(mut self, inp: crate::model::ActionCategory) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// <p>The category of the custom action, such as a build action or a test
        /// action.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS
        /// CodeDeploy.</p>
        pub fn provider(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(inp);
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS
        /// CodeDeploy.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The version identifier of the custom action.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The version identifier of the custom action.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>URLs that provide users information about this custom action.</p>
        pub fn settings(mut self, inp: crate::model::ActionTypeSettings) -> Self {
            self.inner = self.inner.settings(inp);
            self
        }
        /// <p>URLs that provide users information about this custom action.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::ActionTypeSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// Appends an item to `configurationProperties`.
        ///
        /// To override the contents of this collection use [`set_configuration_properties`](Self::set_configuration_properties).
        ///
        /// <p>The configuration properties for the custom action.</p>
        /// <note>
        /// <p>You can refer to a name in the configuration properties of the custom action
        /// within the URL templates by following the format of {Config:name}, as long as the
        /// configuration property is both required and not secret. For more information, see
        /// <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a
        /// Custom Action for a Pipeline</a>.</p>
        /// </note>
        pub fn configuration_properties(
            mut self,
            inp: impl Into<crate::model::ActionConfigurationProperty>,
        ) -> Self {
            self.inner = self.inner.configuration_properties(inp);
            self
        }
        /// <p>The configuration properties for the custom action.</p>
        /// <note>
        /// <p>You can refer to a name in the configuration properties of the custom action
        /// within the URL templates by following the format of {Config:name}, as long as the
        /// configuration property is both required and not secret. For more information, see
        /// <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a
        /// Custom Action for a Pipeline</a>.</p>
        /// </note>
        pub fn set_configuration_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionConfigurationProperty>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_properties(input);
            self
        }
        /// <p>The details of the input artifact for the action, such as its commit ID.</p>
        pub fn input_artifact_details(mut self, inp: crate::model::ArtifactDetails) -> Self {
            self.inner = self.inner.input_artifact_details(inp);
            self
        }
        /// <p>The details of the input artifact for the action, such as its commit ID.</p>
        pub fn set_input_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ArtifactDetails>,
        ) -> Self {
            self.inner = self.inner.set_input_artifact_details(input);
            self
        }
        /// <p>The details of the output artifact of the action, such as its commit ID.</p>
        pub fn output_artifact_details(mut self, inp: crate::model::ArtifactDetails) -> Self {
            self.inner = self.inner.output_artifact_details(inp);
            self
        }
        /// <p>The details of the output artifact of the action, such as its commit ID.</p>
        pub fn set_output_artifact_details(
            mut self,
            input: std::option::Option<crate::model::ArtifactDetails>,
        ) -> Self {
            self.inner = self.inner.set_output_artifact_details(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the custom action.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the custom action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePipeline`.
    ///
    /// <p>Creates a pipeline.</p>
    /// <note>
    /// <p>In the pipeline structure, you must include either <code>artifactStore</code>
    /// or <code>artifactStores</code> in your pipeline, but you cannot use both. If you
    /// create a cross-region action in your pipeline, you must use
    /// <code>artifactStores</code>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_pipeline_input::Builder,
    }
    impl<C, M, R> CreatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePipelineInputOperationOutputAlias,
                crate::output::CreatePipelineOutput,
                crate::error::CreatePipelineError,
                crate::input::CreatePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the structure of actions and stages to be performed in the pipeline.
        /// </p>
        pub fn pipeline(mut self, inp: crate::model::PipelineDeclaration) -> Self {
            self.inner = self.inner.pipeline(inp);
            self
        }
        /// <p>Represents the structure of actions and stages to be performed in the pipeline.
        /// </p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::PipelineDeclaration>,
        ) -> Self {
            self.inner = self.inner.set_pipeline(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the pipeline.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomActionType`.
    ///
    /// <p>Marks a custom action as deleted. <code>PollForJobs</code> for the custom action
    /// fails after the action is marked for deletion. Used for custom actions only.</p>
    /// <important>
    /// <p>To re-create a custom action after it has been deleted you must use a string in
    /// the version field that has never been used before. This string can be an incremented
    /// version number, for example. To restore a deleted custom action, use a JSON file
    /// that is identical to the deleted action, including the original string in the
    /// version field.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomActionType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_action_type_input::Builder,
    }
    impl<C, M, R> DeleteCustomActionType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomActionType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomActionTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomActionTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomActionTypeInputOperationOutputAlias,
                crate::output::DeleteCustomActionTypeOutput,
                crate::error::DeleteCustomActionTypeError,
                crate::input::DeleteCustomActionTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The category of the custom action that you want to delete, such as source or
        /// deploy.</p>
        pub fn category(mut self, inp: crate::model::ActionCategory) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// <p>The category of the custom action that you want to delete, such as source or
        /// deploy.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS
        /// CodeDeploy.</p>
        pub fn provider(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(inp);
            self
        }
        /// <p>The provider of the service used in the custom action, such as AWS
        /// CodeDeploy.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The version of the custom action to delete.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The version of the custom action to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePipeline`.
    ///
    /// <p>Deletes the specified pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_pipeline_input::Builder,
    }
    impl<C, M, R> DeletePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePipelineInputOperationOutputAlias,
                crate::output::DeletePipelineOutput,
                crate::error::DeletePipelineError,
                crate::input::DeletePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the pipeline to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebhook`.
    ///
    /// <p>Deletes a previously created webhook by name. Deleting the webhook stops AWS
    /// CodePipeline from starting a pipeline every time an external event occurs. The API
    /// returns successfully when trying to delete a webhook that is already deleted. If a
    /// deleted webhook is re-created by calling PutWebhook with the same name, it will have a
    /// different URL.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_webhook_input::Builder,
    }
    impl<C, M, R> DeleteWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWebhookInputOperationOutputAlias,
                crate::output::DeleteWebhookOutput,
                crate::error::DeleteWebhookError,
                crate::input::DeleteWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the webhook you want to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the webhook you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterWebhookWithThirdParty`.
    ///
    /// <p>Removes the connection between the webhook that was created by CodePipeline and the
    /// external tool with events to be detected. Currently supported only for webhooks that
    /// target an action type of GitHub.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterWebhookWithThirdParty<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_webhook_with_third_party_input::Builder,
    }
    impl<C, M, R> DeregisterWebhookWithThirdParty<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterWebhookWithThirdParty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterWebhookWithThirdPartyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterWebhookWithThirdPartyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterWebhookWithThirdPartyInputOperationOutputAlias,
                crate::output::DeregisterWebhookWithThirdPartyOutput,
                crate::error::DeregisterWebhookWithThirdPartyError,
                crate::input::DeregisterWebhookWithThirdPartyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the webhook you want to deregister.</p>
        pub fn webhook_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_name(inp);
            self
        }
        /// <p>The name of the webhook you want to deregister.</p>
        pub fn set_webhook_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableStageTransition`.
    ///
    /// <p>Prevents artifacts in a pipeline from transitioning to the next stage in the
    /// pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableStageTransition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_stage_transition_input::Builder,
    }
    impl<C, M, R> DisableStageTransition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableStageTransition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableStageTransitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableStageTransitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableStageTransitionInputOperationOutputAlias,
                crate::output::DisableStageTransitionOutput,
                crate::error::DisableStageTransitionError,
                crate::input::DisableStageTransitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline in which you want to disable the flow of artifacts from
        /// one stage to another.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline in which you want to disable the flow of artifacts from
        /// one stage to another.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The name of the stage where you want to disable the inbound or outbound transition
        /// of artifacts.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The name of the stage where you want to disable the inbound or outbound transition
        /// of artifacts.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>Specifies whether artifacts are prevented from transitioning into the stage and
        /// being processed by the actions in that stage (inbound), or prevented from transitioning
        /// from the stage after they have been processed by the actions in that stage
        /// (outbound).</p>
        pub fn transition_type(mut self, inp: crate::model::StageTransitionType) -> Self {
            self.inner = self.inner.transition_type(inp);
            self
        }
        /// <p>Specifies whether artifacts are prevented from transitioning into the stage and
        /// being processed by the actions in that stage (inbound), or prevented from transitioning
        /// from the stage after they have been processed by the actions in that stage
        /// (outbound).</p>
        pub fn set_transition_type(
            mut self,
            input: std::option::Option<crate::model::StageTransitionType>,
        ) -> Self {
            self.inner = self.inner.set_transition_type(input);
            self
        }
        /// <p>The reason given to the user that a stage is disabled, such as waiting for manual
        /// approval or manual tests. This message is displayed in the pipeline console
        /// UI.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>The reason given to the user that a stage is disabled, such as waiting for manual
        /// approval or manual tests. This message is displayed in the pipeline console
        /// UI.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableStageTransition`.
    ///
    /// <p>Enables artifacts in a pipeline to transition to a stage in a pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableStageTransition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_stage_transition_input::Builder,
    }
    impl<C, M, R> EnableStageTransition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableStageTransition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableStageTransitionOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableStageTransitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableStageTransitionInputOperationOutputAlias,
                crate::output::EnableStageTransitionOutput,
                crate::error::EnableStageTransitionError,
                crate::input::EnableStageTransitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline in which you want to enable the flow of artifacts from one
        /// stage to another.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline in which you want to enable the flow of artifacts from one
        /// stage to another.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The name of the stage where you want to enable the transition of artifacts, either
        /// into the stage (inbound) or from that stage to the next stage (outbound).</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The name of the stage where you want to enable the transition of artifacts, either
        /// into the stage (inbound) or from that stage to the next stage (outbound).</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>Specifies whether artifacts are allowed to enter the stage and be processed by the
        /// actions in that stage (inbound) or whether already processed artifacts are allowed to
        /// transition to the next stage (outbound).</p>
        pub fn transition_type(mut self, inp: crate::model::StageTransitionType) -> Self {
            self.inner = self.inner.transition_type(inp);
            self
        }
        /// <p>Specifies whether artifacts are allowed to enter the stage and be processed by the
        /// actions in that stage (inbound) or whether already processed artifacts are allowed to
        /// transition to the next stage (outbound).</p>
        pub fn set_transition_type(
            mut self,
            input: std::option::Option<crate::model::StageTransitionType>,
        ) -> Self {
            self.inner = self.inner.set_transition_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetActionType`.
    ///
    /// <p>Returns information about an action type created for an external provider, where the
    /// action is to be used by customers of the external provider. The action can be created
    /// with any supported integration model.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetActionType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_action_type_input::Builder,
    }
    impl<C, M, R> GetActionType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetActionType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetActionTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetActionTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetActionTypeInputOperationOutputAlias,
                crate::output::GetActionTypeOutput,
                crate::error::GetActionTypeError,
                crate::input::GetActionTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines what kind of action can be taken in the stage. The following are the valid
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Source</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Build</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Test</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Approval</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Invoke</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn category(mut self, inp: crate::model::ActionCategory) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// <p>Defines what kind of action can be taken in the stage. The following are the valid
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Source</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Build</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Test</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deploy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Approval</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Invoke</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::ActionCategory>,
        ) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>The creator of an action type that was created with any supported integration model.
        /// There are two valid values: <code>AWS</code> and <code>ThirdParty</code>.</p>
        pub fn owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>The creator of an action type that was created with any supported integration model.
        /// There are two valid values: <code>AWS</code> and <code>ThirdParty</code>.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The provider of the action type being called. The provider name is specified when the
        /// action type is created.</p>
        pub fn provider(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider(inp);
            self
        }
        /// <p>The provider of the action type being called. The provider name is specified when the
        /// action type is created.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>A string that describes the action type version.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>A string that describes the action type version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobDetails`.
    ///
    /// <p>Returns information about a job. Used for custom actions only.</p>
    /// <important>
    /// <p>When this API is called, AWS CodePipeline returns temporary credentials for the
    /// S3 bucket used to store artifacts for the pipeline, if the action requires access to
    /// that S3 bucket for input or output artifacts. This API also returns any secret
    /// values defined for the action.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct GetJobDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_details_input::Builder,
    }
    impl<C, M, R> GetJobDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobDetailsInputOperationOutputAlias,
                crate::output::GetJobDetailsOutput,
                crate::error::GetJobDetailsError,
                crate::input::GetJobDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique system-generated ID for the job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique system-generated ID for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPipeline`.
    ///
    /// <p>Returns the metadata, structure, stages, and actions of a pipeline. Can be used to
    /// return the entire structure of a pipeline in JSON format, which can then be modified and
    /// used to update the pipeline structure with <a>UpdatePipeline</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_pipeline_input::Builder,
    }
    impl<C, M, R> GetPipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPipelineInputOperationOutputAlias,
                crate::output::GetPipelineOutput,
                crate::error::GetPipelineError,
                crate::input::GetPipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline for which you want to get information. Pipeline names must
        /// be unique under an AWS user account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the pipeline for which you want to get information. Pipeline names must
        /// be unique under an AWS user account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version number of the pipeline. If you do not specify a version, defaults to
        /// the current version.</p>
        pub fn version(mut self, inp: i32) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>The version number of the pipeline. If you do not specify a version, defaults to
        /// the current version.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPipelineExecution`.
    ///
    /// <p>Returns information about an execution of a pipeline, including details about
    /// artifacts, the pipeline execution ID, and the name, version, and status of the
    /// pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPipelineExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_pipeline_execution_input::Builder,
    }
    impl<C, M, R> GetPipelineExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPipelineExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPipelineExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPipelineExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPipelineExecutionInputOperationOutputAlias,
                crate::output::GetPipelineExecutionOutput,
                crate::error::GetPipelineExecutionError,
                crate::input::GetPipelineExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline about which you want to get execution details.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline about which you want to get execution details.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The ID of the pipeline execution about which you want to get execution
        /// details.</p>
        pub fn pipeline_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_execution_id(inp);
            self
        }
        /// <p>The ID of the pipeline execution about which you want to get execution
        /// details.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPipelineState`.
    ///
    /// <p>Returns information about the state of a pipeline, including the stages and
    /// actions.</p>
    /// <note>
    /// <p>Values returned in the <code>revisionId</code> and <code>revisionUrl</code>
    /// fields indicate the source revision information, such as the commit ID, for the
    /// current state.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetPipelineState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_pipeline_state_input::Builder,
    }
    impl<C, M, R> GetPipelineState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPipelineState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPipelineStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPipelineStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPipelineStateInputOperationOutputAlias,
                crate::output::GetPipelineStateOutput,
                crate::error::GetPipelineStateError,
                crate::input::GetPipelineStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline about which you want to get information.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the pipeline about which you want to get information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetThirdPartyJobDetails`.
    ///
    /// <p>Requests the details of a job for a third party action. Used for partner actions
    /// only.</p>
    /// <important>
    /// <p>When this API is called, AWS CodePipeline returns temporary credentials for the
    /// S3 bucket used to store artifacts for the pipeline, if the action requires access to
    /// that S3 bucket for input or output artifacts. This API also returns any secret
    /// values defined for the action.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct GetThirdPartyJobDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_third_party_job_details_input::Builder,
    }
    impl<C, M, R> GetThirdPartyJobDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetThirdPartyJobDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetThirdPartyJobDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetThirdPartyJobDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetThirdPartyJobDetailsInputOperationOutputAlias,
                crate::output::GetThirdPartyJobDetailsOutput,
                crate::error::GetThirdPartyJobDetailsError,
                crate::input::GetThirdPartyJobDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique system-generated ID used for identifying the job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique system-generated ID used for identifying the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActionExecutions`.
    ///
    /// <p>Lists the action executions that have occurred in a pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListActionExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_action_executions_input::Builder,
    }
    impl<C, M, R> ListActionExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListActionExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActionExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActionExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListActionExecutionsInputOperationOutputAlias,
                crate::output::ListActionExecutionsOutput,
                crate::error::ListActionExecutionsError,
                crate::input::ListActionExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the pipeline for which you want to list action execution history.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p> The name of the pipeline for which you want to list action execution history.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>Input information used to filter action execution history.</p>
        pub fn filter(mut self, inp: crate::model::ActionExecutionFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Input information used to filter action execution history.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ActionExecutionFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned nextToken value. Action execution history
        /// is retained for up to 12 months, based on action execution start times. Default value is
        /// 100. </p>
        /// <note>
        /// <p>Detailed execution history is available for executions run on or after February
        /// 21, 2019.</p>
        /// </note>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned nextToken value. Action execution history
        /// is retained for up to 12 months, based on action execution start times. Default value is
        /// 100. </p>
        /// <note>
        /// <p>Detailed execution history is available for executions run on or after February
        /// 21, 2019.</p>
        /// </note>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that was returned from the previous <code>ListActionExecutions</code> call,
        /// which can be used to return the next set of action executions in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that was returned from the previous <code>ListActionExecutions</code> call,
        /// which can be used to return the next set of action executions in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActionTypes`.
    ///
    /// <p>Gets a summary of all AWS CodePipeline action types associated with your
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListActionTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_action_types_input::Builder,
    }
    impl<C, M, R> ListActionTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListActionTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActionTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActionTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListActionTypesInputOperationOutputAlias,
                crate::output::ListActionTypesOutput,
                crate::error::ListActionTypesError,
                crate::input::ListActionTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the list of action types to those created by a specified entity.</p>
        pub fn action_owner_filter(mut self, inp: crate::model::ActionOwner) -> Self {
            self.inner = self.inner.action_owner_filter(inp);
            self
        }
        /// <p>Filters the list of action types to those created by a specified entity.</p>
        pub fn set_action_owner_filter(
            mut self,
            input: std::option::Option<crate::model::ActionOwner>,
        ) -> Self {
            self.inner = self.inner.set_action_owner_filter(input);
            self
        }
        /// <p>An identifier that was returned from the previous list action types call, which can
        /// be used to return the next set of action types in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous list action types call, which can
        /// be used to return the next set of action types in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The Region to filter on for the list of action types.</p>
        pub fn region_filter(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_filter(inp);
            self
        }
        /// <p>The Region to filter on for the list of action types.</p>
        pub fn set_region_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_region_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPipelineExecutions`.
    ///
    /// <p>Gets a summary of the most recent executions for a pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPipelineExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pipeline_executions_input::Builder,
    }
    impl<C, M, R> ListPipelineExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPipelineExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPipelineExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPipelineExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPipelineExecutionsInputOperationOutputAlias,
                crate::output::ListPipelineExecutionsOutput,
                crate::error::ListPipelineExecutionsError,
                crate::input::ListPipelineExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline for which you want to get execution summary
        /// information.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline for which you want to get execution summary
        /// information.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned nextToken value. Pipeline history is
        /// limited to the most recent 12 months, based on pipeline execution start times. Default
        /// value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned nextToken value. Pipeline history is
        /// limited to the most recent 12 months, based on pipeline execution start times. Default
        /// value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that was returned from the previous <code>ListPipelineExecutions</code>
        /// call, which can be used to return the next set of pipeline executions in the
        /// list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that was returned from the previous <code>ListPipelineExecutions</code>
        /// call, which can be used to return the next set of pipeline executions in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPipelines`.
    ///
    /// <p>Gets a summary of all of the pipelines associated with your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPipelines<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pipelines_input::Builder,
    }
    impl<C, M, R> ListPipelines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPipelinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPipelinesInputOperationOutputAlias,
                crate::output::ListPipelinesOutput,
                crate::error::ListPipelinesError,
                crate::input::ListPipelinesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier that was returned from the previous list pipelines call. It can be
        /// used to return the next set of pipelines in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous list pipelines call. It can be
        /// used to return the next set of pipelines in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of pipelines to return in a single call. To retrieve the remaining
        /// pipelines, make another call with the returned nextToken value. The minimum value you
        /// can specify is 1. The maximum accepted value is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of pipelines to return in a single call. To retrieve the remaining
        /// pipelines, make another call with the returned nextToken value. The minimum value you
        /// can specify is 1. The maximum accepted value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets the set of key-value pairs (metadata) that are used to manage the
    /// resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The token that was returned from the previous API call, which would be used to return
        /// the next page of the list. The ListTagsforResource call lists all available tags in one
        /// call and does not use pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that was returned from the previous API call, which would be used to return
        /// the next page of the list. The ListTagsforResource call lists all available tags in one
        /// call and does not use pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebhooks`.
    ///
    /// <p>Gets a listing of all the webhooks in this AWS Region for this account. The output
    /// lists all webhooks and includes the webhook URL and ARN and the configuration for each
    /// webhook.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWebhooks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_webhooks_input::Builder,
    }
    impl<C, M, R> ListWebhooks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWebhooks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebhooksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebhooksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWebhooksInputOperationOutputAlias,
                crate::output::ListWebhooksOutput,
                crate::error::ListWebhooksError,
                crate::input::ListWebhooksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that was returned from the previous ListWebhooks call, which can be used
        /// to return the next set of webhooks in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that was returned from the previous ListWebhooks call, which can be used
        /// to return the next set of webhooks in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned nextToken value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. To retrieve the remaining
        /// results, make another call with the returned nextToken value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PollForJobs`.
    ///
    /// <p>Returns information about any jobs for AWS CodePipeline to act on.
    /// <code>PollForJobs</code> is valid only for action types with "Custom" in the owner
    /// field. If the action type contains "AWS" or "ThirdParty" in the owner field, the
    /// <code>PollForJobs</code> action returns an error.</p>
    /// <important>
    /// <p>When this API is called, AWS CodePipeline returns temporary credentials for the
    /// S3 bucket used to store artifacts for the pipeline, if the action requires access to
    /// that S3 bucket for input or output artifacts. This API also returns any secret
    /// values defined for the action.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct PollForJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::poll_for_jobs_input::Builder,
    }
    impl<C, M, R> PollForJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PollForJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PollForJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::PollForJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PollForJobsInputOperationOutputAlias,
                crate::output::PollForJobsOutput,
                crate::error::PollForJobsError,
                crate::input::PollForJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents information about an action type.</p>
        pub fn action_type_id(mut self, inp: crate::model::ActionTypeId) -> Self {
            self.inner = self.inner.action_type_id(inp);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.inner = self.inner.set_action_type_id(input);
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn max_batch_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_batch_size(inp);
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_batch_size(input);
            self
        }
        /// Adds a key-value pair to `queryParam`.
        ///
        /// To override the contents of this collection use [`set_query_param`](Self::set_query_param).
        ///
        /// <p>A map of property names and values. For an action type with no queryable
        /// properties, this value must be null or an empty map. For an action type with a queryable
        /// property, you must supply that property as a key in the map. Only jobs whose action
        /// configuration matches the mapped value are returned.</p>
        pub fn query_param(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.query_param(k, v);
            self
        }
        /// <p>A map of property names and values. For an action type with no queryable
        /// properties, this value must be null or an empty map. For an action type with a queryable
        /// property, you must supply that property as a key in the map. Only jobs whose action
        /// configuration matches the mapped value are returned.</p>
        pub fn set_query_param(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_query_param(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PollForThirdPartyJobs`.
    ///
    /// <p>Determines whether there are any third party jobs for a job worker to act on. Used
    /// for partner actions only.</p>
    /// <important>
    /// <p>When this API is called, AWS CodePipeline returns temporary credentials for the
    /// S3 bucket used to store artifacts for the pipeline, if the action requires access to
    /// that S3 bucket for input or output artifacts.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct PollForThirdPartyJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::poll_for_third_party_jobs_input::Builder,
    }
    impl<C, M, R> PollForThirdPartyJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PollForThirdPartyJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PollForThirdPartyJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::PollForThirdPartyJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PollForThirdPartyJobsInputOperationOutputAlias,
                crate::output::PollForThirdPartyJobsOutput,
                crate::error::PollForThirdPartyJobsError,
                crate::input::PollForThirdPartyJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents information about an action type.</p>
        pub fn action_type_id(mut self, inp: crate::model::ActionTypeId) -> Self {
            self.inner = self.inner.action_type_id(inp);
            self
        }
        /// <p>Represents information about an action type.</p>
        pub fn set_action_type_id(
            mut self,
            input: std::option::Option<crate::model::ActionTypeId>,
        ) -> Self {
            self.inner = self.inner.set_action_type_id(input);
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn max_batch_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_batch_size(inp);
            self
        }
        /// <p>The maximum number of jobs to return in a poll for jobs call.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_batch_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutActionRevision`.
    ///
    /// <p>Provides information to AWS CodePipeline about new revisions to a source.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutActionRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_action_revision_input::Builder,
    }
    impl<C, M, R> PutActionRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutActionRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutActionRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutActionRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutActionRevisionInputOperationOutputAlias,
                crate::output::PutActionRevisionOutput,
                crate::error::PutActionRevisionError,
                crate::input::PutActionRevisionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline that starts processing the revision to the
        /// source.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline that starts processing the revision to the
        /// source.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The name of the stage that contains the action that acts on the revision.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The name of the stage that contains the action that acts on the revision.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The name of the action that processes the revision.</p>
        pub fn action_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(inp);
            self
        }
        /// <p>The name of the action that processes the revision.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
        /// <p>Represents information about the version (or revision) of an action.</p>
        pub fn action_revision(mut self, inp: crate::model::ActionRevision) -> Self {
            self.inner = self.inner.action_revision(inp);
            self
        }
        /// <p>Represents information about the version (or revision) of an action.</p>
        pub fn set_action_revision(
            mut self,
            input: std::option::Option<crate::model::ActionRevision>,
        ) -> Self {
            self.inner = self.inner.set_action_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutApprovalResult`.
    ///
    /// <p>Provides the response to a manual approval request to AWS CodePipeline. Valid
    /// responses include Approved and Rejected.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutApprovalResult<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_approval_result_input::Builder,
    }
    impl<C, M, R> PutApprovalResult<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutApprovalResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutApprovalResultOutput,
            aws_smithy_http::result::SdkError<crate::error::PutApprovalResultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutApprovalResultInputOperationOutputAlias,
                crate::output::PutApprovalResultOutput,
                crate::error::PutApprovalResultError,
                crate::input::PutApprovalResultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline that contains the action. </p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline that contains the action. </p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The name of the stage that contains the action.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The name of the stage that contains the action.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The name of the action for which approval is requested.</p>
        pub fn action_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(inp);
            self
        }
        /// <p>The name of the action for which approval is requested.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
        /// <p>Represents information about the result of the approval request.</p>
        pub fn result(mut self, inp: crate::model::ApprovalResult) -> Self {
            self.inner = self.inner.result(inp);
            self
        }
        /// <p>Represents information about the result of the approval request.</p>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ApprovalResult>,
        ) -> Self {
            self.inner = self.inner.set_result(input);
            self
        }
        /// <p>The system-generated token used to identify a unique approval request. The token
        /// for each open approval request can be obtained using the <a>GetPipelineState</a> action. It is used to validate that the approval
        /// request corresponding to this token is still valid.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The system-generated token used to identify a unique approval request. The token
        /// for each open approval request can be obtained using the <a>GetPipelineState</a> action. It is used to validate that the approval
        /// request corresponding to this token is still valid.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutJobFailureResult`.
    ///
    /// <p>Represents the failure of a job as returned to the pipeline by a job worker. Used
    /// for custom actions only.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutJobFailureResult<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_job_failure_result_input::Builder,
    }
    impl<C, M, R> PutJobFailureResult<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutJobFailureResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutJobFailureResultOutput,
            aws_smithy_http::result::SdkError<crate::error::PutJobFailureResultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutJobFailureResultInputOperationOutputAlias,
                crate::output::PutJobFailureResultOutput,
                crate::error::PutJobFailureResultError,
                crate::input::PutJobFailureResultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique system-generated ID of the job that failed. This is the same ID returned
        /// from <code>PollForJobs</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique system-generated ID of the job that failed. This is the same ID returned
        /// from <code>PollForJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The details about the failure of a job.</p>
        pub fn failure_details(mut self, inp: crate::model::FailureDetails) -> Self {
            self.inner = self.inner.failure_details(inp);
            self
        }
        /// <p>The details about the failure of a job.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.inner = self.inner.set_failure_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutJobSuccessResult`.
    ///
    /// <p>Represents the success of a job as returned to the pipeline by a job worker. Used
    /// for custom actions only.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutJobSuccessResult<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_job_success_result_input::Builder,
    }
    impl<C, M, R> PutJobSuccessResult<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutJobSuccessResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutJobSuccessResultOutput,
            aws_smithy_http::result::SdkError<crate::error::PutJobSuccessResultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutJobSuccessResultInputOperationOutputAlias,
                crate::output::PutJobSuccessResultOutput,
                crate::error::PutJobSuccessResultError,
                crate::input::PutJobSuccessResultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique system-generated ID of the job that succeeded. This is the same ID
        /// returned from <code>PollForJobs</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique system-generated ID of the job that succeeded. This is the same ID
        /// returned from <code>PollForJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The ID of the current revision of the artifact successfully worked on by the
        /// job.</p>
        pub fn current_revision(mut self, inp: crate::model::CurrentRevision) -> Self {
            self.inner = self.inner.current_revision(inp);
            self
        }
        /// <p>The ID of the current revision of the artifact successfully worked on by the
        /// job.</p>
        pub fn set_current_revision(
            mut self,
            input: std::option::Option<crate::model::CurrentRevision>,
        ) -> Self {
            self.inner = self.inner.set_current_revision(input);
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a
        /// successful job provides to identify a custom action in progress. Future jobs use this
        /// token to identify the running instance of the action. It can be reused to return more
        /// information about the progress of the custom action. When the action is complete, no
        /// continuation token should be supplied.</p>
        pub fn continuation_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continuation_token(inp);
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a
        /// successful job provides to identify a custom action in progress. Future jobs use this
        /// token to identify the running instance of the action. It can be reused to return more
        /// information about the progress of the custom action. When the action is complete, no
        /// continuation token should be supplied.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continuation_token(input);
            self
        }
        /// <p>The execution details of the successful job, such as the actions taken by the job
        /// worker.</p>
        pub fn execution_details(mut self, inp: crate::model::ExecutionDetails) -> Self {
            self.inner = self.inner.execution_details(inp);
            self
        }
        /// <p>The execution details of the successful job, such as the actions taken by the job
        /// worker.</p>
        pub fn set_execution_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionDetails>,
        ) -> Self {
            self.inner = self.inner.set_execution_details(input);
            self
        }
        /// Adds a key-value pair to `outputVariables`.
        ///
        /// To override the contents of this collection use [`set_output_variables`](Self::set_output_variables).
        ///
        /// <p>Key-value pairs produced as output by a job worker that can be made available to a
        /// downstream action configuration. <code>outputVariables</code> can be included only when
        /// there is no continuation token on the request.</p>
        pub fn output_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.output_variables(k, v);
            self
        }
        /// <p>Key-value pairs produced as output by a job worker that can be made available to a
        /// downstream action configuration. <code>outputVariables</code> can be included only when
        /// there is no continuation token on the request.</p>
        pub fn set_output_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_output_variables(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutThirdPartyJobFailureResult`.
    ///
    /// <p>Represents the failure of a third party job as returned to the pipeline by a job
    /// worker. Used for partner actions only.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutThirdPartyJobFailureResult<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_third_party_job_failure_result_input::Builder,
    }
    impl<C, M, R> PutThirdPartyJobFailureResult<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutThirdPartyJobFailureResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutThirdPartyJobFailureResultOutput,
            aws_smithy_http::result::SdkError<crate::error::PutThirdPartyJobFailureResultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutThirdPartyJobFailureResultInputOperationOutputAlias,
                crate::output::PutThirdPartyJobFailureResultOutput,
                crate::error::PutThirdPartyJobFailureResultError,
                crate::input::PutThirdPartyJobFailureResultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job that failed. This is the same ID returned from
        /// <code>PollForThirdPartyJobs</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the job that failed. This is the same ID returned from
        /// <code>PollForThirdPartyJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Represents information about failure details.</p>
        pub fn failure_details(mut self, inp: crate::model::FailureDetails) -> Self {
            self.inner = self.inner.failure_details(inp);
            self
        }
        /// <p>Represents information about failure details.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.inner = self.inner.set_failure_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutThirdPartyJobSuccessResult`.
    ///
    /// <p>Represents the success of a third party job as returned to the pipeline by a job
    /// worker. Used for partner actions only.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutThirdPartyJobSuccessResult<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_third_party_job_success_result_input::Builder,
    }
    impl<C, M, R> PutThirdPartyJobSuccessResult<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutThirdPartyJobSuccessResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutThirdPartyJobSuccessResultOutput,
            aws_smithy_http::result::SdkError<crate::error::PutThirdPartyJobSuccessResultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutThirdPartyJobSuccessResultInputOperationOutputAlias,
                crate::output::PutThirdPartyJobSuccessResultOutput,
                crate::error::PutThirdPartyJobSuccessResultError,
                crate::input::PutThirdPartyJobSuccessResultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job that successfully completed. This is the same ID returned from
        /// <code>PollForThirdPartyJobs</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the job that successfully completed. This is the same ID returned from
        /// <code>PollForThirdPartyJobs</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The clientToken portion of the clientId and clientToken pair used to verify that
        /// the calling entity is allowed access to the job and its details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Represents information about a current revision.</p>
        pub fn current_revision(mut self, inp: crate::model::CurrentRevision) -> Self {
            self.inner = self.inner.current_revision(inp);
            self
        }
        /// <p>Represents information about a current revision.</p>
        pub fn set_current_revision(
            mut self,
            input: std::option::Option<crate::model::CurrentRevision>,
        ) -> Self {
            self.inner = self.inner.set_current_revision(input);
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a
        /// successful job provides to identify a partner action in progress. Future jobs use this
        /// token to identify the running instance of the action. It can be reused to return more
        /// information about the progress of the partner action. When the action is complete, no
        /// continuation token should be supplied.</p>
        pub fn continuation_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continuation_token(inp);
            self
        }
        /// <p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a
        /// successful job provides to identify a partner action in progress. Future jobs use this
        /// token to identify the running instance of the action. It can be reused to return more
        /// information about the progress of the partner action. When the action is complete, no
        /// continuation token should be supplied.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continuation_token(input);
            self
        }
        /// <p>The details of the actions taken and results produced on an artifact as it passes
        /// through stages in the pipeline. </p>
        pub fn execution_details(mut self, inp: crate::model::ExecutionDetails) -> Self {
            self.inner = self.inner.execution_details(inp);
            self
        }
        /// <p>The details of the actions taken and results produced on an artifact as it passes
        /// through stages in the pipeline. </p>
        pub fn set_execution_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionDetails>,
        ) -> Self {
            self.inner = self.inner.set_execution_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutWebhook`.
    ///
    /// <p>Defines a webhook and returns a unique webhook URL generated by CodePipeline. This
    /// URL can be supplied to third party source hosting providers to call every time there's a
    /// code change. When CodePipeline receives a POST request on this URL, the pipeline defined
    /// in the webhook is started as long as the POST request satisfied the authentication and
    /// filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty
    /// and DeregisterWebhookWithThirdParty APIs can be used to automatically configure
    /// supported third parties to call the generated webhook URL.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_webhook_input::Builder,
    }
    impl<C, M, R> PutWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::PutWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutWebhookInputOperationOutputAlias,
                crate::output::PutWebhookOutput,
                crate::error::PutWebhookError,
                crate::input::PutWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detail provided in an input file to create the webhook, such as the webhook
        /// name, the pipeline name, and the action name. Give the webhook a unique name that helps
        /// you identify it. You might name the webhook after the pipeline and action it targets so
        /// that you can easily recognize what it's used for later.</p>
        pub fn webhook(mut self, inp: crate::model::WebhookDefinition) -> Self {
            self.inner = self.inner.webhook(inp);
            self
        }
        /// <p>The detail provided in an input file to create the webhook, such as the webhook
        /// name, the pipeline name, and the action name. Give the webhook a unique name that helps
        /// you identify it. You might name the webhook after the pipeline and action it targets so
        /// that you can easily recognize what it's used for later.</p>
        pub fn set_webhook(
            mut self,
            input: std::option::Option<crate::model::WebhookDefinition>,
        ) -> Self {
            self.inner = self.inner.set_webhook(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the webhook.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the webhook.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterWebhookWithThirdParty`.
    ///
    /// <p>Configures a connection between the webhook that was created and the external tool
    /// with events to be detected.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterWebhookWithThirdParty<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_webhook_with_third_party_input::Builder,
    }
    impl<C, M, R> RegisterWebhookWithThirdParty<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterWebhookWithThirdParty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterWebhookWithThirdPartyOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterWebhookWithThirdPartyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterWebhookWithThirdPartyInputOperationOutputAlias,
                crate::output::RegisterWebhookWithThirdPartyOutput,
                crate::error::RegisterWebhookWithThirdPartyError,
                crate::input::RegisterWebhookWithThirdPartyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an existing webhook created with PutWebhook to register with a
        /// supported third party. </p>
        pub fn webhook_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.webhook_name(inp);
            self
        }
        /// <p>The name of an existing webhook created with PutWebhook to register with a
        /// supported third party. </p>
        pub fn set_webhook_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_webhook_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryStageExecution`.
    ///
    /// <p>Resumes the pipeline execution by retrying the last failed actions in a stage. You
    /// can retry a stage immediately if any of the actions in the stage fail. When you retry,
    /// all actions that are still in progress continue working, and failed actions are
    /// triggered again.</p>
    #[derive(std::fmt::Debug)]
    pub struct RetryStageExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retry_stage_execution_input::Builder,
    }
    impl<C, M, R> RetryStageExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetryStageExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryStageExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryStageExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetryStageExecutionInputOperationOutputAlias,
                crate::output::RetryStageExecutionOutput,
                crate::error::RetryStageExecutionError,
                crate::input::RetryStageExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline that contains the failed stage.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline that contains the failed stage.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The name of the failed stage to be retried.</p>
        pub fn stage_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(inp);
            self
        }
        /// <p>The name of the failed stage to be retried.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The ID of the pipeline execution in the failed stage to be retried. Use the <a>GetPipelineState</a> action to retrieve the current pipelineExecutionId of
        /// the failed stage</p>
        pub fn pipeline_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_execution_id(inp);
            self
        }
        /// <p>The ID of the pipeline execution in the failed stage to be retried. Use the <a>GetPipelineState</a> action to retrieve the current pipelineExecutionId of
        /// the failed stage</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_execution_id(input);
            self
        }
        /// <p>The scope of the retry attempt. Currently, the only supported value is
        /// FAILED_ACTIONS.</p>
        pub fn retry_mode(mut self, inp: crate::model::StageRetryMode) -> Self {
            self.inner = self.inner.retry_mode(inp);
            self
        }
        /// <p>The scope of the retry attempt. Currently, the only supported value is
        /// FAILED_ACTIONS.</p>
        pub fn set_retry_mode(
            mut self,
            input: std::option::Option<crate::model::StageRetryMode>,
        ) -> Self {
            self.inner = self.inner.set_retry_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPipelineExecution`.
    ///
    /// <p>Starts the specified pipeline. Specifically, it begins processing the latest commit
    /// to the source location specified as part of the pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartPipelineExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_pipeline_execution_input::Builder,
    }
    impl<C, M, R> StartPipelineExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartPipelineExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPipelineExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPipelineExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartPipelineExecutionInputOperationOutputAlias,
                crate::output::StartPipelineExecutionOutput,
                crate::error::StartPipelineExecutionError,
                crate::input::StartPipelineExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to start.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the pipeline to start.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The system-generated unique ID used to identify a unique execution
        /// request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The system-generated unique ID used to identify a unique execution
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopPipelineExecution`.
    ///
    /// <p>Stops the specified pipeline execution. You choose to either stop the pipeline
    /// execution by completing in-progress actions without starting subsequent actions, or by
    /// abandoning in-progress actions. While completing or abandoning in-progress actions, the
    /// pipeline execution is in a <code>Stopping</code> state. After all in-progress actions
    /// are completed or abandoned, the pipeline execution is in a <code>Stopped</code>
    /// state.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopPipelineExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_pipeline_execution_input::Builder,
    }
    impl<C, M, R> StopPipelineExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopPipelineExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopPipelineExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopPipelineExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopPipelineExecutionInputOperationOutputAlias,
                crate::output::StopPipelineExecutionOutput,
                crate::error::StopPipelineExecutionError,
                crate::input::StopPipelineExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to stop.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline to stop.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The ID of the pipeline execution to be stopped in the current stage. Use the
        /// <code>GetPipelineState</code> action to retrieve the current
        /// pipelineExecutionId.</p>
        pub fn pipeline_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_execution_id(inp);
            self
        }
        /// <p>The ID of the pipeline execution to be stopped in the current stage. Use the
        /// <code>GetPipelineState</code> action to retrieve the current
        /// pipelineExecutionId.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_execution_id(input);
            self
        }
        /// <p>Use this option to stop the pipeline execution by abandoning, rather than finishing,
        /// in-progress actions.</p>
        /// <note>
        /// <p>This option can lead to failed or out-of-sequence tasks.</p>
        /// </note>
        pub fn abandon(mut self, inp: bool) -> Self {
            self.inner = self.inner.abandon(inp);
            self
        }
        /// <p>Use this option to stop the pipeline execution by abandoning, rather than finishing,
        /// in-progress actions.</p>
        /// <note>
        /// <p>This option can lead to failed or out-of-sequence tasks.</p>
        /// </note>
        pub fn set_abandon(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_abandon(input);
            self
        }
        /// <p>Use this option to enter comments, such as the reason the pipeline was stopped.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>Use this option to enter comments, such as the reason the pipeline was stopped.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used
    /// to manage a resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an AWS resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys for the tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of keys for the tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateActionType`.
    ///
    /// <p>Updates an action type that was created with any supported integration model, where
    /// the action type is to be used by customers of the action type provider. Use a JSON file
    /// with the action definition and <code>UpdateActionType</code> to provide the full
    /// structure.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateActionType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_action_type_input::Builder,
    }
    impl<C, M, R> UpdateActionType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateActionType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateActionTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateActionTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateActionTypeInputOperationOutputAlias,
                crate::output::UpdateActionTypeOutput,
                crate::error::UpdateActionTypeError,
                crate::input::UpdateActionTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The action type definition for the action type to be updated.</p>
        pub fn action_type(mut self, inp: crate::model::ActionTypeDeclaration) -> Self {
            self.inner = self.inner.action_type(inp);
            self
        }
        /// <p>The action type definition for the action type to be updated.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionTypeDeclaration>,
        ) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePipeline`.
    ///
    /// <p>Updates a specified pipeline with edits or changes to its structure. Use a JSON
    /// file with the pipeline structure and <code>UpdatePipeline</code> to provide the full
    /// structure of the pipeline. Updating the pipeline increases the version number of the
    /// pipeline by 1.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_pipeline_input::Builder,
    }
    impl<C, M, R> UpdatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePipelineInputOperationOutputAlias,
                crate::output::UpdatePipelineOutput,
                crate::error::UpdatePipelineError,
                crate::input::UpdatePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to be updated.</p>
        pub fn pipeline(mut self, inp: crate::model::PipelineDeclaration) -> Self {
            self.inner = self.inner.pipeline(inp);
            self
        }
        /// <p>The name of the pipeline to be updated.</p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::PipelineDeclaration>,
        ) -> Self {
            self.inner = self.inner.set_pipeline(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
