// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The specified action cannot be found.</p>
    ActionNotFoundException(crate::error::ActionNotFoundException),
    /// <p>The specified action type cannot be found.</p>
    ActionTypeNotFoundException(crate::error::ActionTypeNotFoundException),
    /// <p>The approval action has already been approved or rejected.</p>
    ApprovalAlreadyCompletedException(crate::error::ApprovalAlreadyCompletedException),
    /// <p>Unable to modify the tag due to a simultaneous update request.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Your request cannot be handled because the pipeline is busy handling ongoing activities. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The pipeline execution is already in a <code>Stopping</code> state. If you already chose to stop and wait, you cannot make that request again. You can choose to stop and abandon now, but be aware that this option can lead to failed tasks or out of sequence tasks. If you already chose to stop and abandon, you cannot make that request again.</p>
    DuplicatedStopRequestException(crate::error::DuplicatedStopRequestException),
    /// <p>The action declaration was specified in an invalid format.</p>
    InvalidActionDeclarationException(crate::error::InvalidActionDeclarationException),
    /// <p>The approval request already received a response or has expired.</p>
    InvalidApprovalTokenException(crate::error::InvalidApprovalTokenException),
    /// <p>The specified resource ARN is invalid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Reserved for future use.</p>
    InvalidBlockerDeclarationException(crate::error::InvalidBlockerDeclarationException),
    /// <p>The client token was specified in an invalid format</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    InvalidJobException(crate::error::InvalidJobException),
    /// <p>The job state was specified in an invalid format.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The nonce was specified in an invalid format.</p>
    InvalidNonceException(crate::error::InvalidNonceException),
    /// <p>The stage declaration was specified in an invalid format.</p>
    InvalidStageDeclarationException(crate::error::InvalidStageDeclarationException),
    /// <p>The structure was specified in an invalid format.</p>
    InvalidStructureException(crate::error::InvalidStructureException),
    /// <p>The specified resource tags are invalid.</p>
    InvalidTagsException(crate::error::InvalidTagsException),
    /// <p>The specified authentication type is in an invalid format.</p>
    InvalidWebhookAuthenticationParametersException(
        crate::error::InvalidWebhookAuthenticationParametersException,
    ),
    /// <p>The specified event filter rule is in an invalid format.</p>
    InvalidWebhookFilterPatternException(crate::error::InvalidWebhookFilterPatternException),
    /// <p>The job was specified in an invalid format or cannot be found.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The stage has failed in a later run of the pipeline and the pipelineExecutionId associated with the request is out of date.</p>
    NotLatestPipelineExecutionException(crate::error::NotLatestPipelineExecutionException),
    /// <p>Exceeded the total size limit for all variables in the pipeline.</p>
    OutputVariablesSizeExceededException(crate::error::OutputVariablesSizeExceededException),
    /// <p>The pipeline execution was specified in an invalid format or cannot be found, or an execution ID does not belong to the specified pipeline. </p>
    PipelineExecutionNotFoundException(crate::error::PipelineExecutionNotFoundException),
    /// <p>Unable to stop the pipeline execution. The execution might already be in a <code>Stopped</code> state, or it might no longer be in progress.</p>
    PipelineExecutionNotStoppableException(crate::error::PipelineExecutionNotStoppableException),
    /// <p>The specified pipeline name is already in use.</p>
    PipelineNameInUseException(crate::error::PipelineNameInUseException),
    /// <p>The pipeline was specified in an invalid format or cannot be found.</p>
    PipelineNotFoundException(crate::error::PipelineNotFoundException),
    /// <p>The pipeline version was specified in an invalid format or cannot be found.</p>
    PipelineVersionNotFoundException(crate::error::PipelineVersionNotFoundException),
    /// <p>The request failed because of an unknown error, exception, or failure.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>The resource was specified in an invalid format.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The stage was specified in an invalid format or cannot be found.</p>
    StageNotFoundException(crate::error::StageNotFoundException),
    /// <p>Unable to retry. The pipeline structure or stage state might have changed while actions awaited retry, or the stage contains no failed actions.</p>
    StageNotRetryableException(crate::error::StageNotRetryableException),
    /// <p>The tags limit for a resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The validation was specified in an invalid format.</p>
    ValidationException(crate::error::ValidationException),
    /// <p>The specified webhook was entered in an invalid format or cannot be found.</p>
    WebhookNotFoundException(crate::error::WebhookNotFoundException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ActionNotFoundException(inner) => inner.fmt(f),
            Error::ActionTypeNotFoundException(inner) => inner.fmt(f),
            Error::ApprovalAlreadyCompletedException(inner) => inner.fmt(f),
            Error::ConcurrentModificationException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::DuplicatedStopRequestException(inner) => inner.fmt(f),
            Error::InvalidActionDeclarationException(inner) => inner.fmt(f),
            Error::InvalidApprovalTokenException(inner) => inner.fmt(f),
            Error::InvalidArnException(inner) => inner.fmt(f),
            Error::InvalidBlockerDeclarationException(inner) => inner.fmt(f),
            Error::InvalidClientTokenException(inner) => inner.fmt(f),
            Error::InvalidJobException(inner) => inner.fmt(f),
            Error::InvalidJobStateException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidNonceException(inner) => inner.fmt(f),
            Error::InvalidStageDeclarationException(inner) => inner.fmt(f),
            Error::InvalidStructureException(inner) => inner.fmt(f),
            Error::InvalidTagsException(inner) => inner.fmt(f),
            Error::InvalidWebhookAuthenticationParametersException(inner) => inner.fmt(f),
            Error::InvalidWebhookFilterPatternException(inner) => inner.fmt(f),
            Error::JobNotFoundException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::NotLatestPipelineExecutionException(inner) => inner.fmt(f),
            Error::OutputVariablesSizeExceededException(inner) => inner.fmt(f),
            Error::PipelineExecutionNotFoundException(inner) => inner.fmt(f),
            Error::PipelineExecutionNotStoppableException(inner) => inner.fmt(f),
            Error::PipelineNameInUseException(inner) => inner.fmt(f),
            Error::PipelineNotFoundException(inner) => inner.fmt(f),
            Error::PipelineVersionNotFoundException(inner) => inner.fmt(f),
            Error::RequestFailedException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::StageNotFoundException(inner) => inner.fmt(f),
            Error::StageNotRetryableException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::WebhookNotFoundException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AcknowledgeJobError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AcknowledgeJobError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AcknowledgeJobErrorKind::InvalidNonceException(inner) => {
                    Error::InvalidNonceException(inner)
                }
                crate::error::AcknowledgeJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::AcknowledgeJobErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::AcknowledgeJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AcknowledgeThirdPartyJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AcknowledgeThirdPartyJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AcknowledgeThirdPartyJobErrorKind::InvalidClientTokenException(
                    inner,
                ) => Error::InvalidClientTokenException(inner),
                crate::error::AcknowledgeThirdPartyJobErrorKind::InvalidNonceException(inner) => {
                    Error::InvalidNonceException(inner)
                }
                crate::error::AcknowledgeThirdPartyJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::AcknowledgeThirdPartyJobErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::AcknowledgeThirdPartyJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCustomActionTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCustomActionTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCustomActionTypeErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::CreateCustomActionTypeErrorKind::InvalidTagsException(inner) => {
                    Error::InvalidTagsException(inner)
                }
                crate::error::CreateCustomActionTypeErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateCustomActionTypeErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateCustomActionTypeErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateCustomActionTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreatePipelineError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePipelineErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::CreatePipelineErrorKind::InvalidActionDeclarationException(inner) => {
                    Error::InvalidActionDeclarationException(inner)
                }
                crate::error::CreatePipelineErrorKind::InvalidBlockerDeclarationException(
                    inner,
                ) => Error::InvalidBlockerDeclarationException(inner),
                crate::error::CreatePipelineErrorKind::InvalidStageDeclarationException(inner) => {
                    Error::InvalidStageDeclarationException(inner)
                }
                crate::error::CreatePipelineErrorKind::InvalidStructureException(inner) => {
                    Error::InvalidStructureException(inner)
                }
                crate::error::CreatePipelineErrorKind::InvalidTagsException(inner) => {
                    Error::InvalidTagsException(inner)
                }
                crate::error::CreatePipelineErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreatePipelineErrorKind::PipelineNameInUseException(inner) => {
                    Error::PipelineNameInUseException(inner)
                }
                crate::error::CreatePipelineErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreatePipelineErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreatePipelineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomActionTypeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCustomActionTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCustomActionTypeErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::DeleteCustomActionTypeErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteCustomActionTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeletePipelineError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePipelineErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeletePipelineErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeletePipelineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteWebhookError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteWebhookError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteWebhookErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteWebhookErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteWebhookErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeregisterWebhookWithThirdPartyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeregisterWebhookWithThirdPartyError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterWebhookWithThirdPartyErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DeregisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(inner) => Error::WebhookNotFoundException(inner),
                crate::error::DeregisterWebhookWithThirdPartyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableStageTransitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisableStageTransitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableStageTransitionErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::DisableStageTransitionErrorKind::StageNotFoundException(inner) => {
                    Error::StageNotFoundException(inner)
                }
                crate::error::DisableStageTransitionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DisableStageTransitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableStageTransitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::EnableStageTransitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableStageTransitionErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::EnableStageTransitionErrorKind::StageNotFoundException(inner) => {
                    Error::StageNotFoundException(inner)
                }
                crate::error::EnableStageTransitionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::EnableStageTransitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetActionTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetActionTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetActionTypeErrorKind::ActionTypeNotFoundException(inner) => {
                    Error::ActionTypeNotFoundException(inner)
                }
                crate::error::GetActionTypeErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetActionTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetJobDetailsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetJobDetailsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetJobDetailsErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::GetJobDetailsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetJobDetailsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPipelineError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPipelineErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::GetPipelineErrorKind::PipelineVersionNotFoundException(inner) => {
                    Error::PipelineVersionNotFoundException(inner)
                }
                crate::error::GetPipelineErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetPipelineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPipelineExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPipelineExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPipelineExecutionErrorKind::PipelineExecutionNotFoundException(
                    inner,
                ) => Error::PipelineExecutionNotFoundException(inner),
                crate::error::GetPipelineExecutionErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::GetPipelineExecutionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetPipelineExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPipelineStateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPipelineStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPipelineStateErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::GetPipelineStateErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetPipelineStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetThirdPartyJobDetailsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetThirdPartyJobDetailsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetThirdPartyJobDetailsErrorKind::InvalidClientTokenException(
                    inner,
                ) => Error::InvalidClientTokenException(inner),
                crate::error::GetThirdPartyJobDetailsErrorKind::InvalidJobException(inner) => {
                    Error::InvalidJobException(inner)
                }
                crate::error::GetThirdPartyJobDetailsErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::GetThirdPartyJobDetailsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetThirdPartyJobDetailsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListActionExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListActionExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListActionExecutionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListActionExecutionsErrorKind::PipelineExecutionNotFoundException(
                    inner,
                ) => Error::PipelineExecutionNotFoundException(inner),
                crate::error::ListActionExecutionsErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::ListActionExecutionsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListActionExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListActionTypesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListActionTypesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListActionTypesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListActionTypesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListActionTypesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPipelineExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListPipelineExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPipelineExecutionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListPipelineExecutionsErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::ListPipelineExecutionsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListPipelineExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPipelinesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListPipelinesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPipelinesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListPipelinesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListPipelinesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListWebhooksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListWebhooksError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListWebhooksErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListWebhooksErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListWebhooksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PollForJobsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PollForJobsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PollForJobsErrorKind::ActionTypeNotFoundException(inner) => {
                    Error::ActionTypeNotFoundException(inner)
                }
                crate::error::PollForJobsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::PollForJobsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PollForThirdPartyJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PollForThirdPartyJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PollForThirdPartyJobsErrorKind::ActionTypeNotFoundException(
                    inner,
                ) => Error::ActionTypeNotFoundException(inner),
                crate::error::PollForThirdPartyJobsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::PollForThirdPartyJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutActionRevisionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutActionRevisionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutActionRevisionErrorKind::ActionNotFoundException(inner) => {
                    Error::ActionNotFoundException(inner)
                }
                crate::error::PutActionRevisionErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::PutActionRevisionErrorKind::StageNotFoundException(inner) => {
                    Error::StageNotFoundException(inner)
                }
                crate::error::PutActionRevisionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::PutActionRevisionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutApprovalResultError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutApprovalResultError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutApprovalResultErrorKind::ActionNotFoundException(inner) => {
                    Error::ActionNotFoundException(inner)
                }
                crate::error::PutApprovalResultErrorKind::ApprovalAlreadyCompletedException(
                    inner,
                ) => Error::ApprovalAlreadyCompletedException(inner),
                crate::error::PutApprovalResultErrorKind::InvalidApprovalTokenException(inner) => {
                    Error::InvalidApprovalTokenException(inner)
                }
                crate::error::PutApprovalResultErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::PutApprovalResultErrorKind::StageNotFoundException(inner) => {
                    Error::StageNotFoundException(inner)
                }
                crate::error::PutApprovalResultErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::PutApprovalResultErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutJobFailureResultError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutJobFailureResultError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutJobFailureResultErrorKind::InvalidJobStateException(inner) => {
                    Error::InvalidJobStateException(inner)
                }
                crate::error::PutJobFailureResultErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::PutJobFailureResultErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::PutJobFailureResultErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutJobSuccessResultError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutJobSuccessResultError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutJobSuccessResultErrorKind::InvalidJobStateException(inner) => Error::InvalidJobStateException(inner),
                crate::error::PutJobSuccessResultErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::PutJobSuccessResultErrorKind::OutputVariablesSizeExceededException(inner) => Error::OutputVariablesSizeExceededException(inner),
                crate::error::PutJobSuccessResultErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutJobSuccessResultErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutThirdPartyJobFailureResultError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutThirdPartyJobFailureResultError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutThirdPartyJobFailureResultErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::PutThirdPartyJobFailureResultErrorKind::InvalidJobStateException(inner) => Error::InvalidJobStateException(inner),
                crate::error::PutThirdPartyJobFailureResultErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::PutThirdPartyJobFailureResultErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutThirdPartyJobFailureResultErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutThirdPartyJobSuccessResultError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutThirdPartyJobSuccessResultError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutThirdPartyJobSuccessResultErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::PutThirdPartyJobSuccessResultErrorKind::InvalidJobStateException(inner) => Error::InvalidJobStateException(inner),
                crate::error::PutThirdPartyJobSuccessResultErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::PutThirdPartyJobSuccessResultErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutThirdPartyJobSuccessResultErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutWebhookError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutWebhookError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutWebhookErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::PutWebhookErrorKind::InvalidTagsException(inner) => Error::InvalidTagsException(inner),
                crate::error::PutWebhookErrorKind::InvalidWebhookAuthenticationParametersException(inner) => Error::InvalidWebhookAuthenticationParametersException(inner),
                crate::error::PutWebhookErrorKind::InvalidWebhookFilterPatternException(inner) => Error::InvalidWebhookFilterPatternException(inner),
                crate::error::PutWebhookErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::PutWebhookErrorKind::PipelineNotFoundException(inner) => Error::PipelineNotFoundException(inner),
                crate::error::PutWebhookErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::PutWebhookErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutWebhookErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterWebhookWithThirdPartyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterWebhookWithThirdPartyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterWebhookWithThirdPartyErrorKind::ValidationException(
                    inner,
                ) => Error::ValidationException(inner),
                crate::error::RegisterWebhookWithThirdPartyErrorKind::WebhookNotFoundException(
                    inner,
                ) => Error::WebhookNotFoundException(inner),
                crate::error::RegisterWebhookWithThirdPartyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RetryStageExecutionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RetryStageExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RetryStageExecutionErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::RetryStageExecutionErrorKind::NotLatestPipelineExecutionException(
                    inner,
                ) => Error::NotLatestPipelineExecutionException(inner),
                crate::error::RetryStageExecutionErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::RetryStageExecutionErrorKind::StageNotFoundException(inner) => {
                    Error::StageNotFoundException(inner)
                }
                crate::error::RetryStageExecutionErrorKind::StageNotRetryableException(inner) => {
                    Error::StageNotRetryableException(inner)
                }
                crate::error::RetryStageExecutionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::RetryStageExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartPipelineExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartPipelineExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartPipelineExecutionErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::StartPipelineExecutionErrorKind::PipelineNotFoundException(inner) => {
                    Error::PipelineNotFoundException(inner)
                }
                crate::error::StartPipelineExecutionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::StartPipelineExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopPipelineExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopPipelineExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopPipelineExecutionErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::StopPipelineExecutionErrorKind::DuplicatedStopRequestException(inner) => Error::DuplicatedStopRequestException(inner),
                crate::error::StopPipelineExecutionErrorKind::PipelineExecutionNotStoppableException(inner) => Error::PipelineExecutionNotStoppableException(inner),
                crate::error::StopPipelineExecutionErrorKind::PipelineNotFoundException(inner) => Error::PipelineNotFoundException(inner),
                crate::error::StopPipelineExecutionErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::StopPipelineExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidTagsException(inner) => {
                    Error::InvalidTagsException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::TagResourceErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidTagsException(inner) => {
                    Error::InvalidTagsException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateActionTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateActionTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateActionTypeErrorKind::ActionTypeNotFoundException(inner) => {
                    Error::ActionTypeNotFoundException(inner)
                }
                crate::error::UpdateActionTypeErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::UpdateActionTypeErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UpdateActionTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdatePipelineError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdatePipelineErrorKind::InvalidActionDeclarationException(inner) => {
                    Error::InvalidActionDeclarationException(inner)
                }
                crate::error::UpdatePipelineErrorKind::InvalidBlockerDeclarationException(
                    inner,
                ) => Error::InvalidBlockerDeclarationException(inner),
                crate::error::UpdatePipelineErrorKind::InvalidStageDeclarationException(inner) => {
                    Error::InvalidStageDeclarationException(inner)
                }
                crate::error::UpdatePipelineErrorKind::InvalidStructureException(inner) => {
                    Error::InvalidStructureException(inner)
                }
                crate::error::UpdatePipelineErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdatePipelineErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UpdatePipelineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
