// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the output of an <code>UpdatePipeline</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePipelineOutput {
    /// <p>The structure of the updated pipeline.</p>
    pub pipeline: std::option::Option<crate::model::PipelineDeclaration>,
}
impl UpdatePipelineOutput {
    /// <p>The structure of the updated pipeline.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::PipelineDeclaration> {
        self.pipeline.as_ref()
    }
}
impl std::fmt::Debug for UpdatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePipelineOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.finish()
    }
}
/// See [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
pub mod update_pipeline_output {
    /// A builder for [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::PipelineDeclaration>,
    }
    impl Builder {
        /// <p>The structure of the updated pipeline.</p>
        pub fn pipeline(mut self, input: crate::model::PipelineDeclaration) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>The structure of the updated pipeline.</p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::PipelineDeclaration>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
        pub fn build(self) -> crate::output::UpdatePipelineOutput {
            crate::output::UpdatePipelineOutput {
                pipeline: self.pipeline,
            }
        }
    }
}
impl UpdatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
    pub fn builder() -> crate::output::update_pipeline_output::Builder {
        crate::output::update_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateActionTypeOutput {}
impl std::fmt::Debug for UpdateActionTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateActionTypeOutput");
        formatter.finish()
    }
}
/// See [`UpdateActionTypeOutput`](crate::output::UpdateActionTypeOutput)
pub mod update_action_type_output {
    /// A builder for [`UpdateActionTypeOutput`](crate::output::UpdateActionTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateActionTypeOutput`](crate::output::UpdateActionTypeOutput)
        pub fn build(self) -> crate::output::UpdateActionTypeOutput {
            crate::output::UpdateActionTypeOutput {}
        }
    }
}
impl UpdateActionTypeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateActionTypeOutput`](crate::output::UpdateActionTypeOutput)
    pub fn builder() -> crate::output::update_action_type_output::Builder {
        crate::output::update_action_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopPipelineExecutionOutput {
    /// <p>The unique system-generated ID of the pipeline execution that was stopped.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
}
impl StopPipelineExecutionOutput {
    /// <p>The unique system-generated ID of the pipeline execution that was stopped.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
}
impl std::fmt::Debug for StopPipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopPipelineExecutionOutput");
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.finish()
    }
}
/// See [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
pub mod stop_pipeline_execution_output {
    /// A builder for [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the pipeline execution that was stopped.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the pipeline execution that was stopped.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
        pub fn build(self) -> crate::output::StopPipelineExecutionOutput {
            crate::output::StopPipelineExecutionOutput {
                pipeline_execution_id: self.pipeline_execution_id,
            }
        }
    }
}
impl StopPipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
    pub fn builder() -> crate::output::stop_pipeline_execution_output::Builder {
        crate::output::stop_pipeline_execution_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>StartPipelineExecution</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartPipelineExecutionOutput {
    /// <p>The unique system-generated ID of the pipeline execution that was
    /// started.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
}
impl StartPipelineExecutionOutput {
    /// <p>The unique system-generated ID of the pipeline execution that was
    /// started.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
}
impl std::fmt::Debug for StartPipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartPipelineExecutionOutput");
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.finish()
    }
}
/// See [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
pub mod start_pipeline_execution_output {
    /// A builder for [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique system-generated ID of the pipeline execution that was
        /// started.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The unique system-generated ID of the pipeline execution that was
        /// started.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
        pub fn build(self) -> crate::output::StartPipelineExecutionOutput {
            crate::output::StartPipelineExecutionOutput {
                pipeline_execution_id: self.pipeline_execution_id,
            }
        }
    }
}
impl StartPipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
    pub fn builder() -> crate::output::start_pipeline_execution_output::Builder {
        crate::output::start_pipeline_execution_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>RetryStageExecution</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryStageExecutionOutput {
    /// <p>The ID of the current workflow execution in the failed stage.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
}
impl RetryStageExecutionOutput {
    /// <p>The ID of the current workflow execution in the failed stage.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
}
impl std::fmt::Debug for RetryStageExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryStageExecutionOutput");
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.finish()
    }
}
/// See [`RetryStageExecutionOutput`](crate::output::RetryStageExecutionOutput)
pub mod retry_stage_execution_output {
    /// A builder for [`RetryStageExecutionOutput`](crate::output::RetryStageExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the current workflow execution in the failed stage.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the current workflow execution in the failed stage.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryStageExecutionOutput`](crate::output::RetryStageExecutionOutput)
        pub fn build(self) -> crate::output::RetryStageExecutionOutput {
            crate::output::RetryStageExecutionOutput {
                pipeline_execution_id: self.pipeline_execution_id,
            }
        }
    }
}
impl RetryStageExecutionOutput {
    /// Creates a new builder-style object to manufacture [`RetryStageExecutionOutput`](crate::output::RetryStageExecutionOutput)
    pub fn builder() -> crate::output::retry_stage_execution_output::Builder {
        crate::output::retry_stage_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterWebhookWithThirdPartyOutput {}
impl std::fmt::Debug for RegisterWebhookWithThirdPartyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterWebhookWithThirdPartyOutput");
        formatter.finish()
    }
}
/// See [`RegisterWebhookWithThirdPartyOutput`](crate::output::RegisterWebhookWithThirdPartyOutput)
pub mod register_webhook_with_third_party_output {
    /// A builder for [`RegisterWebhookWithThirdPartyOutput`](crate::output::RegisterWebhookWithThirdPartyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterWebhookWithThirdPartyOutput`](crate::output::RegisterWebhookWithThirdPartyOutput)
        pub fn build(self) -> crate::output::RegisterWebhookWithThirdPartyOutput {
            crate::output::RegisterWebhookWithThirdPartyOutput {}
        }
    }
}
impl RegisterWebhookWithThirdPartyOutput {
    /// Creates a new builder-style object to manufacture [`RegisterWebhookWithThirdPartyOutput`](crate::output::RegisterWebhookWithThirdPartyOutput)
    pub fn builder() -> crate::output::register_webhook_with_third_party_output::Builder {
        crate::output::register_webhook_with_third_party_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutWebhookOutput {
    /// <p>The detail returned from creating the webhook, such as the webhook name, webhook
    /// URL, and webhook ARN.</p>
    pub webhook: std::option::Option<crate::model::ListWebhookItem>,
}
impl PutWebhookOutput {
    /// <p>The detail returned from creating the webhook, such as the webhook name, webhook
    /// URL, and webhook ARN.</p>
    pub fn webhook(&self) -> std::option::Option<&crate::model::ListWebhookItem> {
        self.webhook.as_ref()
    }
}
impl std::fmt::Debug for PutWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutWebhookOutput");
        formatter.field("webhook", &self.webhook);
        formatter.finish()
    }
}
/// See [`PutWebhookOutput`](crate::output::PutWebhookOutput)
pub mod put_webhook_output {
    /// A builder for [`PutWebhookOutput`](crate::output::PutWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::ListWebhookItem>,
    }
    impl Builder {
        /// <p>The detail returned from creating the webhook, such as the webhook name, webhook
        /// URL, and webhook ARN.</p>
        pub fn webhook(mut self, input: crate::model::ListWebhookItem) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p>The detail returned from creating the webhook, such as the webhook name, webhook
        /// URL, and webhook ARN.</p>
        pub fn set_webhook(
            mut self,
            input: std::option::Option<crate::model::ListWebhookItem>,
        ) -> Self {
            self.webhook = input;
            self
        }
        /// Consumes the builder and constructs a [`PutWebhookOutput`](crate::output::PutWebhookOutput)
        pub fn build(self) -> crate::output::PutWebhookOutput {
            crate::output::PutWebhookOutput {
                webhook: self.webhook,
            }
        }
    }
}
impl PutWebhookOutput {
    /// Creates a new builder-style object to manufacture [`PutWebhookOutput`](crate::output::PutWebhookOutput)
    pub fn builder() -> crate::output::put_webhook_output::Builder {
        crate::output::put_webhook_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutThirdPartyJobSuccessResultOutput {}
impl std::fmt::Debug for PutThirdPartyJobSuccessResultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutThirdPartyJobSuccessResultOutput");
        formatter.finish()
    }
}
/// See [`PutThirdPartyJobSuccessResultOutput`](crate::output::PutThirdPartyJobSuccessResultOutput)
pub mod put_third_party_job_success_result_output {
    /// A builder for [`PutThirdPartyJobSuccessResultOutput`](crate::output::PutThirdPartyJobSuccessResultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutThirdPartyJobSuccessResultOutput`](crate::output::PutThirdPartyJobSuccessResultOutput)
        pub fn build(self) -> crate::output::PutThirdPartyJobSuccessResultOutput {
            crate::output::PutThirdPartyJobSuccessResultOutput {}
        }
    }
}
impl PutThirdPartyJobSuccessResultOutput {
    /// Creates a new builder-style object to manufacture [`PutThirdPartyJobSuccessResultOutput`](crate::output::PutThirdPartyJobSuccessResultOutput)
    pub fn builder() -> crate::output::put_third_party_job_success_result_output::Builder {
        crate::output::put_third_party_job_success_result_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutThirdPartyJobFailureResultOutput {}
impl std::fmt::Debug for PutThirdPartyJobFailureResultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutThirdPartyJobFailureResultOutput");
        formatter.finish()
    }
}
/// See [`PutThirdPartyJobFailureResultOutput`](crate::output::PutThirdPartyJobFailureResultOutput)
pub mod put_third_party_job_failure_result_output {
    /// A builder for [`PutThirdPartyJobFailureResultOutput`](crate::output::PutThirdPartyJobFailureResultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutThirdPartyJobFailureResultOutput`](crate::output::PutThirdPartyJobFailureResultOutput)
        pub fn build(self) -> crate::output::PutThirdPartyJobFailureResultOutput {
            crate::output::PutThirdPartyJobFailureResultOutput {}
        }
    }
}
impl PutThirdPartyJobFailureResultOutput {
    /// Creates a new builder-style object to manufacture [`PutThirdPartyJobFailureResultOutput`](crate::output::PutThirdPartyJobFailureResultOutput)
    pub fn builder() -> crate::output::put_third_party_job_failure_result_output::Builder {
        crate::output::put_third_party_job_failure_result_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutJobSuccessResultOutput {}
impl std::fmt::Debug for PutJobSuccessResultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutJobSuccessResultOutput");
        formatter.finish()
    }
}
/// See [`PutJobSuccessResultOutput`](crate::output::PutJobSuccessResultOutput)
pub mod put_job_success_result_output {
    /// A builder for [`PutJobSuccessResultOutput`](crate::output::PutJobSuccessResultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutJobSuccessResultOutput`](crate::output::PutJobSuccessResultOutput)
        pub fn build(self) -> crate::output::PutJobSuccessResultOutput {
            crate::output::PutJobSuccessResultOutput {}
        }
    }
}
impl PutJobSuccessResultOutput {
    /// Creates a new builder-style object to manufacture [`PutJobSuccessResultOutput`](crate::output::PutJobSuccessResultOutput)
    pub fn builder() -> crate::output::put_job_success_result_output::Builder {
        crate::output::put_job_success_result_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutJobFailureResultOutput {}
impl std::fmt::Debug for PutJobFailureResultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutJobFailureResultOutput");
        formatter.finish()
    }
}
/// See [`PutJobFailureResultOutput`](crate::output::PutJobFailureResultOutput)
pub mod put_job_failure_result_output {
    /// A builder for [`PutJobFailureResultOutput`](crate::output::PutJobFailureResultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutJobFailureResultOutput`](crate::output::PutJobFailureResultOutput)
        pub fn build(self) -> crate::output::PutJobFailureResultOutput {
            crate::output::PutJobFailureResultOutput {}
        }
    }
}
impl PutJobFailureResultOutput {
    /// Creates a new builder-style object to manufacture [`PutJobFailureResultOutput`](crate::output::PutJobFailureResultOutput)
    pub fn builder() -> crate::output::put_job_failure_result_output::Builder {
        crate::output::put_job_failure_result_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>PutApprovalResult</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutApprovalResultOutput {
    /// <p>The timestamp showing when the approval or rejection was submitted.</p>
    pub approved_at: std::option::Option<aws_smithy_types::Instant>,
}
impl PutApprovalResultOutput {
    /// <p>The timestamp showing when the approval or rejection was submitted.</p>
    pub fn approved_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.approved_at.as_ref()
    }
}
impl std::fmt::Debug for PutApprovalResultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutApprovalResultOutput");
        formatter.field("approved_at", &self.approved_at);
        formatter.finish()
    }
}
/// See [`PutApprovalResultOutput`](crate::output::PutApprovalResultOutput)
pub mod put_approval_result_output {
    /// A builder for [`PutApprovalResultOutput`](crate::output::PutApprovalResultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approved_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The timestamp showing when the approval or rejection was submitted.</p>
        pub fn approved_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.approved_at = Some(input);
            self
        }
        /// <p>The timestamp showing when the approval or rejection was submitted.</p>
        pub fn set_approved_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.approved_at = input;
            self
        }
        /// Consumes the builder and constructs a [`PutApprovalResultOutput`](crate::output::PutApprovalResultOutput)
        pub fn build(self) -> crate::output::PutApprovalResultOutput {
            crate::output::PutApprovalResultOutput {
                approved_at: self.approved_at,
            }
        }
    }
}
impl PutApprovalResultOutput {
    /// Creates a new builder-style object to manufacture [`PutApprovalResultOutput`](crate::output::PutApprovalResultOutput)
    pub fn builder() -> crate::output::put_approval_result_output::Builder {
        crate::output::put_approval_result_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>PutActionRevision</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutActionRevisionOutput {
    /// <p>Indicates whether the artifact revision was previously used in an execution of the
    /// specified pipeline.</p>
    pub new_revision: bool,
    /// <p>The ID of the current workflow state of the pipeline.</p>
    pub pipeline_execution_id: std::option::Option<std::string::String>,
}
impl PutActionRevisionOutput {
    /// <p>Indicates whether the artifact revision was previously used in an execution of the
    /// specified pipeline.</p>
    pub fn new_revision(&self) -> bool {
        self.new_revision
    }
    /// <p>The ID of the current workflow state of the pipeline.</p>
    pub fn pipeline_execution_id(&self) -> std::option::Option<&str> {
        self.pipeline_execution_id.as_deref()
    }
}
impl std::fmt::Debug for PutActionRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutActionRevisionOutput");
        formatter.field("new_revision", &self.new_revision);
        formatter.field("pipeline_execution_id", &self.pipeline_execution_id);
        formatter.finish()
    }
}
/// See [`PutActionRevisionOutput`](crate::output::PutActionRevisionOutput)
pub mod put_action_revision_output {
    /// A builder for [`PutActionRevisionOutput`](crate::output::PutActionRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) new_revision: std::option::Option<bool>,
        pub(crate) pipeline_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the artifact revision was previously used in an execution of the
        /// specified pipeline.</p>
        pub fn new_revision(mut self, input: bool) -> Self {
            self.new_revision = Some(input);
            self
        }
        /// <p>Indicates whether the artifact revision was previously used in an execution of the
        /// specified pipeline.</p>
        pub fn set_new_revision(mut self, input: std::option::Option<bool>) -> Self {
            self.new_revision = input;
            self
        }
        /// <p>The ID of the current workflow state of the pipeline.</p>
        pub fn pipeline_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the current workflow state of the pipeline.</p>
        pub fn set_pipeline_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutActionRevisionOutput`](crate::output::PutActionRevisionOutput)
        pub fn build(self) -> crate::output::PutActionRevisionOutput {
            crate::output::PutActionRevisionOutput {
                new_revision: self.new_revision.unwrap_or_default(),
                pipeline_execution_id: self.pipeline_execution_id,
            }
        }
    }
}
impl PutActionRevisionOutput {
    /// Creates a new builder-style object to manufacture [`PutActionRevisionOutput`](crate::output::PutActionRevisionOutput)
    pub fn builder() -> crate::output::put_action_revision_output::Builder {
        crate::output::put_action_revision_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>PollForThirdPartyJobs</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PollForThirdPartyJobsOutput {
    /// <p>Information about the jobs to take action on.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::ThirdPartyJob>>,
}
impl PollForThirdPartyJobsOutput {
    /// <p>Information about the jobs to take action on.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::ThirdPartyJob]> {
        self.jobs.as_deref()
    }
}
impl std::fmt::Debug for PollForThirdPartyJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PollForThirdPartyJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.finish()
    }
}
/// See [`PollForThirdPartyJobsOutput`](crate::output::PollForThirdPartyJobsOutput)
pub mod poll_for_third_party_jobs_output {
    /// A builder for [`PollForThirdPartyJobsOutput`](crate::output::PollForThirdPartyJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::ThirdPartyJob>>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>Information about the jobs to take action on.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::ThirdPartyJob>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>Information about the jobs to take action on.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThirdPartyJob>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Consumes the builder and constructs a [`PollForThirdPartyJobsOutput`](crate::output::PollForThirdPartyJobsOutput)
        pub fn build(self) -> crate::output::PollForThirdPartyJobsOutput {
            crate::output::PollForThirdPartyJobsOutput { jobs: self.jobs }
        }
    }
}
impl PollForThirdPartyJobsOutput {
    /// Creates a new builder-style object to manufacture [`PollForThirdPartyJobsOutput`](crate::output::PollForThirdPartyJobsOutput)
    pub fn builder() -> crate::output::poll_for_third_party_jobs_output::Builder {
        crate::output::poll_for_third_party_jobs_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>PollForJobs</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PollForJobsOutput {
    /// <p>Information about the jobs to take action on.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
}
impl PollForJobsOutput {
    /// <p>Information about the jobs to take action on.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::Job]> {
        self.jobs.as_deref()
    }
}
impl std::fmt::Debug for PollForJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PollForJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.finish()
    }
}
/// See [`PollForJobsOutput`](crate::output::PollForJobsOutput)
pub mod poll_for_jobs_output {
    /// A builder for [`PollForJobsOutput`](crate::output::PollForJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>Information about the jobs to take action on.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>Information about the jobs to take action on.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Consumes the builder and constructs a [`PollForJobsOutput`](crate::output::PollForJobsOutput)
        pub fn build(self) -> crate::output::PollForJobsOutput {
            crate::output::PollForJobsOutput { jobs: self.jobs }
        }
    }
}
impl PollForJobsOutput {
    /// Creates a new builder-style object to manufacture [`PollForJobsOutput`](crate::output::PollForJobsOutput)
    pub fn builder() -> crate::output::poll_for_jobs_output::Builder {
        crate::output::poll_for_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWebhooksOutput {
    /// <p>The JSON detail returned for each webhook in the list output for the ListWebhooks
    /// call.</p>
    pub webhooks: std::option::Option<std::vec::Vec<crate::model::ListWebhookItem>>,
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned and can be used in a subsequent ListWebhooks call to return the next set of
    /// webhooks in the list. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWebhooksOutput {
    /// <p>The JSON detail returned for each webhook in the list output for the ListWebhooks
    /// call.</p>
    pub fn webhooks(&self) -> std::option::Option<&[crate::model::ListWebhookItem]> {
        self.webhooks.as_deref()
    }
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned and can be used in a subsequent ListWebhooks call to return the next set of
    /// webhooks in the list. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWebhooksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWebhooksOutput");
        formatter.field("webhooks", &self.webhooks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
pub mod list_webhooks_output {
    /// A builder for [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhooks: std::option::Option<std::vec::Vec<crate::model::ListWebhookItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `webhooks`.
        ///
        /// To override the contents of this collection use [`set_webhooks`](Self::set_webhooks).
        ///
        /// <p>The JSON detail returned for each webhook in the list output for the ListWebhooks
        /// call.</p>
        pub fn webhooks(mut self, input: impl Into<crate::model::ListWebhookItem>) -> Self {
            let mut v = self.webhooks.unwrap_or_default();
            v.push(input.into());
            self.webhooks = Some(v);
            self
        }
        /// <p>The JSON detail returned for each webhook in the list output for the ListWebhooks
        /// call.</p>
        pub fn set_webhooks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListWebhookItem>>,
        ) -> Self {
            self.webhooks = input;
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned and can be used in a subsequent ListWebhooks call to return the next set of
        /// webhooks in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned and can be used in a subsequent ListWebhooks call to return the next set of
        /// webhooks in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
        pub fn build(self) -> crate::output::ListWebhooksOutput {
            crate::output::ListWebhooksOutput {
                webhooks: self.webhooks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWebhooksOutput {
    /// Creates a new builder-style object to manufacture [`ListWebhooksOutput`](crate::output::ListWebhooksOutput)
    pub fn builder() -> crate::output::list_webhooks_output::Builder {
        crate::output::list_webhooks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned and can be used in a subsequent API call to return the next page of the list.
    /// The ListTagsforResource call lists all available tags in one call and does not use
    /// pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned and can be used in a subsequent API call to return the next page of the list.
    /// The ListTagsforResource call lists all available tags in one call and does not use
    /// pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned and can be used in a subsequent API call to return the next page of the list.
        /// The ListTagsforResource call lists all available tags in one call and does not use
        /// pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned and can be used in a subsequent API call to return the next page of the list.
        /// The ListTagsforResource call lists all available tags in one call and does not use
        /// pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListPipelines</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelinesOutput {
    /// <p>The list of pipelines.</p>
    pub pipelines: std::option::Option<std::vec::Vec<crate::model::PipelineSummary>>,
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned. It can be used in a subsequent list pipelines call to return the next set of
    /// pipelines in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPipelinesOutput {
    /// <p>The list of pipelines.</p>
    pub fn pipelines(&self) -> std::option::Option<&[crate::model::PipelineSummary]> {
        self.pipelines.as_deref()
    }
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned. It can be used in a subsequent list pipelines call to return the next set of
    /// pipelines in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelinesOutput");
        formatter.field("pipelines", &self.pipelines);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
pub mod list_pipelines_output {
    /// A builder for [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipelines: std::option::Option<std::vec::Vec<crate::model::PipelineSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pipelines`.
        ///
        /// To override the contents of this collection use [`set_pipelines`](Self::set_pipelines).
        ///
        /// <p>The list of pipelines.</p>
        pub fn pipelines(mut self, input: impl Into<crate::model::PipelineSummary>) -> Self {
            let mut v = self.pipelines.unwrap_or_default();
            v.push(input.into());
            self.pipelines = Some(v);
            self
        }
        /// <p>The list of pipelines.</p>
        pub fn set_pipelines(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineSummary>>,
        ) -> Self {
            self.pipelines = input;
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned. It can be used in a subsequent list pipelines call to return the next set of
        /// pipelines in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned. It can be used in a subsequent list pipelines call to return the next set of
        /// pipelines in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
        pub fn build(self) -> crate::output::ListPipelinesOutput {
            crate::output::ListPipelinesOutput {
                pipelines: self.pipelines,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPipelinesOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    pub fn builder() -> crate::output::list_pipelines_output::Builder {
        crate::output::list_pipelines_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListPipelineExecutions</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelineExecutionsOutput {
    /// <p>A list of executions in the history of a pipeline.</p>
    pub pipeline_execution_summaries:
        std::option::Option<std::vec::Vec<crate::model::PipelineExecutionSummary>>,
    /// <p>A token that can be used in the next <code>ListPipelineExecutions</code> call. To
    /// view all items in the list, continue to call this operation with each subsequent token
    /// until no more nextToken values are returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPipelineExecutionsOutput {
    /// <p>A list of executions in the history of a pipeline.</p>
    pub fn pipeline_execution_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::PipelineExecutionSummary]> {
        self.pipeline_execution_summaries.as_deref()
    }
    /// <p>A token that can be used in the next <code>ListPipelineExecutions</code> call. To
    /// view all items in the list, continue to call this operation with each subsequent token
    /// until no more nextToken values are returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelineExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelineExecutionsOutput");
        formatter.field(
            "pipeline_execution_summaries",
            &self.pipeline_execution_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
pub mod list_pipeline_executions_output {
    /// A builder for [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_summaries:
            std::option::Option<std::vec::Vec<crate::model::PipelineExecutionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pipeline_execution_summaries`.
        ///
        /// To override the contents of this collection use [`set_pipeline_execution_summaries`](Self::set_pipeline_execution_summaries).
        ///
        /// <p>A list of executions in the history of a pipeline.</p>
        pub fn pipeline_execution_summaries(
            mut self,
            input: impl Into<crate::model::PipelineExecutionSummary>,
        ) -> Self {
            let mut v = self.pipeline_execution_summaries.unwrap_or_default();
            v.push(input.into());
            self.pipeline_execution_summaries = Some(v);
            self
        }
        /// <p>A list of executions in the history of a pipeline.</p>
        pub fn set_pipeline_execution_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineExecutionSummary>>,
        ) -> Self {
            self.pipeline_execution_summaries = input;
            self
        }
        /// <p>A token that can be used in the next <code>ListPipelineExecutions</code> call. To
        /// view all items in the list, continue to call this operation with each subsequent token
        /// until no more nextToken values are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used in the next <code>ListPipelineExecutions</code> call. To
        /// view all items in the list, continue to call this operation with each subsequent token
        /// until no more nextToken values are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
        pub fn build(self) -> crate::output::ListPipelineExecutionsOutput {
            crate::output::ListPipelineExecutionsOutput {
                pipeline_execution_summaries: self.pipeline_execution_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPipelineExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
    pub fn builder() -> crate::output::list_pipeline_executions_output::Builder {
        crate::output::list_pipeline_executions_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListActionTypes</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActionTypesOutput {
    /// <p>Provides details of the action types.</p>
    pub action_types: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned. It can be used in a subsequent list action types call to return the next set
    /// of action types in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListActionTypesOutput {
    /// <p>Provides details of the action types.</p>
    pub fn action_types(&self) -> std::option::Option<&[crate::model::ActionType]> {
        self.action_types.as_deref()
    }
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned. It can be used in a subsequent list action types call to return the next set
    /// of action types in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListActionTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActionTypesOutput");
        formatter.field("action_types", &self.action_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListActionTypesOutput`](crate::output::ListActionTypesOutput)
pub mod list_action_types_output {
    /// A builder for [`ListActionTypesOutput`](crate::output::ListActionTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_types: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `action_types`.
        ///
        /// To override the contents of this collection use [`set_action_types`](Self::set_action_types).
        ///
        /// <p>Provides details of the action types.</p>
        pub fn action_types(mut self, input: impl Into<crate::model::ActionType>) -> Self {
            let mut v = self.action_types.unwrap_or_default();
            v.push(input.into());
            self.action_types = Some(v);
            self
        }
        /// <p>Provides details of the action types.</p>
        pub fn set_action_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
        ) -> Self {
            self.action_types = input;
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned. It can be used in a subsequent list action types call to return the next set
        /// of action types in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned. It can be used in a subsequent list action types call to return the next set
        /// of action types in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActionTypesOutput`](crate::output::ListActionTypesOutput)
        pub fn build(self) -> crate::output::ListActionTypesOutput {
            crate::output::ListActionTypesOutput {
                action_types: self.action_types,
                next_token: self.next_token,
            }
        }
    }
}
impl ListActionTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListActionTypesOutput`](crate::output::ListActionTypesOutput)
    pub fn builder() -> crate::output::list_action_types_output::Builder {
        crate::output::list_action_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActionExecutionsOutput {
    /// <p>The details for a list of recent executions, such as action execution ID.</p>
    pub action_execution_details:
        std::option::Option<std::vec::Vec<crate::model::ActionExecutionDetail>>,
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned and can be used in a subsequent <code>ListActionExecutions</code> call to
    /// return the next set of action executions in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListActionExecutionsOutput {
    /// <p>The details for a list of recent executions, such as action execution ID.</p>
    pub fn action_execution_details(
        &self,
    ) -> std::option::Option<&[crate::model::ActionExecutionDetail]> {
        self.action_execution_details.as_deref()
    }
    /// <p>If the amount of returned information is significantly large, an identifier is also
    /// returned and can be used in a subsequent <code>ListActionExecutions</code> call to
    /// return the next set of action executions in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListActionExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActionExecutionsOutput");
        formatter.field("action_execution_details", &self.action_execution_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListActionExecutionsOutput`](crate::output::ListActionExecutionsOutput)
pub mod list_action_executions_output {
    /// A builder for [`ListActionExecutionsOutput`](crate::output::ListActionExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_execution_details:
            std::option::Option<std::vec::Vec<crate::model::ActionExecutionDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `action_execution_details`.
        ///
        /// To override the contents of this collection use [`set_action_execution_details`](Self::set_action_execution_details).
        ///
        /// <p>The details for a list of recent executions, such as action execution ID.</p>
        pub fn action_execution_details(
            mut self,
            input: impl Into<crate::model::ActionExecutionDetail>,
        ) -> Self {
            let mut v = self.action_execution_details.unwrap_or_default();
            v.push(input.into());
            self.action_execution_details = Some(v);
            self
        }
        /// <p>The details for a list of recent executions, such as action execution ID.</p>
        pub fn set_action_execution_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionExecutionDetail>>,
        ) -> Self {
            self.action_execution_details = input;
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned and can be used in a subsequent <code>ListActionExecutions</code> call to
        /// return the next set of action executions in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the amount of returned information is significantly large, an identifier is also
        /// returned and can be used in a subsequent <code>ListActionExecutions</code> call to
        /// return the next set of action executions in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActionExecutionsOutput`](crate::output::ListActionExecutionsOutput)
        pub fn build(self) -> crate::output::ListActionExecutionsOutput {
            crate::output::ListActionExecutionsOutput {
                action_execution_details: self.action_execution_details,
                next_token: self.next_token,
            }
        }
    }
}
impl ListActionExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListActionExecutionsOutput`](crate::output::ListActionExecutionsOutput)
    pub fn builder() -> crate::output::list_action_executions_output::Builder {
        crate::output::list_action_executions_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetThirdPartyJobDetails</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetThirdPartyJobDetailsOutput {
    /// <p>The details of the job, including any protected values defined for the
    /// job.</p>
    pub job_details: std::option::Option<crate::model::ThirdPartyJobDetails>,
}
impl GetThirdPartyJobDetailsOutput {
    /// <p>The details of the job, including any protected values defined for the
    /// job.</p>
    pub fn job_details(&self) -> std::option::Option<&crate::model::ThirdPartyJobDetails> {
        self.job_details.as_ref()
    }
}
impl std::fmt::Debug for GetThirdPartyJobDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetThirdPartyJobDetailsOutput");
        formatter.field("job_details", &self.job_details);
        formatter.finish()
    }
}
/// See [`GetThirdPartyJobDetailsOutput`](crate::output::GetThirdPartyJobDetailsOutput)
pub mod get_third_party_job_details_output {
    /// A builder for [`GetThirdPartyJobDetailsOutput`](crate::output::GetThirdPartyJobDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_details: std::option::Option<crate::model::ThirdPartyJobDetails>,
    }
    impl Builder {
        /// <p>The details of the job, including any protected values defined for the
        /// job.</p>
        pub fn job_details(mut self, input: crate::model::ThirdPartyJobDetails) -> Self {
            self.job_details = Some(input);
            self
        }
        /// <p>The details of the job, including any protected values defined for the
        /// job.</p>
        pub fn set_job_details(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyJobDetails>,
        ) -> Self {
            self.job_details = input;
            self
        }
        /// Consumes the builder and constructs a [`GetThirdPartyJobDetailsOutput`](crate::output::GetThirdPartyJobDetailsOutput)
        pub fn build(self) -> crate::output::GetThirdPartyJobDetailsOutput {
            crate::output::GetThirdPartyJobDetailsOutput {
                job_details: self.job_details,
            }
        }
    }
}
impl GetThirdPartyJobDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GetThirdPartyJobDetailsOutput`](crate::output::GetThirdPartyJobDetailsOutput)
    pub fn builder() -> crate::output::get_third_party_job_details_output::Builder {
        crate::output::get_third_party_job_details_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetPipelineState</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPipelineStateOutput {
    /// <p>The name of the pipeline for which you want to get the state.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The version number of the pipeline.</p>
    /// <note>
    /// <p>A newly created pipeline is always assigned a version number of
    /// <code>1</code>.</p>
    /// </note>
    pub pipeline_version: std::option::Option<i32>,
    /// <p>A list of the pipeline stage output information, including stage name, state, most
    /// recent run details, whether the stage is disabled, and other data.</p>
    pub stage_states: std::option::Option<std::vec::Vec<crate::model::StageState>>,
    /// <p>The date and time the pipeline was created, in timestamp format.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
    pub updated: std::option::Option<aws_smithy_types::Instant>,
}
impl GetPipelineStateOutput {
    /// <p>The name of the pipeline for which you want to get the state.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The version number of the pipeline.</p>
    /// <note>
    /// <p>A newly created pipeline is always assigned a version number of
    /// <code>1</code>.</p>
    /// </note>
    pub fn pipeline_version(&self) -> std::option::Option<i32> {
        self.pipeline_version
    }
    /// <p>A list of the pipeline stage output information, including stage name, state, most
    /// recent run details, whether the stage is disabled, and other data.</p>
    pub fn stage_states(&self) -> std::option::Option<&[crate::model::StageState]> {
        self.stage_states.as_deref()
    }
    /// <p>The date and time the pipeline was created, in timestamp format.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
    pub fn updated(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated.as_ref()
    }
}
impl std::fmt::Debug for GetPipelineStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPipelineStateOutput");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("pipeline_version", &self.pipeline_version);
        formatter.field("stage_states", &self.stage_states);
        formatter.field("created", &self.created);
        formatter.field("updated", &self.updated);
        formatter.finish()
    }
}
/// See [`GetPipelineStateOutput`](crate::output::GetPipelineStateOutput)
pub mod get_pipeline_state_output {
    /// A builder for [`GetPipelineStateOutput`](crate::output::GetPipelineStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_version: std::option::Option<i32>,
        pub(crate) stage_states: std::option::Option<std::vec::Vec<crate::model::StageState>>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the pipeline for which you want to get the state.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline for which you want to get the state.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The version number of the pipeline.</p>
        /// <note>
        /// <p>A newly created pipeline is always assigned a version number of
        /// <code>1</code>.</p>
        /// </note>
        pub fn pipeline_version(mut self, input: i32) -> Self {
            self.pipeline_version = Some(input);
            self
        }
        /// <p>The version number of the pipeline.</p>
        /// <note>
        /// <p>A newly created pipeline is always assigned a version number of
        /// <code>1</code>.</p>
        /// </note>
        pub fn set_pipeline_version(mut self, input: std::option::Option<i32>) -> Self {
            self.pipeline_version = input;
            self
        }
        /// Appends an item to `stage_states`.
        ///
        /// To override the contents of this collection use [`set_stage_states`](Self::set_stage_states).
        ///
        /// <p>A list of the pipeline stage output information, including stage name, state, most
        /// recent run details, whether the stage is disabled, and other data.</p>
        pub fn stage_states(mut self, input: impl Into<crate::model::StageState>) -> Self {
            let mut v = self.stage_states.unwrap_or_default();
            v.push(input.into());
            self.stage_states = Some(v);
            self
        }
        /// <p>A list of the pipeline stage output information, including stage name, state, most
        /// recent run details, whether the stage is disabled, and other data.</p>
        pub fn set_stage_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StageState>>,
        ) -> Self {
            self.stage_states = input;
            self
        }
        /// <p>The date and time the pipeline was created, in timestamp format.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time the pipeline was created, in timestamp format.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
        pub fn updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated = Some(input);
            self
        }
        /// <p>The date and time the pipeline was last updated, in timestamp format.</p>
        pub fn set_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPipelineStateOutput`](crate::output::GetPipelineStateOutput)
        pub fn build(self) -> crate::output::GetPipelineStateOutput {
            crate::output::GetPipelineStateOutput {
                pipeline_name: self.pipeline_name,
                pipeline_version: self.pipeline_version,
                stage_states: self.stage_states,
                created: self.created,
                updated: self.updated,
            }
        }
    }
}
impl GetPipelineStateOutput {
    /// Creates a new builder-style object to manufacture [`GetPipelineStateOutput`](crate::output::GetPipelineStateOutput)
    pub fn builder() -> crate::output::get_pipeline_state_output::Builder {
        crate::output::get_pipeline_state_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetPipelineExecution</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPipelineExecutionOutput {
    /// <p>Represents information about the execution of a pipeline.</p>
    pub pipeline_execution: std::option::Option<crate::model::PipelineExecution>,
}
impl GetPipelineExecutionOutput {
    /// <p>Represents information about the execution of a pipeline.</p>
    pub fn pipeline_execution(&self) -> std::option::Option<&crate::model::PipelineExecution> {
        self.pipeline_execution.as_ref()
    }
}
impl std::fmt::Debug for GetPipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPipelineExecutionOutput");
        formatter.field("pipeline_execution", &self.pipeline_execution);
        formatter.finish()
    }
}
/// See [`GetPipelineExecutionOutput`](crate::output::GetPipelineExecutionOutput)
pub mod get_pipeline_execution_output {
    /// A builder for [`GetPipelineExecutionOutput`](crate::output::GetPipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution: std::option::Option<crate::model::PipelineExecution>,
    }
    impl Builder {
        /// <p>Represents information about the execution of a pipeline.</p>
        pub fn pipeline_execution(mut self, input: crate::model::PipelineExecution) -> Self {
            self.pipeline_execution = Some(input);
            self
        }
        /// <p>Represents information about the execution of a pipeline.</p>
        pub fn set_pipeline_execution(
            mut self,
            input: std::option::Option<crate::model::PipelineExecution>,
        ) -> Self {
            self.pipeline_execution = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPipelineExecutionOutput`](crate::output::GetPipelineExecutionOutput)
        pub fn build(self) -> crate::output::GetPipelineExecutionOutput {
            crate::output::GetPipelineExecutionOutput {
                pipeline_execution: self.pipeline_execution,
            }
        }
    }
}
impl GetPipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`GetPipelineExecutionOutput`](crate::output::GetPipelineExecutionOutput)
    pub fn builder() -> crate::output::get_pipeline_execution_output::Builder {
        crate::output::get_pipeline_execution_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetPipeline</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPipelineOutput {
    /// <p>Represents the structure of actions and stages to be performed in the pipeline.
    /// </p>
    pub pipeline: std::option::Option<crate::model::PipelineDeclaration>,
    /// <p>Represents the pipeline metadata information returned as part of the output of a
    /// <code>GetPipeline</code> action.</p>
    pub metadata: std::option::Option<crate::model::PipelineMetadata>,
}
impl GetPipelineOutput {
    /// <p>Represents the structure of actions and stages to be performed in the pipeline.
    /// </p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::PipelineDeclaration> {
        self.pipeline.as_ref()
    }
    /// <p>Represents the pipeline metadata information returned as part of the output of a
    /// <code>GetPipeline</code> action.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::PipelineMetadata> {
        self.metadata.as_ref()
    }
}
impl std::fmt::Debug for GetPipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPipelineOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`GetPipelineOutput`](crate::output::GetPipelineOutput)
pub mod get_pipeline_output {
    /// A builder for [`GetPipelineOutput`](crate::output::GetPipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::PipelineDeclaration>,
        pub(crate) metadata: std::option::Option<crate::model::PipelineMetadata>,
    }
    impl Builder {
        /// <p>Represents the structure of actions and stages to be performed in the pipeline.
        /// </p>
        pub fn pipeline(mut self, input: crate::model::PipelineDeclaration) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>Represents the structure of actions and stages to be performed in the pipeline.
        /// </p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::PipelineDeclaration>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// <p>Represents the pipeline metadata information returned as part of the output of a
        /// <code>GetPipeline</code> action.</p>
        pub fn metadata(mut self, input: crate::model::PipelineMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>Represents the pipeline metadata information returned as part of the output of a
        /// <code>GetPipeline</code> action.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::PipelineMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPipelineOutput`](crate::output::GetPipelineOutput)
        pub fn build(self) -> crate::output::GetPipelineOutput {
            crate::output::GetPipelineOutput {
                pipeline: self.pipeline,
                metadata: self.metadata,
            }
        }
    }
}
impl GetPipelineOutput {
    /// Creates a new builder-style object to manufacture [`GetPipelineOutput`](crate::output::GetPipelineOutput)
    pub fn builder() -> crate::output::get_pipeline_output::Builder {
        crate::output::get_pipeline_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetJobDetails</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobDetailsOutput {
    /// <p>The details of the job.</p>
    /// <note>
    /// <p>If AWSSessionCredentials is used, a long-running job can call
    /// <code>GetJobDetails</code> again to obtain new credentials.</p>
    /// </note>
    pub job_details: std::option::Option<crate::model::JobDetails>,
}
impl GetJobDetailsOutput {
    /// <p>The details of the job.</p>
    /// <note>
    /// <p>If AWSSessionCredentials is used, a long-running job can call
    /// <code>GetJobDetails</code> again to obtain new credentials.</p>
    /// </note>
    pub fn job_details(&self) -> std::option::Option<&crate::model::JobDetails> {
        self.job_details.as_ref()
    }
}
impl std::fmt::Debug for GetJobDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobDetailsOutput");
        formatter.field("job_details", &self.job_details);
        formatter.finish()
    }
}
/// See [`GetJobDetailsOutput`](crate::output::GetJobDetailsOutput)
pub mod get_job_details_output {
    /// A builder for [`GetJobDetailsOutput`](crate::output::GetJobDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_details: std::option::Option<crate::model::JobDetails>,
    }
    impl Builder {
        /// <p>The details of the job.</p>
        /// <note>
        /// <p>If AWSSessionCredentials is used, a long-running job can call
        /// <code>GetJobDetails</code> again to obtain new credentials.</p>
        /// </note>
        pub fn job_details(mut self, input: crate::model::JobDetails) -> Self {
            self.job_details = Some(input);
            self
        }
        /// <p>The details of the job.</p>
        /// <note>
        /// <p>If AWSSessionCredentials is used, a long-running job can call
        /// <code>GetJobDetails</code> again to obtain new credentials.</p>
        /// </note>
        pub fn set_job_details(
            mut self,
            input: std::option::Option<crate::model::JobDetails>,
        ) -> Self {
            self.job_details = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobDetailsOutput`](crate::output::GetJobDetailsOutput)
        pub fn build(self) -> crate::output::GetJobDetailsOutput {
            crate::output::GetJobDetailsOutput {
                job_details: self.job_details,
            }
        }
    }
}
impl GetJobDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GetJobDetailsOutput`](crate::output::GetJobDetailsOutput)
    pub fn builder() -> crate::output::get_job_details_output::Builder {
        crate::output::get_job_details_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetActionTypeOutput {
    /// <p>The action type information for the requested action type, such as the action type
    /// ID.</p>
    pub action_type: std::option::Option<crate::model::ActionTypeDeclaration>,
}
impl GetActionTypeOutput {
    /// <p>The action type information for the requested action type, such as the action type
    /// ID.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ActionTypeDeclaration> {
        self.action_type.as_ref()
    }
}
impl std::fmt::Debug for GetActionTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetActionTypeOutput");
        formatter.field("action_type", &self.action_type);
        formatter.finish()
    }
}
/// See [`GetActionTypeOutput`](crate::output::GetActionTypeOutput)
pub mod get_action_type_output {
    /// A builder for [`GetActionTypeOutput`](crate::output::GetActionTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<crate::model::ActionTypeDeclaration>,
    }
    impl Builder {
        /// <p>The action type information for the requested action type, such as the action type
        /// ID.</p>
        pub fn action_type(mut self, input: crate::model::ActionTypeDeclaration) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The action type information for the requested action type, such as the action type
        /// ID.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionTypeDeclaration>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetActionTypeOutput`](crate::output::GetActionTypeOutput)
        pub fn build(self) -> crate::output::GetActionTypeOutput {
            crate::output::GetActionTypeOutput {
                action_type: self.action_type,
            }
        }
    }
}
impl GetActionTypeOutput {
    /// Creates a new builder-style object to manufacture [`GetActionTypeOutput`](crate::output::GetActionTypeOutput)
    pub fn builder() -> crate::output::get_action_type_output::Builder {
        crate::output::get_action_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableStageTransitionOutput {}
impl std::fmt::Debug for EnableStageTransitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableStageTransitionOutput");
        formatter.finish()
    }
}
/// See [`EnableStageTransitionOutput`](crate::output::EnableStageTransitionOutput)
pub mod enable_stage_transition_output {
    /// A builder for [`EnableStageTransitionOutput`](crate::output::EnableStageTransitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableStageTransitionOutput`](crate::output::EnableStageTransitionOutput)
        pub fn build(self) -> crate::output::EnableStageTransitionOutput {
            crate::output::EnableStageTransitionOutput {}
        }
    }
}
impl EnableStageTransitionOutput {
    /// Creates a new builder-style object to manufacture [`EnableStageTransitionOutput`](crate::output::EnableStageTransitionOutput)
    pub fn builder() -> crate::output::enable_stage_transition_output::Builder {
        crate::output::enable_stage_transition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableStageTransitionOutput {}
impl std::fmt::Debug for DisableStageTransitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableStageTransitionOutput");
        formatter.finish()
    }
}
/// See [`DisableStageTransitionOutput`](crate::output::DisableStageTransitionOutput)
pub mod disable_stage_transition_output {
    /// A builder for [`DisableStageTransitionOutput`](crate::output::DisableStageTransitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableStageTransitionOutput`](crate::output::DisableStageTransitionOutput)
        pub fn build(self) -> crate::output::DisableStageTransitionOutput {
            crate::output::DisableStageTransitionOutput {}
        }
    }
}
impl DisableStageTransitionOutput {
    /// Creates a new builder-style object to manufacture [`DisableStageTransitionOutput`](crate::output::DisableStageTransitionOutput)
    pub fn builder() -> crate::output::disable_stage_transition_output::Builder {
        crate::output::disable_stage_transition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterWebhookWithThirdPartyOutput {}
impl std::fmt::Debug for DeregisterWebhookWithThirdPartyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterWebhookWithThirdPartyOutput");
        formatter.finish()
    }
}
/// See [`DeregisterWebhookWithThirdPartyOutput`](crate::output::DeregisterWebhookWithThirdPartyOutput)
pub mod deregister_webhook_with_third_party_output {
    /// A builder for [`DeregisterWebhookWithThirdPartyOutput`](crate::output::DeregisterWebhookWithThirdPartyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterWebhookWithThirdPartyOutput`](crate::output::DeregisterWebhookWithThirdPartyOutput)
        pub fn build(self) -> crate::output::DeregisterWebhookWithThirdPartyOutput {
            crate::output::DeregisterWebhookWithThirdPartyOutput {}
        }
    }
}
impl DeregisterWebhookWithThirdPartyOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterWebhookWithThirdPartyOutput`](crate::output::DeregisterWebhookWithThirdPartyOutput)
    pub fn builder() -> crate::output::deregister_webhook_with_third_party_output::Builder {
        crate::output::deregister_webhook_with_third_party_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWebhookOutput {}
impl std::fmt::Debug for DeleteWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWebhookOutput");
        formatter.finish()
    }
}
/// See [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
pub mod delete_webhook_output {
    /// A builder for [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
        pub fn build(self) -> crate::output::DeleteWebhookOutput {
            crate::output::DeleteWebhookOutput {}
        }
    }
}
impl DeleteWebhookOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
    pub fn builder() -> crate::output::delete_webhook_output::Builder {
        crate::output::delete_webhook_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePipelineOutput {}
impl std::fmt::Debug for DeletePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePipelineOutput");
        formatter.finish()
    }
}
/// See [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
pub mod delete_pipeline_output {
    /// A builder for [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
        pub fn build(self) -> crate::output::DeletePipelineOutput {
            crate::output::DeletePipelineOutput {}
        }
    }
}
impl DeletePipelineOutput {
    /// Creates a new builder-style object to manufacture [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
    pub fn builder() -> crate::output::delete_pipeline_output::Builder {
        crate::output::delete_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomActionTypeOutput {}
impl std::fmt::Debug for DeleteCustomActionTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomActionTypeOutput");
        formatter.finish()
    }
}
/// See [`DeleteCustomActionTypeOutput`](crate::output::DeleteCustomActionTypeOutput)
pub mod delete_custom_action_type_output {
    /// A builder for [`DeleteCustomActionTypeOutput`](crate::output::DeleteCustomActionTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCustomActionTypeOutput`](crate::output::DeleteCustomActionTypeOutput)
        pub fn build(self) -> crate::output::DeleteCustomActionTypeOutput {
            crate::output::DeleteCustomActionTypeOutput {}
        }
    }
}
impl DeleteCustomActionTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomActionTypeOutput`](crate::output::DeleteCustomActionTypeOutput)
    pub fn builder() -> crate::output::delete_custom_action_type_output::Builder {
        crate::output::delete_custom_action_type_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreatePipeline</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePipelineOutput {
    /// <p>Represents the structure of actions and stages to be performed in the pipeline.
    /// </p>
    pub pipeline: std::option::Option<crate::model::PipelineDeclaration>,
    /// <p>Specifies the tags applied to the pipeline.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreatePipelineOutput {
    /// <p>Represents the structure of actions and stages to be performed in the pipeline.
    /// </p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::PipelineDeclaration> {
        self.pipeline.as_ref()
    }
    /// <p>Specifies the tags applied to the pipeline.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePipelineOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
pub mod create_pipeline_output {
    /// A builder for [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::PipelineDeclaration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Represents the structure of actions and stages to be performed in the pipeline.
        /// </p>
        pub fn pipeline(mut self, input: crate::model::PipelineDeclaration) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>Represents the structure of actions and stages to be performed in the pipeline.
        /// </p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::PipelineDeclaration>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the pipeline.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to the pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
        pub fn build(self) -> crate::output::CreatePipelineOutput {
            crate::output::CreatePipelineOutput {
                pipeline: self.pipeline,
                tags: self.tags,
            }
        }
    }
}
impl CreatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
    pub fn builder() -> crate::output::create_pipeline_output::Builder {
        crate::output::create_pipeline_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateCustomActionType</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomActionTypeOutput {
    /// <p>Returns information about the details of an action type.</p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>Specifies the tags applied to the custom action.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateCustomActionTypeOutput {
    /// <p>Returns information about the details of an action type.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ActionType> {
        self.action_type.as_ref()
    }
    /// <p>Specifies the tags applied to the custom action.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomActionTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomActionTypeOutput");
        formatter.field("action_type", &self.action_type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateCustomActionTypeOutput`](crate::output::CreateCustomActionTypeOutput)
pub mod create_custom_action_type_output {
    /// A builder for [`CreateCustomActionTypeOutput`](crate::output::CreateCustomActionTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Returns information about the details of an action type.</p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>Returns information about the details of an action type.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the custom action.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to the custom action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomActionTypeOutput`](crate::output::CreateCustomActionTypeOutput)
        pub fn build(self) -> crate::output::CreateCustomActionTypeOutput {
            crate::output::CreateCustomActionTypeOutput {
                action_type: self.action_type,
                tags: self.tags,
            }
        }
    }
}
impl CreateCustomActionTypeOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomActionTypeOutput`](crate::output::CreateCustomActionTypeOutput)
    pub fn builder() -> crate::output::create_custom_action_type_output::Builder {
        crate::output::create_custom_action_type_output::Builder::default()
    }
}

/// <p>Represents the output of an AcknowledgeThirdPartyJob action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcknowledgeThirdPartyJobOutput {
    /// <p>The status information for the third party job, if any.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
}
impl AcknowledgeThirdPartyJobOutput {
    /// <p>The status information for the third party job, if any.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AcknowledgeThirdPartyJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcknowledgeThirdPartyJobOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AcknowledgeThirdPartyJobOutput`](crate::output::AcknowledgeThirdPartyJobOutput)
pub mod acknowledge_third_party_job_output {
    /// A builder for [`AcknowledgeThirdPartyJobOutput`](crate::output::AcknowledgeThirdPartyJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
    }
    impl Builder {
        /// <p>The status information for the third party job, if any.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status information for the third party job, if any.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AcknowledgeThirdPartyJobOutput`](crate::output::AcknowledgeThirdPartyJobOutput)
        pub fn build(self) -> crate::output::AcknowledgeThirdPartyJobOutput {
            crate::output::AcknowledgeThirdPartyJobOutput {
                status: self.status,
            }
        }
    }
}
impl AcknowledgeThirdPartyJobOutput {
    /// Creates a new builder-style object to manufacture [`AcknowledgeThirdPartyJobOutput`](crate::output::AcknowledgeThirdPartyJobOutput)
    pub fn builder() -> crate::output::acknowledge_third_party_job_output::Builder {
        crate::output::acknowledge_third_party_job_output::Builder::default()
    }
}

/// <p>Represents the output of an AcknowledgeJob action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcknowledgeJobOutput {
    /// <p>Whether the job worker has received the specified job.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
}
impl AcknowledgeJobOutput {
    /// <p>Whether the job worker has received the specified job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AcknowledgeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcknowledgeJobOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AcknowledgeJobOutput`](crate::output::AcknowledgeJobOutput)
pub mod acknowledge_job_output {
    /// A builder for [`AcknowledgeJobOutput`](crate::output::AcknowledgeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
    }
    impl Builder {
        /// <p>Whether the job worker has received the specified job.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Whether the job worker has received the specified job.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AcknowledgeJobOutput`](crate::output::AcknowledgeJobOutput)
        pub fn build(self) -> crate::output::AcknowledgeJobOutput {
            crate::output::AcknowledgeJobOutput {
                status: self.status,
            }
        }
    }
}
impl AcknowledgeJobOutput {
    /// Creates a new builder-style object to manufacture [`AcknowledgeJobOutput`](crate::output::AcknowledgeJobOutput)
    pub fn builder() -> crate::output::acknowledge_job_output::Builder {
        crate::output::acknowledge_job_output::Builder::default()
    }
}
