// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcknowledgeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`acknowledge_job`](crate::client::Client::acknowledge_job).
///
/// See [`crate::client::fluent_builders::AcknowledgeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcknowledgeJob {
    _private: (),
}
impl AcknowledgeJob {
    /// Creates a new builder-style object to manufacture [`AcknowledgeJobInput`](crate::input::AcknowledgeJobInput)
    pub fn builder() -> crate::input::acknowledge_job_input::Builder {
        crate::input::acknowledge_job_input::Builder::default()
    }
    /// Creates a new `AcknowledgeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcknowledgeJob {
    type Output =
        std::result::Result<crate::output::AcknowledgeJobOutput, crate::error::AcknowledgeJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_acknowledge_job_error(response)
        } else {
            crate::operation_deser::parse_acknowledge_job_response(response)
        }
    }
}

/// Operation shape for `AcknowledgeThirdPartyJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`acknowledge_third_party_job`](crate::client::Client::acknowledge_third_party_job).
///
/// See [`crate::client::fluent_builders::AcknowledgeThirdPartyJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcknowledgeThirdPartyJob {
    _private: (),
}
impl AcknowledgeThirdPartyJob {
    /// Creates a new builder-style object to manufacture [`AcknowledgeThirdPartyJobInput`](crate::input::AcknowledgeThirdPartyJobInput)
    pub fn builder() -> crate::input::acknowledge_third_party_job_input::Builder {
        crate::input::acknowledge_third_party_job_input::Builder::default()
    }
    /// Creates a new `AcknowledgeThirdPartyJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcknowledgeThirdPartyJob {
    type Output = std::result::Result<
        crate::output::AcknowledgeThirdPartyJobOutput,
        crate::error::AcknowledgeThirdPartyJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_acknowledge_third_party_job_error(response)
        } else {
            crate::operation_deser::parse_acknowledge_third_party_job_response(response)
        }
    }
}

/// Operation shape for `CreateCustomActionType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_action_type`](crate::client::Client::create_custom_action_type).
///
/// See [`crate::client::fluent_builders::CreateCustomActionType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomActionType {
    _private: (),
}
impl CreateCustomActionType {
    /// Creates a new builder-style object to manufacture [`CreateCustomActionTypeInput`](crate::input::CreateCustomActionTypeInput)
    pub fn builder() -> crate::input::create_custom_action_type_input::Builder {
        crate::input::create_custom_action_type_input::Builder::default()
    }
    /// Creates a new `CreateCustomActionType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomActionType {
    type Output = std::result::Result<
        crate::output::CreateCustomActionTypeOutput,
        crate::error::CreateCustomActionTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_action_type_error(response)
        } else {
            crate::operation_deser::parse_create_custom_action_type_response(response)
        }
    }
}

/// Operation shape for `CreatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pipeline`](crate::client::Client::create_pipeline).
///
/// See [`crate::client::fluent_builders::CreatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePipeline {
    _private: (),
}
impl CreatePipeline {
    /// Creates a new builder-style object to manufacture [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    pub fn builder() -> crate::input::create_pipeline_input::Builder {
        crate::input::create_pipeline_input::Builder::default()
    }
    /// Creates a new `CreatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePipeline {
    type Output =
        std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_pipeline_error(response)
        } else {
            crate::operation_deser::parse_create_pipeline_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomActionType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_action_type`](crate::client::Client::delete_custom_action_type).
///
/// See [`crate::client::fluent_builders::DeleteCustomActionType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomActionType {
    _private: (),
}
impl DeleteCustomActionType {
    /// Creates a new builder-style object to manufacture [`DeleteCustomActionTypeInput`](crate::input::DeleteCustomActionTypeInput)
    pub fn builder() -> crate::input::delete_custom_action_type_input::Builder {
        crate::input::delete_custom_action_type_input::Builder::default()
    }
    /// Creates a new `DeleteCustomActionType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomActionType {
    type Output = std::result::Result<
        crate::output::DeleteCustomActionTypeOutput,
        crate::error::DeleteCustomActionTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_action_type_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_action_type_response(response)
        }
    }
}

/// Operation shape for `DeletePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pipeline`](crate::client::Client::delete_pipeline).
///
/// See [`crate::client::fluent_builders::DeletePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePipeline {
    _private: (),
}
impl DeletePipeline {
    /// Creates a new builder-style object to manufacture [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    pub fn builder() -> crate::input::delete_pipeline_input::Builder {
        crate::input::delete_pipeline_input::Builder::default()
    }
    /// Creates a new `DeletePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePipeline {
    type Output =
        std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_pipeline_error(response)
        } else {
            crate::operation_deser::parse_delete_pipeline_response(response)
        }
    }
}

/// Operation shape for `DeleteWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_webhook`](crate::client::Client::delete_webhook).
///
/// See [`crate::client::fluent_builders::DeleteWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWebhook {
    _private: (),
}
impl DeleteWebhook {
    /// Creates a new builder-style object to manufacture [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
    pub fn builder() -> crate::input::delete_webhook_input::Builder {
        crate::input::delete_webhook_input::Builder::default()
    }
    /// Creates a new `DeleteWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWebhook {
    type Output =
        std::result::Result<crate::output::DeleteWebhookOutput, crate::error::DeleteWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_webhook_error(response)
        } else {
            crate::operation_deser::parse_delete_webhook_response(response)
        }
    }
}

/// Operation shape for `DeregisterWebhookWithThirdParty`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_webhook_with_third_party`](crate::client::Client::deregister_webhook_with_third_party).
///
/// See [`crate::client::fluent_builders::DeregisterWebhookWithThirdParty`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterWebhookWithThirdParty {
    _private: (),
}
impl DeregisterWebhookWithThirdParty {
    /// Creates a new builder-style object to manufacture [`DeregisterWebhookWithThirdPartyInput`](crate::input::DeregisterWebhookWithThirdPartyInput)
    pub fn builder() -> crate::input::deregister_webhook_with_third_party_input::Builder {
        crate::input::deregister_webhook_with_third_party_input::Builder::default()
    }
    /// Creates a new `DeregisterWebhookWithThirdParty` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterWebhookWithThirdParty {
    type Output = std::result::Result<
        crate::output::DeregisterWebhookWithThirdPartyOutput,
        crate::error::DeregisterWebhookWithThirdPartyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_webhook_with_third_party_error(response)
        } else {
            crate::operation_deser::parse_deregister_webhook_with_third_party_response(response)
        }
    }
}

/// Operation shape for `DisableStageTransition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_stage_transition`](crate::client::Client::disable_stage_transition).
///
/// See [`crate::client::fluent_builders::DisableStageTransition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableStageTransition {
    _private: (),
}
impl DisableStageTransition {
    /// Creates a new builder-style object to manufacture [`DisableStageTransitionInput`](crate::input::DisableStageTransitionInput)
    pub fn builder() -> crate::input::disable_stage_transition_input::Builder {
        crate::input::disable_stage_transition_input::Builder::default()
    }
    /// Creates a new `DisableStageTransition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableStageTransition {
    type Output = std::result::Result<
        crate::output::DisableStageTransitionOutput,
        crate::error::DisableStageTransitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_stage_transition_error(response)
        } else {
            crate::operation_deser::parse_disable_stage_transition_response(response)
        }
    }
}

/// Operation shape for `EnableStageTransition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_stage_transition`](crate::client::Client::enable_stage_transition).
///
/// See [`crate::client::fluent_builders::EnableStageTransition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableStageTransition {
    _private: (),
}
impl EnableStageTransition {
    /// Creates a new builder-style object to manufacture [`EnableStageTransitionInput`](crate::input::EnableStageTransitionInput)
    pub fn builder() -> crate::input::enable_stage_transition_input::Builder {
        crate::input::enable_stage_transition_input::Builder::default()
    }
    /// Creates a new `EnableStageTransition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableStageTransition {
    type Output = std::result::Result<
        crate::output::EnableStageTransitionOutput,
        crate::error::EnableStageTransitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_stage_transition_error(response)
        } else {
            crate::operation_deser::parse_enable_stage_transition_response(response)
        }
    }
}

/// Operation shape for `GetActionType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_action_type`](crate::client::Client::get_action_type).
///
/// See [`crate::client::fluent_builders::GetActionType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetActionType {
    _private: (),
}
impl GetActionType {
    /// Creates a new builder-style object to manufacture [`GetActionTypeInput`](crate::input::GetActionTypeInput)
    pub fn builder() -> crate::input::get_action_type_input::Builder {
        crate::input::get_action_type_input::Builder::default()
    }
    /// Creates a new `GetActionType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetActionType {
    type Output =
        std::result::Result<crate::output::GetActionTypeOutput, crate::error::GetActionTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_action_type_error(response)
        } else {
            crate::operation_deser::parse_get_action_type_response(response)
        }
    }
}

/// Operation shape for `GetJobDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_details`](crate::client::Client::get_job_details).
///
/// See [`crate::client::fluent_builders::GetJobDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobDetails {
    _private: (),
}
impl GetJobDetails {
    /// Creates a new builder-style object to manufacture [`GetJobDetailsInput`](crate::input::GetJobDetailsInput)
    pub fn builder() -> crate::input::get_job_details_input::Builder {
        crate::input::get_job_details_input::Builder::default()
    }
    /// Creates a new `GetJobDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobDetails {
    type Output =
        std::result::Result<crate::output::GetJobDetailsOutput, crate::error::GetJobDetailsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_details_error(response)
        } else {
            crate::operation_deser::parse_get_job_details_response(response)
        }
    }
}

/// Operation shape for `GetPipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_pipeline`](crate::client::Client::get_pipeline).
///
/// See [`crate::client::fluent_builders::GetPipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPipeline {
    _private: (),
}
impl GetPipeline {
    /// Creates a new builder-style object to manufacture [`GetPipelineInput`](crate::input::GetPipelineInput)
    pub fn builder() -> crate::input::get_pipeline_input::Builder {
        crate::input::get_pipeline_input::Builder::default()
    }
    /// Creates a new `GetPipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPipeline {
    type Output =
        std::result::Result<crate::output::GetPipelineOutput, crate::error::GetPipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_pipeline_error(response)
        } else {
            crate::operation_deser::parse_get_pipeline_response(response)
        }
    }
}

/// Operation shape for `GetPipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_pipeline_execution`](crate::client::Client::get_pipeline_execution).
///
/// See [`crate::client::fluent_builders::GetPipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPipelineExecution {
    _private: (),
}
impl GetPipelineExecution {
    /// Creates a new builder-style object to manufacture [`GetPipelineExecutionInput`](crate::input::GetPipelineExecutionInput)
    pub fn builder() -> crate::input::get_pipeline_execution_input::Builder {
        crate::input::get_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `GetPipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPipelineExecution {
    type Output = std::result::Result<
        crate::output::GetPipelineExecutionOutput,
        crate::error::GetPipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_get_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `GetPipelineState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_pipeline_state`](crate::client::Client::get_pipeline_state).
///
/// See [`crate::client::fluent_builders::GetPipelineState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPipelineState {
    _private: (),
}
impl GetPipelineState {
    /// Creates a new builder-style object to manufacture [`GetPipelineStateInput`](crate::input::GetPipelineStateInput)
    pub fn builder() -> crate::input::get_pipeline_state_input::Builder {
        crate::input::get_pipeline_state_input::Builder::default()
    }
    /// Creates a new `GetPipelineState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPipelineState {
    type Output = std::result::Result<
        crate::output::GetPipelineStateOutput,
        crate::error::GetPipelineStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_pipeline_state_error(response)
        } else {
            crate::operation_deser::parse_get_pipeline_state_response(response)
        }
    }
}

/// Operation shape for `GetThirdPartyJobDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_third_party_job_details`](crate::client::Client::get_third_party_job_details).
///
/// See [`crate::client::fluent_builders::GetThirdPartyJobDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetThirdPartyJobDetails {
    _private: (),
}
impl GetThirdPartyJobDetails {
    /// Creates a new builder-style object to manufacture [`GetThirdPartyJobDetailsInput`](crate::input::GetThirdPartyJobDetailsInput)
    pub fn builder() -> crate::input::get_third_party_job_details_input::Builder {
        crate::input::get_third_party_job_details_input::Builder::default()
    }
    /// Creates a new `GetThirdPartyJobDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetThirdPartyJobDetails {
    type Output = std::result::Result<
        crate::output::GetThirdPartyJobDetailsOutput,
        crate::error::GetThirdPartyJobDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_third_party_job_details_error(response)
        } else {
            crate::operation_deser::parse_get_third_party_job_details_response(response)
        }
    }
}

/// Operation shape for `ListActionExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_action_executions`](crate::client::Client::list_action_executions).
///
/// See [`crate::client::fluent_builders::ListActionExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListActionExecutions {
    _private: (),
}
impl ListActionExecutions {
    /// Creates a new builder-style object to manufacture [`ListActionExecutionsInput`](crate::input::ListActionExecutionsInput)
    pub fn builder() -> crate::input::list_action_executions_input::Builder {
        crate::input::list_action_executions_input::Builder::default()
    }
    /// Creates a new `ListActionExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListActionExecutions {
    type Output = std::result::Result<
        crate::output::ListActionExecutionsOutput,
        crate::error::ListActionExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_action_executions_error(response)
        } else {
            crate::operation_deser::parse_list_action_executions_response(response)
        }
    }
}

/// Operation shape for `ListActionTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_action_types`](crate::client::Client::list_action_types).
///
/// See [`crate::client::fluent_builders::ListActionTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListActionTypes {
    _private: (),
}
impl ListActionTypes {
    /// Creates a new builder-style object to manufacture [`ListActionTypesInput`](crate::input::ListActionTypesInput)
    pub fn builder() -> crate::input::list_action_types_input::Builder {
        crate::input::list_action_types_input::Builder::default()
    }
    /// Creates a new `ListActionTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListActionTypes {
    type Output = std::result::Result<
        crate::output::ListActionTypesOutput,
        crate::error::ListActionTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_action_types_error(response)
        } else {
            crate::operation_deser::parse_list_action_types_response(response)
        }
    }
}

/// Operation shape for `ListPipelineExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipeline_executions`](crate::client::Client::list_pipeline_executions).
///
/// See [`crate::client::fluent_builders::ListPipelineExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelineExecutions {
    _private: (),
}
impl ListPipelineExecutions {
    /// Creates a new builder-style object to manufacture [`ListPipelineExecutionsInput`](crate::input::ListPipelineExecutionsInput)
    pub fn builder() -> crate::input::list_pipeline_executions_input::Builder {
        crate::input::list_pipeline_executions_input::Builder::default()
    }
    /// Creates a new `ListPipelineExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelineExecutions {
    type Output = std::result::Result<
        crate::output::ListPipelineExecutionsOutput,
        crate::error::ListPipelineExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipeline_executions_error(response)
        } else {
            crate::operation_deser::parse_list_pipeline_executions_response(response)
        }
    }
}

/// Operation shape for `ListPipelines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipelines`](crate::client::Client::list_pipelines).
///
/// See [`crate::client::fluent_builders::ListPipelines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelines {
    _private: (),
}
impl ListPipelines {
    /// Creates a new builder-style object to manufacture [`ListPipelinesInput`](crate::input::ListPipelinesInput)
    pub fn builder() -> crate::input::list_pipelines_input::Builder {
        crate::input::list_pipelines_input::Builder::default()
    }
    /// Creates a new `ListPipelines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelines {
    type Output =
        std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipelines_error(response)
        } else {
            crate::operation_deser::parse_list_pipelines_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWebhooks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_webhooks`](crate::client::Client::list_webhooks).
///
/// See [`crate::client::fluent_builders::ListWebhooks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWebhooks {
    _private: (),
}
impl ListWebhooks {
    /// Creates a new builder-style object to manufacture [`ListWebhooksInput`](crate::input::ListWebhooksInput)
    pub fn builder() -> crate::input::list_webhooks_input::Builder {
        crate::input::list_webhooks_input::Builder::default()
    }
    /// Creates a new `ListWebhooks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWebhooks {
    type Output =
        std::result::Result<crate::output::ListWebhooksOutput, crate::error::ListWebhooksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_webhooks_error(response)
        } else {
            crate::operation_deser::parse_list_webhooks_response(response)
        }
    }
}

/// Operation shape for `PollForJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`poll_for_jobs`](crate::client::Client::poll_for_jobs).
///
/// See [`crate::client::fluent_builders::PollForJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PollForJobs {
    _private: (),
}
impl PollForJobs {
    /// Creates a new builder-style object to manufacture [`PollForJobsInput`](crate::input::PollForJobsInput)
    pub fn builder() -> crate::input::poll_for_jobs_input::Builder {
        crate::input::poll_for_jobs_input::Builder::default()
    }
    /// Creates a new `PollForJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PollForJobs {
    type Output =
        std::result::Result<crate::output::PollForJobsOutput, crate::error::PollForJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_poll_for_jobs_error(response)
        } else {
            crate::operation_deser::parse_poll_for_jobs_response(response)
        }
    }
}

/// Operation shape for `PollForThirdPartyJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`poll_for_third_party_jobs`](crate::client::Client::poll_for_third_party_jobs).
///
/// See [`crate::client::fluent_builders::PollForThirdPartyJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PollForThirdPartyJobs {
    _private: (),
}
impl PollForThirdPartyJobs {
    /// Creates a new builder-style object to manufacture [`PollForThirdPartyJobsInput`](crate::input::PollForThirdPartyJobsInput)
    pub fn builder() -> crate::input::poll_for_third_party_jobs_input::Builder {
        crate::input::poll_for_third_party_jobs_input::Builder::default()
    }
    /// Creates a new `PollForThirdPartyJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PollForThirdPartyJobs {
    type Output = std::result::Result<
        crate::output::PollForThirdPartyJobsOutput,
        crate::error::PollForThirdPartyJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_poll_for_third_party_jobs_error(response)
        } else {
            crate::operation_deser::parse_poll_for_third_party_jobs_response(response)
        }
    }
}

/// Operation shape for `PutActionRevision`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_action_revision`](crate::client::Client::put_action_revision).
///
/// See [`crate::client::fluent_builders::PutActionRevision`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutActionRevision {
    _private: (),
}
impl PutActionRevision {
    /// Creates a new builder-style object to manufacture [`PutActionRevisionInput`](crate::input::PutActionRevisionInput)
    pub fn builder() -> crate::input::put_action_revision_input::Builder {
        crate::input::put_action_revision_input::Builder::default()
    }
    /// Creates a new `PutActionRevision` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutActionRevision {
    type Output = std::result::Result<
        crate::output::PutActionRevisionOutput,
        crate::error::PutActionRevisionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_action_revision_error(response)
        } else {
            crate::operation_deser::parse_put_action_revision_response(response)
        }
    }
}

/// Operation shape for `PutApprovalResult`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_approval_result`](crate::client::Client::put_approval_result).
///
/// See [`crate::client::fluent_builders::PutApprovalResult`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutApprovalResult {
    _private: (),
}
impl PutApprovalResult {
    /// Creates a new builder-style object to manufacture [`PutApprovalResultInput`](crate::input::PutApprovalResultInput)
    pub fn builder() -> crate::input::put_approval_result_input::Builder {
        crate::input::put_approval_result_input::Builder::default()
    }
    /// Creates a new `PutApprovalResult` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutApprovalResult {
    type Output = std::result::Result<
        crate::output::PutApprovalResultOutput,
        crate::error::PutApprovalResultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_approval_result_error(response)
        } else {
            crate::operation_deser::parse_put_approval_result_response(response)
        }
    }
}

/// Operation shape for `PutJobFailureResult`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_job_failure_result`](crate::client::Client::put_job_failure_result).
///
/// See [`crate::client::fluent_builders::PutJobFailureResult`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutJobFailureResult {
    _private: (),
}
impl PutJobFailureResult {
    /// Creates a new builder-style object to manufacture [`PutJobFailureResultInput`](crate::input::PutJobFailureResultInput)
    pub fn builder() -> crate::input::put_job_failure_result_input::Builder {
        crate::input::put_job_failure_result_input::Builder::default()
    }
    /// Creates a new `PutJobFailureResult` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutJobFailureResult {
    type Output = std::result::Result<
        crate::output::PutJobFailureResultOutput,
        crate::error::PutJobFailureResultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_job_failure_result_error(response)
        } else {
            crate::operation_deser::parse_put_job_failure_result_response(response)
        }
    }
}

/// Operation shape for `PutJobSuccessResult`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_job_success_result`](crate::client::Client::put_job_success_result).
///
/// See [`crate::client::fluent_builders::PutJobSuccessResult`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutJobSuccessResult {
    _private: (),
}
impl PutJobSuccessResult {
    /// Creates a new builder-style object to manufacture [`PutJobSuccessResultInput`](crate::input::PutJobSuccessResultInput)
    pub fn builder() -> crate::input::put_job_success_result_input::Builder {
        crate::input::put_job_success_result_input::Builder::default()
    }
    /// Creates a new `PutJobSuccessResult` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutJobSuccessResult {
    type Output = std::result::Result<
        crate::output::PutJobSuccessResultOutput,
        crate::error::PutJobSuccessResultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_job_success_result_error(response)
        } else {
            crate::operation_deser::parse_put_job_success_result_response(response)
        }
    }
}

/// Operation shape for `PutThirdPartyJobFailureResult`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_third_party_job_failure_result`](crate::client::Client::put_third_party_job_failure_result).
///
/// See [`crate::client::fluent_builders::PutThirdPartyJobFailureResult`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutThirdPartyJobFailureResult {
    _private: (),
}
impl PutThirdPartyJobFailureResult {
    /// Creates a new builder-style object to manufacture [`PutThirdPartyJobFailureResultInput`](crate::input::PutThirdPartyJobFailureResultInput)
    pub fn builder() -> crate::input::put_third_party_job_failure_result_input::Builder {
        crate::input::put_third_party_job_failure_result_input::Builder::default()
    }
    /// Creates a new `PutThirdPartyJobFailureResult` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutThirdPartyJobFailureResult {
    type Output = std::result::Result<
        crate::output::PutThirdPartyJobFailureResultOutput,
        crate::error::PutThirdPartyJobFailureResultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_third_party_job_failure_result_error(response)
        } else {
            crate::operation_deser::parse_put_third_party_job_failure_result_response(response)
        }
    }
}

/// Operation shape for `PutThirdPartyJobSuccessResult`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_third_party_job_success_result`](crate::client::Client::put_third_party_job_success_result).
///
/// See [`crate::client::fluent_builders::PutThirdPartyJobSuccessResult`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutThirdPartyJobSuccessResult {
    _private: (),
}
impl PutThirdPartyJobSuccessResult {
    /// Creates a new builder-style object to manufacture [`PutThirdPartyJobSuccessResultInput`](crate::input::PutThirdPartyJobSuccessResultInput)
    pub fn builder() -> crate::input::put_third_party_job_success_result_input::Builder {
        crate::input::put_third_party_job_success_result_input::Builder::default()
    }
    /// Creates a new `PutThirdPartyJobSuccessResult` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutThirdPartyJobSuccessResult {
    type Output = std::result::Result<
        crate::output::PutThirdPartyJobSuccessResultOutput,
        crate::error::PutThirdPartyJobSuccessResultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_third_party_job_success_result_error(response)
        } else {
            crate::operation_deser::parse_put_third_party_job_success_result_response(response)
        }
    }
}

/// Operation shape for `PutWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_webhook`](crate::client::Client::put_webhook).
///
/// See [`crate::client::fluent_builders::PutWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutWebhook {
    _private: (),
}
impl PutWebhook {
    /// Creates a new builder-style object to manufacture [`PutWebhookInput`](crate::input::PutWebhookInput)
    pub fn builder() -> crate::input::put_webhook_input::Builder {
        crate::input::put_webhook_input::Builder::default()
    }
    /// Creates a new `PutWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutWebhook {
    type Output =
        std::result::Result<crate::output::PutWebhookOutput, crate::error::PutWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_webhook_error(response)
        } else {
            crate::operation_deser::parse_put_webhook_response(response)
        }
    }
}

/// Operation shape for `RegisterWebhookWithThirdParty`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_webhook_with_third_party`](crate::client::Client::register_webhook_with_third_party).
///
/// See [`crate::client::fluent_builders::RegisterWebhookWithThirdParty`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterWebhookWithThirdParty {
    _private: (),
}
impl RegisterWebhookWithThirdParty {
    /// Creates a new builder-style object to manufacture [`RegisterWebhookWithThirdPartyInput`](crate::input::RegisterWebhookWithThirdPartyInput)
    pub fn builder() -> crate::input::register_webhook_with_third_party_input::Builder {
        crate::input::register_webhook_with_third_party_input::Builder::default()
    }
    /// Creates a new `RegisterWebhookWithThirdParty` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterWebhookWithThirdParty {
    type Output = std::result::Result<
        crate::output::RegisterWebhookWithThirdPartyOutput,
        crate::error::RegisterWebhookWithThirdPartyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_webhook_with_third_party_error(response)
        } else {
            crate::operation_deser::parse_register_webhook_with_third_party_response(response)
        }
    }
}

/// Operation shape for `RetryStageExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retry_stage_execution`](crate::client::Client::retry_stage_execution).
///
/// See [`crate::client::fluent_builders::RetryStageExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetryStageExecution {
    _private: (),
}
impl RetryStageExecution {
    /// Creates a new builder-style object to manufacture [`RetryStageExecutionInput`](crate::input::RetryStageExecutionInput)
    pub fn builder() -> crate::input::retry_stage_execution_input::Builder {
        crate::input::retry_stage_execution_input::Builder::default()
    }
    /// Creates a new `RetryStageExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetryStageExecution {
    type Output = std::result::Result<
        crate::output::RetryStageExecutionOutput,
        crate::error::RetryStageExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retry_stage_execution_error(response)
        } else {
            crate::operation_deser::parse_retry_stage_execution_response(response)
        }
    }
}

/// Operation shape for `StartPipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_pipeline_execution`](crate::client::Client::start_pipeline_execution).
///
/// See [`crate::client::fluent_builders::StartPipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartPipelineExecution {
    _private: (),
}
impl StartPipelineExecution {
    /// Creates a new builder-style object to manufacture [`StartPipelineExecutionInput`](crate::input::StartPipelineExecutionInput)
    pub fn builder() -> crate::input::start_pipeline_execution_input::Builder {
        crate::input::start_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `StartPipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartPipelineExecution {
    type Output = std::result::Result<
        crate::output::StartPipelineExecutionOutput,
        crate::error::StartPipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_start_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `StopPipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_pipeline_execution`](crate::client::Client::stop_pipeline_execution).
///
/// See [`crate::client::fluent_builders::StopPipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopPipelineExecution {
    _private: (),
}
impl StopPipelineExecution {
    /// Creates a new builder-style object to manufacture [`StopPipelineExecutionInput`](crate::input::StopPipelineExecutionInput)
    pub fn builder() -> crate::input::stop_pipeline_execution_input::Builder {
        crate::input::stop_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `StopPipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopPipelineExecution {
    type Output = std::result::Result<
        crate::output::StopPipelineExecutionOutput,
        crate::error::StopPipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_stop_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateActionType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_action_type`](crate::client::Client::update_action_type).
///
/// See [`crate::client::fluent_builders::UpdateActionType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateActionType {
    _private: (),
}
impl UpdateActionType {
    /// Creates a new builder-style object to manufacture [`UpdateActionTypeInput`](crate::input::UpdateActionTypeInput)
    pub fn builder() -> crate::input::update_action_type_input::Builder {
        crate::input::update_action_type_input::Builder::default()
    }
    /// Creates a new `UpdateActionType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateActionType {
    type Output = std::result::Result<
        crate::output::UpdateActionTypeOutput,
        crate::error::UpdateActionTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_action_type_error(response)
        } else {
            crate::operation_deser::parse_update_action_type_response(response)
        }
    }
}

/// Operation shape for `UpdatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pipeline`](crate::client::Client::update_pipeline).
///
/// See [`crate::client::fluent_builders::UpdatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePipeline {
    _private: (),
}
impl UpdatePipeline {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
    pub fn builder() -> crate::input::update_pipeline_input::Builder {
        crate::input::update_pipeline_input::Builder::default()
    }
    /// Creates a new `UpdatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePipeline {
    type Output =
        std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pipeline_error(response)
        } else {
            crate::operation_deser::parse_update_pipeline_response(response)
        }
    }
}
