// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateRepositoryInput`](crate::input::AssociateRepositoryInput)
pub mod associate_repository_input {
    /// A builder for [`AssociateRepositoryInput`](crate::input::AssociateRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::Repository>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) kms_key_details: std::option::Option<crate::model::KmsKeyDetails>,
    }
    impl Builder {
        /// <p>The repository to associate.</p>
        pub fn repository(mut self, input: crate::model::Repository) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>The repository to associate.</p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::Repository>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// <p>Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
        /// <ul>
        /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
        /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
        /// <ul>
        /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
        /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
        /// <ul>
        /// <li> <p>The encryption option for this repository association. It is either owned by Amazon Web Services Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p> </li>
        /// <li> <p>The ID of the Amazon Web Services KMS key that is associated with this respository association.</p> </li>
        /// </ul>
        pub fn kms_key_details(mut self, input: crate::model::KmsKeyDetails) -> Self {
            self.kms_key_details = Some(input);
            self
        }
        /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
        /// <ul>
        /// <li> <p>The encryption option for this repository association. It is either owned by Amazon Web Services Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p> </li>
        /// <li> <p>The ID of the Amazon Web Services KMS key that is associated with this respository association.</p> </li>
        /// </ul>
        pub fn set_kms_key_details(
            mut self,
            input: std::option::Option<crate::model::KmsKeyDetails>,
        ) -> Self {
            self.kms_key_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateRepositoryInput`](crate::input::AssociateRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateRepositoryInput {
                repository: self.repository,
                client_request_token: self.client_request_token,
                tags: self.tags,
                kms_key_details: self.kms_key_details,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateRepositoryInputOperationOutputAlias = crate::operation::AssociateRepository;
#[doc(hidden)]
pub type AssociateRepositoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`AssociateRepository`](crate::operation::AssociateRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/associations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_repository(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateRepository",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateRepositoryInput`](crate::input::AssociateRepositoryInput)
    pub fn builder() -> crate::input::associate_repository_input::Builder {
        crate::input::associate_repository_input::Builder::default()
    }
}

/// See [`CreateCodeReviewInput`](crate::input::CreateCodeReviewInput)
pub mod create_code_review_input {
    /// A builder for [`CreateCodeReviewInput`](crate::input::CreateCodeReviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) repository_association_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::CodeReviewType>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the code review. The name of each code review in your Amazon Web Services account must be unique. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the code review. The name of each code review in your Amazon Web Services account must be unique. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        /// <p> A code review can only be created on an associated repository. This is the ARN of the associated repository. </p>
        pub fn repository_association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_association_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        /// <p> A code review can only be created on an associated repository. This is the ARN of the associated repository. </p>
        pub fn set_repository_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_association_arn = input;
            self
        }
        /// <p> The type of code review to create. This is specified using a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html"> <code>CodeReviewType</code> </a> object. You can create a code review only of type <code>RepositoryAnalysis</code>. </p>
        pub fn r#type(mut self, input: crate::model::CodeReviewType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of code review to create. This is specified using a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html"> <code>CodeReviewType</code> </a> object. You can create a code review only of type <code>RepositoryAnalysis</code>. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CodeReviewType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p> Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there are failures and retries. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there are failures and retries. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCodeReviewInput`](crate::input::CreateCodeReviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCodeReviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCodeReviewInput {
                name: self.name,
                repository_association_arn: self.repository_association_arn,
                r#type: self.r#type,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCodeReviewInputOperationOutputAlias = crate::operation::CreateCodeReview;
#[doc(hidden)]
pub type CreateCodeReviewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCodeReviewInput {
    /// Consumes the builder and constructs an Operation<[`CreateCodeReview`](crate::operation::CreateCodeReview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCodeReview,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCodeReviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/codereviews").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCodeReviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCodeReviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_code_review(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCodeReview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCodeReview",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCodeReviewInput`](crate::input::CreateCodeReviewInput)
    pub fn builder() -> crate::input::create_code_review_input::Builder {
        crate::input::create_code_review_input::Builder::default()
    }
}

/// See [`DescribeCodeReviewInput`](crate::input::DescribeCodeReviewInput)
pub mod describe_code_review_input {
    /// A builder for [`DescribeCodeReviewInput`](crate::input::DescribeCodeReviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCodeReviewInput`](crate::input::DescribeCodeReviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCodeReviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCodeReviewInput {
                code_review_arn: self.code_review_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCodeReviewInputOperationOutputAlias = crate::operation::DescribeCodeReview;
#[doc(hidden)]
pub type DescribeCodeReviewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCodeReviewInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCodeReview`](crate::operation::DescribeCodeReview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCodeReview,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCodeReviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.code_review_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_review_arn",
                        details: "cannot be empty or unset",
                    })?;
            let code_review_arn = aws_smithy_http::label::fmt_string(input_1, false);
            if code_review_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "code_review_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/codereviews/{CodeReviewArn}",
                CodeReviewArn = code_review_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCodeReviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCodeReviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCodeReview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCodeReview",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCodeReviewInput`](crate::input::DescribeCodeReviewInput)
    pub fn builder() -> crate::input::describe_code_review_input::Builder {
        crate::input::describe_code_review_input::Builder::default()
    }
}

/// See [`DescribeRecommendationFeedbackInput`](crate::input::DescribeRecommendationFeedbackInput)
pub mod describe_recommendation_feedback_input {
    /// A builder for [`DescribeRecommendationFeedbackInput`](crate::input::DescribeRecommendationFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p> Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request. </p>
        /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p> Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request. </p>
        /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecommendationFeedbackInput`](crate::input::DescribeRecommendationFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecommendationFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecommendationFeedbackInput {
                code_review_arn: self.code_review_arn,
                recommendation_id: self.recommendation_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecommendationFeedbackInputOperationOutputAlias =
    crate::operation::DescribeRecommendationFeedback;
#[doc(hidden)]
pub type DescribeRecommendationFeedbackInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRecommendationFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecommendationFeedback`](crate::operation::DescribeRecommendationFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecommendationFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecommendationFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.code_review_arn;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_review_arn",
                        details: "cannot be empty or unset",
                    })?;
            let code_review_arn = aws_smithy_http::label::fmt_string(input_2, false);
            if code_review_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "code_review_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/feedback/{CodeReviewArn}",
                CodeReviewArn = code_review_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeRecommendationFeedbackInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.recommendation_id {
                query.push_kv(
                    "RecommendationId",
                    &aws_smithy_http::query::fmt_string(&inner_3),
                );
            }
            if let Some(inner_4) = &_input.user_id {
                query.push_kv("UserId", &aws_smithy_http::query::fmt_string(&inner_4));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecommendationFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecommendationFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecommendationFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecommendationFeedback",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecommendationFeedbackInput`](crate::input::DescribeRecommendationFeedbackInput)
    pub fn builder() -> crate::input::describe_recommendation_feedback_input::Builder {
        crate::input::describe_recommendation_feedback_input::Builder::default()
    }
}

/// See [`DescribeRepositoryAssociationInput`](crate::input::DescribeRepositoryAssociationInput)
pub mod describe_repository_association_input {
    /// A builder for [`DescribeRepositoryAssociationInput`](crate::input::DescribeRepositoryAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn set_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRepositoryAssociationInput`](crate::input::DescribeRepositoryAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRepositoryAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRepositoryAssociationInput {
                association_arn: self.association_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRepositoryAssociationInputOperationOutputAlias =
    crate::operation::DescribeRepositoryAssociation;
#[doc(hidden)]
pub type DescribeRepositoryAssociationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRepositoryAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRepositoryAssociation`](crate::operation::DescribeRepositoryAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRepositoryAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRepositoryAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.association_arn;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "association_arn",
                        details: "cannot be empty or unset",
                    })?;
            let association_arn = aws_smithy_http::label::fmt_string(input_5, false);
            if association_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "association_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/associations/{AssociationArn}",
                AssociationArn = association_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRepositoryAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRepositoryAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRepositoryAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRepositoryAssociation",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRepositoryAssociationInput`](crate::input::DescribeRepositoryAssociationInput)
    pub fn builder() -> crate::input::describe_repository_association_input::Builder {
        crate::input::describe_repository_association_input::Builder::default()
    }
}

/// See [`DisassociateRepositoryInput`](crate::input::DisassociateRepositoryInput)
pub mod disassociate_repository_input {
    /// A builder for [`DisassociateRepositoryInput`](crate::input::DisassociateRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn set_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateRepositoryInput`](crate::input::DisassociateRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateRepositoryInput {
                association_arn: self.association_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateRepositoryInputOperationOutputAlias = crate::operation::DisassociateRepository;
#[doc(hidden)]
pub type DisassociateRepositoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateRepository`](crate::operation::DisassociateRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.association_arn;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "association_arn",
                        details: "cannot be empty or unset",
                    })?;
            let association_arn = aws_smithy_http::label::fmt_string(input_6, false);
            if association_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "association_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/associations/{AssociationArn}",
                AssociationArn = association_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateRepository",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateRepositoryInput`](crate::input::DisassociateRepositoryInput)
    pub fn builder() -> crate::input::disassociate_repository_input::Builder {
        crate::input::disassociate_repository_input::Builder::default()
    }
}

/// See [`ListCodeReviewsInput`](crate::input::ListCodeReviewsInput)
pub mod list_code_reviews_input {
    /// A builder for [`ListCodeReviewsInput`](crate::input::ListCodeReviewsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider_types: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::JobState>>,
        pub(crate) repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provider_types`.
        ///
        /// To override the contents of this collection use [`set_provider_types`](Self::set_provider_types).
        ///
        /// <p> List of provider types for filtering that needs to be applied before displaying the result. For example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub. </p>
        pub fn provider_types(mut self, input: crate::model::ProviderType) -> Self {
            let mut v = self.provider_types.unwrap_or_default();
            v.push(input);
            self.provider_types = Some(v);
            self
        }
        /// <p> List of provider types for filtering that needs to be applied before displaying the result. For example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub. </p>
        pub fn set_provider_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
        ) -> Self {
            self.provider_types = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p> List of states for filtering that needs to be applied before displaying the result. For example, <code>states=[Pending]</code> lists code reviews in the Pending state. </p>
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li> <p> <code>Completed</code>: The code review is complete. </p> </li>
        /// <li> <p> <code>Pending</code>: The code review started and has not completed or failed. </p> </li>
        /// <li> <p> <code>Failed</code>: The code review failed. </p> </li>
        /// <li> <p> <code>Deleting</code>: The code review is being deleted. </p> </li>
        /// </ul>
        pub fn states(mut self, input: crate::model::JobState) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input);
            self.states = Some(v);
            self
        }
        /// <p> List of states for filtering that needs to be applied before displaying the result. For example, <code>states=[Pending]</code> lists code reviews in the Pending state. </p>
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li> <p> <code>Completed</code>: The code review is complete. </p> </li>
        /// <li> <p> <code>Pending</code>: The code review started and has not completed or failed. </p> </li>
        /// <li> <p> <code>Failed</code>: The code review failed. </p> </li>
        /// <li> <p> <code>Deleting</code>: The code review is being deleted. </p> </li>
        /// </ul>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// Appends an item to `repository_names`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p> List of repository names for filtering that needs to be applied before displaying the result. </p>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repository_names.unwrap_or_default();
            v.push(input.into());
            self.repository_names = Some(v);
            self
        }
        /// <p> List of repository names for filtering that needs to be applied before displaying the result. </p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repository_names = input;
            self
        }
        /// <p> The type of code reviews to list in the response. </p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of code reviews to list in the response. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The maximum number of results that are returned per call. The default is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results that are returned per call. The default is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCodeReviewsInput`](crate::input::ListCodeReviewsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCodeReviewsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCodeReviewsInput {
                provider_types: self.provider_types,
                states: self.states,
                repository_names: self.repository_names,
                r#type: self.r#type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCodeReviewsInputOperationOutputAlias = crate::operation::ListCodeReviews;
#[doc(hidden)]
pub type ListCodeReviewsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListCodeReviewsInput {
    /// Consumes the builder and constructs an Operation<[`ListCodeReviews`](crate::operation::ListCodeReviews)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCodeReviews,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCodeReviewsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/codereviews").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListCodeReviewsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.provider_types {
                for inner_8 in inner_7 {
                    query.push_kv(
                        "ProviderTypes",
                        &aws_smithy_http::query::fmt_string(&inner_8),
                    );
                }
            }
            if let Some(inner_9) = &_input.states {
                for inner_10 in inner_9 {
                    query.push_kv("States", &aws_smithy_http::query::fmt_string(&inner_10));
                }
            }
            if let Some(inner_11) = &_input.repository_names {
                for inner_12 in inner_11 {
                    query.push_kv(
                        "RepositoryNames",
                        &aws_smithy_http::query::fmt_string(&inner_12),
                    );
                }
            }
            if let Some(inner_13) = &_input.r#type {
                query.push_kv("Type", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            if let Some(inner_14) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_14).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCodeReviewsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCodeReviewsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCodeReviews::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCodeReviews",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCodeReviewsInput`](crate::input::ListCodeReviewsInput)
    pub fn builder() -> crate::input::list_code_reviews_input::Builder {
        crate::input::list_code_reviews_input::Builder::default()
    }
}

/// See [`ListRecommendationFeedbackInput`](crate::input::ListRecommendationFeedbackInput)
pub mod list_recommendation_feedback_input {
    /// A builder for [`ListRecommendationFeedbackInput`](crate::input::ListRecommendationFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> If <code>nextToken</code> is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If <code>nextToken</code> is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of results that are returned per call. The default is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results that are returned per call. The default is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p> An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user. </p>
        /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p> An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user. </p>
        /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// Appends an item to `recommendation_ids`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p> Used to query the recommendation feedback for a given recommendation. </p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommendation_ids.unwrap_or_default();
            v.push(input.into());
            self.recommendation_ids = Some(v);
            self
        }
        /// <p> Used to query the recommendation feedback for a given recommendation. </p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommendation_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendationFeedbackInput`](crate::input::ListRecommendationFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecommendationFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecommendationFeedbackInput {
                next_token: self.next_token,
                max_results: self.max_results,
                code_review_arn: self.code_review_arn,
                user_ids: self.user_ids,
                recommendation_ids: self.recommendation_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecommendationFeedbackInputOperationOutputAlias =
    crate::operation::ListRecommendationFeedback;
#[doc(hidden)]
pub type ListRecommendationFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRecommendationFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`ListRecommendationFeedback`](crate::operation::ListRecommendationFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecommendationFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecommendationFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.code_review_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_review_arn",
                        details: "cannot be empty or unset",
                    })?;
            let code_review_arn = aws_smithy_http::label::fmt_string(input_16, false);
            if code_review_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "code_review_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/feedback/{CodeReviewArn}/RecommendationFeedback",
                CodeReviewArn = code_review_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRecommendationFeedbackInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_17) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_17));
            }
            if let Some(inner_18) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_18).encode(),
                );
            }
            if let Some(inner_19) = &_input.user_ids {
                for inner_20 in inner_19 {
                    query.push_kv("UserIds", &aws_smithy_http::query::fmt_string(&inner_20));
                }
            }
            if let Some(inner_21) = &_input.recommendation_ids {
                for inner_22 in inner_21 {
                    query.push_kv(
                        "RecommendationIds",
                        &aws_smithy_http::query::fmt_string(&inner_22),
                    );
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecommendationFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecommendationFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecommendationFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecommendationFeedback",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecommendationFeedbackInput`](crate::input::ListRecommendationFeedbackInput)
    pub fn builder() -> crate::input::list_recommendation_feedback_input::Builder {
        crate::input::list_recommendation_feedback_input::Builder::default()
    }
}

/// See [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
pub mod list_recommendations_input {
    /// A builder for [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Pagination token. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Pagination token. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of results that are returned per call. The default is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results that are returned per call. The default is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecommendationsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                code_review_arn: self.code_review_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecommendationsInputOperationOutputAlias = crate::operation::ListRecommendations;
#[doc(hidden)]
pub type ListRecommendationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ListRecommendations`](crate::operation::ListRecommendations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecommendations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.code_review_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_review_arn",
                        details: "cannot be empty or unset",
                    })?;
            let code_review_arn = aws_smithy_http::label::fmt_string(input_23, false);
            if code_review_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "code_review_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/codereviews/{CodeReviewArn}/Recommendations",
                CodeReviewArn = code_review_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRecommendationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_24) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if let Some(inner_25) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_25).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecommendations",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
    pub fn builder() -> crate::input::list_recommendations_input::Builder {
        crate::input::list_recommendations_input::Builder::default()
    }
}

/// See [`ListRepositoryAssociationsInput`](crate::input::ListRepositoryAssociationsInput)
pub mod list_repository_associations_input {
    /// A builder for [`ListRepositoryAssociationsInput`](crate::input::ListRepositoryAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider_types: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
        pub(crate) states:
            std::option::Option<std::vec::Vec<crate::model::RepositoryAssociationState>>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) owners: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provider_types`.
        ///
        /// To override the contents of this collection use [`set_provider_types`](Self::set_provider_types).
        ///
        /// <p>List of provider types to use as a filter.</p>
        pub fn provider_types(mut self, input: crate::model::ProviderType) -> Self {
            let mut v = self.provider_types.unwrap_or_default();
            v.push(input);
            self.provider_types = Some(v);
            self
        }
        /// <p>List of provider types to use as a filter.</p>
        pub fn set_provider_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
        ) -> Self {
            self.provider_types = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>List of repository association states to use as a filter.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li> <p> <b>Associated</b>: The repository association is complete. </p> </li>
        /// <li> <p> <b>Associating</b>: CodeGuru Reviewer is: </p>
        /// <ul>
        /// <li> <p> Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review. </p> <note>
        /// <p> If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered. </p>
        /// </note> </li>
        /// <li> <p> Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository. </p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Failed</b>: The repository failed to associate or disassociate. </p> </li>
        /// <li> <p> <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source code access. </p> </li>
        /// <li> <p> <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association with this repository if you want to review source code in it later. You can control access to code reviews created in an associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>. </p> </li>
        /// </ul>
        pub fn states(mut self, input: crate::model::RepositoryAssociationState) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input);
            self.states = Some(v);
            self
        }
        /// <p>List of repository association states to use as a filter.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li> <p> <b>Associated</b>: The repository association is complete. </p> </li>
        /// <li> <p> <b>Associating</b>: CodeGuru Reviewer is: </p>
        /// <ul>
        /// <li> <p> Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review. </p> <note>
        /// <p> If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered. </p>
        /// </note> </li>
        /// <li> <p> Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository. </p> </li>
        /// </ul> </li>
        /// <li> <p> <b>Failed</b>: The repository failed to associate or disassociate. </p> </li>
        /// <li> <p> <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source code access. </p> </li>
        /// <li> <p> <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association with this repository if you want to review source code in it later. You can control access to code reviews created in an associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>. </p> </li>
        /// </ul>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryAssociationState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>List of repository names to use as a filter.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>List of repository names to use as a filter.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// Appends an item to `owners`.
        ///
        /// To override the contents of this collection use [`set_owners`](Self::set_owners).
        ///
        /// <p>List of owners to use as a filter. For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account that was used to associate the repository. </p>
        pub fn owners(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.owners.unwrap_or_default();
            v.push(input.into());
            self.owners = Some(v);
            self
        }
        /// <p>List of owners to use as a filter. For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account that was used to associate the repository. </p>
        pub fn set_owners(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.owners = input;
            self
        }
        /// <p>The maximum number of repository association results returned by <code>ListRepositoryAssociations</code> in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRepositoryAssociations</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository association results returned by <code>ListRepositoryAssociations</code> in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRepositoryAssociations</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoryAssociationsInput`](crate::input::ListRepositoryAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRepositoryAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRepositoryAssociationsInput {
                provider_types: self.provider_types,
                states: self.states,
                names: self.names,
                owners: self.owners,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRepositoryAssociationsInputOperationOutputAlias =
    crate::operation::ListRepositoryAssociations;
#[doc(hidden)]
pub type ListRepositoryAssociationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRepositoryAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListRepositoryAssociations`](crate::operation::ListRepositoryAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRepositoryAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRepositoryAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/associations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRepositoryAssociationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.provider_types {
                for inner_27 in inner_26 {
                    query.push_kv(
                        "ProviderType",
                        &aws_smithy_http::query::fmt_string(&inner_27),
                    );
                }
            }
            if let Some(inner_28) = &_input.states {
                for inner_29 in inner_28 {
                    query.push_kv("State", &aws_smithy_http::query::fmt_string(&inner_29));
                }
            }
            if let Some(inner_30) = &_input.names {
                for inner_31 in inner_30 {
                    query.push_kv("Name", &aws_smithy_http::query::fmt_string(&inner_31));
                }
            }
            if let Some(inner_32) = &_input.owners {
                for inner_33 in inner_32 {
                    query.push_kv("Owner", &aws_smithy_http::query::fmt_string(&inner_33));
                }
            }
            if let Some(inner_34) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                );
            }
            if let Some(inner_35) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRepositoryAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRepositoryAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRepositoryAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRepositoryAssociations",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRepositoryAssociationsInput`](crate::input::ListRepositoryAssociationsInput)
    pub fn builder() -> crate::input::list_repository_associations_input::Builder {
        crate::input::list_repository_associations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.resource_arn;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_36, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutRecommendationFeedbackInput`](crate::input::PutRecommendationFeedbackInput)
pub mod put_recommendation_feedback_input {
    /// A builder for [`PutRecommendationFeedbackInput`](crate::input::PutRecommendationFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) reactions: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// Appends an item to `reactions`.
        ///
        /// To override the contents of this collection use [`set_reactions`](Self::set_reactions).
        ///
        /// <p> List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback. </p>
        pub fn reactions(mut self, input: crate::model::Reaction) -> Self {
            let mut v = self.reactions.unwrap_or_default();
            v.push(input);
            self.reactions = Some(v);
            self
        }
        /// <p> List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback. </p>
        pub fn set_reactions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
        ) -> Self {
            self.reactions = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecommendationFeedbackInput`](crate::input::PutRecommendationFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRecommendationFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRecommendationFeedbackInput {
                code_review_arn: self.code_review_arn,
                recommendation_id: self.recommendation_id,
                reactions: self.reactions,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRecommendationFeedbackInputOperationOutputAlias =
    crate::operation::PutRecommendationFeedback;
#[doc(hidden)]
pub type PutRecommendationFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutRecommendationFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`PutRecommendationFeedback`](crate::operation::PutRecommendationFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRecommendationFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRecommendationFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/feedback").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRecommendationFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRecommendationFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_recommendation_feedback(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRecommendationFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRecommendationFeedback",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRecommendationFeedbackInput`](crate::input::PutRecommendationFeedbackInput)
    pub fn builder() -> crate::input::put_recommendation_feedback_input::Builder {
        crate::input::put_recommendation_feedback_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
        /// <ul>
        /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
        /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
        /// <ul>
        /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
        /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.resource_arn;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_37, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys for each tag you want to remove from an associated repository.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of the keys for each tag you want to remove from an associated repository.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.resource_arn;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_38, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.tag_keys {
                for inner_40 in inner_39 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_40));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "codegurureviewer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the keys for each tag you want to remove from an associated repository.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the keys for each tag you want to remove from an associated repository.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
    /// <ul>
    /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
    /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
    /// <ul>
    /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
    /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecommendationFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub code_review_arn: std::option::Option<std::string::String>,
    /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p> List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback. </p>
    pub reactions: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
}
impl PutRecommendationFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub fn code_review_arn(&self) -> std::option::Option<&str> {
        self.code_review_arn.as_deref()
    }
    /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p> List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback. </p>
    pub fn reactions(&self) -> std::option::Option<&[crate::model::Reaction]> {
        self.reactions.as_deref()
    }
}
impl std::fmt::Debug for PutRecommendationFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecommendationFeedbackInput");
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("reactions", &self.reactions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoryAssociationsInput {
    /// <p>List of provider types to use as a filter.</p>
    pub provider_types: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
    /// <p>List of repository association states to use as a filter.</p>
    /// <p>The valid repository association states are:</p>
    /// <ul>
    /// <li> <p> <b>Associated</b>: The repository association is complete. </p> </li>
    /// <li> <p> <b>Associating</b>: CodeGuru Reviewer is: </p>
    /// <ul>
    /// <li> <p> Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review. </p> <note>
    /// <p> If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered. </p>
    /// </note> </li>
    /// <li> <p> Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository. </p> </li>
    /// </ul> </li>
    /// <li> <p> <b>Failed</b>: The repository failed to associate or disassociate. </p> </li>
    /// <li> <p> <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source code access. </p> </li>
    /// <li> <p> <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association with this repository if you want to review source code in it later. You can control access to code reviews created in an associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>. </p> </li>
    /// </ul>
    pub states: std::option::Option<std::vec::Vec<crate::model::RepositoryAssociationState>>,
    /// <p>List of repository names to use as a filter.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of owners to use as a filter. For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account that was used to associate the repository. </p>
    pub owners: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of repository association results returned by <code>ListRepositoryAssociations</code> in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRepositoryAssociations</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
    /// <p>Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRepositoryAssociationsInput {
    /// <p>List of provider types to use as a filter.</p>
    pub fn provider_types(&self) -> std::option::Option<&[crate::model::ProviderType]> {
        self.provider_types.as_deref()
    }
    /// <p>List of repository association states to use as a filter.</p>
    /// <p>The valid repository association states are:</p>
    /// <ul>
    /// <li> <p> <b>Associated</b>: The repository association is complete. </p> </li>
    /// <li> <p> <b>Associating</b>: CodeGuru Reviewer is: </p>
    /// <ul>
    /// <li> <p> Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review. </p> <note>
    /// <p> If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered. </p>
    /// </note> </li>
    /// <li> <p> Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository. </p> </li>
    /// </ul> </li>
    /// <li> <p> <b>Failed</b>: The repository failed to associate or disassociate. </p> </li>
    /// <li> <p> <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source code access. </p> </li>
    /// <li> <p> <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association with this repository if you want to review source code in it later. You can control access to code reviews created in an associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>. </p> </li>
    /// </ul>
    pub fn states(&self) -> std::option::Option<&[crate::model::RepositoryAssociationState]> {
        self.states.as_deref()
    }
    /// <p>List of repository names to use as a filter.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>List of owners to use as a filter. For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account that was used to associate the repository. </p>
    pub fn owners(&self) -> std::option::Option<&[std::string::String]> {
        self.owners.as_deref()
    }
    /// <p>The maximum number of repository association results returned by <code>ListRepositoryAssociations</code> in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRepositoryAssociations</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
    /// <p>Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRepositoryAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoryAssociationsInput");
        formatter.field("provider_types", &self.provider_types);
        formatter.field("states", &self.states);
        formatter.field("names", &self.names);
        formatter.field("owners", &self.owners);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendationsInput {
    /// <p> Pagination token. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of results that are returned per call. The default is 100. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub code_review_arn: std::option::Option<std::string::String>,
}
impl ListRecommendationsInput {
    /// <p> Pagination token. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of results that are returned per call. The default is 100. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub fn code_review_arn(&self) -> std::option::Option<&str> {
        self.code_review_arn.as_deref()
    }
}
impl std::fmt::Debug for ListRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendationFeedbackInput {
    /// <p> If <code>nextToken</code> is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of results that are returned per call. The default is 100. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub code_review_arn: std::option::Option<std::string::String>,
    /// <p> An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user. </p>
    /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Used to query the recommendation feedback for a given recommendation. </p>
    pub recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListRecommendationFeedbackInput {
    /// <p> If <code>nextToken</code> is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of results that are returned per call. The default is 100. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub fn code_review_arn(&self) -> std::option::Option<&str> {
        self.code_review_arn.as_deref()
    }
    /// <p> An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user. </p>
    /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p> Used to query the recommendation feedback for a given recommendation. </p>
    pub fn recommendation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.recommendation_ids.as_deref()
    }
}
impl std::fmt::Debug for ListRecommendationFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendationFeedbackInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("recommendation_ids", &self.recommendation_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCodeReviewsInput {
    /// <p> List of provider types for filtering that needs to be applied before displaying the result. For example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub. </p>
    pub provider_types: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
    /// <p> List of states for filtering that needs to be applied before displaying the result. For example, <code>states=[Pending]</code> lists code reviews in the Pending state. </p>
    /// <p>The valid code review states are:</p>
    /// <ul>
    /// <li> <p> <code>Completed</code>: The code review is complete. </p> </li>
    /// <li> <p> <code>Pending</code>: The code review started and has not completed or failed. </p> </li>
    /// <li> <p> <code>Failed</code>: The code review failed. </p> </li>
    /// <li> <p> <code>Deleting</code>: The code review is being deleted. </p> </li>
    /// </ul>
    pub states: std::option::Option<std::vec::Vec<crate::model::JobState>>,
    /// <p> List of repository names for filtering that needs to be applied before displaying the result. </p>
    pub repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The type of code reviews to list in the response. </p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p> The maximum number of results that are returned per call. The default is 100. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCodeReviewsInput {
    /// <p> List of provider types for filtering that needs to be applied before displaying the result. For example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub. </p>
    pub fn provider_types(&self) -> std::option::Option<&[crate::model::ProviderType]> {
        self.provider_types.as_deref()
    }
    /// <p> List of states for filtering that needs to be applied before displaying the result. For example, <code>states=[Pending]</code> lists code reviews in the Pending state. </p>
    /// <p>The valid code review states are:</p>
    /// <ul>
    /// <li> <p> <code>Completed</code>: The code review is complete. </p> </li>
    /// <li> <p> <code>Pending</code>: The code review started and has not completed or failed. </p> </li>
    /// <li> <p> <code>Failed</code>: The code review failed. </p> </li>
    /// <li> <p> <code>Deleting</code>: The code review is being deleted. </p> </li>
    /// </ul>
    pub fn states(&self) -> std::option::Option<&[crate::model::JobState]> {
        self.states.as_deref()
    }
    /// <p> List of repository names for filtering that needs to be applied before displaying the result. </p>
    pub fn repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.repository_names.as_deref()
    }
    /// <p> The type of code reviews to list in the response. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p> The maximum number of results that are returned per call. The default is 100. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCodeReviewsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCodeReviewsInput");
        formatter.field("provider_types", &self.provider_types);
        formatter.field("states", &self.states);
        formatter.field("repository_names", &self.repository_names);
        formatter.field("r#type", &self.r#type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateRepositoryInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub association_arn: std::option::Option<std::string::String>,
}
impl DisassociateRepositoryInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub fn association_arn(&self) -> std::option::Option<&str> {
        self.association_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateRepositoryInput");
        formatter.field("association_arn", &self.association_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRepositoryAssociationInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub association_arn: std::option::Option<std::string::String>,
}
impl DescribeRepositoryAssociationInput {
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    pub fn association_arn(&self) -> std::option::Option<&str> {
        self.association_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeRepositoryAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRepositoryAssociationInput");
        formatter.field("association_arn", &self.association_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecommendationFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub code_review_arn: std::option::Option<std::string::String>,
    /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p> Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request. </p>
    /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
    pub user_id: std::option::Option<std::string::String>,
}
impl DescribeRecommendationFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub fn code_review_arn(&self) -> std::option::Option<&str> {
        self.code_review_arn.as_deref()
    }
    /// <p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p> Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request. </p>
    /// <p> The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>. </p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecommendationFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecommendationFeedbackInput");
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCodeReviewInput {
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub code_review_arn: std::option::Option<std::string::String>,
}
impl DescribeCodeReviewInput {
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>
    pub fn code_review_arn(&self) -> std::option::Option<&str> {
        self.code_review_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCodeReviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCodeReviewInput");
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCodeReviewInput {
    /// <p> The name of the code review. The name of each code review in your Amazon Web Services account must be unique. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    /// <p> A code review can only be created on an associated repository. This is the ARN of the associated repository. </p>
    pub repository_association_arn: std::option::Option<std::string::String>,
    /// <p> The type of code review to create. This is specified using a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html"> <code>CodeReviewType</code> </a> object. You can create a code review only of type <code>RepositoryAnalysis</code>. </p>
    pub r#type: std::option::Option<crate::model::CodeReviewType>,
    /// <p> Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there are failures and retries. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl CreateCodeReviewInput {
    /// <p> The name of the code review. The name of each code review in your Amazon Web Services account must be unique. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a>. </p>
    /// <p> A code review can only be created on an associated repository. This is the ARN of the associated repository. </p>
    pub fn repository_association_arn(&self) -> std::option::Option<&str> {
        self.repository_association_arn.as_deref()
    }
    /// <p> The type of code review to create. This is specified using a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html"> <code>CodeReviewType</code> </a> object. You can create a code review only of type <code>RepositoryAnalysis</code>. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CodeReviewType> {
        self.r#type.as_ref()
    }
    /// <p> Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there are failures and retries. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for CreateCodeReviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCodeReviewInput");
        formatter.field("name", &self.name);
        formatter.field(
            "repository_association_arn",
            &self.repository_association_arn,
        );
        formatter.field("r#type", &self.r#type);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateRepositoryInput {
    /// <p>The repository to associate.</p>
    pub repository: std::option::Option<crate::model::Repository>,
    /// <p>Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries. </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
    /// <ul>
    /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
    /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
    /// <ul>
    /// <li> <p>The encryption option for this repository association. It is either owned by Amazon Web Services Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p> </li>
    /// <li> <p>The ID of the Amazon Web Services KMS key that is associated with this respository association.</p> </li>
    /// </ul>
    pub kms_key_details: std::option::Option<crate::model::KmsKeyDetails>,
}
impl AssociateRepositoryInput {
    /// <p>The repository to associate.</p>
    pub fn repository(&self) -> std::option::Option<&crate::model::Repository> {
        self.repository.as_ref()
    }
    /// <p>Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p> An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts: </p>
    /// <ul>
    /// <li> <p>A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag keys are case sensitive.</p> </li>
    /// <li> <p>An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
    /// <ul>
    /// <li> <p>The encryption option for this repository association. It is either owned by Amazon Web Services Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p> </li>
    /// <li> <p>The ID of the Amazon Web Services KMS key that is associated with this respository association.</p> </li>
    /// </ul>
    pub fn kms_key_details(&self) -> std::option::Option<&crate::model::KmsKeyDetails> {
        self.kms_key_details.as_ref()
    }
}
impl std::fmt::Debug for AssociateRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateRepositoryInput");
        formatter.field("repository", &self.repository);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_details", &self.kms_key_details);
        formatter.finish()
    }
}
