// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSGuruFrontendService`.
///
/// This client allows ergonomic access to a `AWSGuruFrontendService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateRepository` operation.
    ///
    /// See [`AssociateRepository`](crate::client::fluent_builders::AssociateRepository) for more information about the
    /// operation and its arguments.
    pub fn associate_repository(&self) -> fluent_builders::AssociateRepository<C, M, R> {
        fluent_builders::AssociateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCodeReview` operation.
    ///
    /// See [`CreateCodeReview`](crate::client::fluent_builders::CreateCodeReview) for more information about the
    /// operation and its arguments.
    pub fn create_code_review(&self) -> fluent_builders::CreateCodeReview<C, M, R> {
        fluent_builders::CreateCodeReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCodeReview` operation.
    ///
    /// See [`DescribeCodeReview`](crate::client::fluent_builders::DescribeCodeReview) for more information about the
    /// operation and its arguments.
    pub fn describe_code_review(&self) -> fluent_builders::DescribeCodeReview<C, M, R> {
        fluent_builders::DescribeCodeReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecommendationFeedback` operation.
    ///
    /// See [`DescribeRecommendationFeedback`](crate::client::fluent_builders::DescribeRecommendationFeedback) for more information about the
    /// operation and its arguments.
    pub fn describe_recommendation_feedback(
        &self,
    ) -> fluent_builders::DescribeRecommendationFeedback<C, M, R> {
        fluent_builders::DescribeRecommendationFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRepositoryAssociation` operation.
    ///
    /// See [`DescribeRepositoryAssociation`](crate::client::fluent_builders::DescribeRepositoryAssociation) for more information about the
    /// operation and its arguments.
    pub fn describe_repository_association(
        &self,
    ) -> fluent_builders::DescribeRepositoryAssociation<C, M, R> {
        fluent_builders::DescribeRepositoryAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateRepository` operation.
    ///
    /// See [`DisassociateRepository`](crate::client::fluent_builders::DisassociateRepository) for more information about the
    /// operation and its arguments.
    pub fn disassociate_repository(&self) -> fluent_builders::DisassociateRepository<C, M, R> {
        fluent_builders::DisassociateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCodeReviews` operation.
    ///
    /// See [`ListCodeReviews`](crate::client::fluent_builders::ListCodeReviews) for more information about the
    /// operation and its arguments.
    pub fn list_code_reviews(&self) -> fluent_builders::ListCodeReviews<C, M, R> {
        fluent_builders::ListCodeReviews::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecommendationFeedback` operation.
    ///
    /// See [`ListRecommendationFeedback`](crate::client::fluent_builders::ListRecommendationFeedback) for more information about the
    /// operation and its arguments.
    pub fn list_recommendation_feedback(
        &self,
    ) -> fluent_builders::ListRecommendationFeedback<C, M, R> {
        fluent_builders::ListRecommendationFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecommendations` operation.
    ///
    /// See [`ListRecommendations`](crate::client::fluent_builders::ListRecommendations) for more information about the
    /// operation and its arguments.
    pub fn list_recommendations(&self) -> fluent_builders::ListRecommendations<C, M, R> {
        fluent_builders::ListRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRepositoryAssociations` operation.
    ///
    /// See [`ListRepositoryAssociations`](crate::client::fluent_builders::ListRepositoryAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_repository_associations(
        &self,
    ) -> fluent_builders::ListRepositoryAssociations<C, M, R> {
        fluent_builders::ListRepositoryAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRecommendationFeedback` operation.
    ///
    /// See [`PutRecommendationFeedback`](crate::client::fluent_builders::PutRecommendationFeedback) for more information about the
    /// operation and its arguments.
    pub fn put_recommendation_feedback(
        &self,
    ) -> fluent_builders::PutRecommendationFeedback<C, M, R> {
        fluent_builders::PutRecommendationFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateRepository`.
    ///
    /// <p>
    /// Use to associate an Amazon Web Services CodeCommit repository or a repostory managed by
    /// Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a
    /// repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides
    /// automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html">Recommendations in
    /// Amazon CodeGuru Reviewer</a> in the <i>Amazon CodeGuru Reviewer User Guide.</i>
    /// </p>
    ///
    /// <p>If you associate a CodeCommit or S3 repository, it must be in the same
    /// Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.</p>
    ///
    /// <p>Bitbucket and GitHub Enterprise Server repositories are managed by Amazon Web Services CodeStar
    /// Connections to connect to CodeGuru Reviewer. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-associate-repository.html">Associate a repository</a> in
    /// the <i>Amazon CodeGuru Reviewer User Guide.</i>
    /// </p>
    ///
    /// <note>
    /// <p>
    /// You cannot use the CodeGuru Reviewer SDK or the Amazon Web Services CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate
    /// a GitHub repository, use the console. For more information, see
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html">Getting
    /// started with CodeGuru Reviewer</a> in the <i>CodeGuru Reviewer User Guide.</i>
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AssociateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_repository_input::Builder,
    }
    impl<C, M, R> AssociateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateRepositoryInputOperationOutputAlias,
                crate::output::AssociateRepositoryOutput,
                crate::error::AssociateRepositoryError,
                crate::input::AssociateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository to associate.</p>
        pub fn repository(mut self, inp: crate::model::Repository) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>The repository to associate.</p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::Repository>,
        ) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
        /// associations if there are failures and retries. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
        /// associations if there are failures and retries. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>A <i>tag key</i> (for example, <code>CostCenter</code>,
        /// <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag
        /// keys are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>An optional field known as a <i>tag value</i> (for example,
        /// <code>111122223333</code>, <code>Production</code>, or a team name).
        /// Omitting the tag value is the same as using an empty string. Like tag keys, tag
        /// values are case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>A <i>tag key</i> (for example, <code>CostCenter</code>,
        /// <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag
        /// keys are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>An optional field known as a <i>tag value</i> (for example,
        /// <code>111122223333</code>, <code>Production</code>, or a team name).
        /// Omitting the tag value is the same as using an empty string. Like tag keys, tag
        /// values are case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
        /// <ul>
        /// <li>
        /// <p>The encryption option for this repository association. It is either owned by Amazon Web Services
        /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
        /// </li>
        /// <li>
        /// <p>The ID of the Amazon Web Services KMS key that
        /// is associated with this respository association.</p>
        /// </li>
        /// </ul>
        pub fn kms_key_details(mut self, inp: crate::model::KmsKeyDetails) -> Self {
            self.inner = self.inner.kms_key_details(inp);
            self
        }
        /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
        /// <ul>
        /// <li>
        /// <p>The encryption option for this repository association. It is either owned by Amazon Web Services
        /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
        /// </li>
        /// <li>
        /// <p>The ID of the Amazon Web Services KMS key that
        /// is associated with this respository association.</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_details(
            mut self,
            input: std::option::Option<crate::model::KmsKeyDetails>,
        ) -> Self {
            self.inner = self.inner.set_kms_key_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCodeReview`.
    ///
    /// <p>
    /// Use to create a code review with a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
    /// <code>CodeReviewType</code>
    /// </a>
    /// of <code>RepositoryAnalysis</code>. This type of code review analyzes all code under a specified branch in an associated repository.
    /// <code>PullRequest</code> code reviews are automatically triggered by a pull request.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCodeReview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_code_review_input::Builder,
    }
    impl<C, M, R> CreateCodeReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCodeReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCodeReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCodeReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCodeReviewInputOperationOutputAlias,
                crate::output::CreateCodeReviewOutput,
                crate::error::CreateCodeReviewError,
                crate::input::CreateCodeReviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        /// <p>
        /// A code review can only be created on an associated repository. This is the ARN of the
        /// associated repository.
        /// </p>
        pub fn repository_association_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_association_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        /// <p>
        /// A code review can only be created on an associated repository. This is the ARN of the
        /// associated repository.
        /// </p>
        pub fn set_repository_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_association_arn(input);
            self
        }
        /// <p>
        /// The type of code review to create. This is specified using a
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
        /// <code>CodeReviewType</code>
        /// </a>
        /// object. You can create a code review only of type <code>RepositoryAnalysis</code>.
        /// </p>
        pub fn r#type(mut self, inp: crate::model::CodeReviewType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>
        /// The type of code review to create. This is specified using a
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
        /// <code>CodeReviewType</code>
        /// </a>
        /// object. You can create a code review only of type <code>RepositoryAnalysis</code>.
        /// </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CodeReviewType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>
        /// Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code
        /// reviews if there are failures and retries.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code
        /// reviews if there are failures and retries.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCodeReview`.
    ///
    /// <p> Returns the metadata associated with the code review along with its status.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCodeReview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_code_review_input::Builder,
    }
    impl<C, M, R> DescribeCodeReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCodeReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCodeReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCodeReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCodeReviewInputOperationOutputAlias,
                crate::output::DescribeCodeReviewOutput,
                crate::error::DescribeCodeReviewError,
                crate::input::DescribeCodeReviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_review_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_review_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecommendationFeedback`.
    ///
    /// <p>
    /// Describes the customer feedback for a CodeGuru Reviewer recommendation.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRecommendationFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_recommendation_feedback_input::Builder,
    }
    impl<C, M, R> DescribeRecommendationFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecommendationFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecommendationFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecommendationFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecommendationFeedbackInputOperationOutputAlias,
                crate::output::DescribeRecommendationFeedbackOutput,
                crate::error::DescribeRecommendationFeedbackError,
                crate::input::DescribeRecommendationFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_review_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_review_arn(input);
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations and then to collect the feedback.
        /// </p>
        pub fn recommendation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommendation_id(inp);
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations and then to collect the feedback.
        /// </p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_id(input);
            self
        }
        /// <p>
        /// Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>
        /// Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRepositoryAssociation`.
    ///
    /// <p>
    /// Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
    /// <code>RepositoryAssociation</code>
    /// </a> object
    /// that contains information about the requested repository association.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRepositoryAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_repository_association_input::Builder,
    }
    impl<C, M, R> DescribeRepositoryAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRepositoryAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRepositoryAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRepositoryAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRepositoryAssociationInputOperationOutputAlias,
                crate::output::DescribeRepositoryAssociationOutput,
                crate::error::DescribeRepositoryAssociationError,
                crate::input::DescribeRepositoryAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn association_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn set_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateRepository`.
    ///
    /// <p>Removes the association between Amazon CodeGuru Reviewer and a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_repository_input::Builder,
    }
    impl<C, M, R> DisassociateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateRepositoryInputOperationOutputAlias,
                crate::output::DisassociateRepositoryOutput,
                crate::error::DisassociateRepositoryError,
                crate::input::DisassociateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn association_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn set_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCodeReviews`.
    ///
    /// <p>
    /// Lists all the code reviews that the customer has created in the past 90 days.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListCodeReviews<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_code_reviews_input::Builder,
    }
    impl<C, M, R> ListCodeReviews<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCodeReviews`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCodeReviewsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCodeReviewsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCodeReviewsInputOperationOutputAlias,
                crate::output::ListCodeReviewsOutput,
                crate::error::ListCodeReviewsError,
                crate::input::ListCodeReviewsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ProviderTypes`.
        ///
        /// To override the contents of this collection use [`set_provider_types`](Self::set_provider_types).
        ///
        /// <p>
        /// List of provider types for filtering that needs to be applied before displaying the result. For example, <code>providerTypes=[GitHub]</code>  lists code reviews from GitHub.
        /// </p>
        pub fn provider_types(mut self, inp: impl Into<crate::model::ProviderType>) -> Self {
            self.inner = self.inner.provider_types(inp);
            self
        }
        /// <p>
        /// List of provider types for filtering that needs to be applied before displaying the result. For example, <code>providerTypes=[GitHub]</code>  lists code reviews from GitHub.
        /// </p>
        pub fn set_provider_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
        ) -> Self {
            self.inner = self.inner.set_provider_types(input);
            self
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>
        /// List of states for filtering that needs to be applied before displaying the result. For example, <code>states=[Pending]</code> lists code reviews in the Pending state.
        /// </p>
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <code>Completed</code>: The code review is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Pending</code>: The code review started and has not completed or failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: The code review failed.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: The code review is being deleted.
        /// </p>
        /// </li>
        /// </ul>
        pub fn states(mut self, inp: impl Into<crate::model::JobState>) -> Self {
            self.inner = self.inner.states(inp);
            self
        }
        /// <p>
        /// List of states for filtering that needs to be applied before displaying the result. For example, <code>states=[Pending]</code> lists code reviews in the Pending state.
        /// </p>
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <code>Completed</code>: The code review is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Pending</code>: The code review started and has not completed or failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: The code review failed.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: The code review is being deleted.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// Appends an item to `RepositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>
        /// List of repository names for filtering that needs to be applied before displaying the result.
        /// </p>
        pub fn repository_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(inp);
            self
        }
        /// <p>
        /// List of repository names for filtering that needs to be applied before displaying the result.
        /// </p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
        /// <p>
        /// The type of code reviews to list in the response.
        /// </p>
        pub fn r#type(mut self, inp: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>
        /// The type of code reviews to list in the response.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>
        /// The maximum number of results that are returned per call. The default is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results that are returned per call. The default is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommendationFeedback`.
    ///
    /// <p>
    /// Returns a list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html">
    /// <code>RecommendationFeedbackSummary</code>
    /// </a>
    /// objects that contain customer recommendation feedback for all CodeGuru Reviewer users.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecommendationFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recommendation_feedback_input::Builder,
    }
    impl<C, M, R> ListRecommendationFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecommendationFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendationFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendationFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecommendationFeedbackInputOperationOutputAlias,
                crate::output::ListRecommendationFeedbackOutput,
                crate::error::ListRecommendationFeedbackError,
                crate::input::ListRecommendationFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// If <code>nextToken</code> is returned, there are more results available. The value of nextToken is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// If <code>nextToken</code> is returned, there are more results available. The value of nextToken is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// The maximum number of results that are returned per call. The default is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results that are returned per call. The default is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_review_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_review_arn(input);
            self
        }
        /// Appends an item to `UserIds`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>
        /// An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn user_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_ids(inp);
            self
        }
        /// <p>
        /// An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_ids(input);
            self
        }
        /// Appends an item to `RecommendationIds`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>
        /// Used to query the recommendation feedback for a given recommendation.
        /// </p>
        pub fn recommendation_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommendation_ids(inp);
            self
        }
        /// <p>
        /// Used to query the recommendation feedback for a given recommendation.
        /// </p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommendations`.
    ///
    /// <p>
    /// Returns the list of all recommendations for a completed code review.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recommendations_input::Builder,
    }
    impl<C, M, R> ListRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecommendationsInputOperationOutputAlias,
                crate::output::ListRecommendationsOutput,
                crate::error::ListRecommendationsError,
                crate::input::ListRecommendationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Pagination token.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// Pagination token.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// The maximum number of results that are returned per call. The default is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results that are returned per call. The default is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_review_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_review_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositoryAssociations`.
    ///
    /// <p>
    /// Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html">
    /// <code>RepositoryAssociationSummary</code>
    /// </a> objects that
    /// contain summary information about a repository association. You can filter the returned list by
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType">
    /// <code>ProviderType</code>
    /// </a>,
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name">
    /// <code>Name</code>
    /// </a>,
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State">
    /// <code>State</code>
    /// </a>, and
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner">
    /// <code>Owner</code>
    /// </a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRepositoryAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repository_associations_input::Builder,
    }
    impl<C, M, R> ListRepositoryAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositoryAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoryAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoryAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoryAssociationsInputOperationOutputAlias,
                crate::output::ListRepositoryAssociationsOutput,
                crate::error::ListRepositoryAssociationsError,
                crate::input::ListRepositoryAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ProviderTypes`.
        ///
        /// To override the contents of this collection use [`set_provider_types`](Self::set_provider_types).
        ///
        /// <p>List of provider types to use as a filter.</p>
        pub fn provider_types(mut self, inp: impl Into<crate::model::ProviderType>) -> Self {
            self.inner = self.inner.provider_types(inp);
            self
        }
        /// <p>List of provider types to use as a filter.</p>
        pub fn set_provider_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProviderType>>,
        ) -> Self {
            self.inner = self.inner.set_provider_types(input);
            self
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>List of repository association states to use as a filter.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <b>Associated</b>: The repository
        /// association is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Associating</b>: CodeGuru Reviewer is:               
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting up pull request notifications. This is required
        /// for pull requests to trigger a CodeGuru Reviewer review.
        /// </p>
        /// <note>
        /// <p>
        /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
        /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
        /// reviews of code in your repository cannot be triggered.
        /// </p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// Setting up source code access. This is required for CodeGuru Reviewer to securely
        /// clone code in your repository.
        /// </p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Failed</b>: The repository failed to associate or disassociate.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
        /// source code access.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
        /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
        /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
        /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn states(mut self, inp: impl Into<crate::model::RepositoryAssociationState>) -> Self {
            self.inner = self.inner.states(inp);
            self
        }
        /// <p>List of repository association states to use as a filter.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <b>Associated</b>: The repository
        /// association is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Associating</b>: CodeGuru Reviewer is:               
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting up pull request notifications. This is required
        /// for pull requests to trigger a CodeGuru Reviewer review.
        /// </p>
        /// <note>
        /// <p>
        /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
        /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
        /// reviews of code in your repository cannot be triggered.
        /// </p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// Setting up source code access. This is required for CodeGuru Reviewer to securely
        /// clone code in your repository.
        /// </p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Failed</b>: The repository failed to associate or disassociate.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
        /// source code access.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
        /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
        /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
        /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryAssociationState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>List of repository names to use as a filter.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>List of repository names to use as a filter.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// Appends an item to `Owners`.
        ///
        /// To override the contents of this collection use [`set_owners`](Self::set_owners).
        ///
        /// <p>List of owners to use as a filter.
        /// For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was
        /// used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account
        /// that was used to associate the repository. </p>
        pub fn owners(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owners(inp);
            self
        }
        /// <p>List of owners to use as a filter.
        /// For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was
        /// used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account
        /// that was used to associate the repository. </p>
        pub fn set_owners(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_owners(input);
            self
        }
        /// <p>The maximum number of repository association results returned by <code>ListRepositoryAssociations</code>
        /// in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns
        /// <code>maxResults</code> results in a single page with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListRepositoryAssociations</code> request with the returned
        /// <code>nextToken</code> value.
        /// This value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code>
        /// returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository association results returned by <code>ListRepositoryAssociations</code>
        /// in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns
        /// <code>maxResults</code> results in a single page with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListRepositoryAssociations</code> request with the returned
        /// <code>nextToken</code> value.
        /// This value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code>
        /// returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous results
        /// that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>Treat this token as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous results
        /// that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>Treat this token as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns the list of tags associated with an associated repository resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRecommendationFeedback`.
    ///
    /// <p>
    /// Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct PutRecommendationFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_recommendation_feedback_input::Builder,
    }
    impl<C, M, R> PutRecommendationFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRecommendationFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRecommendationFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRecommendationFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRecommendationFeedbackInputOperationOutputAlias,
                crate::output::PutRecommendationFeedbackOutput,
                crate::error::PutRecommendationFeedbackError,
                crate::input::PutRecommendationFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_review_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_review_arn(input);
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations and then to collect the feedback.
        /// </p>
        pub fn recommendation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommendation_id(inp);
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations and then to collect the feedback.
        /// </p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_id(input);
            self
        }
        /// Appends an item to `Reactions`.
        ///
        /// To override the contents of this collection use [`set_reactions`](Self::set_reactions).
        ///
        /// <p>
        /// List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback.
        /// </p>
        pub fn reactions(mut self, inp: impl Into<crate::model::Reaction>) -> Self {
            self.inner = self.inner.reactions(inp);
            self
        }
        /// <p>
        /// List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback.
        /// </p>
        pub fn set_reactions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
        ) -> Self {
            self.inner = self.inner.set_reactions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to an associated repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>A <i>tag key</i> (for example, <code>CostCenter</code>,
        /// <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag
        /// keys are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>An optional field known as a <i>tag value</i> (for example,
        /// <code>111122223333</code>, <code>Production</code>, or a team name).
        /// Omitting the tag value is the same as using an empty string. Like tag keys, tag
        /// values are case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>A <i>tag key</i> (for example, <code>CostCenter</code>,
        /// <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag
        /// keys are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>An optional field known as a <i>tag value</i> (for example,
        /// <code>111122223333</code>, <code>Production</code>, or a team name).
        /// Omitting the tag value is the same as using an empty string. Like tag keys, tag
        /// values are case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from an associated repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys for each tag you want to remove from an associated repository.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of the keys for each tag you want to remove from an associated repository.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
