// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Reaction {
    #[allow(missing_docs)] // documentation missing in model
    ThumbsDown,
    #[allow(missing_docs)] // documentation missing in model
    ThumbsUp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Reaction {
    fn from(s: &str) -> Self {
        match s {
            "ThumbsDown" => Reaction::ThumbsDown,
            "ThumbsUp" => Reaction::ThumbsUp,
            other => Reaction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Reaction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Reaction::from(s))
    }
}
impl Reaction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Reaction::ThumbsDown => "ThumbsDown",
            Reaction::ThumbsUp => "ThumbsUp",
            Reaction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ThumbsDown", "ThumbsUp"]
    }
}
impl AsRef<str> for Reaction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a repository association. The
/// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
/// <code>ListRepositoryAssociations</code>
/// </a>
/// operation returns a list of <code>RepositoryAssociationSummary</code> objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryAssociationSummary {
    /// <p>
    /// The Amazon Resource Name (ARN) of the  
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
    /// <code>RepositoryAssociation</code>
    /// </a> object.
    /// You can retrieve this ARN by calling
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
    /// <code>ListRepositoryAssociations</code>
    /// </a>.
    /// </p>
    pub association_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
    /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
    /// <code>Connection</code>
    /// </a> in
    /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
    /// </p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, since the repository association
    /// was last updated.
    /// </p>
    pub last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The repository association ID.
    /// </p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository association.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
    /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
    /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The provider type of the repository association.</p>
    pub provider_type: std::option::Option<crate::model::ProviderType>,
    /// <p>The state of the repository association.</p>
    /// <p>The valid repository association states are:</p>
    /// <ul>
    /// <li>            
    /// <p>
    /// <b>Associated</b>: The repository
    /// association is complete.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <b>Associating</b>: CodeGuru Reviewer is:               
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// Setting up pull request notifications. This is required
    /// for pull requests to trigger a CodeGuru Reviewer review.
    /// </p>
    /// <note>
    /// <p>
    /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
    /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
    /// reviews of code in your repository cannot be triggered.
    /// </p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// Setting up source code access. This is required for CodeGuru Reviewer to securely
    /// clone code in your repository.
    /// </p>
    /// </li>
    /// </ul>            
    /// </li>
    /// <li>
    /// <p>
    /// <b>Failed</b>: The repository failed to associate or disassociate.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
    /// source code access.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
    /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
    /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
    /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
    /// </p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::RepositoryAssociationState>,
}
impl std::fmt::Debug for RepositoryAssociationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryAssociationSummary");
        formatter.field("association_arn", &self.association_arn);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("last_updated_time_stamp", &self.last_updated_time_stamp);
        formatter.field("association_id", &self.association_id);
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`RepositoryAssociationSummary`](crate::model::RepositoryAssociationSummary)
pub mod repository_association_summary {
    /// A builder for [`RepositoryAssociationSummary`](crate::model::RepositoryAssociationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_arn: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::ProviderType>,
        pub(crate) state: std::option::Option<crate::model::RepositoryAssociationState>,
    }
    impl Builder {
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> object.
        /// You can retrieve this ARN by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn set_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_arn = input;
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
        /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
        /// <code>Connection</code>
        /// </a> in
        /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
        /// </p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
        /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
        /// <code>Connection</code>
        /// </a> in
        /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
        /// </p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, since the repository association
        /// was last updated.
        /// </p>
        pub fn last_updated_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time_stamp = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, since the repository association
        /// was last updated.
        /// </p>
        pub fn set_last_updated_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time_stamp = input;
            self
        }
        /// <p>
        /// The repository association ID.
        /// </p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>
        /// The repository association ID.
        /// </p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The name of the repository association.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the repository association.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The provider type of the repository association.</p>
        pub fn provider_type(mut self, input: crate::model::ProviderType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>The provider type of the repository association.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// <p>The state of the repository association.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <b>Associated</b>: The repository
        /// association is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Associating</b>: CodeGuru Reviewer is:               
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting up pull request notifications. This is required
        /// for pull requests to trigger a CodeGuru Reviewer review.
        /// </p>
        /// <note>
        /// <p>
        /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
        /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
        /// reviews of code in your repository cannot be triggered.
        /// </p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// Setting up source code access. This is required for CodeGuru Reviewer to securely
        /// clone code in your repository.
        /// </p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Failed</b>: The repository failed to associate or disassociate.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
        /// source code access.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
        /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
        /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
        /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::RepositoryAssociationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the repository association.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <b>Associated</b>: The repository
        /// association is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Associating</b>: CodeGuru Reviewer is:               
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting up pull request notifications. This is required
        /// for pull requests to trigger a CodeGuru Reviewer review.
        /// </p>
        /// <note>
        /// <p>
        /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
        /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
        /// reviews of code in your repository cannot be triggered.
        /// </p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// Setting up source code access. This is required for CodeGuru Reviewer to securely
        /// clone code in your repository.
        /// </p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Failed</b>: The repository failed to associate or disassociate.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
        /// source code access.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
        /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
        /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
        /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::RepositoryAssociationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryAssociationSummary`](crate::model::RepositoryAssociationSummary)
        pub fn build(self) -> crate::model::RepositoryAssociationSummary {
            crate::model::RepositoryAssociationSummary {
                association_arn: self.association_arn,
                connection_arn: self.connection_arn,
                last_updated_time_stamp: self.last_updated_time_stamp,
                association_id: self.association_id,
                name: self.name,
                owner: self.owner,
                provider_type: self.provider_type,
                state: self.state,
            }
        }
    }
}
impl RepositoryAssociationSummary {
    /// Creates a new builder-style object to manufacture [`RepositoryAssociationSummary`](crate::model::RepositoryAssociationSummary)
    pub fn builder() -> crate::model::repository_association_summary::Builder {
        crate::model::repository_association_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RepositoryAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Associated,
    #[allow(missing_docs)] // documentation missing in model
    Associating,
    #[allow(missing_docs)] // documentation missing in model
    Disassociated,
    #[allow(missing_docs)] // documentation missing in model
    Disassociating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RepositoryAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "Associated" => RepositoryAssociationState::Associated,
            "Associating" => RepositoryAssociationState::Associating,
            "Disassociated" => RepositoryAssociationState::Disassociated,
            "Disassociating" => RepositoryAssociationState::Disassociating,
            "Failed" => RepositoryAssociationState::Failed,
            other => RepositoryAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RepositoryAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RepositoryAssociationState::from(s))
    }
}
impl RepositoryAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RepositoryAssociationState::Associated => "Associated",
            RepositoryAssociationState::Associating => "Associating",
            RepositoryAssociationState::Disassociated => "Disassociated",
            RepositoryAssociationState::Disassociating => "Disassociating",
            RepositoryAssociationState::Failed => "Failed",
            RepositoryAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Associated",
            "Associating",
            "Disassociated",
            "Disassociating",
            "Failed",
        ]
    }
}
impl AsRef<str> for RepositoryAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProviderType {
    #[allow(missing_docs)] // documentation missing in model
    Bitbucket,
    #[allow(missing_docs)] // documentation missing in model
    CodeCommit,
    #[allow(missing_docs)] // documentation missing in model
    GitHub,
    #[allow(missing_docs)] // documentation missing in model
    GitHubEnterpriseServer,
    #[allow(missing_docs)] // documentation missing in model
    S3Bucket,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProviderType {
    fn from(s: &str) -> Self {
        match s {
            "Bitbucket" => ProviderType::Bitbucket,
            "CodeCommit" => ProviderType::CodeCommit,
            "GitHub" => ProviderType::GitHub,
            "GitHubEnterpriseServer" => ProviderType::GitHubEnterpriseServer,
            "S3Bucket" => ProviderType::S3Bucket,
            other => ProviderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProviderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProviderType::from(s))
    }
}
impl ProviderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProviderType::Bitbucket => "Bitbucket",
            ProviderType::CodeCommit => "CodeCommit",
            ProviderType::GitHub => "GitHub",
            ProviderType::GitHubEnterpriseServer => "GitHubEnterpriseServer",
            ProviderType::S3Bucket => "S3Bucket",
            ProviderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bitbucket",
            "CodeCommit",
            "GitHub",
            "GitHubEnterpriseServer",
            "S3Bucket",
        ]
    }
}
impl AsRef<str> for ProviderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about recommendations.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationSummary {
    /// <p>Name of the file on which a recommendation is provided.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>
    /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
    /// </p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>
    /// Start line from where the recommendation is applicable in the source commit or source branch.
    /// </p>
    pub start_line: std::option::Option<i32>,
    /// <p>
    /// Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
    /// </p>
    pub end_line: std::option::Option<i32>,
    /// <p>
    /// A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of a recommendation.</p>
    pub recommendation_category: std::option::Option<crate::model::RecommendationCategory>,
    /// <p>Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
    /// short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
    /// included in analysis results if code is detected that violates the rule.</p>
    pub rule_metadata: std::option::Option<crate::model::RuleMetadata>,
    /// <p>The severity of the issue in the code that generated this recommendation.</p>
    pub severity: std::option::Option<crate::model::Severity>,
}
impl std::fmt::Debug for RecommendationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationSummary");
        formatter.field("file_path", &self.file_path);
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("start_line", &self.start_line);
        formatter.field("end_line", &self.end_line);
        formatter.field("description", &self.description);
        formatter.field("recommendation_category", &self.recommendation_category);
        formatter.field("rule_metadata", &self.rule_metadata);
        formatter.field("severity", &self.severity);
        formatter.finish()
    }
}
/// See [`RecommendationSummary`](crate::model::RecommendationSummary)
pub mod recommendation_summary {
    /// A builder for [`RecommendationSummary`](crate::model::RecommendationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) start_line: std::option::Option<i32>,
        pub(crate) end_line: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommendation_category:
            std::option::Option<crate::model::RecommendationCategory>,
        pub(crate) rule_metadata: std::option::Option<crate::model::RuleMetadata>,
        pub(crate) severity: std::option::Option<crate::model::Severity>,
    }
    impl Builder {
        /// <p>Name of the file on which a recommendation is provided.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>Name of the file on which a recommendation is provided.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
        /// </p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
        /// </p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>
        /// Start line from where the recommendation is applicable in the source commit or source branch.
        /// </p>
        pub fn start_line(mut self, input: i32) -> Self {
            self.start_line = Some(input);
            self
        }
        /// <p>
        /// Start line from where the recommendation is applicable in the source commit or source branch.
        /// </p>
        pub fn set_start_line(mut self, input: std::option::Option<i32>) -> Self {
            self.start_line = input;
            self
        }
        /// <p>
        /// Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
        /// </p>
        pub fn end_line(mut self, input: i32) -> Self {
            self.end_line = Some(input);
            self
        }
        /// <p>
        /// Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
        /// </p>
        pub fn set_end_line(mut self, input: std::option::Option<i32>) -> Self {
            self.end_line = input;
            self
        }
        /// <p>
        /// A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of a recommendation.</p>
        pub fn recommendation_category(
            mut self,
            input: crate::model::RecommendationCategory,
        ) -> Self {
            self.recommendation_category = Some(input);
            self
        }
        /// <p>The type of a recommendation.</p>
        pub fn set_recommendation_category(
            mut self,
            input: std::option::Option<crate::model::RecommendationCategory>,
        ) -> Self {
            self.recommendation_category = input;
            self
        }
        /// <p>Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
        /// short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
        /// included in analysis results if code is detected that violates the rule.</p>
        pub fn rule_metadata(mut self, input: crate::model::RuleMetadata) -> Self {
            self.rule_metadata = Some(input);
            self
        }
        /// <p>Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
        /// short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
        /// included in analysis results if code is detected that violates the rule.</p>
        pub fn set_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::RuleMetadata>,
        ) -> Self {
            self.rule_metadata = input;
            self
        }
        /// <p>The severity of the issue in the code that generated this recommendation.</p>
        pub fn severity(mut self, input: crate::model::Severity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the issue in the code that generated this recommendation.</p>
        pub fn set_severity(mut self, input: std::option::Option<crate::model::Severity>) -> Self {
            self.severity = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationSummary`](crate::model::RecommendationSummary)
        pub fn build(self) -> crate::model::RecommendationSummary {
            crate::model::RecommendationSummary {
                file_path: self.file_path,
                recommendation_id: self.recommendation_id,
                start_line: self.start_line,
                end_line: self.end_line,
                description: self.description,
                recommendation_category: self.recommendation_category,
                rule_metadata: self.rule_metadata,
                severity: self.severity,
            }
        }
    }
}
impl RecommendationSummary {
    /// Creates a new builder-style object to manufacture [`RecommendationSummary`](crate::model::RecommendationSummary)
    pub fn builder() -> crate::model::recommendation_summary::Builder {
        crate::model::recommendation_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Severity {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Severity {
    fn from(s: &str) -> Self {
        match s {
            "Critical" => Severity::Critical,
            "High" => Severity::High,
            "Info" => Severity::Info,
            "Low" => Severity::Low,
            "Medium" => Severity::Medium,
            other => Severity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Severity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Severity::from(s))
    }
}
impl Severity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Severity::Critical => "Critical",
            Severity::High => "High",
            Severity::Info => "Info",
            Severity::Low => "Low",
            Severity::Medium => "Medium",
            Severity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Critical", "High", "Info", "Low", "Medium"]
    }
}
impl AsRef<str> for Severity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
/// short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
/// included in analysis results if code is detected that violates the rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleMetadata {
    /// <p>The ID of the rule.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The name of the rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>A short description of the rule.</p>
    pub short_description: std::option::Option<std::string::String>,
    /// <p>A long description of the rule.</p>
    pub long_description: std::option::Option<std::string::String>,
    /// <p>Tags that are associated with the rule.</p>
    pub rule_tags: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for RuleMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleMetadata");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("rule_name", &self.rule_name);
        formatter.field("short_description", &self.short_description);
        formatter.field("long_description", &self.long_description);
        formatter.field("rule_tags", &self.rule_tags);
        formatter.finish()
    }
}
/// See [`RuleMetadata`](crate::model::RuleMetadata)
pub mod rule_metadata {
    /// A builder for [`RuleMetadata`](crate::model::RuleMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) short_description: std::option::Option<std::string::String>,
        pub(crate) long_description: std::option::Option<std::string::String>,
        pub(crate) rule_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the rule.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the rule.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>A short description of the rule.</p>
        pub fn short_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_description = Some(input.into());
            self
        }
        /// <p>A short description of the rule.</p>
        pub fn set_short_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.short_description = input;
            self
        }
        /// <p>A long description of the rule.</p>
        pub fn long_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.long_description = Some(input.into());
            self
        }
        /// <p>A long description of the rule.</p>
        pub fn set_long_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.long_description = input;
            self
        }
        /// Appends an item to `rule_tags`.
        ///
        /// To override the contents of this collection use [`set_rule_tags`](Self::set_rule_tags).
        ///
        /// <p>Tags that are associated with the rule.</p>
        pub fn rule_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rule_tags.unwrap_or_default();
            v.push(input.into());
            self.rule_tags = Some(v);
            self
        }
        /// <p>Tags that are associated with the rule.</p>
        pub fn set_rule_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rule_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleMetadata`](crate::model::RuleMetadata)
        pub fn build(self) -> crate::model::RuleMetadata {
            crate::model::RuleMetadata {
                rule_id: self.rule_id,
                rule_name: self.rule_name,
                short_description: self.short_description,
                long_description: self.long_description,
                rule_tags: self.rule_tags,
            }
        }
    }
}
impl RuleMetadata {
    /// Creates a new builder-style object to manufacture [`RuleMetadata`](crate::model::RuleMetadata)
    pub fn builder() -> crate::model::rule_metadata::Builder {
        crate::model::rule_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationCategory {
    #[allow(missing_docs)] // documentation missing in model
    AwsBestPractices,
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudformationIssues,
    #[allow(missing_docs)] // documentation missing in model
    CodeInconsistencies,
    #[allow(missing_docs)] // documentation missing in model
    CodeMaintenanceIssues,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrencyIssues,
    #[allow(missing_docs)] // documentation missing in model
    DuplicateCode,
    #[allow(missing_docs)] // documentation missing in model
    InputValidations,
    #[allow(missing_docs)] // documentation missing in model
    JavaBestPractices,
    #[allow(missing_docs)] // documentation missing in model
    PythonBestPractices,
    #[allow(missing_docs)] // documentation missing in model
    ResourceLeaks,
    #[allow(missing_docs)] // documentation missing in model
    SecurityIssues,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationCategory {
    fn from(s: &str) -> Self {
        match s {
            "AWSBestPractices" => RecommendationCategory::AwsBestPractices,
            "AWSCloudFormationIssues" => RecommendationCategory::AwsCloudformationIssues,
            "CodeInconsistencies" => RecommendationCategory::CodeInconsistencies,
            "CodeMaintenanceIssues" => RecommendationCategory::CodeMaintenanceIssues,
            "ConcurrencyIssues" => RecommendationCategory::ConcurrencyIssues,
            "DuplicateCode" => RecommendationCategory::DuplicateCode,
            "InputValidations" => RecommendationCategory::InputValidations,
            "JavaBestPractices" => RecommendationCategory::JavaBestPractices,
            "PythonBestPractices" => RecommendationCategory::PythonBestPractices,
            "ResourceLeaks" => RecommendationCategory::ResourceLeaks,
            "SecurityIssues" => RecommendationCategory::SecurityIssues,
            other => RecommendationCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationCategory::from(s))
    }
}
impl RecommendationCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationCategory::AwsBestPractices => "AWSBestPractices",
            RecommendationCategory::AwsCloudformationIssues => "AWSCloudFormationIssues",
            RecommendationCategory::CodeInconsistencies => "CodeInconsistencies",
            RecommendationCategory::CodeMaintenanceIssues => "CodeMaintenanceIssues",
            RecommendationCategory::ConcurrencyIssues => "ConcurrencyIssues",
            RecommendationCategory::DuplicateCode => "DuplicateCode",
            RecommendationCategory::InputValidations => "InputValidations",
            RecommendationCategory::JavaBestPractices => "JavaBestPractices",
            RecommendationCategory::PythonBestPractices => "PythonBestPractices",
            RecommendationCategory::ResourceLeaks => "ResourceLeaks",
            RecommendationCategory::SecurityIssues => "SecurityIssues",
            RecommendationCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWSBestPractices",
            "AWSCloudFormationIssues",
            "CodeInconsistencies",
            "CodeMaintenanceIssues",
            "ConcurrencyIssues",
            "DuplicateCode",
            "InputValidations",
            "JavaBestPractices",
            "PythonBestPractices",
            "ResourceLeaks",
            "SecurityIssues",
        ]
    }
}
impl AsRef<str> for RecommendationCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about recommendation feedback summaries.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationFeedbackSummary {
    /// <p>
    /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
    /// </p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>
    /// List for storing reactions. Reactions are utf-8 text code for emojis.
    /// </p>
    pub reactions: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
    /// <p>
    /// The ID of the user that gave the feedback.
    /// </p>
    /// <p>
    /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
    /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
    /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
    /// </p>
    pub user_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecommendationFeedbackSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationFeedbackSummary");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("reactions", &self.reactions);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`RecommendationFeedbackSummary`](crate::model::RecommendationFeedbackSummary)
pub mod recommendation_feedback_summary {
    /// A builder for [`RecommendationFeedbackSummary`](crate::model::RecommendationFeedbackSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) reactions: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
        /// </p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
        /// </p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// Appends an item to `reactions`.
        ///
        /// To override the contents of this collection use [`set_reactions`](Self::set_reactions).
        ///
        /// <p>
        /// List for storing reactions. Reactions are utf-8 text code for emojis.
        /// </p>
        pub fn reactions(mut self, input: impl Into<crate::model::Reaction>) -> Self {
            let mut v = self.reactions.unwrap_or_default();
            v.push(input.into());
            self.reactions = Some(v);
            self
        }
        /// <p>
        /// List for storing reactions. Reactions are utf-8 text code for emojis.
        /// </p>
        pub fn set_reactions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
        ) -> Self {
            self.reactions = input;
            self
        }
        /// <p>
        /// The ID of the user that gave the feedback.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the user that gave the feedback.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationFeedbackSummary`](crate::model::RecommendationFeedbackSummary)
        pub fn build(self) -> crate::model::RecommendationFeedbackSummary {
            crate::model::RecommendationFeedbackSummary {
                recommendation_id: self.recommendation_id,
                reactions: self.reactions,
                user_id: self.user_id,
            }
        }
    }
}
impl RecommendationFeedbackSummary {
    /// Creates a new builder-style object to manufacture [`RecommendationFeedbackSummary`](crate::model::RecommendationFeedbackSummary)
    pub fn builder() -> crate::model::recommendation_feedback_summary::Builder {
        crate::model::recommendation_feedback_summary::Builder::default()
    }
}

/// <p>
/// Information about the summary of the code review.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeReviewSummary {
    /// <p>
    /// The name of the code review.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
    /// <code>CodeReview</code>
    /// </a> object.
    /// </p>
    pub code_review_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository.
    /// </p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
    /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
    /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>
    /// The provider type of the repository association.
    /// </p>
    pub provider_type: std::option::Option<crate::model::ProviderType>,
    /// <p>
    /// The state of the code review.
    /// </p>
    /// <p>The valid code review states are:</p>
    /// <ul>
    /// <li>            
    /// <p>
    /// <code>Completed</code>: The code review is complete.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <code>Pending</code>: The code review started and has not completed or failed.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code>: The code review failed.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleting</code>: The code review is being deleted.
    /// </p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::JobState>,
    /// <p>
    /// The time, in milliseconds since the epoch, when the code review was created.
    /// </p>
    pub created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The time, in milliseconds since the epoch, when the code review was last updated.
    /// </p>
    pub last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The type of the code review.
    /// </p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>
    /// The pull request ID for the code review.
    /// </p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>
    /// The statistics from the code review.
    /// </p>
    pub metrics_summary: std::option::Option<crate::model::MetricsSummary>,
    /// <p>
    /// Specifies the source code that is analyzed in a code review.
    /// </p>
    pub source_code_type: std::option::Option<crate::model::SourceCodeType>,
}
impl std::fmt::Debug for CodeReviewSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeReviewSummary");
        formatter.field("name", &self.name);
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("owner", &self.owner);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("state", &self.state);
        formatter.field("created_time_stamp", &self.created_time_stamp);
        formatter.field("last_updated_time_stamp", &self.last_updated_time_stamp);
        formatter.field("r#type", &self.r#type);
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("metrics_summary", &self.metrics_summary);
        formatter.field("source_code_type", &self.source_code_type);
        formatter.finish()
    }
}
/// See [`CodeReviewSummary`](crate::model::CodeReviewSummary)
pub mod code_review_summary {
    /// A builder for [`CodeReviewSummary`](crate::model::CodeReviewSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::ProviderType>,
        pub(crate) state: std::option::Option<crate::model::JobState>,
        pub(crate) created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) metrics_summary: std::option::Option<crate::model::MetricsSummary>,
        pub(crate) source_code_type: std::option::Option<crate::model::SourceCodeType>,
    }
    impl Builder {
        /// <p>
        /// The name of the code review.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the code review.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>
        /// The provider type of the repository association.
        /// </p>
        pub fn provider_type(mut self, input: crate::model::ProviderType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>
        /// The provider type of the repository association.
        /// </p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// <p>
        /// The state of the code review.
        /// </p>
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <code>Completed</code>: The code review is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Pending</code>: The code review started and has not completed or failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: The code review failed.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: The code review is being deleted.
        /// </p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::JobState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>
        /// The state of the code review.
        /// </p>
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <code>Completed</code>: The code review is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Pending</code>: The code review started and has not completed or failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: The code review failed.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: The code review is being deleted.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<crate::model::JobState>) -> Self {
            self.state = input;
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was created.
        /// </p>
        pub fn created_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time_stamp = Some(input);
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was created.
        /// </p>
        pub fn set_created_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time_stamp = input;
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was last updated.
        /// </p>
        pub fn last_updated_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time_stamp = Some(input);
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was last updated.
        /// </p>
        pub fn set_last_updated_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time_stamp = input;
            self
        }
        /// <p>
        /// The type of the code review.
        /// </p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// The type of the code review.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>
        /// The pull request ID for the code review.
        /// </p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>
        /// The pull request ID for the code review.
        /// </p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>
        /// The statistics from the code review.
        /// </p>
        pub fn metrics_summary(mut self, input: crate::model::MetricsSummary) -> Self {
            self.metrics_summary = Some(input);
            self
        }
        /// <p>
        /// The statistics from the code review.
        /// </p>
        pub fn set_metrics_summary(
            mut self,
            input: std::option::Option<crate::model::MetricsSummary>,
        ) -> Self {
            self.metrics_summary = input;
            self
        }
        /// <p>
        /// Specifies the source code that is analyzed in a code review.
        /// </p>
        pub fn source_code_type(mut self, input: crate::model::SourceCodeType) -> Self {
            self.source_code_type = Some(input);
            self
        }
        /// <p>
        /// Specifies the source code that is analyzed in a code review.
        /// </p>
        pub fn set_source_code_type(
            mut self,
            input: std::option::Option<crate::model::SourceCodeType>,
        ) -> Self {
            self.source_code_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeReviewSummary`](crate::model::CodeReviewSummary)
        pub fn build(self) -> crate::model::CodeReviewSummary {
            crate::model::CodeReviewSummary {
                name: self.name,
                code_review_arn: self.code_review_arn,
                repository_name: self.repository_name,
                owner: self.owner,
                provider_type: self.provider_type,
                state: self.state,
                created_time_stamp: self.created_time_stamp,
                last_updated_time_stamp: self.last_updated_time_stamp,
                r#type: self.r#type,
                pull_request_id: self.pull_request_id,
                metrics_summary: self.metrics_summary,
                source_code_type: self.source_code_type,
            }
        }
    }
}
impl CodeReviewSummary {
    /// Creates a new builder-style object to manufacture [`CodeReviewSummary`](crate::model::CodeReviewSummary)
    pub fn builder() -> crate::model::code_review_summary::Builder {
        crate::model::code_review_summary::Builder::default()
    }
}

/// <p>
/// Specifies the source code that is analyzed in a code review.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceCodeType {
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
    /// <code>SourceCodeType</code>
    /// </a> that
    /// specifies a commit diff created by a pull request on an associated repository.
    /// </p>
    pub commit_diff: std::option::Option<crate::model::CommitDiffSourceCodeType>,
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
    /// <code>SourceCodeType</code>
    /// </a> that specifies
    /// the tip of a branch in an associated repository.
    /// </p>
    pub repository_head: std::option::Option<crate::model::RepositoryHeadSourceCodeType>,
    /// <p>
    /// A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
    /// <code>SourceCodeType</code>
    /// </a> that
    /// specifies a source branch name and a destination branch name in an associated repository.
    /// </p>
    pub branch_diff: std::option::Option<crate::model::BranchDiffSourceCodeType>,
    /// <p>
    /// Information about an associated repository in an S3 bucket that includes its name and an <code>S3RepositoryDetails</code> object.
    /// The <code>S3RepositoryDetails</code> object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
    /// an S3 key for a build artifacts .zip file. <code>S3BucketRepository</code> is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
    /// <code>SourceCodeType</code>
    /// </a> for
    /// <code>S3BucketRepository</code> based code reviews.
    /// </p>
    pub s3_bucket_repository: std::option::Option<crate::model::S3BucketRepository>,
    /// <p>Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
    /// <code>RequestMetadaa</code> field captures any event metadata. For example, it might capture metadata associated with
    /// an event trigger, such as a push or a pull request. </p>
    pub request_metadata: std::option::Option<crate::model::RequestMetadata>,
}
impl std::fmt::Debug for SourceCodeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceCodeType");
        formatter.field("commit_diff", &self.commit_diff);
        formatter.field("repository_head", &self.repository_head);
        formatter.field("branch_diff", &self.branch_diff);
        formatter.field("s3_bucket_repository", &self.s3_bucket_repository);
        formatter.field("request_metadata", &self.request_metadata);
        formatter.finish()
    }
}
/// See [`SourceCodeType`](crate::model::SourceCodeType)
pub mod source_code_type {
    /// A builder for [`SourceCodeType`](crate::model::SourceCodeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_diff: std::option::Option<crate::model::CommitDiffSourceCodeType>,
        pub(crate) repository_head: std::option::Option<crate::model::RepositoryHeadSourceCodeType>,
        pub(crate) branch_diff: std::option::Option<crate::model::BranchDiffSourceCodeType>,
        pub(crate) s3_bucket_repository: std::option::Option<crate::model::S3BucketRepository>,
        pub(crate) request_metadata: std::option::Option<crate::model::RequestMetadata>,
    }
    impl Builder {
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that
        /// specifies a commit diff created by a pull request on an associated repository.
        /// </p>
        pub fn commit_diff(mut self, input: crate::model::CommitDiffSourceCodeType) -> Self {
            self.commit_diff = Some(input);
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that
        /// specifies a commit diff created by a pull request on an associated repository.
        /// </p>
        pub fn set_commit_diff(
            mut self,
            input: std::option::Option<crate::model::CommitDiffSourceCodeType>,
        ) -> Self {
            self.commit_diff = input;
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that specifies
        /// the tip of a branch in an associated repository.
        /// </p>
        pub fn repository_head(
            mut self,
            input: crate::model::RepositoryHeadSourceCodeType,
        ) -> Self {
            self.repository_head = Some(input);
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that specifies
        /// the tip of a branch in an associated repository.
        /// </p>
        pub fn set_repository_head(
            mut self,
            input: std::option::Option<crate::model::RepositoryHeadSourceCodeType>,
        ) -> Self {
            self.repository_head = input;
            self
        }
        /// <p>
        /// A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that
        /// specifies a source branch name and a destination branch name in an associated repository.
        /// </p>
        pub fn branch_diff(mut self, input: crate::model::BranchDiffSourceCodeType) -> Self {
            self.branch_diff = Some(input);
            self
        }
        /// <p>
        /// A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that
        /// specifies a source branch name and a destination branch name in an associated repository.
        /// </p>
        pub fn set_branch_diff(
            mut self,
            input: std::option::Option<crate::model::BranchDiffSourceCodeType>,
        ) -> Self {
            self.branch_diff = input;
            self
        }
        /// <p>
        /// Information about an associated repository in an S3 bucket that includes its name and an <code>S3RepositoryDetails</code> object.
        /// The <code>S3RepositoryDetails</code> object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
        /// an S3 key for a build artifacts .zip file. <code>S3BucketRepository</code> is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> for
        /// <code>S3BucketRepository</code> based code reviews.
        /// </p>
        pub fn s3_bucket_repository(mut self, input: crate::model::S3BucketRepository) -> Self {
            self.s3_bucket_repository = Some(input);
            self
        }
        /// <p>
        /// Information about an associated repository in an S3 bucket that includes its name and an <code>S3RepositoryDetails</code> object.
        /// The <code>S3RepositoryDetails</code> object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
        /// an S3 key for a build artifacts .zip file. <code>S3BucketRepository</code> is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> for
        /// <code>S3BucketRepository</code> based code reviews.
        /// </p>
        pub fn set_s3_bucket_repository(
            mut self,
            input: std::option::Option<crate::model::S3BucketRepository>,
        ) -> Self {
            self.s3_bucket_repository = input;
            self
        }
        /// <p>Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
        /// <code>RequestMetadaa</code> field captures any event metadata. For example, it might capture metadata associated with
        /// an event trigger, such as a push or a pull request. </p>
        pub fn request_metadata(mut self, input: crate::model::RequestMetadata) -> Self {
            self.request_metadata = Some(input);
            self
        }
        /// <p>Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
        /// <code>RequestMetadaa</code> field captures any event metadata. For example, it might capture metadata associated with
        /// an event trigger, such as a push or a pull request. </p>
        pub fn set_request_metadata(
            mut self,
            input: std::option::Option<crate::model::RequestMetadata>,
        ) -> Self {
            self.request_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceCodeType`](crate::model::SourceCodeType)
        pub fn build(self) -> crate::model::SourceCodeType {
            crate::model::SourceCodeType {
                commit_diff: self.commit_diff,
                repository_head: self.repository_head,
                branch_diff: self.branch_diff,
                s3_bucket_repository: self.s3_bucket_repository,
                request_metadata: self.request_metadata,
            }
        }
    }
}
impl SourceCodeType {
    /// Creates a new builder-style object to manufacture [`SourceCodeType`](crate::model::SourceCodeType)
    pub fn builder() -> crate::model::source_code_type::Builder {
        crate::model::source_code_type::Builder::default()
    }
}

/// <p>Metadata that is associated with a code review. This applies to both pull request
/// and repository analysis code reviews.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestMetadata {
    /// <p>The ID of the request. This is required for a pull request code review.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>An identifier, such as a name or account ID, that is associated with the requester. The
    /// <code>Requester</code> is used to capture the <code>author/actor</code> name of the event request.</p>
    pub requester: std::option::Option<std::string::String>,
    /// <p>Information about the event associated with a code review.</p>
    pub event_info: std::option::Option<crate::model::EventInfo>,
    /// <p>The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
    /// review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
    /// review by GitHub scripts from a GitHub repository, then the repository association's <code>ProviderType</code> is
    /// <code>S3Bucket</code> and the CI/CD repository vendor name is GitHub. For more
    /// information, see the definition for <code>ProviderType</code> in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation</a>. </p>
    pub vendor_name: std::option::Option<crate::model::VendorName>,
}
impl std::fmt::Debug for RequestMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestMetadata");
        formatter.field("request_id", &self.request_id);
        formatter.field("requester", &self.requester);
        formatter.field("event_info", &self.event_info);
        formatter.field("vendor_name", &self.vendor_name);
        formatter.finish()
    }
}
/// See [`RequestMetadata`](crate::model::RequestMetadata)
pub mod request_metadata {
    /// A builder for [`RequestMetadata`](crate::model::RequestMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) requester: std::option::Option<std::string::String>,
        pub(crate) event_info: std::option::Option<crate::model::EventInfo>,
        pub(crate) vendor_name: std::option::Option<crate::model::VendorName>,
    }
    impl Builder {
        /// <p>The ID of the request. This is required for a pull request code review.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The ID of the request. This is required for a pull request code review.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>An identifier, such as a name or account ID, that is associated with the requester. The
        /// <code>Requester</code> is used to capture the <code>author/actor</code> name of the event request.</p>
        pub fn requester(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester = Some(input.into());
            self
        }
        /// <p>An identifier, such as a name or account ID, that is associated with the requester. The
        /// <code>Requester</code> is used to capture the <code>author/actor</code> name of the event request.</p>
        pub fn set_requester(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.requester = input;
            self
        }
        /// <p>Information about the event associated with a code review.</p>
        pub fn event_info(mut self, input: crate::model::EventInfo) -> Self {
            self.event_info = Some(input);
            self
        }
        /// <p>Information about the event associated with a code review.</p>
        pub fn set_event_info(
            mut self,
            input: std::option::Option<crate::model::EventInfo>,
        ) -> Self {
            self.event_info = input;
            self
        }
        /// <p>The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
        /// review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
        /// review by GitHub scripts from a GitHub repository, then the repository association's <code>ProviderType</code> is
        /// <code>S3Bucket</code> and the CI/CD repository vendor name is GitHub. For more
        /// information, see the definition for <code>ProviderType</code> in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation</a>. </p>
        pub fn vendor_name(mut self, input: crate::model::VendorName) -> Self {
            self.vendor_name = Some(input);
            self
        }
        /// <p>The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
        /// review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
        /// review by GitHub scripts from a GitHub repository, then the repository association's <code>ProviderType</code> is
        /// <code>S3Bucket</code> and the CI/CD repository vendor name is GitHub. For more
        /// information, see the definition for <code>ProviderType</code> in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation</a>. </p>
        pub fn set_vendor_name(
            mut self,
            input: std::option::Option<crate::model::VendorName>,
        ) -> Self {
            self.vendor_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestMetadata`](crate::model::RequestMetadata)
        pub fn build(self) -> crate::model::RequestMetadata {
            crate::model::RequestMetadata {
                request_id: self.request_id,
                requester: self.requester,
                event_info: self.event_info,
                vendor_name: self.vendor_name,
            }
        }
    }
}
impl RequestMetadata {
    /// Creates a new builder-style object to manufacture [`RequestMetadata`](crate::model::RequestMetadata)
    pub fn builder() -> crate::model::request_metadata::Builder {
        crate::model::request_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VendorName {
    #[allow(missing_docs)] // documentation missing in model
    Github,
    #[allow(missing_docs)] // documentation missing in model
    Gitlab,
    #[allow(missing_docs)] // documentation missing in model
    NativeS3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VendorName {
    fn from(s: &str) -> Self {
        match s {
            "GitHub" => VendorName::Github,
            "GitLab" => VendorName::Gitlab,
            "NativeS3" => VendorName::NativeS3,
            other => VendorName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VendorName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VendorName::from(s))
    }
}
impl VendorName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VendorName::Github => "GitHub",
            VendorName::Gitlab => "GitLab",
            VendorName::NativeS3 => "NativeS3",
            VendorName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GitHub", "GitLab", "NativeS3"]
    }
}
impl AsRef<str> for VendorName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an event. The event might be a push, pull request, scheduled request, or another type of event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventInfo {
    /// <p>The name of the event. The possible names are <code>pull_request</code>, <code>workflow_dispatch</code>,
    /// <code>schedule</code>, and <code>push</code>
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of an event. The state might be open, closed, or another state.</p>
    pub state: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventInfo");
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`EventInfo`](crate::model::EventInfo)
pub mod event_info {
    /// A builder for [`EventInfo`](crate::model::EventInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event. The possible names are <code>pull_request</code>, <code>workflow_dispatch</code>,
        /// <code>schedule</code>, and <code>push</code>
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event. The possible names are <code>pull_request</code>, <code>workflow_dispatch</code>,
        /// <code>schedule</code>, and <code>push</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of an event. The state might be open, closed, or another state.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of an event. The state might be open, closed, or another state.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`EventInfo`](crate::model::EventInfo)
        pub fn build(self) -> crate::model::EventInfo {
            crate::model::EventInfo {
                name: self.name,
                state: self.state,
            }
        }
    }
}
impl EventInfo {
    /// Creates a new builder-style object to manufacture [`EventInfo`](crate::model::EventInfo)
    pub fn builder() -> crate::model::event_info::Builder {
        crate::model::event_info::Builder::default()
    }
}

/// <p>
/// Information about an associated repository in an S3 bucket. The associated repository contains a source code
/// .zip file and a build artifacts .zip file that contains .jar or .class files.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketRepository {
    /// <p>
    /// The name of the repository when the <code>ProviderType</code> is <code>S3Bucket</code>.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and
    /// a <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3
    /// object keys for a source code .zip file and for a build artifacts .zip file.
    /// </p>
    pub details: std::option::Option<crate::model::S3RepositoryDetails>,
}
impl std::fmt::Debug for S3BucketRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketRepository");
        formatter.field("name", &self.name);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`S3BucketRepository`](crate::model::S3BucketRepository)
pub mod s3_bucket_repository {
    /// A builder for [`S3BucketRepository`](crate::model::S3BucketRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<crate::model::S3RepositoryDetails>,
    }
    impl Builder {
        /// <p>
        /// The name of the repository when the <code>ProviderType</code> is <code>S3Bucket</code>.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository when the <code>ProviderType</code> is <code>S3Bucket</code>.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and
        /// a <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3
        /// object keys for a source code .zip file and for a build artifacts .zip file.
        /// </p>
        pub fn details(mut self, input: crate::model::S3RepositoryDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>
        /// An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and
        /// a <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3
        /// object keys for a source code .zip file and for a build artifacts .zip file.
        /// </p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::S3RepositoryDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketRepository`](crate::model::S3BucketRepository)
        pub fn build(self) -> crate::model::S3BucketRepository {
            crate::model::S3BucketRepository {
                name: self.name,
                details: self.details,
            }
        }
    }
}
impl S3BucketRepository {
    /// Creates a new builder-style object to manufacture [`S3BucketRepository`](crate::model::S3BucketRepository)
    pub fn builder() -> crate::model::s3_bucket_repository::Builder {
        crate::model::s3_bucket_repository::Builder::default()
    }
}

/// <p>
/// Specifies the name of an S3 bucket and a <code>CodeArtifacts</code> object that contains the S3
/// object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3RepositoryDetails {
    /// <p>The name of the S3 bucket used for associating a new S3 repository. It must begin with
    /// <code>codeguru-reviewer-</code>. </p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>
    /// A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3
    /// object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
    /// </p>
    pub code_artifacts: std::option::Option<crate::model::CodeArtifacts>,
}
impl std::fmt::Debug for S3RepositoryDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3RepositoryDetails");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("code_artifacts", &self.code_artifacts);
        formatter.finish()
    }
}
/// See [`S3RepositoryDetails`](crate::model::S3RepositoryDetails)
pub mod s3_repository_details {
    /// A builder for [`S3RepositoryDetails`](crate::model::S3RepositoryDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) code_artifacts: std::option::Option<crate::model::CodeArtifacts>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket used for associating a new S3 repository. It must begin with
        /// <code>codeguru-reviewer-</code>. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket used for associating a new S3 repository. It must begin with
        /// <code>codeguru-reviewer-</code>. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>
        /// A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3
        /// object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
        /// </p>
        pub fn code_artifacts(mut self, input: crate::model::CodeArtifacts) -> Self {
            self.code_artifacts = Some(input);
            self
        }
        /// <p>
        /// A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3
        /// object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
        /// </p>
        pub fn set_code_artifacts(
            mut self,
            input: std::option::Option<crate::model::CodeArtifacts>,
        ) -> Self {
            self.code_artifacts = input;
            self
        }
        /// Consumes the builder and constructs a [`S3RepositoryDetails`](crate::model::S3RepositoryDetails)
        pub fn build(self) -> crate::model::S3RepositoryDetails {
            crate::model::S3RepositoryDetails {
                bucket_name: self.bucket_name,
                code_artifacts: self.code_artifacts,
            }
        }
    }
}
impl S3RepositoryDetails {
    /// Creates a new builder-style object to manufacture [`S3RepositoryDetails`](crate::model::S3RepositoryDetails)
    pub fn builder() -> crate::model::s3_repository_details::Builder {
        crate::model::s3_repository_details::Builder::default()
    }
}

/// <p>Code artifacts are source code artifacts and build artifacts used in a repository analysis or a pull request review.</p>
/// <ul>
/// <li>
/// <p>Source code artifacts are source code files in a Git repository that are
/// compressed into a .zip file.</p>
/// </li>
/// <li>
/// <p>Build artifacts are .jar or .class files that are compressed in a .zip file.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeArtifacts {
    /// <p>The S3 object key for a source code .zip file. This is required for all code reviews.</p>
    pub source_code_artifacts_object_key: std::option::Option<std::string::String>,
    /// <p>The S3 object key for a build artifacts .zip file that
    /// contains .jar or .class files. This is required for a code review with security analysis. For more
    /// information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
    /// analysis</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.</p>
    pub build_artifacts_object_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CodeArtifacts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeArtifacts");
        formatter.field(
            "source_code_artifacts_object_key",
            &self.source_code_artifacts_object_key,
        );
        formatter.field(
            "build_artifacts_object_key",
            &self.build_artifacts_object_key,
        );
        formatter.finish()
    }
}
/// See [`CodeArtifacts`](crate::model::CodeArtifacts)
pub mod code_artifacts {
    /// A builder for [`CodeArtifacts`](crate::model::CodeArtifacts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_code_artifacts_object_key: std::option::Option<std::string::String>,
        pub(crate) build_artifacts_object_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 object key for a source code .zip file. This is required for all code reviews.</p>
        pub fn source_code_artifacts_object_key(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_code_artifacts_object_key = Some(input.into());
            self
        }
        /// <p>The S3 object key for a source code .zip file. This is required for all code reviews.</p>
        pub fn set_source_code_artifacts_object_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_code_artifacts_object_key = input;
            self
        }
        /// <p>The S3 object key for a build artifacts .zip file that
        /// contains .jar or .class files. This is required for a code review with security analysis. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
        /// analysis</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.</p>
        pub fn build_artifacts_object_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_artifacts_object_key = Some(input.into());
            self
        }
        /// <p>The S3 object key for a build artifacts .zip file that
        /// contains .jar or .class files. This is required for a code review with security analysis. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
        /// analysis</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.</p>
        pub fn set_build_artifacts_object_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.build_artifacts_object_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeArtifacts`](crate::model::CodeArtifacts)
        pub fn build(self) -> crate::model::CodeArtifacts {
            crate::model::CodeArtifacts {
                source_code_artifacts_object_key: self.source_code_artifacts_object_key,
                build_artifacts_object_key: self.build_artifacts_object_key,
            }
        }
    }
}
impl CodeArtifacts {
    /// Creates a new builder-style object to manufacture [`CodeArtifacts`](crate::model::CodeArtifacts)
    pub fn builder() -> crate::model::code_artifacts::Builder {
        crate::model::code_artifacts::Builder::default()
    }
}

/// <p>
/// A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
/// <code>SourceCodeType</code>
/// </a> that
/// specifies a code diff between a source and destination branch in an associated repository.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BranchDiffSourceCodeType {
    /// <p>The source branch for a diff in an associated repository.</p>
    pub source_branch_name: std::option::Option<std::string::String>,
    /// <p>The destination branch for a diff in an associated repository.</p>
    pub destination_branch_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BranchDiffSourceCodeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BranchDiffSourceCodeType");
        formatter.field("source_branch_name", &self.source_branch_name);
        formatter.field("destination_branch_name", &self.destination_branch_name);
        formatter.finish()
    }
}
/// See [`BranchDiffSourceCodeType`](crate::model::BranchDiffSourceCodeType)
pub mod branch_diff_source_code_type {
    /// A builder for [`BranchDiffSourceCodeType`](crate::model::BranchDiffSourceCodeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_branch_name: std::option::Option<std::string::String>,
        pub(crate) destination_branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source branch for a diff in an associated repository.</p>
        pub fn source_branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_branch_name = Some(input.into());
            self
        }
        /// <p>The source branch for a diff in an associated repository.</p>
        pub fn set_source_branch_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_branch_name = input;
            self
        }
        /// <p>The destination branch for a diff in an associated repository.</p>
        pub fn destination_branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_branch_name = Some(input.into());
            self
        }
        /// <p>The destination branch for a diff in an associated repository.</p>
        pub fn set_destination_branch_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BranchDiffSourceCodeType`](crate::model::BranchDiffSourceCodeType)
        pub fn build(self) -> crate::model::BranchDiffSourceCodeType {
            crate::model::BranchDiffSourceCodeType {
                source_branch_name: self.source_branch_name,
                destination_branch_name: self.destination_branch_name,
            }
        }
    }
}
impl BranchDiffSourceCodeType {
    /// Creates a new builder-style object to manufacture [`BranchDiffSourceCodeType`](crate::model::BranchDiffSourceCodeType)
    pub fn builder() -> crate::model::branch_diff_source_code_type::Builder {
        crate::model::branch_diff_source_code_type::Builder::default()
    }
}

/// <p>
/// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
/// <code>SourceCodeType</code>
/// </a> that specifies
/// the tip of a branch in an associated repository.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryHeadSourceCodeType {
    /// <p>
    /// The name of the branch in an associated repository. The <code>RepositoryHeadSourceCodeType</code> specifies
    /// the tip of this branch.
    /// </p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryHeadSourceCodeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryHeadSourceCodeType");
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}
/// See [`RepositoryHeadSourceCodeType`](crate::model::RepositoryHeadSourceCodeType)
pub mod repository_head_source_code_type {
    /// A builder for [`RepositoryHeadSourceCodeType`](crate::model::RepositoryHeadSourceCodeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the branch in an associated repository. The <code>RepositoryHeadSourceCodeType</code> specifies
        /// the tip of this branch.
        /// </p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the branch in an associated repository. The <code>RepositoryHeadSourceCodeType</code> specifies
        /// the tip of this branch.
        /// </p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryHeadSourceCodeType`](crate::model::RepositoryHeadSourceCodeType)
        pub fn build(self) -> crate::model::RepositoryHeadSourceCodeType {
            crate::model::RepositoryHeadSourceCodeType {
                branch_name: self.branch_name,
            }
        }
    }
}
impl RepositoryHeadSourceCodeType {
    /// Creates a new builder-style object to manufacture [`RepositoryHeadSourceCodeType`](crate::model::RepositoryHeadSourceCodeType)
    pub fn builder() -> crate::model::repository_head_source_code_type::Builder {
        crate::model::repository_head_source_code_type::Builder::default()
    }
}

/// <p>
/// A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
/// <code>SourceCodeType</code>
/// </a> that
/// specifies the commit diff for a pull request on an associated repository. The <code>SourceCommit</code>
/// and <code>DestinationCommit</code> fields are required to do a pull request code review.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommitDiffSourceCodeType {
    /// <p>
    /// The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
    /// </p>
    pub source_commit: std::option::Option<std::string::String>,
    /// <p>
    /// The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
    /// </p>
    pub destination_commit: std::option::Option<std::string::String>,
    /// <p>The SHA of the merge base of a commit.</p>
    pub merge_base_commit: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CommitDiffSourceCodeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommitDiffSourceCodeType");
        formatter.field("source_commit", &self.source_commit);
        formatter.field("destination_commit", &self.destination_commit);
        formatter.field("merge_base_commit", &self.merge_base_commit);
        formatter.finish()
    }
}
/// See [`CommitDiffSourceCodeType`](crate::model::CommitDiffSourceCodeType)
pub mod commit_diff_source_code_type {
    /// A builder for [`CommitDiffSourceCodeType`](crate::model::CommitDiffSourceCodeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_commit: std::option::Option<std::string::String>,
        pub(crate) destination_commit: std::option::Option<std::string::String>,
        pub(crate) merge_base_commit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
        /// </p>
        pub fn source_commit(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit = Some(input.into());
            self
        }
        /// <p>
        /// The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
        /// </p>
        pub fn set_source_commit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit = input;
            self
        }
        /// <p>
        /// The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
        /// </p>
        pub fn destination_commit(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit = Some(input.into());
            self
        }
        /// <p>
        /// The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
        /// </p>
        pub fn set_destination_commit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit = input;
            self
        }
        /// <p>The SHA of the merge base of a commit.</p>
        pub fn merge_base_commit(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_base_commit = Some(input.into());
            self
        }
        /// <p>The SHA of the merge base of a commit.</p>
        pub fn set_merge_base_commit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.merge_base_commit = input;
            self
        }
        /// Consumes the builder and constructs a [`CommitDiffSourceCodeType`](crate::model::CommitDiffSourceCodeType)
        pub fn build(self) -> crate::model::CommitDiffSourceCodeType {
            crate::model::CommitDiffSourceCodeType {
                source_commit: self.source_commit,
                destination_commit: self.destination_commit,
                merge_base_commit: self.merge_base_commit,
            }
        }
    }
}
impl CommitDiffSourceCodeType {
    /// Creates a new builder-style object to manufacture [`CommitDiffSourceCodeType`](crate::model::CommitDiffSourceCodeType)
    pub fn builder() -> crate::model::commit_diff_source_code_type::Builder {
        crate::model::commit_diff_source_code_type::Builder::default()
    }
}

/// <p>
/// Information about metrics summaries.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricsSummary {
    /// <p>
    /// Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions,
    /// this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that already
    /// existed in the pull request, this includes only the changed lines of code. In both cases, this does not include non-code lines such as comments
    /// and import statements. For example, if you submit a pull request containing 5 files, each with 500 lines of code, and in
    /// a subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files,
    /// <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of
    /// code for a total of 2,725 lines of code.
    /// </p>
    pub metered_lines_of_code_count: std::option::Option<i64>,
    /// <p>
    /// Total number of recommendations found in the code review.
    /// </p>
    pub findings_count: std::option::Option<i64>,
}
impl std::fmt::Debug for MetricsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricsSummary");
        formatter.field(
            "metered_lines_of_code_count",
            &self.metered_lines_of_code_count,
        );
        formatter.field("findings_count", &self.findings_count);
        formatter.finish()
    }
}
/// See [`MetricsSummary`](crate::model::MetricsSummary)
pub mod metrics_summary {
    /// A builder for [`MetricsSummary`](crate::model::MetricsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metered_lines_of_code_count: std::option::Option<i64>,
        pub(crate) findings_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>
        /// Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions,
        /// this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that already
        /// existed in the pull request, this includes only the changed lines of code. In both cases, this does not include non-code lines such as comments
        /// and import statements. For example, if you submit a pull request containing 5 files, each with 500 lines of code, and in
        /// a subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files,
        /// <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of
        /// code for a total of 2,725 lines of code.
        /// </p>
        pub fn metered_lines_of_code_count(mut self, input: i64) -> Self {
            self.metered_lines_of_code_count = Some(input);
            self
        }
        /// <p>
        /// Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions,
        /// this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that already
        /// existed in the pull request, this includes only the changed lines of code. In both cases, this does not include non-code lines such as comments
        /// and import statements. For example, if you submit a pull request containing 5 files, each with 500 lines of code, and in
        /// a subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files,
        /// <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of
        /// code for a total of 2,725 lines of code.
        /// </p>
        pub fn set_metered_lines_of_code_count(mut self, input: std::option::Option<i64>) -> Self {
            self.metered_lines_of_code_count = input;
            self
        }
        /// <p>
        /// Total number of recommendations found in the code review.
        /// </p>
        pub fn findings_count(mut self, input: i64) -> Self {
            self.findings_count = Some(input);
            self
        }
        /// <p>
        /// Total number of recommendations found in the code review.
        /// </p>
        pub fn set_findings_count(mut self, input: std::option::Option<i64>) -> Self {
            self.findings_count = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricsSummary`](crate::model::MetricsSummary)
        pub fn build(self) -> crate::model::MetricsSummary {
            crate::model::MetricsSummary {
                metered_lines_of_code_count: self.metered_lines_of_code_count,
                findings_count: self.findings_count,
            }
        }
    }
}
impl MetricsSummary {
    /// Creates a new builder-style object to manufacture [`MetricsSummary`](crate::model::MetricsSummary)
    pub fn builder() -> crate::model::metrics_summary::Builder {
        crate::model::metrics_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    PullRequest,
    #[allow(missing_docs)] // documentation missing in model
    RepositoryAnalysis,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "PullRequest" => Type::PullRequest,
            "RepositoryAnalysis" => Type::RepositoryAnalysis,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::PullRequest => "PullRequest",
            Type::RepositoryAnalysis => "RepositoryAnalysis",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PullRequest", "RepositoryAnalysis"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobState {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobState {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => JobState::Completed,
            "Deleting" => JobState::Deleting,
            "Failed" => JobState::Failed,
            "Pending" => JobState::Pending,
            other => JobState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobState::from(s))
    }
}
impl JobState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobState::Completed => "Completed",
            JobState::Deleting => "Deleting",
            JobState::Failed => "Failed",
            JobState::Pending => "Pending",
            JobState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Deleting", "Failed", "Pending"]
    }
}
impl AsRef<str> for JobState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a repository association. The
/// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_DescribeRepositoryAssociation.html">
/// <code>DescribeRepositoryAssociation</code>
/// </a>
/// operation returns a <code>RepositoryAssociation</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryAssociation {
    /// <p>The ID of the repository association.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) identifying the repository association.</p>
    pub association_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
    /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
    /// <code>Connection</code>
    /// </a> in
    /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
    /// </p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The name of the repository.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
    /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
    /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The provider type of the repository association.</p>
    pub provider_type: std::option::Option<crate::model::ProviderType>,
    /// <p>The state of the repository association.</p>
    /// <p>The valid repository association states are:</p>
    /// <ul>
    /// <li>            
    /// <p>
    /// <b>Associated</b>: The repository
    /// association is complete.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <b>Associating</b>: CodeGuru Reviewer is:               
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// Setting up pull request notifications. This is required
    /// for pull requests to trigger a CodeGuru Reviewer review.
    /// </p>
    /// <note>
    /// <p>
    /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
    /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
    /// reviews of code in your repository cannot be triggered.
    /// </p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// Setting up source code access. This is required for CodeGuru Reviewer to securely
    /// clone code in your repository.
    /// </p>
    /// </li>
    /// </ul>            
    /// </li>
    /// <li>
    /// <p>
    /// <b>Failed</b>: The repository failed to associate or disassociate.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
    /// source code access.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
    /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
    /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
    /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
    /// </p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::RepositoryAssociationState>,
    /// <p>A description of why the repository association is in the current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the repository association was last updated.</p>
    pub last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in milliseconds since the epoch, when the repository association was created.</p>
    pub created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
    /// <ul>
    /// <li>
    /// <p>The encryption option for this repository association. It is either owned by Amazon Web Services
    /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
    /// </li>
    /// <li>
    /// <p>The ID of the Amazon Web Services KMS key that
    /// is associated with this respository association.</p>
    /// </li>
    /// </ul>
    pub kms_key_details: std::option::Option<crate::model::KmsKeyDetails>,
    /// <p>
    /// Specifies the name of an S3 bucket and a <code>CodeArtifacts</code> object that contains the S3
    /// object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
    /// </p>
    pub s3_repository_details: std::option::Option<crate::model::S3RepositoryDetails>,
}
impl std::fmt::Debug for RepositoryAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryAssociation");
        formatter.field("association_id", &self.association_id);
        formatter.field("association_arn", &self.association_arn);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("last_updated_time_stamp", &self.last_updated_time_stamp);
        formatter.field("created_time_stamp", &self.created_time_stamp);
        formatter.field("kms_key_details", &self.kms_key_details);
        formatter.field("s3_repository_details", &self.s3_repository_details);
        formatter.finish()
    }
}
/// See [`RepositoryAssociation`](crate::model::RepositoryAssociation)
pub mod repository_association {
    /// A builder for [`RepositoryAssociation`](crate::model::RepositoryAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) association_arn: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::ProviderType>,
        pub(crate) state: std::option::Option<crate::model::RepositoryAssociationState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) kms_key_details: std::option::Option<crate::model::KmsKeyDetails>,
        pub(crate) s3_repository_details: std::option::Option<crate::model::S3RepositoryDetails>,
    }
    impl Builder {
        /// <p>The ID of the repository association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of the repository association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the repository association.</p>
        pub fn association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the repository association.</p>
        pub fn set_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_arn = input;
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
        /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
        /// <code>Connection</code>
        /// </a> in
        /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
        /// </p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
        /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
        /// <code>Connection</code>
        /// </a> in
        /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
        /// </p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The name of the repository.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The provider type of the repository association.</p>
        pub fn provider_type(mut self, input: crate::model::ProviderType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>The provider type of the repository association.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// <p>The state of the repository association.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <b>Associated</b>: The repository
        /// association is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Associating</b>: CodeGuru Reviewer is:               
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting up pull request notifications. This is required
        /// for pull requests to trigger a CodeGuru Reviewer review.
        /// </p>
        /// <note>
        /// <p>
        /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
        /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
        /// reviews of code in your repository cannot be triggered.
        /// </p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// Setting up source code access. This is required for CodeGuru Reviewer to securely
        /// clone code in your repository.
        /// </p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Failed</b>: The repository failed to associate or disassociate.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
        /// source code access.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
        /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
        /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
        /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::RepositoryAssociationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the repository association.</p>
        /// <p>The valid repository association states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <b>Associated</b>: The repository
        /// association is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Associating</b>: CodeGuru Reviewer is:               
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// Setting up pull request notifications. This is required
        /// for pull requests to trigger a CodeGuru Reviewer review.
        /// </p>
        /// <note>
        /// <p>
        /// If your repository <code>ProviderType</code> is <code>GitHub</code>, <code>GitHub Enterprise Server</code>, or <code>Bitbucket</code>,
        /// CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
        /// reviews of code in your repository cannot be triggered.
        /// </p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// Setting up source code access. This is required for CodeGuru Reviewer to securely
        /// clone code in your repository.
        /// </p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Failed</b>: The repository failed to associate or disassociate.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
        /// source code access.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Disassociated</b>: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
        /// with this repository if you want to review source code in it later. You can control access to code reviews created in an
        /// associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
        /// associated repositories</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::RepositoryAssociationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>A description of why the repository association is in the current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>A description of why the repository association is in the current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the repository association was last updated.</p>
        pub fn last_updated_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time_stamp = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the repository association was last updated.</p>
        pub fn set_last_updated_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time_stamp = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the repository association was created.</p>
        pub fn created_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time_stamp = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the repository association was created.</p>
        pub fn set_created_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time_stamp = input;
            self
        }
        /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
        /// <ul>
        /// <li>
        /// <p>The encryption option for this repository association. It is either owned by Amazon Web Services
        /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
        /// </li>
        /// <li>
        /// <p>The ID of the Amazon Web Services KMS key that
        /// is associated with this respository association.</p>
        /// </li>
        /// </ul>
        pub fn kms_key_details(mut self, input: crate::model::KmsKeyDetails) -> Self {
            self.kms_key_details = Some(input);
            self
        }
        /// <p>A <code>KMSKeyDetails</code> object that contains:</p>
        /// <ul>
        /// <li>
        /// <p>The encryption option for this repository association. It is either owned by Amazon Web Services
        /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
        /// </li>
        /// <li>
        /// <p>The ID of the Amazon Web Services KMS key that
        /// is associated with this respository association.</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_details(
            mut self,
            input: std::option::Option<crate::model::KmsKeyDetails>,
        ) -> Self {
            self.kms_key_details = input;
            self
        }
        /// <p>
        /// Specifies the name of an S3 bucket and a <code>CodeArtifacts</code> object that contains the S3
        /// object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
        /// </p>
        pub fn s3_repository_details(mut self, input: crate::model::S3RepositoryDetails) -> Self {
            self.s3_repository_details = Some(input);
            self
        }
        /// <p>
        /// Specifies the name of an S3 bucket and a <code>CodeArtifacts</code> object that contains the S3
        /// object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
        /// </p>
        pub fn set_s3_repository_details(
            mut self,
            input: std::option::Option<crate::model::S3RepositoryDetails>,
        ) -> Self {
            self.s3_repository_details = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryAssociation`](crate::model::RepositoryAssociation)
        pub fn build(self) -> crate::model::RepositoryAssociation {
            crate::model::RepositoryAssociation {
                association_id: self.association_id,
                association_arn: self.association_arn,
                connection_arn: self.connection_arn,
                name: self.name,
                owner: self.owner,
                provider_type: self.provider_type,
                state: self.state,
                state_reason: self.state_reason,
                last_updated_time_stamp: self.last_updated_time_stamp,
                created_time_stamp: self.created_time_stamp,
                kms_key_details: self.kms_key_details,
                s3_repository_details: self.s3_repository_details,
            }
        }
    }
}
impl RepositoryAssociation {
    /// Creates a new builder-style object to manufacture [`RepositoryAssociation`](crate::model::RepositoryAssociation)
    pub fn builder() -> crate::model::repository_association::Builder {
        crate::model::repository_association::Builder::default()
    }
}

/// <p>An object that contains:</p>
/// <ul>
/// <li>
/// <p>The encryption option for a repository association. It is either owned by Amazon Web Services
/// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
/// </li>
/// <li>
/// <p>The ID of the Amazon Web Services KMS key that
/// is associated with a respository association.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyDetails {
    /// <p>The ID of the Amazon Web Services KMS key that is associated with a respository association.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The encryption option for a repository association. It is either owned by Amazon Web Services
    /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
    pub encryption_option: std::option::Option<crate::model::EncryptionOption>,
}
impl std::fmt::Debug for KmsKeyDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyDetails");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("encryption_option", &self.encryption_option);
        formatter.finish()
    }
}
/// See [`KmsKeyDetails`](crate::model::KmsKeyDetails)
pub mod kms_key_details {
    /// A builder for [`KmsKeyDetails`](crate::model::KmsKeyDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) encryption_option: std::option::Option<crate::model::EncryptionOption>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services KMS key that is associated with a respository association.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services KMS key that is associated with a respository association.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The encryption option for a repository association. It is either owned by Amazon Web Services
        /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
        pub fn encryption_option(mut self, input: crate::model::EncryptionOption) -> Self {
            self.encryption_option = Some(input);
            self
        }
        /// <p>The encryption option for a repository association. It is either owned by Amazon Web Services
        /// Key Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).</p>
        pub fn set_encryption_option(
            mut self,
            input: std::option::Option<crate::model::EncryptionOption>,
        ) -> Self {
            self.encryption_option = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyDetails`](crate::model::KmsKeyDetails)
        pub fn build(self) -> crate::model::KmsKeyDetails {
            crate::model::KmsKeyDetails {
                kms_key_id: self.kms_key_id,
                encryption_option: self.encryption_option,
            }
        }
    }
}
impl KmsKeyDetails {
    /// Creates a new builder-style object to manufacture [`KmsKeyDetails`](crate::model::KmsKeyDetails)
    pub fn builder() -> crate::model::kms_key_details::Builder {
        crate::model::kms_key_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionOption {
    #[allow(missing_docs)] // documentation missing in model
    AoCmk,
    #[allow(missing_docs)] // documentation missing in model
    CmCmk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionOption {
    fn from(s: &str) -> Self {
        match s {
            "AWS_OWNED_CMK" => EncryptionOption::AoCmk,
            "CUSTOMER_MANAGED_CMK" => EncryptionOption::CmCmk,
            other => EncryptionOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionOption::from(s))
    }
}
impl EncryptionOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionOption::AoCmk => "AWS_OWNED_CMK",
            EncryptionOption::CmCmk => "CUSTOMER_MANAGED_CMK",
            EncryptionOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_OWNED_CMK", "CUSTOMER_MANAGED_CMK"]
    }
}
impl AsRef<str> for EncryptionOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about the recommendation feedback.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationFeedback {
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
    /// <code>CodeReview</code>
    /// </a> object.
    /// </p>
    pub code_review_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
    /// </p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>
    /// List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
    /// </p>
    pub reactions: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
    /// <p>
    /// The ID of the user that made the API call.
    /// </p>
    /// <p>
    /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
    /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
    /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
    /// </p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>
    /// The time at which the feedback was created.
    /// </p>
    pub created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The time at which the feedback was last updated.
    /// </p>
    pub last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for RecommendationFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationFeedback");
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("reactions", &self.reactions);
        formatter.field("user_id", &self.user_id);
        formatter.field("created_time_stamp", &self.created_time_stamp);
        formatter.field("last_updated_time_stamp", &self.last_updated_time_stamp);
        formatter.finish()
    }
}
/// See [`RecommendationFeedback`](crate::model::RecommendationFeedback)
pub mod recommendation_feedback {
    /// A builder for [`RecommendationFeedback`](crate::model::RecommendationFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) reactions: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
        /// </p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>
        /// The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
        /// </p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// Appends an item to `reactions`.
        ///
        /// To override the contents of this collection use [`set_reactions`](Self::set_reactions).
        ///
        /// <p>
        /// List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
        /// </p>
        pub fn reactions(mut self, input: impl Into<crate::model::Reaction>) -> Self {
            let mut v = self.reactions.unwrap_or_default();
            v.push(input.into());
            self.reactions = Some(v);
            self
        }
        /// <p>
        /// List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
        /// </p>
        pub fn set_reactions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Reaction>>,
        ) -> Self {
            self.reactions = input;
            self
        }
        /// <p>
        /// The ID of the user that made the API call.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the user that made the API call.
        /// </p>
        /// <p>
        /// The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
        /// Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
        /// </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>
        /// The time at which the feedback was created.
        /// </p>
        pub fn created_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time_stamp = Some(input);
            self
        }
        /// <p>
        /// The time at which the feedback was created.
        /// </p>
        pub fn set_created_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time_stamp = input;
            self
        }
        /// <p>
        /// The time at which the feedback was last updated.
        /// </p>
        pub fn last_updated_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time_stamp = Some(input);
            self
        }
        /// <p>
        /// The time at which the feedback was last updated.
        /// </p>
        pub fn set_last_updated_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time_stamp = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationFeedback`](crate::model::RecommendationFeedback)
        pub fn build(self) -> crate::model::RecommendationFeedback {
            crate::model::RecommendationFeedback {
                code_review_arn: self.code_review_arn,
                recommendation_id: self.recommendation_id,
                reactions: self.reactions,
                user_id: self.user_id,
                created_time_stamp: self.created_time_stamp,
                last_updated_time_stamp: self.last_updated_time_stamp,
            }
        }
    }
}
impl RecommendationFeedback {
    /// Creates a new builder-style object to manufacture [`RecommendationFeedback`](crate::model::RecommendationFeedback)
    pub fn builder() -> crate::model::recommendation_feedback::Builder {
        crate::model::recommendation_feedback::Builder::default()
    }
}

/// <p>
/// Information about a code review. A code review belongs to the associated repository that contains the reviewed code.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeReview {
    /// <p>
    /// The name of the code review.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
    /// <code>CodeReview</code>
    /// </a> object.
    /// </p>
    pub code_review_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository.
    /// </p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
    /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
    /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>
    /// The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
    /// </p>
    pub provider_type: std::option::Option<crate::model::ProviderType>,
    /// <p>The valid code review states are:</p>
    /// <ul>
    /// <li>            
    /// <p>
    /// <code>Completed</code>: The code review is complete.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <code>Pending</code>: The code review started and has not completed or failed.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code>: The code review failed.
    /// </p>            
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleting</code>: The code review is being deleted.
    /// </p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::JobState>,
    /// <p>
    /// The reason for the state of the code review.
    /// </p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>
    /// The time, in milliseconds since the epoch, when the code review was created.
    /// </p>
    pub created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The time, in milliseconds since the epoch, when the code review was last updated.
    /// </p>
    pub last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The type of code review.
    /// </p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>
    /// The pull request ID for the code review.
    /// </p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>
    /// The type of the source code for the code review.
    /// </p>
    pub source_code_type: std::option::Option<crate::model::SourceCodeType>,
    /// <p>
    /// The Amazon Resource Name (ARN) of the  
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
    /// <code>RepositoryAssociation</code>
    /// </a> that contains
    /// the reviewed source code. You can retrieve associated repository ARNs by calling
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
    /// <code>ListRepositoryAssociations</code>
    /// </a>.
    /// </p>
    pub association_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The statistics from the code review.
    /// </p>
    pub metrics: std::option::Option<crate::model::Metrics>,
    /// <p>They types of analysis performed during a repository analysis or a pull request review. You can specify either
    /// <code>Security</code>, <code>CodeQuality</code>, or both.</p>
    pub analysis_types: std::option::Option<std::vec::Vec<crate::model::AnalysisType>>,
}
impl std::fmt::Debug for CodeReview {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeReview");
        formatter.field("name", &self.name);
        formatter.field("code_review_arn", &self.code_review_arn);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("owner", &self.owner);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("created_time_stamp", &self.created_time_stamp);
        formatter.field("last_updated_time_stamp", &self.last_updated_time_stamp);
        formatter.field("r#type", &self.r#type);
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("source_code_type", &self.source_code_type);
        formatter.field("association_arn", &self.association_arn);
        formatter.field("metrics", &self.metrics);
        formatter.field("analysis_types", &self.analysis_types);
        formatter.finish()
    }
}
/// See [`CodeReview`](crate::model::CodeReview)
pub mod code_review {
    /// A builder for [`CodeReview`](crate::model::CodeReview)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) code_review_arn: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::ProviderType>,
        pub(crate) state: std::option::Option<crate::model::JobState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) source_code_type: std::option::Option<crate::model::SourceCodeType>,
        pub(crate) association_arn: std::option::Option<std::string::String>,
        pub(crate) metrics: std::option::Option<crate::model::Metrics>,
        pub(crate) analysis_types: std::option::Option<std::vec::Vec<crate::model::AnalysisType>>,
    }
    impl Builder {
        /// <p>
        /// The name of the code review.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the code review.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn code_review_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_review_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
        /// <code>CodeReview</code>
        /// </a> object.
        /// </p>
        pub fn set_code_review_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_review_arn = input;
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
        /// account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
        /// For an S3 repository, it can be the username or Amazon Web Services account ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>
        /// The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
        /// </p>
        pub fn provider_type(mut self, input: crate::model::ProviderType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>
        /// The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
        /// </p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <code>Completed</code>: The code review is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Pending</code>: The code review started and has not completed or failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: The code review failed.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: The code review is being deleted.
        /// </p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::JobState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The valid code review states are:</p>
        /// <ul>
        /// <li>            
        /// <p>
        /// <code>Completed</code>: The code review is complete.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Pending</code>: The code review started and has not completed or failed.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: The code review failed.
        /// </p>            
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: The code review is being deleted.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<crate::model::JobState>) -> Self {
            self.state = input;
            self
        }
        /// <p>
        /// The reason for the state of the code review.
        /// </p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>
        /// The reason for the state of the code review.
        /// </p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was created.
        /// </p>
        pub fn created_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time_stamp = Some(input);
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was created.
        /// </p>
        pub fn set_created_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time_stamp = input;
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was last updated.
        /// </p>
        pub fn last_updated_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time_stamp = Some(input);
            self
        }
        /// <p>
        /// The time, in milliseconds since the epoch, when the code review was last updated.
        /// </p>
        pub fn set_last_updated_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time_stamp = input;
            self
        }
        /// <p>
        /// The type of code review.
        /// </p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// The type of code review.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>
        /// The pull request ID for the code review.
        /// </p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>
        /// The pull request ID for the code review.
        /// </p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>
        /// The type of the source code for the code review.
        /// </p>
        pub fn source_code_type(mut self, input: crate::model::SourceCodeType) -> Self {
            self.source_code_type = Some(input);
            self
        }
        /// <p>
        /// The type of the source code for the code review.
        /// </p>
        pub fn set_source_code_type(
            mut self,
            input: std::option::Option<crate::model::SourceCodeType>,
        ) -> Self {
            self.source_code_type = input;
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> that contains
        /// the reviewed source code. You can retrieve associated repository ARNs by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the  
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
        /// <code>RepositoryAssociation</code>
        /// </a> that contains
        /// the reviewed source code. You can retrieve associated repository ARNs by calling
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
        /// <code>ListRepositoryAssociations</code>
        /// </a>.
        /// </p>
        pub fn set_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_arn = input;
            self
        }
        /// <p>
        /// The statistics from the code review.
        /// </p>
        pub fn metrics(mut self, input: crate::model::Metrics) -> Self {
            self.metrics = Some(input);
            self
        }
        /// <p>
        /// The statistics from the code review.
        /// </p>
        pub fn set_metrics(mut self, input: std::option::Option<crate::model::Metrics>) -> Self {
            self.metrics = input;
            self
        }
        /// Appends an item to `analysis_types`.
        ///
        /// To override the contents of this collection use [`set_analysis_types`](Self::set_analysis_types).
        ///
        /// <p>They types of analysis performed during a repository analysis or a pull request review. You can specify either
        /// <code>Security</code>, <code>CodeQuality</code>, or both.</p>
        pub fn analysis_types(mut self, input: impl Into<crate::model::AnalysisType>) -> Self {
            let mut v = self.analysis_types.unwrap_or_default();
            v.push(input.into());
            self.analysis_types = Some(v);
            self
        }
        /// <p>They types of analysis performed during a repository analysis or a pull request review. You can specify either
        /// <code>Security</code>, <code>CodeQuality</code>, or both.</p>
        pub fn set_analysis_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisType>>,
        ) -> Self {
            self.analysis_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeReview`](crate::model::CodeReview)
        pub fn build(self) -> crate::model::CodeReview {
            crate::model::CodeReview {
                name: self.name,
                code_review_arn: self.code_review_arn,
                repository_name: self.repository_name,
                owner: self.owner,
                provider_type: self.provider_type,
                state: self.state,
                state_reason: self.state_reason,
                created_time_stamp: self.created_time_stamp,
                last_updated_time_stamp: self.last_updated_time_stamp,
                r#type: self.r#type,
                pull_request_id: self.pull_request_id,
                source_code_type: self.source_code_type,
                association_arn: self.association_arn,
                metrics: self.metrics,
                analysis_types: self.analysis_types,
            }
        }
    }
}
impl CodeReview {
    /// Creates a new builder-style object to manufacture [`CodeReview`](crate::model::CodeReview)
    pub fn builder() -> crate::model::code_review::Builder {
        crate::model::code_review::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalysisType {
    #[allow(missing_docs)] // documentation missing in model
    CodeQuality,
    #[allow(missing_docs)] // documentation missing in model
    Security,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalysisType {
    fn from(s: &str) -> Self {
        match s {
            "CodeQuality" => AnalysisType::CodeQuality,
            "Security" => AnalysisType::Security,
            other => AnalysisType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalysisType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalysisType::from(s))
    }
}
impl AnalysisType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalysisType::CodeQuality => "CodeQuality",
            AnalysisType::Security => "Security",
            AnalysisType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CodeQuality", "Security"]
    }
}
impl AsRef<str> for AnalysisType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about the statistics from the code review.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metrics {
    /// <p>
    /// <code>MeteredLinesOfCode</code> is the number of lines of code in the repository where the code review happened.
    /// This does not include non-code lines such as comments and blank lines.
    /// </p>
    pub metered_lines_of_code_count: std::option::Option<i64>,
    /// <p>
    /// Total number of recommendations found in the code review.
    /// </p>
    pub findings_count: std::option::Option<i64>,
}
impl std::fmt::Debug for Metrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metrics");
        formatter.field(
            "metered_lines_of_code_count",
            &self.metered_lines_of_code_count,
        );
        formatter.field("findings_count", &self.findings_count);
        formatter.finish()
    }
}
/// See [`Metrics`](crate::model::Metrics)
pub mod metrics {
    /// A builder for [`Metrics`](crate::model::Metrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metered_lines_of_code_count: std::option::Option<i64>,
        pub(crate) findings_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>
        /// <code>MeteredLinesOfCode</code> is the number of lines of code in the repository where the code review happened.
        /// This does not include non-code lines such as comments and blank lines.
        /// </p>
        pub fn metered_lines_of_code_count(mut self, input: i64) -> Self {
            self.metered_lines_of_code_count = Some(input);
            self
        }
        /// <p>
        /// <code>MeteredLinesOfCode</code> is the number of lines of code in the repository where the code review happened.
        /// This does not include non-code lines such as comments and blank lines.
        /// </p>
        pub fn set_metered_lines_of_code_count(mut self, input: std::option::Option<i64>) -> Self {
            self.metered_lines_of_code_count = input;
            self
        }
        /// <p>
        /// Total number of recommendations found in the code review.
        /// </p>
        pub fn findings_count(mut self, input: i64) -> Self {
            self.findings_count = Some(input);
            self
        }
        /// <p>
        /// Total number of recommendations found in the code review.
        /// </p>
        pub fn set_findings_count(mut self, input: std::option::Option<i64>) -> Self {
            self.findings_count = input;
            self
        }
        /// Consumes the builder and constructs a [`Metrics`](crate::model::Metrics)
        pub fn build(self) -> crate::model::Metrics {
            crate::model::Metrics {
                metered_lines_of_code_count: self.metered_lines_of_code_count,
                findings_count: self.findings_count,
            }
        }
    }
}
impl Metrics {
    /// Creates a new builder-style object to manufacture [`Metrics`](crate::model::Metrics)
    pub fn builder() -> crate::model::metrics::Builder {
        crate::model::metrics::Builder::default()
    }
}

/// <p>
/// The type of a code review. There are two code review types:         
/// </p>
/// <ul>
/// <li>
/// <p>
/// <code>PullRequest</code> - A code review that is automatically triggered by a pull request on an associated repository.
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>RepositoryAnalysis</code> - A code review that analyzes all code under a specified
/// branch in an associated repository. The associated repository is specified using its ARN
/// in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
/// <code>CreateCodeReview</code>
/// </a>. </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeReviewType {
    /// <p> A code review that analyzes all code under a specified branch in an associated
    /// repository. The associated repository is specified using its ARN in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
    /// <code>CreateCodeReview</code>
    /// </a>. </p>
    pub repository_analysis: std::option::Option<crate::model::RepositoryAnalysis>,
    /// <p>They types of analysis performed during a repository analysis or a pull request review. You can specify either
    /// <code>Security</code>, <code>CodeQuality</code>, or both.</p>
    pub analysis_types: std::option::Option<std::vec::Vec<crate::model::AnalysisType>>,
}
impl std::fmt::Debug for CodeReviewType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeReviewType");
        formatter.field("repository_analysis", &self.repository_analysis);
        formatter.field("analysis_types", &self.analysis_types);
        formatter.finish()
    }
}
/// See [`CodeReviewType`](crate::model::CodeReviewType)
pub mod code_review_type {
    /// A builder for [`CodeReviewType`](crate::model::CodeReviewType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_analysis: std::option::Option<crate::model::RepositoryAnalysis>,
        pub(crate) analysis_types: std::option::Option<std::vec::Vec<crate::model::AnalysisType>>,
    }
    impl Builder {
        /// <p> A code review that analyzes all code under a specified branch in an associated
        /// repository. The associated repository is specified using its ARN in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
        /// <code>CreateCodeReview</code>
        /// </a>. </p>
        pub fn repository_analysis(mut self, input: crate::model::RepositoryAnalysis) -> Self {
            self.repository_analysis = Some(input);
            self
        }
        /// <p> A code review that analyzes all code under a specified branch in an associated
        /// repository. The associated repository is specified using its ARN in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
        /// <code>CreateCodeReview</code>
        /// </a>. </p>
        pub fn set_repository_analysis(
            mut self,
            input: std::option::Option<crate::model::RepositoryAnalysis>,
        ) -> Self {
            self.repository_analysis = input;
            self
        }
        /// Appends an item to `analysis_types`.
        ///
        /// To override the contents of this collection use [`set_analysis_types`](Self::set_analysis_types).
        ///
        /// <p>They types of analysis performed during a repository analysis or a pull request review. You can specify either
        /// <code>Security</code>, <code>CodeQuality</code>, or both.</p>
        pub fn analysis_types(mut self, input: impl Into<crate::model::AnalysisType>) -> Self {
            let mut v = self.analysis_types.unwrap_or_default();
            v.push(input.into());
            self.analysis_types = Some(v);
            self
        }
        /// <p>They types of analysis performed during a repository analysis or a pull request review. You can specify either
        /// <code>Security</code>, <code>CodeQuality</code>, or both.</p>
        pub fn set_analysis_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisType>>,
        ) -> Self {
            self.analysis_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeReviewType`](crate::model::CodeReviewType)
        pub fn build(self) -> crate::model::CodeReviewType {
            crate::model::CodeReviewType {
                repository_analysis: self.repository_analysis,
                analysis_types: self.analysis_types,
            }
        }
    }
}
impl CodeReviewType {
    /// Creates a new builder-style object to manufacture [`CodeReviewType`](crate::model::CodeReviewType)
    pub fn builder() -> crate::model::code_review_type::Builder {
        crate::model::code_review_type::Builder::default()
    }
}

/// <p> A code review type that analyzes all code under a specified branch in an associated
/// repository. The associated repository is specified using its ARN when you call <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
/// <code>CreateCodeReview</code>
/// </a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryAnalysis {
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
    /// <code>SourceCodeType</code>
    /// </a> that
    /// specifies the tip of a branch in an associated repository.
    /// </p>
    pub repository_head: std::option::Option<crate::model::RepositoryHeadSourceCodeType>,
    /// <p>
    /// Specifies the source code that is analyzed in a code review.
    /// </p>
    pub source_code_type: std::option::Option<crate::model::SourceCodeType>,
}
impl std::fmt::Debug for RepositoryAnalysis {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryAnalysis");
        formatter.field("repository_head", &self.repository_head);
        formatter.field("source_code_type", &self.source_code_type);
        formatter.finish()
    }
}
/// See [`RepositoryAnalysis`](crate::model::RepositoryAnalysis)
pub mod repository_analysis {
    /// A builder for [`RepositoryAnalysis`](crate::model::RepositoryAnalysis)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_head: std::option::Option<crate::model::RepositoryHeadSourceCodeType>,
        pub(crate) source_code_type: std::option::Option<crate::model::SourceCodeType>,
    }
    impl Builder {
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that
        /// specifies the tip of a branch in an associated repository.
        /// </p>
        pub fn repository_head(
            mut self,
            input: crate::model::RepositoryHeadSourceCodeType,
        ) -> Self {
            self.repository_head = Some(input);
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
        /// <code>SourceCodeType</code>
        /// </a> that
        /// specifies the tip of a branch in an associated repository.
        /// </p>
        pub fn set_repository_head(
            mut self,
            input: std::option::Option<crate::model::RepositoryHeadSourceCodeType>,
        ) -> Self {
            self.repository_head = input;
            self
        }
        /// <p>
        /// Specifies the source code that is analyzed in a code review.
        /// </p>
        pub fn source_code_type(mut self, input: crate::model::SourceCodeType) -> Self {
            self.source_code_type = Some(input);
            self
        }
        /// <p>
        /// Specifies the source code that is analyzed in a code review.
        /// </p>
        pub fn set_source_code_type(
            mut self,
            input: std::option::Option<crate::model::SourceCodeType>,
        ) -> Self {
            self.source_code_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryAnalysis`](crate::model::RepositoryAnalysis)
        pub fn build(self) -> crate::model::RepositoryAnalysis {
            crate::model::RepositoryAnalysis {
                repository_head: self.repository_head,
                source_code_type: self.source_code_type,
            }
        }
    }
}
impl RepositoryAnalysis {
    /// Creates a new builder-style object to manufacture [`RepositoryAnalysis`](crate::model::RepositoryAnalysis)
    pub fn builder() -> crate::model::repository_analysis::Builder {
        crate::model::repository_analysis::Builder::default()
    }
}

/// <p>
/// Information about an associated Amazon Web Services CodeCommit repository or an associated repository that is managed
/// by Amazon Web Services CodeStar Connections (for example, Bitbucket). This <code>Repository</code> object
/// is not used if your source code is in an associated GitHub repository.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Repository {
    /// <p>Information about an Amazon Web Services CodeCommit repository.</p>
    pub code_commit: std::option::Option<crate::model::CodeCommitRepository>,
    /// <p>
    /// Information about a Bitbucket repository.
    /// </p>
    pub bitbucket: std::option::Option<crate::model::ThirdPartySourceRepository>,
    /// <p>
    /// Information about a GitHub Enterprise Server repository.
    /// </p>
    pub git_hub_enterprise_server: std::option::Option<crate::model::ThirdPartySourceRepository>,
    /// <p>
    /// Information about a repository in an S3 bucket.
    /// </p>
    pub s3_bucket: std::option::Option<crate::model::S3Repository>,
}
impl std::fmt::Debug for Repository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Repository");
        formatter.field("code_commit", &self.code_commit);
        formatter.field("bitbucket", &self.bitbucket);
        formatter.field("git_hub_enterprise_server", &self.git_hub_enterprise_server);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.finish()
    }
}
/// See [`Repository`](crate::model::Repository)
pub mod repository {
    /// A builder for [`Repository`](crate::model::Repository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_commit: std::option::Option<crate::model::CodeCommitRepository>,
        pub(crate) bitbucket: std::option::Option<crate::model::ThirdPartySourceRepository>,
        pub(crate) git_hub_enterprise_server:
            std::option::Option<crate::model::ThirdPartySourceRepository>,
        pub(crate) s3_bucket: std::option::Option<crate::model::S3Repository>,
    }
    impl Builder {
        /// <p>Information about an Amazon Web Services CodeCommit repository.</p>
        pub fn code_commit(mut self, input: crate::model::CodeCommitRepository) -> Self {
            self.code_commit = Some(input);
            self
        }
        /// <p>Information about an Amazon Web Services CodeCommit repository.</p>
        pub fn set_code_commit(
            mut self,
            input: std::option::Option<crate::model::CodeCommitRepository>,
        ) -> Self {
            self.code_commit = input;
            self
        }
        /// <p>
        /// Information about a Bitbucket repository.
        /// </p>
        pub fn bitbucket(mut self, input: crate::model::ThirdPartySourceRepository) -> Self {
            self.bitbucket = Some(input);
            self
        }
        /// <p>
        /// Information about a Bitbucket repository.
        /// </p>
        pub fn set_bitbucket(
            mut self,
            input: std::option::Option<crate::model::ThirdPartySourceRepository>,
        ) -> Self {
            self.bitbucket = input;
            self
        }
        /// <p>
        /// Information about a GitHub Enterprise Server repository.
        /// </p>
        pub fn git_hub_enterprise_server(
            mut self,
            input: crate::model::ThirdPartySourceRepository,
        ) -> Self {
            self.git_hub_enterprise_server = Some(input);
            self
        }
        /// <p>
        /// Information about a GitHub Enterprise Server repository.
        /// </p>
        pub fn set_git_hub_enterprise_server(
            mut self,
            input: std::option::Option<crate::model::ThirdPartySourceRepository>,
        ) -> Self {
            self.git_hub_enterprise_server = input;
            self
        }
        /// <p>
        /// Information about a repository in an S3 bucket.
        /// </p>
        pub fn s3_bucket(mut self, input: crate::model::S3Repository) -> Self {
            self.s3_bucket = Some(input);
            self
        }
        /// <p>
        /// Information about a repository in an S3 bucket.
        /// </p>
        pub fn set_s3_bucket(
            mut self,
            input: std::option::Option<crate::model::S3Repository>,
        ) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`Repository`](crate::model::Repository)
        pub fn build(self) -> crate::model::Repository {
            crate::model::Repository {
                code_commit: self.code_commit,
                bitbucket: self.bitbucket,
                git_hub_enterprise_server: self.git_hub_enterprise_server,
                s3_bucket: self.s3_bucket,
            }
        }
    }
}
impl Repository {
    /// Creates a new builder-style object to manufacture [`Repository`](crate::model::Repository)
    pub fn builder() -> crate::model::repository::Builder {
        crate::model::repository::Builder::default()
    }
}

/// <p>
/// Information about a repository in an S3 bucket.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Repository {
    /// <p> The name of the repository in the S3 bucket. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the S3 bucket used for associating a new S3 repository. It must begin with
    /// <code>codeguru-reviewer-</code>. </p>
    pub bucket_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Repository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Repository");
        formatter.field("name", &self.name);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.finish()
    }
}
/// See [`S3Repository`](crate::model::S3Repository)
pub mod s3_repository {
    /// A builder for [`S3Repository`](crate::model::S3Repository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the repository in the S3 bucket. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the repository in the S3 bucket. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the S3 bucket used for associating a new S3 repository. It must begin with
        /// <code>codeguru-reviewer-</code>. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket used for associating a new S3 repository. It must begin with
        /// <code>codeguru-reviewer-</code>. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Repository`](crate::model::S3Repository)
        pub fn build(self) -> crate::model::S3Repository {
            crate::model::S3Repository {
                name: self.name,
                bucket_name: self.bucket_name,
            }
        }
    }
}
impl S3Repository {
    /// Creates a new builder-style object to manufacture [`S3Repository`](crate::model::S3Repository)
    pub fn builder() -> crate::model::s3_repository::Builder {
        crate::model::s3_repository::Builder::default()
    }
}

/// <p>
/// Information about a third-party source repository connected to CodeGuru Reviewer.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThirdPartySourceRepository {
    /// <p>
    /// The name of the third party source repository.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
    /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
    /// <code>Connection</code>
    /// </a> in
    /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
    /// </p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
    /// this is the username for the account that owns the repository. For an S3 repository,
    /// this can be the username or Amazon Web Services account ID.
    /// </p>
    pub owner: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThirdPartySourceRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThirdPartySourceRepository");
        formatter.field("name", &self.name);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("owner", &self.owner);
        formatter.finish()
    }
}
/// See [`ThirdPartySourceRepository`](crate::model::ThirdPartySourceRepository)
pub mod third_party_source_repository {
    /// A builder for [`ThirdPartySourceRepository`](crate::model::ThirdPartySourceRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the third party source repository.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the third party source repository.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
        /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
        /// <code>Connection</code>
        /// </a> in
        /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
        /// </p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
        /// <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
        /// <code>Connection</code>
        /// </a> in
        /// the <i>Amazon Web Services CodeStar Connections API Reference</i>.
        /// </p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>
        /// The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
        /// this is the username for the account that owns the repository. For an S3 repository,
        /// this can be the username or Amazon Web Services account ID.
        /// </p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>
        /// The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
        /// this is the username for the account that owns the repository. For an S3 repository,
        /// this can be the username or Amazon Web Services account ID.
        /// </p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ThirdPartySourceRepository`](crate::model::ThirdPartySourceRepository)
        pub fn build(self) -> crate::model::ThirdPartySourceRepository {
            crate::model::ThirdPartySourceRepository {
                name: self.name,
                connection_arn: self.connection_arn,
                owner: self.owner,
            }
        }
    }
}
impl ThirdPartySourceRepository {
    /// Creates a new builder-style object to manufacture [`ThirdPartySourceRepository`](crate::model::ThirdPartySourceRepository)
    pub fn builder() -> crate::model::third_party_source_repository::Builder {
        crate::model::third_party_source_repository::Builder::default()
    }
}

/// <p>Information about an Amazon Web Services CodeCommit repository. The CodeCommit repository must be in the same
/// Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeCommitRepository {
    /// <p>The name of the Amazon Web Services CodeCommit repository. For more information, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName">repositoryName</a>
    /// in the <i>Amazon Web Services CodeCommit API Reference</i>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CodeCommitRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeCommitRepository");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CodeCommitRepository`](crate::model::CodeCommitRepository)
pub mod code_commit_repository {
    /// A builder for [`CodeCommitRepository`](crate::model::CodeCommitRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Web Services CodeCommit repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName">repositoryName</a>
        /// in the <i>Amazon Web Services CodeCommit API Reference</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services CodeCommit repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName">repositoryName</a>
        /// in the <i>Amazon Web Services CodeCommit API Reference</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeCommitRepository`](crate::model::CodeCommitRepository)
        pub fn build(self) -> crate::model::CodeCommitRepository {
            crate::model::CodeCommitRepository { name: self.name }
        }
    }
}
impl CodeCommitRepository {
    /// Creates a new builder-style object to manufacture [`CodeCommitRepository`](crate::model::CodeCommitRepository)
    pub fn builder() -> crate::model::code_commit_repository::Builder {
        crate::model::code_commit_repository::Builder::default()
    }
}
