// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CodeGuru Profiler
///
/// Client for invoking operations on Amazon CodeGuru Profiler. Each operation on Amazon CodeGuru Profiler is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codeguruprofiler::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codeguruprofiler::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codeguruprofiler::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddNotificationChannels` operation.
    ///
    /// See [`AddNotificationChannels`](crate::client::fluent_builders::AddNotificationChannels) for more information about the
    /// operation and its arguments.
    pub fn add_notification_channels(&self) -> fluent_builders::AddNotificationChannels<C, M, R> {
        fluent_builders::AddNotificationChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetFrameMetricData` operation.
    ///
    /// See [`BatchGetFrameMetricData`](crate::client::fluent_builders::BatchGetFrameMetricData) for more information about the
    /// operation and its arguments.
    pub fn batch_get_frame_metric_data(&self) -> fluent_builders::BatchGetFrameMetricData<C, M, R> {
        fluent_builders::BatchGetFrameMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfigureAgent` operation.
    ///
    /// See [`ConfigureAgent`](crate::client::fluent_builders::ConfigureAgent) for more information about the
    /// operation and its arguments.
    pub fn configure_agent(&self) -> fluent_builders::ConfigureAgent<C, M, R> {
        fluent_builders::ConfigureAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProfilingGroup` operation.
    ///
    /// See [`CreateProfilingGroup`](crate::client::fluent_builders::CreateProfilingGroup) for more information about the
    /// operation and its arguments.
    pub fn create_profiling_group(&self) -> fluent_builders::CreateProfilingGroup<C, M, R> {
        fluent_builders::CreateProfilingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProfilingGroup` operation.
    ///
    /// See [`DeleteProfilingGroup`](crate::client::fluent_builders::DeleteProfilingGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_profiling_group(&self) -> fluent_builders::DeleteProfilingGroup<C, M, R> {
        fluent_builders::DeleteProfilingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProfilingGroup` operation.
    ///
    /// See [`DescribeProfilingGroup`](crate::client::fluent_builders::DescribeProfilingGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_profiling_group(&self) -> fluent_builders::DescribeProfilingGroup<C, M, R> {
        fluent_builders::DescribeProfilingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindingsReportAccountSummary` operation.
    ///
    /// See [`GetFindingsReportAccountSummary`](crate::client::fluent_builders::GetFindingsReportAccountSummary) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetFindingsReportAccountSummary::into_paginator).
    pub fn get_findings_report_account_summary(
        &self,
    ) -> fluent_builders::GetFindingsReportAccountSummary<C, M, R> {
        fluent_builders::GetFindingsReportAccountSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNotificationConfiguration` operation.
    ///
    /// See [`GetNotificationConfiguration`](crate::client::fluent_builders::GetNotificationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_notification_configuration(
        &self,
    ) -> fluent_builders::GetNotificationConfiguration<C, M, R> {
        fluent_builders::GetNotificationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPolicy` operation.
    ///
    /// See [`GetPolicy`](crate::client::fluent_builders::GetPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_policy(&self) -> fluent_builders::GetPolicy<C, M, R> {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProfile` operation.
    ///
    /// See [`GetProfile`](crate::client::fluent_builders::GetProfile) for more information about the
    /// operation and its arguments.
    pub fn get_profile(&self) -> fluent_builders::GetProfile<C, M, R> {
        fluent_builders::GetProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecommendations` operation.
    ///
    /// See [`GetRecommendations`](crate::client::fluent_builders::GetRecommendations) for more information about the
    /// operation and its arguments.
    pub fn get_recommendations(&self) -> fluent_builders::GetRecommendations<C, M, R> {
        fluent_builders::GetRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindingsReports` operation.
    ///
    /// See [`ListFindingsReports`](crate::client::fluent_builders::ListFindingsReports) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFindingsReports::into_paginator).
    pub fn list_findings_reports(&self) -> fluent_builders::ListFindingsReports<C, M, R> {
        fluent_builders::ListFindingsReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProfileTimes` operation.
    ///
    /// See [`ListProfileTimes`](crate::client::fluent_builders::ListProfileTimes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProfileTimes::into_paginator).
    pub fn list_profile_times(&self) -> fluent_builders::ListProfileTimes<C, M, R> {
        fluent_builders::ListProfileTimes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProfilingGroups` operation.
    ///
    /// See [`ListProfilingGroups`](crate::client::fluent_builders::ListProfilingGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProfilingGroups::into_paginator).
    pub fn list_profiling_groups(&self) -> fluent_builders::ListProfilingGroups<C, M, R> {
        fluent_builders::ListProfilingGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PostAgentProfile` operation.
    ///
    /// See [`PostAgentProfile`](crate::client::fluent_builders::PostAgentProfile) for more information about the
    /// operation and its arguments.
    pub fn post_agent_profile(&self) -> fluent_builders::PostAgentProfile<C, M, R> {
        fluent_builders::PostAgentProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPermission` operation.
    ///
    /// See [`PutPermission`](crate::client::fluent_builders::PutPermission) for more information about the
    /// operation and its arguments.
    pub fn put_permission(&self) -> fluent_builders::PutPermission<C, M, R> {
        fluent_builders::PutPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveNotificationChannel` operation.
    ///
    /// See [`RemoveNotificationChannel`](crate::client::fluent_builders::RemoveNotificationChannel) for more information about the
    /// operation and its arguments.
    pub fn remove_notification_channel(
        &self,
    ) -> fluent_builders::RemoveNotificationChannel<C, M, R> {
        fluent_builders::RemoveNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemovePermission` operation.
    ///
    /// See [`RemovePermission`](crate::client::fluent_builders::RemovePermission) for more information about the
    /// operation and its arguments.
    pub fn remove_permission(&self) -> fluent_builders::RemovePermission<C, M, R> {
        fluent_builders::RemovePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SubmitFeedback` operation.
    ///
    /// See [`SubmitFeedback`](crate::client::fluent_builders::SubmitFeedback) for more information about the
    /// operation and its arguments.
    pub fn submit_feedback(&self) -> fluent_builders::SubmitFeedback<C, M, R> {
        fluent_builders::SubmitFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProfilingGroup` operation.
    ///
    /// See [`UpdateProfilingGroup`](crate::client::fluent_builders::UpdateProfilingGroup) for more information about the
    /// operation and its arguments.
    pub fn update_profiling_group(&self) -> fluent_builders::UpdateProfilingGroup<C, M, R> {
        fluent_builders::UpdateProfilingGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddNotificationChannels`.
    ///
    /// <p>Add up to 2 anomaly notifications channels for a profiling group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddNotificationChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_notification_channels_input::Builder,
    }
    impl<C, M, R> AddNotificationChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddNotificationChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddNotificationChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddNotificationChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddNotificationChannelsInputOperationOutputAlias,
                crate::output::AddNotificationChannelsOutput,
                crate::error::AddNotificationChannelsError,
                crate::input::AddNotificationChannelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group that we are setting up notifications for.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group that we are setting up notifications for.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>One or 2 channels to report to when anomalies are detected.</p>
        pub fn channels(mut self, input: crate::model::Channel) -> Self {
            self.inner = self.inner.channels(input);
            self
        }
        /// <p>One or 2 channels to report to when anomalies are detected.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.inner = self.inner.set_channels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetFrameMetricData`.
    ///
    /// <p> Returns the time series of values for a requested list of frame metrics from a time period.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetFrameMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_frame_metric_data_input::Builder,
    }
    impl<C, M, R> BatchGetFrameMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetFrameMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetFrameMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetFrameMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetFrameMetricDataInputOperationOutputAlias,
                crate::output::BatchGetFrameMetricDataOutput,
                crate::error::BatchGetFrameMetricDataError,
                crate::input::BatchGetFrameMetricDataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the profiling group associated with the the frame metrics used to return the time series values. </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p> The name of the profiling group associated with the the frame metrics used to return the time series values. </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> The start time of the time period for the frame metrics used to return the time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p> The start time of the time period for the frame metrics used to return the time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The end time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The end time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> The duration of the frame metrics used to return the time series values. Specify using the ISO 8601 format. The maximum period duration is one day (<code>PT24H</code> or <code>P1D</code>). </p>
        pub fn period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.period(input.into());
            self
        }
        /// <p> The duration of the frame metrics used to return the time series values. Specify using the ISO 8601 format. The maximum period duration is one day (<code>PT24H</code> or <code>P1D</code>). </p>
        pub fn set_period(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The requested resolution of time steps for the returned time series of values. If the requested target resolution is not available due to data not being retained we provide a best effort result by falling back to the most granular available resolution after the target resolution. There are 3 valid values. </p>
        /// <ul>
        /// <li> <p> <code>P1D</code> — 1 day </p> </li>
        /// <li> <p> <code>PT1H</code> — 1 hour </p> </li>
        /// <li> <p> <code>PT5M</code> — 5 minutes </p> </li>
        /// </ul>
        pub fn target_resolution(mut self, input: crate::model::AggregationPeriod) -> Self {
            self.inner = self.inner.target_resolution(input);
            self
        }
        /// <p>The requested resolution of time steps for the returned time series of values. If the requested target resolution is not available due to data not being retained we provide a best effort result by falling back to the most granular available resolution after the target resolution. There are 3 valid values. </p>
        /// <ul>
        /// <li> <p> <code>P1D</code> — 1 day </p> </li>
        /// <li> <p> <code>PT1H</code> — 1 hour </p> </li>
        /// <li> <p> <code>PT5M</code> — 5 minutes </p> </li>
        /// </ul>
        pub fn set_target_resolution(
            mut self,
            input: std::option::Option<crate::model::AggregationPeriod>,
        ) -> Self {
            self.inner = self.inner.set_target_resolution(input);
            self
        }
        /// Appends an item to `frameMetrics`.
        ///
        /// To override the contents of this collection use [`set_frame_metrics`](Self::set_frame_metrics).
        ///
        /// <p> The details of the metrics that are used to request a time series of values. The metric includes the name of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for the metric value of the frame.</p>
        pub fn frame_metrics(mut self, input: crate::model::FrameMetric) -> Self {
            self.inner = self.inner.frame_metrics(input);
            self
        }
        /// <p> The details of the metrics that are used to request a time series of values. The metric includes the name of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for the metric value of the frame.</p>
        pub fn set_frame_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameMetric>>,
        ) -> Self {
            self.inner = self.inner.set_frame_metrics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfigureAgent`.
    ///
    /// <p> Used by profiler agents to report their current state and to receive remote configuration updates. For example, <code>ConfigureAgent</code> can be used to tell an agent whether to profile or not and for how long to return profiling data. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfigureAgent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::configure_agent_input::Builder,
    }
    impl<C, M, R> ConfigureAgent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfigureAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfigureAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfigureAgentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfigureAgentInputOperationOutputAlias,
                crate::output::ConfigureAgentOutput,
                crate::error::ConfigureAgentError,
                crate::input::ConfigureAgentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the profiling group for which the configured agent is collecting profiling data. </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p> The name of the profiling group for which the configured agent is collecting profiling data. </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the container's task ID. </p>
        pub fn fleet_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_instance_id(input.into());
            self
        }
        /// <p> A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the container's task ID. </p>
        pub fn set_fleet_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fleet_instance_id(input);
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p> Metadata captured about the compute platform the agent is running on. It includes information about sampling and reporting. The valid fields are:</p>
        /// <ul>
        /// <li> <p> <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running </p> </li>
        /// <li> <p> <code>AGENT_ID</code> - The ID for an agent instance. </p> </li>
        /// <li> <p> <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation. </p> </li>
        /// <li> <p> <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on. </p> </li>
        /// <li> <p> <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function. </p> </li>
        /// <li> <p> <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function. </p> </li>
        /// <li> <p> <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda function times out. </p> </li>
        /// <li> <p> <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations of a Lambda function. </p> </li>
        /// <li> <p> <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda invocation. </p> </li>
        /// </ul>
        pub fn metadata(
            mut self,
            k: crate::model::MetadataField,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k, v.into());
            self
        }
        /// <p> Metadata captured about the compute platform the agent is running on. It includes information about sampling and reporting. The valid fields are:</p>
        /// <ul>
        /// <li> <p> <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running </p> </li>
        /// <li> <p> <code>AGENT_ID</code> - The ID for an agent instance. </p> </li>
        /// <li> <p> <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation. </p> </li>
        /// <li> <p> <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on. </p> </li>
        /// <li> <p> <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function. </p> </li>
        /// <li> <p> <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function. </p> </li>
        /// <li> <p> <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda function times out. </p> </li>
        /// <li> <p> <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations of a Lambda function. </p> </li>
        /// <li> <p> <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda invocation. </p> </li>
        /// </ul>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::MetadataField, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProfilingGroup`.
    ///
    /// <p>Creates a profiling group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProfilingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_profiling_group_input::Builder,
    }
    impl<C, M, R> CreateProfilingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProfilingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProfilingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProfilingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProfilingGroupInputOperationOutputAlias,
                crate::output::CreateProfilingGroupOutput,
                crate::error::CreateProfilingGroupError,
                crate::input::CreateProfilingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group to create.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group to create.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, <code>Default</code> is used. </p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.inner = self.inner.compute_platform(input);
            self
        }
        /// <p> The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, <code>Default</code> is used. </p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.inner = self.inner.set_compute_platform(input);
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of duplicate profiling groups if there are failures and retries. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of duplicate profiling groups if there are failures and retries. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p> Specifies whether profiling is enabled or disabled for the created profiling group. </p>
        pub fn agent_orchestration_config(
            mut self,
            input: crate::model::AgentOrchestrationConfig,
        ) -> Self {
            self.inner = self.inner.agent_orchestration_config(input);
            self
        }
        /// <p> Specifies whether profiling is enabled or disabled for the created profiling group. </p>
        pub fn set_agent_orchestration_config(
            mut self,
            input: std::option::Option<crate::model::AgentOrchestrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_agent_orchestration_config(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A list of tags to add to the created profiling group. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A list of tags to add to the created profiling group. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfilingGroup`.
    ///
    /// <p>Deletes a profiling group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProfilingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_profiling_group_input::Builder,
    }
    impl<C, M, R> DeleteProfilingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProfilingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfilingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfilingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProfilingGroupInputOperationOutputAlias,
                crate::output::DeleteProfilingGroupOutput,
                crate::error::DeleteProfilingGroupError,
                crate::input::DeleteProfilingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group to delete.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group to delete.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProfilingGroup`.
    ///
    /// <p> Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> object that contains information about the requested profiling group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProfilingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_profiling_group_input::Builder,
    }
    impl<C, M, R> DescribeProfilingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProfilingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProfilingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProfilingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProfilingGroupInputOperationOutputAlias,
                crate::output::DescribeProfilingGroupOutput,
                crate::error::DescribeProfilingGroupError,
                crate::input::DescribeProfilingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the profiling group to get information about. </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p> The name of the profiling group to get information about. </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindingsReportAccountSummary`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html"> <code>FindingsReportSummary</code> </a> objects that contain analysis results for all profiling groups in your AWS account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindingsReportAccountSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_report_account_summary_input::Builder,
    }
    impl<C, M, R> GetFindingsReportAccountSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingsReportAccountSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsReportAccountSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsReportAccountSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsReportAccountSummaryInputOperationOutputAlias,
                crate::output::GetFindingsReportAccountSummaryOutput,
                crate::error::GetFindingsReportAccountSummaryError,
                crate::input::GetFindingsReportAccountSummaryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetFindingsReportAccountSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetFindingsReportAccountSummaryPaginator<C, M, R> {
            crate::paginator::GetFindingsReportAccountSummaryPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>GetFindingsReportAccountSummary</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>GetFindingsReportAccountSummary</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code> GetFindingsReportAccountSummary</code> in paginated output. When this parameter is used, <code>GetFindingsReportAccountSummary</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>GetFindingsReportAccountSummary</code> request with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by <code> GetFindingsReportAccountSummary</code> in paginated output. When this parameter is used, <code>GetFindingsReportAccountSummary</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>GetFindingsReportAccountSummary</code> request with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn daily_reports_only(mut self, input: bool) -> Self {
            self.inner = self.inner.daily_reports_only(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn set_daily_reports_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_daily_reports_only(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNotificationConfiguration`.
    ///
    /// <p>Get the current configuration for anomaly notifications for a profiling group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNotificationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_notification_configuration_input::Builder,
    }
    impl<C, M, R> GetNotificationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNotificationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNotificationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNotificationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNotificationConfigurationInputOperationOutputAlias,
                crate::output::GetNotificationConfigurationOutput,
                crate::error::GetNotificationConfigurationError,
                crate::input::GetNotificationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group we want to get the notification configuration for.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group we want to get the notification configuration for.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// <p> Returns the JSON-formatted resource-based policy on a profiling group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl<C, M, R> GetPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyInputOperationOutputAlias,
                crate::output::GetPolicyOutput,
                crate::error::GetPolicyError,
                crate::input::GetPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProfile`.
    ///
    /// <p> Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles. </p> <note>
    /// <p> Because aggregated profiles expire over time <code>GetProfile</code> is not idempotent. </p>
    /// </note>
    /// <p> Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: <code>startTime</code>, <code>endTime</code>, <code>period</code>. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only <code>period</code>, the latest aggregated profile is returned. </p>
    /// <p> Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html"> <code>AggregatedProfileTime</code> </a>. The aggregated profile's aggregation period determines how long it is retained by CodeGuru Profiler. </p>
    /// <ul>
    /// <li> <p> If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days. </p> </li>
    /// <li> <p> If the aggregation period is 1 hour, the aggregated profile is retained for 60 days. </p> </li>
    /// <li> <p> If the aggregation period is 1 day, the aggregated profile is retained for 3 years. </p> </li>
    /// </ul>
    /// <p>There are two use cases for calling <code>GetProfile</code>.</p>
    /// <ol>
    /// <li> <p> If you want to return an aggregated profile that already exists, use <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html"> <code>ListProfileTimes</code> </a> to view the time ranges of existing aggregated profiles. Use them in a <code>GetProfile</code> request to return a specific, existing aggregated profile. </p> </li>
    /// <li> <p> If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile. </p> <p> If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned. </p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_profile_input::Builder,
    }
    impl<C, M, R> GetProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProfileInputOperationOutputAlias,
                crate::output::GetProfileOutput,
                crate::error::GetProfileError,
                crate::input::GetProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group to get.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group to get.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p>The start time of the profile to get. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        /// <p> If you specify <code>startTime</code>, then you must also specify <code>period</code> or <code>endTime</code>, but not both. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time of the profile to get. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        /// <p> If you specify <code>startTime</code>, then you must also specify <code>period</code> or <code>endTime</code>, but not both. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> Used with <code>startTime</code> or <code>endTime</code> to specify the time range for the returned aggregated profile. Specify using the ISO 8601 format. For example, <code>P1DT1H1M1S</code>. </p>
        /// <p> To get the latest aggregated profile, specify only <code>period</code>. </p>
        pub fn period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.period(input.into());
            self
        }
        /// <p> Used with <code>startTime</code> or <code>endTime</code> to specify the time range for the returned aggregated profile. Specify using the ISO 8601 format. For example, <code>P1DT1H1M1S</code>. </p>
        /// <p> To get the latest aggregated profile, specify only <code>period</code>. </p>
        pub fn set_period(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p> The end time of the requested profile. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        /// <p> If you specify <code>endTime</code>, then you must also specify <code>period</code> or <code>startTime</code>, but not both. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The end time of the requested profile. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        /// <p> If you specify <code>endTime</code>, then you must also specify <code>period</code> or <code>startTime</code>, but not both. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> The maximum depth of the stacks in the code that is represented in the aggregated profile. For example, if CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which calls method <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is set to 2, then the aggregated profile contains representations of methods <code>A</code> and <code>B</code>. </p>
        pub fn max_depth(mut self, input: i32) -> Self {
            self.inner = self.inner.max_depth(input);
            self
        }
        /// <p> The maximum depth of the stacks in the code that is represented in the aggregated profile. For example, if CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which calls method <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is set to 2, then the aggregated profile contains representations of methods <code>A</code> and <code>B</code>. </p>
        pub fn set_max_depth(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_depth(input);
            self
        }
        /// <p> The format of the returned profiling data. The format maps to the <code>Accept</code> and <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default . </p>
        /// <ul>
        /// <li> <p> <code>application/json</code> — standard JSON format </p> </li>
        /// <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li>
        /// </ul>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept(input.into());
            self
        }
        /// <p> The format of the returned profiling data. The format maps to the <code>Accept</code> and <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default . </p>
        /// <ul>
        /// <li> <p> <code>application/json</code> — standard JSON format </p> </li>
        /// <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li>
        /// </ul>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_accept(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecommendations`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html"> <code>Recommendation</code> </a> objects that contain recommendations for a profiling group for a given time period. A list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html"> <code>Anomaly</code> </a> objects that contains details about anomalies detected in the profiling group for the same time period is also returned. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recommendations_input::Builder,
    }
    impl<C, M, R> GetRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecommendationsInputOperationOutputAlias,
                crate::output::GetRecommendationsOutput,
                crate::error::GetRecommendationsError,
                crate::input::GetRecommendationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the profiling group to get analysis data about. </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p> The name of the profiling group to get analysis data about. </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p> The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> The language used to provide analysis. Specify using a string that is one of the following <code>BCP 47</code> language codes. </p>
        /// <ul>
        /// <li> <p> <code>de-DE</code> - German, Germany </p> </li>
        /// <li> <p> <code>en-GB</code> - English, United Kingdom </p> </li>
        /// <li> <p> <code>en-US</code> - English, United States </p> </li>
        /// <li> <p> <code>es-ES</code> - Spanish, Spain </p> </li>
        /// <li> <p> <code>fr-FR</code> - French, France </p> </li>
        /// <li> <p> <code>it-IT</code> - Italian, Italy </p> </li>
        /// <li> <p> <code>ja-JP</code> - Japanese, Japan </p> </li>
        /// <li> <p> <code>ko-KR</code> - Korean, Republic of Korea </p> </li>
        /// <li> <p> <code>pt-BR</code> - Portugese, Brazil </p> </li>
        /// <li> <p> <code>zh-CN</code> - Chinese, China </p> </li>
        /// <li> <p> <code>zh-TW</code> - Chinese, Taiwan </p> </li>
        /// </ul>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p> The language used to provide analysis. Specify using a string that is one of the following <code>BCP 47</code> language codes. </p>
        /// <ul>
        /// <li> <p> <code>de-DE</code> - German, Germany </p> </li>
        /// <li> <p> <code>en-GB</code> - English, United Kingdom </p> </li>
        /// <li> <p> <code>en-US</code> - English, United States </p> </li>
        /// <li> <p> <code>es-ES</code> - Spanish, Spain </p> </li>
        /// <li> <p> <code>fr-FR</code> - French, France </p> </li>
        /// <li> <p> <code>it-IT</code> - Italian, Italy </p> </li>
        /// <li> <p> <code>ja-JP</code> - Japanese, Japan </p> </li>
        /// <li> <p> <code>ko-KR</code> - Korean, Republic of Korea </p> </li>
        /// <li> <p> <code>pt-BR</code> - Portugese, Brazil </p> </li>
        /// <li> <p> <code>zh-CN</code> - Chinese, China </p> </li>
        /// <li> <p> <code>zh-TW</code> - Chinese, Taiwan </p> </li>
        /// </ul>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindingsReports`.
    ///
    /// <p>List the available reports for a given profiling group and time range.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindingsReports<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_reports_input::Builder,
    }
    impl<C, M, R> ListFindingsReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindingsReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsReportsInputOperationOutputAlias,
                crate::output::ListFindingsReportsOutput,
                crate::error::ListFindingsReportsError,
                crate::input::ListFindingsReportsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingsReportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingsReportsPaginator<C, M, R> {
            crate::paginator::ListFindingsReportsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the profiling group from which to search for analysis data.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group from which to search for analysis data.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p> The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of report results returned by <code>ListFindingsReports</code> in paginated output. When this parameter is used, <code>ListFindingsReports</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFindingsReports</code> request with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of report results returned by <code>ListFindingsReports</code> in paginated output. When this parameter is used, <code>ListFindingsReports</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFindingsReports</code> request with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn daily_reports_only(mut self, input: bool) -> Self {
            self.inner = self.inner.daily_reports_only(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn set_daily_reports_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_daily_reports_only(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfileTimes`.
    ///
    /// <p>Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProfileTimes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_profile_times_input::Builder,
    }
    impl<C, M, R> ListProfileTimes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProfileTimes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfileTimesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfileTimesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProfileTimesInputOperationOutputAlias,
                crate::output::ListProfileTimesOutput,
                crate::error::ListProfileTimesError,
                crate::input::ListProfileTimesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProfileTimesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProfileTimesPaginator<C, M, R> {
            crate::paginator::ListProfileTimesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the profiling group.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p>The start time of the time range from which to list the profiles.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time of the time range from which to list the profiles.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time of the time range from which to list the profiles.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end time of the time range from which to list the profiles.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> The aggregation period. This specifies the period during which an aggregation profile collects posted agent profiles for a profiling group. There are 3 valid values. </p>
        /// <ul>
        /// <li> <p> <code>P1D</code> — 1 day </p> </li>
        /// <li> <p> <code>PT1H</code> — 1 hour </p> </li>
        /// <li> <p> <code>PT5M</code> — 5 minutes </p> </li>
        /// </ul>
        pub fn period(mut self, input: crate::model::AggregationPeriod) -> Self {
            self.inner = self.inner.period(input);
            self
        }
        /// <p> The aggregation period. This specifies the period during which an aggregation profile collects posted agent profiles for a profiling group. There are 3 valid values. </p>
        /// <ul>
        /// <li> <p> <code>P1D</code> — 1 day </p> </li>
        /// <li> <p> <code>PT1H</code> — 1 hour </p> </li>
        /// <li> <p> <code>PT5M</code> — 5 minutes </p> </li>
        /// </ul>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::AggregationPeriod>,
        ) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to <code>TIMESTAMP_DESCENDING</code>. </p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.inner = self.inner.order_by(input);
            self
        }
        /// <p>The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to <code>TIMESTAMP_DESCENDING</code>. </p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.inner = self.inner.set_order_by(input);
            self
        }
        /// <p>The maximum number of profile time results returned by <code>ListProfileTimes</code> in paginated output. When this parameter is used, <code>ListProfileTimes</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListProfileTimes</code> request with the returned <code>nextToken</code> value. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of profile time results returned by <code>ListProfileTimes</code> in paginated output. When this parameter is used, <code>ListProfileTimes</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListProfileTimes</code> request with the returned <code>nextToken</code> value. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListProfileTimes</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListProfileTimes</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfilingGroups`.
    ///
    /// <p> Returns a list of profiling groups. The profiling groups are returned as <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProfilingGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_profiling_groups_input::Builder,
    }
    impl<C, M, R> ListProfilingGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProfilingGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfilingGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfilingGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProfilingGroupsInputOperationOutputAlias,
                crate::output::ListProfilingGroupsOutput,
                crate::error::ListProfilingGroupsError,
                crate::input::ListProfilingGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProfilingGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProfilingGroupsPaginator<C, M, R> {
            crate::paginator::ListProfilingGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListProfilingGroups</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListProfilingGroups</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of profiling groups results returned by <code>ListProfilingGroups</code> in paginated output. When this parameter is used, <code>ListProfilingGroups</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListProfilingGroups</code> request with the returned <code>nextToken</code> value. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of profiling groups results returned by <code>ListProfilingGroups</code> in paginated output. When this parameter is used, <code>ListProfilingGroups</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListProfilingGroups</code> request with the returned <code>nextToken</code> value. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>, then a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects that contain detailed information about profiling groups is returned. If <code>false</code>, then a list of profiling group names is returned.</p>
        pub fn include_description(mut self, input: bool) -> Self {
            self.inner = self.inner.include_description(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>, then a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects that contain detailed information about profiling groups is returned. If <code>false</code>, then a list of profiling group names is returned.</p>
        pub fn set_include_description(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of the tags that are assigned to a specified resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that contains the tags to return. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that contains the tags to return. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostAgentProfile`.
    ///
    /// <p> Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html"> <code>GetProfile</code> </a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PostAgentProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::post_agent_profile_input::Builder,
    }
    impl<C, M, R> PostAgentProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PostAgentProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostAgentProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::PostAgentProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PostAgentProfileInputOperationOutputAlias,
                crate::output::PostAgentProfileOutput,
                crate::error::PostAgentProfileError,
                crate::input::PostAgentProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the profiling group with the aggregated profile that receives the submitted profiling data. </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p> The name of the profiling group with the aggregated profile that receives the submitted profiling data. </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> The submitted profiling data. </p>
        pub fn agent_profile(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.agent_profile(input);
            self
        }
        /// <p> The submitted profiling data. </p>
        pub fn set_agent_profile(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_agent_profile(input);
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission of duplicate profiling data if there are failures and retries. </p>
        pub fn profile_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_token(input.into());
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission of duplicate profiling data if there are failures and retries. </p>
        pub fn set_profile_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_token(input);
            self
        }
        /// <p> The format of the submitted profiling data. The format maps to the <code>Accept</code> and <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default . </p>
        /// <ul>
        /// <li> <p> <code>application/json</code> — standard JSON format </p> </li>
        /// <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li>
        /// </ul>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p> The format of the submitted profiling data. The format maps to the <code>Accept</code> and <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default . </p>
        /// <ul>
        /// <li> <p> <code>application/json</code> — standard JSON format </p> </li>
        /// <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li>
        /// </ul>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPermission`.
    ///
    /// <p> Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the <code>principals</code> parameter. </p>
    /// <p> The one supported action group that can be added is <code>agentPermission</code> which grants <code>ConfigureAgent</code> and <code>PostAgent</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a>, and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html"> <code>PostAgentProfile</code> </a>. </p>
    /// <p> The first time you call <code>PutPermission</code> on a profiling group, do not specify a <code>revisionId</code> because it doesn't have a resource-based policy. Subsequent calls must provide a <code>revisionId</code> to specify which revision of the resource-based policy to add the permissions to. </p>
    /// <p> The response contains the profiling group's JSON-formatted resource policy. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_permission_input::Builder,
    }
    impl<C, M, R> PutPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPermissionInputOperationOutputAlias,
                crate::output::PutPermissionOutput,
                crate::error::PutPermissionError,
                crate::input::PutPermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group to grant access to.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group to grant access to.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> Specifies an action group that contains permissions to add to a profiling group resource. One action group is supported, <code>agentPermissions</code>, which grants permission to perform actions required by the profiling agent, <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions. </p>
        pub fn action_group(mut self, input: crate::model::ActionGroup) -> Self {
            self.inner = self.inner.action_group(input);
            self
        }
        /// <p> Specifies an action group that contains permissions to add to a profiling group resource. One action group is supported, <code>agentPermissions</code>, which grants permission to perform actions required by the profiling agent, <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions. </p>
        pub fn set_action_group(
            mut self,
            input: std::option::Option<crate::model::ActionGroup>,
        ) -> Self {
            self.inner = self.inner.set_action_group(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p> A list ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not are supported in the ARNs. </p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(input.into());
            self
        }
        /// <p> A list ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not are supported in the ARNs. </p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the policy you are adding to the profiling group. Do not specify this when you add permissions to a profiling group for the first time. If a policy already exists on the profiling group, you must specify the <code>revisionId</code>. </p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the policy you are adding to the profiling group. Do not specify this when you add permissions to a profiling group for the first time. If a policy already exists on the profiling group, you must specify the <code>revisionId</code>. </p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveNotificationChannel`.
    ///
    /// <p>Remove one anomaly notifications channel for a profiling group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveNotificationChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_notification_channel_input::Builder,
    }
    impl<C, M, R> RemoveNotificationChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveNotificationChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveNotificationChannelInputOperationOutputAlias,
                crate::output::RemoveNotificationChannelOutput,
                crate::error::RemoveNotificationChannelError,
                crate::input::RemoveNotificationChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group we want to change notification configuration for.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group we want to change notification configuration for.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p>The id of the channel that we want to stop receiving notifications.</p>
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(input.into());
            self
        }
        /// <p>The id of the channel that we want to stop receiving notifications.</p>
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemovePermission`.
    ///
    /// <p> Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is <code>agentPermission</code> which grants <code>ConfigureAgent</code> and <code>PostAgent</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a>, and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html"> <code>PostAgentProfile</code> </a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemovePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_permission_input::Builder,
    }
    impl<C, M, R> RemovePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemovePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemovePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemovePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemovePermissionInputOperationOutputAlias,
                crate::output::RemovePermissionOutput,
                crate::error::RemovePermissionError,
                crate::input::RemovePermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> Specifies an action group that contains the permissions to remove from a profiling group's resource-based policy. One action group is supported, <code>agentPermissions</code>, which grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions. </p>
        pub fn action_group(mut self, input: crate::model::ActionGroup) -> Self {
            self.inner = self.inner.action_group(input);
            self
        }
        /// <p> Specifies an action group that contains the permissions to remove from a profiling group's resource-based policy. One action group is supported, <code>agentPermissions</code>, which grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions. </p>
        pub fn set_action_group(
            mut self,
            input: std::option::Option<crate::model::ActionGroup>,
        ) -> Self {
            self.inner = self.inner.set_action_group(input);
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy from which you want to remove permissions. </p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy from which you want to remove permissions. </p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubmitFeedback`.
    ///
    /// <p>Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SubmitFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::submit_feedback_input::Builder,
    }
    impl<C, M, R> SubmitFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SubmitFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubmitFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::SubmitFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SubmitFeedbackInputOperationOutputAlias,
                crate::output::SubmitFeedbackOutput,
                crate::error::SubmitFeedbackError,
                crate::input::SubmitFeedbackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group that is associated with the analysis data.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group that is associated with the analysis data.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p>The universally unique identifier (UUID) of the <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html"> <code>AnomalyInstance</code> </a> object that is included in the analysis data.</p>
        pub fn anomaly_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_instance_id(input.into());
            self
        }
        /// <p>The universally unique identifier (UUID) of the <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html"> <code>AnomalyInstance</code> </a> object that is included in the analysis data.</p>
        pub fn set_anomaly_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_instance_id(input);
            self
        }
        /// <p> The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>. </p>
        pub fn r#type(mut self, input: crate::model::FeedbackType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p> The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FeedbackType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Optional feedback about this anomaly.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>Optional feedback about this anomaly.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Use to assign one or more tags to a resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that the tags are added to. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that the tags are added to. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The list of tags that are added to the specified resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The list of tags that are added to the specified resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Use to remove one or more tags from a resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that contains the tags to remove. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that contains the tags to remove. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> A list of tag keys. Existing tags of resources with keys in this list are removed from the specified resource. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> A list of tag keys. Existing tags of resources with keys in this list are removed from the specified resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProfilingGroup`.
    ///
    /// <p>Updates a profiling group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProfilingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_profiling_group_input::Builder,
    }
    impl<C, M, R> UpdateProfilingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProfilingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProfilingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProfilingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProfilingGroupInputOperationOutputAlias,
                crate::output::UpdateProfilingGroupOutput,
                crate::error::UpdateProfilingGroupError,
                crate::input::UpdateProfilingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profiling group to update.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profiling_group_name(input.into());
            self
        }
        /// <p>The name of the profiling group to update.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profiling_group_name(input);
            self
        }
        /// <p> Specifies whether profiling is enabled or disabled for a profiling group. </p>
        pub fn agent_orchestration_config(
            mut self,
            input: crate::model::AgentOrchestrationConfig,
        ) -> Self {
            self.inner = self.inner.agent_orchestration_config(input);
            self
        }
        /// <p> Specifies whether profiling is enabled or disabled for a profiling group. </p>
        pub fn set_agent_orchestration_config(
            mut self,
            input: std::option::Option<crate::model::AgentOrchestrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_agent_orchestration_config(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
