// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The structure representing the SubmitFeedbackResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitFeedbackOutput {}
impl std::fmt::Debug for SubmitFeedbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitFeedbackOutput");
        formatter.finish()
    }
}
/// See [`SubmitFeedbackOutput`](crate::output::SubmitFeedbackOutput)
pub mod submit_feedback_output {
    /// A builder for [`SubmitFeedbackOutput`](crate::output::SubmitFeedbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SubmitFeedbackOutput`](crate::output::SubmitFeedbackOutput)
        pub fn build(self) -> crate::output::SubmitFeedbackOutput {
            crate::output::SubmitFeedbackOutput {}
        }
    }
}
impl SubmitFeedbackOutput {
    /// Creates a new builder-style object to manufacture [`SubmitFeedbackOutput`](crate::output::SubmitFeedbackOutput)
    pub fn builder() -> crate::output::submit_feedback_output::Builder {
        crate::output::submit_feedback_output::Builder::default()
    }
}

/// <p>The structure representing the <code>removePermissionResponse</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionOutput {
    /// <p>
    /// The JSON-formatted resource-based policy on the profiling group after
    /// the specified permissions were removed.
    /// </p>
    pub policy: std::option::Option<std::string::String>,
    /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
    /// after the specified permissions were removed. The updated JSON-formatted policy is in the
    /// <code>policy</code> element of the response. </p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl RemovePermissionOutput {
    /// <p>
    /// The JSON-formatted resource-based policy on the profiling group after
    /// the specified permissions were removed.
    /// </p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
    /// after the specified permissions were removed. The updated JSON-formatted policy is in the
    /// <code>policy</code> element of the response. </p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for RemovePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionOutput");
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
pub mod remove_permission_output {
    /// A builder for [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The JSON-formatted resource-based policy on the profiling group after
        /// the specified permissions were removed.
        /// </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>
        /// The JSON-formatted resource-based policy on the profiling group after
        /// the specified permissions were removed.
        /// </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
        /// after the specified permissions were removed. The updated JSON-formatted policy is in the
        /// <code>policy</code> element of the response. </p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
        /// after the specified permissions were removed. The updated JSON-formatted policy is in the
        /// <code>policy</code> element of the response. </p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
        pub fn build(self) -> crate::output::RemovePermissionOutput {
            crate::output::RemovePermissionOutput {
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl RemovePermissionOutput {
    /// Creates a new builder-style object to manufacture [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    pub fn builder() -> crate::output::remove_permission_output::Builder {
        crate::output::remove_permission_output::Builder::default()
    }
}

/// <p>The structure representing the RemoveNotificationChannelResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveNotificationChannelOutput {
    /// <p>The new notification configuration for this profiling group.</p>
    pub notification_configuration: std::option::Option<crate::model::NotificationConfiguration>,
}
impl RemoveNotificationChannelOutput {
    /// <p>The new notification configuration for this profiling group.</p>
    pub fn notification_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationConfiguration> {
        self.notification_configuration.as_ref()
    }
}
impl std::fmt::Debug for RemoveNotificationChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveNotificationChannelOutput");
        formatter.field(
            "notification_configuration",
            &self.notification_configuration,
        );
        formatter.finish()
    }
}
/// See [`RemoveNotificationChannelOutput`](crate::output::RemoveNotificationChannelOutput)
pub mod remove_notification_channel_output {
    /// A builder for [`RemoveNotificationChannelOutput`](crate::output::RemoveNotificationChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
    }
    impl Builder {
        /// <p>The new notification configuration for this profiling group.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>The new notification configuration for this profiling group.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveNotificationChannelOutput`](crate::output::RemoveNotificationChannelOutput)
        pub fn build(self) -> crate::output::RemoveNotificationChannelOutput {
            crate::output::RemoveNotificationChannelOutput {
                notification_configuration: self.notification_configuration,
            }
        }
    }
}
impl RemoveNotificationChannelOutput {
    /// Creates a new builder-style object to manufacture [`RemoveNotificationChannelOutput`](crate::output::RemoveNotificationChannelOutput)
    pub fn builder() -> crate::output::remove_notification_channel_output::Builder {
        crate::output::remove_notification_channel_output::Builder::default()
    }
}

/// <p>The structure representing the <code>putPermissionResponse</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPermissionOutput {
    /// <p>
    /// The JSON-formatted resource-based policy on the profiling group that includes the  
    /// added permissions.
    /// </p>
    pub policy: std::option::Option<std::string::String>,
    /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
    /// that includes the added permissions. The JSON-formatted policy is in the
    /// <code>policy</code> element of the response. </p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl PutPermissionOutput {
    /// <p>
    /// The JSON-formatted resource-based policy on the profiling group that includes the  
    /// added permissions.
    /// </p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
    /// that includes the added permissions. The JSON-formatted policy is in the
    /// <code>policy</code> element of the response. </p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for PutPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPermissionOutput");
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`PutPermissionOutput`](crate::output::PutPermissionOutput)
pub mod put_permission_output {
    /// A builder for [`PutPermissionOutput`](crate::output::PutPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The JSON-formatted resource-based policy on the profiling group that includes the  
        /// added permissions.
        /// </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>
        /// The JSON-formatted resource-based policy on the profiling group that includes the  
        /// added permissions.
        /// </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
        /// that includes the added permissions. The JSON-formatted policy is in the
        /// <code>policy</code> element of the response. </p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p> A universally unique identifier (UUID) for the revision of the resource-based policy
        /// that includes the added permissions. The JSON-formatted policy is in the
        /// <code>policy</code> element of the response. </p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPermissionOutput`](crate::output::PutPermissionOutput)
        pub fn build(self) -> crate::output::PutPermissionOutput {
            crate::output::PutPermissionOutput {
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl PutPermissionOutput {
    /// Creates a new builder-style object to manufacture [`PutPermissionOutput`](crate::output::PutPermissionOutput)
    pub fn builder() -> crate::output::put_permission_output::Builder {
        crate::output::put_permission_output::Builder::default()
    }
}

/// <p>The structure representing the postAgentProfileResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostAgentProfileOutput {}
impl std::fmt::Debug for PostAgentProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostAgentProfileOutput");
        formatter.finish()
    }
}
/// See [`PostAgentProfileOutput`](crate::output::PostAgentProfileOutput)
pub mod post_agent_profile_output {
    /// A builder for [`PostAgentProfileOutput`](crate::output::PostAgentProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PostAgentProfileOutput`](crate::output::PostAgentProfileOutput)
        pub fn build(self) -> crate::output::PostAgentProfileOutput {
            crate::output::PostAgentProfileOutput {}
        }
    }
}
impl PostAgentProfileOutput {
    /// Creates a new builder-style object to manufacture [`PostAgentProfileOutput`](crate::output::PostAgentProfileOutput)
    pub fn builder() -> crate::output::post_agent_profile_output::Builder {
        crate::output::post_agent_profile_output::Builder::default()
    }
}

/// <p>The structure representing the listProfileTimesResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileTimesOutput {
    /// <p>The list of start times of the available profiles for the aggregation
    /// period in the specified time range.
    /// </p>
    pub profile_times: std::option::Option<std::vec::Vec<crate::model::ProfileTime>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request.
    /// When the results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProfileTimesOutput {
    /// <p>The list of start times of the available profiles for the aggregation
    /// period in the specified time range.
    /// </p>
    pub fn profile_times(&self) -> std::option::Option<&[crate::model::ProfileTime]> {
        self.profile_times.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request.
    /// When the results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProfileTimesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileTimesOutput");
        formatter.field("profile_times", &self.profile_times);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProfileTimesOutput`](crate::output::ListProfileTimesOutput)
pub mod list_profile_times_output {
    /// A builder for [`ListProfileTimesOutput`](crate::output::ListProfileTimesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_times: std::option::Option<std::vec::Vec<crate::model::ProfileTime>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `profile_times`.
        ///
        /// To override the contents of this collection use [`set_profile_times`](Self::set_profile_times).
        ///
        /// <p>The list of start times of the available profiles for the aggregation
        /// period in the specified time range.
        /// </p>
        pub fn profile_times(mut self, input: impl Into<crate::model::ProfileTime>) -> Self {
            let mut v = self.profile_times.unwrap_or_default();
            v.push(input.into());
            self.profile_times = Some(v);
            self
        }
        /// <p>The list of start times of the available profiles for the aggregation
        /// period in the specified time range.
        /// </p>
        pub fn set_profile_times(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProfileTime>>,
        ) -> Self {
            self.profile_times = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request.
        /// When the results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request.
        /// When the results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileTimesOutput`](crate::output::ListProfileTimesOutput)
        pub fn build(self) -> crate::output::ListProfileTimesOutput {
            crate::output::ListProfileTimesOutput {
                profile_times: self.profile_times,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProfileTimesOutput {
    /// Creates a new builder-style object to manufacture [`ListProfileTimesOutput`](crate::output::ListProfileTimesOutput)
    pub fn builder() -> crate::output::list_profile_times_output::Builder {
        crate::output::list_profile_times_output::Builder::default()
    }
}

/// <p>The structure representing the ListFindingsReportsResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsReportsOutput {
    /// <p>The list of analysis results summaries.</p>
    pub findings_report_summaries:
        std::option::Option<std::vec::Vec<crate::model::FindingsReportSummary>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request.
    /// When the results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFindingsReportsOutput {
    /// <p>The list of analysis results summaries.</p>
    pub fn findings_report_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::FindingsReportSummary]> {
        self.findings_report_summaries.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request.
    /// When the results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFindingsReportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsReportsOutput");
        formatter.field("findings_report_summaries", &self.findings_report_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFindingsReportsOutput`](crate::output::ListFindingsReportsOutput)
pub mod list_findings_reports_output {
    /// A builder for [`ListFindingsReportsOutput`](crate::output::ListFindingsReportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) findings_report_summaries:
            std::option::Option<std::vec::Vec<crate::model::FindingsReportSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `findings_report_summaries`.
        ///
        /// To override the contents of this collection use [`set_findings_report_summaries`](Self::set_findings_report_summaries).
        ///
        /// <p>The list of analysis results summaries.</p>
        pub fn findings_report_summaries(
            mut self,
            input: impl Into<crate::model::FindingsReportSummary>,
        ) -> Self {
            let mut v = self.findings_report_summaries.unwrap_or_default();
            v.push(input.into());
            self.findings_report_summaries = Some(v);
            self
        }
        /// <p>The list of analysis results summaries.</p>
        pub fn set_findings_report_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingsReportSummary>>,
        ) -> Self {
            self.findings_report_summaries = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request.
        /// When the results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request.
        /// When the results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsReportsOutput`](crate::output::ListFindingsReportsOutput)
        pub fn build(self) -> crate::output::ListFindingsReportsOutput {
            crate::output::ListFindingsReportsOutput {
                findings_report_summaries: self.findings_report_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFindingsReportsOutput {
    /// Creates a new builder-style object to manufacture [`ListFindingsReportsOutput`](crate::output::ListFindingsReportsOutput)
    pub fn builder() -> crate::output::list_findings_reports_output::Builder {
        crate::output::list_findings_reports_output::Builder::default()
    }
}

/// <p>The structure representing the GetRecommendationsResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecommendationsOutput {
    /// <p>The name of the profiling group the analysis data is about.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// The start time of the profile the analysis data is about. This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub profile_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The end time of the profile the analysis data is about. This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub profile_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of recommendations that the analysis found for this profile.</p>
    pub recommendations: std::option::Option<std::vec::Vec<crate::model::Recommendation>>,
    /// <p>
    /// The list of anomalies that the analysis has found for this profile.
    /// </p>
    pub anomalies: std::option::Option<std::vec::Vec<crate::model::Anomaly>>,
}
impl GetRecommendationsOutput {
    /// <p>The name of the profiling group the analysis data is about.</p>
    pub fn profiling_group_name(&self) -> std::option::Option<&str> {
        self.profiling_group_name.as_deref()
    }
    /// <p>
    /// The start time of the profile the analysis data is about. This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn profile_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.profile_start_time.as_ref()
    }
    /// <p>
    /// The end time of the profile the analysis data is about. This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn profile_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.profile_end_time.as_ref()
    }
    /// <p>The list of recommendations that the analysis found for this profile.</p>
    pub fn recommendations(&self) -> std::option::Option<&[crate::model::Recommendation]> {
        self.recommendations.as_deref()
    }
    /// <p>
    /// The list of anomalies that the analysis has found for this profile.
    /// </p>
    pub fn anomalies(&self) -> std::option::Option<&[crate::model::Anomaly]> {
        self.anomalies.as_deref()
    }
}
impl std::fmt::Debug for GetRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecommendationsOutput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("profile_start_time", &self.profile_start_time);
        formatter.field("profile_end_time", &self.profile_end_time);
        formatter.field("recommendations", &self.recommendations);
        formatter.field("anomalies", &self.anomalies);
        formatter.finish()
    }
}
/// See [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
pub mod get_recommendations_output {
    /// A builder for [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) profile_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) profile_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) recommendations:
            std::option::Option<std::vec::Vec<crate::model::Recommendation>>,
        pub(crate) anomalies: std::option::Option<std::vec::Vec<crate::model::Anomaly>>,
    }
    impl Builder {
        /// <p>The name of the profiling group the analysis data is about.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group the analysis data is about.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// The start time of the profile the analysis data is about. This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn profile_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.profile_start_time = Some(input);
            self
        }
        /// <p>
        /// The start time of the profile the analysis data is about. This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_profile_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.profile_start_time = input;
            self
        }
        /// <p>
        /// The end time of the profile the analysis data is about. This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn profile_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.profile_end_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the profile the analysis data is about. This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_profile_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.profile_end_time = input;
            self
        }
        /// Appends an item to `recommendations`.
        ///
        /// To override the contents of this collection use [`set_recommendations`](Self::set_recommendations).
        ///
        /// <p>The list of recommendations that the analysis found for this profile.</p>
        pub fn recommendations(mut self, input: impl Into<crate::model::Recommendation>) -> Self {
            let mut v = self.recommendations.unwrap_or_default();
            v.push(input.into());
            self.recommendations = Some(v);
            self
        }
        /// <p>The list of recommendations that the analysis found for this profile.</p>
        pub fn set_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Recommendation>>,
        ) -> Self {
            self.recommendations = input;
            self
        }
        /// Appends an item to `anomalies`.
        ///
        /// To override the contents of this collection use [`set_anomalies`](Self::set_anomalies).
        ///
        /// <p>
        /// The list of anomalies that the analysis has found for this profile.
        /// </p>
        pub fn anomalies(mut self, input: impl Into<crate::model::Anomaly>) -> Self {
            let mut v = self.anomalies.unwrap_or_default();
            v.push(input.into());
            self.anomalies = Some(v);
            self
        }
        /// <p>
        /// The list of anomalies that the analysis has found for this profile.
        /// </p>
        pub fn set_anomalies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Anomaly>>,
        ) -> Self {
            self.anomalies = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
        pub fn build(self) -> crate::output::GetRecommendationsOutput {
            crate::output::GetRecommendationsOutput {
                profiling_group_name: self.profiling_group_name,
                profile_start_time: self.profile_start_time,
                profile_end_time: self.profile_end_time,
                recommendations: self.recommendations,
                anomalies: self.anomalies,
            }
        }
    }
}
impl GetRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
    pub fn builder() -> crate::output::get_recommendations_output::Builder {
        crate::output::get_recommendations_output::Builder::default()
    }
}

/// <p>The structure representing the getProfileResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProfileOutput {
    /// <p>Information about the profile.</p>
    pub profile: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The content type of the profile in the payload. It is
    /// either <code>application/json</code> or the default
    /// <code>application/x-amzn-ion</code>.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The content encoding of the profile.</p>
    pub content_encoding: std::option::Option<std::string::String>,
}
impl GetProfileOutput {
    /// <p>Information about the profile.</p>
    pub fn profile(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.profile.as_ref()
    }
    /// <p>The content type of the profile in the payload. It is
    /// either <code>application/json</code> or the default
    /// <code>application/x-amzn-ion</code>.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The content encoding of the profile.</p>
    pub fn content_encoding(&self) -> std::option::Option<&str> {
        self.content_encoding.as_deref()
    }
}
impl std::fmt::Debug for GetProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProfileOutput");
        formatter.field("profile", &self.profile);
        formatter.field("content_type", &self.content_type);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.finish()
    }
}
/// See [`GetProfileOutput`](crate::output::GetProfileOutput)
pub mod get_profile_output {
    /// A builder for [`GetProfileOutput`](crate::output::GetProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the profile.</p>
        pub fn profile(mut self, input: aws_smithy_types::Blob) -> Self {
            self.profile = Some(input);
            self
        }
        /// <p>Information about the profile.</p>
        pub fn set_profile(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.profile = input;
            self
        }
        /// <p>The content type of the profile in the payload. It is
        /// either <code>application/json</code> or the default
        /// <code>application/x-amzn-ion</code>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type of the profile in the payload. It is
        /// either <code>application/json</code> or the default
        /// <code>application/x-amzn-ion</code>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The content encoding of the profile.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>The content encoding of the profile.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProfileOutput`](crate::output::GetProfileOutput)
        pub fn build(self) -> crate::output::GetProfileOutput {
            crate::output::GetProfileOutput {
                profile: self.profile,
                content_type: self.content_type,
                content_encoding: self.content_encoding,
            }
        }
    }
}
impl GetProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetProfileOutput`](crate::output::GetProfileOutput)
    pub fn builder() -> crate::output::get_profile_output::Builder {
        crate::output::get_profile_output::Builder::default()
    }
}

/// <p>The structure representing the <code>getPolicyResponse</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyOutput {
    /// <p>The JSON-formatted resource-based policy attached to the <code>ProfilingGroup</code>.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the current revision of the returned policy.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetPolicyOutput {
    /// <p>The JSON-formatted resource-based policy attached to the <code>ProfilingGroup</code>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>A unique identifier for the current revision of the returned policy.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`GetPolicyOutput`](crate::output::GetPolicyOutput)
pub mod get_policy_output {
    /// A builder for [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The JSON-formatted resource-based policy attached to the <code>ProfilingGroup</code>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The JSON-formatted resource-based policy attached to the <code>ProfilingGroup</code>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>A unique identifier for the current revision of the returned policy.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the current revision of the returned policy.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyOutput`](crate::output::GetPolicyOutput)
        pub fn build(self) -> crate::output::GetPolicyOutput {
            crate::output::GetPolicyOutput {
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl GetPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    pub fn builder() -> crate::output::get_policy_output::Builder {
        crate::output::get_policy_output::Builder::default()
    }
}

/// <p>The structure representing the GetNotificationConfigurationResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNotificationConfigurationOutput {
    /// <p>The current notification configuration for this profiling group.</p>
    pub notification_configuration: std::option::Option<crate::model::NotificationConfiguration>,
}
impl GetNotificationConfigurationOutput {
    /// <p>The current notification configuration for this profiling group.</p>
    pub fn notification_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationConfiguration> {
        self.notification_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetNotificationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNotificationConfigurationOutput");
        formatter.field(
            "notification_configuration",
            &self.notification_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetNotificationConfigurationOutput`](crate::output::GetNotificationConfigurationOutput)
pub mod get_notification_configuration_output {
    /// A builder for [`GetNotificationConfigurationOutput`](crate::output::GetNotificationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
    }
    impl Builder {
        /// <p>The current notification configuration for this profiling group.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>The current notification configuration for this profiling group.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNotificationConfigurationOutput`](crate::output::GetNotificationConfigurationOutput)
        pub fn build(self) -> crate::output::GetNotificationConfigurationOutput {
            crate::output::GetNotificationConfigurationOutput {
                notification_configuration: self.notification_configuration,
            }
        }
    }
}
impl GetNotificationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetNotificationConfigurationOutput`](crate::output::GetNotificationConfigurationOutput)
    pub fn builder() -> crate::output::get_notification_configuration_output::Builder {
        crate::output::get_notification_configuration_output::Builder::default()
    }
}

/// <p>The structure representing the configureAgentResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigureAgentOutput {
    /// <p>
    /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentConfiguration.html">
    /// <code>AgentConfiguration</code>
    /// </a>
    /// object that specifies if an agent profiles or not and for how long to return profiling data.
    /// </p>
    pub configuration: std::option::Option<crate::model::AgentConfiguration>,
}
impl ConfigureAgentOutput {
    /// <p>
    /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentConfiguration.html">
    /// <code>AgentConfiguration</code>
    /// </a>
    /// object that specifies if an agent profiles or not and for how long to return profiling data.
    /// </p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::AgentConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for ConfigureAgentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigureAgentOutput");
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`ConfigureAgentOutput`](crate::output::ConfigureAgentOutput)
pub mod configure_agent_output {
    /// A builder for [`ConfigureAgentOutput`](crate::output::ConfigureAgentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::AgentConfiguration>,
    }
    impl Builder {
        /// <p>
        /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentConfiguration.html">
        /// <code>AgentConfiguration</code>
        /// </a>
        /// object that specifies if an agent profiles or not and for how long to return profiling data.
        /// </p>
        pub fn configuration(mut self, input: crate::model::AgentConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>
        /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentConfiguration.html">
        /// <code>AgentConfiguration</code>
        /// </a>
        /// object that specifies if an agent profiles or not and for how long to return profiling data.
        /// </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::AgentConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigureAgentOutput`](crate::output::ConfigureAgentOutput)
        pub fn build(self) -> crate::output::ConfigureAgentOutput {
            crate::output::ConfigureAgentOutput {
                configuration: self.configuration,
            }
        }
    }
}
impl ConfigureAgentOutput {
    /// Creates a new builder-style object to manufacture [`ConfigureAgentOutput`](crate::output::ConfigureAgentOutput)
    pub fn builder() -> crate::output::configure_agent_output::Builder {
        crate::output::configure_agent_output::Builder::default()
    }
}

/// <p>The structure representing the BatchGetFrameMetricDataResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetFrameMetricDataOutput {
    /// <p>
    /// The start time of the time period for the returned time series values.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The end time of the time period for the returned time series values.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Resolution or granularity of the profile data used to generate the time series.
    /// This is the value used to jump through time steps in a time series. There are 3 valid values.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>P1D</code> — 1 day
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT1H</code> — 1 hour
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT5M</code> — 5 minutes
    /// </p>
    /// </li>
    /// </ul>
    pub resolution: std::option::Option<crate::model::AggregationPeriod>,
    /// <p>
    /// List of instances, or time steps, in the time series. For example, if the
    /// <code>period</code> is one day (<code>PT24H)</code>), and the <code>resolution</code>
    /// is five minutes (<code>PT5M</code>), then there are 288 <code>endTimes</code> in the
    /// list that are each five minutes appart.
    /// </p>
    pub end_times: std::option::Option<std::vec::Vec<crate::model::TimestampStructure>>,
    /// <p>List of instances which remained unprocessed. This will create a missing time step in the list of end times.</p>
    pub unprocessed_end_times: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::TimestampStructure>,
        >,
    >,
    /// <p>Details of the metrics to request a time series of values. The metric includes
    /// the name of the frame, the aggregation type to calculate the metric value for the frame,
    /// and the thread states to use to get the count for the metric value of the frame.</p>
    pub frame_metric_data: std::option::Option<std::vec::Vec<crate::model::FrameMetricDatum>>,
}
impl BatchGetFrameMetricDataOutput {
    /// <p>
    /// The start time of the time period for the returned time series values.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>
    /// The end time of the time period for the returned time series values.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Resolution or granularity of the profile data used to generate the time series.
    /// This is the value used to jump through time steps in a time series. There are 3 valid values.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>P1D</code> — 1 day
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT1H</code> — 1 hour
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT5M</code> — 5 minutes
    /// </p>
    /// </li>
    /// </ul>
    pub fn resolution(&self) -> std::option::Option<&crate::model::AggregationPeriod> {
        self.resolution.as_ref()
    }
    /// <p>
    /// List of instances, or time steps, in the time series. For example, if the
    /// <code>period</code> is one day (<code>PT24H)</code>), and the <code>resolution</code>
    /// is five minutes (<code>PT5M</code>), then there are 288 <code>endTimes</code> in the
    /// list that are each five minutes appart.
    /// </p>
    pub fn end_times(&self) -> std::option::Option<&[crate::model::TimestampStructure]> {
        self.end_times.as_deref()
    }
    /// <p>List of instances which remained unprocessed. This will create a missing time step in the list of end times.</p>
    pub fn unprocessed_end_times(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::TimestampStructure>,
        >,
    > {
        self.unprocessed_end_times.as_ref()
    }
    /// <p>Details of the metrics to request a time series of values. The metric includes
    /// the name of the frame, the aggregation type to calculate the metric value for the frame,
    /// and the thread states to use to get the count for the metric value of the frame.</p>
    pub fn frame_metric_data(&self) -> std::option::Option<&[crate::model::FrameMetricDatum]> {
        self.frame_metric_data.as_deref()
    }
}
impl std::fmt::Debug for BatchGetFrameMetricDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetFrameMetricDataOutput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("resolution", &self.resolution);
        formatter.field("end_times", &self.end_times);
        formatter.field("unprocessed_end_times", &self.unprocessed_end_times);
        formatter.field("frame_metric_data", &self.frame_metric_data);
        formatter.finish()
    }
}
/// See [`BatchGetFrameMetricDataOutput`](crate::output::BatchGetFrameMetricDataOutput)
pub mod batch_get_frame_metric_data_output {
    /// A builder for [`BatchGetFrameMetricDataOutput`](crate::output::BatchGetFrameMetricDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resolution: std::option::Option<crate::model::AggregationPeriod>,
        pub(crate) end_times: std::option::Option<std::vec::Vec<crate::model::TimestampStructure>>,
        pub(crate) unprocessed_end_times: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::TimestampStructure>,
            >,
        >,
        pub(crate) frame_metric_data:
            std::option::Option<std::vec::Vec<crate::model::FrameMetricDatum>>,
    }
    impl Builder {
        /// <p>
        /// The start time of the time period for the returned time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The start time of the time period for the returned time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The end time of the time period for the returned time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the time period for the returned time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Resolution or granularity of the profile data used to generate the time series.
        /// This is the value used to jump through time steps in a time series. There are 3 valid values.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn resolution(mut self, input: crate::model::AggregationPeriod) -> Self {
            self.resolution = Some(input);
            self
        }
        /// <p>Resolution or granularity of the profile data used to generate the time series.
        /// This is the value used to jump through time steps in a time series. There are 3 valid values.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resolution(
            mut self,
            input: std::option::Option<crate::model::AggregationPeriod>,
        ) -> Self {
            self.resolution = input;
            self
        }
        /// Appends an item to `end_times`.
        ///
        /// To override the contents of this collection use [`set_end_times`](Self::set_end_times).
        ///
        /// <p>
        /// List of instances, or time steps, in the time series. For example, if the
        /// <code>period</code> is one day (<code>PT24H)</code>), and the <code>resolution</code>
        /// is five minutes (<code>PT5M</code>), then there are 288 <code>endTimes</code> in the
        /// list that are each five minutes appart.
        /// </p>
        pub fn end_times(mut self, input: impl Into<crate::model::TimestampStructure>) -> Self {
            let mut v = self.end_times.unwrap_or_default();
            v.push(input.into());
            self.end_times = Some(v);
            self
        }
        /// <p>
        /// List of instances, or time steps, in the time series. For example, if the
        /// <code>period</code> is one day (<code>PT24H)</code>), and the <code>resolution</code>
        /// is five minutes (<code>PT5M</code>), then there are 288 <code>endTimes</code> in the
        /// list that are each five minutes appart.
        /// </p>
        pub fn set_end_times(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimestampStructure>>,
        ) -> Self {
            self.end_times = input;
            self
        }
        /// Adds a key-value pair to `unprocessed_end_times`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_end_times`](Self::set_unprocessed_end_times).
        ///
        /// <p>List of instances which remained unprocessed. This will create a missing time step in the list of end times.</p>
        pub fn unprocessed_end_times(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::TimestampStructure>>,
        ) -> Self {
            let mut hash_map = self.unprocessed_end_times.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.unprocessed_end_times = Some(hash_map);
            self
        }
        /// <p>List of instances which remained unprocessed. This will create a missing time step in the list of end times.</p>
        pub fn set_unprocessed_end_times(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::TimestampStructure>,
                >,
            >,
        ) -> Self {
            self.unprocessed_end_times = input;
            self
        }
        /// Appends an item to `frame_metric_data`.
        ///
        /// To override the contents of this collection use [`set_frame_metric_data`](Self::set_frame_metric_data).
        ///
        /// <p>Details of the metrics to request a time series of values. The metric includes
        /// the name of the frame, the aggregation type to calculate the metric value for the frame,
        /// and the thread states to use to get the count for the metric value of the frame.</p>
        pub fn frame_metric_data(
            mut self,
            input: impl Into<crate::model::FrameMetricDatum>,
        ) -> Self {
            let mut v = self.frame_metric_data.unwrap_or_default();
            v.push(input.into());
            self.frame_metric_data = Some(v);
            self
        }
        /// <p>Details of the metrics to request a time series of values. The metric includes
        /// the name of the frame, the aggregation type to calculate the metric value for the frame,
        /// and the thread states to use to get the count for the metric value of the frame.</p>
        pub fn set_frame_metric_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameMetricDatum>>,
        ) -> Self {
            self.frame_metric_data = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetFrameMetricDataOutput`](crate::output::BatchGetFrameMetricDataOutput)
        pub fn build(self) -> crate::output::BatchGetFrameMetricDataOutput {
            crate::output::BatchGetFrameMetricDataOutput {
                start_time: self.start_time,
                end_time: self.end_time,
                resolution: self.resolution,
                end_times: self.end_times,
                unprocessed_end_times: self.unprocessed_end_times,
                frame_metric_data: self.frame_metric_data,
            }
        }
    }
}
impl BatchGetFrameMetricDataOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetFrameMetricDataOutput`](crate::output::BatchGetFrameMetricDataOutput)
    pub fn builder() -> crate::output::batch_get_frame_metric_data_output::Builder {
        crate::output::batch_get_frame_metric_data_output::Builder::default()
    }
}

/// <p>The structure representing the AddNotificationChannelsResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddNotificationChannelsOutput {
    /// <p>The new notification configuration for this profiling group.</p>
    pub notification_configuration: std::option::Option<crate::model::NotificationConfiguration>,
}
impl AddNotificationChannelsOutput {
    /// <p>The new notification configuration for this profiling group.</p>
    pub fn notification_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationConfiguration> {
        self.notification_configuration.as_ref()
    }
}
impl std::fmt::Debug for AddNotificationChannelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddNotificationChannelsOutput");
        formatter.field(
            "notification_configuration",
            &self.notification_configuration,
        );
        formatter.finish()
    }
}
/// See [`AddNotificationChannelsOutput`](crate::output::AddNotificationChannelsOutput)
pub mod add_notification_channels_output {
    /// A builder for [`AddNotificationChannelsOutput`](crate::output::AddNotificationChannelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
    }
    impl Builder {
        /// <p>The new notification configuration for this profiling group.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>The new notification configuration for this profiling group.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AddNotificationChannelsOutput`](crate::output::AddNotificationChannelsOutput)
        pub fn build(self) -> crate::output::AddNotificationChannelsOutput {
            crate::output::AddNotificationChannelsOutput {
                notification_configuration: self.notification_configuration,
            }
        }
    }
}
impl AddNotificationChannelsOutput {
    /// Creates a new builder-style object to manufacture [`AddNotificationChannelsOutput`](crate::output::AddNotificationChannelsOutput)
    pub fn builder() -> crate::output::add_notification_channels_output::Builder {
        crate::output::add_notification_channels_output::Builder::default()
    }
}

/// <p>The structure representing the listProfilingGroupsResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfilingGroupsOutput {
    /// <p>
    /// A returned list of profiling group names. A list of the names is returned only if
    /// <code>includeDescription</code> is <code>false</code>, otherwise a list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a> objects
    /// is returned.         
    /// </p>
    pub profiling_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// A returned list
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// objects. A list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// objects is returned only if <code>includeDescription</code> is <code>true</code>, otherwise a list of profiling group names is returned.
    /// </p>
    pub profiling_groups:
        std::option::Option<std::vec::Vec<crate::model::ProfilingGroupDescription>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request.
    /// When the results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProfilingGroupsOutput {
    /// <p>
    /// A returned list of profiling group names. A list of the names is returned only if
    /// <code>includeDescription</code> is <code>false</code>, otherwise a list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a> objects
    /// is returned.         
    /// </p>
    pub fn profiling_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.profiling_group_names.as_deref()
    }
    /// <p>
    /// A returned list
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// objects. A list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// objects is returned only if <code>includeDescription</code> is <code>true</code>, otherwise a list of profiling group names is returned.
    /// </p>
    pub fn profiling_groups(
        &self,
    ) -> std::option::Option<&[crate::model::ProfilingGroupDescription]> {
        self.profiling_groups.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request.
    /// When the results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProfilingGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfilingGroupsOutput");
        formatter.field("profiling_group_names", &self.profiling_group_names);
        formatter.field("profiling_groups", &self.profiling_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProfilingGroupsOutput`](crate::output::ListProfilingGroupsOutput)
pub mod list_profiling_groups_output {
    /// A builder for [`ListProfilingGroupsOutput`](crate::output::ListProfilingGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) profiling_groups:
            std::option::Option<std::vec::Vec<crate::model::ProfilingGroupDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `profiling_group_names`.
        ///
        /// To override the contents of this collection use [`set_profiling_group_names`](Self::set_profiling_group_names).
        ///
        /// <p>
        /// A returned list of profiling group names. A list of the names is returned only if
        /// <code>includeDescription</code> is <code>false</code>, otherwise a list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a> objects
        /// is returned.         
        /// </p>
        pub fn profiling_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.profiling_group_names.unwrap_or_default();
            v.push(input.into());
            self.profiling_group_names = Some(v);
            self
        }
        /// <p>
        /// A returned list of profiling group names. A list of the names is returned only if
        /// <code>includeDescription</code> is <code>false</code>, otherwise a list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a> objects
        /// is returned.         
        /// </p>
        pub fn set_profiling_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.profiling_group_names = input;
            self
        }
        /// Appends an item to `profiling_groups`.
        ///
        /// To override the contents of this collection use [`set_profiling_groups`](Self::set_profiling_groups).
        ///
        /// <p>
        /// A returned list
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// objects. A list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// objects is returned only if <code>includeDescription</code> is <code>true</code>, otherwise a list of profiling group names is returned.
        /// </p>
        pub fn profiling_groups(
            mut self,
            input: impl Into<crate::model::ProfilingGroupDescription>,
        ) -> Self {
            let mut v = self.profiling_groups.unwrap_or_default();
            v.push(input.into());
            self.profiling_groups = Some(v);
            self
        }
        /// <p>
        /// A returned list
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// objects. A list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// objects is returned only if <code>includeDescription</code> is <code>true</code>, otherwise a list of profiling group names is returned.
        /// </p>
        pub fn set_profiling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProfilingGroupDescription>>,
        ) -> Self {
            self.profiling_groups = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request.
        /// When the results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request.
        /// When the results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfilingGroupsOutput`](crate::output::ListProfilingGroupsOutput)
        pub fn build(self) -> crate::output::ListProfilingGroupsOutput {
            crate::output::ListProfilingGroupsOutput {
                profiling_group_names: self.profiling_group_names,
                profiling_groups: self.profiling_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProfilingGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListProfilingGroupsOutput`](crate::output::ListProfilingGroupsOutput)
    pub fn builder() -> crate::output::list_profiling_groups_output::Builder {
        crate::output::list_profiling_groups_output::Builder::default()
    }
}

/// <p>The structure representing the createProfilingGroupResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProfilingGroupOutput {
    /// <p> The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a> object that contains information
    /// about the created profiling group. </p>
    pub profiling_group: std::option::Option<crate::model::ProfilingGroupDescription>,
}
impl CreateProfilingGroupOutput {
    /// <p> The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a> object that contains information
    /// about the created profiling group. </p>
    pub fn profiling_group(&self) -> std::option::Option<&crate::model::ProfilingGroupDescription> {
        self.profiling_group.as_ref()
    }
}
impl std::fmt::Debug for CreateProfilingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProfilingGroupOutput");
        formatter.field("profiling_group", &self.profiling_group);
        formatter.finish()
    }
}
/// See [`CreateProfilingGroupOutput`](crate::output::CreateProfilingGroupOutput)
pub mod create_profiling_group_output {
    /// A builder for [`CreateProfilingGroupOutput`](crate::output::CreateProfilingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group: std::option::Option<crate::model::ProfilingGroupDescription>,
    }
    impl Builder {
        /// <p> The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a> object that contains information
        /// about the created profiling group. </p>
        pub fn profiling_group(mut self, input: crate::model::ProfilingGroupDescription) -> Self {
            self.profiling_group = Some(input);
            self
        }
        /// <p> The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a> object that contains information
        /// about the created profiling group. </p>
        pub fn set_profiling_group(
            mut self,
            input: std::option::Option<crate::model::ProfilingGroupDescription>,
        ) -> Self {
            self.profiling_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProfilingGroupOutput`](crate::output::CreateProfilingGroupOutput)
        pub fn build(self) -> crate::output::CreateProfilingGroupOutput {
            crate::output::CreateProfilingGroupOutput {
                profiling_group: self.profiling_group,
            }
        }
    }
}
impl CreateProfilingGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateProfilingGroupOutput`](crate::output::CreateProfilingGroupOutput)
    pub fn builder() -> crate::output::create_profiling_group_output::Builder {
        crate::output::create_profiling_group_output::Builder::default()
    }
}

/// <p>The structure representing the deleteProfilingGroupResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfilingGroupOutput {}
impl std::fmt::Debug for DeleteProfilingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfilingGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteProfilingGroupOutput`](crate::output::DeleteProfilingGroupOutput)
pub mod delete_profiling_group_output {
    /// A builder for [`DeleteProfilingGroupOutput`](crate::output::DeleteProfilingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProfilingGroupOutput`](crate::output::DeleteProfilingGroupOutput)
        pub fn build(self) -> crate::output::DeleteProfilingGroupOutput {
            crate::output::DeleteProfilingGroupOutput {}
        }
    }
}
impl DeleteProfilingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProfilingGroupOutput`](crate::output::DeleteProfilingGroupOutput)
    pub fn builder() -> crate::output::delete_profiling_group_output::Builder {
        crate::output::delete_profiling_group_output::Builder::default()
    }
}

/// <p>The structure representing the updateProfilingGroupResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProfilingGroupOutput {
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// that contains information about the returned updated profiling group.
    /// </p>
    pub profiling_group: std::option::Option<crate::model::ProfilingGroupDescription>,
}
impl UpdateProfilingGroupOutput {
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// that contains information about the returned updated profiling group.
    /// </p>
    pub fn profiling_group(&self) -> std::option::Option<&crate::model::ProfilingGroupDescription> {
        self.profiling_group.as_ref()
    }
}
impl std::fmt::Debug for UpdateProfilingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProfilingGroupOutput");
        formatter.field("profiling_group", &self.profiling_group);
        formatter.finish()
    }
}
/// See [`UpdateProfilingGroupOutput`](crate::output::UpdateProfilingGroupOutput)
pub mod update_profiling_group_output {
    /// A builder for [`UpdateProfilingGroupOutput`](crate::output::UpdateProfilingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group: std::option::Option<crate::model::ProfilingGroupDescription>,
    }
    impl Builder {
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// that contains information about the returned updated profiling group.
        /// </p>
        pub fn profiling_group(mut self, input: crate::model::ProfilingGroupDescription) -> Self {
            self.profiling_group = Some(input);
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// that contains information about the returned updated profiling group.
        /// </p>
        pub fn set_profiling_group(
            mut self,
            input: std::option::Option<crate::model::ProfilingGroupDescription>,
        ) -> Self {
            self.profiling_group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProfilingGroupOutput`](crate::output::UpdateProfilingGroupOutput)
        pub fn build(self) -> crate::output::UpdateProfilingGroupOutput {
            crate::output::UpdateProfilingGroupOutput {
                profiling_group: self.profiling_group,
            }
        }
    }
}
impl UpdateProfilingGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProfilingGroupOutput`](crate::output::UpdateProfilingGroupOutput)
    pub fn builder() -> crate::output::update_profiling_group_output::Builder {
        crate::output::update_profiling_group_output::Builder::default()
    }
}

/// <p>The structure representing the describeProfilingGroupResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProfilingGroupOutput {
    /// <p>
    /// The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// object that contains information about the requested profiling group.
    /// </p>
    pub profiling_group: std::option::Option<crate::model::ProfilingGroupDescription>,
}
impl DescribeProfilingGroupOutput {
    /// <p>
    /// The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a>
    /// object that contains information about the requested profiling group.
    /// </p>
    pub fn profiling_group(&self) -> std::option::Option<&crate::model::ProfilingGroupDescription> {
        self.profiling_group.as_ref()
    }
}
impl std::fmt::Debug for DescribeProfilingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProfilingGroupOutput");
        formatter.field("profiling_group", &self.profiling_group);
        formatter.finish()
    }
}
/// See [`DescribeProfilingGroupOutput`](crate::output::DescribeProfilingGroupOutput)
pub mod describe_profiling_group_output {
    /// A builder for [`DescribeProfilingGroupOutput`](crate::output::DescribeProfilingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group: std::option::Option<crate::model::ProfilingGroupDescription>,
    }
    impl Builder {
        /// <p>
        /// The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// object that contains information about the requested profiling group.
        /// </p>
        pub fn profiling_group(mut self, input: crate::model::ProfilingGroupDescription) -> Self {
            self.profiling_group = Some(input);
            self
        }
        /// <p>
        /// The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a>
        /// object that contains information about the requested profiling group.
        /// </p>
        pub fn set_profiling_group(
            mut self,
            input: std::option::Option<crate::model::ProfilingGroupDescription>,
        ) -> Self {
            self.profiling_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProfilingGroupOutput`](crate::output::DescribeProfilingGroupOutput)
        pub fn build(self) -> crate::output::DescribeProfilingGroupOutput {
            crate::output::DescribeProfilingGroupOutput {
                profiling_group: self.profiling_group,
            }
        }
    }
}
impl DescribeProfilingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProfilingGroupOutput`](crate::output::DescribeProfilingGroupOutput)
    pub fn builder() -> crate::output::describe_profiling_group_output::Builder {
        crate::output::describe_profiling_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>
    /// The list of tags assigned to the specified resource. This is the list of tags
    /// returned in the response.
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>
    /// The list of tags assigned to the specified resource. This is the list of tags
    /// returned in the response.
    /// </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The list of tags assigned to the specified resource. This is the list of tags
        /// returned in the response.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>
        /// The list of tags assigned to the specified resource. This is the list of tags
        /// returned in the response.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>The structure representing the GetFindingsReportAccountSummaryResponse.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsReportAccountSummaryOutput {
    /// <p>The return list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
    /// <code>FindingsReportSummary</code>
    /// </a>
    /// objects taht contain summaries of analysis results for all profiling groups in your AWS account.</p>
    pub report_summaries: std::option::Option<std::vec::Vec<crate::model::FindingsReportSummary>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>GetFindingsReportAccountSummary</code> request.
    /// When the results of a <code>GetFindingsReportAccountSummary</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetFindingsReportAccountSummaryOutput {
    /// <p>The return list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
    /// <code>FindingsReportSummary</code>
    /// </a>
    /// objects taht contain summaries of analysis results for all profiling groups in your AWS account.</p>
    pub fn report_summaries(&self) -> std::option::Option<&[crate::model::FindingsReportSummary]> {
        self.report_summaries.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>GetFindingsReportAccountSummary</code> request.
    /// When the results of a <code>GetFindingsReportAccountSummary</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
    /// results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetFindingsReportAccountSummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsReportAccountSummaryOutput");
        formatter.field("report_summaries", &self.report_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetFindingsReportAccountSummaryOutput`](crate::output::GetFindingsReportAccountSummaryOutput)
pub mod get_findings_report_account_summary_output {
    /// A builder for [`GetFindingsReportAccountSummaryOutput`](crate::output::GetFindingsReportAccountSummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_summaries:
            std::option::Option<std::vec::Vec<crate::model::FindingsReportSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `report_summaries`.
        ///
        /// To override the contents of this collection use [`set_report_summaries`](Self::set_report_summaries).
        ///
        /// <p>The return list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
        /// <code>FindingsReportSummary</code>
        /// </a>
        /// objects taht contain summaries of analysis results for all profiling groups in your AWS account.</p>
        pub fn report_summaries(
            mut self,
            input: impl Into<crate::model::FindingsReportSummary>,
        ) -> Self {
            let mut v = self.report_summaries.unwrap_or_default();
            v.push(input.into());
            self.report_summaries = Some(v);
            self
        }
        /// <p>The return list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
        /// <code>FindingsReportSummary</code>
        /// </a>
        /// objects taht contain summaries of analysis results for all profiling groups in your AWS account.</p>
        pub fn set_report_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingsReportSummary>>,
        ) -> Self {
            self.report_summaries = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>GetFindingsReportAccountSummary</code> request.
        /// When the results of a <code>GetFindingsReportAccountSummary</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>GetFindingsReportAccountSummary</code> request.
        /// When the results of a <code>GetFindingsReportAccountSummary</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
        /// results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsReportAccountSummaryOutput`](crate::output::GetFindingsReportAccountSummaryOutput)
        pub fn build(self) -> crate::output::GetFindingsReportAccountSummaryOutput {
            crate::output::GetFindingsReportAccountSummaryOutput {
                report_summaries: self.report_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl GetFindingsReportAccountSummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetFindingsReportAccountSummaryOutput`](crate::output::GetFindingsReportAccountSummaryOutput)
    pub fn builder() -> crate::output::get_findings_report_account_summary_output::Builder {
        crate::output::get_findings_report_account_summary_output::Builder::default()
    }
}
