// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeedbackType {
    /// Profiler recommendation flagged as not useful.
    Negative,
    /// Profiler recommendation flagged as useful.
    Positive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeedbackType {
    fn from(s: &str) -> Self {
        match s {
            "Negative" => FeedbackType::Negative,
            "Positive" => FeedbackType::Positive,
            other => FeedbackType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeedbackType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeedbackType::from(s))
    }
}
impl FeedbackType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeedbackType::Negative => "Negative",
            FeedbackType::Positive => "Positive",
            FeedbackType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Negative", "Positive"]
    }
}
impl AsRef<str> for FeedbackType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionGroup {
    /// Permission group type for Agent APIs - ConfigureAgent, PostAgentProfile
    AgentPermissions,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionGroup {
    fn from(s: &str) -> Self {
        match s {
            "agentPermissions" => ActionGroup::AgentPermissions,
            other => ActionGroup::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionGroup {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionGroup::from(s))
    }
}
impl ActionGroup {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionGroup::AgentPermissions => "agentPermissions",
            ActionGroup::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["agentPermissions"]
    }
}
impl AsRef<str> for ActionGroup {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for notifications stored for each profiling group. This includes up to
/// to two channels and a list of event publishers associated with each channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfiguration {
    /// <p>List of up to two channels to be used for sending notifications for events detected from
    /// the application profile.</p>
    pub channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
}
impl NotificationConfiguration {
    /// <p>List of up to two channels to be used for sending notifications for events detected from
    /// the application profile.</p>
    pub fn channels(&self) -> std::option::Option<&[crate::model::Channel]> {
        self.channels.as_deref()
    }
}
impl std::fmt::Debug for NotificationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfiguration");
        formatter.field("channels", &self.channels);
        formatter.finish()
    }
}
/// See [`NotificationConfiguration`](crate::model::NotificationConfiguration)
pub mod notification_configuration {
    /// A builder for [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>List of up to two channels to be used for sending notifications for events detected from
        /// the application profile.</p>
        pub fn channels(mut self, input: impl Into<crate::model::Channel>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p>List of up to two channels to be used for sending notifications for events detected from
        /// the application profile.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::model::NotificationConfiguration)
        pub fn build(self) -> crate::model::NotificationConfiguration {
            crate::model::NotificationConfiguration {
                channels: self.channels,
            }
        }
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    pub fn builder() -> crate::model::notification_configuration::Builder {
        crate::model::notification_configuration::Builder::default()
    }
}

/// <p>Notification medium for users to get alerted for events that occur in application profile. We support SNS topic as a notification channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Channel {
    /// <p>Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.</p>
    pub event_publishers: std::option::Option<std::vec::Vec<crate::model::EventPublisher>>,
}
impl Channel {
    /// <p>Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.</p>
    pub fn event_publishers(
        &self,
    ) -> std::option::Option<&std::vec::Vec<crate::model::EventPublisher>> {
        self.event_publishers.as_ref()
    }
}
impl std::fmt::Debug for Channel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Channel");
        formatter.field("id", &self.id);
        formatter.field("uri", &self.uri);
        formatter.field("event_publishers", &self.event_publishers);
        formatter.finish()
    }
}
/// See [`Channel`](crate::model::Channel)
pub mod channel {
    /// A builder for [`Channel`](crate::model::Channel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) event_publishers:
            std::option::Option<std::vec::Vec<crate::model::EventPublisher>>,
    }
    impl Builder {
        /// <p>Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.</p>
        pub fn event_publishers(
            mut self,
            input: std::vec::Vec<crate::model::EventPublisher>,
        ) -> Self {
            self.event_publishers = Some(input);
            self
        }
        /// <p>List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.</p>
        pub fn set_event_publishers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventPublisher>>,
        ) -> Self {
            self.event_publishers = input;
            self
        }
        /// Consumes the builder and constructs a [`Channel`](crate::model::Channel)
        pub fn build(self) -> crate::model::Channel {
            crate::model::Channel {
                id: self.id,
                uri: self.uri,
                event_publishers: self.event_publishers,
            }
        }
    }
}
impl Channel {
    /// Creates a new builder-style object to manufacture [`Channel`](crate::model::Channel)
    pub fn builder() -> crate::model::channel::Builder {
        crate::model::channel::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventPublisher {
    /// Notifications for Anomaly Detection
    AnomalyDetection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventPublisher {
    fn from(s: &str) -> Self {
        match s {
            "AnomalyDetection" => EventPublisher::AnomalyDetection,
            other => EventPublisher::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventPublisher {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventPublisher::from(s))
    }
}
impl EventPublisher {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventPublisher::AnomalyDetection => "AnomalyDetection",
            EventPublisher::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AnomalyDetection"]
    }
}
impl AsRef<str> for EventPublisher {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Contains the start time of a profile.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProfileTime {
    /// <p>The start time of a profile. It is specified using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub start: std::option::Option<aws_smithy_types::DateTime>,
}
impl ProfileTime {
    /// <p>The start time of a profile. It is specified using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub fn start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start.as_ref()
    }
}
impl std::fmt::Debug for ProfileTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProfileTime");
        formatter.field("start", &self.start);
        formatter.finish()
    }
}
/// See [`ProfileTime`](crate::model::ProfileTime)
pub mod profile_time {
    /// A builder for [`ProfileTime`](crate::model::ProfileTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start time of a profile. It is specified using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The start time of a profile. It is specified using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.start = input;
            self
        }
        /// Consumes the builder and constructs a [`ProfileTime`](crate::model::ProfileTime)
        pub fn build(self) -> crate::model::ProfileTime {
            crate::model::ProfileTime { start: self.start }
        }
    }
}
impl ProfileTime {
    /// Creates a new builder-style object to manufacture [`ProfileTime`](crate::model::ProfileTime)
    pub fn builder() -> crate::model::profile_time::Builder {
        crate::model::profile_time::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderBy {
    /// Order by timestamp in ascending order.
    TimestampAscending,
    /// Order by timestamp in descending order.
    TimestampDescending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderBy {
    fn from(s: &str) -> Self {
        match s {
            "TimestampAscending" => OrderBy::TimestampAscending,
            "TimestampDescending" => OrderBy::TimestampDescending,
            other => OrderBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderBy::from(s))
    }
}
impl OrderBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderBy::TimestampAscending => "TimestampAscending",
            OrderBy::TimestampDescending => "TimestampDescending",
            OrderBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TimestampAscending", "TimestampDescending"]
    }
}
impl AsRef<str> for OrderBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregationPeriod {
    /// Period of one day.
    P1D,
    /// Period of one hour.
    Pt1H,
    /// Period of five minutes.
    Pt5M,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregationPeriod {
    fn from(s: &str) -> Self {
        match s {
            "P1D" => AggregationPeriod::P1D,
            "PT1H" => AggregationPeriod::Pt1H,
            "PT5M" => AggregationPeriod::Pt5M,
            other => AggregationPeriod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregationPeriod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregationPeriod::from(s))
    }
}
impl AggregationPeriod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregationPeriod::P1D => "P1D",
            AggregationPeriod::Pt1H => "PT1H",
            AggregationPeriod::Pt5M => "PT5M",
            AggregationPeriod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["P1D", "PT1H", "PT5M"]
    }
}
impl AsRef<str> for AggregationPeriod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about potential recommendations that might be created from the
/// analysis of profiling data.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingsReportSummary {
    /// <p>The universally unique identifier (UUID) of the recommendation report.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the profiling group that is associated with the analysis data.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>The start time of the profile the analysis data is about.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub profile_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The end time of the period during which the metric is flagged as anomalous.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub profile_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The total number of different recommendations that were found by the analysis.</p>
    pub total_number_of_findings: std::option::Option<i32>,
}
impl FindingsReportSummary {
    /// <p>The universally unique identifier (UUID) of the recommendation report.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the profiling group that is associated with the analysis data.</p>
    pub fn profiling_group_name(&self) -> std::option::Option<&str> {
        self.profiling_group_name.as_deref()
    }
    /// <p>The start time of the profile the analysis data is about.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub fn profile_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.profile_start_time.as_ref()
    }
    /// <p>
    /// The end time of the period during which the metric is flagged as anomalous.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn profile_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.profile_end_time.as_ref()
    }
    /// <p>The total number of different recommendations that were found by the analysis.</p>
    pub fn total_number_of_findings(&self) -> std::option::Option<i32> {
        self.total_number_of_findings
    }
}
impl std::fmt::Debug for FindingsReportSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingsReportSummary");
        formatter.field("id", &self.id);
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("profile_start_time", &self.profile_start_time);
        formatter.field("profile_end_time", &self.profile_end_time);
        formatter.field("total_number_of_findings", &self.total_number_of_findings);
        formatter.finish()
    }
}
/// See [`FindingsReportSummary`](crate::model::FindingsReportSummary)
pub mod findings_report_summary {
    /// A builder for [`FindingsReportSummary`](crate::model::FindingsReportSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) profile_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) profile_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) total_number_of_findings: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The universally unique identifier (UUID) of the recommendation report.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The universally unique identifier (UUID) of the recommendation report.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the profiling group that is associated with the analysis data.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group that is associated with the analysis data.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>The start time of the profile the analysis data is about.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn profile_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.profile_start_time = Some(input);
            self
        }
        /// <p>The start time of the profile the analysis data is about.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn set_profile_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.profile_start_time = input;
            self
        }
        /// <p>
        /// The end time of the period during which the metric is flagged as anomalous.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn profile_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.profile_end_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the period during which the metric is flagged as anomalous.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_profile_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.profile_end_time = input;
            self
        }
        /// <p>The total number of different recommendations that were found by the analysis.</p>
        pub fn total_number_of_findings(mut self, input: i32) -> Self {
            self.total_number_of_findings = Some(input);
            self
        }
        /// <p>The total number of different recommendations that were found by the analysis.</p>
        pub fn set_total_number_of_findings(mut self, input: std::option::Option<i32>) -> Self {
            self.total_number_of_findings = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingsReportSummary`](crate::model::FindingsReportSummary)
        pub fn build(self) -> crate::model::FindingsReportSummary {
            crate::model::FindingsReportSummary {
                id: self.id,
                profiling_group_name: self.profiling_group_name,
                profile_start_time: self.profile_start_time,
                profile_end_time: self.profile_end_time,
                total_number_of_findings: self.total_number_of_findings,
            }
        }
    }
}
impl FindingsReportSummary {
    /// Creates a new builder-style object to manufacture [`FindingsReportSummary`](crate::model::FindingsReportSummary)
    pub fn builder() -> crate::model::findings_report_summary::Builder {
        crate::model::findings_report_summary::Builder::default()
    }
}

/// <p>
/// Details about an anomaly in a specific metric of application profile. The anomaly is detected using  
/// analysis of the metric data over a period of time.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Anomaly {
    /// <p>
    /// Details about the metric that the analysis used when it detected the anomaly.
    /// The metric includes the name of the frame that was analyzed with the type and
    /// thread states used to derive the metric value for that frame.
    /// </p>
    pub metric: std::option::Option<crate::model::Metric>,
    /// <p>The reason for which metric was flagged as anomalous.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>
    /// A list of the instances of the detected anomalies during the requested period.
    /// </p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::AnomalyInstance>>,
}
impl Anomaly {
    /// <p>
    /// Details about the metric that the analysis used when it detected the anomaly.
    /// The metric includes the name of the frame that was analyzed with the type and
    /// thread states used to derive the metric value for that frame.
    /// </p>
    pub fn metric(&self) -> std::option::Option<&crate::model::Metric> {
        self.metric.as_ref()
    }
    /// <p>The reason for which metric was flagged as anomalous.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>
    /// A list of the instances of the detected anomalies during the requested period.
    /// </p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::AnomalyInstance]> {
        self.instances.as_deref()
    }
}
impl std::fmt::Debug for Anomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Anomaly");
        formatter.field("metric", &self.metric);
        formatter.field("reason", &self.reason);
        formatter.field("instances", &self.instances);
        formatter.finish()
    }
}
/// See [`Anomaly`](crate::model::Anomaly)
pub mod anomaly {
    /// A builder for [`Anomaly`](crate::model::Anomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<crate::model::Metric>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::AnomalyInstance>>,
    }
    impl Builder {
        /// <p>
        /// Details about the metric that the analysis used when it detected the anomaly.
        /// The metric includes the name of the frame that was analyzed with the type and
        /// thread states used to derive the metric value for that frame.
        /// </p>
        pub fn metric(mut self, input: crate::model::Metric) -> Self {
            self.metric = Some(input);
            self
        }
        /// <p>
        /// Details about the metric that the analysis used when it detected the anomaly.
        /// The metric includes the name of the frame that was analyzed with the type and
        /// thread states used to derive the metric value for that frame.
        /// </p>
        pub fn set_metric(mut self, input: std::option::Option<crate::model::Metric>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The reason for which metric was flagged as anomalous.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for which metric was flagged as anomalous.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>
        /// A list of the instances of the detected anomalies during the requested period.
        /// </p>
        pub fn instances(mut self, input: impl Into<crate::model::AnomalyInstance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>
        /// A list of the instances of the detected anomalies during the requested period.
        /// </p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyInstance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Consumes the builder and constructs a [`Anomaly`](crate::model::Anomaly)
        pub fn build(self) -> crate::model::Anomaly {
            crate::model::Anomaly {
                metric: self.metric,
                reason: self.reason,
                instances: self.instances,
            }
        }
    }
}
impl Anomaly {
    /// Creates a new builder-style object to manufacture [`Anomaly`](crate::model::Anomaly)
    pub fn builder() -> crate::model::anomaly::Builder {
        crate::model::anomaly::Builder::default()
    }
}

/// <p>The specific duration in which the metric is flagged as anomalous.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyInstance {
    /// <p>
    /// The universally unique identifier (UUID) of an instance of an anomaly in a metric.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>
    /// The start time of the period during which the metric is flagged as anomalous.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The end time of the period during which the metric is flagged as anomalous.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Feedback type on a specific instance of anomaly submitted by the user.</p>
    pub user_feedback: std::option::Option<crate::model::UserFeedback>,
}
impl AnomalyInstance {
    /// <p>
    /// The universally unique identifier (UUID) of an instance of an anomaly in a metric.
    /// </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>
    /// The start time of the period during which the metric is flagged as anomalous.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>
    /// The end time of the period during which the metric is flagged as anomalous.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Feedback type on a specific instance of anomaly submitted by the user.</p>
    pub fn user_feedback(&self) -> std::option::Option<&crate::model::UserFeedback> {
        self.user_feedback.as_ref()
    }
}
impl std::fmt::Debug for AnomalyInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyInstance");
        formatter.field("id", &self.id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("user_feedback", &self.user_feedback);
        formatter.finish()
    }
}
/// See [`AnomalyInstance`](crate::model::AnomalyInstance)
pub mod anomaly_instance {
    /// A builder for [`AnomalyInstance`](crate::model::AnomalyInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) user_feedback: std::option::Option<crate::model::UserFeedback>,
    }
    impl Builder {
        /// <p>
        /// The universally unique identifier (UUID) of an instance of an anomaly in a metric.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The universally unique identifier (UUID) of an instance of an anomaly in a metric.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>
        /// The start time of the period during which the metric is flagged as anomalous.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The start time of the period during which the metric is flagged as anomalous.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The end time of the period during which the metric is flagged as anomalous.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the period during which the metric is flagged as anomalous.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Feedback type on a specific instance of anomaly submitted by the user.</p>
        pub fn user_feedback(mut self, input: crate::model::UserFeedback) -> Self {
            self.user_feedback = Some(input);
            self
        }
        /// <p>Feedback type on a specific instance of anomaly submitted by the user.</p>
        pub fn set_user_feedback(
            mut self,
            input: std::option::Option<crate::model::UserFeedback>,
        ) -> Self {
            self.user_feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyInstance`](crate::model::AnomalyInstance)
        pub fn build(self) -> crate::model::AnomalyInstance {
            crate::model::AnomalyInstance {
                id: self.id,
                start_time: self.start_time,
                end_time: self.end_time,
                user_feedback: self.user_feedback,
            }
        }
    }
}
impl AnomalyInstance {
    /// Creates a new builder-style object to manufacture [`AnomalyInstance`](crate::model::AnomalyInstance)
    pub fn builder() -> crate::model::anomaly_instance::Builder {
        crate::model::anomaly_instance::Builder::default()
    }
}

/// <p>Feedback that can be submitted for each instance of an anomaly by the user.
/// Feedback is be used for improvements in generating recommendations for the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserFeedback {
    /// <p>Optional <code>Positive</code> or <code>Negative</code> feedback submitted by
    /// the user about whether the recommendation is useful or not.</p>
    pub r#type: std::option::Option<crate::model::FeedbackType>,
}
impl UserFeedback {
    /// <p>Optional <code>Positive</code> or <code>Negative</code> feedback submitted by
    /// the user about whether the recommendation is useful or not.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FeedbackType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UserFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserFeedback");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`UserFeedback`](crate::model::UserFeedback)
pub mod user_feedback {
    /// A builder for [`UserFeedback`](crate::model::UserFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FeedbackType>,
    }
    impl Builder {
        /// <p>Optional <code>Positive</code> or <code>Negative</code> feedback submitted by
        /// the user about whether the recommendation is useful or not.</p>
        pub fn r#type(mut self, input: crate::model::FeedbackType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Optional <code>Positive</code> or <code>Negative</code> feedback submitted by
        /// the user about whether the recommendation is useful or not.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FeedbackType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UserFeedback`](crate::model::UserFeedback)
        pub fn build(self) -> crate::model::UserFeedback {
            crate::model::UserFeedback {
                r#type: self.r#type,
            }
        }
    }
}
impl UserFeedback {
    /// Creates a new builder-style object to manufacture [`UserFeedback`](crate::model::UserFeedback)
    pub fn builder() -> crate::model::user_feedback::Builder {
        crate::model::user_feedback::Builder::default()
    }
}

/// <p>
/// Details about the metric that the analysis used when it detected the anomaly.
/// The metric what is analyzed to create recommendations. It includes the name of the
/// frame that was analyzed and the type and thread states used to derive the metric
/// value for that frame.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metric {
    /// <p>
    /// The name of the method that appears as a frame in any stack in a profile.
    /// </p>
    pub frame_name: std::option::Option<std::string::String>,
    /// <p>
    /// A type that specifies how a metric for a frame is analyzed.
    /// The supported value <code>AggregatedRelativeTotalTime</code> is an
    /// aggregation of the metric value for one frame that is calculated across the
    /// occurences of all frames in a profile.</p>
    pub r#type: std::option::Option<crate::model::MetricType>,
    /// <p>
    /// The list of application runtime thread states that is used to calculate the
    /// metric value for the frame.
    /// </p>
    pub thread_states: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Metric {
    /// <p>
    /// The name of the method that appears as a frame in any stack in a profile.
    /// </p>
    pub fn frame_name(&self) -> std::option::Option<&str> {
        self.frame_name.as_deref()
    }
    /// <p>
    /// A type that specifies how a metric for a frame is analyzed.
    /// The supported value <code>AggregatedRelativeTotalTime</code> is an
    /// aggregation of the metric value for one frame that is calculated across the
    /// occurences of all frames in a profile.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MetricType> {
        self.r#type.as_ref()
    }
    /// <p>
    /// The list of application runtime thread states that is used to calculate the
    /// metric value for the frame.
    /// </p>
    pub fn thread_states(&self) -> std::option::Option<&[std::string::String]> {
        self.thread_states.as_deref()
    }
}
impl std::fmt::Debug for Metric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metric");
        formatter.field("frame_name", &self.frame_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("thread_states", &self.thread_states);
        formatter.finish()
    }
}
/// See [`Metric`](crate::model::Metric)
pub mod metric {
    /// A builder for [`Metric`](crate::model::Metric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frame_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::MetricType>,
        pub(crate) thread_states: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>
        /// The name of the method that appears as a frame in any stack in a profile.
        /// </p>
        pub fn frame_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.frame_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the method that appears as a frame in any stack in a profile.
        /// </p>
        pub fn set_frame_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.frame_name = input;
            self
        }
        /// <p>
        /// A type that specifies how a metric for a frame is analyzed.
        /// The supported value <code>AggregatedRelativeTotalTime</code> is an
        /// aggregation of the metric value for one frame that is calculated across the
        /// occurences of all frames in a profile.</p>
        pub fn r#type(mut self, input: crate::model::MetricType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// A type that specifies how a metric for a frame is analyzed.
        /// The supported value <code>AggregatedRelativeTotalTime</code> is an
        /// aggregation of the metric value for one frame that is calculated across the
        /// occurences of all frames in a profile.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::MetricType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `thread_states`.
        ///
        /// To override the contents of this collection use [`set_thread_states`](Self::set_thread_states).
        ///
        /// <p>
        /// The list of application runtime thread states that is used to calculate the
        /// metric value for the frame.
        /// </p>
        pub fn thread_states(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.thread_states.unwrap_or_default();
            v.push(input.into());
            self.thread_states = Some(v);
            self
        }
        /// <p>
        /// The list of application runtime thread states that is used to calculate the
        /// metric value for the frame.
        /// </p>
        pub fn set_thread_states(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.thread_states = input;
            self
        }
        /// Consumes the builder and constructs a [`Metric`](crate::model::Metric)
        pub fn build(self) -> crate::model::Metric {
            crate::model::Metric {
                frame_name: self.frame_name,
                r#type: self.r#type,
                thread_states: self.thread_states,
            }
        }
    }
}
impl Metric {
    /// Creates a new builder-style object to manufacture [`Metric`](crate::model::Metric)
    pub fn builder() -> crate::model::metric::Builder {
        crate::model::metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricType {
    /// Metric value aggregated for all instances of a frame name in a profile relative to the root frame.
    AggregatedRelativeTotalTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricType {
    fn from(s: &str) -> Self {
        match s {
            "AggregatedRelativeTotalTime" => MetricType::AggregatedRelativeTotalTime,
            other => MetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricType::from(s))
    }
}
impl MetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricType::AggregatedRelativeTotalTime => "AggregatedRelativeTotalTime",
            MetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AggregatedRelativeTotalTime"]
    }
}
impl AsRef<str> for MetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A potential improvement that was found from analyzing the profiling data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recommendation {
    /// <p>How many different places in the profile graph triggered a match.</p>
    pub all_matches_count: std::option::Option<i32>,
    /// <p>How much of the total sample count is potentially affected.</p>
    pub all_matches_sum: std::option::Option<f64>,
    /// <p>The pattern that analysis recognized in the profile to make this recommendation.</p>
    pub pattern: std::option::Option<crate::model::Pattern>,
    /// <p>List of the matches with most impact. </p>
    pub top_matches: std::option::Option<std::vec::Vec<crate::model::Match>>,
    /// <p>The start time of the profile that was used by this analysis.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>End time of the profile that was used by this analysis.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Recommendation {
    /// <p>How many different places in the profile graph triggered a match.</p>
    pub fn all_matches_count(&self) -> std::option::Option<i32> {
        self.all_matches_count
    }
    /// <p>How much of the total sample count is potentially affected.</p>
    pub fn all_matches_sum(&self) -> std::option::Option<f64> {
        self.all_matches_sum
    }
    /// <p>The pattern that analysis recognized in the profile to make this recommendation.</p>
    pub fn pattern(&self) -> std::option::Option<&crate::model::Pattern> {
        self.pattern.as_ref()
    }
    /// <p>List of the matches with most impact. </p>
    pub fn top_matches(&self) -> std::option::Option<&[crate::model::Match]> {
        self.top_matches.as_deref()
    }
    /// <p>The start time of the profile that was used by this analysis.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>End time of the profile that was used by this analysis.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for Recommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recommendation");
        formatter.field("all_matches_count", &self.all_matches_count);
        formatter.field("all_matches_sum", &self.all_matches_sum);
        formatter.field("pattern", &self.pattern);
        formatter.field("top_matches", &self.top_matches);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`Recommendation`](crate::model::Recommendation)
pub mod recommendation {
    /// A builder for [`Recommendation`](crate::model::Recommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) all_matches_count: std::option::Option<i32>,
        pub(crate) all_matches_sum: std::option::Option<f64>,
        pub(crate) pattern: std::option::Option<crate::model::Pattern>,
        pub(crate) top_matches: std::option::Option<std::vec::Vec<crate::model::Match>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>How many different places in the profile graph triggered a match.</p>
        pub fn all_matches_count(mut self, input: i32) -> Self {
            self.all_matches_count = Some(input);
            self
        }
        /// <p>How many different places in the profile graph triggered a match.</p>
        pub fn set_all_matches_count(mut self, input: std::option::Option<i32>) -> Self {
            self.all_matches_count = input;
            self
        }
        /// <p>How much of the total sample count is potentially affected.</p>
        pub fn all_matches_sum(mut self, input: f64) -> Self {
            self.all_matches_sum = Some(input);
            self
        }
        /// <p>How much of the total sample count is potentially affected.</p>
        pub fn set_all_matches_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.all_matches_sum = input;
            self
        }
        /// <p>The pattern that analysis recognized in the profile to make this recommendation.</p>
        pub fn pattern(mut self, input: crate::model::Pattern) -> Self {
            self.pattern = Some(input);
            self
        }
        /// <p>The pattern that analysis recognized in the profile to make this recommendation.</p>
        pub fn set_pattern(mut self, input: std::option::Option<crate::model::Pattern>) -> Self {
            self.pattern = input;
            self
        }
        /// Appends an item to `top_matches`.
        ///
        /// To override the contents of this collection use [`set_top_matches`](Self::set_top_matches).
        ///
        /// <p>List of the matches with most impact. </p>
        pub fn top_matches(mut self, input: impl Into<crate::model::Match>) -> Self {
            let mut v = self.top_matches.unwrap_or_default();
            v.push(input.into());
            self.top_matches = Some(v);
            self
        }
        /// <p>List of the matches with most impact. </p>
        pub fn set_top_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Match>>,
        ) -> Self {
            self.top_matches = input;
            self
        }
        /// <p>The start time of the profile that was used by this analysis.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the profile that was used by this analysis.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>End time of the profile that was used by this analysis.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>End time of the profile that was used by this analysis.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Recommendation`](crate::model::Recommendation)
        pub fn build(self) -> crate::model::Recommendation {
            crate::model::Recommendation {
                all_matches_count: self.all_matches_count,
                all_matches_sum: self.all_matches_sum,
                pattern: self.pattern,
                top_matches: self.top_matches,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl Recommendation {
    /// Creates a new builder-style object to manufacture [`Recommendation`](crate::model::Recommendation)
    pub fn builder() -> crate::model::recommendation::Builder {
        crate::model::recommendation::Builder::default()
    }
}

/// <p>The part of a profile that contains a recommendation found during analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Match {
    /// <p>The target frame that triggered a match.</p>
    pub target_frames_index: std::option::Option<i32>,
    /// <p>The location in the profiling graph that contains a recommendation found during analysis.</p>
    pub frame_address: std::option::Option<std::string::String>,
    /// <p>The value in the profile data that exceeded the recommendation threshold.</p>
    pub threshold_breach_value: std::option::Option<f64>,
}
impl Match {
    /// <p>The target frame that triggered a match.</p>
    pub fn target_frames_index(&self) -> std::option::Option<i32> {
        self.target_frames_index
    }
    /// <p>The location in the profiling graph that contains a recommendation found during analysis.</p>
    pub fn frame_address(&self) -> std::option::Option<&str> {
        self.frame_address.as_deref()
    }
    /// <p>The value in the profile data that exceeded the recommendation threshold.</p>
    pub fn threshold_breach_value(&self) -> std::option::Option<f64> {
        self.threshold_breach_value
    }
}
impl std::fmt::Debug for Match {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Match");
        formatter.field("target_frames_index", &self.target_frames_index);
        formatter.field("frame_address", &self.frame_address);
        formatter.field("threshold_breach_value", &self.threshold_breach_value);
        formatter.finish()
    }
}
/// See [`Match`](crate::model::Match)
pub mod r#match {
    /// A builder for [`Match`](crate::model::Match)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_frames_index: std::option::Option<i32>,
        pub(crate) frame_address: std::option::Option<std::string::String>,
        pub(crate) threshold_breach_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The target frame that triggered a match.</p>
        pub fn target_frames_index(mut self, input: i32) -> Self {
            self.target_frames_index = Some(input);
            self
        }
        /// <p>The target frame that triggered a match.</p>
        pub fn set_target_frames_index(mut self, input: std::option::Option<i32>) -> Self {
            self.target_frames_index = input;
            self
        }
        /// <p>The location in the profiling graph that contains a recommendation found during analysis.</p>
        pub fn frame_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.frame_address = Some(input.into());
            self
        }
        /// <p>The location in the profiling graph that contains a recommendation found during analysis.</p>
        pub fn set_frame_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.frame_address = input;
            self
        }
        /// <p>The value in the profile data that exceeded the recommendation threshold.</p>
        pub fn threshold_breach_value(mut self, input: f64) -> Self {
            self.threshold_breach_value = Some(input);
            self
        }
        /// <p>The value in the profile data that exceeded the recommendation threshold.</p>
        pub fn set_threshold_breach_value(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold_breach_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Match`](crate::model::Match)
        pub fn build(self) -> crate::model::Match {
            crate::model::Match {
                target_frames_index: self.target_frames_index,
                frame_address: self.frame_address,
                threshold_breach_value: self.threshold_breach_value,
            }
        }
    }
}
impl Match {
    /// Creates a new builder-style object to manufacture [`Match`](crate::model::Match)
    pub fn builder() -> crate::model::r#match::Builder {
        crate::model::r#match::Builder::default()
    }
}

/// <p>
/// A set of rules used to make a recommendation during an analysis.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Pattern {
    /// <p>The universally unique identifier (UUID) of this pattern.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name for this pattern.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the recommendation. This explains a potential
    /// inefficiency in a profiled application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the steps recommended to address the potential inefficiency.
    /// </p>
    pub resolution_steps: std::option::Option<std::string::String>,
    /// <p>A list of frame names that were searched during the analysis that generated
    /// a recommendation.</p>
    pub target_frames: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
    /// <p>
    /// The percentage of time an application spends in one method that triggers
    /// a recommendation. The percentage of time is the same as the percentage of
    /// the total gathered sample counts during analysis.
    /// </p>
    pub threshold_percent: f64,
    /// <p>
    /// A list of the different counters used to determine if there is a match.
    /// </p>
    pub counters_to_aggregate: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Pattern {
    /// <p>The universally unique identifier (UUID) of this pattern.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name for this pattern.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the recommendation. This explains a potential
    /// inefficiency in a profiled application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>
    /// A string that contains the steps recommended to address the potential inefficiency.
    /// </p>
    pub fn resolution_steps(&self) -> std::option::Option<&str> {
        self.resolution_steps.as_deref()
    }
    /// <p>A list of frame names that were searched during the analysis that generated
    /// a recommendation.</p>
    pub fn target_frames(&self) -> std::option::Option<&[std::vec::Vec<std::string::String>]> {
        self.target_frames.as_deref()
    }
    /// <p>
    /// The percentage of time an application spends in one method that triggers
    /// a recommendation. The percentage of time is the same as the percentage of
    /// the total gathered sample counts during analysis.
    /// </p>
    pub fn threshold_percent(&self) -> f64 {
        self.threshold_percent
    }
    /// <p>
    /// A list of the different counters used to determine if there is a match.
    /// </p>
    pub fn counters_to_aggregate(&self) -> std::option::Option<&[std::string::String]> {
        self.counters_to_aggregate.as_deref()
    }
}
impl std::fmt::Debug for Pattern {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Pattern");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("resolution_steps", &self.resolution_steps);
        formatter.field("target_frames", &self.target_frames);
        formatter.field("threshold_percent", &self.threshold_percent);
        formatter.field("counters_to_aggregate", &self.counters_to_aggregate);
        formatter.finish()
    }
}
/// See [`Pattern`](crate::model::Pattern)
pub mod pattern {
    /// A builder for [`Pattern`](crate::model::Pattern)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) resolution_steps: std::option::Option<std::string::String>,
        pub(crate) target_frames:
            std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        pub(crate) threshold_percent: std::option::Option<f64>,
        pub(crate) counters_to_aggregate: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The universally unique identifier (UUID) of this pattern.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The universally unique identifier (UUID) of this pattern.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name for this pattern.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for this pattern.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the recommendation. This explains a potential
        /// inefficiency in a profiled application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the recommendation. This explains a potential
        /// inefficiency in a profiled application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>
        /// A string that contains the steps recommended to address the potential inefficiency.
        /// </p>
        pub fn resolution_steps(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_steps = Some(input.into());
            self
        }
        /// <p>
        /// A string that contains the steps recommended to address the potential inefficiency.
        /// </p>
        pub fn set_resolution_steps(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_steps = input;
            self
        }
        /// Appends an item to `target_frames`.
        ///
        /// To override the contents of this collection use [`set_target_frames`](Self::set_target_frames).
        ///
        /// <p>A list of frame names that were searched during the analysis that generated
        /// a recommendation.</p>
        pub fn target_frames(
            mut self,
            input: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut v = self.target_frames.unwrap_or_default();
            v.push(input.into());
            self.target_frames = Some(v);
            self
        }
        /// <p>A list of frame names that were searched during the analysis that generated
        /// a recommendation.</p>
        pub fn set_target_frames(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.target_frames = input;
            self
        }
        /// <p>
        /// The percentage of time an application spends in one method that triggers
        /// a recommendation. The percentage of time is the same as the percentage of
        /// the total gathered sample counts during analysis.
        /// </p>
        pub fn threshold_percent(mut self, input: f64) -> Self {
            self.threshold_percent = Some(input);
            self
        }
        /// <p>
        /// The percentage of time an application spends in one method that triggers
        /// a recommendation. The percentage of time is the same as the percentage of
        /// the total gathered sample counts during analysis.
        /// </p>
        pub fn set_threshold_percent(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold_percent = input;
            self
        }
        /// Appends an item to `counters_to_aggregate`.
        ///
        /// To override the contents of this collection use [`set_counters_to_aggregate`](Self::set_counters_to_aggregate).
        ///
        /// <p>
        /// A list of the different counters used to determine if there is a match.
        /// </p>
        pub fn counters_to_aggregate(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.counters_to_aggregate.unwrap_or_default();
            v.push(input.into());
            self.counters_to_aggregate = Some(v);
            self
        }
        /// <p>
        /// A list of the different counters used to determine if there is a match.
        /// </p>
        pub fn set_counters_to_aggregate(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.counters_to_aggregate = input;
            self
        }
        /// Consumes the builder and constructs a [`Pattern`](crate::model::Pattern)
        pub fn build(self) -> crate::model::Pattern {
            crate::model::Pattern {
                id: self.id,
                name: self.name,
                description: self.description,
                resolution_steps: self.resolution_steps,
                target_frames: self.target_frames,
                threshold_percent: self.threshold_percent.unwrap_or_default(),
                counters_to_aggregate: self.counters_to_aggregate,
            }
        }
    }
}
impl Pattern {
    /// Creates a new builder-style object to manufacture [`Pattern`](crate::model::Pattern)
    pub fn builder() -> crate::model::pattern::Builder {
        crate::model::pattern::Builder::default()
    }
}

/// <p>
/// The response of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
/// <code>ConfigureAgent</code>
/// </a> that
/// specifies if an agent profiles or not and for how long to return profiling data.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentConfiguration {
    /// <p>
    /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
    /// to enable profiling.
    /// </p>
    pub should_profile: std::option::Option<bool>,
    /// <p>
    /// How long a profiling agent should send profiling data using
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
    /// <code>ConfigureAgent</code>
    /// </a>.
    /// For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
    /// <code>ConfigureAgent</code>
    /// </a>
    /// every 5 minutes to submit the profiled data collected during that period.
    /// </p>
    pub period_in_seconds: std::option::Option<i32>,
    /// <p>
    /// Parameters used by the profiler. The valid parameters are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MaxStackDepth</code> - The maximum depth of the stacks in the code that is represented in
    /// the profile. For example, if CodeGuru Profiler finds a method <code>A</code>,
    /// which calls method <code>B</code>, which calls method <code>C</code>, which
    /// calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
    /// set to 2, then the profiler evaluates <code>A</code> and <code>B</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MemoryUsageLimitPercent</code> - The percentage of memory that is used by the
    /// profiler.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MinimumTimeForReportingInMilliseconds</code> - The minimum time in milliseconds between
    /// sending reports.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReportingIntervalInMilliseconds</code> - The reporting interval in milliseconds used
    /// to report profiles.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SamplingIntervalInMilliseconds</code> - The sampling interval in milliseconds that is used to
    /// profile samples.
    /// </p>
    /// </li>
    /// </ul>
    pub agent_parameters: std::option::Option<
        std::collections::HashMap<crate::model::AgentParameterField, std::string::String>,
    >,
}
impl AgentConfiguration {
    /// <p>
    /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
    /// to enable profiling.
    /// </p>
    pub fn should_profile(&self) -> std::option::Option<bool> {
        self.should_profile
    }
    /// <p>
    /// How long a profiling agent should send profiling data using
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
    /// <code>ConfigureAgent</code>
    /// </a>.
    /// For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
    /// <code>ConfigureAgent</code>
    /// </a>
    /// every 5 minutes to submit the profiled data collected during that period.
    /// </p>
    pub fn period_in_seconds(&self) -> std::option::Option<i32> {
        self.period_in_seconds
    }
    /// <p>
    /// Parameters used by the profiler. The valid parameters are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MaxStackDepth</code> - The maximum depth of the stacks in the code that is represented in
    /// the profile. For example, if CodeGuru Profiler finds a method <code>A</code>,
    /// which calls method <code>B</code>, which calls method <code>C</code>, which
    /// calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
    /// set to 2, then the profiler evaluates <code>A</code> and <code>B</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MemoryUsageLimitPercent</code> - The percentage of memory that is used by the
    /// profiler.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MinimumTimeForReportingInMilliseconds</code> - The minimum time in milliseconds between
    /// sending reports.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReportingIntervalInMilliseconds</code> - The reporting interval in milliseconds used
    /// to report profiles.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SamplingIntervalInMilliseconds</code> - The sampling interval in milliseconds that is used to
    /// profile samples.
    /// </p>
    /// </li>
    /// </ul>
    pub fn agent_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::AgentParameterField, std::string::String>,
    > {
        self.agent_parameters.as_ref()
    }
}
impl std::fmt::Debug for AgentConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentConfiguration");
        formatter.field("should_profile", &self.should_profile);
        formatter.field("period_in_seconds", &self.period_in_seconds);
        formatter.field("agent_parameters", &self.agent_parameters);
        formatter.finish()
    }
}
/// See [`AgentConfiguration`](crate::model::AgentConfiguration)
pub mod agent_configuration {
    /// A builder for [`AgentConfiguration`](crate::model::AgentConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) should_profile: std::option::Option<bool>,
        pub(crate) period_in_seconds: std::option::Option<i32>,
        pub(crate) agent_parameters: std::option::Option<
            std::collections::HashMap<crate::model::AgentParameterField, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>
        /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
        /// to enable profiling.
        /// </p>
        pub fn should_profile(mut self, input: bool) -> Self {
            self.should_profile = Some(input);
            self
        }
        /// <p>
        /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
        /// to enable profiling.
        /// </p>
        pub fn set_should_profile(mut self, input: std::option::Option<bool>) -> Self {
            self.should_profile = input;
            self
        }
        /// <p>
        /// How long a profiling agent should send profiling data using
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
        /// <code>ConfigureAgent</code>
        /// </a>.
        /// For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
        /// <code>ConfigureAgent</code>
        /// </a>
        /// every 5 minutes to submit the profiled data collected during that period.
        /// </p>
        pub fn period_in_seconds(mut self, input: i32) -> Self {
            self.period_in_seconds = Some(input);
            self
        }
        /// <p>
        /// How long a profiling agent should send profiling data using
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
        /// <code>ConfigureAgent</code>
        /// </a>.
        /// For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
        /// <code>ConfigureAgent</code>
        /// </a>
        /// every 5 minutes to submit the profiled data collected during that period.
        /// </p>
        pub fn set_period_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.period_in_seconds = input;
            self
        }
        /// Adds a key-value pair to `agent_parameters`.
        ///
        /// To override the contents of this collection use [`set_agent_parameters`](Self::set_agent_parameters).
        ///
        /// <p>
        /// Parameters used by the profiler. The valid parameters are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MaxStackDepth</code> - The maximum depth of the stacks in the code that is represented in
        /// the profile. For example, if CodeGuru Profiler finds a method <code>A</code>,
        /// which calls method <code>B</code>, which calls method <code>C</code>, which
        /// calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
        /// set to 2, then the profiler evaluates <code>A</code> and <code>B</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MemoryUsageLimitPercent</code> - The percentage of memory that is used by the
        /// profiler.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MinimumTimeForReportingInMilliseconds</code> - The minimum time in milliseconds between
        /// sending reports.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReportingIntervalInMilliseconds</code> - The reporting interval in milliseconds used
        /// to report profiles.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SamplingIntervalInMilliseconds</code> - The sampling interval in milliseconds that is used to
        /// profile samples.
        /// </p>
        /// </li>
        /// </ul>
        pub fn agent_parameters(
            mut self,
            k: impl Into<crate::model::AgentParameterField>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.agent_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.agent_parameters = Some(hash_map);
            self
        }
        /// <p>
        /// Parameters used by the profiler. The valid parameters are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MaxStackDepth</code> - The maximum depth of the stacks in the code that is represented in
        /// the profile. For example, if CodeGuru Profiler finds a method <code>A</code>,
        /// which calls method <code>B</code>, which calls method <code>C</code>, which
        /// calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
        /// set to 2, then the profiler evaluates <code>A</code> and <code>B</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MemoryUsageLimitPercent</code> - The percentage of memory that is used by the
        /// profiler.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MinimumTimeForReportingInMilliseconds</code> - The minimum time in milliseconds between
        /// sending reports.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReportingIntervalInMilliseconds</code> - The reporting interval in milliseconds used
        /// to report profiles.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SamplingIntervalInMilliseconds</code> - The sampling interval in milliseconds that is used to
        /// profile samples.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_agent_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AgentParameterField, std::string::String>,
            >,
        ) -> Self {
            self.agent_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentConfiguration`](crate::model::AgentConfiguration)
        pub fn build(self) -> crate::model::AgentConfiguration {
            crate::model::AgentConfiguration {
                should_profile: self.should_profile,
                period_in_seconds: self.period_in_seconds,
                agent_parameters: self.agent_parameters,
            }
        }
    }
}
impl AgentConfiguration {
    /// Creates a new builder-style object to manufacture [`AgentConfiguration`](crate::model::AgentConfiguration)
    pub fn builder() -> crate::model::agent_configuration::Builder {
        crate::model::agent_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentParameterField {
    /// Maximum stack depth to be captured by the CodeGuru Profiler.
    MaxStackDepth,
    /// Percentage of memory to be used by CodeGuru profiler. Minimum of 30MB is required for the agent.
    MemoryUsageLimitPercent,
    /// Minimum time in milliseconds between sending reports.
    MinimumTimeForReportingInMilliseconds,
    /// Reporting interval in milliseconds used to report profiles.
    ReportingIntervalInMilliseconds,
    /// Sampling interval in milliseconds used to sample profiles.
    SamplingIntervalInMilliseconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentParameterField {
    fn from(s: &str) -> Self {
        match s {
            "MaxStackDepth" => AgentParameterField::MaxStackDepth,
            "MemoryUsageLimitPercent" => AgentParameterField::MemoryUsageLimitPercent,
            "MinimumTimeForReportingInMilliseconds" => {
                AgentParameterField::MinimumTimeForReportingInMilliseconds
            }
            "ReportingIntervalInMilliseconds" => {
                AgentParameterField::ReportingIntervalInMilliseconds
            }
            "SamplingIntervalInMilliseconds" => AgentParameterField::SamplingIntervalInMilliseconds,
            other => AgentParameterField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentParameterField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentParameterField::from(s))
    }
}
impl AgentParameterField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentParameterField::MaxStackDepth => "MaxStackDepth",
            AgentParameterField::MemoryUsageLimitPercent => "MemoryUsageLimitPercent",
            AgentParameterField::MinimumTimeForReportingInMilliseconds => {
                "MinimumTimeForReportingInMilliseconds"
            }
            AgentParameterField::ReportingIntervalInMilliseconds => {
                "ReportingIntervalInMilliseconds"
            }
            AgentParameterField::SamplingIntervalInMilliseconds => "SamplingIntervalInMilliseconds",
            AgentParameterField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "MaxStackDepth",
            "MemoryUsageLimitPercent",
            "MinimumTimeForReportingInMilliseconds",
            "ReportingIntervalInMilliseconds",
            "SamplingIntervalInMilliseconds",
        ]
    }
}
impl AsRef<str> for AgentParameterField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetadataField {
    /// Unique identifier for the agent instance.
    AgentId,
    /// AWS requestId of the Lambda invocation.
    AwsRequestId,
    /// Compute platform on which agent is running.
    ComputePlatform,
    /// Execution environment on which Lambda function is running.
    ExecutionEnvironment,
    /// Function ARN that's used to invoke the Lambda function.
    LambdaFunctionArn,
    /// Memory allocated for the Lambda function.
    LambdaMemoryLimitInMb,
    /// Time in milliseconds for the previous Lambda invocation.
    LambdaPreviousExecutionTimeInMilliseconds,
    /// Time in milliseconds left before the execution times out.
    LambdaRemainingTimeInMilliseconds,
    /// Time in milliseconds between two invocations of the Lambda function.
    LambdaTimeGapBetweenInvokesInMilliseconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetadataField {
    fn from(s: &str) -> Self {
        match s {
            "AgentId" => MetadataField::AgentId,
            "AwsRequestId" => MetadataField::AwsRequestId,
            "ComputePlatform" => MetadataField::ComputePlatform,
            "ExecutionEnvironment" => MetadataField::ExecutionEnvironment,
            "LambdaFunctionArn" => MetadataField::LambdaFunctionArn,
            "LambdaMemoryLimitInMB" => MetadataField::LambdaMemoryLimitInMb,
            "LambdaPreviousExecutionTimeInMilliseconds" => {
                MetadataField::LambdaPreviousExecutionTimeInMilliseconds
            }
            "LambdaRemainingTimeInMilliseconds" => MetadataField::LambdaRemainingTimeInMilliseconds,
            "LambdaTimeGapBetweenInvokesInMilliseconds" => {
                MetadataField::LambdaTimeGapBetweenInvokesInMilliseconds
            }
            other => MetadataField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetadataField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetadataField::from(s))
    }
}
impl MetadataField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetadataField::AgentId => "AgentId",
            MetadataField::AwsRequestId => "AwsRequestId",
            MetadataField::ComputePlatform => "ComputePlatform",
            MetadataField::ExecutionEnvironment => "ExecutionEnvironment",
            MetadataField::LambdaFunctionArn => "LambdaFunctionArn",
            MetadataField::LambdaMemoryLimitInMb => "LambdaMemoryLimitInMB",
            MetadataField::LambdaPreviousExecutionTimeInMilliseconds => {
                "LambdaPreviousExecutionTimeInMilliseconds"
            }
            MetadataField::LambdaRemainingTimeInMilliseconds => "LambdaRemainingTimeInMilliseconds",
            MetadataField::LambdaTimeGapBetweenInvokesInMilliseconds => {
                "LambdaTimeGapBetweenInvokesInMilliseconds"
            }
            MetadataField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AgentId",
            "AwsRequestId",
            "ComputePlatform",
            "ExecutionEnvironment",
            "LambdaFunctionArn",
            "LambdaMemoryLimitInMB",
            "LambdaPreviousExecutionTimeInMilliseconds",
            "LambdaRemainingTimeInMilliseconds",
            "LambdaTimeGapBetweenInvokesInMilliseconds",
        ]
    }
}
impl AsRef<str> for MetadataField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about a frame metric and its values.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrameMetricDatum {
    /// <p>
    /// The frame name, metric type, and thread states. These are used
    /// to derive the value of the metric for the frame.</p>
    pub frame_metric: std::option::Option<crate::model::FrameMetric>,
    /// <p>
    /// A list of values that are associated with a frame metric.
    /// </p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
}
impl FrameMetricDatum {
    /// <p>
    /// The frame name, metric type, and thread states. These are used
    /// to derive the value of the metric for the frame.</p>
    pub fn frame_metric(&self) -> std::option::Option<&crate::model::FrameMetric> {
        self.frame_metric.as_ref()
    }
    /// <p>
    /// A list of values that are associated with a frame metric.
    /// </p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for FrameMetricDatum {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrameMetricDatum");
        formatter.field("frame_metric", &self.frame_metric);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`FrameMetricDatum`](crate::model::FrameMetricDatum)
pub mod frame_metric_datum {
    /// A builder for [`FrameMetricDatum`](crate::model::FrameMetricDatum)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frame_metric: std::option::Option<crate::model::FrameMetric>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// <p>
        /// The frame name, metric type, and thread states. These are used
        /// to derive the value of the metric for the frame.</p>
        pub fn frame_metric(mut self, input: crate::model::FrameMetric) -> Self {
            self.frame_metric = Some(input);
            self
        }
        /// <p>
        /// The frame name, metric type, and thread states. These are used
        /// to derive the value of the metric for the frame.</p>
        pub fn set_frame_metric(
            mut self,
            input: std::option::Option<crate::model::FrameMetric>,
        ) -> Self {
            self.frame_metric = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>
        /// A list of values that are associated with a frame metric.
        /// </p>
        pub fn values(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>
        /// A list of values that are associated with a frame metric.
        /// </p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`FrameMetricDatum`](crate::model::FrameMetricDatum)
        pub fn build(self) -> crate::model::FrameMetricDatum {
            crate::model::FrameMetricDatum {
                frame_metric: self.frame_metric,
                values: self.values,
            }
        }
    }
}
impl FrameMetricDatum {
    /// Creates a new builder-style object to manufacture [`FrameMetricDatum`](crate::model::FrameMetricDatum)
    pub fn builder() -> crate::model::frame_metric_datum::Builder {
        crate::model::frame_metric_datum::Builder::default()
    }
}

/// <p>
/// The frame name, metric type, and thread states. These are used
/// to derive the value of the metric for the frame.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrameMetric {
    /// <p> Name of the method common across the multiple occurrences of a frame in an application
    /// profile.</p>
    pub frame_name: std::option::Option<std::string::String>,
    /// <p> A type of aggregation that specifies how a metric for a frame is analyzed. The
    /// supported value <code>AggregatedRelativeTotalTime</code> is an aggregation of the metric
    /// value for one frame that is calculated across the occurrences of all frames in a profile. </p>
    pub r#type: std::option::Option<crate::model::MetricType>,
    /// <p>List of application runtime thread states used to get the counts for a frame a derive a metric value.</p>
    pub thread_states: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl FrameMetric {
    /// <p> Name of the method common across the multiple occurrences of a frame in an application
    /// profile.</p>
    pub fn frame_name(&self) -> std::option::Option<&str> {
        self.frame_name.as_deref()
    }
    /// <p> A type of aggregation that specifies how a metric for a frame is analyzed. The
    /// supported value <code>AggregatedRelativeTotalTime</code> is an aggregation of the metric
    /// value for one frame that is calculated across the occurrences of all frames in a profile. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MetricType> {
        self.r#type.as_ref()
    }
    /// <p>List of application runtime thread states used to get the counts for a frame a derive a metric value.</p>
    pub fn thread_states(&self) -> std::option::Option<&[std::string::String]> {
        self.thread_states.as_deref()
    }
}
impl std::fmt::Debug for FrameMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrameMetric");
        formatter.field("frame_name", &self.frame_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("thread_states", &self.thread_states);
        formatter.finish()
    }
}
/// See [`FrameMetric`](crate::model::FrameMetric)
pub mod frame_metric {
    /// A builder for [`FrameMetric`](crate::model::FrameMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frame_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::MetricType>,
        pub(crate) thread_states: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> Name of the method common across the multiple occurrences of a frame in an application
        /// profile.</p>
        pub fn frame_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.frame_name = Some(input.into());
            self
        }
        /// <p> Name of the method common across the multiple occurrences of a frame in an application
        /// profile.</p>
        pub fn set_frame_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.frame_name = input;
            self
        }
        /// <p> A type of aggregation that specifies how a metric for a frame is analyzed. The
        /// supported value <code>AggregatedRelativeTotalTime</code> is an aggregation of the metric
        /// value for one frame that is calculated across the occurrences of all frames in a profile. </p>
        pub fn r#type(mut self, input: crate::model::MetricType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> A type of aggregation that specifies how a metric for a frame is analyzed. The
        /// supported value <code>AggregatedRelativeTotalTime</code> is an aggregation of the metric
        /// value for one frame that is calculated across the occurrences of all frames in a profile. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::MetricType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `thread_states`.
        ///
        /// To override the contents of this collection use [`set_thread_states`](Self::set_thread_states).
        ///
        /// <p>List of application runtime thread states used to get the counts for a frame a derive a metric value.</p>
        pub fn thread_states(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.thread_states.unwrap_or_default();
            v.push(input.into());
            self.thread_states = Some(v);
            self
        }
        /// <p>List of application runtime thread states used to get the counts for a frame a derive a metric value.</p>
        pub fn set_thread_states(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.thread_states = input;
            self
        }
        /// Consumes the builder and constructs a [`FrameMetric`](crate::model::FrameMetric)
        pub fn build(self) -> crate::model::FrameMetric {
            crate::model::FrameMetric {
                frame_name: self.frame_name,
                r#type: self.r#type,
                thread_states: self.thread_states,
            }
        }
    }
}
impl FrameMetric {
    /// Creates a new builder-style object to manufacture [`FrameMetric`](crate::model::FrameMetric)
    pub fn builder() -> crate::model::frame_metric::Builder {
        crate::model::frame_metric::Builder::default()
    }
}

/// <p>
/// A data type that contains a <code>Timestamp</code> object. This is specified
/// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
/// millisecond past June 1, 2020 1:15:02 PM UTC.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestampStructure {
    /// <p>
    /// A <code>Timestamp</code>. This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub value: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimestampStructure {
    /// <p>
    /// A <code>Timestamp</code>. This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn value(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for TimestampStructure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestampStructure");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`TimestampStructure`](crate::model::TimestampStructure)
pub mod timestamp_structure {
    /// A builder for [`TimestampStructure`](crate::model::TimestampStructure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>
        /// A <code>Timestamp</code>. This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn value(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>
        /// A <code>Timestamp</code>. This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestampStructure`](crate::model::TimestampStructure)
        pub fn build(self) -> crate::model::TimestampStructure {
            crate::model::TimestampStructure { value: self.value }
        }
    }
}
impl TimestampStructure {
    /// Creates a new builder-style object to manufacture [`TimestampStructure`](crate::model::TimestampStructure)
    pub fn builder() -> crate::model::timestamp_structure::Builder {
        crate::model::timestamp_structure::Builder::default()
    }
}

/// <p>
/// Contains information about a profiling group.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProfilingGroupDescription {
    /// <p>The name of the profiling group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
    /// <code>AgentOrchestrationConfig</code>
    /// </a>
    /// object that indicates if the profiling group is enabled for profiled or not.
    /// </p>
    pub agent_orchestration_config: std::option::Option<crate::model::AgentOrchestrationConfig>,
    /// <p>The Amazon Resource Name (ARN) identifying the profiling group resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the profiling group was created. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The date and time when the profiling group was last updated. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
    /// <code>ProfilingStatus</code>
    /// </a> object
    /// that includes information about the last time a profile agent pinged back,
    /// the last time a profile was received, and the aggregation period and start time for the
    /// most recent aggregated profile.
    /// </p>
    pub profiling_status: std::option::Option<crate::model::ProfilingStatus>,
    /// <p>
    /// The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then
    /// the profiled application runs on AWS Lambda. If it is set to <code>Default</code>, then the
    /// profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance,
    /// an on-premises server, or a different platform. The default is <code>Default</code>.         
    /// </p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
    /// <p>
    /// A list of the tags that belong to this profiling group.
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ProfilingGroupDescription {
    /// <p>The name of the profiling group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
    /// <code>AgentOrchestrationConfig</code>
    /// </a>
    /// object that indicates if the profiling group is enabled for profiled or not.
    /// </p>
    pub fn agent_orchestration_config(
        &self,
    ) -> std::option::Option<&crate::model::AgentOrchestrationConfig> {
        self.agent_orchestration_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) identifying the profiling group resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the profiling group was created. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>
    /// The date and time when the profiling group was last updated. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
    /// <code>ProfilingStatus</code>
    /// </a> object
    /// that includes information about the last time a profile agent pinged back,
    /// the last time a profile was received, and the aggregation period and start time for the
    /// most recent aggregated profile.
    /// </p>
    pub fn profiling_status(&self) -> std::option::Option<&crate::model::ProfilingStatus> {
        self.profiling_status.as_ref()
    }
    /// <p>
    /// The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then
    /// the profiled application runs on AWS Lambda. If it is set to <code>Default</code>, then the
    /// profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance,
    /// an on-premises server, or a different platform. The default is <code>Default</code>.         
    /// </p>
    pub fn compute_platform(&self) -> std::option::Option<&crate::model::ComputePlatform> {
        self.compute_platform.as_ref()
    }
    /// <p>
    /// A list of the tags that belong to this profiling group.
    /// </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ProfilingGroupDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProfilingGroupDescription");
        formatter.field("name", &self.name);
        formatter.field(
            "agent_orchestration_config",
            &self.agent_orchestration_config,
        );
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("profiling_status", &self.profiling_status);
        formatter.field("compute_platform", &self.compute_platform);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ProfilingGroupDescription`](crate::model::ProfilingGroupDescription)
pub mod profiling_group_description {
    /// A builder for [`ProfilingGroupDescription`](crate::model::ProfilingGroupDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) agent_orchestration_config:
            std::option::Option<crate::model::AgentOrchestrationConfig>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) profiling_status: std::option::Option<crate::model::ProfilingStatus>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the profiling group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
        /// <code>AgentOrchestrationConfig</code>
        /// </a>
        /// object that indicates if the profiling group is enabled for profiled or not.
        /// </p>
        pub fn agent_orchestration_config(
            mut self,
            input: crate::model::AgentOrchestrationConfig,
        ) -> Self {
            self.agent_orchestration_config = Some(input);
            self
        }
        /// <p>
        /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
        /// <code>AgentOrchestrationConfig</code>
        /// </a>
        /// object that indicates if the profiling group is enabled for profiled or not.
        /// </p>
        pub fn set_agent_orchestration_config(
            mut self,
            input: std::option::Option<crate::model::AgentOrchestrationConfig>,
        ) -> Self {
            self.agent_orchestration_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the profiling group resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the profiling group resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the profiling group was created. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the profiling group was created. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>
        /// The date and time when the profiling group was last updated. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>
        /// The date and time when the profiling group was last updated. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
        /// <code>ProfilingStatus</code>
        /// </a> object
        /// that includes information about the last time a profile agent pinged back,
        /// the last time a profile was received, and the aggregation period and start time for the
        /// most recent aggregated profile.
        /// </p>
        pub fn profiling_status(mut self, input: crate::model::ProfilingStatus) -> Self {
            self.profiling_status = Some(input);
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
        /// <code>ProfilingStatus</code>
        /// </a> object
        /// that includes information about the last time a profile agent pinged back,
        /// the last time a profile was received, and the aggregation period and start time for the
        /// most recent aggregated profile.
        /// </p>
        pub fn set_profiling_status(
            mut self,
            input: std::option::Option<crate::model::ProfilingStatus>,
        ) -> Self {
            self.profiling_status = input;
            self
        }
        /// <p>
        /// The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then
        /// the profiled application runs on AWS Lambda. If it is set to <code>Default</code>, then the
        /// profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance,
        /// an on-premises server, or a different platform. The default is <code>Default</code>.         
        /// </p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p>
        /// The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then
        /// the profiled application runs on AWS Lambda. If it is set to <code>Default</code>, then the
        /// profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance,
        /// an on-premises server, or a different platform. The default is <code>Default</code>.         
        /// </p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// A list of the tags that belong to this profiling group.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>
        /// A list of the tags that belong to this profiling group.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ProfilingGroupDescription`](crate::model::ProfilingGroupDescription)
        pub fn build(self) -> crate::model::ProfilingGroupDescription {
            crate::model::ProfilingGroupDescription {
                name: self.name,
                agent_orchestration_config: self.agent_orchestration_config,
                arn: self.arn,
                created_at: self.created_at,
                updated_at: self.updated_at,
                profiling_status: self.profiling_status,
                compute_platform: self.compute_platform,
                tags: self.tags,
            }
        }
    }
}
impl ProfilingGroupDescription {
    /// Creates a new builder-style object to manufacture [`ProfilingGroupDescription`](crate::model::ProfilingGroupDescription)
    pub fn builder() -> crate::model::profiling_group_description::Builder {
        crate::model::profiling_group_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputePlatform {
    /// Compute platform meant to used for AWS Lambda.
    Awslambda,
    /// Compute platform meant to used for all usecases (like EC2, Fargate, physical servers etc.) but AWS Lambda.
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputePlatform {
    fn from(s: &str) -> Self {
        match s {
            "AWSLambda" => ComputePlatform::Awslambda,
            "Default" => ComputePlatform::Default,
            other => ComputePlatform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputePlatform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputePlatform::from(s))
    }
}
impl ComputePlatform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputePlatform::Awslambda => "AWSLambda",
            ComputePlatform::Default => "Default",
            ComputePlatform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWSLambda", "Default"]
    }
}
impl AsRef<str> for ComputePlatform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Profiling status includes information about the last time a profile agent pinged back,
/// the last time a profile was received, and the aggregation period and start time for the
/// most recent aggregated profile.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProfilingStatus {
    /// <p>The date and time when the most recent profile was received. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub latest_agent_profile_reported_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
    /// <code>AggregatedProfileTime</code>
    /// </a>
    /// object that contains the aggregation period and start time for an aggregated profile.
    /// </p>
    pub latest_aggregated_profile: std::option::Option<crate::model::AggregatedProfileTime>,
    /// <p>The date and time when the profiling agent most recently pinged back. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub latest_agent_orchestrated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl ProfilingStatus {
    /// <p>The date and time when the most recent profile was received. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub fn latest_agent_profile_reported_at(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_agent_profile_reported_at.as_ref()
    }
    /// <p>
    /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
    /// <code>AggregatedProfileTime</code>
    /// </a>
    /// object that contains the aggregation period and start time for an aggregated profile.
    /// </p>
    pub fn latest_aggregated_profile(
        &self,
    ) -> std::option::Option<&crate::model::AggregatedProfileTime> {
        self.latest_aggregated_profile.as_ref()
    }
    /// <p>The date and time when the profiling agent most recently pinged back. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    pub fn latest_agent_orchestrated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_agent_orchestrated_at.as_ref()
    }
}
impl std::fmt::Debug for ProfilingStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProfilingStatus");
        formatter.field(
            "latest_agent_profile_reported_at",
            &self.latest_agent_profile_reported_at,
        );
        formatter.field("latest_aggregated_profile", &self.latest_aggregated_profile);
        formatter.field(
            "latest_agent_orchestrated_at",
            &self.latest_agent_orchestrated_at,
        );
        formatter.finish()
    }
}
/// See [`ProfilingStatus`](crate::model::ProfilingStatus)
pub mod profiling_status {
    /// A builder for [`ProfilingStatus`](crate::model::ProfilingStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) latest_agent_profile_reported_at:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_aggregated_profile:
            std::option::Option<crate::model::AggregatedProfileTime>,
        pub(crate) latest_agent_orchestrated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time when the most recent profile was received. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn latest_agent_profile_reported_at(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.latest_agent_profile_reported_at = Some(input);
            self
        }
        /// <p>The date and time when the most recent profile was received. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn set_latest_agent_profile_reported_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_agent_profile_reported_at = input;
            self
        }
        /// <p>
        /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
        /// <code>AggregatedProfileTime</code>
        /// </a>
        /// object that contains the aggregation period and start time for an aggregated profile.
        /// </p>
        pub fn latest_aggregated_profile(
            mut self,
            input: crate::model::AggregatedProfileTime,
        ) -> Self {
            self.latest_aggregated_profile = Some(input);
            self
        }
        /// <p>
        /// An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
        /// <code>AggregatedProfileTime</code>
        /// </a>
        /// object that contains the aggregation period and start time for an aggregated profile.
        /// </p>
        pub fn set_latest_aggregated_profile(
            mut self,
            input: std::option::Option<crate::model::AggregatedProfileTime>,
        ) -> Self {
            self.latest_aggregated_profile = input;
            self
        }
        /// <p>The date and time when the profiling agent most recently pinged back. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn latest_agent_orchestrated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_agent_orchestrated_at = Some(input);
            self
        }
        /// <p>The date and time when the profiling agent most recently pinged back. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        pub fn set_latest_agent_orchestrated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_agent_orchestrated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ProfilingStatus`](crate::model::ProfilingStatus)
        pub fn build(self) -> crate::model::ProfilingStatus {
            crate::model::ProfilingStatus {
                latest_agent_profile_reported_at: self.latest_agent_profile_reported_at,
                latest_aggregated_profile: self.latest_aggregated_profile,
                latest_agent_orchestrated_at: self.latest_agent_orchestrated_at,
            }
        }
    }
}
impl ProfilingStatus {
    /// Creates a new builder-style object to manufacture [`ProfilingStatus`](crate::model::ProfilingStatus)
    pub fn builder() -> crate::model::profiling_status::Builder {
        crate::model::profiling_status::Builder::default()
    }
}

/// <p>
/// Specifies the aggregation period and aggregation start time for
/// an aggregated profile. An aggregated profile is used to collect posted agent profiles
/// during an aggregation period. There are three possible aggregation periods (1 day,
/// 1 hour, or 5 minutes).
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregatedProfileTime {
    /// <p>
    /// The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile
    /// contains profiles posted by the agent starting at this time for an aggregation period  
    /// specified by the <code>period</code> property of the <code>AggregatedProfileTime</code>
    /// object.
    /// </p>
    /// <p>
    /// Specify <code>start</code> using the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub start: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The aggregation period. This indicates the period during which an aggregation profile
    /// collects posted agent profiles for a profiling group. Use one of three valid
    /// durations that are specified using the ISO 8601 format.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>P1D</code> — 1 day
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT1H</code> — 1 hour
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT5M</code> — 5 minutes
    /// </p>
    /// </li>
    /// </ul>
    pub period: std::option::Option<crate::model::AggregationPeriod>,
}
impl AggregatedProfileTime {
    /// <p>
    /// The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile
    /// contains profiles posted by the agent starting at this time for an aggregation period  
    /// specified by the <code>period</code> property of the <code>AggregatedProfileTime</code>
    /// object.
    /// </p>
    /// <p>
    /// Specify <code>start</code> using the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub fn start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start.as_ref()
    }
    /// <p>
    /// The aggregation period. This indicates the period during which an aggregation profile
    /// collects posted agent profiles for a profiling group. Use one of three valid
    /// durations that are specified using the ISO 8601 format.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>P1D</code> — 1 day
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT1H</code> — 1 hour
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT5M</code> — 5 minutes
    /// </p>
    /// </li>
    /// </ul>
    pub fn period(&self) -> std::option::Option<&crate::model::AggregationPeriod> {
        self.period.as_ref()
    }
}
impl std::fmt::Debug for AggregatedProfileTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregatedProfileTime");
        formatter.field("start", &self.start);
        formatter.field("period", &self.period);
        formatter.finish()
    }
}
/// See [`AggregatedProfileTime`](crate::model::AggregatedProfileTime)
pub mod aggregated_profile_time {
    /// A builder for [`AggregatedProfileTime`](crate::model::AggregatedProfileTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) period: std::option::Option<crate::model::AggregationPeriod>,
    }
    impl Builder {
        /// <p>
        /// The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile
        /// contains profiles posted by the agent starting at this time for an aggregation period  
        /// specified by the <code>period</code> property of the <code>AggregatedProfileTime</code>
        /// object.
        /// </p>
        /// <p>
        /// Specify <code>start</code> using the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>
        /// The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile
        /// contains profiles posted by the agent starting at this time for an aggregation period  
        /// specified by the <code>period</code> property of the <code>AggregatedProfileTime</code>
        /// object.
        /// </p>
        /// <p>
        /// Specify <code>start</code> using the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.start = input;
            self
        }
        /// <p>
        /// The aggregation period. This indicates the period during which an aggregation profile
        /// collects posted agent profiles for a profiling group. Use one of three valid
        /// durations that are specified using the ISO 8601 format.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn period(mut self, input: crate::model::AggregationPeriod) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>
        /// The aggregation period. This indicates the period during which an aggregation profile
        /// collects posted agent profiles for a profiling group. Use one of three valid
        /// durations that are specified using the ISO 8601 format.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::AggregationPeriod>,
        ) -> Self {
            self.period = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregatedProfileTime`](crate::model::AggregatedProfileTime)
        pub fn build(self) -> crate::model::AggregatedProfileTime {
            crate::model::AggregatedProfileTime {
                start: self.start,
                period: self.period,
            }
        }
    }
}
impl AggregatedProfileTime {
    /// Creates a new builder-style object to manufacture [`AggregatedProfileTime`](crate::model::AggregatedProfileTime)
    pub fn builder() -> crate::model::aggregated_profile_time::Builder {
        crate::model::aggregated_profile_time::Builder::default()
    }
}

/// <p>
/// Specifies whether profiling is enabled or disabled for a profiling group. It
/// is used by <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
/// <code>ConfigureAgent</code>
/// </a>
/// to enable or disable profiling for a profiling group.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentOrchestrationConfig {
    /// <p>
    /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
    /// to enable profiling.
    /// </p>
    pub profiling_enabled: std::option::Option<bool>,
}
impl AgentOrchestrationConfig {
    /// <p>
    /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
    /// to enable profiling.
    /// </p>
    pub fn profiling_enabled(&self) -> std::option::Option<bool> {
        self.profiling_enabled
    }
}
impl std::fmt::Debug for AgentOrchestrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentOrchestrationConfig");
        formatter.field("profiling_enabled", &self.profiling_enabled);
        formatter.finish()
    }
}
/// See [`AgentOrchestrationConfig`](crate::model::AgentOrchestrationConfig)
pub mod agent_orchestration_config {
    /// A builder for [`AgentOrchestrationConfig`](crate::model::AgentOrchestrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>
        /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
        /// to enable profiling.
        /// </p>
        pub fn profiling_enabled(mut self, input: bool) -> Self {
            self.profiling_enabled = Some(input);
            self
        }
        /// <p>
        /// A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code>
        /// to enable profiling.
        /// </p>
        pub fn set_profiling_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.profiling_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentOrchestrationConfig`](crate::model::AgentOrchestrationConfig)
        pub fn build(self) -> crate::model::AgentOrchestrationConfig {
            crate::model::AgentOrchestrationConfig {
                profiling_enabled: self.profiling_enabled,
            }
        }
    }
}
impl AgentOrchestrationConfig {
    /// Creates a new builder-style object to manufacture [`AgentOrchestrationConfig`](crate::model::AgentOrchestrationConfig)
    pub fn builder() -> crate::model::agent_orchestration_config::Builder {
        crate::model::agent_orchestration_config::Builder::default()
    }
}
