// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddNotificationChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddNotificationChannelsError {
    /// Kind of error that occurred.
    pub kind: AddNotificationChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddNotificationChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddNotificationChannelsErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a> to request a service quota increase. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddNotificationChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddNotificationChannelsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AddNotificationChannelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AddNotificationChannelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddNotificationChannelsErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AddNotificationChannelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AddNotificationChannelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AddNotificationChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddNotificationChannelsError {
    fn code(&self) -> Option<&str> {
        AddNotificationChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            AddNotificationChannelsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            AddNotificationChannelsErrorKind::ServiceQuotaExceededException(inner) => {
                Some(inner.retryable_error_kind())
            }
            AddNotificationChannelsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl AddNotificationChannelsError {
    /// Creates a new `AddNotificationChannelsError`.
    pub fn new(kind: AddNotificationChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddNotificationChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddNotificationChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddNotificationChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddNotificationChannelsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddNotificationChannelsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AddNotificationChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddNotificationChannelsErrorKind::ConflictException(_inner) => Some(_inner),
            AddNotificationChannelsErrorKind::InternalServerException(_inner) => Some(_inner),
            AddNotificationChannelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddNotificationChannelsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AddNotificationChannelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AddNotificationChannelsErrorKind::ValidationException(_inner) => Some(_inner),
            AddNotificationChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetFrameMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetFrameMetricDataError {
    /// Kind of error that occurred.
    pub kind: BatchGetFrameMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetFrameMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetFrameMetricDataErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetFrameMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetFrameMetricDataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchGetFrameMetricDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchGetFrameMetricDataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchGetFrameMetricDataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetFrameMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetFrameMetricDataError {
    fn code(&self) -> Option<&str> {
        BatchGetFrameMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            BatchGetFrameMetricDataErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            BatchGetFrameMetricDataErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl BatchGetFrameMetricDataError {
    /// Creates a new `BatchGetFrameMetricDataError`.
    pub fn new(kind: BatchGetFrameMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetFrameMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetFrameMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetFrameMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetFrameMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetFrameMetricDataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFrameMetricDataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetFrameMetricDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFrameMetricDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetFrameMetricDataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFrameMetricDataErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetFrameMetricDataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFrameMetricDataErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetFrameMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetFrameMetricDataErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetFrameMetricDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchGetFrameMetricDataErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchGetFrameMetricDataErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetFrameMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfigureAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfigureAgentError {
    /// Kind of error that occurred.
    pub kind: ConfigureAgentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfigureAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfigureAgentErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfigureAgentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfigureAgentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ConfigureAgentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ConfigureAgentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ConfigureAgentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ConfigureAgentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfigureAgentError {
    fn code(&self) -> Option<&str> {
        ConfigureAgentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ConfigureAgentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ConfigureAgentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ConfigureAgentError {
    /// Creates a new `ConfigureAgentError`.
    pub fn new(kind: ConfigureAgentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfigureAgentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfigureAgentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfigureAgentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfigureAgentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConfigureAgentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfigureAgentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfigureAgentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfigureAgentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfigureAgentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ConfigureAgentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ConfigureAgentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ConfigureAgentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ConfigureAgentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfigureAgentErrorKind::InternalServerException(_inner) => Some(_inner),
            ConfigureAgentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ConfigureAgentErrorKind::ThrottlingException(_inner) => Some(_inner),
            ConfigureAgentErrorKind::ValidationException(_inner) => Some(_inner),
            ConfigureAgentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProfilingGroupError {
    /// Kind of error that occurred.
    pub kind: CreateProfilingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProfilingGroupErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a> to request a service quota increase. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProfilingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProfilingGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateProfilingGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateProfilingGroupErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateProfilingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProfilingGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateProfilingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProfilingGroupError {
    fn code(&self) -> Option<&str> {
        CreateProfilingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateProfilingGroupErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateProfilingGroupErrorKind::ServiceQuotaExceededException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateProfilingGroupErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateProfilingGroupError {
    /// Creates a new `CreateProfilingGroupError`.
    pub fn new(kind: CreateProfilingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProfilingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProfilingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProfilingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProfilingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProfilingGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfilingGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProfilingGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfilingGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProfilingGroupErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfilingGroupErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProfilingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfilingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProfilingGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfilingGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateProfilingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProfilingGroupErrorKind::ConflictException(_inner) => Some(_inner),
            CreateProfilingGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateProfilingGroupErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateProfilingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProfilingGroupErrorKind::ValidationException(_inner) => Some(_inner),
            CreateProfilingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProfilingGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteProfilingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProfilingGroupErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProfilingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProfilingGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteProfilingGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteProfilingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProfilingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProfilingGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteProfilingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProfilingGroupError {
    fn code(&self) -> Option<&str> {
        DeleteProfilingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteProfilingGroupErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteProfilingGroupErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteProfilingGroupError {
    /// Creates a new `DeleteProfilingGroupError`.
    pub fn new(kind: DeleteProfilingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProfilingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProfilingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProfilingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProfilingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProfilingGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfilingGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProfilingGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfilingGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProfilingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfilingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProfilingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfilingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProfilingGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfilingGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteProfilingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProfilingGroupErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteProfilingGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteProfilingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProfilingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProfilingGroupErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteProfilingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProfilingGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeProfilingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProfilingGroupErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProfilingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProfilingGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeProfilingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProfilingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeProfilingGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeProfilingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProfilingGroupError {
    fn code(&self) -> Option<&str> {
        DescribeProfilingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeProfilingGroupErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeProfilingGroupErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeProfilingGroupError {
    /// Creates a new `DescribeProfilingGroupError`.
    pub fn new(kind: DescribeProfilingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProfilingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProfilingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProfilingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProfilingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProfilingGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProfilingGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProfilingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProfilingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProfilingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProfilingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProfilingGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProfilingGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeProfilingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProfilingGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeProfilingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProfilingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeProfilingGroupErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeProfilingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFindingsReportAccountSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingsReportAccountSummaryError {
    /// Kind of error that occurred.
    pub kind: GetFindingsReportAccountSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindingsReportAccountSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingsReportAccountSummaryErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingsReportAccountSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingsReportAccountSummaryErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsReportAccountSummaryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetFindingsReportAccountSummaryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFindingsReportAccountSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingsReportAccountSummaryError {
    fn code(&self) -> Option<&str> {
        GetFindingsReportAccountSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetFindingsReportAccountSummaryErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetFindingsReportAccountSummaryErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetFindingsReportAccountSummaryError {
    /// Creates a new `GetFindingsReportAccountSummaryError`.
    pub fn new(
        kind: GetFindingsReportAccountSummaryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingsReportAccountSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingsReportAccountSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingsReportAccountSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingsReportAccountSummaryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingsReportAccountSummaryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportAccountSummaryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsReportAccountSummaryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportAccountSummaryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsReportAccountSummaryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportAccountSummaryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetFindingsReportAccountSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingsReportAccountSummaryErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetFindingsReportAccountSummaryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetFindingsReportAccountSummaryErrorKind::ValidationException(_inner) => Some(_inner),
            GetFindingsReportAccountSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNotificationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNotificationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetNotificationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNotificationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNotificationConfigurationErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNotificationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNotificationConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetNotificationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetNotificationConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNotificationConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNotificationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNotificationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetNotificationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetNotificationConfigurationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetNotificationConfigurationErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetNotificationConfigurationError {
    /// Creates a new `GetNotificationConfigurationError`.
    pub fn new(kind: GetNotificationConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNotificationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNotificationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNotificationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNotificationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNotificationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNotificationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNotificationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNotificationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNotificationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNotificationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNotificationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNotificationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNotificationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNotificationConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetNotificationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetNotificationConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNotificationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            GetNotificationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyError {
    fn code(&self) -> Option<&str> {
        GetPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetPolicyErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetPolicyErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl GetPolicyError {
    /// Creates a new `GetPolicyError`.
    pub fn new(kind: GetPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProfileError {
    /// Kind of error that occurred.
    pub kind: GetProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProfileErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProfileError {
    fn code(&self) -> Option<&str> {
        GetProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetProfileErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetProfileErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl GetProfileError {
    /// Creates a new `GetProfileError`.
    pub fn new(kind: GetProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetProfileErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetProfileErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetProfileErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            GetProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetProfileErrorKind::ValidationException(_inner) => Some(_inner),
            GetProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecommendations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecommendationsError {
    /// Kind of error that occurred.
    pub kind: GetRecommendationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecommendations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecommendationsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecommendationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecommendationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRecommendationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRecommendationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRecommendationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRecommendationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecommendationsError {
    fn code(&self) -> Option<&str> {
        GetRecommendationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetRecommendationsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetRecommendationsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetRecommendationsError {
    /// Creates a new `GetRecommendationsError`.
    pub fn new(kind: GetRecommendationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecommendationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecommendationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecommendationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecommendationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecommendationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommendationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommendationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommendationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRecommendationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecommendationsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRecommendationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRecommendationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRecommendationsErrorKind::ValidationException(_inner) => Some(_inner),
            GetRecommendationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFindingsReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFindingsReportsError {
    /// Kind of error that occurred.
    pub kind: ListFindingsReportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFindingsReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFindingsReportsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFindingsReportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFindingsReportsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFindingsReportsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFindingsReportsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFindingsReportsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFindingsReportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFindingsReportsError {
    fn code(&self) -> Option<&str> {
        ListFindingsReportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListFindingsReportsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListFindingsReportsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListFindingsReportsError {
    /// Creates a new `ListFindingsReportsError`.
    pub fn new(kind: ListFindingsReportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFindingsReportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFindingsReportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFindingsReportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFindingsReportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFindingsReportsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsReportsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsReportsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsReportsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsReportsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsReportsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsReportsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsReportsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFindingsReportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFindingsReportsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFindingsReportsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFindingsReportsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFindingsReportsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFindingsReportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProfileTimes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProfileTimesError {
    /// Kind of error that occurred.
    pub kind: ListProfileTimesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProfileTimes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProfileTimesErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProfileTimesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProfileTimesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListProfileTimesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProfileTimesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProfileTimesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListProfileTimesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProfileTimesError {
    fn code(&self) -> Option<&str> {
        ListProfileTimesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListProfileTimesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListProfileTimesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListProfileTimesError {
    /// Creates a new `ListProfileTimesError`.
    pub fn new(kind: ListProfileTimesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProfileTimesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProfileTimesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProfileTimesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProfileTimesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProfileTimesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileTimesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProfileTimesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileTimesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProfileTimesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileTimesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProfileTimesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileTimesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListProfileTimesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProfileTimesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListProfileTimesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProfileTimesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProfileTimesErrorKind::ValidationException(_inner) => Some(_inner),
            ListProfileTimesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProfilingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProfilingGroupsError {
    /// Kind of error that occurred.
    pub kind: ListProfilingGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProfilingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProfilingGroupsErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProfilingGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProfilingGroupsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListProfilingGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProfilingGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProfilingGroupsError {
    fn code(&self) -> Option<&str> {
        ListProfilingGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListProfilingGroupsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListProfilingGroupsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListProfilingGroupsError {
    /// Creates a new `ListProfilingGroupsError`.
    pub fn new(kind: ListProfilingGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProfilingGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProfilingGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProfilingGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProfilingGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProfilingGroupsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfilingGroupsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProfilingGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfilingGroupsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListProfilingGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProfilingGroupsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListProfilingGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProfilingGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PostAgentProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PostAgentProfileError {
    /// Kind of error that occurred.
    pub kind: PostAgentProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PostAgentProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PostAgentProfileErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PostAgentProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PostAgentProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PostAgentProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PostAgentProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PostAgentProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PostAgentProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PostAgentProfileError {
    fn code(&self) -> Option<&str> {
        PostAgentProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            PostAgentProfileErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            PostAgentProfileErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl PostAgentProfileError {
    /// Creates a new `PostAgentProfileError`.
    pub fn new(kind: PostAgentProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PostAgentProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PostAgentProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PostAgentProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PostAgentProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PostAgentProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostAgentProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PostAgentProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostAgentProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PostAgentProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostAgentProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PostAgentProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostAgentProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PostAgentProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PostAgentProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            PostAgentProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PostAgentProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            PostAgentProfileErrorKind::ValidationException(_inner) => Some(_inner),
            PostAgentProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPermissionError {
    /// Kind of error that occurred.
    pub kind: PutPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPermissionErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPermissionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPermissionError {
    fn code(&self) -> Option<&str> {
        PutPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            PutPermissionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            PutPermissionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl PutPermissionError {
    /// Creates a new `PutPermissionError`.
    pub fn new(kind: PutPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutPermissionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutPermissionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutPermissionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPermissionErrorKind::ConflictException(_inner) => Some(_inner),
            PutPermissionErrorKind::InternalServerException(_inner) => Some(_inner),
            PutPermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutPermissionErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutPermissionErrorKind::ValidationException(_inner) => Some(_inner),
            PutPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveNotificationChannelError {
    /// Kind of error that occurred.
    pub kind: RemoveNotificationChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveNotificationChannelErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveNotificationChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveNotificationChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveNotificationChannelError {
    fn code(&self) -> Option<&str> {
        RemoveNotificationChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            RemoveNotificationChannelErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            RemoveNotificationChannelErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl RemoveNotificationChannelError {
    /// Creates a new `RemoveNotificationChannelError`.
    pub fn new(kind: RemoveNotificationChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveNotificationChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveNotificationChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveNotificationChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveNotificationChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RemoveNotificationChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveNotificationChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::ValidationException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemovePermissionError {
    /// Kind of error that occurred.
    pub kind: RemovePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemovePermissionErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemovePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemovePermissionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemovePermissionError {
    fn code(&self) -> Option<&str> {
        RemovePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            RemovePermissionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            RemovePermissionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl RemovePermissionError {
    /// Creates a new `RemovePermissionError`.
    pub fn new(kind: RemovePermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, RemovePermissionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RemovePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemovePermissionErrorKind::ConflictException(_inner) => Some(_inner),
            RemovePermissionErrorKind::InternalServerException(_inner) => Some(_inner),
            RemovePermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemovePermissionErrorKind::ThrottlingException(_inner) => Some(_inner),
            RemovePermissionErrorKind::ValidationException(_inner) => Some(_inner),
            RemovePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SubmitFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubmitFeedbackError {
    /// Kind of error that occurred.
    pub kind: SubmitFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SubmitFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubmitFeedbackErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubmitFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubmitFeedbackErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubmitFeedbackError {
    fn code(&self) -> Option<&str> {
        SubmitFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            SubmitFeedbackErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            SubmitFeedbackErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl SubmitFeedbackError {
    /// Creates a new `SubmitFeedbackError`.
    pub fn new(kind: SubmitFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubmitFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubmitFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubmitFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubmitFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitFeedbackErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SubmitFeedbackErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, SubmitFeedbackErrorKind::ValidationException(_))
    }
}
impl std::error::Error for SubmitFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubmitFeedbackErrorKind::InternalServerException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::ThrottlingException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::ValidationException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProfilingGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateProfilingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProfilingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProfilingGroupErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The server encountered an internal error and is unable to complete the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The parameter is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProfilingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProfilingGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateProfilingGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateProfilingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProfilingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateProfilingGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateProfilingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProfilingGroupError {
    fn code(&self) -> Option<&str> {
        UpdateProfilingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateProfilingGroupErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateProfilingGroupErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateProfilingGroupError {
    /// Creates a new `UpdateProfilingGroupError`.
    pub fn new(kind: UpdateProfilingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProfilingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProfilingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProfilingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProfilingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateProfilingGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfilingGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProfilingGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfilingGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProfilingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfilingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProfilingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfilingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProfilingGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfilingGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateProfilingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProfilingGroupErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateProfilingGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateProfilingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProfilingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateProfilingGroupErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateProfilingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The parameter is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ClientError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource specified in the request does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The server encountered an internal error and is unable to complete the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a> to request a service quota increase. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ClientError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
