// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddNotificationChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_notification_channels`](crate::client::Client::add_notification_channels).
///
/// See [`crate::client::fluent_builders::AddNotificationChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddNotificationChannels {
    _private: (),
}
impl AddNotificationChannels {
    /// Creates a new builder-style object to manufacture [`AddNotificationChannelsInput`](crate::input::AddNotificationChannelsInput)
    pub fn builder() -> crate::input::add_notification_channels_input::Builder {
        crate::input::add_notification_channels_input::Builder::default()
    }
    /// Creates a new `AddNotificationChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddNotificationChannels {
    type Output = std::result::Result<
        crate::output::AddNotificationChannelsOutput,
        crate::error::AddNotificationChannelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_notification_channels_error(response)
        } else {
            crate::operation_deser::parse_add_notification_channels_response(response)
        }
    }
}

/// Operation shape for `BatchGetFrameMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_frame_metric_data`](crate::client::Client::batch_get_frame_metric_data).
///
/// See [`crate::client::fluent_builders::BatchGetFrameMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetFrameMetricData {
    _private: (),
}
impl BatchGetFrameMetricData {
    /// Creates a new builder-style object to manufacture [`BatchGetFrameMetricDataInput`](crate::input::BatchGetFrameMetricDataInput)
    pub fn builder() -> crate::input::batch_get_frame_metric_data_input::Builder {
        crate::input::batch_get_frame_metric_data_input::Builder::default()
    }
    /// Creates a new `BatchGetFrameMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetFrameMetricData {
    type Output = std::result::Result<
        crate::output::BatchGetFrameMetricDataOutput,
        crate::error::BatchGetFrameMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_frame_metric_data_error(response)
        } else {
            crate::operation_deser::parse_batch_get_frame_metric_data_response(response)
        }
    }
}

/// Operation shape for `ConfigureAgent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`configure_agent`](crate::client::Client::configure_agent).
///
/// See [`crate::client::fluent_builders::ConfigureAgent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfigureAgent {
    _private: (),
}
impl ConfigureAgent {
    /// Creates a new builder-style object to manufacture [`ConfigureAgentInput`](crate::input::ConfigureAgentInput)
    pub fn builder() -> crate::input::configure_agent_input::Builder {
        crate::input::configure_agent_input::Builder::default()
    }
    /// Creates a new `ConfigureAgent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfigureAgent {
    type Output =
        std::result::Result<crate::output::ConfigureAgentOutput, crate::error::ConfigureAgentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_configure_agent_error(response)
        } else {
            crate::operation_deser::parse_configure_agent_response(response)
        }
    }
}

/// Operation shape for `CreateProfilingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_profiling_group`](crate::client::Client::create_profiling_group).
///
/// See [`crate::client::fluent_builders::CreateProfilingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProfilingGroup {
    _private: (),
}
impl CreateProfilingGroup {
    /// Creates a new builder-style object to manufacture [`CreateProfilingGroupInput`](crate::input::CreateProfilingGroupInput)
    pub fn builder() -> crate::input::create_profiling_group_input::Builder {
        crate::input::create_profiling_group_input::Builder::default()
    }
    /// Creates a new `CreateProfilingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProfilingGroup {
    type Output = std::result::Result<
        crate::output::CreateProfilingGroupOutput,
        crate::error::CreateProfilingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_profiling_group_error(response)
        } else {
            crate::operation_deser::parse_create_profiling_group_response(response)
        }
    }
}

/// Operation shape for `DeleteProfilingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_profiling_group`](crate::client::Client::delete_profiling_group).
///
/// See [`crate::client::fluent_builders::DeleteProfilingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProfilingGroup {
    _private: (),
}
impl DeleteProfilingGroup {
    /// Creates a new builder-style object to manufacture [`DeleteProfilingGroupInput`](crate::input::DeleteProfilingGroupInput)
    pub fn builder() -> crate::input::delete_profiling_group_input::Builder {
        crate::input::delete_profiling_group_input::Builder::default()
    }
    /// Creates a new `DeleteProfilingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProfilingGroup {
    type Output = std::result::Result<
        crate::output::DeleteProfilingGroupOutput,
        crate::error::DeleteProfilingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_profiling_group_error(response)
        } else {
            crate::operation_deser::parse_delete_profiling_group_response(response)
        }
    }
}

/// Operation shape for `DescribeProfilingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_profiling_group`](crate::client::Client::describe_profiling_group).
///
/// See [`crate::client::fluent_builders::DescribeProfilingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProfilingGroup {
    _private: (),
}
impl DescribeProfilingGroup {
    /// Creates a new builder-style object to manufacture [`DescribeProfilingGroupInput`](crate::input::DescribeProfilingGroupInput)
    pub fn builder() -> crate::input::describe_profiling_group_input::Builder {
        crate::input::describe_profiling_group_input::Builder::default()
    }
    /// Creates a new `DescribeProfilingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProfilingGroup {
    type Output = std::result::Result<
        crate::output::DescribeProfilingGroupOutput,
        crate::error::DescribeProfilingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_profiling_group_error(response)
        } else {
            crate::operation_deser::parse_describe_profiling_group_response(response)
        }
    }
}

/// Operation shape for `GetFindingsReportAccountSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings_report_account_summary`](crate::client::Client::get_findings_report_account_summary).
///
/// See [`crate::client::fluent_builders::GetFindingsReportAccountSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindingsReportAccountSummary {
    _private: (),
}
impl GetFindingsReportAccountSummary {
    /// Creates a new builder-style object to manufacture [`GetFindingsReportAccountSummaryInput`](crate::input::GetFindingsReportAccountSummaryInput)
    pub fn builder() -> crate::input::get_findings_report_account_summary_input::Builder {
        crate::input::get_findings_report_account_summary_input::Builder::default()
    }
    /// Creates a new `GetFindingsReportAccountSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindingsReportAccountSummary {
    type Output = std::result::Result<
        crate::output::GetFindingsReportAccountSummaryOutput,
        crate::error::GetFindingsReportAccountSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_report_account_summary_error(response)
        } else {
            crate::operation_deser::parse_get_findings_report_account_summary_response(response)
        }
    }
}

/// Operation shape for `GetNotificationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_notification_configuration`](crate::client::Client::get_notification_configuration).
///
/// See [`crate::client::fluent_builders::GetNotificationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNotificationConfiguration {
    _private: (),
}
impl GetNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetNotificationConfigurationInput`](crate::input::GetNotificationConfigurationInput)
    pub fn builder() -> crate::input::get_notification_configuration_input::Builder {
        crate::input::get_notification_configuration_input::Builder::default()
    }
    /// Creates a new `GetNotificationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNotificationConfiguration {
    type Output = std::result::Result<
        crate::output::GetNotificationConfigurationOutput,
        crate::error::GetNotificationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_notification_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_notification_configuration_response(response)
        }
    }
}

/// Operation shape for `GetPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_policy`](crate::client::Client::get_policy).
///
/// See [`crate::client::fluent_builders::GetPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPolicy {
    _private: (),
}
impl GetPolicy {
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
    /// Creates a new `GetPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPolicy {
    type Output = std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_policy_error(response)
        } else {
            crate::operation_deser::parse_get_policy_response(response)
        }
    }
}

/// Operation shape for `GetProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_profile`](crate::client::Client::get_profile).
///
/// See [`crate::client::fluent_builders::GetProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProfile {
    _private: (),
}
impl GetProfile {
    /// Creates a new builder-style object to manufacture [`GetProfileInput`](crate::input::GetProfileInput)
    pub fn builder() -> crate::input::get_profile_input::Builder {
        crate::input::get_profile_input::Builder::default()
    }
    /// Creates a new `GetProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProfile {
    type Output =
        std::result::Result<crate::output::GetProfileOutput, crate::error::GetProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_profile_error(response)
        } else {
            crate::operation_deser::parse_get_profile_response(response)
        }
    }
}

/// Operation shape for `GetRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_recommendations`](crate::client::Client::get_recommendations).
///
/// See [`crate::client::fluent_builders::GetRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecommendations {
    _private: (),
}
impl GetRecommendations {
    /// Creates a new builder-style object to manufacture [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
    pub fn builder() -> crate::input::get_recommendations_input::Builder {
        crate::input::get_recommendations_input::Builder::default()
    }
    /// Creates a new `GetRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecommendations {
    type Output = std::result::Result<
        crate::output::GetRecommendationsOutput,
        crate::error::GetRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_recommendations_error(response)
        } else {
            crate::operation_deser::parse_get_recommendations_response(response)
        }
    }
}

/// Operation shape for `ListFindingsReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_findings_reports`](crate::client::Client::list_findings_reports).
///
/// See [`crate::client::fluent_builders::ListFindingsReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindingsReports {
    _private: (),
}
impl ListFindingsReports {
    /// Creates a new builder-style object to manufacture [`ListFindingsReportsInput`](crate::input::ListFindingsReportsInput)
    pub fn builder() -> crate::input::list_findings_reports_input::Builder {
        crate::input::list_findings_reports_input::Builder::default()
    }
    /// Creates a new `ListFindingsReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindingsReports {
    type Output = std::result::Result<
        crate::output::ListFindingsReportsOutput,
        crate::error::ListFindingsReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_findings_reports_error(response)
        } else {
            crate::operation_deser::parse_list_findings_reports_response(response)
        }
    }
}

/// Operation shape for `ListProfileTimes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_profile_times`](crate::client::Client::list_profile_times).
///
/// See [`crate::client::fluent_builders::ListProfileTimes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProfileTimes {
    _private: (),
}
impl ListProfileTimes {
    /// Creates a new builder-style object to manufacture [`ListProfileTimesInput`](crate::input::ListProfileTimesInput)
    pub fn builder() -> crate::input::list_profile_times_input::Builder {
        crate::input::list_profile_times_input::Builder::default()
    }
    /// Creates a new `ListProfileTimes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProfileTimes {
    type Output = std::result::Result<
        crate::output::ListProfileTimesOutput,
        crate::error::ListProfileTimesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_profile_times_error(response)
        } else {
            crate::operation_deser::parse_list_profile_times_response(response)
        }
    }
}

/// Operation shape for `ListProfilingGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_profiling_groups`](crate::client::Client::list_profiling_groups).
///
/// See [`crate::client::fluent_builders::ListProfilingGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProfilingGroups {
    _private: (),
}
impl ListProfilingGroups {
    /// Creates a new builder-style object to manufacture [`ListProfilingGroupsInput`](crate::input::ListProfilingGroupsInput)
    pub fn builder() -> crate::input::list_profiling_groups_input::Builder {
        crate::input::list_profiling_groups_input::Builder::default()
    }
    /// Creates a new `ListProfilingGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProfilingGroups {
    type Output = std::result::Result<
        crate::output::ListProfilingGroupsOutput,
        crate::error::ListProfilingGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_profiling_groups_error(response)
        } else {
            crate::operation_deser::parse_list_profiling_groups_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PostAgentProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`post_agent_profile`](crate::client::Client::post_agent_profile).
///
/// See [`crate::client::fluent_builders::PostAgentProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PostAgentProfile {
    _private: (),
}
impl PostAgentProfile {
    /// Creates a new builder-style object to manufacture [`PostAgentProfileInput`](crate::input::PostAgentProfileInput)
    pub fn builder() -> crate::input::post_agent_profile_input::Builder {
        crate::input::post_agent_profile_input::Builder::default()
    }
    /// Creates a new `PostAgentProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PostAgentProfile {
    type Output = std::result::Result<
        crate::output::PostAgentProfileOutput,
        crate::error::PostAgentProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_post_agent_profile_error(response)
        } else {
            crate::operation_deser::parse_post_agent_profile_response(response)
        }
    }
}

/// Operation shape for `PutPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_permission`](crate::client::Client::put_permission).
///
/// See [`crate::client::fluent_builders::PutPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPermission {
    _private: (),
}
impl PutPermission {
    /// Creates a new builder-style object to manufacture [`PutPermissionInput`](crate::input::PutPermissionInput)
    pub fn builder() -> crate::input::put_permission_input::Builder {
        crate::input::put_permission_input::Builder::default()
    }
    /// Creates a new `PutPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPermission {
    type Output =
        std::result::Result<crate::output::PutPermissionOutput, crate::error::PutPermissionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_permission_error(response)
        } else {
            crate::operation_deser::parse_put_permission_response(response)
        }
    }
}

/// Operation shape for `RemoveNotificationChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_notification_channel`](crate::client::Client::remove_notification_channel).
///
/// See [`crate::client::fluent_builders::RemoveNotificationChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveNotificationChannel {
    _private: (),
}
impl RemoveNotificationChannel {
    /// Creates a new builder-style object to manufacture [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
    pub fn builder() -> crate::input::remove_notification_channel_input::Builder {
        crate::input::remove_notification_channel_input::Builder::default()
    }
    /// Creates a new `RemoveNotificationChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveNotificationChannel {
    type Output = std::result::Result<
        crate::output::RemoveNotificationChannelOutput,
        crate::error::RemoveNotificationChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_notification_channel_error(response)
        } else {
            crate::operation_deser::parse_remove_notification_channel_response(response)
        }
    }
}

/// Operation shape for `RemovePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_permission`](crate::client::Client::remove_permission).
///
/// See [`crate::client::fluent_builders::RemovePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemovePermission {
    _private: (),
}
impl RemovePermission {
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
    /// Creates a new `RemovePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemovePermission {
    type Output = std::result::Result<
        crate::output::RemovePermissionOutput,
        crate::error::RemovePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_permission_error(response)
        } else {
            crate::operation_deser::parse_remove_permission_response(response)
        }
    }
}

/// Operation shape for `SubmitFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`submit_feedback`](crate::client::Client::submit_feedback).
///
/// See [`crate::client::fluent_builders::SubmitFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SubmitFeedback {
    _private: (),
}
impl SubmitFeedback {
    /// Creates a new builder-style object to manufacture [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
    pub fn builder() -> crate::input::submit_feedback_input::Builder {
        crate::input::submit_feedback_input::Builder::default()
    }
    /// Creates a new `SubmitFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SubmitFeedback {
    type Output =
        std::result::Result<crate::output::SubmitFeedbackOutput, crate::error::SubmitFeedbackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_submit_feedback_error(response)
        } else {
            crate::operation_deser::parse_submit_feedback_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateProfilingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_profiling_group`](crate::client::Client::update_profiling_group).
///
/// See [`crate::client::fluent_builders::UpdateProfilingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProfilingGroup {
    _private: (),
}
impl UpdateProfilingGroup {
    /// Creates a new builder-style object to manufacture [`UpdateProfilingGroupInput`](crate::input::UpdateProfilingGroupInput)
    pub fn builder() -> crate::input::update_profiling_group_input::Builder {
        crate::input::update_profiling_group_input::Builder::default()
    }
    /// Creates a new `UpdateProfilingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProfilingGroup {
    type Output = std::result::Result<
        crate::output::UpdateProfilingGroupOutput,
        crate::error::UpdateProfilingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_profiling_group_error(response)
        } else {
            crate::operation_deser::parse_update_profiling_group_response(response)
        }
    }
}
