#![allow(clippy::module_inception)]
#![allow(clippy::upper_case_acronyms)]
#![allow(clippy::large_enum_variant)]
#![allow(clippy::wrong_self_convention)]
#![allow(clippy::should_implement_trait)]
#![allow(clippy::blacklisted_name)]
#![allow(clippy::vec_init_then_push)]
#![allow(rustdoc::bare_urls)]
#![warn(missing_docs)]
//! <p>
//! This section provides documentation for the Amazon CodeGuru Profiler API operations.
//! </p>
//! <p>
//! Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides
//! recommendations that can help you fine-tune your application performance. Using machine learning
//! algorithms, CodeGuru Profiler can help you find your most expensive lines of code and suggest ways you can
//! improve efficiency and remove CPU bottlenecks.
//! </p>
//! <p>
//! Amazon CodeGuru Profiler provides different visualizations of profiling data to help you identify what code is
//! running on the CPU, see how much time is consumed, and suggest ways to reduce CPU utilization.
//! </p>
//! <note>
//! <p>Amazon CodeGuru Profiler currently supports applications written in all Java virtual machine (JVM)
//! languages and Python. While CodeGuru Profiler supports both visualizations and recommendations for applications
//! written in Java, it can also generate visualizations and a subset of recommendations for
//! applications written in other JVM languages and Python.</p>
//! </note>
//! <p>
//! For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/what-is-codeguru-profiler.html">What is Amazon CodeGuru Profiler</a> in
//! the <i>Amazon CodeGuru Profiler User Guide</i>.
//! </p>

// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use error_meta::Error;

pub use config::Config;

mod aws_endpoint;
/// Client and fluent builders for calling the service.
#[cfg(feature = "client")]
pub mod client;
/// Configuration for the service.
pub mod config;
/// Errors that can occur when calling the service.
pub mod error;
mod error_meta;
mod http_serde;
mod idempotency_token;
/// Input structures for operations.
pub mod input;
mod json_deser;
mod json_errors;
mod json_ser;
/// Data structures used by operation inputs/outputs.
pub mod model;
mod no_credentials;
/// All operations that this crate can perform.
pub mod operation;
mod operation_deser;
mod operation_ser;
/// Output structures for operations.
pub mod output;
/// Crate version number.
pub static PKG_VERSION: &str = env!("CARGO_PKG_VERSION");
pub use aws_smithy_http::byte_stream::ByteStream;
pub use aws_smithy_http::result::SdkError;
pub use aws_smithy_types::Blob;
static API_METADATA: aws_http::user_agent::ApiMetadata =
    aws_http::user_agent::ApiMetadata::new("codeguruprofiler", PKG_VERSION);
pub use aws_smithy_http::endpoint::Endpoint;
pub use aws_smithy_types::retry::RetryConfig;
pub use aws_types::region::Region;
pub use aws_types::Credentials;
#[cfg(feature = "client")]
pub use client::Client;
