// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddNotificationChannelsInput`](crate::input::AddNotificationChannelsInput)
pub mod add_notification_channels_input {
    /// A builder for [`AddNotificationChannelsInput`](crate::input::AddNotificationChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
    }
    impl Builder {
        /// <p>The name of the profiling group that we are setting up notifications for.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group that we are setting up notifications for.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>One or 2 channels to report to when anomalies are detected.</p>
        pub fn channels(mut self, input: impl Into<crate::model::Channel>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p>One or 2 channels to report to when anomalies are detected.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// Consumes the builder and constructs a [`AddNotificationChannelsInput`](crate::input::AddNotificationChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddNotificationChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddNotificationChannelsInput {
                profiling_group_name: self.profiling_group_name,
                channels: self.channels,
            })
        }
    }
}
#[doc(hidden)]
pub type AddNotificationChannelsInputOperationOutputAlias =
    crate::operation::AddNotificationChannels;
#[doc(hidden)]
pub type AddNotificationChannelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddNotificationChannelsInput {
    /// Consumes the builder and constructs an Operation<[`AddNotificationChannels`](crate::operation::AddNotificationChannels)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddNotificationChannels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddNotificationChannelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.profiling_group_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_1, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/notificationConfiguration",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddNotificationChannelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddNotificationChannelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_notification_channels(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddNotificationChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddNotificationChannels",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddNotificationChannelsInput`](crate::input::AddNotificationChannelsInput)
    pub fn builder() -> crate::input::add_notification_channels_input::Builder {
        crate::input::add_notification_channels_input::Builder::default()
    }
}

/// See [`BatchGetFrameMetricDataInput`](crate::input::BatchGetFrameMetricDataInput)
pub mod batch_get_frame_metric_data_input {
    /// A builder for [`BatchGetFrameMetricDataInput`](crate::input::BatchGetFrameMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) period: std::option::Option<std::string::String>,
        pub(crate) target_resolution: std::option::Option<crate::model::AggregationPeriod>,
        pub(crate) frame_metrics: std::option::Option<std::vec::Vec<crate::model::FrameMetric>>,
    }
    impl Builder {
        /// <p>
        /// The name of the profiling group associated with the
        /// the frame metrics used to return the time series values.
        /// </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the profiling group associated with the
        /// the frame metrics used to return the time series values.
        /// </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// The start time of the time period for the frame metrics used to return the time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The start time of the time period for the frame metrics used to return the time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The end time of the time period for the returned time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the time period for the returned time series values.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>
        /// The duration of the frame metrics used to return the time series values.
        /// Specify using the ISO 8601 format. The maximum period duration
        /// is one day (<code>PT24H</code> or <code>P1D</code>).
        /// </p>
        pub fn period(mut self, input: impl Into<std::string::String>) -> Self {
            self.period = Some(input.into());
            self
        }
        /// <p>
        /// The duration of the frame metrics used to return the time series values.
        /// Specify using the ISO 8601 format. The maximum period duration
        /// is one day (<code>PT24H</code> or <code>P1D</code>).
        /// </p>
        pub fn set_period(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.period = input;
            self
        }
        /// <p>The requested resolution of time steps for the returned time series of values.
        /// If the requested target resolution is not available due to data not being retained we provide a best effort
        /// result by falling back to the most granular available resolution after the target resolution.
        /// There are 3 valid values.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn target_resolution(mut self, input: crate::model::AggregationPeriod) -> Self {
            self.target_resolution = Some(input);
            self
        }
        /// <p>The requested resolution of time steps for the returned time series of values.
        /// If the requested target resolution is not available due to data not being retained we provide a best effort
        /// result by falling back to the most granular available resolution after the target resolution.
        /// There are 3 valid values.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_target_resolution(
            mut self,
            input: std::option::Option<crate::model::AggregationPeriod>,
        ) -> Self {
            self.target_resolution = input;
            self
        }
        /// Appends an item to `frame_metrics`.
        ///
        /// To override the contents of this collection use [`set_frame_metrics`](Self::set_frame_metrics).
        ///
        /// <p>
        /// The details of the metrics that are used to request a time series of values. The metric includes
        /// the name of the frame, the aggregation type to calculate the metric value for the
        /// frame, and the thread states to use to get the count for the metric value of the frame.</p>
        pub fn frame_metrics(mut self, input: impl Into<crate::model::FrameMetric>) -> Self {
            let mut v = self.frame_metrics.unwrap_or_default();
            v.push(input.into());
            self.frame_metrics = Some(v);
            self
        }
        /// <p>
        /// The details of the metrics that are used to request a time series of values. The metric includes
        /// the name of the frame, the aggregation type to calculate the metric value for the
        /// frame, and the thread states to use to get the count for the metric value of the frame.</p>
        pub fn set_frame_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameMetric>>,
        ) -> Self {
            self.frame_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetFrameMetricDataInput`](crate::input::BatchGetFrameMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetFrameMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetFrameMetricDataInput {
                profiling_group_name: self.profiling_group_name,
                start_time: self.start_time,
                end_time: self.end_time,
                period: self.period,
                target_resolution: self.target_resolution,
                frame_metrics: self.frame_metrics,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetFrameMetricDataInputOperationOutputAlias =
    crate::operation::BatchGetFrameMetricData;
#[doc(hidden)]
pub type BatchGetFrameMetricDataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetFrameMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetFrameMetricData`](crate::operation::BatchGetFrameMetricData)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetFrameMetricData,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetFrameMetricDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.profiling_group_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_2, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/frames/-/metrics",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::BatchGetFrameMetricDataInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.start_time {
                query.push_kv(
                    "startTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_3,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_4) = &_input.end_time {
                query.push_kv(
                    "endTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_4,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_5) = &_input.period {
                query.push_kv("period", &aws_smithy_http::query::fmt_string(&inner_5));
            }
            if let Some(inner_6) = &_input.target_resolution {
                query.push_kv(
                    "targetResolution",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetFrameMetricDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetFrameMetricDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_frame_metric_data(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetFrameMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetFrameMetricData",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetFrameMetricDataInput`](crate::input::BatchGetFrameMetricDataInput)
    pub fn builder() -> crate::input::batch_get_frame_metric_data_input::Builder {
        crate::input::batch_get_frame_metric_data_input::Builder::default()
    }
}

/// See [`ConfigureAgentInput`](crate::input::ConfigureAgentInput)
pub mod configure_agent_input {
    /// A builder for [`ConfigureAgentInput`](crate::input::ConfigureAgentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) fleet_instance_id: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<crate::model::MetadataField, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>
        /// The name of the profiling group for which the configured agent is collecting profiling data.
        /// </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the profiling group for which the configured agent is collecting profiling data.
        /// </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p> A universally unique identifier (UUID) for a profiling instance. For example, if the
        /// profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS
        /// Fargate container, it is the container's task ID. </p>
        pub fn fleet_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_instance_id = Some(input.into());
            self
        }
        /// <p> A universally unique identifier (UUID) for a profiling instance. For example, if the
        /// profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS
        /// Fargate container, it is the container's task ID. </p>
        pub fn set_fleet_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fleet_instance_id = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p> Metadata captured about the compute platform the agent is running on. It includes
        /// information about sampling and reporting. The valid fields are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AGENT_ID</code> - The ID for an agent instance.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda function times out.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations of a Lambda function.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda invocation.
        /// </p>
        /// </li>
        /// </ul>
        pub fn metadata(
            mut self,
            k: impl Into<crate::model::MetadataField>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p> Metadata captured about the compute platform the agent is running on. It includes
        /// information about sampling and reporting. The valid fields are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AGENT_ID</code> - The ID for an agent instance.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda function times out.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations of a Lambda function.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda invocation.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::MetadataField, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigureAgentInput`](crate::input::ConfigureAgentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfigureAgentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfigureAgentInput {
                profiling_group_name: self.profiling_group_name,
                fleet_instance_id: self.fleet_instance_id,
                metadata: self.metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfigureAgentInputOperationOutputAlias = crate::operation::ConfigureAgent;
#[doc(hidden)]
pub type ConfigureAgentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConfigureAgentInput {
    /// Consumes the builder and constructs an Operation<[`ConfigureAgent`](crate::operation::ConfigureAgent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfigureAgent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfigureAgentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.profiling_group_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_7, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/configureAgent",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfigureAgentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfigureAgentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_configure_agent(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfigureAgent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfigureAgent",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfigureAgentInput`](crate::input::ConfigureAgentInput)
    pub fn builder() -> crate::input::configure_agent_input::Builder {
        crate::input::configure_agent_input::Builder::default()
    }
}

/// See [`CreateProfilingGroupInput`](crate::input::CreateProfilingGroupInput)
pub mod create_profiling_group_input {
    /// A builder for [`CreateProfilingGroupInput`](crate::input::CreateProfilingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) agent_orchestration_config:
            std::option::Option<crate::model::AgentOrchestrationConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the profiling group to create.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group to create.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// The compute platform of the profiling group. Use <code>AWSLambda</code> if your application
        /// runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that
        /// is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform.
        /// If not specified, <code>Default</code> is used.         
        /// </p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p>
        /// The compute platform of the profiling group. Use <code>AWSLambda</code> if your application
        /// runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that
        /// is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform.
        /// If not specified, <code>Default</code> is used.         
        /// </p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
        /// accidental creation of duplicate profiling groups if there are failures and retries. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
        /// accidental creation of duplicate profiling groups if there are failures and retries. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>
        /// Specifies whether profiling is enabled or disabled for the created profiling group.
        /// </p>
        pub fn agent_orchestration_config(
            mut self,
            input: crate::model::AgentOrchestrationConfig,
        ) -> Self {
            self.agent_orchestration_config = Some(input);
            self
        }
        /// <p>
        /// Specifies whether profiling is enabled or disabled for the created profiling group.
        /// </p>
        pub fn set_agent_orchestration_config(
            mut self,
            input: std::option::Option<crate::model::AgentOrchestrationConfig>,
        ) -> Self {
            self.agent_orchestration_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// A list of tags to add to the created profiling group.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>
        /// A list of tags to add to the created profiling group.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProfilingGroupInput`](crate::input::CreateProfilingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProfilingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProfilingGroupInput {
                profiling_group_name: self.profiling_group_name,
                compute_platform: self.compute_platform,
                client_token: self.client_token,
                agent_orchestration_config: self.agent_orchestration_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProfilingGroupInputOperationOutputAlias = crate::operation::CreateProfilingGroup;
#[doc(hidden)]
pub type CreateProfilingGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProfilingGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateProfilingGroup`](crate::operation::CreateProfilingGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProfilingGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProfilingGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/profilingGroups").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::CreateProfilingGroupInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.client_token {
                query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProfilingGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProfilingGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_profiling_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProfilingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProfilingGroup",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProfilingGroupInput`](crate::input::CreateProfilingGroupInput)
    pub fn builder() -> crate::input::create_profiling_group_input::Builder {
        crate::input::create_profiling_group_input::Builder::default()
    }
}

/// See [`DeleteProfilingGroupInput`](crate::input::DeleteProfilingGroupInput)
pub mod delete_profiling_group_input {
    /// A builder for [`DeleteProfilingGroupInput`](crate::input::DeleteProfilingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group to delete.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group to delete.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfilingGroupInput`](crate::input::DeleteProfilingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProfilingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProfilingGroupInput {
                profiling_group_name: self.profiling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProfilingGroupInputOperationOutputAlias = crate::operation::DeleteProfilingGroup;
#[doc(hidden)]
pub type DeleteProfilingGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteProfilingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProfilingGroup`](crate::operation::DeleteProfilingGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProfilingGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProfilingGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.profiling_group_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_9, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProfilingGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProfilingGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProfilingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProfilingGroup",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProfilingGroupInput`](crate::input::DeleteProfilingGroupInput)
    pub fn builder() -> crate::input::delete_profiling_group_input::Builder {
        crate::input::delete_profiling_group_input::Builder::default()
    }
}

/// See [`DescribeProfilingGroupInput`](crate::input::DescribeProfilingGroupInput)
pub mod describe_profiling_group_input {
    /// A builder for [`DescribeProfilingGroupInput`](crate::input::DescribeProfilingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the profiling group to get information about.
        /// </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the profiling group to get information about.
        /// </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProfilingGroupInput`](crate::input::DescribeProfilingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProfilingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProfilingGroupInput {
                profiling_group_name: self.profiling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProfilingGroupInputOperationOutputAlias = crate::operation::DescribeProfilingGroup;
#[doc(hidden)]
pub type DescribeProfilingGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProfilingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProfilingGroup`](crate::operation::DescribeProfilingGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProfilingGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProfilingGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.profiling_group_name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_10, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProfilingGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProfilingGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProfilingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProfilingGroup",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProfilingGroupInput`](crate::input::DescribeProfilingGroupInput)
    pub fn builder() -> crate::input::describe_profiling_group_input::Builder {
        crate::input::describe_profiling_group_input::Builder::default()
    }
}

/// See [`GetFindingsReportAccountSummaryInput`](crate::input::GetFindingsReportAccountSummaryInput)
pub mod get_findings_report_account_summary_input {
    /// A builder for [`GetFindingsReportAccountSummaryInput`](crate::input::GetFindingsReportAccountSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) daily_reports_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>GetFindingsReportAccountSummary</code>
        /// request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
        /// Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>GetFindingsReportAccountSummary</code>
        /// request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
        /// Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code> GetFindingsReportAccountSummary</code> in paginated output.
        /// When this parameter is used, <code>GetFindingsReportAccountSummary</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial
        /// request can be seen by sending another <code>GetFindingsReportAccountSummary</code> request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code> GetFindingsReportAccountSummary</code> in paginated output.
        /// When this parameter is used, <code>GetFindingsReportAccountSummary</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial
        /// request can be seen by sending another <code>GetFindingsReportAccountSummary</code> request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set
        /// to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
        /// analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn daily_reports_only(mut self, input: bool) -> Self {
            self.daily_reports_only = Some(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set
        /// to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
        /// analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn set_daily_reports_only(mut self, input: std::option::Option<bool>) -> Self {
            self.daily_reports_only = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsReportAccountSummaryInput`](crate::input::GetFindingsReportAccountSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingsReportAccountSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingsReportAccountSummaryInput {
                next_token: self.next_token,
                max_results: self.max_results,
                daily_reports_only: self.daily_reports_only,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingsReportAccountSummaryInputOperationOutputAlias =
    crate::operation::GetFindingsReportAccountSummary;
#[doc(hidden)]
pub type GetFindingsReportAccountSummaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFindingsReportAccountSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetFindingsReportAccountSummary`](crate::operation::GetFindingsReportAccountSummary)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindingsReportAccountSummary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingsReportAccountSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/internal/findingsReports").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetFindingsReportAccountSummaryInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            if let Some(inner_12) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_12).encode(),
                );
            }
            if let Some(inner_13) = &_input.daily_reports_only {
                query.push_kv(
                    "dailyReportsOnly",
                    &aws_smithy_types::primitive::Encoder::from(*inner_13).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingsReportAccountSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingsReportAccountSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindingsReportAccountSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindingsReportAccountSummary",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingsReportAccountSummaryInput`](crate::input::GetFindingsReportAccountSummaryInput)
    pub fn builder() -> crate::input::get_findings_report_account_summary_input::Builder {
        crate::input::get_findings_report_account_summary_input::Builder::default()
    }
}

/// See [`GetNotificationConfigurationInput`](crate::input::GetNotificationConfigurationInput)
pub mod get_notification_configuration_input {
    /// A builder for [`GetNotificationConfigurationInput`](crate::input::GetNotificationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group we want to get the notification configuration for.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group we want to get the notification configuration for.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNotificationConfigurationInput`](crate::input::GetNotificationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNotificationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNotificationConfigurationInput {
                profiling_group_name: self.profiling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetNotificationConfigurationInputOperationOutputAlias =
    crate::operation::GetNotificationConfiguration;
#[doc(hidden)]
pub type GetNotificationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetNotificationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetNotificationConfiguration`](crate::operation::GetNotificationConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNotificationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetNotificationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.profiling_group_name;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_14, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/notificationConfiguration",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetNotificationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetNotificationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNotificationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNotificationConfiguration",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetNotificationConfigurationInput`](crate::input::GetNotificationConfigurationInput)
    pub fn builder() -> crate::input::get_notification_configuration_input::Builder {
        crate::input::get_notification_configuration_input::Builder::default()
    }
}

/// See [`GetPolicyInput`](crate::input::GetPolicyInput)
pub mod get_policy_input {
    /// A builder for [`GetPolicyInput`](crate::input::GetPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyInput`](crate::input::GetPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetPolicyInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetPolicyInput {
                profiling_group_name: self.profiling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPolicyInputOperationOutputAlias = crate::operation::GetPolicy;
#[doc(hidden)]
pub type GetPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetPolicy`](crate::operation::GetPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.profiling_group_name;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_15, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/policy",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetPolicy::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetPolicy",
                    "codeguruprofiler",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
}

/// See [`GetProfileInput`](crate::input::GetProfileInput)
pub mod get_profile_input {
    /// A builder for [`GetProfileInput`](crate::input::GetProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) period: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) max_depth: std::option::Option<i32>,
        pub(crate) accept: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group to get.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group to get.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>The start time of the profile to get. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        ///
        /// <p>
        /// If you specify <code>startTime</code>, then you must also specify <code>period</code>
        /// or <code>endTime</code>, but not both.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the profile to get. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
        ///
        /// <p>
        /// If you specify <code>startTime</code>, then you must also specify <code>period</code>
        /// or <code>endTime</code>, but not both.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// Used with <code>startTime</code> or <code>endTime</code> to specify
        /// the time range for the returned aggregated profile. Specify using
        /// the ISO 8601 format. For example, <code>P1DT1H1M1S</code>.
        /// </p>
        ///
        /// <p>
        /// To get the latest aggregated profile, specify only <code>period</code>.
        /// </p>
        pub fn period(mut self, input: impl Into<std::string::String>) -> Self {
            self.period = Some(input.into());
            self
        }
        /// <p>
        /// Used with <code>startTime</code> or <code>endTime</code> to specify
        /// the time range for the returned aggregated profile. Specify using
        /// the ISO 8601 format. For example, <code>P1DT1H1M1S</code>.
        /// </p>
        ///
        /// <p>
        /// To get the latest aggregated profile, specify only <code>period</code>.
        /// </p>
        pub fn set_period(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.period = input;
            self
        }
        /// <p>
        /// The end time of the requested profile. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        /// <p>
        /// If you specify <code>endTime</code>, then you must also specify <code>period</code>
        /// or <code>startTime</code>, but not both.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the requested profile. Specify using
        /// the ISO 8601 format. For example,
        /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        /// <p>
        /// If you specify <code>endTime</code>, then you must also specify <code>period</code>
        /// or <code>startTime</code>, but not both.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>
        /// The maximum depth of the stacks in the code that is represented in
        /// the aggregated profile. For example, if CodeGuru Profiler finds a method <code>A</code>,
        /// which calls method <code>B</code>, which calls method <code>C</code>, which
        /// calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
        /// set to 2, then the aggregated profile contains representations of methods <code>A</code>
        /// and <code>B</code>.
        /// </p>
        pub fn max_depth(mut self, input: i32) -> Self {
            self.max_depth = Some(input);
            self
        }
        /// <p>
        /// The maximum depth of the stacks in the code that is represented in
        /// the aggregated profile. For example, if CodeGuru Profiler finds a method <code>A</code>,
        /// which calls method <code>B</code>, which calls method <code>C</code>, which
        /// calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
        /// set to 2, then the aggregated profile contains representations of methods <code>A</code>
        /// and <code>B</code>.
        /// </p>
        pub fn set_max_depth(mut self, input: std::option::Option<i32>) -> Self {
            self.max_depth = input;
            self
        }
        /// <p>
        /// The format of the returned profiling data. The format maps to the
        /// <code>Accept</code> and <code>Content-Type</code> headers of the
        /// HTTP request. You can specify one of the following:
        /// or the default .
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>application/json</code> — standard JSON format
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information,
        /// see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept = Some(input.into());
            self
        }
        /// <p>
        /// The format of the returned profiling data. The format maps to the
        /// <code>Accept</code> and <code>Content-Type</code> headers of the
        /// HTTP request. You can specify one of the following:
        /// or the default .
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>application/json</code> — standard JSON format
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information,
        /// see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accept = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProfileInput`](crate::input::GetProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProfileInput {
                profiling_group_name: self.profiling_group_name,
                start_time: self.start_time,
                period: self.period,
                end_time: self.end_time,
                max_depth: self.max_depth,
                accept: self.accept,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProfileInputOperationOutputAlias = crate::operation::GetProfile;
#[doc(hidden)]
pub type GetProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetProfile`](crate::operation::GetProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.profiling_group_name;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_16, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/profile",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetProfileInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_17) = &_input.accept {
                let formatted_18 = AsRef::<str>::as_ref(inner_17);
                if !formatted_18.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_18;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "accept",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Accept", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::GetProfileInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_19) = &_input.start_time {
                query.push_kv(
                    "startTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_19,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_20) = &_input.period {
                query.push_kv("period", &aws_smithy_http::query::fmt_string(&inner_20));
            }
            if let Some(inner_21) = &_input.end_time {
                query.push_kv(
                    "endTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_21,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_22) = &_input.max_depth {
                query.push_kv(
                    "maxDepth",
                    &aws_smithy_types::primitive::Encoder::from(*inner_22).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProfile",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetProfileInput`](crate::input::GetProfileInput)
    pub fn builder() -> crate::input::get_profile_input::Builder {
        crate::input::get_profile_input::Builder::default()
    }
}

/// See [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
pub mod get_recommendations_input {
    /// A builder for [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) locale: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the profiling group to get analysis data about.
        /// </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the profiling group to get analysis data about.
        /// </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>
        /// The language used to provide analysis. Specify using a string that is one
        /// of the following <code>BCP 47</code> language codes.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>de-DE</code> - German, Germany
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>en-GB</code> - English, United Kingdom
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>en-US</code> - English, United States
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>es-ES</code> - Spanish, Spain
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fr-FR</code> - French, France
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>it-IT</code> - Italian, Italy
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ja-JP</code> - Japanese, Japan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ko-KR</code> - Korean, Republic of Korea
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pt-BR</code> - Portugese, Brazil
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh-CN</code> - Chinese, China
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh-TW</code> - Chinese, Taiwan
        /// </p>
        /// </li>
        /// </ul>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>
        /// The language used to provide analysis. Specify using a string that is one
        /// of the following <code>BCP 47</code> language codes.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>de-DE</code> - German, Germany
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>en-GB</code> - English, United Kingdom
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>en-US</code> - English, United States
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>es-ES</code> - Spanish, Spain
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fr-FR</code> - French, France
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>it-IT</code> - Italian, Italy
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ja-JP</code> - Japanese, Japan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ko-KR</code> - Korean, Republic of Korea
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pt-BR</code> - Portugese, Brazil
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh-CN</code> - Chinese, China
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh-TW</code> - Chinese, Taiwan
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecommendationsInput {
                profiling_group_name: self.profiling_group_name,
                start_time: self.start_time,
                end_time: self.end_time,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecommendationsInputOperationOutputAlias = crate::operation::GetRecommendations;
#[doc(hidden)]
pub type GetRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`GetRecommendations`](crate::operation::GetRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.profiling_group_name;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_23, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/internal/profilingGroups/{profilingGroupName}/recommendations",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetRecommendationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_24) = &_input.start_time {
                query.push_kv(
                    "startTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_24,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_25) = &_input.end_time {
                query.push_kv(
                    "endTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_25,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_26) = &_input.locale {
                query.push_kv("locale", &aws_smithy_http::query::fmt_string(&inner_26));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecommendations",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
    pub fn builder() -> crate::input::get_recommendations_input::Builder {
        crate::input::get_recommendations_input::Builder::default()
    }
}

/// See [`ListFindingsReportsInput`](crate::input::ListFindingsReportsInput)
pub mod list_findings_reports_input {
    /// A builder for [`ListFindingsReportsInput`](crate::input::ListFindingsReportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) daily_reports_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the profiling group from which to search for analysis data.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group from which to search for analysis data.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
        /// This is specified
        /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
        /// millisecond past June 1, 2020 1:15:02 PM UTC.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code>
        /// request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
        /// Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code>
        /// request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
        /// Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of report results returned by <code>ListFindingsReports</code>
        /// in paginated output. When this parameter is used, <code>ListFindingsReports</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListFindingsReports</code> request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of report results returned by <code>ListFindingsReports</code>
        /// in paginated output. When this parameter is used, <code>ListFindingsReports</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListFindingsReports</code> request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set
        /// to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
        /// analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn daily_reports_only(mut self, input: bool) -> Self {
            self.daily_reports_only = Some(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set
        /// to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
        /// analysis data is returned from smaller time windows (for example, one hour).</p>
        pub fn set_daily_reports_only(mut self, input: std::option::Option<bool>) -> Self {
            self.daily_reports_only = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsReportsInput`](crate::input::ListFindingsReportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFindingsReportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFindingsReportsInput {
                profiling_group_name: self.profiling_group_name,
                start_time: self.start_time,
                end_time: self.end_time,
                next_token: self.next_token,
                max_results: self.max_results,
                daily_reports_only: self.daily_reports_only,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFindingsReportsInputOperationOutputAlias = crate::operation::ListFindingsReports;
#[doc(hidden)]
pub type ListFindingsReportsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFindingsReportsInput {
    /// Consumes the builder and constructs an Operation<[`ListFindingsReports`](crate::operation::ListFindingsReports)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFindingsReports,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFindingsReportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.profiling_group_name;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_27, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/internal/profilingGroups/{profilingGroupName}/findingsReports",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListFindingsReportsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_28) = &_input.start_time {
                query.push_kv(
                    "startTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_28,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_29) = &_input.end_time {
                query.push_kv(
                    "endTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_29,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_30) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_30));
            }
            if let Some(inner_31) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_31).encode(),
                );
            }
            if let Some(inner_32) = &_input.daily_reports_only {
                query.push_kv(
                    "dailyReportsOnly",
                    &aws_smithy_types::primitive::Encoder::from(*inner_32).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFindingsReportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFindingsReportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFindingsReports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFindingsReports",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFindingsReportsInput`](crate::input::ListFindingsReportsInput)
    pub fn builder() -> crate::input::list_findings_reports_input::Builder {
        crate::input::list_findings_reports_input::Builder::default()
    }
}

/// See [`ListProfileTimesInput`](crate::input::ListProfileTimesInput)
pub mod list_profile_times_input {
    /// A builder for [`ListProfileTimesInput`](crate::input::ListProfileTimesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) period: std::option::Option<crate::model::AggregationPeriod>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>The start time of the time range from which to list the profiles.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the time range from which to list the profiles.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the time range from which to list the profiles.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the time range from which to list the profiles.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>
        /// The aggregation period. This specifies the period during which an aggregation profile
        /// collects posted agent profiles for a profiling group. There are 3 valid values.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn period(mut self, input: crate::model::AggregationPeriod) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>
        /// The aggregation period. This specifies the period during which an aggregation profile
        /// collects posted agent profiles for a profiling group. There are 3 valid values.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>P1D</code> — 1 day
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT1H</code> — 1 hour
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PT5M</code> — 5 minutes
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::AggregationPeriod>,
        ) -> Self {
            self.period = input;
            self
        }
        /// <p>The order (ascending or descending by start time of the profile) to
        /// use when listing profiles. Defaults to <code>TIMESTAMP_DESCENDING</code>.
        /// </p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The order (ascending or descending by start time of the profile) to
        /// use when listing profiles. Defaults to <code>TIMESTAMP_DESCENDING</code>.
        /// </p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// <p>The maximum number of profile time results returned by <code>ListProfileTimes</code>
        /// in paginated output. When this parameter is used, <code>ListProfileTimes</code> only returns
        /// <code>maxResults</code> results in a single page with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListProfileTimes</code> request with the returned
        /// <code>nextToken</code> value.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of profile time results returned by <code>ListProfileTimes</code>
        /// in paginated output. When this parameter is used, <code>ListProfileTimes</code> only returns
        /// <code>maxResults</code> results in a single page with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListProfileTimes</code> request with the returned
        /// <code>nextToken</code> value.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListProfileTimes</code> request where <code>maxResults</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous results
        /// that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListProfileTimes</code> request where <code>maxResults</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous results
        /// that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileTimesInput`](crate::input::ListProfileTimesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProfileTimesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProfileTimesInput {
                profiling_group_name: self.profiling_group_name,
                start_time: self.start_time,
                end_time: self.end_time,
                period: self.period,
                order_by: self.order_by,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProfileTimesInputOperationOutputAlias = crate::operation::ListProfileTimes;
#[doc(hidden)]
pub type ListProfileTimesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProfileTimesInput {
    /// Consumes the builder and constructs an Operation<[`ListProfileTimes`](crate::operation::ListProfileTimes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProfileTimes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProfileTimesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.profiling_group_name;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_33, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/profileTimes",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListProfileTimesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_34) = &_input.start_time {
                query.push_kv(
                    "startTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_34,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_35) = &_input.end_time {
                query.push_kv(
                    "endTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_35,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_36) = &_input.period {
                query.push_kv("period", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            if let Some(inner_37) = &_input.order_by {
                query.push_kv("orderBy", &aws_smithy_http::query::fmt_string(&inner_37));
            }
            if let Some(inner_38) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_38).encode(),
                );
            }
            if let Some(inner_39) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_39));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProfileTimesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProfileTimesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProfileTimes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProfileTimes",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProfileTimesInput`](crate::input::ListProfileTimesInput)
    pub fn builder() -> crate::input::list_profile_times_input::Builder {
        crate::input::list_profile_times_input::Builder::default()
    }
}

/// See [`ListProfilingGroupsInput`](crate::input::ListProfilingGroupsInput)
pub mod list_profiling_groups_input {
    /// A builder for [`ListProfilingGroupsInput`](crate::input::ListProfilingGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) include_description: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListProfilingGroups</code> request where <code>maxResults</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous results
        /// that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListProfilingGroups</code> request where <code>maxResults</code> was used and the results
        /// exceeded the value of that parameter. Pagination continues from the end of the previous results
        /// that returned the <code>nextToken</code> value.
        /// </p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve
        /// the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of profiling groups results returned by <code>ListProfilingGroups</code>
        /// in paginated output. When this parameter is used, <code>ListProfilingGroups</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListProfilingGroups</code> request with the returned
        /// <code>nextToken</code> value.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of profiling groups results returned by <code>ListProfilingGroups</code>
        /// in paginated output. When this parameter is used, <code>ListProfilingGroups</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
        /// element. The remaining results of the initial request
        /// can be seen by sending another <code>ListProfilingGroups</code> request with the returned
        /// <code>nextToken</code> value.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>,
        /// then a list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a> objects
        /// that contain detailed information about profiling groups is returned. If <code>false</code>, then
        /// a list of profiling group names is returned.</p>
        pub fn include_description(mut self, input: bool) -> Self {
            self.include_description = Some(input);
            self
        }
        /// <p>A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>,
        /// then a list of
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
        /// <code>ProfilingGroupDescription</code>
        /// </a> objects
        /// that contain detailed information about profiling groups is returned. If <code>false</code>, then
        /// a list of profiling group names is returned.</p>
        pub fn set_include_description(mut self, input: std::option::Option<bool>) -> Self {
            self.include_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfilingGroupsInput`](crate::input::ListProfilingGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProfilingGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProfilingGroupsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                include_description: self.include_description,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProfilingGroupsInputOperationOutputAlias = crate::operation::ListProfilingGroups;
#[doc(hidden)]
pub type ListProfilingGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProfilingGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListProfilingGroups`](crate::operation::ListProfilingGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProfilingGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProfilingGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/profilingGroups").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListProfilingGroupsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            if let Some(inner_41) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_41).encode(),
                );
            }
            if let Some(inner_42) = &_input.include_description {
                query.push_kv(
                    "includeDescription",
                    &aws_smithy_types::primitive::Encoder::from(*inner_42).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProfilingGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProfilingGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProfilingGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProfilingGroups",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProfilingGroupsInput`](crate::input::ListProfilingGroupsInput)
    pub fn builder() -> crate::input::list_profiling_groups_input::Builder {
        crate::input::list_profiling_groups_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that contains the tags to return.
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that contains the tags to return.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.resource_arn;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_43, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PostAgentProfileInput`](crate::input::PostAgentProfileInput)
pub mod post_agent_profile_input {
    /// A builder for [`PostAgentProfileInput`](crate::input::PostAgentProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) agent_profile: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) profile_token: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the profiling group with the aggregated profile that receives the
        /// submitted profiling data.
        /// </p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the profiling group with the aggregated profile that receives the
        /// submitted profiling data.
        /// </p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// The submitted profiling data.
        /// </p>
        pub fn agent_profile(mut self, input: aws_smithy_types::Blob) -> Self {
            self.agent_profile = Some(input);
            self
        }
        /// <p>
        /// The submitted profiling data.
        /// </p>
        pub fn set_agent_profile(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.agent_profile = input;
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
        /// accidental submission of duplicate profiling data if there are failures and retries. </p>
        pub fn profile_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_token = Some(input.into());
            self
        }
        /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
        /// accidental submission of duplicate profiling data if there are failures and retries. </p>
        pub fn set_profile_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_token = input;
            self
        }
        /// <p>
        /// The format of the submitted profiling data. The format maps to the
        /// <code>Accept</code> and <code>Content-Type</code> headers of the
        /// HTTP request. You can specify one of the following:
        /// or the default .
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>application/json</code> — standard JSON format
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information,
        /// see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>
        /// The format of the submitted profiling data. The format maps to the
        /// <code>Accept</code> and <code>Content-Type</code> headers of the
        /// HTTP request. You can specify one of the following:
        /// or the default .
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>application/json</code> — standard JSON format
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information,
        /// see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PostAgentProfileInput`](crate::input::PostAgentProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PostAgentProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PostAgentProfileInput {
                profiling_group_name: self.profiling_group_name,
                agent_profile: self.agent_profile,
                profile_token: self.profile_token,
                content_type: self.content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type PostAgentProfileInputOperationOutputAlias = crate::operation::PostAgentProfile;
#[doc(hidden)]
pub type PostAgentProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PostAgentProfileInput {
    /// Consumes the builder and constructs an Operation<[`PostAgentProfile`](crate::operation::PostAgentProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PostAgentProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PostAgentProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.profiling_group_name;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_44, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/agentProfile",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PostAgentProfileInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_45) = &_input.content_type {
                let formatted_46 = AsRef::<str>::as_ref(inner_45);
                if !formatted_46.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_46;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Type", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::PostAgentProfileInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_47) = &_input.profile_token {
                query.push_kv(
                    "profileToken",
                    &aws_smithy_http::query::fmt_string(&inner_47),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PostAgentProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PostAgentProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        if self.profile_token.is_none() {
            self.profile_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_post_agent_profile_input(self.agent_profile)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PostAgentProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PostAgentProfile",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PostAgentProfileInput`](crate::input::PostAgentProfileInput)
    pub fn builder() -> crate::input::post_agent_profile_input::Builder {
        crate::input::post_agent_profile_input::Builder::default()
    }
}

/// See [`PutPermissionInput`](crate::input::PutPermissionInput)
pub mod put_permission_input {
    /// A builder for [`PutPermissionInput`](crate::input::PutPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) action_group: std::option::Option<crate::model::ActionGroup>,
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group to grant access to.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group to grant access to.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// Specifies an action group that contains permissions to add to
        /// a profiling group resource. One action group is supported, <code>agentPermissions</code>, which
        /// grants permission to perform actions required by the profiling agent, <code>ConfigureAgent</code>
        /// and <code>PostAgentProfile</code> permissions.
        /// </p>
        pub fn action_group(mut self, input: crate::model::ActionGroup) -> Self {
            self.action_group = Some(input);
            self
        }
        /// <p>
        /// Specifies an action group that contains permissions to add to
        /// a profiling group resource. One action group is supported, <code>agentPermissions</code>, which
        /// grants permission to perform actions required by the profiling agent, <code>ConfigureAgent</code>
        /// and <code>PostAgentProfile</code> permissions.
        /// </p>
        pub fn set_action_group(
            mut self,
            input: std::option::Option<crate::model::ActionGroup>,
        ) -> Self {
            self.action_group = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>
        /// A list ARNs for the roles and users you want to grant access to the profiling group.
        /// Wildcards are not are supported in the ARNs.
        /// </p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>
        /// A list ARNs for the roles and users you want to grant access to the profiling group.
        /// Wildcards are not are supported in the ARNs.
        /// </p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>
        /// A universally unique identifier (UUID) for the revision of the policy you
        /// are adding to the profiling group. Do not specify
        /// this when you add permissions to a profiling group for the first time. If a policy already exists on the
        /// profiling group, you must specify the <code>revisionId</code>.
        /// </p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>
        /// A universally unique identifier (UUID) for the revision of the policy you
        /// are adding to the profiling group. Do not specify
        /// this when you add permissions to a profiling group for the first time. If a policy already exists on the
        /// profiling group, you must specify the <code>revisionId</code>.
        /// </p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPermissionInput`](crate::input::PutPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutPermissionInput {
                profiling_group_name: self.profiling_group_name,
                action_group: self.action_group,
                principals: self.principals,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutPermissionInputOperationOutputAlias = crate::operation::PutPermission;
#[doc(hidden)]
pub type PutPermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutPermissionInput {
    /// Consumes the builder and constructs an Operation<[`PutPermission`](crate::operation::PutPermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutPermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.profiling_group_name;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_48, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_49 = &_input.action_group;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_group",
                        details: "cannot be empty or unset",
                    })?;
            let action_group = aws_smithy_http::label::fmt_string(input_49, false);
            if action_group.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "action_group",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/policy/{actionGroup}",
                profilingGroupName = profiling_group_name,
                actionGroup = action_group
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_permission(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutPermission",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutPermissionInput`](crate::input::PutPermissionInput)
    pub fn builder() -> crate::input::put_permission_input::Builder {
        crate::input::put_permission_input::Builder::default()
    }
}

/// See [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
pub mod remove_notification_channel_input {
    /// A builder for [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group we want to change notification configuration for.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group we want to change notification configuration for.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>The id of the channel that we want to stop receiving notifications.</p>
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// <p>The id of the channel that we want to stop receiving notifications.</p>
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveNotificationChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveNotificationChannelInput {
                profiling_group_name: self.profiling_group_name,
                channel_id: self.channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveNotificationChannelInputOperationOutputAlias =
    crate::operation::RemoveNotificationChannel;
#[doc(hidden)]
pub type RemoveNotificationChannelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveNotificationChannelInput {
    /// Consumes the builder and constructs an Operation<[`RemoveNotificationChannel`](crate::operation::RemoveNotificationChannel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveNotificationChannel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveNotificationChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.profiling_group_name;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_50, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_51 = &_input.channel_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_51, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/notificationConfiguration/{channelId}",
                profilingGroupName = profiling_group_name,
                channelId = channel_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveNotificationChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveNotificationChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveNotificationChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveNotificationChannel",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
    pub fn builder() -> crate::input::remove_notification_channel_input::Builder {
        crate::input::remove_notification_channel_input::Builder::default()
    }
}

/// See [`RemovePermissionInput`](crate::input::RemovePermissionInput)
pub mod remove_permission_input {
    /// A builder for [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) action_group: std::option::Option<crate::model::ActionGroup>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// Specifies an action group that contains the permissions to remove from
        /// a profiling group's resource-based policy. One action group is supported, <code>agentPermissions</code>, which
        /// grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
        /// </p>
        pub fn action_group(mut self, input: crate::model::ActionGroup) -> Self {
            self.action_group = Some(input);
            self
        }
        /// <p>
        /// Specifies an action group that contains the permissions to remove from
        /// a profiling group's resource-based policy. One action group is supported, <code>agentPermissions</code>, which
        /// grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
        /// </p>
        pub fn set_action_group(
            mut self,
            input: std::option::Option<crate::model::ActionGroup>,
        ) -> Self {
            self.action_group = input;
            self
        }
        /// <p>
        /// A universally unique identifier (UUID) for the revision of the resource-based policy from which
        /// you want to remove permissions.
        /// </p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>
        /// A universally unique identifier (UUID) for the revision of the resource-based policy from which
        /// you want to remove permissions.
        /// </p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemovePermissionInput`](crate::input::RemovePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemovePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemovePermissionInput {
                profiling_group_name: self.profiling_group_name,
                action_group: self.action_group,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemovePermissionInputOperationOutputAlias = crate::operation::RemovePermission;
#[doc(hidden)]
pub type RemovePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemovePermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemovePermission`](crate::operation::RemovePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemovePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemovePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.profiling_group_name;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_52, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_53 = &_input.action_group;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_group",
                        details: "cannot be empty or unset",
                    })?;
            let action_group = aws_smithy_http::label::fmt_string(input_53, false);
            if action_group.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "action_group",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}/policy/{actionGroup}",
                profilingGroupName = profiling_group_name,
                actionGroup = action_group
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::RemovePermissionInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_54) = &_input.revision_id {
                query.push_kv("revisionId", &aws_smithy_http::query::fmt_string(&inner_54));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemovePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemovePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemovePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemovePermission",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
}

/// See [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
pub mod submit_feedback_input {
    /// A builder for [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) anomaly_instance_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FeedbackType>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profiling group that is associated with the analysis data.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group that is associated with the analysis data.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>The universally unique identifier (UUID) of the
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
        /// <code>AnomalyInstance</code>
        /// </a> object
        /// that is included in the analysis data.</p>
        pub fn anomaly_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_instance_id = Some(input.into());
            self
        }
        /// <p>The universally unique identifier (UUID) of the
        /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
        /// <code>AnomalyInstance</code>
        /// </a> object
        /// that is included in the analysis data.</p>
        pub fn set_anomaly_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_instance_id = input;
            self
        }
        /// <p>
        /// The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
        /// </p>
        pub fn r#type(mut self, input: crate::model::FeedbackType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FeedbackType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Optional feedback about this anomaly.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>Optional feedback about this anomaly.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SubmitFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SubmitFeedbackInput {
                profiling_group_name: self.profiling_group_name,
                anomaly_instance_id: self.anomaly_instance_id,
                r#type: self.r#type,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type SubmitFeedbackInputOperationOutputAlias = crate::operation::SubmitFeedback;
#[doc(hidden)]
pub type SubmitFeedbackInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubmitFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`SubmitFeedback`](crate::operation::SubmitFeedback)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SubmitFeedback,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubmitFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.profiling_group_name;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_55, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_56 = &_input.anomaly_instance_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "anomaly_instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let anomaly_instance_id = aws_smithy_http::label::fmt_string(input_56, false);
            if anomaly_instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "anomaly_instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/internal/profilingGroups/{profilingGroupName}/anomalies/{anomalyInstanceId}/feedback", profilingGroupName = profiling_group_name, anomalyInstanceId = anomaly_instance_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubmitFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubmitFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_submit_feedback(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SubmitFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SubmitFeedback",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
    pub fn builder() -> crate::input::submit_feedback_input::Builder {
        crate::input::submit_feedback_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that the tags are added to.
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that the tags are added to.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The list of tags that are added to the specified resource.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>
        /// The list of tags that are added to the specified resource.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.resource_arn;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_57, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that contains the tags to remove.
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that contains the tags to remove.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>
        /// A list of tag keys. Existing tags of resources with keys in this list are removed from
        /// the specified resource.
        /// </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>
        /// A list of tag keys. Existing tags of resources with keys in this list are removed from
        /// the specified resource.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.resource_arn;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_58, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_59) = &_input.tag_keys {
                for inner_60 in inner_59 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_60));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateProfilingGroupInput`](crate::input::UpdateProfilingGroupInput)
pub mod update_profiling_group_input {
    /// A builder for [`UpdateProfilingGroupInput`](crate::input::UpdateProfilingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiling_group_name: std::option::Option<std::string::String>,
        pub(crate) agent_orchestration_config:
            std::option::Option<crate::model::AgentOrchestrationConfig>,
    }
    impl Builder {
        /// <p>The name of the profiling group to update.</p>
        pub fn profiling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profiling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the profiling group to update.</p>
        pub fn set_profiling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profiling_group_name = input;
            self
        }
        /// <p>
        /// Specifies whether profiling is enabled or disabled for a profiling group.
        /// </p>
        pub fn agent_orchestration_config(
            mut self,
            input: crate::model::AgentOrchestrationConfig,
        ) -> Self {
            self.agent_orchestration_config = Some(input);
            self
        }
        /// <p>
        /// Specifies whether profiling is enabled or disabled for a profiling group.
        /// </p>
        pub fn set_agent_orchestration_config(
            mut self,
            input: std::option::Option<crate::model::AgentOrchestrationConfig>,
        ) -> Self {
            self.agent_orchestration_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProfilingGroupInput`](crate::input::UpdateProfilingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProfilingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProfilingGroupInput {
                profiling_group_name: self.profiling_group_name,
                agent_orchestration_config: self.agent_orchestration_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProfilingGroupInputOperationOutputAlias = crate::operation::UpdateProfilingGroup;
#[doc(hidden)]
pub type UpdateProfilingGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateProfilingGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProfilingGroup`](crate::operation::UpdateProfilingGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProfilingGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProfilingGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.profiling_group_name;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profiling_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let profiling_group_name = aws_smithy_http::label::fmt_string(input_61, false);
            if profiling_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profiling_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/profilingGroups/{profilingGroupName}",
                profilingGroupName = profiling_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProfilingGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProfilingGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_profiling_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProfilingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProfilingGroup",
            "codeguruprofiler",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProfilingGroupInput`](crate::input::UpdateProfilingGroupInput)
    pub fn builder() -> crate::input::update_profiling_group_input::Builder {
        crate::input::update_profiling_group_input::Builder::default()
    }
}

/// <p>The structure representing the SubmitFeedbackRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitFeedbackInput {
    /// <p>The name of the profiling group that is associated with the analysis data.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>The universally unique identifier (UUID) of the
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
    /// <code>AnomalyInstance</code>
    /// </a> object
    /// that is included in the analysis data.</p>
    pub anomaly_instance_id: std::option::Option<std::string::String>,
    /// <p>
    /// The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
    /// </p>
    pub r#type: std::option::Option<crate::model::FeedbackType>,
    /// <p>Optional feedback about this anomaly.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubmitFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitFeedbackInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("anomaly_instance_id", &self.anomaly_instance_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

/// <p>
///
/// The structure representing the <code>removePermissionRequest</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionInput {
    /// <p>The name of the profiling group.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// Specifies an action group that contains the permissions to remove from
    /// a profiling group's resource-based policy. One action group is supported, <code>agentPermissions</code>, which
    /// grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
    /// </p>
    pub action_group: std::option::Option<crate::model::ActionGroup>,
    /// <p>
    /// A universally unique identifier (UUID) for the revision of the resource-based policy from which
    /// you want to remove permissions.
    /// </p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemovePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("action_group", &self.action_group);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

/// <p>The structure representing the RemoveNotificationChannelRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveNotificationChannelInput {
    /// <p>The name of the profiling group we want to change notification configuration for.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>The id of the channel that we want to stop receiving notifications.</p>
    pub channel_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveNotificationChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveNotificationChannelInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}

/// <p>The structure representing the <code>putPermissionRequest</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPermissionInput {
    /// <p>The name of the profiling group to grant access to.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// Specifies an action group that contains permissions to add to
    /// a profiling group resource. One action group is supported, <code>agentPermissions</code>, which
    /// grants permission to perform actions required by the profiling agent, <code>ConfigureAgent</code>
    /// and <code>PostAgentProfile</code> permissions.
    /// </p>
    pub action_group: std::option::Option<crate::model::ActionGroup>,
    /// <p>
    /// A list ARNs for the roles and users you want to grant access to the profiling group.
    /// Wildcards are not are supported in the ARNs.
    /// </p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// A universally unique identifier (UUID) for the revision of the policy you
    /// are adding to the profiling group. Do not specify
    /// this when you add permissions to a profiling group for the first time. If a policy already exists on the
    /// profiling group, you must specify the <code>revisionId</code>.
    /// </p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPermissionInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("action_group", &self.action_group);
        formatter.field("principals", &self.principals);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

/// <p>The structure representing the postAgentProfileRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostAgentProfileInput {
    /// <p>
    /// The name of the profiling group with the aggregated profile that receives the
    /// submitted profiling data.
    /// </p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// The submitted profiling data.
    /// </p>
    pub agent_profile: std::option::Option<aws_smithy_types::Blob>,
    /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
    /// accidental submission of duplicate profiling data if there are failures and retries. </p>
    pub profile_token: std::option::Option<std::string::String>,
    /// <p>
    /// The format of the submitted profiling data. The format maps to the
    /// <code>Accept</code> and <code>Content-Type</code> headers of the
    /// HTTP request. You can specify one of the following:
    /// or the default .
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>application/json</code> — standard JSON format
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information,
    /// see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>.
    /// </p>
    /// </li>
    /// </ul>
    pub content_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PostAgentProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostAgentProfileInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("agent_profile", &self.agent_profile);
        formatter.field("profile_token", &self.profile_token);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}

/// <p>The structure representing the listProfileTimesRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileTimesInput {
    /// <p>The name of the profiling group.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>The start time of the time range from which to list the profiles.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time of the time range from which to list the profiles.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The aggregation period. This specifies the period during which an aggregation profile
    /// collects posted agent profiles for a profiling group. There are 3 valid values.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>P1D</code> — 1 day
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT1H</code> — 1 hour
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT5M</code> — 5 minutes
    /// </p>
    /// </li>
    /// </ul>
    pub period: std::option::Option<crate::model::AggregationPeriod>,
    /// <p>The order (ascending or descending by start time of the profile) to
    /// use when listing profiles. Defaults to <code>TIMESTAMP_DESCENDING</code>.
    /// </p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
    /// <p>The maximum number of profile time results returned by <code>ListProfileTimes</code>
    /// in paginated output. When this parameter is used, <code>ListProfileTimes</code> only returns
    /// <code>maxResults</code> results in a single page with a <code>nextToken</code> response
    /// element. The remaining results of the initial request
    /// can be seen by sending another <code>ListProfileTimes</code> request with the returned
    /// <code>nextToken</code> value.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>ListProfileTimes</code> request where <code>maxResults</code> was used and the results
    /// exceeded the value of that parameter. Pagination continues from the end of the previous results
    /// that returned the <code>nextToken</code> value.
    /// </p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve
    /// the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProfileTimesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileTimesInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("period", &self.period);
        formatter.field("order_by", &self.order_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The structure representing the ListFindingsReportsRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsReportsInput {
    /// <p>The name of the profiling group from which to search for analysis data.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code>
    /// request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
    /// Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
    /// </p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve
    /// the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of report results returned by <code>ListFindingsReports</code>
    /// in paginated output. When this parameter is used, <code>ListFindingsReports</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
    /// element. The remaining results of the initial request
    /// can be seen by sending another <code>ListFindingsReports</code> request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set
    /// to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
    /// analysis data is returned from smaller time windows (for example, one hour).</p>
    pub daily_reports_only: std::option::Option<bool>,
}
impl std::fmt::Debug for ListFindingsReportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsReportsInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("daily_reports_only", &self.daily_reports_only);
        formatter.finish()
    }
}

/// <p>The structure representing the GetRecommendationsRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecommendationsInput {
    /// <p>
    /// The name of the profiling group to get analysis data about.
    /// </p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The language used to provide analysis. Specify using a string that is one
    /// of the following <code>BCP 47</code> language codes.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>de-DE</code> - German, Germany
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>en-GB</code> - English, United Kingdom
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>en-US</code> - English, United States
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>es-ES</code> - Spanish, Spain
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>fr-FR</code> - French, France
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>it-IT</code> - Italian, Italy
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ja-JP</code> - Japanese, Japan
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ko-KR</code> - Korean, Republic of Korea
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pt-BR</code> - Portugese, Brazil
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>zh-CN</code> - Chinese, China
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>zh-TW</code> - Chinese, Taiwan
    /// </p>
    /// </li>
    /// </ul>
    pub locale: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecommendationsInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

/// <p>The structure representing the getProfileRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProfileInput {
    /// <p>The name of the profiling group to get.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>The start time of the profile to get. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
    ///
    /// <p>
    /// If you specify <code>startTime</code>, then you must also specify <code>period</code>
    /// or <code>endTime</code>, but not both.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// Used with <code>startTime</code> or <code>endTime</code> to specify
    /// the time range for the returned aggregated profile. Specify using
    /// the ISO 8601 format. For example, <code>P1DT1H1M1S</code>.
    /// </p>
    ///
    /// <p>
    /// To get the latest aggregated profile, specify only <code>period</code>.
    /// </p>
    pub period: std::option::Option<std::string::String>,
    /// <p>
    /// The end time of the requested profile. Specify using
    /// the ISO 8601 format. For example,
    /// 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    /// <p>
    /// If you specify <code>endTime</code>, then you must also specify <code>period</code>
    /// or <code>startTime</code>, but not both.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The maximum depth of the stacks in the code that is represented in
    /// the aggregated profile. For example, if CodeGuru Profiler finds a method <code>A</code>,
    /// which calls method <code>B</code>, which calls method <code>C</code>, which
    /// calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
    /// set to 2, then the aggregated profile contains representations of methods <code>A</code>
    /// and <code>B</code>.
    /// </p>
    pub max_depth: std::option::Option<i32>,
    /// <p>
    /// The format of the returned profiling data. The format maps to the
    /// <code>Accept</code> and <code>Content-Type</code> headers of the
    /// HTTP request. You can specify one of the following:
    /// or the default .
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>application/json</code> — standard JSON format
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information,
    /// see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>.
    /// </p>
    /// </li>
    /// </ul>
    pub accept: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProfileInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("period", &self.period);
        formatter.field("end_time", &self.end_time);
        formatter.field("max_depth", &self.max_depth);
        formatter.field("accept", &self.accept);
        formatter.finish()
    }
}

/// <p>
/// The structure representing the <code>getPolicyRequest</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyInput {
    /// <p>The name of the profiling group.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.finish()
    }
}

/// <p>The structure representing the GetNotificationConfigurationRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNotificationConfigurationInput {
    /// <p>The name of the profiling group we want to get the notification configuration for.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetNotificationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNotificationConfigurationInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.finish()
    }
}

/// <p>The structure representing the configureAgentRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigureAgentInput {
    /// <p>
    /// The name of the profiling group for which the configured agent is collecting profiling data.
    /// </p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p> A universally unique identifier (UUID) for a profiling instance. For example, if the
    /// profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS
    /// Fargate container, it is the container's task ID. </p>
    pub fleet_instance_id: std::option::Option<std::string::String>,
    /// <p> Metadata captured about the compute platform the agent is running on. It includes
    /// information about sampling and reporting. The valid fields are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AGENT_ID</code> - The ID for an agent instance.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda function times out.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations of a Lambda function.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda invocation.
    /// </p>
    /// </li>
    /// </ul>
    pub metadata: std::option::Option<
        std::collections::HashMap<crate::model::MetadataField, std::string::String>,
    >,
}
impl std::fmt::Debug for ConfigureAgentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigureAgentInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("fleet_instance_id", &self.fleet_instance_id);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}

/// <p>The structure representing the BatchGetFrameMetricDataRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetFrameMetricDataInput {
    /// <p>
    /// The name of the profiling group associated with the
    /// the frame metrics used to return the time series values.
    /// </p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// The start time of the time period for the frame metrics used to return the time series values.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The end time of the time period for the returned time series values.
    /// This is specified
    /// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
    /// millisecond past June 1, 2020 1:15:02 PM UTC.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The duration of the frame metrics used to return the time series values.
    /// Specify using the ISO 8601 format. The maximum period duration
    /// is one day (<code>PT24H</code> or <code>P1D</code>).
    /// </p>
    pub period: std::option::Option<std::string::String>,
    /// <p>The requested resolution of time steps for the returned time series of values.
    /// If the requested target resolution is not available due to data not being retained we provide a best effort
    /// result by falling back to the most granular available resolution after the target resolution.
    /// There are 3 valid values.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>P1D</code> — 1 day
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT1H</code> — 1 hour
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PT5M</code> — 5 minutes
    /// </p>
    /// </li>
    /// </ul>
    pub target_resolution: std::option::Option<crate::model::AggregationPeriod>,
    /// <p>
    /// The details of the metrics that are used to request a time series of values. The metric includes
    /// the name of the frame, the aggregation type to calculate the metric value for the
    /// frame, and the thread states to use to get the count for the metric value of the frame.</p>
    pub frame_metrics: std::option::Option<std::vec::Vec<crate::model::FrameMetric>>,
}
impl std::fmt::Debug for BatchGetFrameMetricDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetFrameMetricDataInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("period", &self.period);
        formatter.field("target_resolution", &self.target_resolution);
        formatter.field("frame_metrics", &self.frame_metrics);
        formatter.finish()
    }
}

/// <p>The structure representing the AddNotificationChannelsRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddNotificationChannelsInput {
    /// <p>The name of the profiling group that we are setting up notifications for.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>One or 2 channels to report to when anomalies are detected.</p>
    pub channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
}
impl std::fmt::Debug for AddNotificationChannelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddNotificationChannelsInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("channels", &self.channels);
        formatter.finish()
    }
}

/// <p>The structure representing the listProfilingGroupsRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfilingGroupsInput {
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>ListProfilingGroups</code> request where <code>maxResults</code> was used and the results
    /// exceeded the value of that parameter. Pagination continues from the end of the previous results
    /// that returned the <code>nextToken</code> value.
    /// </p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve
    /// the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of profiling groups results returned by <code>ListProfilingGroups</code>
    /// in paginated output. When this parameter is used, <code>ListProfilingGroups</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
    /// element. The remaining results of the initial request
    /// can be seen by sending another <code>ListProfilingGroups</code> request with the returned
    /// <code>nextToken</code> value.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>,
    /// then a list of
    /// <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
    /// <code>ProfilingGroupDescription</code>
    /// </a> objects
    /// that contain detailed information about profiling groups is returned. If <code>false</code>, then
    /// a list of profiling group names is returned.</p>
    pub include_description: std::option::Option<bool>,
}
impl std::fmt::Debug for ListProfilingGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfilingGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("include_description", &self.include_description);
        formatter.finish()
    }
}

/// <p>The structure representing the createProfiliingGroupRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProfilingGroupInput {
    /// <p>The name of the profiling group to create.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// The compute platform of the profiling group. Use <code>AWSLambda</code> if your application
    /// runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that
    /// is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform.
    /// If not specified, <code>Default</code> is used.         
    /// </p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
    /// <p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
    /// accidental creation of duplicate profiling groups if there are failures and retries. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>
    /// Specifies whether profiling is enabled or disabled for the created profiling group.
    /// </p>
    pub agent_orchestration_config: std::option::Option<crate::model::AgentOrchestrationConfig>,
    /// <p>
    /// A list of tags to add to the created profiling group.
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateProfilingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProfilingGroupInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field("compute_platform", &self.compute_platform);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "agent_orchestration_config",
            &self.agent_orchestration_config,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The structure representing the deleteProfilingGroupRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfilingGroupInput {
    /// <p>The name of the profiling group to delete.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteProfilingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfilingGroupInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.finish()
    }
}

/// <p>The structure representing the updateProfilingGroupRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProfilingGroupInput {
    /// <p>The name of the profiling group to update.</p>
    pub profiling_group_name: std::option::Option<std::string::String>,
    /// <p>
    /// Specifies whether profiling is enabled or disabled for a profiling group.
    /// </p>
    pub agent_orchestration_config: std::option::Option<crate::model::AgentOrchestrationConfig>,
}
impl std::fmt::Debug for UpdateProfilingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProfilingGroupInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.field(
            "agent_orchestration_config",
            &self.agent_orchestration_config,
        );
        formatter.finish()
    }
}

/// <p>The structure representing the describeProfilingGroupRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProfilingGroupInput {
    /// <p>
    /// The name of the profiling group to get information about.
    /// </p>
    pub profiling_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeProfilingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProfilingGroupInput");
        formatter.field("profiling_group_name", &self.profiling_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>
    /// The Amazon Resource Name (ARN) of the resource that contains the tags to remove.
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>
    /// A list of tag keys. Existing tags of resources with keys in this list are removed from
    /// the specified resource.
    /// </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>
    /// The Amazon Resource Name (ARN) of the resource that the tags are added to.
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The list of tags that are added to the specified resource.
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>
    /// The Amazon Resource Name (ARN) of the resource that contains the tags to return.
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p>The structure representing the GetFindingsReportAccountSummaryRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsReportAccountSummaryInput {
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>GetFindingsReportAccountSummary</code>
    /// request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
    /// Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
    /// </p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve
    /// the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code> GetFindingsReportAccountSummary</code> in paginated output.
    /// When this parameter is used, <code>GetFindingsReportAccountSummary</code> only returns <code>maxResults</code>
    /// results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial
    /// request can be seen by sending another <code>GetFindingsReportAccountSummary</code> request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set
    /// to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
    /// analysis data is returned from smaller time windows (for example, one hour).</p>
    pub daily_reports_only: std::option::Option<bool>,
}
impl std::fmt::Debug for GetFindingsReportAccountSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsReportAccountSummaryInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("daily_reports_only", &self.daily_reports_only);
        formatter.finish()
    }
}
