// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsToOnPremisesInstancesInput`](crate::input::AddTagsToOnPremisesInstancesInput)
pub mod add_tags_to_on_premises_instances_input {
    /// A builder for [`AddTagsToOnPremisesInstancesInput`](crate::input::AddTagsToOnPremisesInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs to add to the on-premises instances.</p>
        /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs to add to the on-premises instances.</p>
        /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances to which to add tags.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>The names of the on-premises instances to which to add tags.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToOnPremisesInstancesInput`](crate::input::AddTagsToOnPremisesInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToOnPremisesInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToOnPremisesInstancesInput {
                tags: self.tags,
                instance_names: self.instance_names,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToOnPremisesInstancesInputOperationOutputAlias =
    crate::operation::AddTagsToOnPremisesInstances;
#[doc(hidden)]
pub type AddTagsToOnPremisesInstancesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AddTagsToOnPremisesInstancesInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToOnPremisesInstances`](crate::operation::AddTagsToOnPremisesInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToOnPremisesInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToOnPremisesInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToOnPremisesInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToOnPremisesInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.AddTagsToOnPremisesInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_on_premises_instances(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToOnPremisesInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToOnPremisesInstances",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToOnPremisesInstancesInput`](crate::input::AddTagsToOnPremisesInstancesInput)
    pub fn builder() -> crate::input::add_tags_to_on_premises_instances_input::Builder {
        crate::input::add_tags_to_on_premises_instances_input::Builder::default()
    }
}

/// See [`BatchGetApplicationRevisionsInput`](crate::input::BatchGetApplicationRevisionsInput)
pub mod batch_get_application_revisions_input {
    /// A builder for [`BatchGetApplicationRevisionsInput`](crate::input::BatchGetApplicationRevisionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) revisions: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application about which to get revision information.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application about which to get revision information.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Appends an item to `revisions`.
        ///
        /// To override the contents of this collection use [`set_revisions`](Self::set_revisions).
        ///
        /// <p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>
        pub fn revisions(mut self, input: crate::model::RevisionLocation) -> Self {
            let mut v = self.revisions.unwrap_or_default();
            v.push(input);
            self.revisions = Some(v);
            self
        }
        /// <p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>
        pub fn set_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
        ) -> Self {
            self.revisions = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetApplicationRevisionsInput`](crate::input::BatchGetApplicationRevisionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetApplicationRevisionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetApplicationRevisionsInput {
                application_name: self.application_name,
                revisions: self.revisions,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetApplicationRevisionsInputOperationOutputAlias =
    crate::operation::BatchGetApplicationRevisions;
#[doc(hidden)]
pub type BatchGetApplicationRevisionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetApplicationRevisionsInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetApplicationRevisions`](crate::operation::BatchGetApplicationRevisions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetApplicationRevisions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetApplicationRevisionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetApplicationRevisionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetApplicationRevisionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.BatchGetApplicationRevisions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_application_revisions(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetApplicationRevisions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetApplicationRevisions",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetApplicationRevisionsInput`](crate::input::BatchGetApplicationRevisionsInput)
    pub fn builder() -> crate::input::batch_get_application_revisions_input::Builder {
        crate::input::batch_get_application_revisions_input::Builder::default()
    }
}

/// See [`BatchGetApplicationsInput`](crate::input::BatchGetApplicationsInput)
pub mod batch_get_applications_input {
    /// A builder for [`BatchGetApplicationsInput`](crate::input::BatchGetApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `application_names`.
        ///
        /// To override the contents of this collection use [`set_application_names`](Self::set_application_names).
        ///
        /// <p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>
        pub fn application_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.application_names.unwrap_or_default();
            v.push(input.into());
            self.application_names = Some(v);
            self
        }
        /// <p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>
        pub fn set_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.application_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetApplicationsInput`](crate::input::BatchGetApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetApplicationsInput {
                application_names: self.application_names,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetApplicationsInputOperationOutputAlias = crate::operation::BatchGetApplications;
#[doc(hidden)]
pub type BatchGetApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetApplications`](crate::operation::BatchGetApplications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetApplicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetApplicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetApplicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.BatchGetApplications",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_applications(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetApplications",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetApplicationsInput`](crate::input::BatchGetApplicationsInput)
    pub fn builder() -> crate::input::batch_get_applications_input::Builder {
        crate::input::batch_get_applications_input::Builder::default()
    }
}

/// See [`BatchGetDeploymentGroupsInput`](crate::input::BatchGetDeploymentGroupsInput)
pub mod batch_get_deployment_groups_input {
    /// A builder for [`BatchGetDeploymentGroupsInput`](crate::input::BatchGetDeploymentGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Appends an item to `deployment_group_names`.
        ///
        /// To override the contents of this collection use [`set_deployment_group_names`](Self::set_deployment_group_names).
        ///
        /// <p>The names of the deployment groups.</p>
        pub fn deployment_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployment_group_names.unwrap_or_default();
            v.push(input.into());
            self.deployment_group_names = Some(v);
            self
        }
        /// <p>The names of the deployment groups.</p>
        pub fn set_deployment_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployment_group_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentGroupsInput`](crate::input::BatchGetDeploymentGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetDeploymentGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetDeploymentGroupsInput {
                application_name: self.application_name,
                deployment_group_names: self.deployment_group_names,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetDeploymentGroupsInputOperationOutputAlias =
    crate::operation::BatchGetDeploymentGroups;
#[doc(hidden)]
pub type BatchGetDeploymentGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetDeploymentGroupsInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetDeploymentGroups`](crate::operation::BatchGetDeploymentGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetDeploymentGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetDeploymentGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetDeploymentGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetDeploymentGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.BatchGetDeploymentGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_deployment_groups(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetDeploymentGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetDeploymentGroups",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentGroupsInput`](crate::input::BatchGetDeploymentGroupsInput)
    pub fn builder() -> crate::input::batch_get_deployment_groups_input::Builder {
        crate::input::batch_get_deployment_groups_input::Builder::default()
    }
}

/// See [`BatchGetDeploymentInstancesInput`](crate::input::BatchGetDeploymentInstancesInput)
pub mod batch_get_deployment_instances_input {
    /// A builder for [`BatchGetDeploymentInstancesInput`](crate::input::BatchGetDeploymentInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentInstancesInput`](crate::input::BatchGetDeploymentInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetDeploymentInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetDeploymentInstancesInput {
                deployment_id: self.deployment_id,
                instance_ids: self.instance_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetDeploymentInstancesInputOperationOutputAlias =
    crate::operation::BatchGetDeploymentInstances;
#[doc(hidden)]
pub type BatchGetDeploymentInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetDeploymentInstancesInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetDeploymentInstances`](crate::operation::BatchGetDeploymentInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetDeploymentInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetDeploymentInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetDeploymentInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetDeploymentInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.BatchGetDeploymentInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_deployment_instances(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetDeploymentInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetDeploymentInstances",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentInstancesInput`](crate::input::BatchGetDeploymentInstancesInput)
    pub fn builder() -> crate::input::batch_get_deployment_instances_input::Builder {
        crate::input::batch_get_deployment_instances_input::Builder::default()
    }
}

/// See [`BatchGetDeploymentsInput`](crate::input::BatchGetDeploymentsInput)
pub mod batch_get_deployments_input {
    /// A builder for [`BatchGetDeploymentsInput`](crate::input::BatchGetDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `deployment_ids`.
        ///
        /// To override the contents of this collection use [`set_deployment_ids`](Self::set_deployment_ids).
        ///
        /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>
        pub fn deployment_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployment_ids.unwrap_or_default();
            v.push(input.into());
            self.deployment_ids = Some(v);
            self
        }
        /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>
        pub fn set_deployment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployment_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentsInput`](crate::input::BatchGetDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetDeploymentsInput {
                deployment_ids: self.deployment_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetDeploymentsInputOperationOutputAlias = crate::operation::BatchGetDeployments;
#[doc(hidden)]
pub type BatchGetDeploymentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetDeployments`](crate::operation::BatchGetDeployments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetDeployments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.BatchGetDeployments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_deployments(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetDeployments",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentsInput`](crate::input::BatchGetDeploymentsInput)
    pub fn builder() -> crate::input::batch_get_deployments_input::Builder {
        crate::input::batch_get_deployments_input::Builder::default()
    }
}

/// See [`BatchGetDeploymentTargetsInput`](crate::input::BatchGetDeploymentTargetsInput)
pub mod batch_get_deployment_targets_input {
    /// A builder for [`BatchGetDeploymentTargetsInput`](crate::input::BatchGetDeploymentTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) target_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Appends an item to `target_ids`.
        ///
        /// To override the contents of this collection use [`set_target_ids`](Self::set_target_ids).
        ///
        /// <p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>
        /// <ul>
        /// <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. Their target type is <code>ecsTarget</code>. </p> </li>
        /// <li> <p> For deployments that are deployed with AWS CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li>
        /// </ul>
        pub fn target_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_ids.unwrap_or_default();
            v.push(input.into());
            self.target_ids = Some(v);
            self
        }
        /// <p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>
        /// <ul>
        /// <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. Their target type is <code>ecsTarget</code>. </p> </li>
        /// <li> <p> For deployments that are deployed with AWS CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li>
        /// </ul>
        pub fn set_target_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentTargetsInput`](crate::input::BatchGetDeploymentTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetDeploymentTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetDeploymentTargetsInput {
                deployment_id: self.deployment_id,
                target_ids: self.target_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetDeploymentTargetsInputOperationOutputAlias =
    crate::operation::BatchGetDeploymentTargets;
#[doc(hidden)]
pub type BatchGetDeploymentTargetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetDeploymentTargetsInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetDeploymentTargets`](crate::operation::BatchGetDeploymentTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetDeploymentTargets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetDeploymentTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetDeploymentTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetDeploymentTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.BatchGetDeploymentTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_deployment_targets(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetDeploymentTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetDeploymentTargets",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentTargetsInput`](crate::input::BatchGetDeploymentTargetsInput)
    pub fn builder() -> crate::input::batch_get_deployment_targets_input::Builder {
        crate::input::batch_get_deployment_targets_input::Builder::default()
    }
}

/// See [`BatchGetOnPremisesInstancesInput`](crate::input::BatchGetOnPremisesInstancesInput)
pub mod batch_get_on_premises_instances_input {
    /// A builder for [`BatchGetOnPremisesInstancesInput`](crate::input::BatchGetOnPremisesInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetOnPremisesInstancesInput`](crate::input::BatchGetOnPremisesInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetOnPremisesInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetOnPremisesInstancesInput {
                instance_names: self.instance_names,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetOnPremisesInstancesInputOperationOutputAlias =
    crate::operation::BatchGetOnPremisesInstances;
#[doc(hidden)]
pub type BatchGetOnPremisesInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetOnPremisesInstancesInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetOnPremisesInstances`](crate::operation::BatchGetOnPremisesInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetOnPremisesInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetOnPremisesInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetOnPremisesInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetOnPremisesInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.BatchGetOnPremisesInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_on_premises_instances(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetOnPremisesInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetOnPremisesInstances",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetOnPremisesInstancesInput`](crate::input::BatchGetOnPremisesInstancesInput)
    pub fn builder() -> crate::input::batch_get_on_premises_instances_input::Builder {
        crate::input::batch_get_on_premises_instances_input::Builder::default()
    }
}

/// See [`ContinueDeploymentInput`](crate::input::ContinueDeploymentInput)
pub mod continue_deployment_input {
    /// A builder for [`ContinueDeploymentInput`](crate::input::ContinueDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_wait_type: std::option::Option<crate::model::DeploymentWaitType>,
    }
    impl Builder {
        /// <p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>
        pub fn deployment_wait_type(mut self, input: crate::model::DeploymentWaitType) -> Self {
            self.deployment_wait_type = Some(input);
            self
        }
        /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>
        pub fn set_deployment_wait_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentWaitType>,
        ) -> Self {
            self.deployment_wait_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinueDeploymentInput`](crate::input::ContinueDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ContinueDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ContinueDeploymentInput {
                deployment_id: self.deployment_id,
                deployment_wait_type: self.deployment_wait_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ContinueDeploymentInputOperationOutputAlias = crate::operation::ContinueDeployment;
#[doc(hidden)]
pub type ContinueDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ContinueDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`ContinueDeployment`](crate::operation::ContinueDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ContinueDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ContinueDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ContinueDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ContinueDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ContinueDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_continue_deployment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ContinueDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ContinueDeployment",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ContinueDeploymentInput`](crate::input::ContinueDeploymentInput)
    pub fn builder() -> crate::input::continue_deployment_input::Builder {
        crate::input::continue_deployment_input::Builder::default()
    }
}

/// See [`CreateApplicationInput`](crate::input::CreateApplicationInput)
pub mod create_application_input {
    /// A builder for [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInput`](crate::input::CreateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInput {
                application_name: self.application_name,
                compute_platform: self.compute_platform,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInputOperationOutputAlias = crate::operation::CreateApplication;
#[doc(hidden)]
pub type CreateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplication`](crate::operation::CreateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.CreateApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_application(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplication",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
}

/// See [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
pub mod create_deployment_input {
    /// A builder for [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_name: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<crate::model::RevisionLocation>,
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ignore_application_stop_failures: std::option::Option<bool>,
        pub(crate) target_instances: std::option::Option<crate::model::TargetInstances>,
        pub(crate) auto_rollback_configuration:
            std::option::Option<crate::model::AutoRollbackConfiguration>,
        pub(crate) update_outdated_instances_only: std::option::Option<bool>,
        pub(crate) file_exists_behavior: std::option::Option<crate::model::FileExistsBehavior>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the deployment group.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_name = Some(input.into());
            self
        }
        /// <p>The name of the deployment group.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_name = input;
            self
        }
        /// <p> The type and location of the revision to deploy. </p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p> The type and location of the revision to deploy. </p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.revision = input;
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        /// <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        /// <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
        /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn ignore_application_stop_failures(mut self, input: bool) -> Self {
            self.ignore_application_stop_failures = Some(input);
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
        /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn set_ignore_application_stop_failures(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.ignore_application_stop_failures = input;
            self
        }
        /// <p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>
        pub fn target_instances(mut self, input: crate::model::TargetInstances) -> Self {
            self.target_instances = Some(input);
            self
        }
        /// <p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>
        pub fn set_target_instances(
            mut self,
            input: std::option::Option<crate::model::TargetInstances>,
        ) -> Self {
            self.target_instances = input;
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment is created.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.auto_rollback_configuration = Some(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment is created.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.auto_rollback_configuration = input;
            self
        }
        /// <p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>
        pub fn update_outdated_instances_only(mut self, input: bool) -> Self {
            self.update_outdated_instances_only = Some(input);
            self
        }
        /// <p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>
        pub fn set_update_outdated_instances_only(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.update_outdated_instances_only = input;
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
        /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p>
        /// <ul>
        /// <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
        /// <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
        /// <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
        /// </ul>
        pub fn file_exists_behavior(mut self, input: crate::model::FileExistsBehavior) -> Self {
            self.file_exists_behavior = Some(input);
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
        /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p>
        /// <ul>
        /// <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
        /// <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
        /// <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
        /// </ul>
        pub fn set_file_exists_behavior(
            mut self,
            input: std::option::Option<crate::model::FileExistsBehavior>,
        ) -> Self {
            self.file_exists_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentInput {
                application_name: self.application_name,
                deployment_group_name: self.deployment_group_name,
                revision: self.revision,
                deployment_config_name: self.deployment_config_name,
                description: self.description,
                ignore_application_stop_failures: self
                    .ignore_application_stop_failures
                    .unwrap_or_default(),
                target_instances: self.target_instances,
                auto_rollback_configuration: self.auto_rollback_configuration,
                update_outdated_instances_only: self
                    .update_outdated_instances_only
                    .unwrap_or_default(),
                file_exists_behavior: self.file_exists_behavior,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentInputOperationOutputAlias = crate::operation::CreateDeployment;
#[doc(hidden)]
pub type CreateDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeployment`](crate::operation::CreateDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.CreateDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deployment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeployment",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
}

/// See [`CreateDeploymentConfigInput`](crate::input::CreateDeploymentConfigInput)
pub mod create_deployment_config_input {
    /// A builder for [`CreateDeploymentConfigInput`](crate::input::CreateDeploymentConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
        pub(crate) minimum_healthy_hosts: std::option::Option<crate::model::MinimumHealthyHosts>,
        pub(crate) traffic_routing_config: std::option::Option<crate::model::TrafficRoutingConfig>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
    }
    impl Builder {
        /// <p>The name of the deployment configuration to create.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>The name of the deployment configuration to create.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// <p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p>
        /// <p>The type parameter takes either of the following values:</p>
        /// <ul>
        /// <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li>
        /// <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li>
        /// </ul>
        /// <p>The value parameter takes an integer.</p>
        /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>
        pub fn minimum_healthy_hosts(mut self, input: crate::model::MinimumHealthyHosts) -> Self {
            self.minimum_healthy_hosts = Some(input);
            self
        }
        /// <p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p>
        /// <p>The type parameter takes either of the following values:</p>
        /// <ul>
        /// <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li>
        /// <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li>
        /// </ul>
        /// <p>The value parameter takes an integer.</p>
        /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>
        pub fn set_minimum_healthy_hosts(
            mut self,
            input: std::option::Option<crate::model::MinimumHealthyHosts>,
        ) -> Self {
            self.minimum_healthy_hosts = input;
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed.</p>
        pub fn traffic_routing_config(mut self, input: crate::model::TrafficRoutingConfig) -> Self {
            self.traffic_routing_config = Some(input);
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed.</p>
        pub fn set_traffic_routing_config(
            mut self,
            input: std::option::Option<crate::model::TrafficRoutingConfig>,
        ) -> Self {
            self.traffic_routing_config = input;
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentConfigInput`](crate::input::CreateDeploymentConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentConfigInput {
                deployment_config_name: self.deployment_config_name,
                minimum_healthy_hosts: self.minimum_healthy_hosts,
                traffic_routing_config: self.traffic_routing_config,
                compute_platform: self.compute_platform,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentConfigInputOperationOutputAlias = crate::operation::CreateDeploymentConfig;
#[doc(hidden)]
pub type CreateDeploymentConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeploymentConfig`](crate::operation::CreateDeploymentConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeploymentConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.CreateDeploymentConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deployment_config(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeploymentConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeploymentConfig",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentConfigInput`](crate::input::CreateDeploymentConfigInput)
    pub fn builder() -> crate::input::create_deployment_config_input::Builder {
        crate::input::create_deployment_config_input::Builder::default()
    }
}

/// See [`CreateDeploymentGroupInput`](crate::input::CreateDeploymentGroupInput)
pub mod create_deployment_group_input {
    /// A builder for [`CreateDeploymentGroupInput`](crate::input::CreateDeploymentGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_name: std::option::Option<std::string::String>,
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
        pub(crate) ec2_tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        pub(crate) on_premises_instance_tag_filters:
            std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        pub(crate) auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) trigger_configurations:
            std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        pub(crate) alarm_configuration: std::option::Option<crate::model::AlarmConfiguration>,
        pub(crate) auto_rollback_configuration:
            std::option::Option<crate::model::AutoRollbackConfiguration>,
        pub(crate) outdated_instances_strategy:
            std::option::Option<crate::model::OutdatedInstancesStrategy>,
        pub(crate) deployment_style: std::option::Option<crate::model::DeploymentStyle>,
        pub(crate) blue_green_deployment_configuration:
            std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        pub(crate) load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
        pub(crate) ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
        pub(crate) ecs_services: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        pub(crate) on_premises_tag_set: std::option::Option<crate::model::OnPremisesTagSet>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of a new deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_name = Some(input.into());
            self
        }
        /// <p>The name of a new deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_name = input;
            self
        }
        /// <p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p>
        /// <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.</p>
        /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p>
        /// <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.</p>
        /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// Appends an item to `ec2_tag_filters`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_filters`](Self::set_ec2_tag_filters).
        ///
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
        pub fn ec2_tag_filters(mut self, input: crate::model::Ec2TagFilter) -> Self {
            let mut v = self.ec2_tag_filters.unwrap_or_default();
            v.push(input);
            self.ec2_tag_filters = Some(v);
            self
        }
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
        pub fn set_ec2_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.ec2_tag_filters = input;
            self
        }
        /// Appends an item to `on_premises_instance_tag_filters`.
        ///
        /// To override the contents of this collection use [`set_on_premises_instance_tag_filters`](Self::set_on_premises_instance_tag_filters).
        ///
        /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>
        pub fn on_premises_instance_tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            let mut v = self.on_premises_instance_tag_filters.unwrap_or_default();
            v.push(input);
            self.on_premises_instance_tag_filters = Some(v);
            self
        }
        /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>
        pub fn set_on_premises_instance_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.on_premises_instance_tag_filters = input;
            self
        }
        /// Appends an item to `auto_scaling_groups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
        pub fn auto_scaling_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_scaling_groups.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_groups = Some(v);
            self
        }
        /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_scaling_groups = input;
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// Appends an item to `trigger_configurations`.
        ///
        /// To override the contents of this collection use [`set_trigger_configurations`](Self::set_trigger_configurations).
        ///
        /// <p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn trigger_configurations(mut self, input: crate::model::TriggerConfig) -> Self {
            let mut v = self.trigger_configurations.unwrap_or_default();
            v.push(input);
            self.trigger_configurations = Some(v);
            self
        }
        /// <p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_trigger_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        ) -> Self {
            self.trigger_configurations = input;
            self
        }
        /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>
        pub fn alarm_configuration(mut self, input: crate::model::AlarmConfiguration) -> Self {
            self.alarm_configuration = Some(input);
            self
        }
        /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>
        pub fn set_alarm_configuration(
            mut self,
            input: std::option::Option<crate::model::AlarmConfiguration>,
        ) -> Self {
            self.alarm_configuration = input;
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.auto_rollback_configuration = Some(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.auto_rollback_configuration = input;
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn outdated_instances_strategy(
            mut self,
            input: crate::model::OutdatedInstancesStrategy,
        ) -> Self {
            self.outdated_instances_strategy = Some(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn set_outdated_instances_strategy(
            mut self,
            input: std::option::Option<crate::model::OutdatedInstancesStrategy>,
        ) -> Self {
            self.outdated_instances_strategy = input;
            self
        }
        /// <p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, input: crate::model::DeploymentStyle) -> Self {
            self.deployment_style = Some(input);
            self
        }
        /// <p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.deployment_style = input;
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            input: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.blue_green_deployment_configuration = Some(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.blue_green_deployment_configuration = input;
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn load_balancer_info(mut self, input: crate::model::LoadBalancerInfo) -> Self {
            self.load_balancer_info = Some(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.load_balancer_info = input;
            self
        }
        /// <p>Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>
        pub fn ec2_tag_set(mut self, input: crate::model::Ec2TagSet) -> Self {
            self.ec2_tag_set = Some(input);
            self
        }
        /// <p>Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.ec2_tag_set = input;
            self
        }
        /// Appends an item to `ecs_services`.
        ///
        /// To override the contents of this collection use [`set_ecs_services`](Self::set_ecs_services).
        ///
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn ecs_services(mut self, input: crate::model::EcsService) -> Self {
            let mut v = self.ecs_services.unwrap_or_default();
            v.push(input);
            self.ecs_services = Some(v);
            self
        }
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn set_ecs_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        ) -> Self {
            self.ecs_services = input;
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
        pub fn on_premises_tag_set(mut self, input: crate::model::OnPremisesTagSet) -> Self {
            self.on_premises_tag_set = Some(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
        pub fn set_on_premises_tag_set(
            mut self,
            input: std::option::Option<crate::model::OnPremisesTagSet>,
        ) -> Self {
            self.on_premises_tag_set = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentGroupInput`](crate::input::CreateDeploymentGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentGroupInput {
                application_name: self.application_name,
                deployment_group_name: self.deployment_group_name,
                deployment_config_name: self.deployment_config_name,
                ec2_tag_filters: self.ec2_tag_filters,
                on_premises_instance_tag_filters: self.on_premises_instance_tag_filters,
                auto_scaling_groups: self.auto_scaling_groups,
                service_role_arn: self.service_role_arn,
                trigger_configurations: self.trigger_configurations,
                alarm_configuration: self.alarm_configuration,
                auto_rollback_configuration: self.auto_rollback_configuration,
                outdated_instances_strategy: self.outdated_instances_strategy,
                deployment_style: self.deployment_style,
                blue_green_deployment_configuration: self.blue_green_deployment_configuration,
                load_balancer_info: self.load_balancer_info,
                ec2_tag_set: self.ec2_tag_set,
                ecs_services: self.ecs_services,
                on_premises_tag_set: self.on_premises_tag_set,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentGroupInputOperationOutputAlias = crate::operation::CreateDeploymentGroup;
#[doc(hidden)]
pub type CreateDeploymentGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeploymentGroup`](crate::operation::CreateDeploymentGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeploymentGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.CreateDeploymentGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deployment_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeploymentGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeploymentGroup",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentGroupInput`](crate::input::CreateDeploymentGroupInput)
    pub fn builder() -> crate::input::create_deployment_group_input::Builder {
        crate::input::create_deployment_group_input::Builder::default()
    }
}

/// See [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
pub mod delete_application_input {
    /// A builder for [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationInput {
                application_name: self.application_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputOperationOutputAlias = crate::operation::DeleteApplication;
#[doc(hidden)]
pub type DeleteApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplication`](crate::operation::DeleteApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.DeleteApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_application(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplication",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
}

/// See [`DeleteDeploymentConfigInput`](crate::input::DeleteDeploymentConfigInput)
pub mod delete_deployment_config_input {
    /// A builder for [`DeleteDeploymentConfigInput`](crate::input::DeleteDeploymentConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeploymentConfigInput`](crate::input::DeleteDeploymentConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeploymentConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeploymentConfigInput {
                deployment_config_name: self.deployment_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeploymentConfigInputOperationOutputAlias = crate::operation::DeleteDeploymentConfig;
#[doc(hidden)]
pub type DeleteDeploymentConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDeploymentConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeploymentConfig`](crate::operation::DeleteDeploymentConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeploymentConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeploymentConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeploymentConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeploymentConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.DeleteDeploymentConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_deployment_config(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeploymentConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeploymentConfig",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentConfigInput`](crate::input::DeleteDeploymentConfigInput)
    pub fn builder() -> crate::input::delete_deployment_config_input::Builder {
        crate::input::delete_deployment_config_input::Builder::default()
    }
}

/// See [`DeleteDeploymentGroupInput`](crate::input::DeleteDeploymentGroupInput)
pub mod delete_deployment_group_input {
    /// A builder for [`DeleteDeploymentGroupInput`](crate::input::DeleteDeploymentGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_name = Some(input.into());
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeploymentGroupInput`](crate::input::DeleteDeploymentGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeploymentGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeploymentGroupInput {
                application_name: self.application_name,
                deployment_group_name: self.deployment_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeploymentGroupInputOperationOutputAlias = crate::operation::DeleteDeploymentGroup;
#[doc(hidden)]
pub type DeleteDeploymentGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDeploymentGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeploymentGroup`](crate::operation::DeleteDeploymentGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeploymentGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeploymentGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeploymentGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeploymentGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.DeleteDeploymentGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_deployment_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeploymentGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeploymentGroup",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentGroupInput`](crate::input::DeleteDeploymentGroupInput)
    pub fn builder() -> crate::input::delete_deployment_group_input::Builder {
        crate::input::delete_deployment_group_input::Builder::default()
    }
}

/// See [`DeleteGitHubAccountTokenInput`](crate::input::DeleteGitHubAccountTokenInput)
pub mod delete_git_hub_account_token_input {
    /// A builder for [`DeleteGitHubAccountTokenInput`](crate::input::DeleteGitHubAccountTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the GitHub account connection to delete.</p>
        pub fn token_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_name = Some(input.into());
            self
        }
        /// <p>The name of the GitHub account connection to delete.</p>
        pub fn set_token_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGitHubAccountTokenInput`](crate::input::DeleteGitHubAccountTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGitHubAccountTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGitHubAccountTokenInput {
                token_name: self.token_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGitHubAccountTokenInputOperationOutputAlias =
    crate::operation::DeleteGitHubAccountToken;
#[doc(hidden)]
pub type DeleteGitHubAccountTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGitHubAccountTokenInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGitHubAccountToken`](crate::operation::DeleteGitHubAccountToken)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGitHubAccountToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGitHubAccountTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGitHubAccountTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGitHubAccountTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.DeleteGitHubAccountToken",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_git_hub_account_token(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGitHubAccountToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGitHubAccountToken",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGitHubAccountTokenInput`](crate::input::DeleteGitHubAccountTokenInput)
    pub fn builder() -> crate::input::delete_git_hub_account_token_input::Builder {
        crate::input::delete_git_hub_account_token_input::Builder::default()
    }
}

/// See [`DeleteResourcesByExternalIdInput`](crate::input::DeleteResourcesByExternalIdInput)
pub mod delete_resources_by_external_id_input {
    /// A builder for [`DeleteResourcesByExternalIdInput`](crate::input::DeleteResourcesByExternalIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcesByExternalIdInput`](crate::input::DeleteResourcesByExternalIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourcesByExternalIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourcesByExternalIdInput {
                external_id: self.external_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourcesByExternalIdInputOperationOutputAlias =
    crate::operation::DeleteResourcesByExternalId;
#[doc(hidden)]
pub type DeleteResourcesByExternalIdInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourcesByExternalIdInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourcesByExternalId`](crate::operation::DeleteResourcesByExternalId)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourcesByExternalId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourcesByExternalIdInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourcesByExternalIdInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourcesByExternalIdInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.DeleteResourcesByExternalId",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_resources_by_external_id(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourcesByExternalId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourcesByExternalId",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourcesByExternalIdInput`](crate::input::DeleteResourcesByExternalIdInput)
    pub fn builder() -> crate::input::delete_resources_by_external_id_input::Builder {
        crate::input::delete_resources_by_external_id_input::Builder::default()
    }
}

/// See [`DeregisterOnPremisesInstanceInput`](crate::input::DeregisterOnPremisesInstanceInput)
pub mod deregister_on_premises_instance_input {
    /// A builder for [`DeregisterOnPremisesInstanceInput`](crate::input::DeregisterOnPremisesInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the on-premises instance to deregister.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the on-premises instance to deregister.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterOnPremisesInstanceInput`](crate::input::DeregisterOnPremisesInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterOnPremisesInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterOnPremisesInstanceInput {
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterOnPremisesInstanceInputOperationOutputAlias =
    crate::operation::DeregisterOnPremisesInstance;
#[doc(hidden)]
pub type DeregisterOnPremisesInstanceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterOnPremisesInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterOnPremisesInstance`](crate::operation::DeregisterOnPremisesInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterOnPremisesInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterOnPremisesInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterOnPremisesInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterOnPremisesInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.DeregisterOnPremisesInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deregister_on_premises_instance(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterOnPremisesInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterOnPremisesInstance",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterOnPremisesInstanceInput`](crate::input::DeregisterOnPremisesInstanceInput)
    pub fn builder() -> crate::input::deregister_on_premises_instance_input::Builder {
        crate::input::deregister_on_premises_instance_input::Builder::default()
    }
}

/// See [`GetApplicationInput`](crate::input::GetApplicationInput)
pub mod get_application_input {
    /// A builder for [`GetApplicationInput`](crate::input::GetApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationInput`](crate::input::GetApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApplicationInput {
                application_name: self.application_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApplicationInputOperationOutputAlias = crate::operation::GetApplication;
#[doc(hidden)]
pub type GetApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApplicationInput {
    /// Consumes the builder and constructs an Operation<[`GetApplication`](crate::operation::GetApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_application(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApplication",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetApplicationInput`](crate::input::GetApplicationInput)
    pub fn builder() -> crate::input::get_application_input::Builder {
        crate::input::get_application_input::Builder::default()
    }
}

/// See [`GetApplicationRevisionInput`](crate::input::GetApplicationRevisionInput)
pub mod get_application_revision_input {
    /// A builder for [`GetApplicationRevisionInput`](crate::input::GetApplicationRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<crate::model::RevisionLocation>,
    }
    impl Builder {
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Information about the application revision to get, including type and location.</p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>Information about the application revision to get, including type and location.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationRevisionInput`](crate::input::GetApplicationRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApplicationRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApplicationRevisionInput {
                application_name: self.application_name,
                revision: self.revision,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApplicationRevisionInputOperationOutputAlias = crate::operation::GetApplicationRevision;
#[doc(hidden)]
pub type GetApplicationRevisionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApplicationRevisionInput {
    /// Consumes the builder and constructs an Operation<[`GetApplicationRevision`](crate::operation::GetApplicationRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApplicationRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetApplicationRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetApplicationRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetApplicationRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetApplicationRevision",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_application_revision(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApplicationRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApplicationRevision",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetApplicationRevisionInput`](crate::input::GetApplicationRevisionInput)
    pub fn builder() -> crate::input::get_application_revision_input::Builder {
        crate::input::get_application_revision_input::Builder::default()
    }
}

/// See [`GetDeploymentInput`](crate::input::GetDeploymentInput)
pub mod get_deployment_input {
    /// A builder for [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentInput`](crate::input::GetDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentInput {
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentInputOperationOutputAlias = crate::operation::GetDeployment;
#[doc(hidden)]
pub type GetDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployment`](crate::operation::GetDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_deployment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployment",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
}

/// See [`GetDeploymentConfigInput`](crate::input::GetDeploymentConfigInput)
pub mod get_deployment_config_input {
    /// A builder for [`GetDeploymentConfigInput`](crate::input::GetDeploymentConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentConfigInput`](crate::input::GetDeploymentConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentConfigInput {
                deployment_config_name: self.deployment_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentConfigInputOperationOutputAlias = crate::operation::GetDeploymentConfig;
#[doc(hidden)]
pub type GetDeploymentConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetDeploymentConfig`](crate::operation::GetDeploymentConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeploymentConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetDeploymentConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_deployment_config(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeploymentConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeploymentConfig",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentConfigInput`](crate::input::GetDeploymentConfigInput)
    pub fn builder() -> crate::input::get_deployment_config_input::Builder {
        crate::input::get_deployment_config_input::Builder::default()
    }
}

/// See [`GetDeploymentGroupInput`](crate::input::GetDeploymentGroupInput)
pub mod get_deployment_group_input {
    /// A builder for [`GetDeploymentGroupInput`](crate::input::GetDeploymentGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_name = Some(input.into());
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentGroupInput`](crate::input::GetDeploymentGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentGroupInput {
                application_name: self.application_name,
                deployment_group_name: self.deployment_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentGroupInputOperationOutputAlias = crate::operation::GetDeploymentGroup;
#[doc(hidden)]
pub type GetDeploymentGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetDeploymentGroup`](crate::operation::GetDeploymentGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeploymentGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetDeploymentGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_deployment_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeploymentGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeploymentGroup",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentGroupInput`](crate::input::GetDeploymentGroupInput)
    pub fn builder() -> crate::input::get_deployment_group_input::Builder {
        crate::input::get_deployment_group_input::Builder::default()
    }
}

/// See [`GetDeploymentInstanceInput`](crate::input::GetDeploymentInstanceInput)
pub mod get_deployment_instance_input {
    /// A builder for [`GetDeploymentInstanceInput`](crate::input::GetDeploymentInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The unique ID of an instance in the deployment group. </p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p> The unique ID of an instance in the deployment group. </p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentInstanceInput`](crate::input::GetDeploymentInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentInstanceInput {
                deployment_id: self.deployment_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentInstanceInputOperationOutputAlias = crate::operation::GetDeploymentInstance;
#[doc(hidden)]
pub type GetDeploymentInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetDeploymentInstance`](crate::operation::GetDeploymentInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeploymentInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetDeploymentInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_deployment_instance(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeploymentInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeploymentInstance",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentInstanceInput`](crate::input::GetDeploymentInstanceInput)
    pub fn builder() -> crate::input::get_deployment_instance_input::Builder {
        crate::input::get_deployment_instance_input::Builder::default()
    }
}

/// See [`GetDeploymentTargetInput`](crate::input::GetDeploymentTargetInput)
pub mod get_deployment_target_input {
    /// A builder for [`GetDeploymentTargetInput`](crate::input::GetDeploymentTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The unique ID of a deployment target. </p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment target. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentTargetInput`](crate::input::GetDeploymentTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentTargetInput {
                deployment_id: self.deployment_id,
                target_id: self.target_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentTargetInputOperationOutputAlias = crate::operation::GetDeploymentTarget;
#[doc(hidden)]
pub type GetDeploymentTargetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeploymentTargetInput {
    /// Consumes the builder and constructs an Operation<[`GetDeploymentTarget`](crate::operation::GetDeploymentTarget)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeploymentTarget,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetDeploymentTarget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_deployment_target(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeploymentTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeploymentTarget",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentTargetInput`](crate::input::GetDeploymentTargetInput)
    pub fn builder() -> crate::input::get_deployment_target_input::Builder {
        crate::input::get_deployment_target_input::Builder::default()
    }
}

/// See [`GetOnPremisesInstanceInput`](crate::input::GetOnPremisesInstanceInput)
pub mod get_on_premises_instance_input {
    /// A builder for [`GetOnPremisesInstanceInput`](crate::input::GetOnPremisesInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the on-premises instance about which to get information. </p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p> The name of the on-premises instance about which to get information. </p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOnPremisesInstanceInput`](crate::input::GetOnPremisesInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOnPremisesInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOnPremisesInstanceInput {
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOnPremisesInstanceInputOperationOutputAlias = crate::operation::GetOnPremisesInstance;
#[doc(hidden)]
pub type GetOnPremisesInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOnPremisesInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetOnPremisesInstance`](crate::operation::GetOnPremisesInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOnPremisesInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOnPremisesInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOnPremisesInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOnPremisesInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.GetOnPremisesInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_on_premises_instance(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOnPremisesInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOnPremisesInstance",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOnPremisesInstanceInput`](crate::input::GetOnPremisesInstanceInput)
    pub fn builder() -> crate::input::get_on_premises_instance_input::Builder {
        crate::input::get_on_premises_instance_input::Builder::default()
    }
}

/// See [`ListApplicationRevisionsInput`](crate::input::ListApplicationRevisionsInput)
pub mod list_application_revisions_input {
    /// A builder for [`ListApplicationRevisionsInput`](crate::input::ListApplicationRevisionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::ApplicationRevisionSortBy>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) deployed: std::option::Option<crate::model::ListStateFilterAction>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS account. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS account. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The column name to use to sort the list results:</p>
        /// <ul>
        /// <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li>
        /// <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li>
        /// <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li>
        /// </ul>
        /// <p> If not specified or set to null, the results are returned in an arbitrary order. </p>
        pub fn sort_by(mut self, input: crate::model::ApplicationRevisionSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The column name to use to sort the list results:</p>
        /// <ul>
        /// <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li>
        /// <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li>
        /// <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li>
        /// </ul>
        /// <p> If not specified or set to null, the results are returned in an arbitrary order. </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ApplicationRevisionSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p> The order in which to sort the list results: </p>
        /// <ul>
        /// <li> <p> <code>ascending</code>: ascending order.</p> </li>
        /// <li> <p> <code>descending</code>: descending order.</p> </li>
        /// </ul>
        /// <p>If not specified, the results are sorted in ascending order.</p>
        /// <p>If set to null, the results are sorted in an arbitrary order.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p> The order in which to sort the list results: </p>
        /// <ul>
        /// <li> <p> <code>ascending</code>: ascending order.</p> </li>
        /// <li> <p> <code>descending</code>: descending order.</p> </li>
        /// </ul>
        /// <p>If not specified, the results are sorted in ascending order.</p>
        /// <p>If set to null, the results are sorted in an arbitrary order.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
        /// <p> If set to null, all of the user's buckets are searched. </p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
        /// <p> If set to null, all of the user's buckets are searched. </p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p>
        /// <ul>
        /// <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>ignore</code>: List all revisions.</p> </li>
        /// </ul>
        pub fn deployed(mut self, input: crate::model::ListStateFilterAction) -> Self {
            self.deployed = Some(input);
            self
        }
        /// <p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p>
        /// <ul>
        /// <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>ignore</code>: List all revisions.</p> </li>
        /// </ul>
        pub fn set_deployed(
            mut self,
            input: std::option::Option<crate::model::ListStateFilterAction>,
        ) -> Self {
            self.deployed = input;
            self
        }
        /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationRevisionsInput`](crate::input::ListApplicationRevisionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationRevisionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationRevisionsInput {
                application_name: self.application_name,
                sort_by: self.sort_by,
                sort_order: self.sort_order,
                s3_bucket: self.s3_bucket,
                s3_key_prefix: self.s3_key_prefix,
                deployed: self.deployed,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationRevisionsInputOperationOutputAlias =
    crate::operation::ListApplicationRevisions;
#[doc(hidden)]
pub type ListApplicationRevisionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListApplicationRevisionsInput {
    /// Consumes the builder and constructs an Operation<[`ListApplicationRevisions`](crate::operation::ListApplicationRevisions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplicationRevisions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationRevisionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationRevisionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationRevisionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListApplicationRevisions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_application_revisions(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplicationRevisions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplicationRevisions",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationRevisionsInput`](crate::input::ListApplicationRevisionsInput)
    pub fn builder() -> crate::input::list_application_revisions_input::Builder {
        crate::input::list_application_revisions_input::Builder::default()
    }
}

/// See [`ListApplicationsInput`](crate::input::ListApplicationsInput)
pub mod list_applications_input {
    /// A builder for [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsInput`](crate::input::ListApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationsInputOperationOutputAlias = crate::operation::ListApplications;
#[doc(hidden)]
pub type ListApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListApplications`](crate::operation::ListApplications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListApplications",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_applications(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplications",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    pub fn builder() -> crate::input::list_applications_input::Builder {
        crate::input::list_applications_input::Builder::default()
    }
}

/// See [`ListDeploymentConfigsInput`](crate::input::ListDeploymentConfigsInput)
pub mod list_deployment_configs_input {
    /// A builder for [`ListDeploymentConfigsInput`](crate::input::ListDeploymentConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentConfigsInput`](crate::input::ListDeploymentConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentConfigsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentConfigsInputOperationOutputAlias = crate::operation::ListDeploymentConfigs;
#[doc(hidden)]
pub type ListDeploymentConfigsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeploymentConfigs`](crate::operation::ListDeploymentConfigs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeploymentConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListDeploymentConfigs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_deployment_configs(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeploymentConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeploymentConfigs",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentConfigsInput`](crate::input::ListDeploymentConfigsInput)
    pub fn builder() -> crate::input::list_deployment_configs_input::Builder {
        crate::input::list_deployment_configs_input::Builder::default()
    }
}

/// See [`ListDeploymentGroupsInput`](crate::input::ListDeploymentGroupsInput)
pub mod list_deployment_groups_input {
    /// A builder for [`ListDeploymentGroupsInput`](crate::input::ListDeploymentGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentGroupsInput`](crate::input::ListDeploymentGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentGroupsInput {
                application_name: self.application_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentGroupsInputOperationOutputAlias = crate::operation::ListDeploymentGroups;
#[doc(hidden)]
pub type ListDeploymentGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeploymentGroups`](crate::operation::ListDeploymentGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeploymentGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListDeploymentGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_deployment_groups(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeploymentGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeploymentGroups",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentGroupsInput`](crate::input::ListDeploymentGroupsInput)
    pub fn builder() -> crate::input::list_deployment_groups_input::Builder {
        crate::input::list_deployment_groups_input::Builder::default()
    }
}

/// See [`ListDeploymentInstancesInput`](crate::input::ListDeploymentInstancesInput)
pub mod list_deployment_instances_input {
    /// A builder for [`ListDeploymentInstancesInput`](crate::input::ListDeploymentInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) instance_status_filter:
            std::option::Option<std::vec::Vec<crate::model::InstanceStatus>>,
        pub(crate) instance_type_filter:
            std::option::Option<std::vec::Vec<crate::model::InstanceType>>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `instance_status_filter`.
        ///
        /// To override the contents of this collection use [`set_instance_status_filter`](Self::set_instance_status_filter).
        ///
        /// <p>A subset of instances to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li>
        /// <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li>
        /// <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li>
        /// <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li>
        /// <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li>
        /// </ul>
        pub fn instance_status_filter(mut self, input: crate::model::InstanceStatus) -> Self {
            let mut v = self.instance_status_filter.unwrap_or_default();
            v.push(input);
            self.instance_status_filter = Some(v);
            self
        }
        /// <p>A subset of instances to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li>
        /// <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li>
        /// <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li>
        /// <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li>
        /// <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li>
        /// </ul>
        pub fn set_instance_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceStatus>>,
        ) -> Self {
            self.instance_status_filter = input;
            self
        }
        /// Appends an item to `instance_type_filter`.
        ///
        /// To override the contents of this collection use [`set_instance_type_filter`](Self::set_instance_type_filter).
        ///
        /// <p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>
        pub fn instance_type_filter(mut self, input: crate::model::InstanceType) -> Self {
            let mut v = self.instance_type_filter.unwrap_or_default();
            v.push(input);
            self.instance_type_filter = Some(v);
            self
        }
        /// <p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>
        pub fn set_instance_type_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceType>>,
        ) -> Self {
            self.instance_type_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentInstancesInput`](crate::input::ListDeploymentInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentInstancesInput {
                deployment_id: self.deployment_id,
                next_token: self.next_token,
                instance_status_filter: self.instance_status_filter,
                instance_type_filter: self.instance_type_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentInstancesInputOperationOutputAlias =
    crate::operation::ListDeploymentInstances;
#[doc(hidden)]
pub type ListDeploymentInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListDeploymentInstances`](crate::operation::ListDeploymentInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeploymentInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListDeploymentInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_deployment_instances(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeploymentInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeploymentInstances",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentInstancesInput`](crate::input::ListDeploymentInstancesInput)
    pub fn builder() -> crate::input::list_deployment_instances_input::Builder {
        crate::input::list_deployment_instances_input::Builder::default()
    }
}

/// See [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
pub mod list_deployments_input {
    /// A builder for [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_name: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) include_only_statuses:
            std::option::Option<std::vec::Vec<crate::model::DeploymentStatus>>,
        pub(crate) create_time_range: std::option::Option<crate::model::TimeRange>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
        /// <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p>
        /// </note>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
        /// <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p>
        /// </note>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of a deployment group for the specified application.</p> <note>
        /// <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p>
        /// </note>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_name = Some(input.into());
            self
        }
        /// <p>The name of a deployment group for the specified application.</p> <note>
        /// <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p>
        /// </note>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_name = input;
            self
        }
        /// <p>The unique ID of an external resource for returning deployments linked to the external resource.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The unique ID of an external resource for returning deployments linked to the external resource.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Appends an item to `include_only_statuses`.
        ///
        /// To override the contents of this collection use [`set_include_only_statuses`](Self::set_include_only_statuses).
        ///
        /// <p>A subset of deployments to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li>
        /// <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li>
        /// </ul>
        pub fn include_only_statuses(mut self, input: crate::model::DeploymentStatus) -> Self {
            let mut v = self.include_only_statuses.unwrap_or_default();
            v.push(input);
            self.include_only_statuses = Some(v);
            self
        }
        /// <p>A subset of deployments to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li>
        /// <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li>
        /// </ul>
        pub fn set_include_only_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentStatus>>,
        ) -> Self {
            self.include_only_statuses = input;
            self
        }
        /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
        pub fn create_time_range(mut self, input: crate::model::TimeRange) -> Self {
            self.create_time_range = Some(input);
            self
        }
        /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
        pub fn set_create_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.create_time_range = input;
            self
        }
        /// <p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentsInput {
                application_name: self.application_name,
                deployment_group_name: self.deployment_group_name,
                external_id: self.external_id,
                include_only_statuses: self.include_only_statuses,
                create_time_range: self.create_time_range,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentsInputOperationOutputAlias = crate::operation::ListDeployments;
#[doc(hidden)]
pub type ListDeploymentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeployments`](crate::operation::ListDeployments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeployments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListDeployments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_deployments(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeployments",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    pub fn builder() -> crate::input::list_deployments_input::Builder {
        crate::input::list_deployments_input::Builder::default()
    }
}

/// See [`ListDeploymentTargetsInput`](crate::input::ListDeploymentTargetsInput)
pub mod list_deployment_targets_input {
    /// A builder for [`ListDeploymentTargetsInput`](crate::input::ListDeploymentTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) target_filters: std::option::Option<
            std::collections::HashMap<
                crate::model::TargetFilterName,
                std::vec::Vec<std::string::String>,
            >,
        >,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Adds a key-value pair to `target_filters`.
        ///
        /// To override the contents of this collection use [`set_target_filters`](Self::set_target_filters).
        ///
        /// <p> A key used to filter the returned targets. The two valid values are:</p>
        /// <ul>
        /// <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li>
        /// <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li>
        /// </ul>
        pub fn target_filters(
            mut self,
            k: crate::model::TargetFilterName,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.target_filters.unwrap_or_default();
            hash_map.insert(k, v);
            self.target_filters = Some(hash_map);
            self
        }
        /// <p> A key used to filter the returned targets. The two valid values are:</p>
        /// <ul>
        /// <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li>
        /// <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li>
        /// </ul>
        pub fn set_target_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::TargetFilterName,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.target_filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentTargetsInput`](crate::input::ListDeploymentTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentTargetsInput {
                deployment_id: self.deployment_id,
                next_token: self.next_token,
                target_filters: self.target_filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentTargetsInputOperationOutputAlias = crate::operation::ListDeploymentTargets;
#[doc(hidden)]
pub type ListDeploymentTargetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentTargetsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeploymentTargets`](crate::operation::ListDeploymentTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeploymentTargets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListDeploymentTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_deployment_targets(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeploymentTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeploymentTargets",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentTargetsInput`](crate::input::ListDeploymentTargetsInput)
    pub fn builder() -> crate::input::list_deployment_targets_input::Builder {
        crate::input::list_deployment_targets_input::Builder::default()
    }
}

/// See [`ListGitHubAccountTokenNamesInput`](crate::input::ListGitHubAccountTokenNamesInput)
pub mod list_git_hub_account_token_names_input {
    /// A builder for [`ListGitHubAccountTokenNamesInput`](crate::input::ListGitHubAccountTokenNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGitHubAccountTokenNamesInput`](crate::input::ListGitHubAccountTokenNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGitHubAccountTokenNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGitHubAccountTokenNamesInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGitHubAccountTokenNamesInputOperationOutputAlias =
    crate::operation::ListGitHubAccountTokenNames;
#[doc(hidden)]
pub type ListGitHubAccountTokenNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGitHubAccountTokenNamesInput {
    /// Consumes the builder and constructs an Operation<[`ListGitHubAccountTokenNames`](crate::operation::ListGitHubAccountTokenNames)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGitHubAccountTokenNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGitHubAccountTokenNamesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGitHubAccountTokenNamesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGitHubAccountTokenNamesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListGitHubAccountTokenNames",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_git_hub_account_token_names(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGitHubAccountTokenNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGitHubAccountTokenNames",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGitHubAccountTokenNamesInput`](crate::input::ListGitHubAccountTokenNamesInput)
    pub fn builder() -> crate::input::list_git_hub_account_token_names_input::Builder {
        crate::input::list_git_hub_account_token_names_input::Builder::default()
    }
}

/// See [`ListOnPremisesInstancesInput`](crate::input::ListOnPremisesInstancesInput)
pub mod list_on_premises_instances_input {
    /// A builder for [`ListOnPremisesInstancesInput`](crate::input::ListOnPremisesInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registration_status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) tag_filters: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registration status of the on-premises instances:</p>
        /// <ul>
        /// <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li>
        /// <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li>
        /// </ul>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.registration_status = Some(input);
            self
        }
        /// <p>The registration status of the on-premises instances:</p>
        /// <ul>
        /// <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li>
        /// <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li>
        /// </ul>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.registration_status = input;
            self
        }
        /// Appends an item to `tag_filters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>
        pub fn tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            let mut v = self.tag_filters.unwrap_or_default();
            v.push(input);
            self.tag_filters = Some(v);
            self
        }
        /// <p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.tag_filters = input;
            self
        }
        /// <p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOnPremisesInstancesInput`](crate::input::ListOnPremisesInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOnPremisesInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOnPremisesInstancesInput {
                registration_status: self.registration_status,
                tag_filters: self.tag_filters,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOnPremisesInstancesInputOperationOutputAlias =
    crate::operation::ListOnPremisesInstances;
#[doc(hidden)]
pub type ListOnPremisesInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOnPremisesInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListOnPremisesInstances`](crate::operation::ListOnPremisesInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOnPremisesInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOnPremisesInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOnPremisesInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOnPremisesInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListOnPremisesInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_on_premises_instances(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOnPremisesInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOnPremisesInstances",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOnPremisesInstancesInput`](crate::input::ListOnPremisesInstancesInput)
    pub fn builder() -> crate::input::list_on_premises_instances_input::Builder {
        crate::input::list_on_premises_instances_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutLifecycleEventHookExecutionStatusInput`](crate::input::PutLifecycleEventHookExecutionStatusInput)
pub mod put_lifecycle_event_hook_execution_status_input {
    /// A builder for [`PutLifecycleEventHookExecutionStatusInput`](crate::input::PutLifecycleEventHookExecutionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle_event_hook_execution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::LifecycleEventStatus>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>
        pub fn lifecycle_event_hook_execution_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.lifecycle_event_hook_execution_id = Some(input.into());
            self
        }
        /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>
        pub fn set_lifecycle_event_hook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_event_hook_execution_id = input;
            self
        }
        /// <p>The result of a Lambda function that validates a deployment lifecycle event. <code>Succeeded</code> and <code>Failed</code> are the only valid values for <code>status</code>.</p>
        pub fn status(mut self, input: crate::model::LifecycleEventStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The result of a Lambda function that validates a deployment lifecycle event. <code>Succeeded</code> and <code>Failed</code> are the only valid values for <code>status</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LifecycleEventStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLifecycleEventHookExecutionStatusInput`](crate::input::PutLifecycleEventHookExecutionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLifecycleEventHookExecutionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLifecycleEventHookExecutionStatusInput {
                deployment_id: self.deployment_id,
                lifecycle_event_hook_execution_id: self.lifecycle_event_hook_execution_id,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLifecycleEventHookExecutionStatusInputOperationOutputAlias =
    crate::operation::PutLifecycleEventHookExecutionStatus;
#[doc(hidden)]
pub type PutLifecycleEventHookExecutionStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutLifecycleEventHookExecutionStatusInput {
    /// Consumes the builder and constructs an Operation<[`PutLifecycleEventHookExecutionStatus`](crate::operation::PutLifecycleEventHookExecutionStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLifecycleEventHookExecutionStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutLifecycleEventHookExecutionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutLifecycleEventHookExecutionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutLifecycleEventHookExecutionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.PutLifecycleEventHookExecutionStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_lifecycle_event_hook_execution_status(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLifecycleEventHookExecutionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLifecycleEventHookExecutionStatus",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutLifecycleEventHookExecutionStatusInput`](crate::input::PutLifecycleEventHookExecutionStatusInput)
    pub fn builder() -> crate::input::put_lifecycle_event_hook_execution_status_input::Builder {
        crate::input::put_lifecycle_event_hook_execution_status_input::Builder::default()
    }
}

/// See [`RegisterApplicationRevisionInput`](crate::input::RegisterApplicationRevisionInput)
pub mod register_application_revision_input {
    /// A builder for [`RegisterApplicationRevisionInput`](crate::input::RegisterApplicationRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<crate::model::RevisionLocation>,
    }
    impl Builder {
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>A comment about the revision.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A comment about the revision.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the application revision to register, including type and location.</p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>Information about the application revision to register, including type and location.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterApplicationRevisionInput`](crate::input::RegisterApplicationRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterApplicationRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterApplicationRevisionInput {
                application_name: self.application_name,
                description: self.description,
                revision: self.revision,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterApplicationRevisionInputOperationOutputAlias =
    crate::operation::RegisterApplicationRevision;
#[doc(hidden)]
pub type RegisterApplicationRevisionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterApplicationRevisionInput {
    /// Consumes the builder and constructs an Operation<[`RegisterApplicationRevision`](crate::operation::RegisterApplicationRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterApplicationRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterApplicationRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterApplicationRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterApplicationRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.RegisterApplicationRevision",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_register_application_revision(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterApplicationRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterApplicationRevision",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterApplicationRevisionInput`](crate::input::RegisterApplicationRevisionInput)
    pub fn builder() -> crate::input::register_application_revision_input::Builder {
        crate::input::register_application_revision_input::Builder::default()
    }
}

/// See [`RegisterOnPremisesInstanceInput`](crate::input::RegisterOnPremisesInstanceInput)
pub mod register_on_premises_instance_input {
    /// A builder for [`RegisterOnPremisesInstanceInput`](crate::input::RegisterOnPremisesInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) iam_session_arn: std::option::Option<std::string::String>,
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the on-premises instance to register.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the on-premises instance to register.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
        pub fn iam_session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_session_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
        pub fn set_iam_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_session_arn = input;
            self
        }
        /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterOnPremisesInstanceInput`](crate::input::RegisterOnPremisesInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterOnPremisesInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterOnPremisesInstanceInput {
                instance_name: self.instance_name,
                iam_session_arn: self.iam_session_arn,
                iam_user_arn: self.iam_user_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterOnPremisesInstanceInputOperationOutputAlias =
    crate::operation::RegisterOnPremisesInstance;
#[doc(hidden)]
pub type RegisterOnPremisesInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterOnPremisesInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RegisterOnPremisesInstance`](crate::operation::RegisterOnPremisesInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterOnPremisesInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterOnPremisesInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterOnPremisesInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterOnPremisesInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.RegisterOnPremisesInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_register_on_premises_instance(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterOnPremisesInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterOnPremisesInstance",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterOnPremisesInstanceInput`](crate::input::RegisterOnPremisesInstanceInput)
    pub fn builder() -> crate::input::register_on_premises_instance_input::Builder {
        crate::input::register_on_premises_instance_input::Builder::default()
    }
}

/// See [`RemoveTagsFromOnPremisesInstancesInput`](crate::input::RemoveTagsFromOnPremisesInstancesInput)
pub mod remove_tags_from_on_premises_instances_input {
    /// A builder for [`RemoveTagsFromOnPremisesInstancesInput`](crate::input::RemoveTagsFromOnPremisesInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances from which to remove tags.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>The names of the on-premises instances from which to remove tags.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromOnPremisesInstancesInput`](crate::input::RemoveTagsFromOnPremisesInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromOnPremisesInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromOnPremisesInstancesInput {
                tags: self.tags,
                instance_names: self.instance_names,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromOnPremisesInstancesInputOperationOutputAlias =
    crate::operation::RemoveTagsFromOnPremisesInstances;
#[doc(hidden)]
pub type RemoveTagsFromOnPremisesInstancesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RemoveTagsFromOnPremisesInstancesInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromOnPremisesInstances`](crate::operation::RemoveTagsFromOnPremisesInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromOnPremisesInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromOnPremisesInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromOnPremisesInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromOnPremisesInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.RemoveTagsFromOnPremisesInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_on_premises_instances(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromOnPremisesInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromOnPremisesInstances",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromOnPremisesInstancesInput`](crate::input::RemoveTagsFromOnPremisesInstancesInput)
    pub fn builder() -> crate::input::remove_tags_from_on_premises_instances_input::Builder {
        crate::input::remove_tags_from_on_premises_instances_input::Builder::default()
    }
}

/// See [`SkipWaitTimeForInstanceTerminationInput`](crate::input::SkipWaitTimeForInstanceTerminationInput)
pub mod skip_wait_time_for_instance_termination_input {
    /// A builder for [`SkipWaitTimeForInstanceTerminationInput`](crate::input::SkipWaitTimeForInstanceTerminationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SkipWaitTimeForInstanceTerminationInput`](crate::input::SkipWaitTimeForInstanceTerminationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SkipWaitTimeForInstanceTerminationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SkipWaitTimeForInstanceTerminationInput {
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SkipWaitTimeForInstanceTerminationInputOperationOutputAlias =
    crate::operation::SkipWaitTimeForInstanceTermination;
#[doc(hidden)]
pub type SkipWaitTimeForInstanceTerminationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl SkipWaitTimeForInstanceTerminationInput {
    /// Consumes the builder and constructs an Operation<[`SkipWaitTimeForInstanceTermination`](crate::operation::SkipWaitTimeForInstanceTermination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SkipWaitTimeForInstanceTermination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SkipWaitTimeForInstanceTerminationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SkipWaitTimeForInstanceTerminationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SkipWaitTimeForInstanceTerminationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.SkipWaitTimeForInstanceTermination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_skip_wait_time_for_instance_termination(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SkipWaitTimeForInstanceTermination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SkipWaitTimeForInstanceTermination",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SkipWaitTimeForInstanceTerminationInput`](crate::input::SkipWaitTimeForInstanceTerminationInput)
    pub fn builder() -> crate::input::skip_wait_time_for_instance_termination_input::Builder {
        crate::input::skip_wait_time_for_instance_termination_input::Builder::default()
    }
}

/// See [`StopDeploymentInput`](crate::input::StopDeploymentInput)
pub mod stop_deployment_input {
    /// A builder for [`StopDeploymentInput`](crate::input::StopDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) auto_rollback_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>
        pub fn auto_rollback_enabled(mut self, input: bool) -> Self {
            self.auto_rollback_enabled = Some(input);
            self
        }
        /// <p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>
        pub fn set_auto_rollback_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_rollback_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDeploymentInput`](crate::input::StopDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDeploymentInput {
                deployment_id: self.deployment_id,
                auto_rollback_enabled: self.auto_rollback_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDeploymentInputOperationOutputAlias = crate::operation::StopDeployment;
#[doc(hidden)]
pub type StopDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`StopDeployment`](crate::operation::StopDeployment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.StopDeployment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_deployment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDeployment",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDeploymentInput`](crate::input::StopDeploymentInput)
    pub fn builder() -> crate::input::stop_deployment_input::Builder {
        crate::input::stop_deployment_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
pub mod update_application_input {
    /// A builder for [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) new_application_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current name of the application you want to change.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The current name of the application you want to change.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The new name to give the application.</p>
        pub fn new_application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_application_name = Some(input.into());
            self
        }
        /// <p>The new name to give the application.</p>
        pub fn set_new_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_application_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationInput {
                application_name: self.application_name,
                new_application_name: self.new_application_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationInputOperationOutputAlias = crate::operation::UpdateApplication;
#[doc(hidden)]
pub type UpdateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplication`](crate::operation::UpdateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.UpdateApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_application(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplication",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
}

/// See [`UpdateDeploymentGroupInput`](crate::input::UpdateDeploymentGroupInput)
pub mod update_deployment_group_input {
    /// A builder for [`UpdateDeploymentGroupInput`](crate::input::UpdateDeploymentGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_deployment_group_name: std::option::Option<std::string::String>,
        pub(crate) new_deployment_group_name: std::option::Option<std::string::String>,
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
        pub(crate) ec2_tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        pub(crate) on_premises_instance_tag_filters:
            std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        pub(crate) auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) trigger_configurations:
            std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        pub(crate) alarm_configuration: std::option::Option<crate::model::AlarmConfiguration>,
        pub(crate) auto_rollback_configuration:
            std::option::Option<crate::model::AutoRollbackConfiguration>,
        pub(crate) outdated_instances_strategy:
            std::option::Option<crate::model::OutdatedInstancesStrategy>,
        pub(crate) deployment_style: std::option::Option<crate::model::DeploymentStyle>,
        pub(crate) blue_green_deployment_configuration:
            std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        pub(crate) load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
        pub(crate) ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
        pub(crate) ecs_services: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        pub(crate) on_premises_tag_set: std::option::Option<crate::model::OnPremisesTagSet>,
    }
    impl Builder {
        /// <p>The application name that corresponds to the deployment group to update.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The application name that corresponds to the deployment group to update.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The current name of the deployment group.</p>
        pub fn current_deployment_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_deployment_group_name = Some(input.into());
            self
        }
        /// <p>The current name of the deployment group.</p>
        pub fn set_current_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_deployment_group_name = input;
            self
        }
        /// <p>The new name of the deployment group, if you want to change it.</p>
        pub fn new_deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_deployment_group_name = Some(input.into());
            self
        }
        /// <p>The new name of the deployment group, if you want to change it.</p>
        pub fn set_new_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_deployment_group_name = input;
            self
        }
        /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// Appends an item to `ec2_tag_filters`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_filters`](Self::set_ec2_tag_filters).
        ///
        /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn ec2_tag_filters(mut self, input: crate::model::Ec2TagFilter) -> Self {
            let mut v = self.ec2_tag_filters.unwrap_or_default();
            v.push(input);
            self.ec2_tag_filters = Some(v);
            self
        }
        /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn set_ec2_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.ec2_tag_filters = input;
            self
        }
        /// Appends an item to `on_premises_instance_tag_filters`.
        ///
        /// To override the contents of this collection use [`set_on_premises_instance_tag_filters`](Self::set_on_premises_instance_tag_filters).
        ///
        /// <p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn on_premises_instance_tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            let mut v = self.on_premises_instance_tag_filters.unwrap_or_default();
            v.push(input);
            self.on_premises_instance_tag_filters = Some(v);
            self
        }
        /// <p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn set_on_premises_instance_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.on_premises_instance_tag_filters = input;
            self
        }
        /// Appends an item to `auto_scaling_groups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>
        pub fn auto_scaling_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_scaling_groups.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_groups = Some(v);
            self
        }
        /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_scaling_groups = input;
            self
        }
        /// <p>A replacement ARN for the service role, if you want to change it.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>A replacement ARN for the service role, if you want to change it.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// Appends an item to `trigger_configurations`.
        ///
        /// To override the contents of this collection use [`set_trigger_configurations`](Self::set_trigger_configurations).
        ///
        /// <p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn trigger_configurations(mut self, input: crate::model::TriggerConfig) -> Self {
            let mut v = self.trigger_configurations.unwrap_or_default();
            v.push(input);
            self.trigger_configurations = Some(v);
            self
        }
        /// <p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_trigger_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        ) -> Self {
            self.trigger_configurations = input;
            self
        }
        /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>
        pub fn alarm_configuration(mut self, input: crate::model::AlarmConfiguration) -> Self {
            self.alarm_configuration = Some(input);
            self
        }
        /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>
        pub fn set_alarm_configuration(
            mut self,
            input: std::option::Option<crate::model::AlarmConfiguration>,
        ) -> Self {
            self.alarm_configuration = input;
            self
        }
        /// <p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.auto_rollback_configuration = Some(input);
            self
        }
        /// <p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.auto_rollback_configuration = input;
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn outdated_instances_strategy(
            mut self,
            input: crate::model::OutdatedInstancesStrategy,
        ) -> Self {
            self.outdated_instances_strategy = Some(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn set_outdated_instances_strategy(
            mut self,
            input: std::option::Option<crate::model::OutdatedInstancesStrategy>,
        ) -> Self {
            self.outdated_instances_strategy = input;
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, input: crate::model::DeploymentStyle) -> Self {
            self.deployment_style = Some(input);
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.deployment_style = input;
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            input: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.blue_green_deployment_configuration = Some(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.blue_green_deployment_configuration = input;
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn load_balancer_info(mut self, input: crate::model::LoadBalancerInfo) -> Self {
            self.load_balancer_info = Some(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.load_balancer_info = input;
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups.</p>
        pub fn ec2_tag_set(mut self, input: crate::model::Ec2TagSet) -> Self {
            self.ec2_tag_set = Some(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.ec2_tag_set = input;
            self
        }
        /// Appends an item to `ecs_services`.
        ///
        /// To override the contents of this collection use [`set_ecs_services`](Self::set_ecs_services).
        ///
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn ecs_services(mut self, input: crate::model::EcsService) -> Self {
            let mut v = self.ecs_services.unwrap_or_default();
            v.push(input);
            self.ecs_services = Some(v);
            self
        }
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn set_ecs_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        ) -> Self {
            self.ecs_services = input;
            self
        }
        /// <p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>
        pub fn on_premises_tag_set(mut self, input: crate::model::OnPremisesTagSet) -> Self {
            self.on_premises_tag_set = Some(input);
            self
        }
        /// <p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>
        pub fn set_on_premises_tag_set(
            mut self,
            input: std::option::Option<crate::model::OnPremisesTagSet>,
        ) -> Self {
            self.on_premises_tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeploymentGroupInput`](crate::input::UpdateDeploymentGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeploymentGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeploymentGroupInput {
                application_name: self.application_name,
                current_deployment_group_name: self.current_deployment_group_name,
                new_deployment_group_name: self.new_deployment_group_name,
                deployment_config_name: self.deployment_config_name,
                ec2_tag_filters: self.ec2_tag_filters,
                on_premises_instance_tag_filters: self.on_premises_instance_tag_filters,
                auto_scaling_groups: self.auto_scaling_groups,
                service_role_arn: self.service_role_arn,
                trigger_configurations: self.trigger_configurations,
                alarm_configuration: self.alarm_configuration,
                auto_rollback_configuration: self.auto_rollback_configuration,
                outdated_instances_strategy: self.outdated_instances_strategy,
                deployment_style: self.deployment_style,
                blue_green_deployment_configuration: self.blue_green_deployment_configuration,
                load_balancer_info: self.load_balancer_info,
                ec2_tag_set: self.ec2_tag_set,
                ecs_services: self.ecs_services,
                on_premises_tag_set: self.on_premises_tag_set,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeploymentGroupInputOperationOutputAlias = crate::operation::UpdateDeploymentGroup;
#[doc(hidden)]
pub type UpdateDeploymentGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDeploymentGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeploymentGroup`](crate::operation::UpdateDeploymentGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeploymentGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeploymentGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeploymentGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeploymentGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeDeploy_20141006.UpdateDeploymentGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_deployment_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeploymentGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeploymentGroup",
            "codedeploy",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentGroupInput`](crate::input::UpdateDeploymentGroupInput)
    pub fn builder() -> crate::input::update_deployment_group_input::Builder {
        crate::input::update_deployment_group_input::Builder::default()
    }
}

/// <p>Represents the input of an <code>UpdateDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeploymentGroupInput {
    /// <p>The application name that corresponds to the deployment group to update.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The current name of the deployment group.</p>
    pub current_deployment_group_name: std::option::Option<std::string::String>,
    /// <p>The new name of the deployment group, if you want to change it.</p>
    pub new_deployment_group_name: std::option::Option<std::string::String>,
    /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
    /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
    pub ec2_tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
    /// <p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
    pub on_premises_instance_tag_filters:
        std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
    /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>
    pub auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A replacement ARN for the service role, if you want to change it.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub trigger_configurations: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
    /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>
    pub alarm_configuration: std::option::Option<crate::model::AlarmConfiguration>,
    /// <p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>
    pub auto_rollback_configuration: std::option::Option<crate::model::AutoRollbackConfiguration>,
    /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
    /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
    /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    pub outdated_instances_strategy: std::option::Option<crate::model::OutdatedInstancesStrategy>,
    /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub deployment_style: std::option::Option<crate::model::DeploymentStyle>,
    /// <p>Information about blue/green deployment options for a deployment group.</p>
    pub blue_green_deployment_configuration:
        std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
    /// <p>Information about the load balancer used in a deployment.</p>
    pub load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
    /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups.</p>
    pub ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
    /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. </p>
    pub ecs_services: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
    /// <p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>
    pub on_premises_tag_set: std::option::Option<crate::model::OnPremisesTagSet>,
}
impl UpdateDeploymentGroupInput {
    /// <p>The application name that corresponds to the deployment group to update.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The current name of the deployment group.</p>
    pub fn current_deployment_group_name(&self) -> std::option::Option<&str> {
        self.current_deployment_group_name.as_deref()
    }
    /// <p>The new name of the deployment group, if you want to change it.</p>
    pub fn new_deployment_group_name(&self) -> std::option::Option<&str> {
        self.new_deployment_group_name.as_deref()
    }
    /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
    /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
    pub fn ec2_tag_filters(&self) -> std::option::Option<&[crate::model::Ec2TagFilter]> {
        self.ec2_tag_filters.as_deref()
    }
    /// <p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
    pub fn on_premises_instance_tag_filters(
        &self,
    ) -> std::option::Option<&[crate::model::TagFilter]> {
        self.on_premises_instance_tag_filters.as_deref()
    }
    /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>
    pub fn auto_scaling_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_scaling_groups.as_deref()
    }
    /// <p>A replacement ARN for the service role, if you want to change it.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub fn trigger_configurations(&self) -> std::option::Option<&[crate::model::TriggerConfig]> {
        self.trigger_configurations.as_deref()
    }
    /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>
    pub fn alarm_configuration(&self) -> std::option::Option<&crate::model::AlarmConfiguration> {
        self.alarm_configuration.as_ref()
    }
    /// <p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>
    pub fn auto_rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoRollbackConfiguration> {
        self.auto_rollback_configuration.as_ref()
    }
    /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
    /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
    /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    pub fn outdated_instances_strategy(
        &self,
    ) -> std::option::Option<&crate::model::OutdatedInstancesStrategy> {
        self.outdated_instances_strategy.as_ref()
    }
    /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub fn deployment_style(&self) -> std::option::Option<&crate::model::DeploymentStyle> {
        self.deployment_style.as_ref()
    }
    /// <p>Information about blue/green deployment options for a deployment group.</p>
    pub fn blue_green_deployment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::BlueGreenDeploymentConfiguration> {
        self.blue_green_deployment_configuration.as_ref()
    }
    /// <p>Information about the load balancer used in a deployment.</p>
    pub fn load_balancer_info(&self) -> std::option::Option<&crate::model::LoadBalancerInfo> {
        self.load_balancer_info.as_ref()
    }
    /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups.</p>
    pub fn ec2_tag_set(&self) -> std::option::Option<&crate::model::Ec2TagSet> {
        self.ec2_tag_set.as_ref()
    }
    /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. </p>
    pub fn ecs_services(&self) -> std::option::Option<&[crate::model::EcsService]> {
        self.ecs_services.as_deref()
    }
    /// <p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>
    pub fn on_premises_tag_set(&self) -> std::option::Option<&crate::model::OnPremisesTagSet> {
        self.on_premises_tag_set.as_ref()
    }
}
impl std::fmt::Debug for UpdateDeploymentGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeploymentGroupInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_deployment_group_name",
            &self.current_deployment_group_name,
        );
        formatter.field("new_deployment_group_name", &self.new_deployment_group_name);
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.field("ec2_tag_filters", &self.ec2_tag_filters);
        formatter.field(
            "on_premises_instance_tag_filters",
            &self.on_premises_instance_tag_filters,
        );
        formatter.field("auto_scaling_groups", &self.auto_scaling_groups);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("trigger_configurations", &self.trigger_configurations);
        formatter.field("alarm_configuration", &self.alarm_configuration);
        formatter.field(
            "auto_rollback_configuration",
            &self.auto_rollback_configuration,
        );
        formatter.field(
            "outdated_instances_strategy",
            &self.outdated_instances_strategy,
        );
        formatter.field("deployment_style", &self.deployment_style);
        formatter.field(
            "blue_green_deployment_configuration",
            &self.blue_green_deployment_configuration,
        );
        formatter.field("load_balancer_info", &self.load_balancer_info);
        formatter.field("ec2_tag_set", &self.ec2_tag_set);
        formatter.field("ecs_services", &self.ecs_services);
        formatter.field("on_premises_tag_set", &self.on_premises_tag_set);
        formatter.finish()
    }
}

/// <p>Represents the input of an <code>UpdateApplication</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationInput {
    /// <p>The current name of the application you want to change.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The new name to give the application.</p>
    pub new_application_name: std::option::Option<std::string::String>,
}
impl UpdateApplicationInput {
    /// <p>The current name of the application you want to change.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The new name to give the application.</p>
    pub fn new_application_name(&self) -> std::option::Option<&str> {
        self.new_application_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("new_application_name", &self.new_application_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p> Represents the input of a <code>StopDeployment</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDeploymentInput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>
    pub auto_rollback_enabled: std::option::Option<bool>,
}
impl StopDeploymentInput {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>
    pub fn auto_rollback_enabled(&self) -> std::option::Option<bool> {
        self.auto_rollback_enabled
    }
}
impl std::fmt::Debug for StopDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDeploymentInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("auto_rollback_enabled", &self.auto_rollback_enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkipWaitTimeForInstanceTerminationInput {
    /// <p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl SkipWaitTimeForInstanceTerminationInput {
    /// <p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
}
impl std::fmt::Debug for SkipWaitTimeForInstanceTerminationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkipWaitTimeForInstanceTerminationInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>RemoveTagsFromOnPremisesInstances</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromOnPremisesInstancesInput {
    /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The names of the on-premises instances from which to remove tags.</p>
    pub instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsFromOnPremisesInstancesInput {
    /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The names of the on-premises instances from which to remove tags.</p>
    pub fn instance_names(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_names.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromOnPremisesInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromOnPremisesInstancesInput");
        formatter.field("tags", &self.tags);
        formatter.field("instance_names", &self.instance_names);
        formatter.finish()
    }
}

/// <p>Represents the input of the register on-premises instance operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterOnPremisesInstanceInput {
    /// <p>The name of the on-premises instance to register.</p>
    pub instance_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
    pub iam_session_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
}
impl RegisterOnPremisesInstanceInput {
    /// <p>The name of the on-premises instance to register.</p>
    pub fn instance_name(&self) -> std::option::Option<&str> {
        self.instance_name.as_deref()
    }
    /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
    pub fn iam_session_arn(&self) -> std::option::Option<&str> {
        self.iam_session_arn.as_deref()
    }
    /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
}
impl std::fmt::Debug for RegisterOnPremisesInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterOnPremisesInstanceInput");
        formatter.field("instance_name", &self.instance_name);
        formatter.field("iam_session_arn", &self.iam_session_arn);
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.finish()
    }
}

/// <p>Represents the input of a RegisterApplicationRevision operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterApplicationRevisionInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>A comment about the revision.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the application revision to register, including type and location.</p>
    pub revision: std::option::Option<crate::model::RevisionLocation>,
}
impl RegisterApplicationRevisionInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>A comment about the revision.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the application revision to register, including type and location.</p>
    pub fn revision(&self) -> std::option::Option<&crate::model::RevisionLocation> {
        self.revision.as_ref()
    }
}
impl std::fmt::Debug for RegisterApplicationRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterApplicationRevisionInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("description", &self.description);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLifecycleEventHookExecutionStatusInput {
    /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>
    pub lifecycle_event_hook_execution_id: std::option::Option<std::string::String>,
    /// <p>The result of a Lambda function that validates a deployment lifecycle event. <code>Succeeded</code> and <code>Failed</code> are the only valid values for <code>status</code>.</p>
    pub status: std::option::Option<crate::model::LifecycleEventStatus>,
}
impl PutLifecycleEventHookExecutionStatusInput {
    /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>
    pub fn lifecycle_event_hook_execution_id(&self) -> std::option::Option<&str> {
        self.lifecycle_event_hook_execution_id.as_deref()
    }
    /// <p>The result of a Lambda function that validates a deployment lifecycle event. <code>Succeeded</code> and <code>Failed</code> are the only valid values for <code>status</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LifecycleEventStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PutLifecycleEventHookExecutionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLifecycleEventHookExecutionStatusInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field(
            "lifecycle_event_hook_execution_id",
            &self.lifecycle_event_hook_execution_id,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListOnPremisesInstances</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOnPremisesInstancesInput {
    /// <p>The registration status of the on-premises instances:</p>
    /// <ul>
    /// <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li>
    /// <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li>
    /// </ul>
    pub registration_status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>
    pub tag_filters: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
    /// <p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOnPremisesInstancesInput {
    /// <p>The registration status of the on-premises instances:</p>
    /// <ul>
    /// <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li>
    /// <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li>
    /// </ul>
    pub fn registration_status(&self) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.registration_status.as_ref()
    }
    /// <p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>
    pub fn tag_filters(&self) -> std::option::Option<&[crate::model::TagFilter]> {
        self.tag_filters.as_deref()
    }
    /// <p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOnPremisesInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOnPremisesInstancesInput");
        formatter.field("registration_status", &self.registration_status);
        formatter.field("tag_filters", &self.tag_filters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListGitHubAccountTokenNames</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGitHubAccountTokenNamesInput {
    /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGitHubAccountTokenNamesInput {
    /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGitHubAccountTokenNamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGitHubAccountTokenNamesInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentTargetsInput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> A key used to filter the returned targets. The two valid values are:</p>
    /// <ul>
    /// <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li>
    /// <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li>
    /// </ul>
    pub target_filters: std::option::Option<
        std::collections::HashMap<
            crate::model::TargetFilterName,
            std::vec::Vec<std::string::String>,
        >,
    >,
}
impl ListDeploymentTargetsInput {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> A key used to filter the returned targets. The two valid values are:</p>
    /// <ul>
    /// <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li>
    /// <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li>
    /// </ul>
    pub fn target_filters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::TargetFilterName,
            std::vec::Vec<std::string::String>,
        >,
    > {
        self.target_filters.as_ref()
    }
}
impl std::fmt::Debug for ListDeploymentTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentTargetsInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("target_filters", &self.target_filters);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListDeployments</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentsInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
    /// <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p>
    /// </note>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of a deployment group for the specified application.</p> <note>
    /// <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p>
    /// </note>
    pub deployment_group_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of an external resource for returning deployments linked to the external resource.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>A subset of deployments to list by status:</p>
    /// <ul>
    /// <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li>
    /// <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li>
    /// </ul>
    pub include_only_statuses: std::option::Option<std::vec::Vec<crate::model::DeploymentStatus>>,
    /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
    pub create_time_range: std::option::Option<crate::model::TimeRange>,
    /// <p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentsInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
    /// <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p>
    /// </note>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of a deployment group for the specified application.</p> <note>
    /// <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p>
    /// </note>
    pub fn deployment_group_name(&self) -> std::option::Option<&str> {
        self.deployment_group_name.as_deref()
    }
    /// <p>The unique ID of an external resource for returning deployments linked to the external resource.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>A subset of deployments to list by status:</p>
    /// <ul>
    /// <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li>
    /// <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li>
    /// <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li>
    /// </ul>
    pub fn include_only_statuses(&self) -> std::option::Option<&[crate::model::DeploymentStatus]> {
        self.include_only_statuses.as_deref()
    }
    /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
    pub fn create_time_range(&self) -> std::option::Option<&crate::model::TimeRange> {
        self.create_time_range.as_ref()
    }
    /// <p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_name", &self.deployment_group_name);
        formatter.field("external_id", &self.external_id);
        formatter.field("include_only_statuses", &self.include_only_statuses);
        formatter.field("create_time_range", &self.create_time_range);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Represents the input of a <code>ListDeploymentInstances</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentInstancesInput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A subset of instances to list by status:</p>
    /// <ul>
    /// <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li>
    /// <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li>
    /// <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li>
    /// <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li>
    /// <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li>
    /// <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li>
    /// </ul>
    pub instance_status_filter: std::option::Option<std::vec::Vec<crate::model::InstanceStatus>>,
    /// <p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>
    pub instance_type_filter: std::option::Option<std::vec::Vec<crate::model::InstanceType>>,
}
impl ListDeploymentInstancesInput {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A subset of instances to list by status:</p>
    /// <ul>
    /// <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li>
    /// <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li>
    /// <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li>
    /// <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li>
    /// <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li>
    /// <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li>
    /// </ul>
    pub fn instance_status_filter(&self) -> std::option::Option<&[crate::model::InstanceStatus]> {
        self.instance_status_filter.as_deref()
    }
    /// <p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>
    pub fn instance_type_filter(&self) -> std::option::Option<&[crate::model::InstanceType]> {
        self.instance_type_filter.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentInstancesInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("instance_status_filter", &self.instance_status_filter);
        formatter.field("instance_type_filter", &self.instance_type_filter);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListDeploymentGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentGroupsInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentGroupsInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentGroupsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListDeploymentConfigs</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentConfigsInput {
    /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentConfigsInput {
    /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentConfigsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListApplications</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsInput {
    /// <p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationsInput {
    /// <p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Represents the input of a <code>ListApplicationRevisions</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationRevisionsInput {
    /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS account. </p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The column name to use to sort the list results:</p>
    /// <ul>
    /// <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li>
    /// <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li>
    /// <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li>
    /// </ul>
    /// <p> If not specified or set to null, the results are returned in an arbitrary order. </p>
    pub sort_by: std::option::Option<crate::model::ApplicationRevisionSortBy>,
    /// <p> The order in which to sort the list results: </p>
    /// <ul>
    /// <li> <p> <code>ascending</code>: ascending order.</p> </li>
    /// <li> <p> <code>descending</code>: descending order.</p> </li>
    /// </ul>
    /// <p>If not specified, the results are sorted in ascending order.</p>
    /// <p>If set to null, the results are sorted in an arbitrary order.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
    /// <p> If set to null, all of the user's buckets are searched. </p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p>
    /// <ul>
    /// <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li>
    /// <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li>
    /// <li> <p> <code>ignore</code>: List all revisions.</p> </li>
    /// </ul>
    pub deployed: std::option::Option<crate::model::ListStateFilterAction>,
    /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationRevisionsInput {
    /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS account. </p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The column name to use to sort the list results:</p>
    /// <ul>
    /// <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li>
    /// <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li>
    /// <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li>
    /// </ul>
    /// <p> If not specified or set to null, the results are returned in an arbitrary order. </p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::ApplicationRevisionSortBy> {
        self.sort_by.as_ref()
    }
    /// <p> The order in which to sort the list results: </p>
    /// <ul>
    /// <li> <p> <code>ascending</code>: ascending order.</p> </li>
    /// <li> <p> <code>descending</code>: descending order.</p> </li>
    /// </ul>
    /// <p>If not specified, the results are sorted in ascending order.</p>
    /// <p>If set to null, the results are sorted in an arbitrary order.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
    /// <p> If set to null, all of the user's buckets are searched. </p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p>
    /// <ul>
    /// <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li>
    /// <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li>
    /// <li> <p> <code>ignore</code>: List all revisions.</p> </li>
    /// </ul>
    pub fn deployed(&self) -> std::option::Option<&crate::model::ListStateFilterAction> {
        self.deployed.as_ref()
    }
    /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationRevisionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationRevisionsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("deployed", &self.deployed);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Represents the input of a <code>GetOnPremisesInstance</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOnPremisesInstanceInput {
    /// <p> The name of the on-premises instance about which to get information. </p>
    pub instance_name: std::option::Option<std::string::String>,
}
impl GetOnPremisesInstanceInput {
    /// <p> The name of the on-premises instance about which to get information. </p>
    pub fn instance_name(&self) -> std::option::Option<&str> {
        self.instance_name.as_deref()
    }
}
impl std::fmt::Debug for GetOnPremisesInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOnPremisesInstanceInput");
        formatter.field("instance_name", &self.instance_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentTargetInput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The unique ID of a deployment target. </p>
    pub target_id: std::option::Option<std::string::String>,
}
impl GetDeploymentTargetInput {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The unique ID of a deployment target. </p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentTargetInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("target_id", &self.target_id);
        formatter.finish()
    }
}

/// <p> Represents the input of a <code>GetDeploymentInstance</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentInstanceInput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The unique ID of an instance in the deployment group. </p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl GetDeploymentInstanceInput {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The unique ID of an instance in the deployment group. </p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentInstanceInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentGroupInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of a deployment group for the specified application.</p>
    pub deployment_group_name: std::option::Option<std::string::String>,
}
impl GetDeploymentGroupInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of a deployment group for the specified application.</p>
    pub fn deployment_group_name(&self) -> std::option::Option<&str> {
        self.deployment_group_name.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentGroupInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_name", &self.deployment_group_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetDeploymentConfig</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentConfigInput {
    /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
}
impl GetDeploymentConfigInput {
    /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentConfigInput");
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetDeployment</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentInput {
    /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl GetDeploymentInput {
    /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetApplicationRevision</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationRevisionInput {
    /// <p>The name of the application that corresponds to the revision.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Information about the application revision to get, including type and location.</p>
    pub revision: std::option::Option<crate::model::RevisionLocation>,
}
impl GetApplicationRevisionInput {
    /// <p>The name of the application that corresponds to the revision.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Information about the application revision to get, including type and location.</p>
    pub fn revision(&self) -> std::option::Option<&crate::model::RevisionLocation> {
        self.revision.as_ref()
    }
}
impl std::fmt::Debug for GetApplicationRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationRevisionInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetApplication</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
}
impl GetApplicationInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
}
impl std::fmt::Debug for GetApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterOnPremisesInstanceInput {
    /// <p>The name of the on-premises instance to deregister.</p>
    pub instance_name: std::option::Option<std::string::String>,
}
impl DeregisterOnPremisesInstanceInput {
    /// <p>The name of the on-premises instance to deregister.</p>
    pub fn instance_name(&self) -> std::option::Option<&str> {
        self.instance_name.as_deref()
    }
}
impl std::fmt::Debug for DeregisterOnPremisesInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterOnPremisesInstanceInput");
        formatter.field("instance_name", &self.instance_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcesByExternalIdInput {
    /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl DeleteResourcesByExternalIdInput {
    /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourcesByExternalIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcesByExternalIdInput");
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteGitHubAccount</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGitHubAccountTokenInput {
    /// <p>The name of the GitHub account connection to delete.</p>
    pub token_name: std::option::Option<std::string::String>,
}
impl DeleteGitHubAccountTokenInput {
    /// <p>The name of the GitHub account connection to delete.</p>
    pub fn token_name(&self) -> std::option::Option<&str> {
        self.token_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteGitHubAccountTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGitHubAccountTokenInput");
        formatter.field("token_name", &self.token_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentGroupInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of a deployment group for the specified application.</p>
    pub deployment_group_name: std::option::Option<std::string::String>,
}
impl DeleteDeploymentGroupInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of a deployment group for the specified application.</p>
    pub fn deployment_group_name(&self) -> std::option::Option<&str> {
        self.deployment_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeploymentGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentGroupInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_name", &self.deployment_group_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteDeploymentConfig</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentConfigInput {
    /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
}
impl DeleteDeploymentConfigInput {
    /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeploymentConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentConfigInput");
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteApplication</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
}
impl DeleteApplicationInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentGroupInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of a new deployment group for the specified application.</p>
    pub deployment_group_name: std::option::Option<std::string::String>,
    /// <p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p>
    /// <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.</p>
    /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
    pub ec2_tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
    /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>
    pub on_premises_instance_tag_filters:
        std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
    /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
    pub auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub trigger_configurations: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
    /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>
    pub alarm_configuration: std::option::Option<crate::model::AlarmConfiguration>,
    /// <p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>
    pub auto_rollback_configuration: std::option::Option<crate::model::AutoRollbackConfiguration>,
    /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
    /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
    /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    pub outdated_instances_strategy: std::option::Option<crate::model::OutdatedInstancesStrategy>,
    /// <p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub deployment_style: std::option::Option<crate::model::DeploymentStyle>,
    /// <p>Information about blue/green deployment options for a deployment group.</p>
    pub blue_green_deployment_configuration:
        std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
    /// <p>Information about the load balancer used in a deployment.</p>
    pub load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
    /// <p>Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>
    pub ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
    /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. </p>
    pub ecs_services: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
    /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
    pub on_premises_tag_set: std::option::Option<crate::model::OnPremisesTagSet>,
    /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDeploymentGroupInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of a new deployment group for the specified application.</p>
    pub fn deployment_group_name(&self) -> std::option::Option<&str> {
        self.deployment_group_name.as_deref()
    }
    /// <p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p>
    /// <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.</p>
    /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
    /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
    pub fn ec2_tag_filters(&self) -> std::option::Option<&[crate::model::Ec2TagFilter]> {
        self.ec2_tag_filters.as_deref()
    }
    /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>
    pub fn on_premises_instance_tag_filters(
        &self,
    ) -> std::option::Option<&[crate::model::TagFilter]> {
        self.on_premises_instance_tag_filters.as_deref()
    }
    /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
    pub fn auto_scaling_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_scaling_groups.as_deref()
    }
    /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub fn trigger_configurations(&self) -> std::option::Option<&[crate::model::TriggerConfig]> {
        self.trigger_configurations.as_deref()
    }
    /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>
    pub fn alarm_configuration(&self) -> std::option::Option<&crate::model::AlarmConfiguration> {
        self.alarm_configuration.as_ref()
    }
    /// <p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>
    pub fn auto_rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoRollbackConfiguration> {
        self.auto_rollback_configuration.as_ref()
    }
    /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
    /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
    /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    pub fn outdated_instances_strategy(
        &self,
    ) -> std::option::Option<&crate::model::OutdatedInstancesStrategy> {
        self.outdated_instances_strategy.as_ref()
    }
    /// <p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub fn deployment_style(&self) -> std::option::Option<&crate::model::DeploymentStyle> {
        self.deployment_style.as_ref()
    }
    /// <p>Information about blue/green deployment options for a deployment group.</p>
    pub fn blue_green_deployment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::BlueGreenDeploymentConfiguration> {
        self.blue_green_deployment_configuration.as_ref()
    }
    /// <p>Information about the load balancer used in a deployment.</p>
    pub fn load_balancer_info(&self) -> std::option::Option<&crate::model::LoadBalancerInfo> {
        self.load_balancer_info.as_ref()
    }
    /// <p>Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>
    pub fn ec2_tag_set(&self) -> std::option::Option<&crate::model::Ec2TagSet> {
        self.ec2_tag_set.as_ref()
    }
    /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. </p>
    pub fn ecs_services(&self) -> std::option::Option<&[crate::model::EcsService]> {
        self.ecs_services.as_deref()
    }
    /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
    pub fn on_premises_tag_set(&self) -> std::option::Option<&crate::model::OnPremisesTagSet> {
        self.on_premises_tag_set.as_ref()
    }
    /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDeploymentGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentGroupInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_name", &self.deployment_group_name);
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.field("ec2_tag_filters", &self.ec2_tag_filters);
        formatter.field(
            "on_premises_instance_tag_filters",
            &self.on_premises_instance_tag_filters,
        );
        formatter.field("auto_scaling_groups", &self.auto_scaling_groups);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("trigger_configurations", &self.trigger_configurations);
        formatter.field("alarm_configuration", &self.alarm_configuration);
        formatter.field(
            "auto_rollback_configuration",
            &self.auto_rollback_configuration,
        );
        formatter.field(
            "outdated_instances_strategy",
            &self.outdated_instances_strategy,
        );
        formatter.field("deployment_style", &self.deployment_style);
        formatter.field(
            "blue_green_deployment_configuration",
            &self.blue_green_deployment_configuration,
        );
        formatter.field("load_balancer_info", &self.load_balancer_info);
        formatter.field("ec2_tag_set", &self.ec2_tag_set);
        formatter.field("ecs_services", &self.ecs_services);
        formatter.field("on_premises_tag_set", &self.on_premises_tag_set);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateDeploymentConfig</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentConfigInput {
    /// <p>The name of the deployment configuration to create.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
    /// <p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p>
    /// <p>The type parameter takes either of the following values:</p>
    /// <ul>
    /// <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li>
    /// <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li>
    /// </ul>
    /// <p>The value parameter takes an integer.</p>
    /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>
    pub minimum_healthy_hosts: std::option::Option<crate::model::MinimumHealthyHosts>,
    /// <p>The configuration that specifies how the deployment traffic is routed.</p>
    pub traffic_routing_config: std::option::Option<crate::model::TrafficRoutingConfig>,
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
}
impl CreateDeploymentConfigInput {
    /// <p>The name of the deployment configuration to create.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
    /// <p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p>
    /// <p>The type parameter takes either of the following values:</p>
    /// <ul>
    /// <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li>
    /// <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li>
    /// </ul>
    /// <p>The value parameter takes an integer.</p>
    /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>
    pub fn minimum_healthy_hosts(&self) -> std::option::Option<&crate::model::MinimumHealthyHosts> {
        self.minimum_healthy_hosts.as_ref()
    }
    /// <p>The configuration that specifies how the deployment traffic is routed.</p>
    pub fn traffic_routing_config(
        &self,
    ) -> std::option::Option<&crate::model::TrafficRoutingConfig> {
        self.traffic_routing_config.as_ref()
    }
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub fn compute_platform(&self) -> std::option::Option<&crate::model::ComputePlatform> {
        self.compute_platform.as_ref()
    }
}
impl std::fmt::Debug for CreateDeploymentConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentConfigInput");
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.field("minimum_healthy_hosts", &self.minimum_healthy_hosts);
        formatter.field("traffic_routing_config", &self.traffic_routing_config);
        formatter.field("compute_platform", &self.compute_platform);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateDeployment</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the deployment group.</p>
    pub deployment_group_name: std::option::Option<std::string::String>,
    /// <p> The type and location of the revision to deploy. </p>
    pub revision: std::option::Option<crate::model::RevisionLocation>,
    /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    /// <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
    /// <p>A comment about the deployment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
    /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
    /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
    /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
    pub ignore_application_stop_failures: bool,
    /// <p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>
    pub target_instances: std::option::Option<crate::model::TargetInstances>,
    /// <p>Configuration information for an automatic rollback that is added when a deployment is created.</p>
    pub auto_rollback_configuration: std::option::Option<crate::model::AutoRollbackConfiguration>,
    /// <p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>
    pub update_outdated_instances_only: bool,
    /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
    /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p>
    /// <ul>
    /// <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
    /// <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
    /// <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
    /// </ul>
    pub file_exists_behavior: std::option::Option<crate::model::FileExistsBehavior>,
}
impl CreateDeploymentInput {
    /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the deployment group.</p>
    pub fn deployment_group_name(&self) -> std::option::Option<&str> {
        self.deployment_group_name.as_deref()
    }
    /// <p> The type and location of the revision to deploy. </p>
    pub fn revision(&self) -> std::option::Option<&crate::model::RevisionLocation> {
        self.revision.as_ref()
    }
    /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    /// <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
    /// <p>A comment about the deployment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
    /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
    /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
    /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
    pub fn ignore_application_stop_failures(&self) -> bool {
        self.ignore_application_stop_failures
    }
    /// <p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>
    pub fn target_instances(&self) -> std::option::Option<&crate::model::TargetInstances> {
        self.target_instances.as_ref()
    }
    /// <p>Configuration information for an automatic rollback that is added when a deployment is created.</p>
    pub fn auto_rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoRollbackConfiguration> {
        self.auto_rollback_configuration.as_ref()
    }
    /// <p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>
    pub fn update_outdated_instances_only(&self) -> bool {
        self.update_outdated_instances_only
    }
    /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
    /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p>
    /// <ul>
    /// <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
    /// <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
    /// <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
    /// </ul>
    pub fn file_exists_behavior(&self) -> std::option::Option<&crate::model::FileExistsBehavior> {
        self.file_exists_behavior.as_ref()
    }
}
impl std::fmt::Debug for CreateDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_name", &self.deployment_group_name);
        formatter.field("revision", &self.revision);
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.field("description", &self.description);
        formatter.field(
            "ignore_application_stop_failures",
            &self.ignore_application_stop_failures,
        );
        formatter.field("target_instances", &self.target_instances);
        formatter.field(
            "auto_rollback_configuration",
            &self.auto_rollback_configuration,
        );
        formatter.field(
            "update_outdated_instances_only",
            &self.update_outdated_instances_only,
        );
        formatter.field("file_exists_behavior", &self.file_exists_behavior);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateApplication</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInput {
    /// <p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
    /// <p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateApplicationInput {
    /// <p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub fn compute_platform(&self) -> std::option::Option<&crate::model::ComputePlatform> {
        self.compute_platform.as_ref()
    }
    /// <p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("compute_platform", &self.compute_platform);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinueDeploymentInput {
    /// <p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>
    pub deployment_wait_type: std::option::Option<crate::model::DeploymentWaitType>,
}
impl ContinueDeploymentInput {
    /// <p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>
    pub fn deployment_wait_type(&self) -> std::option::Option<&crate::model::DeploymentWaitType> {
        self.deployment_wait_type.as_ref()
    }
}
impl std::fmt::Debug for ContinueDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinueDeploymentInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_wait_type", &self.deployment_wait_type);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetOnPremisesInstancesInput {
    /// <p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>
    pub instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetOnPremisesInstancesInput {
    /// <p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>
    pub fn instance_names(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_names.as_deref()
    }
}
impl std::fmt::Debug for BatchGetOnPremisesInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetOnPremisesInstancesInput");
        formatter.field("instance_names", &self.instance_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentTargetsInput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>
    /// <ul>
    /// <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li>
    /// <li> <p> For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li>
    /// <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. Their target type is <code>ecsTarget</code>. </p> </li>
    /// <li> <p> For deployments that are deployed with AWS CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li>
    /// </ul>
    pub target_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetDeploymentTargetsInput {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>
    /// <ul>
    /// <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li>
    /// <li> <p> For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li>
    /// <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. Their target type is <code>ecsTarget</code>. </p> </li>
    /// <li> <p> For deployments that are deployed with AWS CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li>
    /// </ul>
    pub fn target_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.target_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDeploymentTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentTargetsInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("target_ids", &self.target_ids);
        formatter.finish()
    }
}

/// <p> Represents the input of a <code>BatchGetDeployments</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentsInput {
    /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>
    pub deployment_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetDeploymentsInput {
    /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>
    pub fn deployment_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.deployment_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentsInput");
        formatter.field("deployment_ids", &self.deployment_ids);
        formatter.finish()
    }
}

/// <p> Represents the input of a <code>BatchGetDeploymentInstances</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentInstancesInput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetDeploymentInstancesInput {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDeploymentInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentInstancesInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>BatchGetDeploymentGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentGroupsInput {
    /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The names of the deployment groups.</p>
    pub deployment_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetDeploymentGroupsInput {
    /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The names of the deployment groups.</p>
    pub fn deployment_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.deployment_group_names.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDeploymentGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentGroupsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_names", &self.deployment_group_names);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>BatchGetApplications</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetApplicationsInput {
    /// <p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>
    pub application_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetApplicationsInput {
    /// <p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>
    pub fn application_names(&self) -> std::option::Option<&[std::string::String]> {
        self.application_names.as_deref()
    }
}
impl std::fmt::Debug for BatchGetApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetApplicationsInput");
        formatter.field("application_names", &self.application_names);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>BatchGetApplicationRevisions</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetApplicationRevisionsInput {
    /// <p>The name of an AWS CodeDeploy application about which to get revision information.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>
    pub revisions: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
}
impl BatchGetApplicationRevisionsInput {
    /// <p>The name of an AWS CodeDeploy application about which to get revision information.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>
    pub fn revisions(&self) -> std::option::Option<&[crate::model::RevisionLocation]> {
        self.revisions.as_deref()
    }
}
impl std::fmt::Debug for BatchGetApplicationRevisionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetApplicationRevisionsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("revisions", &self.revisions);
        formatter.finish()
    }
}

/// <p>Represents the input of, and adds tags to, an on-premises instance operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToOnPremisesInstancesInput {
    /// <p>The tag key-value pairs to add to the on-premises instances.</p>
    /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The names of the on-premises instances to which to add tags.</p>
    pub instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AddTagsToOnPremisesInstancesInput {
    /// <p>The tag key-value pairs to add to the on-premises instances.</p>
    /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The names of the on-premises instances to which to add tags.</p>
    pub fn instance_names(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_names.as_deref()
    }
}
impl std::fmt::Debug for AddTagsToOnPremisesInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToOnPremisesInstancesInput");
        formatter.field("tags", &self.tags);
        formatter.field("instance_names", &self.instance_names);
        formatter.finish()
    }
}
