// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroup {
    /// <p>The Auto Scaling group name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An Auto Scaling lifecycle event hook name.</p>
    pub hook: std::option::Option<std::string::String>,
}
impl AutoScalingGroup {
    /// <p>The Auto Scaling group name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An Auto Scaling lifecycle event hook name.</p>
    pub fn hook(&self) -> std::option::Option<&str> {
        self.hook.as_deref()
    }
}
impl std::fmt::Debug for AutoScalingGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroup");
        formatter.field("name", &self.name);
        formatter.field("hook", &self.hook);
        formatter.finish()
    }
}
/// See [`AutoScalingGroup`](crate::model::AutoScalingGroup)
pub mod auto_scaling_group {
    /// A builder for [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) hook: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Auto Scaling group name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The Auto Scaling group name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An Auto Scaling lifecycle event hook name.</p>
        pub fn hook(mut self, input: impl Into<std::string::String>) -> Self {
            self.hook = Some(input.into());
            self
        }
        /// <p>An Auto Scaling lifecycle event hook name.</p>
        pub fn set_hook(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hook = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroup`](crate::model::AutoScalingGroup)
        pub fn build(self) -> crate::model::AutoScalingGroup {
            crate::model::AutoScalingGroup {
                name: self.name,
                hook: self.hook,
            }
        }
    }
}
impl AutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    pub fn builder() -> crate::model::auto_scaling_group::Builder {
        crate::model::auto_scaling_group::Builder::default()
    }
}

/// <p>Information about groups of on-premises instance tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnPremisesTagSet {
    /// <p>A list that contains other lists of on-premises instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
    pub on_premises_tag_set_list:
        std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::TagFilter>>>,
}
impl OnPremisesTagSet {
    /// <p>A list that contains other lists of on-premises instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
    pub fn on_premises_tag_set_list(
        &self,
    ) -> std::option::Option<&[std::vec::Vec<crate::model::TagFilter>]> {
        self.on_premises_tag_set_list.as_deref()
    }
}
impl std::fmt::Debug for OnPremisesTagSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnPremisesTagSet");
        formatter.field("on_premises_tag_set_list", &self.on_premises_tag_set_list);
        formatter.finish()
    }
}
/// See [`OnPremisesTagSet`](crate::model::OnPremisesTagSet)
pub mod on_premises_tag_set {
    /// A builder for [`OnPremisesTagSet`](crate::model::OnPremisesTagSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) on_premises_tag_set_list:
            std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::TagFilter>>>,
    }
    impl Builder {
        /// Appends an item to `on_premises_tag_set_list`.
        ///
        /// To override the contents of this collection use [`set_on_premises_tag_set_list`](Self::set_on_premises_tag_set_list).
        ///
        /// <p>A list that contains other lists of on-premises instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
        pub fn on_premises_tag_set_list(
            mut self,
            input: std::vec::Vec<crate::model::TagFilter>,
        ) -> Self {
            let mut v = self.on_premises_tag_set_list.unwrap_or_default();
            v.push(input);
            self.on_premises_tag_set_list = Some(v);
            self
        }
        /// <p>A list that contains other lists of on-premises instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
        pub fn set_on_premises_tag_set_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::TagFilter>>>,
        ) -> Self {
            self.on_premises_tag_set_list = input;
            self
        }
        /// Consumes the builder and constructs a [`OnPremisesTagSet`](crate::model::OnPremisesTagSet)
        pub fn build(self) -> crate::model::OnPremisesTagSet {
            crate::model::OnPremisesTagSet {
                on_premises_tag_set_list: self.on_premises_tag_set_list,
            }
        }
    }
}
impl OnPremisesTagSet {
    /// Creates a new builder-style object to manufacture [`OnPremisesTagSet`](crate::model::OnPremisesTagSet)
    pub fn builder() -> crate::model::on_premises_tag_set::Builder {
        crate::model::on_premises_tag_set::Builder::default()
    }
}

/// <p>Information about an on-premises instance tag filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagFilter {
    /// <p>The on-premises instance tag filter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The on-premises instance tag filter value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The on-premises instance tag filter type:</p>
    /// <ul>
    /// <li> <p>KEY_ONLY: Key only.</p> </li>
    /// <li> <p>VALUE_ONLY: Value only.</p> </li>
    /// <li> <p>KEY_AND_VALUE: Key and value.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::TagFilterType>,
}
impl TagFilter {
    /// <p>The on-premises instance tag filter key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The on-premises instance tag filter value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The on-premises instance tag filter type:</p>
    /// <ul>
    /// <li> <p>KEY_ONLY: Key only.</p> </li>
    /// <li> <p>VALUE_ONLY: Value only.</p> </li>
    /// <li> <p>KEY_AND_VALUE: Key and value.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TagFilterType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for TagFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`TagFilter`](crate::model::TagFilter)
pub mod tag_filter {
    /// A builder for [`TagFilter`](crate::model::TagFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TagFilterType>,
    }
    impl Builder {
        /// <p>The on-premises instance tag filter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The on-premises instance tag filter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The on-premises instance tag filter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The on-premises instance tag filter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The on-premises instance tag filter type:</p>
        /// <ul>
        /// <li> <p>KEY_ONLY: Key only.</p> </li>
        /// <li> <p>VALUE_ONLY: Value only.</p> </li>
        /// <li> <p>KEY_AND_VALUE: Key and value.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::TagFilterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The on-premises instance tag filter type:</p>
        /// <ul>
        /// <li> <p>KEY_ONLY: Key only.</p> </li>
        /// <li> <p>VALUE_ONLY: Value only.</p> </li>
        /// <li> <p>KEY_AND_VALUE: Key and value.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TagFilterType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`TagFilter`](crate::model::TagFilter)
        pub fn build(self) -> crate::model::TagFilter {
            crate::model::TagFilter {
                key: self.key,
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl TagFilter {
    /// Creates a new builder-style object to manufacture [`TagFilter`](crate::model::TagFilter)
    pub fn builder() -> crate::model::tag_filter::Builder {
        crate::model::tag_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TagFilterType {
    #[allow(missing_docs)] // documentation missing in model
    KeyAndValue,
    #[allow(missing_docs)] // documentation missing in model
    KeyOnly,
    #[allow(missing_docs)] // documentation missing in model
    ValueOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TagFilterType {
    fn from(s: &str) -> Self {
        match s {
            "KEY_AND_VALUE" => TagFilterType::KeyAndValue,
            "KEY_ONLY" => TagFilterType::KeyOnly,
            "VALUE_ONLY" => TagFilterType::ValueOnly,
            other => TagFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TagFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TagFilterType::from(s))
    }
}
impl TagFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TagFilterType::KeyAndValue => "KEY_AND_VALUE",
            TagFilterType::KeyOnly => "KEY_ONLY",
            TagFilterType::ValueOnly => "VALUE_ONLY",
            TagFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KEY_AND_VALUE", "KEY_ONLY", "VALUE_ONLY"]
    }
}
impl AsRef<str> for TagFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains the service and cluster names used to identify an Amazon ECS deployment's target. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EcsService {
    /// <p> The name of the target Amazon ECS service. </p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p> The name of the cluster that the Amazon ECS service is associated with. </p>
    pub cluster_name: std::option::Option<std::string::String>,
}
impl EcsService {
    /// <p> The name of the target Amazon ECS service. </p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p> The name of the cluster that the Amazon ECS service is associated with. </p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
}
impl std::fmt::Debug for EcsService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EcsService");
        formatter.field("service_name", &self.service_name);
        formatter.field("cluster_name", &self.cluster_name);
        formatter.finish()
    }
}
/// See [`EcsService`](crate::model::EcsService)
pub mod ecs_service {
    /// A builder for [`EcsService`](crate::model::EcsService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the target Amazon ECS service. </p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p> The name of the target Amazon ECS service. </p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p> The name of the cluster that the Amazon ECS service is associated with. </p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p> The name of the cluster that the Amazon ECS service is associated with. </p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EcsService`](crate::model::EcsService)
        pub fn build(self) -> crate::model::EcsService {
            crate::model::EcsService {
                service_name: self.service_name,
                cluster_name: self.cluster_name,
            }
        }
    }
}
impl EcsService {
    /// Creates a new builder-style object to manufacture [`EcsService`](crate::model::EcsService)
    pub fn builder() -> crate::model::ecs_service::Builder {
        crate::model::ecs_service::Builder::default()
    }
}

/// <p>Information about groups of EC2 instance tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2TagSet {
    /// <p>A list that contains other lists of EC2 instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
    pub ec2_tag_set_list:
        std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::Ec2TagFilter>>>,
}
impl Ec2TagSet {
    /// <p>A list that contains other lists of EC2 instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
    pub fn ec2_tag_set_list(
        &self,
    ) -> std::option::Option<&[std::vec::Vec<crate::model::Ec2TagFilter>]> {
        self.ec2_tag_set_list.as_deref()
    }
}
impl std::fmt::Debug for Ec2TagSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2TagSet");
        formatter.field("ec2_tag_set_list", &self.ec2_tag_set_list);
        formatter.finish()
    }
}
/// See [`Ec2TagSet`](crate::model::Ec2TagSet)
pub mod ec2_tag_set {
    /// A builder for [`Ec2TagSet`](crate::model::Ec2TagSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_tag_set_list:
            std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::Ec2TagFilter>>>,
    }
    impl Builder {
        /// Appends an item to `ec2_tag_set_list`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_set_list`](Self::set_ec2_tag_set_list).
        ///
        /// <p>A list that contains other lists of EC2 instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
        pub fn ec2_tag_set_list(
            mut self,
            input: std::vec::Vec<crate::model::Ec2TagFilter>,
        ) -> Self {
            let mut v = self.ec2_tag_set_list.unwrap_or_default();
            v.push(input);
            self.ec2_tag_set_list = Some(v);
            self
        }
        /// <p>A list that contains other lists of EC2 instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>
        pub fn set_ec2_tag_set_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::Ec2TagFilter>>>,
        ) -> Self {
            self.ec2_tag_set_list = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2TagSet`](crate::model::Ec2TagSet)
        pub fn build(self) -> crate::model::Ec2TagSet {
            crate::model::Ec2TagSet {
                ec2_tag_set_list: self.ec2_tag_set_list,
            }
        }
    }
}
impl Ec2TagSet {
    /// Creates a new builder-style object to manufacture [`Ec2TagSet`](crate::model::Ec2TagSet)
    pub fn builder() -> crate::model::ec2_tag_set::Builder {
        crate::model::ec2_tag_set::Builder::default()
    }
}

/// <p>Information about an EC2 tag filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2TagFilter {
    /// <p>The tag filter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag filter value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The tag filter type:</p>
    /// <ul>
    /// <li> <p> <code>KEY_ONLY</code>: Key only.</p> </li>
    /// <li> <p> <code>VALUE_ONLY</code>: Value only.</p> </li>
    /// <li> <p> <code>KEY_AND_VALUE</code>: Key and value.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::Ec2TagFilterType>,
}
impl Ec2TagFilter {
    /// <p>The tag filter key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag filter value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The tag filter type:</p>
    /// <ul>
    /// <li> <p> <code>KEY_ONLY</code>: Key only.</p> </li>
    /// <li> <p> <code>VALUE_ONLY</code>: Value only.</p> </li>
    /// <li> <p> <code>KEY_AND_VALUE</code>: Key and value.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Ec2TagFilterType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Ec2TagFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2TagFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Ec2TagFilter`](crate::model::Ec2TagFilter)
pub mod ec2_tag_filter {
    /// A builder for [`Ec2TagFilter`](crate::model::Ec2TagFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::Ec2TagFilterType>,
    }
    impl Builder {
        /// <p>The tag filter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag filter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag filter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag filter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The tag filter type:</p>
        /// <ul>
        /// <li> <p> <code>KEY_ONLY</code>: Key only.</p> </li>
        /// <li> <p> <code>VALUE_ONLY</code>: Value only.</p> </li>
        /// <li> <p> <code>KEY_AND_VALUE</code>: Key and value.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::Ec2TagFilterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The tag filter type:</p>
        /// <ul>
        /// <li> <p> <code>KEY_ONLY</code>: Key only.</p> </li>
        /// <li> <p> <code>VALUE_ONLY</code>: Value only.</p> </li>
        /// <li> <p> <code>KEY_AND_VALUE</code>: Key and value.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::Ec2TagFilterType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2TagFilter`](crate::model::Ec2TagFilter)
        pub fn build(self) -> crate::model::Ec2TagFilter {
            crate::model::Ec2TagFilter {
                key: self.key,
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl Ec2TagFilter {
    /// Creates a new builder-style object to manufacture [`Ec2TagFilter`](crate::model::Ec2TagFilter)
    pub fn builder() -> crate::model::ec2_tag_filter::Builder {
        crate::model::ec2_tag_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Ec2TagFilterType {
    #[allow(missing_docs)] // documentation missing in model
    KeyAndValue,
    #[allow(missing_docs)] // documentation missing in model
    KeyOnly,
    #[allow(missing_docs)] // documentation missing in model
    ValueOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Ec2TagFilterType {
    fn from(s: &str) -> Self {
        match s {
            "KEY_AND_VALUE" => Ec2TagFilterType::KeyAndValue,
            "KEY_ONLY" => Ec2TagFilterType::KeyOnly,
            "VALUE_ONLY" => Ec2TagFilterType::ValueOnly,
            other => Ec2TagFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Ec2TagFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Ec2TagFilterType::from(s))
    }
}
impl Ec2TagFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Ec2TagFilterType::KeyAndValue => "KEY_AND_VALUE",
            Ec2TagFilterType::KeyOnly => "KEY_ONLY",
            Ec2TagFilterType::ValueOnly => "VALUE_ONLY",
            Ec2TagFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KEY_AND_VALUE", "KEY_ONLY", "VALUE_ONLY"]
    }
}
impl AsRef<str> for Ec2TagFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the Elastic Load Balancing load balancer or target group used in a deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerInfo {
    /// <p>An array that contains information about the load balancer to use for load balancing in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p> <note>
    /// <p> Adding more than one load balancer to the array is not supported. </p>
    /// </note>
    pub elb_info_list: std::option::Option<std::vec::Vec<crate::model::ElbInfo>>,
    /// <p>An array that contains information about the target group to use for load balancing in a deployment. In Elastic Load Balancing, target groups are used with Application Load Balancers.</p> <note>
    /// <p> Adding more than one target group to the array is not supported. </p>
    /// </note>
    pub target_group_info_list: std::option::Option<std::vec::Vec<crate::model::TargetGroupInfo>>,
    /// <p> The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one. </p>
    pub target_group_pair_info_list:
        std::option::Option<std::vec::Vec<crate::model::TargetGroupPairInfo>>,
}
impl LoadBalancerInfo {
    /// <p>An array that contains information about the load balancer to use for load balancing in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p> <note>
    /// <p> Adding more than one load balancer to the array is not supported. </p>
    /// </note>
    pub fn elb_info_list(&self) -> std::option::Option<&[crate::model::ElbInfo]> {
        self.elb_info_list.as_deref()
    }
    /// <p>An array that contains information about the target group to use for load balancing in a deployment. In Elastic Load Balancing, target groups are used with Application Load Balancers.</p> <note>
    /// <p> Adding more than one target group to the array is not supported. </p>
    /// </note>
    pub fn target_group_info_list(&self) -> std::option::Option<&[crate::model::TargetGroupInfo]> {
        self.target_group_info_list.as_deref()
    }
    /// <p> The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one. </p>
    pub fn target_group_pair_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::TargetGroupPairInfo]> {
        self.target_group_pair_info_list.as_deref()
    }
}
impl std::fmt::Debug for LoadBalancerInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerInfo");
        formatter.field("elb_info_list", &self.elb_info_list);
        formatter.field("target_group_info_list", &self.target_group_info_list);
        formatter.field(
            "target_group_pair_info_list",
            &self.target_group_pair_info_list,
        );
        formatter.finish()
    }
}
/// See [`LoadBalancerInfo`](crate::model::LoadBalancerInfo)
pub mod load_balancer_info {
    /// A builder for [`LoadBalancerInfo`](crate::model::LoadBalancerInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elb_info_list: std::option::Option<std::vec::Vec<crate::model::ElbInfo>>,
        pub(crate) target_group_info_list:
            std::option::Option<std::vec::Vec<crate::model::TargetGroupInfo>>,
        pub(crate) target_group_pair_info_list:
            std::option::Option<std::vec::Vec<crate::model::TargetGroupPairInfo>>,
    }
    impl Builder {
        /// Appends an item to `elb_info_list`.
        ///
        /// To override the contents of this collection use [`set_elb_info_list`](Self::set_elb_info_list).
        ///
        /// <p>An array that contains information about the load balancer to use for load balancing in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p> <note>
        /// <p> Adding more than one load balancer to the array is not supported. </p>
        /// </note>
        pub fn elb_info_list(mut self, input: crate::model::ElbInfo) -> Self {
            let mut v = self.elb_info_list.unwrap_or_default();
            v.push(input);
            self.elb_info_list = Some(v);
            self
        }
        /// <p>An array that contains information about the load balancer to use for load balancing in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p> <note>
        /// <p> Adding more than one load balancer to the array is not supported. </p>
        /// </note>
        pub fn set_elb_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ElbInfo>>,
        ) -> Self {
            self.elb_info_list = input;
            self
        }
        /// Appends an item to `target_group_info_list`.
        ///
        /// To override the contents of this collection use [`set_target_group_info_list`](Self::set_target_group_info_list).
        ///
        /// <p>An array that contains information about the target group to use for load balancing in a deployment. In Elastic Load Balancing, target groups are used with Application Load Balancers.</p> <note>
        /// <p> Adding more than one target group to the array is not supported. </p>
        /// </note>
        pub fn target_group_info_list(mut self, input: crate::model::TargetGroupInfo) -> Self {
            let mut v = self.target_group_info_list.unwrap_or_default();
            v.push(input);
            self.target_group_info_list = Some(v);
            self
        }
        /// <p>An array that contains information about the target group to use for load balancing in a deployment. In Elastic Load Balancing, target groups are used with Application Load Balancers.</p> <note>
        /// <p> Adding more than one target group to the array is not supported. </p>
        /// </note>
        pub fn set_target_group_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupInfo>>,
        ) -> Self {
            self.target_group_info_list = input;
            self
        }
        /// Appends an item to `target_group_pair_info_list`.
        ///
        /// To override the contents of this collection use [`set_target_group_pair_info_list`](Self::set_target_group_pair_info_list).
        ///
        /// <p> The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one. </p>
        pub fn target_group_pair_info_list(
            mut self,
            input: crate::model::TargetGroupPairInfo,
        ) -> Self {
            let mut v = self.target_group_pair_info_list.unwrap_or_default();
            v.push(input);
            self.target_group_pair_info_list = Some(v);
            self
        }
        /// <p> The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one. </p>
        pub fn set_target_group_pair_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupPairInfo>>,
        ) -> Self {
            self.target_group_pair_info_list = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerInfo`](crate::model::LoadBalancerInfo)
        pub fn build(self) -> crate::model::LoadBalancerInfo {
            crate::model::LoadBalancerInfo {
                elb_info_list: self.elb_info_list,
                target_group_info_list: self.target_group_info_list,
                target_group_pair_info_list: self.target_group_pair_info_list,
            }
        }
    }
}
impl LoadBalancerInfo {
    /// Creates a new builder-style object to manufacture [`LoadBalancerInfo`](crate::model::LoadBalancerInfo)
    pub fn builder() -> crate::model::load_balancer_info::Builder {
        crate::model::load_balancer_info::Builder::default()
    }
}

/// <p> Information about two target groups and how traffic is routed during an Amazon ECS deployment. An optional test traffic route can be specified. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetGroupPairInfo {
    /// <p> One pair of target groups. One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete. </p>
    pub target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroupInfo>>,
    /// <p> The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete. </p>
    pub prod_traffic_route: std::option::Option<crate::model::TrafficRoute>,
    /// <p> An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can occur while test traffic is served during a deployment. </p>
    pub test_traffic_route: std::option::Option<crate::model::TrafficRoute>,
}
impl TargetGroupPairInfo {
    /// <p> One pair of target groups. One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete. </p>
    pub fn target_groups(&self) -> std::option::Option<&[crate::model::TargetGroupInfo]> {
        self.target_groups.as_deref()
    }
    /// <p> The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete. </p>
    pub fn prod_traffic_route(&self) -> std::option::Option<&crate::model::TrafficRoute> {
        self.prod_traffic_route.as_ref()
    }
    /// <p> An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can occur while test traffic is served during a deployment. </p>
    pub fn test_traffic_route(&self) -> std::option::Option<&crate::model::TrafficRoute> {
        self.test_traffic_route.as_ref()
    }
}
impl std::fmt::Debug for TargetGroupPairInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetGroupPairInfo");
        formatter.field("target_groups", &self.target_groups);
        formatter.field("prod_traffic_route", &self.prod_traffic_route);
        formatter.field("test_traffic_route", &self.test_traffic_route);
        formatter.finish()
    }
}
/// See [`TargetGroupPairInfo`](crate::model::TargetGroupPairInfo)
pub mod target_group_pair_info {
    /// A builder for [`TargetGroupPairInfo`](crate::model::TargetGroupPairInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroupInfo>>,
        pub(crate) prod_traffic_route: std::option::Option<crate::model::TrafficRoute>,
        pub(crate) test_traffic_route: std::option::Option<crate::model::TrafficRoute>,
    }
    impl Builder {
        /// Appends an item to `target_groups`.
        ///
        /// To override the contents of this collection use [`set_target_groups`](Self::set_target_groups).
        ///
        /// <p> One pair of target groups. One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete. </p>
        pub fn target_groups(mut self, input: crate::model::TargetGroupInfo) -> Self {
            let mut v = self.target_groups.unwrap_or_default();
            v.push(input);
            self.target_groups = Some(v);
            self
        }
        /// <p> One pair of target groups. One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete. </p>
        pub fn set_target_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupInfo>>,
        ) -> Self {
            self.target_groups = input;
            self
        }
        /// <p> The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete. </p>
        pub fn prod_traffic_route(mut self, input: crate::model::TrafficRoute) -> Self {
            self.prod_traffic_route = Some(input);
            self
        }
        /// <p> The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete. </p>
        pub fn set_prod_traffic_route(
            mut self,
            input: std::option::Option<crate::model::TrafficRoute>,
        ) -> Self {
            self.prod_traffic_route = input;
            self
        }
        /// <p> An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can occur while test traffic is served during a deployment. </p>
        pub fn test_traffic_route(mut self, input: crate::model::TrafficRoute) -> Self {
            self.test_traffic_route = Some(input);
            self
        }
        /// <p> An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can occur while test traffic is served during a deployment. </p>
        pub fn set_test_traffic_route(
            mut self,
            input: std::option::Option<crate::model::TrafficRoute>,
        ) -> Self {
            self.test_traffic_route = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetGroupPairInfo`](crate::model::TargetGroupPairInfo)
        pub fn build(self) -> crate::model::TargetGroupPairInfo {
            crate::model::TargetGroupPairInfo {
                target_groups: self.target_groups,
                prod_traffic_route: self.prod_traffic_route,
                test_traffic_route: self.test_traffic_route,
            }
        }
    }
}
impl TargetGroupPairInfo {
    /// Creates a new builder-style object to manufacture [`TargetGroupPairInfo`](crate::model::TargetGroupPairInfo)
    pub fn builder() -> crate::model::target_group_pair_info::Builder {
        crate::model::target_group_pair_info::Builder::default()
    }
}

/// <p> Information about a listener. The listener contains the path used to route traffic that is received from the load balancer to a target group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrafficRoute {
    /// <p> The Amazon Resource Name (ARN) of one listener. The listener identifies the route between a target group and a load balancer. This is an array of strings with a maximum size of one. </p>
    pub listener_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TrafficRoute {
    /// <p> The Amazon Resource Name (ARN) of one listener. The listener identifies the route between a target group and a load balancer. This is an array of strings with a maximum size of one. </p>
    pub fn listener_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.listener_arns.as_deref()
    }
}
impl std::fmt::Debug for TrafficRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrafficRoute");
        formatter.field("listener_arns", &self.listener_arns);
        formatter.finish()
    }
}
/// See [`TrafficRoute`](crate::model::TrafficRoute)
pub mod traffic_route {
    /// A builder for [`TrafficRoute`](crate::model::TrafficRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `listener_arns`.
        ///
        /// To override the contents of this collection use [`set_listener_arns`](Self::set_listener_arns).
        ///
        /// <p> The Amazon Resource Name (ARN) of one listener. The listener identifies the route between a target group and a load balancer. This is an array of strings with a maximum size of one. </p>
        pub fn listener_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.listener_arns.unwrap_or_default();
            v.push(input.into());
            self.listener_arns = Some(v);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of one listener. The listener identifies the route between a target group and a load balancer. This is an array of strings with a maximum size of one. </p>
        pub fn set_listener_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.listener_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`TrafficRoute`](crate::model::TrafficRoute)
        pub fn build(self) -> crate::model::TrafficRoute {
            crate::model::TrafficRoute {
                listener_arns: self.listener_arns,
            }
        }
    }
}
impl TrafficRoute {
    /// Creates a new builder-style object to manufacture [`TrafficRoute`](crate::model::TrafficRoute)
    pub fn builder() -> crate::model::traffic_route::Builder {
        crate::model::traffic_route::Builder::default()
    }
}

/// <p>Information about a target group in Elastic Load Balancing to use in a deployment. Instances are registered as targets in a target group, and traffic is routed to the target group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetGroupInfo {
    /// <p>For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment are registered with. For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete. </p>
    pub name: std::option::Option<std::string::String>,
}
impl TargetGroupInfo {
    /// <p>For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment are registered with. For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for TargetGroupInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetGroupInfo");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`TargetGroupInfo`](crate::model::TargetGroupInfo)
pub mod target_group_info {
    /// A builder for [`TargetGroupInfo`](crate::model::TargetGroupInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment are registered with. For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment are registered with. For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetGroupInfo`](crate::model::TargetGroupInfo)
        pub fn build(self) -> crate::model::TargetGroupInfo {
            crate::model::TargetGroupInfo { name: self.name }
        }
    }
}
impl TargetGroupInfo {
    /// Creates a new builder-style object to manufacture [`TargetGroupInfo`](crate::model::TargetGroupInfo)
    pub fn builder() -> crate::model::target_group_info::Builder {
        crate::model::target_group_info::Builder::default()
    }
}

/// <p>Information about a load balancer in Elastic Load Balancing to use in a deployment. Instances are registered directly with a load balancer, and traffic is routed to the load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElbInfo {
    /// <p>For blue/green deployments, the name of the load balancer that is used to route traffic from original instances to replacement instances in a blue/green deployment. For in-place deployments, the name of the load balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ElbInfo {
    /// <p>For blue/green deployments, the name of the load balancer that is used to route traffic from original instances to replacement instances in a blue/green deployment. For in-place deployments, the name of the load balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ElbInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElbInfo");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ElbInfo`](crate::model::ElbInfo)
pub mod elb_info {
    /// A builder for [`ElbInfo`](crate::model::ElbInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>For blue/green deployments, the name of the load balancer that is used to route traffic from original instances to replacement instances in a blue/green deployment. For in-place deployments, the name of the load balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>For blue/green deployments, the name of the load balancer that is used to route traffic from original instances to replacement instances in a blue/green deployment. For in-place deployments, the name of the load balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ElbInfo`](crate::model::ElbInfo)
        pub fn build(self) -> crate::model::ElbInfo {
            crate::model::ElbInfo { name: self.name }
        }
    }
}
impl ElbInfo {
    /// Creates a new builder-style object to manufacture [`ElbInfo`](crate::model::ElbInfo)
    pub fn builder() -> crate::model::elb_info::Builder {
        crate::model::elb_info::Builder::default()
    }
}

/// <p>Information about blue/green deployment options for a deployment group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlueGreenDeploymentConfiguration {
    /// <p>Information about whether to terminate instances in the original fleet during a blue/green deployment.</p>
    pub terminate_blue_instances_on_deployment_success:
        std::option::Option<crate::model::BlueInstanceTerminationOption>,
    /// <p>Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.</p>
    pub deployment_ready_option: std::option::Option<crate::model::DeploymentReadyOption>,
    /// <p>Information about how instances are provisioned for a replacement environment in a blue/green deployment.</p>
    pub green_fleet_provisioning_option:
        std::option::Option<crate::model::GreenFleetProvisioningOption>,
}
impl BlueGreenDeploymentConfiguration {
    /// <p>Information about whether to terminate instances in the original fleet during a blue/green deployment.</p>
    pub fn terminate_blue_instances_on_deployment_success(
        &self,
    ) -> std::option::Option<&crate::model::BlueInstanceTerminationOption> {
        self.terminate_blue_instances_on_deployment_success.as_ref()
    }
    /// <p>Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.</p>
    pub fn deployment_ready_option(
        &self,
    ) -> std::option::Option<&crate::model::DeploymentReadyOption> {
        self.deployment_ready_option.as_ref()
    }
    /// <p>Information about how instances are provisioned for a replacement environment in a blue/green deployment.</p>
    pub fn green_fleet_provisioning_option(
        &self,
    ) -> std::option::Option<&crate::model::GreenFleetProvisioningOption> {
        self.green_fleet_provisioning_option.as_ref()
    }
}
impl std::fmt::Debug for BlueGreenDeploymentConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlueGreenDeploymentConfiguration");
        formatter.field(
            "terminate_blue_instances_on_deployment_success",
            &self.terminate_blue_instances_on_deployment_success,
        );
        formatter.field("deployment_ready_option", &self.deployment_ready_option);
        formatter.field(
            "green_fleet_provisioning_option",
            &self.green_fleet_provisioning_option,
        );
        formatter.finish()
    }
}
/// See [`BlueGreenDeploymentConfiguration`](crate::model::BlueGreenDeploymentConfiguration)
pub mod blue_green_deployment_configuration {
    /// A builder for [`BlueGreenDeploymentConfiguration`](crate::model::BlueGreenDeploymentConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) terminate_blue_instances_on_deployment_success:
            std::option::Option<crate::model::BlueInstanceTerminationOption>,
        pub(crate) deployment_ready_option:
            std::option::Option<crate::model::DeploymentReadyOption>,
        pub(crate) green_fleet_provisioning_option:
            std::option::Option<crate::model::GreenFleetProvisioningOption>,
    }
    impl Builder {
        /// <p>Information about whether to terminate instances in the original fleet during a blue/green deployment.</p>
        pub fn terminate_blue_instances_on_deployment_success(
            mut self,
            input: crate::model::BlueInstanceTerminationOption,
        ) -> Self {
            self.terminate_blue_instances_on_deployment_success = Some(input);
            self
        }
        /// <p>Information about whether to terminate instances in the original fleet during a blue/green deployment.</p>
        pub fn set_terminate_blue_instances_on_deployment_success(
            mut self,
            input: std::option::Option<crate::model::BlueInstanceTerminationOption>,
        ) -> Self {
            self.terminate_blue_instances_on_deployment_success = input;
            self
        }
        /// <p>Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.</p>
        pub fn deployment_ready_option(
            mut self,
            input: crate::model::DeploymentReadyOption,
        ) -> Self {
            self.deployment_ready_option = Some(input);
            self
        }
        /// <p>Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.</p>
        pub fn set_deployment_ready_option(
            mut self,
            input: std::option::Option<crate::model::DeploymentReadyOption>,
        ) -> Self {
            self.deployment_ready_option = input;
            self
        }
        /// <p>Information about how instances are provisioned for a replacement environment in a blue/green deployment.</p>
        pub fn green_fleet_provisioning_option(
            mut self,
            input: crate::model::GreenFleetProvisioningOption,
        ) -> Self {
            self.green_fleet_provisioning_option = Some(input);
            self
        }
        /// <p>Information about how instances are provisioned for a replacement environment in a blue/green deployment.</p>
        pub fn set_green_fleet_provisioning_option(
            mut self,
            input: std::option::Option<crate::model::GreenFleetProvisioningOption>,
        ) -> Self {
            self.green_fleet_provisioning_option = input;
            self
        }
        /// Consumes the builder and constructs a [`BlueGreenDeploymentConfiguration`](crate::model::BlueGreenDeploymentConfiguration)
        pub fn build(self) -> crate::model::BlueGreenDeploymentConfiguration {
            crate::model::BlueGreenDeploymentConfiguration {
                terminate_blue_instances_on_deployment_success: self
                    .terminate_blue_instances_on_deployment_success,
                deployment_ready_option: self.deployment_ready_option,
                green_fleet_provisioning_option: self.green_fleet_provisioning_option,
            }
        }
    }
}
impl BlueGreenDeploymentConfiguration {
    /// Creates a new builder-style object to manufacture [`BlueGreenDeploymentConfiguration`](crate::model::BlueGreenDeploymentConfiguration)
    pub fn builder() -> crate::model::blue_green_deployment_configuration::Builder {
        crate::model::blue_green_deployment_configuration::Builder::default()
    }
}

/// <p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GreenFleetProvisioningOption {
    /// <p>The method used to add instances to a replacement environment.</p>
    /// <ul>
    /// <li> <p> <code>DISCOVER_EXISTING</code>: Use instances that already exist or will be created manually.</p> </li>
    /// <li> <p> <code>COPY_AUTO_SCALING_GROUP</code>: Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</p> </li>
    /// </ul>
    pub action: std::option::Option<crate::model::GreenFleetProvisioningAction>,
}
impl GreenFleetProvisioningOption {
    /// <p>The method used to add instances to a replacement environment.</p>
    /// <ul>
    /// <li> <p> <code>DISCOVER_EXISTING</code>: Use instances that already exist or will be created manually.</p> </li>
    /// <li> <p> <code>COPY_AUTO_SCALING_GROUP</code>: Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</p> </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::GreenFleetProvisioningAction> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for GreenFleetProvisioningOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GreenFleetProvisioningOption");
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`GreenFleetProvisioningOption`](crate::model::GreenFleetProvisioningOption)
pub mod green_fleet_provisioning_option {
    /// A builder for [`GreenFleetProvisioningOption`](crate::model::GreenFleetProvisioningOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::GreenFleetProvisioningAction>,
    }
    impl Builder {
        /// <p>The method used to add instances to a replacement environment.</p>
        /// <ul>
        /// <li> <p> <code>DISCOVER_EXISTING</code>: Use instances that already exist or will be created manually.</p> </li>
        /// <li> <p> <code>COPY_AUTO_SCALING_GROUP</code>: Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</p> </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::GreenFleetProvisioningAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The method used to add instances to a replacement environment.</p>
        /// <ul>
        /// <li> <p> <code>DISCOVER_EXISTING</code>: Use instances that already exist or will be created manually.</p> </li>
        /// <li> <p> <code>COPY_AUTO_SCALING_GROUP</code>: Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</p> </li>
        /// </ul>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::GreenFleetProvisioningAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`GreenFleetProvisioningOption`](crate::model::GreenFleetProvisioningOption)
        pub fn build(self) -> crate::model::GreenFleetProvisioningOption {
            crate::model::GreenFleetProvisioningOption {
                action: self.action,
            }
        }
    }
}
impl GreenFleetProvisioningOption {
    /// Creates a new builder-style object to manufacture [`GreenFleetProvisioningOption`](crate::model::GreenFleetProvisioningOption)
    pub fn builder() -> crate::model::green_fleet_provisioning_option::Builder {
        crate::model::green_fleet_provisioning_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GreenFleetProvisioningAction {
    #[allow(missing_docs)] // documentation missing in model
    CopyAutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    DiscoverExisting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GreenFleetProvisioningAction {
    fn from(s: &str) -> Self {
        match s {
            "COPY_AUTO_SCALING_GROUP" => GreenFleetProvisioningAction::CopyAutoScalingGroup,
            "DISCOVER_EXISTING" => GreenFleetProvisioningAction::DiscoverExisting,
            other => GreenFleetProvisioningAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GreenFleetProvisioningAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GreenFleetProvisioningAction::from(s))
    }
}
impl GreenFleetProvisioningAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GreenFleetProvisioningAction::CopyAutoScalingGroup => "COPY_AUTO_SCALING_GROUP",
            GreenFleetProvisioningAction::DiscoverExisting => "DISCOVER_EXISTING",
            GreenFleetProvisioningAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COPY_AUTO_SCALING_GROUP", "DISCOVER_EXISTING"]
    }
}
impl AsRef<str> for GreenFleetProvisioningAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about how traffic is rerouted to instances in a replacement environment in a blue/green deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentReadyOption {
    /// <p>Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.</p>
    /// <ul>
    /// <li> <p>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</p> </li>
    /// <li> <p>STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using <code>ContinueDeployment</code>. If traffic rerouting is not started before the end of the specified wait period, the deployment status is changed to Stopped.</p> </li>
    /// </ul>
    pub action_on_timeout: std::option::Option<crate::model::DeploymentReadyAction>,
    /// <p>The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is not started manually. Applies only to the <code>STOP_DEPLOYMENT</code> option for <code>actionOnTimeout</code>.</p>
    pub wait_time_in_minutes: i32,
}
impl DeploymentReadyOption {
    /// <p>Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.</p>
    /// <ul>
    /// <li> <p>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</p> </li>
    /// <li> <p>STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using <code>ContinueDeployment</code>. If traffic rerouting is not started before the end of the specified wait period, the deployment status is changed to Stopped.</p> </li>
    /// </ul>
    pub fn action_on_timeout(&self) -> std::option::Option<&crate::model::DeploymentReadyAction> {
        self.action_on_timeout.as_ref()
    }
    /// <p>The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is not started manually. Applies only to the <code>STOP_DEPLOYMENT</code> option for <code>actionOnTimeout</code>.</p>
    pub fn wait_time_in_minutes(&self) -> i32 {
        self.wait_time_in_minutes
    }
}
impl std::fmt::Debug for DeploymentReadyOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentReadyOption");
        formatter.field("action_on_timeout", &self.action_on_timeout);
        formatter.field("wait_time_in_minutes", &self.wait_time_in_minutes);
        formatter.finish()
    }
}
/// See [`DeploymentReadyOption`](crate::model::DeploymentReadyOption)
pub mod deployment_ready_option {
    /// A builder for [`DeploymentReadyOption`](crate::model::DeploymentReadyOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_on_timeout: std::option::Option<crate::model::DeploymentReadyAction>,
        pub(crate) wait_time_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.</p>
        /// <ul>
        /// <li> <p>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</p> </li>
        /// <li> <p>STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using <code>ContinueDeployment</code>. If traffic rerouting is not started before the end of the specified wait period, the deployment status is changed to Stopped.</p> </li>
        /// </ul>
        pub fn action_on_timeout(mut self, input: crate::model::DeploymentReadyAction) -> Self {
            self.action_on_timeout = Some(input);
            self
        }
        /// <p>Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.</p>
        /// <ul>
        /// <li> <p>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</p> </li>
        /// <li> <p>STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using <code>ContinueDeployment</code>. If traffic rerouting is not started before the end of the specified wait period, the deployment status is changed to Stopped.</p> </li>
        /// </ul>
        pub fn set_action_on_timeout(
            mut self,
            input: std::option::Option<crate::model::DeploymentReadyAction>,
        ) -> Self {
            self.action_on_timeout = input;
            self
        }
        /// <p>The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is not started manually. Applies only to the <code>STOP_DEPLOYMENT</code> option for <code>actionOnTimeout</code>.</p>
        pub fn wait_time_in_minutes(mut self, input: i32) -> Self {
            self.wait_time_in_minutes = Some(input);
            self
        }
        /// <p>The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is not started manually. Applies only to the <code>STOP_DEPLOYMENT</code> option for <code>actionOnTimeout</code>.</p>
        pub fn set_wait_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_time_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentReadyOption`](crate::model::DeploymentReadyOption)
        pub fn build(self) -> crate::model::DeploymentReadyOption {
            crate::model::DeploymentReadyOption {
                action_on_timeout: self.action_on_timeout,
                wait_time_in_minutes: self.wait_time_in_minutes.unwrap_or_default(),
            }
        }
    }
}
impl DeploymentReadyOption {
    /// Creates a new builder-style object to manufacture [`DeploymentReadyOption`](crate::model::DeploymentReadyOption)
    pub fn builder() -> crate::model::deployment_ready_option::Builder {
        crate::model::deployment_ready_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentReadyAction {
    #[allow(missing_docs)] // documentation missing in model
    ContinueDeployment,
    #[allow(missing_docs)] // documentation missing in model
    StopDeployment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentReadyAction {
    fn from(s: &str) -> Self {
        match s {
            "CONTINUE_DEPLOYMENT" => DeploymentReadyAction::ContinueDeployment,
            "STOP_DEPLOYMENT" => DeploymentReadyAction::StopDeployment,
            other => DeploymentReadyAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentReadyAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentReadyAction::from(s))
    }
}
impl DeploymentReadyAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentReadyAction::ContinueDeployment => "CONTINUE_DEPLOYMENT",
            DeploymentReadyAction::StopDeployment => "STOP_DEPLOYMENT",
            DeploymentReadyAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTINUE_DEPLOYMENT", "STOP_DEPLOYMENT"]
    }
}
impl AsRef<str> for DeploymentReadyAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about whether instances in the original environment are terminated when a blue/green deployment is successful. <code>BlueInstanceTerminationOption</code> does not apply to Lambda deployments. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlueInstanceTerminationOption {
    /// <p>The action to take on instances in the original environment after a successful blue/green deployment.</p>
    /// <ul>
    /// <li> <p> <code>TERMINATE</code>: Instances are terminated after a specified wait time.</p> </li>
    /// <li> <p> <code>KEEP_ALIVE</code>: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</p> </li>
    /// </ul>
    pub action: std::option::Option<crate::model::InstanceAction>,
    /// <p>For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.</p>
    /// <p> For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set. </p>
    /// <p> The maximum setting is 2880 minutes (2 days). </p>
    pub termination_wait_time_in_minutes: i32,
}
impl BlueInstanceTerminationOption {
    /// <p>The action to take on instances in the original environment after a successful blue/green deployment.</p>
    /// <ul>
    /// <li> <p> <code>TERMINATE</code>: Instances are terminated after a specified wait time.</p> </li>
    /// <li> <p> <code>KEEP_ALIVE</code>: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</p> </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::InstanceAction> {
        self.action.as_ref()
    }
    /// <p>For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.</p>
    /// <p> For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set. </p>
    /// <p> The maximum setting is 2880 minutes (2 days). </p>
    pub fn termination_wait_time_in_minutes(&self) -> i32 {
        self.termination_wait_time_in_minutes
    }
}
impl std::fmt::Debug for BlueInstanceTerminationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlueInstanceTerminationOption");
        formatter.field("action", &self.action);
        formatter.field(
            "termination_wait_time_in_minutes",
            &self.termination_wait_time_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`BlueInstanceTerminationOption`](crate::model::BlueInstanceTerminationOption)
pub mod blue_instance_termination_option {
    /// A builder for [`BlueInstanceTerminationOption`](crate::model::BlueInstanceTerminationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::InstanceAction>,
        pub(crate) termination_wait_time_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The action to take on instances in the original environment after a successful blue/green deployment.</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code>: Instances are terminated after a specified wait time.</p> </li>
        /// <li> <p> <code>KEEP_ALIVE</code>: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</p> </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::InstanceAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to take on instances in the original environment after a successful blue/green deployment.</p>
        /// <ul>
        /// <li> <p> <code>TERMINATE</code>: Instances are terminated after a specified wait time.</p> </li>
        /// <li> <p> <code>KEEP_ALIVE</code>: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</p> </li>
        /// </ul>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::InstanceAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.</p>
        /// <p> For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set. </p>
        /// <p> The maximum setting is 2880 minutes (2 days). </p>
        pub fn termination_wait_time_in_minutes(mut self, input: i32) -> Self {
            self.termination_wait_time_in_minutes = Some(input);
            self
        }
        /// <p>For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.</p>
        /// <p> For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set. </p>
        /// <p> The maximum setting is 2880 minutes (2 days). </p>
        pub fn set_termination_wait_time_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.termination_wait_time_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`BlueInstanceTerminationOption`](crate::model::BlueInstanceTerminationOption)
        pub fn build(self) -> crate::model::BlueInstanceTerminationOption {
            crate::model::BlueInstanceTerminationOption {
                action: self.action,
                termination_wait_time_in_minutes: self
                    .termination_wait_time_in_minutes
                    .unwrap_or_default(),
            }
        }
    }
}
impl BlueInstanceTerminationOption {
    /// Creates a new builder-style object to manufacture [`BlueInstanceTerminationOption`](crate::model::BlueInstanceTerminationOption)
    pub fn builder() -> crate::model::blue_instance_termination_option::Builder {
        crate::model::blue_instance_termination_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceAction {
    #[allow(missing_docs)] // documentation missing in model
    KeepAlive,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceAction {
    fn from(s: &str) -> Self {
        match s {
            "KEEP_ALIVE" => InstanceAction::KeepAlive,
            "TERMINATE" => InstanceAction::Terminate,
            other => InstanceAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceAction::from(s))
    }
}
impl InstanceAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceAction::KeepAlive => "KEEP_ALIVE",
            InstanceAction::Terminate => "TERMINATE",
            InstanceAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KEEP_ALIVE", "TERMINATE"]
    }
}
impl AsRef<str> for InstanceAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentStyle {
    /// <p>Indicates whether to run an in-place deployment or a blue/green deployment.</p>
    pub deployment_type: std::option::Option<crate::model::DeploymentType>,
    /// <p>Indicates whether to route deployment traffic behind a load balancer.</p>
    pub deployment_option: std::option::Option<crate::model::DeploymentOption>,
}
impl DeploymentStyle {
    /// <p>Indicates whether to run an in-place deployment or a blue/green deployment.</p>
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::DeploymentType> {
        self.deployment_type.as_ref()
    }
    /// <p>Indicates whether to route deployment traffic behind a load balancer.</p>
    pub fn deployment_option(&self) -> std::option::Option<&crate::model::DeploymentOption> {
        self.deployment_option.as_ref()
    }
}
impl std::fmt::Debug for DeploymentStyle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentStyle");
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("deployment_option", &self.deployment_option);
        formatter.finish()
    }
}
/// See [`DeploymentStyle`](crate::model::DeploymentStyle)
pub mod deployment_style {
    /// A builder for [`DeploymentStyle`](crate::model::DeploymentStyle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_type: std::option::Option<crate::model::DeploymentType>,
        pub(crate) deployment_option: std::option::Option<crate::model::DeploymentOption>,
    }
    impl Builder {
        /// <p>Indicates whether to run an in-place deployment or a blue/green deployment.</p>
        pub fn deployment_type(mut self, input: crate::model::DeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>Indicates whether to run an in-place deployment or a blue/green deployment.</p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>Indicates whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_option(mut self, input: crate::model::DeploymentOption) -> Self {
            self.deployment_option = Some(input);
            self
        }
        /// <p>Indicates whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_option(
            mut self,
            input: std::option::Option<crate::model::DeploymentOption>,
        ) -> Self {
            self.deployment_option = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentStyle`](crate::model::DeploymentStyle)
        pub fn build(self) -> crate::model::DeploymentStyle {
            crate::model::DeploymentStyle {
                deployment_type: self.deployment_type,
                deployment_option: self.deployment_option,
            }
        }
    }
}
impl DeploymentStyle {
    /// Creates a new builder-style object to manufacture [`DeploymentStyle`](crate::model::DeploymentStyle)
    pub fn builder() -> crate::model::deployment_style::Builder {
        crate::model::deployment_style::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentOption {
    #[allow(missing_docs)] // documentation missing in model
    WithoutTrafficControl,
    #[allow(missing_docs)] // documentation missing in model
    WithTrafficControl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentOption {
    fn from(s: &str) -> Self {
        match s {
            "WITHOUT_TRAFFIC_CONTROL" => DeploymentOption::WithoutTrafficControl,
            "WITH_TRAFFIC_CONTROL" => DeploymentOption::WithTrafficControl,
            other => DeploymentOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentOption::from(s))
    }
}
impl DeploymentOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentOption::WithoutTrafficControl => "WITHOUT_TRAFFIC_CONTROL",
            DeploymentOption::WithTrafficControl => "WITH_TRAFFIC_CONTROL",
            DeploymentOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["WITHOUT_TRAFFIC_CONTROL", "WITH_TRAFFIC_CONTROL"]
    }
}
impl AsRef<str> for DeploymentOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentType {
    #[allow(missing_docs)] // documentation missing in model
    BlueGreen,
    #[allow(missing_docs)] // documentation missing in model
    InPlace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentType {
    fn from(s: &str) -> Self {
        match s {
            "BLUE_GREEN" => DeploymentType::BlueGreen,
            "IN_PLACE" => DeploymentType::InPlace,
            other => DeploymentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentType::from(s))
    }
}
impl DeploymentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentType::BlueGreen => "BLUE_GREEN",
            DeploymentType::InPlace => "IN_PLACE",
            DeploymentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BLUE_GREEN", "IN_PLACE"]
    }
}
impl AsRef<str> for DeploymentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutdatedInstancesStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutdatedInstancesStrategy {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => OutdatedInstancesStrategy::Ignore,
            "UPDATE" => OutdatedInstancesStrategy::Update,
            other => OutdatedInstancesStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutdatedInstancesStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutdatedInstancesStrategy::from(s))
    }
}
impl OutdatedInstancesStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutdatedInstancesStrategy::Ignore => "IGNORE",
            OutdatedInstancesStrategy::Update => "UPDATE",
            OutdatedInstancesStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "UPDATE"]
    }
}
impl AsRef<str> for OutdatedInstancesStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a configuration for automatically rolling back to a previous version of an application revision when a deployment is not completed successfully.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoRollbackConfiguration {
    /// <p>Indicates whether a defined automatic rollback configuration is currently enabled.</p>
    pub enabled: bool,
    /// <p>The event type or types that trigger a rollback.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::AutoRollbackEvent>>,
}
impl AutoRollbackConfiguration {
    /// <p>Indicates whether a defined automatic rollback configuration is currently enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The event type or types that trigger a rollback.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::AutoRollbackEvent]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for AutoRollbackConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoRollbackConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`AutoRollbackConfiguration`](crate::model::AutoRollbackConfiguration)
pub mod auto_rollback_configuration {
    /// A builder for [`AutoRollbackConfiguration`](crate::model::AutoRollbackConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::AutoRollbackEvent>>,
    }
    impl Builder {
        /// <p>Indicates whether a defined automatic rollback configuration is currently enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether a defined automatic rollback configuration is currently enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The event type or types that trigger a rollback.</p>
        pub fn events(mut self, input: crate::model::AutoRollbackEvent) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>The event type or types that trigger a rollback.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoRollbackEvent>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoRollbackConfiguration`](crate::model::AutoRollbackConfiguration)
        pub fn build(self) -> crate::model::AutoRollbackConfiguration {
            crate::model::AutoRollbackConfiguration {
                enabled: self.enabled.unwrap_or_default(),
                events: self.events,
            }
        }
    }
}
impl AutoRollbackConfiguration {
    /// Creates a new builder-style object to manufacture [`AutoRollbackConfiguration`](crate::model::AutoRollbackConfiguration)
    pub fn builder() -> crate::model::auto_rollback_configuration::Builder {
        crate::model::auto_rollback_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoRollbackEvent {
    #[allow(missing_docs)] // documentation missing in model
    DeploymentFailure,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentStopOnAlarm,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentStopOnRequest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoRollbackEvent {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYMENT_FAILURE" => AutoRollbackEvent::DeploymentFailure,
            "DEPLOYMENT_STOP_ON_ALARM" => AutoRollbackEvent::DeploymentStopOnAlarm,
            "DEPLOYMENT_STOP_ON_REQUEST" => AutoRollbackEvent::DeploymentStopOnRequest,
            other => AutoRollbackEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoRollbackEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoRollbackEvent::from(s))
    }
}
impl AutoRollbackEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoRollbackEvent::DeploymentFailure => "DEPLOYMENT_FAILURE",
            AutoRollbackEvent::DeploymentStopOnAlarm => "DEPLOYMENT_STOP_ON_ALARM",
            AutoRollbackEvent::DeploymentStopOnRequest => "DEPLOYMENT_STOP_ON_REQUEST",
            AutoRollbackEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEPLOYMENT_FAILURE",
            "DEPLOYMENT_STOP_ON_ALARM",
            "DEPLOYMENT_STOP_ON_REQUEST",
        ]
    }
}
impl AsRef<str> for AutoRollbackEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about alarms associated with the deployment group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmConfiguration {
    /// <p>Indicates whether the alarm configuration is enabled.</p>
    pub enabled: bool,
    /// <p>Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.</p>
    /// <ul>
    /// <li> <p> <code>true</code>: The deployment proceeds even if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
    /// <li> <p> <code>false</code>: The deployment stops if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
    /// </ul>
    pub ignore_poll_alarm_failure: bool,
    /// <p>A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment group.</p>
    pub alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
}
impl AlarmConfiguration {
    /// <p>Indicates whether the alarm configuration is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.</p>
    /// <ul>
    /// <li> <p> <code>true</code>: The deployment proceeds even if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
    /// <li> <p> <code>false</code>: The deployment stops if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
    /// </ul>
    pub fn ignore_poll_alarm_failure(&self) -> bool {
        self.ignore_poll_alarm_failure
    }
    /// <p>A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment group.</p>
    pub fn alarms(&self) -> std::option::Option<&[crate::model::Alarm]> {
        self.alarms.as_deref()
    }
}
impl std::fmt::Debug for AlarmConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.field("ignore_poll_alarm_failure", &self.ignore_poll_alarm_failure);
        formatter.field("alarms", &self.alarms);
        formatter.finish()
    }
}
/// See [`AlarmConfiguration`](crate::model::AlarmConfiguration)
pub mod alarm_configuration {
    /// A builder for [`AlarmConfiguration`](crate::model::AlarmConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) ignore_poll_alarm_failure: std::option::Option<bool>,
        pub(crate) alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
    }
    impl Builder {
        /// <p>Indicates whether the alarm configuration is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether the alarm configuration is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.</p>
        /// <ul>
        /// <li> <p> <code>true</code>: The deployment proceeds even if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
        /// <li> <p> <code>false</code>: The deployment stops if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
        /// </ul>
        pub fn ignore_poll_alarm_failure(mut self, input: bool) -> Self {
            self.ignore_poll_alarm_failure = Some(input);
            self
        }
        /// <p>Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.</p>
        /// <ul>
        /// <li> <p> <code>true</code>: The deployment proceeds even if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
        /// <li> <p> <code>false</code>: The deployment stops if alarm status information can't be retrieved from Amazon CloudWatch.</p> </li>
        /// </ul>
        pub fn set_ignore_poll_alarm_failure(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_poll_alarm_failure = input;
            self
        }
        /// Appends an item to `alarms`.
        ///
        /// To override the contents of this collection use [`set_alarms`](Self::set_alarms).
        ///
        /// <p>A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment group.</p>
        pub fn alarms(mut self, input: crate::model::Alarm) -> Self {
            let mut v = self.alarms.unwrap_or_default();
            v.push(input);
            self.alarms = Some(v);
            self
        }
        /// <p>A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment group.</p>
        pub fn set_alarms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
        ) -> Self {
            self.alarms = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmConfiguration`](crate::model::AlarmConfiguration)
        pub fn build(self) -> crate::model::AlarmConfiguration {
            crate::model::AlarmConfiguration {
                enabled: self.enabled.unwrap_or_default(),
                ignore_poll_alarm_failure: self.ignore_poll_alarm_failure.unwrap_or_default(),
                alarms: self.alarms,
            }
        }
    }
}
impl AlarmConfiguration {
    /// Creates a new builder-style object to manufacture [`AlarmConfiguration`](crate::model::AlarmConfiguration)
    pub fn builder() -> crate::model::alarm_configuration::Builder {
        crate::model::alarm_configuration::Builder::default()
    }
}

/// <p>Information about an alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alarm {
    /// <p>The name of the alarm. Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.</p>
    pub name: std::option::Option<std::string::String>,
}
impl Alarm {
    /// <p>The name of the alarm. Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for Alarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alarm");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Alarm`](crate::model::Alarm)
pub mod alarm {
    /// A builder for [`Alarm`](crate::model::Alarm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm. Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alarm. Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Alarm`](crate::model::Alarm)
        pub fn build(self) -> crate::model::Alarm {
            crate::model::Alarm { name: self.name }
        }
    }
}
impl Alarm {
    /// Creates a new builder-style object to manufacture [`Alarm`](crate::model::Alarm)
    pub fn builder() -> crate::model::alarm::Builder {
        crate::model::alarm::Builder::default()
    }
}

/// <p>Information about notification triggers for the deployment group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerConfig {
    /// <p>The name of the notification trigger.</p>
    pub trigger_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.</p>
    pub trigger_target_arn: std::option::Option<std::string::String>,
    /// <p>The event type or types for which notifications are triggered.</p>
    pub trigger_events: std::option::Option<std::vec::Vec<crate::model::TriggerEventType>>,
}
impl TriggerConfig {
    /// <p>The name of the notification trigger.</p>
    pub fn trigger_name(&self) -> std::option::Option<&str> {
        self.trigger_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.</p>
    pub fn trigger_target_arn(&self) -> std::option::Option<&str> {
        self.trigger_target_arn.as_deref()
    }
    /// <p>The event type or types for which notifications are triggered.</p>
    pub fn trigger_events(&self) -> std::option::Option<&[crate::model::TriggerEventType]> {
        self.trigger_events.as_deref()
    }
}
impl std::fmt::Debug for TriggerConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerConfig");
        formatter.field("trigger_name", &self.trigger_name);
        formatter.field("trigger_target_arn", &self.trigger_target_arn);
        formatter.field("trigger_events", &self.trigger_events);
        formatter.finish()
    }
}
/// See [`TriggerConfig`](crate::model::TriggerConfig)
pub mod trigger_config {
    /// A builder for [`TriggerConfig`](crate::model::TriggerConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger_name: std::option::Option<std::string::String>,
        pub(crate) trigger_target_arn: std::option::Option<std::string::String>,
        pub(crate) trigger_events:
            std::option::Option<std::vec::Vec<crate::model::TriggerEventType>>,
    }
    impl Builder {
        /// <p>The name of the notification trigger.</p>
        pub fn trigger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger_name = Some(input.into());
            self
        }
        /// <p>The name of the notification trigger.</p>
        pub fn set_trigger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trigger_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.</p>
        pub fn trigger_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger_target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.</p>
        pub fn set_trigger_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trigger_target_arn = input;
            self
        }
        /// Appends an item to `trigger_events`.
        ///
        /// To override the contents of this collection use [`set_trigger_events`](Self::set_trigger_events).
        ///
        /// <p>The event type or types for which notifications are triggered.</p>
        pub fn trigger_events(mut self, input: crate::model::TriggerEventType) -> Self {
            let mut v = self.trigger_events.unwrap_or_default();
            v.push(input);
            self.trigger_events = Some(v);
            self
        }
        /// <p>The event type or types for which notifications are triggered.</p>
        pub fn set_trigger_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerEventType>>,
        ) -> Self {
            self.trigger_events = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerConfig`](crate::model::TriggerConfig)
        pub fn build(self) -> crate::model::TriggerConfig {
            crate::model::TriggerConfig {
                trigger_name: self.trigger_name,
                trigger_target_arn: self.trigger_target_arn,
                trigger_events: self.trigger_events,
            }
        }
    }
}
impl TriggerConfig {
    /// Creates a new builder-style object to manufacture [`TriggerConfig`](crate::model::TriggerConfig)
    pub fn builder() -> crate::model::trigger_config::Builder {
        crate::model::trigger_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggerEventType {
    #[allow(missing_docs)] // documentation missing in model
    DeploymentFailure,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentReady,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentRollback,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentStart,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentStop,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentSuccess,
    #[allow(missing_docs)] // documentation missing in model
    InstanceFailure,
    #[allow(missing_docs)] // documentation missing in model
    InstanceReady,
    #[allow(missing_docs)] // documentation missing in model
    InstanceStart,
    #[allow(missing_docs)] // documentation missing in model
    InstanceSuccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggerEventType {
    fn from(s: &str) -> Self {
        match s {
            "DeploymentFailure" => TriggerEventType::DeploymentFailure,
            "DeploymentReady" => TriggerEventType::DeploymentReady,
            "DeploymentRollback" => TriggerEventType::DeploymentRollback,
            "DeploymentStart" => TriggerEventType::DeploymentStart,
            "DeploymentStop" => TriggerEventType::DeploymentStop,
            "DeploymentSuccess" => TriggerEventType::DeploymentSuccess,
            "InstanceFailure" => TriggerEventType::InstanceFailure,
            "InstanceReady" => TriggerEventType::InstanceReady,
            "InstanceStart" => TriggerEventType::InstanceStart,
            "InstanceSuccess" => TriggerEventType::InstanceSuccess,
            other => TriggerEventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggerEventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggerEventType::from(s))
    }
}
impl TriggerEventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggerEventType::DeploymentFailure => "DeploymentFailure",
            TriggerEventType::DeploymentReady => "DeploymentReady",
            TriggerEventType::DeploymentRollback => "DeploymentRollback",
            TriggerEventType::DeploymentStart => "DeploymentStart",
            TriggerEventType::DeploymentStop => "DeploymentStop",
            TriggerEventType::DeploymentSuccess => "DeploymentSuccess",
            TriggerEventType::InstanceFailure => "InstanceFailure",
            TriggerEventType::InstanceReady => "InstanceReady",
            TriggerEventType::InstanceStart => "InstanceStart",
            TriggerEventType::InstanceSuccess => "InstanceSuccess",
            TriggerEventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DeploymentFailure",
            "DeploymentReady",
            "DeploymentRollback",
            "DeploymentStart",
            "DeploymentStop",
            "DeploymentSuccess",
            "InstanceFailure",
            "InstanceReady",
            "InstanceStart",
            "InstanceSuccess",
        ]
    }
}
impl AsRef<str> for TriggerEventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag's key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag's key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag's key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag's key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StopStatus {
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StopStatus {
    fn from(s: &str) -> Self {
        match s {
            "Pending" => StopStatus::Pending,
            "Succeeded" => StopStatus::Succeeded,
            other => StopStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StopStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StopStatus::from(s))
    }
}
impl StopStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StopStatus::Pending => "Pending",
            StopStatus::Succeeded => "Succeeded",
            StopStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Pending", "Succeeded"]
    }
}
impl AsRef<str> for StopStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the location of an application revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevisionLocation {
    /// <p>The type of application revision:</p>
    /// <ul>
    /// <li> <p>S3: An application revision stored in Amazon S3.</p> </li>
    /// <li> <p>GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).</p> </li>
    /// <li> <p>String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).</p> </li>
    /// <li> <p>AppSpecContent: An <code>AppSpecContent</code> object that contains the contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML stored as a RawString.</p> </li>
    /// </ul>
    pub revision_type: std::option::Option<crate::model::RevisionLocationType>,
    /// <p>Information about the location of a revision stored in Amazon S3. </p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
    /// <p>Information about the location of application artifacts stored in GitHub.</p>
    pub git_hub_location: std::option::Option<crate::model::GitHubLocation>,
    /// <p>Information about the location of an AWS Lambda deployment revision stored as a RawString.</p>
    pub string: std::option::Option<crate::model::RawString>,
    /// <p> The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML and stored as a RawString. </p>
    pub app_spec_content: std::option::Option<crate::model::AppSpecContent>,
}
impl RevisionLocation {
    /// <p>The type of application revision:</p>
    /// <ul>
    /// <li> <p>S3: An application revision stored in Amazon S3.</p> </li>
    /// <li> <p>GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).</p> </li>
    /// <li> <p>String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).</p> </li>
    /// <li> <p>AppSpecContent: An <code>AppSpecContent</code> object that contains the contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML stored as a RawString.</p> </li>
    /// </ul>
    pub fn revision_type(&self) -> std::option::Option<&crate::model::RevisionLocationType> {
        self.revision_type.as_ref()
    }
    /// <p>Information about the location of a revision stored in Amazon S3. </p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
    /// <p>Information about the location of application artifacts stored in GitHub.</p>
    pub fn git_hub_location(&self) -> std::option::Option<&crate::model::GitHubLocation> {
        self.git_hub_location.as_ref()
    }
    /// <p>Information about the location of an AWS Lambda deployment revision stored as a RawString.</p>
    pub fn string(&self) -> std::option::Option<&crate::model::RawString> {
        self.string.as_ref()
    }
    /// <p> The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML and stored as a RawString. </p>
    pub fn app_spec_content(&self) -> std::option::Option<&crate::model::AppSpecContent> {
        self.app_spec_content.as_ref()
    }
}
impl std::fmt::Debug for RevisionLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevisionLocation");
        formatter.field("revision_type", &self.revision_type);
        formatter.field("s3_location", &self.s3_location);
        formatter.field("git_hub_location", &self.git_hub_location);
        formatter.field("string", &self.string);
        formatter.field("app_spec_content", &self.app_spec_content);
        formatter.finish()
    }
}
/// See [`RevisionLocation`](crate::model::RevisionLocation)
pub mod revision_location {
    /// A builder for [`RevisionLocation`](crate::model::RevisionLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_type: std::option::Option<crate::model::RevisionLocationType>,
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
        pub(crate) git_hub_location: std::option::Option<crate::model::GitHubLocation>,
        pub(crate) string: std::option::Option<crate::model::RawString>,
        pub(crate) app_spec_content: std::option::Option<crate::model::AppSpecContent>,
    }
    impl Builder {
        /// <p>The type of application revision:</p>
        /// <ul>
        /// <li> <p>S3: An application revision stored in Amazon S3.</p> </li>
        /// <li> <p>GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).</p> </li>
        /// <li> <p>String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).</p> </li>
        /// <li> <p>AppSpecContent: An <code>AppSpecContent</code> object that contains the contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML stored as a RawString.</p> </li>
        /// </ul>
        pub fn revision_type(mut self, input: crate::model::RevisionLocationType) -> Self {
            self.revision_type = Some(input);
            self
        }
        /// <p>The type of application revision:</p>
        /// <ul>
        /// <li> <p>S3: An application revision stored in Amazon S3.</p> </li>
        /// <li> <p>GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).</p> </li>
        /// <li> <p>String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).</p> </li>
        /// <li> <p>AppSpecContent: An <code>AppSpecContent</code> object that contains the contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML stored as a RawString.</p> </li>
        /// </ul>
        pub fn set_revision_type(
            mut self,
            input: std::option::Option<crate::model::RevisionLocationType>,
        ) -> Self {
            self.revision_type = input;
            self
        }
        /// <p>Information about the location of a revision stored in Amazon S3. </p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>Information about the location of a revision stored in Amazon S3. </p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// <p>Information about the location of application artifacts stored in GitHub.</p>
        pub fn git_hub_location(mut self, input: crate::model::GitHubLocation) -> Self {
            self.git_hub_location = Some(input);
            self
        }
        /// <p>Information about the location of application artifacts stored in GitHub.</p>
        pub fn set_git_hub_location(
            mut self,
            input: std::option::Option<crate::model::GitHubLocation>,
        ) -> Self {
            self.git_hub_location = input;
            self
        }
        /// <p>Information about the location of an AWS Lambda deployment revision stored as a RawString.</p>
        pub fn string(mut self, input: crate::model::RawString) -> Self {
            self.string = Some(input);
            self
        }
        /// <p>Information about the location of an AWS Lambda deployment revision stored as a RawString.</p>
        pub fn set_string(mut self, input: std::option::Option<crate::model::RawString>) -> Self {
            self.string = input;
            self
        }
        /// <p> The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML and stored as a RawString. </p>
        pub fn app_spec_content(mut self, input: crate::model::AppSpecContent) -> Self {
            self.app_spec_content = Some(input);
            self
        }
        /// <p> The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML and stored as a RawString. </p>
        pub fn set_app_spec_content(
            mut self,
            input: std::option::Option<crate::model::AppSpecContent>,
        ) -> Self {
            self.app_spec_content = input;
            self
        }
        /// Consumes the builder and constructs a [`RevisionLocation`](crate::model::RevisionLocation)
        pub fn build(self) -> crate::model::RevisionLocation {
            crate::model::RevisionLocation {
                revision_type: self.revision_type,
                s3_location: self.s3_location,
                git_hub_location: self.git_hub_location,
                string: self.string,
                app_spec_content: self.app_spec_content,
            }
        }
    }
}
impl RevisionLocation {
    /// Creates a new builder-style object to manufacture [`RevisionLocation`](crate::model::RevisionLocation)
    pub fn builder() -> crate::model::revision_location::Builder {
        crate::model::revision_location::Builder::default()
    }
}

/// <p> A revision for an AWS Lambda or Amazon ECS deployment that is a YAML-formatted or JSON-formatted string. For AWS Lambda and Amazon ECS deployments, the revision is the same as the AppSpec file. This method replaces the deprecated <code>RawString</code> data type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppSpecContent {
    /// <p> The YAML-formatted or JSON-formatted revision string. </p>
    /// <p> For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original version, and the alias for its replacement version. The deployment shifts traffic from the original version of the Lambda function to the replacement version. </p>
    /// <p> For an Amazon ECS deployment, the content includes the task name, information about the load balancer that serves traffic to the container, and more. </p>
    /// <p> For both types of deployments, the content can specify Lambda functions that run at specified hooks, such as <code>BeforeInstall</code>, during a deployment. </p>
    pub content: std::option::Option<std::string::String>,
    /// <p> The SHA256 hash value of the revision content. </p>
    pub sha256: std::option::Option<std::string::String>,
}
impl AppSpecContent {
    /// <p> The YAML-formatted or JSON-formatted revision string. </p>
    /// <p> For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original version, and the alias for its replacement version. The deployment shifts traffic from the original version of the Lambda function to the replacement version. </p>
    /// <p> For an Amazon ECS deployment, the content includes the task name, information about the load balancer that serves traffic to the container, and more. </p>
    /// <p> For both types of deployments, the content can specify Lambda functions that run at specified hooks, such as <code>BeforeInstall</code>, during a deployment. </p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p> The SHA256 hash value of the revision content. </p>
    pub fn sha256(&self) -> std::option::Option<&str> {
        self.sha256.as_deref()
    }
}
impl std::fmt::Debug for AppSpecContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppSpecContent");
        formatter.field("content", &self.content);
        formatter.field("sha256", &self.sha256);
        formatter.finish()
    }
}
/// See [`AppSpecContent`](crate::model::AppSpecContent)
pub mod app_spec_content {
    /// A builder for [`AppSpecContent`](crate::model::AppSpecContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) sha256: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The YAML-formatted or JSON-formatted revision string. </p>
        /// <p> For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original version, and the alias for its replacement version. The deployment shifts traffic from the original version of the Lambda function to the replacement version. </p>
        /// <p> For an Amazon ECS deployment, the content includes the task name, information about the load balancer that serves traffic to the container, and more. </p>
        /// <p> For both types of deployments, the content can specify Lambda functions that run at specified hooks, such as <code>BeforeInstall</code>, during a deployment. </p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p> The YAML-formatted or JSON-formatted revision string. </p>
        /// <p> For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original version, and the alias for its replacement version. The deployment shifts traffic from the original version of the Lambda function to the replacement version. </p>
        /// <p> For an Amazon ECS deployment, the content includes the task name, information about the load balancer that serves traffic to the container, and more. </p>
        /// <p> For both types of deployments, the content can specify Lambda functions that run at specified hooks, such as <code>BeforeInstall</code>, during a deployment. </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p> The SHA256 hash value of the revision content. </p>
        pub fn sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha256 = Some(input.into());
            self
        }
        /// <p> The SHA256 hash value of the revision content. </p>
        pub fn set_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sha256 = input;
            self
        }
        /// Consumes the builder and constructs a [`AppSpecContent`](crate::model::AppSpecContent)
        pub fn build(self) -> crate::model::AppSpecContent {
            crate::model::AppSpecContent {
                content: self.content,
                sha256: self.sha256,
            }
        }
    }
}
impl AppSpecContent {
    /// Creates a new builder-style object to manufacture [`AppSpecContent`](crate::model::AppSpecContent)
    pub fn builder() -> crate::model::app_spec_content::Builder {
        crate::model::app_spec_content::Builder::default()
    }
}

/// <p>A revision for an AWS Lambda deployment that is a YAML-formatted or JSON-formatted string. For AWS Lambda deployments, the revision is the same as the AppSpec file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RawString {
    /// <p>The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function to update and optional Lambda functions that validate deployment lifecycle events.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The SHA256 hash value of the revision content.</p>
    pub sha256: std::option::Option<std::string::String>,
}
impl RawString {
    /// <p>The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function to update and optional Lambda functions that validate deployment lifecycle events.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The SHA256 hash value of the revision content.</p>
    pub fn sha256(&self) -> std::option::Option<&str> {
        self.sha256.as_deref()
    }
}
impl std::fmt::Debug for RawString {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RawString");
        formatter.field("content", &self.content);
        formatter.field("sha256", &self.sha256);
        formatter.finish()
    }
}
/// See [`RawString`](crate::model::RawString)
pub mod raw_string {
    /// A builder for [`RawString`](crate::model::RawString)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) sha256: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function to update and optional Lambda functions that validate deployment lifecycle events.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function to update and optional Lambda functions that validate deployment lifecycle events.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The SHA256 hash value of the revision content.</p>
        pub fn sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha256 = Some(input.into());
            self
        }
        /// <p>The SHA256 hash value of the revision content.</p>
        pub fn set_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sha256 = input;
            self
        }
        /// Consumes the builder and constructs a [`RawString`](crate::model::RawString)
        pub fn build(self) -> crate::model::RawString {
            crate::model::RawString {
                content: self.content,
                sha256: self.sha256,
            }
        }
    }
}
impl RawString {
    /// Creates a new builder-style object to manufacture [`RawString`](crate::model::RawString)
    pub fn builder() -> crate::model::raw_string::Builder {
        crate::model::raw_string::Builder::default()
    }
}

/// <p>Information about the location of application artifacts stored in GitHub.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GitHubLocation {
    /// <p>The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision. </p>
    /// <p>Specified as account/repository.</p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.</p>
    pub commit_id: std::option::Option<std::string::String>,
}
impl GitHubLocation {
    /// <p>The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision. </p>
    /// <p>Specified as account/repository.</p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
}
impl std::fmt::Debug for GitHubLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GitHubLocation");
        formatter.field("repository", &self.repository);
        formatter.field("commit_id", &self.commit_id);
        formatter.finish()
    }
}
/// See [`GitHubLocation`](crate::model::GitHubLocation)
pub mod git_hub_location {
    /// A builder for [`GitHubLocation`](crate::model::GitHubLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision. </p>
        /// <p>Specified as account/repository.</p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision. </p>
        /// <p>Specified as account/repository.</p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GitHubLocation`](crate::model::GitHubLocation)
        pub fn build(self) -> crate::model::GitHubLocation {
            crate::model::GitHubLocation {
                repository: self.repository,
                commit_id: self.commit_id,
            }
        }
    }
}
impl GitHubLocation {
    /// Creates a new builder-style object to manufacture [`GitHubLocation`](crate::model::GitHubLocation)
    pub fn builder() -> crate::model::git_hub_location::Builder {
        crate::model::git_hub_location::Builder::default()
    }
}

/// <p>Information about the location of application artifacts stored in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The name of the Amazon S3 bucket where the application revision is stored.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The file type of the application revision. Must be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>tar</code>: A tar archive file.</p> </li>
    /// <li> <p> <code>tgz</code>: A compressed tar archive file.</p> </li>
    /// <li> <p> <code>zip</code>: A zip archive file.</p> </li>
    /// </ul>
    pub bundle_type: std::option::Option<crate::model::BundleType>,
    /// <p>A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
    /// <p>If the version is not specified, the system uses the most recent version by default.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
    /// <p>If the ETag is not specified as an input parameter, ETag validation of the object is skipped.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The name of the Amazon S3 bucket where the application revision is stored.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The file type of the application revision. Must be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>tar</code>: A tar archive file.</p> </li>
    /// <li> <p> <code>tgz</code>: A compressed tar archive file.</p> </li>
    /// <li> <p> <code>zip</code>: A zip archive file.</p> </li>
    /// </ul>
    pub fn bundle_type(&self) -> std::option::Option<&crate::model::BundleType> {
        self.bundle_type.as_ref()
    }
    /// <p>A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
    /// <p>If the version is not specified, the system uses the most recent version by default.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
    /// <p>If the ETag is not specified as an input parameter, ETag validation of the object is skipped.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("bundle_type", &self.bundle_type);
        formatter.field("version", &self.version);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) bundle_type: std::option::Option<crate::model::BundleType>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket where the application revision is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where the application revision is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The file type of the application revision. Must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>tar</code>: A tar archive file.</p> </li>
        /// <li> <p> <code>tgz</code>: A compressed tar archive file.</p> </li>
        /// <li> <p> <code>zip</code>: A zip archive file.</p> </li>
        /// </ul>
        pub fn bundle_type(mut self, input: crate::model::BundleType) -> Self {
            self.bundle_type = Some(input);
            self
        }
        /// <p>The file type of the application revision. Must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>tar</code>: A tar archive file.</p> </li>
        /// <li> <p> <code>tgz</code>: A compressed tar archive file.</p> </li>
        /// <li> <p> <code>zip</code>: A zip archive file.</p> </li>
        /// </ul>
        pub fn set_bundle_type(
            mut self,
            input: std::option::Option<crate::model::BundleType>,
        ) -> Self {
            self.bundle_type = input;
            self
        }
        /// <p>A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
        /// <p>If the version is not specified, the system uses the most recent version by default.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
        /// <p>If the version is not specified, the system uses the most recent version by default.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
        /// <p>If the ETag is not specified as an input parameter, ETag validation of the object is skipped.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
        /// <p>If the ETag is not specified as an input parameter, ETag validation of the object is skipped.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                key: self.key,
                bundle_type: self.bundle_type,
                version: self.version,
                e_tag: self.e_tag,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BundleType {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Yaml,
    #[allow(missing_docs)] // documentation missing in model
    Tar,
    #[allow(missing_docs)] // documentation missing in model
    TarGZip,
    #[allow(missing_docs)] // documentation missing in model
    Zip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BundleType {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => BundleType::Json,
            "YAML" => BundleType::Yaml,
            "tar" => BundleType::Tar,
            "tgz" => BundleType::TarGZip,
            "zip" => BundleType::Zip,
            other => BundleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BundleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BundleType::from(s))
    }
}
impl BundleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BundleType::Json => "JSON",
            BundleType::Yaml => "YAML",
            BundleType::Tar => "tar",
            BundleType::TarGZip => "tgz",
            BundleType::Zip => "zip",
            BundleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "YAML", "tar", "tgz", "zip"]
    }
}
impl AsRef<str> for BundleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RevisionLocationType {
    #[allow(missing_docs)] // documentation missing in model
    AppSpecContent,
    #[allow(missing_docs)] // documentation missing in model
    GitHub,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RevisionLocationType {
    fn from(s: &str) -> Self {
        match s {
            "AppSpecContent" => RevisionLocationType::AppSpecContent,
            "GitHub" => RevisionLocationType::GitHub,
            "S3" => RevisionLocationType::S3,
            "String" => RevisionLocationType::String,
            other => RevisionLocationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RevisionLocationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RevisionLocationType::from(s))
    }
}
impl RevisionLocationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RevisionLocationType::AppSpecContent => "AppSpecContent",
            RevisionLocationType::GitHub => "GitHub",
            RevisionLocationType::S3 => "S3",
            RevisionLocationType::String => "String",
            RevisionLocationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AppSpecContent", "GitHub", "S3", "String"]
    }
}
impl AsRef<str> for RevisionLocationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `LifecycleEventStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LifecycleEventStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LifecycleEventStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => LifecycleEventStatus::Failed,
            "InProgress" => LifecycleEventStatus::InProgress,
            "Pending" => LifecycleEventStatus::Pending,
            "Skipped" => LifecycleEventStatus::Skipped,
            "Succeeded" => LifecycleEventStatus::Succeeded,
            "Unknown" => LifecycleEventStatus::UnknownValue,
            other => LifecycleEventStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LifecycleEventStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LifecycleEventStatus::from(s))
    }
}
impl LifecycleEventStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LifecycleEventStatus::Failed => "Failed",
            LifecycleEventStatus::InProgress => "InProgress",
            LifecycleEventStatus::Pending => "Pending",
            LifecycleEventStatus::Skipped => "Skipped",
            LifecycleEventStatus::Succeeded => "Succeeded",
            LifecycleEventStatus::UnknownValue => "Unknown",
            LifecycleEventStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "InProgress",
            "Pending",
            "Skipped",
            "Succeeded",
            "Unknown",
        ]
    }
}
impl AsRef<str> for LifecycleEventStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegistrationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deregistered,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegistrationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Deregistered" => RegistrationStatus::Deregistered,
            "Registered" => RegistrationStatus::Registered,
            other => RegistrationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegistrationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegistrationStatus::from(s))
    }
}
impl RegistrationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegistrationStatus::Deregistered => "Deregistered",
            RegistrationStatus::Registered => "Registered",
            RegistrationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Deregistered", "Registered"]
    }
}
impl AsRef<str> for RegistrationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetFilterName {
    #[allow(missing_docs)] // documentation missing in model
    ServerInstanceLabel,
    #[allow(missing_docs)] // documentation missing in model
    TargetStatus,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetFilterName {
    fn from(s: &str) -> Self {
        match s {
            "ServerInstanceLabel" => TargetFilterName::ServerInstanceLabel,
            "TargetStatus" => TargetFilterName::TargetStatus,
            other => TargetFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetFilterName::from(s))
    }
}
impl TargetFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetFilterName::ServerInstanceLabel => "ServerInstanceLabel",
            TargetFilterName::TargetStatus => "TargetStatus",
            TargetFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ServerInstanceLabel", "TargetStatus"]
    }
}
impl AsRef<str> for TargetFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a time range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeRange {
    /// <p>The start time of the time range.</p> <note>
    /// <p>Specify null to leave the start time open-ended.</p>
    /// </note>
    pub start: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time of the time range.</p> <note>
    /// <p>Specify null to leave the end time open-ended.</p>
    /// </note>
    pub end: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimeRange {
    /// <p>The start time of the time range.</p> <note>
    /// <p>Specify null to leave the start time open-ended.</p>
    /// </note>
    pub fn start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start.as_ref()
    }
    /// <p>The end time of the time range.</p> <note>
    /// <p>Specify null to leave the end time open-ended.</p>
    /// </note>
    pub fn end(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end.as_ref()
    }
}
impl std::fmt::Debug for TimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeRange");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`TimeRange`](crate::model::TimeRange)
pub mod time_range {
    /// A builder for [`TimeRange`](crate::model::TimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start time of the time range.</p> <note>
        /// <p>Specify null to leave the start time open-ended.</p>
        /// </note>
        pub fn start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The start time of the time range.</p> <note>
        /// <p>Specify null to leave the start time open-ended.</p>
        /// </note>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.start = input;
            self
        }
        /// <p>The end time of the time range.</p> <note>
        /// <p>Specify null to leave the end time open-ended.</p>
        /// </note>
        pub fn end(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The end time of the time range.</p> <note>
        /// <p>Specify null to leave the end time open-ended.</p>
        /// </note>
        pub fn set_end(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeRange`](crate::model::TimeRange)
        pub fn build(self) -> crate::model::TimeRange {
            crate::model::TimeRange {
                start: self.start,
                end: self.end,
            }
        }
    }
}
impl TimeRange {
    /// Creates a new builder-style object to manufacture [`TimeRange`](crate::model::TimeRange)
    pub fn builder() -> crate::model::time_range::Builder {
        crate::model::time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Baking,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "Baking" => DeploymentStatus::Baking,
            "Created" => DeploymentStatus::Created,
            "Failed" => DeploymentStatus::Failed,
            "InProgress" => DeploymentStatus::InProgress,
            "Queued" => DeploymentStatus::Queued,
            "Ready" => DeploymentStatus::Ready,
            "Stopped" => DeploymentStatus::Stopped,
            "Succeeded" => DeploymentStatus::Succeeded,
            other => DeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentStatus::from(s))
    }
}
impl DeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentStatus::Baking => "Baking",
            DeploymentStatus::Created => "Created",
            DeploymentStatus::Failed => "Failed",
            DeploymentStatus::InProgress => "InProgress",
            DeploymentStatus::Queued => "Queued",
            DeploymentStatus::Ready => "Ready",
            DeploymentStatus::Stopped => "Stopped",
            DeploymentStatus::Succeeded => "Succeeded",
            DeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Baking",
            "Created",
            "Failed",
            "InProgress",
            "Queued",
            "Ready",
            "Stopped",
            "Succeeded",
        ]
    }
}
impl AsRef<str> for DeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceType {
    #[allow(missing_docs)] // documentation missing in model
    Blue,
    #[allow(missing_docs)] // documentation missing in model
    Green,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceType {
    fn from(s: &str) -> Self {
        match s {
            "Blue" => InstanceType::Blue,
            "Green" => InstanceType::Green,
            other => InstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceType::from(s))
    }
}
impl InstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceType::Blue => "Blue",
            InstanceType::Green => "Green",
            InstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Blue", "Green"]
    }
}
impl AsRef<str> for InstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `InstanceStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => InstanceStatus::Failed,
            "InProgress" => InstanceStatus::InProgress,
            "Pending" => InstanceStatus::Pending,
            "Ready" => InstanceStatus::Ready,
            "Skipped" => InstanceStatus::Skipped,
            "Succeeded" => InstanceStatus::Succeeded,
            "Unknown" => InstanceStatus::UnknownValue,
            other => InstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStatus::from(s))
    }
}
impl InstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStatus::Failed => "Failed",
            InstanceStatus::InProgress => "InProgress",
            InstanceStatus::Pending => "Pending",
            InstanceStatus::Ready => "Ready",
            InstanceStatus::Skipped => "Skipped",
            InstanceStatus::Succeeded => "Succeeded",
            InstanceStatus::UnknownValue => "Unknown",
            InstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "InProgress",
            "Pending",
            "Ready",
            "Skipped",
            "Succeeded",
            "Unknown",
        ]
    }
}
impl AsRef<str> for InstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ListStateFilterAction {
    #[allow(missing_docs)] // documentation missing in model
    Exclude,
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Include,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ListStateFilterAction {
    fn from(s: &str) -> Self {
        match s {
            "exclude" => ListStateFilterAction::Exclude,
            "ignore" => ListStateFilterAction::Ignore,
            "include" => ListStateFilterAction::Include,
            other => ListStateFilterAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ListStateFilterAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ListStateFilterAction::from(s))
    }
}
impl ListStateFilterAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ListStateFilterAction::Exclude => "exclude",
            ListStateFilterAction::Ignore => "ignore",
            ListStateFilterAction::Include => "include",
            ListStateFilterAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["exclude", "ignore", "include"]
    }
}
impl AsRef<str> for ListStateFilterAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ascending" => SortOrder::Ascending,
            "descending" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ascending",
            SortOrder::Descending => "descending",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ascending", "descending"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationRevisionSortBy {
    #[allow(missing_docs)] // documentation missing in model
    FirstUsedTime,
    #[allow(missing_docs)] // documentation missing in model
    LastUsedTime,
    #[allow(missing_docs)] // documentation missing in model
    RegisterTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationRevisionSortBy {
    fn from(s: &str) -> Self {
        match s {
            "firstUsedTime" => ApplicationRevisionSortBy::FirstUsedTime,
            "lastUsedTime" => ApplicationRevisionSortBy::LastUsedTime,
            "registerTime" => ApplicationRevisionSortBy::RegisterTime,
            other => ApplicationRevisionSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationRevisionSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationRevisionSortBy::from(s))
    }
}
impl ApplicationRevisionSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationRevisionSortBy::FirstUsedTime => "firstUsedTime",
            ApplicationRevisionSortBy::LastUsedTime => "lastUsedTime",
            ApplicationRevisionSortBy::RegisterTime => "registerTime",
            ApplicationRevisionSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["firstUsedTime", "lastUsedTime", "registerTime"]
    }
}
impl AsRef<str> for ApplicationRevisionSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an on-premises instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceInfo {
    /// <p>The name of the on-premises instance.</p>
    pub instance_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM session associated with the on-premises instance.</p>
    pub iam_session_arn: std::option::Option<std::string::String>,
    /// <p>The IAM user ARN associated with the on-premises instance.</p>
    pub iam_user_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the on-premises instance.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the on-premises instance was registered.</p>
    pub register_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.</p>
    pub deregister_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The tags currently associated with the on-premises instance.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl InstanceInfo {
    /// <p>The name of the on-premises instance.</p>
    pub fn instance_name(&self) -> std::option::Option<&str> {
        self.instance_name.as_deref()
    }
    /// <p>The ARN of the IAM session associated with the on-premises instance.</p>
    pub fn iam_session_arn(&self) -> std::option::Option<&str> {
        self.iam_session_arn.as_deref()
    }
    /// <p>The IAM user ARN associated with the on-premises instance.</p>
    pub fn iam_user_arn(&self) -> std::option::Option<&str> {
        self.iam_user_arn.as_deref()
    }
    /// <p>The ARN of the on-premises instance.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The time at which the on-premises instance was registered.</p>
    pub fn register_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.register_time.as_ref()
    }
    /// <p>If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.</p>
    pub fn deregister_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deregister_time.as_ref()
    }
    /// <p>The tags currently associated with the on-premises instance.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for InstanceInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceInfo");
        formatter.field("instance_name", &self.instance_name);
        formatter.field("iam_session_arn", &self.iam_session_arn);
        formatter.field("iam_user_arn", &self.iam_user_arn);
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("register_time", &self.register_time);
        formatter.field("deregister_time", &self.deregister_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`InstanceInfo`](crate::model::InstanceInfo)
pub mod instance_info {
    /// A builder for [`InstanceInfo`](crate::model::InstanceInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) iam_session_arn: std::option::Option<std::string::String>,
        pub(crate) iam_user_arn: std::option::Option<std::string::String>,
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) register_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deregister_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the on-premises instance.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the on-premises instance.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>The ARN of the IAM session associated with the on-premises instance.</p>
        pub fn iam_session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_session_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM session associated with the on-premises instance.</p>
        pub fn set_iam_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_session_arn = input;
            self
        }
        /// <p>The IAM user ARN associated with the on-premises instance.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_user_arn = Some(input.into());
            self
        }
        /// <p>The IAM user ARN associated with the on-premises instance.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_user_arn = input;
            self
        }
        /// <p>The ARN of the on-premises instance.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the on-premises instance.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The time at which the on-premises instance was registered.</p>
        pub fn register_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.register_time = Some(input);
            self
        }
        /// <p>The time at which the on-premises instance was registered.</p>
        pub fn set_register_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.register_time = input;
            self
        }
        /// <p>If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.</p>
        pub fn deregister_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deregister_time = Some(input);
            self
        }
        /// <p>If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.</p>
        pub fn set_deregister_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deregister_time = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags currently associated with the on-premises instance.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags currently associated with the on-premises instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceInfo`](crate::model::InstanceInfo)
        pub fn build(self) -> crate::model::InstanceInfo {
            crate::model::InstanceInfo {
                instance_name: self.instance_name,
                iam_session_arn: self.iam_session_arn,
                iam_user_arn: self.iam_user_arn,
                instance_arn: self.instance_arn,
                register_time: self.register_time,
                deregister_time: self.deregister_time,
                tags: self.tags,
            }
        }
    }
}
impl InstanceInfo {
    /// Creates a new builder-style object to manufacture [`InstanceInfo`](crate::model::InstanceInfo)
    pub fn builder() -> crate::model::instance_info::Builder {
        crate::model::instance_info::Builder::default()
    }
}

/// <p> Information about the deployment target. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentTarget {
    /// <p>The deployment type that is specific to the deployment's compute platform or deployments initiated by a CloudFormation stack update.</p>
    pub deployment_target_type: std::option::Option<crate::model::DeploymentTargetType>,
    /// <p> Information about the target for a deployment that uses the EC2/On-premises compute platform. </p>
    pub instance_target: std::option::Option<crate::model::InstanceTarget>,
    /// <p> Information about the target for a deployment that uses the AWS Lambda compute platform. </p>
    pub lambda_target: std::option::Option<crate::model::LambdaTarget>,
    /// <p> Information about the target for a deployment that uses the Amazon ECS compute platform. </p>
    pub ecs_target: std::option::Option<crate::model::EcsTarget>,
    /// <p> Information about the target to be updated by an AWS CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.</p>
    pub cloud_formation_target: std::option::Option<crate::model::CloudFormationTarget>,
}
impl DeploymentTarget {
    /// <p>The deployment type that is specific to the deployment's compute platform or deployments initiated by a CloudFormation stack update.</p>
    pub fn deployment_target_type(
        &self,
    ) -> std::option::Option<&crate::model::DeploymentTargetType> {
        self.deployment_target_type.as_ref()
    }
    /// <p> Information about the target for a deployment that uses the EC2/On-premises compute platform. </p>
    pub fn instance_target(&self) -> std::option::Option<&crate::model::InstanceTarget> {
        self.instance_target.as_ref()
    }
    /// <p> Information about the target for a deployment that uses the AWS Lambda compute platform. </p>
    pub fn lambda_target(&self) -> std::option::Option<&crate::model::LambdaTarget> {
        self.lambda_target.as_ref()
    }
    /// <p> Information about the target for a deployment that uses the Amazon ECS compute platform. </p>
    pub fn ecs_target(&self) -> std::option::Option<&crate::model::EcsTarget> {
        self.ecs_target.as_ref()
    }
    /// <p> Information about the target to be updated by an AWS CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.</p>
    pub fn cloud_formation_target(
        &self,
    ) -> std::option::Option<&crate::model::CloudFormationTarget> {
        self.cloud_formation_target.as_ref()
    }
}
impl std::fmt::Debug for DeploymentTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentTarget");
        formatter.field("deployment_target_type", &self.deployment_target_type);
        formatter.field("instance_target", &self.instance_target);
        formatter.field("lambda_target", &self.lambda_target);
        formatter.field("ecs_target", &self.ecs_target);
        formatter.field("cloud_formation_target", &self.cloud_formation_target);
        formatter.finish()
    }
}
/// See [`DeploymentTarget`](crate::model::DeploymentTarget)
pub mod deployment_target {
    /// A builder for [`DeploymentTarget`](crate::model::DeploymentTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_target_type: std::option::Option<crate::model::DeploymentTargetType>,
        pub(crate) instance_target: std::option::Option<crate::model::InstanceTarget>,
        pub(crate) lambda_target: std::option::Option<crate::model::LambdaTarget>,
        pub(crate) ecs_target: std::option::Option<crate::model::EcsTarget>,
        pub(crate) cloud_formation_target: std::option::Option<crate::model::CloudFormationTarget>,
    }
    impl Builder {
        /// <p>The deployment type that is specific to the deployment's compute platform or deployments initiated by a CloudFormation stack update.</p>
        pub fn deployment_target_type(mut self, input: crate::model::DeploymentTargetType) -> Self {
            self.deployment_target_type = Some(input);
            self
        }
        /// <p>The deployment type that is specific to the deployment's compute platform or deployments initiated by a CloudFormation stack update.</p>
        pub fn set_deployment_target_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargetType>,
        ) -> Self {
            self.deployment_target_type = input;
            self
        }
        /// <p> Information about the target for a deployment that uses the EC2/On-premises compute platform. </p>
        pub fn instance_target(mut self, input: crate::model::InstanceTarget) -> Self {
            self.instance_target = Some(input);
            self
        }
        /// <p> Information about the target for a deployment that uses the EC2/On-premises compute platform. </p>
        pub fn set_instance_target(
            mut self,
            input: std::option::Option<crate::model::InstanceTarget>,
        ) -> Self {
            self.instance_target = input;
            self
        }
        /// <p> Information about the target for a deployment that uses the AWS Lambda compute platform. </p>
        pub fn lambda_target(mut self, input: crate::model::LambdaTarget) -> Self {
            self.lambda_target = Some(input);
            self
        }
        /// <p> Information about the target for a deployment that uses the AWS Lambda compute platform. </p>
        pub fn set_lambda_target(
            mut self,
            input: std::option::Option<crate::model::LambdaTarget>,
        ) -> Self {
            self.lambda_target = input;
            self
        }
        /// <p> Information about the target for a deployment that uses the Amazon ECS compute platform. </p>
        pub fn ecs_target(mut self, input: crate::model::EcsTarget) -> Self {
            self.ecs_target = Some(input);
            self
        }
        /// <p> Information about the target for a deployment that uses the Amazon ECS compute platform. </p>
        pub fn set_ecs_target(
            mut self,
            input: std::option::Option<crate::model::EcsTarget>,
        ) -> Self {
            self.ecs_target = input;
            self
        }
        /// <p> Information about the target to be updated by an AWS CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.</p>
        pub fn cloud_formation_target(mut self, input: crate::model::CloudFormationTarget) -> Self {
            self.cloud_formation_target = Some(input);
            self
        }
        /// <p> Information about the target to be updated by an AWS CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.</p>
        pub fn set_cloud_formation_target(
            mut self,
            input: std::option::Option<crate::model::CloudFormationTarget>,
        ) -> Self {
            self.cloud_formation_target = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentTarget`](crate::model::DeploymentTarget)
        pub fn build(self) -> crate::model::DeploymentTarget {
            crate::model::DeploymentTarget {
                deployment_target_type: self.deployment_target_type,
                instance_target: self.instance_target,
                lambda_target: self.lambda_target,
                ecs_target: self.ecs_target,
                cloud_formation_target: self.cloud_formation_target,
            }
        }
    }
}
impl DeploymentTarget {
    /// Creates a new builder-style object to manufacture [`DeploymentTarget`](crate::model::DeploymentTarget)
    pub fn builder() -> crate::model::deployment_target::Builder {
        crate::model::deployment_target::Builder::default()
    }
}

/// <p> Information about the target to be updated by an AWS CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationTarget {
    /// <p>The unique ID of an AWS CloudFormation blue/green deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The unique ID of a deployment target that has a type of&nbsp;<code>CloudFormationTarget</code>. </p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p> The date and time when the target application was updated by an AWS CloudFormation blue/green deployment. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The lifecycle events of the AWS CloudFormation blue/green deployment to this target application. </p>
    pub lifecycle_events: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
    /// <p> The status of an AWS CloudFormation blue/green deployment's target application. </p>
    pub status: std::option::Option<crate::model::TargetStatus>,
    /// <p>The resource type for the AWS CloudFormation blue/green deployment.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The percentage of production traffic that the target version of an AWS CloudFormation blue/green deployment receives.</p>
    pub target_version_weight: f64,
}
impl CloudFormationTarget {
    /// <p>The unique ID of an AWS CloudFormation blue/green deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The unique ID of a deployment target that has a type of&nbsp;<code>CloudFormationTarget</code>. </p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p> The date and time when the target application was updated by an AWS CloudFormation blue/green deployment. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p> The lifecycle events of the AWS CloudFormation blue/green deployment to this target application. </p>
    pub fn lifecycle_events(&self) -> std::option::Option<&[crate::model::LifecycleEvent]> {
        self.lifecycle_events.as_deref()
    }
    /// <p> The status of an AWS CloudFormation blue/green deployment's target application. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::TargetStatus> {
        self.status.as_ref()
    }
    /// <p>The resource type for the AWS CloudFormation blue/green deployment.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The percentage of production traffic that the target version of an AWS CloudFormation blue/green deployment receives.</p>
    pub fn target_version_weight(&self) -> f64 {
        self.target_version_weight
    }
}
impl std::fmt::Debug for CloudFormationTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationTarget");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("target_id", &self.target_id);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("lifecycle_events", &self.lifecycle_events);
        formatter.field("status", &self.status);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("target_version_weight", &self.target_version_weight);
        formatter.finish()
    }
}
/// See [`CloudFormationTarget`](crate::model::CloudFormationTarget)
pub mod cloud_formation_target {
    /// A builder for [`CloudFormationTarget`](crate::model::CloudFormationTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lifecycle_events:
            std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        pub(crate) status: std::option::Option<crate::model::TargetStatus>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) target_version_weight: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The unique ID of an AWS CloudFormation blue/green deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The unique ID of an AWS CloudFormation blue/green deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The unique ID of a deployment target that has a type of&nbsp;<code>CloudFormationTarget</code>. </p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment target that has a type of&nbsp;<code>CloudFormationTarget</code>. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p> The date and time when the target application was updated by an AWS CloudFormation blue/green deployment. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> The date and time when the target application was updated by an AWS CloudFormation blue/green deployment. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Appends an item to `lifecycle_events`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_events`](Self::set_lifecycle_events).
        ///
        /// <p> The lifecycle events of the AWS CloudFormation blue/green deployment to this target application. </p>
        pub fn lifecycle_events(mut self, input: crate::model::LifecycleEvent) -> Self {
            let mut v = self.lifecycle_events.unwrap_or_default();
            v.push(input);
            self.lifecycle_events = Some(v);
            self
        }
        /// <p> The lifecycle events of the AWS CloudFormation blue/green deployment to this target application. </p>
        pub fn set_lifecycle_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        ) -> Self {
            self.lifecycle_events = input;
            self
        }
        /// <p> The status of an AWS CloudFormation blue/green deployment's target application. </p>
        pub fn status(mut self, input: crate::model::TargetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of an AWS CloudFormation blue/green deployment's target application. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TargetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The resource type for the AWS CloudFormation blue/green deployment.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type for the AWS CloudFormation blue/green deployment.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The percentage of production traffic that the target version of an AWS CloudFormation blue/green deployment receives.</p>
        pub fn target_version_weight(mut self, input: f64) -> Self {
            self.target_version_weight = Some(input);
            self
        }
        /// <p>The percentage of production traffic that the target version of an AWS CloudFormation blue/green deployment receives.</p>
        pub fn set_target_version_weight(mut self, input: std::option::Option<f64>) -> Self {
            self.target_version_weight = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationTarget`](crate::model::CloudFormationTarget)
        pub fn build(self) -> crate::model::CloudFormationTarget {
            crate::model::CloudFormationTarget {
                deployment_id: self.deployment_id,
                target_id: self.target_id,
                last_updated_at: self.last_updated_at,
                lifecycle_events: self.lifecycle_events,
                status: self.status,
                resource_type: self.resource_type,
                target_version_weight: self.target_version_weight.unwrap_or_default(),
            }
        }
    }
}
impl CloudFormationTarget {
    /// Creates a new builder-style object to manufacture [`CloudFormationTarget`](crate::model::CloudFormationTarget)
    pub fn builder() -> crate::model::cloud_formation_target::Builder {
        crate::model::cloud_formation_target::Builder::default()
    }
}

/// _Note: `TargetStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => TargetStatus::Failed,
            "InProgress" => TargetStatus::InProgress,
            "Pending" => TargetStatus::Pending,
            "Ready" => TargetStatus::Ready,
            "Skipped" => TargetStatus::Skipped,
            "Succeeded" => TargetStatus::Succeeded,
            "Unknown" => TargetStatus::UnknownValue,
            other => TargetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetStatus::from(s))
    }
}
impl TargetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetStatus::Failed => "Failed",
            TargetStatus::InProgress => "InProgress",
            TargetStatus::Pending => "Pending",
            TargetStatus::Ready => "Ready",
            TargetStatus::Skipped => "Skipped",
            TargetStatus::Succeeded => "Succeeded",
            TargetStatus::UnknownValue => "Unknown",
            TargetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "InProgress",
            "Pending",
            "Ready",
            "Skipped",
            "Succeeded",
            "Unknown",
        ]
    }
}
impl AsRef<str> for TargetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a deployment lifecycle event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleEvent {
    /// <p>The deployment lifecycle event name, such as <code>ApplicationStop</code>, <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>ApplicationStart</code>, or <code>ValidateService</code>.</p>
    pub lifecycle_event_name: std::option::Option<std::string::String>,
    /// <p>Diagnostic information about the deployment lifecycle event.</p>
    pub diagnostics: std::option::Option<crate::model::Diagnostics>,
    /// <p>A timestamp that indicates when the deployment lifecycle event started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the deployment lifecycle event ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The deployment lifecycle event status:</p>
    /// <ul>
    /// <li> <p>Pending: The deployment lifecycle event is pending.</p> </li>
    /// <li> <p>InProgress: The deployment lifecycle event is in progress.</p> </li>
    /// <li> <p>Succeeded: The deployment lifecycle event ran successfully.</p> </li>
    /// <li> <p>Failed: The deployment lifecycle event has failed.</p> </li>
    /// <li> <p>Skipped: The deployment lifecycle event has been skipped.</p> </li>
    /// <li> <p>Unknown: The deployment lifecycle event is unknown.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::LifecycleEventStatus>,
}
impl LifecycleEvent {
    /// <p>The deployment lifecycle event name, such as <code>ApplicationStop</code>, <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>ApplicationStart</code>, or <code>ValidateService</code>.</p>
    pub fn lifecycle_event_name(&self) -> std::option::Option<&str> {
        self.lifecycle_event_name.as_deref()
    }
    /// <p>Diagnostic information about the deployment lifecycle event.</p>
    pub fn diagnostics(&self) -> std::option::Option<&crate::model::Diagnostics> {
        self.diagnostics.as_ref()
    }
    /// <p>A timestamp that indicates when the deployment lifecycle event started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>A timestamp that indicates when the deployment lifecycle event ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The deployment lifecycle event status:</p>
    /// <ul>
    /// <li> <p>Pending: The deployment lifecycle event is pending.</p> </li>
    /// <li> <p>InProgress: The deployment lifecycle event is in progress.</p> </li>
    /// <li> <p>Succeeded: The deployment lifecycle event ran successfully.</p> </li>
    /// <li> <p>Failed: The deployment lifecycle event has failed.</p> </li>
    /// <li> <p>Skipped: The deployment lifecycle event has been skipped.</p> </li>
    /// <li> <p>Unknown: The deployment lifecycle event is unknown.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::LifecycleEventStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for LifecycleEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleEvent");
        formatter.field("lifecycle_event_name", &self.lifecycle_event_name);
        formatter.field("diagnostics", &self.diagnostics);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`LifecycleEvent`](crate::model::LifecycleEvent)
pub mod lifecycle_event {
    /// A builder for [`LifecycleEvent`](crate::model::LifecycleEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_event_name: std::option::Option<std::string::String>,
        pub(crate) diagnostics: std::option::Option<crate::model::Diagnostics>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::LifecycleEventStatus>,
    }
    impl Builder {
        /// <p>The deployment lifecycle event name, such as <code>ApplicationStop</code>, <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>ApplicationStart</code>, or <code>ValidateService</code>.</p>
        pub fn lifecycle_event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_event_name = Some(input.into());
            self
        }
        /// <p>The deployment lifecycle event name, such as <code>ApplicationStop</code>, <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>ApplicationStart</code>, or <code>ValidateService</code>.</p>
        pub fn set_lifecycle_event_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_event_name = input;
            self
        }
        /// <p>Diagnostic information about the deployment lifecycle event.</p>
        pub fn diagnostics(mut self, input: crate::model::Diagnostics) -> Self {
            self.diagnostics = Some(input);
            self
        }
        /// <p>Diagnostic information about the deployment lifecycle event.</p>
        pub fn set_diagnostics(
            mut self,
            input: std::option::Option<crate::model::Diagnostics>,
        ) -> Self {
            self.diagnostics = input;
            self
        }
        /// <p>A timestamp that indicates when the deployment lifecycle event started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the deployment lifecycle event started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>A timestamp that indicates when the deployment lifecycle event ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the deployment lifecycle event ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The deployment lifecycle event status:</p>
        /// <ul>
        /// <li> <p>Pending: The deployment lifecycle event is pending.</p> </li>
        /// <li> <p>InProgress: The deployment lifecycle event is in progress.</p> </li>
        /// <li> <p>Succeeded: The deployment lifecycle event ran successfully.</p> </li>
        /// <li> <p>Failed: The deployment lifecycle event has failed.</p> </li>
        /// <li> <p>Skipped: The deployment lifecycle event has been skipped.</p> </li>
        /// <li> <p>Unknown: The deployment lifecycle event is unknown.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::LifecycleEventStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The deployment lifecycle event status:</p>
        /// <ul>
        /// <li> <p>Pending: The deployment lifecycle event is pending.</p> </li>
        /// <li> <p>InProgress: The deployment lifecycle event is in progress.</p> </li>
        /// <li> <p>Succeeded: The deployment lifecycle event ran successfully.</p> </li>
        /// <li> <p>Failed: The deployment lifecycle event has failed.</p> </li>
        /// <li> <p>Skipped: The deployment lifecycle event has been skipped.</p> </li>
        /// <li> <p>Unknown: The deployment lifecycle event is unknown.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LifecycleEventStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleEvent`](crate::model::LifecycleEvent)
        pub fn build(self) -> crate::model::LifecycleEvent {
            crate::model::LifecycleEvent {
                lifecycle_event_name: self.lifecycle_event_name,
                diagnostics: self.diagnostics,
                start_time: self.start_time,
                end_time: self.end_time,
                status: self.status,
            }
        }
    }
}
impl LifecycleEvent {
    /// Creates a new builder-style object to manufacture [`LifecycleEvent`](crate::model::LifecycleEvent)
    pub fn builder() -> crate::model::lifecycle_event::Builder {
        crate::model::lifecycle_event::Builder::default()
    }
}

/// <p>Diagnostic information about executable scripts that are part of a deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Diagnostics {
    /// <p>The associated error code:</p>
    /// <ul>
    /// <li> <p>Success: The specified script ran.</p> </li>
    /// <li> <p>ScriptMissing: The specified script was not found in the specified location.</p> </li>
    /// <li> <p>ScriptNotExecutable: The specified script is not a recognized executable file type.</p> </li>
    /// <li> <p>ScriptTimedOut: The specified script did not finish running in the specified time period.</p> </li>
    /// <li> <p>ScriptFailed: The specified script failed to run as expected.</p> </li>
    /// <li> <p>UnknownError: The specified script did not run for an unknown reason.</p> </li>
    /// </ul>
    pub error_code: std::option::Option<crate::model::LifecycleErrorCode>,
    /// <p>The name of the script.</p>
    pub script_name: std::option::Option<std::string::String>,
    /// <p>The message associated with the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The last portion of the diagnostic log.</p>
    /// <p>If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.</p>
    pub log_tail: std::option::Option<std::string::String>,
}
impl Diagnostics {
    /// <p>The associated error code:</p>
    /// <ul>
    /// <li> <p>Success: The specified script ran.</p> </li>
    /// <li> <p>ScriptMissing: The specified script was not found in the specified location.</p> </li>
    /// <li> <p>ScriptNotExecutable: The specified script is not a recognized executable file type.</p> </li>
    /// <li> <p>ScriptTimedOut: The specified script did not finish running in the specified time period.</p> </li>
    /// <li> <p>ScriptFailed: The specified script failed to run as expected.</p> </li>
    /// <li> <p>UnknownError: The specified script did not run for an unknown reason.</p> </li>
    /// </ul>
    pub fn error_code(&self) -> std::option::Option<&crate::model::LifecycleErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The name of the script.</p>
    pub fn script_name(&self) -> std::option::Option<&str> {
        self.script_name.as_deref()
    }
    /// <p>The message associated with the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The last portion of the diagnostic log.</p>
    /// <p>If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.</p>
    pub fn log_tail(&self) -> std::option::Option<&str> {
        self.log_tail.as_deref()
    }
}
impl std::fmt::Debug for Diagnostics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Diagnostics");
        formatter.field("error_code", &self.error_code);
        formatter.field("script_name", &self.script_name);
        formatter.field("message", &self.message);
        formatter.field("log_tail", &self.log_tail);
        formatter.finish()
    }
}
/// See [`Diagnostics`](crate::model::Diagnostics)
pub mod diagnostics {
    /// A builder for [`Diagnostics`](crate::model::Diagnostics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::LifecycleErrorCode>,
        pub(crate) script_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) log_tail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The associated error code:</p>
        /// <ul>
        /// <li> <p>Success: The specified script ran.</p> </li>
        /// <li> <p>ScriptMissing: The specified script was not found in the specified location.</p> </li>
        /// <li> <p>ScriptNotExecutable: The specified script is not a recognized executable file type.</p> </li>
        /// <li> <p>ScriptTimedOut: The specified script did not finish running in the specified time period.</p> </li>
        /// <li> <p>ScriptFailed: The specified script failed to run as expected.</p> </li>
        /// <li> <p>UnknownError: The specified script did not run for an unknown reason.</p> </li>
        /// </ul>
        pub fn error_code(mut self, input: crate::model::LifecycleErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The associated error code:</p>
        /// <ul>
        /// <li> <p>Success: The specified script ran.</p> </li>
        /// <li> <p>ScriptMissing: The specified script was not found in the specified location.</p> </li>
        /// <li> <p>ScriptNotExecutable: The specified script is not a recognized executable file type.</p> </li>
        /// <li> <p>ScriptTimedOut: The specified script did not finish running in the specified time period.</p> </li>
        /// <li> <p>ScriptFailed: The specified script failed to run as expected.</p> </li>
        /// <li> <p>UnknownError: The specified script did not run for an unknown reason.</p> </li>
        /// </ul>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::LifecycleErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The name of the script.</p>
        pub fn script_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_name = Some(input.into());
            self
        }
        /// <p>The name of the script.</p>
        pub fn set_script_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_name = input;
            self
        }
        /// <p>The message associated with the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The last portion of the diagnostic log.</p>
        /// <p>If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.</p>
        pub fn log_tail(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_tail = Some(input.into());
            self
        }
        /// <p>The last portion of the diagnostic log.</p>
        /// <p>If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.</p>
        pub fn set_log_tail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_tail = input;
            self
        }
        /// Consumes the builder and constructs a [`Diagnostics`](crate::model::Diagnostics)
        pub fn build(self) -> crate::model::Diagnostics {
            crate::model::Diagnostics {
                error_code: self.error_code,
                script_name: self.script_name,
                message: self.message,
                log_tail: self.log_tail,
            }
        }
    }
}
impl Diagnostics {
    /// Creates a new builder-style object to manufacture [`Diagnostics`](crate::model::Diagnostics)
    pub fn builder() -> crate::model::diagnostics::Builder {
        crate::model::diagnostics::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LifecycleErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    ScriptFailed,
    #[allow(missing_docs)] // documentation missing in model
    ScriptMissing,
    #[allow(missing_docs)] // documentation missing in model
    ScriptNotExecutable,
    #[allow(missing_docs)] // documentation missing in model
    ScriptTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    UnknownError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LifecycleErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ScriptFailed" => LifecycleErrorCode::ScriptFailed,
            "ScriptMissing" => LifecycleErrorCode::ScriptMissing,
            "ScriptNotExecutable" => LifecycleErrorCode::ScriptNotExecutable,
            "ScriptTimedOut" => LifecycleErrorCode::ScriptTimedOut,
            "Success" => LifecycleErrorCode::Success,
            "UnknownError" => LifecycleErrorCode::UnknownError,
            other => LifecycleErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LifecycleErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LifecycleErrorCode::from(s))
    }
}
impl LifecycleErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LifecycleErrorCode::ScriptFailed => "ScriptFailed",
            LifecycleErrorCode::ScriptMissing => "ScriptMissing",
            LifecycleErrorCode::ScriptNotExecutable => "ScriptNotExecutable",
            LifecycleErrorCode::ScriptTimedOut => "ScriptTimedOut",
            LifecycleErrorCode::Success => "Success",
            LifecycleErrorCode::UnknownError => "UnknownError",
            LifecycleErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ScriptFailed",
            "ScriptMissing",
            "ScriptNotExecutable",
            "ScriptTimedOut",
            "Success",
            "UnknownError",
        ]
    }
}
impl AsRef<str> for LifecycleErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about the target of an Amazon ECS deployment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EcsTarget {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The unique ID of a deployment target that has a type of <code>ecsTarget</code>. </p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the target. </p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p> The date and time when the target Amazon ECS application was updated by a deployment. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The lifecycle events of the deployment to this target Amazon ECS application. </p>
    pub lifecycle_events: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
    /// <p> The status an Amazon ECS deployment's target ECS application. </p>
    pub status: std::option::Option<crate::model::TargetStatus>,
    /// <p> The <code>ECSTaskSet</code> objects associated with the ECS target. </p>
    pub task_sets_info: std::option::Option<std::vec::Vec<crate::model::EcsTaskSet>>,
}
impl EcsTarget {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The unique ID of a deployment target that has a type of <code>ecsTarget</code>. </p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the target. </p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p> The date and time when the target Amazon ECS application was updated by a deployment. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p> The lifecycle events of the deployment to this target Amazon ECS application. </p>
    pub fn lifecycle_events(&self) -> std::option::Option<&[crate::model::LifecycleEvent]> {
        self.lifecycle_events.as_deref()
    }
    /// <p> The status an Amazon ECS deployment's target ECS application. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::TargetStatus> {
        self.status.as_ref()
    }
    /// <p> The <code>ECSTaskSet</code> objects associated with the ECS target. </p>
    pub fn task_sets_info(&self) -> std::option::Option<&[crate::model::EcsTaskSet]> {
        self.task_sets_info.as_deref()
    }
}
impl std::fmt::Debug for EcsTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EcsTarget");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("lifecycle_events", &self.lifecycle_events);
        formatter.field("status", &self.status);
        formatter.field("task_sets_info", &self.task_sets_info);
        formatter.finish()
    }
}
/// See [`EcsTarget`](crate::model::EcsTarget)
pub mod ecs_target {
    /// A builder for [`EcsTarget`](crate::model::EcsTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lifecycle_events:
            std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        pub(crate) status: std::option::Option<crate::model::TargetStatus>,
        pub(crate) task_sets_info: std::option::Option<std::vec::Vec<crate::model::EcsTaskSet>>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The unique ID of a deployment target that has a type of <code>ecsTarget</code>. </p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment target that has a type of <code>ecsTarget</code>. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the target. </p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the target. </p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p> The date and time when the target Amazon ECS application was updated by a deployment. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> The date and time when the target Amazon ECS application was updated by a deployment. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Appends an item to `lifecycle_events`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_events`](Self::set_lifecycle_events).
        ///
        /// <p> The lifecycle events of the deployment to this target Amazon ECS application. </p>
        pub fn lifecycle_events(mut self, input: crate::model::LifecycleEvent) -> Self {
            let mut v = self.lifecycle_events.unwrap_or_default();
            v.push(input);
            self.lifecycle_events = Some(v);
            self
        }
        /// <p> The lifecycle events of the deployment to this target Amazon ECS application. </p>
        pub fn set_lifecycle_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        ) -> Self {
            self.lifecycle_events = input;
            self
        }
        /// <p> The status an Amazon ECS deployment's target ECS application. </p>
        pub fn status(mut self, input: crate::model::TargetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status an Amazon ECS deployment's target ECS application. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TargetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `task_sets_info`.
        ///
        /// To override the contents of this collection use [`set_task_sets_info`](Self::set_task_sets_info).
        ///
        /// <p> The <code>ECSTaskSet</code> objects associated with the ECS target. </p>
        pub fn task_sets_info(mut self, input: crate::model::EcsTaskSet) -> Self {
            let mut v = self.task_sets_info.unwrap_or_default();
            v.push(input);
            self.task_sets_info = Some(v);
            self
        }
        /// <p> The <code>ECSTaskSet</code> objects associated with the ECS target. </p>
        pub fn set_task_sets_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsTaskSet>>,
        ) -> Self {
            self.task_sets_info = input;
            self
        }
        /// Consumes the builder and constructs a [`EcsTarget`](crate::model::EcsTarget)
        pub fn build(self) -> crate::model::EcsTarget {
            crate::model::EcsTarget {
                deployment_id: self.deployment_id,
                target_id: self.target_id,
                target_arn: self.target_arn,
                last_updated_at: self.last_updated_at,
                lifecycle_events: self.lifecycle_events,
                status: self.status,
                task_sets_info: self.task_sets_info,
            }
        }
    }
}
impl EcsTarget {
    /// Creates a new builder-style object to manufacture [`EcsTarget`](crate::model::EcsTarget)
    pub fn builder() -> crate::model::ecs_target::Builder {
        crate::model::ecs_target::Builder::default()
    }
}

/// <p> Information about a set of Amazon ECS tasks in an AWS CodeDeploy deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic. An AWS CodeDeploy application that uses the Amazon ECS compute platform deploys a containerized application in an Amazon ECS service as a task set. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EcsTaskSet {
    /// <p> A unique ID of an <code>ECSTaskSet</code>. </p>
    pub identifer: std::option::Option<std::string::String>,
    /// <p> The number of tasks in a task set. During a deployment that uses the Amazon ECS compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this value to determine how many tasks to create. After the updated task set is created, CodeDeploy shifts traffic to the new task set. </p>
    pub desired_count: i64,
    /// <p> The number of tasks in the task set that are in the <code>PENDING</code> status during an Amazon ECS deployment. A task in the <code>PENDING</code> state is preparing to enter the <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when it launches for the first time, or when it is restarted after being in the <code>STOPPED</code> state. </p>
    pub pending_count: i64,
    /// <p> The number of tasks in the task set that are in the <code>RUNNING</code> status during an Amazon ECS deployment. A task in the <code>RUNNING</code> state is running and ready for use. </p>
    pub running_count: i64,
    /// <p> The status of the task set. There are three valid task set statuses: </p>
    /// <ul>
    /// <li> <p> <code>PRIMARY</code>: Indicates the task set is serving production traffic. </p> </li>
    /// <li> <p> <code>ACTIVE</code>: Indicates the task set is not serving production traffic. </p> </li>
    /// <li> <p> <code>DRAINING</code>: Indicates the tasks in the task set are being stopped and their corresponding targets are being deregistered from their target group. </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p> The percentage of traffic served by this task set. </p>
    pub traffic_weight: f64,
    /// <p> The target group associated with the task set. The target group is used by AWS CodeDeploy to manage traffic to a task set. </p>
    pub target_group: std::option::Option<crate::model::TargetGroupInfo>,
    /// <p> A label that identifies whether the ECS task set is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
    pub task_set_label: std::option::Option<crate::model::TargetLabel>,
}
impl EcsTaskSet {
    /// <p> A unique ID of an <code>ECSTaskSet</code>. </p>
    pub fn identifer(&self) -> std::option::Option<&str> {
        self.identifer.as_deref()
    }
    /// <p> The number of tasks in a task set. During a deployment that uses the Amazon ECS compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this value to determine how many tasks to create. After the updated task set is created, CodeDeploy shifts traffic to the new task set. </p>
    pub fn desired_count(&self) -> i64 {
        self.desired_count
    }
    /// <p> The number of tasks in the task set that are in the <code>PENDING</code> status during an Amazon ECS deployment. A task in the <code>PENDING</code> state is preparing to enter the <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when it launches for the first time, or when it is restarted after being in the <code>STOPPED</code> state. </p>
    pub fn pending_count(&self) -> i64 {
        self.pending_count
    }
    /// <p> The number of tasks in the task set that are in the <code>RUNNING</code> status during an Amazon ECS deployment. A task in the <code>RUNNING</code> state is running and ready for use. </p>
    pub fn running_count(&self) -> i64 {
        self.running_count
    }
    /// <p> The status of the task set. There are three valid task set statuses: </p>
    /// <ul>
    /// <li> <p> <code>PRIMARY</code>: Indicates the task set is serving production traffic. </p> </li>
    /// <li> <p> <code>ACTIVE</code>: Indicates the task set is not serving production traffic. </p> </li>
    /// <li> <p> <code>DRAINING</code>: Indicates the tasks in the task set are being stopped and their corresponding targets are being deregistered from their target group. </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p> The percentage of traffic served by this task set. </p>
    pub fn traffic_weight(&self) -> f64 {
        self.traffic_weight
    }
    /// <p> The target group associated with the task set. The target group is used by AWS CodeDeploy to manage traffic to a task set. </p>
    pub fn target_group(&self) -> std::option::Option<&crate::model::TargetGroupInfo> {
        self.target_group.as_ref()
    }
    /// <p> A label that identifies whether the ECS task set is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
    pub fn task_set_label(&self) -> std::option::Option<&crate::model::TargetLabel> {
        self.task_set_label.as_ref()
    }
}
impl std::fmt::Debug for EcsTaskSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EcsTaskSet");
        formatter.field("identifer", &self.identifer);
        formatter.field("desired_count", &self.desired_count);
        formatter.field("pending_count", &self.pending_count);
        formatter.field("running_count", &self.running_count);
        formatter.field("status", &self.status);
        formatter.field("traffic_weight", &self.traffic_weight);
        formatter.field("target_group", &self.target_group);
        formatter.field("task_set_label", &self.task_set_label);
        formatter.finish()
    }
}
/// See [`EcsTaskSet`](crate::model::EcsTaskSet)
pub mod ecs_task_set {
    /// A builder for [`EcsTaskSet`](crate::model::EcsTaskSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifer: std::option::Option<std::string::String>,
        pub(crate) desired_count: std::option::Option<i64>,
        pub(crate) pending_count: std::option::Option<i64>,
        pub(crate) running_count: std::option::Option<i64>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) traffic_weight: std::option::Option<f64>,
        pub(crate) target_group: std::option::Option<crate::model::TargetGroupInfo>,
        pub(crate) task_set_label: std::option::Option<crate::model::TargetLabel>,
    }
    impl Builder {
        /// <p> A unique ID of an <code>ECSTaskSet</code>. </p>
        pub fn identifer(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifer = Some(input.into());
            self
        }
        /// <p> A unique ID of an <code>ECSTaskSet</code>. </p>
        pub fn set_identifer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifer = input;
            self
        }
        /// <p> The number of tasks in a task set. During a deployment that uses the Amazon ECS compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this value to determine how many tasks to create. After the updated task set is created, CodeDeploy shifts traffic to the new task set. </p>
        pub fn desired_count(mut self, input: i64) -> Self {
            self.desired_count = Some(input);
            self
        }
        /// <p> The number of tasks in a task set. During a deployment that uses the Amazon ECS compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this value to determine how many tasks to create. After the updated task set is created, CodeDeploy shifts traffic to the new task set. </p>
        pub fn set_desired_count(mut self, input: std::option::Option<i64>) -> Self {
            self.desired_count = input;
            self
        }
        /// <p> The number of tasks in the task set that are in the <code>PENDING</code> status during an Amazon ECS deployment. A task in the <code>PENDING</code> state is preparing to enter the <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when it launches for the first time, or when it is restarted after being in the <code>STOPPED</code> state. </p>
        pub fn pending_count(mut self, input: i64) -> Self {
            self.pending_count = Some(input);
            self
        }
        /// <p> The number of tasks in the task set that are in the <code>PENDING</code> status during an Amazon ECS deployment. A task in the <code>PENDING</code> state is preparing to enter the <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when it launches for the first time, or when it is restarted after being in the <code>STOPPED</code> state. </p>
        pub fn set_pending_count(mut self, input: std::option::Option<i64>) -> Self {
            self.pending_count = input;
            self
        }
        /// <p> The number of tasks in the task set that are in the <code>RUNNING</code> status during an Amazon ECS deployment. A task in the <code>RUNNING</code> state is running and ready for use. </p>
        pub fn running_count(mut self, input: i64) -> Self {
            self.running_count = Some(input);
            self
        }
        /// <p> The number of tasks in the task set that are in the <code>RUNNING</code> status during an Amazon ECS deployment. A task in the <code>RUNNING</code> state is running and ready for use. </p>
        pub fn set_running_count(mut self, input: std::option::Option<i64>) -> Self {
            self.running_count = input;
            self
        }
        /// <p> The status of the task set. There are three valid task set statuses: </p>
        /// <ul>
        /// <li> <p> <code>PRIMARY</code>: Indicates the task set is serving production traffic. </p> </li>
        /// <li> <p> <code>ACTIVE</code>: Indicates the task set is not serving production traffic. </p> </li>
        /// <li> <p> <code>DRAINING</code>: Indicates the tasks in the task set are being stopped and their corresponding targets are being deregistered from their target group. </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p> The status of the task set. There are three valid task set statuses: </p>
        /// <ul>
        /// <li> <p> <code>PRIMARY</code>: Indicates the task set is serving production traffic. </p> </li>
        /// <li> <p> <code>ACTIVE</code>: Indicates the task set is not serving production traffic. </p> </li>
        /// <li> <p> <code>DRAINING</code>: Indicates the tasks in the task set are being stopped and their corresponding targets are being deregistered from their target group. </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p> The percentage of traffic served by this task set. </p>
        pub fn traffic_weight(mut self, input: f64) -> Self {
            self.traffic_weight = Some(input);
            self
        }
        /// <p> The percentage of traffic served by this task set. </p>
        pub fn set_traffic_weight(mut self, input: std::option::Option<f64>) -> Self {
            self.traffic_weight = input;
            self
        }
        /// <p> The target group associated with the task set. The target group is used by AWS CodeDeploy to manage traffic to a task set. </p>
        pub fn target_group(mut self, input: crate::model::TargetGroupInfo) -> Self {
            self.target_group = Some(input);
            self
        }
        /// <p> The target group associated with the task set. The target group is used by AWS CodeDeploy to manage traffic to a task set. </p>
        pub fn set_target_group(
            mut self,
            input: std::option::Option<crate::model::TargetGroupInfo>,
        ) -> Self {
            self.target_group = input;
            self
        }
        /// <p> A label that identifies whether the ECS task set is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
        pub fn task_set_label(mut self, input: crate::model::TargetLabel) -> Self {
            self.task_set_label = Some(input);
            self
        }
        /// <p> A label that identifies whether the ECS task set is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
        pub fn set_task_set_label(
            mut self,
            input: std::option::Option<crate::model::TargetLabel>,
        ) -> Self {
            self.task_set_label = input;
            self
        }
        /// Consumes the builder and constructs a [`EcsTaskSet`](crate::model::EcsTaskSet)
        pub fn build(self) -> crate::model::EcsTaskSet {
            crate::model::EcsTaskSet {
                identifer: self.identifer,
                desired_count: self.desired_count.unwrap_or_default(),
                pending_count: self.pending_count.unwrap_or_default(),
                running_count: self.running_count.unwrap_or_default(),
                status: self.status,
                traffic_weight: self.traffic_weight.unwrap_or_default(),
                target_group: self.target_group,
                task_set_label: self.task_set_label,
            }
        }
    }
}
impl EcsTaskSet {
    /// Creates a new builder-style object to manufacture [`EcsTaskSet`](crate::model::EcsTaskSet)
    pub fn builder() -> crate::model::ecs_task_set::Builder {
        crate::model::ecs_task_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetLabel {
    #[allow(missing_docs)] // documentation missing in model
    Blue,
    #[allow(missing_docs)] // documentation missing in model
    Green,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetLabel {
    fn from(s: &str) -> Self {
        match s {
            "Blue" => TargetLabel::Blue,
            "Green" => TargetLabel::Green,
            other => TargetLabel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetLabel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetLabel::from(s))
    }
}
impl TargetLabel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetLabel::Blue => "Blue",
            TargetLabel::Green => "Green",
            TargetLabel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Blue", "Green"]
    }
}
impl AsRef<str> for TargetLabel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about the target AWS Lambda function during an AWS Lambda deployment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaTarget {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The unique ID of a deployment target that has a type of <code>lambdaTarget</code>. </p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the target. </p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p> The status an AWS Lambda deployment's target Lambda function. </p>
    pub status: std::option::Option<crate::model::TargetStatus>,
    /// <p> The date and time when the target Lambda function was updated by a deployment. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The lifecycle events of the deployment to this target Lambda function. </p>
    pub lifecycle_events: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
    /// <p> A <code>LambdaFunctionInfo</code> object that describes a target Lambda function. </p>
    pub lambda_function_info: std::option::Option<crate::model::LambdaFunctionInfo>,
}
impl LambdaTarget {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The unique ID of a deployment target that has a type of <code>lambdaTarget</code>. </p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the target. </p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p> The status an AWS Lambda deployment's target Lambda function. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::TargetStatus> {
        self.status.as_ref()
    }
    /// <p> The date and time when the target Lambda function was updated by a deployment. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p> The lifecycle events of the deployment to this target Lambda function. </p>
    pub fn lifecycle_events(&self) -> std::option::Option<&[crate::model::LifecycleEvent]> {
        self.lifecycle_events.as_deref()
    }
    /// <p> A <code>LambdaFunctionInfo</code> object that describes a target Lambda function. </p>
    pub fn lambda_function_info(&self) -> std::option::Option<&crate::model::LambdaFunctionInfo> {
        self.lambda_function_info.as_ref()
    }
}
impl std::fmt::Debug for LambdaTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaTarget");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("status", &self.status);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("lifecycle_events", &self.lifecycle_events);
        formatter.field("lambda_function_info", &self.lambda_function_info);
        formatter.finish()
    }
}
/// See [`LambdaTarget`](crate::model::LambdaTarget)
pub mod lambda_target {
    /// A builder for [`LambdaTarget`](crate::model::LambdaTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TargetStatus>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lifecycle_events:
            std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        pub(crate) lambda_function_info: std::option::Option<crate::model::LambdaFunctionInfo>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The unique ID of a deployment target that has a type of <code>lambdaTarget</code>. </p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment target that has a type of <code>lambdaTarget</code>. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the target. </p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the target. </p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p> The status an AWS Lambda deployment's target Lambda function. </p>
        pub fn status(mut self, input: crate::model::TargetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status an AWS Lambda deployment's target Lambda function. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TargetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The date and time when the target Lambda function was updated by a deployment. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> The date and time when the target Lambda function was updated by a deployment. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Appends an item to `lifecycle_events`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_events`](Self::set_lifecycle_events).
        ///
        /// <p> The lifecycle events of the deployment to this target Lambda function. </p>
        pub fn lifecycle_events(mut self, input: crate::model::LifecycleEvent) -> Self {
            let mut v = self.lifecycle_events.unwrap_or_default();
            v.push(input);
            self.lifecycle_events = Some(v);
            self
        }
        /// <p> The lifecycle events of the deployment to this target Lambda function. </p>
        pub fn set_lifecycle_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        ) -> Self {
            self.lifecycle_events = input;
            self
        }
        /// <p> A <code>LambdaFunctionInfo</code> object that describes a target Lambda function. </p>
        pub fn lambda_function_info(mut self, input: crate::model::LambdaFunctionInfo) -> Self {
            self.lambda_function_info = Some(input);
            self
        }
        /// <p> A <code>LambdaFunctionInfo</code> object that describes a target Lambda function. </p>
        pub fn set_lambda_function_info(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionInfo>,
        ) -> Self {
            self.lambda_function_info = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaTarget`](crate::model::LambdaTarget)
        pub fn build(self) -> crate::model::LambdaTarget {
            crate::model::LambdaTarget {
                deployment_id: self.deployment_id,
                target_id: self.target_id,
                target_arn: self.target_arn,
                status: self.status,
                last_updated_at: self.last_updated_at,
                lifecycle_events: self.lifecycle_events,
                lambda_function_info: self.lambda_function_info,
            }
        }
    }
}
impl LambdaTarget {
    /// Creates a new builder-style object to manufacture [`LambdaTarget`](crate::model::LambdaTarget)
    pub fn builder() -> crate::model::lambda_target::Builder {
        crate::model::lambda_target::Builder::default()
    }
}

/// <p> Information about a Lambda function specified in a deployment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionInfo {
    /// <p> The name of a Lambda function. </p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p> The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a> in the <i>AWS Lambda Developer Guide</i>.</p>
    pub function_alias: std::option::Option<std::string::String>,
    /// <p> The version of a Lambda function that production traffic points to. </p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p> The version of a Lambda function that production traffic points to after the Lambda function is deployed. </p>
    pub target_version: std::option::Option<std::string::String>,
    /// <p> The percentage of production traffic that the target version of a Lambda function receives. </p>
    pub target_version_weight: f64,
}
impl LambdaFunctionInfo {
    /// <p> The name of a Lambda function. </p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p> The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a> in the <i>AWS Lambda Developer Guide</i>.</p>
    pub fn function_alias(&self) -> std::option::Option<&str> {
        self.function_alias.as_deref()
    }
    /// <p> The version of a Lambda function that production traffic points to. </p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
    /// <p> The version of a Lambda function that production traffic points to after the Lambda function is deployed. </p>
    pub fn target_version(&self) -> std::option::Option<&str> {
        self.target_version.as_deref()
    }
    /// <p> The percentage of production traffic that the target version of a Lambda function receives. </p>
    pub fn target_version_weight(&self) -> f64 {
        self.target_version_weight
    }
}
impl std::fmt::Debug for LambdaFunctionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionInfo");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_alias", &self.function_alias);
        formatter.field("current_version", &self.current_version);
        formatter.field("target_version", &self.target_version);
        formatter.field("target_version_weight", &self.target_version_weight);
        formatter.finish()
    }
}
/// See [`LambdaFunctionInfo`](crate::model::LambdaFunctionInfo)
pub mod lambda_function_info {
    /// A builder for [`LambdaFunctionInfo`](crate::model::LambdaFunctionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_alias: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) target_version: std::option::Option<std::string::String>,
        pub(crate) target_version_weight: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The name of a Lambda function. </p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p> The name of a Lambda function. </p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p> The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a> in the <i>AWS Lambda Developer Guide</i>.</p>
        pub fn function_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_alias = Some(input.into());
            self
        }
        /// <p> The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a> in the <i>AWS Lambda Developer Guide</i>.</p>
        pub fn set_function_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_alias = input;
            self
        }
        /// <p> The version of a Lambda function that production traffic points to. </p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p> The version of a Lambda function that production traffic points to. </p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p> The version of a Lambda function that production traffic points to after the Lambda function is deployed. </p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_version = Some(input.into());
            self
        }
        /// <p> The version of a Lambda function that production traffic points to after the Lambda function is deployed. </p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_version = input;
            self
        }
        /// <p> The percentage of production traffic that the target version of a Lambda function receives. </p>
        pub fn target_version_weight(mut self, input: f64) -> Self {
            self.target_version_weight = Some(input);
            self
        }
        /// <p> The percentage of production traffic that the target version of a Lambda function receives. </p>
        pub fn set_target_version_weight(mut self, input: std::option::Option<f64>) -> Self {
            self.target_version_weight = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionInfo`](crate::model::LambdaFunctionInfo)
        pub fn build(self) -> crate::model::LambdaFunctionInfo {
            crate::model::LambdaFunctionInfo {
                function_name: self.function_name,
                function_alias: self.function_alias,
                current_version: self.current_version,
                target_version: self.target_version,
                target_version_weight: self.target_version_weight.unwrap_or_default(),
            }
        }
    }
}
impl LambdaFunctionInfo {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionInfo`](crate::model::LambdaFunctionInfo)
    pub fn builder() -> crate::model::lambda_function_info::Builder {
        crate::model::lambda_function_info::Builder::default()
    }
}

/// <p> A target Amazon EC2 or on-premises instance during a deployment that uses the EC2/On-premises compute platform. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceTarget {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p> The unique ID of a deployment target that has a type of <code>instanceTarget</code>. </p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the target. </p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p> The status an EC2/On-premises deployment's target instance. </p>
    pub status: std::option::Option<crate::model::TargetStatus>,
    /// <p> The date and time when the target instance was updated by a deployment. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The lifecycle events of the deployment to this target instance. </p>
    pub lifecycle_events: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
    /// <p> A label that identifies whether the instance is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
    pub instance_label: std::option::Option<crate::model::TargetLabel>,
}
impl InstanceTarget {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p> The unique ID of a deployment target that has a type of <code>instanceTarget</code>. </p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the target. </p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p> The status an EC2/On-premises deployment's target instance. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::TargetStatus> {
        self.status.as_ref()
    }
    /// <p> The date and time when the target instance was updated by a deployment. </p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p> The lifecycle events of the deployment to this target instance. </p>
    pub fn lifecycle_events(&self) -> std::option::Option<&[crate::model::LifecycleEvent]> {
        self.lifecycle_events.as_deref()
    }
    /// <p> A label that identifies whether the instance is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
    pub fn instance_label(&self) -> std::option::Option<&crate::model::TargetLabel> {
        self.instance_label.as_ref()
    }
}
impl std::fmt::Debug for InstanceTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceTarget");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("status", &self.status);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("lifecycle_events", &self.lifecycle_events);
        formatter.field("instance_label", &self.instance_label);
        formatter.finish()
    }
}
/// See [`InstanceTarget`](crate::model::InstanceTarget)
pub mod instance_target {
    /// A builder for [`InstanceTarget`](crate::model::InstanceTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TargetStatus>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lifecycle_events:
            std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        pub(crate) instance_label: std::option::Option<crate::model::TargetLabel>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p> The unique ID of a deployment target that has a type of <code>instanceTarget</code>. </p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment target that has a type of <code>instanceTarget</code>. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the target. </p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the target. </p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p> The status an EC2/On-premises deployment's target instance. </p>
        pub fn status(mut self, input: crate::model::TargetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status an EC2/On-premises deployment's target instance. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TargetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The date and time when the target instance was updated by a deployment. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> The date and time when the target instance was updated by a deployment. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Appends an item to `lifecycle_events`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_events`](Self::set_lifecycle_events).
        ///
        /// <p> The lifecycle events of the deployment to this target instance. </p>
        pub fn lifecycle_events(mut self, input: crate::model::LifecycleEvent) -> Self {
            let mut v = self.lifecycle_events.unwrap_or_default();
            v.push(input);
            self.lifecycle_events = Some(v);
            self
        }
        /// <p> The lifecycle events of the deployment to this target instance. </p>
        pub fn set_lifecycle_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        ) -> Self {
            self.lifecycle_events = input;
            self
        }
        /// <p> A label that identifies whether the instance is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
        pub fn instance_label(mut self, input: crate::model::TargetLabel) -> Self {
            self.instance_label = Some(input);
            self
        }
        /// <p> A label that identifies whether the instance is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>
        pub fn set_instance_label(
            mut self,
            input: std::option::Option<crate::model::TargetLabel>,
        ) -> Self {
            self.instance_label = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceTarget`](crate::model::InstanceTarget)
        pub fn build(self) -> crate::model::InstanceTarget {
            crate::model::InstanceTarget {
                deployment_id: self.deployment_id,
                target_id: self.target_id,
                target_arn: self.target_arn,
                status: self.status,
                last_updated_at: self.last_updated_at,
                lifecycle_events: self.lifecycle_events,
                instance_label: self.instance_label,
            }
        }
    }
}
impl InstanceTarget {
    /// Creates a new builder-style object to manufacture [`InstanceTarget`](crate::model::InstanceTarget)
    pub fn builder() -> crate::model::instance_target::Builder {
        crate::model::instance_target::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentTargetType {
    #[allow(missing_docs)] // documentation missing in model
    CloudformationTarget,
    #[allow(missing_docs)] // documentation missing in model
    EcsTarget,
    #[allow(missing_docs)] // documentation missing in model
    InstanceTarget,
    #[allow(missing_docs)] // documentation missing in model
    LambdaTarget,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentTargetType {
    fn from(s: &str) -> Self {
        match s {
            "CloudFormationTarget" => DeploymentTargetType::CloudformationTarget,
            "ECSTarget" => DeploymentTargetType::EcsTarget,
            "InstanceTarget" => DeploymentTargetType::InstanceTarget,
            "LambdaTarget" => DeploymentTargetType::LambdaTarget,
            other => DeploymentTargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentTargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentTargetType::from(s))
    }
}
impl DeploymentTargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentTargetType::CloudformationTarget => "CloudFormationTarget",
            DeploymentTargetType::EcsTarget => "ECSTarget",
            DeploymentTargetType::InstanceTarget => "InstanceTarget",
            DeploymentTargetType::LambdaTarget => "LambdaTarget",
            DeploymentTargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CloudFormationTarget",
            "ECSTarget",
            "InstanceTarget",
            "LambdaTarget",
        ]
    }
}
impl AsRef<str> for DeploymentTargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an instance in a deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceSummary {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The deployment status for this instance:</p>
    /// <ul>
    /// <li> <p> <code>Pending</code>: The deployment is pending for this instance.</p> </li>
    /// <li> <p> <code>In Progress</code>: The deployment is in progress for this instance.</p> </li>
    /// <li> <p> <code>Succeeded</code>: The deployment has succeeded for this instance.</p> </li>
    /// <li> <p> <code>Failed</code>: The deployment has failed for this instance.</p> </li>
    /// <li> <p> <code>Skipped</code>: The deployment has been skipped for this instance.</p> </li>
    /// <li> <p> <code>Unknown</code>: The deployment status is unknown for this instance.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::InstanceStatus>,
    /// <p>A timestamp that indicates when the instance information was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of lifecycle events for this instance.</p>
    pub lifecycle_events: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
    /// <p>Information about which environment an instance belongs to in a blue/green deployment.</p>
    /// <ul>
    /// <li> <p>BLUE: The instance is part of the original environment.</p> </li>
    /// <li> <p>GREEN: The instance is part of the replacement environment.</p> </li>
    /// </ul>
    pub instance_type: std::option::Option<crate::model::InstanceType>,
}
impl InstanceSummary {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The deployment status for this instance:</p>
    /// <ul>
    /// <li> <p> <code>Pending</code>: The deployment is pending for this instance.</p> </li>
    /// <li> <p> <code>In Progress</code>: The deployment is in progress for this instance.</p> </li>
    /// <li> <p> <code>Succeeded</code>: The deployment has succeeded for this instance.</p> </li>
    /// <li> <p> <code>Failed</code>: The deployment has failed for this instance.</p> </li>
    /// <li> <p> <code>Skipped</code>: The deployment has been skipped for this instance.</p> </li>
    /// <li> <p> <code>Unknown</code>: The deployment status is unknown for this instance.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::InstanceStatus> {
        self.status.as_ref()
    }
    /// <p>A timestamp that indicates when the instance information was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>A list of lifecycle events for this instance.</p>
    pub fn lifecycle_events(&self) -> std::option::Option<&[crate::model::LifecycleEvent]> {
        self.lifecycle_events.as_deref()
    }
    /// <p>Information about which environment an instance belongs to in a blue/green deployment.</p>
    /// <ul>
    /// <li> <p>BLUE: The instance is part of the original environment.</p> </li>
    /// <li> <p>GREEN: The instance is part of the replacement environment.</p> </li>
    /// </ul>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::InstanceType> {
        self.instance_type.as_ref()
    }
}
impl std::fmt::Debug for InstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceSummary");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("status", &self.status);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("lifecycle_events", &self.lifecycle_events);
        formatter.field("instance_type", &self.instance_type);
        formatter.finish()
    }
}
/// See [`InstanceSummary`](crate::model::InstanceSummary)
pub mod instance_summary {
    /// A builder for [`InstanceSummary`](crate::model::InstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::InstanceStatus>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lifecycle_events:
            std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        pub(crate) instance_type: std::option::Option<crate::model::InstanceType>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The deployment status for this instance:</p>
        /// <ul>
        /// <li> <p> <code>Pending</code>: The deployment is pending for this instance.</p> </li>
        /// <li> <p> <code>In Progress</code>: The deployment is in progress for this instance.</p> </li>
        /// <li> <p> <code>Succeeded</code>: The deployment has succeeded for this instance.</p> </li>
        /// <li> <p> <code>Failed</code>: The deployment has failed for this instance.</p> </li>
        /// <li> <p> <code>Skipped</code>: The deployment has been skipped for this instance.</p> </li>
        /// <li> <p> <code>Unknown</code>: The deployment status is unknown for this instance.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::InstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The deployment status for this instance:</p>
        /// <ul>
        /// <li> <p> <code>Pending</code>: The deployment is pending for this instance.</p> </li>
        /// <li> <p> <code>In Progress</code>: The deployment is in progress for this instance.</p> </li>
        /// <li> <p> <code>Succeeded</code>: The deployment has succeeded for this instance.</p> </li>
        /// <li> <p> <code>Failed</code>: The deployment has failed for this instance.</p> </li>
        /// <li> <p> <code>Skipped</code>: The deployment has been skipped for this instance.</p> </li>
        /// <li> <p> <code>Unknown</code>: The deployment status is unknown for this instance.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp that indicates when the instance information was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the instance information was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Appends an item to `lifecycle_events`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_events`](Self::set_lifecycle_events).
        ///
        /// <p>A list of lifecycle events for this instance.</p>
        pub fn lifecycle_events(mut self, input: crate::model::LifecycleEvent) -> Self {
            let mut v = self.lifecycle_events.unwrap_or_default();
            v.push(input);
            self.lifecycle_events = Some(v);
            self
        }
        /// <p>A list of lifecycle events for this instance.</p>
        pub fn set_lifecycle_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleEvent>>,
        ) -> Self {
            self.lifecycle_events = input;
            self
        }
        /// <p>Information about which environment an instance belongs to in a blue/green deployment.</p>
        /// <ul>
        /// <li> <p>BLUE: The instance is part of the original environment.</p> </li>
        /// <li> <p>GREEN: The instance is part of the replacement environment.</p> </li>
        /// </ul>
        pub fn instance_type(mut self, input: crate::model::InstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>Information about which environment an instance belongs to in a blue/green deployment.</p>
        /// <ul>
        /// <li> <p>BLUE: The instance is part of the original environment.</p> </li>
        /// <li> <p>GREEN: The instance is part of the replacement environment.</p> </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::InstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceSummary`](crate::model::InstanceSummary)
        pub fn build(self) -> crate::model::InstanceSummary {
            crate::model::InstanceSummary {
                deployment_id: self.deployment_id,
                instance_id: self.instance_id,
                status: self.status,
                last_updated_at: self.last_updated_at,
                lifecycle_events: self.lifecycle_events,
                instance_type: self.instance_type,
            }
        }
    }
}
impl InstanceSummary {
    /// Creates a new builder-style object to manufacture [`InstanceSummary`](crate::model::InstanceSummary)
    pub fn builder() -> crate::model::instance_summary::Builder {
        crate::model::instance_summary::Builder::default()
    }
}

/// <p>Information about a deployment group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentGroupInfo {
    /// <p>The application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The deployment group ID.</p>
    pub deployment_group_id: std::option::Option<std::string::String>,
    /// <p>The deployment group name.</p>
    pub deployment_group_name: std::option::Option<std::string::String>,
    /// <p>The deployment configuration name.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags.</p>
    pub ec2_tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
    /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags.</p>
    pub on_premises_instance_tag_filters:
        std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
    /// <p>A list of associated Auto Scaling groups.</p>
    pub auto_scaling_groups: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
    /// <p>A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>Information about the deployment group's target revision, including type and location.</p>
    pub target_revision: std::option::Option<crate::model::RevisionLocation>,
    /// <p>Information about triggers associated with the deployment group.</p>
    pub trigger_configurations: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
    /// <p>A list of alarms associated with the deployment group.</p>
    pub alarm_configuration: std::option::Option<crate::model::AlarmConfiguration>,
    /// <p>Information about the automatic rollback configuration associated with the deployment group.</p>
    pub auto_rollback_configuration: std::option::Option<crate::model::AutoRollbackConfiguration>,
    /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub deployment_style: std::option::Option<crate::model::DeploymentStyle>,
    /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
    /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
    /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    pub outdated_instances_strategy: std::option::Option<crate::model::OutdatedInstancesStrategy>,
    /// <p>Information about blue/green deployment options for a deployment group.</p>
    pub blue_green_deployment_configuration:
        std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
    /// <p>Information about the load balancer to use in a deployment.</p>
    pub load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
    /// <p>Information about the most recent successful deployment to the deployment group.</p>
    pub last_successful_deployment: std::option::Option<crate::model::LastDeploymentInfo>,
    /// <p>Information about the most recent attempted deployment to the deployment group.</p>
    pub last_attempted_deployment: std::option::Option<crate::model::LastDeploymentInfo>,
    /// <p>Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.</p>
    pub ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
    /// <p>Information about groups of tags applied to an on-premises instance. The deployment group includes only on-premises instances identified by all the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.</p>
    pub on_premises_tag_set: std::option::Option<crate::model::OnPremisesTagSet>,
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
    /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. </p>
    pub ecs_services: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
}
impl DeploymentGroupInfo {
    /// <p>The application name.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The deployment group ID.</p>
    pub fn deployment_group_id(&self) -> std::option::Option<&str> {
        self.deployment_group_id.as_deref()
    }
    /// <p>The deployment group name.</p>
    pub fn deployment_group_name(&self) -> std::option::Option<&str> {
        self.deployment_group_name.as_deref()
    }
    /// <p>The deployment configuration name.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
    /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags.</p>
    pub fn ec2_tag_filters(&self) -> std::option::Option<&[crate::model::Ec2TagFilter]> {
        self.ec2_tag_filters.as_deref()
    }
    /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags.</p>
    pub fn on_premises_instance_tag_filters(
        &self,
    ) -> std::option::Option<&[crate::model::TagFilter]> {
        self.on_premises_instance_tag_filters.as_deref()
    }
    /// <p>A list of associated Auto Scaling groups.</p>
    pub fn auto_scaling_groups(&self) -> std::option::Option<&[crate::model::AutoScalingGroup]> {
        self.auto_scaling_groups.as_deref()
    }
    /// <p>A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>Information about the deployment group's target revision, including type and location.</p>
    pub fn target_revision(&self) -> std::option::Option<&crate::model::RevisionLocation> {
        self.target_revision.as_ref()
    }
    /// <p>Information about triggers associated with the deployment group.</p>
    pub fn trigger_configurations(&self) -> std::option::Option<&[crate::model::TriggerConfig]> {
        self.trigger_configurations.as_deref()
    }
    /// <p>A list of alarms associated with the deployment group.</p>
    pub fn alarm_configuration(&self) -> std::option::Option<&crate::model::AlarmConfiguration> {
        self.alarm_configuration.as_ref()
    }
    /// <p>Information about the automatic rollback configuration associated with the deployment group.</p>
    pub fn auto_rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoRollbackConfiguration> {
        self.auto_rollback_configuration.as_ref()
    }
    /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub fn deployment_style(&self) -> std::option::Option<&crate::model::DeploymentStyle> {
        self.deployment_style.as_ref()
    }
    /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
    /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
    /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    pub fn outdated_instances_strategy(
        &self,
    ) -> std::option::Option<&crate::model::OutdatedInstancesStrategy> {
        self.outdated_instances_strategy.as_ref()
    }
    /// <p>Information about blue/green deployment options for a deployment group.</p>
    pub fn blue_green_deployment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::BlueGreenDeploymentConfiguration> {
        self.blue_green_deployment_configuration.as_ref()
    }
    /// <p>Information about the load balancer to use in a deployment.</p>
    pub fn load_balancer_info(&self) -> std::option::Option<&crate::model::LoadBalancerInfo> {
        self.load_balancer_info.as_ref()
    }
    /// <p>Information about the most recent successful deployment to the deployment group.</p>
    pub fn last_successful_deployment(
        &self,
    ) -> std::option::Option<&crate::model::LastDeploymentInfo> {
        self.last_successful_deployment.as_ref()
    }
    /// <p>Information about the most recent attempted deployment to the deployment group.</p>
    pub fn last_attempted_deployment(
        &self,
    ) -> std::option::Option<&crate::model::LastDeploymentInfo> {
        self.last_attempted_deployment.as_ref()
    }
    /// <p>Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.</p>
    pub fn ec2_tag_set(&self) -> std::option::Option<&crate::model::Ec2TagSet> {
        self.ec2_tag_set.as_ref()
    }
    /// <p>Information about groups of tags applied to an on-premises instance. The deployment group includes only on-premises instances identified by all the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.</p>
    pub fn on_premises_tag_set(&self) -> std::option::Option<&crate::model::OnPremisesTagSet> {
        self.on_premises_tag_set.as_ref()
    }
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub fn compute_platform(&self) -> std::option::Option<&crate::model::ComputePlatform> {
        self.compute_platform.as_ref()
    }
    /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
    /// <clustername>
    /// :
    /// <servicename></servicename>
    /// </clustername></code>. </p>
    pub fn ecs_services(&self) -> std::option::Option<&[crate::model::EcsService]> {
        self.ecs_services.as_deref()
    }
}
impl std::fmt::Debug for DeploymentGroupInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentGroupInfo");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_id", &self.deployment_group_id);
        formatter.field("deployment_group_name", &self.deployment_group_name);
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.field("ec2_tag_filters", &self.ec2_tag_filters);
        formatter.field(
            "on_premises_instance_tag_filters",
            &self.on_premises_instance_tag_filters,
        );
        formatter.field("auto_scaling_groups", &self.auto_scaling_groups);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("target_revision", &self.target_revision);
        formatter.field("trigger_configurations", &self.trigger_configurations);
        formatter.field("alarm_configuration", &self.alarm_configuration);
        formatter.field(
            "auto_rollback_configuration",
            &self.auto_rollback_configuration,
        );
        formatter.field("deployment_style", &self.deployment_style);
        formatter.field(
            "outdated_instances_strategy",
            &self.outdated_instances_strategy,
        );
        formatter.field(
            "blue_green_deployment_configuration",
            &self.blue_green_deployment_configuration,
        );
        formatter.field("load_balancer_info", &self.load_balancer_info);
        formatter.field(
            "last_successful_deployment",
            &self.last_successful_deployment,
        );
        formatter.field("last_attempted_deployment", &self.last_attempted_deployment);
        formatter.field("ec2_tag_set", &self.ec2_tag_set);
        formatter.field("on_premises_tag_set", &self.on_premises_tag_set);
        formatter.field("compute_platform", &self.compute_platform);
        formatter.field("ecs_services", &self.ecs_services);
        formatter.finish()
    }
}
/// See [`DeploymentGroupInfo`](crate::model::DeploymentGroupInfo)
pub mod deployment_group_info {
    /// A builder for [`DeploymentGroupInfo`](crate::model::DeploymentGroupInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_id: std::option::Option<std::string::String>,
        pub(crate) deployment_group_name: std::option::Option<std::string::String>,
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
        pub(crate) ec2_tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        pub(crate) on_premises_instance_tag_filters:
            std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        pub(crate) auto_scaling_groups:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) target_revision: std::option::Option<crate::model::RevisionLocation>,
        pub(crate) trigger_configurations:
            std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        pub(crate) alarm_configuration: std::option::Option<crate::model::AlarmConfiguration>,
        pub(crate) auto_rollback_configuration:
            std::option::Option<crate::model::AutoRollbackConfiguration>,
        pub(crate) deployment_style: std::option::Option<crate::model::DeploymentStyle>,
        pub(crate) outdated_instances_strategy:
            std::option::Option<crate::model::OutdatedInstancesStrategy>,
        pub(crate) blue_green_deployment_configuration:
            std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        pub(crate) load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
        pub(crate) last_successful_deployment:
            std::option::Option<crate::model::LastDeploymentInfo>,
        pub(crate) last_attempted_deployment: std::option::Option<crate::model::LastDeploymentInfo>,
        pub(crate) ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
        pub(crate) on_premises_tag_set: std::option::Option<crate::model::OnPremisesTagSet>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
        pub(crate) ecs_services: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
    }
    impl Builder {
        /// <p>The application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The deployment group ID.</p>
        pub fn deployment_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_id = Some(input.into());
            self
        }
        /// <p>The deployment group ID.</p>
        pub fn set_deployment_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_id = input;
            self
        }
        /// <p>The deployment group name.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_name = Some(input.into());
            self
        }
        /// <p>The deployment group name.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_name = input;
            self
        }
        /// <p>The deployment configuration name.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>The deployment configuration name.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// Appends an item to `ec2_tag_filters`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_filters`](Self::set_ec2_tag_filters).
        ///
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags.</p>
        pub fn ec2_tag_filters(mut self, input: crate::model::Ec2TagFilter) -> Self {
            let mut v = self.ec2_tag_filters.unwrap_or_default();
            v.push(input);
            self.ec2_tag_filters = Some(v);
            self
        }
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags.</p>
        pub fn set_ec2_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.ec2_tag_filters = input;
            self
        }
        /// Appends an item to `on_premises_instance_tag_filters`.
        ///
        /// To override the contents of this collection use [`set_on_premises_instance_tag_filters`](Self::set_on_premises_instance_tag_filters).
        ///
        /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags.</p>
        pub fn on_premises_instance_tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            let mut v = self.on_premises_instance_tag_filters.unwrap_or_default();
            v.push(input);
            self.on_premises_instance_tag_filters = Some(v);
            self
        }
        /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags.</p>
        pub fn set_on_premises_instance_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.on_premises_instance_tag_filters = input;
            self
        }
        /// Appends an item to `auto_scaling_groups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>A list of associated Auto Scaling groups.</p>
        pub fn auto_scaling_groups(mut self, input: crate::model::AutoScalingGroup) -> Self {
            let mut v = self.auto_scaling_groups.unwrap_or_default();
            v.push(input);
            self.auto_scaling_groups = Some(v);
            self
        }
        /// <p>A list of associated Auto Scaling groups.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        ) -> Self {
            self.auto_scaling_groups = input;
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>Information about the deployment group's target revision, including type and location.</p>
        pub fn target_revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.target_revision = Some(input);
            self
        }
        /// <p>Information about the deployment group's target revision, including type and location.</p>
        pub fn set_target_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.target_revision = input;
            self
        }
        /// Appends an item to `trigger_configurations`.
        ///
        /// To override the contents of this collection use [`set_trigger_configurations`](Self::set_trigger_configurations).
        ///
        /// <p>Information about triggers associated with the deployment group.</p>
        pub fn trigger_configurations(mut self, input: crate::model::TriggerConfig) -> Self {
            let mut v = self.trigger_configurations.unwrap_or_default();
            v.push(input);
            self.trigger_configurations = Some(v);
            self
        }
        /// <p>Information about triggers associated with the deployment group.</p>
        pub fn set_trigger_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        ) -> Self {
            self.trigger_configurations = input;
            self
        }
        /// <p>A list of alarms associated with the deployment group.</p>
        pub fn alarm_configuration(mut self, input: crate::model::AlarmConfiguration) -> Self {
            self.alarm_configuration = Some(input);
            self
        }
        /// <p>A list of alarms associated with the deployment group.</p>
        pub fn set_alarm_configuration(
            mut self,
            input: std::option::Option<crate::model::AlarmConfiguration>,
        ) -> Self {
            self.alarm_configuration = input;
            self
        }
        /// <p>Information about the automatic rollback configuration associated with the deployment group.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.auto_rollback_configuration = Some(input);
            self
        }
        /// <p>Information about the automatic rollback configuration associated with the deployment group.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.auto_rollback_configuration = input;
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, input: crate::model::DeploymentStyle) -> Self {
            self.deployment_style = Some(input);
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.deployment_style = input;
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn outdated_instances_strategy(
            mut self,
            input: crate::model::OutdatedInstancesStrategy,
        ) -> Self {
            self.outdated_instances_strategy = Some(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn set_outdated_instances_strategy(
            mut self,
            input: std::option::Option<crate::model::OutdatedInstancesStrategy>,
        ) -> Self {
            self.outdated_instances_strategy = input;
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            input: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.blue_green_deployment_configuration = Some(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.blue_green_deployment_configuration = input;
            self
        }
        /// <p>Information about the load balancer to use in a deployment.</p>
        pub fn load_balancer_info(mut self, input: crate::model::LoadBalancerInfo) -> Self {
            self.load_balancer_info = Some(input);
            self
        }
        /// <p>Information about the load balancer to use in a deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.load_balancer_info = input;
            self
        }
        /// <p>Information about the most recent successful deployment to the deployment group.</p>
        pub fn last_successful_deployment(
            mut self,
            input: crate::model::LastDeploymentInfo,
        ) -> Self {
            self.last_successful_deployment = Some(input);
            self
        }
        /// <p>Information about the most recent successful deployment to the deployment group.</p>
        pub fn set_last_successful_deployment(
            mut self,
            input: std::option::Option<crate::model::LastDeploymentInfo>,
        ) -> Self {
            self.last_successful_deployment = input;
            self
        }
        /// <p>Information about the most recent attempted deployment to the deployment group.</p>
        pub fn last_attempted_deployment(
            mut self,
            input: crate::model::LastDeploymentInfo,
        ) -> Self {
            self.last_attempted_deployment = Some(input);
            self
        }
        /// <p>Information about the most recent attempted deployment to the deployment group.</p>
        pub fn set_last_attempted_deployment(
            mut self,
            input: std::option::Option<crate::model::LastDeploymentInfo>,
        ) -> Self {
            self.last_attempted_deployment = input;
            self
        }
        /// <p>Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.</p>
        pub fn ec2_tag_set(mut self, input: crate::model::Ec2TagSet) -> Self {
            self.ec2_tag_set = Some(input);
            self
        }
        /// <p>Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.ec2_tag_set = input;
            self
        }
        /// <p>Information about groups of tags applied to an on-premises instance. The deployment group includes only on-premises instances identified by all the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.</p>
        pub fn on_premises_tag_set(mut self, input: crate::model::OnPremisesTagSet) -> Self {
            self.on_premises_tag_set = Some(input);
            self
        }
        /// <p>Information about groups of tags applied to an on-premises instance. The deployment group includes only on-premises instances identified by all the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.</p>
        pub fn set_on_premises_tag_set(
            mut self,
            input: std::option::Option<crate::model::OnPremisesTagSet>,
        ) -> Self {
            self.on_premises_tag_set = input;
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// Appends an item to `ecs_services`.
        ///
        /// To override the contents of this collection use [`set_ecs_services`](Self::set_ecs_services).
        ///
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn ecs_services(mut self, input: crate::model::EcsService) -> Self {
            let mut v = self.ecs_services.unwrap_or_default();
            v.push(input);
            self.ecs_services = Some(v);
            self
        }
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn set_ecs_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        ) -> Self {
            self.ecs_services = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentGroupInfo`](crate::model::DeploymentGroupInfo)
        pub fn build(self) -> crate::model::DeploymentGroupInfo {
            crate::model::DeploymentGroupInfo {
                application_name: self.application_name,
                deployment_group_id: self.deployment_group_id,
                deployment_group_name: self.deployment_group_name,
                deployment_config_name: self.deployment_config_name,
                ec2_tag_filters: self.ec2_tag_filters,
                on_premises_instance_tag_filters: self.on_premises_instance_tag_filters,
                auto_scaling_groups: self.auto_scaling_groups,
                service_role_arn: self.service_role_arn,
                target_revision: self.target_revision,
                trigger_configurations: self.trigger_configurations,
                alarm_configuration: self.alarm_configuration,
                auto_rollback_configuration: self.auto_rollback_configuration,
                deployment_style: self.deployment_style,
                outdated_instances_strategy: self.outdated_instances_strategy,
                blue_green_deployment_configuration: self.blue_green_deployment_configuration,
                load_balancer_info: self.load_balancer_info,
                last_successful_deployment: self.last_successful_deployment,
                last_attempted_deployment: self.last_attempted_deployment,
                ec2_tag_set: self.ec2_tag_set,
                on_premises_tag_set: self.on_premises_tag_set,
                compute_platform: self.compute_platform,
                ecs_services: self.ecs_services,
            }
        }
    }
}
impl DeploymentGroupInfo {
    /// Creates a new builder-style object to manufacture [`DeploymentGroupInfo`](crate::model::DeploymentGroupInfo)
    pub fn builder() -> crate::model::deployment_group_info::Builder {
        crate::model::deployment_group_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputePlatform {
    #[allow(missing_docs)] // documentation missing in model
    Ecs,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    Server,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputePlatform {
    fn from(s: &str) -> Self {
        match s {
            "ECS" => ComputePlatform::Ecs,
            "Lambda" => ComputePlatform::Lambda,
            "Server" => ComputePlatform::Server,
            other => ComputePlatform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputePlatform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputePlatform::from(s))
    }
}
impl ComputePlatform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputePlatform::Ecs => "ECS",
            ComputePlatform::Lambda => "Lambda",
            ComputePlatform::Server => "Server",
            ComputePlatform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ECS", "Lambda", "Server"]
    }
}
impl AsRef<str> for ComputePlatform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the most recent attempted or successful deployment to a deployment group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LastDeploymentInfo {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The status of the most recent deployment.</p>
    pub status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>A timestamp that indicates when the most recent deployment to the deployment group was complete.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the most recent deployment to the deployment group started.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl LastDeploymentInfo {
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The status of the most recent deployment.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.status.as_ref()
    }
    /// <p>A timestamp that indicates when the most recent deployment to the deployment group was complete.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>A timestamp that indicates when the most recent deployment to the deployment group started.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
}
impl std::fmt::Debug for LastDeploymentInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LastDeploymentInfo");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("status", &self.status);
        formatter.field("end_time", &self.end_time);
        formatter.field("create_time", &self.create_time);
        formatter.finish()
    }
}
/// See [`LastDeploymentInfo`](crate::model::LastDeploymentInfo)
pub mod last_deployment_info {
    /// A builder for [`LastDeploymentInfo`](crate::model::LastDeploymentInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The status of the most recent deployment.</p>
        pub fn status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the most recent deployment.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp that indicates when the most recent deployment to the deployment group was complete.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the most recent deployment to the deployment group was complete.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>A timestamp that indicates when the most recent deployment to the deployment group started.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the most recent deployment to the deployment group started.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LastDeploymentInfo`](crate::model::LastDeploymentInfo)
        pub fn build(self) -> crate::model::LastDeploymentInfo {
            crate::model::LastDeploymentInfo {
                deployment_id: self.deployment_id,
                status: self.status,
                end_time: self.end_time,
                create_time: self.create_time,
            }
        }
    }
}
impl LastDeploymentInfo {
    /// Creates a new builder-style object to manufacture [`LastDeploymentInfo`](crate::model::LastDeploymentInfo)
    pub fn builder() -> crate::model::last_deployment_info::Builder {
        crate::model::last_deployment_info::Builder::default()
    }
}

/// <p>Information about a deployment configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentConfigInfo {
    /// <p>The deployment configuration ID.</p>
    pub deployment_config_id: std::option::Option<std::string::String>,
    /// <p>The deployment configuration name.</p>
    pub deployment_config_name: std::option::Option<std::string::String>,
    /// <p>Information about the number or percentage of minimum healthy instance.</p>
    pub minimum_healthy_hosts: std::option::Option<crate::model::MinimumHealthyHosts>,
    /// <p>The time at which the deployment configuration was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
    /// <p>The configuration that specifies how the deployment traffic is routed. Used for deployments with a Lambda or ECS compute platform only.</p>
    pub traffic_routing_config: std::option::Option<crate::model::TrafficRoutingConfig>,
}
impl DeploymentConfigInfo {
    /// <p>The deployment configuration ID.</p>
    pub fn deployment_config_id(&self) -> std::option::Option<&str> {
        self.deployment_config_id.as_deref()
    }
    /// <p>The deployment configuration name.</p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
    /// <p>Information about the number or percentage of minimum healthy instance.</p>
    pub fn minimum_healthy_hosts(&self) -> std::option::Option<&crate::model::MinimumHealthyHosts> {
        self.minimum_healthy_hosts.as_ref()
    }
    /// <p>The time at which the deployment configuration was created.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub fn compute_platform(&self) -> std::option::Option<&crate::model::ComputePlatform> {
        self.compute_platform.as_ref()
    }
    /// <p>The configuration that specifies how the deployment traffic is routed. Used for deployments with a Lambda or ECS compute platform only.</p>
    pub fn traffic_routing_config(
        &self,
    ) -> std::option::Option<&crate::model::TrafficRoutingConfig> {
        self.traffic_routing_config.as_ref()
    }
}
impl std::fmt::Debug for DeploymentConfigInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentConfigInfo");
        formatter.field("deployment_config_id", &self.deployment_config_id);
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.field("minimum_healthy_hosts", &self.minimum_healthy_hosts);
        formatter.field("create_time", &self.create_time);
        formatter.field("compute_platform", &self.compute_platform);
        formatter.field("traffic_routing_config", &self.traffic_routing_config);
        formatter.finish()
    }
}
/// See [`DeploymentConfigInfo`](crate::model::DeploymentConfigInfo)
pub mod deployment_config_info {
    /// A builder for [`DeploymentConfigInfo`](crate::model::DeploymentConfigInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_config_id: std::option::Option<std::string::String>,
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
        pub(crate) minimum_healthy_hosts: std::option::Option<crate::model::MinimumHealthyHosts>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
        pub(crate) traffic_routing_config: std::option::Option<crate::model::TrafficRoutingConfig>,
    }
    impl Builder {
        /// <p>The deployment configuration ID.</p>
        pub fn deployment_config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_id = Some(input.into());
            self
        }
        /// <p>The deployment configuration ID.</p>
        pub fn set_deployment_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_id = input;
            self
        }
        /// <p>The deployment configuration name.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p>The deployment configuration name.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// <p>Information about the number or percentage of minimum healthy instance.</p>
        pub fn minimum_healthy_hosts(mut self, input: crate::model::MinimumHealthyHosts) -> Self {
            self.minimum_healthy_hosts = Some(input);
            self
        }
        /// <p>Information about the number or percentage of minimum healthy instance.</p>
        pub fn set_minimum_healthy_hosts(
            mut self,
            input: std::option::Option<crate::model::MinimumHealthyHosts>,
        ) -> Self {
            self.minimum_healthy_hosts = input;
            self
        }
        /// <p>The time at which the deployment configuration was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time at which the deployment configuration was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed. Used for deployments with a Lambda or ECS compute platform only.</p>
        pub fn traffic_routing_config(mut self, input: crate::model::TrafficRoutingConfig) -> Self {
            self.traffic_routing_config = Some(input);
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed. Used for deployments with a Lambda or ECS compute platform only.</p>
        pub fn set_traffic_routing_config(
            mut self,
            input: std::option::Option<crate::model::TrafficRoutingConfig>,
        ) -> Self {
            self.traffic_routing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentConfigInfo`](crate::model::DeploymentConfigInfo)
        pub fn build(self) -> crate::model::DeploymentConfigInfo {
            crate::model::DeploymentConfigInfo {
                deployment_config_id: self.deployment_config_id,
                deployment_config_name: self.deployment_config_name,
                minimum_healthy_hosts: self.minimum_healthy_hosts,
                create_time: self.create_time,
                compute_platform: self.compute_platform,
                traffic_routing_config: self.traffic_routing_config,
            }
        }
    }
}
impl DeploymentConfigInfo {
    /// Creates a new builder-style object to manufacture [`DeploymentConfigInfo`](crate::model::DeploymentConfigInfo)
    pub fn builder() -> crate::model::deployment_config_info::Builder {
        crate::model::deployment_config_info::Builder::default()
    }
}

/// <p>The configuration that specifies how traffic is shifted from one version of a Lambda function to another version during an AWS Lambda deployment, or from one Amazon ECS task set to another during an Amazon ECS deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrafficRoutingConfig {
    /// <p>The type of traffic shifting (<code>TimeBasedCanary</code> or <code>TimeBasedLinear</code>) used by a deployment configuration.</p>
    pub r#type: std::option::Option<crate::model::TrafficRoutingType>,
    /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
    pub time_based_canary: std::option::Option<crate::model::TimeBasedCanary>,
    /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
    pub time_based_linear: std::option::Option<crate::model::TimeBasedLinear>,
}
impl TrafficRoutingConfig {
    /// <p>The type of traffic shifting (<code>TimeBasedCanary</code> or <code>TimeBasedLinear</code>) used by a deployment configuration.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TrafficRoutingType> {
        self.r#type.as_ref()
    }
    /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
    pub fn time_based_canary(&self) -> std::option::Option<&crate::model::TimeBasedCanary> {
        self.time_based_canary.as_ref()
    }
    /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
    pub fn time_based_linear(&self) -> std::option::Option<&crate::model::TimeBasedLinear> {
        self.time_based_linear.as_ref()
    }
}
impl std::fmt::Debug for TrafficRoutingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrafficRoutingConfig");
        formatter.field("r#type", &self.r#type);
        formatter.field("time_based_canary", &self.time_based_canary);
        formatter.field("time_based_linear", &self.time_based_linear);
        formatter.finish()
    }
}
/// See [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
pub mod traffic_routing_config {
    /// A builder for [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::TrafficRoutingType>,
        pub(crate) time_based_canary: std::option::Option<crate::model::TimeBasedCanary>,
        pub(crate) time_based_linear: std::option::Option<crate::model::TimeBasedLinear>,
    }
    impl Builder {
        /// <p>The type of traffic shifting (<code>TimeBasedCanary</code> or <code>TimeBasedLinear</code>) used by a deployment configuration.</p>
        pub fn r#type(mut self, input: crate::model::TrafficRoutingType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of traffic shifting (<code>TimeBasedCanary</code> or <code>TimeBasedLinear</code>) used by a deployment configuration.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TrafficRoutingType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
        pub fn time_based_canary(mut self, input: crate::model::TimeBasedCanary) -> Self {
            self.time_based_canary = Some(input);
            self
        }
        /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
        pub fn set_time_based_canary(
            mut self,
            input: std::option::Option<crate::model::TimeBasedCanary>,
        ) -> Self {
            self.time_based_canary = input;
            self
        }
        /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
        pub fn time_based_linear(mut self, input: crate::model::TimeBasedLinear) -> Self {
            self.time_based_linear = Some(input);
            self
        }
        /// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
        pub fn set_time_based_linear(
            mut self,
            input: std::option::Option<crate::model::TimeBasedLinear>,
        ) -> Self {
            self.time_based_linear = input;
            self
        }
        /// Consumes the builder and constructs a [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
        pub fn build(self) -> crate::model::TrafficRoutingConfig {
            crate::model::TrafficRoutingConfig {
                r#type: self.r#type,
                time_based_canary: self.time_based_canary,
                time_based_linear: self.time_based_linear,
            }
        }
    }
}
impl TrafficRoutingConfig {
    /// Creates a new builder-style object to manufacture [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
    pub fn builder() -> crate::model::traffic_routing_config::Builder {
        crate::model::traffic_routing_config::Builder::default()
    }
}

/// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeBasedLinear {
    /// <p>The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code> deployment.</p>
    pub linear_percentage: i32,
    /// <p>The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.</p>
    pub linear_interval: i32,
}
impl TimeBasedLinear {
    /// <p>The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code> deployment.</p>
    pub fn linear_percentage(&self) -> i32 {
        self.linear_percentage
    }
    /// <p>The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.</p>
    pub fn linear_interval(&self) -> i32 {
        self.linear_interval
    }
}
impl std::fmt::Debug for TimeBasedLinear {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeBasedLinear");
        formatter.field("linear_percentage", &self.linear_percentage);
        formatter.field("linear_interval", &self.linear_interval);
        formatter.finish()
    }
}
/// See [`TimeBasedLinear`](crate::model::TimeBasedLinear)
pub mod time_based_linear {
    /// A builder for [`TimeBasedLinear`](crate::model::TimeBasedLinear)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) linear_percentage: std::option::Option<i32>,
        pub(crate) linear_interval: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code> deployment.</p>
        pub fn linear_percentage(mut self, input: i32) -> Self {
            self.linear_percentage = Some(input);
            self
        }
        /// <p>The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code> deployment.</p>
        pub fn set_linear_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.linear_percentage = input;
            self
        }
        /// <p>The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.</p>
        pub fn linear_interval(mut self, input: i32) -> Self {
            self.linear_interval = Some(input);
            self
        }
        /// <p>The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.</p>
        pub fn set_linear_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.linear_interval = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeBasedLinear`](crate::model::TimeBasedLinear)
        pub fn build(self) -> crate::model::TimeBasedLinear {
            crate::model::TimeBasedLinear {
                linear_percentage: self.linear_percentage.unwrap_or_default(),
                linear_interval: self.linear_interval.unwrap_or_default(),
            }
        }
    }
}
impl TimeBasedLinear {
    /// Creates a new builder-style object to manufacture [`TimeBasedLinear`](crate::model::TimeBasedLinear)
    pub fn builder() -> crate::model::time_based_linear::Builder {
        crate::model::time_based_linear::Builder::default()
    }
}

/// <p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeBasedCanary {
    /// <p>The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.</p>
    pub canary_percentage: i32,
    /// <p>The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment.</p>
    pub canary_interval: i32,
}
impl TimeBasedCanary {
    /// <p>The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.</p>
    pub fn canary_percentage(&self) -> i32 {
        self.canary_percentage
    }
    /// <p>The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment.</p>
    pub fn canary_interval(&self) -> i32 {
        self.canary_interval
    }
}
impl std::fmt::Debug for TimeBasedCanary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeBasedCanary");
        formatter.field("canary_percentage", &self.canary_percentage);
        formatter.field("canary_interval", &self.canary_interval);
        formatter.finish()
    }
}
/// See [`TimeBasedCanary`](crate::model::TimeBasedCanary)
pub mod time_based_canary {
    /// A builder for [`TimeBasedCanary`](crate::model::TimeBasedCanary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) canary_percentage: std::option::Option<i32>,
        pub(crate) canary_interval: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.</p>
        pub fn canary_percentage(mut self, input: i32) -> Self {
            self.canary_percentage = Some(input);
            self
        }
        /// <p>The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.</p>
        pub fn set_canary_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.canary_percentage = input;
            self
        }
        /// <p>The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment.</p>
        pub fn canary_interval(mut self, input: i32) -> Self {
            self.canary_interval = Some(input);
            self
        }
        /// <p>The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment.</p>
        pub fn set_canary_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.canary_interval = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeBasedCanary`](crate::model::TimeBasedCanary)
        pub fn build(self) -> crate::model::TimeBasedCanary {
            crate::model::TimeBasedCanary {
                canary_percentage: self.canary_percentage.unwrap_or_default(),
                canary_interval: self.canary_interval.unwrap_or_default(),
            }
        }
    }
}
impl TimeBasedCanary {
    /// Creates a new builder-style object to manufacture [`TimeBasedCanary`](crate::model::TimeBasedCanary)
    pub fn builder() -> crate::model::time_based_canary::Builder {
        crate::model::time_based_canary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrafficRoutingType {
    #[allow(missing_docs)] // documentation missing in model
    AllAtOnce,
    #[allow(missing_docs)] // documentation missing in model
    TimeBasedCanary,
    #[allow(missing_docs)] // documentation missing in model
    TimeBasedLinear,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrafficRoutingType {
    fn from(s: &str) -> Self {
        match s {
            "AllAtOnce" => TrafficRoutingType::AllAtOnce,
            "TimeBasedCanary" => TrafficRoutingType::TimeBasedCanary,
            "TimeBasedLinear" => TrafficRoutingType::TimeBasedLinear,
            other => TrafficRoutingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrafficRoutingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrafficRoutingType::from(s))
    }
}
impl TrafficRoutingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrafficRoutingType::AllAtOnce => "AllAtOnce",
            TrafficRoutingType::TimeBasedCanary => "TimeBasedCanary",
            TrafficRoutingType::TimeBasedLinear => "TimeBasedLinear",
            TrafficRoutingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AllAtOnce", "TimeBasedCanary", "TimeBasedLinear"]
    }
}
impl AsRef<str> for TrafficRoutingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about minimum healthy instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MinimumHealthyHosts {
    /// <p>The minimum healthy instance type:</p>
    /// <ul>
    /// <li> <p> <code>HOST_COUNT</code>: The minimum number of healthy instances as an absolute value.</p> </li>
    /// <li> <p> <code>FLEET_PERCENT</code>: The minimum number of healthy instances as a percentage of the total number of instances in the deployment.</p> </li>
    /// </ul>
    /// <p>In an example of nine instances, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instances at a time. The deployment is successful if four or more instances are deployed to successfully. Otherwise, the deployment fails.</p> <note>
    /// <p>In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment is still successful.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub r#type: std::option::Option<crate::model::MinimumHealthyHostsType>,
    /// <p>The minimum healthy instance value.</p>
    pub value: i32,
}
impl MinimumHealthyHosts {
    /// <p>The minimum healthy instance type:</p>
    /// <ul>
    /// <li> <p> <code>HOST_COUNT</code>: The minimum number of healthy instances as an absolute value.</p> </li>
    /// <li> <p> <code>FLEET_PERCENT</code>: The minimum number of healthy instances as a percentage of the total number of instances in the deployment.</p> </li>
    /// </ul>
    /// <p>In an example of nine instances, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instances at a time. The deployment is successful if four or more instances are deployed to successfully. Otherwise, the deployment fails.</p> <note>
    /// <p>In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment is still successful.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MinimumHealthyHostsType> {
        self.r#type.as_ref()
    }
    /// <p>The minimum healthy instance value.</p>
    pub fn value(&self) -> i32 {
        self.value
    }
}
impl std::fmt::Debug for MinimumHealthyHosts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MinimumHealthyHosts");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MinimumHealthyHosts`](crate::model::MinimumHealthyHosts)
pub mod minimum_healthy_hosts {
    /// A builder for [`MinimumHealthyHosts`](crate::model::MinimumHealthyHosts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::MinimumHealthyHostsType>,
        pub(crate) value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum healthy instance type:</p>
        /// <ul>
        /// <li> <p> <code>HOST_COUNT</code>: The minimum number of healthy instances as an absolute value.</p> </li>
        /// <li> <p> <code>FLEET_PERCENT</code>: The minimum number of healthy instances as a percentage of the total number of instances in the deployment.</p> </li>
        /// </ul>
        /// <p>In an example of nine instances, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instances at a time. The deployment is successful if four or more instances are deployed to successfully. Otherwise, the deployment fails.</p> <note>
        /// <p>In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment is still successful.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::MinimumHealthyHostsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The minimum healthy instance type:</p>
        /// <ul>
        /// <li> <p> <code>HOST_COUNT</code>: The minimum number of healthy instances as an absolute value.</p> </li>
        /// <li> <p> <code>FLEET_PERCENT</code>: The minimum number of healthy instances as a percentage of the total number of instances in the deployment.</p> </li>
        /// </ul>
        /// <p>In an example of nine instances, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instances at a time. The deployment is successful if four or more instances are deployed to successfully. Otherwise, the deployment fails.</p> <note>
        /// <p>In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment is still successful.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::MinimumHealthyHostsType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The minimum healthy instance value.</p>
        pub fn value(mut self, input: i32) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The minimum healthy instance value.</p>
        pub fn set_value(mut self, input: std::option::Option<i32>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MinimumHealthyHosts`](crate::model::MinimumHealthyHosts)
        pub fn build(self) -> crate::model::MinimumHealthyHosts {
            crate::model::MinimumHealthyHosts {
                r#type: self.r#type,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl MinimumHealthyHosts {
    /// Creates a new builder-style object to manufacture [`MinimumHealthyHosts`](crate::model::MinimumHealthyHosts)
    pub fn builder() -> crate::model::minimum_healthy_hosts::Builder {
        crate::model::minimum_healthy_hosts::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MinimumHealthyHostsType {
    #[allow(missing_docs)] // documentation missing in model
    FleetPercent,
    #[allow(missing_docs)] // documentation missing in model
    HostCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MinimumHealthyHostsType {
    fn from(s: &str) -> Self {
        match s {
            "FLEET_PERCENT" => MinimumHealthyHostsType::FleetPercent,
            "HOST_COUNT" => MinimumHealthyHostsType::HostCount,
            other => MinimumHealthyHostsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MinimumHealthyHostsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MinimumHealthyHostsType::from(s))
    }
}
impl MinimumHealthyHostsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MinimumHealthyHostsType::FleetPercent => "FLEET_PERCENT",
            MinimumHealthyHostsType::HostCount => "HOST_COUNT",
            MinimumHealthyHostsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FLEET_PERCENT", "HOST_COUNT"]
    }
}
impl AsRef<str> for MinimumHealthyHostsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentInfo {
    /// <p>The application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p> The deployment group name. </p>
    pub deployment_group_name: std::option::Option<std::string::String>,
    /// <p> The deployment configuration name. </p>
    pub deployment_config_name: std::option::Option<std::string::String>,
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>Information about the application revision that was deployed to the deployment group before the most recent successful deployment.</p>
    pub previous_revision: std::option::Option<crate::model::RevisionLocation>,
    /// <p>Information about the location of stored application artifacts and the service from which to retrieve them.</p>
    pub revision: std::option::Option<crate::model::RevisionLocation>,
    /// <p>The current state of the deployment as a whole.</p>
    pub status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>Information about any error associated with this deployment.</p>
    pub error_information: std::option::Option<crate::model::ErrorInformation>,
    /// <p>A timestamp that indicates when the deployment was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the deployment was deployed to the deployment group.</p>
    /// <p>In some cases, the reported value of the start time might be later than the complete time. This is due to differences in the clock settings of backend servers that participate in the deployment process.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the deployment was complete.</p>
    pub complete_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A summary of the deployment status of the instances in the deployment.</p>
    pub deployment_overview: std::option::Option<crate::model::DeploymentOverview>,
    /// <p>A comment about the deployment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The means by which the deployment was created:</p>
    /// <ul>
    /// <li> <p> <code>user</code>: A user created the deployment.</p> </li>
    /// <li> <p> <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.</p> </li>
    /// <li> <p> <code>codeDeployRollback</code>: A rollback process created the deployment.</p> </li>
    /// <li> <p> <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated EC2 instances.</p> </li>
    /// </ul>
    pub creator: std::option::Option<crate::model::DeploymentCreator>,
    /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
    /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
    /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
    /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
    pub ignore_application_stop_failures: bool,
    /// <p>Information about the automatic rollback configuration associated with the deployment.</p>
    pub auto_rollback_configuration: std::option::Option<crate::model::AutoRollbackConfiguration>,
    /// <p>Indicates whether only instances that are not running the latest application revision are to be deployed to.</p>
    pub update_outdated_instances_only: bool,
    /// <p>Information about a deployment rollback.</p>
    pub rollback_info: std::option::Option<crate::model::RollbackInfo>,
    /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub deployment_style: std::option::Option<crate::model::DeploymentStyle>,
    /// <p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>
    pub target_instances: std::option::Option<crate::model::TargetInstances>,
    /// <p>Indicates whether the wait period set for the termination of instances in the original environment has started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the termination wait period starts.</p>
    pub instance_termination_wait_time_started: bool,
    /// <p>Information about blue/green deployment options for this deployment.</p>
    pub blue_green_deployment_configuration:
        std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
    /// <p>Information about the load balancer used in the deployment.</p>
    pub load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
    /// <p>Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.</p>
    pub additional_deployment_status_info: std::option::Option<std::string::String>,
    /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
    /// <ul>
    /// <li> <p> <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
    /// <li> <p> <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
    /// <li> <p> <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
    /// </ul>
    pub file_exists_behavior: std::option::Option<crate::model::FileExistsBehavior>,
    /// <p>Messages that contain information about the status of a deployment.</p>
    pub deployment_status_messages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
    /// <p>The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this deployment.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>Information about deployments related to the specified deployment.</p>
    pub related_deployments: std::option::Option<crate::model::RelatedDeployments>,
}
impl DeploymentInfo {
    /// <p>The application name.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p> The deployment group name. </p>
    pub fn deployment_group_name(&self) -> std::option::Option<&str> {
        self.deployment_group_name.as_deref()
    }
    /// <p> The deployment configuration name. </p>
    pub fn deployment_config_name(&self) -> std::option::Option<&str> {
        self.deployment_config_name.as_deref()
    }
    /// <p> The unique ID of a deployment. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>Information about the application revision that was deployed to the deployment group before the most recent successful deployment.</p>
    pub fn previous_revision(&self) -> std::option::Option<&crate::model::RevisionLocation> {
        self.previous_revision.as_ref()
    }
    /// <p>Information about the location of stored application artifacts and the service from which to retrieve them.</p>
    pub fn revision(&self) -> std::option::Option<&crate::model::RevisionLocation> {
        self.revision.as_ref()
    }
    /// <p>The current state of the deployment as a whole.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.status.as_ref()
    }
    /// <p>Information about any error associated with this deployment.</p>
    pub fn error_information(&self) -> std::option::Option<&crate::model::ErrorInformation> {
        self.error_information.as_ref()
    }
    /// <p>A timestamp that indicates when the deployment was created.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>A timestamp that indicates when the deployment was deployed to the deployment group.</p>
    /// <p>In some cases, the reported value of the start time might be later than the complete time. This is due to differences in the clock settings of backend servers that participate in the deployment process.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>A timestamp that indicates when the deployment was complete.</p>
    pub fn complete_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.complete_time.as_ref()
    }
    /// <p>A summary of the deployment status of the instances in the deployment.</p>
    pub fn deployment_overview(&self) -> std::option::Option<&crate::model::DeploymentOverview> {
        self.deployment_overview.as_ref()
    }
    /// <p>A comment about the deployment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The means by which the deployment was created:</p>
    /// <ul>
    /// <li> <p> <code>user</code>: A user created the deployment.</p> </li>
    /// <li> <p> <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.</p> </li>
    /// <li> <p> <code>codeDeployRollback</code>: A rollback process created the deployment.</p> </li>
    /// <li> <p> <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated EC2 instances.</p> </li>
    /// </ul>
    pub fn creator(&self) -> std::option::Option<&crate::model::DeploymentCreator> {
        self.creator.as_ref()
    }
    /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
    /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
    /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
    /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
    pub fn ignore_application_stop_failures(&self) -> bool {
        self.ignore_application_stop_failures
    }
    /// <p>Information about the automatic rollback configuration associated with the deployment.</p>
    pub fn auto_rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoRollbackConfiguration> {
        self.auto_rollback_configuration.as_ref()
    }
    /// <p>Indicates whether only instances that are not running the latest application revision are to be deployed to.</p>
    pub fn update_outdated_instances_only(&self) -> bool {
        self.update_outdated_instances_only
    }
    /// <p>Information about a deployment rollback.</p>
    pub fn rollback_info(&self) -> std::option::Option<&crate::model::RollbackInfo> {
        self.rollback_info.as_ref()
    }
    /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
    pub fn deployment_style(&self) -> std::option::Option<&crate::model::DeploymentStyle> {
        self.deployment_style.as_ref()
    }
    /// <p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>
    pub fn target_instances(&self) -> std::option::Option<&crate::model::TargetInstances> {
        self.target_instances.as_ref()
    }
    /// <p>Indicates whether the wait period set for the termination of instances in the original environment has started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the termination wait period starts.</p>
    pub fn instance_termination_wait_time_started(&self) -> bool {
        self.instance_termination_wait_time_started
    }
    /// <p>Information about blue/green deployment options for this deployment.</p>
    pub fn blue_green_deployment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::BlueGreenDeploymentConfiguration> {
        self.blue_green_deployment_configuration.as_ref()
    }
    /// <p>Information about the load balancer used in the deployment.</p>
    pub fn load_balancer_info(&self) -> std::option::Option<&crate::model::LoadBalancerInfo> {
        self.load_balancer_info.as_ref()
    }
    /// <p>Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.</p>
    pub fn additional_deployment_status_info(&self) -> std::option::Option<&str> {
        self.additional_deployment_status_info.as_deref()
    }
    /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
    /// <ul>
    /// <li> <p> <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
    /// <li> <p> <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
    /// <li> <p> <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
    /// </ul>
    pub fn file_exists_behavior(&self) -> std::option::Option<&crate::model::FileExistsBehavior> {
        self.file_exists_behavior.as_ref()
    }
    /// <p>Messages that contain information about the status of a deployment.</p>
    pub fn deployment_status_messages(&self) -> std::option::Option<&[std::string::String]> {
        self.deployment_status_messages.as_deref()
    }
    /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    pub fn compute_platform(&self) -> std::option::Option<&crate::model::ComputePlatform> {
        self.compute_platform.as_ref()
    }
    /// <p>The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this deployment.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>Information about deployments related to the specified deployment.</p>
    pub fn related_deployments(&self) -> std::option::Option<&crate::model::RelatedDeployments> {
        self.related_deployments.as_ref()
    }
}
impl std::fmt::Debug for DeploymentInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentInfo");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_group_name", &self.deployment_group_name);
        formatter.field("deployment_config_name", &self.deployment_config_name);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("previous_revision", &self.previous_revision);
        formatter.field("revision", &self.revision);
        formatter.field("status", &self.status);
        formatter.field("error_information", &self.error_information);
        formatter.field("create_time", &self.create_time);
        formatter.field("start_time", &self.start_time);
        formatter.field("complete_time", &self.complete_time);
        formatter.field("deployment_overview", &self.deployment_overview);
        formatter.field("description", &self.description);
        formatter.field("creator", &self.creator);
        formatter.field(
            "ignore_application_stop_failures",
            &self.ignore_application_stop_failures,
        );
        formatter.field(
            "auto_rollback_configuration",
            &self.auto_rollback_configuration,
        );
        formatter.field(
            "update_outdated_instances_only",
            &self.update_outdated_instances_only,
        );
        formatter.field("rollback_info", &self.rollback_info);
        formatter.field("deployment_style", &self.deployment_style);
        formatter.field("target_instances", &self.target_instances);
        formatter.field(
            "instance_termination_wait_time_started",
            &self.instance_termination_wait_time_started,
        );
        formatter.field(
            "blue_green_deployment_configuration",
            &self.blue_green_deployment_configuration,
        );
        formatter.field("load_balancer_info", &self.load_balancer_info);
        formatter.field(
            "additional_deployment_status_info",
            &self.additional_deployment_status_info,
        );
        formatter.field("file_exists_behavior", &self.file_exists_behavior);
        formatter.field(
            "deployment_status_messages",
            &self.deployment_status_messages,
        );
        formatter.field("compute_platform", &self.compute_platform);
        formatter.field("external_id", &self.external_id);
        formatter.field("related_deployments", &self.related_deployments);
        formatter.finish()
    }
}
/// See [`DeploymentInfo`](crate::model::DeploymentInfo)
pub mod deployment_info {
    /// A builder for [`DeploymentInfo`](crate::model::DeploymentInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_group_name: std::option::Option<std::string::String>,
        pub(crate) deployment_config_name: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) previous_revision: std::option::Option<crate::model::RevisionLocation>,
        pub(crate) revision: std::option::Option<crate::model::RevisionLocation>,
        pub(crate) status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) error_information: std::option::Option<crate::model::ErrorInformation>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) complete_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_overview: std::option::Option<crate::model::DeploymentOverview>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creator: std::option::Option<crate::model::DeploymentCreator>,
        pub(crate) ignore_application_stop_failures: std::option::Option<bool>,
        pub(crate) auto_rollback_configuration:
            std::option::Option<crate::model::AutoRollbackConfiguration>,
        pub(crate) update_outdated_instances_only: std::option::Option<bool>,
        pub(crate) rollback_info: std::option::Option<crate::model::RollbackInfo>,
        pub(crate) deployment_style: std::option::Option<crate::model::DeploymentStyle>,
        pub(crate) target_instances: std::option::Option<crate::model::TargetInstances>,
        pub(crate) instance_termination_wait_time_started: std::option::Option<bool>,
        pub(crate) blue_green_deployment_configuration:
            std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        pub(crate) load_balancer_info: std::option::Option<crate::model::LoadBalancerInfo>,
        pub(crate) additional_deployment_status_info: std::option::Option<std::string::String>,
        pub(crate) file_exists_behavior: std::option::Option<crate::model::FileExistsBehavior>,
        pub(crate) deployment_status_messages:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) related_deployments: std::option::Option<crate::model::RelatedDeployments>,
    }
    impl Builder {
        /// <p>The application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p> The deployment group name. </p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_name = Some(input.into());
            self
        }
        /// <p> The deployment group name. </p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_name = input;
            self
        }
        /// <p> The deployment configuration name. </p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_name = Some(input.into());
            self
        }
        /// <p> The deployment configuration name. </p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_name = input;
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>Information about the application revision that was deployed to the deployment group before the most recent successful deployment.</p>
        pub fn previous_revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.previous_revision = Some(input);
            self
        }
        /// <p>Information about the application revision that was deployed to the deployment group before the most recent successful deployment.</p>
        pub fn set_previous_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.previous_revision = input;
            self
        }
        /// <p>Information about the location of stored application artifacts and the service from which to retrieve them.</p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>Information about the location of stored application artifacts and the service from which to retrieve them.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.revision = input;
            self
        }
        /// <p>The current state of the deployment as a whole.</p>
        pub fn status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the deployment as a whole.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about any error associated with this deployment.</p>
        pub fn error_information(mut self, input: crate::model::ErrorInformation) -> Self {
            self.error_information = Some(input);
            self
        }
        /// <p>Information about any error associated with this deployment.</p>
        pub fn set_error_information(
            mut self,
            input: std::option::Option<crate::model::ErrorInformation>,
        ) -> Self {
            self.error_information = input;
            self
        }
        /// <p>A timestamp that indicates when the deployment was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the deployment was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>A timestamp that indicates when the deployment was deployed to the deployment group.</p>
        /// <p>In some cases, the reported value of the start time might be later than the complete time. This is due to differences in the clock settings of backend servers that participate in the deployment process.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the deployment was deployed to the deployment group.</p>
        /// <p>In some cases, the reported value of the start time might be later than the complete time. This is due to differences in the clock settings of backend servers that participate in the deployment process.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>A timestamp that indicates when the deployment was complete.</p>
        pub fn complete_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.complete_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the deployment was complete.</p>
        pub fn set_complete_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.complete_time = input;
            self
        }
        /// <p>A summary of the deployment status of the instances in the deployment.</p>
        pub fn deployment_overview(mut self, input: crate::model::DeploymentOverview) -> Self {
            self.deployment_overview = Some(input);
            self
        }
        /// <p>A summary of the deployment status of the instances in the deployment.</p>
        pub fn set_deployment_overview(
            mut self,
            input: std::option::Option<crate::model::DeploymentOverview>,
        ) -> Self {
            self.deployment_overview = input;
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The means by which the deployment was created:</p>
        /// <ul>
        /// <li> <p> <code>user</code>: A user created the deployment.</p> </li>
        /// <li> <p> <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.</p> </li>
        /// <li> <p> <code>codeDeployRollback</code>: A rollback process created the deployment.</p> </li>
        /// <li> <p> <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated EC2 instances.</p> </li>
        /// </ul>
        pub fn creator(mut self, input: crate::model::DeploymentCreator) -> Self {
            self.creator = Some(input);
            self
        }
        /// <p>The means by which the deployment was created:</p>
        /// <ul>
        /// <li> <p> <code>user</code>: A user created the deployment.</p> </li>
        /// <li> <p> <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.</p> </li>
        /// <li> <p> <code>codeDeployRollback</code>: A rollback process created the deployment.</p> </li>
        /// <li> <p> <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated EC2 instances.</p> </li>
        /// </ul>
        pub fn set_creator(
            mut self,
            input: std::option::Option<crate::model::DeploymentCreator>,
        ) -> Self {
            self.creator = input;
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
        /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn ignore_application_stop_failures(mut self, input: bool) -> Self {
            self.ignore_application_stop_failures = Some(input);
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
        /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn set_ignore_application_stop_failures(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.ignore_application_stop_failures = input;
            self
        }
        /// <p>Information about the automatic rollback configuration associated with the deployment.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.auto_rollback_configuration = Some(input);
            self
        }
        /// <p>Information about the automatic rollback configuration associated with the deployment.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.auto_rollback_configuration = input;
            self
        }
        /// <p>Indicates whether only instances that are not running the latest application revision are to be deployed to.</p>
        pub fn update_outdated_instances_only(mut self, input: bool) -> Self {
            self.update_outdated_instances_only = Some(input);
            self
        }
        /// <p>Indicates whether only instances that are not running the latest application revision are to be deployed to.</p>
        pub fn set_update_outdated_instances_only(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.update_outdated_instances_only = input;
            self
        }
        /// <p>Information about a deployment rollback.</p>
        pub fn rollback_info(mut self, input: crate::model::RollbackInfo) -> Self {
            self.rollback_info = Some(input);
            self
        }
        /// <p>Information about a deployment rollback.</p>
        pub fn set_rollback_info(
            mut self,
            input: std::option::Option<crate::model::RollbackInfo>,
        ) -> Self {
            self.rollback_info = input;
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, input: crate::model::DeploymentStyle) -> Self {
            self.deployment_style = Some(input);
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.deployment_style = input;
            self
        }
        /// <p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>
        pub fn target_instances(mut self, input: crate::model::TargetInstances) -> Self {
            self.target_instances = Some(input);
            self
        }
        /// <p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>
        pub fn set_target_instances(
            mut self,
            input: std::option::Option<crate::model::TargetInstances>,
        ) -> Self {
            self.target_instances = input;
            self
        }
        /// <p>Indicates whether the wait period set for the termination of instances in the original environment has started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the termination wait period starts.</p>
        pub fn instance_termination_wait_time_started(mut self, input: bool) -> Self {
            self.instance_termination_wait_time_started = Some(input);
            self
        }
        /// <p>Indicates whether the wait period set for the termination of instances in the original environment has started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the termination wait period starts.</p>
        pub fn set_instance_termination_wait_time_started(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.instance_termination_wait_time_started = input;
            self
        }
        /// <p>Information about blue/green deployment options for this deployment.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            input: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.blue_green_deployment_configuration = Some(input);
            self
        }
        /// <p>Information about blue/green deployment options for this deployment.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.blue_green_deployment_configuration = input;
            self
        }
        /// <p>Information about the load balancer used in the deployment.</p>
        pub fn load_balancer_info(mut self, input: crate::model::LoadBalancerInfo) -> Self {
            self.load_balancer_info = Some(input);
            self
        }
        /// <p>Information about the load balancer used in the deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.load_balancer_info = input;
            self
        }
        /// <p>Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.</p>
        pub fn additional_deployment_status_info(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.additional_deployment_status_info = Some(input.into());
            self
        }
        /// <p>Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.</p>
        pub fn set_additional_deployment_status_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_deployment_status_info = input;
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
        /// <ul>
        /// <li> <p> <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
        /// <li> <p> <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
        /// <li> <p> <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
        /// </ul>
        pub fn file_exists_behavior(mut self, input: crate::model::FileExistsBehavior) -> Self {
            self.file_exists_behavior = Some(input);
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
        /// <ul>
        /// <li> <p> <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
        /// <li> <p> <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
        /// <li> <p> <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
        /// </ul>
        pub fn set_file_exists_behavior(
            mut self,
            input: std::option::Option<crate::model::FileExistsBehavior>,
        ) -> Self {
            self.file_exists_behavior = input;
            self
        }
        /// Appends an item to `deployment_status_messages`.
        ///
        /// To override the contents of this collection use [`set_deployment_status_messages`](Self::set_deployment_status_messages).
        ///
        /// <p>Messages that contain information about the status of a deployment.</p>
        pub fn deployment_status_messages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployment_status_messages.unwrap_or_default();
            v.push(input.into());
            self.deployment_status_messages = Some(v);
            self
        }
        /// <p>Messages that contain information about the status of a deployment.</p>
        pub fn set_deployment_status_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployment_status_messages = input;
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// <p>The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this deployment.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this deployment.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>Information about deployments related to the specified deployment.</p>
        pub fn related_deployments(mut self, input: crate::model::RelatedDeployments) -> Self {
            self.related_deployments = Some(input);
            self
        }
        /// <p>Information about deployments related to the specified deployment.</p>
        pub fn set_related_deployments(
            mut self,
            input: std::option::Option<crate::model::RelatedDeployments>,
        ) -> Self {
            self.related_deployments = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentInfo`](crate::model::DeploymentInfo)
        pub fn build(self) -> crate::model::DeploymentInfo {
            crate::model::DeploymentInfo {
                application_name: self.application_name,
                deployment_group_name: self.deployment_group_name,
                deployment_config_name: self.deployment_config_name,
                deployment_id: self.deployment_id,
                previous_revision: self.previous_revision,
                revision: self.revision,
                status: self.status,
                error_information: self.error_information,
                create_time: self.create_time,
                start_time: self.start_time,
                complete_time: self.complete_time,
                deployment_overview: self.deployment_overview,
                description: self.description,
                creator: self.creator,
                ignore_application_stop_failures: self
                    .ignore_application_stop_failures
                    .unwrap_or_default(),
                auto_rollback_configuration: self.auto_rollback_configuration,
                update_outdated_instances_only: self
                    .update_outdated_instances_only
                    .unwrap_or_default(),
                rollback_info: self.rollback_info,
                deployment_style: self.deployment_style,
                target_instances: self.target_instances,
                instance_termination_wait_time_started: self
                    .instance_termination_wait_time_started
                    .unwrap_or_default(),
                blue_green_deployment_configuration: self.blue_green_deployment_configuration,
                load_balancer_info: self.load_balancer_info,
                additional_deployment_status_info: self.additional_deployment_status_info,
                file_exists_behavior: self.file_exists_behavior,
                deployment_status_messages: self.deployment_status_messages,
                compute_platform: self.compute_platform,
                external_id: self.external_id,
                related_deployments: self.related_deployments,
            }
        }
    }
}
impl DeploymentInfo {
    /// Creates a new builder-style object to manufacture [`DeploymentInfo`](crate::model::DeploymentInfo)
    pub fn builder() -> crate::model::deployment_info::Builder {
        crate::model::deployment_info::Builder::default()
    }
}

/// <p>Information about deployments related to the specified deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelatedDeployments {
    /// <p>The deployment ID of the root deployment that triggered this deployment.</p>
    pub auto_update_outdated_instances_root_deployment_id: std::option::Option<std::string::String>,
    /// <p>The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.</p>
    pub auto_update_outdated_instances_deployment_ids:
        std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RelatedDeployments {
    /// <p>The deployment ID of the root deployment that triggered this deployment.</p>
    pub fn auto_update_outdated_instances_root_deployment_id(&self) -> std::option::Option<&str> {
        self.auto_update_outdated_instances_root_deployment_id
            .as_deref()
    }
    /// <p>The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.</p>
    pub fn auto_update_outdated_instances_deployment_ids(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.auto_update_outdated_instances_deployment_ids
            .as_deref()
    }
}
impl std::fmt::Debug for RelatedDeployments {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelatedDeployments");
        formatter.field(
            "auto_update_outdated_instances_root_deployment_id",
            &self.auto_update_outdated_instances_root_deployment_id,
        );
        formatter.field(
            "auto_update_outdated_instances_deployment_ids",
            &self.auto_update_outdated_instances_deployment_ids,
        );
        formatter.finish()
    }
}
/// See [`RelatedDeployments`](crate::model::RelatedDeployments)
pub mod related_deployments {
    /// A builder for [`RelatedDeployments`](crate::model::RelatedDeployments)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_update_outdated_instances_root_deployment_id:
            std::option::Option<std::string::String>,
        pub(crate) auto_update_outdated_instances_deployment_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The deployment ID of the root deployment that triggered this deployment.</p>
        pub fn auto_update_outdated_instances_root_deployment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.auto_update_outdated_instances_root_deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment ID of the root deployment that triggered this deployment.</p>
        pub fn set_auto_update_outdated_instances_root_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_update_outdated_instances_root_deployment_id = input;
            self
        }
        /// Appends an item to `auto_update_outdated_instances_deployment_ids`.
        ///
        /// To override the contents of this collection use [`set_auto_update_outdated_instances_deployment_ids`](Self::set_auto_update_outdated_instances_deployment_ids).
        ///
        /// <p>The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.</p>
        pub fn auto_update_outdated_instances_deployment_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .auto_update_outdated_instances_deployment_ids
                .unwrap_or_default();
            v.push(input.into());
            self.auto_update_outdated_instances_deployment_ids = Some(v);
            self
        }
        /// <p>The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.</p>
        pub fn set_auto_update_outdated_instances_deployment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_update_outdated_instances_deployment_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`RelatedDeployments`](crate::model::RelatedDeployments)
        pub fn build(self) -> crate::model::RelatedDeployments {
            crate::model::RelatedDeployments {
                auto_update_outdated_instances_root_deployment_id: self
                    .auto_update_outdated_instances_root_deployment_id,
                auto_update_outdated_instances_deployment_ids: self
                    .auto_update_outdated_instances_deployment_ids,
            }
        }
    }
}
impl RelatedDeployments {
    /// Creates a new builder-style object to manufacture [`RelatedDeployments`](crate::model::RelatedDeployments)
    pub fn builder() -> crate::model::related_deployments::Builder {
        crate::model::related_deployments::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileExistsBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Disallow,
    #[allow(missing_docs)] // documentation missing in model
    Overwrite,
    #[allow(missing_docs)] // documentation missing in model
    Retain,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileExistsBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DISALLOW" => FileExistsBehavior::Disallow,
            "OVERWRITE" => FileExistsBehavior::Overwrite,
            "RETAIN" => FileExistsBehavior::Retain,
            other => FileExistsBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileExistsBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileExistsBehavior::from(s))
    }
}
impl FileExistsBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileExistsBehavior::Disallow => "DISALLOW",
            FileExistsBehavior::Overwrite => "OVERWRITE",
            FileExistsBehavior::Retain => "RETAIN",
            FileExistsBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISALLOW", "OVERWRITE", "RETAIN"]
    }
}
impl AsRef<str> for FileExistsBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the instances to be used in the replacement environment in a blue/green deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetInstances {
    /// <p>The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.</p>
    pub tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
    /// <p>The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.</p>
    pub auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the groups of EC2 instance tags that an instance must be identified by in order for it to be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as <code>tagFilters</code>.</p>
    pub ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
}
impl TargetInstances {
    /// <p>The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.</p>
    pub fn tag_filters(&self) -> std::option::Option<&[crate::model::Ec2TagFilter]> {
        self.tag_filters.as_deref()
    }
    /// <p>The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.</p>
    pub fn auto_scaling_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_scaling_groups.as_deref()
    }
    /// <p>Information about the groups of EC2 instance tags that an instance must be identified by in order for it to be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as <code>tagFilters</code>.</p>
    pub fn ec2_tag_set(&self) -> std::option::Option<&crate::model::Ec2TagSet> {
        self.ec2_tag_set.as_ref()
    }
}
impl std::fmt::Debug for TargetInstances {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetInstances");
        formatter.field("tag_filters", &self.tag_filters);
        formatter.field("auto_scaling_groups", &self.auto_scaling_groups);
        formatter.field("ec2_tag_set", &self.ec2_tag_set);
        formatter.finish()
    }
}
/// See [`TargetInstances`](crate::model::TargetInstances)
pub mod target_instances {
    /// A builder for [`TargetInstances`](crate::model::TargetInstances)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_filters: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        pub(crate) auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ec2_tag_set: std::option::Option<crate::model::Ec2TagSet>,
    }
    impl Builder {
        /// Appends an item to `tag_filters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.</p>
        pub fn tag_filters(mut self, input: crate::model::Ec2TagFilter) -> Self {
            let mut v = self.tag_filters.unwrap_or_default();
            v.push(input);
            self.tag_filters = Some(v);
            self
        }
        /// <p>The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.tag_filters = input;
            self
        }
        /// Appends an item to `auto_scaling_groups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.</p>
        pub fn auto_scaling_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_scaling_groups.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_groups = Some(v);
            self
        }
        /// <p>The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_scaling_groups = input;
            self
        }
        /// <p>Information about the groups of EC2 instance tags that an instance must be identified by in order for it to be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as <code>tagFilters</code>.</p>
        pub fn ec2_tag_set(mut self, input: crate::model::Ec2TagSet) -> Self {
            self.ec2_tag_set = Some(input);
            self
        }
        /// <p>Information about the groups of EC2 instance tags that an instance must be identified by in order for it to be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as <code>tagFilters</code>.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.ec2_tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetInstances`](crate::model::TargetInstances)
        pub fn build(self) -> crate::model::TargetInstances {
            crate::model::TargetInstances {
                tag_filters: self.tag_filters,
                auto_scaling_groups: self.auto_scaling_groups,
                ec2_tag_set: self.ec2_tag_set,
            }
        }
    }
}
impl TargetInstances {
    /// Creates a new builder-style object to manufacture [`TargetInstances`](crate::model::TargetInstances)
    pub fn builder() -> crate::model::target_instances::Builder {
        crate::model::target_instances::Builder::default()
    }
}

/// <p>Information about a deployment rollback.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RollbackInfo {
    /// <p>The ID of the deployment rollback.</p>
    pub rollback_deployment_id: std::option::Option<std::string::String>,
    /// <p>The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or was stopped.</p>
    pub rollback_triggering_deployment_id: std::option::Option<std::string::String>,
    /// <p>Information that describes the status of a deployment rollback (for example, whether the deployment can't be rolled back, is in progress, failed, or succeeded). </p>
    pub rollback_message: std::option::Option<std::string::String>,
}
impl RollbackInfo {
    /// <p>The ID of the deployment rollback.</p>
    pub fn rollback_deployment_id(&self) -> std::option::Option<&str> {
        self.rollback_deployment_id.as_deref()
    }
    /// <p>The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or was stopped.</p>
    pub fn rollback_triggering_deployment_id(&self) -> std::option::Option<&str> {
        self.rollback_triggering_deployment_id.as_deref()
    }
    /// <p>Information that describes the status of a deployment rollback (for example, whether the deployment can't be rolled back, is in progress, failed, or succeeded). </p>
    pub fn rollback_message(&self) -> std::option::Option<&str> {
        self.rollback_message.as_deref()
    }
}
impl std::fmt::Debug for RollbackInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RollbackInfo");
        formatter.field("rollback_deployment_id", &self.rollback_deployment_id);
        formatter.field(
            "rollback_triggering_deployment_id",
            &self.rollback_triggering_deployment_id,
        );
        formatter.field("rollback_message", &self.rollback_message);
        formatter.finish()
    }
}
/// See [`RollbackInfo`](crate::model::RollbackInfo)
pub mod rollback_info {
    /// A builder for [`RollbackInfo`](crate::model::RollbackInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rollback_deployment_id: std::option::Option<std::string::String>,
        pub(crate) rollback_triggering_deployment_id: std::option::Option<std::string::String>,
        pub(crate) rollback_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deployment rollback.</p>
        pub fn rollback_deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rollback_deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment rollback.</p>
        pub fn set_rollback_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rollback_deployment_id = input;
            self
        }
        /// <p>The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or was stopped.</p>
        pub fn rollback_triggering_deployment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.rollback_triggering_deployment_id = Some(input.into());
            self
        }
        /// <p>The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or was stopped.</p>
        pub fn set_rollback_triggering_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rollback_triggering_deployment_id = input;
            self
        }
        /// <p>Information that describes the status of a deployment rollback (for example, whether the deployment can't be rolled back, is in progress, failed, or succeeded). </p>
        pub fn rollback_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.rollback_message = Some(input.into());
            self
        }
        /// <p>Information that describes the status of a deployment rollback (for example, whether the deployment can't be rolled back, is in progress, failed, or succeeded). </p>
        pub fn set_rollback_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rollback_message = input;
            self
        }
        /// Consumes the builder and constructs a [`RollbackInfo`](crate::model::RollbackInfo)
        pub fn build(self) -> crate::model::RollbackInfo {
            crate::model::RollbackInfo {
                rollback_deployment_id: self.rollback_deployment_id,
                rollback_triggering_deployment_id: self.rollback_triggering_deployment_id,
                rollback_message: self.rollback_message,
            }
        }
    }
}
impl RollbackInfo {
    /// Creates a new builder-style object to manufacture [`RollbackInfo`](crate::model::RollbackInfo)
    pub fn builder() -> crate::model::rollback_info::Builder {
        crate::model::rollback_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentCreator {
    #[allow(missing_docs)] // documentation missing in model
    CloudFormation,
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationRollback,
    #[allow(missing_docs)] // documentation missing in model
    CodeDeploy,
    #[allow(missing_docs)] // documentation missing in model
    CodeDeployAutoUpdate,
    #[allow(missing_docs)] // documentation missing in model
    Autoscaling,
    #[allow(missing_docs)] // documentation missing in model
    CodeDeployRollback,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentCreator {
    fn from(s: &str) -> Self {
        match s {
            "CloudFormation" => DeploymentCreator::CloudFormation,
            "CloudFormationRollback" => DeploymentCreator::CloudFormationRollback,
            "CodeDeploy" => DeploymentCreator::CodeDeploy,
            "CodeDeployAutoUpdate" => DeploymentCreator::CodeDeployAutoUpdate,
            "autoscaling" => DeploymentCreator::Autoscaling,
            "codeDeployRollback" => DeploymentCreator::CodeDeployRollback,
            "user" => DeploymentCreator::User,
            other => DeploymentCreator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentCreator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentCreator::from(s))
    }
}
impl DeploymentCreator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentCreator::CloudFormation => "CloudFormation",
            DeploymentCreator::CloudFormationRollback => "CloudFormationRollback",
            DeploymentCreator::CodeDeploy => "CodeDeploy",
            DeploymentCreator::CodeDeployAutoUpdate => "CodeDeployAutoUpdate",
            DeploymentCreator::Autoscaling => "autoscaling",
            DeploymentCreator::CodeDeployRollback => "codeDeployRollback",
            DeploymentCreator::User => "user",
            DeploymentCreator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CloudFormation",
            "CloudFormationRollback",
            "CodeDeploy",
            "CodeDeployAutoUpdate",
            "autoscaling",
            "codeDeployRollback",
            "user",
        ]
    }
}
impl AsRef<str> for DeploymentCreator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the deployment status of the instances in the deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentOverview {
    /// <p>The number of instances in the deployment in a pending state.</p>
    pub pending: i64,
    /// <p>The number of instances in which the deployment is in progress.</p>
    pub in_progress: i64,
    /// <p>The number of instances in the deployment to which revisions have been successfully deployed.</p>
    pub succeeded: i64,
    /// <p>The number of instances in the deployment in a failed state.</p>
    pub failed: i64,
    /// <p>The number of instances in the deployment in a skipped state.</p>
    pub skipped: i64,
    /// <p>The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.</p>
    pub ready: i64,
}
impl DeploymentOverview {
    /// <p>The number of instances in the deployment in a pending state.</p>
    pub fn pending(&self) -> i64 {
        self.pending
    }
    /// <p>The number of instances in which the deployment is in progress.</p>
    pub fn in_progress(&self) -> i64 {
        self.in_progress
    }
    /// <p>The number of instances in the deployment to which revisions have been successfully deployed.</p>
    pub fn succeeded(&self) -> i64 {
        self.succeeded
    }
    /// <p>The number of instances in the deployment in a failed state.</p>
    pub fn failed(&self) -> i64 {
        self.failed
    }
    /// <p>The number of instances in the deployment in a skipped state.</p>
    pub fn skipped(&self) -> i64 {
        self.skipped
    }
    /// <p>The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.</p>
    pub fn ready(&self) -> i64 {
        self.ready
    }
}
impl std::fmt::Debug for DeploymentOverview {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentOverview");
        formatter.field("pending", &self.pending);
        formatter.field("in_progress", &self.in_progress);
        formatter.field("succeeded", &self.succeeded);
        formatter.field("failed", &self.failed);
        formatter.field("skipped", &self.skipped);
        formatter.field("ready", &self.ready);
        formatter.finish()
    }
}
/// See [`DeploymentOverview`](crate::model::DeploymentOverview)
pub mod deployment_overview {
    /// A builder for [`DeploymentOverview`](crate::model::DeploymentOverview)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pending: std::option::Option<i64>,
        pub(crate) in_progress: std::option::Option<i64>,
        pub(crate) succeeded: std::option::Option<i64>,
        pub(crate) failed: std::option::Option<i64>,
        pub(crate) skipped: std::option::Option<i64>,
        pub(crate) ready: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of instances in the deployment in a pending state.</p>
        pub fn pending(mut self, input: i64) -> Self {
            self.pending = Some(input);
            self
        }
        /// <p>The number of instances in the deployment in a pending state.</p>
        pub fn set_pending(mut self, input: std::option::Option<i64>) -> Self {
            self.pending = input;
            self
        }
        /// <p>The number of instances in which the deployment is in progress.</p>
        pub fn in_progress(mut self, input: i64) -> Self {
            self.in_progress = Some(input);
            self
        }
        /// <p>The number of instances in which the deployment is in progress.</p>
        pub fn set_in_progress(mut self, input: std::option::Option<i64>) -> Self {
            self.in_progress = input;
            self
        }
        /// <p>The number of instances in the deployment to which revisions have been successfully deployed.</p>
        pub fn succeeded(mut self, input: i64) -> Self {
            self.succeeded = Some(input);
            self
        }
        /// <p>The number of instances in the deployment to which revisions have been successfully deployed.</p>
        pub fn set_succeeded(mut self, input: std::option::Option<i64>) -> Self {
            self.succeeded = input;
            self
        }
        /// <p>The number of instances in the deployment in a failed state.</p>
        pub fn failed(mut self, input: i64) -> Self {
            self.failed = Some(input);
            self
        }
        /// <p>The number of instances in the deployment in a failed state.</p>
        pub fn set_failed(mut self, input: std::option::Option<i64>) -> Self {
            self.failed = input;
            self
        }
        /// <p>The number of instances in the deployment in a skipped state.</p>
        pub fn skipped(mut self, input: i64) -> Self {
            self.skipped = Some(input);
            self
        }
        /// <p>The number of instances in the deployment in a skipped state.</p>
        pub fn set_skipped(mut self, input: std::option::Option<i64>) -> Self {
            self.skipped = input;
            self
        }
        /// <p>The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.</p>
        pub fn ready(mut self, input: i64) -> Self {
            self.ready = Some(input);
            self
        }
        /// <p>The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.</p>
        pub fn set_ready(mut self, input: std::option::Option<i64>) -> Self {
            self.ready = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentOverview`](crate::model::DeploymentOverview)
        pub fn build(self) -> crate::model::DeploymentOverview {
            crate::model::DeploymentOverview {
                pending: self.pending.unwrap_or_default(),
                in_progress: self.in_progress.unwrap_or_default(),
                succeeded: self.succeeded.unwrap_or_default(),
                failed: self.failed.unwrap_or_default(),
                skipped: self.skipped.unwrap_or_default(),
                ready: self.ready.unwrap_or_default(),
            }
        }
    }
}
impl DeploymentOverview {
    /// Creates a new builder-style object to manufacture [`DeploymentOverview`](crate::model::DeploymentOverview)
    pub fn builder() -> crate::model::deployment_overview::Builder {
        crate::model::deployment_overview::Builder::default()
    }
}

/// <p>Information about a deployment error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorInformation {
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>.</p>
    /// <p>The error code:</p>
    /// <ul>
    /// <li> <p>APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is deleted after the deployment is created, but before it is started.</p> </li>
    /// <li> <p>DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the deployment group is deleted after the deployment is created, but before it is started.</p> </li>
    /// <li> <p>HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.</p> </li>
    /// <li> <p>HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.</p> </li>
    /// <li> <p>IAM_ROLE_MISSING: The service role cannot be accessed.</p> </li>
    /// <li> <p>IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.</p> </li>
    /// <li> <p>INTERNAL_ERROR: There was an internal error.</p> </li>
    /// <li> <p>NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.</p> </li>
    /// <li> <p>NO_INSTANCES: No instances were specified, or no instances can be found.</p> </li>
    /// <li> <p>OVER_MAX_INSTANCES: The maximum number of instances was exceeded.</p> </li>
    /// <li> <p>THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more AWS services.</p> </li>
    /// <li> <p>TIMEOUT: The deployment has timed out.</p> </li>
    /// <li> <p>REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted after the deployment is created, but before it is started.</p> </li>
    /// </ul>
    pub code: std::option::Option<crate::model::ErrorCode>,
    /// <p>An accompanying error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ErrorInformation {
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>.</p>
    /// <p>The error code:</p>
    /// <ul>
    /// <li> <p>APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is deleted after the deployment is created, but before it is started.</p> </li>
    /// <li> <p>DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the deployment group is deleted after the deployment is created, but before it is started.</p> </li>
    /// <li> <p>HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.</p> </li>
    /// <li> <p>HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.</p> </li>
    /// <li> <p>IAM_ROLE_MISSING: The service role cannot be accessed.</p> </li>
    /// <li> <p>IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.</p> </li>
    /// <li> <p>INTERNAL_ERROR: There was an internal error.</p> </li>
    /// <li> <p>NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.</p> </li>
    /// <li> <p>NO_INSTANCES: No instances were specified, or no instances can be found.</p> </li>
    /// <li> <p>OVER_MAX_INSTANCES: The maximum number of instances was exceeded.</p> </li>
    /// <li> <p>THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more AWS services.</p> </li>
    /// <li> <p>TIMEOUT: The deployment has timed out.</p> </li>
    /// <li> <p>REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted after the deployment is created, but before it is started.</p> </li>
    /// </ul>
    pub fn code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.code.as_ref()
    }
    /// <p>An accompanying error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ErrorInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorInformation");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ErrorInformation`](crate::model::ErrorInformation)
pub mod error_information {
    /// A builder for [`ErrorInformation`](crate::model::ErrorInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>.</p>
        /// <p>The error code:</p>
        /// <ul>
        /// <li> <p>APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is deleted after the deployment is created, but before it is started.</p> </li>
        /// <li> <p>DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the deployment group is deleted after the deployment is created, but before it is started.</p> </li>
        /// <li> <p>HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.</p> </li>
        /// <li> <p>HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.</p> </li>
        /// <li> <p>IAM_ROLE_MISSING: The service role cannot be accessed.</p> </li>
        /// <li> <p>IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.</p> </li>
        /// <li> <p>INTERNAL_ERROR: There was an internal error.</p> </li>
        /// <li> <p>NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.</p> </li>
        /// <li> <p>NO_INSTANCES: No instances were specified, or no instances can be found.</p> </li>
        /// <li> <p>OVER_MAX_INSTANCES: The maximum number of instances was exceeded.</p> </li>
        /// <li> <p>THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more AWS services.</p> </li>
        /// <li> <p>TIMEOUT: The deployment has timed out.</p> </li>
        /// <li> <p>REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted after the deployment is created, but before it is started.</p> </li>
        /// </ul>
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>.</p>
        /// <p>The error code:</p>
        /// <ul>
        /// <li> <p>APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is deleted after the deployment is created, but before it is started.</p> </li>
        /// <li> <p>DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the deployment group is deleted after the deployment is created, but before it is started.</p> </li>
        /// <li> <p>HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.</p> </li>
        /// <li> <p>HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.</p> </li>
        /// <li> <p>IAM_ROLE_MISSING: The service role cannot be accessed.</p> </li>
        /// <li> <p>IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.</p> </li>
        /// <li> <p>INTERNAL_ERROR: There was an internal error.</p> </li>
        /// <li> <p>NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.</p> </li>
        /// <li> <p>NO_INSTANCES: No instances were specified, or no instances can be found.</p> </li>
        /// <li> <p>OVER_MAX_INSTANCES: The maximum number of instances was exceeded.</p> </li>
        /// <li> <p>THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more AWS services.</p> </li>
        /// <li> <p>TIMEOUT: The deployment has timed out.</p> </li>
        /// <li> <p>REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted after the deployment is created, but before it is started.</p> </li>
        /// </ul>
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        /// <p>An accompanying error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An accompanying error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorInformation`](crate::model::ErrorInformation)
        pub fn build(self) -> crate::model::ErrorInformation {
            crate::model::ErrorInformation {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ErrorInformation {
    /// Creates a new builder-style object to manufacture [`ErrorInformation`](crate::model::ErrorInformation)
    pub fn builder() -> crate::model::error_information::Builder {
        crate::model::error_information::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AgentIssue,
    #[allow(missing_docs)] // documentation missing in model
    AlarmActive,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationMissing,
    #[allow(missing_docs)] // documentation missing in model
    AutoscalingValidationError,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingIamRolePermissions,
    #[allow(missing_docs)] // documentation missing in model
    CloudformationStackFailure,
    #[allow(missing_docs)] // documentation missing in model
    CodedeployResourceCannotBeFound,
    #[allow(missing_docs)] // documentation missing in model
    CustomerApplicationUnhealthy,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentGroupMissing,
    #[allow(missing_docs)] // documentation missing in model
    EcsUpdateError,
    #[allow(missing_docs)] // documentation missing in model
    ElasticLoadBalancingInvalid,
    #[allow(missing_docs)] // documentation missing in model
    ElbInvalidInstance,
    #[allow(missing_docs)] // documentation missing in model
    HealthConstraints,
    #[allow(missing_docs)] // documentation missing in model
    HealthConstraintsInvalid,
    #[allow(missing_docs)] // documentation missing in model
    HookExecutionFailure,
    #[allow(missing_docs)] // documentation missing in model
    IamRoleMissing,
    #[allow(missing_docs)] // documentation missing in model
    IamRolePermissions,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEcsService,
    #[allow(missing_docs)] // documentation missing in model
    InvalidLambdaConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    InvalidLambdaFunction,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRevision,
    #[allow(missing_docs)] // documentation missing in model
    ManualStop,
    #[allow(missing_docs)] // documentation missing in model
    MissingBlueGreenDeploymentConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    MissingElbInformation,
    #[allow(missing_docs)] // documentation missing in model
    MissingGithubToken,
    #[allow(missing_docs)] // documentation missing in model
    NoEc2Subscription,
    #[allow(missing_docs)] // documentation missing in model
    NoInstances,
    #[allow(missing_docs)] // documentation missing in model
    OverMaxInstances,
    #[allow(missing_docs)] // documentation missing in model
    ResourceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    RevisionMissing,
    #[allow(missing_docs)] // documentation missing in model
    Throttled,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AGENT_ISSUE" => ErrorCode::AgentIssue,
            "ALARM_ACTIVE" => ErrorCode::AlarmActive,
            "APPLICATION_MISSING" => ErrorCode::ApplicationMissing,
            "AUTOSCALING_VALIDATION_ERROR" => ErrorCode::AutoscalingValidationError,
            "AUTO_SCALING_CONFIGURATION" => ErrorCode::AutoScalingConfiguration,
            "AUTO_SCALING_IAM_ROLE_PERMISSIONS" => ErrorCode::AutoScalingIamRolePermissions,
            "CLOUDFORMATION_STACK_FAILURE" => ErrorCode::CloudformationStackFailure,
            "CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND" => ErrorCode::CodedeployResourceCannotBeFound,
            "CUSTOMER_APPLICATION_UNHEALTHY" => ErrorCode::CustomerApplicationUnhealthy,
            "DEPLOYMENT_GROUP_MISSING" => ErrorCode::DeploymentGroupMissing,
            "ECS_UPDATE_ERROR" => ErrorCode::EcsUpdateError,
            "ELASTIC_LOAD_BALANCING_INVALID" => ErrorCode::ElasticLoadBalancingInvalid,
            "ELB_INVALID_INSTANCE" => ErrorCode::ElbInvalidInstance,
            "HEALTH_CONSTRAINTS" => ErrorCode::HealthConstraints,
            "HEALTH_CONSTRAINTS_INVALID" => ErrorCode::HealthConstraintsInvalid,
            "HOOK_EXECUTION_FAILURE" => ErrorCode::HookExecutionFailure,
            "IAM_ROLE_MISSING" => ErrorCode::IamRoleMissing,
            "IAM_ROLE_PERMISSIONS" => ErrorCode::IamRolePermissions,
            "INTERNAL_ERROR" => ErrorCode::InternalError,
            "INVALID_ECS_SERVICE" => ErrorCode::InvalidEcsService,
            "INVALID_LAMBDA_CONFIGURATION" => ErrorCode::InvalidLambdaConfiguration,
            "INVALID_LAMBDA_FUNCTION" => ErrorCode::InvalidLambdaFunction,
            "INVALID_REVISION" => ErrorCode::InvalidRevision,
            "MANUAL_STOP" => ErrorCode::ManualStop,
            "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION" => {
                ErrorCode::MissingBlueGreenDeploymentConfiguration
            }
            "MISSING_ELB_INFORMATION" => ErrorCode::MissingElbInformation,
            "MISSING_GITHUB_TOKEN" => ErrorCode::MissingGithubToken,
            "NO_EC2_SUBSCRIPTION" => ErrorCode::NoEc2Subscription,
            "NO_INSTANCES" => ErrorCode::NoInstances,
            "OVER_MAX_INSTANCES" => ErrorCode::OverMaxInstances,
            "RESOURCE_LIMIT_EXCEEDED" => ErrorCode::ResourceLimitExceeded,
            "REVISION_MISSING" => ErrorCode::RevisionMissing,
            "THROTTLED" => ErrorCode::Throttled,
            "TIMEOUT" => ErrorCode::Timeout,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::AgentIssue => "AGENT_ISSUE",
            ErrorCode::AlarmActive => "ALARM_ACTIVE",
            ErrorCode::ApplicationMissing => "APPLICATION_MISSING",
            ErrorCode::AutoscalingValidationError => "AUTOSCALING_VALIDATION_ERROR",
            ErrorCode::AutoScalingConfiguration => "AUTO_SCALING_CONFIGURATION",
            ErrorCode::AutoScalingIamRolePermissions => "AUTO_SCALING_IAM_ROLE_PERMISSIONS",
            ErrorCode::CloudformationStackFailure => "CLOUDFORMATION_STACK_FAILURE",
            ErrorCode::CodedeployResourceCannotBeFound => "CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND",
            ErrorCode::CustomerApplicationUnhealthy => "CUSTOMER_APPLICATION_UNHEALTHY",
            ErrorCode::DeploymentGroupMissing => "DEPLOYMENT_GROUP_MISSING",
            ErrorCode::EcsUpdateError => "ECS_UPDATE_ERROR",
            ErrorCode::ElasticLoadBalancingInvalid => "ELASTIC_LOAD_BALANCING_INVALID",
            ErrorCode::ElbInvalidInstance => "ELB_INVALID_INSTANCE",
            ErrorCode::HealthConstraints => "HEALTH_CONSTRAINTS",
            ErrorCode::HealthConstraintsInvalid => "HEALTH_CONSTRAINTS_INVALID",
            ErrorCode::HookExecutionFailure => "HOOK_EXECUTION_FAILURE",
            ErrorCode::IamRoleMissing => "IAM_ROLE_MISSING",
            ErrorCode::IamRolePermissions => "IAM_ROLE_PERMISSIONS",
            ErrorCode::InternalError => "INTERNAL_ERROR",
            ErrorCode::InvalidEcsService => "INVALID_ECS_SERVICE",
            ErrorCode::InvalidLambdaConfiguration => "INVALID_LAMBDA_CONFIGURATION",
            ErrorCode::InvalidLambdaFunction => "INVALID_LAMBDA_FUNCTION",
            ErrorCode::InvalidRevision => "INVALID_REVISION",
            ErrorCode::ManualStop => "MANUAL_STOP",
            ErrorCode::MissingBlueGreenDeploymentConfiguration => {
                "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION"
            }
            ErrorCode::MissingElbInformation => "MISSING_ELB_INFORMATION",
            ErrorCode::MissingGithubToken => "MISSING_GITHUB_TOKEN",
            ErrorCode::NoEc2Subscription => "NO_EC2_SUBSCRIPTION",
            ErrorCode::NoInstances => "NO_INSTANCES",
            ErrorCode::OverMaxInstances => "OVER_MAX_INSTANCES",
            ErrorCode::ResourceLimitExceeded => "RESOURCE_LIMIT_EXCEEDED",
            ErrorCode::RevisionMissing => "REVISION_MISSING",
            ErrorCode::Throttled => "THROTTLED",
            ErrorCode::Timeout => "TIMEOUT",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGENT_ISSUE",
            "ALARM_ACTIVE",
            "APPLICATION_MISSING",
            "AUTOSCALING_VALIDATION_ERROR",
            "AUTO_SCALING_CONFIGURATION",
            "AUTO_SCALING_IAM_ROLE_PERMISSIONS",
            "CLOUDFORMATION_STACK_FAILURE",
            "CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND",
            "CUSTOMER_APPLICATION_UNHEALTHY",
            "DEPLOYMENT_GROUP_MISSING",
            "ECS_UPDATE_ERROR",
            "ELASTIC_LOAD_BALANCING_INVALID",
            "ELB_INVALID_INSTANCE",
            "HEALTH_CONSTRAINTS",
            "HEALTH_CONSTRAINTS_INVALID",
            "HOOK_EXECUTION_FAILURE",
            "IAM_ROLE_MISSING",
            "IAM_ROLE_PERMISSIONS",
            "INTERNAL_ERROR",
            "INVALID_ECS_SERVICE",
            "INVALID_LAMBDA_CONFIGURATION",
            "INVALID_LAMBDA_FUNCTION",
            "INVALID_REVISION",
            "MANUAL_STOP",
            "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION",
            "MISSING_ELB_INFORMATION",
            "MISSING_GITHUB_TOKEN",
            "NO_EC2_SUBSCRIPTION",
            "NO_INSTANCES",
            "OVER_MAX_INSTANCES",
            "RESOURCE_LIMIT_EXCEEDED",
            "REVISION_MISSING",
            "THROTTLED",
            "TIMEOUT",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an application revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenericRevisionInfo {
    /// <p>A comment about the revision.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The deployment groups for which this is the current target revision.</p>
    pub deployment_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When the revision was first used by AWS CodeDeploy.</p>
    pub first_used_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the revision was last used by AWS CodeDeploy.</p>
    pub last_used_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the revision was registered with AWS CodeDeploy.</p>
    pub register_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GenericRevisionInfo {
    /// <p>A comment about the revision.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The deployment groups for which this is the current target revision.</p>
    pub fn deployment_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.deployment_groups.as_deref()
    }
    /// <p>When the revision was first used by AWS CodeDeploy.</p>
    pub fn first_used_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.first_used_time.as_ref()
    }
    /// <p>When the revision was last used by AWS CodeDeploy.</p>
    pub fn last_used_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_used_time.as_ref()
    }
    /// <p>When the revision was registered with AWS CodeDeploy.</p>
    pub fn register_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.register_time.as_ref()
    }
}
impl std::fmt::Debug for GenericRevisionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenericRevisionInfo");
        formatter.field("description", &self.description);
        formatter.field("deployment_groups", &self.deployment_groups);
        formatter.field("first_used_time", &self.first_used_time);
        formatter.field("last_used_time", &self.last_used_time);
        formatter.field("register_time", &self.register_time);
        formatter.finish()
    }
}
/// See [`GenericRevisionInfo`](crate::model::GenericRevisionInfo)
pub mod generic_revision_info {
    /// A builder for [`GenericRevisionInfo`](crate::model::GenericRevisionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) deployment_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) first_used_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_used_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) register_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A comment about the revision.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A comment about the revision.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `deployment_groups`.
        ///
        /// To override the contents of this collection use [`set_deployment_groups`](Self::set_deployment_groups).
        ///
        /// <p>The deployment groups for which this is the current target revision.</p>
        pub fn deployment_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployment_groups.unwrap_or_default();
            v.push(input.into());
            self.deployment_groups = Some(v);
            self
        }
        /// <p>The deployment groups for which this is the current target revision.</p>
        pub fn set_deployment_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployment_groups = input;
            self
        }
        /// <p>When the revision was first used by AWS CodeDeploy.</p>
        pub fn first_used_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.first_used_time = Some(input);
            self
        }
        /// <p>When the revision was first used by AWS CodeDeploy.</p>
        pub fn set_first_used_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.first_used_time = input;
            self
        }
        /// <p>When the revision was last used by AWS CodeDeploy.</p>
        pub fn last_used_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_used_time = Some(input);
            self
        }
        /// <p>When the revision was last used by AWS CodeDeploy.</p>
        pub fn set_last_used_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_used_time = input;
            self
        }
        /// <p>When the revision was registered with AWS CodeDeploy.</p>
        pub fn register_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.register_time = Some(input);
            self
        }
        /// <p>When the revision was registered with AWS CodeDeploy.</p>
        pub fn set_register_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.register_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GenericRevisionInfo`](crate::model::GenericRevisionInfo)
        pub fn build(self) -> crate::model::GenericRevisionInfo {
            crate::model::GenericRevisionInfo {
                description: self.description,
                deployment_groups: self.deployment_groups,
                first_used_time: self.first_used_time,
                last_used_time: self.last_used_time,
                register_time: self.register_time,
            }
        }
    }
}
impl GenericRevisionInfo {
    /// Creates a new builder-style object to manufacture [`GenericRevisionInfo`](crate::model::GenericRevisionInfo)
    pub fn builder() -> crate::model::generic_revision_info::Builder {
        crate::model::generic_revision_info::Builder::default()
    }
}

/// <p>Information about an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationInfo {
    /// <p>The application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The time at which the application was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>True if the user has authenticated with GitHub for the specified application. Otherwise, false.</p>
    pub linked_to_git_hub: bool,
    /// <p>The name for a connection to a GitHub account.</p>
    pub git_hub_account_name: std::option::Option<std::string::String>,
    /// <p>The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).</p>
    pub compute_platform: std::option::Option<crate::model::ComputePlatform>,
}
impl ApplicationInfo {
    /// <p>The application ID.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The application name.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The time at which the application was created.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>True if the user has authenticated with GitHub for the specified application. Otherwise, false.</p>
    pub fn linked_to_git_hub(&self) -> bool {
        self.linked_to_git_hub
    }
    /// <p>The name for a connection to a GitHub account.</p>
    pub fn git_hub_account_name(&self) -> std::option::Option<&str> {
        self.git_hub_account_name.as_deref()
    }
    /// <p>The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).</p>
    pub fn compute_platform(&self) -> std::option::Option<&crate::model::ComputePlatform> {
        self.compute_platform.as_ref()
    }
}
impl std::fmt::Debug for ApplicationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationInfo");
        formatter.field("application_id", &self.application_id);
        formatter.field("application_name", &self.application_name);
        formatter.field("create_time", &self.create_time);
        formatter.field("linked_to_git_hub", &self.linked_to_git_hub);
        formatter.field("git_hub_account_name", &self.git_hub_account_name);
        formatter.field("compute_platform", &self.compute_platform);
        formatter.finish()
    }
}
/// See [`ApplicationInfo`](crate::model::ApplicationInfo)
pub mod application_info {
    /// A builder for [`ApplicationInfo`](crate::model::ApplicationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) linked_to_git_hub: std::option::Option<bool>,
        pub(crate) git_hub_account_name: std::option::Option<std::string::String>,
        pub(crate) compute_platform: std::option::Option<crate::model::ComputePlatform>,
    }
    impl Builder {
        /// <p>The application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The time at which the application was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time at which the application was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>True if the user has authenticated with GitHub for the specified application. Otherwise, false.</p>
        pub fn linked_to_git_hub(mut self, input: bool) -> Self {
            self.linked_to_git_hub = Some(input);
            self
        }
        /// <p>True if the user has authenticated with GitHub for the specified application. Otherwise, false.</p>
        pub fn set_linked_to_git_hub(mut self, input: std::option::Option<bool>) -> Self {
            self.linked_to_git_hub = input;
            self
        }
        /// <p>The name for a connection to a GitHub account.</p>
        pub fn git_hub_account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.git_hub_account_name = Some(input.into());
            self
        }
        /// <p>The name for a connection to a GitHub account.</p>
        pub fn set_git_hub_account_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.git_hub_account_name = input;
            self
        }
        /// <p>The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.compute_platform = Some(input);
            self
        }
        /// <p>The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.compute_platform = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationInfo`](crate::model::ApplicationInfo)
        pub fn build(self) -> crate::model::ApplicationInfo {
            crate::model::ApplicationInfo {
                application_id: self.application_id,
                application_name: self.application_name,
                create_time: self.create_time,
                linked_to_git_hub: self.linked_to_git_hub.unwrap_or_default(),
                git_hub_account_name: self.git_hub_account_name,
                compute_platform: self.compute_platform,
            }
        }
    }
}
impl ApplicationInfo {
    /// Creates a new builder-style object to manufacture [`ApplicationInfo`](crate::model::ApplicationInfo)
    pub fn builder() -> crate::model::application_info::Builder {
        crate::model::application_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentWaitType {
    #[allow(missing_docs)] // documentation missing in model
    ReadyWait,
    #[allow(missing_docs)] // documentation missing in model
    TerminationWait,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentWaitType {
    fn from(s: &str) -> Self {
        match s {
            "READY_WAIT" => DeploymentWaitType::ReadyWait,
            "TERMINATION_WAIT" => DeploymentWaitType::TerminationWait,
            other => DeploymentWaitType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentWaitType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentWaitType::from(s))
    }
}
impl DeploymentWaitType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentWaitType::ReadyWait => "READY_WAIT",
            DeploymentWaitType::TerminationWait => "TERMINATION_WAIT",
            DeploymentWaitType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["READY_WAIT", "TERMINATION_WAIT"]
    }
}
impl AsRef<str> for DeploymentWaitType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an application revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevisionInfo {
    /// <p>Information about the location and type of an application revision.</p>
    pub revision_location: std::option::Option<crate::model::RevisionLocation>,
    /// <p>Information about an application revision, including usage details and associated deployment groups.</p>
    pub generic_revision_info: std::option::Option<crate::model::GenericRevisionInfo>,
}
impl RevisionInfo {
    /// <p>Information about the location and type of an application revision.</p>
    pub fn revision_location(&self) -> std::option::Option<&crate::model::RevisionLocation> {
        self.revision_location.as_ref()
    }
    /// <p>Information about an application revision, including usage details and associated deployment groups.</p>
    pub fn generic_revision_info(&self) -> std::option::Option<&crate::model::GenericRevisionInfo> {
        self.generic_revision_info.as_ref()
    }
}
impl std::fmt::Debug for RevisionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevisionInfo");
        formatter.field("revision_location", &self.revision_location);
        formatter.field("generic_revision_info", &self.generic_revision_info);
        formatter.finish()
    }
}
/// See [`RevisionInfo`](crate::model::RevisionInfo)
pub mod revision_info {
    /// A builder for [`RevisionInfo`](crate::model::RevisionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_location: std::option::Option<crate::model::RevisionLocation>,
        pub(crate) generic_revision_info: std::option::Option<crate::model::GenericRevisionInfo>,
    }
    impl Builder {
        /// <p>Information about the location and type of an application revision.</p>
        pub fn revision_location(mut self, input: crate::model::RevisionLocation) -> Self {
            self.revision_location = Some(input);
            self
        }
        /// <p>Information about the location and type of an application revision.</p>
        pub fn set_revision_location(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.revision_location = input;
            self
        }
        /// <p>Information about an application revision, including usage details and associated deployment groups.</p>
        pub fn generic_revision_info(mut self, input: crate::model::GenericRevisionInfo) -> Self {
            self.generic_revision_info = Some(input);
            self
        }
        /// <p>Information about an application revision, including usage details and associated deployment groups.</p>
        pub fn set_generic_revision_info(
            mut self,
            input: std::option::Option<crate::model::GenericRevisionInfo>,
        ) -> Self {
            self.generic_revision_info = input;
            self
        }
        /// Consumes the builder and constructs a [`RevisionInfo`](crate::model::RevisionInfo)
        pub fn build(self) -> crate::model::RevisionInfo {
            crate::model::RevisionInfo {
                revision_location: self.revision_location,
                generic_revision_info: self.generic_revision_info,
            }
        }
    }
}
impl RevisionInfo {
    /// Creates a new builder-style object to manufacture [`RevisionInfo`](crate::model::RevisionInfo)
    pub fn builder() -> crate::model::revision_info::Builder {
        crate::model::revision_info::Builder::default()
    }
}
