// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS CodeDeploy
///
/// Client for invoking operations on AWS CodeDeploy. Each operation on AWS CodeDeploy is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codedeploy::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codedeploy::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codedeploy::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddTagsToOnPremisesInstances` operation.
    ///
    /// See [`AddTagsToOnPremisesInstances`](crate::client::fluent_builders::AddTagsToOnPremisesInstances) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_on_premises_instances(
        &self,
    ) -> fluent_builders::AddTagsToOnPremisesInstances<C, M, R> {
        fluent_builders::AddTagsToOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetApplicationRevisions` operation.
    ///
    /// See [`BatchGetApplicationRevisions`](crate::client::fluent_builders::BatchGetApplicationRevisions) for more information about the
    /// operation and its arguments.
    pub fn batch_get_application_revisions(
        &self,
    ) -> fluent_builders::BatchGetApplicationRevisions<C, M, R> {
        fluent_builders::BatchGetApplicationRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetApplications` operation.
    ///
    /// See [`BatchGetApplications`](crate::client::fluent_builders::BatchGetApplications) for more information about the
    /// operation and its arguments.
    pub fn batch_get_applications(&self) -> fluent_builders::BatchGetApplications<C, M, R> {
        fluent_builders::BatchGetApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetDeploymentGroups` operation.
    ///
    /// See [`BatchGetDeploymentGroups`](crate::client::fluent_builders::BatchGetDeploymentGroups) for more information about the
    /// operation and its arguments.
    pub fn batch_get_deployment_groups(
        &self,
    ) -> fluent_builders::BatchGetDeploymentGroups<C, M, R> {
        fluent_builders::BatchGetDeploymentGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetDeploymentInstances` operation.
    ///
    /// See [`BatchGetDeploymentInstances`](crate::client::fluent_builders::BatchGetDeploymentInstances) for more information about the
    /// operation and its arguments.
    pub fn batch_get_deployment_instances(
        &self,
    ) -> fluent_builders::BatchGetDeploymentInstances<C, M, R> {
        fluent_builders::BatchGetDeploymentInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetDeployments` operation.
    ///
    /// See [`BatchGetDeployments`](crate::client::fluent_builders::BatchGetDeployments) for more information about the
    /// operation and its arguments.
    pub fn batch_get_deployments(&self) -> fluent_builders::BatchGetDeployments<C, M, R> {
        fluent_builders::BatchGetDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetDeploymentTargets` operation.
    ///
    /// See [`BatchGetDeploymentTargets`](crate::client::fluent_builders::BatchGetDeploymentTargets) for more information about the
    /// operation and its arguments.
    pub fn batch_get_deployment_targets(
        &self,
    ) -> fluent_builders::BatchGetDeploymentTargets<C, M, R> {
        fluent_builders::BatchGetDeploymentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetOnPremisesInstances` operation.
    ///
    /// See [`BatchGetOnPremisesInstances`](crate::client::fluent_builders::BatchGetOnPremisesInstances) for more information about the
    /// operation and its arguments.
    pub fn batch_get_on_premises_instances(
        &self,
    ) -> fluent_builders::BatchGetOnPremisesInstances<C, M, R> {
        fluent_builders::BatchGetOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ContinueDeployment` operation.
    ///
    /// See [`ContinueDeployment`](crate::client::fluent_builders::ContinueDeployment) for more information about the
    /// operation and its arguments.
    pub fn continue_deployment(&self) -> fluent_builders::ContinueDeployment<C, M, R> {
        fluent_builders::ContinueDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApplication` operation.
    ///
    /// See [`CreateApplication`](crate::client::fluent_builders::CreateApplication) for more information about the
    /// operation and its arguments.
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeployment` operation.
    ///
    /// See [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) for more information about the
    /// operation and its arguments.
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment<C, M, R> {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeploymentConfig` operation.
    ///
    /// See [`CreateDeploymentConfig`](crate::client::fluent_builders::CreateDeploymentConfig) for more information about the
    /// operation and its arguments.
    pub fn create_deployment_config(&self) -> fluent_builders::CreateDeploymentConfig<C, M, R> {
        fluent_builders::CreateDeploymentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeploymentGroup` operation.
    ///
    /// See [`CreateDeploymentGroup`](crate::client::fluent_builders::CreateDeploymentGroup) for more information about the
    /// operation and its arguments.
    pub fn create_deployment_group(&self) -> fluent_builders::CreateDeploymentGroup<C, M, R> {
        fluent_builders::CreateDeploymentGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApplication` operation.
    ///
    /// See [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) for more information about the
    /// operation and its arguments.
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeploymentConfig` operation.
    ///
    /// See [`DeleteDeploymentConfig`](crate::client::fluent_builders::DeleteDeploymentConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_deployment_config(&self) -> fluent_builders::DeleteDeploymentConfig<C, M, R> {
        fluent_builders::DeleteDeploymentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeploymentGroup` operation.
    ///
    /// See [`DeleteDeploymentGroup`](crate::client::fluent_builders::DeleteDeploymentGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_deployment_group(&self) -> fluent_builders::DeleteDeploymentGroup<C, M, R> {
        fluent_builders::DeleteDeploymentGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGitHubAccountToken` operation.
    ///
    /// See [`DeleteGitHubAccountToken`](crate::client::fluent_builders::DeleteGitHubAccountToken) for more information about the
    /// operation and its arguments.
    pub fn delete_git_hub_account_token(
        &self,
    ) -> fluent_builders::DeleteGitHubAccountToken<C, M, R> {
        fluent_builders::DeleteGitHubAccountToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcesByExternalId` operation.
    ///
    /// See [`DeleteResourcesByExternalId`](crate::client::fluent_builders::DeleteResourcesByExternalId) for more information about the
    /// operation and its arguments.
    pub fn delete_resources_by_external_id(
        &self,
    ) -> fluent_builders::DeleteResourcesByExternalId<C, M, R> {
        fluent_builders::DeleteResourcesByExternalId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterOnPremisesInstance` operation.
    ///
    /// See [`DeregisterOnPremisesInstance`](crate::client::fluent_builders::DeregisterOnPremisesInstance) for more information about the
    /// operation and its arguments.
    pub fn deregister_on_premises_instance(
        &self,
    ) -> fluent_builders::DeregisterOnPremisesInstance<C, M, R> {
        fluent_builders::DeregisterOnPremisesInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApplication` operation.
    ///
    /// See [`GetApplication`](crate::client::fluent_builders::GetApplication) for more information about the
    /// operation and its arguments.
    pub fn get_application(&self) -> fluent_builders::GetApplication<C, M, R> {
        fluent_builders::GetApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApplicationRevision` operation.
    ///
    /// See [`GetApplicationRevision`](crate::client::fluent_builders::GetApplicationRevision) for more information about the
    /// operation and its arguments.
    pub fn get_application_revision(&self) -> fluent_builders::GetApplicationRevision<C, M, R> {
        fluent_builders::GetApplicationRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeployment` operation.
    ///
    /// See [`GetDeployment`](crate::client::fluent_builders::GetDeployment) for more information about the
    /// operation and its arguments.
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment<C, M, R> {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeploymentConfig` operation.
    ///
    /// See [`GetDeploymentConfig`](crate::client::fluent_builders::GetDeploymentConfig) for more information about the
    /// operation and its arguments.
    pub fn get_deployment_config(&self) -> fluent_builders::GetDeploymentConfig<C, M, R> {
        fluent_builders::GetDeploymentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeploymentGroup` operation.
    ///
    /// See [`GetDeploymentGroup`](crate::client::fluent_builders::GetDeploymentGroup) for more information about the
    /// operation and its arguments.
    pub fn get_deployment_group(&self) -> fluent_builders::GetDeploymentGroup<C, M, R> {
        fluent_builders::GetDeploymentGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeploymentInstance` operation.
    ///
    /// See [`GetDeploymentInstance`](crate::client::fluent_builders::GetDeploymentInstance) for more information about the
    /// operation and its arguments.
    pub fn get_deployment_instance(&self) -> fluent_builders::GetDeploymentInstance<C, M, R> {
        fluent_builders::GetDeploymentInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeploymentTarget` operation.
    ///
    /// See [`GetDeploymentTarget`](crate::client::fluent_builders::GetDeploymentTarget) for more information about the
    /// operation and its arguments.
    pub fn get_deployment_target(&self) -> fluent_builders::GetDeploymentTarget<C, M, R> {
        fluent_builders::GetDeploymentTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOnPremisesInstance` operation.
    ///
    /// See [`GetOnPremisesInstance`](crate::client::fluent_builders::GetOnPremisesInstance) for more information about the
    /// operation and its arguments.
    pub fn get_on_premises_instance(&self) -> fluent_builders::GetOnPremisesInstance<C, M, R> {
        fluent_builders::GetOnPremisesInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationRevisions` operation.
    ///
    /// See [`ListApplicationRevisions`](crate::client::fluent_builders::ListApplicationRevisions) for more information about the
    /// operation and its arguments.
    pub fn list_application_revisions(&self) -> fluent_builders::ListApplicationRevisions<C, M, R> {
        fluent_builders::ListApplicationRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplications` operation.
    ///
    /// See [`ListApplications`](crate::client::fluent_builders::ListApplications) for more information about the
    /// operation and its arguments.
    pub fn list_applications(&self) -> fluent_builders::ListApplications<C, M, R> {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeploymentConfigs` operation.
    ///
    /// See [`ListDeploymentConfigs`](crate::client::fluent_builders::ListDeploymentConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_deployment_configs(&self) -> fluent_builders::ListDeploymentConfigs<C, M, R> {
        fluent_builders::ListDeploymentConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeploymentGroups` operation.
    ///
    /// See [`ListDeploymentGroups`](crate::client::fluent_builders::ListDeploymentGroups) for more information about the
    /// operation and its arguments.
    pub fn list_deployment_groups(&self) -> fluent_builders::ListDeploymentGroups<C, M, R> {
        fluent_builders::ListDeploymentGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeploymentInstances` operation.
    ///
    /// See [`ListDeploymentInstances`](crate::client::fluent_builders::ListDeploymentInstances) for more information about the
    /// operation and its arguments.
    pub fn list_deployment_instances(&self) -> fluent_builders::ListDeploymentInstances<C, M, R> {
        fluent_builders::ListDeploymentInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeployments` operation.
    ///
    /// See [`ListDeployments`](crate::client::fluent_builders::ListDeployments) for more information about the
    /// operation and its arguments.
    pub fn list_deployments(&self) -> fluent_builders::ListDeployments<C, M, R> {
        fluent_builders::ListDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeploymentTargets` operation.
    ///
    /// See [`ListDeploymentTargets`](crate::client::fluent_builders::ListDeploymentTargets) for more information about the
    /// operation and its arguments.
    pub fn list_deployment_targets(&self) -> fluent_builders::ListDeploymentTargets<C, M, R> {
        fluent_builders::ListDeploymentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGitHubAccountTokenNames` operation.
    ///
    /// See [`ListGitHubAccountTokenNames`](crate::client::fluent_builders::ListGitHubAccountTokenNames) for more information about the
    /// operation and its arguments.
    pub fn list_git_hub_account_token_names(
        &self,
    ) -> fluent_builders::ListGitHubAccountTokenNames<C, M, R> {
        fluent_builders::ListGitHubAccountTokenNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOnPremisesInstances` operation.
    ///
    /// See [`ListOnPremisesInstances`](crate::client::fluent_builders::ListOnPremisesInstances) for more information about the
    /// operation and its arguments.
    pub fn list_on_premises_instances(&self) -> fluent_builders::ListOnPremisesInstances<C, M, R> {
        fluent_builders::ListOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLifecycleEventHookExecutionStatus` operation.
    ///
    /// See [`PutLifecycleEventHookExecutionStatus`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus) for more information about the
    /// operation and its arguments.
    pub fn put_lifecycle_event_hook_execution_status(
        &self,
    ) -> fluent_builders::PutLifecycleEventHookExecutionStatus<C, M, R> {
        fluent_builders::PutLifecycleEventHookExecutionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterApplicationRevision` operation.
    ///
    /// See [`RegisterApplicationRevision`](crate::client::fluent_builders::RegisterApplicationRevision) for more information about the
    /// operation and its arguments.
    pub fn register_application_revision(
        &self,
    ) -> fluent_builders::RegisterApplicationRevision<C, M, R> {
        fluent_builders::RegisterApplicationRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterOnPremisesInstance` operation.
    ///
    /// See [`RegisterOnPremisesInstance`](crate::client::fluent_builders::RegisterOnPremisesInstance) for more information about the
    /// operation and its arguments.
    pub fn register_on_premises_instance(
        &self,
    ) -> fluent_builders::RegisterOnPremisesInstance<C, M, R> {
        fluent_builders::RegisterOnPremisesInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromOnPremisesInstances` operation.
    ///
    /// See [`RemoveTagsFromOnPremisesInstances`](crate::client::fluent_builders::RemoveTagsFromOnPremisesInstances) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_on_premises_instances(
        &self,
    ) -> fluent_builders::RemoveTagsFromOnPremisesInstances<C, M, R> {
        fluent_builders::RemoveTagsFromOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SkipWaitTimeForInstanceTermination` operation.
    ///
    /// See [`SkipWaitTimeForInstanceTermination`](crate::client::fluent_builders::SkipWaitTimeForInstanceTermination) for more information about the
    /// operation and its arguments.
    pub fn skip_wait_time_for_instance_termination(
        &self,
    ) -> fluent_builders::SkipWaitTimeForInstanceTermination<C, M, R> {
        fluent_builders::SkipWaitTimeForInstanceTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDeployment` operation.
    ///
    /// See [`StopDeployment`](crate::client::fluent_builders::StopDeployment) for more information about the
    /// operation and its arguments.
    pub fn stop_deployment(&self) -> fluent_builders::StopDeployment<C, M, R> {
        fluent_builders::StopDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplication` operation.
    ///
    /// See [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) for more information about the
    /// operation and its arguments.
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeploymentGroup` operation.
    ///
    /// See [`UpdateDeploymentGroup`](crate::client::fluent_builders::UpdateDeploymentGroup) for more information about the
    /// operation and its arguments.
    pub fn update_deployment_group(&self) -> fluent_builders::UpdateDeploymentGroup<C, M, R> {
        fluent_builders::UpdateDeploymentGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToOnPremisesInstances`.
    ///
    /// <p>Adds tags to on-premises instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToOnPremisesInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_on_premises_instances_input::Builder,
    }
    impl<C, M, R> AddTagsToOnPremisesInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToOnPremisesInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToOnPremisesInstancesInputOperationOutputAlias,
                crate::output::AddTagsToOnPremisesInstancesOutput,
                crate::error::AddTagsToOnPremisesInstancesError,
                crate::input::AddTagsToOnPremisesInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs to add to the on-premises instances.</p>
        /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only
        /// tags are not allowed.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs to add to the on-premises instances.</p>
        /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only
        /// tags are not allowed.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances to which to add tags.</p>
        pub fn instance_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(inp);
            self
        }
        /// <p>The names of the on-premises instances to which to add tags.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetApplicationRevisions`.
    ///
    /// <p>Gets information about one or more application revisions. The maximum number of
    /// application revisions that can be returned is 25.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetApplicationRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_application_revisions_input::Builder,
    }
    impl<C, M, R> BatchGetApplicationRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetApplicationRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetApplicationRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetApplicationRevisionsInputOperationOutputAlias,
                crate::output::BatchGetApplicationRevisionsOutput,
                crate::error::BatchGetApplicationRevisionsError,
                crate::input::BatchGetApplicationRevisionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application about which to get revision
        /// information.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application about which to get revision
        /// information.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// Appends an item to `revisions`.
        ///
        /// To override the contents of this collection use [`set_revisions`](Self::set_revisions).
        ///
        /// <p>An array of <code>RevisionLocation</code> objects that specify information to get
        /// about the application revisions, including type and location. The maximum number of
        /// <code>RevisionLocation</code> objects you can specify is 25.</p>
        pub fn revisions(mut self, inp: impl Into<crate::model::RevisionLocation>) -> Self {
            self.inner = self.inner.revisions(inp);
            self
        }
        /// <p>An array of <code>RevisionLocation</code> objects that specify information to get
        /// about the application revisions, including type and location. The maximum number of
        /// <code>RevisionLocation</code> objects you can specify is 25.</p>
        pub fn set_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
        ) -> Self {
            self.inner = self.inner.set_revisions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetApplications`.
    ///
    /// <p>Gets information about one or more applications. The maximum number of applications
    /// that can be returned is 100.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_applications_input::Builder,
    }
    impl<C, M, R> BatchGetApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetApplicationsInputOperationOutputAlias,
                crate::output::BatchGetApplicationsOutput,
                crate::error::BatchGetApplicationsError,
                crate::input::BatchGetApplicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `applicationNames`.
        ///
        /// To override the contents of this collection use [`set_application_names`](Self::set_application_names).
        ///
        /// <p>A list of application names separated by spaces. The maximum number of application
        /// names you can specify is 100.</p>
        pub fn application_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_names(inp);
            self
        }
        /// <p>A list of application names separated by spaces. The maximum number of application
        /// names you can specify is 100.</p>
        pub fn set_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_application_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeploymentGroups`.
    ///
    /// <p>Gets information about one or more deployment groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetDeploymentGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_deployment_groups_input::Builder,
    }
    impl<C, M, R> BatchGetDeploymentGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetDeploymentGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetDeploymentGroupsInputOperationOutputAlias,
                crate::output::BatchGetDeploymentGroupsOutput,
                crate::error::BatchGetDeploymentGroupsError,
                crate::input::BatchGetDeploymentGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or
        /// AWS account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or
        /// AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// Appends an item to `deploymentGroupNames`.
        ///
        /// To override the contents of this collection use [`set_deployment_group_names`](Self::set_deployment_group_names).
        ///
        /// <p>The names of the deployment groups.</p>
        pub fn deployment_group_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_names(inp);
            self
        }
        /// <p>The names of the deployment groups.</p>
        pub fn set_deployment_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeploymentInstances`.
    ///
    /// <note>
    /// <p> This method works, but is deprecated. Use <code>BatchGetDeploymentTargets</code>
    /// instead. </p>
    /// </note>
    /// <p> Returns an array of one or more instances associated with a deployment. This method
    /// works with EC2/On-premises and AWS Lambda compute platforms. The newer
    /// <code>BatchGetDeploymentTargets</code> works with all compute platforms. The maximum
    /// number of instances that can be returned is 25.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetDeploymentInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_deployment_instances_input::Builder,
    }
    impl<C, M, R> BatchGetDeploymentInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetDeploymentInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetDeploymentInstancesInputOperationOutputAlias,
                crate::output::BatchGetDeploymentInstancesOutput,
                crate::error::BatchGetDeploymentInstancesError,
                crate::input::BatchGetDeploymentInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `instanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs
        /// you can specify is 25.</p>
        pub fn instance_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(inp);
            self
        }
        /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs
        /// you can specify is 25.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeployments`.
    ///
    /// <p>Gets information about one or more deployments. The maximum number of deployments that
    /// can be returned is 25.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_deployments_input::Builder,
    }
    impl<C, M, R> BatchGetDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetDeploymentsInputOperationOutputAlias,
                crate::output::BatchGetDeploymentsOutput,
                crate::error::BatchGetDeploymentsError,
                crate::input::BatchGetDeploymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `deploymentIds`.
        ///
        /// To override the contents of this collection use [`set_deployment_ids`](Self::set_deployment_ids).
        ///
        /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs
        /// you can specify is 25.</p>
        pub fn deployment_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_ids(inp);
            self
        }
        /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs
        /// you can specify is 25.</p>
        pub fn set_deployment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_deployment_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeploymentTargets`.
    ///
    /// <p> Returns an array of one or more targets associated with a deployment. This method
    /// works with all compute types and should be used instead of the deprecated
    /// <code>BatchGetDeploymentInstances</code>. The maximum number of targets that can be
    /// returned is 25.</p>
    /// <p> The type of targets returned depends on the deployment's compute platform or
    /// deployment method: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>EC2/On-premises</b>: Information about EC2 instance
    /// targets. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AWS Lambda</b>: Information about Lambda functions
    /// targets. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Amazon ECS</b>: Information about Amazon ECS
    /// service targets. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CloudFormation</b>: Information about targets of
    /// blue/green deployments initiated by a CloudFormation stack update.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetDeploymentTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_deployment_targets_input::Builder,
    }
    impl<C, M, R> BatchGetDeploymentTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetDeploymentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetDeploymentTargetsInputOperationOutputAlias,
                crate::output::BatchGetDeploymentTargetsOutput,
                crate::error::BatchGetDeploymentTargetsError,
                crate::input::BatchGetDeploymentTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `targetIds`.
        ///
        /// To override the contents of this collection use [`set_target_ids`](Self::set_target_ids).
        ///
        /// <p> The unique IDs of the deployment targets. The compute platform of the deployment
        /// determines the type of the targets and their formats. The maximum number of deployment
        /// target IDs you can specify is 25.</p>
        /// <ul>
        /// <li>
        /// <p> For deployments that use the EC2/On-premises compute platform, the target IDs
        /// are EC2 or on-premises instances IDs, and their target type is
        /// <code>instanceTarget</code>. </p>
        /// </li>
        /// <li>
        /// <p> For deployments that use the AWS Lambda compute platform, the target IDs are
        /// the names of Lambda functions, and their target type is
        /// <code>instanceTarget</code>. </p>
        /// </li>
        /// <li>
        /// <p> For deployments that use the Amazon ECS compute platform, the target IDs are
        /// pairs of Amazon ECS clusters and services specified using the format
        /// <code><clustername>:<servicename></code>. Their target type is
        /// <code>ecsTarget</code>. </p>
        /// </li>
        /// <li>
        /// <p> For deployments that are deployed with AWS CloudFormation, the target IDs are
        /// CloudFormation stack IDs. Their target type is
        /// <code>cloudFormationTarget</code>. </p>
        /// </li>
        /// </ul>
        pub fn target_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_ids(inp);
            self
        }
        /// <p> The unique IDs of the deployment targets. The compute platform of the deployment
        /// determines the type of the targets and their formats. The maximum number of deployment
        /// target IDs you can specify is 25.</p>
        /// <ul>
        /// <li>
        /// <p> For deployments that use the EC2/On-premises compute platform, the target IDs
        /// are EC2 or on-premises instances IDs, and their target type is
        /// <code>instanceTarget</code>. </p>
        /// </li>
        /// <li>
        /// <p> For deployments that use the AWS Lambda compute platform, the target IDs are
        /// the names of Lambda functions, and their target type is
        /// <code>instanceTarget</code>. </p>
        /// </li>
        /// <li>
        /// <p> For deployments that use the Amazon ECS compute platform, the target IDs are
        /// pairs of Amazon ECS clusters and services specified using the format
        /// <code><clustername>:<servicename></code>. Their target type is
        /// <code>ecsTarget</code>. </p>
        /// </li>
        /// <li>
        /// <p> For deployments that are deployed with AWS CloudFormation, the target IDs are
        /// CloudFormation stack IDs. Their target type is
        /// <code>cloudFormationTarget</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_target_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetOnPremisesInstances`.
    ///
    /// <p>Gets information about one or more on-premises instances. The maximum number of
    /// on-premises instances that can be returned is 25.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetOnPremisesInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_on_premises_instances_input::Builder,
    }
    impl<C, M, R> BatchGetOnPremisesInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetOnPremisesInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetOnPremisesInstancesInputOperationOutputAlias,
                crate::output::BatchGetOnPremisesInstancesOutput,
                crate::error::BatchGetOnPremisesInstancesError,
                crate::input::BatchGetOnPremisesInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances about which to get information. The maximum
        /// number of instance names you can specify is 25.</p>
        pub fn instance_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(inp);
            self
        }
        /// <p>The names of the on-premises instances about which to get information. The maximum
        /// number of instance names you can specify is 25.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ContinueDeployment`.
    ///
    /// <p>For a blue/green deployment, starts the process of rerouting traffic from instances in
    /// the original environment to instances in the replacement environment without waiting for
    /// a specified wait time to elapse. (Traffic rerouting, which is achieved by registering
    /// instances in the replacement environment with the load balancer, can start as soon as
    /// all instances have a status of Ready.) </p>
    #[derive(std::fmt::Debug)]
    pub struct ContinueDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::continue_deployment_input::Builder,
    }
    impl<C, M, R> ContinueDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ContinueDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ContinueDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::ContinueDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ContinueDeploymentInputOperationOutputAlias,
                crate::output::ContinueDeploymentOutput,
                crate::error::ContinueDeploymentError,
                crate::input::ContinueDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a blue/green deployment for which you want to start rerouting
        /// traffic to the replacement environment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a blue/green deployment for which you want to start rerouting
        /// traffic to the replacement environment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that
        /// the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code>
        /// indicates that the traffic is shifted, but the original target is not terminated.
        /// </p>
        pub fn deployment_wait_type(mut self, inp: crate::model::DeploymentWaitType) -> Self {
            self.inner = self.inner.deployment_wait_type(inp);
            self
        }
        /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that
        /// the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code>
        /// indicates that the traffic is shifted, but the original target is not terminated.
        /// </p>
        pub fn set_deployment_wait_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentWaitType>,
        ) -> Self {
            self.inner = self.inner.set_deployment_wait_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application. This name must be unique with the applicable IAM user or
        /// AWS account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application. This name must be unique with the applicable IAM user or
        /// AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p> The destination platform type for the deployment (<code>Lambda</code>,
        /// <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, inp: crate::model::ComputePlatform) -> Self {
            self.inner = self.inner.compute_platform(inp);
            self
        }
        /// <p> The destination platform type for the deployment (<code>Lambda</code>,
        /// <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.inner = self.inner.set_compute_platform(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The metadata that you apply to CodeDeploy applications to help you organize and
        /// categorize them. Each tag consists of a key and an optional value, both of which you
        /// define. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p> The metadata that you apply to CodeDeploy applications to help you organize and
        /// categorize them. Each tag consists of a key and an optional value, both of which you
        /// define. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p>Deploys an application revision through the specified deployment group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl<C, M, R> CreateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentInputOperationOutputAlias,
                crate::output::CreateDeploymentOutput,
                crate::error::CreateDeploymentError,
                crate::input::CreateDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the deployment group.</p>
        pub fn deployment_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(inp);
            self
        }
        /// <p>The name of the deployment group.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
        /// <p> The type and location of the revision to deploy. </p>
        pub fn revision(mut self, inp: crate::model::RevisionLocation) -> Self {
            self.inner = self.inner.revision(inp);
            self
        }
        /// <p> The type and location of the revision to deploy. </p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.inner = self.inner.set_revision(input);
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS
        /// account.</p>
        /// <p>If not specified, the value configured in the deployment group is used as the default.
        /// If the deployment group does not have a deployment configuration associated with it,
        /// <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
        pub fn deployment_config_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(inp);
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS
        /// account.</p>
        /// <p>If not specified, the value configured in the deployment group is used as the default.
        /// If the deployment group does not have a deployment configuration associated with it,
        /// <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
        /// <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then
        /// the deployment continues to the next deployment lifecycle event. For example, if
        /// <code>ApplicationStop</code> fails, the deployment continues with
        /// <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the
        /// deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code>
        /// fails, the deployment continues with <code>ApplicationStop</code>. </p>
        ///
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an
        /// instance, that deployment fails. If deployment to that instance is part of an overall
        /// deployment and the number of healthy hosts is not less than the minimum number of
        /// healthy hosts, then a deployment to the next instance is attempted. </p>
        ///
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for
        /// <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and
        /// <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful
        /// deployment. (All other scripts are run from the AppSpec file in the current deployment.)
        /// If one of these scripts contains an error and does not run successfully, the deployment
        /// can fail. </p>
        ///
        /// <p> If the cause of the failure is a script from the last successful deployment that will
        /// never run successfully, create a new deployment and use
        /// <code>ignoreApplicationStopFailures</code> to specify that the
        /// <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and
        /// <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn ignore_application_stop_failures(mut self, inp: bool) -> Self {
            self.inner = self.inner.ignore_application_stop_failures(inp);
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
        /// <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then
        /// the deployment continues to the next deployment lifecycle event. For example, if
        /// <code>ApplicationStop</code> fails, the deployment continues with
        /// <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the
        /// deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code>
        /// fails, the deployment continues with <code>ApplicationStop</code>. </p>
        ///
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an
        /// instance, that deployment fails. If deployment to that instance is part of an overall
        /// deployment and the number of healthy hosts is not less than the minimum number of
        /// healthy hosts, then a deployment to the next instance is attempted. </p>
        ///
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for
        /// <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and
        /// <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful
        /// deployment. (All other scripts are run from the AppSpec file in the current deployment.)
        /// If one of these scripts contains an error and does not run successfully, the deployment
        /// can fail. </p>
        ///
        /// <p> If the cause of the failure is a script from the last successful deployment that will
        /// never run successfully, create a new deployment and use
        /// <code>ignoreApplicationStopFailures</code> to specify that the
        /// <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and
        /// <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn set_ignore_application_stop_failures(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_ignore_application_stop_failures(input);
            self
        }
        /// <p> Information about the instances that belong to the replacement environment in a
        /// blue/green deployment. </p>
        pub fn target_instances(mut self, inp: crate::model::TargetInstances) -> Self {
            self.inner = self.inner.target_instances(inp);
            self
        }
        /// <p> Information about the instances that belong to the replacement environment in a
        /// blue/green deployment. </p>
        pub fn set_target_instances(
            mut self,
            input: std::option::Option<crate::model::TargetInstances>,
        ) -> Self {
            self.inner = self.inner.set_target_instances(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment is
        /// created.</p>
        pub fn auto_rollback_configuration(
            mut self,
            inp: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.inner = self.inner.auto_rollback_configuration(inp);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment is
        /// created.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_auto_rollback_configuration(input);
            self
        }
        /// <p> Indicates whether to deploy to all instances or only to instances that are not
        /// running the latest application revision. </p>
        pub fn update_outdated_instances_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.update_outdated_instances_only(inp);
            self
        }
        /// <p> Indicates whether to deploy to all instances or only to instances that are not
        /// running the latest application revision. </p>
        pub fn set_update_outdated_instances_only(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_update_outdated_instances_only(input);
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment
        /// target location but weren't part of the previous successful deployment.</p>
        /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>DISALLOW: The deployment fails. This is also the default behavior if no option
        /// is specified.</p>
        /// </li>
        /// <li>
        /// <p>OVERWRITE: The version of the file from the application revision currently
        /// being deployed replaces the version already on the instance.</p>
        /// </li>
        /// <li>
        /// <p>RETAIN: The version of the file already on the instance is kept and used as
        /// part of the new deployment.</p>
        /// </li>
        /// </ul>
        pub fn file_exists_behavior(mut self, inp: crate::model::FileExistsBehavior) -> Self {
            self.inner = self.inner.file_exists_behavior(inp);
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment
        /// target location but weren't part of the previous successful deployment.</p>
        /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>DISALLOW: The deployment fails. This is also the default behavior if no option
        /// is specified.</p>
        /// </li>
        /// <li>
        /// <p>OVERWRITE: The version of the file from the application revision currently
        /// being deployed replaces the version already on the instance.</p>
        /// </li>
        /// <li>
        /// <p>RETAIN: The version of the file already on the instance is kept and used as
        /// part of the new deployment.</p>
        /// </li>
        /// </ul>
        pub fn set_file_exists_behavior(
            mut self,
            input: std::option::Option<crate::model::FileExistsBehavior>,
        ) -> Self {
            self.inner = self.inner.set_file_exists_behavior(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeploymentConfig`.
    ///
    /// <p> Creates a deployment configuration. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDeploymentConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_config_input::Builder,
    }
    impl<C, M, R> CreateDeploymentConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeploymentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentConfigInputOperationOutputAlias,
                crate::output::CreateDeploymentConfigOutput,
                crate::error::CreateDeploymentConfigError,
                crate::input::CreateDeploymentConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the deployment configuration to create.</p>
        pub fn deployment_config_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(inp);
            self
        }
        /// <p>The name of the deployment configuration to create.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// <p>The minimum number of healthy instances that should be available at any time during
        /// the deployment. There are two parameters expected in the input: type and value.</p>
        /// <p>The type parameter takes either of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>HOST_COUNT: The value parameter represents the minimum number of healthy
        /// instances as an absolute value.</p>
        /// </li>
        /// <li>
        /// <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy
        /// instances as a percentage of the total number of instances in the deployment. If
        /// you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy
        /// converts the percentage to the equivalent number of instances and rounds up
        /// fractional instances.</p>
        /// </li>
        /// </ul>
        /// <p>The value parameter takes an integer.</p>
        /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT
        /// and a value of 95.</p>
        pub fn minimum_healthy_hosts(mut self, inp: crate::model::MinimumHealthyHosts) -> Self {
            self.inner = self.inner.minimum_healthy_hosts(inp);
            self
        }
        /// <p>The minimum number of healthy instances that should be available at any time during
        /// the deployment. There are two parameters expected in the input: type and value.</p>
        /// <p>The type parameter takes either of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>HOST_COUNT: The value parameter represents the minimum number of healthy
        /// instances as an absolute value.</p>
        /// </li>
        /// <li>
        /// <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy
        /// instances as a percentage of the total number of instances in the deployment. If
        /// you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy
        /// converts the percentage to the equivalent number of instances and rounds up
        /// fractional instances.</p>
        /// </li>
        /// </ul>
        /// <p>The value parameter takes an integer.</p>
        /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT
        /// and a value of 95.</p>
        pub fn set_minimum_healthy_hosts(
            mut self,
            input: std::option::Option<crate::model::MinimumHealthyHosts>,
        ) -> Self {
            self.inner = self.inner.set_minimum_healthy_hosts(input);
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed.</p>
        pub fn traffic_routing_config(mut self, inp: crate::model::TrafficRoutingConfig) -> Self {
            self.inner = self.inner.traffic_routing_config(inp);
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed.</p>
        pub fn set_traffic_routing_config(
            mut self,
            input: std::option::Option<crate::model::TrafficRoutingConfig>,
        ) -> Self {
            self.inner = self.inner.set_traffic_routing_config(input);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>,
        /// <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, inp: crate::model::ComputePlatform) -> Self {
            self.inner = self.inner.compute_platform(inp);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>,
        /// <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.inner = self.inner.set_compute_platform(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeploymentGroup`.
    ///
    /// <p>Creates a deployment group to which application revisions are deployed.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDeploymentGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_group_input::Builder,
    }
    impl<C, M, R> CreateDeploymentGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentGroupInputOperationOutputAlias,
                crate::output::CreateDeploymentGroupOutput,
                crate::error::CreateDeploymentGroupError,
                crate::input::CreateDeploymentGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a new deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(inp);
            self
        }
        /// <p>The name of a new deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
        /// <p>If specified, the deployment configuration name can be either one of the predefined
        /// configurations provided with AWS CodeDeploy or a custom deployment configuration that
        /// you create by calling the create deployment configuration operation.</p>
        /// <p>
        /// <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It
        /// is used if a configuration isn't specified for the deployment or deployment
        /// group.</p>
        /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy,
        /// see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with
        /// Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User
        /// Guide</i>.</p>
        pub fn deployment_config_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(inp);
            self
        }
        /// <p>If specified, the deployment configuration name can be either one of the predefined
        /// configurations provided with AWS CodeDeploy or a custom deployment configuration that
        /// you create by calling the create deployment configuration operation.</p>
        /// <p>
        /// <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It
        /// is used if a configuration isn't specified for the deployment or deployment
        /// group.</p>
        /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy,
        /// see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with
        /// Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User
        /// Guide</i>.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// Appends an item to `ec2TagFilters`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_filters`](Self::set_ec2_tag_filters).
        ///
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
        /// with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
        pub fn ec2_tag_filters(mut self, inp: impl Into<crate::model::Ec2TagFilter>) -> Self {
            self.inner = self.inner.ec2_tag_filters(inp);
            self
        }
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances
        /// with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
        pub fn set_ec2_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_filters(input);
            self
        }
        /// Appends an item to `onPremisesInstanceTagFilters`.
        ///
        /// To override the contents of this collection use [`set_on_premises_instance_tag_filters`](Self::set_on_premises_instance_tag_filters).
        ///
        /// <p>The on-premises instance tags on which to filter. The deployment group includes
        /// on-premises instances with any of the specified tags. Cannot be used in the same call as
        /// <code>OnPremisesTagSet</code>.</p>
        pub fn on_premises_instance_tag_filters(
            mut self,
            inp: impl Into<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.on_premises_instance_tag_filters(inp);
            self
        }
        /// <p>The on-premises instance tags on which to filter. The deployment group includes
        /// on-premises instances with any of the specified tags. Cannot be used in the same call as
        /// <code>OnPremisesTagSet</code>.</p>
        pub fn set_on_premises_instance_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_instance_tag_filters(input);
            self
        }
        /// Appends an item to `autoScalingGroups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
        pub fn auto_scaling_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_scaling_groups(inp);
            self
        }
        /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_groups(input);
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the
        /// user's behalf when interacting with AWS services.</p>
        pub fn service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(inp);
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the
        /// user's behalf when interacting with AWS services.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// Appends an item to `triggerConfigurations`.
        ///
        /// To override the contents of this collection use [`set_trigger_configurations`](Self::set_trigger_configurations).
        ///
        /// <p>Information about triggers to create when the deployment group is created. For
        /// examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an
        /// AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User
        /// Guide</i>.</p>
        pub fn trigger_configurations(
            mut self,
            inp: impl Into<crate::model::TriggerConfig>,
        ) -> Self {
            self.inner = self.inner.trigger_configurations(inp);
            self
        }
        /// <p>Information about triggers to create when the deployment group is created. For
        /// examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an
        /// AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User
        /// Guide</i>.</p>
        pub fn set_trigger_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        ) -> Self {
            self.inner = self.inner.set_trigger_configurations(input);
            self
        }
        /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is
        /// created.</p>
        pub fn alarm_configuration(mut self, inp: crate::model::AlarmConfiguration) -> Self {
            self.inner = self.inner.alarm_configuration(inp);
            self
        }
        /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is
        /// created.</p>
        pub fn set_alarm_configuration(
            mut self,
            input: std::option::Option<crate::model::AlarmConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_alarm_configuration(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment
        /// group is created.</p>
        pub fn auto_rollback_configuration(
            mut self,
            inp: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.inner = self.inner.auto_rollback_configuration(inp);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment
        /// group is created.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_auto_rollback_configuration(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not
        /// receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates
        /// one or more 'auto-update outdated instances' deployments to apply the deployed
        /// application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a
        /// deployment to update the new EC2 instances. This may result in instances having
        /// different revisions.</p>
        pub fn outdated_instances_strategy(
            mut self,
            inp: crate::model::OutdatedInstancesStrategy,
        ) -> Self {
            self.inner = self.inner.outdated_instances_strategy(inp);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not
        /// receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates
        /// one or more 'auto-update outdated instances' deployments to apply the deployed
        /// application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a
        /// deployment to update the new EC2 instances. This may result in instances having
        /// different revisions.</p>
        pub fn set_outdated_instances_strategy(
            mut self,
            input: std::option::Option<crate::model::OutdatedInstancesStrategy>,
        ) -> Self {
            self.inner = self.inner.set_outdated_instances_strategy(input);
            self
        }
        /// <p>Information about the type of deployment, in-place or blue/green, that you want to run
        /// and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, inp: crate::model::DeploymentStyle) -> Self {
            self.inner = self.inner.deployment_style(inp);
            self
        }
        /// <p>Information about the type of deployment, in-place or blue/green, that you want to run
        /// and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.inner = self.inner.set_deployment_style(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            inp: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.inner = self.inner.blue_green_deployment_configuration(inp);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_blue_green_deployment_configuration(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn load_balancer_info(mut self, inp: crate::model::LoadBalancerInfo) -> Self {
            self.inner = self.inner.load_balancer_info(inp);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_info(input);
            self
        }
        /// <p>Information about groups of tags applied to EC2 instances. The deployment group
        /// includes only EC2 instances identified by all the tag groups. Cannot be used in the same
        /// call as <code>ec2TagFilters</code>.</p>
        pub fn ec2_tag_set(mut self, inp: crate::model::Ec2TagSet) -> Self {
            self.inner = self.inner.ec2_tag_set(inp);
            self
        }
        /// <p>Information about groups of tags applied to EC2 instances. The deployment group
        /// includes only EC2 instances identified by all the tag groups. Cannot be used in the same
        /// call as <code>ec2TagFilters</code>.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_set(input);
            self
        }
        /// Appends an item to `ecsServices`.
        ///
        /// To override the contents of this collection use [`set_ecs_services`](Self::set_ecs_services).
        ///
        /// <p> The target Amazon ECS services in the deployment group. This applies only to
        /// deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
        /// is specified as an Amazon ECS cluster and service name pair using the format
        /// <code><clustername>:<servicename></code>. </p>
        pub fn ecs_services(mut self, inp: impl Into<crate::model::EcsService>) -> Self {
            self.inner = self.inner.ecs_services(inp);
            self
        }
        /// <p> The target Amazon ECS services in the deployment group. This applies only to
        /// deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
        /// is specified as an Amazon ECS cluster and service name pair using the format
        /// <code><clustername>:<servicename></code>. </p>
        pub fn set_ecs_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        ) -> Self {
            self.inner = self.inner.set_ecs_services(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment
        /// group includes only on-premises instances identified by all of the tag groups. Cannot be
        /// used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
        pub fn on_premises_tag_set(mut self, inp: crate::model::OnPremisesTagSet) -> Self {
            self.inner = self.inner.on_premises_tag_set(inp);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment
        /// group includes only on-premises instances identified by all of the tag groups. Cannot be
        /// used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
        pub fn set_on_premises_tag_set(
            mut self,
            input: std::option::Option<crate::model::OnPremisesTagSet>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_tag_set(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and
        /// categorize them. Each tag consists of a key and an optional value, both of which you
        /// define. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and
        /// categorize them. Each tag consists of a key and an optional value, both of which you
        /// define. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeploymentConfig`.
    ///
    /// <p>Deletes a deployment configuration.</p>
    /// <note>
    /// <p>A deployment configuration cannot be deleted if it is currently in use. Predefined
    /// configurations cannot be deleted.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDeploymentConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_deployment_config_input::Builder,
    }
    impl<C, M, R> DeleteDeploymentConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeploymentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeploymentConfigInputOperationOutputAlias,
                crate::output::DeleteDeploymentConfigOutput,
                crate::error::DeleteDeploymentConfigError,
                crate::input::DeleteDeploymentConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS
        /// account.</p>
        pub fn deployment_config_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(inp);
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS
        /// account.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeploymentGroup`.
    ///
    /// <p>Deletes a deployment group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDeploymentGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_deployment_group_input::Builder,
    }
    impl<C, M, R> DeleteDeploymentGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeploymentGroupInputOperationOutputAlias,
                crate::output::DeleteDeploymentGroupOutput,
                crate::error::DeleteDeploymentGroupError,
                crate::input::DeleteDeploymentGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(inp);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGitHubAccountToken`.
    ///
    /// <p>Deletes a GitHub account connection.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGitHubAccountToken<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_git_hub_account_token_input::Builder,
    }
    impl<C, M, R> DeleteGitHubAccountToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGitHubAccountToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGitHubAccountTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGitHubAccountTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGitHubAccountTokenInputOperationOutputAlias,
                crate::output::DeleteGitHubAccountTokenOutput,
                crate::error::DeleteGitHubAccountTokenError,
                crate::input::DeleteGitHubAccountTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the GitHub account connection to delete.</p>
        pub fn token_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_name(inp);
            self
        }
        /// <p>The name of the GitHub account connection to delete.</p>
        pub fn set_token_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcesByExternalId`.
    ///
    /// <p>Deletes resources linked to an external ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourcesByExternalId<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resources_by_external_id_input::Builder,
    }
    impl<C, M, R> DeleteResourcesByExternalId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcesByExternalId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcesByExternalIdOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcesByExternalIdError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcesByExternalIdInputOperationOutputAlias,
                crate::output::DeleteResourcesByExternalIdOutput,
                crate::error::DeleteResourcesByExternalIdError,
                crate::input::DeleteResourcesByExternalIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is
        /// linked to one or more CodeDeploy resources.</p>
        pub fn external_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(inp);
            self
        }
        /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is
        /// linked to one or more CodeDeploy resources.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterOnPremisesInstance`.
    ///
    /// <p>Deregisters an on-premises instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterOnPremisesInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_on_premises_instance_input::Builder,
    }
    impl<C, M, R> DeregisterOnPremisesInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterOnPremisesInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterOnPremisesInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterOnPremisesInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterOnPremisesInstanceInputOperationOutputAlias,
                crate::output::DeregisterOnPremisesInstanceOutput,
                crate::error::DeregisterOnPremisesInstanceError,
                crate::input::DeregisterOnPremisesInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the on-premises instance to deregister.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the on-premises instance to deregister.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplication`.
    ///
    /// <p>Gets information about an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_input::Builder,
    }
    impl<C, M, R> GetApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationInputOperationOutputAlias,
                crate::output::GetApplicationOutput,
                crate::error::GetApplicationError,
                crate::input::GetApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationRevision`.
    ///
    /// <p>Gets information about an application revision.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplicationRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_revision_input::Builder,
    }
    impl<C, M, R> GetApplicationRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationRevisionInputOperationOutputAlias,
                crate::output::GetApplicationRevisionOutput,
                crate::error::GetApplicationRevisionError,
                crate::input::GetApplicationRevisionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Information about the application revision to get, including type and location.</p>
        pub fn revision(mut self, inp: crate::model::RevisionLocation) -> Self {
            self.inner = self.inner.revision(inp);
            self
        }
        /// <p>Information about the application revision to get, including type and location.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.inner = self.inner.set_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Gets information about a deployment.</p>
    /// <note>
    /// <p> The <code>content</code> property of the <code>appSpecContent</code> object in
    /// the returned revision is always null. Use <code>GetApplicationRevision</code> and
    /// the <code>sha256</code> property of the returned <code>appSpecContent</code> object
    /// to get the content of the deployment’s AppSpec file. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl<C, M, R> GetDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentInputOperationOutputAlias,
                crate::output::GetDeploymentOutput,
                crate::error::GetDeploymentError,
                crate::input::GetDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentConfig`.
    ///
    /// <p>Gets information about a deployment configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeploymentConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_config_input::Builder,
    }
    impl<C, M, R> GetDeploymentConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeploymentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentConfigInputOperationOutputAlias,
                crate::output::GetDeploymentConfigOutput,
                crate::error::GetDeploymentConfigError,
                crate::input::GetDeploymentConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS
        /// account.</p>
        pub fn deployment_config_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(inp);
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS
        /// account.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentGroup`.
    ///
    /// <p>Gets information about a deployment group.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeploymentGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_group_input::Builder,
    }
    impl<C, M, R> GetDeploymentGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentGroupInputOperationOutputAlias,
                crate::output::GetDeploymentGroupOutput,
                crate::error::GetDeploymentGroupError,
                crate::input::GetDeploymentGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(inp);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentInstance`.
    ///
    /// <p>Gets information about an instance as part of a deployment.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeploymentInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_instance_input::Builder,
    }
    impl<C, M, R> GetDeploymentInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeploymentInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentInstanceInputOperationOutputAlias,
                crate::output::GetDeploymentInstanceOutput,
                crate::error::GetDeploymentInstanceError,
                crate::input::GetDeploymentInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The unique ID of an instance in the deployment group. </p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p> The unique ID of an instance in the deployment group. </p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentTarget`.
    ///
    /// <p> Returns information about a deployment target. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeploymentTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_target_input::Builder,
    }
    impl<C, M, R> GetDeploymentTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeploymentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentTargetInputOperationOutputAlias,
                crate::output::GetDeploymentTargetOutput,
                crate::error::GetDeploymentTargetError,
                crate::input::GetDeploymentTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The unique ID of a deployment target. </p>
        pub fn target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(inp);
            self
        }
        /// <p> The unique ID of a deployment target. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOnPremisesInstance`.
    ///
    /// <p> Gets information about an on-premises instance. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetOnPremisesInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_on_premises_instance_input::Builder,
    }
    impl<C, M, R> GetOnPremisesInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOnPremisesInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOnPremisesInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOnPremisesInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOnPremisesInstanceInputOperationOutputAlias,
                crate::output::GetOnPremisesInstanceOutput,
                crate::error::GetOnPremisesInstanceError,
                crate::input::GetOnPremisesInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the on-premises instance about which to get information. </p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p> The name of the on-premises instance about which to get information. </p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationRevisions`.
    ///
    /// <p>Lists information about revisions for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApplicationRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_revisions_input::Builder,
    }
    impl<C, M, R> ListApplicationRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationRevisionsInputOperationOutputAlias,
                crate::output::ListApplicationRevisionsOutput,
                crate::error::ListApplicationRevisionsError,
                crate::input::ListApplicationRevisionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account. </p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The column name to use to sort the list results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>registerTime</code>: Sort by the time the revisions were registered with
        /// AWS CodeDeploy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>firstUsedTime</code>: Sort by the time the revisions were first used in
        /// a deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>lastUsedTime</code>: Sort by the time the revisions were last used in a
        /// deployment.</p>
        /// </li>
        /// </ul>
        /// <p> If not specified or set to null, the results are returned in an arbitrary order.
        /// </p>
        pub fn sort_by(mut self, inp: crate::model::ApplicationRevisionSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The column name to use to sort the list results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>registerTime</code>: Sort by the time the revisions were registered with
        /// AWS CodeDeploy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>firstUsedTime</code>: Sort by the time the revisions were first used in
        /// a deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>lastUsedTime</code>: Sort by the time the revisions were last used in a
        /// deployment.</p>
        /// </li>
        /// </ul>
        /// <p> If not specified or set to null, the results are returned in an arbitrary order.
        /// </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ApplicationRevisionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p> The order in which to sort the list results: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ascending</code>: ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>descending</code>: descending order.</p>
        /// </li>
        /// </ul>
        /// <p>If not specified, the results are sorted in ascending order.</p>
        /// <p>If set to null, the results are sorted in an arbitrary order.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p> The order in which to sort the list results: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ascending</code>: ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>descending</code>: descending order.</p>
        /// </li>
        /// </ul>
        /// <p>If not specified, the results are sorted in ascending order.</p>
        /// <p>If set to null, the results are sorted in an arbitrary order.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
        /// <p> If set to null, all of the user's buckets are searched. </p>
        pub fn s3_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(inp);
            self
        }
        /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
        /// <p> If set to null, all of the user's buckets are searched. </p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions.
        /// </p>
        pub fn s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(inp);
            self
        }
        /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions.
        /// </p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
        /// <p> Whether to list revisions based on whether the revision is the target revision of a
        /// deployment group: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>include</code>: List revisions that are target revisions of a deployment
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>exclude</code>: Do not list revisions that are target revisions of a
        /// deployment group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ignore</code>: List all revisions.</p>
        /// </li>
        /// </ul>
        pub fn deployed(mut self, inp: crate::model::ListStateFilterAction) -> Self {
            self.inner = self.inner.deployed(inp);
            self
        }
        /// <p> Whether to list revisions based on whether the revision is the target revision of a
        /// deployment group: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>include</code>: List revisions that are target revisions of a deployment
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>exclude</code>: Do not list revisions that are target revisions of a
        /// deployment group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ignore</code>: List all revisions.</p>
        /// </li>
        /// </ul>
        pub fn set_deployed(
            mut self,
            input: std::option::Option<crate::model::ListStateFilterAction>,
        ) -> Self {
            self.inner = self.inner.set_deployed(input);
            self
        }
        /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call.
        /// It can be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call.
        /// It can be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists the applications registered with the IAM user or AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl<C, M, R> ListApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationsInputOperationOutputAlias,
                crate::output::ListApplicationsOutput,
                crate::error::ListApplicationsError,
                crate::input::ListApplicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier returned from the previous list applications call. It can be used to
        /// return the next set of applications in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous list applications call. It can be used to
        /// return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentConfigs`.
    ///
    /// <p>Lists the deployment configurations with the IAM user or AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeploymentConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deployment_configs_input::Builder,
    }
    impl<C, M, R> ListDeploymentConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeploymentConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeploymentConfigsInputOperationOutputAlias,
                crate::output::ListDeploymentConfigsOutput,
                crate::error::ListDeploymentConfigsError,
                crate::input::ListDeploymentConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It
        /// can be used to return the next set of deployment configurations in the list. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It
        /// can be used to return the next set of deployment configurations in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentGroups`.
    ///
    /// <p>Lists the deployment groups for an application registered with the IAM user or AWS
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeploymentGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deployment_groups_input::Builder,
    }
    impl<C, M, R> ListDeploymentGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeploymentGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeploymentGroupsInputOperationOutputAlias,
                crate::output::ListDeploymentGroupsOutput,
                crate::error::ListDeploymentGroupsError,
                crate::input::ListDeploymentGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>An identifier returned from the previous list deployment groups call. It can be used
        /// to return the next set of deployment groups in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous list deployment groups call. It can be used
        /// to return the next set of deployment groups in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentInstances`.
    ///
    /// <note>
    /// <p> The newer <code>BatchGetDeploymentTargets</code> should be used instead because
    /// it works with all compute types. <code>ListDeploymentInstances</code> throws an
    /// exception if it is used with a compute platform other than EC2/On-premises or AWS
    /// Lambda. </p>
    /// </note>
    /// <p> Lists the instance for a deployment associated with the IAM user or AWS account. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeploymentInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deployment_instances_input::Builder,
    }
    impl<C, M, R> ListDeploymentInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeploymentInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeploymentInstancesInputOperationOutputAlias,
                crate::output::ListDeploymentInstancesOutput,
                crate::error::ListDeploymentInstancesError,
                crate::input::ListDeploymentInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>An identifier returned from the previous list deployment instances call. It can be
        /// used to return the next set of deployment instances in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous list deployment instances call. It can be
        /// used to return the next set of deployment instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `instanceStatusFilter`.
        ///
        /// To override the contents of this collection use [`set_instance_status_filter`](Self::set_instance_status_filter).
        ///
        /// <p>A subset of instances to list by status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code>: Include those instances with pending deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code>: Include those instances where deployments are still
        /// in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Succeeded</code>: Include those instances with successful
        /// deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: Include those instances with failed deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Skipped</code>: Include those instances with skipped deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unknown</code>: Include those instances with deployments in an unknown
        /// state.</p>
        /// </li>
        /// </ul>
        pub fn instance_status_filter(
            mut self,
            inp: impl Into<crate::model::InstanceStatus>,
        ) -> Self {
            self.inner = self.inner.instance_status_filter(inp);
            self
        }
        /// <p>A subset of instances to list by status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code>: Include those instances with pending deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code>: Include those instances where deployments are still
        /// in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Succeeded</code>: Include those instances with successful
        /// deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: Include those instances with failed deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Skipped</code>: Include those instances with skipped deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unknown</code>: Include those instances with deployments in an unknown
        /// state.</p>
        /// </li>
        /// </ul>
        pub fn set_instance_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceStatus>>,
        ) -> Self {
            self.inner = self.inner.set_instance_status_filter(input);
            self
        }
        /// Appends an item to `instanceTypeFilter`.
        ///
        /// To override the contents of this collection use [`set_instance_type_filter`](Self::set_instance_type_filter).
        ///
        /// <p>The set of instances in a blue/green deployment, either those in the original
        /// environment ("BLUE") or those in the replacement environment ("GREEN"), for which you
        /// want to view instance information.</p>
        pub fn instance_type_filter(mut self, inp: impl Into<crate::model::InstanceType>) -> Self {
            self.inner = self.inner.instance_type_filter(inp);
            self
        }
        /// <p>The set of instances in a blue/green deployment, either those in the original
        /// environment ("BLUE") or those in the replacement environment ("GREEN"), for which you
        /// want to view instance information.</p>
        pub fn set_instance_type_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceType>>,
        ) -> Self {
            self.inner = self.inner.set_instance_type_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeployments`.
    ///
    /// <p>Lists the deployments in a deployment group for an application registered with the IAM
    /// user or AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deployments_input::Builder,
    }
    impl<C, M, R> ListDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeploymentsInputOperationOutputAlias,
                crate::output::ListDeploymentsOutput,
                crate::error::ListDeploymentsError,
                crate::input::ListDeploymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        /// <note>
        /// <p>If <code>applicationName</code> is specified, then
        /// <code>deploymentGroupName</code> must be specified. If it is not specified, then
        /// <code>deploymentGroupName</code> must not be specified. </p>
        /// </note>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        /// <note>
        /// <p>If <code>applicationName</code> is specified, then
        /// <code>deploymentGroupName</code> must be specified. If it is not specified, then
        /// <code>deploymentGroupName</code> must not be specified. </p>
        /// </note>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        /// <note>
        /// <p>If <code>deploymentGroupName</code> is specified, then
        /// <code>applicationName</code> must be specified. If it is not specified, then
        /// <code>applicationName</code> must not be specified. </p>
        /// </note>
        pub fn deployment_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(inp);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        /// <note>
        /// <p>If <code>deploymentGroupName</code> is specified, then
        /// <code>applicationName</code> must be specified. If it is not specified, then
        /// <code>applicationName</code> must not be specified. </p>
        /// </note>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
        /// <p>The unique ID of an external resource for returning deployments linked to the external
        /// resource.</p>
        pub fn external_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(inp);
            self
        }
        /// <p>The unique ID of an external resource for returning deployments linked to the external
        /// resource.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
        /// Appends an item to `includeOnlyStatuses`.
        ///
        /// To override the contents of this collection use [`set_include_only_statuses`](Self::set_include_only_statuses).
        ///
        /// <p>A subset of deployments to list by status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Created</code>: Include created deployments in the resulting
        /// list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Queued</code>: Include queued deployments in the resulting list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>In Progress</code>: Include in-progress deployments in the resulting
        /// list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Succeeded</code>: Include successful deployments in the resulting
        /// list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: Include failed deployments in the resulting list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Stopped</code>: Include stopped deployments in the resulting
        /// list.</p>
        /// </li>
        /// </ul>
        pub fn include_only_statuses(
            mut self,
            inp: impl Into<crate::model::DeploymentStatus>,
        ) -> Self {
            self.inner = self.inner.include_only_statuses(inp);
            self
        }
        /// <p>A subset of deployments to list by status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Created</code>: Include created deployments in the resulting
        /// list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Queued</code>: Include queued deployments in the resulting list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>In Progress</code>: Include in-progress deployments in the resulting
        /// list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Succeeded</code>: Include successful deployments in the resulting
        /// list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: Include failed deployments in the resulting list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Stopped</code>: Include stopped deployments in the resulting
        /// list.</p>
        /// </li>
        /// </ul>
        pub fn set_include_only_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentStatus>>,
        ) -> Self {
            self.inner = self.inner.set_include_only_statuses(input);
            self
        }
        /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
        pub fn create_time_range(mut self, inp: crate::model::TimeRange) -> Self {
            self.inner = self.inner.create_time_range(inp);
            self
        }
        /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
        pub fn set_create_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_create_time_range(input);
            self
        }
        /// <p>An identifier returned from the previous list deployments call. It can be used to
        /// return the next set of deployments in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous list deployments call. It can be used to
        /// return the next set of deployments in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentTargets`.
    ///
    /// <p> Returns an array of target IDs that are associated a deployment. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeploymentTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deployment_targets_input::Builder,
    }
    impl<C, M, R> ListDeploymentTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeploymentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeploymentTargetsInputOperationOutputAlias,
                crate::output::ListDeploymentTargetsOutput,
                crate::error::ListDeploymentTargetsError,
                crate::input::ListDeploymentTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code>
        /// call. It can be used to return the next set of deployment targets in the list. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code>
        /// call. It can be used to return the next set of deployment targets in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Adds a key-value pair to `targetFilters`.
        ///
        /// To override the contents of this collection use [`set_target_filters`](Self::set_target_filters).
        ///
        /// <p> A key used to filter the returned targets. The two valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be
        /// <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>,
        /// <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or
        /// <code>Unknown</code>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter
        /// string can be <code>Blue</code> or <code>Green</code>. </p>
        /// </li>
        /// </ul>
        pub fn target_filters(
            mut self,
            k: impl Into<crate::model::TargetFilterName>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.target_filters(k, v);
            self
        }
        /// <p> A key used to filter the returned targets. The two valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be
        /// <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>,
        /// <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or
        /// <code>Unknown</code>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter
        /// string can be <code>Blue</code> or <code>Green</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_target_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::TargetFilterName,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_target_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGitHubAccountTokenNames`.
    ///
    /// <p>Lists the names of stored connections to GitHub accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGitHubAccountTokenNames<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_git_hub_account_token_names_input::Builder,
    }
    impl<C, M, R> ListGitHubAccountTokenNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGitHubAccountTokenNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGitHubAccountTokenNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGitHubAccountTokenNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGitHubAccountTokenNamesInputOperationOutputAlias,
                crate::output::ListGitHubAccountTokenNamesOutput,
                crate::error::ListGitHubAccountTokenNamesError,
                crate::input::ListGitHubAccountTokenNamesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code>
        /// call. It can be used to return the next set of names in the list. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code>
        /// call. It can be used to return the next set of names in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOnPremisesInstances`.
    ///
    /// <p>Gets a list of names for one or more on-premises instances.</p>
    /// <p>Unless otherwise specified, both registered and deregistered on-premises instance
    /// names are listed. To list only registered or deregistered on-premises instance names,
    /// use the registration status parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOnPremisesInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_on_premises_instances_input::Builder,
    }
    impl<C, M, R> ListOnPremisesInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOnPremisesInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOnPremisesInstancesInputOperationOutputAlias,
                crate::output::ListOnPremisesInstancesOutput,
                crate::error::ListOnPremisesInstancesError,
                crate::input::ListOnPremisesInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The registration status of the on-premises instances:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Deregistered</code>: Include deregistered on-premises instances in the
        /// resulting list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Registered</code>: Include registered on-premises instances in the
        /// resulting list.</p>
        /// </li>
        /// </ul>
        pub fn registration_status(mut self, inp: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(inp);
            self
        }
        /// <p>The registration status of the on-premises instances:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Deregistered</code>: Include deregistered on-premises instances in the
        /// resulting list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Registered</code>: Include registered on-premises instances in the
        /// resulting list.</p>
        /// </li>
        /// </ul>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// Appends an item to `tagFilters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>The on-premises instance tags that are used to restrict the on-premises instance names
        /// returned.</p>
        pub fn tag_filters(mut self, inp: impl Into<crate::model::TagFilter>) -> Self {
            self.inner = self.inner.tag_filters(inp);
            self
        }
        /// <p>The on-premises instance tags that are used to restrict the on-premises instance names
        /// returned.</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_tag_filters(input);
            self
        }
        /// <p>An identifier returned from the previous list on-premises instances call. It can be
        /// used to return the next set of on-premises instances in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous list on-premises instances call. It can be
        /// used to return the next set of on-premises instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of tags for the resource identified by a specified Amazon Resource
    /// Name (ARN). Tags are used to organize and categorize your CodeDeploy resources. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the
        /// tags associated with the resource that is identified by the <code>ResourceArn</code>.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the
        /// tags associated with the resource that is identified by the <code>ResourceArn</code>.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can
        /// be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can
        /// be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLifecycleEventHookExecutionStatus`.
    ///
    /// <p> Sets the result of a Lambda validation function. The function validates lifecycle
    /// hooks during a deployment that uses the AWS Lambda or Amazon ECS compute platform. For
    /// AWS Lambda deployments, the available lifecycle hooks are
    /// <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS
    /// deployments, the available lifecycle hooks are <code>BeforeInstall</code>,
    /// <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>,
    /// <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda
    /// validation functions return <code>Succeeded</code> or <code>Failed</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda">AppSpec 'hooks' Section for an AWS Lambda Deployment </a> and <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs">AppSpec 'hooks' Section for an Amazon ECS Deployment</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutLifecycleEventHookExecutionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_lifecycle_event_hook_execution_status_input::Builder,
    }
    impl<C, M, R> PutLifecycleEventHookExecutionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLifecycleEventHookExecutionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLifecycleEventHookExecutionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutLifecycleEventHookExecutionStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLifecycleEventHookExecutionStatusInputOperationOutputAlias,
                crate::output::PutLifecycleEventHookExecutionStatusOutput,
                crate::error::PutLifecycleEventHookExecutionStatusError,
                crate::input::PutLifecycleEventHookExecutionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a
        /// deployment lifecycle event. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a
        /// deployment lifecycle event. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is
        /// specified in the <code>hooks</code> section of the AppSpec file. </p>
        pub fn lifecycle_event_hook_execution_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.lifecycle_event_hook_execution_id(inp);
            self
        }
        /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is
        /// specified in the <code>hooks</code> section of the AppSpec file. </p>
        pub fn set_lifecycle_event_hook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_event_hook_execution_id(input);
            self
        }
        /// <p>The result of a Lambda function that validates a deployment lifecycle event.
        /// <code>Succeeded</code> and <code>Failed</code> are the only valid values for
        /// <code>status</code>.</p>
        pub fn status(mut self, inp: crate::model::LifecycleEventStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The result of a Lambda function that validates a deployment lifecycle event.
        /// <code>Succeeded</code> and <code>Failed</code> are the only valid values for
        /// <code>status</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LifecycleEventStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterApplicationRevision`.
    ///
    /// <p>Registers with AWS CodeDeploy a revision for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterApplicationRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_application_revision_input::Builder,
    }
    impl<C, M, R> RegisterApplicationRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterApplicationRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterApplicationRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterApplicationRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterApplicationRevisionInputOperationOutputAlias,
                crate::output::RegisterApplicationRevisionOutput,
                crate::error::RegisterApplicationRevisionError,
                crate::input::RegisterApplicationRevisionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS
        /// account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A comment about the revision.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A comment about the revision.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Information about the application revision to register, including type and
        /// location.</p>
        pub fn revision(mut self, inp: crate::model::RevisionLocation) -> Self {
            self.inner = self.inner.revision(inp);
            self
        }
        /// <p>Information about the application revision to register, including type and
        /// location.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.inner = self.inner.set_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterOnPremisesInstance`.
    ///
    /// <p>Registers an on-premises instance.</p>
    /// <note>
    /// <p>Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request.
    /// You cannot use both.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RegisterOnPremisesInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_on_premises_instance_input::Builder,
    }
    impl<C, M, R> RegisterOnPremisesInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterOnPremisesInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterOnPremisesInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterOnPremisesInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterOnPremisesInstanceInputOperationOutputAlias,
                crate::output::RegisterOnPremisesInstanceOutput,
                crate::error::RegisterOnPremisesInstanceError,
                crate::input::RegisterOnPremisesInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the on-premises instance to register.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the on-premises instance to register.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
        pub fn iam_session_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_session_arn(inp);
            self
        }
        /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
        pub fn set_iam_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iam_session_arn(input);
            self
        }
        /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
        pub fn iam_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_user_arn(inp);
            self
        }
        /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromOnPremisesInstances`.
    ///
    /// <p>Removes one or more tags from one or more on-premises instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTagsFromOnPremisesInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_on_premises_instances_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromOnPremisesInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromOnPremisesInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromOnPremisesInstancesInputOperationOutputAlias,
                crate::output::RemoveTagsFromOnPremisesInstancesOutput,
                crate::error::RemoveTagsFromOnPremisesInstancesError,
                crate::input::RemoveTagsFromOnPremisesInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances from which to remove tags.</p>
        pub fn instance_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(inp);
            self
        }
        /// <p>The names of the on-premises instances from which to remove tags.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SkipWaitTimeForInstanceTermination`.
    ///
    /// <p>In a blue/green deployment, overrides any specified wait time and starts terminating
    /// instances immediately after the traffic routing is complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct SkipWaitTimeForInstanceTermination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::skip_wait_time_for_instance_termination_input::Builder,
    }
    impl<C, M, R> SkipWaitTimeForInstanceTermination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SkipWaitTimeForInstanceTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SkipWaitTimeForInstanceTerminationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SkipWaitTimeForInstanceTerminationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SkipWaitTimeForInstanceTerminationInputOperationOutputAlias,
                crate::output::SkipWaitTimeForInstanceTerminationOutput,
                crate::error::SkipWaitTimeForInstanceTerminationError,
                crate::input::SkipWaitTimeForInstanceTerminationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a blue/green deployment for which you want to skip the instance
        /// termination wait time. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a blue/green deployment for which you want to skip the instance
        /// termination wait time. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDeployment`.
    ///
    /// <p>Attempts to stop an ongoing deployment.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_deployment_input::Builder,
    }
    impl<C, M, R> StopDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopDeploymentInputOperationOutputAlias,
                crate::output::StopDeploymentOutput,
                crate::error::StopDeploymentError,
                crate::input::StopDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> Indicates, when a deployment is stopped, whether instances that have been updated
        /// should be rolled back to the previous version of the application revision. </p>
        pub fn auto_rollback_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_rollback_enabled(inp);
            self
        }
        /// <p> Indicates, when a deployment is stopped, whether instances that have been updated
        /// should be rolled back to the previous version of the application revision. </p>
        pub fn set_auto_rollback_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_rollback_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Associates the list of tags in the input <code>Tags</code> parameter with the
    /// resource identified by the <code>ResourceArn</code> input parameter. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource
        /// is identified by the <code>ResourceArn</code> input parameter. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource
        /// is identified by the <code>ResourceArn</code> input parameter. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Disassociates a resource from a list of tags. The resource is identified by the
    /// <code>ResourceArn</code> input parameter. The tags are identified by the list of
    /// keys in the <code>TagKeys</code> input parameter. </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the
        /// tags with the keys in the <code>TagKeys</code> input parameter. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the
        /// tags with the keys in the <code>TagKeys</code> input parameter. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified
        /// by the keys are disassociated from the resource specified by the
        /// <code>ResourceArn</code> input parameter. </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified
        /// by the keys are disassociated from the resource specified by the
        /// <code>ResourceArn</code> input parameter. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Changes the name of an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current name of the application you want to change.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The current name of the application you want to change.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The new name to give the application.</p>
        pub fn new_application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_application_name(inp);
            self
        }
        /// <p>The new name to give the application.</p>
        pub fn set_new_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeploymentGroup`.
    ///
    /// <p>Changes information about a deployment group.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDeploymentGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_deployment_group_input::Builder,
    }
    impl<C, M, R> UpdateDeploymentGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeploymentGroupInputOperationOutputAlias,
                crate::output::UpdateDeploymentGroupOutput,
                crate::error::UpdateDeploymentGroupError,
                crate::input::UpdateDeploymentGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application name that corresponds to the deployment group to update.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The application name that corresponds to the deployment group to update.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The current name of the deployment group.</p>
        pub fn current_deployment_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.current_deployment_group_name(inp);
            self
        }
        /// <p>The current name of the deployment group.</p>
        pub fn set_current_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_deployment_group_name(input);
            self
        }
        /// <p>The new name of the deployment group, if you want to change it.</p>
        pub fn new_deployment_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_deployment_group_name(inp);
            self
        }
        /// <p>The new name of the deployment group, if you want to change it.</p>
        pub fn set_new_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_deployment_group_name(input);
            self
        }
        /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
        pub fn deployment_config_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(inp);
            self
        }
        /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// Appends an item to `ec2TagFilters`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_filters`](Self::set_ec2_tag_filters).
        ///
        /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them.
        /// To keep the existing tags, enter their names. To remove tags, do not enter any tag
        /// names.</p>
        pub fn ec2_tag_filters(mut self, inp: impl Into<crate::model::Ec2TagFilter>) -> Self {
            self.inner = self.inner.ec2_tag_filters(inp);
            self
        }
        /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them.
        /// To keep the existing tags, enter their names. To remove tags, do not enter any tag
        /// names.</p>
        pub fn set_ec2_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_filters(input);
            self
        }
        /// Appends an item to `onPremisesInstanceTagFilters`.
        ///
        /// To override the contents of this collection use [`set_on_premises_instance_tag_filters`](Self::set_on_premises_instance_tag_filters).
        ///
        /// <p>The replacement set of on-premises instance tags on which to filter, if you want to
        /// change them. To keep the existing tags, enter their names. To remove tags, do not enter
        /// any tag names.</p>
        pub fn on_premises_instance_tag_filters(
            mut self,
            inp: impl Into<crate::model::TagFilter>,
        ) -> Self {
            self.inner = self.inner.on_premises_instance_tag_filters(inp);
            self
        }
        /// <p>The replacement set of on-premises instance tags on which to filter, if you want to
        /// change them. To keep the existing tags, enter their names. To remove tags, do not enter
        /// any tag names.</p>
        pub fn set_on_premises_instance_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_instance_tag_filters(input);
            self
        }
        /// Appends an item to `autoScalingGroups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if
        /// you want to change them. To keep the Auto Scaling groups, enter their names. To remove
        /// Auto Scaling groups, do not enter any Auto Scaling group names.</p>
        pub fn auto_scaling_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_scaling_groups(inp);
            self
        }
        /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if
        /// you want to change them. To keep the Auto Scaling groups, enter their names. To remove
        /// Auto Scaling groups, do not enter any Auto Scaling group names.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_groups(input);
            self
        }
        /// <p>A replacement ARN for the service role, if you want to change it.</p>
        pub fn service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(inp);
            self
        }
        /// <p>A replacement ARN for the service role, if you want to change it.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// Appends an item to `triggerConfigurations`.
        ///
        /// To override the contents of this collection use [`set_trigger_configurations`](Self::set_trigger_configurations).
        ///
        /// <p>Information about triggers to change when the deployment group is updated. For
        /// examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
        /// CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User
        /// Guide</i>.</p>
        pub fn trigger_configurations(
            mut self,
            inp: impl Into<crate::model::TriggerConfig>,
        ) -> Self {
            self.inner = self.inner.trigger_configurations(inp);
            self
        }
        /// <p>Information about triggers to change when the deployment group is updated. For
        /// examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
        /// CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User
        /// Guide</i>.</p>
        pub fn set_trigger_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        ) -> Self {
            self.inner = self.inner.set_trigger_configurations(input);
            self
        }
        /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group
        /// is updated.</p>
        pub fn alarm_configuration(mut self, inp: crate::model::AlarmConfiguration) -> Self {
            self.inner = self.inner.alarm_configuration(inp);
            self
        }
        /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group
        /// is updated.</p>
        pub fn set_alarm_configuration(
            mut self,
            input: std::option::Option<crate::model::AlarmConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_alarm_configuration(input);
            self
        }
        /// <p>Information for an automatic rollback configuration that is added or changed when a
        /// deployment group is updated.</p>
        pub fn auto_rollback_configuration(
            mut self,
            inp: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.inner = self.inner.auto_rollback_configuration(inp);
            self
        }
        /// <p>Information for an automatic rollback configuration that is added or changed when a
        /// deployment group is updated.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_auto_rollback_configuration(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not
        /// receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates
        /// one or more 'auto-update outdated instances' deployments to apply the deployed
        /// application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a
        /// deployment to update the new EC2 instances. This may result in instances having
        /// different revisions.</p>
        pub fn outdated_instances_strategy(
            mut self,
            inp: crate::model::OutdatedInstancesStrategy,
        ) -> Self {
            self.inner = self.inner.outdated_instances_strategy(inp);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not
        /// receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates
        /// one or more 'auto-update outdated instances' deployments to apply the deployed
        /// application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a
        /// deployment to update the new EC2 instances. This may result in instances having
        /// different revisions.</p>
        pub fn set_outdated_instances_strategy(
            mut self,
            input: std::option::Option<crate::model::OutdatedInstancesStrategy>,
        ) -> Self {
            self.inner = self.inner.set_outdated_instances_strategy(input);
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to
        /// run and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, inp: crate::model::DeploymentStyle) -> Self {
            self.inner = self.inner.deployment_style(inp);
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to
        /// run and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.inner = self.inner.set_deployment_style(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            inp: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.inner = self.inner.blue_green_deployment_configuration(inp);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_blue_green_deployment_configuration(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn load_balancer_info(mut self, inp: crate::model::LoadBalancerInfo) -> Self {
            self.inner = self.inner.load_balancer_info(inp);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_info(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment
        /// group includes only EC2 instances identified by all the tag groups.</p>
        pub fn ec2_tag_set(mut self, inp: crate::model::Ec2TagSet) -> Self {
            self.inner = self.inner.ec2_tag_set(inp);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment
        /// group includes only EC2 instances identified by all the tag groups.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_set(input);
            self
        }
        /// Appends an item to `ecsServices`.
        ///
        /// To override the contents of this collection use [`set_ecs_services`](Self::set_ecs_services).
        ///
        /// <p> The target Amazon ECS services in the deployment group. This applies only to
        /// deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
        /// is specified as an Amazon ECS cluster and service name pair using the format
        /// <code><clustername>:<servicename></code>. </p>
        pub fn ecs_services(mut self, inp: impl Into<crate::model::EcsService>) -> Self {
            self.inner = self.inner.ecs_services(inp);
            self
        }
        /// <p> The target Amazon ECS services in the deployment group. This applies only to
        /// deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
        /// is specified as an Amazon ECS cluster and service name pair using the format
        /// <code><clustername>:<servicename></code>. </p>
        pub fn set_ecs_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        ) -> Self {
            self.inner = self.inner.set_ecs_services(input);
            self
        }
        /// <p>Information about an on-premises instance tag set. The deployment group includes only
        /// on-premises instances identified by all the tag groups.</p>
        pub fn on_premises_tag_set(mut self, inp: crate::model::OnPremisesTagSet) -> Self {
            self.inner = self.inner.on_premises_tag_set(inp);
            self
        }
        /// <p>Information about an on-premises instance tag set. The deployment group includes only
        /// on-premises instances identified by all the tag groups.</p>
        pub fn set_on_premises_tag_set(
            mut self,
            input: std::option::Option<crate::model::OnPremisesTagSet>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_tag_set(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
