// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS CodeDeploy
///
/// Client for invoking operations on AWS CodeDeploy. Each operation on AWS CodeDeploy is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codedeploy::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_codedeploy::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_codedeploy::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddTagsToOnPremisesInstances`](crate::client::fluent_builders::AddTagsToOnPremisesInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToOnPremisesInstances::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToOnPremisesInstances::set_tags): <p>The tag key-value pairs to add to the on-premises instances.</p>  <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>
    ///   - [`instance_names(Vec<String>)`](crate::client::fluent_builders::AddTagsToOnPremisesInstances::instance_names) / [`set_instance_names(Option<Vec<String>>)`](crate::client::fluent_builders::AddTagsToOnPremisesInstances::set_instance_names): <p>The names of the on-premises instances to which to add tags.</p>
    /// - On success, responds with [`AddTagsToOnPremisesInstancesOutput`](crate::output::AddTagsToOnPremisesInstancesOutput)

    /// - On failure, responds with [`SdkError<AddTagsToOnPremisesInstancesError>`](crate::error::AddTagsToOnPremisesInstancesError)
    pub fn add_tags_to_on_premises_instances(
        &self,
    ) -> fluent_builders::AddTagsToOnPremisesInstances {
        fluent_builders::AddTagsToOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetApplicationRevisions`](crate::client::fluent_builders::BatchGetApplicationRevisions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::BatchGetApplicationRevisions::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::BatchGetApplicationRevisions::set_application_name): <p>The name of an AWS CodeDeploy application about which to get revision information.</p>
    ///   - [`revisions(Vec<RevisionLocation>)`](crate::client::fluent_builders::BatchGetApplicationRevisions::revisions) / [`set_revisions(Option<Vec<RevisionLocation>>)`](crate::client::fluent_builders::BatchGetApplicationRevisions::set_revisions): <p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>
    /// - On success, responds with [`BatchGetApplicationRevisionsOutput`](crate::output::BatchGetApplicationRevisionsOutput) with field(s):
    ///   - [`application_name(Option<String>)`](crate::output::BatchGetApplicationRevisionsOutput::application_name): <p>The name of the application that corresponds to the revisions.</p>
    ///   - [`error_message(Option<String>)`](crate::output::BatchGetApplicationRevisionsOutput::error_message): <p>Information about errors that might have occurred during the API call.</p>
    ///   - [`revisions(Option<Vec<RevisionInfo>>)`](crate::output::BatchGetApplicationRevisionsOutput::revisions): <p>Additional information about the revisions, including the type and location.</p>
    /// - On failure, responds with [`SdkError<BatchGetApplicationRevisionsError>`](crate::error::BatchGetApplicationRevisionsError)
    pub fn batch_get_application_revisions(&self) -> fluent_builders::BatchGetApplicationRevisions {
        fluent_builders::BatchGetApplicationRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetApplications`](crate::client::fluent_builders::BatchGetApplications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_names(Vec<String>)`](crate::client::fluent_builders::BatchGetApplications::application_names) / [`set_application_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetApplications::set_application_names): <p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>
    /// - On success, responds with [`BatchGetApplicationsOutput`](crate::output::BatchGetApplicationsOutput) with field(s):
    ///   - [`applications_info(Option<Vec<ApplicationInfo>>)`](crate::output::BatchGetApplicationsOutput::applications_info): <p>Information about the applications.</p>
    /// - On failure, responds with [`SdkError<BatchGetApplicationsError>`](crate::error::BatchGetApplicationsError)
    pub fn batch_get_applications(&self) -> fluent_builders::BatchGetApplications {
        fluent_builders::BatchGetApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetDeploymentGroups`](crate::client::fluent_builders::BatchGetDeploymentGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::BatchGetDeploymentGroups::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::BatchGetDeploymentGroups::set_application_name): <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>
    ///   - [`deployment_group_names(Vec<String>)`](crate::client::fluent_builders::BatchGetDeploymentGroups::deployment_group_names) / [`set_deployment_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetDeploymentGroups::set_deployment_group_names): <p>The names of the deployment groups.</p>
    /// - On success, responds with [`BatchGetDeploymentGroupsOutput`](crate::output::BatchGetDeploymentGroupsOutput) with field(s):
    ///   - [`deployment_groups_info(Option<Vec<DeploymentGroupInfo>>)`](crate::output::BatchGetDeploymentGroupsOutput::deployment_groups_info): <p>Information about the deployment groups.</p>
    ///   - [`error_message(Option<String>)`](crate::output::BatchGetDeploymentGroupsOutput::error_message): <p>Information about errors that might have occurred during the API call.</p>
    /// - On failure, responds with [`SdkError<BatchGetDeploymentGroupsError>`](crate::error::BatchGetDeploymentGroupsError)
    pub fn batch_get_deployment_groups(&self) -> fluent_builders::BatchGetDeploymentGroups {
        fluent_builders::BatchGetDeploymentGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetDeploymentInstances`](crate::client::fluent_builders::BatchGetDeploymentInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::BatchGetDeploymentInstances::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::BatchGetDeploymentInstances::set_deployment_id): <p> The unique ID of a deployment. </p>
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetDeploymentInstances::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetDeploymentInstances::set_instance_ids): <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>
    /// - On success, responds with [`BatchGetDeploymentInstancesOutput`](crate::output::BatchGetDeploymentInstancesOutput) with field(s):
    ///   - [`instances_summary(Option<Vec<InstanceSummary>>)`](crate::output::BatchGetDeploymentInstancesOutput::instances_summary): <p>Information about the instance.</p>
    ///   - [`error_message(Option<String>)`](crate::output::BatchGetDeploymentInstancesOutput::error_message): <p>Information about errors that might have occurred during the API call.</p>
    /// - On failure, responds with [`SdkError<BatchGetDeploymentInstancesError>`](crate::error::BatchGetDeploymentInstancesError)
    pub fn batch_get_deployment_instances(&self) -> fluent_builders::BatchGetDeploymentInstances {
        fluent_builders::BatchGetDeploymentInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetDeployments`](crate::client::fluent_builders::BatchGetDeployments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetDeployments::deployment_ids) / [`set_deployment_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetDeployments::set_deployment_ids): <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>
    /// - On success, responds with [`BatchGetDeploymentsOutput`](crate::output::BatchGetDeploymentsOutput) with field(s):
    ///   - [`deployments_info(Option<Vec<DeploymentInfo>>)`](crate::output::BatchGetDeploymentsOutput::deployments_info): <p> Information about the deployments. </p>
    /// - On failure, responds with [`SdkError<BatchGetDeploymentsError>`](crate::error::BatchGetDeploymentsError)
    pub fn batch_get_deployments(&self) -> fluent_builders::BatchGetDeployments {
        fluent_builders::BatchGetDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetDeploymentTargets`](crate::client::fluent_builders::BatchGetDeploymentTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::BatchGetDeploymentTargets::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::BatchGetDeploymentTargets::set_deployment_id): <p> The unique ID of a deployment. </p>
    ///   - [`target_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetDeploymentTargets::target_ids) / [`set_target_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetDeploymentTargets::set_target_ids): <p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>  <ul>   <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li>   <li> <p> For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li>   <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>     <clustername>      :      <servicename></servicename>     </clustername></code>. Their target type is <code>ecsTarget</code>. </p> </li>   <li> <p> For deployments that are deployed with AWS CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li>  </ul>
    /// - On success, responds with [`BatchGetDeploymentTargetsOutput`](crate::output::BatchGetDeploymentTargetsOutput) with field(s):
    ///   - [`deployment_targets(Option<Vec<DeploymentTarget>>)`](crate::output::BatchGetDeploymentTargetsOutput::deployment_targets): <p> A list of target objects for a deployment. Each target object contains details about the target, such as its status and lifecycle events. The type of the target objects depends on the deployment' compute platform. </p>  <ul>   <li> <p> <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance. </p> </li>   <li> <p> <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function. </p> </li>   <li> <p> <b>Amazon ECS</b>: The target object is an Amazon ECS service. </p> </li>   <li> <p> <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment. </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<BatchGetDeploymentTargetsError>`](crate::error::BatchGetDeploymentTargetsError)
    pub fn batch_get_deployment_targets(&self) -> fluent_builders::BatchGetDeploymentTargets {
        fluent_builders::BatchGetDeploymentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetOnPremisesInstances`](crate::client::fluent_builders::BatchGetOnPremisesInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_names(Vec<String>)`](crate::client::fluent_builders::BatchGetOnPremisesInstances::instance_names) / [`set_instance_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetOnPremisesInstances::set_instance_names): <p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>
    /// - On success, responds with [`BatchGetOnPremisesInstancesOutput`](crate::output::BatchGetOnPremisesInstancesOutput) with field(s):
    ///   - [`instance_infos(Option<Vec<InstanceInfo>>)`](crate::output::BatchGetOnPremisesInstancesOutput::instance_infos): <p>Information about the on-premises instances.</p>
    /// - On failure, responds with [`SdkError<BatchGetOnPremisesInstancesError>`](crate::error::BatchGetOnPremisesInstancesError)
    pub fn batch_get_on_premises_instances(&self) -> fluent_builders::BatchGetOnPremisesInstances {
        fluent_builders::BatchGetOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ContinueDeployment`](crate::client::fluent_builders::ContinueDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::ContinueDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::ContinueDeployment::set_deployment_id): <p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>
    ///   - [`deployment_wait_type(DeploymentWaitType)`](crate::client::fluent_builders::ContinueDeployment::deployment_wait_type) / [`set_deployment_wait_type(Option<DeploymentWaitType>)`](crate::client::fluent_builders::ContinueDeployment::set_deployment_wait_type): <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>
    /// - On success, responds with [`ContinueDeploymentOutput`](crate::output::ContinueDeploymentOutput)

    /// - On failure, responds with [`SdkError<ContinueDeploymentError>`](crate::error::ContinueDeploymentError)
    pub fn continue_deployment(&self) -> fluent_builders::ContinueDeployment {
        fluent_builders::ContinueDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_application_name): <p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>
    ///   - [`compute_platform(ComputePlatform)`](crate::client::fluent_builders::CreateApplication::compute_platform) / [`set_compute_platform(Option<ComputePlatform>)`](crate::client::fluent_builders::CreateApplication::set_compute_platform): <p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateApplicationOutput::application_id): <p>A unique application ID.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    ///   - [`deployment_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::deployment_group_name) / [`set_deployment_group_name(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_deployment_group_name): <p>The name of the deployment group.</p>
    ///   - [`revision(RevisionLocation)`](crate::client::fluent_builders::CreateDeployment::revision) / [`set_revision(Option<RevisionLocation>)`](crate::client::fluent_builders::CreateDeployment::set_revision): <p> The type and location of the revision to deploy. </p>
    ///   - [`deployment_config_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::deployment_config_name) / [`set_deployment_config_name(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_deployment_config_name): <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>  <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_description): <p>A comment about the deployment.</p>
    ///   - [`ignore_application_stop_failures(bool)`](crate::client::fluent_builders::CreateDeployment::ignore_application_stop_failures) / [`set_ignore_application_stop_failures(bool)`](crate::client::fluent_builders::CreateDeployment::set_ignore_application_stop_failures): <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>  <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>  <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>  <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
    ///   - [`target_instances(TargetInstances)`](crate::client::fluent_builders::CreateDeployment::target_instances) / [`set_target_instances(Option<TargetInstances>)`](crate::client::fluent_builders::CreateDeployment::set_target_instances): <p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>
    ///   - [`auto_rollback_configuration(AutoRollbackConfiguration)`](crate::client::fluent_builders::CreateDeployment::auto_rollback_configuration) / [`set_auto_rollback_configuration(Option<AutoRollbackConfiguration>)`](crate::client::fluent_builders::CreateDeployment::set_auto_rollback_configuration): <p>Configuration information for an automatic rollback that is added when a deployment is created.</p>
    ///   - [`update_outdated_instances_only(bool)`](crate::client::fluent_builders::CreateDeployment::update_outdated_instances_only) / [`set_update_outdated_instances_only(bool)`](crate::client::fluent_builders::CreateDeployment::set_update_outdated_instances_only): <p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>
    ///   - [`file_exists_behavior(FileExistsBehavior)`](crate::client::fluent_builders::CreateDeployment::file_exists_behavior) / [`set_file_exists_behavior(Option<FileExistsBehavior>)`](crate::client::fluent_builders::CreateDeployment::set_file_exists_behavior): <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>  <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p>  <ul>   <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li>   <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>   <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>  </ul>
    /// - On success, responds with [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput) with field(s):
    ///   - [`deployment_id(Option<String>)`](crate::output::CreateDeploymentOutput::deployment_id): <p> The unique ID of a deployment. </p>
    /// - On failure, responds with [`SdkError<CreateDeploymentError>`](crate::error::CreateDeploymentError)
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeploymentConfig`](crate::client::fluent_builders::CreateDeploymentConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_config_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeploymentConfig::deployment_config_name) / [`set_deployment_config_name(Option<String>)`](crate::client::fluent_builders::CreateDeploymentConfig::set_deployment_config_name): <p>The name of the deployment configuration to create.</p>
    ///   - [`minimum_healthy_hosts(MinimumHealthyHosts)`](crate::client::fluent_builders::CreateDeploymentConfig::minimum_healthy_hosts) / [`set_minimum_healthy_hosts(Option<MinimumHealthyHosts>)`](crate::client::fluent_builders::CreateDeploymentConfig::set_minimum_healthy_hosts): <p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p>  <p>The type parameter takes either of the following values:</p>  <ul>   <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li>   <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li>  </ul>  <p>The value parameter takes an integer.</p>  <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>
    ///   - [`traffic_routing_config(TrafficRoutingConfig)`](crate::client::fluent_builders::CreateDeploymentConfig::traffic_routing_config) / [`set_traffic_routing_config(Option<TrafficRoutingConfig>)`](crate::client::fluent_builders::CreateDeploymentConfig::set_traffic_routing_config): <p>The configuration that specifies how the deployment traffic is routed.</p>
    ///   - [`compute_platform(ComputePlatform)`](crate::client::fluent_builders::CreateDeploymentConfig::compute_platform) / [`set_compute_platform(Option<ComputePlatform>)`](crate::client::fluent_builders::CreateDeploymentConfig::set_compute_platform): <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
    /// - On success, responds with [`CreateDeploymentConfigOutput`](crate::output::CreateDeploymentConfigOutput) with field(s):
    ///   - [`deployment_config_id(Option<String>)`](crate::output::CreateDeploymentConfigOutput::deployment_config_id): <p>A unique deployment configuration ID.</p>
    /// - On failure, responds with [`SdkError<CreateDeploymentConfigError>`](crate::error::CreateDeploymentConfigError)
    pub fn create_deployment_config(&self) -> fluent_builders::CreateDeploymentConfig {
        fluent_builders::CreateDeploymentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeploymentGroup`](crate::client::fluent_builders::CreateDeploymentGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    ///   - [`deployment_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::deployment_group_name) / [`set_deployment_group_name(Option<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_deployment_group_name): <p>The name of a new deployment group for the specified application.</p>
    ///   - [`deployment_config_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::deployment_config_name) / [`set_deployment_config_name(Option<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_deployment_config_name): <p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p>  <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.</p>  <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    ///   - [`ec2_tag_filters(Vec<Ec2TagFilter>)`](crate::client::fluent_builders::CreateDeploymentGroup::ec2_tag_filters) / [`set_ec2_tag_filters(Option<Vec<Ec2TagFilter>>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_ec2_tag_filters): <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
    ///   - [`on_premises_instance_tag_filters(Vec<TagFilter>)`](crate::client::fluent_builders::CreateDeploymentGroup::on_premises_instance_tag_filters) / [`set_on_premises_instance_tag_filters(Option<Vec<TagFilter>>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_on_premises_instance_tag_filters): <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>
    ///   - [`auto_scaling_groups(Vec<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::auto_scaling_groups) / [`set_auto_scaling_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_auto_scaling_groups): <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
    ///   - [`service_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::service_role_arn) / [`set_service_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_service_role_arn): <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.</p>
    ///   - [`trigger_configurations(Vec<TriggerConfig>)`](crate::client::fluent_builders::CreateDeploymentGroup::trigger_configurations) / [`set_trigger_configurations(Option<Vec<TriggerConfig>>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_trigger_configurations): <p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    ///   - [`alarm_configuration(AlarmConfiguration)`](crate::client::fluent_builders::CreateDeploymentGroup::alarm_configuration) / [`set_alarm_configuration(Option<AlarmConfiguration>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_alarm_configuration): <p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>
    ///   - [`auto_rollback_configuration(AutoRollbackConfiguration)`](crate::client::fluent_builders::CreateDeploymentGroup::auto_rollback_configuration) / [`set_auto_rollback_configuration(Option<AutoRollbackConfiguration>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_auto_rollback_configuration): <p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>
    ///   - [`outdated_instances_strategy(OutdatedInstancesStrategy)`](crate::client::fluent_builders::CreateDeploymentGroup::outdated_instances_strategy) / [`set_outdated_instances_strategy(Option<OutdatedInstancesStrategy>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_outdated_instances_strategy): <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>  <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>  <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    ///   - [`deployment_style(DeploymentStyle)`](crate::client::fluent_builders::CreateDeploymentGroup::deployment_style) / [`set_deployment_style(Option<DeploymentStyle>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_deployment_style): <p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>
    ///   - [`blue_green_deployment_configuration(BlueGreenDeploymentConfiguration)`](crate::client::fluent_builders::CreateDeploymentGroup::blue_green_deployment_configuration) / [`set_blue_green_deployment_configuration(Option<BlueGreenDeploymentConfiguration>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_blue_green_deployment_configuration): <p>Information about blue/green deployment options for a deployment group.</p>
    ///   - [`load_balancer_info(LoadBalancerInfo)`](crate::client::fluent_builders::CreateDeploymentGroup::load_balancer_info) / [`set_load_balancer_info(Option<LoadBalancerInfo>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_load_balancer_info): <p>Information about the load balancer used in a deployment.</p>
    ///   - [`ec2_tag_set(Ec2TagSet)`](crate::client::fluent_builders::CreateDeploymentGroup::ec2_tag_set) / [`set_ec2_tag_set(Option<Ec2TagSet>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_ec2_tag_set): <p>Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>
    ///   - [`ecs_services(Vec<EcsService>)`](crate::client::fluent_builders::CreateDeploymentGroup::ecs_services) / [`set_ecs_services(Option<Vec<EcsService>>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_ecs_services): <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>   <clustername>    :    <servicename></servicename>   </clustername></code>. </p>
    ///   - [`on_premises_tag_set(OnPremisesTagSet)`](crate::client::fluent_builders::CreateDeploymentGroup::on_premises_tag_set) / [`set_on_premises_tag_set(Option<OnPremisesTagSet>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_on_premises_tag_set): <p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDeploymentGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDeploymentGroup::set_tags): <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
    /// - On success, responds with [`CreateDeploymentGroupOutput`](crate::output::CreateDeploymentGroupOutput) with field(s):
    ///   - [`deployment_group_id(Option<String>)`](crate::output::CreateDeploymentGroupOutput::deployment_group_id): <p>A unique deployment group ID.</p>
    /// - On failure, responds with [`SdkError<CreateDeploymentGroupError>`](crate::error::CreateDeploymentGroupError)
    pub fn create_deployment_group(&self) -> fluent_builders::CreateDeploymentGroup {
        fluent_builders::CreateDeploymentGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDeploymentConfig`](crate::client::fluent_builders::DeleteDeploymentConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_config_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDeploymentConfig::deployment_config_name) / [`set_deployment_config_name(Option<String>)`](crate::client::fluent_builders::DeleteDeploymentConfig::set_deployment_config_name): <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    /// - On success, responds with [`DeleteDeploymentConfigOutput`](crate::output::DeleteDeploymentConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteDeploymentConfigError>`](crate::error::DeleteDeploymentConfigError)
    pub fn delete_deployment_config(&self) -> fluent_builders::DeleteDeploymentConfig {
        fluent_builders::DeleteDeploymentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDeploymentGroup`](crate::client::fluent_builders::DeleteDeploymentGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDeploymentGroup::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteDeploymentGroup::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    ///   - [`deployment_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDeploymentGroup::deployment_group_name) / [`set_deployment_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDeploymentGroup::set_deployment_group_name): <p>The name of a deployment group for the specified application.</p>
    /// - On success, responds with [`DeleteDeploymentGroupOutput`](crate::output::DeleteDeploymentGroupOutput) with field(s):
    ///   - [`hooks_not_cleaned_up(Option<Vec<AutoScalingGroup>>)`](crate::output::DeleteDeploymentGroupOutput::hooks_not_cleaned_up): <p>If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.</p>
    /// - On failure, responds with [`SdkError<DeleteDeploymentGroupError>`](crate::error::DeleteDeploymentGroupError)
    pub fn delete_deployment_group(&self) -> fluent_builders::DeleteDeploymentGroup {
        fluent_builders::DeleteDeploymentGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGitHubAccountToken`](crate::client::fluent_builders::DeleteGitHubAccountToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`token_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGitHubAccountToken::token_name) / [`set_token_name(Option<String>)`](crate::client::fluent_builders::DeleteGitHubAccountToken::set_token_name): <p>The name of the GitHub account connection to delete.</p>
    /// - On success, responds with [`DeleteGitHubAccountTokenOutput`](crate::output::DeleteGitHubAccountTokenOutput) with field(s):
    ///   - [`token_name(Option<String>)`](crate::output::DeleteGitHubAccountTokenOutput::token_name): <p>The name of the GitHub account connection that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteGitHubAccountTokenError>`](crate::error::DeleteGitHubAccountTokenError)
    pub fn delete_git_hub_account_token(&self) -> fluent_builders::DeleteGitHubAccountToken {
        fluent_builders::DeleteGitHubAccountToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcesByExternalId`](crate::client::fluent_builders::DeleteResourcesByExternalId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcesByExternalId::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::DeleteResourcesByExternalId::set_external_id): <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>
    /// - On success, responds with [`DeleteResourcesByExternalIdOutput`](crate::output::DeleteResourcesByExternalIdOutput)

    /// - On failure, responds with [`SdkError<DeleteResourcesByExternalIdError>`](crate::error::DeleteResourcesByExternalIdError)
    pub fn delete_resources_by_external_id(&self) -> fluent_builders::DeleteResourcesByExternalId {
        fluent_builders::DeleteResourcesByExternalId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterOnPremisesInstance`](crate::client::fluent_builders::DeregisterOnPremisesInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_name(impl Into<String>)`](crate::client::fluent_builders::DeregisterOnPremisesInstance::instance_name) / [`set_instance_name(Option<String>)`](crate::client::fluent_builders::DeregisterOnPremisesInstance::set_instance_name): <p>The name of the on-premises instance to deregister.</p>
    /// - On success, responds with [`DeregisterOnPremisesInstanceOutput`](crate::output::DeregisterOnPremisesInstanceOutput)

    /// - On failure, responds with [`SdkError<DeregisterOnPremisesInstanceError>`](crate::error::DeregisterOnPremisesInstanceError)
    pub fn deregister_on_premises_instance(&self) -> fluent_builders::DeregisterOnPremisesInstance {
        fluent_builders::DeregisterOnPremisesInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplication`](crate::client::fluent_builders::GetApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::GetApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::GetApplication::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    /// - On success, responds with [`GetApplicationOutput`](crate::output::GetApplicationOutput) with field(s):
    ///   - [`application(Option<ApplicationInfo>)`](crate::output::GetApplicationOutput::application): <p>Information about the application.</p>
    /// - On failure, responds with [`SdkError<GetApplicationError>`](crate::error::GetApplicationError)
    pub fn get_application(&self) -> fluent_builders::GetApplication {
        fluent_builders::GetApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplicationRevision`](crate::client::fluent_builders::GetApplicationRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::GetApplicationRevision::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::GetApplicationRevision::set_application_name): <p>The name of the application that corresponds to the revision.</p>
    ///   - [`revision(RevisionLocation)`](crate::client::fluent_builders::GetApplicationRevision::revision) / [`set_revision(Option<RevisionLocation>)`](crate::client::fluent_builders::GetApplicationRevision::set_revision): <p>Information about the application revision to get, including type and location.</p>
    /// - On success, responds with [`GetApplicationRevisionOutput`](crate::output::GetApplicationRevisionOutput) with field(s):
    ///   - [`application_name(Option<String>)`](crate::output::GetApplicationRevisionOutput::application_name): <p>The name of the application that corresponds to the revision.</p>
    ///   - [`revision(Option<RevisionLocation>)`](crate::output::GetApplicationRevisionOutput::revision): <p>Additional information about the revision, including type and location.</p>
    ///   - [`revision_info(Option<GenericRevisionInfo>)`](crate::output::GetApplicationRevisionOutput::revision_info): <p>General information about the revision.</p>
    /// - On failure, responds with [`SdkError<GetApplicationRevisionError>`](crate::error::GetApplicationRevisionError)
    pub fn get_application_revision(&self) -> fluent_builders::GetApplicationRevision {
        fluent_builders::GetApplicationRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployment`](crate::client::fluent_builders::GetDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_deployment_id): <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
    /// - On success, responds with [`GetDeploymentOutput`](crate::output::GetDeploymentOutput) with field(s):
    ///   - [`deployment_info(Option<DeploymentInfo>)`](crate::output::GetDeploymentOutput::deployment_info): <p>Information about the deployment.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentError>`](crate::error::GetDeploymentError)
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeploymentConfig`](crate::client::fluent_builders::GetDeploymentConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_config_name(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentConfig::deployment_config_name) / [`set_deployment_config_name(Option<String>)`](crate::client::fluent_builders::GetDeploymentConfig::set_deployment_config_name): <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
    /// - On success, responds with [`GetDeploymentConfigOutput`](crate::output::GetDeploymentConfigOutput) with field(s):
    ///   - [`deployment_config_info(Option<DeploymentConfigInfo>)`](crate::output::GetDeploymentConfigOutput::deployment_config_info): <p>Information about the deployment configuration.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentConfigError>`](crate::error::GetDeploymentConfigError)
    pub fn get_deployment_config(&self) -> fluent_builders::GetDeploymentConfig {
        fluent_builders::GetDeploymentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeploymentGroup`](crate::client::fluent_builders::GetDeploymentGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentGroup::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::GetDeploymentGroup::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    ///   - [`deployment_group_name(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentGroup::deployment_group_name) / [`set_deployment_group_name(Option<String>)`](crate::client::fluent_builders::GetDeploymentGroup::set_deployment_group_name): <p>The name of a deployment group for the specified application.</p>
    /// - On success, responds with [`GetDeploymentGroupOutput`](crate::output::GetDeploymentGroupOutput) with field(s):
    ///   - [`deployment_group_info(Option<DeploymentGroupInfo>)`](crate::output::GetDeploymentGroupOutput::deployment_group_info): <p>Information about the deployment group.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentGroupError>`](crate::error::GetDeploymentGroupError)
    pub fn get_deployment_group(&self) -> fluent_builders::GetDeploymentGroup {
        fluent_builders::GetDeploymentGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeploymentInstance`](crate::client::fluent_builders::GetDeploymentInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentInstance::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetDeploymentInstance::set_deployment_id): <p> The unique ID of a deployment. </p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetDeploymentInstance::set_instance_id): <p> The unique ID of an instance in the deployment group. </p>
    /// - On success, responds with [`GetDeploymentInstanceOutput`](crate::output::GetDeploymentInstanceOutput) with field(s):
    ///   - [`instance_summary(Option<InstanceSummary>)`](crate::output::GetDeploymentInstanceOutput::instance_summary): <p> Information about the instance. </p>
    /// - On failure, responds with [`SdkError<GetDeploymentInstanceError>`](crate::error::GetDeploymentInstanceError)
    pub fn get_deployment_instance(&self) -> fluent_builders::GetDeploymentInstance {
        fluent_builders::GetDeploymentInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeploymentTarget`](crate::client::fluent_builders::GetDeploymentTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentTarget::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetDeploymentTarget::set_deployment_id): <p> The unique ID of a deployment. </p>
    ///   - [`target_id(impl Into<String>)`](crate::client::fluent_builders::GetDeploymentTarget::target_id) / [`set_target_id(Option<String>)`](crate::client::fluent_builders::GetDeploymentTarget::set_target_id): <p> The unique ID of a deployment target. </p>
    /// - On success, responds with [`GetDeploymentTargetOutput`](crate::output::GetDeploymentTargetOutput) with field(s):
    ///   - [`deployment_target(Option<DeploymentTarget>)`](crate::output::GetDeploymentTargetOutput::deployment_target): <p> A deployment target that contains information about a deployment such as its status, lifecycle events, and when it was last updated. It also contains metadata about the deployment target. The deployment target metadata depends on the deployment target's type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or <code>ecsTarget</code>). </p>
    /// - On failure, responds with [`SdkError<GetDeploymentTargetError>`](crate::error::GetDeploymentTargetError)
    pub fn get_deployment_target(&self) -> fluent_builders::GetDeploymentTarget {
        fluent_builders::GetDeploymentTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOnPremisesInstance`](crate::client::fluent_builders::GetOnPremisesInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_name(impl Into<String>)`](crate::client::fluent_builders::GetOnPremisesInstance::instance_name) / [`set_instance_name(Option<String>)`](crate::client::fluent_builders::GetOnPremisesInstance::set_instance_name): <p> The name of the on-premises instance about which to get information. </p>
    /// - On success, responds with [`GetOnPremisesInstanceOutput`](crate::output::GetOnPremisesInstanceOutput) with field(s):
    ///   - [`instance_info(Option<InstanceInfo>)`](crate::output::GetOnPremisesInstanceOutput::instance_info): <p> Information about the on-premises instance. </p>
    /// - On failure, responds with [`SdkError<GetOnPremisesInstanceError>`](crate::error::GetOnPremisesInstanceError)
    pub fn get_on_premises_instance(&self) -> fluent_builders::GetOnPremisesInstance {
        fluent_builders::GetOnPremisesInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplicationRevisions`](crate::client::fluent_builders::ListApplicationRevisions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplicationRevisions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::ListApplicationRevisions::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::ListApplicationRevisions::set_application_name): <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS account. </p>
    ///   - [`sort_by(ApplicationRevisionSortBy)`](crate::client::fluent_builders::ListApplicationRevisions::sort_by) / [`set_sort_by(Option<ApplicationRevisionSortBy>)`](crate::client::fluent_builders::ListApplicationRevisions::set_sort_by): <p>The column name to use to sort the list results:</p>  <ul>   <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li>   <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li>   <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li>  </ul>  <p> If not specified or set to null, the results are returned in an arbitrary order. </p>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::ListApplicationRevisions::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::ListApplicationRevisions::set_sort_order): <p> The order in which to sort the list results: </p>  <ul>   <li> <p> <code>ascending</code>: ascending order.</p> </li>   <li> <p> <code>descending</code>: descending order.</p> </li>  </ul>  <p>If not specified, the results are sorted in ascending order.</p>  <p>If set to null, the results are sorted in an arbitrary order.</p>
    ///   - [`s3_bucket(impl Into<String>)`](crate::client::fluent_builders::ListApplicationRevisions::s3_bucket) / [`set_s3_bucket(Option<String>)`](crate::client::fluent_builders::ListApplicationRevisions::set_s3_bucket): <p> An Amazon S3 bucket name to limit the search for revisions. </p>  <p> If set to null, all of the user's buckets are searched. </p>
    ///   - [`s3_key_prefix(impl Into<String>)`](crate::client::fluent_builders::ListApplicationRevisions::s3_key_prefix) / [`set_s3_key_prefix(Option<String>)`](crate::client::fluent_builders::ListApplicationRevisions::set_s3_key_prefix): <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>
    ///   - [`deployed(ListStateFilterAction)`](crate::client::fluent_builders::ListApplicationRevisions::deployed) / [`set_deployed(Option<ListStateFilterAction>)`](crate::client::fluent_builders::ListApplicationRevisions::set_deployed): <p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p>  <ul>   <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li>   <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li>   <li> <p> <code>ignore</code>: List all revisions.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplicationRevisions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplicationRevisions::set_next_token): <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>
    /// - On success, responds with [`ListApplicationRevisionsOutput`](crate::output::ListApplicationRevisionsOutput) with field(s):
    ///   - [`revisions(Option<Vec<RevisionLocation>>)`](crate::output::ListApplicationRevisionsOutput::revisions): <p>A list of locations that contain the matching revisions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationRevisionsOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list application revisions call to return the next set of application revisions in the list.</p>
    /// - On failure, responds with [`SdkError<ListApplicationRevisionsError>`](crate::error::ListApplicationRevisionsError)
    pub fn list_application_revisions(&self) -> fluent_builders::ListApplicationRevisions {
        fluent_builders::ListApplicationRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplications`](crate::client::fluent_builders::ListApplications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplications::set_next_token): <p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>
    /// - On success, responds with [`ListApplicationsOutput`](crate::output::ListApplicationsOutput) with field(s):
    ///   - [`applications(Option<Vec<String>>)`](crate::output::ListApplicationsOutput::applications): <p>A list of application names.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationsOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list applications call to return the next set of applications in the list.</p>
    /// - On failure, responds with [`SdkError<ListApplicationsError>`](crate::error::ListApplicationsError)
    pub fn list_applications(&self) -> fluent_builders::ListApplications {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeploymentConfigs`](crate::client::fluent_builders::ListDeploymentConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeploymentConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeploymentConfigs::set_next_token): <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>
    /// - On success, responds with [`ListDeploymentConfigsOutput`](crate::output::ListDeploymentConfigsOutput) with field(s):
    ///   - [`deployment_configs_list(Option<Vec<String>>)`](crate::output::ListDeploymentConfigsOutput::deployment_configs_list): <p>A list of deployment configurations, including built-in configurations such as <code>CodeDeployDefault.OneAtATime</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentConfigsOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment configurations call to return the next set of deployment configurations in the list.</p>
    /// - On failure, responds with [`SdkError<ListDeploymentConfigsError>`](crate::error::ListDeploymentConfigsError)
    pub fn list_deployment_configs(&self) -> fluent_builders::ListDeploymentConfigs {
        fluent_builders::ListDeploymentConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeploymentGroups`](crate::client::fluent_builders::ListDeploymentGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeploymentGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentGroups::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::ListDeploymentGroups::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeploymentGroups::set_next_token): <p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>
    /// - On success, responds with [`ListDeploymentGroupsOutput`](crate::output::ListDeploymentGroupsOutput) with field(s):
    ///   - [`application_name(Option<String>)`](crate::output::ListDeploymentGroupsOutput::application_name): <p>The application name.</p>
    ///   - [`deployment_groups(Option<Vec<String>>)`](crate::output::ListDeploymentGroupsOutput::deployment_groups): <p>A list of deployment group names.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentGroupsOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment groups call to return the next set of deployment groups in the list.</p>
    /// - On failure, responds with [`SdkError<ListDeploymentGroupsError>`](crate::error::ListDeploymentGroupsError)
    pub fn list_deployment_groups(&self) -> fluent_builders::ListDeploymentGroups {
        fluent_builders::ListDeploymentGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeploymentInstances`](crate::client::fluent_builders::ListDeploymentInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeploymentInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentInstances::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::ListDeploymentInstances::set_deployment_id): <p> The unique ID of a deployment. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeploymentInstances::set_next_token): <p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>
    ///   - [`instance_status_filter(Vec<InstanceStatus>)`](crate::client::fluent_builders::ListDeploymentInstances::instance_status_filter) / [`set_instance_status_filter(Option<Vec<InstanceStatus>>)`](crate::client::fluent_builders::ListDeploymentInstances::set_instance_status_filter): <p>A subset of instances to list by status:</p>  <ul>   <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li>   <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li>   <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li>   <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li>   <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li>   <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li>  </ul>
    ///   - [`instance_type_filter(Vec<InstanceType>)`](crate::client::fluent_builders::ListDeploymentInstances::instance_type_filter) / [`set_instance_type_filter(Option<Vec<InstanceType>>)`](crate::client::fluent_builders::ListDeploymentInstances::set_instance_type_filter): <p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>
    /// - On success, responds with [`ListDeploymentInstancesOutput`](crate::output::ListDeploymentInstancesOutput) with field(s):
    ///   - [`instances_list(Option<Vec<String>>)`](crate::output::ListDeploymentInstancesOutput::instances_list): <p>A list of instance IDs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentInstancesOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment instances call to return the next set of deployment instances in the list.</p>
    /// - On failure, responds with [`SdkError<ListDeploymentInstancesError>`](crate::error::ListDeploymentInstancesError)
    pub fn list_deployment_instances(&self) -> fluent_builders::ListDeploymentInstances {
        fluent_builders::ListDeploymentInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeployments`](crate::client::fluent_builders::ListDeployments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeployments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>   <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p>  </note>
    ///   - [`deployment_group_name(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::deployment_group_name) / [`set_deployment_group_name(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_deployment_group_name): <p>The name of a deployment group for the specified application.</p> <note>   <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p>  </note>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_external_id): <p>The unique ID of an external resource for returning deployments linked to the external resource.</p>
    ///   - [`include_only_statuses(Vec<DeploymentStatus>)`](crate::client::fluent_builders::ListDeployments::include_only_statuses) / [`set_include_only_statuses(Option<Vec<DeploymentStatus>>)`](crate::client::fluent_builders::ListDeployments::set_include_only_statuses): <p>A subset of deployments to list by status:</p>  <ul>   <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li>   <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li>   <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li>   <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li>   <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li>   <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li>  </ul>
    ///   - [`create_time_range(TimeRange)`](crate::client::fluent_builders::ListDeployments::create_time_range) / [`set_create_time_range(Option<TimeRange>)`](crate::client::fluent_builders::ListDeployments::set_create_time_range): <p>A time range (start and end) for returning a subset of the list of deployments.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_next_token): <p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>
    /// - On success, responds with [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput) with field(s):
    ///   - [`deployments(Option<Vec<String>>)`](crate::output::ListDeploymentsOutput::deployments): <p>A list of deployment IDs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentsOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployments call to return the next set of deployments in the list.</p>
    /// - On failure, responds with [`SdkError<ListDeploymentsError>`](crate::error::ListDeploymentsError)
    pub fn list_deployments(&self) -> fluent_builders::ListDeployments {
        fluent_builders::ListDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeploymentTargets`](crate::client::fluent_builders::ListDeploymentTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentTargets::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::ListDeploymentTargets::set_deployment_id): <p> The unique ID of a deployment. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeploymentTargets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeploymentTargets::set_next_token): <p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>
    ///   - [`target_filters(HashMap<TargetFilterName, Vec<String>>)`](crate::client::fluent_builders::ListDeploymentTargets::target_filters) / [`set_target_filters(Option<HashMap<TargetFilterName, Vec<String>>>)`](crate::client::fluent_builders::ListDeploymentTargets::set_target_filters): <p> A key used to filter the returned targets. The two valid values are:</p>  <ul>   <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li>   <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li>  </ul>
    /// - On success, responds with [`ListDeploymentTargetsOutput`](crate::output::ListDeploymentTargetsOutput) with field(s):
    ///   - [`target_ids(Option<Vec<String>>)`](crate::output::ListDeploymentTargetsOutput::target_ids): <p> The unique IDs of deployment targets. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentTargetsOutput::next_token): <p> If a large amount of information is returned, a token identifier is also returned. It can be used in a subsequent <code>ListDeploymentTargets</code> call to return the next set of deployment targets in the list. </p>
    /// - On failure, responds with [`SdkError<ListDeploymentTargetsError>`](crate::error::ListDeploymentTargetsError)
    pub fn list_deployment_targets(&self) -> fluent_builders::ListDeploymentTargets {
        fluent_builders::ListDeploymentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGitHubAccountTokenNames`](crate::client::fluent_builders::ListGitHubAccountTokenNames) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGitHubAccountTokenNames::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGitHubAccountTokenNames::set_next_token): <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>
    /// - On success, responds with [`ListGitHubAccountTokenNamesOutput`](crate::output::ListGitHubAccountTokenNamesOutput) with field(s):
    ///   - [`token_name_list(Option<Vec<String>>)`](crate::output::ListGitHubAccountTokenNamesOutput::token_name_list): <p>A list of names of connections to GitHub accounts.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGitHubAccountTokenNamesOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent <code>ListGitHubAccountTokenNames</code> call to return the next set of names in the list. </p>
    /// - On failure, responds with [`SdkError<ListGitHubAccountTokenNamesError>`](crate::error::ListGitHubAccountTokenNamesError)
    pub fn list_git_hub_account_token_names(&self) -> fluent_builders::ListGitHubAccountTokenNames {
        fluent_builders::ListGitHubAccountTokenNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOnPremisesInstances`](crate::client::fluent_builders::ListOnPremisesInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registration_status(RegistrationStatus)`](crate::client::fluent_builders::ListOnPremisesInstances::registration_status) / [`set_registration_status(Option<RegistrationStatus>)`](crate::client::fluent_builders::ListOnPremisesInstances::set_registration_status): <p>The registration status of the on-premises instances:</p>  <ul>   <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li>   <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li>  </ul>
    ///   - [`tag_filters(Vec<TagFilter>)`](crate::client::fluent_builders::ListOnPremisesInstances::tag_filters) / [`set_tag_filters(Option<Vec<TagFilter>>)`](crate::client::fluent_builders::ListOnPremisesInstances::set_tag_filters): <p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOnPremisesInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOnPremisesInstances::set_next_token): <p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>
    /// - On success, responds with [`ListOnPremisesInstancesOutput`](crate::output::ListOnPremisesInstancesOutput) with field(s):
    ///   - [`instance_names(Option<Vec<String>>)`](crate::output::ListOnPremisesInstancesOutput::instance_names): <p>The list of matching on-premises instance names.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOnPremisesInstancesOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list on-premises instances call to return the next set of on-premises instances in the list.</p>
    /// - On failure, responds with [`SdkError<ListOnPremisesInstancesError>`](crate::error::ListOnPremisesInstancesError)
    pub fn list_on_premises_instances(&self) -> fluent_builders::ListOnPremisesInstances {
        fluent_builders::ListOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p> A list of tags returned by <code>ListTagsForResource</code>. The tags are associated with the resource identified by the input <code>ResourceArn</code> parameter. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list application revisions call to return the next set of application revisions in the list.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLifecycleEventHookExecutionStatus`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus::set_deployment_id): <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>
    ///   - [`lifecycle_event_hook_execution_id(impl Into<String>)`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus::lifecycle_event_hook_execution_id) / [`set_lifecycle_event_hook_execution_id(Option<String>)`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus::set_lifecycle_event_hook_execution_id): <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>
    ///   - [`status(LifecycleEventStatus)`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus::status) / [`set_status(Option<LifecycleEventStatus>)`](crate::client::fluent_builders::PutLifecycleEventHookExecutionStatus::set_status): <p>The result of a Lambda function that validates a deployment lifecycle event. <code>Succeeded</code> and <code>Failed</code> are the only valid values for <code>status</code>.</p>
    /// - On success, responds with [`PutLifecycleEventHookExecutionStatusOutput`](crate::output::PutLifecycleEventHookExecutionStatusOutput) with field(s):
    ///   - [`lifecycle_event_hook_execution_id(Option<String>)`](crate::output::PutLifecycleEventHookExecutionStatusOutput::lifecycle_event_hook_execution_id): <p>The execution ID of the lifecycle event hook. A hook is specified in the <code>hooks</code> section of the deployment's AppSpec file.</p>
    /// - On failure, responds with [`SdkError<PutLifecycleEventHookExecutionStatusError>`](crate::error::PutLifecycleEventHookExecutionStatusError)
    pub fn put_lifecycle_event_hook_execution_status(
        &self,
    ) -> fluent_builders::PutLifecycleEventHookExecutionStatus {
        fluent_builders::PutLifecycleEventHookExecutionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterApplicationRevision`](crate::client::fluent_builders::RegisterApplicationRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::RegisterApplicationRevision::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::RegisterApplicationRevision::set_application_name): <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::RegisterApplicationRevision::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::RegisterApplicationRevision::set_description): <p>A comment about the revision.</p>
    ///   - [`revision(RevisionLocation)`](crate::client::fluent_builders::RegisterApplicationRevision::revision) / [`set_revision(Option<RevisionLocation>)`](crate::client::fluent_builders::RegisterApplicationRevision::set_revision): <p>Information about the application revision to register, including type and location.</p>
    /// - On success, responds with [`RegisterApplicationRevisionOutput`](crate::output::RegisterApplicationRevisionOutput)

    /// - On failure, responds with [`SdkError<RegisterApplicationRevisionError>`](crate::error::RegisterApplicationRevisionError)
    pub fn register_application_revision(&self) -> fluent_builders::RegisterApplicationRevision {
        fluent_builders::RegisterApplicationRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterOnPremisesInstance`](crate::client::fluent_builders::RegisterOnPremisesInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_name(impl Into<String>)`](crate::client::fluent_builders::RegisterOnPremisesInstance::instance_name) / [`set_instance_name(Option<String>)`](crate::client::fluent_builders::RegisterOnPremisesInstance::set_instance_name): <p>The name of the on-premises instance to register.</p>
    ///   - [`iam_session_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterOnPremisesInstance::iam_session_arn) / [`set_iam_session_arn(Option<String>)`](crate::client::fluent_builders::RegisterOnPremisesInstance::set_iam_session_arn): <p>The ARN of the IAM session to associate with the on-premises instance.</p>
    ///   - [`iam_user_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterOnPremisesInstance::iam_user_arn) / [`set_iam_user_arn(Option<String>)`](crate::client::fluent_builders::RegisterOnPremisesInstance::set_iam_user_arn): <p>The ARN of the IAM user to associate with the on-premises instance.</p>
    /// - On success, responds with [`RegisterOnPremisesInstanceOutput`](crate::output::RegisterOnPremisesInstanceOutput)

    /// - On failure, responds with [`SdkError<RegisterOnPremisesInstanceError>`](crate::error::RegisterOnPremisesInstanceError)
    pub fn register_on_premises_instance(&self) -> fluent_builders::RegisterOnPremisesInstance {
        fluent_builders::RegisterOnPremisesInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromOnPremisesInstances`](crate::client::fluent_builders::RemoveTagsFromOnPremisesInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RemoveTagsFromOnPremisesInstances::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RemoveTagsFromOnPremisesInstances::set_tags): <p>The tag key-value pairs to remove from the on-premises instances.</p>
    ///   - [`instance_names(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromOnPremisesInstances::instance_names) / [`set_instance_names(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromOnPremisesInstances::set_instance_names): <p>The names of the on-premises instances from which to remove tags.</p>
    /// - On success, responds with [`RemoveTagsFromOnPremisesInstancesOutput`](crate::output::RemoveTagsFromOnPremisesInstancesOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsFromOnPremisesInstancesError>`](crate::error::RemoveTagsFromOnPremisesInstancesError)
    pub fn remove_tags_from_on_premises_instances(
        &self,
    ) -> fluent_builders::RemoveTagsFromOnPremisesInstances {
        fluent_builders::RemoveTagsFromOnPremisesInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SkipWaitTimeForInstanceTermination`](crate::client::fluent_builders::SkipWaitTimeForInstanceTermination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::SkipWaitTimeForInstanceTermination::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::SkipWaitTimeForInstanceTermination::set_deployment_id): <p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>
    /// - On success, responds with [`SkipWaitTimeForInstanceTerminationOutput`](crate::output::SkipWaitTimeForInstanceTerminationOutput)

    /// - On failure, responds with [`SdkError<SkipWaitTimeForInstanceTerminationError>`](crate::error::SkipWaitTimeForInstanceTerminationError)
    pub fn skip_wait_time_for_instance_termination(
        &self,
    ) -> fluent_builders::SkipWaitTimeForInstanceTermination {
        fluent_builders::SkipWaitTimeForInstanceTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDeployment`](crate::client::fluent_builders::StopDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::StopDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::StopDeployment::set_deployment_id): <p> The unique ID of a deployment. </p>
    ///   - [`auto_rollback_enabled(bool)`](crate::client::fluent_builders::StopDeployment::auto_rollback_enabled) / [`set_auto_rollback_enabled(Option<bool>)`](crate::client::fluent_builders::StopDeployment::set_auto_rollback_enabled): <p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>
    /// - On success, responds with [`StopDeploymentOutput`](crate::output::StopDeploymentOutput) with field(s):
    ///   - [`status(Option<StopStatus>)`](crate::output::StopDeploymentOutput::status): <p>The status of the stop deployment operation:</p>  <ul>   <li> <p>Pending: The stop operation is pending.</p> </li>   <li> <p>Succeeded: The stop operation was successful.</p> </li>  </ul>
    ///   - [`status_message(Option<String>)`](crate::output::StopDeploymentOutput::status_message): <p>An accompanying status message.</p>
    /// - On failure, responds with [`SdkError<StopDeploymentError>`](crate::error::StopDeploymentError)
    pub fn stop_deployment(&self) -> fluent_builders::StopDeployment {
        fluent_builders::StopDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_application_name): <p>The current name of the application you want to change.</p>
    ///   - [`new_application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::new_application_name) / [`set_new_application_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_new_application_name): <p>The new name to give the application.</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)

    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDeploymentGroup`](crate::client::fluent_builders::UpdateDeploymentGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_application_name): <p>The application name that corresponds to the deployment group to update.</p>
    ///   - [`current_deployment_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::current_deployment_group_name) / [`set_current_deployment_group_name(Option<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_current_deployment_group_name): <p>The current name of the deployment group.</p>
    ///   - [`new_deployment_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::new_deployment_group_name) / [`set_new_deployment_group_name(Option<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_new_deployment_group_name): <p>The new name of the deployment group, if you want to change it.</p>
    ///   - [`deployment_config_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::deployment_config_name) / [`set_deployment_config_name(Option<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_deployment_config_name): <p>The replacement deployment configuration name to use, if you want to change it.</p>
    ///   - [`ec2_tag_filters(Vec<Ec2TagFilter>)`](crate::client::fluent_builders::UpdateDeploymentGroup::ec2_tag_filters) / [`set_ec2_tag_filters(Option<Vec<Ec2TagFilter>>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_ec2_tag_filters): <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
    ///   - [`on_premises_instance_tag_filters(Vec<TagFilter>)`](crate::client::fluent_builders::UpdateDeploymentGroup::on_premises_instance_tag_filters) / [`set_on_premises_instance_tag_filters(Option<Vec<TagFilter>>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_on_premises_instance_tag_filters): <p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
    ///   - [`auto_scaling_groups(Vec<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::auto_scaling_groups) / [`set_auto_scaling_groups(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_auto_scaling_groups): <p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>
    ///   - [`service_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::service_role_arn) / [`set_service_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_service_role_arn): <p>A replacement ARN for the service role, if you want to change it.</p>
    ///   - [`trigger_configurations(Vec<TriggerConfig>)`](crate::client::fluent_builders::UpdateDeploymentGroup::trigger_configurations) / [`set_trigger_configurations(Option<Vec<TriggerConfig>>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_trigger_configurations): <p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
    ///   - [`alarm_configuration(AlarmConfiguration)`](crate::client::fluent_builders::UpdateDeploymentGroup::alarm_configuration) / [`set_alarm_configuration(Option<AlarmConfiguration>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_alarm_configuration): <p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>
    ///   - [`auto_rollback_configuration(AutoRollbackConfiguration)`](crate::client::fluent_builders::UpdateDeploymentGroup::auto_rollback_configuration) / [`set_auto_rollback_configuration(Option<AutoRollbackConfiguration>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_auto_rollback_configuration): <p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>
    ///   - [`outdated_instances_strategy(OutdatedInstancesStrategy)`](crate::client::fluent_builders::UpdateDeploymentGroup::outdated_instances_strategy) / [`set_outdated_instances_strategy(Option<OutdatedInstancesStrategy>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_outdated_instances_strategy): <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>  <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>  <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
    ///   - [`deployment_style(DeploymentStyle)`](crate::client::fluent_builders::UpdateDeploymentGroup::deployment_style) / [`set_deployment_style(Option<DeploymentStyle>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_deployment_style): <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
    ///   - [`blue_green_deployment_configuration(BlueGreenDeploymentConfiguration)`](crate::client::fluent_builders::UpdateDeploymentGroup::blue_green_deployment_configuration) / [`set_blue_green_deployment_configuration(Option<BlueGreenDeploymentConfiguration>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_blue_green_deployment_configuration): <p>Information about blue/green deployment options for a deployment group.</p>
    ///   - [`load_balancer_info(LoadBalancerInfo)`](crate::client::fluent_builders::UpdateDeploymentGroup::load_balancer_info) / [`set_load_balancer_info(Option<LoadBalancerInfo>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_load_balancer_info): <p>Information about the load balancer used in a deployment.</p>
    ///   - [`ec2_tag_set(Ec2TagSet)`](crate::client::fluent_builders::UpdateDeploymentGroup::ec2_tag_set) / [`set_ec2_tag_set(Option<Ec2TagSet>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_ec2_tag_set): <p>Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups.</p>
    ///   - [`ecs_services(Vec<EcsService>)`](crate::client::fluent_builders::UpdateDeploymentGroup::ecs_services) / [`set_ecs_services(Option<Vec<EcsService>>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_ecs_services): <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>   <clustername>    :    <servicename></servicename>   </clustername></code>. </p>
    ///   - [`on_premises_tag_set(OnPremisesTagSet)`](crate::client::fluent_builders::UpdateDeploymentGroup::on_premises_tag_set) / [`set_on_premises_tag_set(Option<OnPremisesTagSet>)`](crate::client::fluent_builders::UpdateDeploymentGroup::set_on_premises_tag_set): <p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>
    /// - On success, responds with [`UpdateDeploymentGroupOutput`](crate::output::UpdateDeploymentGroupOutput) with field(s):
    ///   - [`hooks_not_cleaned_up(Option<Vec<AutoScalingGroup>>)`](crate::output::UpdateDeploymentGroupOutput::hooks_not_cleaned_up): <p>If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the AWS account. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the AWS account.</p>
    /// - On failure, responds with [`SdkError<UpdateDeploymentGroupError>`](crate::error::UpdateDeploymentGroupError)
    pub fn update_deployment_group(&self) -> fluent_builders::UpdateDeploymentGroup {
        fluent_builders::UpdateDeploymentGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToOnPremisesInstances`.
    ///
    /// <p>Adds tags to on-premises instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToOnPremisesInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_on_premises_instances_input::Builder,
    }
    impl AddTagsToOnPremisesInstances {
        /// Creates a new `AddTagsToOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToOnPremisesInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs to add to the on-premises instances.</p>
        /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs to add to the on-premises instances.</p>
        /// <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances to which to add tags.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(input.into());
            self
        }
        /// <p>The names of the on-premises instances to which to add tags.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetApplicationRevisions`.
    ///
    /// <p>Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetApplicationRevisions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_application_revisions_input::Builder,
    }
    impl BatchGetApplicationRevisions {
        /// Creates a new `BatchGetApplicationRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetApplicationRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationRevisionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application about which to get revision information.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application about which to get revision information.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// Appends an item to `revisions`.
        ///
        /// To override the contents of this collection use [`set_revisions`](Self::set_revisions).
        ///
        /// <p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>
        pub fn revisions(mut self, input: crate::model::RevisionLocation) -> Self {
            self.inner = self.inner.revisions(input);
            self
        }
        /// <p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>
        pub fn set_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
        ) -> Self {
            self.inner = self.inner.set_revisions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetApplications`.
    ///
    /// <p>Gets information about one or more applications. The maximum number of applications that can be returned is 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetApplications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_applications_input::Builder,
    }
    impl BatchGetApplications {
        /// Creates a new `BatchGetApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `applicationNames`.
        ///
        /// To override the contents of this collection use [`set_application_names`](Self::set_application_names).
        ///
        /// <p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>
        pub fn application_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_names(input.into());
            self
        }
        /// <p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>
        pub fn set_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_application_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeploymentGroups`.
    ///
    /// <p>Gets information about one or more deployment groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetDeploymentGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_deployment_groups_input::Builder,
    }
    impl BatchGetDeploymentGroups {
        /// Creates a new `BatchGetDeploymentGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// Appends an item to `deploymentGroupNames`.
        ///
        /// To override the contents of this collection use [`set_deployment_group_names`](Self::set_deployment_group_names).
        ///
        /// <p>The names of the deployment groups.</p>
        pub fn deployment_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_names(input.into());
            self
        }
        /// <p>The names of the deployment groups.</p>
        pub fn set_deployment_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeploymentInstances`.
    ///
    /// <note>
    /// <p> This method works, but is deprecated. Use <code>BatchGetDeploymentTargets</code> instead. </p>
    /// </note>
    /// <p> Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and AWS Lambda compute platforms. The newer <code>BatchGetDeploymentTargets</code> works with all compute platforms. The maximum number of instances that can be returned is 25.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetDeploymentInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_deployment_instances_input::Builder,
    }
    impl BatchGetDeploymentInstances {
        /// Creates a new `BatchGetDeploymentInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `instanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(input.into());
            self
        }
        /// <p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeployments`.
    ///
    /// <p>Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetDeployments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_deployments_input::Builder,
    }
    impl BatchGetDeployments {
        /// Creates a new `BatchGetDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `deploymentIds`.
        ///
        /// To override the contents of this collection use [`set_deployment_ids`](Self::set_deployment_ids).
        ///
        /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>
        pub fn deployment_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_ids(input.into());
            self
        }
        /// <p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>
        pub fn set_deployment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_deployment_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDeploymentTargets`.
    ///
    /// <p> Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of targets that can be returned is 25.</p>
    /// <p> The type of targets returned depends on the deployment's compute platform or deployment method: </p>
    /// <ul>
    /// <li> <p> <b>EC2/On-premises</b>: Information about EC2 instance targets. </p> </li>
    /// <li> <p> <b>AWS Lambda</b>: Information about Lambda functions targets. </p> </li>
    /// <li> <p> <b>Amazon ECS</b>: Information about Amazon ECS service targets. </p> </li>
    /// <li> <p> <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack update.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetDeploymentTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_deployment_targets_input::Builder,
    }
    impl BatchGetDeploymentTargets {
        /// Creates a new `BatchGetDeploymentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDeploymentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// Appends an item to `targetIds`.
        ///
        /// To override the contents of this collection use [`set_target_ids`](Self::set_target_ids).
        ///
        /// <p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>
        /// <ul>
        /// <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. Their target type is <code>ecsTarget</code>. </p> </li>
        /// <li> <p> For deployments that are deployed with AWS CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li>
        /// </ul>
        pub fn target_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_ids(input.into());
            self
        }
        /// <p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>
        /// <ul>
        /// <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li>
        /// <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. Their target type is <code>ecsTarget</code>. </p> </li>
        /// <li> <p> For deployments that are deployed with AWS CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li>
        /// </ul>
        pub fn set_target_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetOnPremisesInstances`.
    ///
    /// <p>Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetOnPremisesInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_on_premises_instances_input::Builder,
    }
    impl BatchGetOnPremisesInstances {
        /// Creates a new `BatchGetOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetOnPremisesInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(input.into());
            self
        }
        /// <p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ContinueDeployment`.
    ///
    /// <p>For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.) </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ContinueDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::continue_deployment_input::Builder,
    }
    impl ContinueDeployment {
        /// Creates a new `ContinueDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ContinueDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::ContinueDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>
        pub fn deployment_wait_type(mut self, input: crate::model::DeploymentWaitType) -> Self {
            self.inner = self.inner.deployment_wait_type(input);
            self
        }
        /// <p> The status of the deployment's waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>
        pub fn set_deployment_wait_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentWaitType>,
        ) -> Self {
            self.inner = self.inner.set_deployment_wait_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_application_input::Builder,
    }
    impl CreateApplication {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.inner = self.inner.compute_platform(input);
            self
        }
        /// <p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.inner = self.inner.set_compute_platform(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p>Deploys an application revision through the specified deployment group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl CreateDeployment {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the deployment group.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(input.into());
            self
        }
        /// <p>The name of the deployment group.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
        /// <p> The type and location of the revision to deploy. </p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.inner = self.inner.revision(input);
            self
        }
        /// <p> The type and location of the revision to deploy. </p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.inner = self.inner.set_revision(input);
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        /// <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(input.into());
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        /// <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A comment about the deployment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
        /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn ignore_application_stop_failures(mut self, input: bool) -> Self {
            self.inner = self.inner.ignore_application_stop_failures(input);
            self
        }
        /// <p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p>
        /// <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p>
        /// <p> During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p>
        /// <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>
        pub fn set_ignore_application_stop_failures(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_ignore_application_stop_failures(input);
            self
        }
        /// <p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>
        pub fn target_instances(mut self, input: crate::model::TargetInstances) -> Self {
            self.inner = self.inner.target_instances(input);
            self
        }
        /// <p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>
        pub fn set_target_instances(
            mut self,
            input: std::option::Option<crate::model::TargetInstances>,
        ) -> Self {
            self.inner = self.inner.set_target_instances(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment is created.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.inner = self.inner.auto_rollback_configuration(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment is created.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_auto_rollback_configuration(input);
            self
        }
        /// <p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>
        pub fn update_outdated_instances_only(mut self, input: bool) -> Self {
            self.inner = self.inner.update_outdated_instances_only(input);
            self
        }
        /// <p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>
        pub fn set_update_outdated_instances_only(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_update_outdated_instances_only(input);
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
        /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p>
        /// <ul>
        /// <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
        /// <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
        /// <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
        /// </ul>
        pub fn file_exists_behavior(mut self, input: crate::model::FileExistsBehavior) -> Self {
            self.inner = self.inner.file_exists_behavior(input);
            self
        }
        /// <p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.</p>
        /// <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p>
        /// <ul>
        /// <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li>
        /// <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li>
        /// <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li>
        /// </ul>
        pub fn set_file_exists_behavior(
            mut self,
            input: std::option::Option<crate::model::FileExistsBehavior>,
        ) -> Self {
            self.inner = self.inner.set_file_exists_behavior(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeploymentConfig`.
    ///
    /// <p> Creates a deployment configuration. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeploymentConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deployment_config_input::Builder,
    }
    impl CreateDeploymentConfig {
        /// Creates a new `CreateDeploymentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the deployment configuration to create.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(input.into());
            self
        }
        /// <p>The name of the deployment configuration to create.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// <p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p>
        /// <p>The type parameter takes either of the following values:</p>
        /// <ul>
        /// <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li>
        /// <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li>
        /// </ul>
        /// <p>The value parameter takes an integer.</p>
        /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>
        pub fn minimum_healthy_hosts(mut self, input: crate::model::MinimumHealthyHosts) -> Self {
            self.inner = self.inner.minimum_healthy_hosts(input);
            self
        }
        /// <p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p>
        /// <p>The type parameter takes either of the following values:</p>
        /// <ul>
        /// <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li>
        /// <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li>
        /// </ul>
        /// <p>The value parameter takes an integer.</p>
        /// <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>
        pub fn set_minimum_healthy_hosts(
            mut self,
            input: std::option::Option<crate::model::MinimumHealthyHosts>,
        ) -> Self {
            self.inner = self.inner.set_minimum_healthy_hosts(input);
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed.</p>
        pub fn traffic_routing_config(mut self, input: crate::model::TrafficRoutingConfig) -> Self {
            self.inner = self.inner.traffic_routing_config(input);
            self
        }
        /// <p>The configuration that specifies how the deployment traffic is routed.</p>
        pub fn set_traffic_routing_config(
            mut self,
            input: std::option::Option<crate::model::TrafficRoutingConfig>,
        ) -> Self {
            self.inner = self.inner.set_traffic_routing_config(input);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn compute_platform(mut self, input: crate::model::ComputePlatform) -> Self {
            self.inner = self.inner.compute_platform(input);
            self
        }
        /// <p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>
        pub fn set_compute_platform(
            mut self,
            input: std::option::Option<crate::model::ComputePlatform>,
        ) -> Self {
            self.inner = self.inner.set_compute_platform(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeploymentGroup`.
    ///
    /// <p>Creates a deployment group to which application revisions are deployed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeploymentGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deployment_group_input::Builder,
    }
    impl CreateDeploymentGroup {
        /// Creates a new `CreateDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a new deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(input.into());
            self
        }
        /// <p>The name of a new deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
        /// <p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p>
        /// <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.</p>
        /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(input.into());
            self
        }
        /// <p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p>
        /// <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group.</p>
        /// <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// Appends an item to `ec2TagFilters`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_filters`](Self::set_ec2_tag_filters).
        ///
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
        pub fn ec2_tag_filters(mut self, input: crate::model::Ec2TagFilter) -> Self {
            self.inner = self.inner.ec2_tag_filters(input);
            self
        }
        /// <p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>
        pub fn set_ec2_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_filters(input);
            self
        }
        /// Appends an item to `onPremisesInstanceTagFilters`.
        ///
        /// To override the contents of this collection use [`set_on_premises_instance_tag_filters`](Self::set_on_premises_instance_tag_filters).
        ///
        /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>
        pub fn on_premises_instance_tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.on_premises_instance_tag_filters(input);
            self
        }
        /// <p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>
        pub fn set_on_premises_instance_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_instance_tag_filters(input);
            self
        }
        /// Appends an item to `autoScalingGroups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
        pub fn auto_scaling_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_scaling_groups(input.into());
            self
        }
        /// <p>A list of associated Amazon EC2 Auto Scaling groups.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_groups(input);
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(input.into());
            self
        }
        /// <p>A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// Appends an item to `triggerConfigurations`.
        ///
        /// To override the contents of this collection use [`set_trigger_configurations`](Self::set_trigger_configurations).
        ///
        /// <p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn trigger_configurations(mut self, input: crate::model::TriggerConfig) -> Self {
            self.inner = self.inner.trigger_configurations(input);
            self
        }
        /// <p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_trigger_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        ) -> Self {
            self.inner = self.inner.set_trigger_configurations(input);
            self
        }
        /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>
        pub fn alarm_configuration(mut self, input: crate::model::AlarmConfiguration) -> Self {
            self.inner = self.inner.alarm_configuration(input);
            self
        }
        /// <p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>
        pub fn set_alarm_configuration(
            mut self,
            input: std::option::Option<crate::model::AlarmConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_alarm_configuration(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.inner = self.inner.auto_rollback_configuration(input);
            self
        }
        /// <p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_auto_rollback_configuration(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn outdated_instances_strategy(
            mut self,
            input: crate::model::OutdatedInstancesStrategy,
        ) -> Self {
            self.inner = self.inner.outdated_instances_strategy(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn set_outdated_instances_strategy(
            mut self,
            input: std::option::Option<crate::model::OutdatedInstancesStrategy>,
        ) -> Self {
            self.inner = self.inner.set_outdated_instances_strategy(input);
            self
        }
        /// <p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, input: crate::model::DeploymentStyle) -> Self {
            self.inner = self.inner.deployment_style(input);
            self
        }
        /// <p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.inner = self.inner.set_deployment_style(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            input: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.inner = self.inner.blue_green_deployment_configuration(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_blue_green_deployment_configuration(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn load_balancer_info(mut self, input: crate::model::LoadBalancerInfo) -> Self {
            self.inner = self.inner.load_balancer_info(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_info(input);
            self
        }
        /// <p>Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>
        pub fn ec2_tag_set(mut self, input: crate::model::Ec2TagSet) -> Self {
            self.inner = self.inner.ec2_tag_set(input);
            self
        }
        /// <p>Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_set(input);
            self
        }
        /// Appends an item to `ecsServices`.
        ///
        /// To override the contents of this collection use [`set_ecs_services`](Self::set_ecs_services).
        ///
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn ecs_services(mut self, input: crate::model::EcsService) -> Self {
            self.inner = self.inner.ecs_services(input);
            self
        }
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn set_ecs_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        ) -> Self {
            self.inner = self.inner.set_ecs_services(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
        pub fn on_premises_tag_set(mut self, input: crate::model::OnPremisesTagSet) -> Self {
            self.inner = self.inner.on_premises_tag_set(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>
        pub fn set_on_premises_tag_set(
            mut self,
            input: std::option::Option<crate::model::OnPremisesTagSet>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_tag_set(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl DeleteApplication {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeploymentConfig`.
    ///
    /// <p>Deletes a deployment configuration.</p> <note>
    /// <p>A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeploymentConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_deployment_config_input::Builder,
    }
    impl DeleteDeploymentConfig {
        /// Creates a new `DeleteDeploymentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(input.into());
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeploymentGroup`.
    ///
    /// <p>Deletes a deployment group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeploymentGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_deployment_group_input::Builder,
    }
    impl DeleteDeploymentGroup {
        /// Creates a new `DeleteDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(input.into());
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGitHubAccountToken`.
    ///
    /// <p>Deletes a GitHub account connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGitHubAccountToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_git_hub_account_token_input::Builder,
    }
    impl DeleteGitHubAccountToken {
        /// Creates a new `DeleteGitHubAccountToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGitHubAccountTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGitHubAccountTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the GitHub account connection to delete.</p>
        pub fn token_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_name(input.into());
            self
        }
        /// <p>The name of the GitHub account connection to delete.</p>
        pub fn set_token_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcesByExternalId`.
    ///
    /// <p>Deletes resources linked to an external ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcesByExternalId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resources_by_external_id_input::Builder,
    }
    impl DeleteResourcesByExternalId {
        /// Creates a new `DeleteResourcesByExternalId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcesByExternalIdOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcesByExternalIdError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterOnPremisesInstance`.
    ///
    /// <p>Deregisters an on-premises instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterOnPremisesInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_on_premises_instance_input::Builder,
    }
    impl DeregisterOnPremisesInstance {
        /// Creates a new `DeregisterOnPremisesInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterOnPremisesInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterOnPremisesInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the on-premises instance to deregister.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(input.into());
            self
        }
        /// <p>The name of the on-premises instance to deregister.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplication`.
    ///
    /// <p>Gets information about an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_application_input::Builder,
    }
    impl GetApplication {
        /// Creates a new `GetApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationRevision`.
    ///
    /// <p>Gets information about an application revision.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplicationRevision {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_application_revision_input::Builder,
    }
    impl GetApplicationRevision {
        /// Creates a new `GetApplicationRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationRevisionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Information about the application revision to get, including type and location.</p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.inner = self.inner.revision(input);
            self
        }
        /// <p>Information about the application revision to get, including type and location.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.inner = self.inner.set_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Gets information about a deployment.</p> <note>
    /// <p> The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl GetDeployment {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment associated with the IAM user or AWS account. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentConfig`.
    ///
    /// <p>Gets information about a deployment configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeploymentConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_config_input::Builder,
    }
    impl GetDeploymentConfig {
        /// Creates a new `GetDeploymentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(input.into());
            self
        }
        /// <p>The name of a deployment configuration associated with the IAM user or AWS account.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentGroup`.
    ///
    /// <p>Gets information about a deployment group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeploymentGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_group_input::Builder,
    }
    impl GetDeploymentGroup {
        /// Creates a new `GetDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(input.into());
            self
        }
        /// <p>The name of a deployment group for the specified application.</p>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentInstance`.
    ///
    /// <p>Gets information about an instance as part of a deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeploymentInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_instance_input::Builder,
    }
    impl GetDeploymentInstance {
        /// Creates a new `GetDeploymentInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The unique ID of an instance in the deployment group. </p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p> The unique ID of an instance in the deployment group. </p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentTarget`.
    ///
    /// <p> Returns information about a deployment target. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeploymentTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_target_input::Builder,
    }
    impl GetDeploymentTarget {
        /// Creates a new `GetDeploymentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The unique ID of a deployment target. </p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment target. </p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOnPremisesInstance`.
    ///
    /// <p> Gets information about an on-premises instance. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOnPremisesInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_on_premises_instance_input::Builder,
    }
    impl GetOnPremisesInstance {
        /// Creates a new `GetOnPremisesInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOnPremisesInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOnPremisesInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the on-premises instance about which to get information. </p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(input.into());
            self
        }
        /// <p> The name of the on-premises instance about which to get information. </p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationRevisions`.
    ///
    /// <p>Lists information about revisions for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationRevisions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_application_revisions_input::Builder,
    }
    impl ListApplicationRevisions {
        /// Creates a new `ListApplicationRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationRevisionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationRevisionsPaginator {
            crate::paginator::ListApplicationRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS account. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p> The name of an AWS CodeDeploy application associated with the IAM user or AWS account. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The column name to use to sort the list results:</p>
        /// <ul>
        /// <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li>
        /// <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li>
        /// <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li>
        /// </ul>
        /// <p> If not specified or set to null, the results are returned in an arbitrary order. </p>
        pub fn sort_by(mut self, input: crate::model::ApplicationRevisionSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The column name to use to sort the list results:</p>
        /// <ul>
        /// <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li>
        /// <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li>
        /// <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li>
        /// </ul>
        /// <p> If not specified or set to null, the results are returned in an arbitrary order. </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ApplicationRevisionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p> The order in which to sort the list results: </p>
        /// <ul>
        /// <li> <p> <code>ascending</code>: ascending order.</p> </li>
        /// <li> <p> <code>descending</code>: descending order.</p> </li>
        /// </ul>
        /// <p>If not specified, the results are sorted in ascending order.</p>
        /// <p>If set to null, the results are sorted in an arbitrary order.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p> The order in which to sort the list results: </p>
        /// <ul>
        /// <li> <p> <code>ascending</code>: ascending order.</p> </li>
        /// <li> <p> <code>descending</code>: descending order.</p> </li>
        /// </ul>
        /// <p>If not specified, the results are sorted in ascending order.</p>
        /// <p>If set to null, the results are sorted in an arbitrary order.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
        /// <p> If set to null, all of the user's buckets are searched. </p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(input.into());
            self
        }
        /// <p> An Amazon S3 bucket name to limit the search for revisions. </p>
        /// <p> If set to null, all of the user's buckets are searched. </p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(input.into());
            self
        }
        /// <p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
        /// <p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p>
        /// <ul>
        /// <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>ignore</code>: List all revisions.</p> </li>
        /// </ul>
        pub fn deployed(mut self, input: crate::model::ListStateFilterAction) -> Self {
            self.inner = self.inner.deployed(input);
            self
        }
        /// <p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p>
        /// <ul>
        /// <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li>
        /// <li> <p> <code>ignore</code>: List all revisions.</p> </li>
        /// </ul>
        pub fn set_deployed(
            mut self,
            input: std::option::Option<crate::model::ListStateFilterAction>,
        ) -> Self {
            self.inner = self.inner.set_deployed(input);
            self
        }
        /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists the applications registered with the IAM user or AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl ListApplications {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationsPaginator {
            crate::paginator::ListApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentConfigs`.
    ///
    /// <p>Lists the deployment configurations with the IAM user or AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeploymentConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployment_configs_input::Builder,
    }
    impl ListDeploymentConfigs {
        /// Creates a new `ListDeploymentConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentConfigsPaginator {
            crate::paginator::ListDeploymentConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentGroups`.
    ///
    /// <p>Lists the deployment groups for an application registered with the IAM user or AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeploymentGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployment_groups_input::Builder,
    }
    impl ListDeploymentGroups {
        /// Creates a new `ListDeploymentGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentGroupsPaginator {
            crate::paginator::ListDeploymentGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentInstances`.
    ///
    /// <note>
    /// <p> The newer <code>BatchGetDeploymentTargets</code> should be used instead because it works with all compute types. <code>ListDeploymentInstances</code> throws an exception if it is used with a compute platform other than EC2/On-premises or AWS Lambda. </p>
    /// </note>
    /// <p> Lists the instance for a deployment associated with the IAM user or AWS account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeploymentInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployment_instances_input::Builder,
    }
    impl ListDeploymentInstances {
        /// Creates a new `ListDeploymentInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentInstancesPaginator {
            crate::paginator::ListDeploymentInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `instanceStatusFilter`.
        ///
        /// To override the contents of this collection use [`set_instance_status_filter`](Self::set_instance_status_filter).
        ///
        /// <p>A subset of instances to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li>
        /// <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li>
        /// <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li>
        /// <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li>
        /// <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li>
        /// </ul>
        pub fn instance_status_filter(mut self, input: crate::model::InstanceStatus) -> Self {
            self.inner = self.inner.instance_status_filter(input);
            self
        }
        /// <p>A subset of instances to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li>
        /// <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li>
        /// <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li>
        /// <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li>
        /// <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li>
        /// </ul>
        pub fn set_instance_status_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceStatus>>,
        ) -> Self {
            self.inner = self.inner.set_instance_status_filter(input);
            self
        }
        /// Appends an item to `instanceTypeFilter`.
        ///
        /// To override the contents of this collection use [`set_instance_type_filter`](Self::set_instance_type_filter).
        ///
        /// <p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>
        pub fn instance_type_filter(mut self, input: crate::model::InstanceType) -> Self {
            self.inner = self.inner.instance_type_filter(input);
            self
        }
        /// <p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>
        pub fn set_instance_type_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceType>>,
        ) -> Self {
            self.inner = self.inner.set_instance_type_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeployments`.
    ///
    /// <p>Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeployments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployments_input::Builder,
    }
    impl ListDeployments {
        /// Creates a new `ListDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentsPaginator {
            crate::paginator::ListDeploymentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
        /// <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p>
        /// </note>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
        /// <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p>
        /// </note>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of a deployment group for the specified application.</p> <note>
        /// <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p>
        /// </note>
        pub fn deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_group_name(input.into());
            self
        }
        /// <p>The name of a deployment group for the specified application.</p> <note>
        /// <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p>
        /// </note>
        pub fn set_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_group_name(input);
            self
        }
        /// <p>The unique ID of an external resource for returning deployments linked to the external resource.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>The unique ID of an external resource for returning deployments linked to the external resource.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
        /// Appends an item to `includeOnlyStatuses`.
        ///
        /// To override the contents of this collection use [`set_include_only_statuses`](Self::set_include_only_statuses).
        ///
        /// <p>A subset of deployments to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li>
        /// <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li>
        /// </ul>
        pub fn include_only_statuses(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.inner = self.inner.include_only_statuses(input);
            self
        }
        /// <p>A subset of deployments to list by status:</p>
        /// <ul>
        /// <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li>
        /// <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li>
        /// <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li>
        /// </ul>
        pub fn set_include_only_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentStatus>>,
        ) -> Self {
            self.inner = self.inner.set_include_only_statuses(input);
            self
        }
        /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
        pub fn create_time_range(mut self, input: crate::model::TimeRange) -> Self {
            self.inner = self.inner.create_time_range(input);
            self
        }
        /// <p>A time range (start and end) for returning a subset of the list of deployments.</p>
        pub fn set_create_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_create_time_range(input);
            self
        }
        /// <p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentTargets`.
    ///
    /// <p> Returns an array of target IDs that are associated a deployment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeploymentTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployment_targets_input::Builder,
    }
    impl ListDeploymentTargets {
        /// Creates a new `ListDeploymentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Adds a key-value pair to `targetFilters`.
        ///
        /// To override the contents of this collection use [`set_target_filters`](Self::set_target_filters).
        ///
        /// <p> A key used to filter the returned targets. The two valid values are:</p>
        /// <ul>
        /// <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li>
        /// <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li>
        /// </ul>
        pub fn target_filters(
            mut self,
            k: crate::model::TargetFilterName,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_filters(k, v);
            self
        }
        /// <p> A key used to filter the returned targets. The two valid values are:</p>
        /// <ul>
        /// <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li>
        /// <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li>
        /// </ul>
        pub fn set_target_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::TargetFilterName,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_target_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGitHubAccountTokenNames`.
    ///
    /// <p>Lists the names of stored connections to GitHub accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGitHubAccountTokenNames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_git_hub_account_token_names_input::Builder,
    }
    impl ListGitHubAccountTokenNames {
        /// Creates a new `ListGitHubAccountTokenNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGitHubAccountTokenNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGitHubAccountTokenNamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOnPremisesInstances`.
    ///
    /// <p>Gets a list of names for one or more on-premises instances.</p>
    /// <p>Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOnPremisesInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_on_premises_instances_input::Builder,
    }
    impl ListOnPremisesInstances {
        /// Creates a new `ListOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOnPremisesInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The registration status of the on-premises instances:</p>
        /// <ul>
        /// <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li>
        /// <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li>
        /// </ul>
        pub fn registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.inner = self.inner.registration_status(input);
            self
        }
        /// <p>The registration status of the on-premises instances:</p>
        /// <ul>
        /// <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li>
        /// <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li>
        /// </ul>
        pub fn set_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_registration_status(input);
            self
        }
        /// Appends an item to `tagFilters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>
        pub fn tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filters(input);
            self
        }
        /// <p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_tag_filters(input);
            self
        }
        /// <p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLifecycleEventHookExecutionStatus`.
    ///
    /// <p> Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS deployments, the available lifecycle hooks are <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>, <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda validation functions return <code>Succeeded</code> or <code>Failed</code>. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda">AppSpec 'hooks' Section for an AWS Lambda Deployment </a> and <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs">AppSpec 'hooks' Section for an Amazon ECS Deployment</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLifecycleEventHookExecutionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_lifecycle_event_hook_execution_status_input::Builder,
    }
    impl PutLifecycleEventHookExecutionStatus {
        /// Creates a new `PutLifecycleEventHookExecutionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLifecycleEventHookExecutionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutLifecycleEventHookExecutionStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>
        pub fn lifecycle_event_hook_execution_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.lifecycle_event_hook_execution_id(input.into());
            self
        }
        /// <p> The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>
        pub fn set_lifecycle_event_hook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_event_hook_execution_id(input);
            self
        }
        /// <p>The result of a Lambda function that validates a deployment lifecycle event. <code>Succeeded</code> and <code>Failed</code> are the only valid values for <code>status</code>.</p>
        pub fn status(mut self, input: crate::model::LifecycleEventStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The result of a Lambda function that validates a deployment lifecycle event. <code>Succeeded</code> and <code>Failed</code> are the only valid values for <code>status</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LifecycleEventStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterApplicationRevision`.
    ///
    /// <p>Registers with AWS CodeDeploy a revision for the specified application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterApplicationRevision {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_application_revision_input::Builder,
    }
    impl RegisterApplicationRevision {
        /// Creates a new `RegisterApplicationRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterApplicationRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterApplicationRevisionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A comment about the revision.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A comment about the revision.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Information about the application revision to register, including type and location.</p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.inner = self.inner.revision(input);
            self
        }
        /// <p>Information about the application revision to register, including type and location.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.inner = self.inner.set_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterOnPremisesInstance`.
    ///
    /// <p>Registers an on-premises instance.</p> <note>
    /// <p>Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterOnPremisesInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_on_premises_instance_input::Builder,
    }
    impl RegisterOnPremisesInstance {
        /// Creates a new `RegisterOnPremisesInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterOnPremisesInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterOnPremisesInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the on-premises instance to register.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(input.into());
            self
        }
        /// <p>The name of the on-premises instance to register.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
        pub fn iam_session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_session_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM session to associate with the on-premises instance.</p>
        pub fn set_iam_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iam_session_arn(input);
            self
        }
        /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
        pub fn iam_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_user_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM user to associate with the on-premises instance.</p>
        pub fn set_iam_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromOnPremisesInstances`.
    ///
    /// <p>Removes one or more tags from one or more on-premises instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromOnPremisesInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_from_on_premises_instances_input::Builder,
    }
    impl RemoveTagsFromOnPremisesInstances {
        /// Creates a new `RemoveTagsFromOnPremisesInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromOnPremisesInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromOnPremisesInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs to remove from the on-premises instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names of the on-premises instances from which to remove tags.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(input.into());
            self
        }
        /// <p>The names of the on-premises instances from which to remove tags.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SkipWaitTimeForInstanceTermination`.
    ///
    /// <p>In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SkipWaitTimeForInstanceTermination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::skip_wait_time_for_instance_termination_input::Builder,
    }
    impl SkipWaitTimeForInstanceTermination {
        /// Creates a new `SkipWaitTimeForInstanceTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SkipWaitTimeForInstanceTerminationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SkipWaitTimeForInstanceTerminationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDeployment`.
    ///
    /// <p>Attempts to stop an ongoing deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_deployment_input::Builder,
    }
    impl StopDeployment {
        /// Creates a new `StopDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>
        pub fn auto_rollback_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_rollback_enabled(input);
            self
        }
        /// <p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>
        pub fn set_auto_rollback_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_rollback_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Associates the list of tags in the input <code>Tags</code> parameter with the resource identified by the <code>ResourceArn</code> input parameter. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Disassociates a resource from a list of tags. The resource is identified by the <code>ResourceArn</code> input parameter. The tags are identified by the list of keys in the <code>TagKeys</code> input parameter. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Changes the name of an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_input::Builder,
    }
    impl UpdateApplication {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current name of the application you want to change.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The current name of the application you want to change.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The new name to give the application.</p>
        pub fn new_application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_application_name(input.into());
            self
        }
        /// <p>The new name to give the application.</p>
        pub fn set_new_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeploymentGroup`.
    ///
    /// <p>Changes information about a deployment group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDeploymentGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_deployment_group_input::Builder,
    }
    impl UpdateDeploymentGroup {
        /// Creates a new `UpdateDeploymentGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeploymentGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application name that corresponds to the deployment group to update.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The application name that corresponds to the deployment group to update.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The current name of the deployment group.</p>
        pub fn current_deployment_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.current_deployment_group_name(input.into());
            self
        }
        /// <p>The current name of the deployment group.</p>
        pub fn set_current_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_deployment_group_name(input);
            self
        }
        /// <p>The new name of the deployment group, if you want to change it.</p>
        pub fn new_deployment_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_deployment_group_name(input.into());
            self
        }
        /// <p>The new name of the deployment group, if you want to change it.</p>
        pub fn set_new_deployment_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_deployment_group_name(input);
            self
        }
        /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
        pub fn deployment_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_config_name(input.into());
            self
        }
        /// <p>The replacement deployment configuration name to use, if you want to change it.</p>
        pub fn set_deployment_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config_name(input);
            self
        }
        /// Appends an item to `ec2TagFilters`.
        ///
        /// To override the contents of this collection use [`set_ec2_tag_filters`](Self::set_ec2_tag_filters).
        ///
        /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn ec2_tag_filters(mut self, input: crate::model::Ec2TagFilter) -> Self {
            self.inner = self.inner.ec2_tag_filters(input);
            self
        }
        /// <p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn set_ec2_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_filters(input);
            self
        }
        /// Appends an item to `onPremisesInstanceTagFilters`.
        ///
        /// To override the contents of this collection use [`set_on_premises_instance_tag_filters`](Self::set_on_premises_instance_tag_filters).
        ///
        /// <p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn on_premises_instance_tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.on_premises_instance_tag_filters(input);
            self
        }
        /// <p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>
        pub fn set_on_premises_instance_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_instance_tag_filters(input);
            self
        }
        /// Appends an item to `autoScalingGroups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>
        pub fn auto_scaling_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_scaling_groups(input.into());
            self
        }
        /// <p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_groups(input);
            self
        }
        /// <p>A replacement ARN for the service role, if you want to change it.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(input.into());
            self
        }
        /// <p>A replacement ARN for the service role, if you want to change it.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// Appends an item to `triggerConfigurations`.
        ///
        /// To override the contents of this collection use [`set_trigger_configurations`](Self::set_trigger_configurations).
        ///
        /// <p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn trigger_configurations(mut self, input: crate::model::TriggerConfig) -> Self {
            self.inner = self.inner.trigger_configurations(input);
            self
        }
        /// <p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>AWS CodeDeploy User Guide</i>.</p>
        pub fn set_trigger_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TriggerConfig>>,
        ) -> Self {
            self.inner = self.inner.set_trigger_configurations(input);
            self
        }
        /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>
        pub fn alarm_configuration(mut self, input: crate::model::AlarmConfiguration) -> Self {
            self.inner = self.inner.alarm_configuration(input);
            self
        }
        /// <p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>
        pub fn set_alarm_configuration(
            mut self,
            input: std::option::Option<crate::model::AlarmConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_alarm_configuration(input);
            self
        }
        /// <p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfiguration,
        ) -> Self {
            self.inner = self.inner.auto_rollback_configuration(input);
            self
        }
        /// <p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_auto_rollback_configuration(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn outdated_instances_strategy(
            mut self,
            input: crate::model::OutdatedInstancesStrategy,
        ) -> Self {
            self.inner = self.inner.outdated_instances_strategy(input);
            self
        }
        /// <p>Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p>
        /// <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances.</p>
        /// <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions.</p>
        pub fn set_outdated_instances_strategy(
            mut self,
            input: std::option::Option<crate::model::OutdatedInstancesStrategy>,
        ) -> Self {
            self.inner = self.inner.set_outdated_instances_strategy(input);
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn deployment_style(mut self, input: crate::model::DeploymentStyle) -> Self {
            self.inner = self.inner.deployment_style(input);
            self
        }
        /// <p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>
        pub fn set_deployment_style(
            mut self,
            input: std::option::Option<crate::model::DeploymentStyle>,
        ) -> Self {
            self.inner = self.inner.set_deployment_style(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn blue_green_deployment_configuration(
            mut self,
            input: crate::model::BlueGreenDeploymentConfiguration,
        ) -> Self {
            self.inner = self.inner.blue_green_deployment_configuration(input);
            self
        }
        /// <p>Information about blue/green deployment options for a deployment group.</p>
        pub fn set_blue_green_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::BlueGreenDeploymentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_blue_green_deployment_configuration(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn load_balancer_info(mut self, input: crate::model::LoadBalancerInfo) -> Self {
            self.inner = self.inner.load_balancer_info(input);
            self
        }
        /// <p>Information about the load balancer used in a deployment.</p>
        pub fn set_load_balancer_info(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerInfo>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_info(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups.</p>
        pub fn ec2_tag_set(mut self, input: crate::model::Ec2TagSet) -> Self {
            self.inner = self.inner.ec2_tag_set(input);
            self
        }
        /// <p>Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups.</p>
        pub fn set_ec2_tag_set(
            mut self,
            input: std::option::Option<crate::model::Ec2TagSet>,
        ) -> Self {
            self.inner = self.inner.set_ec2_tag_set(input);
            self
        }
        /// Appends an item to `ecsServices`.
        ///
        /// To override the contents of this collection use [`set_ecs_services`](Self::set_ecs_services).
        ///
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn ecs_services(mut self, input: crate::model::EcsService) -> Self {
            self.inner = self.inner.ecs_services(input);
            self
        }
        /// <p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>
        /// <clustername>
        /// :
        /// <servicename></servicename>
        /// </clustername></code>. </p>
        pub fn set_ecs_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EcsService>>,
        ) -> Self {
            self.inner = self.inner.set_ecs_services(input);
            self
        }
        /// <p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>
        pub fn on_premises_tag_set(mut self, input: crate::model::OnPremisesTagSet) -> Self {
            self.inner = self.inner.on_premises_tag_set(input);
            self
        }
        /// <p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>
        pub fn set_on_premises_tag_set(
            mut self,
            input: std::option::Option<crate::model::OnPremisesTagSet>,
        ) -> Self {
            self.inner = self.inner.set_on_premises_tag_set(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
