// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The maximum number of alarms for a deployment group (10) was exceeded.</p>
    AlarmsLimitExceededException(crate::error::AlarmsLimitExceededException),
    /// <p>An application with the specified name with the IAM user or AWS account already
    /// exists.</p>
    ApplicationAlreadyExistsException(crate::error::ApplicationAlreadyExistsException),
    /// <p>The application does not exist with the IAM user or AWS account.</p>
    ApplicationDoesNotExistException(crate::error::ApplicationDoesNotExistException),
    /// <p>More applications were attempted to be created than are allowed.</p>
    ApplicationLimitExceededException(crate::error::ApplicationLimitExceededException),
    /// <p>The minimum number of required application names was not specified.</p>
    ApplicationNameRequiredException(crate::error::ApplicationNameRequiredException),
    /// <p> The specified ARN is not supported. For example, it might be an ARN for a resource
    /// that is not expected. </p>
    ArnNotSupportedException(crate::error::ArnNotSupportedException),
    /// <p>The maximum number of names or IDs allowed for this request (100) was exceeded.</p>
    BatchLimitExceededException(crate::error::BatchLimitExceededException),
    /// <p>A bucket name is required, but was not provided.</p>
    BucketNameFilterRequiredException(crate::error::BucketNameFilterRequiredException),
    /// <p>The deployment is already complete.</p>
    DeploymentAlreadyCompletedException(crate::error::DeploymentAlreadyCompletedException),
    /// <p>A deployment configuration with the specified name with the IAM user or AWS account
    /// already exists.</p>
    DeploymentConfigAlreadyExistsException(crate::error::DeploymentConfigAlreadyExistsException),
    /// <p>The deployment configuration does not exist with the IAM user or AWS account.</p>
    DeploymentConfigDoesNotExistException(crate::error::DeploymentConfigDoesNotExistException),
    /// <p>The deployment configuration is still in use.</p>
    DeploymentConfigInUseException(crate::error::DeploymentConfigInUseException),
    /// <p>The deployment configurations limit was exceeded.</p>
    DeploymentConfigLimitExceededException(crate::error::DeploymentConfigLimitExceededException),
    /// <p>The deployment configuration name was not specified.</p>
    DeploymentConfigNameRequiredException(crate::error::DeploymentConfigNameRequiredException),
    /// <p>The deployment with the IAM user or AWS account does not exist.</p>
    DeploymentDoesNotExistException(crate::error::DeploymentDoesNotExistException),
    /// <p>A deployment group with the specified name with the IAM user or AWS account already
    /// exists.</p>
    DeploymentGroupAlreadyExistsException(crate::error::DeploymentGroupAlreadyExistsException),
    /// <p>The named deployment group with the IAM user or AWS account does not exist.</p>
    DeploymentGroupDoesNotExistException(crate::error::DeploymentGroupDoesNotExistException),
    /// <p> The deployment groups limit was exceeded.</p>
    DeploymentGroupLimitExceededException(crate::error::DeploymentGroupLimitExceededException),
    /// <p>The deployment group name was not specified.</p>
    DeploymentGroupNameRequiredException(crate::error::DeploymentGroupNameRequiredException),
    /// <p>At least one deployment ID must be specified.</p>
    DeploymentIdRequiredException(crate::error::DeploymentIdRequiredException),
    /// <p>The deployment does not have a status of Ready and can't continue yet.</p>
    DeploymentIsNotInReadyStateException(crate::error::DeploymentIsNotInReadyStateException),
    /// <p>The number of allowed deployments was exceeded.</p>
    DeploymentLimitExceededException(crate::error::DeploymentLimitExceededException),
    /// <p>The specified deployment has not started.</p>
    DeploymentNotStartedException(crate::error::DeploymentNotStartedException),
    /// <p> The provided target ID does not belong to the attempted deployment. </p>
    DeploymentTargetDoesNotExistException(crate::error::DeploymentTargetDoesNotExistException),
    /// <p> A deployment target ID was not provided. </p>
    DeploymentTargetIdRequiredException(crate::error::DeploymentTargetIdRequiredException),
    /// <p> The maximum number of targets that can be associated with an Amazon ECS or AWS Lambda
    /// deployment was exceeded. The target list of both types of deployments must have exactly
    /// one item. This exception does not apply to EC2/On-premises deployments. </p>
    DeploymentTargetListSizeExceededException(
        crate::error::DeploymentTargetListSizeExceededException,
    ),
    /// <p>The description is too long.</p>
    DescriptionTooLongException(crate::error::DescriptionTooLongException),
    /// <p> The Amazon ECS service is associated with more than one deployment groups. An Amazon
    /// ECS service can be associated with only one deployment group. </p>
    EcsServiceMappingLimitExceededException(crate::error::EcsServiceMappingLimitExceededException),
    /// <p>No GitHub account connection exists with the named specified in the call.</p>
    GitHubAccountTokenDoesNotExistException(crate::error::GitHubAccountTokenDoesNotExistException),
    /// <p>The call is missing a required GitHub account connection name.</p>
    GitHubAccountTokenNameRequiredException(crate::error::GitHubAccountTokenNameRequiredException),
    /// <p>No IAM ARN was included in the request. You must use an IAM session ARN or IAM user
    /// ARN in the request.</p>
    IamArnRequiredException(crate::error::IamArnRequiredException),
    /// <p>The request included an IAM session ARN that has already been used to register a
    /// different instance.</p>
    IamSessionArnAlreadyRegisteredException(crate::error::IamSessionArnAlreadyRegisteredException),
    /// <p>The specified IAM user ARN is already registered with an on-premises instance.</p>
    IamUserArnAlreadyRegisteredException(crate::error::IamUserArnAlreadyRegisteredException),
    /// <p>An IAM user ARN was not specified.</p>
    IamUserArnRequiredException(crate::error::IamUserArnRequiredException),
    /// <p>The specified instance does not exist in the deployment group.</p>
    InstanceDoesNotExistException(crate::error::InstanceDoesNotExistException),
    /// <p>The instance ID was not specified.</p>
    InstanceIdRequiredException(crate::error::InstanceIdRequiredException),
    /// <p>The maximum number of allowed on-premises instances in a single call was
    /// exceeded.</p>
    InstanceLimitExceededException(crate::error::InstanceLimitExceededException),
    /// <p>The specified on-premises instance name is already registered.</p>
    InstanceNameAlreadyRegisteredException(crate::error::InstanceNameAlreadyRegisteredException),
    /// <p>An on-premises instance name was not specified.</p>
    InstanceNameRequiredException(crate::error::InstanceNameRequiredException),
    /// <p>The specified on-premises instance is not registered.</p>
    InstanceNotRegisteredException(crate::error::InstanceNotRegisteredException),
    /// <p>The format of the alarm configuration is invalid. Possible causes include:</p>
    /// <ul>
    /// <li>
    /// <p>The alarm list is null.</p>
    /// </li>
    /// <li>
    /// <p>The alarm object is null.</p>
    /// </li>
    /// <li>
    /// <p>The alarm name is empty or null or exceeds the limit of 255 characters.</p>
    /// </li>
    /// <li>
    /// <p>Two alarms with the same name have been specified.</p>
    /// </li>
    /// <li>
    /// <p>The alarm configuration is enabled, but the alarm list is empty.</p>
    /// </li>
    /// </ul>
    InvalidAlarmConfigException(crate::error::InvalidAlarmConfigException),
    /// <p>The application name was specified in an invalid format.</p>
    InvalidApplicationNameException(crate::error::InvalidApplicationNameException),
    /// <p> The specified ARN is not in a valid format. </p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The automatic rollback configuration was specified in an invalid format. For example,
    /// automatic rollback is enabled, but an invalid triggering event type or no event types
    /// were listed.</p>
    InvalidAutoRollbackConfigException(crate::error::InvalidAutoRollbackConfigException),
    /// <p>The Auto Scaling group was specified in an invalid format or does not exist.</p>
    InvalidAutoScalingGroupException(crate::error::InvalidAutoScalingGroupException),
    /// <p>The configuration for the blue/green deployment group was provided in an invalid
    /// format. For information about deployment configuration format, see <a>CreateDeploymentConfig</a>.</p>
    InvalidBlueGreenDeploymentConfigurationException(
        crate::error::InvalidBlueGreenDeploymentConfigurationException,
    ),
    /// <p>The bucket name either doesn't exist or was specified in an invalid format.</p>
    InvalidBucketNameFilterException(crate::error::InvalidBucketNameFilterException),
    /// <p>The computePlatform is invalid. The computePlatform should be <code>Lambda</code>,
    /// <code>Server</code>, or <code>ECS</code>.</p>
    InvalidComputePlatformException(crate::error::InvalidComputePlatformException),
    /// <p>The deployed state filter was specified in an invalid format.</p>
    InvalidDeployedStateFilterException(crate::error::InvalidDeployedStateFilterException),
    /// <p>The deployment configuration name was specified in an invalid format.</p>
    InvalidDeploymentConfigNameException(crate::error::InvalidDeploymentConfigNameException),
    /// <p>The deployment group name was specified in an invalid format.</p>
    InvalidDeploymentGroupNameException(crate::error::InvalidDeploymentGroupNameException),
    /// <p>At least one of the deployment IDs was specified in an invalid format.</p>
    InvalidDeploymentIdException(crate::error::InvalidDeploymentIdException),
    /// <p>An instance type was specified for an in-place deployment. Instance types are
    /// supported for blue/green deployments only.</p>
    InvalidDeploymentInstanceTypeException(crate::error::InvalidDeploymentInstanceTypeException),
    /// <p>The specified deployment status doesn't exist or cannot be determined.</p>
    InvalidDeploymentStatusException(crate::error::InvalidDeploymentStatusException),
    /// <p>An invalid deployment style was specified. Valid deployment types include "IN_PLACE"
    /// and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
    /// "WITHOUT_TRAFFIC_CONTROL."</p>
    InvalidDeploymentStyleException(crate::error::InvalidDeploymentStyleException),
    /// <p> The target ID provided was not valid. </p>
    InvalidDeploymentTargetIdException(crate::error::InvalidDeploymentTargetIdException),
    /// <p> The wait type is invalid. </p>
    InvalidDeploymentWaitTypeException(crate::error::InvalidDeploymentWaitTypeException),
    /// <p>A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of
    /// these data types can be used in a single call.</p>
    InvalidEc2TagCombinationException(crate::error::InvalidEc2TagCombinationException),
    /// <p>The tag was specified in an invalid format.</p>
    InvalidEc2TagException(crate::error::InvalidEc2TagException),
    /// <p> The Amazon ECS service identifier is not valid. </p>
    InvalidEcsServiceException(crate::error::InvalidEcsServiceException),
    /// <p>The external ID was specified in an invalid format.</p>
    InvalidExternalIdException(crate::error::InvalidExternalIdException),
    /// <p>An invalid fileExistsBehavior option was specified to determine how AWS CodeDeploy
    /// handles files or directories that already exist in a deployment target location, but
    /// weren't part of the previous successful deployment. Valid values include "DISALLOW,"
    /// "OVERWRITE," and "RETAIN."</p>
    InvalidFileExistsBehaviorException(crate::error::InvalidFileExistsBehaviorException),
    /// <p>The GitHub token is not valid.</p>
    InvalidGitHubAccountTokenException(crate::error::InvalidGitHubAccountTokenException),
    /// <p>The format of the specified GitHub account connection name is invalid.</p>
    InvalidGitHubAccountTokenNameException(crate::error::InvalidGitHubAccountTokenNameException),
    /// <p>The IAM session ARN was specified in an invalid format.</p>
    InvalidIamSessionArnException(crate::error::InvalidIamSessionArnException),
    /// <p>The IAM user ARN was specified in an invalid format.</p>
    InvalidIamUserArnException(crate::error::InvalidIamUserArnException),
    /// <p>The IgnoreApplicationStopFailures value is invalid. For AWS Lambda deployments,
    /// <code>false</code> is expected. For EC2/On-premises deployments, <code>true</code>
    /// or <code>false</code> is expected.</p>
    InvalidIgnoreApplicationStopFailuresValueException(
        crate::error::InvalidIgnoreApplicationStopFailuresValueException,
    ),
    /// <p>The input was specified in an invalid format.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The on-premises instance name was specified in an invalid format.</p>
    InvalidInstanceNameException(crate::error::InvalidInstanceNameException),
    /// <p>The specified instance status does not exist.</p>
    InvalidInstanceStatusException(crate::error::InvalidInstanceStatusException),
    /// <p>An invalid instance type was specified for instances in a blue/green deployment. Valid
    /// values include "Blue" for an original environment and "Green" for a replacement
    /// environment.</p>
    InvalidInstanceTypeException(crate::error::InvalidInstanceTypeException),
    /// <p>The specified key prefix filter was specified in an invalid format.</p>
    InvalidKeyPrefixFilterException(crate::error::InvalidKeyPrefixFilterException),
    /// <p>A lifecycle event hook is invalid. Review the <code>hooks</code> section in your
    /// AppSpec file to ensure the lifecycle events and <code>hooks</code> functions are
    /// valid.</p>
    InvalidLifecycleEventHookExecutionIdException(
        crate::error::InvalidLifecycleEventHookExecutionIdException,
    ),
    /// <p>The result of a Lambda validation function that verifies a lifecycle event is invalid.
    /// It should return <code>Succeeded</code> or <code>Failed</code>.</p>
    InvalidLifecycleEventHookExecutionStatusException(
        crate::error::InvalidLifecycleEventHookExecutionStatusException,
    ),
    /// <p>An invalid load balancer name, or no load balancer name, was specified.</p>
    InvalidLoadBalancerInfoException(crate::error::InvalidLoadBalancerInfoException),
    /// <p>The minimum healthy instance value was specified in an invalid format.</p>
    InvalidMinimumHealthyHostValueException(crate::error::InvalidMinimumHealthyHostValueException),
    /// <p>The next token was specified in an invalid format.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet,
    /// but only one of these data types can be used in a single call.</p>
    InvalidOnPremisesTagCombinationException(
        crate::error::InvalidOnPremisesTagCombinationException,
    ),
    /// <p>An invalid operation was detected.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The registration status was specified in an invalid format.</p>
    InvalidRegistrationStatusException(crate::error::InvalidRegistrationStatusException),
    /// <p>The revision was specified in an invalid format.</p>
    InvalidRevisionException(crate::error::InvalidRevisionException),
    /// <p>The service role ARN was specified in an invalid format. Or, if an Auto Scaling group
    /// was specified, the specified service role does not grant the appropriate permissions to
    /// Amazon EC2 Auto Scaling.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The column name to sort by is either not present or was specified in an invalid
    /// format.</p>
    InvalidSortByException(crate::error::InvalidSortByException),
    /// <p>The sort order was specified in an invalid format.</p>
    InvalidSortOrderException(crate::error::InvalidSortOrderException),
    /// <p>The tag was specified in an invalid format.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>The tag filter was specified in an invalid format.</p>
    InvalidTagFilterException(crate::error::InvalidTagFilterException),
    /// <p> The specified tags are not valid. </p>
    InvalidTagsToAddException(crate::error::InvalidTagsToAddException),
    /// <p> The target filter name is invalid. </p>
    InvalidTargetFilterNameException(crate::error::InvalidTargetFilterNameException),
    /// <p> A target group pair associated with this deployment is not valid. </p>
    InvalidTargetGroupPairException(crate::error::InvalidTargetGroupPairException),
    /// <p>The target instance configuration is invalid. Possible causes include:</p>
    /// <ul>
    /// <li>
    /// <p>Configuration data for target instances was entered for an in-place
    /// deployment.</p>
    /// </li>
    /// <li>
    /// <p>The limit of 10 tags for a tag type was exceeded.</p>
    /// </li>
    /// <li>
    /// <p>The combined length of the tag names exceeded the limit. </p>
    /// </li>
    /// <li>
    /// <p>A specified tag is not currently applied to any instances.</p>
    /// </li>
    /// </ul>
    InvalidTargetInstancesException(crate::error::InvalidTargetInstancesException),
    /// <p>The specified time range was specified in an invalid format.</p>
    InvalidTimeRangeException(crate::error::InvalidTimeRangeException),
    /// <p> The configuration that specifies how traffic is routed during a deployment is
    /// invalid.</p>
    InvalidTrafficRoutingConfigurationException(
        crate::error::InvalidTrafficRoutingConfigurationException,
    ),
    /// <p>The trigger was specified in an invalid format.</p>
    InvalidTriggerConfigException(crate::error::InvalidTriggerConfigException),
    /// <p>The UpdateOutdatedInstancesOnly value is invalid. For AWS Lambda deployments,
    /// <code>false</code> is expected. For EC2/On-premises deployments, <code>true</code>
    /// or <code>false</code> is expected.</p>
    InvalidUpdateOutdatedInstancesOnlyValueException(
        crate::error::InvalidUpdateOutdatedInstancesOnlyValueException,
    ),
    /// <p>An attempt to return the status of an already completed lifecycle event
    /// occurred.</p>
    LifecycleEventAlreadyCompletedException(crate::error::LifecycleEventAlreadyCompletedException),
    /// <p>The limit for lifecycle hooks was exceeded.</p>
    LifecycleHookLimitExceededException(crate::error::LifecycleHookLimitExceededException),
    /// <p>Both an IAM user ARN and an IAM session ARN were included in the request. Use only one
    /// ARN type.</p>
    MultipleIamArnsProvidedException(crate::error::MultipleIamArnsProvidedException),
    /// <p>The API used does not support the deployment.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p> The ARN of a resource is required, but was not found. </p>
    ResourceArnRequiredException(crate::error::ResourceArnRequiredException),
    /// <p>The specified resource could not be validated.</p>
    ResourceValidationException(crate::error::ResourceValidationException),
    /// <p>The named revision does not exist with the IAM user or AWS account.</p>
    RevisionDoesNotExistException(crate::error::RevisionDoesNotExistException),
    /// <p>The revision ID was not specified.</p>
    RevisionRequiredException(crate::error::RevisionRequiredException),
    /// <p>The role ID was not specified.</p>
    RoleRequiredException(crate::error::RoleRequiredException),
    /// <p>The maximum allowed number of tags was exceeded.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>A tag was not specified.</p>
    TagRequiredException(crate::error::TagRequiredException),
    /// <p>The number of tag groups included in the tag set list exceeded the maximum allowed
    /// limit of 3.</p>
    TagSetListLimitExceededException(crate::error::TagSetListLimitExceededException),
    /// <p>An API function was called too frequently.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The maximum allowed number of triggers was exceeded.</p>
    TriggerTargetsLimitExceededException(crate::error::TriggerTargetsLimitExceededException),
    /// <p>A call was submitted that is not supported for the specified deployment type.</p>
    UnsupportedActionForDeploymentTypeException(
        crate::error::UnsupportedActionForDeploymentTypeException,
    ),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AlarmsLimitExceededException(inner) => inner.fmt(f),
            Error::ApplicationAlreadyExistsException(inner) => inner.fmt(f),
            Error::ApplicationDoesNotExistException(inner) => inner.fmt(f),
            Error::ApplicationLimitExceededException(inner) => inner.fmt(f),
            Error::ApplicationNameRequiredException(inner) => inner.fmt(f),
            Error::ArnNotSupportedException(inner) => inner.fmt(f),
            Error::BatchLimitExceededException(inner) => inner.fmt(f),
            Error::BucketNameFilterRequiredException(inner) => inner.fmt(f),
            Error::DeploymentAlreadyCompletedException(inner) => inner.fmt(f),
            Error::DeploymentConfigAlreadyExistsException(inner) => inner.fmt(f),
            Error::DeploymentConfigDoesNotExistException(inner) => inner.fmt(f),
            Error::DeploymentConfigInUseException(inner) => inner.fmt(f),
            Error::DeploymentConfigLimitExceededException(inner) => inner.fmt(f),
            Error::DeploymentConfigNameRequiredException(inner) => inner.fmt(f),
            Error::DeploymentDoesNotExistException(inner) => inner.fmt(f),
            Error::DeploymentGroupAlreadyExistsException(inner) => inner.fmt(f),
            Error::DeploymentGroupDoesNotExistException(inner) => inner.fmt(f),
            Error::DeploymentGroupLimitExceededException(inner) => inner.fmt(f),
            Error::DeploymentGroupNameRequiredException(inner) => inner.fmt(f),
            Error::DeploymentIdRequiredException(inner) => inner.fmt(f),
            Error::DeploymentIsNotInReadyStateException(inner) => inner.fmt(f),
            Error::DeploymentLimitExceededException(inner) => inner.fmt(f),
            Error::DeploymentNotStartedException(inner) => inner.fmt(f),
            Error::DeploymentTargetDoesNotExistException(inner) => inner.fmt(f),
            Error::DeploymentTargetIdRequiredException(inner) => inner.fmt(f),
            Error::DeploymentTargetListSizeExceededException(inner) => inner.fmt(f),
            Error::DescriptionTooLongException(inner) => inner.fmt(f),
            Error::EcsServiceMappingLimitExceededException(inner) => inner.fmt(f),
            Error::GitHubAccountTokenDoesNotExistException(inner) => inner.fmt(f),
            Error::GitHubAccountTokenNameRequiredException(inner) => inner.fmt(f),
            Error::IamArnRequiredException(inner) => inner.fmt(f),
            Error::IamSessionArnAlreadyRegisteredException(inner) => inner.fmt(f),
            Error::IamUserArnAlreadyRegisteredException(inner) => inner.fmt(f),
            Error::IamUserArnRequiredException(inner) => inner.fmt(f),
            Error::InstanceDoesNotExistException(inner) => inner.fmt(f),
            Error::InstanceIdRequiredException(inner) => inner.fmt(f),
            Error::InstanceLimitExceededException(inner) => inner.fmt(f),
            Error::InstanceNameAlreadyRegisteredException(inner) => inner.fmt(f),
            Error::InstanceNameRequiredException(inner) => inner.fmt(f),
            Error::InstanceNotRegisteredException(inner) => inner.fmt(f),
            Error::InvalidAlarmConfigException(inner) => inner.fmt(f),
            Error::InvalidApplicationNameException(inner) => inner.fmt(f),
            Error::InvalidArnException(inner) => inner.fmt(f),
            Error::InvalidAutoRollbackConfigException(inner) => inner.fmt(f),
            Error::InvalidAutoScalingGroupException(inner) => inner.fmt(f),
            Error::InvalidBlueGreenDeploymentConfigurationException(inner) => inner.fmt(f),
            Error::InvalidBucketNameFilterException(inner) => inner.fmt(f),
            Error::InvalidComputePlatformException(inner) => inner.fmt(f),
            Error::InvalidDeployedStateFilterException(inner) => inner.fmt(f),
            Error::InvalidDeploymentConfigNameException(inner) => inner.fmt(f),
            Error::InvalidDeploymentGroupNameException(inner) => inner.fmt(f),
            Error::InvalidDeploymentIdException(inner) => inner.fmt(f),
            Error::InvalidDeploymentInstanceTypeException(inner) => inner.fmt(f),
            Error::InvalidDeploymentStatusException(inner) => inner.fmt(f),
            Error::InvalidDeploymentStyleException(inner) => inner.fmt(f),
            Error::InvalidDeploymentTargetIdException(inner) => inner.fmt(f),
            Error::InvalidDeploymentWaitTypeException(inner) => inner.fmt(f),
            Error::InvalidEc2TagCombinationException(inner) => inner.fmt(f),
            Error::InvalidEc2TagException(inner) => inner.fmt(f),
            Error::InvalidEcsServiceException(inner) => inner.fmt(f),
            Error::InvalidExternalIdException(inner) => inner.fmt(f),
            Error::InvalidFileExistsBehaviorException(inner) => inner.fmt(f),
            Error::InvalidGitHubAccountTokenException(inner) => inner.fmt(f),
            Error::InvalidGitHubAccountTokenNameException(inner) => inner.fmt(f),
            Error::InvalidIamSessionArnException(inner) => inner.fmt(f),
            Error::InvalidIamUserArnException(inner) => inner.fmt(f),
            Error::InvalidIgnoreApplicationStopFailuresValueException(inner) => inner.fmt(f),
            Error::InvalidInputException(inner) => inner.fmt(f),
            Error::InvalidInstanceNameException(inner) => inner.fmt(f),
            Error::InvalidInstanceStatusException(inner) => inner.fmt(f),
            Error::InvalidInstanceTypeException(inner) => inner.fmt(f),
            Error::InvalidKeyPrefixFilterException(inner) => inner.fmt(f),
            Error::InvalidLifecycleEventHookExecutionIdException(inner) => inner.fmt(f),
            Error::InvalidLifecycleEventHookExecutionStatusException(inner) => inner.fmt(f),
            Error::InvalidLoadBalancerInfoException(inner) => inner.fmt(f),
            Error::InvalidMinimumHealthyHostValueException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidOnPremisesTagCombinationException(inner) => inner.fmt(f),
            Error::InvalidOperationException(inner) => inner.fmt(f),
            Error::InvalidRegistrationStatusException(inner) => inner.fmt(f),
            Error::InvalidRevisionException(inner) => inner.fmt(f),
            Error::InvalidRoleException(inner) => inner.fmt(f),
            Error::InvalidSortByException(inner) => inner.fmt(f),
            Error::InvalidSortOrderException(inner) => inner.fmt(f),
            Error::InvalidTagException(inner) => inner.fmt(f),
            Error::InvalidTagFilterException(inner) => inner.fmt(f),
            Error::InvalidTagsToAddException(inner) => inner.fmt(f),
            Error::InvalidTargetFilterNameException(inner) => inner.fmt(f),
            Error::InvalidTargetGroupPairException(inner) => inner.fmt(f),
            Error::InvalidTargetInstancesException(inner) => inner.fmt(f),
            Error::InvalidTimeRangeException(inner) => inner.fmt(f),
            Error::InvalidTrafficRoutingConfigurationException(inner) => inner.fmt(f),
            Error::InvalidTriggerConfigException(inner) => inner.fmt(f),
            Error::InvalidUpdateOutdatedInstancesOnlyValueException(inner) => inner.fmt(f),
            Error::LifecycleEventAlreadyCompletedException(inner) => inner.fmt(f),
            Error::LifecycleHookLimitExceededException(inner) => inner.fmt(f),
            Error::MultipleIamArnsProvidedException(inner) => inner.fmt(f),
            Error::OperationNotSupportedException(inner) => inner.fmt(f),
            Error::ResourceArnRequiredException(inner) => inner.fmt(f),
            Error::ResourceValidationException(inner) => inner.fmt(f),
            Error::RevisionDoesNotExistException(inner) => inner.fmt(f),
            Error::RevisionRequiredException(inner) => inner.fmt(f),
            Error::RoleRequiredException(inner) => inner.fmt(f),
            Error::TagLimitExceededException(inner) => inner.fmt(f),
            Error::TagRequiredException(inner) => inner.fmt(f),
            Error::TagSetListLimitExceededException(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::TriggerTargetsLimitExceededException(inner) => inner.fmt(f),
            Error::UnsupportedActionForDeploymentTypeException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToOnPremisesInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToOnPremisesInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AddTagsToOnPremisesInstancesErrorKind::InstanceLimitExceededException(inner) => Error::InstanceLimitExceededException(inner),
                crate::error::AddTagsToOnPremisesInstancesErrorKind::InstanceNameRequiredException(inner) => Error::InstanceNameRequiredException(inner),
                crate::error::AddTagsToOnPremisesInstancesErrorKind::InstanceNotRegisteredException(inner) => Error::InstanceNotRegisteredException(inner),
                crate::error::AddTagsToOnPremisesInstancesErrorKind::InvalidInstanceNameException(inner) => Error::InvalidInstanceNameException(inner),
                crate::error::AddTagsToOnPremisesInstancesErrorKind::InvalidTagException(inner) => Error::InvalidTagException(inner),
                crate::error::AddTagsToOnPremisesInstancesErrorKind::TagLimitExceededException(inner) => Error::TagLimitExceededException(inner),
                crate::error::AddTagsToOnPremisesInstancesErrorKind::TagRequiredException(inner) => Error::TagRequiredException(inner),
                crate::error::AddTagsToOnPremisesInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationRevisionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationRevisionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetApplicationRevisionsErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::BatchGetApplicationRevisionsErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::BatchGetApplicationRevisionsErrorKind::BatchLimitExceededException(inner) => Error::BatchLimitExceededException(inner),
                crate::error::BatchGetApplicationRevisionsErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::BatchGetApplicationRevisionsErrorKind::InvalidRevisionException(inner) => Error::InvalidRevisionException(inner),
                crate::error::BatchGetApplicationRevisionsErrorKind::RevisionRequiredException(inner) => Error::RevisionRequiredException(inner),
                crate::error::BatchGetApplicationRevisionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetApplicationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetApplicationsErrorKind::ApplicationDoesNotExistException(
                    inner,
                ) => Error::ApplicationDoesNotExistException(inner),
                crate::error::BatchGetApplicationsErrorKind::ApplicationNameRequiredException(
                    inner,
                ) => Error::ApplicationNameRequiredException(inner),
                crate::error::BatchGetApplicationsErrorKind::BatchLimitExceededException(inner) => {
                    Error::BatchLimitExceededException(inner)
                }
                crate::error::BatchGetApplicationsErrorKind::InvalidApplicationNameException(
                    inner,
                ) => Error::InvalidApplicationNameException(inner),
                crate::error::BatchGetApplicationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetDeploymentGroupsErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::BatchGetDeploymentGroupsErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::BatchGetDeploymentGroupsErrorKind::BatchLimitExceededException(inner) => Error::BatchLimitExceededException(inner),
                crate::error::BatchGetDeploymentGroupsErrorKind::DeploymentConfigDoesNotExistException(inner) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::BatchGetDeploymentGroupsErrorKind::DeploymentGroupNameRequiredException(inner) => Error::DeploymentGroupNameRequiredException(inner),
                crate::error::BatchGetDeploymentGroupsErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::BatchGetDeploymentGroupsErrorKind::InvalidDeploymentGroupNameException(inner) => Error::InvalidDeploymentGroupNameException(inner),
                crate::error::BatchGetDeploymentGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetDeploymentInstancesErrorKind::BatchLimitExceededException(inner) => Error::BatchLimitExceededException(inner),
                crate::error::BatchGetDeploymentInstancesErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::BatchGetDeploymentInstancesErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::BatchGetDeploymentInstancesErrorKind::InstanceIdRequiredException(inner) => Error::InstanceIdRequiredException(inner),
                crate::error::BatchGetDeploymentInstancesErrorKind::InvalidComputePlatformException(inner) => Error::InvalidComputePlatformException(inner),
                crate::error::BatchGetDeploymentInstancesErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::BatchGetDeploymentInstancesErrorKind::InvalidInstanceNameException(inner) => Error::InvalidInstanceNameException(inner),
                crate::error::BatchGetDeploymentInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetDeploymentsErrorKind::BatchLimitExceededException(inner) => {
                    Error::BatchLimitExceededException(inner)
                }
                crate::error::BatchGetDeploymentsErrorKind::DeploymentIdRequiredException(
                    inner,
                ) => Error::DeploymentIdRequiredException(inner),
                crate::error::BatchGetDeploymentsErrorKind::InvalidDeploymentIdException(inner) => {
                    Error::InvalidDeploymentIdException(inner)
                }
                crate::error::BatchGetDeploymentsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetDeploymentTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetDeploymentTargetsErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::DeploymentNotStartedException(inner) => Error::DeploymentNotStartedException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::DeploymentTargetDoesNotExistException(inner) => Error::DeploymentTargetDoesNotExistException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::DeploymentTargetIdRequiredException(inner) => Error::DeploymentTargetIdRequiredException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::DeploymentTargetListSizeExceededException(inner) => Error::DeploymentTargetListSizeExceededException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::InstanceDoesNotExistException(inner) => Error::InstanceDoesNotExistException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::InvalidDeploymentTargetIdException(inner) => Error::InvalidDeploymentTargetIdException(inner),
                crate::error::BatchGetDeploymentTargetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetOnPremisesInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetOnPremisesInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetOnPremisesInstancesErrorKind::BatchLimitExceededException(inner) => Error::BatchLimitExceededException(inner),
                crate::error::BatchGetOnPremisesInstancesErrorKind::InstanceNameRequiredException(inner) => Error::InstanceNameRequiredException(inner),
                crate::error::BatchGetOnPremisesInstancesErrorKind::InvalidInstanceNameException(inner) => Error::InvalidInstanceNameException(inner),
                crate::error::BatchGetOnPremisesInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ContinueDeploymentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ContinueDeploymentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ContinueDeploymentErrorKind::DeploymentAlreadyCompletedException(inner) => Error::DeploymentAlreadyCompletedException(inner),
                crate::error::ContinueDeploymentErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::ContinueDeploymentErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::ContinueDeploymentErrorKind::DeploymentIsNotInReadyStateException(inner) => Error::DeploymentIsNotInReadyStateException(inner),
                crate::error::ContinueDeploymentErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::ContinueDeploymentErrorKind::InvalidDeploymentStatusException(inner) => Error::InvalidDeploymentStatusException(inner),
                crate::error::ContinueDeploymentErrorKind::InvalidDeploymentWaitTypeException(inner) => Error::InvalidDeploymentWaitTypeException(inner),
                crate::error::ContinueDeploymentErrorKind::UnsupportedActionForDeploymentTypeException(inner) => Error::UnsupportedActionForDeploymentTypeException(inner),
                crate::error::ContinueDeploymentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateApplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateApplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateApplicationErrorKind::ApplicationAlreadyExistsException(
                    inner,
                ) => Error::ApplicationAlreadyExistsException(inner),
                crate::error::CreateApplicationErrorKind::ApplicationLimitExceededException(
                    inner,
                ) => Error::ApplicationLimitExceededException(inner),
                crate::error::CreateApplicationErrorKind::ApplicationNameRequiredException(
                    inner,
                ) => Error::ApplicationNameRequiredException(inner),
                crate::error::CreateApplicationErrorKind::InvalidApplicationNameException(
                    inner,
                ) => Error::InvalidApplicationNameException(inner),
                crate::error::CreateApplicationErrorKind::InvalidComputePlatformException(
                    inner,
                ) => Error::InvalidComputePlatformException(inner),
                crate::error::CreateApplicationErrorKind::InvalidTagsToAddException(inner) => {
                    Error::InvalidTagsToAddException(inner)
                }
                crate::error::CreateApplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDeploymentErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::CreateDeploymentErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::CreateDeploymentErrorKind::DeploymentConfigDoesNotExistException(inner) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::CreateDeploymentErrorKind::DeploymentGroupDoesNotExistException(inner) => Error::DeploymentGroupDoesNotExistException(inner),
                crate::error::CreateDeploymentErrorKind::DeploymentGroupNameRequiredException(inner) => Error::DeploymentGroupNameRequiredException(inner),
                crate::error::CreateDeploymentErrorKind::DeploymentLimitExceededException(inner) => Error::DeploymentLimitExceededException(inner),
                crate::error::CreateDeploymentErrorKind::DescriptionTooLongException(inner) => Error::DescriptionTooLongException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidAutoRollbackConfigException(inner) => Error::InvalidAutoRollbackConfigException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidAutoScalingGroupException(inner) => Error::InvalidAutoScalingGroupException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidDeploymentConfigNameException(inner) => Error::InvalidDeploymentConfigNameException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidDeploymentGroupNameException(inner) => Error::InvalidDeploymentGroupNameException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidFileExistsBehaviorException(inner) => Error::InvalidFileExistsBehaviorException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidGitHubAccountTokenException(inner) => Error::InvalidGitHubAccountTokenException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidIgnoreApplicationStopFailuresValueException(inner) => Error::InvalidIgnoreApplicationStopFailuresValueException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidLoadBalancerInfoException(inner) => Error::InvalidLoadBalancerInfoException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidRevisionException(inner) => Error::InvalidRevisionException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidRoleException(inner) => Error::InvalidRoleException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidTargetInstancesException(inner) => Error::InvalidTargetInstancesException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidTrafficRoutingConfigurationException(inner) => Error::InvalidTrafficRoutingConfigurationException(inner),
                crate::error::CreateDeploymentErrorKind::InvalidUpdateOutdatedInstancesOnlyValueException(inner) => Error::InvalidUpdateOutdatedInstancesOnlyValueException(inner),
                crate::error::CreateDeploymentErrorKind::RevisionDoesNotExistException(inner) => Error::RevisionDoesNotExistException(inner),
                crate::error::CreateDeploymentErrorKind::RevisionRequiredException(inner) => Error::RevisionRequiredException(inner),
                crate::error::CreateDeploymentErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::CreateDeploymentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDeploymentConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDeploymentConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDeploymentConfigErrorKind::DeploymentConfigAlreadyExistsException(inner) => Error::DeploymentConfigAlreadyExistsException(inner),
                crate::error::CreateDeploymentConfigErrorKind::DeploymentConfigLimitExceededException(inner) => Error::DeploymentConfigLimitExceededException(inner),
                crate::error::CreateDeploymentConfigErrorKind::DeploymentConfigNameRequiredException(inner) => Error::DeploymentConfigNameRequiredException(inner),
                crate::error::CreateDeploymentConfigErrorKind::InvalidComputePlatformException(inner) => Error::InvalidComputePlatformException(inner),
                crate::error::CreateDeploymentConfigErrorKind::InvalidDeploymentConfigNameException(inner) => Error::InvalidDeploymentConfigNameException(inner),
                crate::error::CreateDeploymentConfigErrorKind::InvalidMinimumHealthyHostValueException(inner) => Error::InvalidMinimumHealthyHostValueException(inner),
                crate::error::CreateDeploymentConfigErrorKind::InvalidTrafficRoutingConfigurationException(inner) => Error::InvalidTrafficRoutingConfigurationException(inner),
                crate::error::CreateDeploymentConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDeploymentGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDeploymentGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDeploymentGroupErrorKind::AlarmsLimitExceededException(inner) => Error::AlarmsLimitExceededException(inner),
                crate::error::CreateDeploymentGroupErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::CreateDeploymentGroupErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::CreateDeploymentGroupErrorKind::DeploymentConfigDoesNotExistException(inner) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::CreateDeploymentGroupErrorKind::DeploymentGroupAlreadyExistsException(inner) => Error::DeploymentGroupAlreadyExistsException(inner),
                crate::error::CreateDeploymentGroupErrorKind::DeploymentGroupLimitExceededException(inner) => Error::DeploymentGroupLimitExceededException(inner),
                crate::error::CreateDeploymentGroupErrorKind::DeploymentGroupNameRequiredException(inner) => Error::DeploymentGroupNameRequiredException(inner),
                crate::error::CreateDeploymentGroupErrorKind::EcsServiceMappingLimitExceededException(inner) => Error::EcsServiceMappingLimitExceededException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidAlarmConfigException(inner) => Error::InvalidAlarmConfigException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidAutoRollbackConfigException(inner) => Error::InvalidAutoRollbackConfigException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidAutoScalingGroupException(inner) => Error::InvalidAutoScalingGroupException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidBlueGreenDeploymentConfigurationException(inner) => Error::InvalidBlueGreenDeploymentConfigurationException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidDeploymentConfigNameException(inner) => Error::InvalidDeploymentConfigNameException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidDeploymentGroupNameException(inner) => Error::InvalidDeploymentGroupNameException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidDeploymentStyleException(inner) => Error::InvalidDeploymentStyleException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidEc2TagCombinationException(inner) => Error::InvalidEc2TagCombinationException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidEc2TagException(inner) => Error::InvalidEc2TagException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidEcsServiceException(inner) => Error::InvalidEcsServiceException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidLoadBalancerInfoException(inner) => Error::InvalidLoadBalancerInfoException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidOnPremisesTagCombinationException(inner) => Error::InvalidOnPremisesTagCombinationException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidRoleException(inner) => Error::InvalidRoleException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidTagException(inner) => Error::InvalidTagException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidTagsToAddException(inner) => Error::InvalidTagsToAddException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidTargetGroupPairException(inner) => Error::InvalidTargetGroupPairException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidTrafficRoutingConfigurationException(inner) => Error::InvalidTrafficRoutingConfigurationException(inner),
                crate::error::CreateDeploymentGroupErrorKind::InvalidTriggerConfigException(inner) => Error::InvalidTriggerConfigException(inner),
                crate::error::CreateDeploymentGroupErrorKind::LifecycleHookLimitExceededException(inner) => Error::LifecycleHookLimitExceededException(inner),
                crate::error::CreateDeploymentGroupErrorKind::RoleRequiredException(inner) => Error::RoleRequiredException(inner),
                crate::error::CreateDeploymentGroupErrorKind::TagSetListLimitExceededException(inner) => Error::TagSetListLimitExceededException(inner),
                crate::error::CreateDeploymentGroupErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::CreateDeploymentGroupErrorKind::TriggerTargetsLimitExceededException(inner) => Error::TriggerTargetsLimitExceededException(inner),
                crate::error::CreateDeploymentGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteApplicationErrorKind::ApplicationNameRequiredException(
                    inner,
                ) => Error::ApplicationNameRequiredException(inner),
                crate::error::DeleteApplicationErrorKind::InvalidApplicationNameException(
                    inner,
                ) => Error::InvalidApplicationNameException(inner),
                crate::error::DeleteApplicationErrorKind::InvalidRoleException(inner) => {
                    Error::InvalidRoleException(inner)
                }
                crate::error::DeleteApplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDeploymentConfigErrorKind::DeploymentConfigInUseException(inner) => Error::DeploymentConfigInUseException(inner),
                crate::error::DeleteDeploymentConfigErrorKind::DeploymentConfigNameRequiredException(inner) => Error::DeploymentConfigNameRequiredException(inner),
                crate::error::DeleteDeploymentConfigErrorKind::InvalidDeploymentConfigNameException(inner) => Error::InvalidDeploymentConfigNameException(inner),
                crate::error::DeleteDeploymentConfigErrorKind::InvalidOperationException(inner) => Error::InvalidOperationException(inner),
                crate::error::DeleteDeploymentConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDeploymentGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDeploymentGroupErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::DeleteDeploymentGroupErrorKind::DeploymentGroupNameRequiredException(inner) => Error::DeploymentGroupNameRequiredException(inner),
                crate::error::DeleteDeploymentGroupErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::DeleteDeploymentGroupErrorKind::InvalidDeploymentGroupNameException(inner) => Error::InvalidDeploymentGroupNameException(inner),
                crate::error::DeleteDeploymentGroupErrorKind::InvalidRoleException(inner) => Error::InvalidRoleException(inner),
                crate::error::DeleteDeploymentGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGitHubAccountTokenError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteGitHubAccountTokenError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteGitHubAccountTokenErrorKind::GitHubAccountTokenDoesNotExistException(inner) => Error::GitHubAccountTokenDoesNotExistException(inner),
                crate::error::DeleteGitHubAccountTokenErrorKind::GitHubAccountTokenNameRequiredException(inner) => Error::GitHubAccountTokenNameRequiredException(inner),
                crate::error::DeleteGitHubAccountTokenErrorKind::InvalidGitHubAccountTokenNameException(inner) => Error::InvalidGitHubAccountTokenNameException(inner),
                crate::error::DeleteGitHubAccountTokenErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::DeleteGitHubAccountTokenErrorKind::ResourceValidationException(inner) => Error::ResourceValidationException(inner),
                crate::error::DeleteGitHubAccountTokenErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResourcesByExternalIdError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResourcesByExternalIdError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteResourcesByExternalIdErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterOnPremisesInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterOnPremisesInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterOnPremisesInstanceErrorKind::InstanceNameRequiredException(inner) => Error::InstanceNameRequiredException(inner),
                crate::error::DeregisterOnPremisesInstanceErrorKind::InvalidInstanceNameException(inner) => Error::InvalidInstanceNameException(inner),
                crate::error::DeregisterOnPremisesInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetApplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetApplicationError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetApplicationErrorKind::ApplicationDoesNotExistException(inner) => {
                    Error::ApplicationDoesNotExistException(inner)
                }
                crate::error::GetApplicationErrorKind::ApplicationNameRequiredException(inner) => {
                    Error::ApplicationNameRequiredException(inner)
                }
                crate::error::GetApplicationErrorKind::InvalidApplicationNameException(inner) => {
                    Error::InvalidApplicationNameException(inner)
                }
                crate::error::GetApplicationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetApplicationRevisionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetApplicationRevisionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetApplicationRevisionErrorKind::ApplicationDoesNotExistException(
                    inner,
                ) => Error::ApplicationDoesNotExistException(inner),
                crate::error::GetApplicationRevisionErrorKind::ApplicationNameRequiredException(
                    inner,
                ) => Error::ApplicationNameRequiredException(inner),
                crate::error::GetApplicationRevisionErrorKind::InvalidApplicationNameException(
                    inner,
                ) => Error::InvalidApplicationNameException(inner),
                crate::error::GetApplicationRevisionErrorKind::InvalidRevisionException(inner) => {
                    Error::InvalidRevisionException(inner)
                }
                crate::error::GetApplicationRevisionErrorKind::RevisionDoesNotExistException(
                    inner,
                ) => Error::RevisionDoesNotExistException(inner),
                crate::error::GetApplicationRevisionErrorKind::RevisionRequiredException(inner) => {
                    Error::RevisionRequiredException(inner)
                }
                crate::error::GetApplicationRevisionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDeploymentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDeploymentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDeploymentErrorKind::DeploymentDoesNotExistException(inner) => {
                    Error::DeploymentDoesNotExistException(inner)
                }
                crate::error::GetDeploymentErrorKind::DeploymentIdRequiredException(inner) => {
                    Error::DeploymentIdRequiredException(inner)
                }
                crate::error::GetDeploymentErrorKind::InvalidDeploymentIdException(inner) => {
                    Error::InvalidDeploymentIdException(inner)
                }
                crate::error::GetDeploymentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDeploymentConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDeploymentConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDeploymentConfigErrorKind::DeploymentConfigDoesNotExistException(inner) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::GetDeploymentConfigErrorKind::DeploymentConfigNameRequiredException(inner) => Error::DeploymentConfigNameRequiredException(inner),
                crate::error::GetDeploymentConfigErrorKind::InvalidComputePlatformException(inner) => Error::InvalidComputePlatformException(inner),
                crate::error::GetDeploymentConfigErrorKind::InvalidDeploymentConfigNameException(inner) => Error::InvalidDeploymentConfigNameException(inner),
                crate::error::GetDeploymentConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDeploymentGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDeploymentGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDeploymentGroupErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::GetDeploymentGroupErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::GetDeploymentGroupErrorKind::DeploymentConfigDoesNotExistException(inner) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::GetDeploymentGroupErrorKind::DeploymentGroupDoesNotExistException(inner) => Error::DeploymentGroupDoesNotExistException(inner),
                crate::error::GetDeploymentGroupErrorKind::DeploymentGroupNameRequiredException(inner) => Error::DeploymentGroupNameRequiredException(inner),
                crate::error::GetDeploymentGroupErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::GetDeploymentGroupErrorKind::InvalidDeploymentGroupNameException(inner) => Error::InvalidDeploymentGroupNameException(inner),
                crate::error::GetDeploymentGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDeploymentInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDeploymentInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDeploymentInstanceErrorKind::DeploymentDoesNotExistException(
                    inner,
                ) => Error::DeploymentDoesNotExistException(inner),
                crate::error::GetDeploymentInstanceErrorKind::DeploymentIdRequiredException(
                    inner,
                ) => Error::DeploymentIdRequiredException(inner),
                crate::error::GetDeploymentInstanceErrorKind::InstanceDoesNotExistException(
                    inner,
                ) => Error::InstanceDoesNotExistException(inner),
                crate::error::GetDeploymentInstanceErrorKind::InstanceIdRequiredException(
                    inner,
                ) => Error::InstanceIdRequiredException(inner),
                crate::error::GetDeploymentInstanceErrorKind::InvalidComputePlatformException(
                    inner,
                ) => Error::InvalidComputePlatformException(inner),
                crate::error::GetDeploymentInstanceErrorKind::InvalidDeploymentIdException(
                    inner,
                ) => Error::InvalidDeploymentIdException(inner),
                crate::error::GetDeploymentInstanceErrorKind::InvalidInstanceNameException(
                    inner,
                ) => Error::InvalidInstanceNameException(inner),
                crate::error::GetDeploymentInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDeploymentTargetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDeploymentTargetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDeploymentTargetErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::GetDeploymentTargetErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::GetDeploymentTargetErrorKind::DeploymentNotStartedException(inner) => Error::DeploymentNotStartedException(inner),
                crate::error::GetDeploymentTargetErrorKind::DeploymentTargetDoesNotExistException(inner) => Error::DeploymentTargetDoesNotExistException(inner),
                crate::error::GetDeploymentTargetErrorKind::DeploymentTargetIdRequiredException(inner) => Error::DeploymentTargetIdRequiredException(inner),
                crate::error::GetDeploymentTargetErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::GetDeploymentTargetErrorKind::InvalidDeploymentTargetIdException(inner) => Error::InvalidDeploymentTargetIdException(inner),
                crate::error::GetDeploymentTargetErrorKind::InvalidInstanceNameException(inner) => Error::InvalidInstanceNameException(inner),
                crate::error::GetDeploymentTargetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOnPremisesInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetOnPremisesInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOnPremisesInstanceErrorKind::InstanceNameRequiredException(
                    inner,
                ) => Error::InstanceNameRequiredException(inner),
                crate::error::GetOnPremisesInstanceErrorKind::InstanceNotRegisteredException(
                    inner,
                ) => Error::InstanceNotRegisteredException(inner),
                crate::error::GetOnPremisesInstanceErrorKind::InvalidInstanceNameException(
                    inner,
                ) => Error::InvalidInstanceNameException(inner),
                crate::error::GetOnPremisesInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListApplicationRevisionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListApplicationRevisionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListApplicationRevisionsErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::ListApplicationRevisionsErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::ListApplicationRevisionsErrorKind::BucketNameFilterRequiredException(inner) => Error::BucketNameFilterRequiredException(inner),
                crate::error::ListApplicationRevisionsErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::ListApplicationRevisionsErrorKind::InvalidBucketNameFilterException(inner) => Error::InvalidBucketNameFilterException(inner),
                crate::error::ListApplicationRevisionsErrorKind::InvalidDeployedStateFilterException(inner) => Error::InvalidDeployedStateFilterException(inner),
                crate::error::ListApplicationRevisionsErrorKind::InvalidKeyPrefixFilterException(inner) => Error::InvalidKeyPrefixFilterException(inner),
                crate::error::ListApplicationRevisionsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListApplicationRevisionsErrorKind::InvalidSortByException(inner) => Error::InvalidSortByException(inner),
                crate::error::ListApplicationRevisionsErrorKind::InvalidSortOrderException(inner) => Error::InvalidSortOrderException(inner),
                crate::error::ListApplicationRevisionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListApplicationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListApplicationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListApplicationsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListApplicationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDeploymentConfigsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDeploymentConfigsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDeploymentConfigsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListDeploymentConfigsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDeploymentGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDeploymentGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDeploymentGroupsErrorKind::ApplicationDoesNotExistException(
                    inner,
                ) => Error::ApplicationDoesNotExistException(inner),
                crate::error::ListDeploymentGroupsErrorKind::ApplicationNameRequiredException(
                    inner,
                ) => Error::ApplicationNameRequiredException(inner),
                crate::error::ListDeploymentGroupsErrorKind::InvalidApplicationNameException(
                    inner,
                ) => Error::InvalidApplicationNameException(inner),
                crate::error::ListDeploymentGroupsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListDeploymentGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDeploymentInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDeploymentInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDeploymentInstancesErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::ListDeploymentInstancesErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::ListDeploymentInstancesErrorKind::DeploymentNotStartedException(inner) => Error::DeploymentNotStartedException(inner),
                crate::error::ListDeploymentInstancesErrorKind::InvalidComputePlatformException(inner) => Error::InvalidComputePlatformException(inner),
                crate::error::ListDeploymentInstancesErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::ListDeploymentInstancesErrorKind::InvalidDeploymentInstanceTypeException(inner) => Error::InvalidDeploymentInstanceTypeException(inner),
                crate::error::ListDeploymentInstancesErrorKind::InvalidInstanceStatusException(inner) => Error::InvalidInstanceStatusException(inner),
                crate::error::ListDeploymentInstancesErrorKind::InvalidInstanceTypeException(inner) => Error::InvalidInstanceTypeException(inner),
                crate::error::ListDeploymentInstancesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListDeploymentInstancesErrorKind::InvalidTargetFilterNameException(inner) => Error::InvalidTargetFilterNameException(inner),
                crate::error::ListDeploymentInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDeploymentsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListDeploymentsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDeploymentsErrorKind::ApplicationDoesNotExistException(inner) => {
                    Error::ApplicationDoesNotExistException(inner)
                }
                crate::error::ListDeploymentsErrorKind::ApplicationNameRequiredException(inner) => {
                    Error::ApplicationNameRequiredException(inner)
                }
                crate::error::ListDeploymentsErrorKind::DeploymentGroupDoesNotExistException(
                    inner,
                ) => Error::DeploymentGroupDoesNotExistException(inner),
                crate::error::ListDeploymentsErrorKind::DeploymentGroupNameRequiredException(
                    inner,
                ) => Error::DeploymentGroupNameRequiredException(inner),
                crate::error::ListDeploymentsErrorKind::InvalidApplicationNameException(inner) => {
                    Error::InvalidApplicationNameException(inner)
                }
                crate::error::ListDeploymentsErrorKind::InvalidDeploymentGroupNameException(
                    inner,
                ) => Error::InvalidDeploymentGroupNameException(inner),
                crate::error::ListDeploymentsErrorKind::InvalidDeploymentStatusException(inner) => {
                    Error::InvalidDeploymentStatusException(inner)
                }
                crate::error::ListDeploymentsErrorKind::InvalidExternalIdException(inner) => {
                    Error::InvalidExternalIdException(inner)
                }
                crate::error::ListDeploymentsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListDeploymentsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListDeploymentsErrorKind::InvalidTimeRangeException(inner) => {
                    Error::InvalidTimeRangeException(inner)
                }
                crate::error::ListDeploymentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDeploymentTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDeploymentTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDeploymentTargetsErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::ListDeploymentTargetsErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::ListDeploymentTargetsErrorKind::DeploymentNotStartedException(inner) => Error::DeploymentNotStartedException(inner),
                crate::error::ListDeploymentTargetsErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::ListDeploymentTargetsErrorKind::InvalidDeploymentInstanceTypeException(inner) => Error::InvalidDeploymentInstanceTypeException(inner),
                crate::error::ListDeploymentTargetsErrorKind::InvalidInstanceStatusException(inner) => Error::InvalidInstanceStatusException(inner),
                crate::error::ListDeploymentTargetsErrorKind::InvalidInstanceTypeException(inner) => Error::InvalidInstanceTypeException(inner),
                crate::error::ListDeploymentTargetsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListDeploymentTargetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGitHubAccountTokenNamesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListGitHubAccountTokenNamesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListGitHubAccountTokenNamesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListGitHubAccountTokenNamesErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::ListGitHubAccountTokenNamesErrorKind::ResourceValidationException(inner) => Error::ResourceValidationException(inner),
                crate::error::ListGitHubAccountTokenNamesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOnPremisesInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListOnPremisesInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListOnPremisesInstancesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListOnPremisesInstancesErrorKind::InvalidRegistrationStatusException(inner) => Error::InvalidRegistrationStatusException(inner),
                crate::error::ListOnPremisesInstancesErrorKind::InvalidTagFilterException(inner) => Error::InvalidTagFilterException(inner),
                crate::error::ListOnPremisesInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::ArnNotSupportedException(inner) => {
                    Error::ArnNotSupportedException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceArnRequiredException(inner) => {
                    Error::ResourceArnRequiredException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::PutLifecycleEventHookExecutionStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PutLifecycleEventHookExecutionStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::InvalidLifecycleEventHookExecutionIdException(inner) => Error::InvalidLifecycleEventHookExecutionIdException(inner),
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::InvalidLifecycleEventHookExecutionStatusException(inner) => Error::InvalidLifecycleEventHookExecutionStatusException(inner),
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::LifecycleEventAlreadyCompletedException(inner) => Error::LifecycleEventAlreadyCompletedException(inner),
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::UnsupportedActionForDeploymentTypeException(inner) => Error::UnsupportedActionForDeploymentTypeException(inner),
                crate::error::PutLifecycleEventHookExecutionStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterApplicationRevisionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterApplicationRevisionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterApplicationRevisionErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::RegisterApplicationRevisionErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::RegisterApplicationRevisionErrorKind::DescriptionTooLongException(inner) => Error::DescriptionTooLongException(inner),
                crate::error::RegisterApplicationRevisionErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::RegisterApplicationRevisionErrorKind::InvalidRevisionException(inner) => Error::InvalidRevisionException(inner),
                crate::error::RegisterApplicationRevisionErrorKind::RevisionRequiredException(inner) => Error::RevisionRequiredException(inner),
                crate::error::RegisterApplicationRevisionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterOnPremisesInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterOnPremisesInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterOnPremisesInstanceErrorKind::IamArnRequiredException(inner) => Error::IamArnRequiredException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::IamSessionArnAlreadyRegisteredException(inner) => Error::IamSessionArnAlreadyRegisteredException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::IamUserArnAlreadyRegisteredException(inner) => Error::IamUserArnAlreadyRegisteredException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::IamUserArnRequiredException(inner) => Error::IamUserArnRequiredException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::InstanceNameAlreadyRegisteredException(inner) => Error::InstanceNameAlreadyRegisteredException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::InstanceNameRequiredException(inner) => Error::InstanceNameRequiredException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::InvalidIamSessionArnException(inner) => Error::InvalidIamSessionArnException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::InvalidIamUserArnException(inner) => Error::InvalidIamUserArnException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::InvalidInstanceNameException(inner) => Error::InvalidInstanceNameException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::MultipleIamArnsProvidedException(inner) => Error::MultipleIamArnsProvidedException(inner),
                crate::error::RegisterOnPremisesInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromOnPremisesInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RemoveTagsFromOnPremisesInstancesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::InstanceLimitExceededException(inner) => Error::InstanceLimitExceededException(inner),
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::InstanceNameRequiredException(inner) => Error::InstanceNameRequiredException(inner),
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::InstanceNotRegisteredException(inner) => Error::InstanceNotRegisteredException(inner),
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::InvalidInstanceNameException(inner) => Error::InvalidInstanceNameException(inner),
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::InvalidTagException(inner) => Error::InvalidTagException(inner),
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::TagLimitExceededException(inner) => Error::TagLimitExceededException(inner),
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::TagRequiredException(inner) => Error::TagRequiredException(inner),
                crate::error::RemoveTagsFromOnPremisesInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::SkipWaitTimeForInstanceTerminationError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::SkipWaitTimeForInstanceTerminationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::SkipWaitTimeForInstanceTerminationErrorKind::DeploymentAlreadyCompletedException(inner) => Error::DeploymentAlreadyCompletedException(inner),
                crate::error::SkipWaitTimeForInstanceTerminationErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::SkipWaitTimeForInstanceTerminationErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::SkipWaitTimeForInstanceTerminationErrorKind::DeploymentNotStartedException(inner) => Error::DeploymentNotStartedException(inner),
                crate::error::SkipWaitTimeForInstanceTerminationErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::SkipWaitTimeForInstanceTerminationErrorKind::UnsupportedActionForDeploymentTypeException(inner) => Error::UnsupportedActionForDeploymentTypeException(inner),
                crate::error::SkipWaitTimeForInstanceTerminationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopDeploymentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopDeploymentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopDeploymentErrorKind::DeploymentAlreadyCompletedException(inner) => Error::DeploymentAlreadyCompletedException(inner),
                crate::error::StopDeploymentErrorKind::DeploymentDoesNotExistException(inner) => Error::DeploymentDoesNotExistException(inner),
                crate::error::StopDeploymentErrorKind::DeploymentGroupDoesNotExistException(inner) => Error::DeploymentGroupDoesNotExistException(inner),
                crate::error::StopDeploymentErrorKind::DeploymentIdRequiredException(inner) => Error::DeploymentIdRequiredException(inner),
                crate::error::StopDeploymentErrorKind::InvalidDeploymentIdException(inner) => Error::InvalidDeploymentIdException(inner),
                crate::error::StopDeploymentErrorKind::UnsupportedActionForDeploymentTypeException(inner) => Error::UnsupportedActionForDeploymentTypeException(inner),
                crate::error::StopDeploymentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::ApplicationDoesNotExistException(inner) => {
                    Error::ApplicationDoesNotExistException(inner)
                }
                crate::error::TagResourceErrorKind::ArnNotSupportedException(inner) => {
                    Error::ArnNotSupportedException(inner)
                }
                crate::error::TagResourceErrorKind::DeploymentConfigDoesNotExistException(
                    inner,
                ) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::TagResourceErrorKind::DeploymentGroupDoesNotExistException(inner) => {
                    Error::DeploymentGroupDoesNotExistException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidTagsToAddException(inner) => {
                    Error::InvalidTagsToAddException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceArnRequiredException(inner) => {
                    Error::ResourceArnRequiredException(inner)
                }
                crate::error::TagResourceErrorKind::TagRequiredException(inner) => {
                    Error::TagRequiredException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ApplicationDoesNotExistException(inner) => {
                    Error::ApplicationDoesNotExistException(inner)
                }
                crate::error::UntagResourceErrorKind::ArnNotSupportedException(inner) => {
                    Error::ArnNotSupportedException(inner)
                }
                crate::error::UntagResourceErrorKind::DeploymentConfigDoesNotExistException(
                    inner,
                ) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::UntagResourceErrorKind::DeploymentGroupDoesNotExistException(
                    inner,
                ) => Error::DeploymentGroupDoesNotExistException(inner),
                crate::error::UntagResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidTagsToAddException(inner) => {
                    Error::InvalidTagsToAddException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceArnRequiredException(inner) => {
                    Error::ResourceArnRequiredException(inner)
                }
                crate::error::UntagResourceErrorKind::TagRequiredException(inner) => {
                    Error::TagRequiredException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateApplicationErrorKind::ApplicationAlreadyExistsException(
                    inner,
                ) => Error::ApplicationAlreadyExistsException(inner),
                crate::error::UpdateApplicationErrorKind::ApplicationDoesNotExistException(
                    inner,
                ) => Error::ApplicationDoesNotExistException(inner),
                crate::error::UpdateApplicationErrorKind::ApplicationNameRequiredException(
                    inner,
                ) => Error::ApplicationNameRequiredException(inner),
                crate::error::UpdateApplicationErrorKind::InvalidApplicationNameException(
                    inner,
                ) => Error::InvalidApplicationNameException(inner),
                crate::error::UpdateApplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDeploymentGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDeploymentGroupErrorKind::AlarmsLimitExceededException(inner) => Error::AlarmsLimitExceededException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::ApplicationDoesNotExistException(inner) => Error::ApplicationDoesNotExistException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::ApplicationNameRequiredException(inner) => Error::ApplicationNameRequiredException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::DeploymentConfigDoesNotExistException(inner) => Error::DeploymentConfigDoesNotExistException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::DeploymentGroupAlreadyExistsException(inner) => Error::DeploymentGroupAlreadyExistsException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::DeploymentGroupDoesNotExistException(inner) => Error::DeploymentGroupDoesNotExistException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::DeploymentGroupNameRequiredException(inner) => Error::DeploymentGroupNameRequiredException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::EcsServiceMappingLimitExceededException(inner) => Error::EcsServiceMappingLimitExceededException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidAlarmConfigException(inner) => Error::InvalidAlarmConfigException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidApplicationNameException(inner) => Error::InvalidApplicationNameException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidAutoRollbackConfigException(inner) => Error::InvalidAutoRollbackConfigException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidAutoScalingGroupException(inner) => Error::InvalidAutoScalingGroupException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidBlueGreenDeploymentConfigurationException(inner) => Error::InvalidBlueGreenDeploymentConfigurationException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidDeploymentConfigNameException(inner) => Error::InvalidDeploymentConfigNameException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidDeploymentGroupNameException(inner) => Error::InvalidDeploymentGroupNameException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidDeploymentStyleException(inner) => Error::InvalidDeploymentStyleException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidEc2TagCombinationException(inner) => Error::InvalidEc2TagCombinationException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidEc2TagException(inner) => Error::InvalidEc2TagException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidEcsServiceException(inner) => Error::InvalidEcsServiceException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidLoadBalancerInfoException(inner) => Error::InvalidLoadBalancerInfoException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidOnPremisesTagCombinationException(inner) => Error::InvalidOnPremisesTagCombinationException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidRoleException(inner) => Error::InvalidRoleException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidTagException(inner) => Error::InvalidTagException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidTargetGroupPairException(inner) => Error::InvalidTargetGroupPairException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidTrafficRoutingConfigurationException(inner) => Error::InvalidTrafficRoutingConfigurationException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::InvalidTriggerConfigException(inner) => Error::InvalidTriggerConfigException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::LifecycleHookLimitExceededException(inner) => Error::LifecycleHookLimitExceededException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::TagSetListLimitExceededException(inner) => Error::TagSetListLimitExceededException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::TriggerTargetsLimitExceededException(inner) => Error::TriggerTargetsLimitExceededException(inner),
                crate::error::UpdateDeploymentGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
