// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the output of an <code>UpdateDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeploymentGroupOutput {
    /// <p>If the output contains no data, and the corresponding deployment group contained at
    /// least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto
    /// Scaling lifecycle event hooks from the AWS account. If the output contains data, AWS
    /// CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the AWS
    /// account.</p>
    pub hooks_not_cleaned_up: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
}
impl std::fmt::Debug for UpdateDeploymentGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeploymentGroupOutput");
        formatter.field("hooks_not_cleaned_up", &self.hooks_not_cleaned_up);
        formatter.finish()
    }
}
/// See [`UpdateDeploymentGroupOutput`](crate::output::UpdateDeploymentGroupOutput)
pub mod update_deployment_group_output {
    /// A builder for [`UpdateDeploymentGroupOutput`](crate::output::UpdateDeploymentGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hooks_not_cleaned_up:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
    }
    impl Builder {
        /// Appends an item to `hooks_not_cleaned_up`.
        ///
        /// To override the contents of this collection use [`set_hooks_not_cleaned_up`](Self::set_hooks_not_cleaned_up).
        ///
        /// <p>If the output contains no data, and the corresponding deployment group contained at
        /// least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto
        /// Scaling lifecycle event hooks from the AWS account. If the output contains data, AWS
        /// CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the AWS
        /// account.</p>
        pub fn hooks_not_cleaned_up(
            mut self,
            input: impl Into<crate::model::AutoScalingGroup>,
        ) -> Self {
            let mut v = self.hooks_not_cleaned_up.unwrap_or_default();
            v.push(input.into());
            self.hooks_not_cleaned_up = Some(v);
            self
        }
        /// <p>If the output contains no data, and the corresponding deployment group contained at
        /// least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto
        /// Scaling lifecycle event hooks from the AWS account. If the output contains data, AWS
        /// CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the AWS
        /// account.</p>
        pub fn set_hooks_not_cleaned_up(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        ) -> Self {
            self.hooks_not_cleaned_up = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeploymentGroupOutput`](crate::output::UpdateDeploymentGroupOutput)
        pub fn build(self) -> crate::output::UpdateDeploymentGroupOutput {
            crate::output::UpdateDeploymentGroupOutput {
                hooks_not_cleaned_up: self.hooks_not_cleaned_up,
            }
        }
    }
}
impl UpdateDeploymentGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeploymentGroupOutput`](crate::output::UpdateDeploymentGroupOutput)
    pub fn builder() -> crate::output::update_deployment_group_output::Builder {
        crate::output::update_deployment_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationOutput {}
impl std::fmt::Debug for UpdateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationOutput");
        formatter.finish()
    }
}
/// See [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
pub mod update_application_output {
    /// A builder for [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
        pub fn build(self) -> crate::output::UpdateApplicationOutput {
            crate::output::UpdateApplicationOutput {}
        }
    }
}
impl UpdateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    pub fn builder() -> crate::output::update_application_output::Builder {
        crate::output::update_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>StopDeployment</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDeploymentOutput {
    /// <p>The status of the stop deployment operation:</p>
    /// <ul>
    /// <li>
    /// <p>Pending: The stop operation is pending.</p>
    /// </li>
    /// <li>
    /// <p>Succeeded: The stop operation was successful.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StopStatus>,
    /// <p>An accompanying status message.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDeploymentOutput");
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
pub mod stop_deployment_output {
    /// A builder for [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::StopStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the stop deployment operation:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The stop operation is pending.</p>
        /// </li>
        /// <li>
        /// <p>Succeeded: The stop operation was successful.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StopStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stop deployment operation:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The stop operation is pending.</p>
        /// </li>
        /// <li>
        /// <p>Succeeded: The stop operation was successful.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StopStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>An accompanying status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>An accompanying status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
        pub fn build(self) -> crate::output::StopDeploymentOutput {
            crate::output::StopDeploymentOutput {
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl StopDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`StopDeploymentOutput`](crate::output::StopDeploymentOutput)
    pub fn builder() -> crate::output::stop_deployment_output::Builder {
        crate::output::stop_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkipWaitTimeForInstanceTerminationOutput {}
impl std::fmt::Debug for SkipWaitTimeForInstanceTerminationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkipWaitTimeForInstanceTerminationOutput");
        formatter.finish()
    }
}
/// See [`SkipWaitTimeForInstanceTerminationOutput`](crate::output::SkipWaitTimeForInstanceTerminationOutput)
pub mod skip_wait_time_for_instance_termination_output {
    /// A builder for [`SkipWaitTimeForInstanceTerminationOutput`](crate::output::SkipWaitTimeForInstanceTerminationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SkipWaitTimeForInstanceTerminationOutput`](crate::output::SkipWaitTimeForInstanceTerminationOutput)
        pub fn build(self) -> crate::output::SkipWaitTimeForInstanceTerminationOutput {
            crate::output::SkipWaitTimeForInstanceTerminationOutput {}
        }
    }
}
impl SkipWaitTimeForInstanceTerminationOutput {
    /// Creates a new builder-style object to manufacture [`SkipWaitTimeForInstanceTerminationOutput`](crate::output::SkipWaitTimeForInstanceTerminationOutput)
    pub fn builder() -> crate::output::skip_wait_time_for_instance_termination_output::Builder {
        crate::output::skip_wait_time_for_instance_termination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromOnPremisesInstancesOutput {}
impl std::fmt::Debug for RemoveTagsFromOnPremisesInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromOnPremisesInstancesOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsFromOnPremisesInstancesOutput`](crate::output::RemoveTagsFromOnPremisesInstancesOutput)
pub mod remove_tags_from_on_premises_instances_output {
    /// A builder for [`RemoveTagsFromOnPremisesInstancesOutput`](crate::output::RemoveTagsFromOnPremisesInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsFromOnPremisesInstancesOutput`](crate::output::RemoveTagsFromOnPremisesInstancesOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromOnPremisesInstancesOutput {
            crate::output::RemoveTagsFromOnPremisesInstancesOutput {}
        }
    }
}
impl RemoveTagsFromOnPremisesInstancesOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromOnPremisesInstancesOutput`](crate::output::RemoveTagsFromOnPremisesInstancesOutput)
    pub fn builder() -> crate::output::remove_tags_from_on_premises_instances_output::Builder {
        crate::output::remove_tags_from_on_premises_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterOnPremisesInstanceOutput {}
impl std::fmt::Debug for RegisterOnPremisesInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterOnPremisesInstanceOutput");
        formatter.finish()
    }
}
/// See [`RegisterOnPremisesInstanceOutput`](crate::output::RegisterOnPremisesInstanceOutput)
pub mod register_on_premises_instance_output {
    /// A builder for [`RegisterOnPremisesInstanceOutput`](crate::output::RegisterOnPremisesInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterOnPremisesInstanceOutput`](crate::output::RegisterOnPremisesInstanceOutput)
        pub fn build(self) -> crate::output::RegisterOnPremisesInstanceOutput {
            crate::output::RegisterOnPremisesInstanceOutput {}
        }
    }
}
impl RegisterOnPremisesInstanceOutput {
    /// Creates a new builder-style object to manufacture [`RegisterOnPremisesInstanceOutput`](crate::output::RegisterOnPremisesInstanceOutput)
    pub fn builder() -> crate::output::register_on_premises_instance_output::Builder {
        crate::output::register_on_premises_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterApplicationRevisionOutput {}
impl std::fmt::Debug for RegisterApplicationRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterApplicationRevisionOutput");
        formatter.finish()
    }
}
/// See [`RegisterApplicationRevisionOutput`](crate::output::RegisterApplicationRevisionOutput)
pub mod register_application_revision_output {
    /// A builder for [`RegisterApplicationRevisionOutput`](crate::output::RegisterApplicationRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterApplicationRevisionOutput`](crate::output::RegisterApplicationRevisionOutput)
        pub fn build(self) -> crate::output::RegisterApplicationRevisionOutput {
            crate::output::RegisterApplicationRevisionOutput {}
        }
    }
}
impl RegisterApplicationRevisionOutput {
    /// Creates a new builder-style object to manufacture [`RegisterApplicationRevisionOutput`](crate::output::RegisterApplicationRevisionOutput)
    pub fn builder() -> crate::output::register_application_revision_output::Builder {
        crate::output::register_application_revision_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLifecycleEventHookExecutionStatusOutput {
    /// <p>The execution ID of the lifecycle event hook. A hook is specified in the
    /// <code>hooks</code> section of the deployment's AppSpec file.</p>
    pub lifecycle_event_hook_execution_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutLifecycleEventHookExecutionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLifecycleEventHookExecutionStatusOutput");
        formatter.field(
            "lifecycle_event_hook_execution_id",
            &self.lifecycle_event_hook_execution_id,
        );
        formatter.finish()
    }
}
/// See [`PutLifecycleEventHookExecutionStatusOutput`](crate::output::PutLifecycleEventHookExecutionStatusOutput)
pub mod put_lifecycle_event_hook_execution_status_output {
    /// A builder for [`PutLifecycleEventHookExecutionStatusOutput`](crate::output::PutLifecycleEventHookExecutionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_event_hook_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The execution ID of the lifecycle event hook. A hook is specified in the
        /// <code>hooks</code> section of the deployment's AppSpec file.</p>
        pub fn lifecycle_event_hook_execution_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.lifecycle_event_hook_execution_id = Some(input.into());
            self
        }
        /// <p>The execution ID of the lifecycle event hook. A hook is specified in the
        /// <code>hooks</code> section of the deployment's AppSpec file.</p>
        pub fn set_lifecycle_event_hook_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_event_hook_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLifecycleEventHookExecutionStatusOutput`](crate::output::PutLifecycleEventHookExecutionStatusOutput)
        pub fn build(self) -> crate::output::PutLifecycleEventHookExecutionStatusOutput {
            crate::output::PutLifecycleEventHookExecutionStatusOutput {
                lifecycle_event_hook_execution_id: self.lifecycle_event_hook_execution_id,
            }
        }
    }
}
impl PutLifecycleEventHookExecutionStatusOutput {
    /// Creates a new builder-style object to manufacture [`PutLifecycleEventHookExecutionStatusOutput`](crate::output::PutLifecycleEventHookExecutionStatusOutput)
    pub fn builder() -> crate::output::put_lifecycle_event_hook_execution_status_output::Builder {
        crate::output::put_lifecycle_event_hook_execution_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p> A list of tags returned by <code>ListTagsForResource</code>. The tags are associated
    /// with the resource identified by the input <code>ResourceArn</code> parameter. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list application revisions call to return the next set of
    /// application revisions in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A list of tags returned by <code>ListTagsForResource</code>. The tags are associated
        /// with the resource identified by the input <code>ResourceArn</code> parameter. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p> A list of tags returned by <code>ListTagsForResource</code>. The tags are associated
        /// with the resource identified by the input <code>ResourceArn</code> parameter. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list application revisions call to return the next set of
        /// application revisions in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list application revisions call to return the next set of
        /// application revisions in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>Represents the output of the list on-premises instances operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOnPremisesInstancesOutput {
    /// <p>The list of matching on-premises instance names.</p>
    pub instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list on-premises instances call to return the next set of
    /// on-premises instances in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListOnPremisesInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOnPremisesInstancesOutput");
        formatter.field("instance_names", &self.instance_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOnPremisesInstancesOutput`](crate::output::ListOnPremisesInstancesOutput)
pub mod list_on_premises_instances_output {
    /// A builder for [`ListOnPremisesInstancesOutput`](crate::output::ListOnPremisesInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The list of matching on-premises instance names.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>The list of matching on-premises instance names.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list on-premises instances call to return the next set of
        /// on-premises instances in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list on-premises instances call to return the next set of
        /// on-premises instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOnPremisesInstancesOutput`](crate::output::ListOnPremisesInstancesOutput)
        pub fn build(self) -> crate::output::ListOnPremisesInstancesOutput {
            crate::output::ListOnPremisesInstancesOutput {
                instance_names: self.instance_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOnPremisesInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListOnPremisesInstancesOutput`](crate::output::ListOnPremisesInstancesOutput)
    pub fn builder() -> crate::output::list_on_premises_instances_output::Builder {
        crate::output::list_on_premises_instances_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListGitHubAccountTokenNames</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGitHubAccountTokenNamesOutput {
    /// <p>A list of names of connections to GitHub accounts.</p>
    pub token_name_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent <code>ListGitHubAccountTokenNames</code> call to return the next
    /// set of names in the list. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGitHubAccountTokenNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGitHubAccountTokenNamesOutput");
        formatter.field("token_name_list", &self.token_name_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGitHubAccountTokenNamesOutput`](crate::output::ListGitHubAccountTokenNamesOutput)
pub mod list_git_hub_account_token_names_output {
    /// A builder for [`ListGitHubAccountTokenNamesOutput`](crate::output::ListGitHubAccountTokenNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_name_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `token_name_list`.
        ///
        /// To override the contents of this collection use [`set_token_name_list`](Self::set_token_name_list).
        ///
        /// <p>A list of names of connections to GitHub accounts.</p>
        pub fn token_name_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.token_name_list.unwrap_or_default();
            v.push(input.into());
            self.token_name_list = Some(v);
            self
        }
        /// <p>A list of names of connections to GitHub accounts.</p>
        pub fn set_token_name_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.token_name_list = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent <code>ListGitHubAccountTokenNames</code> call to return the next
        /// set of names in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent <code>ListGitHubAccountTokenNames</code> call to return the next
        /// set of names in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGitHubAccountTokenNamesOutput`](crate::output::ListGitHubAccountTokenNamesOutput)
        pub fn build(self) -> crate::output::ListGitHubAccountTokenNamesOutput {
            crate::output::ListGitHubAccountTokenNamesOutput {
                token_name_list: self.token_name_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGitHubAccountTokenNamesOutput {
    /// Creates a new builder-style object to manufacture [`ListGitHubAccountTokenNamesOutput`](crate::output::ListGitHubAccountTokenNamesOutput)
    pub fn builder() -> crate::output::list_git_hub_account_token_names_output::Builder {
        crate::output::list_git_hub_account_token_names_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentTargetsOutput {
    /// <p> The unique IDs of deployment targets. </p>
    pub target_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> If a large amount of information is returned, a token identifier is also returned. It
    /// can be used in a subsequent <code>ListDeploymentTargets</code> call to return the next
    /// set of deployment targets in the list. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentTargetsOutput");
        formatter.field("target_ids", &self.target_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentTargetsOutput`](crate::output::ListDeploymentTargetsOutput)
pub mod list_deployment_targets_output {
    /// A builder for [`ListDeploymentTargetsOutput`](crate::output::ListDeploymentTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `target_ids`.
        ///
        /// To override the contents of this collection use [`set_target_ids`](Self::set_target_ids).
        ///
        /// <p> The unique IDs of deployment targets. </p>
        pub fn target_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_ids.unwrap_or_default();
            v.push(input.into());
            self.target_ids = Some(v);
            self
        }
        /// <p> The unique IDs of deployment targets. </p>
        pub fn set_target_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_ids = input;
            self
        }
        /// <p> If a large amount of information is returned, a token identifier is also returned. It
        /// can be used in a subsequent <code>ListDeploymentTargets</code> call to return the next
        /// set of deployment targets in the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If a large amount of information is returned, a token identifier is also returned. It
        /// can be used in a subsequent <code>ListDeploymentTargets</code> call to return the next
        /// set of deployment targets in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentTargetsOutput`](crate::output::ListDeploymentTargetsOutput)
        pub fn build(self) -> crate::output::ListDeploymentTargetsOutput {
            crate::output::ListDeploymentTargetsOutput {
                target_ids: self.target_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentTargetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentTargetsOutput`](crate::output::ListDeploymentTargetsOutput)
    pub fn builder() -> crate::output::list_deployment_targets_output::Builder {
        crate::output::list_deployment_targets_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListDeployments</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentsOutput {
    /// <p>A list of deployment IDs.</p>
    pub deployments: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list deployments call to return the next set of deployments in
    /// the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentsOutput");
        formatter.field("deployments", &self.deployments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
pub mod list_deployments_output {
    /// A builder for [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployments: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `deployments`.
        ///
        /// To override the contents of this collection use [`set_deployments`](Self::set_deployments).
        ///
        /// <p>A list of deployment IDs.</p>
        pub fn deployments(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployments.unwrap_or_default();
            v.push(input.into());
            self.deployments = Some(v);
            self
        }
        /// <p>A list of deployment IDs.</p>
        pub fn set_deployments(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployments = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployments call to return the next set of deployments in
        /// the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployments call to return the next set of deployments in
        /// the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
        pub fn build(self) -> crate::output::ListDeploymentsOutput {
            crate::output::ListDeploymentsOutput {
                deployments: self.deployments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
    pub fn builder() -> crate::output::list_deployments_output::Builder {
        crate::output::list_deployments_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListDeploymentInstances</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentInstancesOutput {
    /// <p>A list of instance IDs.</p>
    pub instances_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list deployment instances call to return the next set of
    /// deployment instances in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentInstancesOutput");
        formatter.field("instances_list", &self.instances_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentInstancesOutput`](crate::output::ListDeploymentInstancesOutput)
pub mod list_deployment_instances_output {
    /// A builder for [`ListDeploymentInstancesOutput`](crate::output::ListDeploymentInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instances_list`.
        ///
        /// To override the contents of this collection use [`set_instances_list`](Self::set_instances_list).
        ///
        /// <p>A list of instance IDs.</p>
        pub fn instances_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instances_list.unwrap_or_default();
            v.push(input.into());
            self.instances_list = Some(v);
            self
        }
        /// <p>A list of instance IDs.</p>
        pub fn set_instances_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instances_list = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployment instances call to return the next set of
        /// deployment instances in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployment instances call to return the next set of
        /// deployment instances in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentInstancesOutput`](crate::output::ListDeploymentInstancesOutput)
        pub fn build(self) -> crate::output::ListDeploymentInstancesOutput {
            crate::output::ListDeploymentInstancesOutput {
                instances_list: self.instances_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentInstancesOutput`](crate::output::ListDeploymentInstancesOutput)
    pub fn builder() -> crate::output::list_deployment_instances_output::Builder {
        crate::output::list_deployment_instances_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListDeploymentGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentGroupsOutput {
    /// <p>The application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>A list of deployment group names.</p>
    pub deployment_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list deployment groups call to return the next set of deployment
    /// groups in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentGroupsOutput");
        formatter.field("application_name", &self.application_name);
        formatter.field("deployment_groups", &self.deployment_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentGroupsOutput`](crate::output::ListDeploymentGroupsOutput)
pub mod list_deployment_groups_output {
    /// A builder for [`ListDeploymentGroupsOutput`](crate::output::ListDeploymentGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) deployment_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Appends an item to `deployment_groups`.
        ///
        /// To override the contents of this collection use [`set_deployment_groups`](Self::set_deployment_groups).
        ///
        /// <p>A list of deployment group names.</p>
        pub fn deployment_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployment_groups.unwrap_or_default();
            v.push(input.into());
            self.deployment_groups = Some(v);
            self
        }
        /// <p>A list of deployment group names.</p>
        pub fn set_deployment_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployment_groups = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployment groups call to return the next set of deployment
        /// groups in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployment groups call to return the next set of deployment
        /// groups in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentGroupsOutput`](crate::output::ListDeploymentGroupsOutput)
        pub fn build(self) -> crate::output::ListDeploymentGroupsOutput {
            crate::output::ListDeploymentGroupsOutput {
                application_name: self.application_name,
                deployment_groups: self.deployment_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentGroupsOutput`](crate::output::ListDeploymentGroupsOutput)
    pub fn builder() -> crate::output::list_deployment_groups_output::Builder {
        crate::output::list_deployment_groups_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListDeploymentConfigs</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentConfigsOutput {
    /// <p>A list of deployment configurations, including built-in configurations such as
    /// <code>CodeDeployDefault.OneAtATime</code>.</p>
    pub deployment_configs_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list deployment configurations call to return the next set of
    /// deployment configurations in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentConfigsOutput");
        formatter.field("deployment_configs_list", &self.deployment_configs_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentConfigsOutput`](crate::output::ListDeploymentConfigsOutput)
pub mod list_deployment_configs_output {
    /// A builder for [`ListDeploymentConfigsOutput`](crate::output::ListDeploymentConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_configs_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `deployment_configs_list`.
        ///
        /// To override the contents of this collection use [`set_deployment_configs_list`](Self::set_deployment_configs_list).
        ///
        /// <p>A list of deployment configurations, including built-in configurations such as
        /// <code>CodeDeployDefault.OneAtATime</code>.</p>
        pub fn deployment_configs_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deployment_configs_list.unwrap_or_default();
            v.push(input.into());
            self.deployment_configs_list = Some(v);
            self
        }
        /// <p>A list of deployment configurations, including built-in configurations such as
        /// <code>CodeDeployDefault.OneAtATime</code>.</p>
        pub fn set_deployment_configs_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deployment_configs_list = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployment configurations call to return the next set of
        /// deployment configurations in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list deployment configurations call to return the next set of
        /// deployment configurations in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentConfigsOutput`](crate::output::ListDeploymentConfigsOutput)
        pub fn build(self) -> crate::output::ListDeploymentConfigsOutput {
            crate::output::ListDeploymentConfigsOutput {
                deployment_configs_list: self.deployment_configs_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentConfigsOutput`](crate::output::ListDeploymentConfigsOutput)
    pub fn builder() -> crate::output::list_deployment_configs_output::Builder {
        crate::output::list_deployment_configs_output::Builder::default()
    }
}

/// <p>Represents the output of a ListApplications operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsOutput {
    /// <p>A list of application names.</p>
    pub applications: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list applications call to return the next set of applications in
    /// the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsOutput");
        formatter.field("applications", &self.applications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
pub mod list_applications_output {
    /// A builder for [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) applications: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>A list of application names.</p>
        pub fn applications(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input.into());
            self.applications = Some(v);
            self
        }
        /// <p>A list of application names.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list applications call to return the next set of applications in
        /// the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list applications call to return the next set of applications in
        /// the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
        pub fn build(self) -> crate::output::ListApplicationsOutput {
            crate::output::ListApplicationsOutput {
                applications: self.applications,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    pub fn builder() -> crate::output::list_applications_output::Builder {
        crate::output::list_applications_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListApplicationRevisions</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationRevisionsOutput {
    /// <p>A list of locations that contain the matching revisions.</p>
    pub revisions: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
    /// <p>If a large amount of information is returned, an identifier is also returned. It can
    /// be used in a subsequent list application revisions call to return the next set of
    /// application revisions in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListApplicationRevisionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationRevisionsOutput");
        formatter.field("revisions", &self.revisions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationRevisionsOutput`](crate::output::ListApplicationRevisionsOutput)
pub mod list_application_revisions_output {
    /// A builder for [`ListApplicationRevisionsOutput`](crate::output::ListApplicationRevisionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revisions: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `revisions`.
        ///
        /// To override the contents of this collection use [`set_revisions`](Self::set_revisions).
        ///
        /// <p>A list of locations that contain the matching revisions.</p>
        pub fn revisions(mut self, input: impl Into<crate::model::RevisionLocation>) -> Self {
            let mut v = self.revisions.unwrap_or_default();
            v.push(input.into());
            self.revisions = Some(v);
            self
        }
        /// <p>A list of locations that contain the matching revisions.</p>
        pub fn set_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionLocation>>,
        ) -> Self {
            self.revisions = input;
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list application revisions call to return the next set of
        /// application revisions in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a large amount of information is returned, an identifier is also returned. It can
        /// be used in a subsequent list application revisions call to return the next set of
        /// application revisions in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationRevisionsOutput`](crate::output::ListApplicationRevisionsOutput)
        pub fn build(self) -> crate::output::ListApplicationRevisionsOutput {
            crate::output::ListApplicationRevisionsOutput {
                revisions: self.revisions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationRevisionsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationRevisionsOutput`](crate::output::ListApplicationRevisionsOutput)
    pub fn builder() -> crate::output::list_application_revisions_output::Builder {
        crate::output::list_application_revisions_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>GetOnPremisesInstance</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOnPremisesInstanceOutput {
    /// <p> Information about the on-premises instance. </p>
    pub instance_info: std::option::Option<crate::model::InstanceInfo>,
}
impl std::fmt::Debug for GetOnPremisesInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOnPremisesInstanceOutput");
        formatter.field("instance_info", &self.instance_info);
        formatter.finish()
    }
}
/// See [`GetOnPremisesInstanceOutput`](crate::output::GetOnPremisesInstanceOutput)
pub mod get_on_premises_instance_output {
    /// A builder for [`GetOnPremisesInstanceOutput`](crate::output::GetOnPremisesInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_info: std::option::Option<crate::model::InstanceInfo>,
    }
    impl Builder {
        /// <p> Information about the on-premises instance. </p>
        pub fn instance_info(mut self, input: crate::model::InstanceInfo) -> Self {
            self.instance_info = Some(input);
            self
        }
        /// <p> Information about the on-premises instance. </p>
        pub fn set_instance_info(
            mut self,
            input: std::option::Option<crate::model::InstanceInfo>,
        ) -> Self {
            self.instance_info = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOnPremisesInstanceOutput`](crate::output::GetOnPremisesInstanceOutput)
        pub fn build(self) -> crate::output::GetOnPremisesInstanceOutput {
            crate::output::GetOnPremisesInstanceOutput {
                instance_info: self.instance_info,
            }
        }
    }
}
impl GetOnPremisesInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetOnPremisesInstanceOutput`](crate::output::GetOnPremisesInstanceOutput)
    pub fn builder() -> crate::output::get_on_premises_instance_output::Builder {
        crate::output::get_on_premises_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentTargetOutput {
    /// <p> A deployment target that contains information about a deployment such as its status,
    /// lifecycle events, and when it was last updated. It also contains metadata about the
    /// deployment target. The deployment target metadata depends on the deployment target's
    /// type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or
    /// <code>ecsTarget</code>). </p>
    pub deployment_target: std::option::Option<crate::model::DeploymentTarget>,
}
impl std::fmt::Debug for GetDeploymentTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentTargetOutput");
        formatter.field("deployment_target", &self.deployment_target);
        formatter.finish()
    }
}
/// See [`GetDeploymentTargetOutput`](crate::output::GetDeploymentTargetOutput)
pub mod get_deployment_target_output {
    /// A builder for [`GetDeploymentTargetOutput`](crate::output::GetDeploymentTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_target: std::option::Option<crate::model::DeploymentTarget>,
    }
    impl Builder {
        /// <p> A deployment target that contains information about a deployment such as its status,
        /// lifecycle events, and when it was last updated. It also contains metadata about the
        /// deployment target. The deployment target metadata depends on the deployment target's
        /// type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or
        /// <code>ecsTarget</code>). </p>
        pub fn deployment_target(mut self, input: crate::model::DeploymentTarget) -> Self {
            self.deployment_target = Some(input);
            self
        }
        /// <p> A deployment target that contains information about a deployment such as its status,
        /// lifecycle events, and when it was last updated. It also contains metadata about the
        /// deployment target. The deployment target metadata depends on the deployment target's
        /// type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or
        /// <code>ecsTarget</code>). </p>
        pub fn set_deployment_target(
            mut self,
            input: std::option::Option<crate::model::DeploymentTarget>,
        ) -> Self {
            self.deployment_target = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentTargetOutput`](crate::output::GetDeploymentTargetOutput)
        pub fn build(self) -> crate::output::GetDeploymentTargetOutput {
            crate::output::GetDeploymentTargetOutput {
                deployment_target: self.deployment_target,
            }
        }
    }
}
impl GetDeploymentTargetOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentTargetOutput`](crate::output::GetDeploymentTargetOutput)
    pub fn builder() -> crate::output::get_deployment_target_output::Builder {
        crate::output::get_deployment_target_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>GetDeploymentInstance</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentInstanceOutput {
    /// <p> Information about the instance. </p>
    pub instance_summary: std::option::Option<crate::model::InstanceSummary>,
}
impl std::fmt::Debug for GetDeploymentInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentInstanceOutput");
        formatter.field("instance_summary", &self.instance_summary);
        formatter.finish()
    }
}
/// See [`GetDeploymentInstanceOutput`](crate::output::GetDeploymentInstanceOutput)
pub mod get_deployment_instance_output {
    /// A builder for [`GetDeploymentInstanceOutput`](crate::output::GetDeploymentInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_summary: std::option::Option<crate::model::InstanceSummary>,
    }
    impl Builder {
        /// <p> Information about the instance. </p>
        pub fn instance_summary(mut self, input: crate::model::InstanceSummary) -> Self {
            self.instance_summary = Some(input);
            self
        }
        /// <p> Information about the instance. </p>
        pub fn set_instance_summary(
            mut self,
            input: std::option::Option<crate::model::InstanceSummary>,
        ) -> Self {
            self.instance_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentInstanceOutput`](crate::output::GetDeploymentInstanceOutput)
        pub fn build(self) -> crate::output::GetDeploymentInstanceOutput {
            crate::output::GetDeploymentInstanceOutput {
                instance_summary: self.instance_summary,
            }
        }
    }
}
impl GetDeploymentInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentInstanceOutput`](crate::output::GetDeploymentInstanceOutput)
    pub fn builder() -> crate::output::get_deployment_instance_output::Builder {
        crate::output::get_deployment_instance_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentGroupOutput {
    /// <p>Information about the deployment group.</p>
    pub deployment_group_info: std::option::Option<crate::model::DeploymentGroupInfo>,
}
impl std::fmt::Debug for GetDeploymentGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentGroupOutput");
        formatter.field("deployment_group_info", &self.deployment_group_info);
        formatter.finish()
    }
}
/// See [`GetDeploymentGroupOutput`](crate::output::GetDeploymentGroupOutput)
pub mod get_deployment_group_output {
    /// A builder for [`GetDeploymentGroupOutput`](crate::output::GetDeploymentGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_group_info: std::option::Option<crate::model::DeploymentGroupInfo>,
    }
    impl Builder {
        /// <p>Information about the deployment group.</p>
        pub fn deployment_group_info(mut self, input: crate::model::DeploymentGroupInfo) -> Self {
            self.deployment_group_info = Some(input);
            self
        }
        /// <p>Information about the deployment group.</p>
        pub fn set_deployment_group_info(
            mut self,
            input: std::option::Option<crate::model::DeploymentGroupInfo>,
        ) -> Self {
            self.deployment_group_info = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentGroupOutput`](crate::output::GetDeploymentGroupOutput)
        pub fn build(self) -> crate::output::GetDeploymentGroupOutput {
            crate::output::GetDeploymentGroupOutput {
                deployment_group_info: self.deployment_group_info,
            }
        }
    }
}
impl GetDeploymentGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentGroupOutput`](crate::output::GetDeploymentGroupOutput)
    pub fn builder() -> crate::output::get_deployment_group_output::Builder {
        crate::output::get_deployment_group_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetDeploymentConfig</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentConfigOutput {
    /// <p>Information about the deployment configuration.</p>
    pub deployment_config_info: std::option::Option<crate::model::DeploymentConfigInfo>,
}
impl std::fmt::Debug for GetDeploymentConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentConfigOutput");
        formatter.field("deployment_config_info", &self.deployment_config_info);
        formatter.finish()
    }
}
/// See [`GetDeploymentConfigOutput`](crate::output::GetDeploymentConfigOutput)
pub mod get_deployment_config_output {
    /// A builder for [`GetDeploymentConfigOutput`](crate::output::GetDeploymentConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_config_info: std::option::Option<crate::model::DeploymentConfigInfo>,
    }
    impl Builder {
        /// <p>Information about the deployment configuration.</p>
        pub fn deployment_config_info(mut self, input: crate::model::DeploymentConfigInfo) -> Self {
            self.deployment_config_info = Some(input);
            self
        }
        /// <p>Information about the deployment configuration.</p>
        pub fn set_deployment_config_info(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfigInfo>,
        ) -> Self {
            self.deployment_config_info = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentConfigOutput`](crate::output::GetDeploymentConfigOutput)
        pub fn build(self) -> crate::output::GetDeploymentConfigOutput {
            crate::output::GetDeploymentConfigOutput {
                deployment_config_info: self.deployment_config_info,
            }
        }
    }
}
impl GetDeploymentConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentConfigOutput`](crate::output::GetDeploymentConfigOutput)
    pub fn builder() -> crate::output::get_deployment_config_output::Builder {
        crate::output::get_deployment_config_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetDeployment</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentOutput {
    /// <p>Information about the deployment.</p>
    pub deployment_info: std::option::Option<crate::model::DeploymentInfo>,
}
impl std::fmt::Debug for GetDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentOutput");
        formatter.field("deployment_info", &self.deployment_info);
        formatter.finish()
    }
}
/// See [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
pub mod get_deployment_output {
    /// A builder for [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_info: std::option::Option<crate::model::DeploymentInfo>,
    }
    impl Builder {
        /// <p>Information about the deployment.</p>
        pub fn deployment_info(mut self, input: crate::model::DeploymentInfo) -> Self {
            self.deployment_info = Some(input);
            self
        }
        /// <p>Information about the deployment.</p>
        pub fn set_deployment_info(
            mut self,
            input: std::option::Option<crate::model::DeploymentInfo>,
        ) -> Self {
            self.deployment_info = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
        pub fn build(self) -> crate::output::GetDeploymentOutput {
            crate::output::GetDeploymentOutput {
                deployment_info: self.deployment_info,
            }
        }
    }
}
impl GetDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    pub fn builder() -> crate::output::get_deployment_output::Builder {
        crate::output::get_deployment_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetApplicationRevision</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationRevisionOutput {
    /// <p>The name of the application that corresponds to the revision.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Additional information about the revision, including type and location.</p>
    pub revision: std::option::Option<crate::model::RevisionLocation>,
    /// <p>General information about the revision.</p>
    pub revision_info: std::option::Option<crate::model::GenericRevisionInfo>,
}
impl std::fmt::Debug for GetApplicationRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationRevisionOutput");
        formatter.field("application_name", &self.application_name);
        formatter.field("revision", &self.revision);
        formatter.field("revision_info", &self.revision_info);
        formatter.finish()
    }
}
/// See [`GetApplicationRevisionOutput`](crate::output::GetApplicationRevisionOutput)
pub mod get_application_revision_output {
    /// A builder for [`GetApplicationRevisionOutput`](crate::output::GetApplicationRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<crate::model::RevisionLocation>,
        pub(crate) revision_info: std::option::Option<crate::model::GenericRevisionInfo>,
    }
    impl Builder {
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application that corresponds to the revision.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Additional information about the revision, including type and location.</p>
        pub fn revision(mut self, input: crate::model::RevisionLocation) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>Additional information about the revision, including type and location.</p>
        pub fn set_revision(
            mut self,
            input: std::option::Option<crate::model::RevisionLocation>,
        ) -> Self {
            self.revision = input;
            self
        }
        /// <p>General information about the revision.</p>
        pub fn revision_info(mut self, input: crate::model::GenericRevisionInfo) -> Self {
            self.revision_info = Some(input);
            self
        }
        /// <p>General information about the revision.</p>
        pub fn set_revision_info(
            mut self,
            input: std::option::Option<crate::model::GenericRevisionInfo>,
        ) -> Self {
            self.revision_info = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationRevisionOutput`](crate::output::GetApplicationRevisionOutput)
        pub fn build(self) -> crate::output::GetApplicationRevisionOutput {
            crate::output::GetApplicationRevisionOutput {
                application_name: self.application_name,
                revision: self.revision,
                revision_info: self.revision_info,
            }
        }
    }
}
impl GetApplicationRevisionOutput {
    /// Creates a new builder-style object to manufacture [`GetApplicationRevisionOutput`](crate::output::GetApplicationRevisionOutput)
    pub fn builder() -> crate::output::get_application_revision_output::Builder {
        crate::output::get_application_revision_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetApplication</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationOutput {
    /// <p>Information about the application.</p>
    pub application: std::option::Option<crate::model::ApplicationInfo>,
}
impl std::fmt::Debug for GetApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationOutput");
        formatter.field("application", &self.application);
        formatter.finish()
    }
}
/// See [`GetApplicationOutput`](crate::output::GetApplicationOutput)
pub mod get_application_output {
    /// A builder for [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<crate::model::ApplicationInfo>,
    }
    impl Builder {
        /// <p>Information about the application.</p>
        pub fn application(mut self, input: crate::model::ApplicationInfo) -> Self {
            self.application = Some(input);
            self
        }
        /// <p>Information about the application.</p>
        pub fn set_application(
            mut self,
            input: std::option::Option<crate::model::ApplicationInfo>,
        ) -> Self {
            self.application = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationOutput`](crate::output::GetApplicationOutput)
        pub fn build(self) -> crate::output::GetApplicationOutput {
            crate::output::GetApplicationOutput {
                application: self.application,
            }
        }
    }
}
impl GetApplicationOutput {
    /// Creates a new builder-style object to manufacture [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    pub fn builder() -> crate::output::get_application_output::Builder {
        crate::output::get_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterOnPremisesInstanceOutput {}
impl std::fmt::Debug for DeregisterOnPremisesInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterOnPremisesInstanceOutput");
        formatter.finish()
    }
}
/// See [`DeregisterOnPremisesInstanceOutput`](crate::output::DeregisterOnPremisesInstanceOutput)
pub mod deregister_on_premises_instance_output {
    /// A builder for [`DeregisterOnPremisesInstanceOutput`](crate::output::DeregisterOnPremisesInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterOnPremisesInstanceOutput`](crate::output::DeregisterOnPremisesInstanceOutput)
        pub fn build(self) -> crate::output::DeregisterOnPremisesInstanceOutput {
            crate::output::DeregisterOnPremisesInstanceOutput {}
        }
    }
}
impl DeregisterOnPremisesInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterOnPremisesInstanceOutput`](crate::output::DeregisterOnPremisesInstanceOutput)
    pub fn builder() -> crate::output::deregister_on_premises_instance_output::Builder {
        crate::output::deregister_on_premises_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcesByExternalIdOutput {}
impl std::fmt::Debug for DeleteResourcesByExternalIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcesByExternalIdOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourcesByExternalIdOutput`](crate::output::DeleteResourcesByExternalIdOutput)
pub mod delete_resources_by_external_id_output {
    /// A builder for [`DeleteResourcesByExternalIdOutput`](crate::output::DeleteResourcesByExternalIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourcesByExternalIdOutput`](crate::output::DeleteResourcesByExternalIdOutput)
        pub fn build(self) -> crate::output::DeleteResourcesByExternalIdOutput {
            crate::output::DeleteResourcesByExternalIdOutput {}
        }
    }
}
impl DeleteResourcesByExternalIdOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcesByExternalIdOutput`](crate::output::DeleteResourcesByExternalIdOutput)
    pub fn builder() -> crate::output::delete_resources_by_external_id_output::Builder {
        crate::output::delete_resources_by_external_id_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DeleteGitHubAccountToken</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGitHubAccountTokenOutput {
    /// <p>The name of the GitHub account connection that was deleted.</p>
    pub token_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteGitHubAccountTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGitHubAccountTokenOutput");
        formatter.field("token_name", &self.token_name);
        formatter.finish()
    }
}
/// See [`DeleteGitHubAccountTokenOutput`](crate::output::DeleteGitHubAccountTokenOutput)
pub mod delete_git_hub_account_token_output {
    /// A builder for [`DeleteGitHubAccountTokenOutput`](crate::output::DeleteGitHubAccountTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the GitHub account connection that was deleted.</p>
        pub fn token_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_name = Some(input.into());
            self
        }
        /// <p>The name of the GitHub account connection that was deleted.</p>
        pub fn set_token_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGitHubAccountTokenOutput`](crate::output::DeleteGitHubAccountTokenOutput)
        pub fn build(self) -> crate::output::DeleteGitHubAccountTokenOutput {
            crate::output::DeleteGitHubAccountTokenOutput {
                token_name: self.token_name,
            }
        }
    }
}
impl DeleteGitHubAccountTokenOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGitHubAccountTokenOutput`](crate::output::DeleteGitHubAccountTokenOutput)
    pub fn builder() -> crate::output::delete_git_hub_account_token_output::Builder {
        crate::output::delete_git_hub_account_token_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DeleteDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentGroupOutput {
    /// <p>If the output contains no data, and the corresponding deployment group contained at
    /// least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto
    /// Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.
    /// If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle
    /// event hooks from the Amazon EC2 instances in the Auto Scaling group.</p>
    pub hooks_not_cleaned_up: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
}
impl std::fmt::Debug for DeleteDeploymentGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentGroupOutput");
        formatter.field("hooks_not_cleaned_up", &self.hooks_not_cleaned_up);
        formatter.finish()
    }
}
/// See [`DeleteDeploymentGroupOutput`](crate::output::DeleteDeploymentGroupOutput)
pub mod delete_deployment_group_output {
    /// A builder for [`DeleteDeploymentGroupOutput`](crate::output::DeleteDeploymentGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hooks_not_cleaned_up:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
    }
    impl Builder {
        /// Appends an item to `hooks_not_cleaned_up`.
        ///
        /// To override the contents of this collection use [`set_hooks_not_cleaned_up`](Self::set_hooks_not_cleaned_up).
        ///
        /// <p>If the output contains no data, and the corresponding deployment group contained at
        /// least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto
        /// Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.
        /// If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle
        /// event hooks from the Amazon EC2 instances in the Auto Scaling group.</p>
        pub fn hooks_not_cleaned_up(
            mut self,
            input: impl Into<crate::model::AutoScalingGroup>,
        ) -> Self {
            let mut v = self.hooks_not_cleaned_up.unwrap_or_default();
            v.push(input.into());
            self.hooks_not_cleaned_up = Some(v);
            self
        }
        /// <p>If the output contains no data, and the corresponding deployment group contained at
        /// least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto
        /// Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.
        /// If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle
        /// event hooks from the Amazon EC2 instances in the Auto Scaling group.</p>
        pub fn set_hooks_not_cleaned_up(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        ) -> Self {
            self.hooks_not_cleaned_up = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeploymentGroupOutput`](crate::output::DeleteDeploymentGroupOutput)
        pub fn build(self) -> crate::output::DeleteDeploymentGroupOutput {
            crate::output::DeleteDeploymentGroupOutput {
                hooks_not_cleaned_up: self.hooks_not_cleaned_up,
            }
        }
    }
}
impl DeleteDeploymentGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentGroupOutput`](crate::output::DeleteDeploymentGroupOutput)
    pub fn builder() -> crate::output::delete_deployment_group_output::Builder {
        crate::output::delete_deployment_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeploymentConfigOutput {}
impl std::fmt::Debug for DeleteDeploymentConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeploymentConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteDeploymentConfigOutput`](crate::output::DeleteDeploymentConfigOutput)
pub mod delete_deployment_config_output {
    /// A builder for [`DeleteDeploymentConfigOutput`](crate::output::DeleteDeploymentConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDeploymentConfigOutput`](crate::output::DeleteDeploymentConfigOutput)
        pub fn build(self) -> crate::output::DeleteDeploymentConfigOutput {
            crate::output::DeleteDeploymentConfigOutput {}
        }
    }
}
impl DeleteDeploymentConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDeploymentConfigOutput`](crate::output::DeleteDeploymentConfigOutput)
    pub fn builder() -> crate::output::delete_deployment_config_output::Builder {
        crate::output::delete_deployment_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutput {}
impl std::fmt::Debug for DeleteApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
pub mod delete_application_output {
    /// A builder for [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
        pub fn build(self) -> crate::output::DeleteApplicationOutput {
            crate::output::DeleteApplicationOutput {}
        }
    }
}
impl DeleteApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    pub fn builder() -> crate::output::delete_application_output::Builder {
        crate::output::delete_application_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateDeploymentGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentGroupOutput {
    /// <p>A unique deployment group ID.</p>
    pub deployment_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDeploymentGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentGroupOutput");
        formatter.field("deployment_group_id", &self.deployment_group_id);
        formatter.finish()
    }
}
/// See [`CreateDeploymentGroupOutput`](crate::output::CreateDeploymentGroupOutput)
pub mod create_deployment_group_output {
    /// A builder for [`CreateDeploymentGroupOutput`](crate::output::CreateDeploymentGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique deployment group ID.</p>
        pub fn deployment_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_group_id = Some(input.into());
            self
        }
        /// <p>A unique deployment group ID.</p>
        pub fn set_deployment_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentGroupOutput`](crate::output::CreateDeploymentGroupOutput)
        pub fn build(self) -> crate::output::CreateDeploymentGroupOutput {
            crate::output::CreateDeploymentGroupOutput {
                deployment_group_id: self.deployment_group_id,
            }
        }
    }
}
impl CreateDeploymentGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentGroupOutput`](crate::output::CreateDeploymentGroupOutput)
    pub fn builder() -> crate::output::create_deployment_group_output::Builder {
        crate::output::create_deployment_group_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateDeploymentConfig</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentConfigOutput {
    /// <p>A unique deployment configuration ID.</p>
    pub deployment_config_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDeploymentConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentConfigOutput");
        formatter.field("deployment_config_id", &self.deployment_config_id);
        formatter.finish()
    }
}
/// See [`CreateDeploymentConfigOutput`](crate::output::CreateDeploymentConfigOutput)
pub mod create_deployment_config_output {
    /// A builder for [`CreateDeploymentConfigOutput`](crate::output::CreateDeploymentConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_config_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique deployment configuration ID.</p>
        pub fn deployment_config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_config_id = Some(input.into());
            self
        }
        /// <p>A unique deployment configuration ID.</p>
        pub fn set_deployment_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_config_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentConfigOutput`](crate::output::CreateDeploymentConfigOutput)
        pub fn build(self) -> crate::output::CreateDeploymentConfigOutput {
            crate::output::CreateDeploymentConfigOutput {
                deployment_config_id: self.deployment_config_id,
            }
        }
    }
}
impl CreateDeploymentConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentConfigOutput`](crate::output::CreateDeploymentConfigOutput)
    pub fn builder() -> crate::output::create_deployment_config_output::Builder {
        crate::output::create_deployment_config_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>CreateDeployment</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentOutput {
    /// <p> The unique ID of a deployment. </p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentOutput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}
/// See [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
pub mod create_deployment_output {
    /// A builder for [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique ID of a deployment. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The unique ID of a deployment. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
        pub fn build(self) -> crate::output::CreateDeploymentOutput {
            crate::output::CreateDeploymentOutput {
                deployment_id: self.deployment_id,
            }
        }
    }
}
impl CreateDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    pub fn builder() -> crate::output::create_deployment_output::Builder {
        crate::output::create_deployment_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateApplication</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p>A unique application ID.</p>
    pub application_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("application_id", &self.application_id);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique application ID.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>A unique application ID.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                application_id: self.application_id,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinueDeploymentOutput {}
impl std::fmt::Debug for ContinueDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinueDeploymentOutput");
        formatter.finish()
    }
}
/// See [`ContinueDeploymentOutput`](crate::output::ContinueDeploymentOutput)
pub mod continue_deployment_output {
    /// A builder for [`ContinueDeploymentOutput`](crate::output::ContinueDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ContinueDeploymentOutput`](crate::output::ContinueDeploymentOutput)
        pub fn build(self) -> crate::output::ContinueDeploymentOutput {
            crate::output::ContinueDeploymentOutput {}
        }
    }
}
impl ContinueDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`ContinueDeploymentOutput`](crate::output::ContinueDeploymentOutput)
    pub fn builder() -> crate::output::continue_deployment_output::Builder {
        crate::output::continue_deployment_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchGetOnPremisesInstances</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetOnPremisesInstancesOutput {
    /// <p>Information about the on-premises instances.</p>
    pub instance_infos: std::option::Option<std::vec::Vec<crate::model::InstanceInfo>>,
}
impl std::fmt::Debug for BatchGetOnPremisesInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetOnPremisesInstancesOutput");
        formatter.field("instance_infos", &self.instance_infos);
        formatter.finish()
    }
}
/// See [`BatchGetOnPremisesInstancesOutput`](crate::output::BatchGetOnPremisesInstancesOutput)
pub mod batch_get_on_premises_instances_output {
    /// A builder for [`BatchGetOnPremisesInstancesOutput`](crate::output::BatchGetOnPremisesInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_infos: std::option::Option<std::vec::Vec<crate::model::InstanceInfo>>,
    }
    impl Builder {
        /// Appends an item to `instance_infos`.
        ///
        /// To override the contents of this collection use [`set_instance_infos`](Self::set_instance_infos).
        ///
        /// <p>Information about the on-premises instances.</p>
        pub fn instance_infos(mut self, input: impl Into<crate::model::InstanceInfo>) -> Self {
            let mut v = self.instance_infos.unwrap_or_default();
            v.push(input.into());
            self.instance_infos = Some(v);
            self
        }
        /// <p>Information about the on-premises instances.</p>
        pub fn set_instance_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceInfo>>,
        ) -> Self {
            self.instance_infos = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetOnPremisesInstancesOutput`](crate::output::BatchGetOnPremisesInstancesOutput)
        pub fn build(self) -> crate::output::BatchGetOnPremisesInstancesOutput {
            crate::output::BatchGetOnPremisesInstancesOutput {
                instance_infos: self.instance_infos,
            }
        }
    }
}
impl BatchGetOnPremisesInstancesOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetOnPremisesInstancesOutput`](crate::output::BatchGetOnPremisesInstancesOutput)
    pub fn builder() -> crate::output::batch_get_on_premises_instances_output::Builder {
        crate::output::batch_get_on_premises_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentTargetsOutput {
    /// <p> A list of target objects for a deployment. Each target object contains details about
    /// the target, such as its status and lifecycle events. The type of the target objects
    /// depends on the deployment' compute platform. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>EC2/On-premises</b>: Each target object is an EC2
    /// or on-premises instance. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AWS Lambda</b>: The target object is a specific
    /// version of an AWS Lambda function. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Amazon ECS</b>: The target object is an Amazon ECS
    /// service. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CloudFormation</b>: The target object is an AWS
    /// CloudFormation blue/green deployment. </p>
    /// </li>
    /// </ul>
    pub deployment_targets: std::option::Option<std::vec::Vec<crate::model::DeploymentTarget>>,
}
impl std::fmt::Debug for BatchGetDeploymentTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentTargetsOutput");
        formatter.field("deployment_targets", &self.deployment_targets);
        formatter.finish()
    }
}
/// See [`BatchGetDeploymentTargetsOutput`](crate::output::BatchGetDeploymentTargetsOutput)
pub mod batch_get_deployment_targets_output {
    /// A builder for [`BatchGetDeploymentTargetsOutput`](crate::output::BatchGetDeploymentTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_targets:
            std::option::Option<std::vec::Vec<crate::model::DeploymentTarget>>,
    }
    impl Builder {
        /// Appends an item to `deployment_targets`.
        ///
        /// To override the contents of this collection use [`set_deployment_targets`](Self::set_deployment_targets).
        ///
        /// <p> A list of target objects for a deployment. Each target object contains details about
        /// the target, such as its status and lifecycle events. The type of the target objects
        /// depends on the deployment' compute platform. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>EC2/On-premises</b>: Each target object is an EC2
        /// or on-premises instance. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AWS Lambda</b>: The target object is a specific
        /// version of an AWS Lambda function. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon ECS</b>: The target object is an Amazon ECS
        /// service. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudFormation</b>: The target object is an AWS
        /// CloudFormation blue/green deployment. </p>
        /// </li>
        /// </ul>
        pub fn deployment_targets(
            mut self,
            input: impl Into<crate::model::DeploymentTarget>,
        ) -> Self {
            let mut v = self.deployment_targets.unwrap_or_default();
            v.push(input.into());
            self.deployment_targets = Some(v);
            self
        }
        /// <p> A list of target objects for a deployment. Each target object contains details about
        /// the target, such as its status and lifecycle events. The type of the target objects
        /// depends on the deployment' compute platform. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>EC2/On-premises</b>: Each target object is an EC2
        /// or on-premises instance. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AWS Lambda</b>: The target object is a specific
        /// version of an AWS Lambda function. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon ECS</b>: The target object is an Amazon ECS
        /// service. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudFormation</b>: The target object is an AWS
        /// CloudFormation blue/green deployment. </p>
        /// </li>
        /// </ul>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentTarget>>,
        ) -> Self {
            self.deployment_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentTargetsOutput`](crate::output::BatchGetDeploymentTargetsOutput)
        pub fn build(self) -> crate::output::BatchGetDeploymentTargetsOutput {
            crate::output::BatchGetDeploymentTargetsOutput {
                deployment_targets: self.deployment_targets,
            }
        }
    }
}
impl BatchGetDeploymentTargetsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentTargetsOutput`](crate::output::BatchGetDeploymentTargetsOutput)
    pub fn builder() -> crate::output::batch_get_deployment_targets_output::Builder {
        crate::output::batch_get_deployment_targets_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>BatchGetDeployments</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentsOutput {
    /// <p> Information about the deployments. </p>
    pub deployments_info: std::option::Option<std::vec::Vec<crate::model::DeploymentInfo>>,
}
impl std::fmt::Debug for BatchGetDeploymentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentsOutput");
        formatter.field("deployments_info", &self.deployments_info);
        formatter.finish()
    }
}
/// See [`BatchGetDeploymentsOutput`](crate::output::BatchGetDeploymentsOutput)
pub mod batch_get_deployments_output {
    /// A builder for [`BatchGetDeploymentsOutput`](crate::output::BatchGetDeploymentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployments_info:
            std::option::Option<std::vec::Vec<crate::model::DeploymentInfo>>,
    }
    impl Builder {
        /// Appends an item to `deployments_info`.
        ///
        /// To override the contents of this collection use [`set_deployments_info`](Self::set_deployments_info).
        ///
        /// <p> Information about the deployments. </p>
        pub fn deployments_info(mut self, input: impl Into<crate::model::DeploymentInfo>) -> Self {
            let mut v = self.deployments_info.unwrap_or_default();
            v.push(input.into());
            self.deployments_info = Some(v);
            self
        }
        /// <p> Information about the deployments. </p>
        pub fn set_deployments_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentInfo>>,
        ) -> Self {
            self.deployments_info = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentsOutput`](crate::output::BatchGetDeploymentsOutput)
        pub fn build(self) -> crate::output::BatchGetDeploymentsOutput {
            crate::output::BatchGetDeploymentsOutput {
                deployments_info: self.deployments_info,
            }
        }
    }
}
impl BatchGetDeploymentsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentsOutput`](crate::output::BatchGetDeploymentsOutput)
    pub fn builder() -> crate::output::batch_get_deployments_output::Builder {
        crate::output::batch_get_deployments_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchGetDeploymentInstances</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentInstancesOutput {
    /// <p>Information about the instance.</p>
    pub instances_summary: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
    /// <p>Information about errors that might have occurred during the API call.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchGetDeploymentInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentInstancesOutput");
        formatter.field("instances_summary", &self.instances_summary);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchGetDeploymentInstancesOutput`](crate::output::BatchGetDeploymentInstancesOutput)
pub mod batch_get_deployment_instances_output {
    /// A builder for [`BatchGetDeploymentInstancesOutput`](crate::output::BatchGetDeploymentInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances_summary:
            std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instances_summary`.
        ///
        /// To override the contents of this collection use [`set_instances_summary`](Self::set_instances_summary).
        ///
        /// <p>Information about the instance.</p>
        pub fn instances_summary(
            mut self,
            input: impl Into<crate::model::InstanceSummary>,
        ) -> Self {
            let mut v = self.instances_summary.unwrap_or_default();
            v.push(input.into());
            self.instances_summary = Some(v);
            self
        }
        /// <p>Information about the instance.</p>
        pub fn set_instances_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
        ) -> Self {
            self.instances_summary = input;
            self
        }
        /// <p>Information about errors that might have occurred during the API call.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Information about errors that might have occurred during the API call.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentInstancesOutput`](crate::output::BatchGetDeploymentInstancesOutput)
        pub fn build(self) -> crate::output::BatchGetDeploymentInstancesOutput {
            crate::output::BatchGetDeploymentInstancesOutput {
                instances_summary: self.instances_summary,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchGetDeploymentInstancesOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentInstancesOutput`](crate::output::BatchGetDeploymentInstancesOutput)
    pub fn builder() -> crate::output::batch_get_deployment_instances_output::Builder {
        crate::output::batch_get_deployment_instances_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchGetDeploymentGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDeploymentGroupsOutput {
    /// <p>Information about the deployment groups.</p>
    pub deployment_groups_info:
        std::option::Option<std::vec::Vec<crate::model::DeploymentGroupInfo>>,
    /// <p>Information about errors that might have occurred during the API call.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchGetDeploymentGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDeploymentGroupsOutput");
        formatter.field("deployment_groups_info", &self.deployment_groups_info);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchGetDeploymentGroupsOutput`](crate::output::BatchGetDeploymentGroupsOutput)
pub mod batch_get_deployment_groups_output {
    /// A builder for [`BatchGetDeploymentGroupsOutput`](crate::output::BatchGetDeploymentGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_groups_info:
            std::option::Option<std::vec::Vec<crate::model::DeploymentGroupInfo>>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `deployment_groups_info`.
        ///
        /// To override the contents of this collection use [`set_deployment_groups_info`](Self::set_deployment_groups_info).
        ///
        /// <p>Information about the deployment groups.</p>
        pub fn deployment_groups_info(
            mut self,
            input: impl Into<crate::model::DeploymentGroupInfo>,
        ) -> Self {
            let mut v = self.deployment_groups_info.unwrap_or_default();
            v.push(input.into());
            self.deployment_groups_info = Some(v);
            self
        }
        /// <p>Information about the deployment groups.</p>
        pub fn set_deployment_groups_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentGroupInfo>>,
        ) -> Self {
            self.deployment_groups_info = input;
            self
        }
        /// <p>Information about errors that might have occurred during the API call.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Information about errors that might have occurred during the API call.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDeploymentGroupsOutput`](crate::output::BatchGetDeploymentGroupsOutput)
        pub fn build(self) -> crate::output::BatchGetDeploymentGroupsOutput {
            crate::output::BatchGetDeploymentGroupsOutput {
                deployment_groups_info: self.deployment_groups_info,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchGetDeploymentGroupsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetDeploymentGroupsOutput`](crate::output::BatchGetDeploymentGroupsOutput)
    pub fn builder() -> crate::output::batch_get_deployment_groups_output::Builder {
        crate::output::batch_get_deployment_groups_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchGetApplications</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetApplicationsOutput {
    /// <p>Information about the applications.</p>
    pub applications_info: std::option::Option<std::vec::Vec<crate::model::ApplicationInfo>>,
}
impl std::fmt::Debug for BatchGetApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetApplicationsOutput");
        formatter.field("applications_info", &self.applications_info);
        formatter.finish()
    }
}
/// See [`BatchGetApplicationsOutput`](crate::output::BatchGetApplicationsOutput)
pub mod batch_get_applications_output {
    /// A builder for [`BatchGetApplicationsOutput`](crate::output::BatchGetApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) applications_info:
            std::option::Option<std::vec::Vec<crate::model::ApplicationInfo>>,
    }
    impl Builder {
        /// Appends an item to `applications_info`.
        ///
        /// To override the contents of this collection use [`set_applications_info`](Self::set_applications_info).
        ///
        /// <p>Information about the applications.</p>
        pub fn applications_info(
            mut self,
            input: impl Into<crate::model::ApplicationInfo>,
        ) -> Self {
            let mut v = self.applications_info.unwrap_or_default();
            v.push(input.into());
            self.applications_info = Some(v);
            self
        }
        /// <p>Information about the applications.</p>
        pub fn set_applications_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationInfo>>,
        ) -> Self {
            self.applications_info = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetApplicationsOutput`](crate::output::BatchGetApplicationsOutput)
        pub fn build(self) -> crate::output::BatchGetApplicationsOutput {
            crate::output::BatchGetApplicationsOutput {
                applications_info: self.applications_info,
            }
        }
    }
}
impl BatchGetApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetApplicationsOutput`](crate::output::BatchGetApplicationsOutput)
    pub fn builder() -> crate::output::batch_get_applications_output::Builder {
        crate::output::batch_get_applications_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchGetApplicationRevisions</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetApplicationRevisionsOutput {
    /// <p>The name of the application that corresponds to the revisions.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Information about errors that might have occurred during the API call.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Additional information about the revisions, including the type and location.</p>
    pub revisions: std::option::Option<std::vec::Vec<crate::model::RevisionInfo>>,
}
impl std::fmt::Debug for BatchGetApplicationRevisionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetApplicationRevisionsOutput");
        formatter.field("application_name", &self.application_name);
        formatter.field("error_message", &self.error_message);
        formatter.field("revisions", &self.revisions);
        formatter.finish()
    }
}
/// See [`BatchGetApplicationRevisionsOutput`](crate::output::BatchGetApplicationRevisionsOutput)
pub mod batch_get_application_revisions_output {
    /// A builder for [`BatchGetApplicationRevisionsOutput`](crate::output::BatchGetApplicationRevisionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) revisions: std::option::Option<std::vec::Vec<crate::model::RevisionInfo>>,
    }
    impl Builder {
        /// <p>The name of the application that corresponds to the revisions.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application that corresponds to the revisions.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Information about errors that might have occurred during the API call.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Information about errors that might have occurred during the API call.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Appends an item to `revisions`.
        ///
        /// To override the contents of this collection use [`set_revisions`](Self::set_revisions).
        ///
        /// <p>Additional information about the revisions, including the type and location.</p>
        pub fn revisions(mut self, input: impl Into<crate::model::RevisionInfo>) -> Self {
            let mut v = self.revisions.unwrap_or_default();
            v.push(input.into());
            self.revisions = Some(v);
            self
        }
        /// <p>Additional information about the revisions, including the type and location.</p>
        pub fn set_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionInfo>>,
        ) -> Self {
            self.revisions = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetApplicationRevisionsOutput`](crate::output::BatchGetApplicationRevisionsOutput)
        pub fn build(self) -> crate::output::BatchGetApplicationRevisionsOutput {
            crate::output::BatchGetApplicationRevisionsOutput {
                application_name: self.application_name,
                error_message: self.error_message,
                revisions: self.revisions,
            }
        }
    }
}
impl BatchGetApplicationRevisionsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetApplicationRevisionsOutput`](crate::output::BatchGetApplicationRevisionsOutput)
    pub fn builder() -> crate::output::batch_get_application_revisions_output::Builder {
        crate::output::batch_get_application_revisions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToOnPremisesInstancesOutput {}
impl std::fmt::Debug for AddTagsToOnPremisesInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToOnPremisesInstancesOutput");
        formatter.finish()
    }
}
/// See [`AddTagsToOnPremisesInstancesOutput`](crate::output::AddTagsToOnPremisesInstancesOutput)
pub mod add_tags_to_on_premises_instances_output {
    /// A builder for [`AddTagsToOnPremisesInstancesOutput`](crate::output::AddTagsToOnPremisesInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsToOnPremisesInstancesOutput`](crate::output::AddTagsToOnPremisesInstancesOutput)
        pub fn build(self) -> crate::output::AddTagsToOnPremisesInstancesOutput {
            crate::output::AddTagsToOnPremisesInstancesOutput {}
        }
    }
}
impl AddTagsToOnPremisesInstancesOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToOnPremisesInstancesOutput`](crate::output::AddTagsToOnPremisesInstancesOutput)
    pub fn builder() -> crate::output::add_tags_to_on_premises_instances_output::Builder {
        crate::output::add_tags_to_on_premises_instances_output::Builder::default()
    }
}
