// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateApprovalRuleTemplateWithRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_approval_rule_template_with_repository`](crate::client::Client::associate_approval_rule_template_with_repository).
///
/// See [`crate::client::fluent_builders::AssociateApprovalRuleTemplateWithRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateApprovalRuleTemplateWithRepository {
    _private: (),
}
impl AssociateApprovalRuleTemplateWithRepository {
    /// Creates a new builder-style object to manufacture [`AssociateApprovalRuleTemplateWithRepositoryInput`](crate::input::AssociateApprovalRuleTemplateWithRepositoryInput)
    pub fn builder() -> crate::input::associate_approval_rule_template_with_repository_input::Builder
    {
        crate::input::associate_approval_rule_template_with_repository_input::Builder::default()
    }
    /// Creates a new `AssociateApprovalRuleTemplateWithRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for AssociateApprovalRuleTemplateWithRepository
{
    type Output = std::result::Result<
        crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput,
        crate::error::AssociateApprovalRuleTemplateWithRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_approval_rule_template_with_repository_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_approval_rule_template_with_repository_response(
                response,
            )
        }
    }
}

/// Operation shape for `BatchAssociateApprovalRuleTemplateWithRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_associate_approval_rule_template_with_repositories`](crate::client::Client::batch_associate_approval_rule_template_with_repositories).
///
/// See [`crate::client::fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchAssociateApprovalRuleTemplateWithRepositories {
    _private: (),
}
impl BatchAssociateApprovalRuleTemplateWithRepositories {
    /// Creates a new builder-style object to manufacture [`BatchAssociateApprovalRuleTemplateWithRepositoriesInput`](crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput)
    pub fn builder(
    ) -> crate::input::batch_associate_approval_rule_template_with_repositories_input::Builder {
        crate::input::batch_associate_approval_rule_template_with_repositories_input::Builder::default()
    }
    /// Creates a new `BatchAssociateApprovalRuleTemplateWithRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for BatchAssociateApprovalRuleTemplateWithRepositories
{
    type Output = std::result::Result<
        crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput,
        crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_associate_approval_rule_template_with_repositories_error(response)
        } else {
            crate::operation_deser::parse_batch_associate_approval_rule_template_with_repositories_response(response)
        }
    }
}

/// Operation shape for `BatchDescribeMergeConflicts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_describe_merge_conflicts`](crate::client::Client::batch_describe_merge_conflicts).
///
/// See [`crate::client::fluent_builders::BatchDescribeMergeConflicts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDescribeMergeConflicts {
    _private: (),
}
impl BatchDescribeMergeConflicts {
    /// Creates a new builder-style object to manufacture [`BatchDescribeMergeConflictsInput`](crate::input::BatchDescribeMergeConflictsInput)
    pub fn builder() -> crate::input::batch_describe_merge_conflicts_input::Builder {
        crate::input::batch_describe_merge_conflicts_input::Builder::default()
    }
    /// Creates a new `BatchDescribeMergeConflicts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDescribeMergeConflicts {
    type Output = std::result::Result<
        crate::output::BatchDescribeMergeConflictsOutput,
        crate::error::BatchDescribeMergeConflictsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_describe_merge_conflicts_error(response)
        } else {
            crate::operation_deser::parse_batch_describe_merge_conflicts_response(response)
        }
    }
}

/// Operation shape for `BatchDisassociateApprovalRuleTemplateFromRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_disassociate_approval_rule_template_from_repositories`](crate::client::Client::batch_disassociate_approval_rule_template_from_repositories).
///
/// See [`crate::client::fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDisassociateApprovalRuleTemplateFromRepositories {
    _private: (),
}
impl BatchDisassociateApprovalRuleTemplateFromRepositories {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateApprovalRuleTemplateFromRepositoriesInput`](crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput)
    pub fn builder(
    ) -> crate::input::batch_disassociate_approval_rule_template_from_repositories_input::Builder
    {
        crate::input::batch_disassociate_approval_rule_template_from_repositories_input::Builder::default()
    }
    /// Creates a new `BatchDisassociateApprovalRuleTemplateFromRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for BatchDisassociateApprovalRuleTemplateFromRepositories
{
    type Output = std::result::Result<
        crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput,
        crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_disassociate_approval_rule_template_from_repositories_error(response)
        } else {
            crate::operation_deser::parse_batch_disassociate_approval_rule_template_from_repositories_response(response)
        }
    }
}

/// Operation shape for `BatchGetCommits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_commits`](crate::client::Client::batch_get_commits).
///
/// See [`crate::client::fluent_builders::BatchGetCommits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetCommits {
    _private: (),
}
impl BatchGetCommits {
    /// Creates a new builder-style object to manufacture [`BatchGetCommitsInput`](crate::input::BatchGetCommitsInput)
    pub fn builder() -> crate::input::batch_get_commits_input::Builder {
        crate::input::batch_get_commits_input::Builder::default()
    }
    /// Creates a new `BatchGetCommits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetCommits {
    type Output = std::result::Result<
        crate::output::BatchGetCommitsOutput,
        crate::error::BatchGetCommitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_commits_error(response)
        } else {
            crate::operation_deser::parse_batch_get_commits_response(response)
        }
    }
}

/// Operation shape for `BatchGetRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_repositories`](crate::client::Client::batch_get_repositories).
///
/// See [`crate::client::fluent_builders::BatchGetRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetRepositories {
    _private: (),
}
impl BatchGetRepositories {
    /// Creates a new builder-style object to manufacture [`BatchGetRepositoriesInput`](crate::input::BatchGetRepositoriesInput)
    pub fn builder() -> crate::input::batch_get_repositories_input::Builder {
        crate::input::batch_get_repositories_input::Builder::default()
    }
    /// Creates a new `BatchGetRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetRepositories {
    type Output = std::result::Result<
        crate::output::BatchGetRepositoriesOutput,
        crate::error::BatchGetRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_repositories_error(response)
        } else {
            crate::operation_deser::parse_batch_get_repositories_response(response)
        }
    }
}

/// Operation shape for `CreateApprovalRuleTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_approval_rule_template`](crate::client::Client::create_approval_rule_template).
///
/// See [`crate::client::fluent_builders::CreateApprovalRuleTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApprovalRuleTemplate {
    _private: (),
}
impl CreateApprovalRuleTemplate {
    /// Creates a new builder-style object to manufacture [`CreateApprovalRuleTemplateInput`](crate::input::CreateApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::create_approval_rule_template_input::Builder {
        crate::input::create_approval_rule_template_input::Builder::default()
    }
    /// Creates a new `CreateApprovalRuleTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApprovalRuleTemplate {
    type Output = std::result::Result<
        crate::output::CreateApprovalRuleTemplateOutput,
        crate::error::CreateApprovalRuleTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_approval_rule_template_error(response)
        } else {
            crate::operation_deser::parse_create_approval_rule_template_response(response)
        }
    }
}

/// Operation shape for `CreateBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_branch`](crate::client::Client::create_branch).
///
/// See [`crate::client::fluent_builders::CreateBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBranch {
    _private: (),
}
impl CreateBranch {
    /// Creates a new builder-style object to manufacture [`CreateBranchInput`](crate::input::CreateBranchInput)
    pub fn builder() -> crate::input::create_branch_input::Builder {
        crate::input::create_branch_input::Builder::default()
    }
    /// Creates a new `CreateBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBranch {
    type Output =
        std::result::Result<crate::output::CreateBranchOutput, crate::error::CreateBranchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_branch_error(response)
        } else {
            crate::operation_deser::parse_create_branch_response(response)
        }
    }
}

/// Operation shape for `CreateCommit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_commit`](crate::client::Client::create_commit).
///
/// See [`crate::client::fluent_builders::CreateCommit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCommit {
    _private: (),
}
impl CreateCommit {
    /// Creates a new builder-style object to manufacture [`CreateCommitInput`](crate::input::CreateCommitInput)
    pub fn builder() -> crate::input::create_commit_input::Builder {
        crate::input::create_commit_input::Builder::default()
    }
    /// Creates a new `CreateCommit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCommit {
    type Output =
        std::result::Result<crate::output::CreateCommitOutput, crate::error::CreateCommitError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_commit_error(response)
        } else {
            crate::operation_deser::parse_create_commit_response(response)
        }
    }
}

/// Operation shape for `CreatePullRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pull_request`](crate::client::Client::create_pull_request).
///
/// See [`crate::client::fluent_builders::CreatePullRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePullRequest {
    _private: (),
}
impl CreatePullRequest {
    /// Creates a new builder-style object to manufacture [`CreatePullRequestInput`](crate::input::CreatePullRequestInput)
    pub fn builder() -> crate::input::create_pull_request_input::Builder {
        crate::input::create_pull_request_input::Builder::default()
    }
    /// Creates a new `CreatePullRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePullRequest {
    type Output = std::result::Result<
        crate::output::CreatePullRequestOutput,
        crate::error::CreatePullRequestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_pull_request_error(response)
        } else {
            crate::operation_deser::parse_create_pull_request_response(response)
        }
    }
}

/// Operation shape for `CreatePullRequestApprovalRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pull_request_approval_rule`](crate::client::Client::create_pull_request_approval_rule).
///
/// See [`crate::client::fluent_builders::CreatePullRequestApprovalRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePullRequestApprovalRule {
    _private: (),
}
impl CreatePullRequestApprovalRule {
    /// Creates a new builder-style object to manufacture [`CreatePullRequestApprovalRuleInput`](crate::input::CreatePullRequestApprovalRuleInput)
    pub fn builder() -> crate::input::create_pull_request_approval_rule_input::Builder {
        crate::input::create_pull_request_approval_rule_input::Builder::default()
    }
    /// Creates a new `CreatePullRequestApprovalRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePullRequestApprovalRule {
    type Output = std::result::Result<
        crate::output::CreatePullRequestApprovalRuleOutput,
        crate::error::CreatePullRequestApprovalRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_pull_request_approval_rule_error(response)
        } else {
            crate::operation_deser::parse_create_pull_request_approval_rule_response(response)
        }
    }
}

/// Operation shape for `CreateRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_repository`](crate::client::Client::create_repository).
///
/// See [`crate::client::fluent_builders::CreateRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRepository {
    _private: (),
}
impl CreateRepository {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
    /// Creates a new `CreateRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRepository {
    type Output = std::result::Result<
        crate::output::CreateRepositoryOutput,
        crate::error::CreateRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_repository_error(response)
        } else {
            crate::operation_deser::parse_create_repository_response(response)
        }
    }
}

/// Operation shape for `CreateUnreferencedMergeCommit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_unreferenced_merge_commit`](crate::client::Client::create_unreferenced_merge_commit).
///
/// See [`crate::client::fluent_builders::CreateUnreferencedMergeCommit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUnreferencedMergeCommit {
    _private: (),
}
impl CreateUnreferencedMergeCommit {
    /// Creates a new builder-style object to manufacture [`CreateUnreferencedMergeCommitInput`](crate::input::CreateUnreferencedMergeCommitInput)
    pub fn builder() -> crate::input::create_unreferenced_merge_commit_input::Builder {
        crate::input::create_unreferenced_merge_commit_input::Builder::default()
    }
    /// Creates a new `CreateUnreferencedMergeCommit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUnreferencedMergeCommit {
    type Output = std::result::Result<
        crate::output::CreateUnreferencedMergeCommitOutput,
        crate::error::CreateUnreferencedMergeCommitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_unreferenced_merge_commit_error(response)
        } else {
            crate::operation_deser::parse_create_unreferenced_merge_commit_response(response)
        }
    }
}

/// Operation shape for `DeleteApprovalRuleTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_approval_rule_template`](crate::client::Client::delete_approval_rule_template).
///
/// See [`crate::client::fluent_builders::DeleteApprovalRuleTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApprovalRuleTemplate {
    _private: (),
}
impl DeleteApprovalRuleTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteApprovalRuleTemplateInput`](crate::input::DeleteApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::delete_approval_rule_template_input::Builder {
        crate::input::delete_approval_rule_template_input::Builder::default()
    }
    /// Creates a new `DeleteApprovalRuleTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApprovalRuleTemplate {
    type Output = std::result::Result<
        crate::output::DeleteApprovalRuleTemplateOutput,
        crate::error::DeleteApprovalRuleTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_approval_rule_template_error(response)
        } else {
            crate::operation_deser::parse_delete_approval_rule_template_response(response)
        }
    }
}

/// Operation shape for `DeleteBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_branch`](crate::client::Client::delete_branch).
///
/// See [`crate::client::fluent_builders::DeleteBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBranch {
    _private: (),
}
impl DeleteBranch {
    /// Creates a new builder-style object to manufacture [`DeleteBranchInput`](crate::input::DeleteBranchInput)
    pub fn builder() -> crate::input::delete_branch_input::Builder {
        crate::input::delete_branch_input::Builder::default()
    }
    /// Creates a new `DeleteBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBranch {
    type Output =
        std::result::Result<crate::output::DeleteBranchOutput, crate::error::DeleteBranchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_branch_error(response)
        } else {
            crate::operation_deser::parse_delete_branch_response(response)
        }
    }
}

/// Operation shape for `DeleteCommentContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_comment_content`](crate::client::Client::delete_comment_content).
///
/// See [`crate::client::fluent_builders::DeleteCommentContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCommentContent {
    _private: (),
}
impl DeleteCommentContent {
    /// Creates a new builder-style object to manufacture [`DeleteCommentContentInput`](crate::input::DeleteCommentContentInput)
    pub fn builder() -> crate::input::delete_comment_content_input::Builder {
        crate::input::delete_comment_content_input::Builder::default()
    }
    /// Creates a new `DeleteCommentContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCommentContent {
    type Output = std::result::Result<
        crate::output::DeleteCommentContentOutput,
        crate::error::DeleteCommentContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_comment_content_error(response)
        } else {
            crate::operation_deser::parse_delete_comment_content_response(response)
        }
    }
}

/// Operation shape for `DeleteFile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_file`](crate::client::Client::delete_file).
///
/// See [`crate::client::fluent_builders::DeleteFile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFile {
    _private: (),
}
impl DeleteFile {
    /// Creates a new builder-style object to manufacture [`DeleteFileInput`](crate::input::DeleteFileInput)
    pub fn builder() -> crate::input::delete_file_input::Builder {
        crate::input::delete_file_input::Builder::default()
    }
    /// Creates a new `DeleteFile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFile {
    type Output =
        std::result::Result<crate::output::DeleteFileOutput, crate::error::DeleteFileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_file_error(response)
        } else {
            crate::operation_deser::parse_delete_file_response(response)
        }
    }
}

/// Operation shape for `DeletePullRequestApprovalRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pull_request_approval_rule`](crate::client::Client::delete_pull_request_approval_rule).
///
/// See [`crate::client::fluent_builders::DeletePullRequestApprovalRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePullRequestApprovalRule {
    _private: (),
}
impl DeletePullRequestApprovalRule {
    /// Creates a new builder-style object to manufacture [`DeletePullRequestApprovalRuleInput`](crate::input::DeletePullRequestApprovalRuleInput)
    pub fn builder() -> crate::input::delete_pull_request_approval_rule_input::Builder {
        crate::input::delete_pull_request_approval_rule_input::Builder::default()
    }
    /// Creates a new `DeletePullRequestApprovalRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePullRequestApprovalRule {
    type Output = std::result::Result<
        crate::output::DeletePullRequestApprovalRuleOutput,
        crate::error::DeletePullRequestApprovalRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_pull_request_approval_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_pull_request_approval_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository`](crate::client::Client::delete_repository).
///
/// See [`crate::client::fluent_builders::DeleteRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepository {
    _private: (),
}
impl DeleteRepository {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
    /// Creates a new `DeleteRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepository {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryOutput,
        crate::error::DeleteRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_response(response)
        }
    }
}

/// Operation shape for `DescribeMergeConflicts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_merge_conflicts`](crate::client::Client::describe_merge_conflicts).
///
/// See [`crate::client::fluent_builders::DescribeMergeConflicts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMergeConflicts {
    _private: (),
}
impl DescribeMergeConflicts {
    /// Creates a new builder-style object to manufacture [`DescribeMergeConflictsInput`](crate::input::DescribeMergeConflictsInput)
    pub fn builder() -> crate::input::describe_merge_conflicts_input::Builder {
        crate::input::describe_merge_conflicts_input::Builder::default()
    }
    /// Creates a new `DescribeMergeConflicts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMergeConflicts {
    type Output = std::result::Result<
        crate::output::DescribeMergeConflictsOutput,
        crate::error::DescribeMergeConflictsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_merge_conflicts_error(response)
        } else {
            crate::operation_deser::parse_describe_merge_conflicts_response(response)
        }
    }
}

/// Operation shape for `DescribePullRequestEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pull_request_events`](crate::client::Client::describe_pull_request_events).
///
/// See [`crate::client::fluent_builders::DescribePullRequestEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePullRequestEvents {
    _private: (),
}
impl DescribePullRequestEvents {
    /// Creates a new builder-style object to manufacture [`DescribePullRequestEventsInput`](crate::input::DescribePullRequestEventsInput)
    pub fn builder() -> crate::input::describe_pull_request_events_input::Builder {
        crate::input::describe_pull_request_events_input::Builder::default()
    }
    /// Creates a new `DescribePullRequestEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePullRequestEvents {
    type Output = std::result::Result<
        crate::output::DescribePullRequestEventsOutput,
        crate::error::DescribePullRequestEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pull_request_events_error(response)
        } else {
            crate::operation_deser::parse_describe_pull_request_events_response(response)
        }
    }
}

/// Operation shape for `DisassociateApprovalRuleTemplateFromRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_approval_rule_template_from_repository`](crate::client::Client::disassociate_approval_rule_template_from_repository).
///
/// See [`crate::client::fluent_builders::DisassociateApprovalRuleTemplateFromRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateApprovalRuleTemplateFromRepository {
    _private: (),
}
impl DisassociateApprovalRuleTemplateFromRepository {
    /// Creates a new builder-style object to manufacture [`DisassociateApprovalRuleTemplateFromRepositoryInput`](crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput)
    pub fn builder(
    ) -> crate::input::disassociate_approval_rule_template_from_repository_input::Builder {
        crate::input::disassociate_approval_rule_template_from_repository_input::Builder::default()
    }
    /// Creates a new `DisassociateApprovalRuleTemplateFromRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DisassociateApprovalRuleTemplateFromRepository
{
    type Output = std::result::Result<
        crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput,
        crate::error::DisassociateApprovalRuleTemplateFromRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_approval_rule_template_from_repository_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_approval_rule_template_from_repository_response(response)
        }
    }
}

/// Operation shape for `EvaluatePullRequestApprovalRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`evaluate_pull_request_approval_rules`](crate::client::Client::evaluate_pull_request_approval_rules).
///
/// See [`crate::client::fluent_builders::EvaluatePullRequestApprovalRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EvaluatePullRequestApprovalRules {
    _private: (),
}
impl EvaluatePullRequestApprovalRules {
    /// Creates a new builder-style object to manufacture [`EvaluatePullRequestApprovalRulesInput`](crate::input::EvaluatePullRequestApprovalRulesInput)
    pub fn builder() -> crate::input::evaluate_pull_request_approval_rules_input::Builder {
        crate::input::evaluate_pull_request_approval_rules_input::Builder::default()
    }
    /// Creates a new `EvaluatePullRequestApprovalRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EvaluatePullRequestApprovalRules {
    type Output = std::result::Result<
        crate::output::EvaluatePullRequestApprovalRulesOutput,
        crate::error::EvaluatePullRequestApprovalRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_evaluate_pull_request_approval_rules_error(response)
        } else {
            crate::operation_deser::parse_evaluate_pull_request_approval_rules_response(response)
        }
    }
}

/// Operation shape for `GetApprovalRuleTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_approval_rule_template`](crate::client::Client::get_approval_rule_template).
///
/// See [`crate::client::fluent_builders::GetApprovalRuleTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApprovalRuleTemplate {
    _private: (),
}
impl GetApprovalRuleTemplate {
    /// Creates a new builder-style object to manufacture [`GetApprovalRuleTemplateInput`](crate::input::GetApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::get_approval_rule_template_input::Builder {
        crate::input::get_approval_rule_template_input::Builder::default()
    }
    /// Creates a new `GetApprovalRuleTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApprovalRuleTemplate {
    type Output = std::result::Result<
        crate::output::GetApprovalRuleTemplateOutput,
        crate::error::GetApprovalRuleTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_approval_rule_template_error(response)
        } else {
            crate::operation_deser::parse_get_approval_rule_template_response(response)
        }
    }
}

/// Operation shape for `GetBlob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_blob`](crate::client::Client::get_blob).
///
/// See [`crate::client::fluent_builders::GetBlob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBlob {
    _private: (),
}
impl GetBlob {
    /// Creates a new builder-style object to manufacture [`GetBlobInput`](crate::input::GetBlobInput)
    pub fn builder() -> crate::input::get_blob_input::Builder {
        crate::input::get_blob_input::Builder::default()
    }
    /// Creates a new `GetBlob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBlob {
    type Output = std::result::Result<crate::output::GetBlobOutput, crate::error::GetBlobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_blob_error(response)
        } else {
            crate::operation_deser::parse_get_blob_response(response)
        }
    }
}

/// Operation shape for `GetBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_branch`](crate::client::Client::get_branch).
///
/// See [`crate::client::fluent_builders::GetBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBranch {
    _private: (),
}
impl GetBranch {
    /// Creates a new builder-style object to manufacture [`GetBranchInput`](crate::input::GetBranchInput)
    pub fn builder() -> crate::input::get_branch_input::Builder {
        crate::input::get_branch_input::Builder::default()
    }
    /// Creates a new `GetBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBranch {
    type Output = std::result::Result<crate::output::GetBranchOutput, crate::error::GetBranchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_branch_error(response)
        } else {
            crate::operation_deser::parse_get_branch_response(response)
        }
    }
}

/// Operation shape for `GetComment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_comment`](crate::client::Client::get_comment).
///
/// See [`crate::client::fluent_builders::GetComment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComment {
    _private: (),
}
impl GetComment {
    /// Creates a new builder-style object to manufacture [`GetCommentInput`](crate::input::GetCommentInput)
    pub fn builder() -> crate::input::get_comment_input::Builder {
        crate::input::get_comment_input::Builder::default()
    }
    /// Creates a new `GetComment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComment {
    type Output =
        std::result::Result<crate::output::GetCommentOutput, crate::error::GetCommentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_comment_error(response)
        } else {
            crate::operation_deser::parse_get_comment_response(response)
        }
    }
}

/// Operation shape for `GetCommentReactions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_comment_reactions`](crate::client::Client::get_comment_reactions).
///
/// See [`crate::client::fluent_builders::GetCommentReactions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCommentReactions {
    _private: (),
}
impl GetCommentReactions {
    /// Creates a new builder-style object to manufacture [`GetCommentReactionsInput`](crate::input::GetCommentReactionsInput)
    pub fn builder() -> crate::input::get_comment_reactions_input::Builder {
        crate::input::get_comment_reactions_input::Builder::default()
    }
    /// Creates a new `GetCommentReactions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCommentReactions {
    type Output = std::result::Result<
        crate::output::GetCommentReactionsOutput,
        crate::error::GetCommentReactionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_comment_reactions_error(response)
        } else {
            crate::operation_deser::parse_get_comment_reactions_response(response)
        }
    }
}

/// Operation shape for `GetCommentsForComparedCommit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_comments_for_compared_commit`](crate::client::Client::get_comments_for_compared_commit).
///
/// See [`crate::client::fluent_builders::GetCommentsForComparedCommit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCommentsForComparedCommit {
    _private: (),
}
impl GetCommentsForComparedCommit {
    /// Creates a new builder-style object to manufacture [`GetCommentsForComparedCommitInput`](crate::input::GetCommentsForComparedCommitInput)
    pub fn builder() -> crate::input::get_comments_for_compared_commit_input::Builder {
        crate::input::get_comments_for_compared_commit_input::Builder::default()
    }
    /// Creates a new `GetCommentsForComparedCommit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCommentsForComparedCommit {
    type Output = std::result::Result<
        crate::output::GetCommentsForComparedCommitOutput,
        crate::error::GetCommentsForComparedCommitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_comments_for_compared_commit_error(response)
        } else {
            crate::operation_deser::parse_get_comments_for_compared_commit_response(response)
        }
    }
}

/// Operation shape for `GetCommentsForPullRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_comments_for_pull_request`](crate::client::Client::get_comments_for_pull_request).
///
/// See [`crate::client::fluent_builders::GetCommentsForPullRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCommentsForPullRequest {
    _private: (),
}
impl GetCommentsForPullRequest {
    /// Creates a new builder-style object to manufacture [`GetCommentsForPullRequestInput`](crate::input::GetCommentsForPullRequestInput)
    pub fn builder() -> crate::input::get_comments_for_pull_request_input::Builder {
        crate::input::get_comments_for_pull_request_input::Builder::default()
    }
    /// Creates a new `GetCommentsForPullRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCommentsForPullRequest {
    type Output = std::result::Result<
        crate::output::GetCommentsForPullRequestOutput,
        crate::error::GetCommentsForPullRequestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_comments_for_pull_request_error(response)
        } else {
            crate::operation_deser::parse_get_comments_for_pull_request_response(response)
        }
    }
}

/// Operation shape for `GetCommit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_commit`](crate::client::Client::get_commit).
///
/// See [`crate::client::fluent_builders::GetCommit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCommit {
    _private: (),
}
impl GetCommit {
    /// Creates a new builder-style object to manufacture [`GetCommitInput`](crate::input::GetCommitInput)
    pub fn builder() -> crate::input::get_commit_input::Builder {
        crate::input::get_commit_input::Builder::default()
    }
    /// Creates a new `GetCommit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCommit {
    type Output = std::result::Result<crate::output::GetCommitOutput, crate::error::GetCommitError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_commit_error(response)
        } else {
            crate::operation_deser::parse_get_commit_response(response)
        }
    }
}

/// Operation shape for `GetDifferences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_differences`](crate::client::Client::get_differences).
///
/// See [`crate::client::fluent_builders::GetDifferences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDifferences {
    _private: (),
}
impl GetDifferences {
    /// Creates a new builder-style object to manufacture [`GetDifferencesInput`](crate::input::GetDifferencesInput)
    pub fn builder() -> crate::input::get_differences_input::Builder {
        crate::input::get_differences_input::Builder::default()
    }
    /// Creates a new `GetDifferences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDifferences {
    type Output =
        std::result::Result<crate::output::GetDifferencesOutput, crate::error::GetDifferencesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_differences_error(response)
        } else {
            crate::operation_deser::parse_get_differences_response(response)
        }
    }
}

/// Operation shape for `GetFile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_file`](crate::client::Client::get_file).
///
/// See [`crate::client::fluent_builders::GetFile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFile {
    _private: (),
}
impl GetFile {
    /// Creates a new builder-style object to manufacture [`GetFileInput`](crate::input::GetFileInput)
    pub fn builder() -> crate::input::get_file_input::Builder {
        crate::input::get_file_input::Builder::default()
    }
    /// Creates a new `GetFile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFile {
    type Output = std::result::Result<crate::output::GetFileOutput, crate::error::GetFileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_file_error(response)
        } else {
            crate::operation_deser::parse_get_file_response(response)
        }
    }
}

/// Operation shape for `GetFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_folder`](crate::client::Client::get_folder).
///
/// See [`crate::client::fluent_builders::GetFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFolder {
    _private: (),
}
impl GetFolder {
    /// Creates a new builder-style object to manufacture [`GetFolderInput`](crate::input::GetFolderInput)
    pub fn builder() -> crate::input::get_folder_input::Builder {
        crate::input::get_folder_input::Builder::default()
    }
    /// Creates a new `GetFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFolder {
    type Output = std::result::Result<crate::output::GetFolderOutput, crate::error::GetFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_folder_error(response)
        } else {
            crate::operation_deser::parse_get_folder_response(response)
        }
    }
}

/// Operation shape for `GetMergeCommit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_merge_commit`](crate::client::Client::get_merge_commit).
///
/// See [`crate::client::fluent_builders::GetMergeCommit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMergeCommit {
    _private: (),
}
impl GetMergeCommit {
    /// Creates a new builder-style object to manufacture [`GetMergeCommitInput`](crate::input::GetMergeCommitInput)
    pub fn builder() -> crate::input::get_merge_commit_input::Builder {
        crate::input::get_merge_commit_input::Builder::default()
    }
    /// Creates a new `GetMergeCommit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMergeCommit {
    type Output =
        std::result::Result<crate::output::GetMergeCommitOutput, crate::error::GetMergeCommitError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_merge_commit_error(response)
        } else {
            crate::operation_deser::parse_get_merge_commit_response(response)
        }
    }
}

/// Operation shape for `GetMergeConflicts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_merge_conflicts`](crate::client::Client::get_merge_conflicts).
///
/// See [`crate::client::fluent_builders::GetMergeConflicts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMergeConflicts {
    _private: (),
}
impl GetMergeConflicts {
    /// Creates a new builder-style object to manufacture [`GetMergeConflictsInput`](crate::input::GetMergeConflictsInput)
    pub fn builder() -> crate::input::get_merge_conflicts_input::Builder {
        crate::input::get_merge_conflicts_input::Builder::default()
    }
    /// Creates a new `GetMergeConflicts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMergeConflicts {
    type Output = std::result::Result<
        crate::output::GetMergeConflictsOutput,
        crate::error::GetMergeConflictsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_merge_conflicts_error(response)
        } else {
            crate::operation_deser::parse_get_merge_conflicts_response(response)
        }
    }
}

/// Operation shape for `GetMergeOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_merge_options`](crate::client::Client::get_merge_options).
///
/// See [`crate::client::fluent_builders::GetMergeOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMergeOptions {
    _private: (),
}
impl GetMergeOptions {
    /// Creates a new builder-style object to manufacture [`GetMergeOptionsInput`](crate::input::GetMergeOptionsInput)
    pub fn builder() -> crate::input::get_merge_options_input::Builder {
        crate::input::get_merge_options_input::Builder::default()
    }
    /// Creates a new `GetMergeOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMergeOptions {
    type Output = std::result::Result<
        crate::output::GetMergeOptionsOutput,
        crate::error::GetMergeOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_merge_options_error(response)
        } else {
            crate::operation_deser::parse_get_merge_options_response(response)
        }
    }
}

/// Operation shape for `GetPullRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_pull_request`](crate::client::Client::get_pull_request).
///
/// See [`crate::client::fluent_builders::GetPullRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPullRequest {
    _private: (),
}
impl GetPullRequest {
    /// Creates a new builder-style object to manufacture [`GetPullRequestInput`](crate::input::GetPullRequestInput)
    pub fn builder() -> crate::input::get_pull_request_input::Builder {
        crate::input::get_pull_request_input::Builder::default()
    }
    /// Creates a new `GetPullRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPullRequest {
    type Output =
        std::result::Result<crate::output::GetPullRequestOutput, crate::error::GetPullRequestError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_pull_request_error(response)
        } else {
            crate::operation_deser::parse_get_pull_request_response(response)
        }
    }
}

/// Operation shape for `GetPullRequestApprovalStates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_pull_request_approval_states`](crate::client::Client::get_pull_request_approval_states).
///
/// See [`crate::client::fluent_builders::GetPullRequestApprovalStates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPullRequestApprovalStates {
    _private: (),
}
impl GetPullRequestApprovalStates {
    /// Creates a new builder-style object to manufacture [`GetPullRequestApprovalStatesInput`](crate::input::GetPullRequestApprovalStatesInput)
    pub fn builder() -> crate::input::get_pull_request_approval_states_input::Builder {
        crate::input::get_pull_request_approval_states_input::Builder::default()
    }
    /// Creates a new `GetPullRequestApprovalStates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPullRequestApprovalStates {
    type Output = std::result::Result<
        crate::output::GetPullRequestApprovalStatesOutput,
        crate::error::GetPullRequestApprovalStatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_pull_request_approval_states_error(response)
        } else {
            crate::operation_deser::parse_get_pull_request_approval_states_response(response)
        }
    }
}

/// Operation shape for `GetPullRequestOverrideState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_pull_request_override_state`](crate::client::Client::get_pull_request_override_state).
///
/// See [`crate::client::fluent_builders::GetPullRequestOverrideState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPullRequestOverrideState {
    _private: (),
}
impl GetPullRequestOverrideState {
    /// Creates a new builder-style object to manufacture [`GetPullRequestOverrideStateInput`](crate::input::GetPullRequestOverrideStateInput)
    pub fn builder() -> crate::input::get_pull_request_override_state_input::Builder {
        crate::input::get_pull_request_override_state_input::Builder::default()
    }
    /// Creates a new `GetPullRequestOverrideState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPullRequestOverrideState {
    type Output = std::result::Result<
        crate::output::GetPullRequestOverrideStateOutput,
        crate::error::GetPullRequestOverrideStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_pull_request_override_state_error(response)
        } else {
            crate::operation_deser::parse_get_pull_request_override_state_response(response)
        }
    }
}

/// Operation shape for `GetRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository`](crate::client::Client::get_repository).
///
/// See [`crate::client::fluent_builders::GetRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepository {
    _private: (),
}
impl GetRepository {
    /// Creates a new builder-style object to manufacture [`GetRepositoryInput`](crate::input::GetRepositoryInput)
    pub fn builder() -> crate::input::get_repository_input::Builder {
        crate::input::get_repository_input::Builder::default()
    }
    /// Creates a new `GetRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepository {
    type Output =
        std::result::Result<crate::output::GetRepositoryOutput, crate::error::GetRepositoryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_error(response)
        } else {
            crate::operation_deser::parse_get_repository_response(response)
        }
    }
}

/// Operation shape for `GetRepositoryTriggers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository_triggers`](crate::client::Client::get_repository_triggers).
///
/// See [`crate::client::fluent_builders::GetRepositoryTriggers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepositoryTriggers {
    _private: (),
}
impl GetRepositoryTriggers {
    /// Creates a new builder-style object to manufacture [`GetRepositoryTriggersInput`](crate::input::GetRepositoryTriggersInput)
    pub fn builder() -> crate::input::get_repository_triggers_input::Builder {
        crate::input::get_repository_triggers_input::Builder::default()
    }
    /// Creates a new `GetRepositoryTriggers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepositoryTriggers {
    type Output = std::result::Result<
        crate::output::GetRepositoryTriggersOutput,
        crate::error::GetRepositoryTriggersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_triggers_error(response)
        } else {
            crate::operation_deser::parse_get_repository_triggers_response(response)
        }
    }
}

/// Operation shape for `ListApprovalRuleTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_approval_rule_templates`](crate::client::Client::list_approval_rule_templates).
///
/// See [`crate::client::fluent_builders::ListApprovalRuleTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApprovalRuleTemplates {
    _private: (),
}
impl ListApprovalRuleTemplates {
    /// Creates a new builder-style object to manufacture [`ListApprovalRuleTemplatesInput`](crate::input::ListApprovalRuleTemplatesInput)
    pub fn builder() -> crate::input::list_approval_rule_templates_input::Builder {
        crate::input::list_approval_rule_templates_input::Builder::default()
    }
    /// Creates a new `ListApprovalRuleTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApprovalRuleTemplates {
    type Output = std::result::Result<
        crate::output::ListApprovalRuleTemplatesOutput,
        crate::error::ListApprovalRuleTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_approval_rule_templates_error(response)
        } else {
            crate::operation_deser::parse_list_approval_rule_templates_response(response)
        }
    }
}

/// Operation shape for `ListAssociatedApprovalRuleTemplatesForRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_associated_approval_rule_templates_for_repository`](crate::client::Client::list_associated_approval_rule_templates_for_repository).
///
/// See [`crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociatedApprovalRuleTemplatesForRepository {
    _private: (),
}
impl ListAssociatedApprovalRuleTemplatesForRepository {
    /// Creates a new builder-style object to manufacture [`ListAssociatedApprovalRuleTemplatesForRepositoryInput`](crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput)
    pub fn builder(
    ) -> crate::input::list_associated_approval_rule_templates_for_repository_input::Builder {
        crate::input::list_associated_approval_rule_templates_for_repository_input::Builder::default(
        )
    }
    /// Creates a new `ListAssociatedApprovalRuleTemplatesForRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for ListAssociatedApprovalRuleTemplatesForRepository
{
    type Output = std::result::Result<
        crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput,
        crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_associated_approval_rule_templates_for_repository_error(response)
        } else {
            crate::operation_deser::parse_list_associated_approval_rule_templates_for_repository_response(response)
        }
    }
}

/// Operation shape for `ListBranches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_branches`](crate::client::Client::list_branches).
///
/// See [`crate::client::fluent_builders::ListBranches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBranches {
    _private: (),
}
impl ListBranches {
    /// Creates a new builder-style object to manufacture [`ListBranchesInput`](crate::input::ListBranchesInput)
    pub fn builder() -> crate::input::list_branches_input::Builder {
        crate::input::list_branches_input::Builder::default()
    }
    /// Creates a new `ListBranches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBranches {
    type Output =
        std::result::Result<crate::output::ListBranchesOutput, crate::error::ListBranchesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_branches_error(response)
        } else {
            crate::operation_deser::parse_list_branches_response(response)
        }
    }
}

/// Operation shape for `ListPullRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pull_requests`](crate::client::Client::list_pull_requests).
///
/// See [`crate::client::fluent_builders::ListPullRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPullRequests {
    _private: (),
}
impl ListPullRequests {
    /// Creates a new builder-style object to manufacture [`ListPullRequestsInput`](crate::input::ListPullRequestsInput)
    pub fn builder() -> crate::input::list_pull_requests_input::Builder {
        crate::input::list_pull_requests_input::Builder::default()
    }
    /// Creates a new `ListPullRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPullRequests {
    type Output = std::result::Result<
        crate::output::ListPullRequestsOutput,
        crate::error::ListPullRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pull_requests_error(response)
        } else {
            crate::operation_deser::parse_list_pull_requests_response(response)
        }
    }
}

/// Operation shape for `ListRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_repositories`](crate::client::Client::list_repositories).
///
/// See [`crate::client::fluent_builders::ListRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRepositories {
    _private: (),
}
impl ListRepositories {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
    pub fn builder() -> crate::input::list_repositories_input::Builder {
        crate::input::list_repositories_input::Builder::default()
    }
    /// Creates a new `ListRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRepositories {
    type Output = std::result::Result<
        crate::output::ListRepositoriesOutput,
        crate::error::ListRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_repositories_error(response)
        } else {
            crate::operation_deser::parse_list_repositories_response(response)
        }
    }
}

/// Operation shape for `ListRepositoriesForApprovalRuleTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_repositories_for_approval_rule_template`](crate::client::Client::list_repositories_for_approval_rule_template).
///
/// See [`crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRepositoriesForApprovalRuleTemplate {
    _private: (),
}
impl ListRepositoriesForApprovalRuleTemplate {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesForApprovalRuleTemplateInput`](crate::input::ListRepositoriesForApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::list_repositories_for_approval_rule_template_input::Builder {
        crate::input::list_repositories_for_approval_rule_template_input::Builder::default()
    }
    /// Creates a new `ListRepositoriesForApprovalRuleTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRepositoriesForApprovalRuleTemplate {
    type Output = std::result::Result<
        crate::output::ListRepositoriesForApprovalRuleTemplateOutput,
        crate::error::ListRepositoriesForApprovalRuleTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_repositories_for_approval_rule_template_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_repositories_for_approval_rule_template_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `MergeBranchesByFastForward`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`merge_branches_by_fast_forward`](crate::client::Client::merge_branches_by_fast_forward).
///
/// See [`crate::client::fluent_builders::MergeBranchesByFastForward`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MergeBranchesByFastForward {
    _private: (),
}
impl MergeBranchesByFastForward {
    /// Creates a new builder-style object to manufacture [`MergeBranchesByFastForwardInput`](crate::input::MergeBranchesByFastForwardInput)
    pub fn builder() -> crate::input::merge_branches_by_fast_forward_input::Builder {
        crate::input::merge_branches_by_fast_forward_input::Builder::default()
    }
    /// Creates a new `MergeBranchesByFastForward` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MergeBranchesByFastForward {
    type Output = std::result::Result<
        crate::output::MergeBranchesByFastForwardOutput,
        crate::error::MergeBranchesByFastForwardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_merge_branches_by_fast_forward_error(response)
        } else {
            crate::operation_deser::parse_merge_branches_by_fast_forward_response(response)
        }
    }
}

/// Operation shape for `MergeBranchesBySquash`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`merge_branches_by_squash`](crate::client::Client::merge_branches_by_squash).
///
/// See [`crate::client::fluent_builders::MergeBranchesBySquash`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MergeBranchesBySquash {
    _private: (),
}
impl MergeBranchesBySquash {
    /// Creates a new builder-style object to manufacture [`MergeBranchesBySquashInput`](crate::input::MergeBranchesBySquashInput)
    pub fn builder() -> crate::input::merge_branches_by_squash_input::Builder {
        crate::input::merge_branches_by_squash_input::Builder::default()
    }
    /// Creates a new `MergeBranchesBySquash` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MergeBranchesBySquash {
    type Output = std::result::Result<
        crate::output::MergeBranchesBySquashOutput,
        crate::error::MergeBranchesBySquashError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_merge_branches_by_squash_error(response)
        } else {
            crate::operation_deser::parse_merge_branches_by_squash_response(response)
        }
    }
}

/// Operation shape for `MergeBranchesByThreeWay`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`merge_branches_by_three_way`](crate::client::Client::merge_branches_by_three_way).
///
/// See [`crate::client::fluent_builders::MergeBranchesByThreeWay`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MergeBranchesByThreeWay {
    _private: (),
}
impl MergeBranchesByThreeWay {
    /// Creates a new builder-style object to manufacture [`MergeBranchesByThreeWayInput`](crate::input::MergeBranchesByThreeWayInput)
    pub fn builder() -> crate::input::merge_branches_by_three_way_input::Builder {
        crate::input::merge_branches_by_three_way_input::Builder::default()
    }
    /// Creates a new `MergeBranchesByThreeWay` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MergeBranchesByThreeWay {
    type Output = std::result::Result<
        crate::output::MergeBranchesByThreeWayOutput,
        crate::error::MergeBranchesByThreeWayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_merge_branches_by_three_way_error(response)
        } else {
            crate::operation_deser::parse_merge_branches_by_three_way_response(response)
        }
    }
}

/// Operation shape for `MergePullRequestByFastForward`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`merge_pull_request_by_fast_forward`](crate::client::Client::merge_pull_request_by_fast_forward).
///
/// See [`crate::client::fluent_builders::MergePullRequestByFastForward`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MergePullRequestByFastForward {
    _private: (),
}
impl MergePullRequestByFastForward {
    /// Creates a new builder-style object to manufacture [`MergePullRequestByFastForwardInput`](crate::input::MergePullRequestByFastForwardInput)
    pub fn builder() -> crate::input::merge_pull_request_by_fast_forward_input::Builder {
        crate::input::merge_pull_request_by_fast_forward_input::Builder::default()
    }
    /// Creates a new `MergePullRequestByFastForward` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MergePullRequestByFastForward {
    type Output = std::result::Result<
        crate::output::MergePullRequestByFastForwardOutput,
        crate::error::MergePullRequestByFastForwardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_merge_pull_request_by_fast_forward_error(response)
        } else {
            crate::operation_deser::parse_merge_pull_request_by_fast_forward_response(response)
        }
    }
}

/// Operation shape for `MergePullRequestBySquash`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`merge_pull_request_by_squash`](crate::client::Client::merge_pull_request_by_squash).
///
/// See [`crate::client::fluent_builders::MergePullRequestBySquash`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MergePullRequestBySquash {
    _private: (),
}
impl MergePullRequestBySquash {
    /// Creates a new builder-style object to manufacture [`MergePullRequestBySquashInput`](crate::input::MergePullRequestBySquashInput)
    pub fn builder() -> crate::input::merge_pull_request_by_squash_input::Builder {
        crate::input::merge_pull_request_by_squash_input::Builder::default()
    }
    /// Creates a new `MergePullRequestBySquash` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MergePullRequestBySquash {
    type Output = std::result::Result<
        crate::output::MergePullRequestBySquashOutput,
        crate::error::MergePullRequestBySquashError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_merge_pull_request_by_squash_error(response)
        } else {
            crate::operation_deser::parse_merge_pull_request_by_squash_response(response)
        }
    }
}

/// Operation shape for `MergePullRequestByThreeWay`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`merge_pull_request_by_three_way`](crate::client::Client::merge_pull_request_by_three_way).
///
/// See [`crate::client::fluent_builders::MergePullRequestByThreeWay`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MergePullRequestByThreeWay {
    _private: (),
}
impl MergePullRequestByThreeWay {
    /// Creates a new builder-style object to manufacture [`MergePullRequestByThreeWayInput`](crate::input::MergePullRequestByThreeWayInput)
    pub fn builder() -> crate::input::merge_pull_request_by_three_way_input::Builder {
        crate::input::merge_pull_request_by_three_way_input::Builder::default()
    }
    /// Creates a new `MergePullRequestByThreeWay` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MergePullRequestByThreeWay {
    type Output = std::result::Result<
        crate::output::MergePullRequestByThreeWayOutput,
        crate::error::MergePullRequestByThreeWayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_merge_pull_request_by_three_way_error(response)
        } else {
            crate::operation_deser::parse_merge_pull_request_by_three_way_response(response)
        }
    }
}

/// Operation shape for `OverridePullRequestApprovalRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`override_pull_request_approval_rules`](crate::client::Client::override_pull_request_approval_rules).
///
/// See [`crate::client::fluent_builders::OverridePullRequestApprovalRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct OverridePullRequestApprovalRules {
    _private: (),
}
impl OverridePullRequestApprovalRules {
    /// Creates a new builder-style object to manufacture [`OverridePullRequestApprovalRulesInput`](crate::input::OverridePullRequestApprovalRulesInput)
    pub fn builder() -> crate::input::override_pull_request_approval_rules_input::Builder {
        crate::input::override_pull_request_approval_rules_input::Builder::default()
    }
    /// Creates a new `OverridePullRequestApprovalRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for OverridePullRequestApprovalRules {
    type Output = std::result::Result<
        crate::output::OverridePullRequestApprovalRulesOutput,
        crate::error::OverridePullRequestApprovalRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_override_pull_request_approval_rules_error(response)
        } else {
            crate::operation_deser::parse_override_pull_request_approval_rules_response(response)
        }
    }
}

/// Operation shape for `PostCommentForComparedCommit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`post_comment_for_compared_commit`](crate::client::Client::post_comment_for_compared_commit).
///
/// See [`crate::client::fluent_builders::PostCommentForComparedCommit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PostCommentForComparedCommit {
    _private: (),
}
impl PostCommentForComparedCommit {
    /// Creates a new builder-style object to manufacture [`PostCommentForComparedCommitInput`](crate::input::PostCommentForComparedCommitInput)
    pub fn builder() -> crate::input::post_comment_for_compared_commit_input::Builder {
        crate::input::post_comment_for_compared_commit_input::Builder::default()
    }
    /// Creates a new `PostCommentForComparedCommit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PostCommentForComparedCommit {
    type Output = std::result::Result<
        crate::output::PostCommentForComparedCommitOutput,
        crate::error::PostCommentForComparedCommitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_post_comment_for_compared_commit_error(response)
        } else {
            crate::operation_deser::parse_post_comment_for_compared_commit_response(response)
        }
    }
}

/// Operation shape for `PostCommentForPullRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`post_comment_for_pull_request`](crate::client::Client::post_comment_for_pull_request).
///
/// See [`crate::client::fluent_builders::PostCommentForPullRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PostCommentForPullRequest {
    _private: (),
}
impl PostCommentForPullRequest {
    /// Creates a new builder-style object to manufacture [`PostCommentForPullRequestInput`](crate::input::PostCommentForPullRequestInput)
    pub fn builder() -> crate::input::post_comment_for_pull_request_input::Builder {
        crate::input::post_comment_for_pull_request_input::Builder::default()
    }
    /// Creates a new `PostCommentForPullRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PostCommentForPullRequest {
    type Output = std::result::Result<
        crate::output::PostCommentForPullRequestOutput,
        crate::error::PostCommentForPullRequestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_post_comment_for_pull_request_error(response)
        } else {
            crate::operation_deser::parse_post_comment_for_pull_request_response(response)
        }
    }
}

/// Operation shape for `PostCommentReply`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`post_comment_reply`](crate::client::Client::post_comment_reply).
///
/// See [`crate::client::fluent_builders::PostCommentReply`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PostCommentReply {
    _private: (),
}
impl PostCommentReply {
    /// Creates a new builder-style object to manufacture [`PostCommentReplyInput`](crate::input::PostCommentReplyInput)
    pub fn builder() -> crate::input::post_comment_reply_input::Builder {
        crate::input::post_comment_reply_input::Builder::default()
    }
    /// Creates a new `PostCommentReply` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PostCommentReply {
    type Output = std::result::Result<
        crate::output::PostCommentReplyOutput,
        crate::error::PostCommentReplyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_post_comment_reply_error(response)
        } else {
            crate::operation_deser::parse_post_comment_reply_response(response)
        }
    }
}

/// Operation shape for `PutCommentReaction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_comment_reaction`](crate::client::Client::put_comment_reaction).
///
/// See [`crate::client::fluent_builders::PutCommentReaction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutCommentReaction {
    _private: (),
}
impl PutCommentReaction {
    /// Creates a new builder-style object to manufacture [`PutCommentReactionInput`](crate::input::PutCommentReactionInput)
    pub fn builder() -> crate::input::put_comment_reaction_input::Builder {
        crate::input::put_comment_reaction_input::Builder::default()
    }
    /// Creates a new `PutCommentReaction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutCommentReaction {
    type Output = std::result::Result<
        crate::output::PutCommentReactionOutput,
        crate::error::PutCommentReactionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_comment_reaction_error(response)
        } else {
            crate::operation_deser::parse_put_comment_reaction_response(response)
        }
    }
}

/// Operation shape for `PutFile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_file`](crate::client::Client::put_file).
///
/// See [`crate::client::fluent_builders::PutFile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFile {
    _private: (),
}
impl PutFile {
    /// Creates a new builder-style object to manufacture [`PutFileInput`](crate::input::PutFileInput)
    pub fn builder() -> crate::input::put_file_input::Builder {
        crate::input::put_file_input::Builder::default()
    }
    /// Creates a new `PutFile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFile {
    type Output = std::result::Result<crate::output::PutFileOutput, crate::error::PutFileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_file_error(response)
        } else {
            crate::operation_deser::parse_put_file_response(response)
        }
    }
}

/// Operation shape for `PutRepositoryTriggers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_repository_triggers`](crate::client::Client::put_repository_triggers).
///
/// See [`crate::client::fluent_builders::PutRepositoryTriggers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRepositoryTriggers {
    _private: (),
}
impl PutRepositoryTriggers {
    /// Creates a new builder-style object to manufacture [`PutRepositoryTriggersInput`](crate::input::PutRepositoryTriggersInput)
    pub fn builder() -> crate::input::put_repository_triggers_input::Builder {
        crate::input::put_repository_triggers_input::Builder::default()
    }
    /// Creates a new `PutRepositoryTriggers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRepositoryTriggers {
    type Output = std::result::Result<
        crate::output::PutRepositoryTriggersOutput,
        crate::error::PutRepositoryTriggersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_repository_triggers_error(response)
        } else {
            crate::operation_deser::parse_put_repository_triggers_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestRepositoryTriggers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_repository_triggers`](crate::client::Client::test_repository_triggers).
///
/// See [`crate::client::fluent_builders::TestRepositoryTriggers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestRepositoryTriggers {
    _private: (),
}
impl TestRepositoryTriggers {
    /// Creates a new builder-style object to manufacture [`TestRepositoryTriggersInput`](crate::input::TestRepositoryTriggersInput)
    pub fn builder() -> crate::input::test_repository_triggers_input::Builder {
        crate::input::test_repository_triggers_input::Builder::default()
    }
    /// Creates a new `TestRepositoryTriggers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestRepositoryTriggers {
    type Output = std::result::Result<
        crate::output::TestRepositoryTriggersOutput,
        crate::error::TestRepositoryTriggersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_repository_triggers_error(response)
        } else {
            crate::operation_deser::parse_test_repository_triggers_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApprovalRuleTemplateContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_approval_rule_template_content`](crate::client::Client::update_approval_rule_template_content).
///
/// See [`crate::client::fluent_builders::UpdateApprovalRuleTemplateContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApprovalRuleTemplateContent {
    _private: (),
}
impl UpdateApprovalRuleTemplateContent {
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateContentInput`](crate::input::UpdateApprovalRuleTemplateContentInput)
    pub fn builder() -> crate::input::update_approval_rule_template_content_input::Builder {
        crate::input::update_approval_rule_template_content_input::Builder::default()
    }
    /// Creates a new `UpdateApprovalRuleTemplateContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApprovalRuleTemplateContent {
    type Output = std::result::Result<
        crate::output::UpdateApprovalRuleTemplateContentOutput,
        crate::error::UpdateApprovalRuleTemplateContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_approval_rule_template_content_error(response)
        } else {
            crate::operation_deser::parse_update_approval_rule_template_content_response(response)
        }
    }
}

/// Operation shape for `UpdateApprovalRuleTemplateDescription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_approval_rule_template_description`](crate::client::Client::update_approval_rule_template_description).
///
/// See [`crate::client::fluent_builders::UpdateApprovalRuleTemplateDescription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApprovalRuleTemplateDescription {
    _private: (),
}
impl UpdateApprovalRuleTemplateDescription {
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateDescriptionInput`](crate::input::UpdateApprovalRuleTemplateDescriptionInput)
    pub fn builder() -> crate::input::update_approval_rule_template_description_input::Builder {
        crate::input::update_approval_rule_template_description_input::Builder::default()
    }
    /// Creates a new `UpdateApprovalRuleTemplateDescription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApprovalRuleTemplateDescription {
    type Output = std::result::Result<
        crate::output::UpdateApprovalRuleTemplateDescriptionOutput,
        crate::error::UpdateApprovalRuleTemplateDescriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_approval_rule_template_description_error(response)
        } else {
            crate::operation_deser::parse_update_approval_rule_template_description_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateApprovalRuleTemplateName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_approval_rule_template_name`](crate::client::Client::update_approval_rule_template_name).
///
/// See [`crate::client::fluent_builders::UpdateApprovalRuleTemplateName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApprovalRuleTemplateName {
    _private: (),
}
impl UpdateApprovalRuleTemplateName {
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateNameInput`](crate::input::UpdateApprovalRuleTemplateNameInput)
    pub fn builder() -> crate::input::update_approval_rule_template_name_input::Builder {
        crate::input::update_approval_rule_template_name_input::Builder::default()
    }
    /// Creates a new `UpdateApprovalRuleTemplateName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApprovalRuleTemplateName {
    type Output = std::result::Result<
        crate::output::UpdateApprovalRuleTemplateNameOutput,
        crate::error::UpdateApprovalRuleTemplateNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_approval_rule_template_name_error(response)
        } else {
            crate::operation_deser::parse_update_approval_rule_template_name_response(response)
        }
    }
}

/// Operation shape for `UpdateComment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_comment`](crate::client::Client::update_comment).
///
/// See [`crate::client::fluent_builders::UpdateComment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateComment {
    _private: (),
}
impl UpdateComment {
    /// Creates a new builder-style object to manufacture [`UpdateCommentInput`](crate::input::UpdateCommentInput)
    pub fn builder() -> crate::input::update_comment_input::Builder {
        crate::input::update_comment_input::Builder::default()
    }
    /// Creates a new `UpdateComment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateComment {
    type Output =
        std::result::Result<crate::output::UpdateCommentOutput, crate::error::UpdateCommentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_comment_error(response)
        } else {
            crate::operation_deser::parse_update_comment_response(response)
        }
    }
}

/// Operation shape for `UpdateDefaultBranch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_default_branch`](crate::client::Client::update_default_branch).
///
/// See [`crate::client::fluent_builders::UpdateDefaultBranch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDefaultBranch {
    _private: (),
}
impl UpdateDefaultBranch {
    /// Creates a new builder-style object to manufacture [`UpdateDefaultBranchInput`](crate::input::UpdateDefaultBranchInput)
    pub fn builder() -> crate::input::update_default_branch_input::Builder {
        crate::input::update_default_branch_input::Builder::default()
    }
    /// Creates a new `UpdateDefaultBranch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDefaultBranch {
    type Output = std::result::Result<
        crate::output::UpdateDefaultBranchOutput,
        crate::error::UpdateDefaultBranchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_default_branch_error(response)
        } else {
            crate::operation_deser::parse_update_default_branch_response(response)
        }
    }
}

/// Operation shape for `UpdatePullRequestApprovalRuleContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pull_request_approval_rule_content`](crate::client::Client::update_pull_request_approval_rule_content).
///
/// See [`crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePullRequestApprovalRuleContent {
    _private: (),
}
impl UpdatePullRequestApprovalRuleContent {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestApprovalRuleContentInput`](crate::input::UpdatePullRequestApprovalRuleContentInput)
    pub fn builder() -> crate::input::update_pull_request_approval_rule_content_input::Builder {
        crate::input::update_pull_request_approval_rule_content_input::Builder::default()
    }
    /// Creates a new `UpdatePullRequestApprovalRuleContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePullRequestApprovalRuleContent {
    type Output = std::result::Result<
        crate::output::UpdatePullRequestApprovalRuleContentOutput,
        crate::error::UpdatePullRequestApprovalRuleContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pull_request_approval_rule_content_error(response)
        } else {
            crate::operation_deser::parse_update_pull_request_approval_rule_content_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdatePullRequestApprovalState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pull_request_approval_state`](crate::client::Client::update_pull_request_approval_state).
///
/// See [`crate::client::fluent_builders::UpdatePullRequestApprovalState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePullRequestApprovalState {
    _private: (),
}
impl UpdatePullRequestApprovalState {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestApprovalStateInput`](crate::input::UpdatePullRequestApprovalStateInput)
    pub fn builder() -> crate::input::update_pull_request_approval_state_input::Builder {
        crate::input::update_pull_request_approval_state_input::Builder::default()
    }
    /// Creates a new `UpdatePullRequestApprovalState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePullRequestApprovalState {
    type Output = std::result::Result<
        crate::output::UpdatePullRequestApprovalStateOutput,
        crate::error::UpdatePullRequestApprovalStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pull_request_approval_state_error(response)
        } else {
            crate::operation_deser::parse_update_pull_request_approval_state_response(response)
        }
    }
}

/// Operation shape for `UpdatePullRequestDescription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pull_request_description`](crate::client::Client::update_pull_request_description).
///
/// See [`crate::client::fluent_builders::UpdatePullRequestDescription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePullRequestDescription {
    _private: (),
}
impl UpdatePullRequestDescription {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestDescriptionInput`](crate::input::UpdatePullRequestDescriptionInput)
    pub fn builder() -> crate::input::update_pull_request_description_input::Builder {
        crate::input::update_pull_request_description_input::Builder::default()
    }
    /// Creates a new `UpdatePullRequestDescription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePullRequestDescription {
    type Output = std::result::Result<
        crate::output::UpdatePullRequestDescriptionOutput,
        crate::error::UpdatePullRequestDescriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pull_request_description_error(response)
        } else {
            crate::operation_deser::parse_update_pull_request_description_response(response)
        }
    }
}

/// Operation shape for `UpdatePullRequestStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pull_request_status`](crate::client::Client::update_pull_request_status).
///
/// See [`crate::client::fluent_builders::UpdatePullRequestStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePullRequestStatus {
    _private: (),
}
impl UpdatePullRequestStatus {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestStatusInput`](crate::input::UpdatePullRequestStatusInput)
    pub fn builder() -> crate::input::update_pull_request_status_input::Builder {
        crate::input::update_pull_request_status_input::Builder::default()
    }
    /// Creates a new `UpdatePullRequestStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePullRequestStatus {
    type Output = std::result::Result<
        crate::output::UpdatePullRequestStatusOutput,
        crate::error::UpdatePullRequestStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pull_request_status_error(response)
        } else {
            crate::operation_deser::parse_update_pull_request_status_response(response)
        }
    }
}

/// Operation shape for `UpdatePullRequestTitle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pull_request_title`](crate::client::Client::update_pull_request_title).
///
/// See [`crate::client::fluent_builders::UpdatePullRequestTitle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePullRequestTitle {
    _private: (),
}
impl UpdatePullRequestTitle {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestTitleInput`](crate::input::UpdatePullRequestTitleInput)
    pub fn builder() -> crate::input::update_pull_request_title_input::Builder {
        crate::input::update_pull_request_title_input::Builder::default()
    }
    /// Creates a new `UpdatePullRequestTitle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePullRequestTitle {
    type Output = std::result::Result<
        crate::output::UpdatePullRequestTitleOutput,
        crate::error::UpdatePullRequestTitleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pull_request_title_error(response)
        } else {
            crate::operation_deser::parse_update_pull_request_title_response(response)
        }
    }
}

/// Operation shape for `UpdateRepositoryDescription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_repository_description`](crate::client::Client::update_repository_description).
///
/// See [`crate::client::fluent_builders::UpdateRepositoryDescription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRepositoryDescription {
    _private: (),
}
impl UpdateRepositoryDescription {
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryDescriptionInput`](crate::input::UpdateRepositoryDescriptionInput)
    pub fn builder() -> crate::input::update_repository_description_input::Builder {
        crate::input::update_repository_description_input::Builder::default()
    }
    /// Creates a new `UpdateRepositoryDescription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRepositoryDescription {
    type Output = std::result::Result<
        crate::output::UpdateRepositoryDescriptionOutput,
        crate::error::UpdateRepositoryDescriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_repository_description_error(response)
        } else {
            crate::operation_deser::parse_update_repository_description_response(response)
        }
    }
}

/// Operation shape for `UpdateRepositoryName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_repository_name`](crate::client::Client::update_repository_name).
///
/// See [`crate::client::fluent_builders::UpdateRepositoryName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRepositoryName {
    _private: (),
}
impl UpdateRepositoryName {
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryNameInput`](crate::input::UpdateRepositoryNameInput)
    pub fn builder() -> crate::input::update_repository_name_input::Builder {
        crate::input::update_repository_name_input::Builder::default()
    }
    /// Creates a new `UpdateRepositoryName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRepositoryName {
    type Output = std::result::Result<
        crate::output::UpdateRepositoryNameOutput,
        crate::error::UpdateRepositoryNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_repository_name_error(response)
        } else {
            crate::operation_deser::parse_update_repository_name_response(response)
        }
    }
}
